; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=aarch64 | FileCheck %s --check-prefixes=CHECK,CHECK-SD
; RUN: llc < %s -mtriple=aarch64 -global-isel | FileCheck %s --check-prefixes=CHECK,CHECK-GI

define i1 @and(i32 %x, i32 %y, i32 %z, i32 %w) {
; CHECK-SD-LABEL: and:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmp w0, w1
; CHECK-SD-NEXT:    ccmp w2, w3, #4, eq
; CHECK-SD-NEXT:    cset w0, gt
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: and:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    cmp w0, w1
; CHECK-GI-NEXT:    cset w8, eq
; CHECK-GI-NEXT:    cmp w2, w3
; CHECK-GI-NEXT:    cset w9, gt
; CHECK-GI-NEXT:    and w0, w8, w9
; CHECK-GI-NEXT:    ret
  %a = icmp eq i32 %x, %y
  %b = icmp sgt i32 %z, %w
  %s = select i1 %a, i1 %b, i1 false
  ret i1 %s
}

define i1 @or(i32 %x, i32 %y, i32 %z, i32 %w) {
; CHECK-SD-LABEL: or:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmp w0, w1
; CHECK-SD-NEXT:    ccmp w2, w3, #0, ne
; CHECK-SD-NEXT:    cset w0, gt
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: or:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    cmp w0, w1
; CHECK-GI-NEXT:    cset w8, eq
; CHECK-GI-NEXT:    cmp w2, w3
; CHECK-GI-NEXT:    cset w9, gt
; CHECK-GI-NEXT:    orr w8, w8, w9
; CHECK-GI-NEXT:    and w0, w8, #0x1
; CHECK-GI-NEXT:    ret
  %a = icmp eq i32 %x, %y
  %b = icmp sgt i32 %z, %w
  %s = select i1 %a, i1 true, i1 %b
  ret i1 %s
}

define i1 @and_not(i32 %x, i32 %y, i32 %z, i32 %w) {
; CHECK-SD-LABEL: and_not:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmp w0, w1
; CHECK-SD-NEXT:    ccmp w2, w3, #4, ne
; CHECK-SD-NEXT:    cset w0, gt
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: and_not:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    cmp w0, w1
; CHECK-GI-NEXT:    cset w8, ne
; CHECK-GI-NEXT:    cmp w2, w3
; CHECK-GI-NEXT:    cset w9, gt
; CHECK-GI-NEXT:    and w0, w8, w9
; CHECK-GI-NEXT:    ret
  %a = icmp eq i32 %x, %y
  %b = icmp sgt i32 %z, %w
  %s = select i1 %a, i1 false, i1 %b
  ret i1 %s
}

define i1 @or_not(i32 %x, i32 %y, i32 %z, i32 %w) {
; CHECK-SD-LABEL: or_not:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmp w0, w1
; CHECK-SD-NEXT:    ccmp w2, w3, #0, eq
; CHECK-SD-NEXT:    cset w0, gt
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: or_not:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    cmp w0, w1
; CHECK-GI-NEXT:    cset w8, ne
; CHECK-GI-NEXT:    cmp w2, w3
; CHECK-GI-NEXT:    cset w9, gt
; CHECK-GI-NEXT:    orr w8, w8, w9
; CHECK-GI-NEXT:    and w0, w8, #0x1
; CHECK-GI-NEXT:    ret
  %a = icmp eq i32 %x, %y
  %b = icmp sgt i32 %z, %w
  %s = select i1 %a, i1 %b, i1 true
  ret i1 %s
}

define <4 x i1> @and_vec(<4 x i32> %x, <4 x i32> %y, <4 x i32> %z, <4 x i32> %w) {
; CHECK-SD-LABEL: and_vec:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmgt v2.4s, v2.4s, v3.4s
; CHECK-SD-NEXT:    cmeq v0.4s, v0.4s, v1.4s
; CHECK-SD-NEXT:    and v0.16b, v0.16b, v2.16b
; CHECK-SD-NEXT:    xtn v0.4h, v0.4s
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: and_vec:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    cmeq v0.4s, v0.4s, v1.4s
; CHECK-GI-NEXT:    cmgt v1.4s, v2.4s, v3.4s
; CHECK-GI-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    xtn v0.4h, v0.4s
; CHECK-GI-NEXT:    ret
  %a = icmp eq <4 x i32> %x, %y
  %b = icmp sgt <4 x i32> %z, %w
  %s = select <4 x i1> %a, <4 x i1> %b, <4 x i1> zeroinitializer
  ret <4 x i1> %s
}

define <4 x i1> @or_vec(<4 x i32> %x, <4 x i32> %y, <4 x i32> %z, <4 x i32> %w) {
; CHECK-SD-LABEL: or_vec:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmgt v2.4s, v2.4s, v3.4s
; CHECK-SD-NEXT:    cmeq v0.4s, v0.4s, v1.4s
; CHECK-SD-NEXT:    orr v0.16b, v0.16b, v2.16b
; CHECK-SD-NEXT:    xtn v0.4h, v0.4s
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: or_vec:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    cmeq v0.4s, v0.4s, v1.4s
; CHECK-GI-NEXT:    cmgt v1.4s, v2.4s, v3.4s
; CHECK-GI-NEXT:    orr v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    xtn v0.4h, v0.4s
; CHECK-GI-NEXT:    ret
  %a = icmp eq <4 x i32> %x, %y
  %b = icmp sgt <4 x i32> %z, %w
  %s = select <4 x i1> %a, <4 x i1> <i1 1, i1 1, i1 1, i1 1>, <4 x i1> %b
  ret <4 x i1> %s
}

define <4 x i1> @and_not_vec(<4 x i32> %x, <4 x i32> %y, <4 x i32> %z, <4 x i32> %w) {
; CHECK-SD-LABEL: and_not_vec:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmgt v2.4s, v2.4s, v3.4s
; CHECK-SD-NEXT:    cmeq v0.4s, v0.4s, v1.4s
; CHECK-SD-NEXT:    bic v0.16b, v2.16b, v0.16b
; CHECK-SD-NEXT:    xtn v0.4h, v0.4s
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: and_not_vec:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    cmeq v0.4s, v0.4s, v1.4s
; CHECK-GI-NEXT:    cmgt v1.4s, v2.4s, v3.4s
; CHECK-GI-NEXT:    bic v0.16b, v1.16b, v0.16b
; CHECK-GI-NEXT:    xtn v0.4h, v0.4s
; CHECK-GI-NEXT:    ret
  %a = icmp eq <4 x i32> %x, %y
  %b = icmp sgt <4 x i32> %z, %w
  %s = select <4 x i1> %a, <4 x i1> zeroinitializer, <4 x i1> %b
  ret <4 x i1> %s
}

define <4 x i1> @or_not_vec(<4 x i32> %x, <4 x i32> %y, <4 x i32> %z, <4 x i32> %w) {
; CHECK-SD-LABEL: or_not_vec:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmgt v2.4s, v2.4s, v3.4s
; CHECK-SD-NEXT:    cmeq v0.4s, v0.4s, v1.4s
; CHECK-SD-NEXT:    orn v0.16b, v2.16b, v0.16b
; CHECK-SD-NEXT:    xtn v0.4h, v0.4s
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: or_not_vec:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    cmeq v0.4s, v0.4s, v1.4s
; CHECK-GI-NEXT:    cmgt v1.4s, v2.4s, v3.4s
; CHECK-GI-NEXT:    orn v0.16b, v1.16b, v0.16b
; CHECK-GI-NEXT:    xtn v0.4h, v0.4s
; CHECK-GI-NEXT:    ret
  %a = icmp eq <4 x i32> %x, %y
  %b = icmp sgt <4 x i32> %z, %w
  %s = select <4 x i1> %a, <4 x i1> %b, <4 x i1> <i1 1, i1 1, i1 1, i1 1>
  ret <4 x i1> %s
}

define <4 x i1> @and_vec_undef(<4 x i32> %x, <4 x i32> %y, <4 x i32> %z, <4 x i32> %w) {
; CHECK-SD-LABEL: and_vec_undef:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmgt v2.4s, v2.4s, v3.4s
; CHECK-SD-NEXT:    cmeq v0.4s, v0.4s, v1.4s
; CHECK-SD-NEXT:    and v0.16b, v0.16b, v2.16b
; CHECK-SD-NEXT:    xtn v0.4h, v0.4s
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: and_vec_undef:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    cmeq v0.4s, v0.4s, v1.4s
; CHECK-GI-NEXT:    cmgt v1.4s, v2.4s, v3.4s
; CHECK-GI-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    xtn v0.4h, v0.4s
; CHECK-GI-NEXT:    ret
  %a = icmp eq <4 x i32> %x, %y
  %b = icmp sgt <4 x i32> %z, %w
  %s = select <4 x i1> %a, <4 x i1> %b, <4 x i1> <i1 0, i1 undef, i1 0, i1 undef>
  ret <4 x i1> %s
}

define <4 x i1> @or_vec_undef(<4 x i32> %x, <4 x i32> %y, <4 x i32> %z, <4 x i32> %w) {
; CHECK-SD-LABEL: or_vec_undef:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmgt v2.4s, v2.4s, v3.4s
; CHECK-SD-NEXT:    cmeq v0.4s, v0.4s, v1.4s
; CHECK-SD-NEXT:    orr v0.16b, v0.16b, v2.16b
; CHECK-SD-NEXT:    xtn v0.4h, v0.4s
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: or_vec_undef:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    cmeq v0.4s, v0.4s, v1.4s
; CHECK-GI-NEXT:    cmgt v1.4s, v2.4s, v3.4s
; CHECK-GI-NEXT:    orr v0.16b, v0.16b, v1.16b
; CHECK-GI-NEXT:    xtn v0.4h, v0.4s
; CHECK-GI-NEXT:    ret
  %a = icmp eq <4 x i32> %x, %y
  %b = icmp sgt <4 x i32> %z, %w
  %s = select <4 x i1> %a, <4 x i1> <i1 undef, i1 1, i1 1, i1 undef>, <4 x i1> %b
  ret <4 x i1> %s
}

define <4 x i1> @and_not_vec_undef(<4 x i32> %x, <4 x i32> %y, <4 x i32> %z, <4 x i32> %w) {
; CHECK-SD-LABEL: and_not_vec_undef:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmgt v2.4s, v2.4s, v3.4s
; CHECK-SD-NEXT:    cmeq v0.4s, v0.4s, v1.4s
; CHECK-SD-NEXT:    bic v0.16b, v2.16b, v0.16b
; CHECK-SD-NEXT:    xtn v0.4h, v0.4s
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: and_not_vec_undef:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    cmeq v0.4s, v0.4s, v1.4s
; CHECK-GI-NEXT:    cmgt v1.4s, v2.4s, v3.4s
; CHECK-GI-NEXT:    bic v0.16b, v1.16b, v0.16b
; CHECK-GI-NEXT:    xtn v0.4h, v0.4s
; CHECK-GI-NEXT:    ret
  %a = icmp eq <4 x i32> %x, %y
  %b = icmp sgt <4 x i32> %z, %w
  %s = select <4 x i1> %a, <4 x i1> <i1 0, i1 0, i1 undef, i1 0>, <4 x i1> %b
  ret <4 x i1> %s
}

define <4 x i1> @or_not_vec_undef(<4 x i32> %x, <4 x i32> %y, <4 x i32> %z, <4 x i32> %w) {
; CHECK-SD-LABEL: or_not_vec_undef:
; CHECK-SD:       // %bb.0:
; CHECK-SD-NEXT:    cmgt v2.4s, v2.4s, v3.4s
; CHECK-SD-NEXT:    cmeq v0.4s, v0.4s, v1.4s
; CHECK-SD-NEXT:    orn v0.16b, v2.16b, v0.16b
; CHECK-SD-NEXT:    xtn v0.4h, v0.4s
; CHECK-SD-NEXT:    ret
;
; CHECK-GI-LABEL: or_not_vec_undef:
; CHECK-GI:       // %bb.0:
; CHECK-GI-NEXT:    cmeq v0.4s, v0.4s, v1.4s
; CHECK-GI-NEXT:    cmgt v1.4s, v2.4s, v3.4s
; CHECK-GI-NEXT:    orn v0.16b, v1.16b, v0.16b
; CHECK-GI-NEXT:    xtn v0.4h, v0.4s
; CHECK-GI-NEXT:    ret
  %a = icmp eq <4 x i32> %x, %y
  %b = icmp sgt <4 x i32> %z, %w
  %s = select <4 x i1> %a, <4 x i1> %b, <4 x i1> <i1 1, i1 undef, i1 1, i1 1>
  ret <4 x i1> %s
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; CHECK: {{.*}}
