; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-- | FileCheck %s --check-prefixes=SSE2
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-- -mattr=+ssse3 | FileCheck %s --check-prefixes=SSSE3
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-- -mattr=+sse4.2 | FileCheck %s --check-prefixes=SSE42
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-- -mattr=+avx | FileCheck %s --check-prefixes=AVX1
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-- -mattr=+avx2 | FileCheck %s --check-prefixes=AVX2
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-- -mattr=+avx512f | FileCheck %s --check-prefixes=AVX512F
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-- -mattr=+avx512f,+avx512bw | FileCheck %s --check-prefixes=AVX512BW
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-- -mattr=+avx512f,+avx512dq | FileCheck %s --check-prefixes=AVX512DQ
;
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-- -mcpu=slm | FileCheck %s --check-prefixes=SLM
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-- -mcpu=goldmont | FileCheck %s --check-prefixes=GLM
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=all -mtriple=x86_64-- -mcpu=btver2 | FileCheck %s --check-prefixes=BTVER2

declare i64        @llvm.uadd.sat.i64(i64, i64)
declare <2 x i64>  @llvm.uadd.sat.v2i64(<2 x i64>, <2 x i64>)
declare <4 x i64>  @llvm.uadd.sat.v4i64(<4 x i64>, <4 x i64>)
declare <8 x i64>  @llvm.uadd.sat.v8i64(<8 x i64>, <8 x i64>)

declare i32        @llvm.uadd.sat.i32(i32, i32)
declare <4 x i32>  @llvm.uadd.sat.v4i32(<4 x i32>, <4 x i32>)
declare <8 x i32>  @llvm.uadd.sat.v8i32(<8 x i32>, <8 x i32>)
declare <16 x i32> @llvm.uadd.sat.v16i32(<16 x i32>, <16 x i32>)

declare i16        @llvm.uadd.sat.i16(i16, i16)
declare <8 x i16>  @llvm.uadd.sat.v8i16(<8 x i16>, <8 x i16>)
declare <16 x i16> @llvm.uadd.sat.v16i16(<16 x i16>, <16 x i16>)
declare <32 x i16> @llvm.uadd.sat.v32i16(<32 x i16>, <32 x i16>)

declare i8         @llvm.uadd.sat.i8(i8,  i8)
declare <16 x i8>  @llvm.uadd.sat.v16i8(<16 x i8>, <16 x i8>)
declare <32 x i8>  @llvm.uadd.sat.v32i8(<32 x i8>, <32 x i8>)
declare <64 x i8>  @llvm.uadd.sat.v64i8(<64 x i8>, <64 x i8>)

define i32 @add(i32 %arg) {
; SSE2-LABEL: 'add'
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I64 = call i64 @llvm.uadd.sat.i64(i64 undef, i64 undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:14 Lat:13 SizeLat:14 for: %V2I64 = call <2 x i64> @llvm.uadd.sat.v2i64(<2 x i64> undef, <2 x i64> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:28 Lat:26 SizeLat:28 for: %V4I64 = call <4 x i64> @llvm.uadd.sat.v4i64(<4 x i64> undef, <4 x i64> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:56 Lat:52 SizeLat:56 for: %V8I64 = call <8 x i64> @llvm.uadd.sat.v8i64(<8 x i64> undef, <8 x i64> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I32 = call i32 @llvm.uadd.sat.i32(i32 undef, i32 undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:7 Lat:5 SizeLat:7 for: %V4I32 = call <4 x i32> @llvm.uadd.sat.v4i32(<4 x i32> undef, <4 x i32> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:14 Lat:10 SizeLat:14 for: %V8I32 = call <8 x i32> @llvm.uadd.sat.v8i32(<8 x i32> undef, <8 x i32> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:28 Lat:20 SizeLat:28 for: %V16I32 = call <16 x i32> @llvm.uadd.sat.v16i32(<16 x i32> undef, <16 x i32> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I16 = call i16 @llvm.uadd.sat.i16(i16 undef, i16 undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V8I16 = call <8 x i16> @llvm.uadd.sat.v8i16(<8 x i16> undef, <8 x i16> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:2 for: %V16I16 = call <16 x i16> @llvm.uadd.sat.v16i16(<16 x i16> undef, <16 x i16> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:4 for: %V32I16 = call <32 x i16> @llvm.uadd.sat.v32i16(<32 x i16> undef, <32 x i16> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:3 SizeLat:8 for: %I8 = call i8 @llvm.uadd.sat.i8(i8 undef, i8 undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V16I8 = call <16 x i8> @llvm.uadd.sat.v16i8(<16 x i8> undef, <16 x i8> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:2 for: %V32I8 = call <32 x i8> @llvm.uadd.sat.v32i8(<32 x i8> undef, <32 x i8> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:4 for: %V64I8 = call <64 x i8> @llvm.uadd.sat.v64i8(<64 x i8> undef, <64 x i8> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSSE3-LABEL: 'add'
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I64 = call i64 @llvm.uadd.sat.i64(i64 undef, i64 undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:14 Lat:13 SizeLat:14 for: %V2I64 = call <2 x i64> @llvm.uadd.sat.v2i64(<2 x i64> undef, <2 x i64> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:28 Lat:26 SizeLat:28 for: %V4I64 = call <4 x i64> @llvm.uadd.sat.v4i64(<4 x i64> undef, <4 x i64> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:56 Lat:52 SizeLat:56 for: %V8I64 = call <8 x i64> @llvm.uadd.sat.v8i64(<8 x i64> undef, <8 x i64> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I32 = call i32 @llvm.uadd.sat.i32(i32 undef, i32 undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:7 Lat:5 SizeLat:7 for: %V4I32 = call <4 x i32> @llvm.uadd.sat.v4i32(<4 x i32> undef, <4 x i32> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:14 Lat:10 SizeLat:14 for: %V8I32 = call <8 x i32> @llvm.uadd.sat.v8i32(<8 x i32> undef, <8 x i32> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:28 Lat:20 SizeLat:28 for: %V16I32 = call <16 x i32> @llvm.uadd.sat.v16i32(<16 x i32> undef, <16 x i32> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I16 = call i16 @llvm.uadd.sat.i16(i16 undef, i16 undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V8I16 = call <8 x i16> @llvm.uadd.sat.v8i16(<8 x i16> undef, <8 x i16> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:2 for: %V16I16 = call <16 x i16> @llvm.uadd.sat.v16i16(<16 x i16> undef, <16 x i16> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:4 for: %V32I16 = call <32 x i16> @llvm.uadd.sat.v32i16(<32 x i16> undef, <32 x i16> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:3 SizeLat:8 for: %I8 = call i8 @llvm.uadd.sat.i8(i8 undef, i8 undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V16I8 = call <16 x i8> @llvm.uadd.sat.v16i8(<16 x i8> undef, <16 x i8> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:2 for: %V32I8 = call <32 x i8> @llvm.uadd.sat.v32i8(<32 x i8> undef, <32 x i8> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:4 for: %V64I8 = call <64 x i8> @llvm.uadd.sat.v64i8(<64 x i8> undef, <64 x i8> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE42-LABEL: 'add'
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I64 = call i64 @llvm.uadd.sat.i64(i64 undef, i64 undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:14 Lat:13 SizeLat:14 for: %V2I64 = call <2 x i64> @llvm.uadd.sat.v2i64(<2 x i64> undef, <2 x i64> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:28 Lat:26 SizeLat:28 for: %V4I64 = call <4 x i64> @llvm.uadd.sat.v4i64(<4 x i64> undef, <4 x i64> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:56 Lat:52 SizeLat:56 for: %V8I64 = call <8 x i64> @llvm.uadd.sat.v8i64(<8 x i64> undef, <8 x i64> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I32 = call i32 @llvm.uadd.sat.i32(i32 undef, i32 undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:2 SizeLat:4 for: %V4I32 = call <4 x i32> @llvm.uadd.sat.v4i32(<4 x i32> undef, <4 x i32> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:8 Lat:4 SizeLat:8 for: %V8I32 = call <8 x i32> @llvm.uadd.sat.v8i32(<8 x i32> undef, <8 x i32> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:16 Lat:8 SizeLat:16 for: %V16I32 = call <16 x i32> @llvm.uadd.sat.v16i32(<16 x i32> undef, <16 x i32> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I16 = call i16 @llvm.uadd.sat.i16(i16 undef, i16 undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V8I16 = call <8 x i16> @llvm.uadd.sat.v8i16(<8 x i16> undef, <8 x i16> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:2 for: %V16I16 = call <16 x i16> @llvm.uadd.sat.v16i16(<16 x i16> undef, <16 x i16> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:4 for: %V32I16 = call <32 x i16> @llvm.uadd.sat.v32i16(<32 x i16> undef, <32 x i16> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:3 SizeLat:8 for: %I8 = call i8 @llvm.uadd.sat.i8(i8 undef, i8 undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V16I8 = call <16 x i8> @llvm.uadd.sat.v16i8(<16 x i8> undef, <16 x i8> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:2 for: %V32I8 = call <32 x i8> @llvm.uadd.sat.v32i8(<32 x i8> undef, <32 x i8> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:4 for: %V64I8 = call <64 x i8> @llvm.uadd.sat.v64i8(<64 x i8> undef, <64 x i8> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'add'
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I64 = call i64 @llvm.uadd.sat.i64(i64 undef, i64 undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:6 Lat:8 SizeLat:6 for: %V2I64 = call <2 x i64> @llvm.uadd.sat.v2i64(<2 x i64> undef, <2 x i64> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:14 Lat:11 SizeLat:15 for: %V4I64 = call <4 x i64> @llvm.uadd.sat.v4i64(<4 x i64> undef, <4 x i64> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:28 Lat:22 SizeLat:30 for: %V8I64 = call <8 x i64> @llvm.uadd.sat.v8i64(<8 x i64> undef, <8 x i64> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I32 = call i32 @llvm.uadd.sat.i32(i32 undef, i32 undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:2 SizeLat:4 for: %V4I32 = call <4 x i32> @llvm.uadd.sat.v4i32(<4 x i32> undef, <4 x i32> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:10 Lat:6 SizeLat:11 for: %V8I32 = call <8 x i32> @llvm.uadd.sat.v8i32(<8 x i32> undef, <8 x i32> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:20 Lat:12 SizeLat:22 for: %V16I32 = call <16 x i32> @llvm.uadd.sat.v16i32(<16 x i32> undef, <16 x i32> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I16 = call i16 @llvm.uadd.sat.i16(i16 undef, i16 undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V8I16 = call <8 x i16> @llvm.uadd.sat.v8i16(<8 x i16> undef, <8 x i16> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:3 SizeLat:6 for: %V16I16 = call <16 x i16> @llvm.uadd.sat.v16i16(<16 x i16> undef, <16 x i16> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:10 Lat:6 SizeLat:12 for: %V32I16 = call <32 x i16> @llvm.uadd.sat.v32i16(<32 x i16> undef, <32 x i16> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:3 SizeLat:8 for: %I8 = call i8 @llvm.uadd.sat.i8(i8 undef, i8 undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V16I8 = call <16 x i8> @llvm.uadd.sat.v16i8(<16 x i8> undef, <16 x i8> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:3 SizeLat:6 for: %V32I8 = call <32 x i8> @llvm.uadd.sat.v32i8(<32 x i8> undef, <32 x i8> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:10 Lat:6 SizeLat:12 for: %V64I8 = call <64 x i8> @llvm.uadd.sat.v64i8(<64 x i8> undef, <64 x i8> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'add'
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I64 = call i64 @llvm.uadd.sat.i64(i64 undef, i64 undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:6 Lat:8 SizeLat:6 for: %V2I64 = call <2 x i64> @llvm.uadd.sat.v2i64(<2 x i64> undef, <2 x i64> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:6 Lat:8 SizeLat:10 for: %V4I64 = call <4 x i64> @llvm.uadd.sat.v4i64(<4 x i64> undef, <4 x i64> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:12 Lat:16 SizeLat:20 for: %V8I64 = call <8 x i64> @llvm.uadd.sat.v8i64(<8 x i64> undef, <8 x i64> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I32 = call i32 @llvm.uadd.sat.i32(i32 undef, i32 undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:2 SizeLat:4 for: %V4I32 = call <4 x i32> @llvm.uadd.sat.v4i32(<4 x i32> undef, <4 x i32> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:2 SizeLat:8 for: %V8I32 = call <8 x i32> @llvm.uadd.sat.v8i32(<8 x i32> undef, <8 x i32> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:8 Lat:4 SizeLat:16 for: %V16I32 = call <16 x i32> @llvm.uadd.sat.v16i32(<16 x i32> undef, <16 x i32> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I16 = call i16 @llvm.uadd.sat.i16(i16 undef, i16 undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V8I16 = call <8 x i16> @llvm.uadd.sat.v8i16(<8 x i16> undef, <8 x i16> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V16I16 = call <16 x i16> @llvm.uadd.sat.v16i16(<16 x i16> undef, <16 x i16> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V32I16 = call <32 x i16> @llvm.uadd.sat.v32i16(<32 x i16> undef, <32 x i16> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:3 SizeLat:8 for: %I8 = call i8 @llvm.uadd.sat.i8(i8 undef, i8 undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V16I8 = call <16 x i8> @llvm.uadd.sat.v16i8(<16 x i8> undef, <16 x i8> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I8 = call <32 x i8> @llvm.uadd.sat.v32i8(<32 x i8> undef, <32 x i8> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V64I8 = call <64 x i8> @llvm.uadd.sat.v64i8(<64 x i8> undef, <64 x i8> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512F-LABEL: 'add'
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I64 = call i64 @llvm.uadd.sat.i64(i64 undef, i64 undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:4 Lat:4 SizeLat:4 for: %V2I64 = call <2 x i64> @llvm.uadd.sat.v2i64(<2 x i64> undef, <2 x i64> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:4 Lat:4 SizeLat:4 for: %V4I64 = call <4 x i64> @llvm.uadd.sat.v4i64(<4 x i64> undef, <4 x i64> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:4 Lat:4 SizeLat:4 for: %V8I64 = call <8 x i64> @llvm.uadd.sat.v8i64(<8 x i64> undef, <8 x i64> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I32 = call i32 @llvm.uadd.sat.i32(i32 undef, i32 undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:4 Lat:2 SizeLat:4 for: %V4I32 = call <4 x i32> @llvm.uadd.sat.v4i32(<4 x i32> undef, <4 x i32> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:4 Lat:2 SizeLat:4 for: %V8I32 = call <8 x i32> @llvm.uadd.sat.v8i32(<8 x i32> undef, <8 x i32> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:2 SizeLat:4 for: %V16I32 = call <16 x i32> @llvm.uadd.sat.v16i32(<16 x i32> undef, <16 x i32> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I16 = call i16 @llvm.uadd.sat.i16(i16 undef, i16 undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V8I16 = call <8 x i16> @llvm.uadd.sat.v8i16(<8 x i16> undef, <8 x i16> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V16I16 = call <16 x i16> @llvm.uadd.sat.v16i16(<16 x i16> undef, <16 x i16> undef)
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V32I16 = call <32 x i16> @llvm.uadd.sat.v32i16(<32 x i16> undef, <32 x i16> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:3 SizeLat:8 for: %I8 = call i8 @llvm.uadd.sat.i8(i8 undef, i8 undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V16I8 = call <16 x i8> @llvm.uadd.sat.v16i8(<16 x i8> undef, <16 x i8> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I8 = call <32 x i8> @llvm.uadd.sat.v32i8(<32 x i8> undef, <32 x i8> undef)
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V64I8 = call <64 x i8> @llvm.uadd.sat.v64i8(<64 x i8> undef, <64 x i8> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512BW-LABEL: 'add'
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I64 = call i64 @llvm.uadd.sat.i64(i64 undef, i64 undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:4 Lat:4 SizeLat:4 for: %V2I64 = call <2 x i64> @llvm.uadd.sat.v2i64(<2 x i64> undef, <2 x i64> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:4 Lat:4 SizeLat:4 for: %V4I64 = call <4 x i64> @llvm.uadd.sat.v4i64(<4 x i64> undef, <4 x i64> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:4 Lat:4 SizeLat:4 for: %V8I64 = call <8 x i64> @llvm.uadd.sat.v8i64(<8 x i64> undef, <8 x i64> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I32 = call i32 @llvm.uadd.sat.i32(i32 undef, i32 undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:4 Lat:2 SizeLat:4 for: %V4I32 = call <4 x i32> @llvm.uadd.sat.v4i32(<4 x i32> undef, <4 x i32> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:4 Lat:2 SizeLat:4 for: %V8I32 = call <8 x i32> @llvm.uadd.sat.v8i32(<8 x i32> undef, <8 x i32> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:2 SizeLat:4 for: %V16I32 = call <16 x i32> @llvm.uadd.sat.v16i32(<16 x i32> undef, <16 x i32> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I16 = call i16 @llvm.uadd.sat.i16(i16 undef, i16 undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V8I16 = call <8 x i16> @llvm.uadd.sat.v8i16(<8 x i16> undef, <8 x i16> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V16I16 = call <16 x i16> @llvm.uadd.sat.v16i16(<16 x i16> undef, <16 x i16> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32I16 = call <32 x i16> @llvm.uadd.sat.v32i16(<32 x i16> undef, <32 x i16> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:3 SizeLat:8 for: %I8 = call i8 @llvm.uadd.sat.i8(i8 undef, i8 undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V16I8 = call <16 x i8> @llvm.uadd.sat.v16i8(<16 x i8> undef, <16 x i8> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I8 = call <32 x i8> @llvm.uadd.sat.v32i8(<32 x i8> undef, <32 x i8> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V64I8 = call <64 x i8> @llvm.uadd.sat.v64i8(<64 x i8> undef, <64 x i8> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512DQ-LABEL: 'add'
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I64 = call i64 @llvm.uadd.sat.i64(i64 undef, i64 undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:4 Lat:4 SizeLat:4 for: %V2I64 = call <2 x i64> @llvm.uadd.sat.v2i64(<2 x i64> undef, <2 x i64> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:4 Lat:4 SizeLat:4 for: %V4I64 = call <4 x i64> @llvm.uadd.sat.v4i64(<4 x i64> undef, <4 x i64> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:4 Lat:4 SizeLat:4 for: %V8I64 = call <8 x i64> @llvm.uadd.sat.v8i64(<8 x i64> undef, <8 x i64> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I32 = call i32 @llvm.uadd.sat.i32(i32 undef, i32 undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:4 Lat:2 SizeLat:4 for: %V4I32 = call <4 x i32> @llvm.uadd.sat.v4i32(<4 x i32> undef, <4 x i32> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:4 Lat:2 SizeLat:4 for: %V8I32 = call <8 x i32> @llvm.uadd.sat.v8i32(<8 x i32> undef, <8 x i32> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:2 SizeLat:4 for: %V16I32 = call <16 x i32> @llvm.uadd.sat.v16i32(<16 x i32> undef, <16 x i32> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I16 = call i16 @llvm.uadd.sat.i16(i16 undef, i16 undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V8I16 = call <8 x i16> @llvm.uadd.sat.v8i16(<8 x i16> undef, <8 x i16> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V16I16 = call <16 x i16> @llvm.uadd.sat.v16i16(<16 x i16> undef, <16 x i16> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of 2 for: %V32I16 = call <32 x i16> @llvm.uadd.sat.v32i16(<32 x i16> undef, <32 x i16> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:3 SizeLat:8 for: %I8 = call i8 @llvm.uadd.sat.i8(i8 undef, i8 undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V16I8 = call <16 x i8> @llvm.uadd.sat.v16i8(<16 x i8> undef, <16 x i8> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I8 = call <32 x i8> @llvm.uadd.sat.v32i8(<32 x i8> undef, <32 x i8> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of 2 for: %V64I8 = call <64 x i8> @llvm.uadd.sat.v64i8(<64 x i8> undef, <64 x i8> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SLM-LABEL: 'add'
; SLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I64 = call i64 @llvm.uadd.sat.i64(i64 undef, i64 undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:14 Lat:13 SizeLat:14 for: %V2I64 = call <2 x i64> @llvm.uadd.sat.v2i64(<2 x i64> undef, <2 x i64> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:28 Lat:26 SizeLat:28 for: %V4I64 = call <4 x i64> @llvm.uadd.sat.v4i64(<4 x i64> undef, <4 x i64> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:56 Lat:52 SizeLat:56 for: %V8I64 = call <8 x i64> @llvm.uadd.sat.v8i64(<8 x i64> undef, <8 x i64> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I32 = call i32 @llvm.uadd.sat.i32(i32 undef, i32 undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:2 SizeLat:4 for: %V4I32 = call <4 x i32> @llvm.uadd.sat.v4i32(<4 x i32> undef, <4 x i32> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:8 Lat:4 SizeLat:8 for: %V8I32 = call <8 x i32> @llvm.uadd.sat.v8i32(<8 x i32> undef, <8 x i32> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:16 Lat:8 SizeLat:16 for: %V16I32 = call <16 x i32> @llvm.uadd.sat.v16i32(<16 x i32> undef, <16 x i32> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I16 = call i16 @llvm.uadd.sat.i16(i16 undef, i16 undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V8I16 = call <8 x i16> @llvm.uadd.sat.v8i16(<8 x i16> undef, <8 x i16> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:2 for: %V16I16 = call <16 x i16> @llvm.uadd.sat.v16i16(<16 x i16> undef, <16 x i16> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:4 for: %V32I16 = call <32 x i16> @llvm.uadd.sat.v32i16(<32 x i16> undef, <32 x i16> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:3 SizeLat:8 for: %I8 = call i8 @llvm.uadd.sat.i8(i8 undef, i8 undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V16I8 = call <16 x i8> @llvm.uadd.sat.v16i8(<16 x i8> undef, <16 x i8> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:2 for: %V32I8 = call <32 x i8> @llvm.uadd.sat.v32i8(<32 x i8> undef, <32 x i8> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:4 for: %V64I8 = call <64 x i8> @llvm.uadd.sat.v64i8(<64 x i8> undef, <64 x i8> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; GLM-LABEL: 'add'
; GLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I64 = call i64 @llvm.uadd.sat.i64(i64 undef, i64 undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:14 Lat:13 SizeLat:14 for: %V2I64 = call <2 x i64> @llvm.uadd.sat.v2i64(<2 x i64> undef, <2 x i64> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:28 Lat:26 SizeLat:28 for: %V4I64 = call <4 x i64> @llvm.uadd.sat.v4i64(<4 x i64> undef, <4 x i64> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:56 Lat:52 SizeLat:56 for: %V8I64 = call <8 x i64> @llvm.uadd.sat.v8i64(<8 x i64> undef, <8 x i64> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I32 = call i32 @llvm.uadd.sat.i32(i32 undef, i32 undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:2 SizeLat:4 for: %V4I32 = call <4 x i32> @llvm.uadd.sat.v4i32(<4 x i32> undef, <4 x i32> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:8 Lat:4 SizeLat:8 for: %V8I32 = call <8 x i32> @llvm.uadd.sat.v8i32(<8 x i32> undef, <8 x i32> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:16 Lat:8 SizeLat:16 for: %V16I32 = call <16 x i32> @llvm.uadd.sat.v16i32(<16 x i32> undef, <16 x i32> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I16 = call i16 @llvm.uadd.sat.i16(i16 undef, i16 undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V8I16 = call <8 x i16> @llvm.uadd.sat.v8i16(<8 x i16> undef, <8 x i16> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:2 for: %V16I16 = call <16 x i16> @llvm.uadd.sat.v16i16(<16 x i16> undef, <16 x i16> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:4 for: %V32I16 = call <32 x i16> @llvm.uadd.sat.v32i16(<32 x i16> undef, <32 x i16> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:3 SizeLat:8 for: %I8 = call i8 @llvm.uadd.sat.i8(i8 undef, i8 undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V16I8 = call <16 x i8> @llvm.uadd.sat.v16i8(<16 x i8> undef, <16 x i8> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:2 for: %V32I8 = call <32 x i8> @llvm.uadd.sat.v32i8(<32 x i8> undef, <32 x i8> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:4 for: %V64I8 = call <64 x i8> @llvm.uadd.sat.v64i8(<64 x i8> undef, <64 x i8> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; BTVER2-LABEL: 'add'
; BTVER2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I64 = call i64 @llvm.uadd.sat.i64(i64 undef, i64 undef)
; BTVER2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:6 Lat:8 SizeLat:6 for: %V2I64 = call <2 x i64> @llvm.uadd.sat.v2i64(<2 x i64> undef, <2 x i64> undef)
; BTVER2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:14 Lat:11 SizeLat:15 for: %V4I64 = call <4 x i64> @llvm.uadd.sat.v4i64(<4 x i64> undef, <4 x i64> undef)
; BTVER2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:28 Lat:22 SizeLat:30 for: %V8I64 = call <8 x i64> @llvm.uadd.sat.v8i64(<8 x i64> undef, <8 x i64> undef)
; BTVER2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I32 = call i32 @llvm.uadd.sat.i32(i32 undef, i32 undef)
; BTVER2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:2 SizeLat:4 for: %V4I32 = call <4 x i32> @llvm.uadd.sat.v4i32(<4 x i32> undef, <4 x i32> undef)
; BTVER2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:10 Lat:6 SizeLat:11 for: %V8I32 = call <8 x i32> @llvm.uadd.sat.v8i32(<8 x i32> undef, <8 x i32> undef)
; BTVER2-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:20 Lat:12 SizeLat:22 for: %V16I32 = call <16 x i32> @llvm.uadd.sat.v16i32(<16 x i32> undef, <16 x i32> undef)
; BTVER2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I16 = call i16 @llvm.uadd.sat.i16(i16 undef, i16 undef)
; BTVER2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V8I16 = call <8 x i16> @llvm.uadd.sat.v8i16(<8 x i16> undef, <8 x i16> undef)
; BTVER2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:3 SizeLat:6 for: %V16I16 = call <16 x i16> @llvm.uadd.sat.v16i16(<16 x i16> undef, <16 x i16> undef)
; BTVER2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:10 Lat:6 SizeLat:12 for: %V32I16 = call <32 x i16> @llvm.uadd.sat.v32i16(<32 x i16> undef, <32 x i16> undef)
; BTVER2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:3 SizeLat:8 for: %I8 = call i8 @llvm.uadd.sat.i8(i8 undef, i8 undef)
; BTVER2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V16I8 = call <16 x i8> @llvm.uadd.sat.v16i8(<16 x i8> undef, <16 x i8> undef)
; BTVER2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:3 SizeLat:6 for: %V32I8 = call <32 x i8> @llvm.uadd.sat.v32i8(<32 x i8> undef, <32 x i8> undef)
; BTVER2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:10 Lat:6 SizeLat:12 for: %V64I8 = call <64 x i8> @llvm.uadd.sat.v64i8(<64 x i8> undef, <64 x i8> undef)
; BTVER2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %I64 = call i64 @llvm.uadd.sat.i64(i64 undef, i64 undef)
  %V2I64 = call <2 x i64> @llvm.uadd.sat.v2i64(<2 x i64> undef, <2 x i64> undef)
  %V4I64 = call <4 x i64> @llvm.uadd.sat.v4i64(<4 x i64> undef, <4 x i64> undef)
  %V8I64 = call <8 x i64> @llvm.uadd.sat.v8i64(<8 x i64> undef, <8 x i64> undef)

  %I32 = call i32 @llvm.uadd.sat.i32(i32 undef, i32 undef)
  %V4I32  = call <4 x i32>  @llvm.uadd.sat.v4i32(<4 x i32> undef, <4 x i32> undef)
  %V8I32  = call <8 x i32>  @llvm.uadd.sat.v8i32(<8 x i32> undef, <8 x i32> undef)
  %V16I32 = call <16 x i32> @llvm.uadd.sat.v16i32(<16 x i32> undef, <16 x i32> undef)

  %I16 = call i16 @llvm.uadd.sat.i16(i16 undef, i16 undef)
  %V8I16  = call <8 x i16>  @llvm.uadd.sat.v8i16(<8 x i16> undef, <8 x i16> undef)
  %V16I16 = call <16 x i16> @llvm.uadd.sat.v16i16(<16 x i16> undef, <16 x i16> undef)
  %V32I16 = call <32 x i16> @llvm.uadd.sat.v32i16(<32 x i16> undef, <32 x i16> undef)

  %I8 = call i8 @llvm.uadd.sat.i8(i8 undef, i8 undef)
  %V16I8 = call <16 x i8> @llvm.uadd.sat.v16i8(<16 x i8> undef, <16 x i8> undef)
  %V32I8 = call <32 x i8> @llvm.uadd.sat.v32i8(<32 x i8> undef, <32 x i8> undef)
  %V64I8 = call <64 x i8> @llvm.uadd.sat.v64i8(<64 x i8> undef, <64 x i8> undef)

  ret i32 undef
}

declare i64        @llvm.usub.sat.i64(i64, i64)
declare <2 x i64>  @llvm.usub.sat.v2i64(<2 x i64>, <2 x i64>)
declare <4 x i64>  @llvm.usub.sat.v4i64(<4 x i64>, <4 x i64>)
declare <8 x i64>  @llvm.usub.sat.v8i64(<8 x i64>, <8 x i64>)

declare i32        @llvm.usub.sat.i32(i32, i32)
declare <4 x i32>  @llvm.usub.sat.v4i32(<4 x i32>, <4 x i32>)
declare <8 x i32>  @llvm.usub.sat.v8i32(<8 x i32>, <8 x i32>)
declare <16 x i32> @llvm.usub.sat.v16i32(<16 x i32>, <16 x i32>)

declare i16        @llvm.usub.sat.i16(i16, i16)
declare <8 x i16>  @llvm.usub.sat.v8i16(<8 x i16>, <8 x i16>)
declare <16 x i16> @llvm.usub.sat.v16i16(<16 x i16>, <16 x i16>)
declare <32 x i16> @llvm.usub.sat.v32i16(<32 x i16>, <32 x i16>)

declare i8         @llvm.usub.sat.i8(i8,  i8)
declare <16 x i8>  @llvm.usub.sat.v16i8(<16 x i8>, <16 x i8>)
declare <32 x i8>  @llvm.usub.sat.v32i8(<32 x i8>, <32 x i8>)
declare <64 x i8>  @llvm.usub.sat.v64i8(<64 x i8>, <64 x i8>)

define i32 @sub(i32 %arg) {
; SSE2-LABEL: 'sub'
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I64 = call i64 @llvm.usub.sat.i64(i64 undef, i64 undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:14 Lat:10 SizeLat:14 for: %V2I64 = call <2 x i64> @llvm.usub.sat.v2i64(<2 x i64> undef, <2 x i64> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:28 Lat:20 SizeLat:28 for: %V4I64 = call <4 x i64> @llvm.usub.sat.v4i64(<4 x i64> undef, <4 x i64> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:56 Lat:40 SizeLat:56 for: %V8I64 = call <8 x i64> @llvm.usub.sat.v8i64(<8 x i64> undef, <8 x i64> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I32 = call i32 @llvm.usub.sat.i32(i32 undef, i32 undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:7 Lat:4 SizeLat:7 for: %V4I32 = call <4 x i32> @llvm.usub.sat.v4i32(<4 x i32> undef, <4 x i32> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:14 Lat:8 SizeLat:14 for: %V8I32 = call <8 x i32> @llvm.usub.sat.v8i32(<8 x i32> undef, <8 x i32> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:28 Lat:16 SizeLat:28 for: %V16I32 = call <16 x i32> @llvm.usub.sat.v16i32(<16 x i32> undef, <16 x i32> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I16 = call i16 @llvm.usub.sat.i16(i16 undef, i16 undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V8I16 = call <8 x i16> @llvm.usub.sat.v8i16(<8 x i16> undef, <8 x i16> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:2 for: %V16I16 = call <16 x i16> @llvm.usub.sat.v16i16(<16 x i16> undef, <16 x i16> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:4 for: %V32I16 = call <32 x i16> @llvm.usub.sat.v32i16(<32 x i16> undef, <32 x i16> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:3 SizeLat:8 for: %I8 = call i8 @llvm.usub.sat.i8(i8 undef, i8 undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V16I8 = call <16 x i8> @llvm.usub.sat.v16i8(<16 x i8> undef, <16 x i8> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:2 for: %V32I8 = call <32 x i8> @llvm.usub.sat.v32i8(<32 x i8> undef, <32 x i8> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:4 for: %V64I8 = call <64 x i8> @llvm.usub.sat.v64i8(<64 x i8> undef, <64 x i8> undef)
; SSE2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSSE3-LABEL: 'sub'
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I64 = call i64 @llvm.usub.sat.i64(i64 undef, i64 undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:14 Lat:10 SizeLat:14 for: %V2I64 = call <2 x i64> @llvm.usub.sat.v2i64(<2 x i64> undef, <2 x i64> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:28 Lat:20 SizeLat:28 for: %V4I64 = call <4 x i64> @llvm.usub.sat.v4i64(<4 x i64> undef, <4 x i64> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:28 CodeSize:56 Lat:40 SizeLat:56 for: %V8I64 = call <8 x i64> @llvm.usub.sat.v8i64(<8 x i64> undef, <8 x i64> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I32 = call i32 @llvm.usub.sat.i32(i32 undef, i32 undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:7 Lat:4 SizeLat:7 for: %V4I32 = call <4 x i32> @llvm.usub.sat.v4i32(<4 x i32> undef, <4 x i32> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:14 Lat:8 SizeLat:14 for: %V8I32 = call <8 x i32> @llvm.usub.sat.v8i32(<8 x i32> undef, <8 x i32> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:28 Lat:16 SizeLat:28 for: %V16I32 = call <16 x i32> @llvm.usub.sat.v16i32(<16 x i32> undef, <16 x i32> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I16 = call i16 @llvm.usub.sat.i16(i16 undef, i16 undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V8I16 = call <8 x i16> @llvm.usub.sat.v8i16(<8 x i16> undef, <8 x i16> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:2 for: %V16I16 = call <16 x i16> @llvm.usub.sat.v16i16(<16 x i16> undef, <16 x i16> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:4 for: %V32I16 = call <32 x i16> @llvm.usub.sat.v32i16(<32 x i16> undef, <32 x i16> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:3 SizeLat:8 for: %I8 = call i8 @llvm.usub.sat.i8(i8 undef, i8 undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V16I8 = call <16 x i8> @llvm.usub.sat.v16i8(<16 x i8> undef, <16 x i8> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:2 for: %V32I8 = call <32 x i8> @llvm.usub.sat.v32i8(<32 x i8> undef, <32 x i8> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:4 for: %V64I8 = call <64 x i8> @llvm.usub.sat.v64i8(<64 x i8> undef, <64 x i8> undef)
; SSSE3-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SSE42-LABEL: 'sub'
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I64 = call i64 @llvm.usub.sat.i64(i64 undef, i64 undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:14 Lat:10 SizeLat:14 for: %V2I64 = call <2 x i64> @llvm.usub.sat.v2i64(<2 x i64> undef, <2 x i64> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:28 Lat:20 SizeLat:28 for: %V4I64 = call <4 x i64> @llvm.usub.sat.v4i64(<4 x i64> undef, <4 x i64> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:56 Lat:40 SizeLat:56 for: %V8I64 = call <8 x i64> @llvm.usub.sat.v8i64(<8 x i64> undef, <8 x i64> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I32 = call i32 @llvm.usub.sat.i32(i32 undef, i32 undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:2 SizeLat:2 for: %V4I32 = call <4 x i32> @llvm.usub.sat.v4i32(<4 x i32> undef, <4 x i32> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:4 SizeLat:4 for: %V8I32 = call <8 x i32> @llvm.usub.sat.v8i32(<8 x i32> undef, <8 x i32> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:8 Lat:8 SizeLat:8 for: %V16I32 = call <16 x i32> @llvm.usub.sat.v16i32(<16 x i32> undef, <16 x i32> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I16 = call i16 @llvm.usub.sat.i16(i16 undef, i16 undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V8I16 = call <8 x i16> @llvm.usub.sat.v8i16(<8 x i16> undef, <8 x i16> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:2 for: %V16I16 = call <16 x i16> @llvm.usub.sat.v16i16(<16 x i16> undef, <16 x i16> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:4 for: %V32I16 = call <32 x i16> @llvm.usub.sat.v32i16(<32 x i16> undef, <32 x i16> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:3 SizeLat:8 for: %I8 = call i8 @llvm.usub.sat.i8(i8 undef, i8 undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V16I8 = call <16 x i8> @llvm.usub.sat.v16i8(<16 x i8> undef, <16 x i8> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:2 for: %V32I8 = call <32 x i8> @llvm.usub.sat.v32i8(<32 x i8> undef, <32 x i8> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:4 for: %V64I8 = call <64 x i8> @llvm.usub.sat.v64i8(<64 x i8> undef, <64 x i8> undef)
; SSE42-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX1-LABEL: 'sub'
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I64 = call i64 @llvm.usub.sat.i64(i64 undef, i64 undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:6 Lat:7 SizeLat:6 for: %V2I64 = call <2 x i64> @llvm.usub.sat.v2i64(<2 x i64> undef, <2 x i64> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:14 Lat:10 SizeLat:15 for: %V4I64 = call <4 x i64> @llvm.usub.sat.v4i64(<4 x i64> undef, <4 x i64> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:28 Lat:20 SizeLat:30 for: %V8I64 = call <8 x i64> @llvm.usub.sat.v8i64(<8 x i64> undef, <8 x i64> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I32 = call i32 @llvm.usub.sat.i32(i32 undef, i32 undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:2 SizeLat:2 for: %V4I32 = call <4 x i32> @llvm.usub.sat.v4i32(<4 x i32> undef, <4 x i32> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:7 Lat:4 SizeLat:8 for: %V8I32 = call <8 x i32> @llvm.usub.sat.v8i32(<8 x i32> undef, <8 x i32> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:14 Lat:8 SizeLat:16 for: %V16I32 = call <16 x i32> @llvm.usub.sat.v16i32(<16 x i32> undef, <16 x i32> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I16 = call i16 @llvm.usub.sat.i16(i16 undef, i16 undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V8I16 = call <8 x i16> @llvm.usub.sat.v8i16(<8 x i16> undef, <8 x i16> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:3 SizeLat:6 for: %V16I16 = call <16 x i16> @llvm.usub.sat.v16i16(<16 x i16> undef, <16 x i16> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:10 Lat:6 SizeLat:12 for: %V32I16 = call <32 x i16> @llvm.usub.sat.v32i16(<32 x i16> undef, <32 x i16> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:3 SizeLat:8 for: %I8 = call i8 @llvm.usub.sat.i8(i8 undef, i8 undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V16I8 = call <16 x i8> @llvm.usub.sat.v16i8(<16 x i8> undef, <16 x i8> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:3 SizeLat:6 for: %V32I8 = call <32 x i8> @llvm.usub.sat.v32i8(<32 x i8> undef, <32 x i8> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:10 Lat:6 SizeLat:12 for: %V64I8 = call <64 x i8> @llvm.usub.sat.v64i8(<64 x i8> undef, <64 x i8> undef)
; AVX1-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX2-LABEL: 'sub'
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I64 = call i64 @llvm.usub.sat.i64(i64 undef, i64 undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:6 Lat:7 SizeLat:6 for: %V2I64 = call <2 x i64> @llvm.usub.sat.v2i64(<2 x i64> undef, <2 x i64> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:6 Lat:7 SizeLat:10 for: %V4I64 = call <4 x i64> @llvm.usub.sat.v4i64(<4 x i64> undef, <4 x i64> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:12 Lat:14 SizeLat:20 for: %V8I64 = call <8 x i64> @llvm.usub.sat.v8i64(<8 x i64> undef, <8 x i64> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I32 = call i32 @llvm.usub.sat.i32(i32 undef, i32 undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:2 SizeLat:2 for: %V4I32 = call <4 x i32> @llvm.usub.sat.v4i32(<4 x i32> undef, <4 x i32> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V8I32 = call <8 x i32> @llvm.usub.sat.v8i32(<8 x i32> undef, <8 x i32> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:4 SizeLat:8 for: %V16I32 = call <16 x i32> @llvm.usub.sat.v16i32(<16 x i32> undef, <16 x i32> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I16 = call i16 @llvm.usub.sat.i16(i16 undef, i16 undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V8I16 = call <8 x i16> @llvm.usub.sat.v8i16(<8 x i16> undef, <8 x i16> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V16I16 = call <16 x i16> @llvm.usub.sat.v16i16(<16 x i16> undef, <16 x i16> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V32I16 = call <32 x i16> @llvm.usub.sat.v32i16(<32 x i16> undef, <32 x i16> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:3 SizeLat:8 for: %I8 = call i8 @llvm.usub.sat.i8(i8 undef, i8 undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V16I8 = call <16 x i8> @llvm.usub.sat.v16i8(<16 x i8> undef, <16 x i8> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I8 = call <32 x i8> @llvm.usub.sat.v32i8(<32 x i8> undef, <32 x i8> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:2 SizeLat:4 for: %V64I8 = call <64 x i8> @llvm.usub.sat.v64i8(<64 x i8> undef, <64 x i8> undef)
; AVX2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512F-LABEL: 'sub'
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I64 = call i64 @llvm.usub.sat.i64(i64 undef, i64 undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:4 SizeLat:2 for: %V2I64 = call <2 x i64> @llvm.usub.sat.v2i64(<2 x i64> undef, <2 x i64> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:4 SizeLat:2 for: %V4I64 = call <4 x i64> @llvm.usub.sat.v4i64(<4 x i64> undef, <4 x i64> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:4 SizeLat:2 for: %V8I64 = call <8 x i64> @llvm.usub.sat.v8i64(<8 x i64> undef, <8 x i64> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I32 = call i32 @llvm.usub.sat.i32(i32 undef, i32 undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:2 SizeLat:2 for: %V4I32 = call <4 x i32> @llvm.usub.sat.v4i32(<4 x i32> undef, <4 x i32> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:2 SizeLat:2 for: %V8I32 = call <8 x i32> @llvm.usub.sat.v8i32(<8 x i32> undef, <8 x i32> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:2 SizeLat:2 for: %V16I32 = call <16 x i32> @llvm.usub.sat.v16i32(<16 x i32> undef, <16 x i32> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I16 = call i16 @llvm.usub.sat.i16(i16 undef, i16 undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V8I16 = call <8 x i16> @llvm.usub.sat.v8i16(<8 x i16> undef, <8 x i16> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V16I16 = call <16 x i16> @llvm.usub.sat.v16i16(<16 x i16> undef, <16 x i16> undef)
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V32I16 = call <32 x i16> @llvm.usub.sat.v32i16(<32 x i16> undef, <32 x i16> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:3 SizeLat:8 for: %I8 = call i8 @llvm.usub.sat.i8(i8 undef, i8 undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V16I8 = call <16 x i8> @llvm.usub.sat.v16i8(<16 x i8> undef, <16 x i8> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I8 = call <32 x i8> @llvm.usub.sat.v32i8(<32 x i8> undef, <32 x i8> undef)
; AVX512F-NEXT:  Cost Model: Found costs of 2 for: %V64I8 = call <64 x i8> @llvm.usub.sat.v64i8(<64 x i8> undef, <64 x i8> undef)
; AVX512F-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512BW-LABEL: 'sub'
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I64 = call i64 @llvm.usub.sat.i64(i64 undef, i64 undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:4 SizeLat:2 for: %V2I64 = call <2 x i64> @llvm.usub.sat.v2i64(<2 x i64> undef, <2 x i64> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:4 SizeLat:2 for: %V4I64 = call <4 x i64> @llvm.usub.sat.v4i64(<4 x i64> undef, <4 x i64> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:4 SizeLat:2 for: %V8I64 = call <8 x i64> @llvm.usub.sat.v8i64(<8 x i64> undef, <8 x i64> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I32 = call i32 @llvm.usub.sat.i32(i32 undef, i32 undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:2 SizeLat:2 for: %V4I32 = call <4 x i32> @llvm.usub.sat.v4i32(<4 x i32> undef, <4 x i32> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:2 SizeLat:2 for: %V8I32 = call <8 x i32> @llvm.usub.sat.v8i32(<8 x i32> undef, <8 x i32> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:2 SizeLat:2 for: %V16I32 = call <16 x i32> @llvm.usub.sat.v16i32(<16 x i32> undef, <16 x i32> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I16 = call i16 @llvm.usub.sat.i16(i16 undef, i16 undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V8I16 = call <8 x i16> @llvm.usub.sat.v8i16(<8 x i16> undef, <8 x i16> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V16I16 = call <16 x i16> @llvm.usub.sat.v16i16(<16 x i16> undef, <16 x i16> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V32I16 = call <32 x i16> @llvm.usub.sat.v32i16(<32 x i16> undef, <32 x i16> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:3 SizeLat:8 for: %I8 = call i8 @llvm.usub.sat.i8(i8 undef, i8 undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V16I8 = call <16 x i8> @llvm.usub.sat.v16i8(<16 x i8> undef, <16 x i8> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I8 = call <32 x i8> @llvm.usub.sat.v32i8(<32 x i8> undef, <32 x i8> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of 1 for: %V64I8 = call <64 x i8> @llvm.usub.sat.v64i8(<64 x i8> undef, <64 x i8> undef)
; AVX512BW-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; AVX512DQ-LABEL: 'sub'
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I64 = call i64 @llvm.usub.sat.i64(i64 undef, i64 undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:4 SizeLat:2 for: %V2I64 = call <2 x i64> @llvm.usub.sat.v2i64(<2 x i64> undef, <2 x i64> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:4 SizeLat:2 for: %V4I64 = call <4 x i64> @llvm.usub.sat.v4i64(<4 x i64> undef, <4 x i64> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:4 SizeLat:2 for: %V8I64 = call <8 x i64> @llvm.usub.sat.v8i64(<8 x i64> undef, <8 x i64> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I32 = call i32 @llvm.usub.sat.i32(i32 undef, i32 undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:2 SizeLat:2 for: %V4I32 = call <4 x i32> @llvm.usub.sat.v4i32(<4 x i32> undef, <4 x i32> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:2 SizeLat:2 for: %V8I32 = call <8 x i32> @llvm.usub.sat.v8i32(<8 x i32> undef, <8 x i32> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:2 SizeLat:2 for: %V16I32 = call <16 x i32> @llvm.usub.sat.v16i32(<16 x i32> undef, <16 x i32> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I16 = call i16 @llvm.usub.sat.i16(i16 undef, i16 undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V8I16 = call <8 x i16> @llvm.usub.sat.v8i16(<8 x i16> undef, <8 x i16> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V16I16 = call <16 x i16> @llvm.usub.sat.v16i16(<16 x i16> undef, <16 x i16> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of 2 for: %V32I16 = call <32 x i16> @llvm.usub.sat.v32i16(<32 x i16> undef, <32 x i16> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:3 SizeLat:8 for: %I8 = call i8 @llvm.usub.sat.i8(i8 undef, i8 undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V16I8 = call <16 x i8> @llvm.usub.sat.v16i8(<16 x i8> undef, <16 x i8> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:1 SizeLat:2 for: %V32I8 = call <32 x i8> @llvm.usub.sat.v32i8(<32 x i8> undef, <32 x i8> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of 2 for: %V64I8 = call <64 x i8> @llvm.usub.sat.v64i8(<64 x i8> undef, <64 x i8> undef)
; AVX512DQ-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; SLM-LABEL: 'sub'
; SLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I64 = call i64 @llvm.usub.sat.i64(i64 undef, i64 undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:14 Lat:10 SizeLat:14 for: %V2I64 = call <2 x i64> @llvm.usub.sat.v2i64(<2 x i64> undef, <2 x i64> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:28 Lat:20 SizeLat:28 for: %V4I64 = call <4 x i64> @llvm.usub.sat.v4i64(<4 x i64> undef, <4 x i64> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:56 Lat:40 SizeLat:56 for: %V8I64 = call <8 x i64> @llvm.usub.sat.v8i64(<8 x i64> undef, <8 x i64> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I32 = call i32 @llvm.usub.sat.i32(i32 undef, i32 undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:2 SizeLat:2 for: %V4I32 = call <4 x i32> @llvm.usub.sat.v4i32(<4 x i32> undef, <4 x i32> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:4 SizeLat:4 for: %V8I32 = call <8 x i32> @llvm.usub.sat.v8i32(<8 x i32> undef, <8 x i32> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:8 Lat:8 SizeLat:8 for: %V16I32 = call <16 x i32> @llvm.usub.sat.v16i32(<16 x i32> undef, <16 x i32> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I16 = call i16 @llvm.usub.sat.i16(i16 undef, i16 undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V8I16 = call <8 x i16> @llvm.usub.sat.v8i16(<8 x i16> undef, <8 x i16> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:2 for: %V16I16 = call <16 x i16> @llvm.usub.sat.v16i16(<16 x i16> undef, <16 x i16> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:4 for: %V32I16 = call <32 x i16> @llvm.usub.sat.v32i16(<32 x i16> undef, <32 x i16> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:3 SizeLat:8 for: %I8 = call i8 @llvm.usub.sat.i8(i8 undef, i8 undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V16I8 = call <16 x i8> @llvm.usub.sat.v16i8(<16 x i8> undef, <16 x i8> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:2 for: %V32I8 = call <32 x i8> @llvm.usub.sat.v32i8(<32 x i8> undef, <32 x i8> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:4 for: %V64I8 = call <64 x i8> @llvm.usub.sat.v64i8(<64 x i8> undef, <64 x i8> undef)
; SLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; GLM-LABEL: 'sub'
; GLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I64 = call i64 @llvm.usub.sat.i64(i64 undef, i64 undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:14 Lat:10 SizeLat:14 for: %V2I64 = call <2 x i64> @llvm.usub.sat.v2i64(<2 x i64> undef, <2 x i64> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:12 CodeSize:28 Lat:20 SizeLat:28 for: %V4I64 = call <4 x i64> @llvm.usub.sat.v4i64(<4 x i64> undef, <4 x i64> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:24 CodeSize:56 Lat:40 SizeLat:56 for: %V8I64 = call <8 x i64> @llvm.usub.sat.v8i64(<8 x i64> undef, <8 x i64> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I32 = call i32 @llvm.usub.sat.i32(i32 undef, i32 undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:2 SizeLat:2 for: %V4I32 = call <4 x i32> @llvm.usub.sat.v4i32(<4 x i32> undef, <4 x i32> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:4 SizeLat:4 for: %V8I32 = call <8 x i32> @llvm.usub.sat.v8i32(<8 x i32> undef, <8 x i32> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:8 Lat:8 SizeLat:8 for: %V16I32 = call <16 x i32> @llvm.usub.sat.v16i32(<16 x i32> undef, <16 x i32> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I16 = call i16 @llvm.usub.sat.i16(i16 undef, i16 undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V8I16 = call <8 x i16> @llvm.usub.sat.v8i16(<8 x i16> undef, <8 x i16> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:2 for: %V16I16 = call <16 x i16> @llvm.usub.sat.v16i16(<16 x i16> undef, <16 x i16> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:4 for: %V32I16 = call <32 x i16> @llvm.usub.sat.v32i16(<32 x i16> undef, <32 x i16> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:3 SizeLat:8 for: %I8 = call i8 @llvm.usub.sat.i8(i8 undef, i8 undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V16I8 = call <16 x i8> @llvm.usub.sat.v16i8(<16 x i8> undef, <16 x i8> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:2 Lat:4 SizeLat:2 for: %V32I8 = call <32 x i8> @llvm.usub.sat.v32i8(<32 x i8> undef, <32 x i8> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:4 Lat:8 SizeLat:4 for: %V64I8 = call <64 x i8> @llvm.usub.sat.v64i8(<64 x i8> undef, <64 x i8> undef)
; GLM-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
; BTVER2-LABEL: 'sub'
; BTVER2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I64 = call i64 @llvm.usub.sat.i64(i64 undef, i64 undef)
; BTVER2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:6 Lat:7 SizeLat:6 for: %V2I64 = call <2 x i64> @llvm.usub.sat.v2i64(<2 x i64> undef, <2 x i64> undef)
; BTVER2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:14 Lat:10 SizeLat:15 for: %V4I64 = call <4 x i64> @llvm.usub.sat.v4i64(<4 x i64> undef, <4 x i64> undef)
; BTVER2-NEXT:  Cost Model: Found costs of RThru:16 CodeSize:28 Lat:20 SizeLat:30 for: %V8I64 = call <8 x i64> @llvm.usub.sat.v8i64(<8 x i64> undef, <8 x i64> undef)
; BTVER2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I32 = call i32 @llvm.usub.sat.i32(i32 undef, i32 undef)
; BTVER2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:2 Lat:2 SizeLat:2 for: %V4I32 = call <4 x i32> @llvm.usub.sat.v4i32(<4 x i32> undef, <4 x i32> undef)
; BTVER2-NEXT:  Cost Model: Found costs of RThru:4 CodeSize:7 Lat:4 SizeLat:8 for: %V8I32 = call <8 x i32> @llvm.usub.sat.v8i32(<8 x i32> undef, <8 x i32> undef)
; BTVER2-NEXT:  Cost Model: Found costs of RThru:8 CodeSize:14 Lat:8 SizeLat:16 for: %V16I32 = call <16 x i32> @llvm.usub.sat.v16i32(<16 x i32> undef, <16 x i32> undef)
; BTVER2-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:4 Lat:3 SizeLat:7 for: %I16 = call i16 @llvm.usub.sat.i16(i16 undef, i16 undef)
; BTVER2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V8I16 = call <8 x i16> @llvm.usub.sat.v8i16(<8 x i16> undef, <8 x i16> undef)
; BTVER2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:3 SizeLat:6 for: %V16I16 = call <16 x i16> @llvm.usub.sat.v16i16(<16 x i16> undef, <16 x i16> undef)
; BTVER2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:10 Lat:6 SizeLat:12 for: %V32I16 = call <32 x i16> @llvm.usub.sat.v32i16(<32 x i16> undef, <32 x i16> undef)
; BTVER2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:3 SizeLat:8 for: %I8 = call i8 @llvm.usub.sat.i8(i8 undef, i8 undef)
; BTVER2-NEXT:  Cost Model: Found costs of RThru:1 CodeSize:1 Lat:2 SizeLat:1 for: %V16I8 = call <16 x i8> @llvm.usub.sat.v16i8(<16 x i8> undef, <16 x i8> undef)
; BTVER2-NEXT:  Cost Model: Found costs of RThru:3 CodeSize:5 Lat:3 SizeLat:6 for: %V32I8 = call <32 x i8> @llvm.usub.sat.v32i8(<32 x i8> undef, <32 x i8> undef)
; BTVER2-NEXT:  Cost Model: Found costs of RThru:6 CodeSize:10 Lat:6 SizeLat:12 for: %V64I8 = call <64 x i8> @llvm.usub.sat.v64i8(<64 x i8> undef, <64 x i8> undef)
; BTVER2-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 undef
;
  %I64 = call i64 @llvm.usub.sat.i64(i64 undef, i64 undef)
  %V2I64 = call <2 x i64> @llvm.usub.sat.v2i64(<2 x i64> undef, <2 x i64> undef)
  %V4I64 = call <4 x i64> @llvm.usub.sat.v4i64(<4 x i64> undef, <4 x i64> undef)
  %V8I64 = call <8 x i64> @llvm.usub.sat.v8i64(<8 x i64> undef, <8 x i64> undef)

  %I32 = call i32 @llvm.usub.sat.i32(i32 undef, i32 undef)
  %V4I32  = call <4 x i32>  @llvm.usub.sat.v4i32(<4 x i32> undef, <4 x i32> undef)
  %V8I32  = call <8 x i32>  @llvm.usub.sat.v8i32(<8 x i32> undef, <8 x i32> undef)
  %V16I32 = call <16 x i32> @llvm.usub.sat.v16i32(<16 x i32> undef, <16 x i32> undef)

  %I16 = call i16 @llvm.usub.sat.i16(i16 undef, i16 undef)
  %V8I16  = call <8 x i16>  @llvm.usub.sat.v8i16(<8 x i16> undef, <8 x i16> undef)
  %V16I16 = call <16 x i16> @llvm.usub.sat.v16i16(<16 x i16> undef, <16 x i16> undef)
  %V32I16 = call <32 x i16> @llvm.usub.sat.v32i16(<32 x i16> undef, <32 x i16> undef)

  %I8 = call i8 @llvm.usub.sat.i8(i8 undef, i8 undef)
  %V16I8 = call <16 x i8> @llvm.usub.sat.v16i8(<16 x i8> undef, <16 x i8> undef)
  %V32I8 = call <32 x i8> @llvm.usub.sat.v32i8(<32 x i8> undef, <32 x i8> undef)
  %V64I8 = call <64 x i8> @llvm.usub.sat.v64i8(<64 x i8> undef, <64 x i8> undef)

  ret i32 undef
}
