
macro(STK_ADD_DEBUG_AND_DEPRECATED_OPTIONS)
  if(HAVE_STK_Trilinos)
    TRIBITS_ADD_DEBUG_OPTION()
    TRIBITS_ADD_SHOW_DEPRECATED_WARNINGS_OPTION()
  else()
    # what should we do here?
  endif()
endmacro()

macro(STK_CONFIGURE_FILE filename)
  if(HAVE_STK_Trilinos)
    TRIBITS_CONFIGURE_FILE(${filename})
    TRIBITS_INCLUDE_DIRECTORIES(${CMAKE_CURRENT_BINARY_DIR})
  else()
    configure_file(${STK_TOPLEVEL_SOURCE_DIR}/cmake/${filename}.in ${CMAKE_CURRENT_BINARY_DIR}/${filename})
  endif()
endmacro()

function(stk_process_enables)
  message("******** Begin stk_process_enables ******")
  if(STK_ENABLE_ALL)
    message("STK_ENABLE_ALL is on.")
    set(STK_ENABLE_STKUtil ON CACHE BOOL "")

    if (DEFINED STK_ENABLE_STKCoupling AND NOT STK_ENABLE_STKCoupling)
      message("STKCoupling explicitly disabled.")
    elseif(NOT STK_HAS_MPI)
      message("STKCoupling disabled because MPI not enabled.")
    else()
      set(STK_ENABLE_STKCoupling ON CACHE BOOL "")
    endif()

    if (DEFINED STK_ENABLE_STKMath AND NOT STK_ENABLE_STKMath)
      message("STKMath explicitly disabled.")
    else()
      set(STK_ENABLE_STKMath ON CACHE BOOL "")
    endif()

    if (DEFINED STK_ENABLE_STKSimd AND NOT STK_ENABLE_STKSimd)
      message("STKSimd explicitly disabled.")
    else()
      set(STK_ENABLE_STKSimd ON CACHE BOOL "")
    endif()

    if (DEFINED STK_ENABLE_STKNGP_TEST AND NOT STK_ENABLE_STKNGP_TEST)
      message("STKNGP_TEST explicitly disabled.")
    else()
      set(STK_ENABLE_STKNGP_TEST ON CACHE BOOL "")
    endif()

    if (DEFINED STK_ENABLE_STKExprEval AND NOT STK_ENABLE_STKExprEval)
      message("STKExprEval explicitly disabled.")
    else()
      set(STK_ENABLE_STKExprEval ON CACHE BOOL "")
    endif()

    if (DEFINED STK_ENABLE_STKTopology AND NOT STK_ENABLE_STKTopology)
      message("STKTopology explicitly disabled.")
    else()
      set(STK_ENABLE_STKTopology ON CACHE BOOL "")
    endif()

    if (DEFINED STK_ENABLE_STKEmend AND NOT STK_ENABLE_STKEmend)
      message("STKEmend explicitly disabled.")
    else()
      set(STK_ENABLE_STKEmend ON CACHE BOOL "")
    endif()

    if (DEFINED STK_ENABLE_STKSearch AND NOT STK_ENABLE_STKSearch)
      message("STKSearch explicitly disabled.")
    elseif(NOT STK_HAS_MPI)
      message("STKSearch disabled because MPI not enabled.")
    else()
      set(STK_ENABLE_STKSearch ON CACHE BOOL "")
    endif()

    if (DEFINED STK_ENABLE_STKMiddle_mesh AND NOT STK_ENABLE_STKMiddle_mesh)
      message("STKMiddle_mesh explicitly disabled.")
    else()
      set(STK_ENABLE_STKMiddle_mesh ON CACHE BOOL "")
    endif()

    if (DEFINED STK_ENABLE_STKMiddle_mesh_util AND NOT STK_ENABLE_STKMiddle_mesh_util)
      message("STKMiddle_mesh_util explicitly disabled.")
    elseif(NOT STK_ENABLE_STKMiddle_mesh)
      message("STKMiddle_mesh_util disabled because STKMiddle_mesh not enabled.")
    else()
      set(STK_ENABLE_STKMiddle_mesh_util ON CACHE BOOL "")
    endif()

    if (DEFINED STK_ENABLE_STKTransfer AND NOT STK_ENABLE_STKTransfer)
      message("STKTransfer explicitly disabled.")
    elseif(NOT STK_ENABLE_STKSearch)
      message("STKTransfer disabled because STKSearch not enabled.")
    else()
      set(STK_ENABLE_STKTransfer ON CACHE BOOL "")
    endif()

    if (DEFINED STK_ENABLE_STKMesh AND NOT STK_ENABLE_STKMesh)
      message("STKMesh explicitly disabled.")
    elseif(NOT STK_ENABLE_STKTopology)
      message("STKMesh disabled because STKTopology not enabled.")
    elseif(NOT STK_HAS_MPI)
      message("STKMesh disabled because MPI not enabled.")
    else()
      set(STK_ENABLE_STKMesh ON CACHE BOOL "")
    endif()

    if (DEFINED STK_ENABLE_STKSearchUtil AND NOT STK_ENABLE_STKSearchUtil)
      message("STKSearchUtil explicitly disabled.")
    elseif(NOT STK_ENABLE_STKMesh)
      message("STKSearchUtil disabled because STKMesh not enabled.")
    else()
      set(STK_ENABLE_STKSearchUtil ON CACHE BOOL "")
    endif()

    if (DEFINED STK_ENABLE_STKTransferUtil AND NOT STK_ENABLE_STKTransferUtil)
      message("STKTransferUtil explicitly disabled.")
    elseif(NOT STK_ENABLE_STKMesh)
      message("STKTransferUtil disabled because STKMesh not enabled.")
    else()
      set(STK_ENABLE_STKTransferUtil ON CACHE BOOL "")
    endif()

    if (DEFINED STK_ENABLE_STKIO AND NOT STK_ENABLE_STKIO)
      message("STKIO explicitly disabled.")
    elseif(NOT STK_ENABLE_STKMesh)
      message("STKIO disabled because STKMesh not enabled.")
    else()
      if (STK_HAS_SEACAS_IOSS)
        set(STK_ENABLE_STKIO ON CACHE BOOL "")
      else()
        message("STKIO disabled because SEACASIoss not available.")
      endif()
    endif()

    if (DEFINED STK_ENABLE_STKTools AND NOT STK_ENABLE_STKTools)
      message("STKTools explicitly disabled.")
    elseif(NOT STK_ENABLE_STKMesh)
      message("STKTools disabled because STKMesh not enabled.")
    else()
      set(STK_ENABLE_STKTools ON CACHE BOOL "")
    endif()

    if (DEFINED STK_ENABLE_STKBalance AND NOT STK_ENABLE_STKBalance)
      message("STKBalance explicitly disabled.")
    elseif(NOT STK_ENABLE_STKIO)
      message("STKBalance disabled because STKIO not enabled.")
    else()
      set(STK_ENABLE_STKBalance ON CACHE BOOL "")
    endif()
  endif()
  
  if(STK_ENABLE_TESTS)
    set(STK_ENABLE_STKUnit_tests ON CACHE BOOL "")
    set(STK_ENABLE_STKDoc_tests ON CACHE BOOL "")
  endif()
  message("******** End stk_process_enables ******")
endfunction()

macro(STK_SUBPACKAGES)
  if(HAVE_STK_Trilinos)
    TRIBITS_PROCESS_SUBPACKAGES()
  else()
    add_subdirectory(stk_util)
    message("STKUtil is always enabled.")

    if(STK_ENABLE_STKCoupling)
      add_subdirectory(stk_coupling)
      message("STKCoupling is enabled.")
    endif()

    if(STK_ENABLE_STKMath)
      add_subdirectory(stk_math)
      message("STKMath is enabled.")
    endif()

    if(STK_ENABLE_STKSimd)
      add_subdirectory(stk_simd)
      message("STKSimd is enabled.")
    endif()

    if(STK_ENABLE_STKNGP_TEST)
      add_subdirectory(stk_ngp_test)
      message("STKNGP_TEST is enabled.")
    endif()

    if(STK_ENABLE_STKExprEval)
      add_subdirectory(stk_expreval)
      message("STKExprEval is enabled.")
    endif()

    if(STK_ENABLE_STKTopology)
      add_subdirectory(stk_topology)
      message("STKTopology is enabled.")
    endif()

    if(STK_ENABLE_STKEmend)
      add_subdirectory(stk_emend)
      message("STKEmend is enabled.")
    endif()
    
    if(STK_ENABLE_STKSearch)
      add_subdirectory(stk_search)
      message("STKSearch is enabled.")
    endif()

    if(STK_ENABLE_STKMiddle_mesh)
      add_subdirectory(stk_middle_mesh)
      message("STKMiddle_mesh is enabled.")
    endif()

    if(STK_ENABLE_STKMiddle_mesh_util)
      add_subdirectory(stk_middle_mesh_util)
      message("STKMiddle_mesh_util is enabled.")
    endif()

    if(STK_ENABLE_STKTransfer)
      add_subdirectory(stk_transfer)
      message("STKTransfer is enabled.")
    endif()

    if(STK_ENABLE_STKMesh)
      message("STKMesh is enabled.")
      add_subdirectory(stk_mesh)
    endif()

    if(STK_ENABLE_STKSearchUtil)
      message("STKSearchUtil is enabled.")
      add_subdirectory(stk_search_util)
    endif()

    if(STK_ENABLE_STKTransferUtil)
      message("STKTransferUtil is enabled.")
      add_subdirectory(stk_transfer_util)
    endif()

    if(STK_ENABLE_STKIO)
      message("STKIO is enabled.")
      add_subdirectory(stk_io)
    endif()

    if(STK_ENABLE_STKTools)
      message("STKTools is enabled.")
      add_subdirectory(stk_tools)
    endif()

    if(STK_ENABLE_STKBalance)
      message("STKBalance is enabled.")
      add_subdirectory(stk_balance)
    endif()

    if(STK_ENABLE_TESTS)
      add_subdirectory(stk_unit_test_utils)
      message("STKUnit_test_utils is enabled.")

      add_subdirectory(stk_unit_tests)
      message("STKUnit_tests is enabled.")

      add_subdirectory(stk_doc_tests)
      message("STKDoc_tests is enabled.")
    endif()
  endif()
endmacro()

macro(STK_SUBPACKAGE subpkg)
  if(HAVE_STK_Trilinos)
    TRIBITS_SUBPACKAGE($subpkg)
  else()
  endif()
endmacro()

macro(STK_ADD_TEST_DIRECTORIES subdir)
  if(HAVE_STK_Trilinos)
    TRIBITS_ADD_TEST_DIRECTORIES(${subdir})
  else()
    add_subdirectory(${subdir})
  endif()
endmacro()

macro(STK_SUBPACKAGE_POSTPROCESS)
  if(HAVE_STK_Trilinos)
    TRIBITS_SUBPACKAGE_POSTPROCESS()
  else()
  endif()
endmacro()

macro(STK_PACKAGE_POSTPROCESS)
  if(HAVE_STK_Trilinos)
    TRIBITS_PACKAGE_DEF()
    TRIBITS_PACKAGE_POSTPROCESS()
  else()
  endif()
endmacro()
