// Copyright 2020 The Gitea Authors. All rights reserved.
// SPDX-License-Identifier: MIT

package cmd

import (
	"code.gitea.io/tea/cmd/notifications"

	"github.com/urfave/cli/v3"
)

// CmdNotifications is the main command to operate with notifications
var CmdNotifications = cli.Command{
	Name:        "notifications",
	Aliases:     []string{"notification", "n"},
	Category:    catHelpers,
	Usage:       "Show notifications",
	Description: "Show notifications, by default based on the current repo if available",
	Action:      notifications.RunNotificationsList,
	Commands: []*cli.Command{
		&notifications.CmdNotificationsList,
		&notifications.CmdNotificationsMarkRead,
		&notifications.CmdNotificationsMarkUnread,
		&notifications.CmdNotificationsMarkPinned,
		&notifications.CmdNotificationsUnpin,
	},
	Flags: notifications.CmdNotificationsList.Flags,
}
