#[allow(non_camel_case_types)]
#[derive(Debug, Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
pub enum Opcode {
  PHI,
  INLINEASM,
  INLINEASM_BR,
  CFI_INSTRUCTION,
  EH_LABEL,
  GC_LABEL,
  ANNOTATION_LABEL,
  KILL,
  EXTRACT_SUBREG,
  INSERT_SUBREG,
  IMPLICIT_DEF,
  INIT_UNDEF,
  SUBREG_TO_REG,
  COPY_TO_REGCLASS,
  DBG_VALUE,
  DBG_VALUE_LIST,
  DBG_INSTR_REF,
  DBG_PHI,
  DBG_LABEL,
  REG_SEQUENCE,
  COPY,
  BUNDLE,
  LIFETIME_START,
  LIFETIME_END,
  PSEUDO_PROBE,
  ARITH_FENCE,
  STACKMAP,
  FENTRY_CALL,
  PATCHPOINT,
  LOAD_STACK_GUARD,
  PREALLOCATED_SETUP,
  PREALLOCATED_ARG,
  STATEPOINT,
  LOCAL_ESCAPE,
  FAULTING_OP,
  PATCHABLE_OP,
  PATCHABLE_FUNCTION_ENTER,
  PATCHABLE_RET,
  PATCHABLE_FUNCTION_EXIT,
  PATCHABLE_TAIL_CALL,
  PATCHABLE_EVENT_CALL,
  PATCHABLE_TYPED_EVENT_CALL,
  ICALL_BRANCH_FUNNEL,
  FAKE_USE,
  MEMBARRIER,
  JUMP_TABLE_DEBUG_INFO,
  CONVERGENCECTRL_ENTRY,
  CONVERGENCECTRL_ANCHOR,
  CONVERGENCECTRL_LOOP,
  CONVERGENCECTRL_GLUE,
  G_ASSERT_SEXT,
  G_ASSERT_ZEXT,
  G_ASSERT_ALIGN,
  G_ADD,
  G_SUB,
  G_MUL,
  G_SDIV,
  G_UDIV,
  G_SREM,
  G_UREM,
  G_SDIVREM,
  G_UDIVREM,
  G_AND,
  G_OR,
  G_XOR,
  G_ABDS,
  G_ABDU,
  G_IMPLICIT_DEF,
  G_PHI,
  G_FRAME_INDEX,
  G_GLOBAL_VALUE,
  G_PTRAUTH_GLOBAL_VALUE,
  G_CONSTANT_POOL,
  G_EXTRACT,
  G_UNMERGE_VALUES,
  G_INSERT,
  G_MERGE_VALUES,
  G_BUILD_VECTOR,
  G_BUILD_VECTOR_TRUNC,
  G_CONCAT_VECTORS,
  G_PTRTOINT,
  G_INTTOPTR,
  G_BITCAST,
  G_FREEZE,
  G_CONSTANT_FOLD_BARRIER,
  G_INTRINSIC_FPTRUNC_ROUND,
  G_INTRINSIC_TRUNC,
  G_INTRINSIC_ROUND,
  G_INTRINSIC_LRINT,
  G_INTRINSIC_LLRINT,
  G_INTRINSIC_ROUNDEVEN,
  G_READCYCLECOUNTER,
  G_READSTEADYCOUNTER,
  G_LOAD,
  G_SEXTLOAD,
  G_ZEXTLOAD,
  G_INDEXED_LOAD,
  G_INDEXED_SEXTLOAD,
  G_INDEXED_ZEXTLOAD,
  G_STORE,
  G_INDEXED_STORE,
  G_ATOMIC_CMPXCHG_WITH_SUCCESS,
  G_ATOMIC_CMPXCHG,
  G_ATOMICRMW_XCHG,
  G_ATOMICRMW_ADD,
  G_ATOMICRMW_SUB,
  G_ATOMICRMW_AND,
  G_ATOMICRMW_NAND,
  G_ATOMICRMW_OR,
  G_ATOMICRMW_XOR,
  G_ATOMICRMW_MAX,
  G_ATOMICRMW_MIN,
  G_ATOMICRMW_UMAX,
  G_ATOMICRMW_UMIN,
  G_ATOMICRMW_FADD,
  G_ATOMICRMW_FSUB,
  G_ATOMICRMW_FMAX,
  G_ATOMICRMW_FMIN,
  G_ATOMICRMW_FMAXIMUM,
  G_ATOMICRMW_FMINIMUM,
  G_ATOMICRMW_UINC_WRAP,
  G_ATOMICRMW_UDEC_WRAP,
  G_ATOMICRMW_USUB_COND,
  G_ATOMICRMW_USUB_SAT,
  G_FENCE,
  G_PREFETCH,
  G_BRCOND,
  G_BRINDIRECT,
  G_INVOKE_REGION_START,
  G_INTRINSIC,
  G_INTRINSIC_W_SIDE_EFFECTS,
  G_INTRINSIC_CONVERGENT,
  G_INTRINSIC_CONVERGENT_W_SIDE_EFFECTS,
  G_ANYEXT,
  G_TRUNC,
  G_TRUNC_SSAT_S,
  G_TRUNC_SSAT_U,
  G_TRUNC_USAT_U,
  G_CONSTANT,
  G_FCONSTANT,
  G_VASTART,
  G_VAARG,
  G_SEXT,
  G_SEXT_INREG,
  G_ZEXT,
  G_SHL,
  G_LSHR,
  G_ASHR,
  G_FSHL,
  G_FSHR,
  G_ROTR,
  G_ROTL,
  G_ICMP,
  G_FCMP,
  G_SCMP,
  G_UCMP,
  G_SELECT,
  G_UADDO,
  G_UADDE,
  G_USUBO,
  G_USUBE,
  G_SADDO,
  G_SADDE,
  G_SSUBO,
  G_SSUBE,
  G_UMULO,
  G_SMULO,
  G_UMULH,
  G_SMULH,
  G_UADDSAT,
  G_SADDSAT,
  G_USUBSAT,
  G_SSUBSAT,
  G_USHLSAT,
  G_SSHLSAT,
  G_SMULFIX,
  G_UMULFIX,
  G_SMULFIXSAT,
  G_UMULFIXSAT,
  G_SDIVFIX,
  G_UDIVFIX,
  G_SDIVFIXSAT,
  G_UDIVFIXSAT,
  G_FADD,
  G_FSUB,
  G_FMUL,
  G_FMA,
  G_FMAD,
  G_FDIV,
  G_FREM,
  G_FPOW,
  G_FPOWI,
  G_FEXP,
  G_FEXP2,
  G_FEXP10,
  G_FLOG,
  G_FLOG2,
  G_FLOG10,
  G_FLDEXP,
  G_FFREXP,
  G_FNEG,
  G_FPEXT,
  G_FPTRUNC,
  G_FPTOSI,
  G_FPTOUI,
  G_SITOFP,
  G_UITOFP,
  G_FPTOSI_SAT,
  G_FPTOUI_SAT,
  G_FABS,
  G_FCOPYSIGN,
  G_IS_FPCLASS,
  G_FCANONICALIZE,
  G_FMINNUM,
  G_FMAXNUM,
  G_FMINNUM_IEEE,
  G_FMAXNUM_IEEE,
  G_FMINIMUM,
  G_FMAXIMUM,
  G_FMINIMUMNUM,
  G_FMAXIMUMNUM,
  G_GET_FPENV,
  G_SET_FPENV,
  G_RESET_FPENV,
  G_GET_FPMODE,
  G_SET_FPMODE,
  G_RESET_FPMODE,
  G_GET_ROUNDING,
  G_PTR_ADD,
  G_PTRMASK,
  G_SMIN,
  G_SMAX,
  G_UMIN,
  G_UMAX,
  G_ABS,
  G_LROUND,
  G_LLROUND,
  G_BR,
  G_BRJT,
  G_VSCALE,
  G_INSERT_SUBVECTOR,
  G_EXTRACT_SUBVECTOR,
  G_INSERT_VECTOR_ELT,
  G_EXTRACT_VECTOR_ELT,
  G_SHUFFLE_VECTOR,
  G_SPLAT_VECTOR,
  G_STEP_VECTOR,
  G_VECTOR_COMPRESS,
  G_CTTZ,
  G_CTTZ_ZERO_UNDEF,
  G_CTLZ,
  G_CTLZ_ZERO_UNDEF,
  G_CTPOP,
  G_BSWAP,
  G_BITREVERSE,
  G_FCEIL,
  G_FCOS,
  G_FSIN,
  G_FSINCOS,
  G_FTAN,
  G_FACOS,
  G_FASIN,
  G_FATAN,
  G_FATAN2,
  G_FCOSH,
  G_FSINH,
  G_FTANH,
  G_FSQRT,
  G_FFLOOR,
  G_FRINT,
  G_FNEARBYINT,
  G_ADDRSPACE_CAST,
  G_BLOCK_ADDR,
  G_JUMP_TABLE,
  G_DYN_STACKALLOC,
  G_STACKSAVE,
  G_STACKRESTORE,
  G_STRICT_FADD,
  G_STRICT_FSUB,
  G_STRICT_FMUL,
  G_STRICT_FDIV,
  G_STRICT_FREM,
  G_STRICT_FMA,
  G_STRICT_FSQRT,
  G_STRICT_FLDEXP,
  G_READ_REGISTER,
  G_WRITE_REGISTER,
  G_MEMCPY,
  G_MEMCPY_INLINE,
  G_MEMMOVE,
  G_MEMSET,
  G_BZERO,
  G_TRAP,
  G_DEBUGTRAP,
  G_UBSANTRAP,
  G_VECREDUCE_SEQ_FADD,
  G_VECREDUCE_SEQ_FMUL,
  G_VECREDUCE_FADD,
  G_VECREDUCE_FMUL,
  G_VECREDUCE_FMAX,
  G_VECREDUCE_FMIN,
  G_VECREDUCE_FMAXIMUM,
  G_VECREDUCE_FMINIMUM,
  G_VECREDUCE_ADD,
  G_VECREDUCE_MUL,
  G_VECREDUCE_AND,
  G_VECREDUCE_OR,
  G_VECREDUCE_XOR,
  G_VECREDUCE_SMAX,
  G_VECREDUCE_SMIN,
  G_VECREDUCE_UMAX,
  G_VECREDUCE_UMIN,
  G_SBFX,
  G_UBFX,
  ATOMIC_CMP_SWAP_I128,
  ATOMIC_LOAD_ADD_I128,
  ATOMIC_LOAD_AND_I128,
  ATOMIC_LOAD_NAND_I128,
  ATOMIC_LOAD_OR_I128,
  ATOMIC_LOAD_SUB_I128,
  ATOMIC_LOAD_XOR_I128,
  ATOMIC_SWAP_I128,
  BUILD_QUADWORD,
  BUILD_UACC,
  CFENCE,
  CFENCE8,
  CLRLSLDI,
  CLRLSLDI_rec,
  CLRLSLWI,
  CLRLSLWI_rec,
  CLRRDI,
  CLRRDI_rec,
  CLRRWI,
  CLRRWI_rec,
  DCBFL,
  DCBFLP,
  DCBFPS,
  DCBFx,
  DCBSTPS,
  DCBTCT,
  DCBTDS,
  DCBTSTCT,
  DCBTSTDS,
  DCBTSTT,
  DCBTSTx,
  DCBTT,
  DCBTx,
  DFLOADf32,
  DFLOADf64,
  DFSTOREf32,
  DFSTOREf64,
  EXTLDI,
  EXTLDI_rec,
  EXTLWI,
  EXTLWI_rec,
  EXTRDI,
  EXTRDI_rec,
  EXTRWI,
  EXTRWI_rec,
  INSLWI,
  INSLWI_rec,
  INSRDI,
  INSRDI_rec,
  INSRWI,
  INSRWI_rec,
  KILL_PAIR,
  LAx,
  LIWAX,
  LIWZX,
  PPCLdFixedAddr,
  PSUBI,
  RLWIMIbm,
  RLWIMIbm_rec,
  RLWINMbm,
  RLWINMbm_rec,
  RLWNMbm,
  RLWNMbm_rec,
  ROTRDI,
  ROTRDI_rec,
  ROTRWI,
  ROTRWI_rec,
  SLDI,
  SLDI_rec,
  SLWI,
  SLWI_rec,
  SPILLTOVSR_LD,
  SPILLTOVSR_LDX,
  SPILLTOVSR_ST,
  SPILLTOVSR_STX,
  SRDI,
  SRDI_rec,
  SRWI,
  SRWI_rec,
  STIWX,
  SUBI,
  SUBIC,
  SUBIC_rec,
  SUBIS,
  SUBPCIS,
  XFLOADf32,
  XFLOADf64,
  XFSTOREf32,
  XFSTOREf64,
  ADD4,
  ADD4O,
  ADD4O_rec,
  ADD4TLS,
  ADD4_rec,
  ADD8,
  ADD8O,
  ADD8O_rec,
  ADD8TLS,
  ADD8TLS_,
  ADD8_rec,
  ADDC,
  ADDC8,
  ADDC8O,
  ADDC8O_rec,
  ADDC8_rec,
  ADDCO,
  ADDCO_rec,
  ADDC_rec,
  ADDE,
  ADDE8,
  ADDE8O,
  ADDE8O_rec,
  ADDE8_rec,
  ADDEO,
  ADDEO_rec,
  ADDEX,
  ADDEX8,
  ADDE_rec,
  ADDG6S,
  ADDG6S8,
  ADDI,
  ADDI8,
  ADDIC,
  ADDIC8,
  ADDIC_rec,
  ADDIS,
  ADDIS8,
  ADDISdtprelHA,
  ADDISdtprelHA32,
  ADDISgotTprelHA,
  ADDIStlsgdHA,
  ADDIStlsldHA,
  ADDIStocHA,
  ADDIStocHA8,
  ADDIdtprelL,
  ADDIdtprelL32,
  ADDItlsgdL,
  ADDItlsgdL32,
  ADDItlsgdLADDR,
  ADDItlsgdLADDR32,
  ADDItlsldL,
  ADDItlsldL32,
  ADDItlsldLADDR,
  ADDItlsldLADDR32,
  ADDItoc,
  ADDItoc8,
  ADDItocL,
  ADDItocL8,
  ADDME,
  ADDME8,
  ADDME8O,
  ADDME8O_rec,
  ADDME8_rec,
  ADDMEO,
  ADDMEO_rec,
  ADDME_rec,
  ADDPCIS,
  ADDZE,
  ADDZE8,
  ADDZE8O,
  ADDZE8O_rec,
  ADDZE8_rec,
  ADDZEO,
  ADDZEO_rec,
  ADDZE_rec,
  ADJCALLSTACKDOWN,
  ADJCALLSTACKUP,
  AND,
  AND8,
  AND8_rec,
  ANDC,
  ANDC8,
  ANDC8_rec,
  ANDC_rec,
  ANDI8_rec,
  ANDIS8_rec,
  ANDIS_rec,
  ANDI_rec,
  ANDI_rec_1_EQ_BIT,
  ANDI_rec_1_EQ_BIT8,
  ANDI_rec_1_GT_BIT,
  ANDI_rec_1_GT_BIT8,
  AND_rec,
  ATOMIC_CMP_SWAP_I16,
  ATOMIC_CMP_SWAP_I32,
  ATOMIC_CMP_SWAP_I64,
  ATOMIC_CMP_SWAP_I8,
  ATOMIC_LOAD_ADD_I16,
  ATOMIC_LOAD_ADD_I32,
  ATOMIC_LOAD_ADD_I64,
  ATOMIC_LOAD_ADD_I8,
  ATOMIC_LOAD_AND_I16,
  ATOMIC_LOAD_AND_I32,
  ATOMIC_LOAD_AND_I64,
  ATOMIC_LOAD_AND_I8,
  ATOMIC_LOAD_MAX_I16,
  ATOMIC_LOAD_MAX_I32,
  ATOMIC_LOAD_MAX_I64,
  ATOMIC_LOAD_MAX_I8,
  ATOMIC_LOAD_MIN_I16,
  ATOMIC_LOAD_MIN_I32,
  ATOMIC_LOAD_MIN_I64,
  ATOMIC_LOAD_MIN_I8,
  ATOMIC_LOAD_NAND_I16,
  ATOMIC_LOAD_NAND_I32,
  ATOMIC_LOAD_NAND_I64,
  ATOMIC_LOAD_NAND_I8,
  ATOMIC_LOAD_OR_I16,
  ATOMIC_LOAD_OR_I32,
  ATOMIC_LOAD_OR_I64,
  ATOMIC_LOAD_OR_I8,
  ATOMIC_LOAD_SUB_I16,
  ATOMIC_LOAD_SUB_I32,
  ATOMIC_LOAD_SUB_I64,
  ATOMIC_LOAD_SUB_I8,
  ATOMIC_LOAD_UMAX_I16,
  ATOMIC_LOAD_UMAX_I32,
  ATOMIC_LOAD_UMAX_I64,
  ATOMIC_LOAD_UMAX_I8,
  ATOMIC_LOAD_UMIN_I16,
  ATOMIC_LOAD_UMIN_I32,
  ATOMIC_LOAD_UMIN_I64,
  ATOMIC_LOAD_UMIN_I8,
  ATOMIC_LOAD_XOR_I16,
  ATOMIC_LOAD_XOR_I32,
  ATOMIC_LOAD_XOR_I64,
  ATOMIC_LOAD_XOR_I8,
  ATOMIC_SWAP_I16,
  ATOMIC_SWAP_I32,
  ATOMIC_SWAP_I64,
  ATOMIC_SWAP_I8,
  ATTN,
  B,
  BA,
  BC,
  BCC,
  BCCA,
  BCCCTR,
  BCCCTR8,
  BCCCTRL,
  BCCCTRL8,
  BCCL,
  BCCLA,
  BCCLR,
  BCCLRL,
  BCCTR,
  BCCTR8,
  BCCTR8n,
  BCCTRL,
  BCCTRL8,
  BCCTRL8n,
  BCCTRLn,
  BCCTRn,
  BCDADD_rec,
  BCDCFN_rec,
  BCDCFSQ_rec,
  BCDCFZ_rec,
  BCDCPSGN_rec,
  BCDCTN_rec,
  BCDCTSQ_rec,
  BCDCTZ_rec,
  BCDSETSGN_rec,
  BCDSR_rec,
  BCDSUB_rec,
  BCDS_rec,
  BCDTRUNC_rec,
  BCDUS_rec,
  BCDUTRUNC_rec,
  BCL,
  BCLR,
  BCLRL,
  BCLRLn,
  BCLRn,
  BCLalways,
  BCLn,
  BCTR,
  BCTR8,
  BCTRL,
  BCTRL8,
  BCTRL8_LDinto_toc,
  BCTRL8_LDinto_toc_RM,
  BCTRL8_RM,
  BCTRL_LWZinto_toc,
  BCTRL_LWZinto_toc_RM,
  BCTRL_RM,
  BCn,
  BDNZ,
  BDNZ8,
  BDNZA,
  BDNZAm,
  BDNZAp,
  BDNZL,
  BDNZLA,
  BDNZLAm,
  BDNZLAp,
  BDNZLR,
  BDNZLR8,
  BDNZLRL,
  BDNZLRLm,
  BDNZLRLp,
  BDNZLRm,
  BDNZLRp,
  BDNZLm,
  BDNZLp,
  BDNZm,
  BDNZp,
  BDZ,
  BDZ8,
  BDZA,
  BDZAm,
  BDZAp,
  BDZL,
  BDZLA,
  BDZLAm,
  BDZLAp,
  BDZLR,
  BDZLR8,
  BDZLRL,
  BDZLRLm,
  BDZLRLp,
  BDZLRm,
  BDZLRp,
  BDZLm,
  BDZLp,
  BDZm,
  BDZp,
  BL,
  BL8,
  BL8_NOP,
  BL8_NOP_RM,
  BL8_NOP_TLS,
  BL8_NOTOC,
  BL8_NOTOC_RM,
  BL8_NOTOC_TLS,
  BL8_RM,
  BL8_TLS,
  BL8_TLS_,
  BLA,
  BLA8,
  BLA8_NOP,
  BLA8_NOP_RM,
  BLA8_RM,
  BLA_RM,
  BLR,
  BLR8,
  BLRL,
  BL_NOP,
  BL_NOP_RM,
  BL_RM,
  BL_TLS,
  BPERMD,
  BRD,
  BRH,
  BRH8,
  BRINC,
  BRW,
  BRW8,
  CBCDTD,
  CBCDTD8,
  CDTBCD,
  CDTBCD8,
  CFUGED,
  CLRBHRB,
  CMPB,
  CMPB8,
  CMPD,
  CMPDI,
  CMPEQB,
  CMPLD,
  CMPLDI,
  CMPLW,
  CMPLWI,
  CMPRB,
  CMPRB8,
  CMPW,
  CMPWI,
  CNTLZD,
  CNTLZDM,
  CNTLZD_rec,
  CNTLZW,
  CNTLZW8,
  CNTLZW8_rec,
  CNTLZW_rec,
  CNTTZD,
  CNTTZDM,
  CNTTZD_rec,
  CNTTZW,
  CNTTZW8,
  CNTTZW8_rec,
  CNTTZW_rec,
  CP_ABORT,
  CP_COPY,
  CP_COPY8,
  CP_PASTE8_rec,
  CP_PASTE_rec,
  CR6SET,
  CR6UNSET,
  CRAND,
  CRANDC,
  CREQV,
  CRNAND,
  CRNOR,
  CRNOT,
  CROR,
  CRORC,
  CRSET,
  CRUNSET,
  CRXOR,
  CTRL_DEP,
  DADD,
  DADDQ,
  DADDQ_rec,
  DADD_rec,
  DARN,
  DCBA,
  DCBF,
  DCBFEP,
  DCBI,
  DCBST,
  DCBSTEP,
  DCBT,
  DCBTEP,
  DCBTST,
  DCBTSTEP,
  DCBZ,
  DCBZEP,
  DCBZL,
  DCBZLEP,
  DCCCI,
  DCFFIX,
  DCFFIXQ,
  DCFFIXQQ,
  DCFFIXQ_rec,
  DCFFIX_rec,
  DCMPO,
  DCMPOQ,
  DCMPU,
  DCMPUQ,
  DCTDP,
  DCTDP_rec,
  DCTFIX,
  DCTFIXQ,
  DCTFIXQQ,
  DCTFIXQ_rec,
  DCTFIX_rec,
  DCTQPQ,
  DCTQPQ_rec,
  DDEDPD,
  DDEDPDQ,
  DDEDPDQ_rec,
  DDEDPD_rec,
  DDIV,
  DDIVQ,
  DDIVQ_rec,
  DDIV_rec,
  DENBCD,
  DENBCDQ,
  DENBCDQ_rec,
  DENBCD_rec,
  DIEX,
  DIEXQ,
  DIEXQ_rec,
  DIEX_rec,
  DIVD,
  DIVDE,
  DIVDEO,
  DIVDEO_rec,
  DIVDEU,
  DIVDEUO,
  DIVDEUO_rec,
  DIVDEU_rec,
  DIVDE_rec,
  DIVDO,
  DIVDO_rec,
  DIVDU,
  DIVDUO,
  DIVDUO_rec,
  DIVDU_rec,
  DIVD_rec,
  DIVW,
  DIVWE,
  DIVWEO,
  DIVWEO_rec,
  DIVWEU,
  DIVWEUO,
  DIVWEUO_rec,
  DIVWEU_rec,
  DIVWE_rec,
  DIVWO,
  DIVWO_rec,
  DIVWU,
  DIVWUO,
  DIVWUO_rec,
  DIVWU_rec,
  DIVW_rec,
  DMMR,
  DMSETDMRZ,
  DMSHA2HASH,
  DMSHA3HASH,
  DMUL,
  DMULQ,
  DMULQ_rec,
  DMUL_rec,
  DMXOR,
  DMXVBF16GERX2,
  DMXVBF16GERX2NN,
  DMXVBF16GERX2NP,
  DMXVBF16GERX2PN,
  DMXVBF16GERX2PP,
  DMXVF16GERX2,
  DMXVF16GERX2NN,
  DMXVF16GERX2NP,
  DMXVF16GERX2PN,
  DMXVF16GERX2PP,
  DMXVI8GERX4,
  DMXVI8GERX4PP,
  DMXVI8GERX4SPP,
  DMXXEXTFDMR256,
  DMXXEXTFDMR512,
  DMXXEXTFDMR512_HI,
  DMXXINSTDMR256,
  DMXXINSTDMR512,
  DMXXINSTDMR512_HI,
  DMXXSETACCZ,
  DMXXSHAPAD,
  DQUA,
  DQUAI,
  DQUAIQ,
  DQUAIQ_rec,
  DQUAI_rec,
  DQUAQ,
  DQUAQ_rec,
  DQUA_rec,
  DRDPQ,
  DRDPQ_rec,
  DRINTN,
  DRINTNQ,
  DRINTNQ_rec,
  DRINTN_rec,
  DRINTX,
  DRINTXQ,
  DRINTXQ_rec,
  DRINTX_rec,
  DRRND,
  DRRNDQ,
  DRRNDQ_rec,
  DRRND_rec,
  DRSP,
  DRSP_rec,
  DSCLI,
  DSCLIQ,
  DSCLIQ_rec,
  DSCLI_rec,
  DSCRI,
  DSCRIQ,
  DSCRIQ_rec,
  DSCRI_rec,
  DSS,
  DSSALL,
  DST,
  DST64,
  DSTST,
  DSTST64,
  DSTSTT,
  DSTSTT64,
  DSTT,
  DSTT64,
  DSUB,
  DSUBQ,
  DSUBQ_rec,
  DSUB_rec,
  DTSTDC,
  DTSTDCQ,
  DTSTDG,
  DTSTDGQ,
  DTSTEX,
  DTSTEXQ,
  DTSTSF,
  DTSTSFI,
  DTSTSFIQ,
  DTSTSFQ,
  DXEX,
  DXEXQ,
  DXEXQ_rec,
  DXEX_rec,
  DYNALLOC,
  DYNALLOC8,
  DYNAREAOFFSET,
  DYNAREAOFFSET8,
  DecreaseCTR8loop,
  DecreaseCTRloop,
  EFDABS,
  EFDADD,
  EFDCFS,
  EFDCFSF,
  EFDCFSI,
  EFDCFSID,
  EFDCFUF,
  EFDCFUI,
  EFDCFUID,
  EFDCMPEQ,
  EFDCMPGT,
  EFDCMPLT,
  EFDCTSF,
  EFDCTSI,
  EFDCTSIDZ,
  EFDCTSIZ,
  EFDCTUF,
  EFDCTUI,
  EFDCTUIDZ,
  EFDCTUIZ,
  EFDDIV,
  EFDMUL,
  EFDNABS,
  EFDNEG,
  EFDSUB,
  EFDTSTEQ,
  EFDTSTGT,
  EFDTSTLT,
  EFSABS,
  EFSADD,
  EFSCFD,
  EFSCFSF,
  EFSCFSI,
  EFSCFUF,
  EFSCFUI,
  EFSCMPEQ,
  EFSCMPGT,
  EFSCMPLT,
  EFSCTSF,
  EFSCTSI,
  EFSCTSIZ,
  EFSCTUF,
  EFSCTUI,
  EFSCTUIZ,
  EFSDIV,
  EFSMUL,
  EFSNABS,
  EFSNEG,
  EFSSUB,
  EFSTSTEQ,
  EFSTSTGT,
  EFSTSTLT,
  EH_SjLj_LongJmp32,
  EH_SjLj_LongJmp64,
  EH_SjLj_SetJmp32,
  EH_SjLj_SetJmp64,
  EH_SjLj_Setup,
  EQV,
  EQV8,
  EQV8_rec,
  EQV_rec,
  EVABS,
  EVADDIW,
  EVADDSMIAAW,
  EVADDSSIAAW,
  EVADDUMIAAW,
  EVADDUSIAAW,
  EVADDW,
  EVAND,
  EVANDC,
  EVCMPEQ,
  EVCMPGTS,
  EVCMPGTU,
  EVCMPLTS,
  EVCMPLTU,
  EVCNTLSW,
  EVCNTLZW,
  EVDIVWS,
  EVDIVWU,
  EVEQV,
  EVEXTSB,
  EVEXTSH,
  EVFSABS,
  EVFSADD,
  EVFSCFSF,
  EVFSCFSI,
  EVFSCFUF,
  EVFSCFUI,
  EVFSCMPEQ,
  EVFSCMPGT,
  EVFSCMPLT,
  EVFSCTSF,
  EVFSCTSI,
  EVFSCTSIZ,
  EVFSCTUF,
  EVFSCTUI,
  EVFSCTUIZ,
  EVFSDIV,
  EVFSMUL,
  EVFSNABS,
  EVFSNEG,
  EVFSSUB,
  EVFSTSTEQ,
  EVFSTSTGT,
  EVFSTSTLT,
  EVLDD,
  EVLDDX,
  EVLDH,
  EVLDHX,
  EVLDW,
  EVLDWX,
  EVLHHESPLAT,
  EVLHHESPLATX,
  EVLHHOSSPLAT,
  EVLHHOSSPLATX,
  EVLHHOUSPLAT,
  EVLHHOUSPLATX,
  EVLWHE,
  EVLWHEX,
  EVLWHOS,
  EVLWHOSX,
  EVLWHOU,
  EVLWHOUX,
  EVLWHSPLAT,
  EVLWHSPLATX,
  EVLWWSPLAT,
  EVLWWSPLATX,
  EVMERGEHI,
  EVMERGEHILO,
  EVMERGELO,
  EVMERGELOHI,
  EVMHEGSMFAA,
  EVMHEGSMFAN,
  EVMHEGSMIAA,
  EVMHEGSMIAN,
  EVMHEGUMIAA,
  EVMHEGUMIAN,
  EVMHESMF,
  EVMHESMFA,
  EVMHESMFAAW,
  EVMHESMFANW,
  EVMHESMI,
  EVMHESMIA,
  EVMHESMIAAW,
  EVMHESMIANW,
  EVMHESSF,
  EVMHESSFA,
  EVMHESSFAAW,
  EVMHESSFANW,
  EVMHESSIAAW,
  EVMHESSIANW,
  EVMHEUMI,
  EVMHEUMIA,
  EVMHEUMIAAW,
  EVMHEUMIANW,
  EVMHEUSIAAW,
  EVMHEUSIANW,
  EVMHOGSMFAA,
  EVMHOGSMFAN,
  EVMHOGSMIAA,
  EVMHOGSMIAN,
  EVMHOGUMIAA,
  EVMHOGUMIAN,
  EVMHOSMF,
  EVMHOSMFA,
  EVMHOSMFAAW,
  EVMHOSMFANW,
  EVMHOSMI,
  EVMHOSMIA,
  EVMHOSMIAAW,
  EVMHOSMIANW,
  EVMHOSSF,
  EVMHOSSFA,
  EVMHOSSFAAW,
  EVMHOSSFANW,
  EVMHOSSIAAW,
  EVMHOSSIANW,
  EVMHOUMI,
  EVMHOUMIA,
  EVMHOUMIAAW,
  EVMHOUMIANW,
  EVMHOUSIAAW,
  EVMHOUSIANW,
  EVMRA,
  EVMWHSMF,
  EVMWHSMFA,
  EVMWHSMI,
  EVMWHSMIA,
  EVMWHSSF,
  EVMWHSSFA,
  EVMWHUMI,
  EVMWHUMIA,
  EVMWLSMIAAW,
  EVMWLSMIANW,
  EVMWLSSIAAW,
  EVMWLSSIANW,
  EVMWLUMI,
  EVMWLUMIA,
  EVMWLUMIAAW,
  EVMWLUMIANW,
  EVMWLUSIAAW,
  EVMWLUSIANW,
  EVMWSMF,
  EVMWSMFA,
  EVMWSMFAA,
  EVMWSMFAN,
  EVMWSMI,
  EVMWSMIA,
  EVMWSMIAA,
  EVMWSMIAN,
  EVMWSSF,
  EVMWSSFA,
  EVMWSSFAA,
  EVMWSSFAN,
  EVMWUMI,
  EVMWUMIA,
  EVMWUMIAA,
  EVMWUMIAN,
  EVNAND,
  EVNEG,
  EVNOR,
  EVOR,
  EVORC,
  EVRLW,
  EVRLWI,
  EVRNDW,
  EVSEL,
  EVSLW,
  EVSLWI,
  EVSPLATFI,
  EVSPLATI,
  EVSRWIS,
  EVSRWIU,
  EVSRWS,
  EVSRWU,
  EVSTDD,
  EVSTDDX,
  EVSTDH,
  EVSTDHX,
  EVSTDW,
  EVSTDWX,
  EVSTWHE,
  EVSTWHEX,
  EVSTWHO,
  EVSTWHOX,
  EVSTWWE,
  EVSTWWEX,
  EVSTWWO,
  EVSTWWOX,
  EVSUBFSMIAAW,
  EVSUBFSSIAAW,
  EVSUBFUMIAAW,
  EVSUBFUSIAAW,
  EVSUBFW,
  EVSUBIFW,
  EVXOR,
  EXTSB,
  EXTSB8,
  EXTSB8_32_64,
  EXTSB8_rec,
  EXTSB_rec,
  EXTSH,
  EXTSH8,
  EXTSH8_32_64,
  EXTSH8_rec,
  EXTSH_rec,
  EXTSW,
  EXTSWSLI,
  EXTSWSLI_32_64,
  EXTSWSLI_32_64_rec,
  EXTSWSLI_rec,
  EXTSW_32,
  EXTSW_32_64,
  EXTSW_32_64_rec,
  EXTSW_rec,
  EnforceIEIO,
  FABSD,
  FABSD_rec,
  FABSS,
  FABSS_rec,
  FADD,
  FADDS,
  FADDS_rec,
  FADD_rec,
  FADDrtz,
  FCFID,
  FCFIDS,
  FCFIDS_rec,
  FCFIDU,
  FCFIDUS,
  FCFIDUS_rec,
  FCFIDU_rec,
  FCFID_rec,
  FCMPOD,
  FCMPOS,
  FCMPUD,
  FCMPUS,
  FCPSGND,
  FCPSGND_rec,
  FCPSGNS,
  FCPSGNS_rec,
  FCTID,
  FCTIDU,
  FCTIDUZ,
  FCTIDUZ_rec,
  FCTIDU_rec,
  FCTIDZ,
  FCTIDZ_rec,
  FCTID_rec,
  FCTIW,
  FCTIWU,
  FCTIWUZ,
  FCTIWUZ_rec,
  FCTIWU_rec,
  FCTIWZ,
  FCTIWZ_rec,
  FCTIW_rec,
  FDIV,
  FDIVS,
  FDIVS_rec,
  FDIV_rec,
  FENCE,
  FMADD,
  FMADDS,
  FMADDS_rec,
  FMADD_rec,
  FMR,
  FMR_rec,
  FMSUB,
  FMSUBS,
  FMSUBS_rec,
  FMSUB_rec,
  FMUL,
  FMULS,
  FMULS_rec,
  FMUL_rec,
  FNABSD,
  FNABSD_rec,
  FNABSS,
  FNABSS_rec,
  FNEGD,
  FNEGD_rec,
  FNEGS,
  FNEGS_rec,
  FNMADD,
  FNMADDS,
  FNMADDS_rec,
  FNMADD_rec,
  FNMSUB,
  FNMSUBS,
  FNMSUBS_rec,
  FNMSUB_rec,
  FRE,
  FRES,
  FRES_rec,
  FRE_rec,
  FRIMD,
  FRIMD_rec,
  FRIMS,
  FRIMS_rec,
  FRIND,
  FRIND_rec,
  FRINS,
  FRINS_rec,
  FRIPD,
  FRIPD_rec,
  FRIPS,
  FRIPS_rec,
  FRIZD,
  FRIZD_rec,
  FRIZS,
  FRIZS_rec,
  FRSP,
  FRSP_rec,
  FRSQRTE,
  FRSQRTES,
  FRSQRTES_rec,
  FRSQRTE_rec,
  FSELD,
  FSELD_rec,
  FSELS,
  FSELS_rec,
  FSQRT,
  FSQRTS,
  FSQRTS_rec,
  FSQRT_rec,
  FSUB,
  FSUBS,
  FSUBS_rec,
  FSUB_rec,
  FTDIV,
  FTSQRT,
  GETtlsADDR,
  GETtlsADDR32,
  GETtlsADDR32AIX,
  GETtlsADDR64AIX,
  GETtlsADDRPCREL,
  GETtlsMOD32AIX,
  GETtlsMOD64AIX,
  GETtlsTpointer32AIX,
  GETtlsldADDR,
  GETtlsldADDR32,
  GETtlsldADDRPCREL,
  HASHCHK,
  HASHCHK8,
  HASHCHKP,
  HASHCHKP8,
  HASHST,
  HASHST8,
  HASHSTP,
  HASHSTP8,
  HRFID,
  ICBI,
  ICBIEP,
  ICBLC,
  ICBLQ,
  ICBT,
  ICBTLS,
  ICCCI,
  ISEL,
  ISEL8,
  ISYNC,
  LA,
  LA8,
  LBARX,
  LBARXL,
  LBEPX,
  LBZ,
  LBZ8,
  LBZCIX,
  LBZU,
  LBZU8,
  LBZUX,
  LBZUX8,
  LBZX,
  LBZX8,
  LBZXTLS,
  LBZXTLS_,
  LBZXTLS_32,
  LD,
  LDARX,
  LDARXL,
  LDAT,
  LDBRX,
  LDCIX,
  LDU,
  LDUX,
  LDX,
  LDXTLS,
  LDXTLS_,
  LDgotTprelL,
  LDgotTprelL32,
  LDtoc,
  LDtocBA,
  LDtocCPT,
  LDtocJTI,
  LDtocL,
  LFD,
  LFDEPX,
  LFDU,
  LFDUX,
  LFDX,
  LFDXTLS,
  LFDXTLS_,
  LFIWAX,
  LFIWZX,
  LFS,
  LFSU,
  LFSUX,
  LFSX,
  LFSXTLS,
  LFSXTLS_,
  LHA,
  LHA8,
  LHARX,
  LHARXL,
  LHAU,
  LHAU8,
  LHAUX,
  LHAUX8,
  LHAX,
  LHAX8,
  LHAXTLS,
  LHAXTLS_,
  LHAXTLS_32,
  LHBRX,
  LHBRX8,
  LHEPX,
  LHZ,
  LHZ8,
  LHZCIX,
  LHZU,
  LHZU8,
  LHZUX,
  LHZUX8,
  LHZX,
  LHZX8,
  LHZXTLS,
  LHZXTLS_,
  LHZXTLS_32,
  LI,
  LI8,
  LIS,
  LIS8,
  LMW,
  LQ,
  LQARX,
  LQARXL,
  LQX_PSEUDO,
  LSWI,
  LVEBX,
  LVEHX,
  LVEWX,
  LVSL,
  LVSR,
  LVX,
  LVXL,
  LWA,
  LWARX,
  LWARXL,
  LWAT,
  LWAUX,
  LWAX,
  LWAXTLS,
  LWAXTLS_,
  LWAXTLS_32,
  LWAX_32,
  LWA_32,
  LWBRX,
  LWBRX8,
  LWEPX,
  LWZ,
  LWZ8,
  LWZCIX,
  LWZU,
  LWZU8,
  LWZUX,
  LWZUX8,
  LWZX,
  LWZX8,
  LWZXTLS,
  LWZXTLS_,
  LWZXTLS_32,
  LWZtoc,
  LWZtocL,
  LXSD,
  LXSDX,
  LXSIBZX,
  LXSIHZX,
  LXSIWAX,
  LXSIWZX,
  LXSSP,
  LXSSPX,
  LXV,
  LXVB16X,
  LXVD2X,
  LXVDSX,
  LXVH8X,
  LXVKQ,
  LXVL,
  LXVLL,
  LXVP,
  LXVPRL,
  LXVPRLL,
  LXVPX,
  LXVRBX,
  LXVRDX,
  LXVRHX,
  LXVRL,
  LXVRLL,
  LXVRWX,
  LXVW4X,
  LXVWSX,
  LXVX,
  MADDHD,
  MADDHDU,
  MADDLD,
  MADDLD8,
  MBAR,
  MCRF,
  MCRFS,
  MCRXRX,
  MFBHRBE,
  MFCR,
  MFCR8,
  MFCTR,
  MFCTR8,
  MFDCR,
  MFFS,
  MFFSCDRN,
  MFFSCDRNI,
  MFFSCE,
  MFFSCRN,
  MFFSCRNI,
  MFFSL,
  MFFS_rec,
  MFLR,
  MFLR8,
  MFMSR,
  MFOCRF,
  MFOCRF8,
  MFPMR,
  MFSPR,
  MFSPR8,
  MFSR,
  MFSRIN,
  MFTB,
  MFTB8,
  MFUDSCR,
  MFVRD,
  MFVRSAVE,
  MFVRSAVEv,
  MFVRWZ,
  MFVSCR,
  MFVSRD,
  MFVSRLD,
  MFVSRWZ,
  MODSD,
  MODSW,
  MODUD,
  MODUW,
  MSGSYNC,
  MSYNC,
  MTCRF,
  MTCRF8,
  MTCTR,
  MTCTR8,
  MTCTR8loop,
  MTCTRloop,
  MTDCR,
  MTFSB0,
  MTFSB1,
  MTFSF,
  MTFSFI,
  MTFSFI_rec,
  MTFSFIb,
  MTFSF_rec,
  MTFSFb,
  MTLR,
  MTLR8,
  MTMSR,
  MTMSRD,
  MTOCRF,
  MTOCRF8,
  MTPMR,
  MTSPR,
  MTSPR8,
  MTSR,
  MTSRIN,
  MTUDSCR,
  MTVRD,
  MTVRSAVE,
  MTVRSAVEv,
  MTVRWA,
  MTVRWZ,
  MTVSCR,
  MTVSRBM,
  MTVSRBMI,
  MTVSRD,
  MTVSRDD,
  MTVSRDM,
  MTVSRHM,
  MTVSRQM,
  MTVSRWA,
  MTVSRWM,
  MTVSRWS,
  MTVSRWZ,
  MULHD,
  MULHDU,
  MULHDU_rec,
  MULHD_rec,
  MULHW,
  MULHWU,
  MULHWU_rec,
  MULHW_rec,
  MULLD,
  MULLDO,
  MULLDO_rec,
  MULLD_rec,
  MULLI,
  MULLI8,
  MULLW,
  MULLWO,
  MULLWO_rec,
  MULLW_rec,
  MoveGOTtoLR,
  MovePCtoLR,
  MovePCtoLR8,
  NAND,
  NAND8,
  NAND8_rec,
  NAND_rec,
  NAP,
  NEG,
  NEG8,
  NEG8O,
  NEG8O_rec,
  NEG8_rec,
  NEGO,
  NEGO_rec,
  NEG_rec,
  NOP,
  NOP_GT_PWR6,
  NOP_GT_PWR7,
  NOR,
  NOR8,
  NOR8_rec,
  NOR_rec,
  OR,
  OR8,
  OR8_rec,
  ORC,
  ORC8,
  ORC8_rec,
  ORC_rec,
  ORI,
  ORI8,
  ORIS,
  ORIS8,
  OR_rec,
  PADDI,
  PADDI8,
  PADDI8pc,
  PADDIdtprel,
  PADDIpc,
  PDEPD,
  PEXTD,
  PLA,
  PLA8,
  PLA8pc,
  PLApc,
  PLBZ,
  PLBZ8,
  PLBZ8nopc,
  PLBZ8onlypc,
  PLBZ8pc,
  PLBZnopc,
  PLBZonlypc,
  PLBZpc,
  PLD,
  PLDnopc,
  PLDonlypc,
  PLDpc,
  PLFD,
  PLFDnopc,
  PLFDonlypc,
  PLFDpc,
  PLFS,
  PLFSnopc,
  PLFSonlypc,
  PLFSpc,
  PLHA,
  PLHA8,
  PLHA8nopc,
  PLHA8onlypc,
  PLHA8pc,
  PLHAnopc,
  PLHAonlypc,
  PLHApc,
  PLHZ,
  PLHZ8,
  PLHZ8nopc,
  PLHZ8onlypc,
  PLHZ8pc,
  PLHZnopc,
  PLHZonlypc,
  PLHZpc,
  PLI,
  PLI8,
  PLWA,
  PLWA8,
  PLWA8nopc,
  PLWA8onlypc,
  PLWA8pc,
  PLWAnopc,
  PLWAonlypc,
  PLWApc,
  PLWZ,
  PLWZ8,
  PLWZ8nopc,
  PLWZ8onlypc,
  PLWZ8pc,
  PLWZnopc,
  PLWZonlypc,
  PLWZpc,
  PLXSD,
  PLXSDnopc,
  PLXSDonlypc,
  PLXSDpc,
  PLXSSP,
  PLXSSPnopc,
  PLXSSPonlypc,
  PLXSSPpc,
  PLXV,
  PLXVP,
  PLXVPnopc,
  PLXVPonlypc,
  PLXVPpc,
  PLXVnopc,
  PLXVonlypc,
  PLXVpc,
  PMDMXVBF16GERX2,
  PMDMXVBF16GERX2NN,
  PMDMXVBF16GERX2NP,
  PMDMXVBF16GERX2PN,
  PMDMXVBF16GERX2PP,
  PMDMXVF16GERX2,
  PMDMXVF16GERX2NN,
  PMDMXVF16GERX2NP,
  PMDMXVF16GERX2PN,
  PMDMXVF16GERX2PP,
  PMDMXVI8GERX4,
  PMDMXVI8GERX4PP,
  PMDMXVI8GERX4SPP,
  PMXVBF16GER2,
  PMXVBF16GER2NN,
  PMXVBF16GER2NP,
  PMXVBF16GER2PN,
  PMXVBF16GER2PP,
  PMXVBF16GER2W,
  PMXVBF16GER2WNN,
  PMXVBF16GER2WNP,
  PMXVBF16GER2WPN,
  PMXVBF16GER2WPP,
  PMXVF16GER2,
  PMXVF16GER2NN,
  PMXVF16GER2NP,
  PMXVF16GER2PN,
  PMXVF16GER2PP,
  PMXVF16GER2W,
  PMXVF16GER2WNN,
  PMXVF16GER2WNP,
  PMXVF16GER2WPN,
  PMXVF16GER2WPP,
  PMXVF32GER,
  PMXVF32GERNN,
  PMXVF32GERNP,
  PMXVF32GERPN,
  PMXVF32GERPP,
  PMXVF32GERW,
  PMXVF32GERWNN,
  PMXVF32GERWNP,
  PMXVF32GERWPN,
  PMXVF32GERWPP,
  PMXVF64GER,
  PMXVF64GERNN,
  PMXVF64GERNP,
  PMXVF64GERPN,
  PMXVF64GERPP,
  PMXVF64GERW,
  PMXVF64GERWNN,
  PMXVF64GERWNP,
  PMXVF64GERWPN,
  PMXVF64GERWPP,
  PMXVI16GER2,
  PMXVI16GER2PP,
  PMXVI16GER2S,
  PMXVI16GER2SPP,
  PMXVI16GER2SW,
  PMXVI16GER2SWPP,
  PMXVI16GER2W,
  PMXVI16GER2WPP,
  PMXVI4GER8,
  PMXVI4GER8PP,
  PMXVI4GER8W,
  PMXVI4GER8WPP,
  PMXVI8GER4,
  PMXVI8GER4PP,
  PMXVI8GER4SPP,
  PMXVI8GER4W,
  PMXVI8GER4WPP,
  PMXVI8GER4WSPP,
  POPCNTB,
  POPCNTB8,
  POPCNTD,
  POPCNTW,
  PPC32GOT,
  PPC32PICGOT,
  PREPARE_PROBED_ALLOCA_32,
  PREPARE_PROBED_ALLOCA_64,
  PREPARE_PROBED_ALLOCA_NEGSIZE_SAME_REG_32,
  PREPARE_PROBED_ALLOCA_NEGSIZE_SAME_REG_64,
  PROBED_ALLOCA_32,
  PROBED_ALLOCA_64,
  PROBED_STACKALLOC_32,
  PROBED_STACKALLOC_64,
  PSTB,
  PSTB8,
  PSTB8nopc,
  PSTB8onlypc,
  PSTB8pc,
  PSTBnopc,
  PSTBonlypc,
  PSTBpc,
  PSTD,
  PSTDnopc,
  PSTDonlypc,
  PSTDpc,
  PSTFD,
  PSTFDnopc,
  PSTFDonlypc,
  PSTFDpc,
  PSTFS,
  PSTFSnopc,
  PSTFSonlypc,
  PSTFSpc,
  PSTH,
  PSTH8,
  PSTH8nopc,
  PSTH8onlypc,
  PSTH8pc,
  PSTHnopc,
  PSTHonlypc,
  PSTHpc,
  PSTW,
  PSTW8,
  PSTW8nopc,
  PSTW8onlypc,
  PSTW8pc,
  PSTWnopc,
  PSTWonlypc,
  PSTWpc,
  PSTXSD,
  PSTXSDnopc,
  PSTXSDonlypc,
  PSTXSDpc,
  PSTXSSP,
  PSTXSSPnopc,
  PSTXSSPonlypc,
  PSTXSSPpc,
  PSTXV,
  PSTXVP,
  PSTXVPnopc,
  PSTXVPonlypc,
  PSTXVPpc,
  PSTXVnopc,
  PSTXVonlypc,
  PSTXVpc,
  PseudoEIEIO,
  RESTORE_ACC,
  RESTORE_CR,
  RESTORE_CRBIT,
  RESTORE_DMR,
  RESTORE_DMRP,
  RESTORE_QUADWORD,
  RESTORE_UACC,
  RESTORE_WACC,
  RFCI,
  RFDI,
  RFEBB,
  RFI,
  RFID,
  RFMCI,
  RLDCL,
  RLDCL_rec,
  RLDCR,
  RLDCR_rec,
  RLDIC,
  RLDICL,
  RLDICL_32,
  RLDICL_32_64,
  RLDICL_32_rec,
  RLDICL_rec,
  RLDICR,
  RLDICR_32,
  RLDICR_rec,
  RLDIC_rec,
  RLDIMI,
  RLDIMI_rec,
  RLWIMI,
  RLWIMI8,
  RLWIMI8_rec,
  RLWIMI_rec,
  RLWINM,
  RLWINM8,
  RLWINM8_rec,
  RLWINM_rec,
  RLWNM,
  RLWNM8,
  RLWNM8_rec,
  RLWNM_rec,
  ReadTB,
  SC,
  SCV,
  SELECT_CC_F16,
  SELECT_CC_F4,
  SELECT_CC_F8,
  SELECT_CC_I4,
  SELECT_CC_I8,
  SELECT_CC_SPE,
  SELECT_CC_SPE4,
  SELECT_CC_VRRC,
  SELECT_CC_VSFRC,
  SELECT_CC_VSRC,
  SELECT_CC_VSSRC,
  SELECT_F16,
  SELECT_F4,
  SELECT_F8,
  SELECT_I4,
  SELECT_I8,
  SELECT_SPE,
  SELECT_SPE4,
  SELECT_VRRC,
  SELECT_VSFRC,
  SELECT_VSRC,
  SELECT_VSSRC,
  SETB,
  SETB8,
  SETBC,
  SETBC8,
  SETBCR,
  SETBCR8,
  SETFLM,
  SETNBC,
  SETNBC8,
  SETNBCR,
  SETNBCR8,
  SETRND,
  SETRNDi,
  SLBFEE_rec,
  SLBIA,
  SLBIE,
  SLBIEG,
  SLBMFEE,
  SLBMFEV,
  SLBMTE,
  SLBSYNC,
  SLD,
  SLD_rec,
  SLW,
  SLW8,
  SLW8_rec,
  SLW_rec,
  SPELWZ,
  SPELWZX,
  SPESTW,
  SPESTWX,
  SPILL_ACC,
  SPILL_CR,
  SPILL_CRBIT,
  SPILL_DMR,
  SPILL_DMRP,
  SPILL_QUADWORD,
  SPILL_UACC,
  SPILL_WACC,
  SPLIT_QUADWORD,
  SRAD,
  SRADI,
  SRADI_32,
  SRADI_rec,
  SRAD_rec,
  SRAW,
  SRAW8,
  SRAW8_rec,
  SRAWI,
  SRAWI8,
  SRAWI8_rec,
  SRAWI_rec,
  SRAW_rec,
  SRD,
  SRD_rec,
  SRW,
  SRW8,
  SRW8_rec,
  SRW_rec,
  STB,
  STB8,
  STBCIX,
  STBCX,
  STBEPX,
  STBU,
  STBU8,
  STBUX,
  STBUX8,
  STBX,
  STBX8,
  STBXTLS,
  STBXTLS_,
  STBXTLS_32,
  STD,
  STDAT,
  STDBRX,
  STDCIX,
  STDCX,
  STDU,
  STDUX,
  STDX,
  STDXTLS,
  STDXTLS_,
  STFD,
  STFDEPX,
  STFDU,
  STFDUX,
  STFDX,
  STFDXTLS,
  STFDXTLS_,
  STFIWX,
  STFS,
  STFSU,
  STFSUX,
  STFSX,
  STFSXTLS,
  STFSXTLS_,
  STH,
  STH8,
  STHBRX,
  STHCIX,
  STHCX,
  STHEPX,
  STHU,
  STHU8,
  STHUX,
  STHUX8,
  STHX,
  STHX8,
  STHXTLS,
  STHXTLS_,
  STHXTLS_32,
  STMW,
  STOP,
  STQ,
  STQCX,
  STQX_PSEUDO,
  STSWI,
  STVEBX,
  STVEHX,
  STVEWX,
  STVX,
  STVXL,
  STW,
  STW8,
  STWAT,
  STWBRX,
  STWCIX,
  STWCX,
  STWEPX,
  STWU,
  STWU8,
  STWUX,
  STWUX8,
  STWX,
  STWX8,
  STWXTLS,
  STWXTLS_,
  STWXTLS_32,
  STXSD,
  STXSDX,
  STXSIBX,
  STXSIBXv,
  STXSIHX,
  STXSIHXv,
  STXSIWX,
  STXSSP,
  STXSSPX,
  STXV,
  STXVB16X,
  STXVD2X,
  STXVH8X,
  STXVL,
  STXVLL,
  STXVP,
  STXVPRL,
  STXVPRLL,
  STXVPX,
  STXVRBX,
  STXVRDX,
  STXVRHX,
  STXVRL,
  STXVRLL,
  STXVRWX,
  STXVW4X,
  STXVX,
  SUBF,
  SUBF8,
  SUBF8O,
  SUBF8O_rec,
  SUBF8_rec,
  SUBFC,
  SUBFC8,
  SUBFC8O,
  SUBFC8O_rec,
  SUBFC8_rec,
  SUBFCO,
  SUBFCO_rec,
  SUBFC_rec,
  SUBFE,
  SUBFE8,
  SUBFE8O,
  SUBFE8O_rec,
  SUBFE8_rec,
  SUBFEO,
  SUBFEO_rec,
  SUBFE_rec,
  SUBFIC,
  SUBFIC8,
  SUBFME,
  SUBFME8,
  SUBFME8O,
  SUBFME8O_rec,
  SUBFME8_rec,
  SUBFMEO,
  SUBFMEO_rec,
  SUBFME_rec,
  SUBFO,
  SUBFO_rec,
  SUBFUS,
  SUBFUS_rec,
  SUBFZE,
  SUBFZE8,
  SUBFZE8O,
  SUBFZE8O_rec,
  SUBFZE8_rec,
  SUBFZEO,
  SUBFZEO_rec,
  SUBFZE_rec,
  SUBF_rec,
  SYNC,
  SYNCP10,
  TABORT,
  TABORTDC,
  TABORTDCI,
  TABORTWC,
  TABORTWCI,
  TAILB,
  TAILB8,
  TAILBA,
  TAILBA8,
  TAILBCTR,
  TAILBCTR8,
  TBEGIN,
  TBEGIN_RET,
  TCHECK,
  TCHECK_RET,
  TCRETURNai,
  TCRETURNai8,
  TCRETURNdi,
  TCRETURNdi8,
  TCRETURNri,
  TCRETURNri8,
  TD,
  TDI,
  TEND,
  TLBIA,
  TLBIE,
  TLBIEL,
  TLBILX,
  TLBIVAX,
  TLBLD,
  TLBLI,
  TLBRE,
  TLBRE2,
  TLBSX,
  TLBSX2,
  TLBSX2D,
  TLBSYNC,
  TLBWE,
  TLBWE2,
  TLSGDAIX,
  TLSGDAIX8,
  TLSLDAIX,
  TLSLDAIX8,
  TRAP,
  TRECHKPT,
  TRECLAIM,
  TSR,
  TW,
  TWI,
  UNENCODED_NOP,
  UpdateGBR,
  VABSDUB,
  VABSDUH,
  VABSDUW,
  VADDCUQ,
  VADDCUW,
  VADDECUQ,
  VADDEUQM,
  VADDFP,
  VADDSBS,
  VADDSHS,
  VADDSWS,
  VADDUBM,
  VADDUBS,
  VADDUDM,
  VADDUHM,
  VADDUHS,
  VADDUQM,
  VADDUWM,
  VADDUWS,
  VAND,
  VANDC,
  VAVGSB,
  VAVGSH,
  VAVGSW,
  VAVGUB,
  VAVGUH,
  VAVGUW,
  VBPERMD,
  VBPERMQ,
  VCFSX,
  VCFSX_0,
  VCFUGED,
  VCFUX,
  VCFUX_0,
  VCIPHER,
  VCIPHERLAST,
  VCLRLB,
  VCLRRB,
  VCLZB,
  VCLZD,
  VCLZDM,
  VCLZH,
  VCLZLSBB,
  VCLZW,
  VCMPBFP,
  VCMPBFP_rec,
  VCMPEQFP,
  VCMPEQFP_rec,
  VCMPEQUB,
  VCMPEQUB_rec,
  VCMPEQUD,
  VCMPEQUD_rec,
  VCMPEQUH,
  VCMPEQUH_rec,
  VCMPEQUQ,
  VCMPEQUQ_rec,
  VCMPEQUW,
  VCMPEQUW_rec,
  VCMPGEFP,
  VCMPGEFP_rec,
  VCMPGTFP,
  VCMPGTFP_rec,
  VCMPGTSB,
  VCMPGTSB_rec,
  VCMPGTSD,
  VCMPGTSD_rec,
  VCMPGTSH,
  VCMPGTSH_rec,
  VCMPGTSQ,
  VCMPGTSQ_rec,
  VCMPGTSW,
  VCMPGTSW_rec,
  VCMPGTUB,
  VCMPGTUB_rec,
  VCMPGTUD,
  VCMPGTUD_rec,
  VCMPGTUH,
  VCMPGTUH_rec,
  VCMPGTUQ,
  VCMPGTUQ_rec,
  VCMPGTUW,
  VCMPGTUW_rec,
  VCMPNEB,
  VCMPNEB_rec,
  VCMPNEH,
  VCMPNEH_rec,
  VCMPNEW,
  VCMPNEW_rec,
  VCMPNEZB,
  VCMPNEZB_rec,
  VCMPNEZH,
  VCMPNEZH_rec,
  VCMPNEZW,
  VCMPNEZW_rec,
  VCMPSQ,
  VCMPUQ,
  VCNTMBB,
  VCNTMBD,
  VCNTMBH,
  VCNTMBW,
  VCTSXS,
  VCTSXS_0,
  VCTUXS,
  VCTUXS_0,
  VCTZB,
  VCTZD,
  VCTZDM,
  VCTZH,
  VCTZLSBB,
  VCTZW,
  VDIVESD,
  VDIVESQ,
  VDIVESW,
  VDIVEUD,
  VDIVEUQ,
  VDIVEUW,
  VDIVSD,
  VDIVSQ,
  VDIVSW,
  VDIVUD,
  VDIVUQ,
  VDIVUW,
  VEQV,
  VEXPANDBM,
  VEXPANDDM,
  VEXPANDHM,
  VEXPANDQM,
  VEXPANDWM,
  VEXPTEFP,
  VEXTDDVLX,
  VEXTDDVRX,
  VEXTDUBVLX,
  VEXTDUBVRX,
  VEXTDUHVLX,
  VEXTDUHVRX,
  VEXTDUWVLX,
  VEXTDUWVRX,
  VEXTRACTBM,
  VEXTRACTD,
  VEXTRACTDM,
  VEXTRACTHM,
  VEXTRACTQM,
  VEXTRACTUB,
  VEXTRACTUH,
  VEXTRACTUW,
  VEXTRACTWM,
  VEXTSB2D,
  VEXTSB2Ds,
  VEXTSB2W,
  VEXTSB2Ws,
  VEXTSD2Q,
  VEXTSH2D,
  VEXTSH2Ds,
  VEXTSH2W,
  VEXTSH2Ws,
  VEXTSW2D,
  VEXTSW2Ds,
  VEXTUBLX,
  VEXTUBRX,
  VEXTUHLX,
  VEXTUHRX,
  VEXTUWLX,
  VEXTUWRX,
  VGBBD,
  VGNB,
  VINSBLX,
  VINSBRX,
  VINSBVLX,
  VINSBVRX,
  VINSD,
  VINSDLX,
  VINSDRX,
  VINSERTB,
  VINSERTD,
  VINSERTH,
  VINSERTW,
  VINSHLX,
  VINSHRX,
  VINSHVLX,
  VINSHVRX,
  VINSW,
  VINSWLX,
  VINSWRX,
  VINSWVLX,
  VINSWVRX,
  VLOGEFP,
  VMADDFP,
  VMAXFP,
  VMAXSB,
  VMAXSD,
  VMAXSH,
  VMAXSW,
  VMAXUB,
  VMAXUD,
  VMAXUH,
  VMAXUW,
  VMHADDSHS,
  VMHRADDSHS,
  VMINFP,
  VMINSB,
  VMINSD,
  VMINSH,
  VMINSW,
  VMINUB,
  VMINUD,
  VMINUH,
  VMINUW,
  VMLADDUHM,
  VMODSD,
  VMODSQ,
  VMODSW,
  VMODUD,
  VMODUQ,
  VMODUW,
  VMRGEW,
  VMRGHB,
  VMRGHH,
  VMRGHW,
  VMRGLB,
  VMRGLH,
  VMRGLW,
  VMRGOW,
  VMSUMCUD,
  VMSUMMBM,
  VMSUMSHM,
  VMSUMSHS,
  VMSUMUBM,
  VMSUMUDM,
  VMSUMUHM,
  VMSUMUHS,
  VMUL10CUQ,
  VMUL10ECUQ,
  VMUL10EUQ,
  VMUL10UQ,
  VMULESB,
  VMULESD,
  VMULESH,
  VMULESW,
  VMULEUB,
  VMULEUD,
  VMULEUH,
  VMULEUW,
  VMULHSD,
  VMULHSW,
  VMULHUD,
  VMULHUW,
  VMULLD,
  VMULOSB,
  VMULOSD,
  VMULOSH,
  VMULOSW,
  VMULOUB,
  VMULOUD,
  VMULOUH,
  VMULOUW,
  VMULUWM,
  VNAND,
  VNCIPHER,
  VNCIPHERLAST,
  VNEGD,
  VNEGW,
  VNMSUBFP,
  VNOR,
  VOR,
  VORC,
  VPDEPD,
  VPERM,
  VPERMR,
  VPERMXOR,
  VPEXTD,
  VPKPX,
  VPKSDSS,
  VPKSDUS,
  VPKSHSS,
  VPKSHUS,
  VPKSWSS,
  VPKSWUS,
  VPKUDUM,
  VPKUDUS,
  VPKUHUM,
  VPKUHUS,
  VPKUWUM,
  VPKUWUS,
  VPMSUMB,
  VPMSUMD,
  VPMSUMH,
  VPMSUMW,
  VPOPCNTB,
  VPOPCNTD,
  VPOPCNTH,
  VPOPCNTW,
  VPRTYBD,
  VPRTYBQ,
  VPRTYBW,
  VREFP,
  VRFIM,
  VRFIN,
  VRFIP,
  VRFIZ,
  VRLB,
  VRLD,
  VRLDMI,
  VRLDNM,
  VRLH,
  VRLQ,
  VRLQMI,
  VRLQNM,
  VRLW,
  VRLWMI,
  VRLWNM,
  VRSQRTEFP,
  VSBOX,
  VSEL,
  VSHASIGMAD,
  VSHASIGMAW,
  VSL,
  VSLB,
  VSLD,
  VSLDBI,
  VSLDOI,
  VSLH,
  VSLO,
  VSLQ,
  VSLV,
  VSLW,
  VSPLTB,
  VSPLTBs,
  VSPLTH,
  VSPLTHs,
  VSPLTISB,
  VSPLTISH,
  VSPLTISW,
  VSPLTW,
  VSR,
  VSRAB,
  VSRAD,
  VSRAH,
  VSRAQ,
  VSRAW,
  VSRB,
  VSRD,
  VSRDBI,
  VSRH,
  VSRO,
  VSRQ,
  VSRV,
  VSRW,
  VSTRIBL,
  VSTRIBL_rec,
  VSTRIBR,
  VSTRIBR_rec,
  VSTRIHL,
  VSTRIHL_rec,
  VSTRIHR,
  VSTRIHR_rec,
  VSUBCUQ,
  VSUBCUW,
  VSUBECUQ,
  VSUBEUQM,
  VSUBFP,
  VSUBSBS,
  VSUBSHS,
  VSUBSWS,
  VSUBUBM,
  VSUBUBS,
  VSUBUDM,
  VSUBUHM,
  VSUBUHS,
  VSUBUQM,
  VSUBUWM,
  VSUBUWS,
  VSUM2SWS,
  VSUM4SBS,
  VSUM4SHS,
  VSUM4UBS,
  VSUMSWS,
  VUPKHPX,
  VUPKHSB,
  VUPKHSH,
  VUPKHSW,
  VUPKLPX,
  VUPKLSB,
  VUPKLSH,
  VUPKLSW,
  VXOR,
  V_SET0,
  V_SET0B,
  V_SET0H,
  V_SETALLONES,
  V_SETALLONESB,
  V_SETALLONESH,
  WAIT,
  WAITP10,
  WRTEE,
  WRTEEI,
  XOR,
  XOR8,
  XOR8_rec,
  XORI,
  XORI8,
  XORIS,
  XORIS8,
  XOR_rec,
  XSABSDP,
  XSABSQP,
  XSADDDP,
  XSADDQP,
  XSADDQPO,
  XSADDSP,
  XSCMPEQDP,
  XSCMPEQQP,
  XSCMPEXPDP,
  XSCMPEXPQP,
  XSCMPGEDP,
  XSCMPGEQP,
  XSCMPGTDP,
  XSCMPGTQP,
  XSCMPODP,
  XSCMPOQP,
  XSCMPUDP,
  XSCMPUQP,
  XSCPSGNDP,
  XSCPSGNQP,
  XSCVDPHP,
  XSCVDPQP,
  XSCVDPSP,
  XSCVDPSPN,
  XSCVDPSXDS,
  XSCVDPSXDSs,
  XSCVDPSXWS,
  XSCVDPSXWSs,
  XSCVDPUXDS,
  XSCVDPUXDSs,
  XSCVDPUXWS,
  XSCVDPUXWSs,
  XSCVHPDP,
  XSCVQPDP,
  XSCVQPDPO,
  XSCVQPSDZ,
  XSCVQPSQZ,
  XSCVQPSWZ,
  XSCVQPUDZ,
  XSCVQPUQZ,
  XSCVQPUWZ,
  XSCVSDQP,
  XSCVSPDP,
  XSCVSPDPN,
  XSCVSQQP,
  XSCVSXDDP,
  XSCVSXDSP,
  XSCVUDQP,
  XSCVUQQP,
  XSCVUXDDP,
  XSCVUXDSP,
  XSDIVDP,
  XSDIVQP,
  XSDIVQPO,
  XSDIVSP,
  XSIEXPDP,
  XSIEXPQP,
  XSMADDADP,
  XSMADDASP,
  XSMADDMDP,
  XSMADDMSP,
  XSMADDQP,
  XSMADDQPO,
  XSMAXCDP,
  XSMAXCQP,
  XSMAXDP,
  XSMAXJDP,
  XSMINCDP,
  XSMINCQP,
  XSMINDP,
  XSMINJDP,
  XSMSUBADP,
  XSMSUBASP,
  XSMSUBMDP,
  XSMSUBMSP,
  XSMSUBQP,
  XSMSUBQPO,
  XSMULDP,
  XSMULQP,
  XSMULQPO,
  XSMULSP,
  XSNABSDP,
  XSNABSDPs,
  XSNABSQP,
  XSNEGDP,
  XSNEGQP,
  XSNMADDADP,
  XSNMADDASP,
  XSNMADDMDP,
  XSNMADDMSP,
  XSNMADDQP,
  XSNMADDQPO,
  XSNMSUBADP,
  XSNMSUBASP,
  XSNMSUBMDP,
  XSNMSUBMSP,
  XSNMSUBQP,
  XSNMSUBQPO,
  XSRDPI,
  XSRDPIC,
  XSRDPIM,
  XSRDPIP,
  XSRDPIZ,
  XSREDP,
  XSRESP,
  XSRQPI,
  XSRQPIX,
  XSRQPXP,
  XSRSP,
  XSRSQRTEDP,
  XSRSQRTESP,
  XSSQRTDP,
  XSSQRTQP,
  XSSQRTQPO,
  XSSQRTSP,
  XSSUBDP,
  XSSUBQP,
  XSSUBQPO,
  XSSUBSP,
  XSTDIVDP,
  XSTSQRTDP,
  XSTSTDCDP,
  XSTSTDCQP,
  XSTSTDCSP,
  XSXEXPDP,
  XSXEXPQP,
  XSXSIGDP,
  XSXSIGQP,
  XVABSDP,
  XVABSSP,
  XVADDDP,
  XVADDSP,
  XVBF16GER2,
  XVBF16GER2NN,
  XVBF16GER2NP,
  XVBF16GER2PN,
  XVBF16GER2PP,
  XVBF16GER2W,
  XVBF16GER2WNN,
  XVBF16GER2WNP,
  XVBF16GER2WPN,
  XVBF16GER2WPP,
  XVCMPEQDP,
  XVCMPEQDP_rec,
  XVCMPEQSP,
  XVCMPEQSP_rec,
  XVCMPGEDP,
  XVCMPGEDP_rec,
  XVCMPGESP,
  XVCMPGESP_rec,
  XVCMPGTDP,
  XVCMPGTDP_rec,
  XVCMPGTSP,
  XVCMPGTSP_rec,
  XVCPSGNDP,
  XVCPSGNSP,
  XVCVBF16SPN,
  XVCVDPSP,
  XVCVDPSXDS,
  XVCVDPSXWS,
  XVCVDPUXDS,
  XVCVDPUXWS,
  XVCVHPSP,
  XVCVSPBF16,
  XVCVSPDP,
  XVCVSPHP,
  XVCVSPSXDS,
  XVCVSPSXWS,
  XVCVSPUXDS,
  XVCVSPUXWS,
  XVCVSXDDP,
  XVCVSXDSP,
  XVCVSXWDP,
  XVCVSXWSP,
  XVCVUXDDP,
  XVCVUXDSP,
  XVCVUXWDP,
  XVCVUXWSP,
  XVDIVDP,
  XVDIVSP,
  XVF16GER2,
  XVF16GER2NN,
  XVF16GER2NP,
  XVF16GER2PN,
  XVF16GER2PP,
  XVF16GER2W,
  XVF16GER2WNN,
  XVF16GER2WNP,
  XVF16GER2WPN,
  XVF16GER2WPP,
  XVF32GER,
  XVF32GERNN,
  XVF32GERNP,
  XVF32GERPN,
  XVF32GERPP,
  XVF32GERW,
  XVF32GERWNN,
  XVF32GERWNP,
  XVF32GERWPN,
  XVF32GERWPP,
  XVF64GER,
  XVF64GERNN,
  XVF64GERNP,
  XVF64GERPN,
  XVF64GERPP,
  XVF64GERW,
  XVF64GERWNN,
  XVF64GERWNP,
  XVF64GERWPN,
  XVF64GERWPP,
  XVI16GER2,
  XVI16GER2PP,
  XVI16GER2S,
  XVI16GER2SPP,
  XVI16GER2SW,
  XVI16GER2SWPP,
  XVI16GER2W,
  XVI16GER2WPP,
  XVI4GER8,
  XVI4GER8PP,
  XVI4GER8W,
  XVI4GER8WPP,
  XVI8GER4,
  XVI8GER4PP,
  XVI8GER4SPP,
  XVI8GER4W,
  XVI8GER4WPP,
  XVI8GER4WSPP,
  XVIEXPDP,
  XVIEXPSP,
  XVMADDADP,
  XVMADDASP,
  XVMADDMDP,
  XVMADDMSP,
  XVMAXDP,
  XVMAXSP,
  XVMINDP,
  XVMINSP,
  XVMSUBADP,
  XVMSUBASP,
  XVMSUBMDP,
  XVMSUBMSP,
  XVMULDP,
  XVMULSP,
  XVNABSDP,
  XVNABSSP,
  XVNEGDP,
  XVNEGSP,
  XVNMADDADP,
  XVNMADDASP,
  XVNMADDMDP,
  XVNMADDMSP,
  XVNMSUBADP,
  XVNMSUBASP,
  XVNMSUBMDP,
  XVNMSUBMSP,
  XVRDPI,
  XVRDPIC,
  XVRDPIM,
  XVRDPIP,
  XVRDPIZ,
  XVREDP,
  XVRESP,
  XVRSPI,
  XVRSPIC,
  XVRSPIM,
  XVRSPIP,
  XVRSPIZ,
  XVRSQRTEDP,
  XVRSQRTESP,
  XVSQRTDP,
  XVSQRTSP,
  XVSUBDP,
  XVSUBSP,
  XVTDIVDP,
  XVTDIVSP,
  XVTLSBB,
  XVTSQRTDP,
  XVTSQRTSP,
  XVTSTDCDP,
  XVTSTDCSP,
  XVXEXPDP,
  XVXEXPSP,
  XVXSIGDP,
  XVXSIGSP,
  XXBLENDVB,
  XXBLENDVD,
  XXBLENDVH,
  XXBLENDVW,
  XXBRD,
  XXBRH,
  XXBRQ,
  XXBRW,
  XXEVAL,
  XXEXTRACTUW,
  XXGENPCVBM,
  XXGENPCVDM,
  XXGENPCVHM,
  XXGENPCVWM,
  XXINSERTW,
  XXLAND,
  XXLANDC,
  XXLEQV,
  XXLEQVOnes,
  XXLNAND,
  XXLNOR,
  XXLOR,
  XXLORC,
  XXLORf,
  XXLXOR,
  XXLXORdpz,
  XXLXORspz,
  XXLXORz,
  XXMFACC,
  XXMFACCW,
  XXMRGHW,
  XXMRGLW,
  XXMTACC,
  XXMTACCW,
  XXPERM,
  XXPERMDI,
  XXPERMDIs,
  XXPERMR,
  XXPERMX,
  XXSEL,
  XXSETACCZ,
  XXSLDWI,
  XXSLDWIs,
  XXSPLTI32DX,
  XXSPLTIB,
  XXSPLTIDP,
  XXSPLTIW,
  XXSPLTW,
  XXSPLTWs,
  gBC,
  gBCA,
  gBCAat,
  gBCCTR,
  gBCCTRL,
  gBCL,
  gBCLA,
  gBCLAat,
  gBCLR,
  gBCLRL,
  gBCLat,
  gBCat,
  INSTRUCTION_LIST_END,
  UNKNOWN(u64),
}

impl From<u64> for Opcode {
    fn from(value: u64) -> Self {
        match value {
          0 => Opcode::PHI,
          1 => Opcode::INLINEASM,
          2 => Opcode::INLINEASM_BR,
          3 => Opcode::CFI_INSTRUCTION,
          4 => Opcode::EH_LABEL,
          5 => Opcode::GC_LABEL,
          6 => Opcode::ANNOTATION_LABEL,
          7 => Opcode::KILL,
          8 => Opcode::EXTRACT_SUBREG,
          9 => Opcode::INSERT_SUBREG,
          10 => Opcode::IMPLICIT_DEF,
          11 => Opcode::INIT_UNDEF,
          12 => Opcode::SUBREG_TO_REG,
          13 => Opcode::COPY_TO_REGCLASS,
          14 => Opcode::DBG_VALUE,
          15 => Opcode::DBG_VALUE_LIST,
          16 => Opcode::DBG_INSTR_REF,
          17 => Opcode::DBG_PHI,
          18 => Opcode::DBG_LABEL,
          19 => Opcode::REG_SEQUENCE,
          20 => Opcode::COPY,
          21 => Opcode::BUNDLE,
          22 => Opcode::LIFETIME_START,
          23 => Opcode::LIFETIME_END,
          24 => Opcode::PSEUDO_PROBE,
          25 => Opcode::ARITH_FENCE,
          26 => Opcode::STACKMAP,
          27 => Opcode::FENTRY_CALL,
          28 => Opcode::PATCHPOINT,
          29 => Opcode::LOAD_STACK_GUARD,
          30 => Opcode::PREALLOCATED_SETUP,
          31 => Opcode::PREALLOCATED_ARG,
          32 => Opcode::STATEPOINT,
          33 => Opcode::LOCAL_ESCAPE,
          34 => Opcode::FAULTING_OP,
          35 => Opcode::PATCHABLE_OP,
          36 => Opcode::PATCHABLE_FUNCTION_ENTER,
          37 => Opcode::PATCHABLE_RET,
          38 => Opcode::PATCHABLE_FUNCTION_EXIT,
          39 => Opcode::PATCHABLE_TAIL_CALL,
          40 => Opcode::PATCHABLE_EVENT_CALL,
          41 => Opcode::PATCHABLE_TYPED_EVENT_CALL,
          42 => Opcode::ICALL_BRANCH_FUNNEL,
          43 => Opcode::FAKE_USE,
          44 => Opcode::MEMBARRIER,
          45 => Opcode::JUMP_TABLE_DEBUG_INFO,
          46 => Opcode::CONVERGENCECTRL_ENTRY,
          47 => Opcode::CONVERGENCECTRL_ANCHOR,
          48 => Opcode::CONVERGENCECTRL_LOOP,
          49 => Opcode::CONVERGENCECTRL_GLUE,
          50 => Opcode::G_ASSERT_SEXT,
          51 => Opcode::G_ASSERT_ZEXT,
          52 => Opcode::G_ASSERT_ALIGN,
          53 => Opcode::G_ADD,
          54 => Opcode::G_SUB,
          55 => Opcode::G_MUL,
          56 => Opcode::G_SDIV,
          57 => Opcode::G_UDIV,
          58 => Opcode::G_SREM,
          59 => Opcode::G_UREM,
          60 => Opcode::G_SDIVREM,
          61 => Opcode::G_UDIVREM,
          62 => Opcode::G_AND,
          63 => Opcode::G_OR,
          64 => Opcode::G_XOR,
          65 => Opcode::G_ABDS,
          66 => Opcode::G_ABDU,
          67 => Opcode::G_IMPLICIT_DEF,
          68 => Opcode::G_PHI,
          69 => Opcode::G_FRAME_INDEX,
          70 => Opcode::G_GLOBAL_VALUE,
          71 => Opcode::G_PTRAUTH_GLOBAL_VALUE,
          72 => Opcode::G_CONSTANT_POOL,
          73 => Opcode::G_EXTRACT,
          74 => Opcode::G_UNMERGE_VALUES,
          75 => Opcode::G_INSERT,
          76 => Opcode::G_MERGE_VALUES,
          77 => Opcode::G_BUILD_VECTOR,
          78 => Opcode::G_BUILD_VECTOR_TRUNC,
          79 => Opcode::G_CONCAT_VECTORS,
          80 => Opcode::G_PTRTOINT,
          81 => Opcode::G_INTTOPTR,
          82 => Opcode::G_BITCAST,
          83 => Opcode::G_FREEZE,
          84 => Opcode::G_CONSTANT_FOLD_BARRIER,
          85 => Opcode::G_INTRINSIC_FPTRUNC_ROUND,
          86 => Opcode::G_INTRINSIC_TRUNC,
          87 => Opcode::G_INTRINSIC_ROUND,
          88 => Opcode::G_INTRINSIC_LRINT,
          89 => Opcode::G_INTRINSIC_LLRINT,
          90 => Opcode::G_INTRINSIC_ROUNDEVEN,
          91 => Opcode::G_READCYCLECOUNTER,
          92 => Opcode::G_READSTEADYCOUNTER,
          93 => Opcode::G_LOAD,
          94 => Opcode::G_SEXTLOAD,
          95 => Opcode::G_ZEXTLOAD,
          96 => Opcode::G_INDEXED_LOAD,
          97 => Opcode::G_INDEXED_SEXTLOAD,
          98 => Opcode::G_INDEXED_ZEXTLOAD,
          99 => Opcode::G_STORE,
          100 => Opcode::G_INDEXED_STORE,
          101 => Opcode::G_ATOMIC_CMPXCHG_WITH_SUCCESS,
          102 => Opcode::G_ATOMIC_CMPXCHG,
          103 => Opcode::G_ATOMICRMW_XCHG,
          104 => Opcode::G_ATOMICRMW_ADD,
          105 => Opcode::G_ATOMICRMW_SUB,
          106 => Opcode::G_ATOMICRMW_AND,
          107 => Opcode::G_ATOMICRMW_NAND,
          108 => Opcode::G_ATOMICRMW_OR,
          109 => Opcode::G_ATOMICRMW_XOR,
          110 => Opcode::G_ATOMICRMW_MAX,
          111 => Opcode::G_ATOMICRMW_MIN,
          112 => Opcode::G_ATOMICRMW_UMAX,
          113 => Opcode::G_ATOMICRMW_UMIN,
          114 => Opcode::G_ATOMICRMW_FADD,
          115 => Opcode::G_ATOMICRMW_FSUB,
          116 => Opcode::G_ATOMICRMW_FMAX,
          117 => Opcode::G_ATOMICRMW_FMIN,
          118 => Opcode::G_ATOMICRMW_FMAXIMUM,
          119 => Opcode::G_ATOMICRMW_FMINIMUM,
          120 => Opcode::G_ATOMICRMW_UINC_WRAP,
          121 => Opcode::G_ATOMICRMW_UDEC_WRAP,
          122 => Opcode::G_ATOMICRMW_USUB_COND,
          123 => Opcode::G_ATOMICRMW_USUB_SAT,
          124 => Opcode::G_FENCE,
          125 => Opcode::G_PREFETCH,
          126 => Opcode::G_BRCOND,
          127 => Opcode::G_BRINDIRECT,
          128 => Opcode::G_INVOKE_REGION_START,
          129 => Opcode::G_INTRINSIC,
          130 => Opcode::G_INTRINSIC_W_SIDE_EFFECTS,
          131 => Opcode::G_INTRINSIC_CONVERGENT,
          132 => Opcode::G_INTRINSIC_CONVERGENT_W_SIDE_EFFECTS,
          133 => Opcode::G_ANYEXT,
          134 => Opcode::G_TRUNC,
          135 => Opcode::G_TRUNC_SSAT_S,
          136 => Opcode::G_TRUNC_SSAT_U,
          137 => Opcode::G_TRUNC_USAT_U,
          138 => Opcode::G_CONSTANT,
          139 => Opcode::G_FCONSTANT,
          140 => Opcode::G_VASTART,
          141 => Opcode::G_VAARG,
          142 => Opcode::G_SEXT,
          143 => Opcode::G_SEXT_INREG,
          144 => Opcode::G_ZEXT,
          145 => Opcode::G_SHL,
          146 => Opcode::G_LSHR,
          147 => Opcode::G_ASHR,
          148 => Opcode::G_FSHL,
          149 => Opcode::G_FSHR,
          150 => Opcode::G_ROTR,
          151 => Opcode::G_ROTL,
          152 => Opcode::G_ICMP,
          153 => Opcode::G_FCMP,
          154 => Opcode::G_SCMP,
          155 => Opcode::G_UCMP,
          156 => Opcode::G_SELECT,
          157 => Opcode::G_UADDO,
          158 => Opcode::G_UADDE,
          159 => Opcode::G_USUBO,
          160 => Opcode::G_USUBE,
          161 => Opcode::G_SADDO,
          162 => Opcode::G_SADDE,
          163 => Opcode::G_SSUBO,
          164 => Opcode::G_SSUBE,
          165 => Opcode::G_UMULO,
          166 => Opcode::G_SMULO,
          167 => Opcode::G_UMULH,
          168 => Opcode::G_SMULH,
          169 => Opcode::G_UADDSAT,
          170 => Opcode::G_SADDSAT,
          171 => Opcode::G_USUBSAT,
          172 => Opcode::G_SSUBSAT,
          173 => Opcode::G_USHLSAT,
          174 => Opcode::G_SSHLSAT,
          175 => Opcode::G_SMULFIX,
          176 => Opcode::G_UMULFIX,
          177 => Opcode::G_SMULFIXSAT,
          178 => Opcode::G_UMULFIXSAT,
          179 => Opcode::G_SDIVFIX,
          180 => Opcode::G_UDIVFIX,
          181 => Opcode::G_SDIVFIXSAT,
          182 => Opcode::G_UDIVFIXSAT,
          183 => Opcode::G_FADD,
          184 => Opcode::G_FSUB,
          185 => Opcode::G_FMUL,
          186 => Opcode::G_FMA,
          187 => Opcode::G_FMAD,
          188 => Opcode::G_FDIV,
          189 => Opcode::G_FREM,
          190 => Opcode::G_FPOW,
          191 => Opcode::G_FPOWI,
          192 => Opcode::G_FEXP,
          193 => Opcode::G_FEXP2,
          194 => Opcode::G_FEXP10,
          195 => Opcode::G_FLOG,
          196 => Opcode::G_FLOG2,
          197 => Opcode::G_FLOG10,
          198 => Opcode::G_FLDEXP,
          199 => Opcode::G_FFREXP,
          200 => Opcode::G_FNEG,
          201 => Opcode::G_FPEXT,
          202 => Opcode::G_FPTRUNC,
          203 => Opcode::G_FPTOSI,
          204 => Opcode::G_FPTOUI,
          205 => Opcode::G_SITOFP,
          206 => Opcode::G_UITOFP,
          207 => Opcode::G_FPTOSI_SAT,
          208 => Opcode::G_FPTOUI_SAT,
          209 => Opcode::G_FABS,
          210 => Opcode::G_FCOPYSIGN,
          211 => Opcode::G_IS_FPCLASS,
          212 => Opcode::G_FCANONICALIZE,
          213 => Opcode::G_FMINNUM,
          214 => Opcode::G_FMAXNUM,
          215 => Opcode::G_FMINNUM_IEEE,
          216 => Opcode::G_FMAXNUM_IEEE,
          217 => Opcode::G_FMINIMUM,
          218 => Opcode::G_FMAXIMUM,
          219 => Opcode::G_FMINIMUMNUM,
          220 => Opcode::G_FMAXIMUMNUM,
          221 => Opcode::G_GET_FPENV,
          222 => Opcode::G_SET_FPENV,
          223 => Opcode::G_RESET_FPENV,
          224 => Opcode::G_GET_FPMODE,
          225 => Opcode::G_SET_FPMODE,
          226 => Opcode::G_RESET_FPMODE,
          227 => Opcode::G_GET_ROUNDING,
          228 => Opcode::G_PTR_ADD,
          229 => Opcode::G_PTRMASK,
          230 => Opcode::G_SMIN,
          231 => Opcode::G_SMAX,
          232 => Opcode::G_UMIN,
          233 => Opcode::G_UMAX,
          234 => Opcode::G_ABS,
          235 => Opcode::G_LROUND,
          236 => Opcode::G_LLROUND,
          237 => Opcode::G_BR,
          238 => Opcode::G_BRJT,
          239 => Opcode::G_VSCALE,
          240 => Opcode::G_INSERT_SUBVECTOR,
          241 => Opcode::G_EXTRACT_SUBVECTOR,
          242 => Opcode::G_INSERT_VECTOR_ELT,
          243 => Opcode::G_EXTRACT_VECTOR_ELT,
          244 => Opcode::G_SHUFFLE_VECTOR,
          245 => Opcode::G_SPLAT_VECTOR,
          246 => Opcode::G_STEP_VECTOR,
          247 => Opcode::G_VECTOR_COMPRESS,
          248 => Opcode::G_CTTZ,
          249 => Opcode::G_CTTZ_ZERO_UNDEF,
          250 => Opcode::G_CTLZ,
          251 => Opcode::G_CTLZ_ZERO_UNDEF,
          252 => Opcode::G_CTPOP,
          253 => Opcode::G_BSWAP,
          254 => Opcode::G_BITREVERSE,
          255 => Opcode::G_FCEIL,
          256 => Opcode::G_FCOS,
          257 => Opcode::G_FSIN,
          258 => Opcode::G_FSINCOS,
          259 => Opcode::G_FTAN,
          260 => Opcode::G_FACOS,
          261 => Opcode::G_FASIN,
          262 => Opcode::G_FATAN,
          263 => Opcode::G_FATAN2,
          264 => Opcode::G_FCOSH,
          265 => Opcode::G_FSINH,
          266 => Opcode::G_FTANH,
          267 => Opcode::G_FSQRT,
          268 => Opcode::G_FFLOOR,
          269 => Opcode::G_FRINT,
          270 => Opcode::G_FNEARBYINT,
          271 => Opcode::G_ADDRSPACE_CAST,
          272 => Opcode::G_BLOCK_ADDR,
          273 => Opcode::G_JUMP_TABLE,
          274 => Opcode::G_DYN_STACKALLOC,
          275 => Opcode::G_STACKSAVE,
          276 => Opcode::G_STACKRESTORE,
          277 => Opcode::G_STRICT_FADD,
          278 => Opcode::G_STRICT_FSUB,
          279 => Opcode::G_STRICT_FMUL,
          280 => Opcode::G_STRICT_FDIV,
          281 => Opcode::G_STRICT_FREM,
          282 => Opcode::G_STRICT_FMA,
          283 => Opcode::G_STRICT_FSQRT,
          284 => Opcode::G_STRICT_FLDEXP,
          285 => Opcode::G_READ_REGISTER,
          286 => Opcode::G_WRITE_REGISTER,
          287 => Opcode::G_MEMCPY,
          288 => Opcode::G_MEMCPY_INLINE,
          289 => Opcode::G_MEMMOVE,
          290 => Opcode::G_MEMSET,
          291 => Opcode::G_BZERO,
          292 => Opcode::G_TRAP,
          293 => Opcode::G_DEBUGTRAP,
          294 => Opcode::G_UBSANTRAP,
          295 => Opcode::G_VECREDUCE_SEQ_FADD,
          296 => Opcode::G_VECREDUCE_SEQ_FMUL,
          297 => Opcode::G_VECREDUCE_FADD,
          298 => Opcode::G_VECREDUCE_FMUL,
          299 => Opcode::G_VECREDUCE_FMAX,
          300 => Opcode::G_VECREDUCE_FMIN,
          301 => Opcode::G_VECREDUCE_FMAXIMUM,
          302 => Opcode::G_VECREDUCE_FMINIMUM,
          303 => Opcode::G_VECREDUCE_ADD,
          304 => Opcode::G_VECREDUCE_MUL,
          305 => Opcode::G_VECREDUCE_AND,
          306 => Opcode::G_VECREDUCE_OR,
          307 => Opcode::G_VECREDUCE_XOR,
          308 => Opcode::G_VECREDUCE_SMAX,
          309 => Opcode::G_VECREDUCE_SMIN,
          310 => Opcode::G_VECREDUCE_UMAX,
          311 => Opcode::G_VECREDUCE_UMIN,
          312 => Opcode::G_SBFX,
          313 => Opcode::G_UBFX,
          314 => Opcode::ATOMIC_CMP_SWAP_I128,
          315 => Opcode::ATOMIC_LOAD_ADD_I128,
          316 => Opcode::ATOMIC_LOAD_AND_I128,
          317 => Opcode::ATOMIC_LOAD_NAND_I128,
          318 => Opcode::ATOMIC_LOAD_OR_I128,
          319 => Opcode::ATOMIC_LOAD_SUB_I128,
          320 => Opcode::ATOMIC_LOAD_XOR_I128,
          321 => Opcode::ATOMIC_SWAP_I128,
          322 => Opcode::BUILD_QUADWORD,
          323 => Opcode::BUILD_UACC,
          324 => Opcode::CFENCE,
          325 => Opcode::CFENCE8,
          326 => Opcode::CLRLSLDI,
          327 => Opcode::CLRLSLDI_rec,
          328 => Opcode::CLRLSLWI,
          329 => Opcode::CLRLSLWI_rec,
          330 => Opcode::CLRRDI,
          331 => Opcode::CLRRDI_rec,
          332 => Opcode::CLRRWI,
          333 => Opcode::CLRRWI_rec,
          334 => Opcode::DCBFL,
          335 => Opcode::DCBFLP,
          336 => Opcode::DCBFPS,
          337 => Opcode::DCBFx,
          338 => Opcode::DCBSTPS,
          339 => Opcode::DCBTCT,
          340 => Opcode::DCBTDS,
          341 => Opcode::DCBTSTCT,
          342 => Opcode::DCBTSTDS,
          343 => Opcode::DCBTSTT,
          344 => Opcode::DCBTSTx,
          345 => Opcode::DCBTT,
          346 => Opcode::DCBTx,
          347 => Opcode::DFLOADf32,
          348 => Opcode::DFLOADf64,
          349 => Opcode::DFSTOREf32,
          350 => Opcode::DFSTOREf64,
          351 => Opcode::EXTLDI,
          352 => Opcode::EXTLDI_rec,
          353 => Opcode::EXTLWI,
          354 => Opcode::EXTLWI_rec,
          355 => Opcode::EXTRDI,
          356 => Opcode::EXTRDI_rec,
          357 => Opcode::EXTRWI,
          358 => Opcode::EXTRWI_rec,
          359 => Opcode::INSLWI,
          360 => Opcode::INSLWI_rec,
          361 => Opcode::INSRDI,
          362 => Opcode::INSRDI_rec,
          363 => Opcode::INSRWI,
          364 => Opcode::INSRWI_rec,
          365 => Opcode::KILL_PAIR,
          366 => Opcode::LAx,
          367 => Opcode::LIWAX,
          368 => Opcode::LIWZX,
          369 => Opcode::PPCLdFixedAddr,
          370 => Opcode::PSUBI,
          371 => Opcode::RLWIMIbm,
          372 => Opcode::RLWIMIbm_rec,
          373 => Opcode::RLWINMbm,
          374 => Opcode::RLWINMbm_rec,
          375 => Opcode::RLWNMbm,
          376 => Opcode::RLWNMbm_rec,
          377 => Opcode::ROTRDI,
          378 => Opcode::ROTRDI_rec,
          379 => Opcode::ROTRWI,
          380 => Opcode::ROTRWI_rec,
          381 => Opcode::SLDI,
          382 => Opcode::SLDI_rec,
          383 => Opcode::SLWI,
          384 => Opcode::SLWI_rec,
          385 => Opcode::SPILLTOVSR_LD,
          386 => Opcode::SPILLTOVSR_LDX,
          387 => Opcode::SPILLTOVSR_ST,
          388 => Opcode::SPILLTOVSR_STX,
          389 => Opcode::SRDI,
          390 => Opcode::SRDI_rec,
          391 => Opcode::SRWI,
          392 => Opcode::SRWI_rec,
          393 => Opcode::STIWX,
          394 => Opcode::SUBI,
          395 => Opcode::SUBIC,
          396 => Opcode::SUBIC_rec,
          397 => Opcode::SUBIS,
          398 => Opcode::SUBPCIS,
          399 => Opcode::XFLOADf32,
          400 => Opcode::XFLOADf64,
          401 => Opcode::XFSTOREf32,
          402 => Opcode::XFSTOREf64,
          403 => Opcode::ADD4,
          404 => Opcode::ADD4O,
          405 => Opcode::ADD4O_rec,
          406 => Opcode::ADD4TLS,
          407 => Opcode::ADD4_rec,
          408 => Opcode::ADD8,
          409 => Opcode::ADD8O,
          410 => Opcode::ADD8O_rec,
          411 => Opcode::ADD8TLS,
          412 => Opcode::ADD8TLS_,
          413 => Opcode::ADD8_rec,
          414 => Opcode::ADDC,
          415 => Opcode::ADDC8,
          416 => Opcode::ADDC8O,
          417 => Opcode::ADDC8O_rec,
          418 => Opcode::ADDC8_rec,
          419 => Opcode::ADDCO,
          420 => Opcode::ADDCO_rec,
          421 => Opcode::ADDC_rec,
          422 => Opcode::ADDE,
          423 => Opcode::ADDE8,
          424 => Opcode::ADDE8O,
          425 => Opcode::ADDE8O_rec,
          426 => Opcode::ADDE8_rec,
          427 => Opcode::ADDEO,
          428 => Opcode::ADDEO_rec,
          429 => Opcode::ADDEX,
          430 => Opcode::ADDEX8,
          431 => Opcode::ADDE_rec,
          432 => Opcode::ADDG6S,
          433 => Opcode::ADDG6S8,
          434 => Opcode::ADDI,
          435 => Opcode::ADDI8,
          436 => Opcode::ADDIC,
          437 => Opcode::ADDIC8,
          438 => Opcode::ADDIC_rec,
          439 => Opcode::ADDIS,
          440 => Opcode::ADDIS8,
          441 => Opcode::ADDISdtprelHA,
          442 => Opcode::ADDISdtprelHA32,
          443 => Opcode::ADDISgotTprelHA,
          444 => Opcode::ADDIStlsgdHA,
          445 => Opcode::ADDIStlsldHA,
          446 => Opcode::ADDIStocHA,
          447 => Opcode::ADDIStocHA8,
          448 => Opcode::ADDIdtprelL,
          449 => Opcode::ADDIdtprelL32,
          450 => Opcode::ADDItlsgdL,
          451 => Opcode::ADDItlsgdL32,
          452 => Opcode::ADDItlsgdLADDR,
          453 => Opcode::ADDItlsgdLADDR32,
          454 => Opcode::ADDItlsldL,
          455 => Opcode::ADDItlsldL32,
          456 => Opcode::ADDItlsldLADDR,
          457 => Opcode::ADDItlsldLADDR32,
          458 => Opcode::ADDItoc,
          459 => Opcode::ADDItoc8,
          460 => Opcode::ADDItocL,
          461 => Opcode::ADDItocL8,
          462 => Opcode::ADDME,
          463 => Opcode::ADDME8,
          464 => Opcode::ADDME8O,
          465 => Opcode::ADDME8O_rec,
          466 => Opcode::ADDME8_rec,
          467 => Opcode::ADDMEO,
          468 => Opcode::ADDMEO_rec,
          469 => Opcode::ADDME_rec,
          470 => Opcode::ADDPCIS,
          471 => Opcode::ADDZE,
          472 => Opcode::ADDZE8,
          473 => Opcode::ADDZE8O,
          474 => Opcode::ADDZE8O_rec,
          475 => Opcode::ADDZE8_rec,
          476 => Opcode::ADDZEO,
          477 => Opcode::ADDZEO_rec,
          478 => Opcode::ADDZE_rec,
          479 => Opcode::ADJCALLSTACKDOWN,
          480 => Opcode::ADJCALLSTACKUP,
          481 => Opcode::AND,
          482 => Opcode::AND8,
          483 => Opcode::AND8_rec,
          484 => Opcode::ANDC,
          485 => Opcode::ANDC8,
          486 => Opcode::ANDC8_rec,
          487 => Opcode::ANDC_rec,
          488 => Opcode::ANDI8_rec,
          489 => Opcode::ANDIS8_rec,
          490 => Opcode::ANDIS_rec,
          491 => Opcode::ANDI_rec,
          492 => Opcode::ANDI_rec_1_EQ_BIT,
          493 => Opcode::ANDI_rec_1_EQ_BIT8,
          494 => Opcode::ANDI_rec_1_GT_BIT,
          495 => Opcode::ANDI_rec_1_GT_BIT8,
          496 => Opcode::AND_rec,
          497 => Opcode::ATOMIC_CMP_SWAP_I16,
          498 => Opcode::ATOMIC_CMP_SWAP_I32,
          499 => Opcode::ATOMIC_CMP_SWAP_I64,
          500 => Opcode::ATOMIC_CMP_SWAP_I8,
          501 => Opcode::ATOMIC_LOAD_ADD_I16,
          502 => Opcode::ATOMIC_LOAD_ADD_I32,
          503 => Opcode::ATOMIC_LOAD_ADD_I64,
          504 => Opcode::ATOMIC_LOAD_ADD_I8,
          505 => Opcode::ATOMIC_LOAD_AND_I16,
          506 => Opcode::ATOMIC_LOAD_AND_I32,
          507 => Opcode::ATOMIC_LOAD_AND_I64,
          508 => Opcode::ATOMIC_LOAD_AND_I8,
          509 => Opcode::ATOMIC_LOAD_MAX_I16,
          510 => Opcode::ATOMIC_LOAD_MAX_I32,
          511 => Opcode::ATOMIC_LOAD_MAX_I64,
          512 => Opcode::ATOMIC_LOAD_MAX_I8,
          513 => Opcode::ATOMIC_LOAD_MIN_I16,
          514 => Opcode::ATOMIC_LOAD_MIN_I32,
          515 => Opcode::ATOMIC_LOAD_MIN_I64,
          516 => Opcode::ATOMIC_LOAD_MIN_I8,
          517 => Opcode::ATOMIC_LOAD_NAND_I16,
          518 => Opcode::ATOMIC_LOAD_NAND_I32,
          519 => Opcode::ATOMIC_LOAD_NAND_I64,
          520 => Opcode::ATOMIC_LOAD_NAND_I8,
          521 => Opcode::ATOMIC_LOAD_OR_I16,
          522 => Opcode::ATOMIC_LOAD_OR_I32,
          523 => Opcode::ATOMIC_LOAD_OR_I64,
          524 => Opcode::ATOMIC_LOAD_OR_I8,
          525 => Opcode::ATOMIC_LOAD_SUB_I16,
          526 => Opcode::ATOMIC_LOAD_SUB_I32,
          527 => Opcode::ATOMIC_LOAD_SUB_I64,
          528 => Opcode::ATOMIC_LOAD_SUB_I8,
          529 => Opcode::ATOMIC_LOAD_UMAX_I16,
          530 => Opcode::ATOMIC_LOAD_UMAX_I32,
          531 => Opcode::ATOMIC_LOAD_UMAX_I64,
          532 => Opcode::ATOMIC_LOAD_UMAX_I8,
          533 => Opcode::ATOMIC_LOAD_UMIN_I16,
          534 => Opcode::ATOMIC_LOAD_UMIN_I32,
          535 => Opcode::ATOMIC_LOAD_UMIN_I64,
          536 => Opcode::ATOMIC_LOAD_UMIN_I8,
          537 => Opcode::ATOMIC_LOAD_XOR_I16,
          538 => Opcode::ATOMIC_LOAD_XOR_I32,
          539 => Opcode::ATOMIC_LOAD_XOR_I64,
          540 => Opcode::ATOMIC_LOAD_XOR_I8,
          541 => Opcode::ATOMIC_SWAP_I16,
          542 => Opcode::ATOMIC_SWAP_I32,
          543 => Opcode::ATOMIC_SWAP_I64,
          544 => Opcode::ATOMIC_SWAP_I8,
          545 => Opcode::ATTN,
          546 => Opcode::B,
          547 => Opcode::BA,
          548 => Opcode::BC,
          549 => Opcode::BCC,
          550 => Opcode::BCCA,
          551 => Opcode::BCCCTR,
          552 => Opcode::BCCCTR8,
          553 => Opcode::BCCCTRL,
          554 => Opcode::BCCCTRL8,
          555 => Opcode::BCCL,
          556 => Opcode::BCCLA,
          557 => Opcode::BCCLR,
          558 => Opcode::BCCLRL,
          559 => Opcode::BCCTR,
          560 => Opcode::BCCTR8,
          561 => Opcode::BCCTR8n,
          562 => Opcode::BCCTRL,
          563 => Opcode::BCCTRL8,
          564 => Opcode::BCCTRL8n,
          565 => Opcode::BCCTRLn,
          566 => Opcode::BCCTRn,
          567 => Opcode::BCDADD_rec,
          568 => Opcode::BCDCFN_rec,
          569 => Opcode::BCDCFSQ_rec,
          570 => Opcode::BCDCFZ_rec,
          571 => Opcode::BCDCPSGN_rec,
          572 => Opcode::BCDCTN_rec,
          573 => Opcode::BCDCTSQ_rec,
          574 => Opcode::BCDCTZ_rec,
          575 => Opcode::BCDSETSGN_rec,
          576 => Opcode::BCDSR_rec,
          577 => Opcode::BCDSUB_rec,
          578 => Opcode::BCDS_rec,
          579 => Opcode::BCDTRUNC_rec,
          580 => Opcode::BCDUS_rec,
          581 => Opcode::BCDUTRUNC_rec,
          582 => Opcode::BCL,
          583 => Opcode::BCLR,
          584 => Opcode::BCLRL,
          585 => Opcode::BCLRLn,
          586 => Opcode::BCLRn,
          587 => Opcode::BCLalways,
          588 => Opcode::BCLn,
          589 => Opcode::BCTR,
          590 => Opcode::BCTR8,
          591 => Opcode::BCTRL,
          592 => Opcode::BCTRL8,
          593 => Opcode::BCTRL8_LDinto_toc,
          594 => Opcode::BCTRL8_LDinto_toc_RM,
          595 => Opcode::BCTRL8_RM,
          596 => Opcode::BCTRL_LWZinto_toc,
          597 => Opcode::BCTRL_LWZinto_toc_RM,
          598 => Opcode::BCTRL_RM,
          599 => Opcode::BCn,
          600 => Opcode::BDNZ,
          601 => Opcode::BDNZ8,
          602 => Opcode::BDNZA,
          603 => Opcode::BDNZAm,
          604 => Opcode::BDNZAp,
          605 => Opcode::BDNZL,
          606 => Opcode::BDNZLA,
          607 => Opcode::BDNZLAm,
          608 => Opcode::BDNZLAp,
          609 => Opcode::BDNZLR,
          610 => Opcode::BDNZLR8,
          611 => Opcode::BDNZLRL,
          612 => Opcode::BDNZLRLm,
          613 => Opcode::BDNZLRLp,
          614 => Opcode::BDNZLRm,
          615 => Opcode::BDNZLRp,
          616 => Opcode::BDNZLm,
          617 => Opcode::BDNZLp,
          618 => Opcode::BDNZm,
          619 => Opcode::BDNZp,
          620 => Opcode::BDZ,
          621 => Opcode::BDZ8,
          622 => Opcode::BDZA,
          623 => Opcode::BDZAm,
          624 => Opcode::BDZAp,
          625 => Opcode::BDZL,
          626 => Opcode::BDZLA,
          627 => Opcode::BDZLAm,
          628 => Opcode::BDZLAp,
          629 => Opcode::BDZLR,
          630 => Opcode::BDZLR8,
          631 => Opcode::BDZLRL,
          632 => Opcode::BDZLRLm,
          633 => Opcode::BDZLRLp,
          634 => Opcode::BDZLRm,
          635 => Opcode::BDZLRp,
          636 => Opcode::BDZLm,
          637 => Opcode::BDZLp,
          638 => Opcode::BDZm,
          639 => Opcode::BDZp,
          640 => Opcode::BL,
          641 => Opcode::BL8,
          642 => Opcode::BL8_NOP,
          643 => Opcode::BL8_NOP_RM,
          644 => Opcode::BL8_NOP_TLS,
          645 => Opcode::BL8_NOTOC,
          646 => Opcode::BL8_NOTOC_RM,
          647 => Opcode::BL8_NOTOC_TLS,
          648 => Opcode::BL8_RM,
          649 => Opcode::BL8_TLS,
          650 => Opcode::BL8_TLS_,
          651 => Opcode::BLA,
          652 => Opcode::BLA8,
          653 => Opcode::BLA8_NOP,
          654 => Opcode::BLA8_NOP_RM,
          655 => Opcode::BLA8_RM,
          656 => Opcode::BLA_RM,
          657 => Opcode::BLR,
          658 => Opcode::BLR8,
          659 => Opcode::BLRL,
          660 => Opcode::BL_NOP,
          661 => Opcode::BL_NOP_RM,
          662 => Opcode::BL_RM,
          663 => Opcode::BL_TLS,
          664 => Opcode::BPERMD,
          665 => Opcode::BRD,
          666 => Opcode::BRH,
          667 => Opcode::BRH8,
          668 => Opcode::BRINC,
          669 => Opcode::BRW,
          670 => Opcode::BRW8,
          671 => Opcode::CBCDTD,
          672 => Opcode::CBCDTD8,
          673 => Opcode::CDTBCD,
          674 => Opcode::CDTBCD8,
          675 => Opcode::CFUGED,
          676 => Opcode::CLRBHRB,
          677 => Opcode::CMPB,
          678 => Opcode::CMPB8,
          679 => Opcode::CMPD,
          680 => Opcode::CMPDI,
          681 => Opcode::CMPEQB,
          682 => Opcode::CMPLD,
          683 => Opcode::CMPLDI,
          684 => Opcode::CMPLW,
          685 => Opcode::CMPLWI,
          686 => Opcode::CMPRB,
          687 => Opcode::CMPRB8,
          688 => Opcode::CMPW,
          689 => Opcode::CMPWI,
          690 => Opcode::CNTLZD,
          691 => Opcode::CNTLZDM,
          692 => Opcode::CNTLZD_rec,
          693 => Opcode::CNTLZW,
          694 => Opcode::CNTLZW8,
          695 => Opcode::CNTLZW8_rec,
          696 => Opcode::CNTLZW_rec,
          697 => Opcode::CNTTZD,
          698 => Opcode::CNTTZDM,
          699 => Opcode::CNTTZD_rec,
          700 => Opcode::CNTTZW,
          701 => Opcode::CNTTZW8,
          702 => Opcode::CNTTZW8_rec,
          703 => Opcode::CNTTZW_rec,
          704 => Opcode::CP_ABORT,
          705 => Opcode::CP_COPY,
          706 => Opcode::CP_COPY8,
          707 => Opcode::CP_PASTE8_rec,
          708 => Opcode::CP_PASTE_rec,
          709 => Opcode::CR6SET,
          710 => Opcode::CR6UNSET,
          711 => Opcode::CRAND,
          712 => Opcode::CRANDC,
          713 => Opcode::CREQV,
          714 => Opcode::CRNAND,
          715 => Opcode::CRNOR,
          716 => Opcode::CRNOT,
          717 => Opcode::CROR,
          718 => Opcode::CRORC,
          719 => Opcode::CRSET,
          720 => Opcode::CRUNSET,
          721 => Opcode::CRXOR,
          722 => Opcode::CTRL_DEP,
          723 => Opcode::DADD,
          724 => Opcode::DADDQ,
          725 => Opcode::DADDQ_rec,
          726 => Opcode::DADD_rec,
          727 => Opcode::DARN,
          728 => Opcode::DCBA,
          729 => Opcode::DCBF,
          730 => Opcode::DCBFEP,
          731 => Opcode::DCBI,
          732 => Opcode::DCBST,
          733 => Opcode::DCBSTEP,
          734 => Opcode::DCBT,
          735 => Opcode::DCBTEP,
          736 => Opcode::DCBTST,
          737 => Opcode::DCBTSTEP,
          738 => Opcode::DCBZ,
          739 => Opcode::DCBZEP,
          740 => Opcode::DCBZL,
          741 => Opcode::DCBZLEP,
          742 => Opcode::DCCCI,
          743 => Opcode::DCFFIX,
          744 => Opcode::DCFFIXQ,
          745 => Opcode::DCFFIXQQ,
          746 => Opcode::DCFFIXQ_rec,
          747 => Opcode::DCFFIX_rec,
          748 => Opcode::DCMPO,
          749 => Opcode::DCMPOQ,
          750 => Opcode::DCMPU,
          751 => Opcode::DCMPUQ,
          752 => Opcode::DCTDP,
          753 => Opcode::DCTDP_rec,
          754 => Opcode::DCTFIX,
          755 => Opcode::DCTFIXQ,
          756 => Opcode::DCTFIXQQ,
          757 => Opcode::DCTFIXQ_rec,
          758 => Opcode::DCTFIX_rec,
          759 => Opcode::DCTQPQ,
          760 => Opcode::DCTQPQ_rec,
          761 => Opcode::DDEDPD,
          762 => Opcode::DDEDPDQ,
          763 => Opcode::DDEDPDQ_rec,
          764 => Opcode::DDEDPD_rec,
          765 => Opcode::DDIV,
          766 => Opcode::DDIVQ,
          767 => Opcode::DDIVQ_rec,
          768 => Opcode::DDIV_rec,
          769 => Opcode::DENBCD,
          770 => Opcode::DENBCDQ,
          771 => Opcode::DENBCDQ_rec,
          772 => Opcode::DENBCD_rec,
          773 => Opcode::DIEX,
          774 => Opcode::DIEXQ,
          775 => Opcode::DIEXQ_rec,
          776 => Opcode::DIEX_rec,
          777 => Opcode::DIVD,
          778 => Opcode::DIVDE,
          779 => Opcode::DIVDEO,
          780 => Opcode::DIVDEO_rec,
          781 => Opcode::DIVDEU,
          782 => Opcode::DIVDEUO,
          783 => Opcode::DIVDEUO_rec,
          784 => Opcode::DIVDEU_rec,
          785 => Opcode::DIVDE_rec,
          786 => Opcode::DIVDO,
          787 => Opcode::DIVDO_rec,
          788 => Opcode::DIVDU,
          789 => Opcode::DIVDUO,
          790 => Opcode::DIVDUO_rec,
          791 => Opcode::DIVDU_rec,
          792 => Opcode::DIVD_rec,
          793 => Opcode::DIVW,
          794 => Opcode::DIVWE,
          795 => Opcode::DIVWEO,
          796 => Opcode::DIVWEO_rec,
          797 => Opcode::DIVWEU,
          798 => Opcode::DIVWEUO,
          799 => Opcode::DIVWEUO_rec,
          800 => Opcode::DIVWEU_rec,
          801 => Opcode::DIVWE_rec,
          802 => Opcode::DIVWO,
          803 => Opcode::DIVWO_rec,
          804 => Opcode::DIVWU,
          805 => Opcode::DIVWUO,
          806 => Opcode::DIVWUO_rec,
          807 => Opcode::DIVWU_rec,
          808 => Opcode::DIVW_rec,
          809 => Opcode::DMMR,
          810 => Opcode::DMSETDMRZ,
          811 => Opcode::DMSHA2HASH,
          812 => Opcode::DMSHA3HASH,
          813 => Opcode::DMUL,
          814 => Opcode::DMULQ,
          815 => Opcode::DMULQ_rec,
          816 => Opcode::DMUL_rec,
          817 => Opcode::DMXOR,
          818 => Opcode::DMXVBF16GERX2,
          819 => Opcode::DMXVBF16GERX2NN,
          820 => Opcode::DMXVBF16GERX2NP,
          821 => Opcode::DMXVBF16GERX2PN,
          822 => Opcode::DMXVBF16GERX2PP,
          823 => Opcode::DMXVF16GERX2,
          824 => Opcode::DMXVF16GERX2NN,
          825 => Opcode::DMXVF16GERX2NP,
          826 => Opcode::DMXVF16GERX2PN,
          827 => Opcode::DMXVF16GERX2PP,
          828 => Opcode::DMXVI8GERX4,
          829 => Opcode::DMXVI8GERX4PP,
          830 => Opcode::DMXVI8GERX4SPP,
          831 => Opcode::DMXXEXTFDMR256,
          832 => Opcode::DMXXEXTFDMR512,
          833 => Opcode::DMXXEXTFDMR512_HI,
          834 => Opcode::DMXXINSTDMR256,
          835 => Opcode::DMXXINSTDMR512,
          836 => Opcode::DMXXINSTDMR512_HI,
          837 => Opcode::DMXXSETACCZ,
          838 => Opcode::DMXXSHAPAD,
          839 => Opcode::DQUA,
          840 => Opcode::DQUAI,
          841 => Opcode::DQUAIQ,
          842 => Opcode::DQUAIQ_rec,
          843 => Opcode::DQUAI_rec,
          844 => Opcode::DQUAQ,
          845 => Opcode::DQUAQ_rec,
          846 => Opcode::DQUA_rec,
          847 => Opcode::DRDPQ,
          848 => Opcode::DRDPQ_rec,
          849 => Opcode::DRINTN,
          850 => Opcode::DRINTNQ,
          851 => Opcode::DRINTNQ_rec,
          852 => Opcode::DRINTN_rec,
          853 => Opcode::DRINTX,
          854 => Opcode::DRINTXQ,
          855 => Opcode::DRINTXQ_rec,
          856 => Opcode::DRINTX_rec,
          857 => Opcode::DRRND,
          858 => Opcode::DRRNDQ,
          859 => Opcode::DRRNDQ_rec,
          860 => Opcode::DRRND_rec,
          861 => Opcode::DRSP,
          862 => Opcode::DRSP_rec,
          863 => Opcode::DSCLI,
          864 => Opcode::DSCLIQ,
          865 => Opcode::DSCLIQ_rec,
          866 => Opcode::DSCLI_rec,
          867 => Opcode::DSCRI,
          868 => Opcode::DSCRIQ,
          869 => Opcode::DSCRIQ_rec,
          870 => Opcode::DSCRI_rec,
          871 => Opcode::DSS,
          872 => Opcode::DSSALL,
          873 => Opcode::DST,
          874 => Opcode::DST64,
          875 => Opcode::DSTST,
          876 => Opcode::DSTST64,
          877 => Opcode::DSTSTT,
          878 => Opcode::DSTSTT64,
          879 => Opcode::DSTT,
          880 => Opcode::DSTT64,
          881 => Opcode::DSUB,
          882 => Opcode::DSUBQ,
          883 => Opcode::DSUBQ_rec,
          884 => Opcode::DSUB_rec,
          885 => Opcode::DTSTDC,
          886 => Opcode::DTSTDCQ,
          887 => Opcode::DTSTDG,
          888 => Opcode::DTSTDGQ,
          889 => Opcode::DTSTEX,
          890 => Opcode::DTSTEXQ,
          891 => Opcode::DTSTSF,
          892 => Opcode::DTSTSFI,
          893 => Opcode::DTSTSFIQ,
          894 => Opcode::DTSTSFQ,
          895 => Opcode::DXEX,
          896 => Opcode::DXEXQ,
          897 => Opcode::DXEXQ_rec,
          898 => Opcode::DXEX_rec,
          899 => Opcode::DYNALLOC,
          900 => Opcode::DYNALLOC8,
          901 => Opcode::DYNAREAOFFSET,
          902 => Opcode::DYNAREAOFFSET8,
          903 => Opcode::DecreaseCTR8loop,
          904 => Opcode::DecreaseCTRloop,
          905 => Opcode::EFDABS,
          906 => Opcode::EFDADD,
          907 => Opcode::EFDCFS,
          908 => Opcode::EFDCFSF,
          909 => Opcode::EFDCFSI,
          910 => Opcode::EFDCFSID,
          911 => Opcode::EFDCFUF,
          912 => Opcode::EFDCFUI,
          913 => Opcode::EFDCFUID,
          914 => Opcode::EFDCMPEQ,
          915 => Opcode::EFDCMPGT,
          916 => Opcode::EFDCMPLT,
          917 => Opcode::EFDCTSF,
          918 => Opcode::EFDCTSI,
          919 => Opcode::EFDCTSIDZ,
          920 => Opcode::EFDCTSIZ,
          921 => Opcode::EFDCTUF,
          922 => Opcode::EFDCTUI,
          923 => Opcode::EFDCTUIDZ,
          924 => Opcode::EFDCTUIZ,
          925 => Opcode::EFDDIV,
          926 => Opcode::EFDMUL,
          927 => Opcode::EFDNABS,
          928 => Opcode::EFDNEG,
          929 => Opcode::EFDSUB,
          930 => Opcode::EFDTSTEQ,
          931 => Opcode::EFDTSTGT,
          932 => Opcode::EFDTSTLT,
          933 => Opcode::EFSABS,
          934 => Opcode::EFSADD,
          935 => Opcode::EFSCFD,
          936 => Opcode::EFSCFSF,
          937 => Opcode::EFSCFSI,
          938 => Opcode::EFSCFUF,
          939 => Opcode::EFSCFUI,
          940 => Opcode::EFSCMPEQ,
          941 => Opcode::EFSCMPGT,
          942 => Opcode::EFSCMPLT,
          943 => Opcode::EFSCTSF,
          944 => Opcode::EFSCTSI,
          945 => Opcode::EFSCTSIZ,
          946 => Opcode::EFSCTUF,
          947 => Opcode::EFSCTUI,
          948 => Opcode::EFSCTUIZ,
          949 => Opcode::EFSDIV,
          950 => Opcode::EFSMUL,
          951 => Opcode::EFSNABS,
          952 => Opcode::EFSNEG,
          953 => Opcode::EFSSUB,
          954 => Opcode::EFSTSTEQ,
          955 => Opcode::EFSTSTGT,
          956 => Opcode::EFSTSTLT,
          957 => Opcode::EH_SjLj_LongJmp32,
          958 => Opcode::EH_SjLj_LongJmp64,
          959 => Opcode::EH_SjLj_SetJmp32,
          960 => Opcode::EH_SjLj_SetJmp64,
          961 => Opcode::EH_SjLj_Setup,
          962 => Opcode::EQV,
          963 => Opcode::EQV8,
          964 => Opcode::EQV8_rec,
          965 => Opcode::EQV_rec,
          966 => Opcode::EVABS,
          967 => Opcode::EVADDIW,
          968 => Opcode::EVADDSMIAAW,
          969 => Opcode::EVADDSSIAAW,
          970 => Opcode::EVADDUMIAAW,
          971 => Opcode::EVADDUSIAAW,
          972 => Opcode::EVADDW,
          973 => Opcode::EVAND,
          974 => Opcode::EVANDC,
          975 => Opcode::EVCMPEQ,
          976 => Opcode::EVCMPGTS,
          977 => Opcode::EVCMPGTU,
          978 => Opcode::EVCMPLTS,
          979 => Opcode::EVCMPLTU,
          980 => Opcode::EVCNTLSW,
          981 => Opcode::EVCNTLZW,
          982 => Opcode::EVDIVWS,
          983 => Opcode::EVDIVWU,
          984 => Opcode::EVEQV,
          985 => Opcode::EVEXTSB,
          986 => Opcode::EVEXTSH,
          987 => Opcode::EVFSABS,
          988 => Opcode::EVFSADD,
          989 => Opcode::EVFSCFSF,
          990 => Opcode::EVFSCFSI,
          991 => Opcode::EVFSCFUF,
          992 => Opcode::EVFSCFUI,
          993 => Opcode::EVFSCMPEQ,
          994 => Opcode::EVFSCMPGT,
          995 => Opcode::EVFSCMPLT,
          996 => Opcode::EVFSCTSF,
          997 => Opcode::EVFSCTSI,
          998 => Opcode::EVFSCTSIZ,
          999 => Opcode::EVFSCTUF,
          1000 => Opcode::EVFSCTUI,
          1001 => Opcode::EVFSCTUIZ,
          1002 => Opcode::EVFSDIV,
          1003 => Opcode::EVFSMUL,
          1004 => Opcode::EVFSNABS,
          1005 => Opcode::EVFSNEG,
          1006 => Opcode::EVFSSUB,
          1007 => Opcode::EVFSTSTEQ,
          1008 => Opcode::EVFSTSTGT,
          1009 => Opcode::EVFSTSTLT,
          1010 => Opcode::EVLDD,
          1011 => Opcode::EVLDDX,
          1012 => Opcode::EVLDH,
          1013 => Opcode::EVLDHX,
          1014 => Opcode::EVLDW,
          1015 => Opcode::EVLDWX,
          1016 => Opcode::EVLHHESPLAT,
          1017 => Opcode::EVLHHESPLATX,
          1018 => Opcode::EVLHHOSSPLAT,
          1019 => Opcode::EVLHHOSSPLATX,
          1020 => Opcode::EVLHHOUSPLAT,
          1021 => Opcode::EVLHHOUSPLATX,
          1022 => Opcode::EVLWHE,
          1023 => Opcode::EVLWHEX,
          1024 => Opcode::EVLWHOS,
          1025 => Opcode::EVLWHOSX,
          1026 => Opcode::EVLWHOU,
          1027 => Opcode::EVLWHOUX,
          1028 => Opcode::EVLWHSPLAT,
          1029 => Opcode::EVLWHSPLATX,
          1030 => Opcode::EVLWWSPLAT,
          1031 => Opcode::EVLWWSPLATX,
          1032 => Opcode::EVMERGEHI,
          1033 => Opcode::EVMERGEHILO,
          1034 => Opcode::EVMERGELO,
          1035 => Opcode::EVMERGELOHI,
          1036 => Opcode::EVMHEGSMFAA,
          1037 => Opcode::EVMHEGSMFAN,
          1038 => Opcode::EVMHEGSMIAA,
          1039 => Opcode::EVMHEGSMIAN,
          1040 => Opcode::EVMHEGUMIAA,
          1041 => Opcode::EVMHEGUMIAN,
          1042 => Opcode::EVMHESMF,
          1043 => Opcode::EVMHESMFA,
          1044 => Opcode::EVMHESMFAAW,
          1045 => Opcode::EVMHESMFANW,
          1046 => Opcode::EVMHESMI,
          1047 => Opcode::EVMHESMIA,
          1048 => Opcode::EVMHESMIAAW,
          1049 => Opcode::EVMHESMIANW,
          1050 => Opcode::EVMHESSF,
          1051 => Opcode::EVMHESSFA,
          1052 => Opcode::EVMHESSFAAW,
          1053 => Opcode::EVMHESSFANW,
          1054 => Opcode::EVMHESSIAAW,
          1055 => Opcode::EVMHESSIANW,
          1056 => Opcode::EVMHEUMI,
          1057 => Opcode::EVMHEUMIA,
          1058 => Opcode::EVMHEUMIAAW,
          1059 => Opcode::EVMHEUMIANW,
          1060 => Opcode::EVMHEUSIAAW,
          1061 => Opcode::EVMHEUSIANW,
          1062 => Opcode::EVMHOGSMFAA,
          1063 => Opcode::EVMHOGSMFAN,
          1064 => Opcode::EVMHOGSMIAA,
          1065 => Opcode::EVMHOGSMIAN,
          1066 => Opcode::EVMHOGUMIAA,
          1067 => Opcode::EVMHOGUMIAN,
          1068 => Opcode::EVMHOSMF,
          1069 => Opcode::EVMHOSMFA,
          1070 => Opcode::EVMHOSMFAAW,
          1071 => Opcode::EVMHOSMFANW,
          1072 => Opcode::EVMHOSMI,
          1073 => Opcode::EVMHOSMIA,
          1074 => Opcode::EVMHOSMIAAW,
          1075 => Opcode::EVMHOSMIANW,
          1076 => Opcode::EVMHOSSF,
          1077 => Opcode::EVMHOSSFA,
          1078 => Opcode::EVMHOSSFAAW,
          1079 => Opcode::EVMHOSSFANW,
          1080 => Opcode::EVMHOSSIAAW,
          1081 => Opcode::EVMHOSSIANW,
          1082 => Opcode::EVMHOUMI,
          1083 => Opcode::EVMHOUMIA,
          1084 => Opcode::EVMHOUMIAAW,
          1085 => Opcode::EVMHOUMIANW,
          1086 => Opcode::EVMHOUSIAAW,
          1087 => Opcode::EVMHOUSIANW,
          1088 => Opcode::EVMRA,
          1089 => Opcode::EVMWHSMF,
          1090 => Opcode::EVMWHSMFA,
          1091 => Opcode::EVMWHSMI,
          1092 => Opcode::EVMWHSMIA,
          1093 => Opcode::EVMWHSSF,
          1094 => Opcode::EVMWHSSFA,
          1095 => Opcode::EVMWHUMI,
          1096 => Opcode::EVMWHUMIA,
          1097 => Opcode::EVMWLSMIAAW,
          1098 => Opcode::EVMWLSMIANW,
          1099 => Opcode::EVMWLSSIAAW,
          1100 => Opcode::EVMWLSSIANW,
          1101 => Opcode::EVMWLUMI,
          1102 => Opcode::EVMWLUMIA,
          1103 => Opcode::EVMWLUMIAAW,
          1104 => Opcode::EVMWLUMIANW,
          1105 => Opcode::EVMWLUSIAAW,
          1106 => Opcode::EVMWLUSIANW,
          1107 => Opcode::EVMWSMF,
          1108 => Opcode::EVMWSMFA,
          1109 => Opcode::EVMWSMFAA,
          1110 => Opcode::EVMWSMFAN,
          1111 => Opcode::EVMWSMI,
          1112 => Opcode::EVMWSMIA,
          1113 => Opcode::EVMWSMIAA,
          1114 => Opcode::EVMWSMIAN,
          1115 => Opcode::EVMWSSF,
          1116 => Opcode::EVMWSSFA,
          1117 => Opcode::EVMWSSFAA,
          1118 => Opcode::EVMWSSFAN,
          1119 => Opcode::EVMWUMI,
          1120 => Opcode::EVMWUMIA,
          1121 => Opcode::EVMWUMIAA,
          1122 => Opcode::EVMWUMIAN,
          1123 => Opcode::EVNAND,
          1124 => Opcode::EVNEG,
          1125 => Opcode::EVNOR,
          1126 => Opcode::EVOR,
          1127 => Opcode::EVORC,
          1128 => Opcode::EVRLW,
          1129 => Opcode::EVRLWI,
          1130 => Opcode::EVRNDW,
          1131 => Opcode::EVSEL,
          1132 => Opcode::EVSLW,
          1133 => Opcode::EVSLWI,
          1134 => Opcode::EVSPLATFI,
          1135 => Opcode::EVSPLATI,
          1136 => Opcode::EVSRWIS,
          1137 => Opcode::EVSRWIU,
          1138 => Opcode::EVSRWS,
          1139 => Opcode::EVSRWU,
          1140 => Opcode::EVSTDD,
          1141 => Opcode::EVSTDDX,
          1142 => Opcode::EVSTDH,
          1143 => Opcode::EVSTDHX,
          1144 => Opcode::EVSTDW,
          1145 => Opcode::EVSTDWX,
          1146 => Opcode::EVSTWHE,
          1147 => Opcode::EVSTWHEX,
          1148 => Opcode::EVSTWHO,
          1149 => Opcode::EVSTWHOX,
          1150 => Opcode::EVSTWWE,
          1151 => Opcode::EVSTWWEX,
          1152 => Opcode::EVSTWWO,
          1153 => Opcode::EVSTWWOX,
          1154 => Opcode::EVSUBFSMIAAW,
          1155 => Opcode::EVSUBFSSIAAW,
          1156 => Opcode::EVSUBFUMIAAW,
          1157 => Opcode::EVSUBFUSIAAW,
          1158 => Opcode::EVSUBFW,
          1159 => Opcode::EVSUBIFW,
          1160 => Opcode::EVXOR,
          1161 => Opcode::EXTSB,
          1162 => Opcode::EXTSB8,
          1163 => Opcode::EXTSB8_32_64,
          1164 => Opcode::EXTSB8_rec,
          1165 => Opcode::EXTSB_rec,
          1166 => Opcode::EXTSH,
          1167 => Opcode::EXTSH8,
          1168 => Opcode::EXTSH8_32_64,
          1169 => Opcode::EXTSH8_rec,
          1170 => Opcode::EXTSH_rec,
          1171 => Opcode::EXTSW,
          1172 => Opcode::EXTSWSLI,
          1173 => Opcode::EXTSWSLI_32_64,
          1174 => Opcode::EXTSWSLI_32_64_rec,
          1175 => Opcode::EXTSWSLI_rec,
          1176 => Opcode::EXTSW_32,
          1177 => Opcode::EXTSW_32_64,
          1178 => Opcode::EXTSW_32_64_rec,
          1179 => Opcode::EXTSW_rec,
          1180 => Opcode::EnforceIEIO,
          1181 => Opcode::FABSD,
          1182 => Opcode::FABSD_rec,
          1183 => Opcode::FABSS,
          1184 => Opcode::FABSS_rec,
          1185 => Opcode::FADD,
          1186 => Opcode::FADDS,
          1187 => Opcode::FADDS_rec,
          1188 => Opcode::FADD_rec,
          1189 => Opcode::FADDrtz,
          1190 => Opcode::FCFID,
          1191 => Opcode::FCFIDS,
          1192 => Opcode::FCFIDS_rec,
          1193 => Opcode::FCFIDU,
          1194 => Opcode::FCFIDUS,
          1195 => Opcode::FCFIDUS_rec,
          1196 => Opcode::FCFIDU_rec,
          1197 => Opcode::FCFID_rec,
          1198 => Opcode::FCMPOD,
          1199 => Opcode::FCMPOS,
          1200 => Opcode::FCMPUD,
          1201 => Opcode::FCMPUS,
          1202 => Opcode::FCPSGND,
          1203 => Opcode::FCPSGND_rec,
          1204 => Opcode::FCPSGNS,
          1205 => Opcode::FCPSGNS_rec,
          1206 => Opcode::FCTID,
          1207 => Opcode::FCTIDU,
          1208 => Opcode::FCTIDUZ,
          1209 => Opcode::FCTIDUZ_rec,
          1210 => Opcode::FCTIDU_rec,
          1211 => Opcode::FCTIDZ,
          1212 => Opcode::FCTIDZ_rec,
          1213 => Opcode::FCTID_rec,
          1214 => Opcode::FCTIW,
          1215 => Opcode::FCTIWU,
          1216 => Opcode::FCTIWUZ,
          1217 => Opcode::FCTIWUZ_rec,
          1218 => Opcode::FCTIWU_rec,
          1219 => Opcode::FCTIWZ,
          1220 => Opcode::FCTIWZ_rec,
          1221 => Opcode::FCTIW_rec,
          1222 => Opcode::FDIV,
          1223 => Opcode::FDIVS,
          1224 => Opcode::FDIVS_rec,
          1225 => Opcode::FDIV_rec,
          1226 => Opcode::FENCE,
          1227 => Opcode::FMADD,
          1228 => Opcode::FMADDS,
          1229 => Opcode::FMADDS_rec,
          1230 => Opcode::FMADD_rec,
          1231 => Opcode::FMR,
          1232 => Opcode::FMR_rec,
          1233 => Opcode::FMSUB,
          1234 => Opcode::FMSUBS,
          1235 => Opcode::FMSUBS_rec,
          1236 => Opcode::FMSUB_rec,
          1237 => Opcode::FMUL,
          1238 => Opcode::FMULS,
          1239 => Opcode::FMULS_rec,
          1240 => Opcode::FMUL_rec,
          1241 => Opcode::FNABSD,
          1242 => Opcode::FNABSD_rec,
          1243 => Opcode::FNABSS,
          1244 => Opcode::FNABSS_rec,
          1245 => Opcode::FNEGD,
          1246 => Opcode::FNEGD_rec,
          1247 => Opcode::FNEGS,
          1248 => Opcode::FNEGS_rec,
          1249 => Opcode::FNMADD,
          1250 => Opcode::FNMADDS,
          1251 => Opcode::FNMADDS_rec,
          1252 => Opcode::FNMADD_rec,
          1253 => Opcode::FNMSUB,
          1254 => Opcode::FNMSUBS,
          1255 => Opcode::FNMSUBS_rec,
          1256 => Opcode::FNMSUB_rec,
          1257 => Opcode::FRE,
          1258 => Opcode::FRES,
          1259 => Opcode::FRES_rec,
          1260 => Opcode::FRE_rec,
          1261 => Opcode::FRIMD,
          1262 => Opcode::FRIMD_rec,
          1263 => Opcode::FRIMS,
          1264 => Opcode::FRIMS_rec,
          1265 => Opcode::FRIND,
          1266 => Opcode::FRIND_rec,
          1267 => Opcode::FRINS,
          1268 => Opcode::FRINS_rec,
          1269 => Opcode::FRIPD,
          1270 => Opcode::FRIPD_rec,
          1271 => Opcode::FRIPS,
          1272 => Opcode::FRIPS_rec,
          1273 => Opcode::FRIZD,
          1274 => Opcode::FRIZD_rec,
          1275 => Opcode::FRIZS,
          1276 => Opcode::FRIZS_rec,
          1277 => Opcode::FRSP,
          1278 => Opcode::FRSP_rec,
          1279 => Opcode::FRSQRTE,
          1280 => Opcode::FRSQRTES,
          1281 => Opcode::FRSQRTES_rec,
          1282 => Opcode::FRSQRTE_rec,
          1283 => Opcode::FSELD,
          1284 => Opcode::FSELD_rec,
          1285 => Opcode::FSELS,
          1286 => Opcode::FSELS_rec,
          1287 => Opcode::FSQRT,
          1288 => Opcode::FSQRTS,
          1289 => Opcode::FSQRTS_rec,
          1290 => Opcode::FSQRT_rec,
          1291 => Opcode::FSUB,
          1292 => Opcode::FSUBS,
          1293 => Opcode::FSUBS_rec,
          1294 => Opcode::FSUB_rec,
          1295 => Opcode::FTDIV,
          1296 => Opcode::FTSQRT,
          1297 => Opcode::GETtlsADDR,
          1298 => Opcode::GETtlsADDR32,
          1299 => Opcode::GETtlsADDR32AIX,
          1300 => Opcode::GETtlsADDR64AIX,
          1301 => Opcode::GETtlsADDRPCREL,
          1302 => Opcode::GETtlsMOD32AIX,
          1303 => Opcode::GETtlsMOD64AIX,
          1304 => Opcode::GETtlsTpointer32AIX,
          1305 => Opcode::GETtlsldADDR,
          1306 => Opcode::GETtlsldADDR32,
          1307 => Opcode::GETtlsldADDRPCREL,
          1308 => Opcode::HASHCHK,
          1309 => Opcode::HASHCHK8,
          1310 => Opcode::HASHCHKP,
          1311 => Opcode::HASHCHKP8,
          1312 => Opcode::HASHST,
          1313 => Opcode::HASHST8,
          1314 => Opcode::HASHSTP,
          1315 => Opcode::HASHSTP8,
          1316 => Opcode::HRFID,
          1317 => Opcode::ICBI,
          1318 => Opcode::ICBIEP,
          1319 => Opcode::ICBLC,
          1320 => Opcode::ICBLQ,
          1321 => Opcode::ICBT,
          1322 => Opcode::ICBTLS,
          1323 => Opcode::ICCCI,
          1324 => Opcode::ISEL,
          1325 => Opcode::ISEL8,
          1326 => Opcode::ISYNC,
          1327 => Opcode::LA,
          1328 => Opcode::LA8,
          1329 => Opcode::LBARX,
          1330 => Opcode::LBARXL,
          1331 => Opcode::LBEPX,
          1332 => Opcode::LBZ,
          1333 => Opcode::LBZ8,
          1334 => Opcode::LBZCIX,
          1335 => Opcode::LBZU,
          1336 => Opcode::LBZU8,
          1337 => Opcode::LBZUX,
          1338 => Opcode::LBZUX8,
          1339 => Opcode::LBZX,
          1340 => Opcode::LBZX8,
          1341 => Opcode::LBZXTLS,
          1342 => Opcode::LBZXTLS_,
          1343 => Opcode::LBZXTLS_32,
          1344 => Opcode::LD,
          1345 => Opcode::LDARX,
          1346 => Opcode::LDARXL,
          1347 => Opcode::LDAT,
          1348 => Opcode::LDBRX,
          1349 => Opcode::LDCIX,
          1350 => Opcode::LDU,
          1351 => Opcode::LDUX,
          1352 => Opcode::LDX,
          1353 => Opcode::LDXTLS,
          1354 => Opcode::LDXTLS_,
          1355 => Opcode::LDgotTprelL,
          1356 => Opcode::LDgotTprelL32,
          1357 => Opcode::LDtoc,
          1358 => Opcode::LDtocBA,
          1359 => Opcode::LDtocCPT,
          1360 => Opcode::LDtocJTI,
          1361 => Opcode::LDtocL,
          1362 => Opcode::LFD,
          1363 => Opcode::LFDEPX,
          1364 => Opcode::LFDU,
          1365 => Opcode::LFDUX,
          1366 => Opcode::LFDX,
          1367 => Opcode::LFDXTLS,
          1368 => Opcode::LFDXTLS_,
          1369 => Opcode::LFIWAX,
          1370 => Opcode::LFIWZX,
          1371 => Opcode::LFS,
          1372 => Opcode::LFSU,
          1373 => Opcode::LFSUX,
          1374 => Opcode::LFSX,
          1375 => Opcode::LFSXTLS,
          1376 => Opcode::LFSXTLS_,
          1377 => Opcode::LHA,
          1378 => Opcode::LHA8,
          1379 => Opcode::LHARX,
          1380 => Opcode::LHARXL,
          1381 => Opcode::LHAU,
          1382 => Opcode::LHAU8,
          1383 => Opcode::LHAUX,
          1384 => Opcode::LHAUX8,
          1385 => Opcode::LHAX,
          1386 => Opcode::LHAX8,
          1387 => Opcode::LHAXTLS,
          1388 => Opcode::LHAXTLS_,
          1389 => Opcode::LHAXTLS_32,
          1390 => Opcode::LHBRX,
          1391 => Opcode::LHBRX8,
          1392 => Opcode::LHEPX,
          1393 => Opcode::LHZ,
          1394 => Opcode::LHZ8,
          1395 => Opcode::LHZCIX,
          1396 => Opcode::LHZU,
          1397 => Opcode::LHZU8,
          1398 => Opcode::LHZUX,
          1399 => Opcode::LHZUX8,
          1400 => Opcode::LHZX,
          1401 => Opcode::LHZX8,
          1402 => Opcode::LHZXTLS,
          1403 => Opcode::LHZXTLS_,
          1404 => Opcode::LHZXTLS_32,
          1405 => Opcode::LI,
          1406 => Opcode::LI8,
          1407 => Opcode::LIS,
          1408 => Opcode::LIS8,
          1409 => Opcode::LMW,
          1410 => Opcode::LQ,
          1411 => Opcode::LQARX,
          1412 => Opcode::LQARXL,
          1413 => Opcode::LQX_PSEUDO,
          1414 => Opcode::LSWI,
          1415 => Opcode::LVEBX,
          1416 => Opcode::LVEHX,
          1417 => Opcode::LVEWX,
          1418 => Opcode::LVSL,
          1419 => Opcode::LVSR,
          1420 => Opcode::LVX,
          1421 => Opcode::LVXL,
          1422 => Opcode::LWA,
          1423 => Opcode::LWARX,
          1424 => Opcode::LWARXL,
          1425 => Opcode::LWAT,
          1426 => Opcode::LWAUX,
          1427 => Opcode::LWAX,
          1428 => Opcode::LWAXTLS,
          1429 => Opcode::LWAXTLS_,
          1430 => Opcode::LWAXTLS_32,
          1431 => Opcode::LWAX_32,
          1432 => Opcode::LWA_32,
          1433 => Opcode::LWBRX,
          1434 => Opcode::LWBRX8,
          1435 => Opcode::LWEPX,
          1436 => Opcode::LWZ,
          1437 => Opcode::LWZ8,
          1438 => Opcode::LWZCIX,
          1439 => Opcode::LWZU,
          1440 => Opcode::LWZU8,
          1441 => Opcode::LWZUX,
          1442 => Opcode::LWZUX8,
          1443 => Opcode::LWZX,
          1444 => Opcode::LWZX8,
          1445 => Opcode::LWZXTLS,
          1446 => Opcode::LWZXTLS_,
          1447 => Opcode::LWZXTLS_32,
          1448 => Opcode::LWZtoc,
          1449 => Opcode::LWZtocL,
          1450 => Opcode::LXSD,
          1451 => Opcode::LXSDX,
          1452 => Opcode::LXSIBZX,
          1453 => Opcode::LXSIHZX,
          1454 => Opcode::LXSIWAX,
          1455 => Opcode::LXSIWZX,
          1456 => Opcode::LXSSP,
          1457 => Opcode::LXSSPX,
          1458 => Opcode::LXV,
          1459 => Opcode::LXVB16X,
          1460 => Opcode::LXVD2X,
          1461 => Opcode::LXVDSX,
          1462 => Opcode::LXVH8X,
          1463 => Opcode::LXVKQ,
          1464 => Opcode::LXVL,
          1465 => Opcode::LXVLL,
          1466 => Opcode::LXVP,
          1467 => Opcode::LXVPRL,
          1468 => Opcode::LXVPRLL,
          1469 => Opcode::LXVPX,
          1470 => Opcode::LXVRBX,
          1471 => Opcode::LXVRDX,
          1472 => Opcode::LXVRHX,
          1473 => Opcode::LXVRL,
          1474 => Opcode::LXVRLL,
          1475 => Opcode::LXVRWX,
          1476 => Opcode::LXVW4X,
          1477 => Opcode::LXVWSX,
          1478 => Opcode::LXVX,
          1479 => Opcode::MADDHD,
          1480 => Opcode::MADDHDU,
          1481 => Opcode::MADDLD,
          1482 => Opcode::MADDLD8,
          1483 => Opcode::MBAR,
          1484 => Opcode::MCRF,
          1485 => Opcode::MCRFS,
          1486 => Opcode::MCRXRX,
          1487 => Opcode::MFBHRBE,
          1488 => Opcode::MFCR,
          1489 => Opcode::MFCR8,
          1490 => Opcode::MFCTR,
          1491 => Opcode::MFCTR8,
          1492 => Opcode::MFDCR,
          1493 => Opcode::MFFS,
          1494 => Opcode::MFFSCDRN,
          1495 => Opcode::MFFSCDRNI,
          1496 => Opcode::MFFSCE,
          1497 => Opcode::MFFSCRN,
          1498 => Opcode::MFFSCRNI,
          1499 => Opcode::MFFSL,
          1500 => Opcode::MFFS_rec,
          1501 => Opcode::MFLR,
          1502 => Opcode::MFLR8,
          1503 => Opcode::MFMSR,
          1504 => Opcode::MFOCRF,
          1505 => Opcode::MFOCRF8,
          1506 => Opcode::MFPMR,
          1507 => Opcode::MFSPR,
          1508 => Opcode::MFSPR8,
          1509 => Opcode::MFSR,
          1510 => Opcode::MFSRIN,
          1511 => Opcode::MFTB,
          1512 => Opcode::MFTB8,
          1513 => Opcode::MFUDSCR,
          1514 => Opcode::MFVRD,
          1515 => Opcode::MFVRSAVE,
          1516 => Opcode::MFVRSAVEv,
          1517 => Opcode::MFVRWZ,
          1518 => Opcode::MFVSCR,
          1519 => Opcode::MFVSRD,
          1520 => Opcode::MFVSRLD,
          1521 => Opcode::MFVSRWZ,
          1522 => Opcode::MODSD,
          1523 => Opcode::MODSW,
          1524 => Opcode::MODUD,
          1525 => Opcode::MODUW,
          1526 => Opcode::MSGSYNC,
          1527 => Opcode::MSYNC,
          1528 => Opcode::MTCRF,
          1529 => Opcode::MTCRF8,
          1530 => Opcode::MTCTR,
          1531 => Opcode::MTCTR8,
          1532 => Opcode::MTCTR8loop,
          1533 => Opcode::MTCTRloop,
          1534 => Opcode::MTDCR,
          1535 => Opcode::MTFSB0,
          1536 => Opcode::MTFSB1,
          1537 => Opcode::MTFSF,
          1538 => Opcode::MTFSFI,
          1539 => Opcode::MTFSFI_rec,
          1540 => Opcode::MTFSFIb,
          1541 => Opcode::MTFSF_rec,
          1542 => Opcode::MTFSFb,
          1543 => Opcode::MTLR,
          1544 => Opcode::MTLR8,
          1545 => Opcode::MTMSR,
          1546 => Opcode::MTMSRD,
          1547 => Opcode::MTOCRF,
          1548 => Opcode::MTOCRF8,
          1549 => Opcode::MTPMR,
          1550 => Opcode::MTSPR,
          1551 => Opcode::MTSPR8,
          1552 => Opcode::MTSR,
          1553 => Opcode::MTSRIN,
          1554 => Opcode::MTUDSCR,
          1555 => Opcode::MTVRD,
          1556 => Opcode::MTVRSAVE,
          1557 => Opcode::MTVRSAVEv,
          1558 => Opcode::MTVRWA,
          1559 => Opcode::MTVRWZ,
          1560 => Opcode::MTVSCR,
          1561 => Opcode::MTVSRBM,
          1562 => Opcode::MTVSRBMI,
          1563 => Opcode::MTVSRD,
          1564 => Opcode::MTVSRDD,
          1565 => Opcode::MTVSRDM,
          1566 => Opcode::MTVSRHM,
          1567 => Opcode::MTVSRQM,
          1568 => Opcode::MTVSRWA,
          1569 => Opcode::MTVSRWM,
          1570 => Opcode::MTVSRWS,
          1571 => Opcode::MTVSRWZ,
          1572 => Opcode::MULHD,
          1573 => Opcode::MULHDU,
          1574 => Opcode::MULHDU_rec,
          1575 => Opcode::MULHD_rec,
          1576 => Opcode::MULHW,
          1577 => Opcode::MULHWU,
          1578 => Opcode::MULHWU_rec,
          1579 => Opcode::MULHW_rec,
          1580 => Opcode::MULLD,
          1581 => Opcode::MULLDO,
          1582 => Opcode::MULLDO_rec,
          1583 => Opcode::MULLD_rec,
          1584 => Opcode::MULLI,
          1585 => Opcode::MULLI8,
          1586 => Opcode::MULLW,
          1587 => Opcode::MULLWO,
          1588 => Opcode::MULLWO_rec,
          1589 => Opcode::MULLW_rec,
          1590 => Opcode::MoveGOTtoLR,
          1591 => Opcode::MovePCtoLR,
          1592 => Opcode::MovePCtoLR8,
          1593 => Opcode::NAND,
          1594 => Opcode::NAND8,
          1595 => Opcode::NAND8_rec,
          1596 => Opcode::NAND_rec,
          1597 => Opcode::NAP,
          1598 => Opcode::NEG,
          1599 => Opcode::NEG8,
          1600 => Opcode::NEG8O,
          1601 => Opcode::NEG8O_rec,
          1602 => Opcode::NEG8_rec,
          1603 => Opcode::NEGO,
          1604 => Opcode::NEGO_rec,
          1605 => Opcode::NEG_rec,
          1606 => Opcode::NOP,
          1607 => Opcode::NOP_GT_PWR6,
          1608 => Opcode::NOP_GT_PWR7,
          1609 => Opcode::NOR,
          1610 => Opcode::NOR8,
          1611 => Opcode::NOR8_rec,
          1612 => Opcode::NOR_rec,
          1613 => Opcode::OR,
          1614 => Opcode::OR8,
          1615 => Opcode::OR8_rec,
          1616 => Opcode::ORC,
          1617 => Opcode::ORC8,
          1618 => Opcode::ORC8_rec,
          1619 => Opcode::ORC_rec,
          1620 => Opcode::ORI,
          1621 => Opcode::ORI8,
          1622 => Opcode::ORIS,
          1623 => Opcode::ORIS8,
          1624 => Opcode::OR_rec,
          1625 => Opcode::PADDI,
          1626 => Opcode::PADDI8,
          1627 => Opcode::PADDI8pc,
          1628 => Opcode::PADDIdtprel,
          1629 => Opcode::PADDIpc,
          1630 => Opcode::PDEPD,
          1631 => Opcode::PEXTD,
          1632 => Opcode::PLA,
          1633 => Opcode::PLA8,
          1634 => Opcode::PLA8pc,
          1635 => Opcode::PLApc,
          1636 => Opcode::PLBZ,
          1637 => Opcode::PLBZ8,
          1638 => Opcode::PLBZ8nopc,
          1639 => Opcode::PLBZ8onlypc,
          1640 => Opcode::PLBZ8pc,
          1641 => Opcode::PLBZnopc,
          1642 => Opcode::PLBZonlypc,
          1643 => Opcode::PLBZpc,
          1644 => Opcode::PLD,
          1645 => Opcode::PLDnopc,
          1646 => Opcode::PLDonlypc,
          1647 => Opcode::PLDpc,
          1648 => Opcode::PLFD,
          1649 => Opcode::PLFDnopc,
          1650 => Opcode::PLFDonlypc,
          1651 => Opcode::PLFDpc,
          1652 => Opcode::PLFS,
          1653 => Opcode::PLFSnopc,
          1654 => Opcode::PLFSonlypc,
          1655 => Opcode::PLFSpc,
          1656 => Opcode::PLHA,
          1657 => Opcode::PLHA8,
          1658 => Opcode::PLHA8nopc,
          1659 => Opcode::PLHA8onlypc,
          1660 => Opcode::PLHA8pc,
          1661 => Opcode::PLHAnopc,
          1662 => Opcode::PLHAonlypc,
          1663 => Opcode::PLHApc,
          1664 => Opcode::PLHZ,
          1665 => Opcode::PLHZ8,
          1666 => Opcode::PLHZ8nopc,
          1667 => Opcode::PLHZ8onlypc,
          1668 => Opcode::PLHZ8pc,
          1669 => Opcode::PLHZnopc,
          1670 => Opcode::PLHZonlypc,
          1671 => Opcode::PLHZpc,
          1672 => Opcode::PLI,
          1673 => Opcode::PLI8,
          1674 => Opcode::PLWA,
          1675 => Opcode::PLWA8,
          1676 => Opcode::PLWA8nopc,
          1677 => Opcode::PLWA8onlypc,
          1678 => Opcode::PLWA8pc,
          1679 => Opcode::PLWAnopc,
          1680 => Opcode::PLWAonlypc,
          1681 => Opcode::PLWApc,
          1682 => Opcode::PLWZ,
          1683 => Opcode::PLWZ8,
          1684 => Opcode::PLWZ8nopc,
          1685 => Opcode::PLWZ8onlypc,
          1686 => Opcode::PLWZ8pc,
          1687 => Opcode::PLWZnopc,
          1688 => Opcode::PLWZonlypc,
          1689 => Opcode::PLWZpc,
          1690 => Opcode::PLXSD,
          1691 => Opcode::PLXSDnopc,
          1692 => Opcode::PLXSDonlypc,
          1693 => Opcode::PLXSDpc,
          1694 => Opcode::PLXSSP,
          1695 => Opcode::PLXSSPnopc,
          1696 => Opcode::PLXSSPonlypc,
          1697 => Opcode::PLXSSPpc,
          1698 => Opcode::PLXV,
          1699 => Opcode::PLXVP,
          1700 => Opcode::PLXVPnopc,
          1701 => Opcode::PLXVPonlypc,
          1702 => Opcode::PLXVPpc,
          1703 => Opcode::PLXVnopc,
          1704 => Opcode::PLXVonlypc,
          1705 => Opcode::PLXVpc,
          1706 => Opcode::PMDMXVBF16GERX2,
          1707 => Opcode::PMDMXVBF16GERX2NN,
          1708 => Opcode::PMDMXVBF16GERX2NP,
          1709 => Opcode::PMDMXVBF16GERX2PN,
          1710 => Opcode::PMDMXVBF16GERX2PP,
          1711 => Opcode::PMDMXVF16GERX2,
          1712 => Opcode::PMDMXVF16GERX2NN,
          1713 => Opcode::PMDMXVF16GERX2NP,
          1714 => Opcode::PMDMXVF16GERX2PN,
          1715 => Opcode::PMDMXVF16GERX2PP,
          1716 => Opcode::PMDMXVI8GERX4,
          1717 => Opcode::PMDMXVI8GERX4PP,
          1718 => Opcode::PMDMXVI8GERX4SPP,
          1719 => Opcode::PMXVBF16GER2,
          1720 => Opcode::PMXVBF16GER2NN,
          1721 => Opcode::PMXVBF16GER2NP,
          1722 => Opcode::PMXVBF16GER2PN,
          1723 => Opcode::PMXVBF16GER2PP,
          1724 => Opcode::PMXVBF16GER2W,
          1725 => Opcode::PMXVBF16GER2WNN,
          1726 => Opcode::PMXVBF16GER2WNP,
          1727 => Opcode::PMXVBF16GER2WPN,
          1728 => Opcode::PMXVBF16GER2WPP,
          1729 => Opcode::PMXVF16GER2,
          1730 => Opcode::PMXVF16GER2NN,
          1731 => Opcode::PMXVF16GER2NP,
          1732 => Opcode::PMXVF16GER2PN,
          1733 => Opcode::PMXVF16GER2PP,
          1734 => Opcode::PMXVF16GER2W,
          1735 => Opcode::PMXVF16GER2WNN,
          1736 => Opcode::PMXVF16GER2WNP,
          1737 => Opcode::PMXVF16GER2WPN,
          1738 => Opcode::PMXVF16GER2WPP,
          1739 => Opcode::PMXVF32GER,
          1740 => Opcode::PMXVF32GERNN,
          1741 => Opcode::PMXVF32GERNP,
          1742 => Opcode::PMXVF32GERPN,
          1743 => Opcode::PMXVF32GERPP,
          1744 => Opcode::PMXVF32GERW,
          1745 => Opcode::PMXVF32GERWNN,
          1746 => Opcode::PMXVF32GERWNP,
          1747 => Opcode::PMXVF32GERWPN,
          1748 => Opcode::PMXVF32GERWPP,
          1749 => Opcode::PMXVF64GER,
          1750 => Opcode::PMXVF64GERNN,
          1751 => Opcode::PMXVF64GERNP,
          1752 => Opcode::PMXVF64GERPN,
          1753 => Opcode::PMXVF64GERPP,
          1754 => Opcode::PMXVF64GERW,
          1755 => Opcode::PMXVF64GERWNN,
          1756 => Opcode::PMXVF64GERWNP,
          1757 => Opcode::PMXVF64GERWPN,
          1758 => Opcode::PMXVF64GERWPP,
          1759 => Opcode::PMXVI16GER2,
          1760 => Opcode::PMXVI16GER2PP,
          1761 => Opcode::PMXVI16GER2S,
          1762 => Opcode::PMXVI16GER2SPP,
          1763 => Opcode::PMXVI16GER2SW,
          1764 => Opcode::PMXVI16GER2SWPP,
          1765 => Opcode::PMXVI16GER2W,
          1766 => Opcode::PMXVI16GER2WPP,
          1767 => Opcode::PMXVI4GER8,
          1768 => Opcode::PMXVI4GER8PP,
          1769 => Opcode::PMXVI4GER8W,
          1770 => Opcode::PMXVI4GER8WPP,
          1771 => Opcode::PMXVI8GER4,
          1772 => Opcode::PMXVI8GER4PP,
          1773 => Opcode::PMXVI8GER4SPP,
          1774 => Opcode::PMXVI8GER4W,
          1775 => Opcode::PMXVI8GER4WPP,
          1776 => Opcode::PMXVI8GER4WSPP,
          1777 => Opcode::POPCNTB,
          1778 => Opcode::POPCNTB8,
          1779 => Opcode::POPCNTD,
          1780 => Opcode::POPCNTW,
          1781 => Opcode::PPC32GOT,
          1782 => Opcode::PPC32PICGOT,
          1783 => Opcode::PREPARE_PROBED_ALLOCA_32,
          1784 => Opcode::PREPARE_PROBED_ALLOCA_64,
          1785 => Opcode::PREPARE_PROBED_ALLOCA_NEGSIZE_SAME_REG_32,
          1786 => Opcode::PREPARE_PROBED_ALLOCA_NEGSIZE_SAME_REG_64,
          1787 => Opcode::PROBED_ALLOCA_32,
          1788 => Opcode::PROBED_ALLOCA_64,
          1789 => Opcode::PROBED_STACKALLOC_32,
          1790 => Opcode::PROBED_STACKALLOC_64,
          1791 => Opcode::PSTB,
          1792 => Opcode::PSTB8,
          1793 => Opcode::PSTB8nopc,
          1794 => Opcode::PSTB8onlypc,
          1795 => Opcode::PSTB8pc,
          1796 => Opcode::PSTBnopc,
          1797 => Opcode::PSTBonlypc,
          1798 => Opcode::PSTBpc,
          1799 => Opcode::PSTD,
          1800 => Opcode::PSTDnopc,
          1801 => Opcode::PSTDonlypc,
          1802 => Opcode::PSTDpc,
          1803 => Opcode::PSTFD,
          1804 => Opcode::PSTFDnopc,
          1805 => Opcode::PSTFDonlypc,
          1806 => Opcode::PSTFDpc,
          1807 => Opcode::PSTFS,
          1808 => Opcode::PSTFSnopc,
          1809 => Opcode::PSTFSonlypc,
          1810 => Opcode::PSTFSpc,
          1811 => Opcode::PSTH,
          1812 => Opcode::PSTH8,
          1813 => Opcode::PSTH8nopc,
          1814 => Opcode::PSTH8onlypc,
          1815 => Opcode::PSTH8pc,
          1816 => Opcode::PSTHnopc,
          1817 => Opcode::PSTHonlypc,
          1818 => Opcode::PSTHpc,
          1819 => Opcode::PSTW,
          1820 => Opcode::PSTW8,
          1821 => Opcode::PSTW8nopc,
          1822 => Opcode::PSTW8onlypc,
          1823 => Opcode::PSTW8pc,
          1824 => Opcode::PSTWnopc,
          1825 => Opcode::PSTWonlypc,
          1826 => Opcode::PSTWpc,
          1827 => Opcode::PSTXSD,
          1828 => Opcode::PSTXSDnopc,
          1829 => Opcode::PSTXSDonlypc,
          1830 => Opcode::PSTXSDpc,
          1831 => Opcode::PSTXSSP,
          1832 => Opcode::PSTXSSPnopc,
          1833 => Opcode::PSTXSSPonlypc,
          1834 => Opcode::PSTXSSPpc,
          1835 => Opcode::PSTXV,
          1836 => Opcode::PSTXVP,
          1837 => Opcode::PSTXVPnopc,
          1838 => Opcode::PSTXVPonlypc,
          1839 => Opcode::PSTXVPpc,
          1840 => Opcode::PSTXVnopc,
          1841 => Opcode::PSTXVonlypc,
          1842 => Opcode::PSTXVpc,
          1843 => Opcode::PseudoEIEIO,
          1844 => Opcode::RESTORE_ACC,
          1845 => Opcode::RESTORE_CR,
          1846 => Opcode::RESTORE_CRBIT,
          1847 => Opcode::RESTORE_DMR,
          1848 => Opcode::RESTORE_DMRP,
          1849 => Opcode::RESTORE_QUADWORD,
          1850 => Opcode::RESTORE_UACC,
          1851 => Opcode::RESTORE_WACC,
          1852 => Opcode::RFCI,
          1853 => Opcode::RFDI,
          1854 => Opcode::RFEBB,
          1855 => Opcode::RFI,
          1856 => Opcode::RFID,
          1857 => Opcode::RFMCI,
          1858 => Opcode::RLDCL,
          1859 => Opcode::RLDCL_rec,
          1860 => Opcode::RLDCR,
          1861 => Opcode::RLDCR_rec,
          1862 => Opcode::RLDIC,
          1863 => Opcode::RLDICL,
          1864 => Opcode::RLDICL_32,
          1865 => Opcode::RLDICL_32_64,
          1866 => Opcode::RLDICL_32_rec,
          1867 => Opcode::RLDICL_rec,
          1868 => Opcode::RLDICR,
          1869 => Opcode::RLDICR_32,
          1870 => Opcode::RLDICR_rec,
          1871 => Opcode::RLDIC_rec,
          1872 => Opcode::RLDIMI,
          1873 => Opcode::RLDIMI_rec,
          1874 => Opcode::RLWIMI,
          1875 => Opcode::RLWIMI8,
          1876 => Opcode::RLWIMI8_rec,
          1877 => Opcode::RLWIMI_rec,
          1878 => Opcode::RLWINM,
          1879 => Opcode::RLWINM8,
          1880 => Opcode::RLWINM8_rec,
          1881 => Opcode::RLWINM_rec,
          1882 => Opcode::RLWNM,
          1883 => Opcode::RLWNM8,
          1884 => Opcode::RLWNM8_rec,
          1885 => Opcode::RLWNM_rec,
          1886 => Opcode::ReadTB,
          1887 => Opcode::SC,
          1888 => Opcode::SCV,
          1889 => Opcode::SELECT_CC_F16,
          1890 => Opcode::SELECT_CC_F4,
          1891 => Opcode::SELECT_CC_F8,
          1892 => Opcode::SELECT_CC_I4,
          1893 => Opcode::SELECT_CC_I8,
          1894 => Opcode::SELECT_CC_SPE,
          1895 => Opcode::SELECT_CC_SPE4,
          1896 => Opcode::SELECT_CC_VRRC,
          1897 => Opcode::SELECT_CC_VSFRC,
          1898 => Opcode::SELECT_CC_VSRC,
          1899 => Opcode::SELECT_CC_VSSRC,
          1900 => Opcode::SELECT_F16,
          1901 => Opcode::SELECT_F4,
          1902 => Opcode::SELECT_F8,
          1903 => Opcode::SELECT_I4,
          1904 => Opcode::SELECT_I8,
          1905 => Opcode::SELECT_SPE,
          1906 => Opcode::SELECT_SPE4,
          1907 => Opcode::SELECT_VRRC,
          1908 => Opcode::SELECT_VSFRC,
          1909 => Opcode::SELECT_VSRC,
          1910 => Opcode::SELECT_VSSRC,
          1911 => Opcode::SETB,
          1912 => Opcode::SETB8,
          1913 => Opcode::SETBC,
          1914 => Opcode::SETBC8,
          1915 => Opcode::SETBCR,
          1916 => Opcode::SETBCR8,
          1917 => Opcode::SETFLM,
          1918 => Opcode::SETNBC,
          1919 => Opcode::SETNBC8,
          1920 => Opcode::SETNBCR,
          1921 => Opcode::SETNBCR8,
          1922 => Opcode::SETRND,
          1923 => Opcode::SETRNDi,
          1924 => Opcode::SLBFEE_rec,
          1925 => Opcode::SLBIA,
          1926 => Opcode::SLBIE,
          1927 => Opcode::SLBIEG,
          1928 => Opcode::SLBMFEE,
          1929 => Opcode::SLBMFEV,
          1930 => Opcode::SLBMTE,
          1931 => Opcode::SLBSYNC,
          1932 => Opcode::SLD,
          1933 => Opcode::SLD_rec,
          1934 => Opcode::SLW,
          1935 => Opcode::SLW8,
          1936 => Opcode::SLW8_rec,
          1937 => Opcode::SLW_rec,
          1938 => Opcode::SPELWZ,
          1939 => Opcode::SPELWZX,
          1940 => Opcode::SPESTW,
          1941 => Opcode::SPESTWX,
          1942 => Opcode::SPILL_ACC,
          1943 => Opcode::SPILL_CR,
          1944 => Opcode::SPILL_CRBIT,
          1945 => Opcode::SPILL_DMR,
          1946 => Opcode::SPILL_DMRP,
          1947 => Opcode::SPILL_QUADWORD,
          1948 => Opcode::SPILL_UACC,
          1949 => Opcode::SPILL_WACC,
          1950 => Opcode::SPLIT_QUADWORD,
          1951 => Opcode::SRAD,
          1952 => Opcode::SRADI,
          1953 => Opcode::SRADI_32,
          1954 => Opcode::SRADI_rec,
          1955 => Opcode::SRAD_rec,
          1956 => Opcode::SRAW,
          1957 => Opcode::SRAW8,
          1958 => Opcode::SRAW8_rec,
          1959 => Opcode::SRAWI,
          1960 => Opcode::SRAWI8,
          1961 => Opcode::SRAWI8_rec,
          1962 => Opcode::SRAWI_rec,
          1963 => Opcode::SRAW_rec,
          1964 => Opcode::SRD,
          1965 => Opcode::SRD_rec,
          1966 => Opcode::SRW,
          1967 => Opcode::SRW8,
          1968 => Opcode::SRW8_rec,
          1969 => Opcode::SRW_rec,
          1970 => Opcode::STB,
          1971 => Opcode::STB8,
          1972 => Opcode::STBCIX,
          1973 => Opcode::STBCX,
          1974 => Opcode::STBEPX,
          1975 => Opcode::STBU,
          1976 => Opcode::STBU8,
          1977 => Opcode::STBUX,
          1978 => Opcode::STBUX8,
          1979 => Opcode::STBX,
          1980 => Opcode::STBX8,
          1981 => Opcode::STBXTLS,
          1982 => Opcode::STBXTLS_,
          1983 => Opcode::STBXTLS_32,
          1984 => Opcode::STD,
          1985 => Opcode::STDAT,
          1986 => Opcode::STDBRX,
          1987 => Opcode::STDCIX,
          1988 => Opcode::STDCX,
          1989 => Opcode::STDU,
          1990 => Opcode::STDUX,
          1991 => Opcode::STDX,
          1992 => Opcode::STDXTLS,
          1993 => Opcode::STDXTLS_,
          1994 => Opcode::STFD,
          1995 => Opcode::STFDEPX,
          1996 => Opcode::STFDU,
          1997 => Opcode::STFDUX,
          1998 => Opcode::STFDX,
          1999 => Opcode::STFDXTLS,
          2000 => Opcode::STFDXTLS_,
          2001 => Opcode::STFIWX,
          2002 => Opcode::STFS,
          2003 => Opcode::STFSU,
          2004 => Opcode::STFSUX,
          2005 => Opcode::STFSX,
          2006 => Opcode::STFSXTLS,
          2007 => Opcode::STFSXTLS_,
          2008 => Opcode::STH,
          2009 => Opcode::STH8,
          2010 => Opcode::STHBRX,
          2011 => Opcode::STHCIX,
          2012 => Opcode::STHCX,
          2013 => Opcode::STHEPX,
          2014 => Opcode::STHU,
          2015 => Opcode::STHU8,
          2016 => Opcode::STHUX,
          2017 => Opcode::STHUX8,
          2018 => Opcode::STHX,
          2019 => Opcode::STHX8,
          2020 => Opcode::STHXTLS,
          2021 => Opcode::STHXTLS_,
          2022 => Opcode::STHXTLS_32,
          2023 => Opcode::STMW,
          2024 => Opcode::STOP,
          2025 => Opcode::STQ,
          2026 => Opcode::STQCX,
          2027 => Opcode::STQX_PSEUDO,
          2028 => Opcode::STSWI,
          2029 => Opcode::STVEBX,
          2030 => Opcode::STVEHX,
          2031 => Opcode::STVEWX,
          2032 => Opcode::STVX,
          2033 => Opcode::STVXL,
          2034 => Opcode::STW,
          2035 => Opcode::STW8,
          2036 => Opcode::STWAT,
          2037 => Opcode::STWBRX,
          2038 => Opcode::STWCIX,
          2039 => Opcode::STWCX,
          2040 => Opcode::STWEPX,
          2041 => Opcode::STWU,
          2042 => Opcode::STWU8,
          2043 => Opcode::STWUX,
          2044 => Opcode::STWUX8,
          2045 => Opcode::STWX,
          2046 => Opcode::STWX8,
          2047 => Opcode::STWXTLS,
          2048 => Opcode::STWXTLS_,
          2049 => Opcode::STWXTLS_32,
          2050 => Opcode::STXSD,
          2051 => Opcode::STXSDX,
          2052 => Opcode::STXSIBX,
          2053 => Opcode::STXSIBXv,
          2054 => Opcode::STXSIHX,
          2055 => Opcode::STXSIHXv,
          2056 => Opcode::STXSIWX,
          2057 => Opcode::STXSSP,
          2058 => Opcode::STXSSPX,
          2059 => Opcode::STXV,
          2060 => Opcode::STXVB16X,
          2061 => Opcode::STXVD2X,
          2062 => Opcode::STXVH8X,
          2063 => Opcode::STXVL,
          2064 => Opcode::STXVLL,
          2065 => Opcode::STXVP,
          2066 => Opcode::STXVPRL,
          2067 => Opcode::STXVPRLL,
          2068 => Opcode::STXVPX,
          2069 => Opcode::STXVRBX,
          2070 => Opcode::STXVRDX,
          2071 => Opcode::STXVRHX,
          2072 => Opcode::STXVRL,
          2073 => Opcode::STXVRLL,
          2074 => Opcode::STXVRWX,
          2075 => Opcode::STXVW4X,
          2076 => Opcode::STXVX,
          2077 => Opcode::SUBF,
          2078 => Opcode::SUBF8,
          2079 => Opcode::SUBF8O,
          2080 => Opcode::SUBF8O_rec,
          2081 => Opcode::SUBF8_rec,
          2082 => Opcode::SUBFC,
          2083 => Opcode::SUBFC8,
          2084 => Opcode::SUBFC8O,
          2085 => Opcode::SUBFC8O_rec,
          2086 => Opcode::SUBFC8_rec,
          2087 => Opcode::SUBFCO,
          2088 => Opcode::SUBFCO_rec,
          2089 => Opcode::SUBFC_rec,
          2090 => Opcode::SUBFE,
          2091 => Opcode::SUBFE8,
          2092 => Opcode::SUBFE8O,
          2093 => Opcode::SUBFE8O_rec,
          2094 => Opcode::SUBFE8_rec,
          2095 => Opcode::SUBFEO,
          2096 => Opcode::SUBFEO_rec,
          2097 => Opcode::SUBFE_rec,
          2098 => Opcode::SUBFIC,
          2099 => Opcode::SUBFIC8,
          2100 => Opcode::SUBFME,
          2101 => Opcode::SUBFME8,
          2102 => Opcode::SUBFME8O,
          2103 => Opcode::SUBFME8O_rec,
          2104 => Opcode::SUBFME8_rec,
          2105 => Opcode::SUBFMEO,
          2106 => Opcode::SUBFMEO_rec,
          2107 => Opcode::SUBFME_rec,
          2108 => Opcode::SUBFO,
          2109 => Opcode::SUBFO_rec,
          2110 => Opcode::SUBFUS,
          2111 => Opcode::SUBFUS_rec,
          2112 => Opcode::SUBFZE,
          2113 => Opcode::SUBFZE8,
          2114 => Opcode::SUBFZE8O,
          2115 => Opcode::SUBFZE8O_rec,
          2116 => Opcode::SUBFZE8_rec,
          2117 => Opcode::SUBFZEO,
          2118 => Opcode::SUBFZEO_rec,
          2119 => Opcode::SUBFZE_rec,
          2120 => Opcode::SUBF_rec,
          2121 => Opcode::SYNC,
          2122 => Opcode::SYNCP10,
          2123 => Opcode::TABORT,
          2124 => Opcode::TABORTDC,
          2125 => Opcode::TABORTDCI,
          2126 => Opcode::TABORTWC,
          2127 => Opcode::TABORTWCI,
          2128 => Opcode::TAILB,
          2129 => Opcode::TAILB8,
          2130 => Opcode::TAILBA,
          2131 => Opcode::TAILBA8,
          2132 => Opcode::TAILBCTR,
          2133 => Opcode::TAILBCTR8,
          2134 => Opcode::TBEGIN,
          2135 => Opcode::TBEGIN_RET,
          2136 => Opcode::TCHECK,
          2137 => Opcode::TCHECK_RET,
          2138 => Opcode::TCRETURNai,
          2139 => Opcode::TCRETURNai8,
          2140 => Opcode::TCRETURNdi,
          2141 => Opcode::TCRETURNdi8,
          2142 => Opcode::TCRETURNri,
          2143 => Opcode::TCRETURNri8,
          2144 => Opcode::TD,
          2145 => Opcode::TDI,
          2146 => Opcode::TEND,
          2147 => Opcode::TLBIA,
          2148 => Opcode::TLBIE,
          2149 => Opcode::TLBIEL,
          2150 => Opcode::TLBILX,
          2151 => Opcode::TLBIVAX,
          2152 => Opcode::TLBLD,
          2153 => Opcode::TLBLI,
          2154 => Opcode::TLBRE,
          2155 => Opcode::TLBRE2,
          2156 => Opcode::TLBSX,
          2157 => Opcode::TLBSX2,
          2158 => Opcode::TLBSX2D,
          2159 => Opcode::TLBSYNC,
          2160 => Opcode::TLBWE,
          2161 => Opcode::TLBWE2,
          2162 => Opcode::TLSGDAIX,
          2163 => Opcode::TLSGDAIX8,
          2164 => Opcode::TLSLDAIX,
          2165 => Opcode::TLSLDAIX8,
          2166 => Opcode::TRAP,
          2167 => Opcode::TRECHKPT,
          2168 => Opcode::TRECLAIM,
          2169 => Opcode::TSR,
          2170 => Opcode::TW,
          2171 => Opcode::TWI,
          2172 => Opcode::UNENCODED_NOP,
          2173 => Opcode::UpdateGBR,
          2174 => Opcode::VABSDUB,
          2175 => Opcode::VABSDUH,
          2176 => Opcode::VABSDUW,
          2177 => Opcode::VADDCUQ,
          2178 => Opcode::VADDCUW,
          2179 => Opcode::VADDECUQ,
          2180 => Opcode::VADDEUQM,
          2181 => Opcode::VADDFP,
          2182 => Opcode::VADDSBS,
          2183 => Opcode::VADDSHS,
          2184 => Opcode::VADDSWS,
          2185 => Opcode::VADDUBM,
          2186 => Opcode::VADDUBS,
          2187 => Opcode::VADDUDM,
          2188 => Opcode::VADDUHM,
          2189 => Opcode::VADDUHS,
          2190 => Opcode::VADDUQM,
          2191 => Opcode::VADDUWM,
          2192 => Opcode::VADDUWS,
          2193 => Opcode::VAND,
          2194 => Opcode::VANDC,
          2195 => Opcode::VAVGSB,
          2196 => Opcode::VAVGSH,
          2197 => Opcode::VAVGSW,
          2198 => Opcode::VAVGUB,
          2199 => Opcode::VAVGUH,
          2200 => Opcode::VAVGUW,
          2201 => Opcode::VBPERMD,
          2202 => Opcode::VBPERMQ,
          2203 => Opcode::VCFSX,
          2204 => Opcode::VCFSX_0,
          2205 => Opcode::VCFUGED,
          2206 => Opcode::VCFUX,
          2207 => Opcode::VCFUX_0,
          2208 => Opcode::VCIPHER,
          2209 => Opcode::VCIPHERLAST,
          2210 => Opcode::VCLRLB,
          2211 => Opcode::VCLRRB,
          2212 => Opcode::VCLZB,
          2213 => Opcode::VCLZD,
          2214 => Opcode::VCLZDM,
          2215 => Opcode::VCLZH,
          2216 => Opcode::VCLZLSBB,
          2217 => Opcode::VCLZW,
          2218 => Opcode::VCMPBFP,
          2219 => Opcode::VCMPBFP_rec,
          2220 => Opcode::VCMPEQFP,
          2221 => Opcode::VCMPEQFP_rec,
          2222 => Opcode::VCMPEQUB,
          2223 => Opcode::VCMPEQUB_rec,
          2224 => Opcode::VCMPEQUD,
          2225 => Opcode::VCMPEQUD_rec,
          2226 => Opcode::VCMPEQUH,
          2227 => Opcode::VCMPEQUH_rec,
          2228 => Opcode::VCMPEQUQ,
          2229 => Opcode::VCMPEQUQ_rec,
          2230 => Opcode::VCMPEQUW,
          2231 => Opcode::VCMPEQUW_rec,
          2232 => Opcode::VCMPGEFP,
          2233 => Opcode::VCMPGEFP_rec,
          2234 => Opcode::VCMPGTFP,
          2235 => Opcode::VCMPGTFP_rec,
          2236 => Opcode::VCMPGTSB,
          2237 => Opcode::VCMPGTSB_rec,
          2238 => Opcode::VCMPGTSD,
          2239 => Opcode::VCMPGTSD_rec,
          2240 => Opcode::VCMPGTSH,
          2241 => Opcode::VCMPGTSH_rec,
          2242 => Opcode::VCMPGTSQ,
          2243 => Opcode::VCMPGTSQ_rec,
          2244 => Opcode::VCMPGTSW,
          2245 => Opcode::VCMPGTSW_rec,
          2246 => Opcode::VCMPGTUB,
          2247 => Opcode::VCMPGTUB_rec,
          2248 => Opcode::VCMPGTUD,
          2249 => Opcode::VCMPGTUD_rec,
          2250 => Opcode::VCMPGTUH,
          2251 => Opcode::VCMPGTUH_rec,
          2252 => Opcode::VCMPGTUQ,
          2253 => Opcode::VCMPGTUQ_rec,
          2254 => Opcode::VCMPGTUW,
          2255 => Opcode::VCMPGTUW_rec,
          2256 => Opcode::VCMPNEB,
          2257 => Opcode::VCMPNEB_rec,
          2258 => Opcode::VCMPNEH,
          2259 => Opcode::VCMPNEH_rec,
          2260 => Opcode::VCMPNEW,
          2261 => Opcode::VCMPNEW_rec,
          2262 => Opcode::VCMPNEZB,
          2263 => Opcode::VCMPNEZB_rec,
          2264 => Opcode::VCMPNEZH,
          2265 => Opcode::VCMPNEZH_rec,
          2266 => Opcode::VCMPNEZW,
          2267 => Opcode::VCMPNEZW_rec,
          2268 => Opcode::VCMPSQ,
          2269 => Opcode::VCMPUQ,
          2270 => Opcode::VCNTMBB,
          2271 => Opcode::VCNTMBD,
          2272 => Opcode::VCNTMBH,
          2273 => Opcode::VCNTMBW,
          2274 => Opcode::VCTSXS,
          2275 => Opcode::VCTSXS_0,
          2276 => Opcode::VCTUXS,
          2277 => Opcode::VCTUXS_0,
          2278 => Opcode::VCTZB,
          2279 => Opcode::VCTZD,
          2280 => Opcode::VCTZDM,
          2281 => Opcode::VCTZH,
          2282 => Opcode::VCTZLSBB,
          2283 => Opcode::VCTZW,
          2284 => Opcode::VDIVESD,
          2285 => Opcode::VDIVESQ,
          2286 => Opcode::VDIVESW,
          2287 => Opcode::VDIVEUD,
          2288 => Opcode::VDIVEUQ,
          2289 => Opcode::VDIVEUW,
          2290 => Opcode::VDIVSD,
          2291 => Opcode::VDIVSQ,
          2292 => Opcode::VDIVSW,
          2293 => Opcode::VDIVUD,
          2294 => Opcode::VDIVUQ,
          2295 => Opcode::VDIVUW,
          2296 => Opcode::VEQV,
          2297 => Opcode::VEXPANDBM,
          2298 => Opcode::VEXPANDDM,
          2299 => Opcode::VEXPANDHM,
          2300 => Opcode::VEXPANDQM,
          2301 => Opcode::VEXPANDWM,
          2302 => Opcode::VEXPTEFP,
          2303 => Opcode::VEXTDDVLX,
          2304 => Opcode::VEXTDDVRX,
          2305 => Opcode::VEXTDUBVLX,
          2306 => Opcode::VEXTDUBVRX,
          2307 => Opcode::VEXTDUHVLX,
          2308 => Opcode::VEXTDUHVRX,
          2309 => Opcode::VEXTDUWVLX,
          2310 => Opcode::VEXTDUWVRX,
          2311 => Opcode::VEXTRACTBM,
          2312 => Opcode::VEXTRACTD,
          2313 => Opcode::VEXTRACTDM,
          2314 => Opcode::VEXTRACTHM,
          2315 => Opcode::VEXTRACTQM,
          2316 => Opcode::VEXTRACTUB,
          2317 => Opcode::VEXTRACTUH,
          2318 => Opcode::VEXTRACTUW,
          2319 => Opcode::VEXTRACTWM,
          2320 => Opcode::VEXTSB2D,
          2321 => Opcode::VEXTSB2Ds,
          2322 => Opcode::VEXTSB2W,
          2323 => Opcode::VEXTSB2Ws,
          2324 => Opcode::VEXTSD2Q,
          2325 => Opcode::VEXTSH2D,
          2326 => Opcode::VEXTSH2Ds,
          2327 => Opcode::VEXTSH2W,
          2328 => Opcode::VEXTSH2Ws,
          2329 => Opcode::VEXTSW2D,
          2330 => Opcode::VEXTSW2Ds,
          2331 => Opcode::VEXTUBLX,
          2332 => Opcode::VEXTUBRX,
          2333 => Opcode::VEXTUHLX,
          2334 => Opcode::VEXTUHRX,
          2335 => Opcode::VEXTUWLX,
          2336 => Opcode::VEXTUWRX,
          2337 => Opcode::VGBBD,
          2338 => Opcode::VGNB,
          2339 => Opcode::VINSBLX,
          2340 => Opcode::VINSBRX,
          2341 => Opcode::VINSBVLX,
          2342 => Opcode::VINSBVRX,
          2343 => Opcode::VINSD,
          2344 => Opcode::VINSDLX,
          2345 => Opcode::VINSDRX,
          2346 => Opcode::VINSERTB,
          2347 => Opcode::VINSERTD,
          2348 => Opcode::VINSERTH,
          2349 => Opcode::VINSERTW,
          2350 => Opcode::VINSHLX,
          2351 => Opcode::VINSHRX,
          2352 => Opcode::VINSHVLX,
          2353 => Opcode::VINSHVRX,
          2354 => Opcode::VINSW,
          2355 => Opcode::VINSWLX,
          2356 => Opcode::VINSWRX,
          2357 => Opcode::VINSWVLX,
          2358 => Opcode::VINSWVRX,
          2359 => Opcode::VLOGEFP,
          2360 => Opcode::VMADDFP,
          2361 => Opcode::VMAXFP,
          2362 => Opcode::VMAXSB,
          2363 => Opcode::VMAXSD,
          2364 => Opcode::VMAXSH,
          2365 => Opcode::VMAXSW,
          2366 => Opcode::VMAXUB,
          2367 => Opcode::VMAXUD,
          2368 => Opcode::VMAXUH,
          2369 => Opcode::VMAXUW,
          2370 => Opcode::VMHADDSHS,
          2371 => Opcode::VMHRADDSHS,
          2372 => Opcode::VMINFP,
          2373 => Opcode::VMINSB,
          2374 => Opcode::VMINSD,
          2375 => Opcode::VMINSH,
          2376 => Opcode::VMINSW,
          2377 => Opcode::VMINUB,
          2378 => Opcode::VMINUD,
          2379 => Opcode::VMINUH,
          2380 => Opcode::VMINUW,
          2381 => Opcode::VMLADDUHM,
          2382 => Opcode::VMODSD,
          2383 => Opcode::VMODSQ,
          2384 => Opcode::VMODSW,
          2385 => Opcode::VMODUD,
          2386 => Opcode::VMODUQ,
          2387 => Opcode::VMODUW,
          2388 => Opcode::VMRGEW,
          2389 => Opcode::VMRGHB,
          2390 => Opcode::VMRGHH,
          2391 => Opcode::VMRGHW,
          2392 => Opcode::VMRGLB,
          2393 => Opcode::VMRGLH,
          2394 => Opcode::VMRGLW,
          2395 => Opcode::VMRGOW,
          2396 => Opcode::VMSUMCUD,
          2397 => Opcode::VMSUMMBM,
          2398 => Opcode::VMSUMSHM,
          2399 => Opcode::VMSUMSHS,
          2400 => Opcode::VMSUMUBM,
          2401 => Opcode::VMSUMUDM,
          2402 => Opcode::VMSUMUHM,
          2403 => Opcode::VMSUMUHS,
          2404 => Opcode::VMUL10CUQ,
          2405 => Opcode::VMUL10ECUQ,
          2406 => Opcode::VMUL10EUQ,
          2407 => Opcode::VMUL10UQ,
          2408 => Opcode::VMULESB,
          2409 => Opcode::VMULESD,
          2410 => Opcode::VMULESH,
          2411 => Opcode::VMULESW,
          2412 => Opcode::VMULEUB,
          2413 => Opcode::VMULEUD,
          2414 => Opcode::VMULEUH,
          2415 => Opcode::VMULEUW,
          2416 => Opcode::VMULHSD,
          2417 => Opcode::VMULHSW,
          2418 => Opcode::VMULHUD,
          2419 => Opcode::VMULHUW,
          2420 => Opcode::VMULLD,
          2421 => Opcode::VMULOSB,
          2422 => Opcode::VMULOSD,
          2423 => Opcode::VMULOSH,
          2424 => Opcode::VMULOSW,
          2425 => Opcode::VMULOUB,
          2426 => Opcode::VMULOUD,
          2427 => Opcode::VMULOUH,
          2428 => Opcode::VMULOUW,
          2429 => Opcode::VMULUWM,
          2430 => Opcode::VNAND,
          2431 => Opcode::VNCIPHER,
          2432 => Opcode::VNCIPHERLAST,
          2433 => Opcode::VNEGD,
          2434 => Opcode::VNEGW,
          2435 => Opcode::VNMSUBFP,
          2436 => Opcode::VNOR,
          2437 => Opcode::VOR,
          2438 => Opcode::VORC,
          2439 => Opcode::VPDEPD,
          2440 => Opcode::VPERM,
          2441 => Opcode::VPERMR,
          2442 => Opcode::VPERMXOR,
          2443 => Opcode::VPEXTD,
          2444 => Opcode::VPKPX,
          2445 => Opcode::VPKSDSS,
          2446 => Opcode::VPKSDUS,
          2447 => Opcode::VPKSHSS,
          2448 => Opcode::VPKSHUS,
          2449 => Opcode::VPKSWSS,
          2450 => Opcode::VPKSWUS,
          2451 => Opcode::VPKUDUM,
          2452 => Opcode::VPKUDUS,
          2453 => Opcode::VPKUHUM,
          2454 => Opcode::VPKUHUS,
          2455 => Opcode::VPKUWUM,
          2456 => Opcode::VPKUWUS,
          2457 => Opcode::VPMSUMB,
          2458 => Opcode::VPMSUMD,
          2459 => Opcode::VPMSUMH,
          2460 => Opcode::VPMSUMW,
          2461 => Opcode::VPOPCNTB,
          2462 => Opcode::VPOPCNTD,
          2463 => Opcode::VPOPCNTH,
          2464 => Opcode::VPOPCNTW,
          2465 => Opcode::VPRTYBD,
          2466 => Opcode::VPRTYBQ,
          2467 => Opcode::VPRTYBW,
          2468 => Opcode::VREFP,
          2469 => Opcode::VRFIM,
          2470 => Opcode::VRFIN,
          2471 => Opcode::VRFIP,
          2472 => Opcode::VRFIZ,
          2473 => Opcode::VRLB,
          2474 => Opcode::VRLD,
          2475 => Opcode::VRLDMI,
          2476 => Opcode::VRLDNM,
          2477 => Opcode::VRLH,
          2478 => Opcode::VRLQ,
          2479 => Opcode::VRLQMI,
          2480 => Opcode::VRLQNM,
          2481 => Opcode::VRLW,
          2482 => Opcode::VRLWMI,
          2483 => Opcode::VRLWNM,
          2484 => Opcode::VRSQRTEFP,
          2485 => Opcode::VSBOX,
          2486 => Opcode::VSEL,
          2487 => Opcode::VSHASIGMAD,
          2488 => Opcode::VSHASIGMAW,
          2489 => Opcode::VSL,
          2490 => Opcode::VSLB,
          2491 => Opcode::VSLD,
          2492 => Opcode::VSLDBI,
          2493 => Opcode::VSLDOI,
          2494 => Opcode::VSLH,
          2495 => Opcode::VSLO,
          2496 => Opcode::VSLQ,
          2497 => Opcode::VSLV,
          2498 => Opcode::VSLW,
          2499 => Opcode::VSPLTB,
          2500 => Opcode::VSPLTBs,
          2501 => Opcode::VSPLTH,
          2502 => Opcode::VSPLTHs,
          2503 => Opcode::VSPLTISB,
          2504 => Opcode::VSPLTISH,
          2505 => Opcode::VSPLTISW,
          2506 => Opcode::VSPLTW,
          2507 => Opcode::VSR,
          2508 => Opcode::VSRAB,
          2509 => Opcode::VSRAD,
          2510 => Opcode::VSRAH,
          2511 => Opcode::VSRAQ,
          2512 => Opcode::VSRAW,
          2513 => Opcode::VSRB,
          2514 => Opcode::VSRD,
          2515 => Opcode::VSRDBI,
          2516 => Opcode::VSRH,
          2517 => Opcode::VSRO,
          2518 => Opcode::VSRQ,
          2519 => Opcode::VSRV,
          2520 => Opcode::VSRW,
          2521 => Opcode::VSTRIBL,
          2522 => Opcode::VSTRIBL_rec,
          2523 => Opcode::VSTRIBR,
          2524 => Opcode::VSTRIBR_rec,
          2525 => Opcode::VSTRIHL,
          2526 => Opcode::VSTRIHL_rec,
          2527 => Opcode::VSTRIHR,
          2528 => Opcode::VSTRIHR_rec,
          2529 => Opcode::VSUBCUQ,
          2530 => Opcode::VSUBCUW,
          2531 => Opcode::VSUBECUQ,
          2532 => Opcode::VSUBEUQM,
          2533 => Opcode::VSUBFP,
          2534 => Opcode::VSUBSBS,
          2535 => Opcode::VSUBSHS,
          2536 => Opcode::VSUBSWS,
          2537 => Opcode::VSUBUBM,
          2538 => Opcode::VSUBUBS,
          2539 => Opcode::VSUBUDM,
          2540 => Opcode::VSUBUHM,
          2541 => Opcode::VSUBUHS,
          2542 => Opcode::VSUBUQM,
          2543 => Opcode::VSUBUWM,
          2544 => Opcode::VSUBUWS,
          2545 => Opcode::VSUM2SWS,
          2546 => Opcode::VSUM4SBS,
          2547 => Opcode::VSUM4SHS,
          2548 => Opcode::VSUM4UBS,
          2549 => Opcode::VSUMSWS,
          2550 => Opcode::VUPKHPX,
          2551 => Opcode::VUPKHSB,
          2552 => Opcode::VUPKHSH,
          2553 => Opcode::VUPKHSW,
          2554 => Opcode::VUPKLPX,
          2555 => Opcode::VUPKLSB,
          2556 => Opcode::VUPKLSH,
          2557 => Opcode::VUPKLSW,
          2558 => Opcode::VXOR,
          2559 => Opcode::V_SET0,
          2560 => Opcode::V_SET0B,
          2561 => Opcode::V_SET0H,
          2562 => Opcode::V_SETALLONES,
          2563 => Opcode::V_SETALLONESB,
          2564 => Opcode::V_SETALLONESH,
          2565 => Opcode::WAIT,
          2566 => Opcode::WAITP10,
          2567 => Opcode::WRTEE,
          2568 => Opcode::WRTEEI,
          2569 => Opcode::XOR,
          2570 => Opcode::XOR8,
          2571 => Opcode::XOR8_rec,
          2572 => Opcode::XORI,
          2573 => Opcode::XORI8,
          2574 => Opcode::XORIS,
          2575 => Opcode::XORIS8,
          2576 => Opcode::XOR_rec,
          2577 => Opcode::XSABSDP,
          2578 => Opcode::XSABSQP,
          2579 => Opcode::XSADDDP,
          2580 => Opcode::XSADDQP,
          2581 => Opcode::XSADDQPO,
          2582 => Opcode::XSADDSP,
          2583 => Opcode::XSCMPEQDP,
          2584 => Opcode::XSCMPEQQP,
          2585 => Opcode::XSCMPEXPDP,
          2586 => Opcode::XSCMPEXPQP,
          2587 => Opcode::XSCMPGEDP,
          2588 => Opcode::XSCMPGEQP,
          2589 => Opcode::XSCMPGTDP,
          2590 => Opcode::XSCMPGTQP,
          2591 => Opcode::XSCMPODP,
          2592 => Opcode::XSCMPOQP,
          2593 => Opcode::XSCMPUDP,
          2594 => Opcode::XSCMPUQP,
          2595 => Opcode::XSCPSGNDP,
          2596 => Opcode::XSCPSGNQP,
          2597 => Opcode::XSCVDPHP,
          2598 => Opcode::XSCVDPQP,
          2599 => Opcode::XSCVDPSP,
          2600 => Opcode::XSCVDPSPN,
          2601 => Opcode::XSCVDPSXDS,
          2602 => Opcode::XSCVDPSXDSs,
          2603 => Opcode::XSCVDPSXWS,
          2604 => Opcode::XSCVDPSXWSs,
          2605 => Opcode::XSCVDPUXDS,
          2606 => Opcode::XSCVDPUXDSs,
          2607 => Opcode::XSCVDPUXWS,
          2608 => Opcode::XSCVDPUXWSs,
          2609 => Opcode::XSCVHPDP,
          2610 => Opcode::XSCVQPDP,
          2611 => Opcode::XSCVQPDPO,
          2612 => Opcode::XSCVQPSDZ,
          2613 => Opcode::XSCVQPSQZ,
          2614 => Opcode::XSCVQPSWZ,
          2615 => Opcode::XSCVQPUDZ,
          2616 => Opcode::XSCVQPUQZ,
          2617 => Opcode::XSCVQPUWZ,
          2618 => Opcode::XSCVSDQP,
          2619 => Opcode::XSCVSPDP,
          2620 => Opcode::XSCVSPDPN,
          2621 => Opcode::XSCVSQQP,
          2622 => Opcode::XSCVSXDDP,
          2623 => Opcode::XSCVSXDSP,
          2624 => Opcode::XSCVUDQP,
          2625 => Opcode::XSCVUQQP,
          2626 => Opcode::XSCVUXDDP,
          2627 => Opcode::XSCVUXDSP,
          2628 => Opcode::XSDIVDP,
          2629 => Opcode::XSDIVQP,
          2630 => Opcode::XSDIVQPO,
          2631 => Opcode::XSDIVSP,
          2632 => Opcode::XSIEXPDP,
          2633 => Opcode::XSIEXPQP,
          2634 => Opcode::XSMADDADP,
          2635 => Opcode::XSMADDASP,
          2636 => Opcode::XSMADDMDP,
          2637 => Opcode::XSMADDMSP,
          2638 => Opcode::XSMADDQP,
          2639 => Opcode::XSMADDQPO,
          2640 => Opcode::XSMAXCDP,
          2641 => Opcode::XSMAXCQP,
          2642 => Opcode::XSMAXDP,
          2643 => Opcode::XSMAXJDP,
          2644 => Opcode::XSMINCDP,
          2645 => Opcode::XSMINCQP,
          2646 => Opcode::XSMINDP,
          2647 => Opcode::XSMINJDP,
          2648 => Opcode::XSMSUBADP,
          2649 => Opcode::XSMSUBASP,
          2650 => Opcode::XSMSUBMDP,
          2651 => Opcode::XSMSUBMSP,
          2652 => Opcode::XSMSUBQP,
          2653 => Opcode::XSMSUBQPO,
          2654 => Opcode::XSMULDP,
          2655 => Opcode::XSMULQP,
          2656 => Opcode::XSMULQPO,
          2657 => Opcode::XSMULSP,
          2658 => Opcode::XSNABSDP,
          2659 => Opcode::XSNABSDPs,
          2660 => Opcode::XSNABSQP,
          2661 => Opcode::XSNEGDP,
          2662 => Opcode::XSNEGQP,
          2663 => Opcode::XSNMADDADP,
          2664 => Opcode::XSNMADDASP,
          2665 => Opcode::XSNMADDMDP,
          2666 => Opcode::XSNMADDMSP,
          2667 => Opcode::XSNMADDQP,
          2668 => Opcode::XSNMADDQPO,
          2669 => Opcode::XSNMSUBADP,
          2670 => Opcode::XSNMSUBASP,
          2671 => Opcode::XSNMSUBMDP,
          2672 => Opcode::XSNMSUBMSP,
          2673 => Opcode::XSNMSUBQP,
          2674 => Opcode::XSNMSUBQPO,
          2675 => Opcode::XSRDPI,
          2676 => Opcode::XSRDPIC,
          2677 => Opcode::XSRDPIM,
          2678 => Opcode::XSRDPIP,
          2679 => Opcode::XSRDPIZ,
          2680 => Opcode::XSREDP,
          2681 => Opcode::XSRESP,
          2682 => Opcode::XSRQPI,
          2683 => Opcode::XSRQPIX,
          2684 => Opcode::XSRQPXP,
          2685 => Opcode::XSRSP,
          2686 => Opcode::XSRSQRTEDP,
          2687 => Opcode::XSRSQRTESP,
          2688 => Opcode::XSSQRTDP,
          2689 => Opcode::XSSQRTQP,
          2690 => Opcode::XSSQRTQPO,
          2691 => Opcode::XSSQRTSP,
          2692 => Opcode::XSSUBDP,
          2693 => Opcode::XSSUBQP,
          2694 => Opcode::XSSUBQPO,
          2695 => Opcode::XSSUBSP,
          2696 => Opcode::XSTDIVDP,
          2697 => Opcode::XSTSQRTDP,
          2698 => Opcode::XSTSTDCDP,
          2699 => Opcode::XSTSTDCQP,
          2700 => Opcode::XSTSTDCSP,
          2701 => Opcode::XSXEXPDP,
          2702 => Opcode::XSXEXPQP,
          2703 => Opcode::XSXSIGDP,
          2704 => Opcode::XSXSIGQP,
          2705 => Opcode::XVABSDP,
          2706 => Opcode::XVABSSP,
          2707 => Opcode::XVADDDP,
          2708 => Opcode::XVADDSP,
          2709 => Opcode::XVBF16GER2,
          2710 => Opcode::XVBF16GER2NN,
          2711 => Opcode::XVBF16GER2NP,
          2712 => Opcode::XVBF16GER2PN,
          2713 => Opcode::XVBF16GER2PP,
          2714 => Opcode::XVBF16GER2W,
          2715 => Opcode::XVBF16GER2WNN,
          2716 => Opcode::XVBF16GER2WNP,
          2717 => Opcode::XVBF16GER2WPN,
          2718 => Opcode::XVBF16GER2WPP,
          2719 => Opcode::XVCMPEQDP,
          2720 => Opcode::XVCMPEQDP_rec,
          2721 => Opcode::XVCMPEQSP,
          2722 => Opcode::XVCMPEQSP_rec,
          2723 => Opcode::XVCMPGEDP,
          2724 => Opcode::XVCMPGEDP_rec,
          2725 => Opcode::XVCMPGESP,
          2726 => Opcode::XVCMPGESP_rec,
          2727 => Opcode::XVCMPGTDP,
          2728 => Opcode::XVCMPGTDP_rec,
          2729 => Opcode::XVCMPGTSP,
          2730 => Opcode::XVCMPGTSP_rec,
          2731 => Opcode::XVCPSGNDP,
          2732 => Opcode::XVCPSGNSP,
          2733 => Opcode::XVCVBF16SPN,
          2734 => Opcode::XVCVDPSP,
          2735 => Opcode::XVCVDPSXDS,
          2736 => Opcode::XVCVDPSXWS,
          2737 => Opcode::XVCVDPUXDS,
          2738 => Opcode::XVCVDPUXWS,
          2739 => Opcode::XVCVHPSP,
          2740 => Opcode::XVCVSPBF16,
          2741 => Opcode::XVCVSPDP,
          2742 => Opcode::XVCVSPHP,
          2743 => Opcode::XVCVSPSXDS,
          2744 => Opcode::XVCVSPSXWS,
          2745 => Opcode::XVCVSPUXDS,
          2746 => Opcode::XVCVSPUXWS,
          2747 => Opcode::XVCVSXDDP,
          2748 => Opcode::XVCVSXDSP,
          2749 => Opcode::XVCVSXWDP,
          2750 => Opcode::XVCVSXWSP,
          2751 => Opcode::XVCVUXDDP,
          2752 => Opcode::XVCVUXDSP,
          2753 => Opcode::XVCVUXWDP,
          2754 => Opcode::XVCVUXWSP,
          2755 => Opcode::XVDIVDP,
          2756 => Opcode::XVDIVSP,
          2757 => Opcode::XVF16GER2,
          2758 => Opcode::XVF16GER2NN,
          2759 => Opcode::XVF16GER2NP,
          2760 => Opcode::XVF16GER2PN,
          2761 => Opcode::XVF16GER2PP,
          2762 => Opcode::XVF16GER2W,
          2763 => Opcode::XVF16GER2WNN,
          2764 => Opcode::XVF16GER2WNP,
          2765 => Opcode::XVF16GER2WPN,
          2766 => Opcode::XVF16GER2WPP,
          2767 => Opcode::XVF32GER,
          2768 => Opcode::XVF32GERNN,
          2769 => Opcode::XVF32GERNP,
          2770 => Opcode::XVF32GERPN,
          2771 => Opcode::XVF32GERPP,
          2772 => Opcode::XVF32GERW,
          2773 => Opcode::XVF32GERWNN,
          2774 => Opcode::XVF32GERWNP,
          2775 => Opcode::XVF32GERWPN,
          2776 => Opcode::XVF32GERWPP,
          2777 => Opcode::XVF64GER,
          2778 => Opcode::XVF64GERNN,
          2779 => Opcode::XVF64GERNP,
          2780 => Opcode::XVF64GERPN,
          2781 => Opcode::XVF64GERPP,
          2782 => Opcode::XVF64GERW,
          2783 => Opcode::XVF64GERWNN,
          2784 => Opcode::XVF64GERWNP,
          2785 => Opcode::XVF64GERWPN,
          2786 => Opcode::XVF64GERWPP,
          2787 => Opcode::XVI16GER2,
          2788 => Opcode::XVI16GER2PP,
          2789 => Opcode::XVI16GER2S,
          2790 => Opcode::XVI16GER2SPP,
          2791 => Opcode::XVI16GER2SW,
          2792 => Opcode::XVI16GER2SWPP,
          2793 => Opcode::XVI16GER2W,
          2794 => Opcode::XVI16GER2WPP,
          2795 => Opcode::XVI4GER8,
          2796 => Opcode::XVI4GER8PP,
          2797 => Opcode::XVI4GER8W,
          2798 => Opcode::XVI4GER8WPP,
          2799 => Opcode::XVI8GER4,
          2800 => Opcode::XVI8GER4PP,
          2801 => Opcode::XVI8GER4SPP,
          2802 => Opcode::XVI8GER4W,
          2803 => Opcode::XVI8GER4WPP,
          2804 => Opcode::XVI8GER4WSPP,
          2805 => Opcode::XVIEXPDP,
          2806 => Opcode::XVIEXPSP,
          2807 => Opcode::XVMADDADP,
          2808 => Opcode::XVMADDASP,
          2809 => Opcode::XVMADDMDP,
          2810 => Opcode::XVMADDMSP,
          2811 => Opcode::XVMAXDP,
          2812 => Opcode::XVMAXSP,
          2813 => Opcode::XVMINDP,
          2814 => Opcode::XVMINSP,
          2815 => Opcode::XVMSUBADP,
          2816 => Opcode::XVMSUBASP,
          2817 => Opcode::XVMSUBMDP,
          2818 => Opcode::XVMSUBMSP,
          2819 => Opcode::XVMULDP,
          2820 => Opcode::XVMULSP,
          2821 => Opcode::XVNABSDP,
          2822 => Opcode::XVNABSSP,
          2823 => Opcode::XVNEGDP,
          2824 => Opcode::XVNEGSP,
          2825 => Opcode::XVNMADDADP,
          2826 => Opcode::XVNMADDASP,
          2827 => Opcode::XVNMADDMDP,
          2828 => Opcode::XVNMADDMSP,
          2829 => Opcode::XVNMSUBADP,
          2830 => Opcode::XVNMSUBASP,
          2831 => Opcode::XVNMSUBMDP,
          2832 => Opcode::XVNMSUBMSP,
          2833 => Opcode::XVRDPI,
          2834 => Opcode::XVRDPIC,
          2835 => Opcode::XVRDPIM,
          2836 => Opcode::XVRDPIP,
          2837 => Opcode::XVRDPIZ,
          2838 => Opcode::XVREDP,
          2839 => Opcode::XVRESP,
          2840 => Opcode::XVRSPI,
          2841 => Opcode::XVRSPIC,
          2842 => Opcode::XVRSPIM,
          2843 => Opcode::XVRSPIP,
          2844 => Opcode::XVRSPIZ,
          2845 => Opcode::XVRSQRTEDP,
          2846 => Opcode::XVRSQRTESP,
          2847 => Opcode::XVSQRTDP,
          2848 => Opcode::XVSQRTSP,
          2849 => Opcode::XVSUBDP,
          2850 => Opcode::XVSUBSP,
          2851 => Opcode::XVTDIVDP,
          2852 => Opcode::XVTDIVSP,
          2853 => Opcode::XVTLSBB,
          2854 => Opcode::XVTSQRTDP,
          2855 => Opcode::XVTSQRTSP,
          2856 => Opcode::XVTSTDCDP,
          2857 => Opcode::XVTSTDCSP,
          2858 => Opcode::XVXEXPDP,
          2859 => Opcode::XVXEXPSP,
          2860 => Opcode::XVXSIGDP,
          2861 => Opcode::XVXSIGSP,
          2862 => Opcode::XXBLENDVB,
          2863 => Opcode::XXBLENDVD,
          2864 => Opcode::XXBLENDVH,
          2865 => Opcode::XXBLENDVW,
          2866 => Opcode::XXBRD,
          2867 => Opcode::XXBRH,
          2868 => Opcode::XXBRQ,
          2869 => Opcode::XXBRW,
          2870 => Opcode::XXEVAL,
          2871 => Opcode::XXEXTRACTUW,
          2872 => Opcode::XXGENPCVBM,
          2873 => Opcode::XXGENPCVDM,
          2874 => Opcode::XXGENPCVHM,
          2875 => Opcode::XXGENPCVWM,
          2876 => Opcode::XXINSERTW,
          2877 => Opcode::XXLAND,
          2878 => Opcode::XXLANDC,
          2879 => Opcode::XXLEQV,
          2880 => Opcode::XXLEQVOnes,
          2881 => Opcode::XXLNAND,
          2882 => Opcode::XXLNOR,
          2883 => Opcode::XXLOR,
          2884 => Opcode::XXLORC,
          2885 => Opcode::XXLORf,
          2886 => Opcode::XXLXOR,
          2887 => Opcode::XXLXORdpz,
          2888 => Opcode::XXLXORspz,
          2889 => Opcode::XXLXORz,
          2890 => Opcode::XXMFACC,
          2891 => Opcode::XXMFACCW,
          2892 => Opcode::XXMRGHW,
          2893 => Opcode::XXMRGLW,
          2894 => Opcode::XXMTACC,
          2895 => Opcode::XXMTACCW,
          2896 => Opcode::XXPERM,
          2897 => Opcode::XXPERMDI,
          2898 => Opcode::XXPERMDIs,
          2899 => Opcode::XXPERMR,
          2900 => Opcode::XXPERMX,
          2901 => Opcode::XXSEL,
          2902 => Opcode::XXSETACCZ,
          2903 => Opcode::XXSLDWI,
          2904 => Opcode::XXSLDWIs,
          2905 => Opcode::XXSPLTI32DX,
          2906 => Opcode::XXSPLTIB,
          2907 => Opcode::XXSPLTIDP,
          2908 => Opcode::XXSPLTIW,
          2909 => Opcode::XXSPLTW,
          2910 => Opcode::XXSPLTWs,
          2911 => Opcode::gBC,
          2912 => Opcode::gBCA,
          2913 => Opcode::gBCAat,
          2914 => Opcode::gBCCTR,
          2915 => Opcode::gBCCTRL,
          2916 => Opcode::gBCL,
          2917 => Opcode::gBCLA,
          2918 => Opcode::gBCLAat,
          2919 => Opcode::gBCLR,
          2920 => Opcode::gBCLRL,
          2921 => Opcode::gBCLat,
          2922 => Opcode::gBCat,
          2923 => Opcode::INSTRUCTION_LIST_END,
          _ => Opcode::UNKNOWN(value),
        }
    }
}
