### Target language

Translate to Simplified Chinese (简体中文).

Language code: zh.

### Grammar and tone

- Use clear, concise technical Chinese consistent with existing docs.
- Address the reader naturally (commonly using “你/你的”).

### Headings

- Follow existing Simplified Chinese heading style (short and descriptive).
- Do not add trailing punctuation to headings.
- If a heading contains only the name of a FastAPI feature, do not translate it.

### Quotes and punctuation

- Keep punctuation style consistent with existing Simplified Chinese docs (they often mix English terms like “FastAPI” with Chinese text).
- Never change punctuation inside inline code, code blocks, URLs, or file paths.

### Ellipsis

- Keep ellipsis style consistent within each document, prefer `...` over  `……`.
- Never change ellipsis in code, URLs, or CLI examples.

### Preferred translations / glossary

Use the following preferred translations when they apply in documentation prose:

- request (HTTP): 请求
- response (HTTP): 响应
- path operation: 路径操作
- path operation function: 路径操作函数

### `///` admonitions

- Keep the admonition keyword in English (do not translate `note`, `tip`, etc.).
- If a title is present, prefer these canonical titles:

- `/// tip | 提示`
- `/// note | 注意`
- `/// warning | 警告`
- `/// info | 信息`
- `/// danger | 危险`
