# Статус-код ответа { #response-status-code }

Подобно тому, как вы можете задать модель/схему ответа, вы можете объявить HTTP статус-код, используемый для ответа, с помощью параметра `status_code` в любой из *операций пути*:

* `@app.get()`
* `@app.post()`
* `@app.put()`
* `@app.delete()`
* и других.

{* ../../docs_src/response_status_code/tutorial001_py39.py hl[6] *}

/// note | Примечание

Обратите внимание, что `status_code` — это параметр метода-декоратора (`get`, `post` и т.д.), а не вашей *функции-обработчика пути*, в отличие от всех остальных параметров и тела запроса.

///

Параметр `status_code` принимает число, обозначающее HTTP статус-код.

/// info | Информация

В качестве значения параметра `status_code` также может использоваться `IntEnum`, например, из библиотеки <a href="https://docs.python.org/3/library/http.html#http.HTTPStatus" class="external-link" target="_blank">`http.HTTPStatus`</a> в Python.

///

Это позволит:

* Возвращать указанный код статуса в ответе.
* Документировать его как код статуса ответа в OpenAPI схеме (а значит, и в пользовательских интерфейсах):

<img src="/img/tutorial/response-status-code/image01.png">

/// note | Примечание

Некоторые коды статуса ответа (см. следующий раздел) указывают на то, что ответ не имеет тела.

FastAPI знает об этом и создаст документацию OpenAPI, в которой будет указано, что тело ответа отсутствует.

///

## Об HTTP статус-кодах { #about-http-status-codes }

/// note | Примечание

Если вы уже знаете, что представляют собой HTTP статус-коды, можете перейти к следующему разделу.

///

В протоколе HTTP числовой код состояния из 3 цифр отправляется как часть ответа.

У кодов статуса есть названия, чтобы упростить их распознавание, но важны именно числовые значения.

Кратко:

* `100 - 199` – статус-коды информационного типа. Они редко используются разработчиками напрямую. Ответы с этими кодами не могут иметь тела.
* **`200 - 299`** – статус-коды, сообщающие об успешной обработке запроса. Они используются чаще всего.
    * `200` – это код статуса ответа по умолчанию, который означает, что все прошло "OK".
    * Другим примером может быть статус `201`, "Created". Он обычно используется после создания новой записи в базе данных.
    * Особый случай – `204`, "No Content". Этот статус ответа используется, когда нет содержимого для возврата клиенту, и поэтому ответ не должен иметь тела.
* **`300 - 399`** – статус-коды, сообщающие о перенаправлениях. Ответы с этими кодами статуса могут иметь или не иметь тело, за исключением ответов со статусом `304`, "Not Modified", у которых не должно быть тела.
* **`400 - 499`** – статус-коды, сообщающие о клиентской ошибке. Это ещё одна наиболее часто используемая категория.
    * Пример – код `404` для статуса "Not Found".
    * Для общих ошибок со стороны клиента можно просто использовать код `400`.
* `500 - 599` – статус-коды, сообщающие о серверной ошибке. Они почти никогда не используются разработчиками напрямую. Когда что-то идет не так в какой-то части кода вашего приложения или на сервере, он автоматически вернёт один из этих кодов статуса.

/// tip | Подсказка

Чтобы узнать больше о HTTP кодах статуса и о том, для чего каждый из них предназначен, ознакомьтесь с <a href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Status" class="external-link" target="_blank"><abbr title="Mozilla Developer Network – Сеть разработчиков Mozilla">MDN</abbr> документацией об HTTP статус-кодах</a>.

///

## Краткие обозначения для запоминания названий кодов { #shortcut-to-remember-the-names }

Рассмотрим предыдущий пример еще раз:

{* ../../docs_src/response_status_code/tutorial001_py39.py hl[6] *}

`201` – это код статуса "Создано".

Но вам не обязательно запоминать, что означает каждый из этих кодов.

Для удобства вы можете использовать переменные из `fastapi.status`.

{* ../../docs_src/response_status_code/tutorial002_py39.py hl[1,6] *}

Они содержат те же числовые значения, но позволяют использовать автозавершение редактора кода для выбора кода статуса:

<img src="/img/tutorial/response-status-code/image02.png">

/// note | Технические детали

Вы также можете использовать `from starlette import status` вместо `from fastapi import status`.

**FastAPI** позволяет использовать как `starlette.status`, так и `fastapi.status` исключительно для удобства разработчиков. Но поставляется fastapi.status непосредственно из Starlette.

///

## Изменение кода статуса по умолчанию { #changing-the-default }

Позже, в [Руководстве для продвинутых пользователей](../advanced/response-change-status-code.md){.internal-link target=_blank}, вы узнаете, как возвращать HTTP статус-код, отличный от значения по умолчанию, которое вы объявляете здесь.
