# Модели Header-параметров { #header-parameter-models }

Если у вас есть группа связанных **header-параметров**, то вы можете объединить их в одну **Pydantic-модель**.

Это позволит вам **переиспользовать модель** в **разных местах**, а также задать валидацию и метаданные сразу для всех параметров. 😎

/// note | Заметка

Этот функционал доступен в FastAPI начиная с версии `0.115.0`. 🤓

///

## Header-параметры в виде Pydantic-модели { #header-parameters-with-a-pydantic-model }

Объявите нужные **header-параметры** в **Pydantic-модели** и затем аннотируйте параметр как `Header`:

{* ../../docs_src/header_param_models/tutorial001_an_py310.py hl[9:14,18] *}

**FastAPI** **извлечёт** данные для **каждого поля** из **заголовков** запроса и выдаст заданную вами Pydantic-модель.

## Проверьте документацию { #check-the-docs }

Вы можете посмотреть нужные header-параметры в графическом интерфейсе сгенерированной документации по пути `/docs`:

<div class="screenshot">
<img src="/img/tutorial/header-param-models/image01.png">
</div>

## Как запретить дополнительные заголовки { #forbid-extra-headers }

В некоторых случаях (не особо часто встречающихся) вам может понадобиться **ограничить** заголовки, которые вы хотите получать.

Вы можете использовать возможности конфигурации Pydantic-модели для того, чтобы запретить (`forbid`) любые дополнительные (`extra`) поля:

{* ../../docs_src/header_param_models/tutorial002_an_py310.py hl[10] *}

Если клиент попробует отправить **дополнительные заголовки**, то в ответ он получит **ошибку**.

Например, если клиент попытается отправить заголовок `tool` со значением `plumbus`, то в ответ он получит ошибку, сообщающую ему, что header-параметр `tool` не разрешен:

```json
{
    "detail": [
        {
            "type": "extra_forbidden",
            "loc": ["header", "tool"],
            "msg": "Extra inputs are not permitted",
            "input": "plumbus",
        }
    ]
}
```

## Как отключить автоматическое преобразование подчеркиваний { #disable-convert-underscores }

Как и в случае с обычными заголовками, если у вас в именах параметров имеются символы подчеркивания, они **автоматически преобразовываются в дефис**.

Например, если в коде есть header-параметр `save_data`, то ожидаемый HTTP-заголовок будет `save-data` и именно так он будет отображаться в документации.

Если по каким-то причинам вам нужно отключить данное автоматическое преобразование, это можно сделать и для Pydantic-моделей для header-параметров.

{* ../../docs_src/header_param_models/tutorial003_an_py310.py hl[19] *}

/// warning | Внимание

Перед тем как устанавливать для параметра `convert_underscores` значение `False`, имейте в виду, что некоторые HTTP-прокси и серверы не разрешают использовать заголовки с символами подчеркивания.

///

## Резюме { #summary }

Вы можете использовать **Pydantic-модели** для объявления **header-параметров** в **FastAPI**. 😎
