# FastAPI helfen – Hilfe erhalten { #help-fastapi-get-help }

Mögen Sie **FastAPI**?

Möchten Sie FastAPI, anderen Benutzern und dem Autor helfen?

Oder möchten Sie Hilfe zu **FastAPI** erhalten?

Es gibt sehr einfache Möglichkeiten zu helfen (einige erfordern nur ein oder zwei Klicks).

Und es gibt auch mehrere Möglichkeiten, Hilfe zu bekommen.

## Newsletter abonnieren { #subscribe-to-the-newsletter }

Sie können den (unregelmäßigen) [**FastAPI and friends**-Newsletter](newsletter.md){.internal-link target=_blank} abonnieren, um über folgende Themen informiert zu bleiben:

* Neuigkeiten über FastAPI und Freunde 🚀
* Anleitungen 📝
* Funktionen ✨
* Breaking Changes 🚨
* Tipps und Tricks ✅

## FastAPI auf X (Twitter) folgen { #follow-fastapi-on-x-twitter }

<a href="https://x.com/fastapi" class="external-link" target="_blank">Folgen Sie @fastapi auf **X (Twitter)**</a>, um die neuesten Nachrichten über **FastAPI** zu erhalten. 🐦

## **FastAPI** auf GitHub einen Stern geben { #star-fastapi-in-github }

Sie können FastAPI auf GitHub „starren“ (klicken Sie auf den Stern-Button oben rechts): <a href="https://github.com/fastapi/fastapi" class="external-link" target="_blank">https://github.com/fastapi/fastapi</a>. ⭐️

Durch das Hinzufügen eines Sterns können andere Benutzer es leichter finden und sehen, dass es für andere bereits nützlich war.

## Das GitHub-Repository auf Releases überwachen { #watch-the-github-repository-for-releases }

Sie können FastAPI auf GitHub „beobachten“ (klicken Sie auf den „watch“-Button oben rechts): <a href="https://github.com/fastapi/fastapi" class="external-link" target="_blank">https://github.com/fastapi/fastapi</a>. 👀

Dort können Sie „Releases only“ auswählen.

Auf diese Weise erhalten Sie Benachrichtigungen (per E-Mail), wenn es ein neues Release (eine neue Version) von **FastAPI** mit Bugfixes und neuen Funktionen gibt.

## Mit dem Autor vernetzen { #connect-with-the-author }

Sie können sich mit <a href="https://tiangolo.com" class="external-link" target="_blank">mir (Sebastián Ramírez / `tiangolo`)</a>, dem Autor, vernetzen.

Sie können:

* <a href="https://github.com/tiangolo" class="external-link" target="_blank">Mir auf **GitHub** folgen</a>.
    * Andere Open-Source-Projekte sehen, die ich erstellt habe und die Ihnen helfen könnten.
    * Mir folgen, um zu sehen, wenn ich ein neues Open-Source-Projekt erstelle.
* <a href="https://x.com/tiangolo" class="external-link" target="_blank">Mir auf **X (Twitter)** folgen</a> oder <a href="https://fosstodon.org/@tiangolo" class="external-link" target="_blank">Mastodon</a>.
    * Mir mitteilen, wie Sie FastAPI verwenden (ich höre das gerne).
    * Mitbekommen, wenn ich Ankündigungen mache oder neue Tools veröffentliche.
    * Sie können auch <a href="https://x.com/fastapi" class="external-link" target="_blank">@fastapi auf X (Twitter) folgen</a> (ein separates Konto).
* <a href="https://www.linkedin.com/in/tiangolo/" class="external-link" target="_blank">Mir auf **LinkedIn** folgen</a>.
    * Mitbekommen, wenn ich Ankündigungen mache oder neue Tools veröffentliche (obwohl ich X (Twitter) häufiger verwende 🤷‍♂).
* Lesen, was ich schreibe (oder mir folgen) auf <a href="https://dev.to/tiangolo" class="external-link" target="_blank">**Dev.to**</a> oder <a href="https://medium.com/@tiangolo" class="external-link" target="_blank">**Medium**</a>.
    * Andere Ideen, Artikel lesen und mehr über die von mir erstellten Tools erfahren.
    * Mir folgen, um zu lesen, wenn ich etwas Neues veröffentliche.

## Über **FastAPI** tweeten { #tweet-about-fastapi }

<a href="https://x.com/compose/tweet?text=I'm loving @fastapi because... https://github.com/fastapi/fastapi" class="external-link" target="_blank">Tweeten Sie über **FastAPI**</a> und teilen Sie mir und anderen mit, warum es Ihnen gefällt. 🎉

Ich höre gerne, wie **FastAPI** verwendet wird, was Ihnen daran gefallen hat, in welchem Projekt/Unternehmen Sie es verwenden, usw.

## Für FastAPI abstimmen { #vote-for-fastapi }

* <a href="https://www.slant.co/options/34241/~fastapi-review" class="external-link" target="_blank">Stimmen Sie für **FastAPI** auf Slant</a>.
* <a href="https://alternativeto.net/software/fastapi/about/" class="external-link" target="_blank">Stimmen Sie für **FastAPI** auf AlternativeTo</a>.
* <a href="https://stackshare.io/pypi-fastapi" class="external-link" target="_blank">Sagen Sie auf StackShare, dass Sie **FastAPI** verwenden</a>.

## Anderen bei Fragen auf GitHub helfen { #help-others-with-questions-in-github }

Sie können versuchen, anderen bei ihren Fragen zu helfen:

* <a href="https://github.com/fastapi/fastapi/discussions/categories/questions?discussions_q=category%3AQuestions+is%3Aunanswered" class="external-link" target="_blank">GitHub-Diskussionen</a>
* <a href="https://github.com/fastapi/fastapi/issues?q=is%3Aissue+is%3Aopen+sort%3Aupdated-desc+label%3Aquestion+-label%3Aanswered+" class="external-link" target="_blank">GitHub-Issues</a>

In vielen Fällen kennen Sie möglicherweise bereits die Antwort auf diese Fragen. 🤓

Wenn Sie vielen Menschen bei ihren Fragen helfen, werden Sie offizieller [FastAPI-Experte](fastapi-people.md#fastapi-experts){.internal-link target=_blank}. 🎉

Denken Sie daran, der wichtigste Punkt ist: Versuchen Sie, freundlich zu sein. Die Leute bringen ihre Frustrationen mit und fragen in vielen Fällen nicht auf die beste Art und Weise, aber versuchen Sie dennoch so gut wie möglich, freundlich zu sein. 🤗

Die **FastAPI**-Community soll freundlich und einladend sein. Akzeptieren Sie gleichzeitig kein Mobbing oder respektloses Verhalten gegenüber anderen. Wir müssen uns umeinander kümmern.

---

So helfen Sie anderen bei Fragen (in Diskussionen oder Issues):

### Die Frage verstehen { #understand-the-question }

* Prüfen Sie, ob Sie verstehen können, was der **Zweck** und der Anwendungsfall der fragenden Person ist.

* Überprüfen Sie dann, ob die Frage (die überwiegende Mehrheit sind Fragen) **klar** ist.

* In vielen Fällen handelt es sich bei der gestellten Frage um eine Lösung, die der Benutzer sich vorstellt, aber es könnte eine **bessere** Lösung geben. Wenn Sie das Problem und den Anwendungsfall besser verstehen, können Sie eine bessere **Alternativlösung** vorschlagen.

* Wenn Sie die Frage nicht verstehen können, fragen Sie nach weiteren **Details**.

### Das Problem reproduzieren { #reproduce-the-problem }

In den meisten Fällen und bei den meisten Fragen gibt es etwas in Bezug auf den **originalen Code** der Person.

In vielen Fällen wird nur ein Fragment des Codes gepostet, aber das reicht nicht aus, um **das Problem zu reproduzieren**.

* Sie können die Person bitten, ein <a href="https://stackoverflow.com/help/minimal-reproducible-example" class="external-link" target="_blank">minimales, reproduzierbares Beispiel</a> bereitzustellen, welches Sie **kopieren, einfügen** und lokal ausführen können, um den gleichen Fehler oder das gleiche Verhalten zu sehen, das die Person sieht, oder um ihren Anwendungsfall besser zu verstehen.

* Wenn Sie in Geberlaune sind, können Sie ein solches Beispiel selbst erstellen, nur basierend auf der Beschreibung des Problems. Denken Sie jedoch daran, dass dies viel Zeit in Anspruch nehmen kann und dass es besser sein kann, zunächst um eine Klärung des Problems zu bitten.

### Lösungen vorschlagen { #suggest-solutions }

* Nachdem Sie die Frage verstanden haben, können Sie eine mögliche **Antwort** geben.

* In vielen Fällen ist es besser, das **zugrunde liegende Problem oder den Anwendungsfall** zu verstehen, da es möglicherweise einen besseren Weg zur Lösung gibt als das, was die Person versucht.

### Um Schließung bitten { #ask-to-close }

Wenn die Person antwortet, besteht eine hohe Chance, dass Sie ihr Problem gelöst haben. Herzlichen Glückwunsch, **Sie sind ein Held**! 🦸

* Wenn es tatsächlich das Problem gelöst hat, können Sie sie darum bitten:

    * In GitHub-Diskussionen: den Kommentar als **Antwort** zu markieren.
    * In GitHub-Issues: Das Issue zu **schließen**.

## Das GitHub-Repository beobachten { #watch-the-github-repository }

Sie können FastAPI auf GitHub „beobachten“ (klicken Sie auf den „watch“-Button oben rechts): <a href="https://github.com/fastapi/fastapi" class="external-link" target="_blank">https://github.com/fastapi/fastapi</a>. 👀

Wenn Sie dann „Watching“ statt „Releases only“ auswählen, erhalten Sie Benachrichtigungen, wenn jemand ein neues Issue eröffnet oder eine neue Frage stellt. Sie können auch spezifizieren, dass Sie nur über neue Issues, Diskussionen, PRs usw. benachrichtigt werden möchten.

Dann können Sie versuchen, bei der Lösung solcher Fragen zu helfen.

## Fragen stellen { #ask-questions }

Sie können im GitHub-Repository <a href="https://github.com/fastapi/fastapi/discussions/new?category=questions" class="external-link" target="_blank">eine neue Frage erstellen</a>, zum Beispiel:

* Stellen Sie eine **Frage** oder bitten Sie um Hilfe mit einem **Problem**.
* Schlagen Sie eine neue **Funktionalität** vor.

**Hinweis**: Wenn Sie das tun, bitte ich Sie, auch anderen zu helfen. 😉

## Pull Requests prüfen { #review-pull-requests }

Sie können mir helfen, Pull Requests von anderen zu überprüfen.

Noch einmal, bitte versuchen Sie Ihr Bestes, freundlich zu sein. 🤗

---

Hier ist, was Sie beachten sollten und wie Sie einen Pull Request überprüfen:

### Das Problem verstehen { #understand-the-problem }

* Stellen Sie zunächst sicher, dass Sie **das Problem verstehen**, welches der Pull Request zu lösen versucht. Möglicherweise gibt es eine längere Diskussion dazu in einer GitHub-Diskussion oder einem GitHub-Issue.

* Es besteht auch eine gute Chance, dass der Pull Request nicht wirklich benötigt wird, da das Problem auf **andere Weise** gelöst werden kann. Dann können Sie das vorschlagen oder danach fragen.

### Keine Panik wegen des Stils { #dont-worry-about-style }

* Machen Sie sich keine Sorgen über Dinge wie den Stil von Commit-Nachrichten. Ich werde den Commit zusammenführen und manuell anpassen.

* Außerdem, keine Sorgen über Stilregeln, es gibt bereits automatisierte Tools, die das überprüfen.

Und wenn es irgendeinen anderen Stil- oder Konsistenzbedarf gibt, werde ich direkt danach fragen oder zusätzliche Commits mit den erforderlichen Änderungen hinzufügen.

### Den Code testen { #check-the-code }

* Prüfen und lesen Sie den Code, fragen Sie sich, ob er Sinn macht, **führen Sie ihn lokal aus** und testen Sie, ob er das Problem tatsächlich löst.

* Schreiben Sie dann einen **Kommentar** und berichten, dass Sie das getan haben. So weiß ich, dass Sie ihn wirklich überprüft haben.

/// info | Info

Leider kann ich PRs, nur weil sie von mehreren gutgeheißen wurden, nicht einfach vertrauen.

Es ist mehrmals passiert, dass es PRs mit drei, fünf oder mehr Zustimmungen gibt, wahrscheinlich weil die Beschreibung ansprechend ist, aber wenn ich die PRs überprüfe, sind sie tatsächlich fehlerhaft, haben einen Bug, oder lösen das Problem nicht, welches sie behaupten, zu lösen. 😅

Daher ist es wirklich wichtig, dass Sie den Code wirklich lesen und ausführen und mir in den Kommentaren mitteilen, dass Sie dies getan haben. 🤓

///

* Wenn der PR in irgendeiner Weise vereinfacht werden kann, können Sie danach fragen, aber es gibt keinen Grund, zu wählerisch zu sein. Es gibt viele subjektive Standpunkte (und ich habe auch meinen eigenen 🙈), also ist es besser, wenn man sich auf die grundlegenden Dinge konzentriert.

### Tests { #tests }

* Helfen Sie mir zu überprüfen, dass der PR **Tests** hat.

* Überprüfen Sie, dass diese Tests vor dem PR **fehlschlagen**. 🚨

* Überprüfen Sie dann, dass diese Tests nach dem PR **bestanden** werden. ✅

* Viele PRs haben keine Tests. Sie können den Autor daran **erinnern**, Tests hinzuzufügen, oder Sie können sogar selbst einige Tests **vorschlagen**. Das ist eines der Dinge, die am meisten Zeit in Anspruch nehmen, und Sie können dabei viel helfen.

* Kommentieren Sie auch hier anschließend, was Sie versucht haben, sodass ich weiß, dass Sie es überprüft haben. 🤓

## Einen Pull Request erstellen { #create-a-pull-request }

Sie können [zum Quellcode mit Pull Requests beitragen](contributing.md){.internal-link target=_blank}, zum Beispiel:

* Um einen Tippfehler zu beheben, den Sie in der Dokumentation gefunden haben.
* Um einen Artikel, ein Video oder einen Podcast über FastAPI zu teilen, den Sie erstellt oder gefunden haben, indem Sie <a href="https://github.com/fastapi/fastapi/edit/master/docs/en/data/external_links.yml" class="external-link" target="_blank">diese Datei bearbeiten</a>.
    * Stellen Sie sicher, dass Sie Ihren Link am Anfang des entsprechenden Abschnitts einfügen.
* Um zu helfen, [die Dokumentation in Ihre Sprache zu übersetzen](contributing.md#translations){.internal-link target=_blank}.
    * Sie können auch dabei helfen, die von anderen erstellten Übersetzungen zu überprüfen (Review).
* Um neue Dokumentationsabschnitte vorzuschlagen.
* Um ein bestehendes Problem/Bug zu beheben.
    * Stellen Sie sicher, dass Sie Tests hinzufügen.
* Um eine neue Funktionalität hinzuzufügen.
    * Stellen Sie sicher, dass Sie Tests hinzufügen.
    * Stellen Sie sicher, dass Sie Dokumentation hinzufügen, falls das notwendig ist.

## FastAPI pflegen { #help-maintain-fastapi }

Helfen Sie mir, **FastAPI** zu pflegen! 🤓

Es gibt viel zu tun, und das meiste davon können **SIE** tun.

Die Hauptaufgaben, die Sie jetzt erledigen können, sind:

* [Anderen bei Fragen auf GitHub helfen](#help-others-with-questions-in-github){.internal-link target=_blank} (siehe Abschnitt oben).
* [Pull Requests prüfen](#review-pull-requests){.internal-link target=_blank} (siehe Abschnitt oben).

Diese beiden Aufgaben sind die Dinge, die **am meisten Zeit verbrauchen**. Das ist die Hauptarbeit bei der Wartung von FastAPI.

Wenn Sie mir dabei helfen können, **helfen Sie mir, FastAPI zu pflegen** und Sie stellen sicher, dass es weiterhin **schneller und besser voranschreitet**. 🚀

## Am Chat teilnehmen { #join-the-chat }

Treten Sie dem 👥 <a href="https://discord.gg/VQjSZaeJmf" class="external-link" target="_blank">Discord-Chatserver</a> 👥 bei und treffen Sie sich mit anderen Mitgliedern der FastAPI-Community.

/// tip | Tipp

Bei Fragen stellen Sie sie in <a href="https://github.com/fastapi/fastapi/discussions/new?category=questions" class="external-link" target="_blank">GitHub-Diskussionen</a>, dort besteht eine viel größere Chance, dass Sie Hilfe von den [FastAPI-Experten](fastapi-people.md#fastapi-experts){.internal-link target=_blank} erhalten.

Nutzen Sie den Chat nur für andere allgemeine Gespräche.

///

### Den Chat nicht für Fragen verwenden { #dont-use-the-chat-for-questions }

Bedenken Sie, dass Sie in Chats, die „freie Konversation“ erlauben, leicht Fragen stellen können, die zu allgemein und schwer zu beantworten sind, sodass Sie möglicherweise keine Antworten erhalten.

Auf GitHub hilft Ihnen die Vorlage dabei, die richtige Frage zu stellen, sodass Sie leichter eine gute Antwort erhalten können, oder sogar das Problem selbst lösen, bevor Sie überhaupt fragen. Und auf GitHub kann ich sicherstellen, dass ich immer alles beantworte, auch wenn es einige Zeit dauert. Persönlich kann ich das mit den Chat-Systemen nicht machen. 😅

Unterhaltungen in den Chat-Systemen sind auch nicht so leicht durchsuchbar wie auf GitHub, sodass Fragen und Antworten möglicherweise im Gespräch verloren gehen. Und nur die auf GitHub machen einen [FastAPI-Experten](fastapi-people.md#fastapi-experts){.internal-link target=_blank}, Sie werden also höchstwahrscheinlich mehr Aufmerksamkeit auf GitHub erhalten.

Auf der anderen Seite gibt es Tausende von Benutzern in den Chat-Systemen, sodass die Wahrscheinlichkeit hoch ist, dass Sie dort fast immer jemanden zum Reden finden. 😄

## Den Autor sponsern { #sponsor-the-author }

Wenn Ihr **Produkt/Firma** auf **FastAPI** angewiesen ist oder in Zusammenhang steht und Sie seine Benutzer erreichen möchten, können Sie den Autor (mich) über <a href="https://github.com/sponsors/tiangolo" class="external-link" target="_blank">GitHub-Sponsoren</a> unterstützen. Je nach Stufe können Sie einige zusätzliche Vorteile erhalten, wie z. B. ein Abzeichen in der Dokumentation. 🎁

---

Danke! 🚀
