/* ========================================
 *  Dubly - Dubly.h
 *  Copyright (c) 2016 airwindows, Airwindows uses the MIT license
 * ======================================== */

#ifndef __Dubly_H
#include "Dubly.h"
#endif
namespace airwinconsolidated::Dubly {

void Dubly::processReplacing(float **inputs, float **outputs, VstInt32 sampleFrames) 
{
    float* in1  =  inputs[0];
    float* in2  =  inputs[1];
    float* out1 = outputs[0];
    float* out2 = outputs[1];

	double overallscale = 1.0;
	overallscale /= 44100.0;
	overallscale *= getSampleRate();
	
	double dublyAmount = pow(A,3)*0.16;
	double outlyAmount = pow(A,3)*0.160618;
	double gain = outlyAmount+1.0;
	double iirAmount = 0.4275/overallscale;
	double wet = B;
	
    while (--sampleFrames >= 0)
    {
		double inputSampleL = *in1;
		double inputSampleR = *in2;
		if (fabs(inputSampleL)<1.18e-23) inputSampleL = fpdL * 1.18e-17;
		if (fabs(inputSampleR)<1.18e-23) inputSampleR = fpdR * 1.18e-17;
		double drySampleL = inputSampleL;
		double drySampleR = inputSampleR;
		
		iirSampleAL = (iirSampleAL * (1.0 - iirAmount)) + (inputSampleL * iirAmount);
		double doubly = inputSampleL - iirSampleAL;
		if (doubly > 1.0) doubly = 1.0; if (doubly < -1.0) doubly = -1.0;
		if (doubly > 0) doubly = log(1.0+(255*fabs(doubly)))/2.40823996531;
		if (doubly < 0) doubly = -log(1.0+(255*fabs(doubly)))/2.40823996531;
		inputSampleL += doubly*dublyAmount;

		iirSampleAR = (iirSampleAR * (1.0 - iirAmount)) + (inputSampleR * iirAmount);
		doubly = inputSampleR - iirSampleAR;
		if (doubly > 1.0) doubly = 1.0; if (doubly < -1.0) doubly = -1.0;
		if (doubly > 0) doubly = log(1.0+(255*fabs(doubly)))/2.40823996531;
		if (doubly < 0) doubly = -log(1.0+(255*fabs(doubly)))/2.40823996531;
		inputSampleR += doubly*dublyAmount;
		//end Dubly encode
		
		inputSampleL *= gain;
		inputSampleL = sin(inputSampleL);
		inputSampleL /= gain;

		inputSampleR *= gain;
		inputSampleR = sin(inputSampleR);
		inputSampleR /= gain;
		
		iirSampleBL = (iirSampleBL * (1.0 - iirAmount)) + (inputSampleL * iirAmount);
		doubly = inputSampleL - iirSampleBL;
		if (doubly > 1.0) doubly = 1.0; if (doubly < -1.0) doubly = -1.0;
		if (doubly > 0) doubly = log(1.0+(255*fabs(doubly)))/2.40823996531;
		if (doubly < 0) doubly = -log(1.0+(255*fabs(doubly)))/2.40823996531;
		inputSampleL -= doubly*outlyAmount;

		iirSampleBR = (iirSampleBR * (1.0 - iirAmount)) + (inputSampleR * iirAmount);
		doubly = inputSampleR - iirSampleBR;
		if (doubly > 1.0) doubly = 1.0; if (doubly < -1.0) doubly = -1.0;
		if (doubly > 0) doubly = log(1.0+(255*fabs(doubly)))/2.40823996531;
		if (doubly < 0) doubly = -log(1.0+(255*fabs(doubly)))/2.40823996531;
		inputSampleR -= doubly*outlyAmount;
		//end Dubly decode
		
		if (wet !=1.0) {
			inputSampleL = (inputSampleL * wet) + (drySampleL * (1.0-wet));
			inputSampleR = (inputSampleR * wet) + (drySampleR * (1.0-wet));
		}
		
		//begin 32 bit stereo floating point dither
		int expon; frexpf((float)inputSampleL, &expon);
		fpdL ^= fpdL << 13; fpdL ^= fpdL >> 17; fpdL ^= fpdL << 5;
		inputSampleL += ((double(fpdL)-uint32_t(0x7fffffff)) * 5.5e-36l * pow(2,expon+62));
		frexpf((float)inputSampleR, &expon);
		fpdR ^= fpdR << 13; fpdR ^= fpdR >> 17; fpdR ^= fpdR << 5;
		inputSampleR += ((double(fpdR)-uint32_t(0x7fffffff)) * 5.5e-36l * pow(2,expon+62));
		//end 32 bit stereo floating point dither
		
		*out1 = inputSampleL;
		*out2 = inputSampleR;

		in1++;
		in2++;
		out1++;
		out2++;
    }
}

void Dubly::processDoubleReplacing(double **inputs, double **outputs, VstInt32 sampleFrames) 
{
    double* in1  =  inputs[0];
    double* in2  =  inputs[1];
    double* out1 = outputs[0];
    double* out2 = outputs[1];

	double overallscale = 1.0;
	overallscale /= 44100.0;
	overallscale *= getSampleRate();
	
	double dublyAmount = pow(A,3)*0.16;
	double outlyAmount = pow(A,3)*0.160618;
	double gain = outlyAmount+1.0;
	double iirAmount = 0.4275/overallscale;
	double wet = B;
	
    while (--sampleFrames >= 0)
    {
		double inputSampleL = *in1;
		double inputSampleR = *in2;
		if (fabs(inputSampleL)<1.18e-23) inputSampleL = fpdL * 1.18e-17;
		if (fabs(inputSampleR)<1.18e-23) inputSampleR = fpdR * 1.18e-17;
		double drySampleL = inputSampleL;
		double drySampleR = inputSampleR;
		
		iirSampleAL = (iirSampleAL * (1.0 - iirAmount)) + (inputSampleL * iirAmount);
		double doubly = inputSampleL - iirSampleAL;
		if (doubly > 1.0) doubly = 1.0; if (doubly < -1.0) doubly = -1.0;
		if (doubly > 0) doubly = log(1.0+(255*fabs(doubly)))/2.40823996531;
		if (doubly < 0) doubly = -log(1.0+(255*fabs(doubly)))/2.40823996531;
		inputSampleL += doubly*dublyAmount;
		
		iirSampleAR = (iirSampleAR * (1.0 - iirAmount)) + (inputSampleR * iirAmount);
		doubly = inputSampleR - iirSampleAR;
		if (doubly > 1.0) doubly = 1.0; if (doubly < -1.0) doubly = -1.0;
		if (doubly > 0) doubly = log(1.0+(255*fabs(doubly)))/2.40823996531;
		if (doubly < 0) doubly = -log(1.0+(255*fabs(doubly)))/2.40823996531;
		inputSampleR += doubly*dublyAmount;
		//end Dubly encode
		
		inputSampleL *= gain;
		inputSampleL = sin(inputSampleL);
		inputSampleL /= gain;
		
		inputSampleR *= gain;
		inputSampleR = sin(inputSampleR);
		inputSampleR /= gain;
		
		iirSampleBL = (iirSampleBL * (1.0 - iirAmount)) + (inputSampleL * iirAmount);
		doubly = inputSampleL - iirSampleBL;
		if (doubly > 1.0) doubly = 1.0; if (doubly < -1.0) doubly = -1.0;
		if (doubly > 0) doubly = log(1.0+(255*fabs(doubly)))/2.40823996531;
		if (doubly < 0) doubly = -log(1.0+(255*fabs(doubly)))/2.40823996531;
		inputSampleL -= doubly*outlyAmount;
		
		iirSampleBR = (iirSampleBR * (1.0 - iirAmount)) + (inputSampleR * iirAmount);
		doubly = inputSampleR - iirSampleBR;
		if (doubly > 1.0) doubly = 1.0; if (doubly < -1.0) doubly = -1.0;
		if (doubly > 0) doubly = log(1.0+(255*fabs(doubly)))/2.40823996531;
		if (doubly < 0) doubly = -log(1.0+(255*fabs(doubly)))/2.40823996531;
		inputSampleR -= doubly*outlyAmount;
		//end Dubly decode
		
		if (wet !=1.0) {
			inputSampleL = (inputSampleL * wet) + (drySampleL * (1.0-wet));
			inputSampleR = (inputSampleR * wet) + (drySampleR * (1.0-wet));
		}
				
		//begin 64 bit stereo floating point dither
		//int expon; frexp((double)inputSampleL, &expon);
		fpdL ^= fpdL << 13; fpdL ^= fpdL >> 17; fpdL ^= fpdL << 5;
		//inputSampleL += ((double(fpdL)-uint32_t(0x7fffffff)) * 1.1e-44l * pow(2,expon+62));
		//frexp((double)inputSampleR, &expon);
		fpdR ^= fpdR << 13; fpdR ^= fpdR >> 17; fpdR ^= fpdR << 5;
		//inputSampleR += ((double(fpdR)-uint32_t(0x7fffffff)) * 1.1e-44l * pow(2,expon+62));
		//end 64 bit stereo floating point dither
		
		*out1 = inputSampleL;
		*out2 = inputSampleR;

		in1++;
		in2++;
		out1++;
		out2++;
    }
}
} // end namespace
