/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 */

#include "./time.hpp"

#include <chrono>

namespace sh4lt {

using namespace std::chrono;

auto Time::update(int64_t buffer_date, int64_t buffer_duration) -> info_t {
  info_.system_clock_date = system_clock_now();
  info_.steady_clock_date = steady_clock_now();
  info_.buffer_number += 1;
  info_.buffer_date = buffer_date;
  info_.buffer_duration = buffer_duration;
  return info_;
}

auto Time::system_clock_now() -> int64_t {
  nanoseconds r = system_clock::now().time_since_epoch();
  return r.count();
}

auto Time::steady_clock_now() -> int64_t {
  nanoseconds r = steady_clock::now().time_since_epoch();
  return r.count();
}
}  // namespace sh4lt
