Minutes from OpenVDB TSC meeting, November 5th, 2024

Attendees: *Ken* M., *Andre* P, *Dan* B., *Greg* H, *Nick* A.

Additional Attendees: Jonathan Swartz (NVIDIA), Barry Dempsey

Regrets: *Jeff* L., *Richard* J.

Agenda:

1) Confirm quorum
2) Secretary
3) V12 post mortem
4) 12.1 release
5) File format updates
6) Dilation
7) Next meeting

------------

1) Confirm quorum

Quorum is present.

2) Secretary

Secretary is Greg Hurst.

3) V12 post mortem

Release wasn't too bad -- getting CI in order was a bit of work but started a bit early.

Having a X.1, X.2, etc. release there would be less of a squeeze for new features.

Ken: perhaps 3 releases per year, including the major release.

Nick: Would be nice if we could be in a place where patch releases are simple whenever there's a new feature. This means we can't put anything into master unless we're completely happy with it. We also need to make sure that the weekly tests are always in working order and when a failure happens, we need to address ASAP.

CI could be more complicated once we start adding GPU's into the mix.

Linux & Mac OS migrations have happenend and switching from bash to shell in Windows had made more stable.

Chat groups can be much easier to manage the CI compared to emails, which we currently operate like. Perhaps Slack or Google chat?

Ken: Could Nick add documentation or a presentation about the current CI? It's complex and a bit intimidating right now.

Porting AX tests to GTest from CPPTest can help a bit with CI.

4) 12.1 release

March 1, 2025 release?

* Tubes + Dilated Meshes
* HalfGrid
* Large Nano updates

5) File format updates

Migrate away from Blosc in favor from LZ4?

Blosc brings a lot of compression codecs with it, so we could precondition ourselves and then just bring in LZ4.

6) Dilation

Dan presents on dilation -- noticed serial dilation was faster when making volume advection calls

Active ideas of how we can speed up the multithreaded code.

Vague description:

Current: dilate into multiple grids then merge
Future: create 1 grid and dilate into it, parallelize over internal nodes directly above leaf nodes

1. Partial Topology Copy, turn dense leaf nodes into active tiles
2. Node dilation, iterate over leafs and touch leaf neighbors
3. Mask dilation, scatter method but make sure you're not writing to the same leaf node at the same time. Split into center, face, edge, and corner passes, so 4 passes instead of 7. Still does scattering over a copy of the data since multiple passes are used.
4. Prune tree

Tentatively a ~4-5x speedup for 'dense-like' grids and ~2x speedup for higher SA/V grids.

TODOs
* Topology Copy
   * Skip Topology Copy and Re-use Input Topology
* Node Dilation
   * Apply Center, Face, Edge, Corner Scheme
   * Avoid Naive Root Children Dilation
* Mask Dilation
   * Cache Neighboring Internal Nodes
   * Thread Corner Cases
   * Simplify Edge Cases
   * Extend to NN_FACE_EDGE/NN_FACE_EDGE_VERTEX modes
* Testing
   * Build Worst Case and Poorly Balanced Trees
   * Multiple Iterations

7) Next meeting

Tentativley we'd like to move meetings to Wednesdays at 11:00 PST if we get a buy in from Jeff and Rich.

If this is the case, the next meeting is Wednesday Novermber 20, 2024 at 11:00 PST.
