Minutes from OpenVDB TSC meeting, January 24, 2023

Attendees: *Jeff* L., *Andre* P, *Dan* B., *Ken* M., *Nick* A., *Greg* H.

Additional Attendees: JT Nelson (Blender)

Regrets: *Rich* J.

Agenda:

1) Confirm quorum
2) Secretary
3) Broken Houdini download link
4) Open PR's
5) Fracture CSG tools
6) Active states
7) Sharpening filter


------------

1) Confirm quorum

Quorum is present.

2) Secretary

Secretary is Greg Hurst.

3) Broken Houdini download link

Houdini download link is broken at openvdb.org downloads page. Happened during git lfs switch. Need to upload regularly using git.

File not updated often, so it's ok to not use git lfs and just use regular git commit.

Maybe the URL needs to change in the html source when using git lfs?

4) Open PR's

Python bindings (1515)
* Ken will try to look at the PR tomorrow
* Recreate the PR to remedy the CLA issues and credit the original author
* Or squash everything and go as if everything is just one commit

Switch to using the static asserts (1522)
* Why do we have a special wrapper for the static assert? 
* NANOVDB_ASSERT instead of the static_assert
* Soon nanovdb will require C++17 (waiting on pnanovdb)
* Ideally we'd have #ifdef platform instead of #if 1, so keep skeleton code present through #if 0
* Ken will approve and merge

Prefer fixed-width integer types instead of size_t (1528)
* Awaiting another approval -- Dan will approve

Add missing separate_arguments cmake call (1534)
* Needs another look -- not entirely clear why this was added
* Splits list of arguments in case they're separated by non-standard delimiters
* Perhaps re-ask OP what failed / why make this PR

Support for IlmBase versions < 3.1 is deprecated and will be removed (1529)
* vdbtool stuff
* This PR looks to remove support for old version

Remove the explicit default assignment operator (1530)
* Remove explicit default assignment operator in nanovdb
* Once something is given a default, you need to set default for other things too
* More defaults need to be removed in the same file before approval

Consolidated ValueAccessor implementations (1547)
* Perhaps someone can build and see if everything still works, test against Houdini, etc.
* Implementation related questions added to the PR by Dan
* The override specifiers might be redundant
* Need to add missing isCached in code base in similar piece of code.

Fix Segfault in Projection Mode of VDB Advect Points SOP (1559)
* Just awaiting approval from Jeff

Fix all the int-in-bool-context warnings with GCC9 (1563)
* Switch to use constexpr
* Still need macros to guard type conversions? (Node type conversion warning, just relevant to float portion now)
* LOD removed for bool grids

5) Fracture CSG tools

https://github.com/AcademySoftwareFoundation/openvdb/issues/1566

Seemless free cuts -- how can you do this with OpenVDB? Can do it in Houdini though since it has robust mesh support.

Really need this to make your split-frame free of artifacts and for water-tight union.

Our current choice is to not support robust mesh computation. Currently OpenVDB just has polygon soup. Mainly used for translation purposes. Robust support could lead us down a rabbit hole.

By templating our meshes, it's probably not clear that if you wrote your own accelerated structure, what methods you need.

Houdini seems to use everything in OpenVDB here, and so we could return polygon soup and edge data list (MeshToVoxelEdgeData) and the user can do it. The SOP can be a reference.

Point OP to this SOP / OpenVDB methods.

6) Active / Inactive States

What should the default behavior be and how to expose different functionalities.

Default behavior proposed: Max of values and if either is active make result active.

Currently the activeness of states is not being brought over.

Not more efficient to make 2 passes when combining multiple grids. Loses cache coherency.
2 passes node-wise will be more efficient than 2 passes tree-wise.

Do we want the ability to handle active states differently? 
Maybe we have a use to ignore when any grid has an inactive value. 

max( (0.0, inactive), (-1.0, active) ) --> (0.0, active) or (0.0, inactive)?

What does it mean for a fog volume node to be active? Tags (GRID_LEVEL_SET, etc in enum GridClass) give implicit meaning to active states / values
Majority of tools don't seem to normalize fogs to lie between 0 and 1. Difficult to maintain this discipline.

Make sure to make whatever choices extendable. Tricky part is coming up with different patterns. 
Selection merge and reduction merge, etc.

7) Sharpening filter

Switch away from boost dependencies & add unit tests.

Seems like updated PR could be around the corner.
