; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -verify-machineinstrs -mtriple=x86_64-unknown-unknown --show-mc-encoding -mattr=+avx10.2-512 | FileCheck %s --check-prefixes=CHECK,X64
; RUN: llc < %s -verify-machineinstrs -mtriple=i686-unknown-unknown --show-mc-encoding -mattr=+avx10.2-512 | FileCheck %s --check-prefixes=CHECK,X86

define <32 x bfloat> @test_int_x86_avx10_vaddbf16512(<32 x bfloat> %x1, <32 x bfloat> %x2) {
; CHECK-LABEL: test_int_x86_avx10_vaddbf16512:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vaddbf16 %zmm1, %zmm0, %zmm0 # encoding: [0x62,0xf5,0x7d,0x48,0x58,0xc1]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %res = fadd <32 x bfloat>  %x1, %x2
  ret <32 x bfloat> %res
}

define <32 x bfloat> @test_int_x86_avx10_mask_add_bf16_512(<32 x bfloat> %src, <32 x bfloat> %x1, <32 x bfloat> %x2, i32 %msk, ptr %ptr) {
; X64-LABEL: test_int_x86_avx10_mask_add_bf16_512:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vaddbf16 %zmm2, %zmm1, %zmm0 {%k1} # encoding: [0x62,0xf5,0x75,0x49,0x58,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_mask_add_bf16_512:
; X86:       # %bb.0:
; X86-NEXT:    kmovd {{[0-9]+}}(%esp), %k1 # encoding: [0xc4,0xe1,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vaddbf16 %zmm2, %zmm1, %zmm0 {%k1} # encoding: [0x62,0xf5,0x75,0x49,0x58,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
  %mask = bitcast i32 %msk to <32 x i1>
  %res0 = fadd <32 x bfloat>  %x1, %x2
  %res = select <32 x i1> %mask, <32 x bfloat> %res0, <32 x bfloat> %src
  ret <32 x bfloat> %res
}

define <32 x bfloat> @test_int_x86_avx10_maskz_add_bf16_512(<32 x bfloat> %src, <32 x bfloat> %x1, <32 x bfloat> %x2, i32 %msk, ptr %ptr) {
; X64-LABEL: test_int_x86_avx10_maskz_add_bf16_512:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vaddbf16 %zmm2, %zmm1, %zmm0 {%k1} {z} # encoding: [0x62,0xf5,0x75,0xc9,0x58,0xc2]
; X64-NEXT:    vaddbf16 (%rsi), %zmm1, %zmm1 {%k1} {z} # encoding: [0x62,0xf5,0x75,0xc9,0x58,0x0e]
; X64-NEXT:    vaddbf16 %zmm1, %zmm0, %zmm0 # encoding: [0x62,0xf5,0x7d,0x48,0x58,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_maskz_add_bf16_512:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax # encoding: [0x8b,0x44,0x24,0x08]
; X86-NEXT:    kmovd {{[0-9]+}}(%esp), %k1 # encoding: [0xc4,0xe1,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vaddbf16 %zmm2, %zmm1, %zmm0 {%k1} {z} # encoding: [0x62,0xf5,0x75,0xc9,0x58,0xc2]
; X86-NEXT:    vaddbf16 (%eax), %zmm1, %zmm1 {%k1} {z} # encoding: [0x62,0xf5,0x75,0xc9,0x58,0x08]
; X86-NEXT:    vaddbf16 %zmm1, %zmm0, %zmm0 # encoding: [0x62,0xf5,0x7d,0x48,0x58,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
  %mask = bitcast i32 %msk to <32 x i1>
  %val = load <32 x bfloat>, ptr %ptr
  %res0 = fadd <32 x bfloat>  %x1, %x2
  %res1 = select <32 x i1> %mask, <32 x bfloat> %res0, <32 x bfloat> zeroinitializer
  %t2 = fadd <32 x bfloat>  %x1, %val
  %res2 = select <32 x i1> %mask, <32 x bfloat> %t2, <32 x bfloat> zeroinitializer
  %res3  =  fadd <32 x bfloat>  %res1, %res2
  ret <32 x bfloat> %res3
}

define <32 x bfloat> @test_int_x86_avx10_sub_bf16_512(<32 x bfloat> %x1, <32 x bfloat> %x2) {
; CHECK-LABEL: test_int_x86_avx10_sub_bf16_512:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsubbf16 %zmm1, %zmm0, %zmm0 # encoding: [0x62,0xf5,0x7d,0x48,0x5c,0xc1]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %res = fsub <32 x bfloat> %x1, %x2
  ret <32 x bfloat> %res
}

define <32 x bfloat> @test_int_x86_avx10_mask_sub_bf16_512(<32 x bfloat> %src, <32 x bfloat> %x1, <32 x bfloat> %x2, i32 %msk, ptr %ptr) {
; X64-LABEL: test_int_x86_avx10_mask_sub_bf16_512:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vsubbf16 %zmm2, %zmm1, %zmm0 {%k1} # encoding: [0x62,0xf5,0x75,0x49,0x5c,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_mask_sub_bf16_512:
; X86:       # %bb.0:
; X86-NEXT:    kmovd {{[0-9]+}}(%esp), %k1 # encoding: [0xc4,0xe1,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vsubbf16 %zmm2, %zmm1, %zmm0 {%k1} # encoding: [0x62,0xf5,0x75,0x49,0x5c,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
  %mask = bitcast i32 %msk to <32 x i1>
  %res0 = fsub <32 x bfloat> %x1, %x2
  %res = select <32 x i1> %mask, <32 x bfloat> %res0, <32 x bfloat> %src
  ret <32 x bfloat> %res
}

define <32 x bfloat> @test_int_x86_avx10_maskz_sub_bf16_512(<32 x bfloat> %src, <32 x bfloat> %x1, <32 x bfloat> %x2, i32 %msk, ptr %ptr) {
; X64-LABEL: test_int_x86_avx10_maskz_sub_bf16_512:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vsubbf16 %zmm2, %zmm1, %zmm0 {%k1} {z} # encoding: [0x62,0xf5,0x75,0xc9,0x5c,0xc2]
; X64-NEXT:    vsubbf16 (%rsi), %zmm1, %zmm1 # encoding: [0x62,0xf5,0x75,0x48,0x5c,0x0e]
; X64-NEXT:    vsubbf16 %zmm1, %zmm0, %zmm0 {%k1} # encoding: [0x62,0xf5,0x7d,0x49,0x5c,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_maskz_sub_bf16_512:
; X86:       # %bb.0:
; X86-NEXT:    kmovd {{[0-9]+}}(%esp), %k1 # encoding: [0xc4,0xe1,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax # encoding: [0x8b,0x44,0x24,0x08]
; X86-NEXT:    vsubbf16 %zmm2, %zmm1, %zmm0 {%k1} {z} # encoding: [0x62,0xf5,0x75,0xc9,0x5c,0xc2]
; X86-NEXT:    vsubbf16 (%eax), %zmm1, %zmm1 # encoding: [0x62,0xf5,0x75,0x48,0x5c,0x08]
; X86-NEXT:    vsubbf16 %zmm1, %zmm0, %zmm0 {%k1} # encoding: [0x62,0xf5,0x7d,0x49,0x5c,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
  %mask = bitcast i32 %msk to <32 x i1>
  %val = load <32 x bfloat>, ptr %ptr
  %res0 = fsub <32 x bfloat> %x1, %x2
  %res1 = select <32 x i1> %mask, <32 x bfloat> %res0, <32 x bfloat> zeroinitializer
  %t2 = fsub <32 x bfloat> %x1, %val
  %res2 = select <32 x i1> %mask, <32 x bfloat> %t2, <32 x bfloat> zeroinitializer
  %res3  = fsub <32 x bfloat> %res1, %res2
  ret <32 x bfloat> %res3
}

declare <32 x bfloat> @llvm.x86.avx10.vmulbf16512(<32 x bfloat>, <32 x bfloat>)

define <32 x bfloat> @test_int_x86_avx10_mul_bf16_512(<32 x bfloat> %x1, <32 x bfloat> %x2) {
; CHECK-LABEL: test_int_x86_avx10_mul_bf16_512:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmulbf16 %zmm1, %zmm0, %zmm0 # encoding: [0x62,0xf5,0x7d,0x48,0x59,0xc1]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %res = fmul <32 x bfloat> %x1, %x2
  ret <32 x bfloat> %res
}

define <32 x bfloat> @test_int_x86_avx10_mask_mul_bf16_512(<32 x bfloat> %src, <32 x bfloat> %x1, <32 x bfloat> %x2, i32 %msk, ptr %ptr) {
; X64-LABEL: test_int_x86_avx10_mask_mul_bf16_512:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vmulbf16 %zmm2, %zmm1, %zmm0 {%k1} # encoding: [0x62,0xf5,0x75,0x49,0x59,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_mask_mul_bf16_512:
; X86:       # %bb.0:
; X86-NEXT:    kmovd {{[0-9]+}}(%esp), %k1 # encoding: [0xc4,0xe1,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vmulbf16 %zmm2, %zmm1, %zmm0 {%k1} # encoding: [0x62,0xf5,0x75,0x49,0x59,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
  %mask = bitcast i32 %msk to <32 x i1>
  %res0 = fmul <32 x bfloat> %x1, %x2
  %res = select <32 x i1> %mask, <32 x bfloat> %res0, <32 x bfloat> %src
  ret <32 x bfloat> %res
}

define <32 x bfloat> @test_int_x86_avx10_maskz_mul_bf16_512(<32 x bfloat> %src, <32 x bfloat> %x1, <32 x bfloat> %x2, i32 %msk, ptr %ptr) {
; X64-LABEL: test_int_x86_avx10_maskz_mul_bf16_512:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vmulbf16 %zmm2, %zmm1, %zmm0 {%k1} {z} # encoding: [0x62,0xf5,0x75,0xc9,0x59,0xc2]
; X64-NEXT:    vmulbf16 (%rsi), %zmm1, %zmm1 {%k1} {z} # encoding: [0x62,0xf5,0x75,0xc9,0x59,0x0e]
; X64-NEXT:    vmulbf16 %zmm1, %zmm0, %zmm0 # encoding: [0x62,0xf5,0x7d,0x48,0x59,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_maskz_mul_bf16_512:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax # encoding: [0x8b,0x44,0x24,0x08]
; X86-NEXT:    kmovd {{[0-9]+}}(%esp), %k1 # encoding: [0xc4,0xe1,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vmulbf16 %zmm2, %zmm1, %zmm0 {%k1} {z} # encoding: [0x62,0xf5,0x75,0xc9,0x59,0xc2]
; X86-NEXT:    vmulbf16 (%eax), %zmm1, %zmm1 {%k1} {z} # encoding: [0x62,0xf5,0x75,0xc9,0x59,0x08]
; X86-NEXT:    vmulbf16 %zmm1, %zmm0, %zmm0 # encoding: [0x62,0xf5,0x7d,0x48,0x59,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
  %mask = bitcast i32 %msk to <32 x i1>
  %val = load <32 x bfloat>, ptr %ptr
  %res0 = fmul <32 x bfloat> %x1, %x2
  %res1 = select <32 x i1> %mask, <32 x bfloat> %res0, <32 x bfloat> zeroinitializer
  %t2 = fmul <32 x bfloat> %x1, %val
  %res2 = select <32 x i1> %mask, <32 x bfloat> %t2, <32 x bfloat> zeroinitializer
  %res3  = fmul <32 x bfloat> %res1, %res2
  ret <32 x bfloat> %res3
}

define <32 x bfloat> @test_int_x86_avx10_div_bf16_512(<32 x bfloat> %x1, <32 x bfloat> %x2) {
; CHECK-LABEL: test_int_x86_avx10_div_bf16_512:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vdivbf16 %zmm1, %zmm0, %zmm0 # encoding: [0x62,0xf5,0x7d,0x48,0x5e,0xc1]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %res = fdiv <32 x bfloat> %x1, %x2
  ret <32 x bfloat> %res
}

define <32 x bfloat> @test_int_x86_avx10_mask_div_bf16_512(<32 x bfloat> %src, <32 x bfloat> %x1, <32 x bfloat> %x2, i32 %msk, ptr %ptr) {
; X64-LABEL: test_int_x86_avx10_mask_div_bf16_512:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vdivbf16 %zmm2, %zmm1, %zmm0 {%k1} # encoding: [0x62,0xf5,0x75,0x49,0x5e,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_mask_div_bf16_512:
; X86:       # %bb.0:
; X86-NEXT:    kmovd {{[0-9]+}}(%esp), %k1 # encoding: [0xc4,0xe1,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vdivbf16 %zmm2, %zmm1, %zmm0 {%k1} # encoding: [0x62,0xf5,0x75,0x49,0x5e,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
  %mask = bitcast i32 %msk to <32 x i1>
  %res0 = fdiv <32 x bfloat> %x1, %x2
  %res = select <32 x i1> %mask, <32 x bfloat> %res0, <32 x bfloat> %src
  ret <32 x bfloat> %res
}

define <32 x bfloat> @test_int_x86_avx10_maskz_div_bf16_512(<32 x bfloat> %src, <32 x bfloat> %x1, <32 x bfloat> %x2, i32 %msk, ptr %ptr) {
; X64-LABEL: test_int_x86_avx10_maskz_div_bf16_512:
; X64:       # %bb.0:
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vdivbf16 %zmm2, %zmm1, %zmm0 {%k1} {z} # encoding: [0x62,0xf5,0x75,0xc9,0x5e,0xc2]
; X64-NEXT:    vdivbf16 (%rsi), %zmm1, %zmm1 {%k1} {z} # encoding: [0x62,0xf5,0x75,0xc9,0x5e,0x0e]
; X64-NEXT:    vdivbf16 %zmm1, %zmm0, %zmm0 # encoding: [0x62,0xf5,0x7d,0x48,0x5e,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_int_x86_avx10_maskz_div_bf16_512:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax # encoding: [0x8b,0x44,0x24,0x08]
; X86-NEXT:    kmovd {{[0-9]+}}(%esp), %k1 # encoding: [0xc4,0xe1,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vdivbf16 %zmm2, %zmm1, %zmm0 {%k1} {z} # encoding: [0x62,0xf5,0x75,0xc9,0x5e,0xc2]
; X86-NEXT:    vdivbf16 (%eax), %zmm1, %zmm1 {%k1} {z} # encoding: [0x62,0xf5,0x75,0xc9,0x5e,0x08]
; X86-NEXT:    vdivbf16 %zmm1, %zmm0, %zmm0 # encoding: [0x62,0xf5,0x7d,0x48,0x5e,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
  %mask = bitcast i32 %msk to <32 x i1>
  %val = load <32 x bfloat>, ptr %ptr
  %res0 = fdiv <32 x bfloat> %x1, %x2
  %res1 = select <32 x i1> %mask, <32 x bfloat> %res0, <32 x bfloat> zeroinitializer
  %t2 = fdiv <32 x bfloat> %x1, %val
  %res2 = select <32 x i1> %mask, <32 x bfloat> %t2, <32 x bfloat> zeroinitializer
  %res3  = fdiv <32 x bfloat> %res1, %res2
  ret <32 x bfloat> %res3
}

define i32 @test_int_x86_avx10_vcmpbf16512(<32 x bfloat> %x1, <32 x bfloat> %x2) {
; CHECK-LABEL: test_int_x86_avx10_vcmpbf16512:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcmpunordbf16 %zmm1, %zmm0, %k0 # encoding: [0x62,0xf3,0x7f,0x48,0xc2,0xc1,0x03]
; CHECK-NEXT:    kmovd %k0, %eax # encoding: [0xc5,0xfb,0x93,0xc0]
; CHECK-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %1 = fcmp uno <32 x bfloat> %x1, %x2
  %res = bitcast <32 x i1> %1 to i32
  ret i32 %res
}

; FIXME: _mm512_mask_cmp_p[s|h]_mask is not using {k2} but gcc does
define i32 @test_int_x86_avx10_vcmpbf16512_mask2(<32 x bfloat> %x1, <32 x bfloat> %x2) {
; CHECK-LABEL: test_int_x86_avx10_vcmpbf16512_mask2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcmpeqbf16 %zmm1, %zmm0, %k0 # encoding: [0x62,0xf3,0x7f,0x48,0xc2,0xc1,0x00]
; CHECK-NEXT:    kmovd %k0, %eax # encoding: [0xc5,0xfb,0x93,0xc0]
; CHECK-NEXT:    andl $3, %eax # encoding: [0x83,0xe0,0x03]
; CHECK-NEXT:    vzeroupper # encoding: [0xc5,0xf8,0x77]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %1 = fcmp oeq <32 x bfloat> %x1, %x2
  %2 = and <32 x i1> %1, <i1 true, i1 true, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false>
  %3 = bitcast <32 x i1> %2 to i32
  ret i32 %3
}

define <32 x bfloat> @test_sqrt_bf16_512(<32 x bfloat> %a0) {
; CHECK-LABEL: test_sqrt_bf16_512:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsqrtbf16 %zmm0, %zmm0 # encoding: [0x62,0xf5,0x7d,0x48,0x51,0xc0]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
  %1 = tail call <32 x bfloat> @llvm.sqrt.v32bf16(<32 x bfloat> %a0)
  ret <32 x bfloat> %1
}

define <32 x bfloat> @test_mm512_mask_sqrt_pbh(<32 x bfloat> %__W, i32 %__U, <32 x bfloat> %__A) {
; X64-LABEL: test_mm512_mask_sqrt_pbh:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vsqrtbf16 %zmm1, %zmm0 {%k1} # encoding: [0x62,0xf5,0x7d,0x49,0x51,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_mm512_mask_sqrt_pbh:
; X86:       # %bb.0: # %entry
; X86-NEXT:    kmovd {{[0-9]+}}(%esp), %k1 # encoding: [0xc4,0xe1,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vsqrtbf16 %zmm1, %zmm0 {%k1} # encoding: [0x62,0xf5,0x7d,0x49,0x51,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
entry:
  %0 = tail call <32 x bfloat> @llvm.sqrt.v32bf16(<32 x bfloat> %__A)
  %1 = bitcast i32 %__U to <32 x i1>
  %2 = select <32 x i1> %1, <32 x bfloat> %0, <32 x bfloat> %__W
  ret <32 x bfloat> %2
}

define <32 x bfloat> @test_mm512_maskz_sqrt_pbh(i32 %__U, <32 x bfloat>%__A) {
; X64-LABEL: test_mm512_maskz_sqrt_pbh:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vsqrtbf16 %zmm0, %zmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7d,0xc9,0x51,0xc0]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_mm512_maskz_sqrt_pbh:
; X86:       # %bb.0: # %entry
; X86-NEXT:    kmovd {{[0-9]+}}(%esp), %k1 # encoding: [0xc4,0xe1,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vsqrtbf16 %zmm0, %zmm0 {%k1} {z} # encoding: [0x62,0xf5,0x7d,0xc9,0x51,0xc0]
; X86-NEXT:    retl # encoding: [0xc3]
entry:
  %0 = tail call <32 x bfloat> @llvm.sqrt.v32bf16(<32 x bfloat> %__A)
  %1 = bitcast i32 %__U to <32 x i1>
  %2 = select <32 x i1> %1, <32 x bfloat> %0, <32 x bfloat> zeroinitializer
  ret <32 x bfloat> %2
}

define <32 x bfloat> @test_mm512_fmaddne_pbh(<32 x bfloat> %__A, <32 x bfloat> %__B, <32 x bfloat> %__C) {
; CHECK-LABEL: test_mm512_fmaddne_pbh:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfmadd213bf16 %zmm2, %zmm1, %zmm0 # encoding: [0x62,0xf6,0x74,0x48,0xa8,0xc2]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
entry:
  %0 = tail call <32 x bfloat> @llvm.fma.v32bf16(<32 x bfloat> %__A, <32 x bfloat> %__B, <32 x bfloat> %__C)
  ret <32 x bfloat> %0
}

define <32 x bfloat> @test_mm512_mask_fmaddne_pbh(<32 x bfloat> %__A, i32 %__U, <32 x bfloat> %__B, <32 x bfloat> %__C) {
; X64-LABEL: test_mm512_mask_fmaddne_pbh:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vfmadd132bf16 %zmm1, %zmm2, %zmm0 {%k1} # encoding: [0x62,0xf6,0x6c,0x49,0x98,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_mm512_mask_fmaddne_pbh:
; X86:       # %bb.0: # %entry
; X86-NEXT:    kmovd {{[0-9]+}}(%esp), %k1 # encoding: [0xc4,0xe1,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vfmadd132bf16 %zmm1, %zmm2, %zmm0 {%k1} # encoding: [0x62,0xf6,0x6c,0x49,0x98,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
entry:
  %0 = tail call <32 x bfloat> @llvm.fma.v32bf16(<32 x bfloat> %__A, <32 x bfloat> %__B, <32 x bfloat> %__C)
  %1 = bitcast i32 %__U to <32 x i1>
  %2 = select <32 x i1> %1, <32 x bfloat> %0, <32 x bfloat> %__A
  ret <32 x bfloat> %2
}

define <32 x bfloat> @test_mm512_mask3_fmaddne_pbh(<32 x bfloat> %__A, <32 x bfloat> %__B, <32 x bfloat> %__C, i32 %__U) {
; X64-LABEL: test_mm512_mask3_fmaddne_pbh:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vfmadd231bf16 %zmm1, %zmm0, %zmm2 {%k1} # encoding: [0x62,0xf6,0x7c,0x49,0xb8,0xd1]
; X64-NEXT:    vmovaps %zmm2, %zmm0 # encoding: [0x62,0xf1,0x7c,0x48,0x28,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_mm512_mask3_fmaddne_pbh:
; X86:       # %bb.0: # %entry
; X86-NEXT:    kmovd {{[0-9]+}}(%esp), %k1 # encoding: [0xc4,0xe1,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vfmadd231bf16 %zmm1, %zmm0, %zmm2 {%k1} # encoding: [0x62,0xf6,0x7c,0x49,0xb8,0xd1]
; X86-NEXT:    vmovaps %zmm2, %zmm0 # encoding: [0x62,0xf1,0x7c,0x48,0x28,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
entry:
  %0 = tail call <32 x bfloat> @llvm.fma.v32bf16(<32 x bfloat> %__A, <32 x bfloat> %__B, <32 x bfloat> %__C)
  %1 = bitcast i32 %__U to <32 x i1>
  %2 = select <32 x i1> %1, <32 x bfloat> %0, <32 x bfloat> %__C
  ret <32 x bfloat> %2
}

define <32 x bfloat> @test_mm512_maskz_fmaddne_pbh(i32 %__U, <32 x bfloat> %__A, <32 x bfloat> %__B, <32 x bfloat> %__C) {
; X64-LABEL: test_mm512_maskz_fmaddne_pbh:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vfmadd213bf16 %zmm2, %zmm1, %zmm0 {%k1} {z} # encoding: [0x62,0xf6,0x74,0xc9,0xa8,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_mm512_maskz_fmaddne_pbh:
; X86:       # %bb.0: # %entry
; X86-NEXT:    kmovd {{[0-9]+}}(%esp), %k1 # encoding: [0xc4,0xe1,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vfmadd213bf16 %zmm2, %zmm1, %zmm0 {%k1} {z} # encoding: [0x62,0xf6,0x74,0xc9,0xa8,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
entry:
  %0 = tail call <32 x bfloat> @llvm.fma.v32bf16(<32 x bfloat> %__A, <32 x bfloat> %__B, <32 x bfloat> %__C)
  %1 = bitcast i32 %__U to <32 x i1>
  %2 = select <32 x i1> %1, <32 x bfloat> %0, <32 x bfloat> zeroinitializer
  ret <32 x bfloat> %2
}

define <32 x bfloat> @test_mm512_fmsubne_pbh(<32 x bfloat> %__A, <32 x bfloat> %__B, <32 x bfloat> %__C) {
; CHECK-LABEL: test_mm512_fmsubne_pbh:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfmsub213bf16 %zmm2, %zmm1, %zmm0 # encoding: [0x62,0xf6,0x74,0x48,0xaa,0xc2]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
entry:
  %fneg.i = fneg <32 x bfloat> %__C
  %0 = tail call <32 x bfloat> @llvm.fma.v32bf16(<32 x bfloat> %__A, <32 x bfloat> %__B, <32 x bfloat> %fneg.i)
  ret <32 x bfloat> %0
}

define <32 x bfloat> @test_mm512_mask_fmsubne_pbh(<32 x bfloat> %__A, i32 %__U, <32 x bfloat> %__B, <32 x bfloat> %__C) {
; X64-LABEL: test_mm512_mask_fmsubne_pbh:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vfmsub132bf16 %zmm1, %zmm2, %zmm0 {%k1} # encoding: [0x62,0xf6,0x6c,0x49,0x9a,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_mm512_mask_fmsubne_pbh:
; X86:       # %bb.0: # %entry
; X86-NEXT:    kmovd {{[0-9]+}}(%esp), %k1 # encoding: [0xc4,0xe1,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vfmsub132bf16 %zmm1, %zmm2, %zmm0 {%k1} # encoding: [0x62,0xf6,0x6c,0x49,0x9a,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
entry:
  %fneg.i.i = fneg <32 x bfloat> %__C
  %0 = tail call <32 x bfloat> @llvm.fma.v32bf16(<32 x bfloat> %__A, <32 x bfloat> %__B, <32 x bfloat> %fneg.i.i)
  %1 = bitcast i32 %__U to <32 x i1>
  %2 = select <32 x i1> %1, <32 x bfloat> %0, <32 x bfloat> %__A
  ret <32 x bfloat> %2
}

define <32 x bfloat> @test_mm512_mask3_fmsubne_pbh(<32 x bfloat> %__A, <32 x bfloat> %__B, <32 x bfloat> %__C, i32 %__U) {
; X64-LABEL: test_mm512_mask3_fmsubne_pbh:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vfmsub231bf16 %zmm1, %zmm0, %zmm2 {%k1} # encoding: [0x62,0xf6,0x7c,0x49,0xba,0xd1]
; X64-NEXT:    vmovaps %zmm2, %zmm0 # encoding: [0x62,0xf1,0x7c,0x48,0x28,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_mm512_mask3_fmsubne_pbh:
; X86:       # %bb.0: # %entry
; X86-NEXT:    kmovd {{[0-9]+}}(%esp), %k1 # encoding: [0xc4,0xe1,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vfmsub231bf16 %zmm1, %zmm0, %zmm2 {%k1} # encoding: [0x62,0xf6,0x7c,0x49,0xba,0xd1]
; X86-NEXT:    vmovaps %zmm2, %zmm0 # encoding: [0x62,0xf1,0x7c,0x48,0x28,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
entry:
  %fneg.i.i = fneg <32 x bfloat> %__C
  %0 = tail call <32 x bfloat> @llvm.fma.v32bf16(<32 x bfloat> %__A, <32 x bfloat> %__B, <32 x bfloat> %fneg.i.i)
  %1 = bitcast i32 %__U to <32 x i1>
  %2 = select <32 x i1> %1, <32 x bfloat> %0, <32 x bfloat> %__C
  ret <32 x bfloat> %2
}

define <32 x bfloat> @test_mm512_maskz_fmsubne_pbh(i32 %__U, <32 x bfloat> %__A, <32 x bfloat> %__B, <32 x bfloat> %__C) {
; X64-LABEL: test_mm512_maskz_fmsubne_pbh:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vfmsub213bf16 %zmm2, %zmm1, %zmm0 {%k1} {z} # encoding: [0x62,0xf6,0x74,0xc9,0xaa,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_mm512_maskz_fmsubne_pbh:
; X86:       # %bb.0: # %entry
; X86-NEXT:    kmovd {{[0-9]+}}(%esp), %k1 # encoding: [0xc4,0xe1,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vfmsub213bf16 %zmm2, %zmm1, %zmm0 {%k1} {z} # encoding: [0x62,0xf6,0x74,0xc9,0xaa,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
entry:
  %fneg.i.i = fneg <32 x bfloat> %__C
  %0 = tail call <32 x bfloat> @llvm.fma.v32bf16(<32 x bfloat> %__A, <32 x bfloat> %__B, <32 x bfloat> %fneg.i.i)
  %1 = bitcast i32 %__U to <32 x i1>
  %2 = select <32 x i1> %1, <32 x bfloat> %0, <32 x bfloat> zeroinitializer
  ret <32 x bfloat> %2
}

define <32 x bfloat> @test_mm512_fnmaddne_pbh(<32 x bfloat> %__A, <32 x bfloat> %__B, <32 x bfloat> %__C) {
; CHECK-LABEL: test_mm512_fnmaddne_pbh:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfnmadd213bf16 %zmm2, %zmm1, %zmm0 # encoding: [0x62,0xf6,0x74,0x48,0xac,0xc2]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
entry:
  %fneg.i = fneg <32 x bfloat> %__B
  %0 = tail call <32 x bfloat> @llvm.fma.v32bf16(<32 x bfloat> %__A, <32 x bfloat> %fneg.i, <32 x bfloat> %__C)
  ret <32 x bfloat> %0
}

define <32 x bfloat> @test_mm512_mask_fnmaddne_pbh(<32 x bfloat> %__A, i32 %__U, <32 x bfloat> %__B, <32 x bfloat> %__C) {
; X64-LABEL: test_mm512_mask_fnmaddne_pbh:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vfnmadd132bf16 %zmm1, %zmm2, %zmm0 {%k1} # encoding: [0x62,0xf6,0x6c,0x49,0x9c,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_mm512_mask_fnmaddne_pbh:
; X86:       # %bb.0: # %entry
; X86-NEXT:    kmovd {{[0-9]+}}(%esp), %k1 # encoding: [0xc4,0xe1,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vfnmadd132bf16 %zmm1, %zmm2, %zmm0 {%k1} # encoding: [0x62,0xf6,0x6c,0x49,0x9c,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
entry:
  %fneg.i.i = fneg <32 x bfloat> %__B
  %0 = tail call <32 x bfloat> @llvm.fma.v32bf16(<32 x bfloat> %__A, <32 x bfloat> %fneg.i.i, <32 x bfloat> %__C)
  %1 = bitcast i32 %__U to <32 x i1>
  %2 = select <32 x i1> %1, <32 x bfloat> %0, <32 x bfloat> %__A
  ret <32 x bfloat> %2
}

define <32 x bfloat> @test_mm512_mask3_fnmaddne_pbh(<32 x bfloat> %__A, <32 x bfloat> %__B, <32 x bfloat> %__C, i32 %__U) {
; X64-LABEL: test_mm512_mask3_fnmaddne_pbh:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vfnmadd231bf16 %zmm1, %zmm0, %zmm2 {%k1} # encoding: [0x62,0xf6,0x7c,0x49,0xbc,0xd1]
; X64-NEXT:    vmovaps %zmm2, %zmm0 # encoding: [0x62,0xf1,0x7c,0x48,0x28,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_mm512_mask3_fnmaddne_pbh:
; X86:       # %bb.0: # %entry
; X86-NEXT:    kmovd {{[0-9]+}}(%esp), %k1 # encoding: [0xc4,0xe1,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vfnmadd231bf16 %zmm1, %zmm0, %zmm2 {%k1} # encoding: [0x62,0xf6,0x7c,0x49,0xbc,0xd1]
; X86-NEXT:    vmovaps %zmm2, %zmm0 # encoding: [0x62,0xf1,0x7c,0x48,0x28,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
entry:
  %fneg.i.i = fneg <32 x bfloat> %__B
  %0 = tail call <32 x bfloat> @llvm.fma.v32bf16(<32 x bfloat> %__A, <32 x bfloat> %fneg.i.i, <32 x bfloat> %__C)
  %1 = bitcast i32 %__U to <32 x i1>
  %2 = select <32 x i1> %1, <32 x bfloat> %0, <32 x bfloat> %__C
  ret <32 x bfloat> %2
}

define <32 x bfloat> @test_mm512_maskz_fnmaddne_pbh(i32 %__U, <32 x bfloat> %__A, <32 x bfloat> %__B, <32 x bfloat> %__C) {
; X64-LABEL: test_mm512_maskz_fnmaddne_pbh:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vfnmadd213bf16 %zmm2, %zmm1, %zmm0 {%k1} {z} # encoding: [0x62,0xf6,0x74,0xc9,0xac,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_mm512_maskz_fnmaddne_pbh:
; X86:       # %bb.0: # %entry
; X86-NEXT:    kmovd {{[0-9]+}}(%esp), %k1 # encoding: [0xc4,0xe1,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vfnmadd213bf16 %zmm2, %zmm1, %zmm0 {%k1} {z} # encoding: [0x62,0xf6,0x74,0xc9,0xac,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
entry:
  %fneg.i.i = fneg <32 x bfloat> %__B
  %0 = tail call <32 x bfloat> @llvm.fma.v32bf16(<32 x bfloat> %__A, <32 x bfloat> %fneg.i.i, <32 x bfloat> %__C)
  %1 = bitcast i32 %__U to <32 x i1>
  %2 = select <32 x i1> %1, <32 x bfloat> %0, <32 x bfloat> zeroinitializer
  ret <32 x bfloat> %2
}

define <32 x bfloat> @test_mm512_fnmsubne_pbh(<32 x bfloat> %__A, <32 x bfloat> %__B, <32 x bfloat> %__C) {
; CHECK-LABEL: test_mm512_fnmsubne_pbh:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vfnmsub213bf16 %zmm2, %zmm1, %zmm0 # encoding: [0x62,0xf6,0x74,0x48,0xae,0xc2]
; CHECK-NEXT:    ret{{[l|q]}} # encoding: [0xc3]
entry:
  %fneg.i = fneg <32 x bfloat> %__B
  %fneg1.i = fneg <32 x bfloat> %__C
  %0 = tail call <32 x bfloat> @llvm.fma.v32bf16(<32 x bfloat> %__A, <32 x bfloat> %fneg.i, <32 x bfloat> %fneg1.i)
  ret <32 x bfloat> %0
}

define <32 x bfloat> @test_mm512_mask_fnmsubne_pbh(<32 x bfloat> %__A, i32 %__U, <32 x bfloat> %__B, <32 x bfloat> %__C) {
; X64-LABEL: test_mm512_mask_fnmsubne_pbh:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vfnmsub132bf16 %zmm1, %zmm2, %zmm0 {%k1} # encoding: [0x62,0xf6,0x6c,0x49,0x9e,0xc1]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_mm512_mask_fnmsubne_pbh:
; X86:       # %bb.0: # %entry
; X86-NEXT:    kmovd {{[0-9]+}}(%esp), %k1 # encoding: [0xc4,0xe1,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vfnmsub132bf16 %zmm1, %zmm2, %zmm0 {%k1} # encoding: [0x62,0xf6,0x6c,0x49,0x9e,0xc1]
; X86-NEXT:    retl # encoding: [0xc3]
entry:
  %fneg.i.i = fneg <32 x bfloat> %__B
  %fneg1.i.i = fneg <32 x bfloat> %__C
  %0 = tail call <32 x bfloat> @llvm.fma.v32bf16(<32 x bfloat> %__A, <32 x bfloat> %fneg.i.i, <32 x bfloat> %fneg1.i.i)
  %1 = bitcast i32 %__U to <32 x i1>
  %2 = select <32 x i1> %1, <32 x bfloat> %0, <32 x bfloat> %__A
  ret <32 x bfloat> %2
}

define <32 x bfloat> @test_mm512_mask3_fnmsubne_pbh(<32 x bfloat> %__A, <32 x bfloat> %__B, <32 x bfloat> %__C, i32 %__U) {
; X64-LABEL: test_mm512_mask3_fnmsubne_pbh:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vfnmsub231bf16 %zmm1, %zmm0, %zmm2 {%k1} # encoding: [0x62,0xf6,0x7c,0x49,0xbe,0xd1]
; X64-NEXT:    vmovaps %zmm2, %zmm0 # encoding: [0x62,0xf1,0x7c,0x48,0x28,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_mm512_mask3_fnmsubne_pbh:
; X86:       # %bb.0: # %entry
; X86-NEXT:    kmovd {{[0-9]+}}(%esp), %k1 # encoding: [0xc4,0xe1,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vfnmsub231bf16 %zmm1, %zmm0, %zmm2 {%k1} # encoding: [0x62,0xf6,0x7c,0x49,0xbe,0xd1]
; X86-NEXT:    vmovaps %zmm2, %zmm0 # encoding: [0x62,0xf1,0x7c,0x48,0x28,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
entry:
  %fneg.i.i = fneg <32 x bfloat> %__B
  %fneg1.i.i = fneg <32 x bfloat> %__C
  %0 = tail call <32 x bfloat> @llvm.fma.v32bf16(<32 x bfloat> %__A, <32 x bfloat> %fneg.i.i, <32 x bfloat> %fneg1.i.i)
  %1 = bitcast i32 %__U to <32 x i1>
  %2 = select <32 x i1> %1, <32 x bfloat> %0, <32 x bfloat> %__C
  ret <32 x bfloat> %2
}

define <32 x bfloat> @test_mm512_maskz_fnmsubne_pbh(i32 %__U, <32 x bfloat> %__A, <32 x bfloat> %__B, <32 x bfloat> %__C) {
; X64-LABEL: test_mm512_maskz_fnmsubne_pbh:
; X64:       # %bb.0: # %entry
; X64-NEXT:    kmovd %edi, %k1 # encoding: [0xc5,0xfb,0x92,0xcf]
; X64-NEXT:    vfnmsub213bf16 %zmm2, %zmm1, %zmm0 {%k1} {z} # encoding: [0x62,0xf6,0x74,0xc9,0xae,0xc2]
; X64-NEXT:    retq # encoding: [0xc3]
;
; X86-LABEL: test_mm512_maskz_fnmsubne_pbh:
; X86:       # %bb.0: # %entry
; X86-NEXT:    kmovd {{[0-9]+}}(%esp), %k1 # encoding: [0xc4,0xe1,0xf9,0x90,0x4c,0x24,0x04]
; X86-NEXT:    vfnmsub213bf16 %zmm2, %zmm1, %zmm0 {%k1} {z} # encoding: [0x62,0xf6,0x74,0xc9,0xae,0xc2]
; X86-NEXT:    retl # encoding: [0xc3]
entry:
  %fneg.i.i = fneg <32 x bfloat> %__B
  %fneg1.i.i = fneg <32 x bfloat> %__C
  %0 = tail call <32 x bfloat> @llvm.fma.v32bf16(<32 x bfloat> %__A, <32 x bfloat> %fneg.i.i, <32 x bfloat> %fneg1.i.i)
  %1 = bitcast i32 %__U to <32 x i1>
  %2 = select <32 x i1> %1, <32 x bfloat> %0, <32 x bfloat> zeroinitializer
  ret <32 x bfloat> %2
}
