; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=correlated-propagation -S < %s | FileCheck %s

; Checks that we don't crash on conflicting facts about a value
; (i.e. unreachable code)

; Test that we can handle conflict edge facts

define i8 @test(i8 %a) {
; CHECK-LABEL: @test(
; CHECK-NEXT:    [[CMP1:%.*]] = icmp eq i8 [[A:%.*]], 5
; CHECK-NEXT:    br i1 [[CMP1]], label [[NEXT:%.*]], label [[EXIT:%.*]]
; CHECK:       next:
; CHECK-NEXT:    br i1 false, label [[DEAD:%.*]], label [[EXIT]]
; CHECK:       dead:
; CHECK-NEXT:    ret i8 5
; CHECK:       exit:
; CHECK-NEXT:    ret i8 0
;
  %cmp1 = icmp eq i8 %a, 5
  br i1 %cmp1, label %next, label %exit
next:
  %cmp2 = icmp eq i8 %a, 3
  br i1 %cmp2, label %dead, label %exit
dead:
; NOTE: undef, or 3 would be equal valid
  ret i8 %a
exit:
  ret i8 0
}

declare void @llvm.assume(i1)

; Test that we can handle conflicting assume vs edge facts

define i8 @test2(i8 %a) {
; CHECK-LABEL: @test2(
; CHECK-NEXT:    [[CMP1:%.*]] = icmp eq i8 [[A:%.*]], 5
; CHECK-NEXT:    call void @llvm.assume(i1 [[CMP1]])
; CHECK-NEXT:    br i1 false, label [[DEAD:%.*]], label [[EXIT:%.*]]
; CHECK:       dead:
; CHECK-NEXT:    ret i8 5
; CHECK:       exit:
; CHECK-NEXT:    ret i8 0
;
  %cmp1 = icmp eq i8 %a, 5
  call void @llvm.assume(i1 %cmp1)
  %cmp2 = icmp eq i8 %a, 3
  br i1 %cmp2, label %dead, label %exit
dead:
  ret i8 %a
exit:
  ret i8 0
}

define i8 @test3(i8 %a) {
; CHECK-LABEL: @test3(
; CHECK-NEXT:    [[CMP1:%.*]] = icmp eq i8 [[A:%.*]], 5
; CHECK-NEXT:    br i1 [[CMP1]], label [[DEAD:%.*]], label [[EXIT:%.*]]
; CHECK:       dead:
; CHECK-NEXT:    call void @llvm.assume(i1 false)
; CHECK-NEXT:    ret i8 5
; CHECK:       exit:
; CHECK-NEXT:    ret i8 0
;
  %cmp1 = icmp eq i8 %a, 5
  br i1 %cmp1, label %dead, label %exit
dead:
  %cmp2 = icmp eq i8 %a, 3
  call void @llvm.assume(i1 %cmp2)
  ret i8 %a
exit:
  ret i8 0
}

