; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 3
; RUN: llc --mtriple=loongarch64 --mattr=+lsx < %s | FileCheck %s

define void @insert_16xi8(ptr %src, ptr %dst, i8 %ins) nounwind {
; CHECK-LABEL: insert_16xi8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a0, 0
; CHECK-NEXT:    vinsgr2vr.b $vr0, $a2, 1
; CHECK-NEXT:    vst $vr0, $a1, 0
; CHECK-NEXT:    ret
  %v = load volatile <16 x i8>, ptr %src
  %v_new = insertelement <16 x i8> %v, i8 %ins, i32 1
  store <16 x i8> %v_new, ptr %dst
  ret void
}

define void @insert_8xi16(ptr %src, ptr %dst, i16 %ins) nounwind {
; CHECK-LABEL: insert_8xi16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a0, 0
; CHECK-NEXT:    vinsgr2vr.h $vr0, $a2, 1
; CHECK-NEXT:    vst $vr0, $a1, 0
; CHECK-NEXT:    ret
  %v = load volatile <8 x i16>, ptr %src
  %v_new = insertelement <8 x i16> %v, i16 %ins, i32 1
  store <8 x i16> %v_new, ptr %dst
  ret void
}

define void @insert_4xi32(ptr %src, ptr %dst, i32 %ins) nounwind {
; CHECK-LABEL: insert_4xi32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a0, 0
; CHECK-NEXT:    vinsgr2vr.w $vr0, $a2, 1
; CHECK-NEXT:    vst $vr0, $a1, 0
; CHECK-NEXT:    ret
  %v = load volatile <4 x i32>, ptr %src
  %v_new = insertelement <4 x i32> %v, i32 %ins, i32 1
  store <4 x i32> %v_new, ptr %dst
  ret void
}

define void @insert_2xi64(ptr %src, ptr %dst, i64 %ins) nounwind {
; CHECK-LABEL: insert_2xi64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr0, $a0, 0
; CHECK-NEXT:    vinsgr2vr.d $vr0, $a2, 1
; CHECK-NEXT:    vst $vr0, $a1, 0
; CHECK-NEXT:    ret
  %v = load volatile <2 x i64>, ptr %src
  %v_new = insertelement <2 x i64> %v, i64 %ins, i32 1
  store <2 x i64> %v_new, ptr %dst
  ret void
}

define void @insert_4xfloat(ptr %src, ptr %dst, float %ins) nounwind {
; CHECK-LABEL: insert_4xfloat:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr1, $a0, 0
; CHECK-NEXT:    movfr2gr.s $a0, $fa0
; CHECK-NEXT:    vinsgr2vr.w $vr1, $a0, 1
; CHECK-NEXT:    vst $vr1, $a1, 0
; CHECK-NEXT:    ret
  %v = load volatile <4 x float>, ptr %src
  %v_new = insertelement <4 x float> %v, float %ins, i32 1
  store <4 x float> %v_new, ptr %dst
  ret void
}

define void @insert_2xdouble(ptr %src, ptr %dst, double %ins) nounwind {
; CHECK-LABEL: insert_2xdouble:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vld $vr1, $a0, 0
; CHECK-NEXT:    movfr2gr.d $a0, $fa0
; CHECK-NEXT:    vinsgr2vr.d $vr1, $a0, 1
; CHECK-NEXT:    vst $vr1, $a1, 0
; CHECK-NEXT:    ret
  %v = load volatile <2 x double>, ptr %src
  %v_new = insertelement <2 x double> %v, double %ins, i32 1
  store <2 x double> %v_new, ptr %dst
  ret void
}

define void @insert_16xi8_idx(ptr %src, ptr %dst, i8 %ins, i32 %idx) nounwind {
; CHECK-LABEL: insert_16xi8_idx:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi.d $sp, $sp, -16
; CHECK-NEXT:    vld $vr0, $a0, 0
; CHECK-NEXT:    vst $vr0, $sp, 0
; CHECK-NEXT:    addi.d $a0, $sp, 0
; CHECK-NEXT:    bstrins.d $a0, $a3, 3, 0
; CHECK-NEXT:    st.b $a2, $a0, 0
; CHECK-NEXT:    vld $vr0, $sp, 0
; CHECK-NEXT:    vst $vr0, $a1, 0
; CHECK-NEXT:    addi.d $sp, $sp, 16
; CHECK-NEXT:    ret
  %v = load volatile <16 x i8>, ptr %src
  %v_new = insertelement <16 x i8> %v, i8 %ins, i32 %idx
  store <16 x i8> %v_new, ptr %dst
  ret void
}

define void @insert_8xi16_idx(ptr %src, ptr %dst, i16 %ins, i32 %idx) nounwind {
; CHECK-LABEL: insert_8xi16_idx:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi.d $sp, $sp, -16
; CHECK-NEXT:    vld $vr0, $a0, 0
; CHECK-NEXT:    vst $vr0, $sp, 0
; CHECK-NEXT:    addi.d $a0, $sp, 0
; CHECK-NEXT:    bstrins.d $a0, $a3, 3, 1
; CHECK-NEXT:    st.h $a2, $a0, 0
; CHECK-NEXT:    vld $vr0, $sp, 0
; CHECK-NEXT:    vst $vr0, $a1, 0
; CHECK-NEXT:    addi.d $sp, $sp, 16
; CHECK-NEXT:    ret
  %v = load volatile <8 x i16>, ptr %src
  %v_new = insertelement <8 x i16> %v, i16 %ins, i32 %idx
  store <8 x i16> %v_new, ptr %dst
  ret void
}

define void @insert_4xi32_idx(ptr %src, ptr %dst, i32 %ins, i32 %idx) nounwind {
; CHECK-LABEL: insert_4xi32_idx:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi.d $sp, $sp, -16
; CHECK-NEXT:    vld $vr0, $a0, 0
; CHECK-NEXT:    vst $vr0, $sp, 0
; CHECK-NEXT:    addi.d $a0, $sp, 0
; CHECK-NEXT:    bstrins.d $a0, $a3, 3, 2
; CHECK-NEXT:    st.w $a2, $a0, 0
; CHECK-NEXT:    vld $vr0, $sp, 0
; CHECK-NEXT:    vst $vr0, $a1, 0
; CHECK-NEXT:    addi.d $sp, $sp, 16
; CHECK-NEXT:    ret
  %v = load volatile <4 x i32>, ptr %src
  %v_new = insertelement <4 x i32> %v, i32 %ins, i32 %idx
  store <4 x i32> %v_new, ptr %dst
  ret void
}

define void @insert_2xi64_idx(ptr %src, ptr %dst, i64 %ins, i32 %idx) nounwind {
; CHECK-LABEL: insert_2xi64_idx:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi.d $sp, $sp, -16
; CHECK-NEXT:    vld $vr0, $a0, 0
; CHECK-NEXT:    vst $vr0, $sp, 0
; CHECK-NEXT:    addi.d $a0, $sp, 0
; CHECK-NEXT:    bstrins.d $a0, $a3, 3, 3
; CHECK-NEXT:    st.d $a2, $a0, 0
; CHECK-NEXT:    vld $vr0, $sp, 0
; CHECK-NEXT:    vst $vr0, $a1, 0
; CHECK-NEXT:    addi.d $sp, $sp, 16
; CHECK-NEXT:    ret
  %v = load volatile <2 x i64>, ptr %src
  %v_new = insertelement <2 x i64> %v, i64 %ins, i32 %idx
  store <2 x i64> %v_new, ptr %dst
  ret void
}

define void @insert_4xfloat_idx(ptr %src, ptr %dst, float %ins, i32 %idx) nounwind {
; CHECK-LABEL: insert_4xfloat_idx:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi.d $sp, $sp, -16
; CHECK-NEXT:    vld $vr1, $a0, 0
; CHECK-NEXT:    vst $vr1, $sp, 0
; CHECK-NEXT:    addi.d $a0, $sp, 0
; CHECK-NEXT:    bstrins.d $a0, $a2, 3, 2
; CHECK-NEXT:    fst.s $fa0, $a0, 0
; CHECK-NEXT:    vld $vr0, $sp, 0
; CHECK-NEXT:    vst $vr0, $a1, 0
; CHECK-NEXT:    addi.d $sp, $sp, 16
; CHECK-NEXT:    ret
  %v = load volatile <4 x float>, ptr %src
  %v_new = insertelement <4 x float> %v, float %ins, i32 %idx
  store <4 x float> %v_new, ptr %dst
  ret void
}

define void @insert_2xdouble_idx(ptr %src, ptr %dst, double %ins, i32 %idx) nounwind {
; CHECK-LABEL: insert_2xdouble_idx:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi.d $sp, $sp, -16
; CHECK-NEXT:    vld $vr1, $a0, 0
; CHECK-NEXT:    vst $vr1, $sp, 0
; CHECK-NEXT:    addi.d $a0, $sp, 0
; CHECK-NEXT:    bstrins.d $a0, $a2, 3, 3
; CHECK-NEXT:    fst.d $fa0, $a0, 0
; CHECK-NEXT:    vld $vr0, $sp, 0
; CHECK-NEXT:    vst $vr0, $a1, 0
; CHECK-NEXT:    addi.d $sp, $sp, 16
; CHECK-NEXT:    ret
  %v = load volatile <2 x double>, ptr %src
  %v_new = insertelement <2 x double> %v, double %ins, i32 %idx
  store <2 x double> %v_new, ptr %dst
  ret void
}
