; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple=nvptx64 -mcpu=sm_90 -mattr=+ptx78 | FileCheck %s
; RUN: %if ptxas-12.2 %{ llc < %s -mtriple=nvptx64 -mcpu=sm_90 -mattr=+ptx78 | %ptxas-verify -arch=sm_90 %}

; TODO: fix "atomic load volatile acquire": generates "ld.acquire.sys;"
;       but should generate "ld.mmio.relaxed.sys; fence.acq_rel.sys;"
; TODO: fix "atomic store volatile release": generates "st.release.sys;"
;       but should generate "fence.acq_rel.sys; st.mmio.relaxed.sys;"

; TODO: fix "atomic load volatile seq_cst": generates "fence.sc.sys; ld.acquire.sys;"
;       but should generate "fence.sc.sys; ld.relaxed.mmio.sys; fence.acq_rel.sys;"
; TODO: fix "atomic store volatile seq_cst": generates "fence.sc.sys; st.release.sys;"
;       but should generate "fence.sc.sys; st.relaxed.mmio.sys;"

; TODO: add i1, <8 x i8>, and <6 x i8> vector tests.

; TODO: add test for vectors that exceed 128-bit length
; Per https://docs.nvidia.com/cuda/parallel-thread-execution/index.html#vectors
; vectors cannot exceed 128-bit in length, i.e., .v4.u64 is not allowed.

; TODO: generate PTX that preserves Concurrent Forward Progress
;       for atomic operations to local statespace
;       by generating atomic or volatile operations.

; TODO: design exposure for atomic operations on vector types.

; TODO: implement and test thread scope.

; TODO: add weak,atomic,volatile,atomic volatile tests
;       for .const and .param statespaces.

; TODO: optimize .shared.sys into .shared.cta or .shared.cluster .

;; generic statespace

; CHECK-LABEL: generic_unordered_cluster
define void @generic_unordered_cluster(ptr %a, ptr %b, ptr %c, ptr %d, ptr %e) local_unnamed_addr {
; CHECK-LABEL: generic_unordered_cluster(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<5>;
; CHECK-NEXT:    .reg .b32 %r<5>;
; CHECK-NEXT:    .reg .b64 %rd<10>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b64 %rd1, [generic_unordered_cluster_param_0];
; CHECK-NEXT:    ld.relaxed.cluster.b8 %rs1, [%rd1];
; CHECK-NEXT:    ld.param.b64 %rd2, [generic_unordered_cluster_param_1];
; CHECK-NEXT:    add.s16 %rs2, %rs1, 1;
; CHECK-NEXT:    ld.param.b64 %rd3, [generic_unordered_cluster_param_2];
; CHECK-NEXT:    st.relaxed.cluster.b8 [%rd1], %rs2;
; CHECK-NEXT:    ld.param.b64 %rd4, [generic_unordered_cluster_param_3];
; CHECK-NEXT:    ld.relaxed.cluster.b16 %rs3, [%rd2];
; CHECK-NEXT:    ld.param.b64 %rd5, [generic_unordered_cluster_param_4];
; CHECK-NEXT:    add.s16 %rs4, %rs3, 1;
; CHECK-NEXT:    st.relaxed.cluster.b16 [%rd2], %rs4;
; CHECK-NEXT:    ld.relaxed.cluster.b32 %r1, [%rd3];
; CHECK-NEXT:    add.s32 %r2, %r1, 1;
; CHECK-NEXT:    st.relaxed.cluster.b32 [%rd3], %r2;
; CHECK-NEXT:    ld.relaxed.cluster.b64 %rd6, [%rd4];
; CHECK-NEXT:    add.s64 %rd7, %rd6, 1;
; CHECK-NEXT:    st.relaxed.cluster.b64 [%rd4], %rd7;
; CHECK-NEXT:    ld.relaxed.cluster.b32 %r3, [%rd5];
; CHECK-NEXT:    add.rn.f32 %r4, %r3, 0f3F800000;
; CHECK-NEXT:    st.relaxed.cluster.b32 [%rd5], %r4;
; CHECK-NEXT:    ld.relaxed.cluster.b64 %rd8, [%rd5];
; CHECK-NEXT:    add.rn.f64 %rd9, %rd8, 0d3FF0000000000000;
; CHECK-NEXT:    st.relaxed.cluster.b64 [%rd5], %rd9;
; CHECK-NEXT:    ret;
  %a.load = load atomic i8, ptr %a syncscope("cluster") unordered, align 1
  %a.add = add i8 %a.load, 1
  store atomic i8 %a.add, ptr %a syncscope("cluster") unordered, align 1

  %b.load = load atomic i16, ptr %b syncscope("cluster") unordered, align 2
  %b.add = add i16 %b.load, 1
  store atomic i16 %b.add, ptr %b syncscope("cluster") unordered, align 2

  %c.load = load atomic i32, ptr %c syncscope("cluster") unordered, align 4
  %c.add = add i32 %c.load, 1
  store atomic i32 %c.add, ptr %c syncscope("cluster") unordered, align 4

  %d.load = load atomic i64, ptr %d syncscope("cluster") unordered, align 8
  %d.add = add i64 %d.load, 1
  store atomic i64 %d.add, ptr %d syncscope("cluster") unordered, align 8

  %e.load = load atomic float, ptr %e syncscope("cluster") unordered, align 4
  %e.add = fadd float %e.load, 1.
  store atomic float %e.add, ptr %e syncscope("cluster") unordered, align 4

  %f.load = load atomic double, ptr %e syncscope("cluster") unordered, align 8
  %f.add = fadd double %f.load, 1.
  store atomic double %f.add, ptr %e syncscope("cluster") unordered, align 8

  ret void
}

; CHECK-LABEL: generic_unordered_volatile_cluster
define void @generic_unordered_volatile_cluster(ptr %a, ptr %b, ptr %c, ptr %d, ptr %e) local_unnamed_addr {
; CHECK-LABEL: generic_unordered_volatile_cluster(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<5>;
; CHECK-NEXT:    .reg .b32 %r<5>;
; CHECK-NEXT:    .reg .b64 %rd<10>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b64 %rd1, [generic_unordered_volatile_cluster_param_0];
; CHECK-NEXT:    ld.volatile.b8 %rs1, [%rd1];
; CHECK-NEXT:    ld.param.b64 %rd2, [generic_unordered_volatile_cluster_param_1];
; CHECK-NEXT:    add.s16 %rs2, %rs1, 1;
; CHECK-NEXT:    ld.param.b64 %rd3, [generic_unordered_volatile_cluster_param_2];
; CHECK-NEXT:    st.volatile.b8 [%rd1], %rs2;
; CHECK-NEXT:    ld.param.b64 %rd4, [generic_unordered_volatile_cluster_param_3];
; CHECK-NEXT:    ld.volatile.b16 %rs3, [%rd2];
; CHECK-NEXT:    ld.param.b64 %rd5, [generic_unordered_volatile_cluster_param_4];
; CHECK-NEXT:    add.s16 %rs4, %rs3, 1;
; CHECK-NEXT:    st.volatile.b16 [%rd2], %rs4;
; CHECK-NEXT:    ld.volatile.b32 %r1, [%rd3];
; CHECK-NEXT:    add.s32 %r2, %r1, 1;
; CHECK-NEXT:    st.volatile.b32 [%rd3], %r2;
; CHECK-NEXT:    ld.volatile.b64 %rd6, [%rd4];
; CHECK-NEXT:    add.s64 %rd7, %rd6, 1;
; CHECK-NEXT:    st.volatile.b64 [%rd4], %rd7;
; CHECK-NEXT:    ld.volatile.b32 %r3, [%rd5];
; CHECK-NEXT:    add.rn.f32 %r4, %r3, 0f3F800000;
; CHECK-NEXT:    st.volatile.b32 [%rd5], %r4;
; CHECK-NEXT:    ld.volatile.b64 %rd8, [%rd5];
; CHECK-NEXT:    add.rn.f64 %rd9, %rd8, 0d3FF0000000000000;
; CHECK-NEXT:    st.volatile.b64 [%rd5], %rd9;
; CHECK-NEXT:    ret;
  %a.load = load atomic volatile i8, ptr %a syncscope("cluster") unordered, align 1
  %a.add = add i8 %a.load, 1
  store atomic volatile i8 %a.add, ptr %a syncscope("cluster") unordered, align 1

  %b.load = load atomic volatile i16, ptr %b syncscope("cluster") unordered, align 2
  %b.add = add i16 %b.load, 1
  store atomic volatile i16 %b.add, ptr %b syncscope("cluster") unordered, align 2

  %c.load = load atomic volatile i32, ptr %c syncscope("cluster") unordered, align 4
  %c.add = add i32 %c.load, 1
  store atomic volatile i32 %c.add, ptr %c syncscope("cluster") unordered, align 4

  %d.load = load atomic volatile i64, ptr %d syncscope("cluster") unordered, align 8
  %d.add = add i64 %d.load, 1
  store atomic volatile i64 %d.add, ptr %d syncscope("cluster") unordered, align 8

  %e.load = load atomic volatile float, ptr %e syncscope("cluster") unordered, align 4
  %e.add = fadd float %e.load, 1.
  store atomic volatile float %e.add, ptr %e syncscope("cluster") unordered, align 4

  %f.load = load atomic volatile double, ptr %e syncscope("cluster") unordered, align 8
  %f.add = fadd double %f.load, 1.
  store atomic volatile double %f.add, ptr %e syncscope("cluster") unordered, align 8

  ret void
}

; CHECK-LABEL: generic_monotonic_cluster
define void @generic_monotonic_cluster(ptr %a, ptr %b, ptr %c, ptr %d, ptr %e) local_unnamed_addr {
; CHECK-LABEL: generic_monotonic_cluster(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<5>;
; CHECK-NEXT:    .reg .b32 %r<5>;
; CHECK-NEXT:    .reg .b64 %rd<10>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b64 %rd1, [generic_monotonic_cluster_param_0];
; CHECK-NEXT:    ld.relaxed.cluster.b8 %rs1, [%rd1];
; CHECK-NEXT:    ld.param.b64 %rd2, [generic_monotonic_cluster_param_1];
; CHECK-NEXT:    add.s16 %rs2, %rs1, 1;
; CHECK-NEXT:    ld.param.b64 %rd3, [generic_monotonic_cluster_param_2];
; CHECK-NEXT:    st.relaxed.cluster.b8 [%rd1], %rs2;
; CHECK-NEXT:    ld.param.b64 %rd4, [generic_monotonic_cluster_param_3];
; CHECK-NEXT:    ld.relaxed.cluster.b16 %rs3, [%rd2];
; CHECK-NEXT:    ld.param.b64 %rd5, [generic_monotonic_cluster_param_4];
; CHECK-NEXT:    add.s16 %rs4, %rs3, 1;
; CHECK-NEXT:    st.relaxed.cluster.b16 [%rd2], %rs4;
; CHECK-NEXT:    ld.relaxed.cluster.b32 %r1, [%rd3];
; CHECK-NEXT:    add.s32 %r2, %r1, 1;
; CHECK-NEXT:    st.relaxed.cluster.b32 [%rd3], %r2;
; CHECK-NEXT:    ld.relaxed.cluster.b64 %rd6, [%rd4];
; CHECK-NEXT:    add.s64 %rd7, %rd6, 1;
; CHECK-NEXT:    st.relaxed.cluster.b64 [%rd4], %rd7;
; CHECK-NEXT:    ld.relaxed.cluster.b32 %r3, [%rd5];
; CHECK-NEXT:    add.rn.f32 %r4, %r3, 0f3F800000;
; CHECK-NEXT:    st.relaxed.cluster.b32 [%rd5], %r4;
; CHECK-NEXT:    ld.relaxed.cluster.b64 %rd8, [%rd5];
; CHECK-NEXT:    add.rn.f64 %rd9, %rd8, 0d3FF0000000000000;
; CHECK-NEXT:    st.relaxed.cluster.b64 [%rd5], %rd9;
; CHECK-NEXT:    ret;
  %a.load = load atomic i8, ptr %a syncscope("cluster") monotonic, align 1
  %a.add = add i8 %a.load, 1
  store atomic i8 %a.add, ptr %a syncscope("cluster") monotonic, align 1

  %b.load = load atomic i16, ptr %b syncscope("cluster") monotonic, align 2
  %b.add = add i16 %b.load, 1
  store atomic i16 %b.add, ptr %b syncscope("cluster") monotonic, align 2

  %c.load = load atomic i32, ptr %c syncscope("cluster") monotonic, align 4
  %c.add = add i32 %c.load, 1
  store atomic i32 %c.add, ptr %c syncscope("cluster") monotonic, align 4

  %d.load = load atomic i64, ptr %d syncscope("cluster") monotonic, align 8
  %d.add = add i64 %d.load, 1
  store atomic i64 %d.add, ptr %d syncscope("cluster") monotonic, align 8

  %e.load = load atomic float, ptr %e syncscope("cluster") monotonic, align 4
  %e.add = fadd float %e.load, 1.
  store atomic float %e.add, ptr %e syncscope("cluster") monotonic, align 4

  %f.load = load atomic double, ptr %e syncscope("cluster") monotonic, align 8
  %f.add = fadd double %f.load, 1.
  store atomic double %f.add, ptr %e syncscope("cluster") monotonic, align 8

  ret void
}

; CHECK-LABEL: generic_monotonic_volatile_cluster
define void @generic_monotonic_volatile_cluster(ptr %a, ptr %b, ptr %c, ptr %d, ptr %e) local_unnamed_addr {
; CHECK-LABEL: generic_monotonic_volatile_cluster(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<5>;
; CHECK-NEXT:    .reg .b32 %r<5>;
; CHECK-NEXT:    .reg .b64 %rd<10>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b64 %rd1, [generic_monotonic_volatile_cluster_param_0];
; CHECK-NEXT:    ld.volatile.b8 %rs1, [%rd1];
; CHECK-NEXT:    ld.param.b64 %rd2, [generic_monotonic_volatile_cluster_param_1];
; CHECK-NEXT:    add.s16 %rs2, %rs1, 1;
; CHECK-NEXT:    ld.param.b64 %rd3, [generic_monotonic_volatile_cluster_param_2];
; CHECK-NEXT:    st.volatile.b8 [%rd1], %rs2;
; CHECK-NEXT:    ld.param.b64 %rd4, [generic_monotonic_volatile_cluster_param_3];
; CHECK-NEXT:    ld.volatile.b16 %rs3, [%rd2];
; CHECK-NEXT:    ld.param.b64 %rd5, [generic_monotonic_volatile_cluster_param_4];
; CHECK-NEXT:    add.s16 %rs4, %rs3, 1;
; CHECK-NEXT:    st.volatile.b16 [%rd2], %rs4;
; CHECK-NEXT:    ld.volatile.b32 %r1, [%rd3];
; CHECK-NEXT:    add.s32 %r2, %r1, 1;
; CHECK-NEXT:    st.volatile.b32 [%rd3], %r2;
; CHECK-NEXT:    ld.volatile.b64 %rd6, [%rd4];
; CHECK-NEXT:    add.s64 %rd7, %rd6, 1;
; CHECK-NEXT:    st.volatile.b64 [%rd4], %rd7;
; CHECK-NEXT:    ld.volatile.b32 %r3, [%rd5];
; CHECK-NEXT:    add.rn.f32 %r4, %r3, 0f3F800000;
; CHECK-NEXT:    st.volatile.b32 [%rd5], %r4;
; CHECK-NEXT:    ld.volatile.b64 %rd8, [%rd5];
; CHECK-NEXT:    add.rn.f64 %rd9, %rd8, 0d3FF0000000000000;
; CHECK-NEXT:    st.volatile.b64 [%rd5], %rd9;
; CHECK-NEXT:    ret;
  %a.load = load atomic volatile i8, ptr %a syncscope("cluster") monotonic, align 1
  %a.add = add i8 %a.load, 1
  store atomic volatile i8 %a.add, ptr %a syncscope("cluster") monotonic, align 1

  %b.load = load atomic volatile i16, ptr %b syncscope("cluster") monotonic, align 2
  %b.add = add i16 %b.load, 1
  store atomic volatile i16 %b.add, ptr %b syncscope("cluster") monotonic, align 2

  %c.load = load atomic volatile i32, ptr %c syncscope("cluster") monotonic, align 4
  %c.add = add i32 %c.load, 1
  store atomic volatile i32 %c.add, ptr %c syncscope("cluster") monotonic, align 4

  %d.load = load atomic volatile i64, ptr %d syncscope("cluster") monotonic, align 8
  %d.add = add i64 %d.load, 1
  store atomic volatile i64 %d.add, ptr %d syncscope("cluster") monotonic, align 8

  %e.load = load atomic volatile float, ptr %e syncscope("cluster") monotonic, align 4
  %e.add = fadd float %e.load, 1.
  store atomic volatile float %e.add, ptr %e syncscope("cluster") monotonic, align 4

  %f.load = load atomic volatile double, ptr %e syncscope("cluster") monotonic, align 8
  %f.add = fadd double %f.load, 1.
  store atomic volatile double %f.add, ptr %e syncscope("cluster") monotonic, align 8

  ret void
}

; CHECK-LABEL: generic_acq_rel_cluster
define void @generic_acq_rel_cluster(ptr %a, ptr %b, ptr %c, ptr %d, ptr %e) local_unnamed_addr {
; CHECK-LABEL: generic_acq_rel_cluster(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<5>;
; CHECK-NEXT:    .reg .b32 %r<5>;
; CHECK-NEXT:    .reg .b64 %rd<10>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b64 %rd1, [generic_acq_rel_cluster_param_0];
; CHECK-NEXT:    ld.acquire.cluster.b8 %rs1, [%rd1];
; CHECK-NEXT:    ld.param.b64 %rd2, [generic_acq_rel_cluster_param_1];
; CHECK-NEXT:    add.s16 %rs2, %rs1, 1;
; CHECK-NEXT:    ld.param.b64 %rd3, [generic_acq_rel_cluster_param_2];
; CHECK-NEXT:    st.release.cluster.b8 [%rd1], %rs2;
; CHECK-NEXT:    ld.param.b64 %rd4, [generic_acq_rel_cluster_param_3];
; CHECK-NEXT:    ld.acquire.cluster.b16 %rs3, [%rd2];
; CHECK-NEXT:    ld.param.b64 %rd5, [generic_acq_rel_cluster_param_4];
; CHECK-NEXT:    add.s16 %rs4, %rs3, 1;
; CHECK-NEXT:    st.release.cluster.b16 [%rd2], %rs4;
; CHECK-NEXT:    ld.acquire.cluster.b32 %r1, [%rd3];
; CHECK-NEXT:    add.s32 %r2, %r1, 1;
; CHECK-NEXT:    st.release.cluster.b32 [%rd3], %r2;
; CHECK-NEXT:    ld.acquire.cluster.b64 %rd6, [%rd4];
; CHECK-NEXT:    add.s64 %rd7, %rd6, 1;
; CHECK-NEXT:    st.release.cluster.b64 [%rd4], %rd7;
; CHECK-NEXT:    ld.acquire.cluster.b32 %r3, [%rd5];
; CHECK-NEXT:    add.rn.f32 %r4, %r3, 0f3F800000;
; CHECK-NEXT:    st.release.cluster.b32 [%rd5], %r4;
; CHECK-NEXT:    ld.acquire.cluster.b64 %rd8, [%rd5];
; CHECK-NEXT:    add.rn.f64 %rd9, %rd8, 0d3FF0000000000000;
; CHECK-NEXT:    st.release.cluster.b64 [%rd5], %rd9;
; CHECK-NEXT:    ret;
  %a.load = load atomic i8, ptr %a syncscope("cluster") acquire, align 1
  %a.add = add i8 %a.load, 1
  store atomic i8 %a.add, ptr %a syncscope("cluster") release, align 1

  %b.load = load atomic i16, ptr %b syncscope("cluster") acquire, align 2
  %b.add = add i16 %b.load, 1
  store atomic i16 %b.add, ptr %b syncscope("cluster") release, align 2

  %c.load = load atomic i32, ptr %c syncscope("cluster") acquire, align 4
  %c.add = add i32 %c.load, 1
  store atomic i32 %c.add, ptr %c syncscope("cluster") release, align 4

  %d.load = load atomic i64, ptr %d syncscope("cluster") acquire, align 8
  %d.add = add i64 %d.load, 1
  store atomic i64 %d.add, ptr %d syncscope("cluster") release, align 8

  %e.load = load atomic float, ptr %e syncscope("cluster") acquire, align 4
  %e.add = fadd float %e.load, 1.
  store atomic float %e.add, ptr %e syncscope("cluster") release, align 4

  %f.load = load atomic double, ptr %e syncscope("cluster") acquire, align 8
  %f.add = fadd double %f.load, 1.
  store atomic double %f.add, ptr %e syncscope("cluster") release, align 8

  ret void
}

; CHECK-LABEL: generic_acq_rel_volatile_cluster
define void @generic_acq_rel_volatile_cluster(ptr %a, ptr %b, ptr %c, ptr %d, ptr %e) local_unnamed_addr {
; CHECK-LABEL: generic_acq_rel_volatile_cluster(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<5>;
; CHECK-NEXT:    .reg .b32 %r<5>;
; CHECK-NEXT:    .reg .b64 %rd<10>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b64 %rd1, [generic_acq_rel_volatile_cluster_param_0];
; CHECK-NEXT:    ld.acquire.sys.b8 %rs1, [%rd1];
; CHECK-NEXT:    ld.param.b64 %rd2, [generic_acq_rel_volatile_cluster_param_1];
; CHECK-NEXT:    add.s16 %rs2, %rs1, 1;
; CHECK-NEXT:    ld.param.b64 %rd3, [generic_acq_rel_volatile_cluster_param_2];
; CHECK-NEXT:    st.release.sys.b8 [%rd1], %rs2;
; CHECK-NEXT:    ld.param.b64 %rd4, [generic_acq_rel_volatile_cluster_param_3];
; CHECK-NEXT:    ld.acquire.sys.b16 %rs3, [%rd2];
; CHECK-NEXT:    ld.param.b64 %rd5, [generic_acq_rel_volatile_cluster_param_4];
; CHECK-NEXT:    add.s16 %rs4, %rs3, 1;
; CHECK-NEXT:    st.release.sys.b16 [%rd2], %rs4;
; CHECK-NEXT:    ld.acquire.sys.b32 %r1, [%rd3];
; CHECK-NEXT:    add.s32 %r2, %r1, 1;
; CHECK-NEXT:    st.release.sys.b32 [%rd3], %r2;
; CHECK-NEXT:    ld.acquire.sys.b64 %rd6, [%rd4];
; CHECK-NEXT:    add.s64 %rd7, %rd6, 1;
; CHECK-NEXT:    st.release.sys.b64 [%rd4], %rd7;
; CHECK-NEXT:    ld.acquire.sys.b32 %r3, [%rd5];
; CHECK-NEXT:    add.rn.f32 %r4, %r3, 0f3F800000;
; CHECK-NEXT:    st.release.sys.b32 [%rd5], %r4;
; CHECK-NEXT:    ld.acquire.sys.b64 %rd8, [%rd5];
; CHECK-NEXT:    add.rn.f64 %rd9, %rd8, 0d3FF0000000000000;
; CHECK-NEXT:    st.release.sys.b64 [%rd5], %rd9;
; CHECK-NEXT:    ret;
  %a.load = load atomic volatile i8, ptr %a syncscope("cluster") acquire, align 1
  %a.add = add i8 %a.load, 1
  store atomic volatile i8 %a.add, ptr %a syncscope("cluster") release, align 1

  %b.load = load atomic volatile i16, ptr %b syncscope("cluster") acquire, align 2
  %b.add = add i16 %b.load, 1
  store atomic volatile i16 %b.add, ptr %b syncscope("cluster") release, align 2

  %c.load = load atomic volatile i32, ptr %c syncscope("cluster") acquire, align 4
  %c.add = add i32 %c.load, 1
  store atomic volatile i32 %c.add, ptr %c syncscope("cluster") release, align 4

  %d.load = load atomic volatile i64, ptr %d syncscope("cluster") acquire, align 8
  %d.add = add i64 %d.load, 1
  store atomic volatile i64 %d.add, ptr %d syncscope("cluster") release, align 8

  %e.load = load atomic volatile float, ptr %e syncscope("cluster") acquire, align 4
  %e.add = fadd float %e.load, 1.
  store atomic volatile float %e.add, ptr %e syncscope("cluster") release, align 4

  %f.load = load atomic volatile double, ptr %e syncscope("cluster") acquire, align 8
  %f.add = fadd double %f.load, 1.
  store atomic volatile double %f.add, ptr %e syncscope("cluster") release, align 8

  ret void
}

; CHECK-LABEL: generic_sc_cluster
define void @generic_sc_cluster(ptr %a, ptr %b, ptr %c, ptr %d, ptr %e) local_unnamed_addr {
; CHECK-LABEL: generic_sc_cluster(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<5>;
; CHECK-NEXT:    .reg .b32 %r<5>;
; CHECK-NEXT:    .reg .b64 %rd<10>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b64 %rd1, [generic_sc_cluster_param_0];
; CHECK-NEXT:    fence.sc.cluster;
; CHECK-NEXT:    ld.acquire.cluster.b8 %rs1, [%rd1];
; CHECK-NEXT:    ld.param.b64 %rd2, [generic_sc_cluster_param_1];
; CHECK-NEXT:    add.s16 %rs2, %rs1, 1;
; CHECK-NEXT:    ld.param.b64 %rd3, [generic_sc_cluster_param_2];
; CHECK-NEXT:    fence.sc.cluster;
; CHECK-NEXT:    st.release.cluster.b8 [%rd1], %rs2;
; CHECK-NEXT:    ld.param.b64 %rd4, [generic_sc_cluster_param_3];
; CHECK-NEXT:    fence.sc.cluster;
; CHECK-NEXT:    ld.acquire.cluster.b16 %rs3, [%rd2];
; CHECK-NEXT:    ld.param.b64 %rd5, [generic_sc_cluster_param_4];
; CHECK-NEXT:    add.s16 %rs4, %rs3, 1;
; CHECK-NEXT:    fence.sc.cluster;
; CHECK-NEXT:    st.release.cluster.b16 [%rd2], %rs4;
; CHECK-NEXT:    fence.sc.cluster;
; CHECK-NEXT:    ld.acquire.cluster.b32 %r1, [%rd3];
; CHECK-NEXT:    add.s32 %r2, %r1, 1;
; CHECK-NEXT:    fence.sc.cluster;
; CHECK-NEXT:    st.release.cluster.b32 [%rd3], %r2;
; CHECK-NEXT:    fence.sc.cluster;
; CHECK-NEXT:    ld.acquire.cluster.b64 %rd6, [%rd4];
; CHECK-NEXT:    add.s64 %rd7, %rd6, 1;
; CHECK-NEXT:    fence.sc.cluster;
; CHECK-NEXT:    st.release.cluster.b64 [%rd4], %rd7;
; CHECK-NEXT:    fence.sc.cluster;
; CHECK-NEXT:    ld.acquire.cluster.b32 %r3, [%rd5];
; CHECK-NEXT:    add.rn.f32 %r4, %r3, 0f3F800000;
; CHECK-NEXT:    fence.sc.cluster;
; CHECK-NEXT:    st.release.cluster.b32 [%rd5], %r4;
; CHECK-NEXT:    fence.sc.cluster;
; CHECK-NEXT:    ld.acquire.cluster.b64 %rd8, [%rd5];
; CHECK-NEXT:    add.rn.f64 %rd9, %rd8, 0d3FF0000000000000;
; CHECK-NEXT:    fence.sc.cluster;
; CHECK-NEXT:    st.release.cluster.b64 [%rd5], %rd9;
; CHECK-NEXT:    ret;
  %a.load = load atomic i8, ptr %a syncscope("cluster") seq_cst, align 1
  %a.add = add i8 %a.load, 1
  store atomic i8 %a.add, ptr %a syncscope("cluster") seq_cst, align 1

  %b.load = load atomic i16, ptr %b syncscope("cluster") seq_cst, align 2
  %b.add = add i16 %b.load, 1
  store atomic i16 %b.add, ptr %b syncscope("cluster") seq_cst, align 2

  %c.load = load atomic i32, ptr %c syncscope("cluster") seq_cst, align 4
  %c.add = add i32 %c.load, 1
  store atomic i32 %c.add, ptr %c syncscope("cluster") seq_cst, align 4

  %d.load = load atomic i64, ptr %d syncscope("cluster") seq_cst, align 8
  %d.add = add i64 %d.load, 1
  store atomic i64 %d.add, ptr %d syncscope("cluster") seq_cst, align 8

  %e.load = load atomic float, ptr %e syncscope("cluster") seq_cst, align 4
  %e.add = fadd float %e.load, 1.
  store atomic float %e.add, ptr %e syncscope("cluster") seq_cst, align 4

  %f.load = load atomic double, ptr %e syncscope("cluster") seq_cst, align 8
  %f.add = fadd double %f.load, 1.
  store atomic double %f.add, ptr %e syncscope("cluster") seq_cst, align 8

  ret void
}

; CHECK-LABEL: generic_sc_volatile_cluster
define void @generic_sc_volatile_cluster(ptr %a, ptr %b, ptr %c, ptr %d, ptr %e) local_unnamed_addr {
; CHECK-LABEL: generic_sc_volatile_cluster(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<5>;
; CHECK-NEXT:    .reg .b32 %r<5>;
; CHECK-NEXT:    .reg .b64 %rd<10>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b64 %rd1, [generic_sc_volatile_cluster_param_0];
; CHECK-NEXT:    fence.sc.sys;
; CHECK-NEXT:    ld.acquire.sys.b8 %rs1, [%rd1];
; CHECK-NEXT:    ld.param.b64 %rd2, [generic_sc_volatile_cluster_param_1];
; CHECK-NEXT:    add.s16 %rs2, %rs1, 1;
; CHECK-NEXT:    ld.param.b64 %rd3, [generic_sc_volatile_cluster_param_2];
; CHECK-NEXT:    fence.sc.sys;
; CHECK-NEXT:    st.release.sys.b8 [%rd1], %rs2;
; CHECK-NEXT:    ld.param.b64 %rd4, [generic_sc_volatile_cluster_param_3];
; CHECK-NEXT:    fence.sc.sys;
; CHECK-NEXT:    ld.acquire.sys.b16 %rs3, [%rd2];
; CHECK-NEXT:    ld.param.b64 %rd5, [generic_sc_volatile_cluster_param_4];
; CHECK-NEXT:    add.s16 %rs4, %rs3, 1;
; CHECK-NEXT:    fence.sc.sys;
; CHECK-NEXT:    st.release.sys.b16 [%rd2], %rs4;
; CHECK-NEXT:    fence.sc.sys;
; CHECK-NEXT:    ld.acquire.sys.b32 %r1, [%rd3];
; CHECK-NEXT:    add.s32 %r2, %r1, 1;
; CHECK-NEXT:    fence.sc.sys;
; CHECK-NEXT:    st.release.sys.b32 [%rd3], %r2;
; CHECK-NEXT:    fence.sc.sys;
; CHECK-NEXT:    ld.acquire.sys.b64 %rd6, [%rd4];
; CHECK-NEXT:    add.s64 %rd7, %rd6, 1;
; CHECK-NEXT:    fence.sc.sys;
; CHECK-NEXT:    st.release.sys.b64 [%rd4], %rd7;
; CHECK-NEXT:    fence.sc.sys;
; CHECK-NEXT:    ld.acquire.sys.b32 %r3, [%rd5];
; CHECK-NEXT:    add.rn.f32 %r4, %r3, 0f3F800000;
; CHECK-NEXT:    fence.sc.sys;
; CHECK-NEXT:    st.release.sys.b32 [%rd5], %r4;
; CHECK-NEXT:    fence.sc.sys;
; CHECK-NEXT:    ld.acquire.sys.b64 %rd8, [%rd5];
; CHECK-NEXT:    add.rn.f64 %rd9, %rd8, 0d3FF0000000000000;
; CHECK-NEXT:    fence.sc.sys;
; CHECK-NEXT:    st.release.sys.b64 [%rd5], %rd9;
; CHECK-NEXT:    ret;
  %a.load = load atomic volatile i8, ptr %a syncscope("cluster") seq_cst, align 1
  %a.add = add i8 %a.load, 1
  store atomic volatile i8 %a.add, ptr %a syncscope("cluster") seq_cst, align 1

  %b.load = load atomic volatile i16, ptr %b syncscope("cluster") seq_cst, align 2
  %b.add = add i16 %b.load, 1
  store atomic volatile i16 %b.add, ptr %b syncscope("cluster") seq_cst, align 2

  %c.load = load atomic volatile i32, ptr %c syncscope("cluster") seq_cst, align 4
  %c.add = add i32 %c.load, 1
  store atomic volatile i32 %c.add, ptr %c syncscope("cluster") seq_cst, align 4

  %d.load = load atomic volatile i64, ptr %d syncscope("cluster") seq_cst, align 8
  %d.add = add i64 %d.load, 1
  store atomic volatile i64 %d.add, ptr %d syncscope("cluster") seq_cst, align 8

  %e.load = load atomic volatile float, ptr %e syncscope("cluster") seq_cst, align 4
  %e.add = fadd float %e.load, 1.
  store atomic volatile float %e.add, ptr %e syncscope("cluster") seq_cst, align 4

  %f.load = load atomic volatile double, ptr %e syncscope("cluster") seq_cst, align 8
  %f.add = fadd double %f.load, 1.
  store atomic volatile double %f.add, ptr %e syncscope("cluster") seq_cst, align 8

  ret void
}

;; global statespace

; CHECK-LABEL: global_unordered_cluster
define void @global_unordered_cluster(ptr addrspace(1) %a, ptr addrspace(1) %b, ptr addrspace(1) %c, ptr addrspace(1) %d, ptr addrspace(1) %e) local_unnamed_addr {
; CHECK-LABEL: global_unordered_cluster(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<5>;
; CHECK-NEXT:    .reg .b32 %r<5>;
; CHECK-NEXT:    .reg .b64 %rd<10>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b64 %rd1, [global_unordered_cluster_param_0];
; CHECK-NEXT:    ld.relaxed.cluster.global.b8 %rs1, [%rd1];
; CHECK-NEXT:    ld.param.b64 %rd2, [global_unordered_cluster_param_1];
; CHECK-NEXT:    add.s16 %rs2, %rs1, 1;
; CHECK-NEXT:    ld.param.b64 %rd3, [global_unordered_cluster_param_2];
; CHECK-NEXT:    st.relaxed.cluster.global.b8 [%rd1], %rs2;
; CHECK-NEXT:    ld.param.b64 %rd4, [global_unordered_cluster_param_3];
; CHECK-NEXT:    ld.relaxed.cluster.global.b16 %rs3, [%rd2];
; CHECK-NEXT:    ld.param.b64 %rd5, [global_unordered_cluster_param_4];
; CHECK-NEXT:    add.s16 %rs4, %rs3, 1;
; CHECK-NEXT:    st.relaxed.cluster.global.b16 [%rd2], %rs4;
; CHECK-NEXT:    ld.relaxed.cluster.global.b32 %r1, [%rd3];
; CHECK-NEXT:    add.s32 %r2, %r1, 1;
; CHECK-NEXT:    st.relaxed.cluster.global.b32 [%rd3], %r2;
; CHECK-NEXT:    ld.relaxed.cluster.global.b64 %rd6, [%rd4];
; CHECK-NEXT:    add.s64 %rd7, %rd6, 1;
; CHECK-NEXT:    st.relaxed.cluster.global.b64 [%rd4], %rd7;
; CHECK-NEXT:    ld.relaxed.cluster.global.b32 %r3, [%rd5];
; CHECK-NEXT:    add.rn.f32 %r4, %r3, 0f3F800000;
; CHECK-NEXT:    st.relaxed.cluster.global.b32 [%rd5], %r4;
; CHECK-NEXT:    ld.relaxed.cluster.global.b64 %rd8, [%rd5];
; CHECK-NEXT:    add.rn.f64 %rd9, %rd8, 0d3FF0000000000000;
; CHECK-NEXT:    st.relaxed.cluster.global.b64 [%rd5], %rd9;
; CHECK-NEXT:    ret;
  %a.load = load atomic i8, ptr addrspace(1) %a syncscope("cluster") unordered, align 1
  %a.add = add i8 %a.load, 1
  store atomic i8 %a.add, ptr addrspace(1) %a syncscope("cluster") unordered, align 1

  %b.load = load atomic i16, ptr addrspace(1) %b syncscope("cluster") unordered, align 2
  %b.add = add i16 %b.load, 1
  store atomic i16 %b.add, ptr addrspace(1) %b syncscope("cluster") unordered, align 2

  %c.load = load atomic i32, ptr addrspace(1) %c syncscope("cluster") unordered, align 4
  %c.add = add i32 %c.load, 1
  store atomic i32 %c.add, ptr addrspace(1) %c syncscope("cluster") unordered, align 4

  %d.load = load atomic i64, ptr addrspace(1) %d syncscope("cluster") unordered, align 8
  %d.add = add i64 %d.load, 1
  store atomic i64 %d.add, ptr addrspace(1) %d syncscope("cluster") unordered, align 8

  %e.load = load atomic float, ptr addrspace(1) %e syncscope("cluster") unordered, align 4
  %e.add = fadd float %e.load, 1.
  store atomic float %e.add, ptr addrspace(1) %e syncscope("cluster") unordered, align 4

  %f.load = load atomic double, ptr addrspace(1) %e syncscope("cluster") unordered, align 8
  %f.add = fadd double %f.load, 1.
  store atomic double %f.add, ptr addrspace(1) %e syncscope("cluster") unordered, align 8

  ret void
}

; CHECK-LABEL: global_unordered_volatile_cluster
define void @global_unordered_volatile_cluster(ptr addrspace(1) %a, ptr addrspace(1) %b, ptr addrspace(1) %c, ptr addrspace(1) %d, ptr addrspace(1) %e) local_unnamed_addr {
; CHECK-LABEL: global_unordered_volatile_cluster(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<5>;
; CHECK-NEXT:    .reg .b32 %r<5>;
; CHECK-NEXT:    .reg .b64 %rd<10>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b64 %rd1, [global_unordered_volatile_cluster_param_0];
; CHECK-NEXT:    ld.volatile.global.b8 %rs1, [%rd1];
; CHECK-NEXT:    ld.param.b64 %rd2, [global_unordered_volatile_cluster_param_1];
; CHECK-NEXT:    add.s16 %rs2, %rs1, 1;
; CHECK-NEXT:    ld.param.b64 %rd3, [global_unordered_volatile_cluster_param_2];
; CHECK-NEXT:    st.volatile.global.b8 [%rd1], %rs2;
; CHECK-NEXT:    ld.param.b64 %rd4, [global_unordered_volatile_cluster_param_3];
; CHECK-NEXT:    ld.volatile.global.b16 %rs3, [%rd2];
; CHECK-NEXT:    ld.param.b64 %rd5, [global_unordered_volatile_cluster_param_4];
; CHECK-NEXT:    add.s16 %rs4, %rs3, 1;
; CHECK-NEXT:    st.volatile.global.b16 [%rd2], %rs4;
; CHECK-NEXT:    ld.volatile.global.b32 %r1, [%rd3];
; CHECK-NEXT:    add.s32 %r2, %r1, 1;
; CHECK-NEXT:    st.volatile.global.b32 [%rd3], %r2;
; CHECK-NEXT:    ld.volatile.global.b64 %rd6, [%rd4];
; CHECK-NEXT:    add.s64 %rd7, %rd6, 1;
; CHECK-NEXT:    st.volatile.global.b64 [%rd4], %rd7;
; CHECK-NEXT:    ld.volatile.global.b32 %r3, [%rd5];
; CHECK-NEXT:    add.rn.f32 %r4, %r3, 0f3F800000;
; CHECK-NEXT:    st.volatile.global.b32 [%rd5], %r4;
; CHECK-NEXT:    ld.volatile.global.b64 %rd8, [%rd5];
; CHECK-NEXT:    add.rn.f64 %rd9, %rd8, 0d3FF0000000000000;
; CHECK-NEXT:    st.volatile.global.b64 [%rd5], %rd9;
; CHECK-NEXT:    ret;
  %a.load = load atomic volatile i8, ptr addrspace(1) %a syncscope("cluster") unordered, align 1
  %a.add = add i8 %a.load, 1
  store atomic volatile i8 %a.add, ptr addrspace(1) %a syncscope("cluster") unordered, align 1

  %b.load = load atomic volatile i16, ptr addrspace(1) %b syncscope("cluster") unordered, align 2
  %b.add = add i16 %b.load, 1
  store atomic volatile i16 %b.add, ptr addrspace(1) %b syncscope("cluster") unordered, align 2

  %c.load = load atomic volatile i32, ptr addrspace(1) %c syncscope("cluster") unordered, align 4
  %c.add = add i32 %c.load, 1
  store atomic volatile i32 %c.add, ptr addrspace(1) %c syncscope("cluster") unordered, align 4

  %d.load = load atomic volatile i64, ptr addrspace(1) %d syncscope("cluster") unordered, align 8
  %d.add = add i64 %d.load, 1
  store atomic volatile i64 %d.add, ptr addrspace(1) %d syncscope("cluster") unordered, align 8

  %e.load = load atomic volatile float, ptr addrspace(1) %e syncscope("cluster") unordered, align 4
  %e.add = fadd float %e.load, 1.
  store atomic volatile float %e.add, ptr addrspace(1) %e syncscope("cluster") unordered, align 4

  %f.load = load atomic volatile double, ptr addrspace(1) %e syncscope("cluster") unordered, align 8
  %f.add = fadd double %f.load, 1.
  store atomic volatile double %f.add, ptr addrspace(1) %e syncscope("cluster") unordered, align 8

  ret void
}

; CHECK-LABEL: global_monotonic_cluster
define void @global_monotonic_cluster(ptr addrspace(1) %a, ptr addrspace(1) %b, ptr addrspace(1) %c, ptr addrspace(1) %d, ptr addrspace(1) %e) local_unnamed_addr {
; CHECK-LABEL: global_monotonic_cluster(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<5>;
; CHECK-NEXT:    .reg .b32 %r<5>;
; CHECK-NEXT:    .reg .b64 %rd<10>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b64 %rd1, [global_monotonic_cluster_param_0];
; CHECK-NEXT:    ld.relaxed.cluster.global.b8 %rs1, [%rd1];
; CHECK-NEXT:    ld.param.b64 %rd2, [global_monotonic_cluster_param_1];
; CHECK-NEXT:    add.s16 %rs2, %rs1, 1;
; CHECK-NEXT:    ld.param.b64 %rd3, [global_monotonic_cluster_param_2];
; CHECK-NEXT:    st.relaxed.cluster.global.b8 [%rd1], %rs2;
; CHECK-NEXT:    ld.param.b64 %rd4, [global_monotonic_cluster_param_3];
; CHECK-NEXT:    ld.relaxed.cluster.global.b16 %rs3, [%rd2];
; CHECK-NEXT:    ld.param.b64 %rd5, [global_monotonic_cluster_param_4];
; CHECK-NEXT:    add.s16 %rs4, %rs3, 1;
; CHECK-NEXT:    st.relaxed.cluster.global.b16 [%rd2], %rs4;
; CHECK-NEXT:    ld.relaxed.cluster.global.b32 %r1, [%rd3];
; CHECK-NEXT:    add.s32 %r2, %r1, 1;
; CHECK-NEXT:    st.relaxed.cluster.global.b32 [%rd3], %r2;
; CHECK-NEXT:    ld.relaxed.cluster.global.b64 %rd6, [%rd4];
; CHECK-NEXT:    add.s64 %rd7, %rd6, 1;
; CHECK-NEXT:    st.relaxed.cluster.global.b64 [%rd4], %rd7;
; CHECK-NEXT:    ld.relaxed.cluster.global.b32 %r3, [%rd5];
; CHECK-NEXT:    add.rn.f32 %r4, %r3, 0f3F800000;
; CHECK-NEXT:    st.relaxed.cluster.global.b32 [%rd5], %r4;
; CHECK-NEXT:    ld.relaxed.cluster.global.b64 %rd8, [%rd5];
; CHECK-NEXT:    add.rn.f64 %rd9, %rd8, 0d3FF0000000000000;
; CHECK-NEXT:    st.relaxed.cluster.global.b64 [%rd5], %rd9;
; CHECK-NEXT:    ret;
  %a.load = load atomic i8, ptr addrspace(1) %a syncscope("cluster") monotonic, align 1
  %a.add = add i8 %a.load, 1
  store atomic i8 %a.add, ptr addrspace(1) %a syncscope("cluster") monotonic, align 1

  %b.load = load atomic i16, ptr addrspace(1) %b syncscope("cluster") monotonic, align 2
  %b.add = add i16 %b.load, 1
  store atomic i16 %b.add, ptr addrspace(1) %b syncscope("cluster") monotonic, align 2

  %c.load = load atomic i32, ptr addrspace(1) %c syncscope("cluster") monotonic, align 4
  %c.add = add i32 %c.load, 1
  store atomic i32 %c.add, ptr addrspace(1) %c syncscope("cluster") monotonic, align 4

  %d.load = load atomic i64, ptr addrspace(1) %d syncscope("cluster") monotonic, align 8
  %d.add = add i64 %d.load, 1
  store atomic i64 %d.add, ptr addrspace(1) %d syncscope("cluster") monotonic, align 8

  %e.load = load atomic float, ptr addrspace(1) %e syncscope("cluster") monotonic, align 4
  %e.add = fadd float %e.load, 1.
  store atomic float %e.add, ptr addrspace(1) %e syncscope("cluster") monotonic, align 4

  %f.load = load atomic double, ptr addrspace(1) %e syncscope("cluster") monotonic, align 8
  %f.add = fadd double %f.load, 1.
  store atomic double %f.add, ptr addrspace(1) %e syncscope("cluster") monotonic, align 8

  ret void
}

; CHECK-LABEL: global_monotonic_volatile_cluster
define void @global_monotonic_volatile_cluster(ptr addrspace(1) %a, ptr addrspace(1) %b, ptr addrspace(1) %c, ptr addrspace(1) %d, ptr addrspace(1) %e) local_unnamed_addr {
; CHECK-LABEL: global_monotonic_volatile_cluster(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<5>;
; CHECK-NEXT:    .reg .b32 %r<5>;
; CHECK-NEXT:    .reg .b64 %rd<10>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b64 %rd1, [global_monotonic_volatile_cluster_param_0];
; CHECK-NEXT:    ld.volatile.global.b8 %rs1, [%rd1];
; CHECK-NEXT:    ld.param.b64 %rd2, [global_monotonic_volatile_cluster_param_1];
; CHECK-NEXT:    add.s16 %rs2, %rs1, 1;
; CHECK-NEXT:    ld.param.b64 %rd3, [global_monotonic_volatile_cluster_param_2];
; CHECK-NEXT:    st.volatile.global.b8 [%rd1], %rs2;
; CHECK-NEXT:    ld.param.b64 %rd4, [global_monotonic_volatile_cluster_param_3];
; CHECK-NEXT:    ld.volatile.global.b16 %rs3, [%rd2];
; CHECK-NEXT:    ld.param.b64 %rd5, [global_monotonic_volatile_cluster_param_4];
; CHECK-NEXT:    add.s16 %rs4, %rs3, 1;
; CHECK-NEXT:    st.volatile.global.b16 [%rd2], %rs4;
; CHECK-NEXT:    ld.volatile.global.b32 %r1, [%rd3];
; CHECK-NEXT:    add.s32 %r2, %r1, 1;
; CHECK-NEXT:    st.volatile.global.b32 [%rd3], %r2;
; CHECK-NEXT:    ld.volatile.global.b64 %rd6, [%rd4];
; CHECK-NEXT:    add.s64 %rd7, %rd6, 1;
; CHECK-NEXT:    st.volatile.global.b64 [%rd4], %rd7;
; CHECK-NEXT:    ld.volatile.global.b32 %r3, [%rd5];
; CHECK-NEXT:    add.rn.f32 %r4, %r3, 0f3F800000;
; CHECK-NEXT:    st.volatile.global.b32 [%rd5], %r4;
; CHECK-NEXT:    ld.volatile.global.b64 %rd8, [%rd5];
; CHECK-NEXT:    add.rn.f64 %rd9, %rd8, 0d3FF0000000000000;
; CHECK-NEXT:    st.volatile.global.b64 [%rd5], %rd9;
; CHECK-NEXT:    ret;
  %a.load = load atomic volatile i8, ptr addrspace(1) %a syncscope("cluster") monotonic, align 1
  %a.add = add i8 %a.load, 1
  store atomic volatile i8 %a.add, ptr addrspace(1) %a syncscope("cluster") monotonic, align 1

  %b.load = load atomic volatile i16, ptr addrspace(1) %b syncscope("cluster") monotonic, align 2
  %b.add = add i16 %b.load, 1
  store atomic volatile i16 %b.add, ptr addrspace(1) %b syncscope("cluster") monotonic, align 2

  %c.load = load atomic volatile i32, ptr addrspace(1) %c syncscope("cluster") monotonic, align 4
  %c.add = add i32 %c.load, 1
  store atomic volatile i32 %c.add, ptr addrspace(1) %c syncscope("cluster") monotonic, align 4

  %d.load = load atomic volatile i64, ptr addrspace(1) %d syncscope("cluster") monotonic, align 8
  %d.add = add i64 %d.load, 1
  store atomic volatile i64 %d.add, ptr addrspace(1) %d syncscope("cluster") monotonic, align 8

  %e.load = load atomic volatile float, ptr addrspace(1) %e syncscope("cluster") monotonic, align 4
  %e.add = fadd float %e.load, 1.
  store atomic volatile float %e.add, ptr addrspace(1) %e syncscope("cluster") monotonic, align 4

  %f.load = load atomic volatile double, ptr addrspace(1) %e syncscope("cluster") monotonic, align 8
  %f.add = fadd double %f.load, 1.
  store atomic volatile double %f.add, ptr addrspace(1) %e syncscope("cluster") monotonic, align 8

  ret void
}

; CHECK-LABEL: global_acq_rel_cluster
define void @global_acq_rel_cluster(ptr addrspace(1) %a, ptr addrspace(1) %b, ptr addrspace(1) %c, ptr addrspace(1) %d, ptr addrspace(1) %e) local_unnamed_addr {
; CHECK-LABEL: global_acq_rel_cluster(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<5>;
; CHECK-NEXT:    .reg .b32 %r<5>;
; CHECK-NEXT:    .reg .b64 %rd<10>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b64 %rd1, [global_acq_rel_cluster_param_0];
; CHECK-NEXT:    ld.acquire.cluster.global.b8 %rs1, [%rd1];
; CHECK-NEXT:    ld.param.b64 %rd2, [global_acq_rel_cluster_param_1];
; CHECK-NEXT:    add.s16 %rs2, %rs1, 1;
; CHECK-NEXT:    ld.param.b64 %rd3, [global_acq_rel_cluster_param_2];
; CHECK-NEXT:    st.release.cluster.global.b8 [%rd1], %rs2;
; CHECK-NEXT:    ld.param.b64 %rd4, [global_acq_rel_cluster_param_3];
; CHECK-NEXT:    ld.acquire.cluster.global.b16 %rs3, [%rd2];
; CHECK-NEXT:    ld.param.b64 %rd5, [global_acq_rel_cluster_param_4];
; CHECK-NEXT:    add.s16 %rs4, %rs3, 1;
; CHECK-NEXT:    st.release.cluster.global.b16 [%rd2], %rs4;
; CHECK-NEXT:    ld.acquire.cluster.global.b32 %r1, [%rd3];
; CHECK-NEXT:    add.s32 %r2, %r1, 1;
; CHECK-NEXT:    st.release.cluster.global.b32 [%rd3], %r2;
; CHECK-NEXT:    ld.acquire.cluster.global.b64 %rd6, [%rd4];
; CHECK-NEXT:    add.s64 %rd7, %rd6, 1;
; CHECK-NEXT:    st.release.cluster.global.b64 [%rd4], %rd7;
; CHECK-NEXT:    ld.acquire.cluster.global.b32 %r3, [%rd5];
; CHECK-NEXT:    add.rn.f32 %r4, %r3, 0f3F800000;
; CHECK-NEXT:    st.release.cluster.global.b32 [%rd5], %r4;
; CHECK-NEXT:    ld.acquire.cluster.global.b64 %rd8, [%rd5];
; CHECK-NEXT:    add.rn.f64 %rd9, %rd8, 0d3FF0000000000000;
; CHECK-NEXT:    st.release.cluster.global.b64 [%rd5], %rd9;
; CHECK-NEXT:    ret;
  %a.load = load atomic i8, ptr addrspace(1) %a syncscope("cluster") acquire, align 1
  %a.add = add i8 %a.load, 1
  store atomic i8 %a.add, ptr addrspace(1) %a syncscope("cluster") release, align 1

  %b.load = load atomic i16, ptr addrspace(1) %b syncscope("cluster") acquire, align 2
  %b.add = add i16 %b.load, 1
  store atomic i16 %b.add, ptr addrspace(1) %b syncscope("cluster") release, align 2

  %c.load = load atomic i32, ptr addrspace(1) %c syncscope("cluster") acquire, align 4
  %c.add = add i32 %c.load, 1
  store atomic i32 %c.add, ptr addrspace(1) %c syncscope("cluster") release, align 4

  %d.load = load atomic i64, ptr addrspace(1) %d syncscope("cluster") acquire, align 8
  %d.add = add i64 %d.load, 1
  store atomic i64 %d.add, ptr addrspace(1) %d syncscope("cluster") release, align 8

  %e.load = load atomic float, ptr addrspace(1) %e syncscope("cluster") acquire, align 4
  %e.add = fadd float %e.load, 1.
  store atomic float %e.add, ptr addrspace(1) %e syncscope("cluster") release, align 4

  %f.load = load atomic double, ptr addrspace(1) %e syncscope("cluster") acquire, align 8
  %f.add = fadd double %f.load, 1.
  store atomic double %f.add, ptr addrspace(1) %e syncscope("cluster") release, align 8

  ret void
}

; CHECK-LABEL: global_acq_rel_volatile_cluster
define void @global_acq_rel_volatile_cluster(ptr addrspace(1) %a, ptr addrspace(1) %b, ptr addrspace(1) %c, ptr addrspace(1) %d, ptr addrspace(1) %e) local_unnamed_addr {
; CHECK-LABEL: global_acq_rel_volatile_cluster(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<5>;
; CHECK-NEXT:    .reg .b32 %r<5>;
; CHECK-NEXT:    .reg .b64 %rd<10>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b64 %rd1, [global_acq_rel_volatile_cluster_param_0];
; CHECK-NEXT:    ld.acquire.sys.global.b8 %rs1, [%rd1];
; CHECK-NEXT:    ld.param.b64 %rd2, [global_acq_rel_volatile_cluster_param_1];
; CHECK-NEXT:    add.s16 %rs2, %rs1, 1;
; CHECK-NEXT:    ld.param.b64 %rd3, [global_acq_rel_volatile_cluster_param_2];
; CHECK-NEXT:    st.release.sys.global.b8 [%rd1], %rs2;
; CHECK-NEXT:    ld.param.b64 %rd4, [global_acq_rel_volatile_cluster_param_3];
; CHECK-NEXT:    ld.acquire.sys.global.b16 %rs3, [%rd2];
; CHECK-NEXT:    ld.param.b64 %rd5, [global_acq_rel_volatile_cluster_param_4];
; CHECK-NEXT:    add.s16 %rs4, %rs3, 1;
; CHECK-NEXT:    st.release.sys.global.b16 [%rd2], %rs4;
; CHECK-NEXT:    ld.acquire.sys.global.b32 %r1, [%rd3];
; CHECK-NEXT:    add.s32 %r2, %r1, 1;
; CHECK-NEXT:    st.release.sys.global.b32 [%rd3], %r2;
; CHECK-NEXT:    ld.acquire.sys.global.b64 %rd6, [%rd4];
; CHECK-NEXT:    add.s64 %rd7, %rd6, 1;
; CHECK-NEXT:    st.release.sys.global.b64 [%rd4], %rd7;
; CHECK-NEXT:    ld.acquire.sys.global.b32 %r3, [%rd5];
; CHECK-NEXT:    add.rn.f32 %r4, %r3, 0f3F800000;
; CHECK-NEXT:    st.release.sys.global.b32 [%rd5], %r4;
; CHECK-NEXT:    ld.acquire.sys.global.b64 %rd8, [%rd5];
; CHECK-NEXT:    add.rn.f64 %rd9, %rd8, 0d3FF0000000000000;
; CHECK-NEXT:    st.release.sys.global.b64 [%rd5], %rd9;
; CHECK-NEXT:    ret;
  %a.load = load atomic volatile i8, ptr addrspace(1) %a syncscope("cluster") acquire, align 1
  %a.add = add i8 %a.load, 1
  store atomic volatile i8 %a.add, ptr addrspace(1) %a syncscope("cluster") release, align 1

  %b.load = load atomic volatile i16, ptr addrspace(1) %b syncscope("cluster") acquire, align 2
  %b.add = add i16 %b.load, 1
  store atomic volatile i16 %b.add, ptr addrspace(1) %b syncscope("cluster") release, align 2

  %c.load = load atomic volatile i32, ptr addrspace(1) %c syncscope("cluster") acquire, align 4
  %c.add = add i32 %c.load, 1
  store atomic volatile i32 %c.add, ptr addrspace(1) %c syncscope("cluster") release, align 4

  %d.load = load atomic volatile i64, ptr addrspace(1) %d syncscope("cluster") acquire, align 8
  %d.add = add i64 %d.load, 1
  store atomic volatile i64 %d.add, ptr addrspace(1) %d syncscope("cluster") release, align 8

  %e.load = load atomic volatile float, ptr addrspace(1) %e syncscope("cluster") acquire, align 4
  %e.add = fadd float %e.load, 1.
  store atomic volatile float %e.add, ptr addrspace(1) %e syncscope("cluster") release, align 4

  %f.load = load atomic volatile double, ptr addrspace(1) %e syncscope("cluster") acquire, align 8
  %f.add = fadd double %f.load, 1.
  store atomic volatile double %f.add, ptr addrspace(1) %e syncscope("cluster") release, align 8

  ret void
}

; CHECK-LABEL: global_seq_cst_cluster
define void @global_seq_cst_cluster(ptr addrspace(1) %a, ptr addrspace(1) %b, ptr addrspace(1) %c, ptr addrspace(1) %d, ptr addrspace(1) %e) local_unnamed_addr {
; CHECK-LABEL: global_seq_cst_cluster(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<5>;
; CHECK-NEXT:    .reg .b32 %r<5>;
; CHECK-NEXT:    .reg .b64 %rd<10>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b64 %rd1, [global_seq_cst_cluster_param_0];
; CHECK-NEXT:    fence.sc.cluster;
; CHECK-NEXT:    ld.acquire.cluster.global.b8 %rs1, [%rd1];
; CHECK-NEXT:    ld.param.b64 %rd2, [global_seq_cst_cluster_param_1];
; CHECK-NEXT:    add.s16 %rs2, %rs1, 1;
; CHECK-NEXT:    ld.param.b64 %rd3, [global_seq_cst_cluster_param_2];
; CHECK-NEXT:    fence.sc.cluster;
; CHECK-NEXT:    st.release.cluster.global.b8 [%rd1], %rs2;
; CHECK-NEXT:    ld.param.b64 %rd4, [global_seq_cst_cluster_param_3];
; CHECK-NEXT:    fence.sc.cluster;
; CHECK-NEXT:    ld.acquire.cluster.global.b16 %rs3, [%rd2];
; CHECK-NEXT:    ld.param.b64 %rd5, [global_seq_cst_cluster_param_4];
; CHECK-NEXT:    add.s16 %rs4, %rs3, 1;
; CHECK-NEXT:    fence.sc.cluster;
; CHECK-NEXT:    st.release.cluster.global.b16 [%rd2], %rs4;
; CHECK-NEXT:    fence.sc.cluster;
; CHECK-NEXT:    ld.acquire.cluster.global.b32 %r1, [%rd3];
; CHECK-NEXT:    add.s32 %r2, %r1, 1;
; CHECK-NEXT:    fence.sc.cluster;
; CHECK-NEXT:    st.release.cluster.global.b32 [%rd3], %r2;
; CHECK-NEXT:    fence.sc.cluster;
; CHECK-NEXT:    ld.acquire.cluster.global.b64 %rd6, [%rd4];
; CHECK-NEXT:    add.s64 %rd7, %rd6, 1;
; CHECK-NEXT:    fence.sc.cluster;
; CHECK-NEXT:    st.release.cluster.global.b64 [%rd4], %rd7;
; CHECK-NEXT:    fence.sc.cluster;
; CHECK-NEXT:    ld.acquire.cluster.global.b32 %r3, [%rd5];
; CHECK-NEXT:    add.rn.f32 %r4, %r3, 0f3F800000;
; CHECK-NEXT:    fence.sc.cluster;
; CHECK-NEXT:    st.release.cluster.global.b32 [%rd5], %r4;
; CHECK-NEXT:    fence.sc.cluster;
; CHECK-NEXT:    ld.acquire.cluster.global.b64 %rd8, [%rd5];
; CHECK-NEXT:    add.rn.f64 %rd9, %rd8, 0d3FF0000000000000;
; CHECK-NEXT:    fence.sc.cluster;
; CHECK-NEXT:    st.release.cluster.global.b64 [%rd5], %rd9;
; CHECK-NEXT:    ret;
  %a.load = load atomic i8, ptr addrspace(1) %a syncscope("cluster") seq_cst, align 1
  %a.add = add i8 %a.load, 1
  store atomic i8 %a.add, ptr addrspace(1) %a syncscope("cluster") seq_cst, align 1

  %b.load = load atomic i16, ptr addrspace(1) %b syncscope("cluster") seq_cst, align 2
  %b.add = add i16 %b.load, 1
  store atomic i16 %b.add, ptr addrspace(1) %b syncscope("cluster") seq_cst, align 2

  %c.load = load atomic i32, ptr addrspace(1) %c syncscope("cluster") seq_cst, align 4
  %c.add = add i32 %c.load, 1
  store atomic i32 %c.add, ptr addrspace(1) %c syncscope("cluster") seq_cst, align 4

  %d.load = load atomic i64, ptr addrspace(1) %d syncscope("cluster") seq_cst, align 8
  %d.add = add i64 %d.load, 1
  store atomic i64 %d.add, ptr addrspace(1) %d syncscope("cluster") seq_cst, align 8

  %e.load = load atomic float, ptr addrspace(1) %e syncscope("cluster") seq_cst, align 4
  %e.add = fadd float %e.load, 1.
  store atomic float %e.add, ptr addrspace(1) %e syncscope("cluster") seq_cst, align 4

  %f.load = load atomic double, ptr addrspace(1) %e syncscope("cluster") seq_cst, align 8
  %f.add = fadd double %f.load, 1.
  store atomic double %f.add, ptr addrspace(1) %e syncscope("cluster") seq_cst, align 8

  ret void
}

; CHECK-LABEL: global_seq_cst_volatile_cluster
define void @global_seq_cst_volatile_cluster(ptr addrspace(1) %a, ptr addrspace(1) %b, ptr addrspace(1) %c, ptr addrspace(1) %d, ptr addrspace(1) %e) local_unnamed_addr {
; CHECK-LABEL: global_seq_cst_volatile_cluster(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<5>;
; CHECK-NEXT:    .reg .b32 %r<5>;
; CHECK-NEXT:    .reg .b64 %rd<10>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b64 %rd1, [global_seq_cst_volatile_cluster_param_0];
; CHECK-NEXT:    fence.sc.sys;
; CHECK-NEXT:    ld.acquire.sys.global.b8 %rs1, [%rd1];
; CHECK-NEXT:    ld.param.b64 %rd2, [global_seq_cst_volatile_cluster_param_1];
; CHECK-NEXT:    add.s16 %rs2, %rs1, 1;
; CHECK-NEXT:    ld.param.b64 %rd3, [global_seq_cst_volatile_cluster_param_2];
; CHECK-NEXT:    fence.sc.sys;
; CHECK-NEXT:    st.release.sys.global.b8 [%rd1], %rs2;
; CHECK-NEXT:    ld.param.b64 %rd4, [global_seq_cst_volatile_cluster_param_3];
; CHECK-NEXT:    fence.sc.sys;
; CHECK-NEXT:    ld.acquire.sys.global.b16 %rs3, [%rd2];
; CHECK-NEXT:    ld.param.b64 %rd5, [global_seq_cst_volatile_cluster_param_4];
; CHECK-NEXT:    add.s16 %rs4, %rs3, 1;
; CHECK-NEXT:    fence.sc.sys;
; CHECK-NEXT:    st.release.sys.global.b16 [%rd2], %rs4;
; CHECK-NEXT:    fence.sc.sys;
; CHECK-NEXT:    ld.acquire.sys.global.b32 %r1, [%rd3];
; CHECK-NEXT:    add.s32 %r2, %r1, 1;
; CHECK-NEXT:    fence.sc.sys;
; CHECK-NEXT:    st.release.sys.global.b32 [%rd3], %r2;
; CHECK-NEXT:    fence.sc.sys;
; CHECK-NEXT:    ld.acquire.sys.global.b64 %rd6, [%rd4];
; CHECK-NEXT:    add.s64 %rd7, %rd6, 1;
; CHECK-NEXT:    fence.sc.sys;
; CHECK-NEXT:    st.release.sys.global.b64 [%rd4], %rd7;
; CHECK-NEXT:    fence.sc.sys;
; CHECK-NEXT:    ld.acquire.sys.global.b32 %r3, [%rd5];
; CHECK-NEXT:    add.rn.f32 %r4, %r3, 0f3F800000;
; CHECK-NEXT:    fence.sc.sys;
; CHECK-NEXT:    st.release.sys.global.b32 [%rd5], %r4;
; CHECK-NEXT:    fence.sc.sys;
; CHECK-NEXT:    ld.acquire.sys.global.b64 %rd8, [%rd5];
; CHECK-NEXT:    add.rn.f64 %rd9, %rd8, 0d3FF0000000000000;
; CHECK-NEXT:    fence.sc.sys;
; CHECK-NEXT:    st.release.sys.global.b64 [%rd5], %rd9;
; CHECK-NEXT:    ret;
  %a.load = load atomic volatile i8, ptr addrspace(1) %a syncscope("cluster") seq_cst, align 1
  %a.add = add i8 %a.load, 1
  store atomic volatile i8 %a.add, ptr addrspace(1) %a syncscope("cluster") seq_cst, align 1

  %b.load = load atomic volatile i16, ptr addrspace(1) %b syncscope("cluster") seq_cst, align 2
  %b.add = add i16 %b.load, 1
  store atomic volatile i16 %b.add, ptr addrspace(1) %b syncscope("cluster") seq_cst, align 2

  %c.load = load atomic volatile i32, ptr addrspace(1) %c syncscope("cluster") seq_cst, align 4
  %c.add = add i32 %c.load, 1
  store atomic volatile i32 %c.add, ptr addrspace(1) %c syncscope("cluster") seq_cst, align 4

  %d.load = load atomic volatile i64, ptr addrspace(1) %d syncscope("cluster") seq_cst, align 8
  %d.add = add i64 %d.load, 1
  store atomic volatile i64 %d.add, ptr addrspace(1) %d syncscope("cluster") seq_cst, align 8

  %e.load = load atomic volatile float, ptr addrspace(1) %e syncscope("cluster") seq_cst, align 4
  %e.add = fadd float %e.load, 1.
  store atomic volatile float %e.add, ptr addrspace(1) %e syncscope("cluster") seq_cst, align 4

  %f.load = load atomic volatile double, ptr addrspace(1) %e syncscope("cluster") seq_cst, align 8
  %f.add = fadd double %f.load, 1.
  store atomic volatile double %f.add, ptr addrspace(1) %e syncscope("cluster") seq_cst, align 8

  ret void
}

;; shared

; CHECK-LABEL: shared_unordered_cluster
define void @shared_unordered_cluster(ptr addrspace(3) %a, ptr addrspace(3) %b, ptr addrspace(3) %c, ptr addrspace(3) %d, ptr addrspace(3) %e) local_unnamed_addr {
; CHECK-LABEL: shared_unordered_cluster(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<5>;
; CHECK-NEXT:    .reg .b32 %r<5>;
; CHECK-NEXT:    .reg .b64 %rd<10>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b64 %rd1, [shared_unordered_cluster_param_0];
; CHECK-NEXT:    ld.relaxed.cluster.shared.b8 %rs1, [%rd1];
; CHECK-NEXT:    ld.param.b64 %rd2, [shared_unordered_cluster_param_1];
; CHECK-NEXT:    add.s16 %rs2, %rs1, 1;
; CHECK-NEXT:    ld.param.b64 %rd3, [shared_unordered_cluster_param_2];
; CHECK-NEXT:    st.relaxed.cluster.shared.b8 [%rd1], %rs2;
; CHECK-NEXT:    ld.param.b64 %rd4, [shared_unordered_cluster_param_3];
; CHECK-NEXT:    ld.relaxed.cluster.shared.b16 %rs3, [%rd2];
; CHECK-NEXT:    ld.param.b64 %rd5, [shared_unordered_cluster_param_4];
; CHECK-NEXT:    add.s16 %rs4, %rs3, 1;
; CHECK-NEXT:    st.relaxed.cluster.shared.b16 [%rd2], %rs4;
; CHECK-NEXT:    ld.relaxed.cluster.shared.b32 %r1, [%rd3];
; CHECK-NEXT:    add.s32 %r2, %r1, 1;
; CHECK-NEXT:    st.relaxed.cluster.shared.b32 [%rd3], %r2;
; CHECK-NEXT:    ld.relaxed.cluster.shared.b64 %rd6, [%rd4];
; CHECK-NEXT:    add.s64 %rd7, %rd6, 1;
; CHECK-NEXT:    st.relaxed.cluster.shared.b64 [%rd4], %rd7;
; CHECK-NEXT:    ld.relaxed.cluster.shared.b32 %r3, [%rd5];
; CHECK-NEXT:    add.rn.f32 %r4, %r3, 0f3F800000;
; CHECK-NEXT:    st.relaxed.cluster.shared.b32 [%rd5], %r4;
; CHECK-NEXT:    ld.relaxed.cluster.shared.b64 %rd8, [%rd5];
; CHECK-NEXT:    add.rn.f64 %rd9, %rd8, 0d3FF0000000000000;
; CHECK-NEXT:    st.relaxed.cluster.shared.b64 [%rd5], %rd9;
; CHECK-NEXT:    ret;
  %a.load = load atomic i8, ptr addrspace(3) %a syncscope("cluster") unordered, align 1
  %a.add = add i8 %a.load, 1
  store atomic i8 %a.add, ptr addrspace(3) %a syncscope("cluster") unordered, align 1

  %b.load = load atomic i16, ptr addrspace(3) %b syncscope("cluster") unordered, align 2
  %b.add = add i16 %b.load, 1
  store atomic i16 %b.add, ptr addrspace(3) %b syncscope("cluster") unordered, align 2

  %c.load = load atomic i32, ptr addrspace(3) %c syncscope("cluster") unordered, align 4
  %c.add = add i32 %c.load, 1
  store atomic i32 %c.add, ptr addrspace(3) %c syncscope("cluster") unordered, align 4

  %d.load = load atomic i64, ptr addrspace(3) %d syncscope("cluster") unordered, align 8
  %d.add = add i64 %d.load, 1
  store atomic i64 %d.add, ptr addrspace(3) %d syncscope("cluster") unordered, align 8

  %e.load = load atomic float, ptr addrspace(3) %e syncscope("cluster") unordered, align 4
  %e.add = fadd float %e.load, 1.
  store atomic float %e.add, ptr addrspace(3) %e syncscope("cluster") unordered, align 4

  %f.load = load atomic double, ptr addrspace(3) %e syncscope("cluster") unordered, align 8
  %f.add = fadd double %f.load, 1.
  store atomic double %f.add, ptr addrspace(3) %e syncscope("cluster") unordered, align 8

  ret void
}

; CHECK-LABEL: shared_unordered_volatile_cluster
define void @shared_unordered_volatile_cluster(ptr addrspace(3) %a, ptr addrspace(3) %b, ptr addrspace(3) %c, ptr addrspace(3) %d, ptr addrspace(3) %e) local_unnamed_addr {
; CHECK-LABEL: shared_unordered_volatile_cluster(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<5>;
; CHECK-NEXT:    .reg .b32 %r<5>;
; CHECK-NEXT:    .reg .b64 %rd<10>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b64 %rd1, [shared_unordered_volatile_cluster_param_0];
; CHECK-NEXT:    ld.volatile.shared.b8 %rs1, [%rd1];
; CHECK-NEXT:    ld.param.b64 %rd2, [shared_unordered_volatile_cluster_param_1];
; CHECK-NEXT:    add.s16 %rs2, %rs1, 1;
; CHECK-NEXT:    ld.param.b64 %rd3, [shared_unordered_volatile_cluster_param_2];
; CHECK-NEXT:    st.volatile.shared.b8 [%rd1], %rs2;
; CHECK-NEXT:    ld.param.b64 %rd4, [shared_unordered_volatile_cluster_param_3];
; CHECK-NEXT:    ld.volatile.shared.b16 %rs3, [%rd2];
; CHECK-NEXT:    ld.param.b64 %rd5, [shared_unordered_volatile_cluster_param_4];
; CHECK-NEXT:    add.s16 %rs4, %rs3, 1;
; CHECK-NEXT:    st.volatile.shared.b16 [%rd2], %rs4;
; CHECK-NEXT:    ld.volatile.shared.b32 %r1, [%rd3];
; CHECK-NEXT:    add.s32 %r2, %r1, 1;
; CHECK-NEXT:    st.volatile.shared.b32 [%rd3], %r2;
; CHECK-NEXT:    ld.volatile.shared.b64 %rd6, [%rd4];
; CHECK-NEXT:    add.s64 %rd7, %rd6, 1;
; CHECK-NEXT:    st.volatile.shared.b64 [%rd4], %rd7;
; CHECK-NEXT:    ld.volatile.shared.b32 %r3, [%rd5];
; CHECK-NEXT:    add.rn.f32 %r4, %r3, 0f3F800000;
; CHECK-NEXT:    st.volatile.shared.b32 [%rd5], %r4;
; CHECK-NEXT:    ld.volatile.shared.b64 %rd8, [%rd5];
; CHECK-NEXT:    add.rn.f64 %rd9, %rd8, 0d3FF0000000000000;
; CHECK-NEXT:    st.volatile.shared.b64 [%rd5], %rd9;
; CHECK-NEXT:    ret;
  %a.load = load atomic volatile i8, ptr addrspace(3) %a syncscope("cluster") unordered, align 1
  %a.add = add i8 %a.load, 1
  store atomic volatile i8 %a.add, ptr addrspace(3) %a syncscope("cluster") unordered, align 1

  %b.load = load atomic volatile i16, ptr addrspace(3) %b syncscope("cluster") unordered, align 2
  %b.add = add i16 %b.load, 1
  store atomic volatile i16 %b.add, ptr addrspace(3) %b syncscope("cluster") unordered, align 2

  %c.load = load atomic volatile i32, ptr addrspace(3) %c syncscope("cluster") unordered, align 4
  %c.add = add i32 %c.load, 1
  store atomic volatile i32 %c.add, ptr addrspace(3) %c syncscope("cluster") unordered, align 4

  %d.load = load atomic volatile i64, ptr addrspace(3) %d syncscope("cluster") unordered, align 8
  %d.add = add i64 %d.load, 1
  store atomic volatile i64 %d.add, ptr addrspace(3) %d syncscope("cluster") unordered, align 8

  %e.load = load atomic volatile float, ptr addrspace(3) %e syncscope("cluster") unordered, align 4
  %e.add = fadd float %e.load, 1.
  store atomic volatile float %e.add, ptr addrspace(3) %e syncscope("cluster") unordered, align 4

  %f.load = load atomic volatile double, ptr addrspace(3) %e syncscope("cluster") unordered, align 8
  %f.add = fadd double %f.load, 1.
  store atomic volatile double %f.add, ptr addrspace(3) %e syncscope("cluster") unordered, align 8

  ret void
}

; CHECK-LABEL: shared_monotonic_cluster
define void @shared_monotonic_cluster(ptr addrspace(3) %a, ptr addrspace(3) %b, ptr addrspace(3) %c, ptr addrspace(3) %d, ptr addrspace(3) %e) local_unnamed_addr {
; CHECK-LABEL: shared_monotonic_cluster(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<5>;
; CHECK-NEXT:    .reg .b32 %r<5>;
; CHECK-NEXT:    .reg .b64 %rd<10>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b64 %rd1, [shared_monotonic_cluster_param_0];
; CHECK-NEXT:    ld.relaxed.cluster.shared.b8 %rs1, [%rd1];
; CHECK-NEXT:    ld.param.b64 %rd2, [shared_monotonic_cluster_param_1];
; CHECK-NEXT:    add.s16 %rs2, %rs1, 1;
; CHECK-NEXT:    ld.param.b64 %rd3, [shared_monotonic_cluster_param_2];
; CHECK-NEXT:    st.relaxed.cluster.shared.b8 [%rd1], %rs2;
; CHECK-NEXT:    ld.param.b64 %rd4, [shared_monotonic_cluster_param_3];
; CHECK-NEXT:    ld.relaxed.cluster.shared.b16 %rs3, [%rd2];
; CHECK-NEXT:    ld.param.b64 %rd5, [shared_monotonic_cluster_param_4];
; CHECK-NEXT:    add.s16 %rs4, %rs3, 1;
; CHECK-NEXT:    st.relaxed.cluster.shared.b16 [%rd2], %rs4;
; CHECK-NEXT:    ld.relaxed.cluster.shared.b32 %r1, [%rd3];
; CHECK-NEXT:    add.s32 %r2, %r1, 1;
; CHECK-NEXT:    st.relaxed.cluster.shared.b32 [%rd3], %r2;
; CHECK-NEXT:    ld.relaxed.cluster.shared.b64 %rd6, [%rd4];
; CHECK-NEXT:    add.s64 %rd7, %rd6, 1;
; CHECK-NEXT:    st.relaxed.cluster.shared.b64 [%rd4], %rd7;
; CHECK-NEXT:    ld.relaxed.cluster.shared.b32 %r3, [%rd5];
; CHECK-NEXT:    add.rn.f32 %r4, %r3, 0f3F800000;
; CHECK-NEXT:    st.relaxed.cluster.shared.b32 [%rd5], %r4;
; CHECK-NEXT:    ld.relaxed.cluster.shared.b64 %rd8, [%rd5];
; CHECK-NEXT:    add.rn.f64 %rd9, %rd8, 0d3FF0000000000000;
; CHECK-NEXT:    st.relaxed.cluster.shared.b64 [%rd5], %rd9;
; CHECK-NEXT:    ret;
  %a.load = load atomic i8, ptr addrspace(3) %a syncscope("cluster") monotonic, align 1
  %a.add = add i8 %a.load, 1
  store atomic i8 %a.add, ptr addrspace(3) %a syncscope("cluster") monotonic, align 1

  %b.load = load atomic i16, ptr addrspace(3) %b syncscope("cluster") monotonic, align 2
  %b.add = add i16 %b.load, 1
  store atomic i16 %b.add, ptr addrspace(3) %b syncscope("cluster") monotonic, align 2

  %c.load = load atomic i32, ptr addrspace(3) %c syncscope("cluster") monotonic, align 4
  %c.add = add i32 %c.load, 1
  store atomic i32 %c.add, ptr addrspace(3) %c syncscope("cluster") monotonic, align 4

  %d.load = load atomic i64, ptr addrspace(3) %d syncscope("cluster") monotonic, align 8
  %d.add = add i64 %d.load, 1
  store atomic i64 %d.add, ptr addrspace(3) %d syncscope("cluster") monotonic, align 8

  %e.load = load atomic float, ptr addrspace(3) %e syncscope("cluster") monotonic, align 4
  %e.add = fadd float %e.load, 1.
  store atomic float %e.add, ptr addrspace(3) %e syncscope("cluster") monotonic, align 4

  %f.load = load atomic double, ptr addrspace(3) %e syncscope("cluster") monotonic, align 8
  %f.add = fadd double %f.load, 1.
  store atomic double %f.add, ptr addrspace(3) %e syncscope("cluster") monotonic, align 8

  ret void
}

; CHECK-LABEL: shared_monotonic_volatile_cluster
define void @shared_monotonic_volatile_cluster(ptr addrspace(3) %a, ptr addrspace(3) %b, ptr addrspace(3) %c, ptr addrspace(3) %d, ptr addrspace(3) %e) local_unnamed_addr {
; CHECK-LABEL: shared_monotonic_volatile_cluster(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<5>;
; CHECK-NEXT:    .reg .b32 %r<5>;
; CHECK-NEXT:    .reg .b64 %rd<10>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b64 %rd1, [shared_monotonic_volatile_cluster_param_0];
; CHECK-NEXT:    ld.volatile.shared.b8 %rs1, [%rd1];
; CHECK-NEXT:    ld.param.b64 %rd2, [shared_monotonic_volatile_cluster_param_1];
; CHECK-NEXT:    add.s16 %rs2, %rs1, 1;
; CHECK-NEXT:    ld.param.b64 %rd3, [shared_monotonic_volatile_cluster_param_2];
; CHECK-NEXT:    st.volatile.shared.b8 [%rd1], %rs2;
; CHECK-NEXT:    ld.param.b64 %rd4, [shared_monotonic_volatile_cluster_param_3];
; CHECK-NEXT:    ld.volatile.shared.b16 %rs3, [%rd2];
; CHECK-NEXT:    ld.param.b64 %rd5, [shared_monotonic_volatile_cluster_param_4];
; CHECK-NEXT:    add.s16 %rs4, %rs3, 1;
; CHECK-NEXT:    st.volatile.shared.b16 [%rd2], %rs4;
; CHECK-NEXT:    ld.volatile.shared.b32 %r1, [%rd3];
; CHECK-NEXT:    add.s32 %r2, %r1, 1;
; CHECK-NEXT:    st.volatile.shared.b32 [%rd3], %r2;
; CHECK-NEXT:    ld.volatile.shared.b64 %rd6, [%rd4];
; CHECK-NEXT:    add.s64 %rd7, %rd6, 1;
; CHECK-NEXT:    st.volatile.shared.b64 [%rd4], %rd7;
; CHECK-NEXT:    ld.volatile.shared.b32 %r3, [%rd5];
; CHECK-NEXT:    add.rn.f32 %r4, %r3, 0f3F800000;
; CHECK-NEXT:    st.volatile.shared.b32 [%rd5], %r4;
; CHECK-NEXT:    ld.volatile.shared.b64 %rd8, [%rd5];
; CHECK-NEXT:    add.rn.f64 %rd9, %rd8, 0d3FF0000000000000;
; CHECK-NEXT:    st.volatile.shared.b64 [%rd5], %rd9;
; CHECK-NEXT:    ret;
  %a.load = load atomic volatile i8, ptr addrspace(3) %a syncscope("cluster") monotonic, align 1
  %a.add = add i8 %a.load, 1
  store atomic volatile i8 %a.add, ptr addrspace(3) %a syncscope("cluster") monotonic, align 1

  %b.load = load atomic volatile i16, ptr addrspace(3) %b syncscope("cluster") monotonic, align 2
  %b.add = add i16 %b.load, 1
  store atomic volatile i16 %b.add, ptr addrspace(3) %b syncscope("cluster") monotonic, align 2

  %c.load = load atomic volatile i32, ptr addrspace(3) %c syncscope("cluster") monotonic, align 4
  %c.add = add i32 %c.load, 1
  store atomic volatile i32 %c.add, ptr addrspace(3) %c syncscope("cluster") monotonic, align 4

  %d.load = load atomic volatile i64, ptr addrspace(3) %d syncscope("cluster") monotonic, align 8
  %d.add = add i64 %d.load, 1
  store atomic volatile i64 %d.add, ptr addrspace(3) %d syncscope("cluster") monotonic, align 8

  %e.load = load atomic volatile float, ptr addrspace(3) %e syncscope("cluster") monotonic, align 4
  %e.add = fadd float %e.load, 1.
  store atomic volatile float %e.add, ptr addrspace(3) %e syncscope("cluster") monotonic, align 4

  %f.load = load atomic volatile double, ptr addrspace(3) %e syncscope("cluster") monotonic, align 8
  %f.add = fadd double %f.load, 1.
  store atomic volatile double %f.add, ptr addrspace(3) %e syncscope("cluster") monotonic, align 8

  ret void
}

; CHECK-LABEL: shared_acq_rel_cluster
define void @shared_acq_rel_cluster(ptr addrspace(3) %a, ptr addrspace(3) %b, ptr addrspace(3) %c, ptr addrspace(3) %d, ptr addrspace(3) %e) local_unnamed_addr {
; CHECK-LABEL: shared_acq_rel_cluster(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<5>;
; CHECK-NEXT:    .reg .b32 %r<5>;
; CHECK-NEXT:    .reg .b64 %rd<10>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b64 %rd1, [shared_acq_rel_cluster_param_0];
; CHECK-NEXT:    ld.acquire.cluster.shared.b8 %rs1, [%rd1];
; CHECK-NEXT:    ld.param.b64 %rd2, [shared_acq_rel_cluster_param_1];
; CHECK-NEXT:    add.s16 %rs2, %rs1, 1;
; CHECK-NEXT:    ld.param.b64 %rd3, [shared_acq_rel_cluster_param_2];
; CHECK-NEXT:    st.release.cluster.shared.b8 [%rd1], %rs2;
; CHECK-NEXT:    ld.param.b64 %rd4, [shared_acq_rel_cluster_param_3];
; CHECK-NEXT:    ld.acquire.cluster.shared.b16 %rs3, [%rd2];
; CHECK-NEXT:    ld.param.b64 %rd5, [shared_acq_rel_cluster_param_4];
; CHECK-NEXT:    add.s16 %rs4, %rs3, 1;
; CHECK-NEXT:    st.release.cluster.shared.b16 [%rd2], %rs4;
; CHECK-NEXT:    ld.acquire.cluster.shared.b32 %r1, [%rd3];
; CHECK-NEXT:    add.s32 %r2, %r1, 1;
; CHECK-NEXT:    st.release.cluster.shared.b32 [%rd3], %r2;
; CHECK-NEXT:    ld.acquire.cluster.shared.b64 %rd6, [%rd4];
; CHECK-NEXT:    add.s64 %rd7, %rd6, 1;
; CHECK-NEXT:    st.release.cluster.shared.b64 [%rd4], %rd7;
; CHECK-NEXT:    ld.acquire.cluster.shared.b32 %r3, [%rd5];
; CHECK-NEXT:    add.rn.f32 %r4, %r3, 0f3F800000;
; CHECK-NEXT:    st.release.cluster.shared.b32 [%rd5], %r4;
; CHECK-NEXT:    ld.acquire.cluster.shared.b64 %rd8, [%rd5];
; CHECK-NEXT:    add.rn.f64 %rd9, %rd8, 0d3FF0000000000000;
; CHECK-NEXT:    st.release.cluster.shared.b64 [%rd5], %rd9;
; CHECK-NEXT:    ret;
  %a.load = load atomic i8, ptr addrspace(3) %a syncscope("cluster") acquire, align 1
  %a.add = add i8 %a.load, 1
  store atomic i8 %a.add, ptr addrspace(3) %a syncscope("cluster") release, align 1

  %b.load = load atomic i16, ptr addrspace(3) %b syncscope("cluster") acquire, align 2
  %b.add = add i16 %b.load, 1
  store atomic i16 %b.add, ptr addrspace(3) %b syncscope("cluster") release, align 2

  %c.load = load atomic i32, ptr addrspace(3) %c syncscope("cluster") acquire, align 4
  %c.add = add i32 %c.load, 1
  store atomic i32 %c.add, ptr addrspace(3) %c syncscope("cluster") release, align 4

  %d.load = load atomic i64, ptr addrspace(3) %d syncscope("cluster") acquire, align 8
  %d.add = add i64 %d.load, 1
  store atomic i64 %d.add, ptr addrspace(3) %d syncscope("cluster") release, align 8

  %e.load = load atomic float, ptr addrspace(3) %e syncscope("cluster") acquire, align 4
  %e.add = fadd float %e.load, 1.
  store atomic float %e.add, ptr addrspace(3) %e syncscope("cluster") release, align 4

  %f.load = load atomic double, ptr addrspace(3) %e syncscope("cluster") acquire, align 8
  %f.add = fadd double %f.load, 1.
  store atomic double %f.add, ptr addrspace(3) %e syncscope("cluster") release, align 8

  ret void
}

; CHECK-LABEL: shared_acq_rel_volatile_cluster
define void @shared_acq_rel_volatile_cluster(ptr addrspace(3) %a, ptr addrspace(3) %b, ptr addrspace(3) %c, ptr addrspace(3) %d, ptr addrspace(3) %e) local_unnamed_addr {
; CHECK-LABEL: shared_acq_rel_volatile_cluster(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<5>;
; CHECK-NEXT:    .reg .b32 %r<5>;
; CHECK-NEXT:    .reg .b64 %rd<10>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b64 %rd1, [shared_acq_rel_volatile_cluster_param_0];
; CHECK-NEXT:    ld.acquire.sys.shared.b8 %rs1, [%rd1];
; CHECK-NEXT:    ld.param.b64 %rd2, [shared_acq_rel_volatile_cluster_param_1];
; CHECK-NEXT:    add.s16 %rs2, %rs1, 1;
; CHECK-NEXT:    ld.param.b64 %rd3, [shared_acq_rel_volatile_cluster_param_2];
; CHECK-NEXT:    st.release.sys.shared.b8 [%rd1], %rs2;
; CHECK-NEXT:    ld.param.b64 %rd4, [shared_acq_rel_volatile_cluster_param_3];
; CHECK-NEXT:    ld.acquire.sys.shared.b16 %rs3, [%rd2];
; CHECK-NEXT:    ld.param.b64 %rd5, [shared_acq_rel_volatile_cluster_param_4];
; CHECK-NEXT:    add.s16 %rs4, %rs3, 1;
; CHECK-NEXT:    st.release.sys.shared.b16 [%rd2], %rs4;
; CHECK-NEXT:    ld.acquire.sys.shared.b32 %r1, [%rd3];
; CHECK-NEXT:    add.s32 %r2, %r1, 1;
; CHECK-NEXT:    st.release.sys.shared.b32 [%rd3], %r2;
; CHECK-NEXT:    ld.acquire.sys.shared.b64 %rd6, [%rd4];
; CHECK-NEXT:    add.s64 %rd7, %rd6, 1;
; CHECK-NEXT:    st.release.sys.shared.b64 [%rd4], %rd7;
; CHECK-NEXT:    ld.acquire.sys.shared.b32 %r3, [%rd5];
; CHECK-NEXT:    add.rn.f32 %r4, %r3, 0f3F800000;
; CHECK-NEXT:    st.release.sys.shared.b32 [%rd5], %r4;
; CHECK-NEXT:    ld.acquire.sys.shared.b64 %rd8, [%rd5];
; CHECK-NEXT:    add.rn.f64 %rd9, %rd8, 0d3FF0000000000000;
; CHECK-NEXT:    st.release.sys.shared.b64 [%rd5], %rd9;
; CHECK-NEXT:    ret;
  %a.load = load atomic volatile i8, ptr addrspace(3) %a syncscope("cluster") acquire, align 1
  %a.add = add i8 %a.load, 1
  store atomic volatile i8 %a.add, ptr addrspace(3) %a syncscope("cluster") release, align 1

  %b.load = load atomic volatile i16, ptr addrspace(3) %b syncscope("cluster") acquire, align 2
  %b.add = add i16 %b.load, 1
  store atomic volatile i16 %b.add, ptr addrspace(3) %b syncscope("cluster") release, align 2

  %c.load = load atomic volatile i32, ptr addrspace(3) %c syncscope("cluster") acquire, align 4
  %c.add = add i32 %c.load, 1
  store atomic volatile i32 %c.add, ptr addrspace(3) %c syncscope("cluster") release, align 4

  %d.load = load atomic volatile i64, ptr addrspace(3) %d syncscope("cluster") acquire, align 8
  %d.add = add i64 %d.load, 1
  store atomic volatile i64 %d.add, ptr addrspace(3) %d syncscope("cluster") release, align 8

  %e.load = load atomic volatile float, ptr addrspace(3) %e syncscope("cluster") acquire, align 4
  %e.add = fadd float %e.load, 1.
  store atomic volatile float %e.add, ptr addrspace(3) %e syncscope("cluster") release, align 4

  %f.load = load atomic volatile double, ptr addrspace(3) %e syncscope("cluster") acquire, align 8
  %f.add = fadd double %f.load, 1.
  store atomic volatile double %f.add, ptr addrspace(3) %e syncscope("cluster") release, align 8

  ret void
}

; CHECK-LABEL: shared_seq_cst_cluster
define void @shared_seq_cst_cluster(ptr addrspace(3) %a, ptr addrspace(3) %b, ptr addrspace(3) %c, ptr addrspace(3) %d, ptr addrspace(3) %e) local_unnamed_addr {
; CHECK-LABEL: shared_seq_cst_cluster(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<5>;
; CHECK-NEXT:    .reg .b32 %r<5>;
; CHECK-NEXT:    .reg .b64 %rd<10>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b64 %rd1, [shared_seq_cst_cluster_param_0];
; CHECK-NEXT:    fence.sc.cluster;
; CHECK-NEXT:    ld.acquire.cluster.shared.b8 %rs1, [%rd1];
; CHECK-NEXT:    ld.param.b64 %rd2, [shared_seq_cst_cluster_param_1];
; CHECK-NEXT:    add.s16 %rs2, %rs1, 1;
; CHECK-NEXT:    ld.param.b64 %rd3, [shared_seq_cst_cluster_param_2];
; CHECK-NEXT:    fence.sc.cluster;
; CHECK-NEXT:    st.release.cluster.shared.b8 [%rd1], %rs2;
; CHECK-NEXT:    ld.param.b64 %rd4, [shared_seq_cst_cluster_param_3];
; CHECK-NEXT:    fence.sc.cluster;
; CHECK-NEXT:    ld.acquire.cluster.shared.b16 %rs3, [%rd2];
; CHECK-NEXT:    ld.param.b64 %rd5, [shared_seq_cst_cluster_param_4];
; CHECK-NEXT:    add.s16 %rs4, %rs3, 1;
; CHECK-NEXT:    fence.sc.cluster;
; CHECK-NEXT:    st.release.cluster.shared.b16 [%rd2], %rs4;
; CHECK-NEXT:    fence.sc.cluster;
; CHECK-NEXT:    ld.acquire.cluster.shared.b32 %r1, [%rd3];
; CHECK-NEXT:    add.s32 %r2, %r1, 1;
; CHECK-NEXT:    fence.sc.cluster;
; CHECK-NEXT:    st.release.cluster.shared.b32 [%rd3], %r2;
; CHECK-NEXT:    fence.sc.cluster;
; CHECK-NEXT:    ld.acquire.cluster.shared.b64 %rd6, [%rd4];
; CHECK-NEXT:    add.s64 %rd7, %rd6, 1;
; CHECK-NEXT:    fence.sc.cluster;
; CHECK-NEXT:    st.release.cluster.shared.b64 [%rd4], %rd7;
; CHECK-NEXT:    fence.sc.cluster;
; CHECK-NEXT:    ld.acquire.cluster.shared.b32 %r3, [%rd5];
; CHECK-NEXT:    add.rn.f32 %r4, %r3, 0f3F800000;
; CHECK-NEXT:    fence.sc.cluster;
; CHECK-NEXT:    st.release.cluster.shared.b32 [%rd5], %r4;
; CHECK-NEXT:    fence.sc.cluster;
; CHECK-NEXT:    ld.acquire.cluster.shared.b64 %rd8, [%rd5];
; CHECK-NEXT:    add.rn.f64 %rd9, %rd8, 0d3FF0000000000000;
; CHECK-NEXT:    fence.sc.cluster;
; CHECK-NEXT:    st.release.cluster.shared.b64 [%rd5], %rd9;
; CHECK-NEXT:    ret;
  %a.load = load atomic i8, ptr addrspace(3) %a syncscope("cluster") seq_cst, align 1
  %a.add = add i8 %a.load, 1
  store atomic i8 %a.add, ptr addrspace(3) %a syncscope("cluster") seq_cst, align 1

  %b.load = load atomic i16, ptr addrspace(3) %b syncscope("cluster") seq_cst, align 2
  %b.add = add i16 %b.load, 1
  store atomic i16 %b.add, ptr addrspace(3) %b syncscope("cluster") seq_cst, align 2

  %c.load = load atomic i32, ptr addrspace(3) %c syncscope("cluster") seq_cst, align 4
  %c.add = add i32 %c.load, 1
  store atomic i32 %c.add, ptr addrspace(3) %c syncscope("cluster") seq_cst, align 4

  %d.load = load atomic i64, ptr addrspace(3) %d syncscope("cluster") seq_cst, align 8
  %d.add = add i64 %d.load, 1
  store atomic i64 %d.add, ptr addrspace(3) %d syncscope("cluster") seq_cst, align 8

  %e.load = load atomic float, ptr addrspace(3) %e syncscope("cluster") seq_cst, align 4
  %e.add = fadd float %e.load, 1.
  store atomic float %e.add, ptr addrspace(3) %e syncscope("cluster") seq_cst, align 4

  %f.load = load atomic double, ptr addrspace(3) %e syncscope("cluster") seq_cst, align 8
  %f.add = fadd double %f.load, 1.
  store atomic double %f.add, ptr addrspace(3) %e syncscope("cluster") seq_cst, align 8

  ret void
}

; CHECK-LABEL: shared_seq_cst_volatile_cluster
define void @shared_seq_cst_volatile_cluster(ptr addrspace(3) %a, ptr addrspace(3) %b, ptr addrspace(3) %c, ptr addrspace(3) %d, ptr addrspace(3) %e) local_unnamed_addr {
; CHECK-LABEL: shared_seq_cst_volatile_cluster(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<5>;
; CHECK-NEXT:    .reg .b32 %r<5>;
; CHECK-NEXT:    .reg .b64 %rd<10>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b64 %rd1, [shared_seq_cst_volatile_cluster_param_0];
; CHECK-NEXT:    fence.sc.sys;
; CHECK-NEXT:    ld.acquire.sys.shared.b8 %rs1, [%rd1];
; CHECK-NEXT:    ld.param.b64 %rd2, [shared_seq_cst_volatile_cluster_param_1];
; CHECK-NEXT:    add.s16 %rs2, %rs1, 1;
; CHECK-NEXT:    ld.param.b64 %rd3, [shared_seq_cst_volatile_cluster_param_2];
; CHECK-NEXT:    fence.sc.sys;
; CHECK-NEXT:    st.release.sys.shared.b8 [%rd1], %rs2;
; CHECK-NEXT:    ld.param.b64 %rd4, [shared_seq_cst_volatile_cluster_param_3];
; CHECK-NEXT:    fence.sc.sys;
; CHECK-NEXT:    ld.acquire.sys.shared.b16 %rs3, [%rd2];
; CHECK-NEXT:    ld.param.b64 %rd5, [shared_seq_cst_volatile_cluster_param_4];
; CHECK-NEXT:    add.s16 %rs4, %rs3, 1;
; CHECK-NEXT:    fence.sc.sys;
; CHECK-NEXT:    st.release.sys.shared.b16 [%rd2], %rs4;
; CHECK-NEXT:    fence.sc.sys;
; CHECK-NEXT:    ld.acquire.sys.shared.b32 %r1, [%rd3];
; CHECK-NEXT:    add.s32 %r2, %r1, 1;
; CHECK-NEXT:    fence.sc.sys;
; CHECK-NEXT:    st.release.sys.shared.b32 [%rd3], %r2;
; CHECK-NEXT:    fence.sc.sys;
; CHECK-NEXT:    ld.acquire.sys.shared.b64 %rd6, [%rd4];
; CHECK-NEXT:    add.s64 %rd7, %rd6, 1;
; CHECK-NEXT:    fence.sc.sys;
; CHECK-NEXT:    st.release.sys.shared.b64 [%rd4], %rd7;
; CHECK-NEXT:    fence.sc.sys;
; CHECK-NEXT:    ld.acquire.sys.shared.b32 %r3, [%rd5];
; CHECK-NEXT:    add.rn.f32 %r4, %r3, 0f3F800000;
; CHECK-NEXT:    fence.sc.sys;
; CHECK-NEXT:    st.release.sys.shared.b32 [%rd5], %r4;
; CHECK-NEXT:    fence.sc.sys;
; CHECK-NEXT:    ld.acquire.sys.shared.b64 %rd8, [%rd5];
; CHECK-NEXT:    add.rn.f64 %rd9, %rd8, 0d3FF0000000000000;
; CHECK-NEXT:    fence.sc.sys;
; CHECK-NEXT:    st.release.sys.shared.b64 [%rd5], %rd9;
; CHECK-NEXT:    ret;
  %a.load = load atomic volatile i8, ptr addrspace(3) %a syncscope("cluster") seq_cst, align 1
  %a.add = add i8 %a.load, 1
  store atomic volatile i8 %a.add, ptr addrspace(3) %a syncscope("cluster") seq_cst, align 1

  %b.load = load atomic volatile i16, ptr addrspace(3) %b syncscope("cluster") seq_cst, align 2
  %b.add = add i16 %b.load, 1
  store atomic volatile i16 %b.add, ptr addrspace(3) %b syncscope("cluster") seq_cst, align 2

  %c.load = load atomic volatile i32, ptr addrspace(3) %c syncscope("cluster") seq_cst, align 4
  %c.add = add i32 %c.load, 1
  store atomic volatile i32 %c.add, ptr addrspace(3) %c syncscope("cluster") seq_cst, align 4

  %d.load = load atomic volatile i64, ptr addrspace(3) %d syncscope("cluster") seq_cst, align 8
  %d.add = add i64 %d.load, 1
  store atomic volatile i64 %d.add, ptr addrspace(3) %d syncscope("cluster") seq_cst, align 8

  %e.load = load atomic volatile float, ptr addrspace(3) %e syncscope("cluster") seq_cst, align 4
  %e.add = fadd float %e.load, 1.
  store atomic volatile float %e.add, ptr addrspace(3) %e syncscope("cluster") seq_cst, align 4

  %f.load = load atomic volatile double, ptr addrspace(3) %e syncscope("cluster") seq_cst, align 8
  %f.add = fadd double %f.load, 1.
  store atomic volatile double %f.add, ptr addrspace(3) %e syncscope("cluster") seq_cst, align 8

  ret void
}

;; local statespace

; CHECK-LABEL: local_unordered_cluster
define void @local_unordered_cluster(ptr addrspace(5) %a, ptr addrspace(5) %b, ptr addrspace(5) %c, ptr addrspace(5) %d, ptr addrspace(5) %e) local_unnamed_addr {
; CHECK-LABEL: local_unordered_cluster(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<5>;
; CHECK-NEXT:    .reg .b32 %r<5>;
; CHECK-NEXT:    .reg .b64 %rd<10>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b64 %rd1, [local_unordered_cluster_param_0];
; CHECK-NEXT:    ld.local.b8 %rs1, [%rd1];
; CHECK-NEXT:    ld.param.b64 %rd2, [local_unordered_cluster_param_1];
; CHECK-NEXT:    add.s16 %rs2, %rs1, 1;
; CHECK-NEXT:    ld.param.b64 %rd3, [local_unordered_cluster_param_2];
; CHECK-NEXT:    st.local.b8 [%rd1], %rs2;
; CHECK-NEXT:    ld.param.b64 %rd4, [local_unordered_cluster_param_3];
; CHECK-NEXT:    ld.local.b16 %rs3, [%rd2];
; CHECK-NEXT:    ld.param.b64 %rd5, [local_unordered_cluster_param_4];
; CHECK-NEXT:    add.s16 %rs4, %rs3, 1;
; CHECK-NEXT:    st.local.b16 [%rd2], %rs4;
; CHECK-NEXT:    ld.local.b32 %r1, [%rd3];
; CHECK-NEXT:    add.s32 %r2, %r1, 1;
; CHECK-NEXT:    st.local.b32 [%rd3], %r2;
; CHECK-NEXT:    ld.local.b64 %rd6, [%rd4];
; CHECK-NEXT:    add.s64 %rd7, %rd6, 1;
; CHECK-NEXT:    st.local.b64 [%rd4], %rd7;
; CHECK-NEXT:    ld.local.b32 %r3, [%rd5];
; CHECK-NEXT:    add.rn.f32 %r4, %r3, 0f3F800000;
; CHECK-NEXT:    st.local.b32 [%rd5], %r4;
; CHECK-NEXT:    ld.local.b64 %rd8, [%rd5];
; CHECK-NEXT:    add.rn.f64 %rd9, %rd8, 0d3FF0000000000000;
; CHECK-NEXT:    st.local.b64 [%rd5], %rd9;
; CHECK-NEXT:    ret;
  %a.load = load atomic i8, ptr addrspace(5) %a syncscope("cluster") unordered, align 1
  %a.add = add i8 %a.load, 1
  store atomic i8 %a.add, ptr addrspace(5) %a syncscope("cluster") unordered, align 1

  %b.load = load atomic i16, ptr addrspace(5) %b syncscope("cluster") unordered, align 2
  %b.add = add i16 %b.load, 1
  store atomic i16 %b.add, ptr addrspace(5) %b syncscope("cluster") unordered, align 2

  %c.load = load atomic i32, ptr addrspace(5) %c syncscope("cluster") unordered, align 4
  %c.add = add i32 %c.load, 1
  store atomic i32 %c.add, ptr addrspace(5) %c syncscope("cluster") unordered, align 4

  %d.load = load atomic i64, ptr addrspace(5) %d syncscope("cluster") unordered, align 8
  %d.add = add i64 %d.load, 1
  store atomic i64 %d.add, ptr addrspace(5) %d syncscope("cluster") unordered, align 8

  %e.load = load atomic float, ptr addrspace(5) %e syncscope("cluster") unordered, align 4
  %e.add = fadd float %e.load, 1.
  store atomic float %e.add, ptr addrspace(5) %e syncscope("cluster") unordered, align 4

  %f.load = load atomic double, ptr addrspace(5) %e syncscope("cluster") unordered, align 8
  %f.add = fadd double %f.load, 1.
  store atomic double %f.add, ptr addrspace(5) %e syncscope("cluster") unordered, align 8

  ret void
}

; CHECK-LABEL: local_unordered_volatile_cluster
define void @local_unordered_volatile_cluster(ptr addrspace(5) %a, ptr addrspace(5) %b, ptr addrspace(5) %c, ptr addrspace(5) %d, ptr addrspace(5) %e) local_unnamed_addr {
; CHECK-LABEL: local_unordered_volatile_cluster(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<5>;
; CHECK-NEXT:    .reg .b32 %r<5>;
; CHECK-NEXT:    .reg .b64 %rd<10>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b64 %rd1, [local_unordered_volatile_cluster_param_0];
; CHECK-NEXT:    ld.local.b8 %rs1, [%rd1];
; CHECK-NEXT:    ld.param.b64 %rd2, [local_unordered_volatile_cluster_param_1];
; CHECK-NEXT:    add.s16 %rs2, %rs1, 1;
; CHECK-NEXT:    ld.param.b64 %rd3, [local_unordered_volatile_cluster_param_2];
; CHECK-NEXT:    st.local.b8 [%rd1], %rs2;
; CHECK-NEXT:    ld.param.b64 %rd4, [local_unordered_volatile_cluster_param_3];
; CHECK-NEXT:    ld.local.b16 %rs3, [%rd2];
; CHECK-NEXT:    ld.param.b64 %rd5, [local_unordered_volatile_cluster_param_4];
; CHECK-NEXT:    add.s16 %rs4, %rs3, 1;
; CHECK-NEXT:    st.local.b16 [%rd2], %rs4;
; CHECK-NEXT:    ld.local.b32 %r1, [%rd3];
; CHECK-NEXT:    add.s32 %r2, %r1, 1;
; CHECK-NEXT:    st.local.b32 [%rd3], %r2;
; CHECK-NEXT:    ld.local.b64 %rd6, [%rd4];
; CHECK-NEXT:    add.s64 %rd7, %rd6, 1;
; CHECK-NEXT:    st.local.b64 [%rd4], %rd7;
; CHECK-NEXT:    ld.local.b32 %r3, [%rd5];
; CHECK-NEXT:    add.rn.f32 %r4, %r3, 0f3F800000;
; CHECK-NEXT:    st.local.b32 [%rd5], %r4;
; CHECK-NEXT:    ld.local.b64 %rd8, [%rd5];
; CHECK-NEXT:    add.rn.f64 %rd9, %rd8, 0d3FF0000000000000;
; CHECK-NEXT:    st.local.b64 [%rd5], %rd9;
; CHECK-NEXT:    ret;
  %a.load = load atomic volatile i8, ptr addrspace(5) %a syncscope("cluster") unordered, align 1
  %a.add = add i8 %a.load, 1
  store atomic volatile i8 %a.add, ptr addrspace(5) %a syncscope("cluster") unordered, align 1

  %b.load = load atomic volatile i16, ptr addrspace(5) %b syncscope("cluster") unordered, align 2
  %b.add = add i16 %b.load, 1
  store atomic volatile i16 %b.add, ptr addrspace(5) %b syncscope("cluster") unordered, align 2

  %c.load = load atomic volatile i32, ptr addrspace(5) %c syncscope("cluster") unordered, align 4
  %c.add = add i32 %c.load, 1
  store atomic volatile i32 %c.add, ptr addrspace(5) %c syncscope("cluster") unordered, align 4

  %d.load = load atomic volatile i64, ptr addrspace(5) %d syncscope("cluster") unordered, align 8
  %d.add = add i64 %d.load, 1
  store atomic volatile i64 %d.add, ptr addrspace(5) %d syncscope("cluster") unordered, align 8

  %e.load = load atomic volatile float, ptr addrspace(5) %e syncscope("cluster") unordered, align 4
  %e.add = fadd float %e.load, 1.
  store atomic volatile float %e.add, ptr addrspace(5) %e syncscope("cluster") unordered, align 4

  %f.load = load atomic volatile double, ptr addrspace(5) %e syncscope("cluster") unordered, align 8
  %f.add = fadd double %f.load, 1.
  store atomic volatile double %f.add, ptr addrspace(5) %e syncscope("cluster") unordered, align 8

  ret void
}

; CHECK-LABEL: local_monotonic_cluster
define void @local_monotonic_cluster(ptr addrspace(5) %a, ptr addrspace(5) %b, ptr addrspace(5) %c, ptr addrspace(5) %d, ptr addrspace(5) %e) local_unnamed_addr {
; CHECK-LABEL: local_monotonic_cluster(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<5>;
; CHECK-NEXT:    .reg .b32 %r<5>;
; CHECK-NEXT:    .reg .b64 %rd<10>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b64 %rd1, [local_monotonic_cluster_param_0];
; CHECK-NEXT:    ld.local.b8 %rs1, [%rd1];
; CHECK-NEXT:    ld.param.b64 %rd2, [local_monotonic_cluster_param_1];
; CHECK-NEXT:    add.s16 %rs2, %rs1, 1;
; CHECK-NEXT:    ld.param.b64 %rd3, [local_monotonic_cluster_param_2];
; CHECK-NEXT:    st.local.b8 [%rd1], %rs2;
; CHECK-NEXT:    ld.param.b64 %rd4, [local_monotonic_cluster_param_3];
; CHECK-NEXT:    ld.local.b16 %rs3, [%rd2];
; CHECK-NEXT:    ld.param.b64 %rd5, [local_monotonic_cluster_param_4];
; CHECK-NEXT:    add.s16 %rs4, %rs3, 1;
; CHECK-NEXT:    st.local.b16 [%rd2], %rs4;
; CHECK-NEXT:    ld.local.b32 %r1, [%rd3];
; CHECK-NEXT:    add.s32 %r2, %r1, 1;
; CHECK-NEXT:    st.local.b32 [%rd3], %r2;
; CHECK-NEXT:    ld.local.b64 %rd6, [%rd4];
; CHECK-NEXT:    add.s64 %rd7, %rd6, 1;
; CHECK-NEXT:    st.local.b64 [%rd4], %rd7;
; CHECK-NEXT:    ld.local.b32 %r3, [%rd5];
; CHECK-NEXT:    add.rn.f32 %r4, %r3, 0f3F800000;
; CHECK-NEXT:    st.local.b32 [%rd5], %r4;
; CHECK-NEXT:    ld.local.b64 %rd8, [%rd5];
; CHECK-NEXT:    add.rn.f64 %rd9, %rd8, 0d3FF0000000000000;
; CHECK-NEXT:    st.local.b64 [%rd5], %rd9;
; CHECK-NEXT:    ret;
  %a.load = load atomic i8, ptr addrspace(5) %a syncscope("cluster") monotonic, align 1
  %a.add = add i8 %a.load, 1
  store atomic i8 %a.add, ptr addrspace(5) %a syncscope("cluster") monotonic, align 1

  %b.load = load atomic i16, ptr addrspace(5) %b syncscope("cluster") monotonic, align 2
  %b.add = add i16 %b.load, 1
  store atomic i16 %b.add, ptr addrspace(5) %b syncscope("cluster") monotonic, align 2

  %c.load = load atomic i32, ptr addrspace(5) %c syncscope("cluster") monotonic, align 4
  %c.add = add i32 %c.load, 1
  store atomic i32 %c.add, ptr addrspace(5) %c syncscope("cluster") monotonic, align 4

  %d.load = load atomic i64, ptr addrspace(5) %d syncscope("cluster") monotonic, align 8
  %d.add = add i64 %d.load, 1
  store atomic i64 %d.add, ptr addrspace(5) %d syncscope("cluster") monotonic, align 8

  %e.load = load atomic float, ptr addrspace(5) %e syncscope("cluster") monotonic, align 4
  %e.add = fadd float %e.load, 1.
  store atomic float %e.add, ptr addrspace(5) %e syncscope("cluster") monotonic, align 4

  %f.load = load atomic double, ptr addrspace(5) %e syncscope("cluster") monotonic, align 8
  %f.add = fadd double %f.load, 1.
  store atomic double %f.add, ptr addrspace(5) %e syncscope("cluster") monotonic, align 8

  ret void
}

; CHECK-LABEL: local_monotonic_volatile_cluster
define void @local_monotonic_volatile_cluster(ptr addrspace(5) %a, ptr addrspace(5) %b, ptr addrspace(5) %c, ptr addrspace(5) %d, ptr addrspace(5) %e) local_unnamed_addr {
; CHECK-LABEL: local_monotonic_volatile_cluster(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<5>;
; CHECK-NEXT:    .reg .b32 %r<5>;
; CHECK-NEXT:    .reg .b64 %rd<10>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b64 %rd1, [local_monotonic_volatile_cluster_param_0];
; CHECK-NEXT:    ld.local.b8 %rs1, [%rd1];
; CHECK-NEXT:    ld.param.b64 %rd2, [local_monotonic_volatile_cluster_param_1];
; CHECK-NEXT:    add.s16 %rs2, %rs1, 1;
; CHECK-NEXT:    ld.param.b64 %rd3, [local_monotonic_volatile_cluster_param_2];
; CHECK-NEXT:    st.local.b8 [%rd1], %rs2;
; CHECK-NEXT:    ld.param.b64 %rd4, [local_monotonic_volatile_cluster_param_3];
; CHECK-NEXT:    ld.local.b16 %rs3, [%rd2];
; CHECK-NEXT:    ld.param.b64 %rd5, [local_monotonic_volatile_cluster_param_4];
; CHECK-NEXT:    add.s16 %rs4, %rs3, 1;
; CHECK-NEXT:    st.local.b16 [%rd2], %rs4;
; CHECK-NEXT:    ld.local.b32 %r1, [%rd3];
; CHECK-NEXT:    add.s32 %r2, %r1, 1;
; CHECK-NEXT:    st.local.b32 [%rd3], %r2;
; CHECK-NEXT:    ld.local.b64 %rd6, [%rd4];
; CHECK-NEXT:    add.s64 %rd7, %rd6, 1;
; CHECK-NEXT:    st.local.b64 [%rd4], %rd7;
; CHECK-NEXT:    ld.local.b32 %r3, [%rd5];
; CHECK-NEXT:    add.rn.f32 %r4, %r3, 0f3F800000;
; CHECK-NEXT:    st.local.b32 [%rd5], %r4;
; CHECK-NEXT:    ld.local.b64 %rd8, [%rd5];
; CHECK-NEXT:    add.rn.f64 %rd9, %rd8, 0d3FF0000000000000;
; CHECK-NEXT:    st.local.b64 [%rd5], %rd9;
; CHECK-NEXT:    ret;
  %a.load = load atomic volatile i8, ptr addrspace(5) %a syncscope("cluster") monotonic, align 1
  %a.add = add i8 %a.load, 1
  store atomic volatile i8 %a.add, ptr addrspace(5) %a syncscope("cluster") monotonic, align 1

  %b.load = load atomic volatile i16, ptr addrspace(5) %b syncscope("cluster") monotonic, align 2
  %b.add = add i16 %b.load, 1
  store atomic volatile i16 %b.add, ptr addrspace(5) %b syncscope("cluster") monotonic, align 2

  %c.load = load atomic volatile i32, ptr addrspace(5) %c syncscope("cluster") monotonic, align 4
  %c.add = add i32 %c.load, 1
  store atomic volatile i32 %c.add, ptr addrspace(5) %c syncscope("cluster") monotonic, align 4

  %d.load = load atomic volatile i64, ptr addrspace(5) %d syncscope("cluster") monotonic, align 8
  %d.add = add i64 %d.load, 1
  store atomic volatile i64 %d.add, ptr addrspace(5) %d syncscope("cluster") monotonic, align 8

  %e.load = load atomic volatile float, ptr addrspace(5) %e syncscope("cluster") monotonic, align 4
  %e.add = fadd float %e.load, 1.
  store atomic volatile float %e.add, ptr addrspace(5) %e syncscope("cluster") monotonic, align 4

  %f.load = load atomic volatile double, ptr addrspace(5) %e syncscope("cluster") monotonic, align 8
  %f.add = fadd double %f.load, 1.
  store atomic volatile double %f.add, ptr addrspace(5) %e syncscope("cluster") monotonic, align 8

  ret void
}

; CHECK-LABEL: local_acq_rel_cluster
define void @local_acq_rel_cluster(ptr addrspace(5) %a, ptr addrspace(5) %b, ptr addrspace(5) %c, ptr addrspace(5) %d, ptr addrspace(5) %e) local_unnamed_addr {
; CHECK-LABEL: local_acq_rel_cluster(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<5>;
; CHECK-NEXT:    .reg .b32 %r<5>;
; CHECK-NEXT:    .reg .b64 %rd<10>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b64 %rd1, [local_acq_rel_cluster_param_0];
; CHECK-NEXT:    ld.local.b8 %rs1, [%rd1];
; CHECK-NEXT:    ld.param.b64 %rd2, [local_acq_rel_cluster_param_1];
; CHECK-NEXT:    add.s16 %rs2, %rs1, 1;
; CHECK-NEXT:    ld.param.b64 %rd3, [local_acq_rel_cluster_param_2];
; CHECK-NEXT:    st.local.b8 [%rd1], %rs2;
; CHECK-NEXT:    ld.param.b64 %rd4, [local_acq_rel_cluster_param_3];
; CHECK-NEXT:    ld.local.b16 %rs3, [%rd2];
; CHECK-NEXT:    ld.param.b64 %rd5, [local_acq_rel_cluster_param_4];
; CHECK-NEXT:    add.s16 %rs4, %rs3, 1;
; CHECK-NEXT:    st.local.b16 [%rd2], %rs4;
; CHECK-NEXT:    ld.local.b32 %r1, [%rd3];
; CHECK-NEXT:    add.s32 %r2, %r1, 1;
; CHECK-NEXT:    st.local.b32 [%rd3], %r2;
; CHECK-NEXT:    ld.local.b64 %rd6, [%rd4];
; CHECK-NEXT:    add.s64 %rd7, %rd6, 1;
; CHECK-NEXT:    st.local.b64 [%rd4], %rd7;
; CHECK-NEXT:    ld.local.b32 %r3, [%rd5];
; CHECK-NEXT:    add.rn.f32 %r4, %r3, 0f3F800000;
; CHECK-NEXT:    st.local.b32 [%rd5], %r4;
; CHECK-NEXT:    ld.local.b64 %rd8, [%rd5];
; CHECK-NEXT:    add.rn.f64 %rd9, %rd8, 0d3FF0000000000000;
; CHECK-NEXT:    st.local.b64 [%rd5], %rd9;
; CHECK-NEXT:    ret;
  %a.load = load atomic i8, ptr addrspace(5) %a syncscope("cluster") acquire, align 1
  %a.add = add i8 %a.load, 1
  store atomic i8 %a.add, ptr addrspace(5) %a syncscope("cluster") release, align 1

  %b.load = load atomic i16, ptr addrspace(5) %b syncscope("cluster") acquire, align 2
  %b.add = add i16 %b.load, 1
  store atomic i16 %b.add, ptr addrspace(5) %b syncscope("cluster") release, align 2

  %c.load = load atomic i32, ptr addrspace(5) %c syncscope("cluster") acquire, align 4
  %c.add = add i32 %c.load, 1
  store atomic i32 %c.add, ptr addrspace(5) %c syncscope("cluster") release, align 4

  %d.load = load atomic i64, ptr addrspace(5) %d syncscope("cluster") acquire, align 8
  %d.add = add i64 %d.load, 1
  store atomic i64 %d.add, ptr addrspace(5) %d syncscope("cluster") release, align 8

  %e.load = load atomic float, ptr addrspace(5) %e syncscope("cluster") acquire, align 4
  %e.add = fadd float %e.load, 1.
  store atomic float %e.add, ptr addrspace(5) %e syncscope("cluster") release, align 4

  %f.load = load atomic double, ptr addrspace(5) %e syncscope("cluster") acquire, align 8
  %f.add = fadd double %f.load, 1.
  store atomic double %f.add, ptr addrspace(5) %e syncscope("cluster") release, align 8

  ret void
}

; CHECK-LABEL: local_acq_rel_volatile_cluster
define void @local_acq_rel_volatile_cluster(ptr addrspace(5) %a, ptr addrspace(5) %b, ptr addrspace(5) %c, ptr addrspace(5) %d, ptr addrspace(5) %e) local_unnamed_addr {
; CHECK-LABEL: local_acq_rel_volatile_cluster(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<5>;
; CHECK-NEXT:    .reg .b32 %r<5>;
; CHECK-NEXT:    .reg .b64 %rd<10>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b64 %rd1, [local_acq_rel_volatile_cluster_param_0];
; CHECK-NEXT:    ld.local.b8 %rs1, [%rd1];
; CHECK-NEXT:    ld.param.b64 %rd2, [local_acq_rel_volatile_cluster_param_1];
; CHECK-NEXT:    add.s16 %rs2, %rs1, 1;
; CHECK-NEXT:    ld.param.b64 %rd3, [local_acq_rel_volatile_cluster_param_2];
; CHECK-NEXT:    st.local.b8 [%rd1], %rs2;
; CHECK-NEXT:    ld.param.b64 %rd4, [local_acq_rel_volatile_cluster_param_3];
; CHECK-NEXT:    ld.local.b16 %rs3, [%rd2];
; CHECK-NEXT:    ld.param.b64 %rd5, [local_acq_rel_volatile_cluster_param_4];
; CHECK-NEXT:    add.s16 %rs4, %rs3, 1;
; CHECK-NEXT:    st.local.b16 [%rd2], %rs4;
; CHECK-NEXT:    ld.local.b32 %r1, [%rd3];
; CHECK-NEXT:    add.s32 %r2, %r1, 1;
; CHECK-NEXT:    st.local.b32 [%rd3], %r2;
; CHECK-NEXT:    ld.local.b64 %rd6, [%rd4];
; CHECK-NEXT:    add.s64 %rd7, %rd6, 1;
; CHECK-NEXT:    st.local.b64 [%rd4], %rd7;
; CHECK-NEXT:    ld.local.b32 %r3, [%rd5];
; CHECK-NEXT:    add.rn.f32 %r4, %r3, 0f3F800000;
; CHECK-NEXT:    st.local.b32 [%rd5], %r4;
; CHECK-NEXT:    ld.local.b64 %rd8, [%rd5];
; CHECK-NEXT:    add.rn.f64 %rd9, %rd8, 0d3FF0000000000000;
; CHECK-NEXT:    st.local.b64 [%rd5], %rd9;
; CHECK-NEXT:    ret;
  %a.load = load atomic volatile i8, ptr addrspace(5) %a syncscope("cluster") acquire, align 1
  %a.add = add i8 %a.load, 1
  store atomic volatile i8 %a.add, ptr addrspace(5) %a syncscope("cluster") release, align 1

  %b.load = load atomic volatile i16, ptr addrspace(5) %b syncscope("cluster") acquire, align 2
  %b.add = add i16 %b.load, 1
  store atomic volatile i16 %b.add, ptr addrspace(5) %b syncscope("cluster") release, align 2

  %c.load = load atomic volatile i32, ptr addrspace(5) %c syncscope("cluster") acquire, align 4
  %c.add = add i32 %c.load, 1
  store atomic volatile i32 %c.add, ptr addrspace(5) %c syncscope("cluster") release, align 4

  %d.load = load atomic volatile i64, ptr addrspace(5) %d syncscope("cluster") acquire, align 8
  %d.add = add i64 %d.load, 1
  store atomic volatile i64 %d.add, ptr addrspace(5) %d syncscope("cluster") release, align 8

  %e.load = load atomic volatile float, ptr addrspace(5) %e syncscope("cluster") acquire, align 4
  %e.add = fadd float %e.load, 1.
  store atomic volatile float %e.add, ptr addrspace(5) %e syncscope("cluster") release, align 4

  %f.load = load atomic volatile double, ptr addrspace(5) %e syncscope("cluster") acquire, align 8
  %f.add = fadd double %f.load, 1.
  store atomic volatile double %f.add, ptr addrspace(5) %e syncscope("cluster") release, align 8

  ret void
}

; CHECK-LABEL: local_seq_cst_cluster
define void @local_seq_cst_cluster(ptr addrspace(5) %a, ptr addrspace(5) %b, ptr addrspace(5) %c, ptr addrspace(5) %d, ptr addrspace(5) %e) local_unnamed_addr {
; CHECK-LABEL: local_seq_cst_cluster(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<5>;
; CHECK-NEXT:    .reg .b32 %r<5>;
; CHECK-NEXT:    .reg .b64 %rd<10>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b64 %rd1, [local_seq_cst_cluster_param_0];
; CHECK-NEXT:    ld.local.b8 %rs1, [%rd1];
; CHECK-NEXT:    ld.param.b64 %rd2, [local_seq_cst_cluster_param_1];
; CHECK-NEXT:    add.s16 %rs2, %rs1, 1;
; CHECK-NEXT:    ld.param.b64 %rd3, [local_seq_cst_cluster_param_2];
; CHECK-NEXT:    st.local.b8 [%rd1], %rs2;
; CHECK-NEXT:    ld.param.b64 %rd4, [local_seq_cst_cluster_param_3];
; CHECK-NEXT:    ld.local.b16 %rs3, [%rd2];
; CHECK-NEXT:    ld.param.b64 %rd5, [local_seq_cst_cluster_param_4];
; CHECK-NEXT:    add.s16 %rs4, %rs3, 1;
; CHECK-NEXT:    st.local.b16 [%rd2], %rs4;
; CHECK-NEXT:    ld.local.b32 %r1, [%rd3];
; CHECK-NEXT:    add.s32 %r2, %r1, 1;
; CHECK-NEXT:    st.local.b32 [%rd3], %r2;
; CHECK-NEXT:    ld.local.b64 %rd6, [%rd4];
; CHECK-NEXT:    add.s64 %rd7, %rd6, 1;
; CHECK-NEXT:    st.local.b64 [%rd4], %rd7;
; CHECK-NEXT:    ld.local.b32 %r3, [%rd5];
; CHECK-NEXT:    add.rn.f32 %r4, %r3, 0f3F800000;
; CHECK-NEXT:    st.local.b32 [%rd5], %r4;
; CHECK-NEXT:    ld.local.b64 %rd8, [%rd5];
; CHECK-NEXT:    add.rn.f64 %rd9, %rd8, 0d3FF0000000000000;
; CHECK-NEXT:    st.local.b64 [%rd5], %rd9;
; CHECK-NEXT:    ret;
  %a.load = load atomic i8, ptr addrspace(5) %a syncscope("cluster") seq_cst, align 1
  %a.add = add i8 %a.load, 1
  store atomic i8 %a.add, ptr addrspace(5) %a syncscope("cluster") seq_cst, align 1

  %b.load = load atomic i16, ptr addrspace(5) %b syncscope("cluster") seq_cst, align 2
  %b.add = add i16 %b.load, 1
  store atomic i16 %b.add, ptr addrspace(5) %b syncscope("cluster") seq_cst, align 2

  %c.load = load atomic i32, ptr addrspace(5) %c syncscope("cluster") seq_cst, align 4
  %c.add = add i32 %c.load, 1
  store atomic i32 %c.add, ptr addrspace(5) %c syncscope("cluster") seq_cst, align 4

  %d.load = load atomic i64, ptr addrspace(5) %d syncscope("cluster") seq_cst, align 8
  %d.add = add i64 %d.load, 1
  store atomic i64 %d.add, ptr addrspace(5) %d syncscope("cluster") seq_cst, align 8

  %e.load = load atomic float, ptr addrspace(5) %e syncscope("cluster") seq_cst, align 4
  %e.add = fadd float %e.load, 1.
  store atomic float %e.add, ptr addrspace(5) %e syncscope("cluster") seq_cst, align 4

  %f.load = load atomic double, ptr addrspace(5) %e syncscope("cluster") seq_cst, align 8
  %f.add = fadd double %f.load, 1.
  store atomic double %f.add, ptr addrspace(5) %e syncscope("cluster") seq_cst, align 8

  ret void
}

; CHECK-LABEL: local_seq_cst_volatile_cluster
define void @local_seq_cst_volatile_cluster(ptr addrspace(5) %a, ptr addrspace(5) %b, ptr addrspace(5) %c, ptr addrspace(5) %d, ptr addrspace(5) %e) local_unnamed_addr {
; CHECK-LABEL: local_seq_cst_volatile_cluster(
; CHECK:       {
; CHECK-NEXT:    .reg .b16 %rs<5>;
; CHECK-NEXT:    .reg .b32 %r<5>;
; CHECK-NEXT:    .reg .b64 %rd<10>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b64 %rd1, [local_seq_cst_volatile_cluster_param_0];
; CHECK-NEXT:    ld.local.b8 %rs1, [%rd1];
; CHECK-NEXT:    ld.param.b64 %rd2, [local_seq_cst_volatile_cluster_param_1];
; CHECK-NEXT:    add.s16 %rs2, %rs1, 1;
; CHECK-NEXT:    ld.param.b64 %rd3, [local_seq_cst_volatile_cluster_param_2];
; CHECK-NEXT:    st.local.b8 [%rd1], %rs2;
; CHECK-NEXT:    ld.param.b64 %rd4, [local_seq_cst_volatile_cluster_param_3];
; CHECK-NEXT:    ld.local.b16 %rs3, [%rd2];
; CHECK-NEXT:    ld.param.b64 %rd5, [local_seq_cst_volatile_cluster_param_4];
; CHECK-NEXT:    add.s16 %rs4, %rs3, 1;
; CHECK-NEXT:    st.local.b16 [%rd2], %rs4;
; CHECK-NEXT:    ld.local.b32 %r1, [%rd3];
; CHECK-NEXT:    add.s32 %r2, %r1, 1;
; CHECK-NEXT:    st.local.b32 [%rd3], %r2;
; CHECK-NEXT:    ld.local.b64 %rd6, [%rd4];
; CHECK-NEXT:    add.s64 %rd7, %rd6, 1;
; CHECK-NEXT:    st.local.b64 [%rd4], %rd7;
; CHECK-NEXT:    ld.local.b32 %r3, [%rd5];
; CHECK-NEXT:    add.rn.f32 %r4, %r3, 0f3F800000;
; CHECK-NEXT:    st.local.b32 [%rd5], %r4;
; CHECK-NEXT:    ld.local.b64 %rd8, [%rd5];
; CHECK-NEXT:    add.rn.f64 %rd9, %rd8, 0d3FF0000000000000;
; CHECK-NEXT:    st.local.b64 [%rd5], %rd9;
; CHECK-NEXT:    ret;
  %a.load = load atomic volatile i8, ptr addrspace(5) %a syncscope("cluster") seq_cst, align 1
  %a.add = add i8 %a.load, 1
  store atomic volatile i8 %a.add, ptr addrspace(5) %a syncscope("cluster") seq_cst, align 1

  %b.load = load atomic volatile i16, ptr addrspace(5) %b syncscope("cluster") seq_cst, align 2
  %b.add = add i16 %b.load, 1
  store atomic volatile i16 %b.add, ptr addrspace(5) %b syncscope("cluster") seq_cst, align 2

  %c.load = load atomic volatile i32, ptr addrspace(5) %c syncscope("cluster") seq_cst, align 4
  %c.add = add i32 %c.load, 1
  store atomic volatile i32 %c.add, ptr addrspace(5) %c syncscope("cluster") seq_cst, align 4

  %d.load = load atomic volatile i64, ptr addrspace(5) %d syncscope("cluster") seq_cst, align 8
  %d.add = add i64 %d.load, 1
  store atomic volatile i64 %d.add, ptr addrspace(5) %d syncscope("cluster") seq_cst, align 8

  %e.load = load atomic volatile float, ptr addrspace(5) %e syncscope("cluster") seq_cst, align 4
  %e.add = fadd float %e.load, 1.
  store atomic volatile float %e.add, ptr addrspace(5) %e syncscope("cluster") seq_cst, align 4

  %f.load = load atomic volatile double, ptr addrspace(5) %e syncscope("cluster") seq_cst, align 8
  %f.add = fadd double %f.load, 1.
  store atomic volatile double %f.add, ptr addrspace(5) %e syncscope("cluster") seq_cst, align 8

  ret void
}
