C    Copyright(C) 1999-2020 National Technology & Engineering Solutions
C    of Sandia, LLC (NTESS).  Under the terms of Contract DE-NA0003525 with
C    NTESS, the U.S. Government retains certain rights in this software.
C
C    See packages/seacas/LICENSE for details

      SUBROUTINE REPSMO (MXND, XN, YN, LXN, NNN, NNNOLD, NIT, EPS, RO,
     &   M1)
C***********************************************************************

C  SUBROUTINE REPSMO = SMOOTHS A MESH GENERATED BY RMESH BY THE
C                      EQUIPOTENTIAL, OR WEIGHTED LAPLACIAN METHOD.
C                      GAUSS-SEIDEL TYPE RELAXATION IS USED.
C     REFERENCE--MESH GENERATION-A SURVEY, BY BUELL AND BUSH, F.M.C.

C***********************************************************************

C     NIT - MAX NUMBER OF ITERATIONS
C     EPS - CONVERGENCE CRITERION FOR NODE MOVEMENTS
C     RO  - RELAXATION FACTOR  (USUALLY 1.0 OR LARGER)
C     M1  - SAME AS M1 GIVEN TO RMESH.  THE MESH MUST BE LOGICALLY
C           EXACTLY AS PRODUCED BY RMESH.

C***********************************************************************

      DIMENSION LXN (4, MXND), XN (MXND), YN (MXND)

      LOGICAL BIG

      EPS2 = (EPS*RO)**2
      NROW = M1 + 1

C  ITERATION LOOP

      DO 110 IT = 1, NIT
         BIG = .FALSE.

C  NODE LOOP

         DO 100 NODE = NNNOLD + 1, NNN

C  SKIP BOUNDARY NODES

            IF (LXN (2, NODE) .GT. 0) THEN
               NT = NODE + NROW
               NB = NODE - NROW

C  COMPUTE WEIGHTS

               XPHI = 0.5* (XN (NT) - XN (NB))
               YPHI = 0.5* (YN (NT) - YN (NB))
               XPSI = 0.5* (XN (NODE + 1) - XN (NODE - 1))
               YPSI = 0.5* (YN (NODE + 1) - YN (NODE - 1))
               ALPHA = XPSI**2 + YPSI**2
               GAMMA = XPHI**2 + YPHI**2
               BETA2 =  (XPHI*XPSI + YPHI*YPSI)*0.5
               WEIGHT = 2.0* (ALPHA + GAMMA)

C  COMPUTE WEIGHTED SUM OF COORDINATES

               XSUM = ALPHA * (XN (NT) + XN (NB))
     &            + GAMMA * (XN (NODE - 1) + XN (NODE + 1))
     &            + BETA2 * (XN (NT - 1) + XN (NB + 1)
     &            - XN (NT + 1) - XN (NB - 1))
               YSUM = ALPHA * (YN (NT) + YN (NB))
     &            + GAMMA * (YN (NODE - 1) + YN (NODE + 1))
     &            + BETA2 * (YN (NT - 1) + YN (NB + 1)
     &            - YN (NT + 1) - YN (NB - 1))

C  MOVE THE NODE AS INDICATED

               DELX = (XSUM/WEIGHT - XN (NODE)) * RO
               DELY = (YSUM/WEIGHT - YN (NODE)) * RO
               XN (NODE) = XN (NODE) + DELX
               YN (NODE) = YN (NODE) + DELY
               IF (DELX ** 2 + DELY ** 2  .GT.  EPS2) BIG = .TRUE.
            ENDIF
  100    CONTINUE
         IF (.NOT.BIG) RETURN
  110 CONTINUE
      RETURN
      END
