"""
Verify there is no buffer corruption after formatting a file containing
tabulations. Also check the highlighter.
"""

import GPS
from gs_utils.internal.utils import *

EXPECTED = """.........
.
............
.............

.......###########.########.####......
.........
.......###########.########.####......
.......###########.########.####......
.......###########.########.####......
.......###########.########.####......
.......###########.########.####......
.......###########.########.####......

.........................
.........................
...........................
...................
.............................
.....
..######................
.
"""


@run_test_driver
def driver():
    b = GPS.EditorBuffer.get(GPS.File("hello.cpp"))
    # Select from the start to the end => it will put the insert mark
    # at the start
    b.select(b.end_of_buffer(), b.beginning_of_buffer())
    # Wait for requests like documentSymbols and diagnostics
    yield timeout(500)
    GPS.execute_action("format selection")
    yield wait_language_server('textDocument/rangeFormatting', 'C++')
    GPS.execute_action("format file")
    yield wait_language_server('textDocument/formatting', 'C++')
    res = b.debug_dump_syntax_highlighting("keyword_text")
    gps_assert(res, EXPECTED, "Wrong highlighting")
