;; NOTE: Assertions have been generated by update_lit_checks.py and should not be edited.

;; RUN: foreach %s %t wasm-opt -all --closed-world --reorder-types-for-testing -S -o - \
;; RUN:     | filecheck %s

(module
  (rec
    ;; CHECK:      (rec
    ;; CHECK-NEXT:  (type $A (struct))
    (type $A (struct))
    ;; CHECK:       (type $B (struct))
    (type $B (struct))
    ;; CHECK:       (type $C (struct))
    (type $C (struct))
  )

  ;; CHECK:      (func $test (type $2)
  ;; CHECK-NEXT:  (local $0 (ref $A))
  ;; CHECK-NEXT:  (local $1 (ref $A))
  ;; CHECK-NEXT:  (local $2 (ref $A))
  ;; CHECK-NEXT:  (local $3 (ref $B))
  ;; CHECK-NEXT:  (local $4 (ref $B))
  ;; CHECK-NEXT:  (local $5 (ref $C))
  ;; CHECK-NEXT: )
  (func $test
    (local (ref $A))
    (local (ref $A))
    (local (ref $A))
    (local (ref $B))
    (local (ref $B))
    (local (ref $C))
  )
)

(module
  (rec
    ;; CHECK:      (rec
    ;; CHECK-NEXT:  (type $A (struct))
    (type $A (struct))
    ;; CHECK:       (type $C (struct))

    ;; CHECK:       (type $B (struct))
    (type $B (struct))
    (type $C (struct))
  )

  ;; CHECK:      (func $test (type $2)
  ;; CHECK-NEXT:  (local $0 (ref $A))
  ;; CHECK-NEXT:  (local $1 (ref $A))
  ;; CHECK-NEXT:  (local $2 (ref $A))
  ;; CHECK-NEXT:  (local $3 (ref $B))
  ;; CHECK-NEXT:  (local $4 (ref $C))
  ;; CHECK-NEXT:  (local $5 (ref $C))
  ;; CHECK-NEXT: )
  (func $test
    (local (ref $A))
    (local (ref $A))
    (local (ref $A))
    (local (ref $B))
    (local (ref $C))
    (local (ref $C))
  )
)

(module
  (rec
    ;; CHECK:      (rec
    ;; CHECK-NEXT:  (type $B (struct))

    ;; CHECK:       (type $A (struct))
    (type $A (struct))
    (type $B (struct))
    ;; CHECK:       (type $C (struct))
    (type $C (struct))
  )

  ;; CHECK:      (func $test (type $2)
  ;; CHECK-NEXT:  (local $0 (ref $A))
  ;; CHECK-NEXT:  (local $1 (ref $A))
  ;; CHECK-NEXT:  (local $2 (ref $B))
  ;; CHECK-NEXT:  (local $3 (ref $B))
  ;; CHECK-NEXT:  (local $4 (ref $B))
  ;; CHECK-NEXT:  (local $5 (ref $C))
  ;; CHECK-NEXT: )
  (func $test
    (local (ref $A))
    (local (ref $A))
    (local (ref $B))
    (local (ref $B))
    (local (ref $B))
    (local (ref $C))
  )
)

(module
  (rec
    ;; CHECK:      (rec
    ;; CHECK-NEXT:  (type $B (struct))

    ;; CHECK:       (type $C (struct))

    ;; CHECK:       (type $A (struct))
    (type $A (struct))
    (type $B (struct))
    (type $C (struct))
  )

  ;; CHECK:      (func $test (type $3)
  ;; CHECK-NEXT:  (local $0 (ref $A))
  ;; CHECK-NEXT:  (local $1 (ref $B))
  ;; CHECK-NEXT:  (local $2 (ref $B))
  ;; CHECK-NEXT:  (local $3 (ref $B))
  ;; CHECK-NEXT:  (local $4 (ref $C))
  ;; CHECK-NEXT:  (local $5 (ref $C))
  ;; CHECK-NEXT: )
  (func $test
    (local (ref $A))
    (local (ref $B))
    (local (ref $B))
    (local (ref $B))
    (local (ref $C))
    (local (ref $C))
  )
)

(module
  (rec
    ;; CHECK:      (rec
    ;; CHECK-NEXT:  (type $C (struct))

    ;; CHECK:       (type $A (struct))
    (type $A (struct))
    ;; CHECK:       (type $B (struct))
    (type $B (struct))
    (type $C (struct))
  )

  ;; CHECK:      (func $test (type $2)
  ;; CHECK-NEXT:  (local $0 (ref $A))
  ;; CHECK-NEXT:  (local $1 (ref $A))
  ;; CHECK-NEXT:  (local $2 (ref $B))
  ;; CHECK-NEXT:  (local $3 (ref $C))
  ;; CHECK-NEXT:  (local $4 (ref $C))
  ;; CHECK-NEXT:  (local $5 (ref $C))
  ;; CHECK-NEXT: )
  (func $test
    (local (ref $A))
    (local (ref $A))
    (local (ref $B))
    (local (ref $C))
    (local (ref $C))
    (local (ref $C))
  )
)

(module
  (rec
    ;; CHECK:      (rec
    ;; CHECK-NEXT:  (type $C (struct))

    ;; CHECK:       (type $B (struct))

    ;; CHECK:       (type $A (struct))
    (type $A (struct))
    (type $B (struct))
    (type $C (struct))
  )

  ;; CHECK:      (func $test (type $3)
  ;; CHECK-NEXT:  (local $0 (ref $A))
  ;; CHECK-NEXT:  (local $1 (ref $B))
  ;; CHECK-NEXT:  (local $2 (ref $B))
  ;; CHECK-NEXT:  (local $3 (ref $C))
  ;; CHECK-NEXT:  (local $4 (ref $C))
  ;; CHECK-NEXT:  (local $5 (ref $C))
  ;; CHECK-NEXT: )
  (func $test
    (local (ref $A))
    (local (ref $B))
    (local (ref $B))
    (local (ref $C))
    (local (ref $C))
    (local (ref $C))
  )
)

(module
  (rec
    ;; CHECK:      (rec
    ;; CHECK-NEXT:  (type $C (struct))

    ;; CHECK:       (type $A (struct))
    (type $A (struct))
    ;; CHECK:       (type $B (struct))
    (type $B (struct))
    (type $C (struct))
  )

  ;; CHECK:      (func $test (type $2)
  ;; CHECK-NEXT:  (local $0 (ref $A))
  ;; CHECK-NEXT:  (local $1 (ref $A))
  ;; CHECK-NEXT:  (local $2 (ref $B))
  ;; CHECK-NEXT:  (local $3 (ref $C))
  ;; CHECK-NEXT:  (local $4 (ref $C))
  ;; CHECK-NEXT:  (local $5 (ref $C))
  ;; CHECK-NEXT: )
  (func $test
    (local (ref $A))
    (local (ref $A))
    (local (ref $B))
    (local (ref $C))
    (local (ref $C))
    (local (ref $C))
  )
)

(module
  ;; Respect ordering constraints even if bad for code size.
  (rec
    ;; CHECK:      (rec
    ;; CHECK-NEXT:  (type $A (sub (struct)))
    (type $A (sub (struct)))
    ;; CHECK:       (type $B (sub $A (struct)))
    (type $B (sub $A (struct)))
    ;; CHECK:       (type $C (sub $B (struct)))
    (type $C (sub $B (struct)))
  )

  ;; CHECK:      (func $test (type $3)
  ;; CHECK-NEXT:  (local $0 (ref $A))
  ;; CHECK-NEXT:  (local $1 (ref $B))
  ;; CHECK-NEXT:  (local $2 (ref $B))
  ;; CHECK-NEXT:  (local $3 (ref $C))
  ;; CHECK-NEXT:  (local $4 (ref $C))
  ;; CHECK-NEXT:  (local $5 (ref $C))
  ;; CHECK-NEXT: )
  (func $test
    (local (ref $A))
    (local (ref $B))
    (local (ref $B))
    (local (ref $C))
    (local (ref $C))
    (local (ref $C))
  )
)

(module
  ;; Successor types are factored in and can break ties. Here there are more
  ;; $Ys, so $X comes first.
  (rec
    ;; CHECK:      (rec
    ;; CHECK-NEXT:  (type $X (sub (struct)))

    ;; CHECK:       (type $Y (sub $X (struct)))

    ;; CHECK:       (type $A (sub (struct)))
    (type $A (sub (struct)))
    ;; CHECK:       (type $B (sub $A (struct)))
    (type $B (sub $A (struct)))
    (type $X (sub (struct)))
    (type $Y (sub $X (struct)))
  )

  ;; CHECK:      (func $test (type $3)
  ;; CHECK-NEXT:  (local $0 (ref $A))
  ;; CHECK-NEXT:  (local $1 (ref $B))
  ;; CHECK-NEXT:  (local $2 (ref $X))
  ;; CHECK-NEXT:  (local $3 (ref $Y))
  ;; CHECK-NEXT:  (local $4 (ref $Y))
  ;; CHECK-NEXT:  (local $5 (ref $Y))
  ;; CHECK-NEXT: )
  (func $test
    (local (ref $A))
    (local (ref $B))
    (local (ref $X))
    (local (ref $Y))
    (local (ref $Y))
    (local (ref $Y))
  )
)


(module
  ;; Same as above, but now there are more $Bs, so $A comes first.
  (rec
    ;; CHECK:      (rec
    ;; CHECK-NEXT:  (type $A (sub (struct)))
    (type $A (sub (struct)))
    ;; CHECK:       (type $B (sub $A (struct)))
    (type $B (sub $A (struct)))
    ;; CHECK:       (type $X (sub (struct)))
    (type $X (sub (struct)))
    ;; CHECK:       (type $Y (sub $X (struct)))
    (type $Y (sub $X (struct)))
  )

  ;; CHECK:      (func $test (type $3)
  ;; CHECK-NEXT:  (local $0 (ref $A))
  ;; CHECK-NEXT:  (local $1 (ref $B))
  ;; CHECK-NEXT:  (local $2 (ref $B))
  ;; CHECK-NEXT:  (local $3 (ref $B))
  ;; CHECK-NEXT:  (local $4 (ref $X))
  ;; CHECK-NEXT:  (local $5 (ref $Y))
  ;; CHECK-NEXT: )
  (func $test
    (local (ref $A))
    (local (ref $B))
    (local (ref $B))
    (local (ref $B))
    (local (ref $X))
    (local (ref $Y))
  )
)

(module
  ;; Now there are lots of $Y again, which would make $X go first, except there
  ;; are even more $A.
  (rec
    ;; CHECK:      (rec
    ;; CHECK-NEXT:  (type $A (sub (struct)))
    (type $A (sub (struct)))
    ;; CHECK:       (type $X (sub (struct)))

    ;; CHECK:       (type $Y (sub $X (struct)))

    ;; CHECK:       (type $B (sub $A (struct)))
    (type $B (sub $A (struct)))
    (type $X (sub (struct)))
    (type $Y (sub $X (struct)))
  )

  ;; CHECK:      (func $test (type $4)
  ;; CHECK-NEXT:  (local $0 (ref $A))
  ;; CHECK-NEXT:  (local $1 (ref $A))
  ;; CHECK-NEXT:  (local $2 (ref $A))
  ;; CHECK-NEXT:  (local $3 (ref $A))
  ;; CHECK-NEXT:  (local $4 (ref $B))
  ;; CHECK-NEXT:  (local $5 (ref $X))
  ;; CHECK-NEXT:  (local $6 (ref $Y))
  ;; CHECK-NEXT:  (local $7 (ref $Y))
  ;; CHECK-NEXT:  (local $8 (ref $Y))
  ;; CHECK-NEXT: )
  (func $test
    (local (ref $A))
    (local (ref $A))
    (local (ref $A))
    (local (ref $A))
    (local (ref $B))
    (local (ref $X))
    (local (ref $Y))
    (local (ref $Y))
    (local (ref $Y))
  )
)

(module
  ;; Same, but with the A/B and X/Y numbers switched.
  (rec
    ;; CHECK:      (rec
    ;; CHECK-NEXT:  (type $X (sub (struct)))

    ;; CHECK:       (type $A (sub (struct)))
    (type $A (sub (struct)))
    ;; CHECK:       (type $B (sub $A (struct)))
    (type $B (sub $A (struct)))
    (type $X (sub (struct)))
    ;; CHECK:       (type $Y (sub $X (struct)))
    (type $Y (sub $X (struct)))
  )

  ;; CHECK:      (func $test (type $4)
  ;; CHECK-NEXT:  (local $0 (ref $A))
  ;; CHECK-NEXT:  (local $1 (ref $B))
  ;; CHECK-NEXT:  (local $2 (ref $B))
  ;; CHECK-NEXT:  (local $3 (ref $B))
  ;; CHECK-NEXT:  (local $4 (ref $X))
  ;; CHECK-NEXT:  (local $5 (ref $X))
  ;; CHECK-NEXT:  (local $6 (ref $X))
  ;; CHECK-NEXT:  (local $7 (ref $X))
  ;; CHECK-NEXT:  (local $8 (ref $Y))
  ;; CHECK-NEXT: )
  (func $test
    (local (ref $A))
    (local (ref $B))
    (local (ref $B))
    (local (ref $B))
    (local (ref $X))
    (local (ref $X))
    (local (ref $X))
    (local (ref $X))
    (local (ref $Y))
  )
)

(module
  ;; Regression test. ReorderTypes used to collect the types used in the binary
  ;; for their counts, which in this case includes $multi because it is part of
  ;; the rec group. However, GlobalTypeRewriter separately collected only the
  ;; used IR types, which includes a standalone function type instead of $multi.
  ;; The sort then tried to lookup the count for the standalone function type
  ;; and crashed when it couldn't find it.
  (rec
    (type $multi (func (result (ref $A) (ref $B))))
    ;; CHECK:      (rec
    ;; CHECK-NEXT:  (type $A (sub (struct)))
    (type $A (sub (struct)))
    ;; CHECK:       (type $B (sub $A (struct)))
    (type $B (sub $A (struct)))
  )
  ;; CHECK:      (func $test (type $3) (param $0 i32) (result (ref $A) (ref $B))
  ;; CHECK-NEXT:  (unreachable)
  ;; CHECK-NEXT: )
  (func $test (param i32) (result (ref $A) (ref $B))
    (block (type $multi) (result (ref $A) (ref $B))
      (unreachable)
    )
  )
)
