#ifndef _PRODUCTION_H_INCLUDED_
#define _PRODUCTION_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// Production.h
// ------------
// dragon LR(1) production interface definition
//                                                         
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2007 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: Production
// 
// Description: grammar production element modelling
//
///////////////////////////////////////////////////////////////////////////////

#include <lfcbase/Exception.h>
#include <lfcbase/Chain.h>
#include <lfcbase/ListT.h>

class Production {
public:
    
    Production();
    Production(const Production& p);
    ~Production();
    
    void addSymbol(const Chain& token, bool isTerm);
    unsigned long getMaxPos() const;
    bool getSymbolAtPos(Chain& s, int pos) const;
    bool isTermAtPos(int pos) const;

    void setAction(const Chain& name);
    void setName(const Chain& name);
    void setId(unsigned long pid);

    const Chain& getAction() const;
    const Chain& getName() const;
    unsigned long getId() const;

    Chain asChain() const;

    Production& operator = (const Production& p);
    bool operator == (const Production& t) const;

private:
    
    Chain _action;
    Chain _name;	
    unsigned long _maxPos;
    unsigned long _pid;

    class Symbol {
	
    public:
	
	Symbol();
	Symbol(const Symbol& s);
	Symbol (const Chain& name, bool isTerm);
	~Symbol();

	const Chain& getName() const;
	bool isTerm() const;

	Symbol& operator = (const Symbol& s); 
	
    private:
	
	Chain _name;
	bool _isTerm;   
    };
    ListT<Symbol> _symbolList;
   
};


#endif














