#ifndef _LR0HASH_H_INCLUDED_
#define _LR0HASH_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// LR0Hash.h
// -----------
// dragon transiaiton hash interface defintion
//                                                         
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2007 Bjoern Lemke
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.  If not, write to
// the Free Software Foundation, 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// INTERFACE MODULE
//
// Class: LR0Hash
// 
// Description: 
//
///////////////////////////////////////////////////////////////////////////////

#include <lfcbase/SetT.h>
#include <lfcbase/Chain.h>

#include "LR0Element.h"

class LR0Hash {
public:
    
    LR0Hash();
    LR0Hash(const SetT<LR0Element>& LR0Set);
    LR0Hash(const SetT<LR0Element>& LR0Set, int id);
    ~LR0Hash();
    
    int getId() const;
    
    SetT<LR0Element>& getSet() const;
    
    LR0Hash& operator = (const LR0Hash& h);
    bool operator == (const LR0Hash& h) const;
    
    
private:
    
    int _id;
    SetT<LR0Element> _LR0Set;
    
};

#endif





