! This file is part of dftd4.
! SPDX-Identifier: LGPL-3.0-or-later
!
! dftd4 is free software: you can redistribute it and/or modify it under
! the terms of the Lesser GNU General Public License as published by
! the Free Software Foundation, either version 3 of the License, or
! (at your option) any later version.
!
! dftd4 is distributed in the hope that it will be useful,
! but WITHOUT ANY WARRANTY; without even the implied warranty of
! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
! Lesser GNU General Public License for more details.
!
! You should have received a copy of the Lesser GNU General Public License
! along with dftd4.  If not, see <https://www.gnu.org/licenses/>.

module dftd4_data_wfpair
   use mctc_env, only : wp
   use mctc_io_symbols, only : to_number
   implicit none
   private

   public :: get_wfpair_val


   !> Get pairwise CN weighting factors
   interface get_wfpair_val
      module procedure :: get_wfpair_val_num
      module procedure :: get_wfpair_val_sym
   end interface get_wfpair_val


   integer, parameter :: max_elem = 118

   !  Reduces weight factor exponents to improve smoothness of the potential
   !  Head-Gordon ...
   real(wp), protected :: weight_factors(max_elem, max_elem)
   data weight_factors(:, 1) / &
   & 3.673526786_wp, 6.000000000_wp, 1.133125000_wp, 0.758750000_wp, & 
   & 2.256250000_wp, 2.978258929_wp, 3.566562500_wp, 4.395535714_wp, & 
   & 4.983839286_wp, 5.786071429_wp, 0.651785714_wp, 0.357633929_wp, & 
   & 1.614464286_wp, 1.881875000_wp, 2.202767857_wp, 2.496919643_wp, & 
   & 2.817812500_wp, 3.005000000_wp, 0.330892857_wp, 0.945937500_wp, & 
   & 0.732008929_wp, 0.812232143_wp, 0.785491071_wp, 0.919196429_wp, & 
   & 0.544821429_wp, 0.571562500_wp, 1.079642857_wp, 1.079642857_wp, & 
   & 1.667946429_wp, 1.293571429_wp, 1.694687500_wp, 1.828392857_wp, & 
   & 2.069062500_wp, 2.229508929_wp, 2.416696429_wp, 2.523660714_wp, & 
   & 0.250669643_wp, 0.865714286_wp, 0.598303571_wp, 0.812232143_wp, & 
   & 0.785491071_wp, 1.106383929_wp, 0.384375000_wp, 0.544821429_wp, & 
   & 1.106383929_wp, 1.133125000_wp, 1.614464286_wp, 2.684107143_wp, & 
   & 1.587723214_wp, 1.587723214_wp, 1.774910714_wp, 1.881875000_wp, & 
   & 2.042321429_wp, 2.069062500_wp, 0.250669643_wp, 1.159866071_wp, & 
   & 0.544821429_wp, 1.881875000_wp, 0.464598214_wp, 0.491339286_wp, & 
   & 0.491339286_wp, 0.491339286_wp, 0.651785714_wp, 0.625044643_wp, & 
   & 0.544821429_wp, 0.571562500_wp, 0.518080357_wp, 0.518080357_wp, & 
   & 0.544821429_wp, 0.571562500_wp, 0.598303571_wp, 0.972678571_wp, & 
   & 1.026160714_wp, 0.518080357_wp, 0.464598214_wp, 0.598303571_wp, & 
   & 2.202767857_wp, 2.042321429_wp, 1.908616071_wp, 2.256250000_wp, & 
   & 1.614464286_wp, 1.507500000_wp, 1.667946429_wp, 1.774910714_wp, & 
   & 1.881875000_wp, 1.935357143_wp, 0.785491071_wp, 0.812232143_wp, & 
   & 0.785491071_wp, 1.106383929_wp, 1.079642857_wp, 0.892455357_wp, & 
   & 1.293571429_wp, 0.758750000_wp, 1.828392857_wp, 0.945937500_wp, & 
   & 1.079642857_wp, 2.924776786_wp, 0.732008929_wp, 1.052901786_wp, & 
   & 1.079642857_wp, 1.106383929_wp, 1.079642857_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 2) / &
   & 6.000000000_wp, 6.000000000_wp, 2.069062500_wp, 1.026160714_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.919196429_wp, 0.544821429_wp, & 
   & 5.277991071_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.705267857_wp, 3.005000000_wp, & 
   & 1.213348214_wp, 1.320312500_wp, 1.347053571_wp, 1.266830357_wp, & 
   & 0.732008929_wp, 0.732008929_wp, 1.774910714_wp, 1.721428571_wp, & 
   & 4.074642857_wp, 1.881875000_wp, 5.277991071_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 0.464598214_wp, 2.764330357_wp, 1.026160714_wp, 1.320312500_wp, & 
   & 1.320312500_wp, 1.587723214_wp, 0.491339286_wp, 0.705267857_wp, & 
   & 1.694687500_wp, 1.507500000_wp, 4.101383929_wp, 2.015580357_wp, & 
   & 4.903616071_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.785491071_wp, 1.748169643_wp, & 
   & 0.865714286_wp, 6.000000000_wp, 0.705267857_wp, 0.732008929_wp, & 
   & 0.732008929_wp, 0.732008929_wp, 1.052901786_wp, 0.892455357_wp, & 
   & 0.785491071_wp, 0.812232143_wp, 0.758750000_wp, 0.758750000_wp, & 
   & 0.785491071_wp, 0.812232143_wp, 0.838973214_wp, 1.667946429_wp, & 
   & 1.801651786_wp, 0.705267857_wp, 0.598303571_wp, 0.785491071_wp, & 
   & 2.336473214_wp, 3.058482143_wp, 6.000000000_wp, 3.085223214_wp, & 
   & 4.716428571_wp, 5.358214286_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 1.748169643_wp, 3.218928571_wp, & 
   & 1.988839286_wp, 2.791071429_wp, 3.780491071_wp, 1.240089286_wp, & 
   & 3.245669643_wp, 2.710848214_wp, 2.443437500_wp, 2.550401786_wp, & 
   & 3.593303571_wp, 3.459598214_wp, 2.764330357_wp, 3.620044643_wp, & 
   & 3.673526786_wp, 3.700267857_wp, 2.550401786_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 3) / &
   & 1.133125000_wp, 2.069062500_wp, 0.250669643_wp, 0.384375000_wp, & 
   & 0.544821429_wp, 0.812232143_wp, 0.838973214_wp, 1.026160714_wp, & 
   & 1.373794643_wp, 1.641205357_wp, 0.250669643_wp, 0.250669643_wp, & 
   & 0.357633929_wp, 0.464598214_wp, 0.464598214_wp, 0.518080357_wp, & 
   & 0.571562500_wp, 0.678526786_wp, 0.116964286_wp, 0.223928571_wp, & 
   & 0.170446429_wp, 0.143705357_wp, 0.143705357_wp, 0.277410714_wp, & 
   & 0.277410714_wp, 0.304151786_wp, 0.277410714_wp, 0.277410714_wp, & 
   & 0.411116071_wp, 0.330892857_wp, 0.384375000_wp, 0.437857143_wp, & 
   & 0.464598214_wp, 0.437857143_wp, 0.491339286_wp, 0.571562500_wp, & 
   & 0.090223214_wp, 0.170446429_wp, 0.197187500_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.277410714_wp, 0.304151786_wp, 0.330892857_wp, & 
   & 0.250669643_wp, 0.304151786_wp, 0.411116071_wp, 0.330892857_wp, & 
   & 0.330892857_wp, 0.384375000_wp, 0.411116071_wp, 0.411116071_wp, & 
   & 0.437857143_wp, 0.437857143_wp, 0.090223214_wp, 0.197187500_wp, & 
   & 0.170446429_wp, 0.384375000_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.116964286_wp, 0.143705357_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.143705357_wp, 0.170446429_wp, & 
   & 0.250669643_wp, 0.330892857_wp, 0.357633929_wp, 0.330892857_wp, & 
   & 0.330892857_wp, 0.437857143_wp, 0.437857143_wp, 0.411116071_wp, & 
   & 0.330892857_wp, 0.357633929_wp, 0.411116071_wp, 0.384375000_wp, & 
   & 0.384375000_wp, 0.437857143_wp, 0.090223214_wp, 0.116964286_wp, & 
   & 0.223928571_wp, 0.197187500_wp, 0.170446429_wp, 0.197187500_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.277410714_wp, 0.250669643_wp, & 
   & 0.143705357_wp, 0.250669643_wp, 0.197187500_wp, 0.170446429_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.223928571_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 4) / &
   & 0.758750000_wp, 1.026160714_wp, 0.384375000_wp, 0.330892857_wp, & 
   & 0.464598214_wp, 0.518080357_wp, 0.544821429_wp, 0.598303571_wp, & 
   & 0.705267857_wp, 0.812232143_wp, 0.304151786_wp, 0.223928571_wp, & 
   & 0.304151786_wp, 0.304151786_wp, 0.304151786_wp, 0.330892857_wp, & 
   & 0.384375000_wp, 0.437857143_wp, 0.223928571_wp, 0.250669643_wp, & 
   & 0.250669643_wp, 0.277410714_wp, 0.223928571_wp, 0.277410714_wp, & 
   & 0.223928571_wp, 0.250669643_wp, 0.330892857_wp, 0.330892857_wp, & 
   & 0.304151786_wp, 0.330892857_wp, 0.277410714_wp, 0.304151786_wp, & 
   & 0.277410714_wp, 0.304151786_wp, 0.330892857_wp, 0.357633929_wp, & 
   & 0.170446429_wp, 0.223928571_wp, 0.250669643_wp, 0.277410714_wp, & 
   & 0.277410714_wp, 0.277410714_wp, 0.170446429_wp, 0.223928571_wp, & 
   & 0.277410714_wp, 0.304151786_wp, 0.277410714_wp, 0.277410714_wp, & 
   & 0.277410714_wp, 0.277410714_wp, 0.250669643_wp, 0.250669643_wp, & 
   & 0.277410714_wp, 0.277410714_wp, 0.116964286_wp, 0.197187500_wp, & 
   & 0.223928571_wp, 0.250669643_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.250669643_wp, 0.250669643_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.223928571_wp, 0.223928571_wp, 0.250669643_wp, 0.330892857_wp, & 
   & 0.304151786_wp, 0.250669643_wp, 0.197187500_wp, 0.223928571_wp, & 
   & 0.277410714_wp, 0.277410714_wp, 0.277410714_wp, 0.277410714_wp, & 
   & 0.277410714_wp, 0.250669643_wp, 0.250669643_wp, 0.223928571_wp, & 
   & 0.250669643_wp, 0.250669643_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.170446429_wp, 0.223928571_wp, 0.223928571_wp, 0.223928571_wp, & 
   & 0.223928571_wp, 0.197187500_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.223928571_wp, 0.197187500_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.170446429_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 5) / &
   & 2.256250000_wp, 6.000000000_wp, 0.544821429_wp, 0.464598214_wp, & 
   & 1.480758929_wp, 1.935357143_wp, 2.630625000_wp, 3.539821429_wp, & 
   & 4.021160714_wp, 4.876875000_wp, 0.357633929_wp, 0.197187500_wp, & 
   & 0.972678571_wp, 1.320312500_wp, 1.881875000_wp, 2.176026786_wp, & 
   & 2.443437500_wp, 2.523660714_wp, 0.143705357_wp, 0.437857143_wp, & 
   & 0.330892857_wp, 0.384375000_wp, 0.304151786_wp, 0.544821429_wp, & 
   & 0.357633929_wp, 0.357633929_wp, 0.491339286_wp, 0.518080357_wp, & 
   & 0.972678571_wp, 0.598303571_wp, 1.052901786_wp, 1.320312500_wp, & 
   & 1.721428571_wp, 1.988839286_wp, 2.202767857_wp, 2.176026786_wp, & 
   & 0.116964286_wp, 0.411116071_wp, 0.330892857_wp, 0.384375000_wp, & 
   & 0.357633929_wp, 0.518080357_wp, 0.250669643_wp, 0.357633929_wp, & 
   & 0.464598214_wp, 0.544821429_wp, 0.945937500_wp, 0.625044643_wp, & 
   & 0.999419643_wp, 1.106383929_wp, 1.400535714_wp, 1.667946429_wp, & 
   & 1.748169643_wp, 1.774910714_wp, 0.116964286_wp, 0.384375000_wp, & 
   & 0.277410714_wp, 1.560982143_wp, 0.250669643_wp, 0.250669643_wp, & 
   & 0.250669643_wp, 0.250669643_wp, 0.330892857_wp, 0.304151786_wp, & 
   & 0.277410714_wp, 0.277410714_wp, 0.250669643_wp, 0.277410714_wp, & 
   & 0.277410714_wp, 0.277410714_wp, 0.304151786_wp, 0.491339286_wp, & 
   & 0.464598214_wp, 0.330892857_wp, 0.304151786_wp, 0.384375000_wp, & 
   & 0.651785714_wp, 1.159866071_wp, 1.454017857_wp, 0.919196429_wp, & 
   & 1.855133929_wp, 0.945937500_wp, 1.213348214_wp, 1.454017857_wp, & 
   & 1.721428571_wp, 1.641205357_wp, 0.357633929_wp, 0.384375000_wp, & 
   & 0.357633929_wp, 0.437857143_wp, 0.357633929_wp, 0.411116071_wp, & 
   & 0.919196429_wp, 0.330892857_wp, 0.732008929_wp, 0.411116071_wp, & 
   & 0.357633929_wp, 0.705267857_wp, 0.330892857_wp, 0.357633929_wp, & 
   & 0.384375000_wp, 0.411116071_wp, 0.464598214_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 6) / &
   & 2.978258929_wp, 6.000000000_wp, 0.812232143_wp, 0.518080357_wp, & 
   & 1.935357143_wp, 1.828392857_wp, 2.336473214_wp, 3.245669643_wp, & 
   & 3.887455357_wp, 4.716428571_wp, 0.384375000_wp, 0.250669643_wp, & 
   & 1.480758929_wp, 1.534241071_wp, 1.694687500_wp, 1.855133929_wp, & 
   & 2.069062500_wp, 2.309732143_wp, 0.170446429_wp, 1.026160714_wp, & 
   & 0.518080357_wp, 0.625044643_wp, 0.491339286_wp, 0.651785714_wp, & 
   & 0.384375000_wp, 0.384375000_wp, 0.812232143_wp, 0.812232143_wp, & 
   & 1.560982143_wp, 0.892455357_wp, 1.507500000_wp, 1.480758929_wp, & 
   & 1.614464286_wp, 1.694687500_wp, 1.855133929_wp, 1.935357143_wp, & 
   & 0.143705357_wp, 0.865714286_wp, 0.464598214_wp, 0.625044643_wp, & 
   & 0.571562500_wp, 0.785491071_wp, 0.250669643_wp, 0.384375000_wp, & 
   & 0.758750000_wp, 0.812232143_wp, 1.454017857_wp, 0.972678571_wp, & 
   & 1.427276786_wp, 1.347053571_wp, 1.400535714_wp, 1.454017857_wp, & 
   & 1.534241071_wp, 1.587723214_wp, 0.116964286_wp, 0.838973214_wp, & 
   & 0.411116071_wp, 1.454017857_wp, 0.304151786_wp, 0.304151786_wp, & 
   & 0.304151786_wp, 0.330892857_wp, 0.491339286_wp, 0.384375000_wp, & 
   & 0.357633929_wp, 0.357633929_wp, 0.330892857_wp, 0.330892857_wp, & 
   & 0.330892857_wp, 0.357633929_wp, 0.384375000_wp, 0.838973214_wp, & 
   & 0.812232143_wp, 0.357633929_wp, 0.304151786_wp, 0.411116071_wp, & 
   & 1.159866071_wp, 1.293571429_wp, 1.507500000_wp, 1.560982143_wp, & 
   & 1.347053571_wp, 1.347053571_wp, 1.347053571_wp, 1.373794643_wp, & 
   & 1.427276786_wp, 1.507500000_wp, 0.838973214_wp, 0.999419643_wp, & 
   & 0.705267857_wp, 0.919196429_wp, 0.838973214_wp, 0.518080357_wp, & 
   & 0.812232143_wp, 0.544821429_wp, 1.347053571_wp, 1.186607143_wp, & 
   & 1.026160714_wp, 0.812232143_wp, 1.774910714_wp, 1.454017857_wp, & 
   & 1.427276786_wp, 1.507500000_wp, 1.106383929_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 7) / &
   & 3.566562500_wp, 6.000000000_wp, 0.838973214_wp, 0.544821429_wp, & 
   & 2.630625000_wp, 2.336473214_wp, 3.352633929_wp, 5.438437500_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.437857143_wp, 0.250669643_wp, & 
   & 2.095803571_wp, 2.309732143_wp, 2.684107143_wp, 3.058482143_wp, & 
   & 3.593303571_wp, 3.753750000_wp, 0.197187500_wp, 1.079642857_wp, & 
   & 0.625044643_wp, 0.705267857_wp, 0.625044643_wp, 0.678526786_wp, & 
   & 0.411116071_wp, 0.411116071_wp, 0.919196429_wp, 0.919196429_wp, & 
   & 1.908616071_wp, 0.999419643_wp, 2.256250000_wp, 2.282991071_wp, & 
   & 2.496919643_wp, 2.710848214_wp, 3.058482143_wp, 3.031741071_wp, & 
   & 0.143705357_wp, 0.919196429_wp, 0.518080357_wp, 0.705267857_wp, & 
   & 0.651785714_wp, 0.865714286_wp, 0.277410714_wp, 0.384375000_wp, & 
   & 0.865714286_wp, 0.892455357_wp, 1.881875000_wp, 1.079642857_wp, & 
   & 2.095803571_wp, 1.988839286_wp, 2.095803571_wp, 2.229508929_wp, & 
   & 2.389955357_wp, 2.443437500_wp, 0.143705357_wp, 1.106383929_wp, & 
   & 0.464598214_wp, 2.256250000_wp, 0.384375000_wp, 0.384375000_wp, & 
   & 0.384375000_wp, 0.384375000_wp, 0.571562500_wp, 0.464598214_wp, & 
   & 0.411116071_wp, 0.437857143_wp, 0.411116071_wp, 0.411116071_wp, & 
   & 0.411116071_wp, 0.437857143_wp, 0.464598214_wp, 0.919196429_wp, & 
   & 0.919196429_wp, 0.384375000_wp, 0.330892857_wp, 0.437857143_wp, & 
   & 1.240089286_wp, 1.320312500_wp, 2.256250000_wp, 1.667946429_wp, & 
   & 2.095803571_wp, 1.908616071_wp, 1.988839286_wp, 2.069062500_wp, & 
   & 2.176026786_wp, 2.229508929_wp, 0.865714286_wp, 0.999419643_wp, & 
   & 0.838973214_wp, 1.427276786_wp, 1.694687500_wp, 0.678526786_wp, & 
   & 1.480758929_wp, 0.678526786_wp, 1.240089286_wp, 1.266830357_wp, & 
   & 1.587723214_wp, 1.774910714_wp, 2.042321429_wp, 1.881875000_wp, & 
   & 1.855133929_wp, 1.881875000_wp, 1.320312500_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 8) / &
   & 4.395535714_wp, 6.000000000_wp, 1.026160714_wp, 0.598303571_wp, & 
   & 3.539821429_wp, 3.245669643_wp, 5.438437500_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.518080357_wp, 0.304151786_wp, & 
   & 3.325892857_wp, 3.780491071_wp, 5.919776786_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.223928571_wp, 1.373794643_wp, & 
   & 0.678526786_wp, 0.785491071_wp, 0.705267857_wp, 0.758750000_wp, & 
   & 0.437857143_wp, 0.437857143_wp, 0.999419643_wp, 0.999419643_wp, & 
   & 2.256250000_wp, 1.079642857_wp, 3.218928571_wp, 3.940937500_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 0.197187500_wp, 1.052901786_wp, 0.571562500_wp, 0.758750000_wp, & 
   & 0.732008929_wp, 0.919196429_wp, 0.304151786_wp, 0.437857143_wp, & 
   & 0.945937500_wp, 0.945937500_wp, 2.309732143_wp, 1.159866071_wp, & 
   & 3.058482143_wp, 3.459598214_wp, 5.545401786_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.170446429_wp, 1.159866071_wp, & 
   & 0.491339286_wp, 6.000000000_wp, 0.411116071_wp, 0.411116071_wp, & 
   & 0.411116071_wp, 0.437857143_wp, 0.625044643_wp, 0.518080357_wp, & 
   & 0.464598214_wp, 0.464598214_wp, 0.437857143_wp, 0.437857143_wp, & 
   & 0.464598214_wp, 0.464598214_wp, 0.491339286_wp, 0.972678571_wp, & 
   & 0.999419643_wp, 0.411116071_wp, 0.357633929_wp, 0.491339286_wp, & 
   & 1.347053571_wp, 1.480758929_wp, 4.903616071_wp, 1.801651786_wp, & 
   & 2.951517857_wp, 2.924776786_wp, 4.903616071_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.945937500_wp, 2.496919643_wp, & 
   & 1.052901786_wp, 1.587723214_wp, 2.042321429_wp, 0.732008929_wp, & 
   & 1.828392857_wp, 0.812232143_wp, 1.400535714_wp, 1.507500000_wp, & 
   & 2.149285714_wp, 2.042321429_wp, 0.732008929_wp, 2.550401786_wp, & 
   & 2.523660714_wp, 2.470178571_wp, 1.507500000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 9) / &
   & 4.983839286_wp, 6.000000000_wp, 1.373794643_wp, 0.705267857_wp, & 
   & 4.021160714_wp, 3.887455357_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.625044643_wp, 0.357633929_wp, & 
   & 3.620044643_wp, 4.181607143_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.384375000_wp, 1.774910714_wp, & 
   & 0.785491071_wp, 0.892455357_wp, 0.838973214_wp, 0.919196429_wp, & 
   & 0.518080357_wp, 0.518080357_wp, 1.159866071_wp, 1.159866071_wp, & 
   & 2.630625000_wp, 1.240089286_wp, 3.780491071_wp, 4.368794643_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 0.250669643_wp, 1.293571429_wp, 0.651785714_wp, 0.892455357_wp, & 
   & 0.838973214_wp, 1.052901786_wp, 0.357633929_wp, 0.491339286_wp, & 
   & 1.133125000_wp, 1.052901786_wp, 2.630625000_wp, 1.347053571_wp, & 
   & 3.566562500_wp, 3.753750000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.384375000_wp, 1.347053571_wp, & 
   & 0.571562500_wp, 6.000000000_wp, 0.464598214_wp, 0.491339286_wp, & 
   & 0.491339286_wp, 0.491339286_wp, 0.705267857_wp, 0.598303571_wp, & 
   & 0.544821429_wp, 0.544821429_wp, 0.518080357_wp, 0.518080357_wp, & 
   & 0.518080357_wp, 0.544821429_wp, 0.571562500_wp, 1.106383929_wp, & 
   & 1.159866071_wp, 0.491339286_wp, 0.437857143_wp, 0.571562500_wp, & 
   & 1.560982143_wp, 1.774910714_wp, 5.625625000_wp, 2.095803571_wp, & 
   & 3.406116071_wp, 3.165446429_wp, 5.331473214_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 1.106383929_wp, 2.496919643_wp, & 
   & 1.400535714_wp, 1.855133929_wp, 2.389955357_wp, 0.865714286_wp, & 
   & 2.149285714_wp, 1.801651786_wp, 1.748169643_wp, 1.694687500_wp, & 
   & 2.309732143_wp, 2.336473214_wp, 2.122544643_wp, 2.550401786_wp, & 
   & 2.523660714_wp, 2.603883929_wp, 1.774910714_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 10) / &
   & 5.786071429_wp, 6.000000000_wp, 1.641205357_wp, 0.812232143_wp, & 
   & 4.876875000_wp, 4.716428571_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.732008929_wp, 0.437857143_wp, & 
   & 4.235089286_wp, 5.277991071_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.678526786_wp, 2.550401786_wp, & 
   & 0.919196429_wp, 1.026160714_wp, 0.999419643_wp, 1.079642857_wp, & 
   & 0.598303571_wp, 0.571562500_wp, 1.347053571_wp, 1.320312500_wp, & 
   & 3.058482143_wp, 1.427276786_wp, 4.181607143_wp, 5.652366071_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 0.357633929_wp, 2.149285714_wp, 0.758750000_wp, 1.026160714_wp, & 
   & 0.999419643_wp, 1.186607143_wp, 0.384375000_wp, 0.544821429_wp, & 
   & 1.293571429_wp, 1.186607143_wp, 3.085223214_wp, 1.534241071_wp, & 
   & 3.940937500_wp, 4.876875000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 1.079642857_wp, 1.400535714_wp, & 
   & 0.651785714_wp, 6.000000000_wp, 0.544821429_wp, 0.544821429_wp, & 
   & 0.571562500_wp, 0.571562500_wp, 0.812232143_wp, 0.678526786_wp, & 
   & 0.598303571_wp, 0.625044643_wp, 0.571562500_wp, 0.598303571_wp, & 
   & 0.598303571_wp, 0.625044643_wp, 0.651785714_wp, 1.240089286_wp, & 
   & 1.373794643_wp, 0.544821429_wp, 0.491339286_wp, 0.625044643_wp, & 
   & 1.774910714_wp, 2.095803571_wp, 6.000000000_wp, 2.363214286_wp, & 
   & 3.780491071_wp, 3.940937500_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 1.320312500_wp, 2.871294643_wp, & 
   & 1.534241071_wp, 2.095803571_wp, 2.737589286_wp, 0.919196429_wp, & 
   & 2.470178571_wp, 2.042321429_wp, 1.935357143_wp, 1.935357143_wp, & 
   & 2.844553571_wp, 2.710848214_wp, 2.336473214_wp, 3.031741071_wp, & 
   & 3.031741071_wp, 3.005000000_wp, 1.935357143_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 11) / &
   & 0.651785714_wp, 0.919196429_wp, 0.250669643_wp, 0.304151786_wp, & 
   & 0.357633929_wp, 0.384375000_wp, 0.437857143_wp, 0.518080357_wp, & 
   & 0.625044643_wp, 0.732008929_wp, 0.223928571_wp, 0.250669643_wp, & 
   & 0.250669643_wp, 0.223928571_wp, 0.250669643_wp, 0.277410714_wp, & 
   & 0.304151786_wp, 0.330892857_wp, 0.170446429_wp, 0.197187500_wp, & 
   & 0.170446429_wp, 0.143705357_wp, 0.143705357_wp, 0.250669643_wp, & 
   & 0.250669643_wp, 0.250669643_wp, 0.250669643_wp, 0.250669643_wp, & 
   & 0.223928571_wp, 0.277410714_wp, 0.197187500_wp, 0.223928571_wp, & 
   & 0.223928571_wp, 0.223928571_wp, 0.250669643_wp, 0.277410714_wp, & 
   & 0.143705357_wp, 0.197187500_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.223928571_wp, 0.197187500_wp, 0.223928571_wp, & 
   & 0.223928571_wp, 0.250669643_wp, 0.223928571_wp, 0.250669643_wp, & 
   & 0.223928571_wp, 0.223928571_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.223928571_wp, 0.223928571_wp, 0.143705357_wp, 0.170446429_wp, & 
   & 0.143705357_wp, 0.197187500_wp, 0.090223214_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.143705357_wp, 0.143705357_wp, 0.197187500_wp, & 
   & 0.223928571_wp, 0.197187500_wp, 0.197187500_wp, 0.223928571_wp, & 
   & 0.223928571_wp, 0.223928571_wp, 0.223928571_wp, 0.223928571_wp, & 
   & 0.223928571_wp, 0.197187500_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.143705357_wp, 0.197187500_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.143705357_wp, 0.197187500_wp, 0.170446429_wp, 0.143705357_wp, & 
   & 0.170446429_wp, 0.143705357_wp, 0.170446429_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 12) / &
   & 0.357633929_wp, 0.544821429_wp, 0.250669643_wp, 0.223928571_wp, & 
   & 0.197187500_wp, 0.250669643_wp, 0.250669643_wp, 0.304151786_wp, & 
   & 0.357633929_wp, 0.437857143_wp, 0.250669643_wp, 0.090223214_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.090223214_wp, 0.116964286_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, 0.116964286_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.116964286_wp, 0.143705357_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.063482143_wp, 0.090223214_wp, 0.090223214_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.116964286_wp, 0.116964286_wp, 0.143705357_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.090223214_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.036741071_wp, 0.063482143_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.116964286_wp, 0.090223214_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.090223214_wp, 0.116964286_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 13) / &
   & 1.614464286_wp, 5.277991071_wp, 0.357633929_wp, 0.304151786_wp, & 
   & 0.972678571_wp, 1.480758929_wp, 2.095803571_wp, 3.325892857_wp, & 
   & 3.620044643_wp, 4.235089286_wp, 0.250669643_wp, 0.116964286_wp, & 
   & 1.855133929_wp, 0.865714286_wp, 2.176026786_wp, 2.309732143_wp, & 
   & 2.470178571_wp, 2.657366071_wp, 0.090223214_wp, 0.277410714_wp, & 
   & 0.223928571_wp, 0.223928571_wp, 0.170446429_wp, 0.357633929_wp, & 
   & 0.223928571_wp, 0.250669643_wp, 0.304151786_wp, 0.330892857_wp, & 
   & 0.571562500_wp, 0.384375000_wp, 1.801651786_wp, 0.945937500_wp, & 
   & 2.069062500_wp, 2.176026786_wp, 2.256250000_wp, 2.389955357_wp, & 
   & 0.063482143_wp, 0.250669643_wp, 0.223928571_wp, 0.223928571_wp, & 
   & 0.223928571_wp, 0.330892857_wp, 0.170446429_wp, 0.250669643_wp, & 
   & 0.304151786_wp, 0.357633929_wp, 0.571562500_wp, 0.384375000_wp, & 
   & 1.667946429_wp, 0.625044643_wp, 1.935357143_wp, 1.988839286_wp, & 
   & 2.042321429_wp, 2.149285714_wp, 0.063482143_wp, 0.223928571_wp, & 
   & 0.197187500_wp, 1.988839286_wp, 0.143705357_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.197187500_wp, 0.277410714_wp, & 
   & 0.277410714_wp, 0.223928571_wp, 0.197187500_wp, 0.277410714_wp, & 
   & 0.384375000_wp, 0.651785714_wp, 1.293571429_wp, 0.544821429_wp, & 
   & 0.437857143_wp, 0.491339286_wp, 1.908616071_wp, 1.908616071_wp, & 
   & 1.988839286_wp, 2.069062500_wp, 0.197187500_wp, 0.223928571_wp, & 
   & 0.223928571_wp, 0.197187500_wp, 0.197187500_wp, 0.250669643_wp, & 
   & 1.079642857_wp, 0.197187500_wp, 0.357633929_wp, 0.250669643_wp, & 
   & 0.197187500_wp, 0.304151786_wp, 0.223928571_wp, 0.197187500_wp, & 
   & 0.223928571_wp, 0.223928571_wp, 0.277410714_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 14) / &
   & 1.881875000_wp, 6.000000000_wp, 0.464598214_wp, 0.304151786_wp, & 
   & 1.320312500_wp, 1.534241071_wp, 2.309732143_wp, 3.780491071_wp, & 
   & 4.181607143_wp, 5.277991071_wp, 0.223928571_wp, 0.116964286_wp, & 
   & 0.865714286_wp, 1.133125000_wp, 1.908616071_wp, 2.496919643_wp, & 
   & 2.844553571_wp, 2.844553571_wp, 0.090223214_wp, 0.357633929_wp, & 
   & 0.250669643_wp, 0.277410714_wp, 0.223928571_wp, 0.411116071_wp, & 
   & 0.250669643_wp, 0.250669643_wp, 0.384375000_wp, 0.437857143_wp, & 
   & 0.812232143_wp, 0.491339286_wp, 1.801651786_wp, 1.186607143_wp, & 
   & 1.962098214_wp, 2.389955357_wp, 2.523660714_wp, 2.309732143_wp, & 
   & 0.063482143_wp, 0.330892857_wp, 0.250669643_wp, 0.277410714_wp, & 
   & 0.277410714_wp, 0.411116071_wp, 0.170446429_wp, 0.250669643_wp, & 
   & 0.357633929_wp, 0.437857143_wp, 0.812232143_wp, 0.491339286_wp, & 
   & 1.855133929_wp, 0.945937500_wp, 1.427276786_wp, 1.962098214_wp, & 
   & 2.202767857_wp, 1.908616071_wp, 0.063482143_wp, 0.330892857_wp, & 
   & 0.223928571_wp, 1.667946429_wp, 0.170446429_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.250669643_wp, 0.223928571_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.223928571_wp, 0.411116071_wp, & 
   & 0.384375000_wp, 0.223928571_wp, 0.197187500_wp, 0.277410714_wp, & 
   & 0.491339286_wp, 0.785491071_wp, 1.373794643_wp, 0.732008929_wp, & 
   & 1.721428571_wp, 0.785491071_wp, 1.213348214_wp, 1.694687500_wp, & 
   & 2.042321429_wp, 1.801651786_wp, 0.304151786_wp, 0.304151786_wp, & 
   & 0.277410714_wp, 0.277410714_wp, 0.732008929_wp, 0.357633929_wp, & 
   & 0.785491071_wp, 0.250669643_wp, 0.625044643_wp, 0.330892857_wp, & 
   & 0.250669643_wp, 0.437857143_wp, 0.250669643_wp, 0.250669643_wp, & 
   & 0.277410714_wp, 0.304151786_wp, 0.357633929_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 15) / &
   & 2.202767857_wp, 6.000000000_wp, 0.464598214_wp, 0.304151786_wp, & 
   & 1.881875000_wp, 1.694687500_wp, 2.684107143_wp, 5.919776786_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.250669643_wp, 0.143705357_wp, & 
   & 2.176026786_wp, 1.908616071_wp, 2.630625000_wp, 3.566562500_wp, & 
   & 3.887455357_wp, 4.342053571_wp, 0.090223214_wp, 0.491339286_wp, & 
   & 0.304151786_wp, 0.357633929_wp, 0.250669643_wp, 0.411116071_wp, & 
   & 0.250669643_wp, 0.250669643_wp, 0.464598214_wp, 0.518080357_wp, & 
   & 1.106383929_wp, 0.571562500_wp, 2.015580357_wp, 1.962098214_wp, & 
   & 2.630625000_wp, 3.218928571_wp, 3.432857143_wp, 3.727008929_wp, & 
   & 0.090223214_wp, 0.437857143_wp, 0.304151786_wp, 0.357633929_wp, & 
   & 0.330892857_wp, 0.491339286_wp, 0.170446429_wp, 0.250669643_wp, & 
   & 0.437857143_wp, 0.518080357_wp, 1.133125000_wp, 0.598303571_wp, & 
   & 1.962098214_wp, 1.667946429_wp, 2.470178571_wp, 2.844553571_wp, & 
   & 2.978258929_wp, 3.165446429_wp, 0.063482143_wp, 0.437857143_wp, & 
   & 0.250669643_wp, 2.791071429_wp, 0.197187500_wp, 0.223928571_wp, & 
   & 0.223928571_wp, 0.223928571_wp, 0.304151786_wp, 0.277410714_wp, & 
   & 0.250669643_wp, 0.250669643_wp, 0.223928571_wp, 0.223928571_wp, & 
   & 0.223928571_wp, 0.250669643_wp, 0.250669643_wp, 0.518080357_wp, & 
   & 0.464598214_wp, 0.223928571_wp, 0.197187500_wp, 0.277410714_wp, & 
   & 0.625044643_wp, 0.812232143_wp, 2.309732143_wp, 0.892455357_wp, & 
   & 1.774910714_wp, 1.454017857_wp, 2.416696429_wp, 2.710848214_wp, & 
   & 2.791071429_wp, 2.951517857_wp, 0.411116071_wp, 0.437857143_wp, & 
   & 0.357633929_wp, 0.972678571_wp, 0.919196429_wp, 0.384375000_wp, & 
   & 0.625044643_wp, 0.330892857_wp, 0.838973214_wp, 0.411116071_wp, & 
   & 0.999419643_wp, 0.518080357_wp, 0.304151786_wp, 0.304151786_wp, & 
   & 0.357633929_wp, 0.384375000_wp, 0.437857143_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 16) / &
   & 2.496919643_wp, 6.000000000_wp, 0.518080357_wp, 0.330892857_wp, & 
   & 2.176026786_wp, 1.855133929_wp, 3.058482143_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.277410714_wp, 0.143705357_wp, & 
   & 2.309732143_wp, 2.496919643_wp, 3.566562500_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.116964286_wp, 0.571562500_wp, & 
   & 0.357633929_wp, 0.411116071_wp, 0.304151786_wp, 0.437857143_wp, & 
   & 0.250669643_wp, 0.277410714_wp, 0.544821429_wp, 0.571562500_wp, & 
   & 1.293571429_wp, 0.625044643_wp, 2.122544643_wp, 2.657366071_wp, & 
   & 3.860714286_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 0.090223214_wp, 0.518080357_wp, 0.330892857_wp, 0.411116071_wp, & 
   & 0.384375000_wp, 0.544821429_wp, 0.197187500_wp, 0.277410714_wp, & 
   & 0.518080357_wp, 0.571562500_wp, 1.320312500_wp, 0.678526786_wp, & 
   & 2.069062500_wp, 2.256250000_wp, 3.673526786_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.063482143_wp, 0.598303571_wp, & 
   & 0.304151786_wp, 6.000000000_wp, 0.223928571_wp, 0.250669643_wp, & 
   & 0.250669643_wp, 0.250669643_wp, 0.357633929_wp, 0.304151786_wp, & 
   & 0.277410714_wp, 0.277410714_wp, 0.250669643_wp, 0.250669643_wp, & 
   & 0.250669643_wp, 0.277410714_wp, 0.277410714_wp, 0.571562500_wp, & 
   & 0.518080357_wp, 0.250669643_wp, 0.223928571_wp, 0.277410714_wp, & 
   & 0.732008929_wp, 0.865714286_wp, 3.646785714_wp, 0.999419643_wp, & 
   & 1.881875000_wp, 1.988839286_wp, 3.753750000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.491339286_wp, 0.518080357_wp, & 
   & 0.437857143_wp, 0.999419643_wp, 1.186607143_wp, 0.437857143_wp, & 
   & 0.758750000_wp, 0.357633929_wp, 0.919196429_wp, 0.491339286_wp, & 
   & 1.133125000_wp, 0.598303571_wp, 0.357633929_wp, 0.411116071_wp, & 
   & 1.962098214_wp, 1.721428571_wp, 0.518080357_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 17) / &
   & 2.817812500_wp, 6.000000000_wp, 0.571562500_wp, 0.384375000_wp, & 
   & 2.443437500_wp, 2.069062500_wp, 3.593303571_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.304151786_wp, 0.170446429_wp, & 
   & 2.470178571_wp, 2.844553571_wp, 3.887455357_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.116964286_wp, 0.651785714_wp, & 
   & 0.411116071_wp, 0.464598214_wp, 0.357633929_wp, 0.491339286_wp, & 
   & 0.277410714_wp, 0.304151786_wp, 0.598303571_wp, 0.625044643_wp, & 
   & 1.480758929_wp, 0.705267857_wp, 2.309732143_wp, 3.085223214_wp, & 
   & 4.208348214_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 0.090223214_wp, 0.598303571_wp, 0.384375000_wp, 0.464598214_wp, & 
   & 0.437857143_wp, 0.598303571_wp, 0.197187500_wp, 0.304151786_wp, & 
   & 0.571562500_wp, 0.625044643_wp, 1.507500000_wp, 0.732008929_wp, & 
   & 2.256250000_wp, 2.630625000_wp, 4.021160714_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.090223214_wp, 0.838973214_wp, & 
   & 0.330892857_wp, 6.000000000_wp, 0.250669643_wp, 0.277410714_wp, & 
   & 0.277410714_wp, 0.277410714_wp, 0.384375000_wp, 0.330892857_wp, & 
   & 0.304151786_wp, 0.304151786_wp, 0.277410714_wp, 0.277410714_wp, & 
   & 0.277410714_wp, 0.304151786_wp, 0.330892857_wp, 0.651785714_wp, & 
   & 0.598303571_wp, 0.277410714_wp, 0.250669643_wp, 0.330892857_wp, & 
   & 0.838973214_wp, 0.945937500_wp, 4.689687500_wp, 1.133125000_wp, & 
   & 2.069062500_wp, 2.256250000_wp, 4.101383929_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.571562500_wp, 2.176026786_wp, & 
   & 0.518080357_wp, 1.052901786_wp, 1.293571429_wp, 0.518080357_wp, & 
   & 0.865714286_wp, 0.437857143_wp, 1.133125000_wp, 0.571562500_wp, & 
   & 1.266830357_wp, 0.732008929_wp, 0.411116071_wp, 0.945937500_wp, & 
   & 1.988839286_wp, 1.881875000_wp, 0.625044643_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 18) / &
   & 3.005000000_wp, 6.000000000_wp, 0.678526786_wp, 0.437857143_wp, & 
   & 2.523660714_wp, 2.309732143_wp, 3.753750000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.330892857_wp, 0.197187500_wp, & 
   & 2.657366071_wp, 2.844553571_wp, 4.342053571_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.143705357_wp, 0.758750000_wp, & 
   & 0.464598214_wp, 0.544821429_wp, 0.411116071_wp, 0.544821429_wp, & 
   & 0.330892857_wp, 0.330892857_wp, 0.678526786_wp, 0.705267857_wp, & 
   & 1.614464286_wp, 0.785491071_wp, 2.550401786_wp, 2.898035714_wp, & 
   & 4.636205357_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 0.116964286_wp, 0.678526786_wp, 0.411116071_wp, 0.544821429_wp, & 
   & 0.491339286_wp, 0.678526786_wp, 0.223928571_wp, 0.330892857_wp, & 
   & 0.651785714_wp, 0.705267857_wp, 1.614464286_wp, 0.838973214_wp, & 
   & 2.470178571_wp, 2.470178571_wp, 4.475758929_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.090223214_wp, 0.945937500_wp, & 
   & 0.357633929_wp, 6.000000000_wp, 0.304151786_wp, 0.304151786_wp, & 
   & 0.304151786_wp, 0.304151786_wp, 0.437857143_wp, 0.384375000_wp, & 
   & 0.330892857_wp, 0.330892857_wp, 0.330892857_wp, 0.330892857_wp, & 
   & 0.330892857_wp, 0.330892857_wp, 0.357633929_wp, 0.705267857_wp, & 
   & 0.678526786_wp, 0.304151786_wp, 0.277410714_wp, 0.357633929_wp, & 
   & 0.945937500_wp, 1.079642857_wp, 3.727008929_wp, 1.240089286_wp, & 
   & 2.309732143_wp, 2.229508929_wp, 3.807232143_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.651785714_wp, 2.363214286_wp, & 
   & 0.598303571_wp, 1.159866071_wp, 1.454017857_wp, 0.544821429_wp, & 
   & 1.026160714_wp, 0.491339286_wp, 1.159866071_wp, 0.651785714_wp, & 
   & 1.373794643_wp, 0.892455357_wp, 0.464598214_wp, 1.320312500_wp, & 
   & 2.149285714_wp, 1.935357143_wp, 0.732008929_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 19) / &
   & 0.330892857_wp, 0.705267857_wp, 0.116964286_wp, 0.223928571_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.197187500_wp, 0.223928571_wp, & 
   & 0.384375000_wp, 0.678526786_wp, 0.170446429_wp, 0.090223214_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.143705357_wp, 0.036741071_wp, 0.063482143_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.116964286_wp, 0.090223214_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.063482143_wp, 0.090223214_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, 0.116964286_wp, & 
   & 0.036741071_wp, 0.063482143_wp, 0.063482143_wp, 0.116964286_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.143705357_wp, 0.116964286_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.063482143_wp, 0.090223214_wp, 0.063482143_wp, 0.063482143_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.036741071_wp, 0.036741071_wp, & 
   & 0.063482143_wp, 0.063482143_wp, 0.063482143_wp, 0.090223214_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.063482143_wp, 0.063482143_wp, & 
   & 0.090223214_wp, 0.063482143_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.090223214_wp, 0.063482143_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.063482143_wp, 0.063482143_wp, 0.063482143_wp, 0.063482143_wp, & 
   & 0.063482143_wp, 0.090223214_wp, 0.036741071_wp, 0.036741071_wp, & 
   & 0.036741071_wp, 0.063482143_wp, 0.063482143_wp, 0.063482143_wp, & 
   & 0.063482143_wp, 0.063482143_wp, 0.063482143_wp, 0.063482143_wp, & 
   & 0.063482143_wp, 0.063482143_wp, 0.063482143_wp, 0.063482143_wp, & 
   & 0.063482143_wp, 0.063482143_wp, 0.036741071_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 20) / &
   & 0.945937500_wp, 3.005000000_wp, 0.223928571_wp, 0.250669643_wp, & 
   & 0.437857143_wp, 1.026160714_wp, 1.079642857_wp, 1.373794643_wp, & 
   & 1.774910714_wp, 2.550401786_wp, 0.197187500_wp, 0.116964286_wp, & 
   & 0.277410714_wp, 0.357633929_wp, 0.491339286_wp, 0.571562500_wp, & 
   & 0.651785714_wp, 0.758750000_wp, 0.063482143_wp, 0.170446429_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.116964286_wp, 0.223928571_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.223928571_wp, 0.223928571_wp, & 
   & 0.330892857_wp, 0.277410714_wp, 0.304151786_wp, 0.357633929_wp, & 
   & 0.437857143_wp, 0.491339286_wp, 0.544821429_wp, 0.598303571_wp, & 
   & 0.036741071_wp, 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.223928571_wp, 0.116964286_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.250669643_wp, 0.330892857_wp, 0.277410714_wp, & 
   & 0.250669643_wp, 0.304151786_wp, 0.357633929_wp, 0.411116071_wp, & 
   & 0.437857143_wp, 0.464598214_wp, 0.036741071_wp, 0.143705357_wp, & 
   & 0.116964286_wp, 0.384375000_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, 0.143705357_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.143705357_wp, 0.223928571_wp, & 
   & 0.250669643_wp, 0.357633929_wp, 0.411116071_wp, 0.330892857_wp, & 
   & 0.250669643_wp, 0.277410714_wp, 0.330892857_wp, 0.357633929_wp, & 
   & 0.411116071_wp, 0.411116071_wp, 0.116964286_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.116964286_wp, 0.170446429_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.197187500_wp, 0.170446429_wp, & 
   & 0.116964286_wp, 0.170446429_wp, 0.143705357_wp, 0.116964286_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 21) / &
   & 0.732008929_wp, 1.213348214_wp, 0.170446429_wp, 0.250669643_wp, & 
   & 0.330892857_wp, 0.518080357_wp, 0.625044643_wp, 0.678526786_wp, & 
   & 0.785491071_wp, 0.919196429_wp, 0.170446429_wp, 0.143705357_wp, & 
   & 0.223928571_wp, 0.250669643_wp, 0.304151786_wp, 0.357633929_wp, & 
   & 0.411116071_wp, 0.464598214_wp, 0.090223214_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.116964286_wp, 0.197187500_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.250669643_wp, 0.223928571_wp, 0.223928571_wp, 0.250669643_wp, & 
   & 0.277410714_wp, 0.304151786_wp, 0.330892857_wp, 0.384375000_wp, & 
   & 0.090223214_wp, 0.116964286_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, 0.197187500_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.223928571_wp, 0.223928571_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.250669643_wp, 0.250669643_wp, & 
   & 0.277410714_wp, 0.304151786_wp, 0.063482143_wp, 0.143705357_wp, & 
   & 0.116964286_wp, 0.250669643_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.250669643_wp, 0.277410714_wp, 0.250669643_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.223928571_wp, 0.223928571_wp, & 
   & 0.250669643_wp, 0.277410714_wp, 0.090223214_wp, 0.116964286_wp, & 
   & 0.143705357_wp, 0.116964286_wp, 0.116964286_wp, 0.170446429_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.116964286_wp, 0.170446429_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 22) / &
   & 0.812232143_wp, 1.320312500_wp, 0.143705357_wp, 0.277410714_wp, & 
   & 0.384375000_wp, 0.625044643_wp, 0.705267857_wp, 0.785491071_wp, & 
   & 0.892455357_wp, 1.026160714_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.223928571_wp, 0.277410714_wp, 0.357633929_wp, 0.411116071_wp, & 
   & 0.464598214_wp, 0.544821429_wp, 0.090223214_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, 0.197187500_wp, & 
   & 0.170446429_wp, 0.223928571_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.250669643_wp, 0.223928571_wp, 0.223928571_wp, 0.277410714_wp, & 
   & 0.330892857_wp, 0.357633929_wp, 0.384375000_wp, 0.437857143_wp, & 
   & 0.090223214_wp, 0.116964286_wp, 0.143705357_wp, 0.116964286_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, 0.197187500_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.250669643_wp, 0.223928571_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.250669643_wp, 0.277410714_wp, & 
   & 0.304151786_wp, 0.330892857_wp, 0.063482143_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.277410714_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, 0.143705357_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.277410714_wp, 0.304151786_wp, 0.277410714_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.223928571_wp, 0.250669643_wp, & 
   & 0.277410714_wp, 0.304151786_wp, 0.090223214_wp, 0.116964286_wp, & 
   & 0.143705357_wp, 0.116964286_wp, 0.116964286_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.116964286_wp, 0.170446429_wp, 0.170446429_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.197187500_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 23) / &
   & 0.785491071_wp, 1.347053571_wp, 0.143705357_wp, 0.223928571_wp, & 
   & 0.304151786_wp, 0.491339286_wp, 0.625044643_wp, 0.705267857_wp, & 
   & 0.838973214_wp, 0.999419643_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.170446429_wp, 0.223928571_wp, 0.250669643_wp, 0.304151786_wp, & 
   & 0.357633929_wp, 0.411116071_wp, 0.090223214_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.143705357_wp, 0.116964286_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.250669643_wp, 0.250669643_wp, 0.304151786_wp, 0.330892857_wp, & 
   & 0.090223214_wp, 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.143705357_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.197187500_wp, 0.223928571_wp, & 
   & 0.223928571_wp, 0.250669643_wp, 0.063482143_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.197187500_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.223928571_wp, 0.223928571_wp, 0.223928571_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, 0.170446429_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.116964286_wp, 0.170446429_wp, 0.143705357_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.143705357_wp, 0.143705357_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 24) / &
   & 0.919196429_wp, 1.266830357_wp, 0.277410714_wp, 0.277410714_wp, & 
   & 0.544821429_wp, 0.651785714_wp, 0.678526786_wp, 0.758750000_wp, & 
   & 0.919196429_wp, 1.079642857_wp, 0.250669643_wp, 0.116964286_wp, & 
   & 0.357633929_wp, 0.411116071_wp, 0.411116071_wp, 0.437857143_wp, & 
   & 0.491339286_wp, 0.544821429_wp, 0.090223214_wp, 0.223928571_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.170446429_wp, 0.304151786_wp, & 
   & 0.223928571_wp, 0.223928571_wp, 0.277410714_wp, 0.304151786_wp, & 
   & 0.384375000_wp, 0.330892857_wp, 0.357633929_wp, 0.411116071_wp, & 
   & 0.384375000_wp, 0.411116071_wp, 0.437857143_wp, 0.464598214_wp, & 
   & 0.063482143_wp, 0.197187500_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.277410714_wp, 0.143705357_wp, 0.223928571_wp, & 
   & 0.250669643_wp, 0.304151786_wp, 0.384375000_wp, 0.330892857_wp, & 
   & 0.330892857_wp, 0.357633929_wp, 0.357633929_wp, 0.357633929_wp, & 
   & 0.357633929_wp, 0.384375000_wp, 0.063482143_wp, 0.223928571_wp, & 
   & 0.170446429_wp, 0.330892857_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, 0.223928571_wp, & 
   & 0.250669643_wp, 0.197187500_wp, 0.170446429_wp, 0.250669643_wp, & 
   & 0.304151786_wp, 0.384375000_wp, 0.384375000_wp, 0.384375000_wp, & 
   & 0.330892857_wp, 0.357633929_wp, 0.330892857_wp, 0.330892857_wp, & 
   & 0.357633929_wp, 0.357633929_wp, 0.170446429_wp, 0.197187500_wp, & 
   & 0.223928571_wp, 0.197187500_wp, 0.170446429_wp, 0.223928571_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.277410714_wp, 0.250669643_wp, & 
   & 0.170446429_wp, 0.250669643_wp, 0.197187500_wp, 0.170446429_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.250669643_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 25) / &
   & 0.544821429_wp, 0.732008929_wp, 0.277410714_wp, 0.223928571_wp, & 
   & 0.357633929_wp, 0.384375000_wp, 0.411116071_wp, 0.437857143_wp, & 
   & 0.518080357_wp, 0.598303571_wp, 0.250669643_wp, 0.143705357_wp, & 
   & 0.223928571_wp, 0.250669643_wp, 0.250669643_wp, 0.250669643_wp, & 
   & 0.277410714_wp, 0.330892857_wp, 0.143705357_wp, 0.197187500_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, 0.223928571_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.250669643_wp, 0.250669643_wp, & 
   & 0.223928571_wp, 0.250669643_wp, 0.223928571_wp, 0.223928571_wp, & 
   & 0.223928571_wp, 0.223928571_wp, 0.250669643_wp, 0.277410714_wp, & 
   & 0.116964286_wp, 0.170446429_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.143705357_wp, 0.170446429_wp, & 
   & 0.223928571_wp, 0.250669643_wp, 0.223928571_wp, 0.223928571_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.090223214_wp, 0.143705357_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.116964286_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, 0.197187500_wp, & 
   & 0.223928571_wp, 0.197187500_wp, 0.143705357_wp, 0.170446429_wp, & 
   & 0.223928571_wp, 0.223928571_wp, 0.223928571_wp, 0.223928571_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.116964286_wp, 0.170446429_wp, 0.170446429_wp, 0.197187500_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.143705357_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.143705357_wp, 0.143705357_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 26) / &
   & 0.571562500_wp, 0.732008929_wp, 0.304151786_wp, 0.250669643_wp, & 
   & 0.357633929_wp, 0.384375000_wp, 0.411116071_wp, 0.437857143_wp, & 
   & 0.518080357_wp, 0.571562500_wp, 0.250669643_wp, 0.143705357_wp, & 
   & 0.250669643_wp, 0.250669643_wp, 0.250669643_wp, 0.277410714_wp, & 
   & 0.304151786_wp, 0.330892857_wp, 0.143705357_wp, 0.223928571_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.197187500_wp, 0.223928571_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.277410714_wp, 0.277410714_wp, & 
   & 0.250669643_wp, 0.277410714_wp, 0.223928571_wp, 0.250669643_wp, & 
   & 0.250669643_wp, 0.250669643_wp, 0.277410714_wp, 0.277410714_wp, & 
   & 0.116964286_wp, 0.197187500_wp, 0.223928571_wp, 0.223928571_wp, & 
   & 0.223928571_wp, 0.250669643_wp, 0.143705357_wp, 0.197187500_wp, & 
   & 0.223928571_wp, 0.250669643_wp, 0.223928571_wp, 0.250669643_wp, & 
   & 0.223928571_wp, 0.223928571_wp, 0.223928571_wp, 0.223928571_wp, & 
   & 0.223928571_wp, 0.250669643_wp, 0.090223214_wp, 0.170446429_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.197187500_wp, 0.250669643_wp, & 
   & 0.250669643_wp, 0.197187500_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.223928571_wp, 0.223928571_wp, 0.223928571_wp, 0.250669643_wp, & 
   & 0.223928571_wp, 0.223928571_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.223928571_wp, 0.223928571_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.143705357_wp, 0.197187500_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.197187500_wp, 0.170446429_wp, 0.170446429_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 27) / &
   & 1.079642857_wp, 1.774910714_wp, 0.277410714_wp, 0.330892857_wp, & 
   & 0.491339286_wp, 0.812232143_wp, 0.919196429_wp, 0.999419643_wp, & 
   & 1.159866071_wp, 1.347053571_wp, 0.250669643_wp, 0.143705357_wp, & 
   & 0.304151786_wp, 0.384375000_wp, 0.464598214_wp, 0.544821429_wp, & 
   & 0.598303571_wp, 0.678526786_wp, 0.116964286_wp, 0.223928571_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.170446429_wp, 0.277410714_wp, & 
   & 0.250669643_wp, 0.277410714_wp, 0.277410714_wp, 0.277410714_wp, & 
   & 0.357633929_wp, 0.330892857_wp, 0.330892857_wp, 0.384375000_wp, & 
   & 0.437857143_wp, 0.464598214_wp, 0.518080357_wp, 0.544821429_wp, & 
   & 0.090223214_wp, 0.197187500_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.250669643_wp, 0.170446429_wp, 0.277410714_wp, & 
   & 0.250669643_wp, 0.277410714_wp, 0.357633929_wp, 0.304151786_wp, & 
   & 0.304151786_wp, 0.330892857_wp, 0.357633929_wp, 0.384375000_wp, & 
   & 0.411116071_wp, 0.437857143_wp, 0.063482143_wp, 0.197187500_wp, & 
   & 0.170446429_wp, 0.384375000_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, 0.223928571_wp, & 
   & 0.223928571_wp, 0.250669643_wp, 0.223928571_wp, 0.304151786_wp, & 
   & 0.304151786_wp, 0.357633929_wp, 0.411116071_wp, 0.357633929_wp, & 
   & 0.304151786_wp, 0.304151786_wp, 0.330892857_wp, 0.357633929_wp, & 
   & 0.384375000_wp, 0.411116071_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.197187500_wp, 0.170446429_wp, 0.170446429_wp, 0.223928571_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.277410714_wp, 0.223928571_wp, & 
   & 0.170446429_wp, 0.250669643_wp, 0.197187500_wp, 0.170446429_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.250669643_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 28) / &
   & 1.079642857_wp, 1.721428571_wp, 0.277410714_wp, 0.330892857_wp, & 
   & 0.518080357_wp, 0.812232143_wp, 0.919196429_wp, 0.999419643_wp, & 
   & 1.159866071_wp, 1.320312500_wp, 0.250669643_wp, 0.143705357_wp, & 
   & 0.330892857_wp, 0.437857143_wp, 0.518080357_wp, 0.571562500_wp, & 
   & 0.625044643_wp, 0.705267857_wp, 0.090223214_wp, 0.223928571_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.170446429_wp, 0.304151786_wp, & 
   & 0.250669643_wp, 0.277410714_wp, 0.277410714_wp, 0.304151786_wp, & 
   & 0.411116071_wp, 0.330892857_wp, 0.384375000_wp, 0.411116071_wp, & 
   & 0.464598214_wp, 0.518080357_wp, 0.544821429_wp, 0.598303571_wp, & 
   & 0.090223214_wp, 0.223928571_wp, 0.223928571_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.277410714_wp, 0.170446429_wp, 0.250669643_wp, & 
   & 0.250669643_wp, 0.304151786_wp, 0.384375000_wp, 0.330892857_wp, & 
   & 0.330892857_wp, 0.357633929_wp, 0.411116071_wp, 0.437857143_wp, & 
   & 0.464598214_wp, 0.491339286_wp, 0.063482143_wp, 0.223928571_wp, & 
   & 0.197187500_wp, 0.411116071_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, 0.223928571_wp, & 
   & 0.250669643_wp, 0.223928571_wp, 0.223928571_wp, 0.277410714_wp, & 
   & 0.304151786_wp, 0.411116071_wp, 0.437857143_wp, 0.411116071_wp, & 
   & 0.330892857_wp, 0.330892857_wp, 0.384375000_wp, 0.411116071_wp, & 
   & 0.411116071_wp, 0.437857143_wp, 0.170446429_wp, 0.197187500_wp, & 
   & 0.223928571_wp, 0.197187500_wp, 0.170446429_wp, 0.223928571_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.277410714_wp, 0.250669643_wp, & 
   & 0.170446429_wp, 0.277410714_wp, 0.223928571_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.277410714_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 29) / &
   & 1.667946429_wp, 4.074642857_wp, 0.411116071_wp, 0.304151786_wp, & 
   & 0.972678571_wp, 1.560982143_wp, 1.908616071_wp, 2.256250000_wp, & 
   & 2.630625000_wp, 3.058482143_wp, 0.223928571_wp, 0.116964286_wp, & 
   & 0.571562500_wp, 0.812232143_wp, 1.106383929_wp, 1.293571429_wp, & 
   & 1.480758929_wp, 1.614464286_wp, 0.090223214_wp, 0.330892857_wp, & 
   & 0.250669643_wp, 0.250669643_wp, 0.197187500_wp, 0.384375000_wp, & 
   & 0.223928571_wp, 0.250669643_wp, 0.357633929_wp, 0.411116071_wp, & 
   & 0.678526786_wp, 0.464598214_wp, 0.651785714_wp, 0.812232143_wp, & 
   & 1.026160714_wp, 1.159866071_wp, 1.293571429_wp, 1.320312500_wp, & 
   & 0.063482143_wp, 0.304151786_wp, 0.250669643_wp, 0.277410714_wp, & 
   & 0.277410714_wp, 0.384375000_wp, 0.170446429_wp, 0.250669643_wp, & 
   & 0.357633929_wp, 0.411116071_wp, 0.678526786_wp, 0.464598214_wp, & 
   & 0.571562500_wp, 0.705267857_wp, 0.838973214_wp, 0.945937500_wp, & 
   & 1.026160714_wp, 1.079642857_wp, 0.063482143_wp, 0.304151786_wp, & 
   & 0.223928571_wp, 0.892455357_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.223928571_wp, 0.223928571_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.223928571_wp, 0.357633929_wp, & 
   & 0.357633929_wp, 0.197187500_wp, 0.197187500_wp, 0.250669643_wp, & 
   & 0.464598214_wp, 0.732008929_wp, 0.892455357_wp, 2.069062500_wp, & 
   & 0.571562500_wp, 0.598303571_wp, 0.758750000_wp, 0.865714286_wp, & 
   & 0.945937500_wp, 0.972678571_wp, 0.250669643_wp, 0.277410714_wp, & 
   & 0.277410714_wp, 0.250669643_wp, 0.223928571_wp, 0.304151786_wp, & 
   & 0.250669643_wp, 0.250669643_wp, 0.464598214_wp, 0.304151786_wp, & 
   & 0.223928571_wp, 0.357633929_wp, 0.250669643_wp, 0.223928571_wp, & 
   & 0.250669643_wp, 0.277410714_wp, 0.330892857_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 30) / &
   & 1.293571429_wp, 1.881875000_wp, 0.330892857_wp, 0.330892857_wp, & 
   & 0.598303571_wp, 0.892455357_wp, 0.999419643_wp, 1.079642857_wp, & 
   & 1.240089286_wp, 1.427276786_wp, 0.277410714_wp, 0.143705357_wp, & 
   & 0.384375000_wp, 0.491339286_wp, 0.571562500_wp, 0.625044643_wp, & 
   & 0.705267857_wp, 0.785491071_wp, 0.090223214_wp, 0.277410714_wp, & 
   & 0.223928571_wp, 0.223928571_wp, 0.197187500_wp, 0.330892857_wp, & 
   & 0.250669643_wp, 0.277410714_wp, 0.330892857_wp, 0.330892857_wp, & 
   & 0.464598214_wp, 0.384375000_wp, 0.437857143_wp, 0.464598214_wp, & 
   & 0.518080357_wp, 0.571562500_wp, 0.598303571_wp, 0.651785714_wp, & 
   & 0.090223214_wp, 0.250669643_wp, 0.250669643_wp, 0.223928571_wp, & 
   & 0.250669643_wp, 0.304151786_wp, 0.170446429_wp, 0.277410714_wp, & 
   & 0.304151786_wp, 0.330892857_wp, 0.437857143_wp, 0.384375000_wp, & 
   & 0.357633929_wp, 0.411116071_wp, 0.464598214_wp, 0.491339286_wp, & 
   & 0.518080357_wp, 0.544821429_wp, 0.063482143_wp, 0.250669643_wp, & 
   & 0.223928571_wp, 0.464598214_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.223928571_wp, 0.197187500_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.197187500_wp, 0.277410714_wp, & 
   & 0.277410714_wp, 0.223928571_wp, 0.223928571_wp, 0.277410714_wp, & 
   & 0.357633929_wp, 0.464598214_wp, 0.491339286_wp, 0.437857143_wp, & 
   & 0.357633929_wp, 0.384375000_wp, 0.437857143_wp, 0.437857143_wp, & 
   & 0.464598214_wp, 0.491339286_wp, 0.197187500_wp, 0.223928571_wp, & 
   & 0.250669643_wp, 0.223928571_wp, 0.197187500_wp, 0.277410714_wp, & 
   & 0.223928571_wp, 0.250669643_wp, 0.330892857_wp, 0.277410714_wp, & 
   & 0.197187500_wp, 0.304151786_wp, 0.250669643_wp, 0.223928571_wp, & 
   & 0.250669643_wp, 0.250669643_wp, 0.304151786_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 31) / &
   & 1.694687500_wp, 5.277991071_wp, 0.384375000_wp, 0.277410714_wp, & 
   & 1.052901786_wp, 1.507500000_wp, 2.256250000_wp, 3.218928571_wp, & 
   & 3.780491071_wp, 4.181607143_wp, 0.197187500_wp, 0.116964286_wp, & 
   & 1.801651786_wp, 1.801651786_wp, 2.015580357_wp, 2.122544643_wp, & 
   & 2.309732143_wp, 2.550401786_wp, 0.063482143_wp, 0.304151786_wp, & 
   & 0.223928571_wp, 0.223928571_wp, 0.197187500_wp, 0.357633929_wp, & 
   & 0.223928571_wp, 0.223928571_wp, 0.330892857_wp, 0.384375000_wp, & 
   & 0.651785714_wp, 0.437857143_wp, 1.694687500_wp, 1.828392857_wp, & 
   & 1.855133929_wp, 1.962098214_wp, 2.042321429_wp, 2.229508929_wp, & 
   & 0.063482143_wp, 0.277410714_wp, 0.223928571_wp, 0.250669643_wp, & 
   & 0.250669643_wp, 0.357633929_wp, 0.143705357_wp, 0.223928571_wp, & 
   & 0.304151786_wp, 0.384375000_wp, 0.651785714_wp, 0.437857143_wp, & 
   & 1.560982143_wp, 0.758750000_wp, 1.774910714_wp, 1.801651786_wp, & 
   & 1.801651786_wp, 1.962098214_wp, 0.063482143_wp, 0.277410714_wp, & 
   & 0.197187500_wp, 1.801651786_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.223928571_wp, 0.197187500_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.197187500_wp, 0.330892857_wp, & 
   & 0.304151786_wp, 0.197187500_wp, 0.170446429_wp, 0.250669643_wp, & 
   & 0.411116071_wp, 0.705267857_wp, 1.801651786_wp, 0.625044643_wp, & 
   & 0.544821429_wp, 0.571562500_wp, 1.774910714_wp, 1.721428571_wp, & 
   & 1.748169643_wp, 1.881875000_wp, 0.250669643_wp, 0.250669643_wp, & 
   & 0.250669643_wp, 0.223928571_wp, 0.197187500_wp, 0.304151786_wp, & 
   & 1.855133929_wp, 0.223928571_wp, 0.437857143_wp, 0.277410714_wp, & 
   & 0.197187500_wp, 0.330892857_wp, 0.223928571_wp, 0.197187500_wp, & 
   & 0.223928571_wp, 1.908616071_wp, 0.304151786_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 32) / &
   & 1.828392857_wp, 6.000000000_wp, 0.437857143_wp, 0.304151786_wp, & 
   & 1.320312500_wp, 1.480758929_wp, 2.282991071_wp, 3.940937500_wp, & 
   & 4.368794643_wp, 5.652366071_wp, 0.223928571_wp, 0.116964286_wp, & 
   & 0.945937500_wp, 1.186607143_wp, 1.962098214_wp, 2.657366071_wp, & 
   & 3.085223214_wp, 2.898035714_wp, 0.090223214_wp, 0.357633929_wp, & 
   & 0.250669643_wp, 0.277410714_wp, 0.197187500_wp, 0.411116071_wp, & 
   & 0.223928571_wp, 0.250669643_wp, 0.384375000_wp, 0.411116071_wp, & 
   & 0.812232143_wp, 0.464598214_wp, 1.828392857_wp, 1.320312500_wp, & 
   & 1.988839286_wp, 2.577142857_wp, 2.764330357_wp, 2.416696429_wp, & 
   & 0.063482143_wp, 0.330892857_wp, 0.250669643_wp, 0.277410714_wp, & 
   & 0.277410714_wp, 0.411116071_wp, 0.170446429_wp, 0.250669643_wp, & 
   & 0.357633929_wp, 0.411116071_wp, 0.812232143_wp, 0.491339286_wp, & 
   & 1.855133929_wp, 1.026160714_wp, 1.560982143_wp, 1.908616071_wp, & 
   & 2.363214286_wp, 1.988839286_wp, 0.063482143_wp, 0.304151786_wp, & 
   & 0.223928571_wp, 1.774910714_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.250669643_wp, 0.223928571_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.223928571_wp, 0.384375000_wp, & 
   & 0.357633929_wp, 0.223928571_wp, 0.197187500_wp, 0.277410714_wp, & 
   & 0.491339286_wp, 0.785491071_wp, 1.427276786_wp, 0.732008929_wp, & 
   & 1.694687500_wp, 0.838973214_wp, 1.373794643_wp, 1.801651786_wp, & 
   & 2.256250000_wp, 1.855133929_wp, 0.277410714_wp, 0.304151786_wp, & 
   & 0.277410714_wp, 0.892455357_wp, 0.865714286_wp, 0.330892857_wp, & 
   & 0.277410714_wp, 0.250669643_wp, 0.625044643_wp, 0.330892857_wp, & 
   & 0.223928571_wp, 0.411116071_wp, 0.250669643_wp, 0.223928571_wp, & 
   & 0.250669643_wp, 0.277410714_wp, 0.357633929_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 33) / &
   & 2.069062500_wp, 6.000000000_wp, 0.464598214_wp, 0.277410714_wp, & 
   & 1.721428571_wp, 1.614464286_wp, 2.496919643_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.223928571_wp, 0.116964286_wp, & 
   & 2.069062500_wp, 1.962098214_wp, 2.630625000_wp, 3.860714286_wp, & 
   & 4.208348214_wp, 4.636205357_wp, 0.090223214_wp, 0.437857143_wp, & 
   & 0.277410714_wp, 0.330892857_wp, 0.250669643_wp, 0.384375000_wp, & 
   & 0.223928571_wp, 0.250669643_wp, 0.437857143_wp, 0.464598214_wp, & 
   & 1.026160714_wp, 0.518080357_wp, 1.855133929_wp, 1.988839286_wp, & 
   & 2.684107143_wp, 3.486339286_wp, 3.700267857_wp, 3.994419643_wp, & 
   & 0.063482143_wp, 0.384375000_wp, 0.277410714_wp, 0.330892857_wp, & 
   & 0.304151786_wp, 0.464598214_wp, 0.170446429_wp, 0.223928571_wp, & 
   & 0.411116071_wp, 0.464598214_wp, 1.052901786_wp, 0.571562500_wp, & 
   & 1.828392857_wp, 1.641205357_wp, 2.523660714_wp, 3.111964286_wp, & 
   & 3.218928571_wp, 3.406116071_wp, 0.063482143_wp, 0.384375000_wp, & 
   & 0.250669643_wp, 3.085223214_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.277410714_wp, 0.250669643_wp, & 
   & 0.223928571_wp, 0.223928571_wp, 0.223928571_wp, 0.223928571_wp, & 
   & 0.223928571_wp, 0.223928571_wp, 0.250669643_wp, 0.464598214_wp, & 
   & 0.437857143_wp, 0.223928571_wp, 0.197187500_wp, 0.250669643_wp, & 
   & 0.598303571_wp, 0.758750000_wp, 2.389955357_wp, 0.838973214_wp, & 
   & 1.667946429_wp, 1.507500000_wp, 2.496919643_wp, 2.951517857_wp, & 
   & 3.031741071_wp, 3.192187500_wp, 0.357633929_wp, 2.176026786_wp, & 
   & 0.330892857_wp, 0.919196429_wp, 0.945937500_wp, 0.384375000_wp, & 
   & 0.411116071_wp, 0.304151786_wp, 0.838973214_wp, 0.384375000_wp, & 
   & 0.999419643_wp, 0.464598214_wp, 0.277410714_wp, 0.277410714_wp, & 
   & 1.935357143_wp, 0.357633929_wp, 0.411116071_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 34) / &
   & 2.229508929_wp, 6.000000000_wp, 0.437857143_wp, 0.304151786_wp, & 
   & 1.988839286_wp, 1.694687500_wp, 2.710848214_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.223928571_wp, 0.116964286_wp, & 
   & 2.176026786_wp, 2.389955357_wp, 3.218928571_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.090223214_wp, 0.491339286_wp, & 
   & 0.304151786_wp, 0.357633929_wp, 0.250669643_wp, 0.411116071_wp, & 
   & 0.223928571_wp, 0.250669643_wp, 0.464598214_wp, 0.518080357_wp, & 
   & 1.159866071_wp, 0.571562500_wp, 1.962098214_wp, 2.577142857_wp, & 
   & 3.486339286_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 0.090223214_wp, 0.464598214_wp, 0.304151786_wp, 0.357633929_wp, & 
   & 0.330892857_wp, 0.491339286_wp, 0.170446429_wp, 0.250669643_wp, & 
   & 0.437857143_wp, 0.518080357_wp, 1.213348214_wp, 0.598303571_wp, & 
   & 1.935357143_wp, 2.176026786_wp, 3.325892857_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.063482143_wp, 0.491339286_wp, & 
   & 0.250669643_wp, 6.000000000_wp, 0.197187500_wp, 0.223928571_wp, & 
   & 0.223928571_wp, 0.223928571_wp, 0.304151786_wp, 0.277410714_wp, & 
   & 0.223928571_wp, 0.250669643_wp, 0.223928571_wp, 0.223928571_wp, & 
   & 0.223928571_wp, 0.250669643_wp, 0.250669643_wp, 0.544821429_wp, & 
   & 0.464598214_wp, 0.223928571_wp, 0.197187500_wp, 0.250669643_wp, & 
   & 0.625044643_wp, 0.758750000_wp, 3.833973214_wp, 0.892455357_wp, & 
   & 1.774910714_wp, 1.881875000_wp, 3.379375000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.411116071_wp, 0.464598214_wp, & 
   & 0.384375000_wp, 0.892455357_wp, 0.892455357_wp, 0.411116071_wp, & 
   & 0.571562500_wp, 0.330892857_wp, 0.919196429_wp, 0.411116071_wp, & 
   & 1.026160714_wp, 0.491339286_wp, 0.304151786_wp, 0.330892857_wp, & 
   & 1.881875000_wp, 1.694687500_wp, 0.464598214_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 35) / &
   & 2.416696429_wp, 6.000000000_wp, 0.491339286_wp, 0.330892857_wp, & 
   & 2.202767857_wp, 1.855133929_wp, 3.058482143_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.250669643_wp, 0.143705357_wp, & 
   & 2.256250000_wp, 2.523660714_wp, 3.432857143_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.090223214_wp, 0.544821429_wp, & 
   & 0.330892857_wp, 0.384375000_wp, 0.304151786_wp, 0.437857143_wp, & 
   & 0.250669643_wp, 0.277410714_wp, 0.518080357_wp, 0.544821429_wp, & 
   & 1.293571429_wp, 0.598303571_wp, 2.042321429_wp, 2.764330357_wp, & 
   & 3.700267857_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 0.090223214_wp, 0.491339286_wp, 0.330892857_wp, 0.384375000_wp, & 
   & 0.384375000_wp, 0.518080357_wp, 0.170446429_wp, 0.250669643_wp, & 
   & 0.491339286_wp, 0.544821429_wp, 1.320312500_wp, 0.651785714_wp, & 
   & 1.988839286_wp, 2.577142857_wp, 3.539821429_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.063482143_wp, 0.598303571_wp, & 
   & 0.277410714_wp, 6.000000000_wp, 0.223928571_wp, 0.223928571_wp, & 
   & 0.223928571_wp, 0.223928571_wp, 0.330892857_wp, 0.277410714_wp, & 
   & 0.250669643_wp, 0.250669643_wp, 0.250669643_wp, 0.250669643_wp, & 
   & 0.250669643_wp, 0.250669643_wp, 0.277410714_wp, 0.571562500_wp, & 
   & 0.518080357_wp, 0.223928571_wp, 0.223928571_wp, 0.277410714_wp, & 
   & 0.705267857_wp, 0.838973214_wp, 5.572142857_wp, 0.972678571_wp, & 
   & 1.855133929_wp, 2.149285714_wp, 3.620044643_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.464598214_wp, 0.518080357_wp, & 
   & 0.411116071_wp, 0.945937500_wp, 0.999419643_wp, 0.464598214_wp, & 
   & 0.678526786_wp, 0.357633929_wp, 0.999419643_wp, 0.464598214_wp, & 
   & 0.999419643_wp, 0.544821429_wp, 0.330892857_wp, 0.384375000_wp, & 
   & 1.828392857_wp, 1.694687500_wp, 0.518080357_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 36) / &
   & 2.523660714_wp, 6.000000000_wp, 0.571562500_wp, 0.357633929_wp, & 
   & 2.176026786_wp, 1.935357143_wp, 3.031741071_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.277410714_wp, 0.143705357_wp, & 
   & 2.389955357_wp, 2.309732143_wp, 3.727008929_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.116964286_wp, 0.598303571_wp, & 
   & 0.384375000_wp, 0.437857143_wp, 0.330892857_wp, 0.464598214_wp, & 
   & 0.277410714_wp, 0.277410714_wp, 0.544821429_wp, 0.598303571_wp, & 
   & 1.320312500_wp, 0.651785714_wp, 2.229508929_wp, 2.416696429_wp, & 
   & 3.994419643_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 0.090223214_wp, 0.544821429_wp, 0.357633929_wp, 0.437857143_wp, & 
   & 0.411116071_wp, 0.571562500_wp, 0.197187500_wp, 0.277410714_wp, & 
   & 0.544821429_wp, 0.598303571_wp, 1.347053571_wp, 0.705267857_wp, & 
   & 2.176026786_wp, 2.095803571_wp, 3.833973214_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.090223214_wp, 0.838973214_wp, & 
   & 0.304151786_wp, 6.000000000_wp, 0.250669643_wp, 0.250669643_wp, & 
   & 0.250669643_wp, 0.250669643_wp, 0.357633929_wp, 0.304151786_wp, & 
   & 0.277410714_wp, 0.277410714_wp, 0.277410714_wp, 0.277410714_wp, & 
   & 0.277410714_wp, 0.277410714_wp, 0.304151786_wp, 0.598303571_wp, & 
   & 0.544821429_wp, 0.250669643_wp, 0.223928571_wp, 0.304151786_wp, & 
   & 0.758750000_wp, 0.892455357_wp, 3.058482143_wp, 1.052901786_wp, & 
   & 2.015580357_wp, 1.908616071_wp, 3.192187500_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.518080357_wp, 2.282991071_wp, & 
   & 0.464598214_wp, 1.026160714_wp, 1.240089286_wp, 0.464598214_wp, & 
   & 0.838973214_wp, 0.384375000_wp, 0.999419643_wp, 0.518080357_wp, & 
   & 1.159866071_wp, 0.651785714_wp, 0.384375000_wp, 0.598303571_wp, & 
   & 2.069062500_wp, 1.855133929_wp, 0.571562500_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 37) / &
   & 0.250669643_wp, 0.464598214_wp, 0.090223214_wp, 0.170446429_wp, & 
   & 0.116964286_wp, 0.143705357_wp, 0.143705357_wp, 0.197187500_wp, & 
   & 0.250669643_wp, 0.357633929_wp, 0.143705357_wp, 0.063482143_wp, & 
   & 0.063482143_wp, 0.063482143_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.090223214_wp, 0.116964286_wp, 0.036741071_wp, 0.036741071_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, 0.063482143_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.063482143_wp, 0.090223214_wp, 0.063482143_wp, 0.063482143_wp, & 
   & 0.063482143_wp, 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.036741071_wp, 0.036741071_wp, 0.063482143_wp, 0.090223214_wp, & 
   & 0.063482143_wp, 0.063482143_wp, 0.116964286_wp, 0.090223214_wp, & 
   & 0.063482143_wp, 0.090223214_wp, 0.063482143_wp, 0.063482143_wp, & 
   & 0.063482143_wp, 0.063482143_wp, 0.063482143_wp, 0.063482143_wp, & 
   & 0.063482143_wp, 0.063482143_wp, 0.036741071_wp, 0.036741071_wp, & 
   & 0.036741071_wp, 0.063482143_wp, 0.063482143_wp, 0.063482143_wp, & 
   & 0.063482143_wp, 0.063482143_wp, 0.063482143_wp, 0.063482143_wp, & 
   & 0.063482143_wp, 0.063482143_wp, 0.063482143_wp, 0.063482143_wp, & 
   & 0.063482143_wp, 0.063482143_wp, 0.063482143_wp, 0.090223214_wp, & 
   & 0.063482143_wp, 0.063482143_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.063482143_wp, 0.063482143_wp, 0.063482143_wp, 0.063482143_wp, & 
   & 0.063482143_wp, 0.063482143_wp, 0.063482143_wp, 0.063482143_wp, & 
   & 0.063482143_wp, 0.063482143_wp, 0.036741071_wp, 0.036741071_wp, & 
   & 0.036741071_wp, 0.036741071_wp, 0.063482143_wp, 0.063482143_wp, & 
   & 0.063482143_wp, 0.063482143_wp, 0.036741071_wp, 0.036741071_wp, & 
   & 0.063482143_wp, 0.036741071_wp, 0.036741071_wp, 0.036741071_wp, & 
   & 0.036741071_wp, 0.036741071_wp, 0.036741071_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 38) / &
   & 0.865714286_wp, 2.764330357_wp, 0.170446429_wp, 0.223928571_wp, & 
   & 0.411116071_wp, 0.865714286_wp, 0.919196429_wp, 1.052901786_wp, & 
   & 1.293571429_wp, 2.149285714_wp, 0.197187500_wp, 0.090223214_wp, & 
   & 0.250669643_wp, 0.330892857_wp, 0.437857143_wp, 0.518080357_wp, & 
   & 0.598303571_wp, 0.678526786_wp, 0.063482143_wp, 0.143705357_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, 0.197187500_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.197187500_wp, 0.223928571_wp, & 
   & 0.304151786_wp, 0.250669643_wp, 0.277410714_wp, 0.330892857_wp, & 
   & 0.384375000_wp, 0.464598214_wp, 0.491339286_wp, 0.544821429_wp, & 
   & 0.036741071_wp, 0.143705357_wp, 0.143705357_wp, 0.116964286_wp, & 
   & 0.143705357_wp, 0.197187500_wp, 0.116964286_wp, 0.197187500_wp, & 
   & 0.170446429_wp, 0.223928571_wp, 0.304151786_wp, 0.250669643_wp, & 
   & 0.223928571_wp, 0.277410714_wp, 0.330892857_wp, 0.357633929_wp, & 
   & 0.384375000_wp, 0.411116071_wp, 0.036741071_wp, 0.143705357_wp, & 
   & 0.116964286_wp, 0.357633929_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.090223214_wp, 0.116964286_wp, 0.090223214_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, 0.143705357_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.143705357_wp, 0.197187500_wp, & 
   & 0.223928571_wp, 0.330892857_wp, 0.357633929_wp, 0.304151786_wp, & 
   & 0.223928571_wp, 0.250669643_wp, 0.304151786_wp, 0.330892857_wp, & 
   & 0.357633929_wp, 0.384375000_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.143705357_wp, 0.116964286_wp, 0.116964286_wp, 0.143705357_wp, & 
   & 0.116964286_wp, 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.116964286_wp, 0.170446429_wp, 0.143705357_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.143705357_wp, 0.170446429_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 39) / &
   & 0.598303571_wp, 1.026160714_wp, 0.197187500_wp, 0.250669643_wp, & 
   & 0.330892857_wp, 0.464598214_wp, 0.518080357_wp, 0.571562500_wp, & 
   & 0.651785714_wp, 0.758750000_wp, 0.170446429_wp, 0.090223214_wp, & 
   & 0.223928571_wp, 0.250669643_wp, 0.304151786_wp, 0.330892857_wp, & 
   & 0.384375000_wp, 0.411116071_wp, 0.063482143_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.116964286_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.197187500_wp, 0.223928571_wp, & 
   & 0.250669643_wp, 0.250669643_wp, 0.223928571_wp, 0.250669643_wp, & 
   & 0.277410714_wp, 0.304151786_wp, 0.330892857_wp, 0.357633929_wp, & 
   & 0.063482143_wp, 0.143705357_wp, 0.116964286_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.197187500_wp, 0.143705357_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.223928571_wp, 0.223928571_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.223928571_wp, 0.250669643_wp, & 
   & 0.277410714_wp, 0.277410714_wp, 0.036741071_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.250669643_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, 0.223928571_wp, & 
   & 0.197187500_wp, 0.250669643_wp, 0.250669643_wp, 0.250669643_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.223928571_wp, 0.223928571_wp, & 
   & 0.250669643_wp, 0.250669643_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, 0.223928571_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.197187500_wp, 0.143705357_wp, & 
   & 0.116964286_wp, 0.250669643_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.143705357_wp, 0.143705357_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 40) / &
   & 0.812232143_wp, 1.320312500_wp, 0.170446429_wp, 0.277410714_wp, & 
   & 0.384375000_wp, 0.625044643_wp, 0.705267857_wp, 0.758750000_wp, & 
   & 0.892455357_wp, 1.026160714_wp, 0.170446429_wp, 0.143705357_wp, & 
   & 0.223928571_wp, 0.277410714_wp, 0.357633929_wp, 0.411116071_wp, & 
   & 0.464598214_wp, 0.544821429_wp, 0.116964286_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.116964286_wp, 0.116964286_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.277410714_wp, 0.223928571_wp, 0.250669643_wp, 0.277410714_wp, & 
   & 0.330892857_wp, 0.357633929_wp, 0.384375000_wp, 0.437857143_wp, & 
   & 0.090223214_wp, 0.116964286_wp, 0.143705357_wp, 0.116964286_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, 0.197187500_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.250669643_wp, 0.223928571_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.250669643_wp, 0.277410714_wp, & 
   & 0.304151786_wp, 0.330892857_wp, 0.063482143_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.277410714_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, 0.143705357_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.277410714_wp, 0.304151786_wp, 0.277410714_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.250669643_wp, 0.250669643_wp, & 
   & 0.277410714_wp, 0.304151786_wp, 0.090223214_wp, 0.116964286_wp, & 
   & 0.143705357_wp, 0.116964286_wp, 0.116964286_wp, 0.170446429_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.197187500_wp, 0.170446429_wp, & 
   & 0.116964286_wp, 0.170446429_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.197187500_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 41) / &
   & 0.785491071_wp, 1.320312500_wp, 0.170446429_wp, 0.277410714_wp, & 
   & 0.357633929_wp, 0.571562500_wp, 0.651785714_wp, 0.732008929_wp, & 
   & 0.838973214_wp, 0.999419643_wp, 0.170446429_wp, 0.143705357_wp, & 
   & 0.223928571_wp, 0.277410714_wp, 0.330892857_wp, 0.384375000_wp, & 
   & 0.437857143_wp, 0.491339286_wp, 0.090223214_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.277410714_wp, 0.250669643_wp, 0.250669643_wp, 0.277410714_wp, & 
   & 0.304151786_wp, 0.330892857_wp, 0.384375000_wp, 0.411116071_wp, & 
   & 0.063482143_wp, 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.197187500_wp, 0.170446429_wp, 0.223928571_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.250669643_wp, 0.223928571_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.250669643_wp, 0.277410714_wp, & 
   & 0.304151786_wp, 0.330892857_wp, 0.063482143_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.277410714_wp, 0.090223214_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, 0.143705357_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.197187500_wp, 0.223928571_wp, & 
   & 0.223928571_wp, 0.277410714_wp, 0.304151786_wp, 0.277410714_wp, & 
   & 0.223928571_wp, 0.223928571_wp, 0.250669643_wp, 0.250669643_wp, & 
   & 0.277410714_wp, 0.304151786_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.143705357_wp, 0.116964286_wp, 0.116964286_wp, 0.170446429_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.197187500_wp, 0.170446429_wp, & 
   & 0.116964286_wp, 0.197187500_wp, 0.170446429_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 42) / &
   & 1.106383929_wp, 1.587723214_wp, 0.277410714_wp, 0.277410714_wp, & 
   & 0.518080357_wp, 0.785491071_wp, 0.865714286_wp, 0.919196429_wp, & 
   & 1.052901786_wp, 1.186607143_wp, 0.223928571_wp, 0.116964286_wp, & 
   & 0.330892857_wp, 0.411116071_wp, 0.491339286_wp, 0.544821429_wp, & 
   & 0.598303571_wp, 0.678526786_wp, 0.090223214_wp, 0.223928571_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, 0.277410714_wp, & 
   & 0.223928571_wp, 0.250669643_wp, 0.250669643_wp, 0.277410714_wp, & 
   & 0.384375000_wp, 0.304151786_wp, 0.357633929_wp, 0.411116071_wp, & 
   & 0.464598214_wp, 0.491339286_wp, 0.518080357_wp, 0.571562500_wp, & 
   & 0.063482143_wp, 0.197187500_wp, 0.197187500_wp, 0.170446429_wp, & 
   & 0.197187500_wp, 0.250669643_wp, 0.143705357_wp, 0.223928571_wp, & 
   & 0.250669643_wp, 0.277410714_wp, 0.384375000_wp, 0.304151786_wp, & 
   & 0.304151786_wp, 0.357633929_wp, 0.384375000_wp, 0.411116071_wp, & 
   & 0.437857143_wp, 0.464598214_wp, 0.063482143_wp, 0.223928571_wp, & 
   & 0.170446429_wp, 0.411116071_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, 0.197187500_wp, & 
   & 0.223928571_wp, 0.197187500_wp, 0.197187500_wp, 0.250669643_wp, & 
   & 0.304151786_wp, 0.384375000_wp, 0.437857143_wp, 0.384375000_wp, & 
   & 0.304151786_wp, 0.330892857_wp, 0.357633929_wp, 0.384375000_wp, & 
   & 0.411116071_wp, 0.437857143_wp, 0.170446429_wp, 0.197187500_wp, & 
   & 0.223928571_wp, 0.170446429_wp, 0.170446429_wp, 0.223928571_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.277410714_wp, 0.250669643_wp, & 
   & 0.170446429_wp, 0.250669643_wp, 0.197187500_wp, 0.170446429_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.250669643_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 43) / &
   & 0.384375000_wp, 0.491339286_wp, 0.304151786_wp, 0.170446429_wp, & 
   & 0.250669643_wp, 0.250669643_wp, 0.277410714_wp, 0.304151786_wp, & 
   & 0.357633929_wp, 0.384375000_wp, 0.197187500_wp, 0.116964286_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.143705357_wp, 0.116964286_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.143705357_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, 0.197187500_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.143705357_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.143705357_wp, 0.090223214_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.143705357_wp, 0.170446429_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.116964286_wp, 0.143705357_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.143705357_wp, 0.116964286_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.090223214_wp, 0.116964286_wp, 0.116964286_wp, 0.143705357_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.143705357_wp, 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 44) / &
   & 0.544821429_wp, 0.705267857_wp, 0.330892857_wp, 0.223928571_wp, & 
   & 0.357633929_wp, 0.384375000_wp, 0.384375000_wp, 0.437857143_wp, & 
   & 0.491339286_wp, 0.544821429_wp, 0.223928571_wp, 0.143705357_wp, & 
   & 0.250669643_wp, 0.250669643_wp, 0.250669643_wp, 0.277410714_wp, & 
   & 0.304151786_wp, 0.330892857_wp, 0.116964286_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.170446429_wp, 0.223928571_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.277410714_wp, 0.250669643_wp, & 
   & 0.250669643_wp, 0.277410714_wp, 0.223928571_wp, 0.250669643_wp, & 
   & 0.223928571_wp, 0.250669643_wp, 0.250669643_wp, 0.277410714_wp, & 
   & 0.090223214_wp, 0.197187500_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.223928571_wp, 0.223928571_wp, 0.143705357_wp, 0.170446429_wp, & 
   & 0.223928571_wp, 0.250669643_wp, 0.223928571_wp, 0.223928571_wp, & 
   & 0.223928571_wp, 0.223928571_wp, 0.197187500_wp, 0.223928571_wp, & 
   & 0.223928571_wp, 0.223928571_wp, 0.063482143_wp, 0.170446429_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, 0.250669643_wp, & 
   & 0.250669643_wp, 0.223928571_wp, 0.143705357_wp, 0.170446429_wp, & 
   & 0.223928571_wp, 0.223928571_wp, 0.223928571_wp, 0.223928571_wp, & 
   & 0.223928571_wp, 0.197187500_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.143705357_wp, 0.197187500_wp, 0.170446429_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 45) / &
   & 1.106383929_wp, 1.694687500_wp, 0.250669643_wp, 0.277410714_wp, & 
   & 0.464598214_wp, 0.758750000_wp, 0.865714286_wp, 0.945937500_wp, & 
   & 1.133125000_wp, 1.293571429_wp, 0.223928571_wp, 0.116964286_wp, & 
   & 0.304151786_wp, 0.357633929_wp, 0.437857143_wp, 0.518080357_wp, & 
   & 0.571562500_wp, 0.651785714_wp, 0.090223214_wp, 0.197187500_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, 0.250669643_wp, & 
   & 0.223928571_wp, 0.223928571_wp, 0.250669643_wp, 0.250669643_wp, & 
   & 0.357633929_wp, 0.304151786_wp, 0.304151786_wp, 0.357633929_wp, & 
   & 0.411116071_wp, 0.437857143_wp, 0.491339286_wp, 0.544821429_wp, & 
   & 0.063482143_wp, 0.170446429_wp, 0.197187500_wp, 0.170446429_wp, & 
   & 0.197187500_wp, 0.250669643_wp, 0.143705357_wp, 0.223928571_wp, & 
   & 0.223928571_wp, 0.277410714_wp, 0.330892857_wp, 0.304151786_wp, & 
   & 0.277410714_wp, 0.304151786_wp, 0.330892857_wp, 0.357633929_wp, & 
   & 0.384375000_wp, 0.411116071_wp, 0.063482143_wp, 0.197187500_wp, & 
   & 0.170446429_wp, 0.357633929_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, 0.197187500_wp, & 
   & 0.223928571_wp, 0.197187500_wp, 0.197187500_wp, 0.250669643_wp, & 
   & 0.277410714_wp, 0.357633929_wp, 0.384375000_wp, 0.357633929_wp, & 
   & 0.277410714_wp, 0.277410714_wp, 0.330892857_wp, 0.330892857_wp, & 
   & 0.357633929_wp, 0.384375000_wp, 0.143705357_wp, 0.170446429_wp, & 
   & 0.197187500_wp, 0.170446429_wp, 0.143705357_wp, 0.223928571_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.250669643_wp, 0.223928571_wp, & 
   & 0.170446429_wp, 0.250669643_wp, 0.197187500_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.223928571_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 46) / &
   & 1.133125000_wp, 1.507500000_wp, 0.304151786_wp, 0.304151786_wp, & 
   & 0.544821429_wp, 0.812232143_wp, 0.892455357_wp, 0.945937500_wp, & 
   & 1.052901786_wp, 1.186607143_wp, 0.250669643_wp, 0.116964286_wp, & 
   & 0.357633929_wp, 0.437857143_wp, 0.518080357_wp, 0.571562500_wp, & 
   & 0.625044643_wp, 0.705267857_wp, 0.090223214_wp, 0.250669643_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.170446429_wp, 0.304151786_wp, & 
   & 0.250669643_wp, 0.250669643_wp, 0.277410714_wp, 0.304151786_wp, & 
   & 0.411116071_wp, 0.330892857_wp, 0.384375000_wp, 0.411116071_wp, & 
   & 0.464598214_wp, 0.518080357_wp, 0.544821429_wp, 0.598303571_wp, & 
   & 0.090223214_wp, 0.223928571_wp, 0.223928571_wp, 0.197187500_wp, & 
   & 0.223928571_wp, 0.277410714_wp, 0.170446429_wp, 0.250669643_wp, & 
   & 0.277410714_wp, 0.304151786_wp, 0.411116071_wp, 0.330892857_wp, & 
   & 0.330892857_wp, 0.357633929_wp, 0.411116071_wp, 0.437857143_wp, & 
   & 0.464598214_wp, 0.491339286_wp, 0.063482143_wp, 0.223928571_wp, & 
   & 0.197187500_wp, 0.437857143_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, 0.223928571_wp, & 
   & 0.250669643_wp, 0.223928571_wp, 0.197187500_wp, 0.277410714_wp, & 
   & 0.304151786_wp, 0.411116071_wp, 0.437857143_wp, 0.411116071_wp, & 
   & 0.330892857_wp, 0.357633929_wp, 0.384375000_wp, 0.411116071_wp, & 
   & 0.437857143_wp, 0.437857143_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.223928571_wp, 0.197187500_wp, 0.170446429_wp, 0.250669643_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.304151786_wp, 0.250669643_wp, & 
   & 0.170446429_wp, 0.277410714_wp, 0.223928571_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.277410714_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 47) / &
   & 1.614464286_wp, 4.101383929_wp, 0.411116071_wp, 0.277410714_wp, & 
   & 0.945937500_wp, 1.454017857_wp, 1.881875000_wp, 2.309732143_wp, & 
   & 2.630625000_wp, 3.085223214_wp, 0.223928571_wp, 0.116964286_wp, & 
   & 0.571562500_wp, 0.812232143_wp, 1.133125000_wp, 1.320312500_wp, & 
   & 1.507500000_wp, 1.614464286_wp, 0.090223214_wp, 0.330892857_wp, & 
   & 0.223928571_wp, 0.250669643_wp, 0.197187500_wp, 0.384375000_wp, & 
   & 0.223928571_wp, 0.223928571_wp, 0.357633929_wp, 0.384375000_wp, & 
   & 0.678526786_wp, 0.437857143_wp, 0.651785714_wp, 0.812232143_wp, & 
   & 1.052901786_wp, 1.213348214_wp, 1.320312500_wp, 1.347053571_wp, & 
   & 0.063482143_wp, 0.304151786_wp, 0.223928571_wp, 0.250669643_wp, & 
   & 0.250669643_wp, 0.384375000_wp, 0.143705357_wp, 0.223928571_wp, & 
   & 0.330892857_wp, 0.411116071_wp, 0.678526786_wp, 0.464598214_wp, & 
   & 0.544821429_wp, 0.705267857_wp, 0.838973214_wp, 0.972678571_wp, & 
   & 1.079642857_wp, 1.106383929_wp, 0.063482143_wp, 0.277410714_wp, & 
   & 0.197187500_wp, 0.919196429_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.223928571_wp, 0.223928571_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.197187500_wp, 0.330892857_wp, & 
   & 0.330892857_wp, 0.197187500_wp, 0.170446429_wp, 0.250669643_wp, & 
   & 0.437857143_wp, 0.732008929_wp, 0.919196429_wp, 0.651785714_wp, & 
   & 0.571562500_wp, 0.598303571_wp, 0.785491071_wp, 0.892455357_wp, & 
   & 0.972678571_wp, 0.999419643_wp, 0.250669643_wp, 0.277410714_wp, & 
   & 0.277410714_wp, 0.250669643_wp, 0.223928571_wp, 0.304151786_wp, & 
   & 0.250669643_wp, 0.250669643_wp, 0.437857143_wp, 0.304151786_wp, & 
   & 0.223928571_wp, 0.357633929_wp, 0.223928571_wp, 0.223928571_wp, & 
   & 0.250669643_wp, 0.277410714_wp, 0.304151786_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 48) / &
   & 2.684107143_wp, 2.015580357_wp, 0.330892857_wp, 0.277410714_wp, & 
   & 0.625044643_wp, 0.972678571_wp, 1.079642857_wp, 1.159866071_wp, & 
   & 1.347053571_wp, 1.534241071_wp, 0.250669643_wp, 0.116964286_wp, & 
   & 0.384375000_wp, 0.491339286_wp, 0.598303571_wp, 0.678526786_wp, & 
   & 0.732008929_wp, 0.838973214_wp, 0.090223214_wp, 0.277410714_wp, & 
   & 0.223928571_wp, 0.223928571_wp, 0.197187500_wp, 0.330892857_wp, & 
   & 0.223928571_wp, 0.250669643_wp, 0.304151786_wp, 0.330892857_wp, & 
   & 0.464598214_wp, 0.384375000_wp, 0.437857143_wp, 0.491339286_wp, & 
   & 0.571562500_wp, 0.598303571_wp, 0.651785714_wp, 0.705267857_wp, & 
   & 0.063482143_wp, 0.250669643_wp, 0.223928571_wp, 0.223928571_wp, & 
   & 0.223928571_wp, 0.304151786_wp, 0.170446429_wp, 0.223928571_wp, & 
   & 0.304151786_wp, 0.330892857_wp, 0.464598214_wp, 0.384375000_wp, & 
   & 0.384375000_wp, 0.437857143_wp, 0.464598214_wp, 0.518080357_wp, & 
   & 0.544821429_wp, 0.571562500_wp, 0.063482143_wp, 0.250669643_wp, & 
   & 0.197187500_wp, 0.491339286_wp, 0.143705357_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.197187500_wp, 0.250669643_wp, & 
   & 0.277410714_wp, 0.223928571_wp, 0.197187500_wp, 0.250669643_wp, & 
   & 0.357633929_wp, 0.464598214_wp, 0.518080357_wp, 0.464598214_wp, & 
   & 0.384375000_wp, 0.411116071_wp, 0.437857143_wp, 0.464598214_wp, & 
   & 0.491339286_wp, 0.518080357_wp, 0.197187500_wp, 0.223928571_wp, & 
   & 0.250669643_wp, 0.223928571_wp, 0.197187500_wp, 0.277410714_wp, & 
   & 0.223928571_wp, 0.223928571_wp, 0.330892857_wp, 0.277410714_wp, & 
   & 0.197187500_wp, 0.304151786_wp, 0.223928571_wp, 0.197187500_wp, & 
   & 0.223928571_wp, 0.250669643_wp, 0.304151786_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 49) / &
   & 1.587723214_wp, 4.903616071_wp, 0.330892857_wp, 0.277410714_wp, & 
   & 0.999419643_wp, 1.427276786_wp, 2.095803571_wp, 3.058482143_wp, & 
   & 3.566562500_wp, 3.940937500_wp, 0.223928571_wp, 0.116964286_wp, & 
   & 1.667946429_wp, 1.855133929_wp, 1.962098214_wp, 2.069062500_wp, & 
   & 2.256250000_wp, 2.470178571_wp, 0.063482143_wp, 0.250669643_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.170446429_wp, 0.330892857_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.304151786_wp, 0.330892857_wp, & 
   & 0.571562500_wp, 0.357633929_wp, 1.560982143_wp, 1.855133929_wp, & 
   & 1.828392857_wp, 1.935357143_wp, 1.988839286_wp, 2.176026786_wp, & 
   & 0.063482143_wp, 0.223928571_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.304151786_wp, 0.143705357_wp, 0.223928571_wp, & 
   & 0.277410714_wp, 0.330892857_wp, 0.544821429_wp, 0.384375000_wp, & 
   & 1.400535714_wp, 1.667946429_wp, 1.694687500_wp, 1.721428571_wp, & 
   & 1.774910714_wp, 1.908616071_wp, 0.063482143_wp, 0.223928571_wp, & 
   & 0.170446429_wp, 1.748169643_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, 0.250669643_wp, & 
   & 0.250669643_wp, 0.197187500_wp, 0.170446429_wp, 0.250669643_wp, & 
   & 0.357633929_wp, 0.625044643_wp, 1.881875000_wp, 0.544821429_wp, & 
   & 0.411116071_wp, 0.464598214_wp, 1.667946429_wp, 1.641205357_wp, & 
   & 1.721428571_wp, 1.801651786_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.170446429_wp, 0.250669643_wp, & 
   & 0.892455357_wp, 0.197187500_wp, 0.357633929_wp, 0.250669643_wp, & 
   & 0.170446429_wp, 0.277410714_wp, 0.197187500_wp, 0.170446429_wp, & 
   & 1.908616071_wp, 0.223928571_wp, 0.250669643_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 50) / &
   & 1.587723214_wp, 6.000000000_wp, 0.384375000_wp, 0.277410714_wp, & 
   & 1.106383929_wp, 1.347053571_wp, 1.988839286_wp, 3.459598214_wp, & 
   & 3.753750000_wp, 4.876875000_wp, 0.223928571_wp, 0.116964286_wp, & 
   & 0.625044643_wp, 0.945937500_wp, 1.667946429_wp, 2.256250000_wp, & 
   & 2.630625000_wp, 2.470178571_wp, 0.090223214_wp, 0.304151786_wp, & 
   & 0.223928571_wp, 0.223928571_wp, 0.170446429_wp, 0.357633929_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.330892857_wp, 0.357633929_wp, & 
   & 0.705267857_wp, 0.411116071_wp, 0.758750000_wp, 1.026160714_wp, & 
   & 1.641205357_wp, 2.176026786_wp, 2.577142857_wp, 2.095803571_wp, & 
   & 0.063482143_wp, 0.277410714_wp, 0.223928571_wp, 0.223928571_wp, & 
   & 0.223928571_wp, 0.357633929_wp, 0.143705357_wp, 0.223928571_wp, & 
   & 0.304151786_wp, 0.357633929_wp, 0.705267857_wp, 0.437857143_wp, & 
   & 1.667946429_wp, 0.838973214_wp, 1.186607143_wp, 1.560982143_wp, & 
   & 1.881875000_wp, 1.694687500_wp, 0.063482143_wp, 0.250669643_wp, & 
   & 0.197187500_wp, 1.400535714_wp, 0.143705357_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.197187500_wp, 0.304151786_wp, & 
   & 0.304151786_wp, 0.197187500_wp, 0.170446429_wp, 0.223928571_wp, & 
   & 0.411116071_wp, 0.705267857_wp, 1.159866071_wp, 0.651785714_wp, & 
   & 1.641205357_wp, 0.678526786_wp, 1.079642857_wp, 1.400535714_wp, & 
   & 1.855133929_wp, 1.480758929_wp, 0.223928571_wp, 0.250669643_wp, & 
   & 0.223928571_wp, 0.223928571_wp, 0.785491071_wp, 0.304151786_wp, & 
   & 0.223928571_wp, 0.223928571_wp, 0.571562500_wp, 0.277410714_wp, & 
   & 0.197187500_wp, 0.330892857_wp, 0.223928571_wp, 0.197187500_wp, & 
   & 0.223928571_wp, 0.250669643_wp, 0.304151786_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 51) / &
   & 1.774910714_wp, 6.000000000_wp, 0.411116071_wp, 0.250669643_wp, & 
   & 1.400535714_wp, 1.400535714_wp, 2.095803571_wp, 5.545401786_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.197187500_wp, 0.090223214_wp, & 
   & 1.935357143_wp, 1.427276786_wp, 2.470178571_wp, 3.673526786_wp, & 
   & 4.021160714_wp, 4.475758929_wp, 0.063482143_wp, 0.357633929_wp, & 
   & 0.250669643_wp, 0.250669643_wp, 0.197187500_wp, 0.357633929_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.357633929_wp, 0.411116071_wp, & 
   & 0.838973214_wp, 0.464598214_wp, 1.774910714_wp, 1.560982143_wp, & 
   & 2.523660714_wp, 3.325892857_wp, 3.539821429_wp, 3.833973214_wp, & 
   & 0.063482143_wp, 0.330892857_wp, 0.223928571_wp, 0.250669643_wp, & 
   & 0.250669643_wp, 0.384375000_wp, 0.143705357_wp, 0.197187500_wp, & 
   & 0.330892857_wp, 0.411116071_wp, 0.838973214_wp, 0.464598214_wp, & 
   & 1.694687500_wp, 1.186607143_wp, 2.095803571_wp, 2.978258929_wp, & 
   & 3.085223214_wp, 3.272410714_wp, 0.063482143_wp, 0.304151786_wp, & 
   & 0.197187500_wp, 2.791071429_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.223928571_wp, 0.223928571_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.197187500_wp, 0.384375000_wp, & 
   & 0.357633929_wp, 0.197187500_wp, 0.170446429_wp, 0.223928571_wp, & 
   & 0.464598214_wp, 0.678526786_wp, 1.748169643_wp, 0.705267857_wp, & 
   & 1.480758929_wp, 0.919196429_wp, 1.828392857_wp, 2.844553571_wp, & 
   & 2.924776786_wp, 3.058482143_wp, 0.304151786_wp, 0.304151786_wp, & 
   & 0.277410714_wp, 0.838973214_wp, 0.945937500_wp, 0.330892857_wp, & 
   & 0.277410714_wp, 0.250669643_wp, 0.651785714_wp, 0.304151786_wp, & 
   & 0.838973214_wp, 0.384375000_wp, 0.250669643_wp, 0.223928571_wp, & 
   & 0.250669643_wp, 0.277410714_wp, 0.330892857_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 52) / &
   & 1.881875000_wp, 6.000000000_wp, 0.411116071_wp, 0.250669643_wp, & 
   & 1.667946429_wp, 1.454017857_wp, 2.229508929_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.197187500_wp, 0.116964286_wp, & 
   & 1.988839286_wp, 1.962098214_wp, 2.844553571_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.063482143_wp, 0.411116071_wp, & 
   & 0.250669643_wp, 0.277410714_wp, 0.223928571_wp, 0.357633929_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.384375000_wp, 0.437857143_wp, & 
   & 0.945937500_wp, 0.491339286_wp, 1.801651786_wp, 1.908616071_wp, & 
   & 3.111964286_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 0.063482143_wp, 0.357633929_wp, 0.250669643_wp, 0.277410714_wp, & 
   & 0.277410714_wp, 0.411116071_wp, 0.143705357_wp, 0.223928571_wp, & 
   & 0.357633929_wp, 0.437857143_wp, 0.972678571_wp, 0.518080357_wp, & 
   & 1.721428571_wp, 1.560982143_wp, 2.978258929_wp, 4.422276786_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.063482143_wp, 0.357633929_wp, & 
   & 0.223928571_wp, 5.491919643_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.250669643_wp, 0.223928571_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.223928571_wp, 0.437857143_wp, & 
   & 0.384375000_wp, 0.197187500_wp, 0.170446429_wp, 0.223928571_wp, & 
   & 0.518080357_wp, 0.678526786_wp, 2.336473214_wp, 0.758750000_wp, & 
   & 1.507500000_wp, 1.320312500_wp, 2.791071429_wp, 4.047901786_wp, & 
   & 5.732589286_wp, 6.000000000_wp, 0.330892857_wp, 0.357633929_wp, & 
   & 0.304151786_wp, 0.785491071_wp, 0.250669643_wp, 0.357633929_wp, & 
   & 0.304151786_wp, 0.250669643_wp, 0.758750000_wp, 0.330892857_wp, & 
   & 0.972678571_wp, 0.384375000_wp, 0.250669643_wp, 0.250669643_wp, & 
   & 1.935357143_wp, 0.304151786_wp, 0.357633929_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 53) / &
   & 2.042321429_wp, 6.000000000_wp, 0.437857143_wp, 0.277410714_wp, & 
   & 1.748169643_wp, 1.534241071_wp, 2.389955357_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.223928571_wp, 0.116964286_wp, & 
   & 2.042321429_wp, 2.202767857_wp, 2.978258929_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.090223214_wp, 0.437857143_wp, & 
   & 0.277410714_wp, 0.304151786_wp, 0.223928571_wp, 0.357633929_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.411116071_wp, 0.464598214_wp, & 
   & 1.026160714_wp, 0.518080357_wp, 1.801651786_wp, 2.363214286_wp, & 
   & 3.218928571_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 0.063482143_wp, 0.384375000_wp, 0.277410714_wp, 0.304151786_wp, & 
   & 0.304151786_wp, 0.437857143_wp, 0.143705357_wp, 0.223928571_wp, & 
   & 0.384375000_wp, 0.464598214_wp, 1.079642857_wp, 0.544821429_wp, & 
   & 1.774910714_wp, 1.881875000_wp, 3.085223214_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.063482143_wp, 0.384375000_wp, & 
   & 0.223928571_wp, 6.000000000_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.277410714_wp, 0.250669643_wp, & 
   & 0.223928571_wp, 0.223928571_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.223928571_wp, 0.491339286_wp, & 
   & 0.411116071_wp, 0.197187500_wp, 0.170446429_wp, 0.250669643_wp, & 
   & 0.571562500_wp, 0.705267857_wp, 3.325892857_wp, 0.838973214_wp, & 
   & 1.587723214_wp, 1.774910714_wp, 3.138705357_wp, 5.491919643_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.357633929_wp, 0.411116071_wp, & 
   & 0.330892857_wp, 0.812232143_wp, 0.812232143_wp, 0.384375000_wp, & 
   & 0.384375000_wp, 0.277410714_wp, 0.838973214_wp, 0.357633929_wp, & 
   & 0.945937500_wp, 0.437857143_wp, 0.277410714_wp, 0.250669643_wp, & 
   & 1.881875000_wp, 0.330892857_wp, 0.384375000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 54) / &
   & 2.069062500_wp, 6.000000000_wp, 0.437857143_wp, 0.277410714_wp, & 
   & 1.774910714_wp, 1.587723214_wp, 2.443437500_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.223928571_wp, 0.116964286_wp, & 
   & 2.149285714_wp, 1.908616071_wp, 3.165446429_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.090223214_wp, 0.464598214_wp, & 
   & 0.304151786_wp, 0.330892857_wp, 0.250669643_wp, 0.384375000_wp, & 
   & 0.223928571_wp, 0.250669643_wp, 0.437857143_wp, 0.491339286_wp, & 
   & 1.079642857_wp, 0.544821429_wp, 1.962098214_wp, 1.988839286_wp, & 
   & 3.406116071_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 0.063482143_wp, 0.411116071_wp, 0.277410714_wp, 0.330892857_wp, & 
   & 0.330892857_wp, 0.464598214_wp, 0.170446429_wp, 0.223928571_wp, & 
   & 0.411116071_wp, 0.491339286_wp, 1.106383929_wp, 0.571562500_wp, & 
   & 1.908616071_wp, 1.694687500_wp, 3.272410714_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.063482143_wp, 0.437857143_wp, & 
   & 0.250669643_wp, 6.000000000_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.304151786_wp, 0.250669643_wp, & 
   & 0.223928571_wp, 0.223928571_wp, 0.223928571_wp, 0.223928571_wp, & 
   & 0.223928571_wp, 0.223928571_wp, 0.250669643_wp, 0.518080357_wp, & 
   & 0.437857143_wp, 0.223928571_wp, 0.197187500_wp, 0.250669643_wp, & 
   & 0.598303571_wp, 0.758750000_wp, 2.443437500_wp, 0.865714286_wp, & 
   & 1.721428571_wp, 1.427276786_wp, 2.603883929_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.411116071_wp, 2.256250000_wp, & 
   & 0.357633929_wp, 0.865714286_wp, 0.945937500_wp, 0.411116071_wp, & 
   & 0.544821429_wp, 0.304151786_wp, 0.945937500_wp, 0.384375000_wp, & 
   & 1.026160714_wp, 0.491339286_wp, 0.304151786_wp, 0.304151786_wp, & 
   & 1.962098214_wp, 0.384375000_wp, 0.437857143_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 55) / &
   & 0.250669643_wp, 0.785491071_wp, 0.090223214_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.143705357_wp, 0.170446429_wp, & 
   & 0.384375000_wp, 1.079642857_wp, 0.143705357_wp, 0.036741071_wp, & 
   & 0.063482143_wp, 0.063482143_wp, 0.063482143_wp, 0.063482143_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.036741071_wp, 0.036741071_wp, & 
   & 0.063482143_wp, 0.063482143_wp, 0.063482143_wp, 0.063482143_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.063482143_wp, 0.063482143_wp, & 
   & 0.063482143_wp, 0.063482143_wp, 0.063482143_wp, 0.063482143_wp, & 
   & 0.063482143_wp, 0.063482143_wp, 0.063482143_wp, 0.090223214_wp, & 
   & 0.036741071_wp, 0.036741071_wp, 0.036741071_wp, 0.063482143_wp, & 
   & 0.063482143_wp, 0.063482143_wp, 0.090223214_wp, 0.063482143_wp, & 
   & 0.063482143_wp, 0.063482143_wp, 0.063482143_wp, 0.063482143_wp, & 
   & 0.063482143_wp, 0.063482143_wp, 0.063482143_wp, 0.063482143_wp, & 
   & 0.063482143_wp, 0.063482143_wp, 0.036741071_wp, 0.036741071_wp, & 
   & 0.036741071_wp, 0.063482143_wp, 0.036741071_wp, 0.063482143_wp, & 
   & 0.063482143_wp, 0.036741071_wp, 0.036741071_wp, 0.036741071_wp, & 
   & 0.063482143_wp, 0.036741071_wp, 0.063482143_wp, 0.063482143_wp, & 
   & 0.063482143_wp, 0.063482143_wp, 0.063482143_wp, 0.063482143_wp, & 
   & 0.063482143_wp, 0.063482143_wp, 0.063482143_wp, 0.063482143_wp, & 
   & 0.063482143_wp, 0.063482143_wp, 0.063482143_wp, 0.063482143_wp, & 
   & 0.063482143_wp, 0.063482143_wp, 0.063482143_wp, 0.063482143_wp, & 
   & 0.063482143_wp, 0.063482143_wp, 0.036741071_wp, 0.036741071_wp, & 
   & 0.036741071_wp, 0.036741071_wp, 0.036741071_wp, 0.036741071_wp, & 
   & 0.036741071_wp, 0.036741071_wp, 0.036741071_wp, 0.036741071_wp, & 
   & 0.036741071_wp, 0.036741071_wp, 0.036741071_wp, 0.036741071_wp, & 
   & 0.036741071_wp, 0.036741071_wp, 0.036741071_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 56) / &
   & 1.159866071_wp, 1.748169643_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.384375000_wp, 0.838973214_wp, 1.106383929_wp, 1.159866071_wp, & 
   & 1.347053571_wp, 1.400535714_wp, 0.170446429_wp, 0.063482143_wp, & 
   & 0.223928571_wp, 0.330892857_wp, 0.437857143_wp, 0.598303571_wp, & 
   & 0.838973214_wp, 0.945937500_wp, 0.036741071_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.116964286_wp, 0.223928571_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.197187500_wp, 0.223928571_wp, & 
   & 0.304151786_wp, 0.250669643_wp, 0.277410714_wp, 0.304151786_wp, & 
   & 0.384375000_wp, 0.491339286_wp, 0.598303571_wp, 0.838973214_wp, & 
   & 0.036741071_wp, 0.143705357_wp, 0.116964286_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.223928571_wp, 0.090223214_wp, 0.170446429_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.277410714_wp, 0.250669643_wp, & 
   & 0.223928571_wp, 0.250669643_wp, 0.304151786_wp, 0.357633929_wp, & 
   & 0.384375000_wp, 0.437857143_wp, 0.036741071_wp, 0.116964286_wp, & 
   & 0.090223214_wp, 0.330892857_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.170446429_wp, 0.143705357_wp, 0.116964286_wp, 0.170446429_wp, & 
   & 0.223928571_wp, 0.330892857_wp, 0.357633929_wp, 0.330892857_wp, & 
   & 0.223928571_wp, 0.250669643_wp, 0.277410714_wp, 0.330892857_wp, & 
   & 0.357633929_wp, 0.384375000_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.090223214_wp, 0.143705357_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.170446429_wp, 0.143705357_wp, & 
   & 0.090223214_wp, 0.170446429_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.143705357_wp, 0.143705357_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 57) / &
   & 0.544821429_wp, 0.865714286_wp, 0.170446429_wp, 0.223928571_wp, & 
   & 0.277410714_wp, 0.411116071_wp, 0.464598214_wp, 0.491339286_wp, & 
   & 0.571562500_wp, 0.651785714_wp, 0.143705357_wp, 0.090223214_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.250669643_wp, 0.304151786_wp, & 
   & 0.330892857_wp, 0.357633929_wp, 0.063482143_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.143705357_wp, 0.116964286_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.170446429_wp, 0.197187500_wp, & 
   & 0.223928571_wp, 0.223928571_wp, 0.197187500_wp, 0.223928571_wp, & 
   & 0.250669643_wp, 0.250669643_wp, 0.277410714_wp, 0.304151786_wp, & 
   & 0.036741071_wp, 0.116964286_wp, 0.116964286_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.116964286_wp, 0.197187500_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.197187500_wp, 0.223928571_wp, & 
   & 0.223928571_wp, 0.250669643_wp, 0.036741071_wp, 0.090223214_wp, & 
   & 0.090223214_wp, 0.223928571_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, 0.143705357_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.143705357_wp, 0.197187500_wp, & 
   & 0.170446429_wp, 0.223928571_wp, 0.223928571_wp, 0.223928571_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.223928571_wp, 0.223928571_wp, 0.090223214_wp, 0.116964286_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, 0.223928571_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.170446429_wp, 0.116964286_wp, & 
   & 0.090223214_wp, 0.197187500_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 58) / &
   & 1.881875000_wp, 6.000000000_wp, 0.384375000_wp, 0.250669643_wp, & 
   & 1.560982143_wp, 1.454017857_wp, 2.256250000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.197187500_wp, 0.090223214_wp, & 
   & 1.988839286_wp, 1.667946429_wp, 2.791071429_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.063482143_wp, 0.384375000_wp, & 
   & 0.250669643_wp, 0.277410714_wp, 0.197187500_wp, 0.330892857_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.384375000_wp, 0.411116071_wp, & 
   & 0.892455357_wp, 0.464598214_wp, 1.801651786_wp, 1.774910714_wp, & 
   & 3.085223214_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 0.063482143_wp, 0.357633929_wp, 0.250669643_wp, 0.277410714_wp, & 
   & 0.277410714_wp, 0.411116071_wp, 0.143705357_wp, 0.197187500_wp, & 
   & 0.357633929_wp, 0.437857143_wp, 0.919196429_wp, 0.491339286_wp, & 
   & 1.748169643_wp, 1.400535714_wp, 2.791071429_wp, 5.491919643_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.063482143_wp, 0.330892857_wp, & 
   & 0.223928571_wp, 6.000000000_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.250669643_wp, 0.223928571_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.223928571_wp, 0.437857143_wp, & 
   & 0.384375000_wp, 0.170446429_wp, 0.170446429_wp, 0.223928571_wp, & 
   & 0.491339286_wp, 0.651785714_wp, 1.988839286_wp, 0.758750000_wp, & 
   & 1.480758929_wp, 1.240089286_wp, 2.309732143_wp, 4.903616071_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.304151786_wp, 0.357633929_wp, & 
   & 0.277410714_wp, 0.785491071_wp, 0.250669643_wp, 0.330892857_wp, & 
   & 0.277410714_wp, 0.250669643_wp, 0.705267857_wp, 0.330892857_wp, & 
   & 0.972678571_wp, 0.384375000_wp, 0.250669643_wp, 0.223928571_wp, & 
   & 1.881875000_wp, 0.304151786_wp, 0.357633929_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 59) / &
   & 0.464598214_wp, 0.705267857_wp, 0.090223214_wp, 0.197187500_wp, & 
   & 0.250669643_wp, 0.304151786_wp, 0.384375000_wp, 0.411116071_wp, & 
   & 0.464598214_wp, 0.544821429_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.197187500_wp, 0.223928571_wp, & 
   & 0.250669643_wp, 0.304151786_wp, 0.063482143_wp, 0.090223214_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.223928571_wp, 0.250669643_wp, & 
   & 0.063482143_wp, 0.090223214_wp, 0.116964286_wp, 0.090223214_wp, & 
   & 0.090223214_wp, 0.116964286_wp, 0.116964286_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.036741071_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.170446429_wp, 0.063482143_wp, 0.063482143_wp, & 
   & 0.063482143_wp, 0.063482143_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.063482143_wp, 0.063482143_wp, 0.063482143_wp, 0.063482143_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.116964286_wp, 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.063482143_wp, 0.090223214_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.090223214_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.090223214_wp, 0.143705357_wp, 0.143705357_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.143705357_wp, 0.143705357_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 60) / &
   & 0.491339286_wp, 0.732008929_wp, 0.090223214_wp, 0.197187500_wp, & 
   & 0.250669643_wp, 0.304151786_wp, 0.384375000_wp, 0.411116071_wp, & 
   & 0.491339286_wp, 0.544821429_wp, 0.116964286_wp, 0.090223214_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.223928571_wp, 0.250669643_wp, & 
   & 0.277410714_wp, 0.304151786_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, 0.116964286_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.223928571_wp, 0.250669643_wp, & 
   & 0.063482143_wp, 0.090223214_wp, 0.116964286_wp, 0.090223214_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.063482143_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.170446429_wp, 0.063482143_wp, 0.063482143_wp, & 
   & 0.063482143_wp, 0.063482143_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.063482143_wp, 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.116964286_wp, 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.197187500_wp, 0.170446429_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.063482143_wp, 0.090223214_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.090223214_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.090223214_wp, 0.143705357_wp, 0.143705357_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.143705357_wp, 0.170446429_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 61) / &
   & 0.491339286_wp, 0.732008929_wp, 0.090223214_wp, 0.197187500_wp, & 
   & 0.250669643_wp, 0.304151786_wp, 0.384375000_wp, 0.411116071_wp, & 
   & 0.491339286_wp, 0.571562500_wp, 0.116964286_wp, 0.090223214_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.223928571_wp, 0.250669643_wp, & 
   & 0.277410714_wp, 0.304151786_wp, 0.090223214_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.090223214_wp, 0.116964286_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.223928571_wp, 0.250669643_wp, & 
   & 0.063482143_wp, 0.090223214_wp, 0.143705357_wp, 0.090223214_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.063482143_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.170446429_wp, 0.063482143_wp, 0.063482143_wp, & 
   & 0.063482143_wp, 0.063482143_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.116964286_wp, 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.197187500_wp, 0.170446429_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.063482143_wp, 0.090223214_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.090223214_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.090223214_wp, 0.143705357_wp, 0.143705357_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.143705357_wp, 0.170446429_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 62) / &
   & 0.491339286_wp, 0.732008929_wp, 0.090223214_wp, 0.197187500_wp, & 
   & 0.250669643_wp, 0.330892857_wp, 0.384375000_wp, 0.437857143_wp, & 
   & 0.491339286_wp, 0.571562500_wp, 0.116964286_wp, 0.090223214_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.223928571_wp, 0.250669643_wp, & 
   & 0.277410714_wp, 0.304151786_wp, 0.090223214_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.090223214_wp, 0.116964286_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.223928571_wp, 0.250669643_wp, & 
   & 0.063482143_wp, 0.090223214_wp, 0.143705357_wp, 0.090223214_wp, & 
   & 0.116964286_wp, 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.036741071_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.170446429_wp, 0.063482143_wp, 0.063482143_wp, & 
   & 0.063482143_wp, 0.063482143_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.116964286_wp, 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.063482143_wp, 0.090223214_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.090223214_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.090223214_wp, 0.143705357_wp, 0.143705357_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.143705357_wp, 0.170446429_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 63) / &
   & 0.651785714_wp, 1.052901786_wp, 0.116964286_wp, 0.250669643_wp, & 
   & 0.330892857_wp, 0.491339286_wp, 0.571562500_wp, 0.625044643_wp, & 
   & 0.705267857_wp, 0.812232143_wp, 0.143705357_wp, 0.090223214_wp, & 
   & 0.197187500_wp, 0.250669643_wp, 0.304151786_wp, 0.357633929_wp, & 
   & 0.384375000_wp, 0.437857143_wp, 0.063482143_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.223928571_wp, 0.223928571_wp, 0.223928571_wp, 0.250669643_wp, & 
   & 0.277410714_wp, 0.304151786_wp, 0.330892857_wp, 0.357633929_wp, & 
   & 0.063482143_wp, 0.116964286_wp, 0.143705357_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.170446429_wp, 0.143705357_wp, 0.197187500_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.223928571_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.223928571_wp, 0.250669643_wp, & 
   & 0.277410714_wp, 0.304151786_wp, 0.036741071_wp, 0.143705357_wp, & 
   & 0.116964286_wp, 0.250669643_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, 0.116964286_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.250669643_wp, 0.250669643_wp, 0.250669643_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.223928571_wp, 0.223928571_wp, & 
   & 0.250669643_wp, 0.277410714_wp, 0.090223214_wp, 0.116964286_wp, & 
   & 0.143705357_wp, 0.116964286_wp, 0.116964286_wp, 0.143705357_wp, & 
   & 0.116964286_wp, 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.116964286_wp, 0.143705357_wp, 0.143705357_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.143705357_wp, 0.170446429_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 64) / &
   & 0.625044643_wp, 0.892455357_wp, 0.143705357_wp, 0.250669643_wp, & 
   & 0.304151786_wp, 0.384375000_wp, 0.464598214_wp, 0.518080357_wp, & 
   & 0.598303571_wp, 0.678526786_wp, 0.143705357_wp, 0.090223214_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.277410714_wp, 0.304151786_wp, & 
   & 0.330892857_wp, 0.384375000_wp, 0.063482143_wp, 0.143705357_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.223928571_wp, 0.197187500_wp, 0.197187500_wp, 0.223928571_wp, & 
   & 0.250669643_wp, 0.277410714_wp, 0.277410714_wp, 0.304151786_wp, & 
   & 0.063482143_wp, 0.116964286_wp, 0.170446429_wp, 0.116964286_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.143705357_wp, 0.197187500_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.223928571_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.223928571_wp, 0.223928571_wp, & 
   & 0.250669643_wp, 0.250669643_wp, 0.036741071_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.223928571_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.090223214_wp, 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.223928571_wp, 0.223928571_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.197187500_wp, 0.223928571_wp, & 
   & 0.223928571_wp, 0.223928571_wp, 0.090223214_wp, 0.116964286_wp, & 
   & 0.143705357_wp, 0.116964286_wp, 0.116964286_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.116964286_wp, 0.170446429_wp, 0.170446429_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.197187500_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 65) / &
   & 0.544821429_wp, 0.785491071_wp, 0.116964286_wp, 0.197187500_wp, & 
   & 0.277410714_wp, 0.357633929_wp, 0.411116071_wp, 0.464598214_wp, & 
   & 0.544821429_wp, 0.598303571_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.250669643_wp, 0.277410714_wp, & 
   & 0.304151786_wp, 0.330892857_wp, 0.090223214_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, 0.143705357_wp, & 
   & 0.197187500_wp, 0.170446429_wp, 0.170446429_wp, 0.197187500_wp, & 
   & 0.223928571_wp, 0.223928571_wp, 0.250669643_wp, 0.277410714_wp, & 
   & 0.063482143_wp, 0.090223214_wp, 0.143705357_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.223928571_wp, 0.223928571_wp, 0.063482143_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.197187500_wp, 0.063482143_wp, 0.063482143_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, 0.116964286_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.063482143_wp, 0.090223214_wp, & 
   & 0.143705357_wp, 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, & 
   & 0.116964286_wp, 0.143705357_wp, 0.143705357_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.170446429_wp, 0.170446429_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 66) / &
   & 0.571562500_wp, 0.812232143_wp, 0.116964286_wp, 0.223928571_wp, & 
   & 0.277410714_wp, 0.357633929_wp, 0.437857143_wp, 0.464598214_wp, & 
   & 0.544821429_wp, 0.625044643_wp, 0.116964286_wp, 0.090223214_wp, & 
   & 0.170446429_wp, 0.223928571_wp, 0.250669643_wp, 0.277410714_wp, & 
   & 0.304151786_wp, 0.330892857_wp, 0.063482143_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.223928571_wp, 0.250669643_wp, 0.250669643_wp, 0.277410714_wp, & 
   & 0.063482143_wp, 0.116964286_wp, 0.143705357_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.197187500_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.223928571_wp, 0.223928571_wp, 0.036741071_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.197187500_wp, 0.063482143_wp, 0.090223214_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, 0.116964286_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.223928571_wp, 0.197187500_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.143705357_wp, 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, & 
   & 0.116964286_wp, 0.143705357_wp, 0.143705357_wp, 0.116964286_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 67) / &
   & 0.518080357_wp, 0.758750000_wp, 0.116964286_wp, 0.197187500_wp, & 
   & 0.250669643_wp, 0.330892857_wp, 0.411116071_wp, 0.437857143_wp, & 
   & 0.518080357_wp, 0.571562500_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.223928571_wp, 0.250669643_wp, & 
   & 0.277410714_wp, 0.330892857_wp, 0.090223214_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, 0.143705357_wp, & 
   & 0.197187500_wp, 0.170446429_wp, 0.170446429_wp, 0.197187500_wp, & 
   & 0.223928571_wp, 0.223928571_wp, 0.250669643_wp, 0.277410714_wp, & 
   & 0.063482143_wp, 0.090223214_wp, 0.143705357_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.063482143_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.197187500_wp, 0.063482143_wp, 0.090223214_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, 0.116964286_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.143705357_wp, 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, & 
   & 0.116964286_wp, 0.143705357_wp, 0.143705357_wp, 0.116964286_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 68) / &
   & 0.518080357_wp, 0.758750000_wp, 0.116964286_wp, 0.197187500_wp, & 
   & 0.277410714_wp, 0.330892857_wp, 0.411116071_wp, 0.437857143_wp, & 
   & 0.518080357_wp, 0.598303571_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.223928571_wp, 0.250669643_wp, & 
   & 0.277410714_wp, 0.330892857_wp, 0.090223214_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, 0.143705357_wp, & 
   & 0.197187500_wp, 0.170446429_wp, 0.170446429_wp, 0.197187500_wp, & 
   & 0.223928571_wp, 0.223928571_wp, 0.250669643_wp, 0.277410714_wp, & 
   & 0.063482143_wp, 0.116964286_wp, 0.143705357_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.063482143_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.197187500_wp, 0.063482143_wp, 0.090223214_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, 0.116964286_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.143705357_wp, 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, & 
   & 0.116964286_wp, 0.143705357_wp, 0.143705357_wp, 0.116964286_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 69) / &
   & 0.544821429_wp, 0.785491071_wp, 0.116964286_wp, 0.223928571_wp, & 
   & 0.277410714_wp, 0.330892857_wp, 0.411116071_wp, 0.464598214_wp, & 
   & 0.518080357_wp, 0.598303571_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.223928571_wp, 0.250669643_wp, & 
   & 0.277410714_wp, 0.330892857_wp, 0.090223214_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.197187500_wp, 0.170446429_wp, 0.170446429_wp, 0.197187500_wp, & 
   & 0.223928571_wp, 0.223928571_wp, 0.250669643_wp, 0.277410714_wp, & 
   & 0.063482143_wp, 0.116964286_wp, 0.143705357_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.197187500_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.063482143_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.197187500_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, 0.116964286_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.143705357_wp, 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, & 
   & 0.116964286_wp, 0.143705357_wp, 0.143705357_wp, 0.116964286_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 70) / &
   & 0.571562500_wp, 0.812232143_wp, 0.116964286_wp, 0.223928571_wp, & 
   & 0.277410714_wp, 0.357633929_wp, 0.437857143_wp, 0.464598214_wp, & 
   & 0.544821429_wp, 0.625044643_wp, 0.143705357_wp, 0.116964286_wp, & 
   & 0.170446429_wp, 0.223928571_wp, 0.250669643_wp, 0.277410714_wp, & 
   & 0.304151786_wp, 0.330892857_wp, 0.090223214_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.223928571_wp, 0.250669643_wp, 0.250669643_wp, 0.277410714_wp, & 
   & 0.063482143_wp, 0.116964286_wp, 0.143705357_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.197187500_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.223928571_wp, 0.223928571_wp, 0.063482143_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.197187500_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, 0.116964286_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.223928571_wp, 0.197187500_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.143705357_wp, 0.116964286_wp, 0.116964286_wp, 0.143705357_wp, & 
   & 0.116964286_wp, 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.116964286_wp, 0.143705357_wp, 0.143705357_wp, 0.116964286_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 71) / &
   & 0.598303571_wp, 0.838973214_wp, 0.143705357_wp, 0.250669643_wp, & 
   & 0.304151786_wp, 0.384375000_wp, 0.464598214_wp, 0.491339286_wp, & 
   & 0.571562500_wp, 0.651785714_wp, 0.143705357_wp, 0.116964286_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.250669643_wp, 0.277410714_wp, & 
   & 0.330892857_wp, 0.357633929_wp, 0.090223214_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.116964286_wp, 0.116964286_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.223928571_wp, 0.197187500_wp, 0.197187500_wp, 0.223928571_wp, & 
   & 0.250669643_wp, 0.250669643_wp, 0.277410714_wp, 0.304151786_wp, & 
   & 0.063482143_wp, 0.116964286_wp, 0.170446429_wp, 0.116964286_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.197187500_wp, 0.223928571_wp, & 
   & 0.223928571_wp, 0.250669643_wp, 0.063482143_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.223928571_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.090223214_wp, 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.223928571_wp, 0.223928571_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.223928571_wp, 0.223928571_wp, 0.090223214_wp, 0.116964286_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.116964286_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.116964286_wp, 0.170446429_wp, 0.170446429_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.197187500_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 72) / &
   & 0.972678571_wp, 1.667946429_wp, 0.170446429_wp, 0.330892857_wp, & 
   & 0.491339286_wp, 0.838973214_wp, 0.919196429_wp, 0.972678571_wp, & 
   & 1.106383929_wp, 1.240089286_wp, 0.197187500_wp, 0.143705357_wp, & 
   & 0.277410714_wp, 0.411116071_wp, 0.518080357_wp, 0.571562500_wp, & 
   & 0.651785714_wp, 0.705267857_wp, 0.090223214_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, 0.223928571_wp, & 
   & 0.197187500_wp, 0.250669643_wp, 0.223928571_wp, 0.223928571_wp, & 
   & 0.357633929_wp, 0.277410714_wp, 0.330892857_wp, 0.384375000_wp, & 
   & 0.464598214_wp, 0.544821429_wp, 0.571562500_wp, 0.598303571_wp, & 
   & 0.090223214_wp, 0.143705357_wp, 0.170446429_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.197187500_wp, 0.170446429_wp, 0.250669643_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.330892857_wp, 0.250669643_wp, & 
   & 0.250669643_wp, 0.304151786_wp, 0.384375000_wp, 0.437857143_wp, & 
   & 0.491339286_wp, 0.518080357_wp, 0.063482143_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.437857143_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, 0.143705357_wp, & 
   & 0.170446429_wp, 0.223928571_wp, 0.223928571_wp, 0.250669643_wp, & 
   & 0.250669643_wp, 0.357633929_wp, 0.464598214_wp, 0.357633929_wp, & 
   & 0.250669643_wp, 0.277410714_wp, 0.330892857_wp, 0.411116071_wp, & 
   & 0.464598214_wp, 0.464598214_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.170446429_wp, 0.143705357_wp, 0.116964286_wp, 0.170446429_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.223928571_wp, 0.197187500_wp, & 
   & 0.116964286_wp, 0.197187500_wp, 0.170446429_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.223928571_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 73) / &
   & 1.026160714_wp, 1.801651786_wp, 0.250669643_wp, 0.304151786_wp, & 
   & 0.464598214_wp, 0.812232143_wp, 0.919196429_wp, 0.999419643_wp, & 
   & 1.159866071_wp, 1.373794643_wp, 0.223928571_wp, 0.143705357_wp, & 
   & 0.277410714_wp, 0.384375000_wp, 0.464598214_wp, 0.518080357_wp, & 
   & 0.598303571_wp, 0.678526786_wp, 0.090223214_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.143705357_wp, 0.250669643_wp, & 
   & 0.223928571_wp, 0.250669643_wp, 0.223928571_wp, 0.250669643_wp, & 
   & 0.357633929_wp, 0.277410714_wp, 0.304151786_wp, 0.357633929_wp, & 
   & 0.437857143_wp, 0.464598214_wp, 0.518080357_wp, 0.544821429_wp, & 
   & 0.063482143_wp, 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.223928571_wp, 0.170446429_wp, 0.250669643_wp, & 
   & 0.223928571_wp, 0.250669643_wp, 0.330892857_wp, 0.277410714_wp, & 
   & 0.250669643_wp, 0.304151786_wp, 0.357633929_wp, 0.384375000_wp, & 
   & 0.411116071_wp, 0.437857143_wp, 0.063482143_wp, 0.170446429_wp, & 
   & 0.143705357_wp, 0.384375000_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, & 
   & 0.197187500_wp, 0.250669643_wp, 0.197187500_wp, 0.277410714_wp, & 
   & 0.250669643_wp, 0.357633929_wp, 0.411116071_wp, 0.357633929_wp, & 
   & 0.277410714_wp, 0.277410714_wp, 0.330892857_wp, 0.357633929_wp, & 
   & 0.384375000_wp, 0.411116071_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.170446429_wp, 0.143705357_wp, 0.143705357_wp, 0.197187500_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.250669643_wp, 0.197187500_wp, & 
   & 0.143705357_wp, 0.223928571_wp, 0.170446429_wp, 0.143705357_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.223928571_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 74) / &
   & 0.518080357_wp, 0.705267857_wp, 0.330892857_wp, 0.250669643_wp, & 
   & 0.330892857_wp, 0.357633929_wp, 0.384375000_wp, 0.411116071_wp, & 
   & 0.491339286_wp, 0.544821429_wp, 0.197187500_wp, 0.116964286_wp, & 
   & 0.223928571_wp, 0.223928571_wp, 0.223928571_wp, 0.250669643_wp, & 
   & 0.277410714_wp, 0.304151786_wp, 0.063482143_wp, 0.170446429_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.170446429_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.250669643_wp, 0.223928571_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.197187500_wp, 0.223928571_wp, & 
   & 0.223928571_wp, 0.223928571_wp, 0.223928571_wp, 0.250669643_wp, & 
   & 0.063482143_wp, 0.170446429_wp, 0.170446429_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.143705357_wp, 0.223928571_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.197187500_wp, 0.223928571_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.063482143_wp, 0.143705357_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, 0.223928571_wp, & 
   & 0.250669643_wp, 0.143705357_wp, 0.170446429_wp, 0.250669643_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.197187500_wp, 0.223928571_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.116964286_wp, 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.170446429_wp, 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 75) / &
   & 0.464598214_wp, 0.598303571_wp, 0.357633929_wp, 0.197187500_wp, & 
   & 0.304151786_wp, 0.304151786_wp, 0.330892857_wp, 0.357633929_wp, & 
   & 0.437857143_wp, 0.491339286_wp, 0.197187500_wp, 0.116964286_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.197187500_wp, 0.223928571_wp, & 
   & 0.250669643_wp, 0.277410714_wp, 0.090223214_wp, 0.143705357_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.143705357_wp, 0.197187500_wp, 0.223928571_wp, 0.223928571_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.170446429_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.223928571_wp, 0.223928571_wp, & 
   & 0.090223214_wp, 0.143705357_wp, 0.170446429_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.116964286_wp, 0.143705357_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.170446429_wp, 0.197187500_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.063482143_wp, 0.116964286_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, 0.223928571_wp, & 
   & 0.197187500_wp, 0.170446429_wp, 0.116964286_wp, 0.143705357_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.170446429_wp, 0.197187500_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.170446429_wp, 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.116964286_wp, 0.116964286_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 76) / &
   & 0.598303571_wp, 0.785491071_wp, 0.330892857_wp, 0.223928571_wp, & 
   & 0.384375000_wp, 0.411116071_wp, 0.437857143_wp, 0.491339286_wp, & 
   & 0.571562500_wp, 0.625044643_wp, 0.223928571_wp, 0.116964286_wp, & 
   & 0.277410714_wp, 0.277410714_wp, 0.277410714_wp, 0.277410714_wp, & 
   & 0.330892857_wp, 0.357633929_wp, 0.090223214_wp, 0.223928571_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.170446429_wp, 0.250669643_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.304151786_wp, 0.277410714_wp, & 
   & 0.250669643_wp, 0.277410714_wp, 0.250669643_wp, 0.277410714_wp, & 
   & 0.250669643_wp, 0.250669643_wp, 0.277410714_wp, 0.304151786_wp, & 
   & 0.090223214_wp, 0.197187500_wp, 0.223928571_wp, 0.197187500_wp, & 
   & 0.223928571_wp, 0.250669643_wp, 0.143705357_wp, 0.170446429_wp, & 
   & 0.250669643_wp, 0.277410714_wp, 0.250669643_wp, 0.250669643_wp, & 
   & 0.250669643_wp, 0.223928571_wp, 0.223928571_wp, 0.223928571_wp, & 
   & 0.250669643_wp, 0.250669643_wp, 0.063482143_wp, 0.170446429_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, 0.250669643_wp, & 
   & 0.277410714_wp, 0.250669643_wp, 0.143705357_wp, 0.170446429_wp, & 
   & 0.250669643_wp, 0.250669643_wp, 0.250669643_wp, 0.250669643_wp, & 
   & 0.223928571_wp, 0.223928571_wp, 0.223928571_wp, 0.223928571_wp, & 
   & 0.223928571_wp, 0.250669643_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.143705357_wp, 0.197187500_wp, 0.170446429_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.170446429_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.170446429_wp, 0.170446429_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 77) / &
   & 2.202767857_wp, 2.336473214_wp, 0.330892857_wp, 0.277410714_wp, & 
   & 0.651785714_wp, 1.159866071_wp, 1.240089286_wp, 1.347053571_wp, & 
   & 1.560982143_wp, 1.774910714_wp, 0.223928571_wp, 0.116964286_wp, & 
   & 0.384375000_wp, 0.491339286_wp, 0.625044643_wp, 0.732008929_wp, & 
   & 0.838973214_wp, 0.945937500_wp, 0.090223214_wp, 0.250669643_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.170446429_wp, 0.304151786_wp, & 
   & 0.223928571_wp, 0.223928571_wp, 0.304151786_wp, 0.304151786_wp, & 
   & 0.464598214_wp, 0.357633929_wp, 0.411116071_wp, 0.491339286_wp, & 
   & 0.598303571_wp, 0.625044643_wp, 0.705267857_wp, 0.758750000_wp, & 
   & 0.063482143_wp, 0.223928571_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.223928571_wp, 0.304151786_wp, 0.143705357_wp, 0.223928571_wp, & 
   & 0.277410714_wp, 0.304151786_wp, 0.437857143_wp, 0.357633929_wp, & 
   & 0.357633929_wp, 0.411116071_wp, 0.464598214_wp, 0.518080357_wp, & 
   & 0.571562500_wp, 0.598303571_wp, 0.063482143_wp, 0.223928571_wp, & 
   & 0.170446429_wp, 0.491339286_wp, 0.143705357_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.197187500_wp, 0.250669643_wp, & 
   & 0.250669643_wp, 0.197187500_wp, 0.170446429_wp, 0.250669643_wp, & 
   & 0.330892857_wp, 0.464598214_wp, 0.544821429_wp, 0.437857143_wp, & 
   & 0.357633929_wp, 0.384375000_wp, 0.437857143_wp, 0.464598214_wp, & 
   & 0.518080357_wp, 0.544821429_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.223928571_wp, 0.197187500_wp, 0.170446429_wp, 0.277410714_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.330892857_wp, 0.250669643_wp, & 
   & 0.170446429_wp, 0.304151786_wp, 0.223928571_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.277410714_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 78) / &
   & 2.042321429_wp, 3.058482143_wp, 0.437857143_wp, 0.277410714_wp, & 
   & 1.159866071_wp, 1.293571429_wp, 1.320312500_wp, 1.480758929_wp, & 
   & 1.774910714_wp, 2.095803571_wp, 0.223928571_wp, 0.116964286_wp, & 
   & 0.651785714_wp, 0.785491071_wp, 0.812232143_wp, 0.865714286_wp, & 
   & 0.945937500_wp, 1.079642857_wp, 0.090223214_wp, 0.357633929_wp, & 
   & 0.250669643_wp, 0.277410714_wp, 0.223928571_wp, 0.384375000_wp, & 
   & 0.223928571_wp, 0.223928571_wp, 0.357633929_wp, 0.411116071_wp, & 
   & 0.732008929_wp, 0.464598214_wp, 0.705267857_wp, 0.785491071_wp, & 
   & 0.758750000_wp, 0.758750000_wp, 0.838973214_wp, 0.892455357_wp, & 
   & 0.063482143_wp, 0.330892857_wp, 0.250669643_wp, 0.277410714_wp, & 
   & 0.277410714_wp, 0.384375000_wp, 0.143705357_wp, 0.223928571_wp, & 
   & 0.357633929_wp, 0.411116071_wp, 0.732008929_wp, 0.464598214_wp, & 
   & 0.625044643_wp, 0.705267857_wp, 0.678526786_wp, 0.678526786_wp, & 
   & 0.705267857_wp, 0.758750000_wp, 0.063482143_wp, 0.330892857_wp, & 
   & 0.223928571_wp, 0.651785714_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.250669643_wp, 0.223928571_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.223928571_wp, 0.357633929_wp, & 
   & 0.357633929_wp, 0.197187500_wp, 0.197187500_wp, 0.250669643_wp, & 
   & 0.464598214_wp, 0.544821429_wp, 0.705267857_wp, 0.651785714_wp, & 
   & 0.651785714_wp, 0.678526786_wp, 0.651785714_wp, 0.651785714_wp, & 
   & 0.651785714_wp, 0.705267857_wp, 0.277410714_wp, 0.304151786_wp, & 
   & 0.304151786_wp, 0.277410714_wp, 0.250669643_wp, 0.330892857_wp, & 
   & 0.812232143_wp, 0.250669643_wp, 0.571562500_wp, 0.330892857_wp, & 
   & 0.223928571_wp, 0.384375000_wp, 0.250669643_wp, 0.223928571_wp, & 
   & 0.277410714_wp, 0.277410714_wp, 0.357633929_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 79) / &
   & 1.908616071_wp, 6.000000000_wp, 0.437857143_wp, 0.277410714_wp, & 
   & 1.454017857_wp, 1.507500000_wp, 2.256250000_wp, 4.903616071_wp, & 
   & 5.625625000_wp, 6.000000000_wp, 0.223928571_wp, 0.116964286_wp, & 
   & 1.293571429_wp, 1.373794643_wp, 2.309732143_wp, 3.646785714_wp, & 
   & 4.689687500_wp, 3.727008929_wp, 0.090223214_wp, 0.411116071_wp, & 
   & 0.277410714_wp, 0.304151786_wp, 0.223928571_wp, 0.384375000_wp, & 
   & 0.223928571_wp, 0.223928571_wp, 0.411116071_wp, 0.437857143_wp, & 
   & 0.892455357_wp, 0.491339286_wp, 1.801651786_wp, 1.427276786_wp, & 
   & 2.389955357_wp, 3.833973214_wp, 5.572142857_wp, 3.058482143_wp, & 
   & 0.063482143_wp, 0.357633929_wp, 0.250669643_wp, 0.304151786_wp, & 
   & 0.304151786_wp, 0.437857143_wp, 0.143705357_wp, 0.223928571_wp, & 
   & 0.384375000_wp, 0.437857143_wp, 0.919196429_wp, 0.518080357_wp, & 
   & 1.881875000_wp, 1.159866071_wp, 1.748169643_wp, 2.336473214_wp, & 
   & 3.325892857_wp, 2.443437500_wp, 0.063482143_wp, 0.357633929_wp, & 
   & 0.223928571_wp, 1.988839286_wp, 0.170446429_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.250669643_wp, 0.223928571_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.223928571_wp, 0.464598214_wp, & 
   & 0.411116071_wp, 0.197187500_wp, 0.170446429_wp, 0.250669643_wp, & 
   & 0.544821429_wp, 0.705267857_wp, 1.614464286_wp, 0.785491071_wp, & 
   & 1.774910714_wp, 0.972678571_wp, 1.507500000_wp, 2.122544643_wp, & 
   & 3.138705357_wp, 2.229508929_wp, 0.330892857_wp, 0.357633929_wp, & 
   & 0.304151786_wp, 0.838973214_wp, 0.945937500_wp, 0.357633929_wp, & 
   & 0.330892857_wp, 0.277410714_wp, 0.732008929_wp, 0.357633929_wp, & 
   & 0.838973214_wp, 0.437857143_wp, 0.277410714_wp, 0.250669643_wp, & 
   & 0.304151786_wp, 0.330892857_wp, 0.357633929_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 80) / &
   & 2.256250000_wp, 3.085223214_wp, 0.411116071_wp, 0.277410714_wp, & 
   & 0.919196429_wp, 1.560982143_wp, 1.667946429_wp, 1.801651786_wp, & 
   & 2.095803571_wp, 2.363214286_wp, 0.223928571_wp, 0.116964286_wp, & 
   & 0.544821429_wp, 0.732008929_wp, 0.892455357_wp, 0.999419643_wp, & 
   & 1.133125000_wp, 1.240089286_wp, 0.090223214_wp, 0.330892857_wp, & 
   & 0.250669643_wp, 0.277410714_wp, 0.223928571_wp, 0.384375000_wp, & 
   & 0.223928571_wp, 0.250669643_wp, 0.357633929_wp, 0.411116071_wp, & 
   & 2.069062500_wp, 0.437857143_wp, 0.625044643_wp, 0.732008929_wp, & 
   & 0.838973214_wp, 0.892455357_wp, 0.972678571_wp, 1.052901786_wp, & 
   & 0.063482143_wp, 0.304151786_wp, 0.250669643_wp, 0.277410714_wp, & 
   & 0.277410714_wp, 0.384375000_wp, 0.170446429_wp, 0.223928571_wp, & 
   & 0.357633929_wp, 0.411116071_wp, 0.651785714_wp, 0.464598214_wp, & 
   & 0.544821429_wp, 0.651785714_wp, 0.705267857_wp, 0.758750000_wp, & 
   & 0.838973214_wp, 0.865714286_wp, 0.063482143_wp, 0.330892857_wp, & 
   & 0.223928571_wp, 0.758750000_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.250669643_wp, 0.223928571_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.223928571_wp, 0.357633929_wp, & 
   & 0.357633929_wp, 0.223928571_wp, 0.197187500_wp, 0.250669643_wp, & 
   & 0.437857143_wp, 0.651785714_wp, 0.785491071_wp, 0.598303571_wp, & 
   & 0.544821429_wp, 0.571562500_wp, 0.678526786_wp, 0.705267857_wp, & 
   & 0.758750000_wp, 0.785491071_wp, 0.277410714_wp, 0.304151786_wp, & 
   & 0.304151786_wp, 0.277410714_wp, 0.250669643_wp, 0.330892857_wp, & 
   & 0.277410714_wp, 0.277410714_wp, 0.518080357_wp, 0.330892857_wp, & 
   & 0.250669643_wp, 0.384375000_wp, 0.250669643_wp, 0.250669643_wp, & 
   & 0.277410714_wp, 0.304151786_wp, 0.357633929_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 81) / &
   & 1.614464286_wp, 4.716428571_wp, 0.330892857_wp, 0.277410714_wp, & 
   & 1.855133929_wp, 1.347053571_wp, 2.095803571_wp, 2.951517857_wp, & 
   & 3.406116071_wp, 3.780491071_wp, 0.223928571_wp, 0.116964286_wp, & 
   & 0.437857143_wp, 1.721428571_wp, 1.774910714_wp, 1.881875000_wp, & 
   & 2.069062500_wp, 2.309732143_wp, 0.063482143_wp, 0.250669643_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.170446429_wp, 0.330892857_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.304151786_wp, 0.330892857_wp, & 
   & 0.571562500_wp, 0.357633929_wp, 0.544821429_wp, 1.694687500_wp, & 
   & 1.667946429_wp, 1.774910714_wp, 1.855133929_wp, 2.015580357_wp, & 
   & 0.063482143_wp, 0.223928571_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.223928571_wp, 0.304151786_wp, 0.143705357_wp, 0.223928571_wp, & 
   & 0.277410714_wp, 0.330892857_wp, 0.571562500_wp, 0.384375000_wp, & 
   & 0.411116071_wp, 1.641205357_wp, 1.480758929_wp, 1.507500000_wp, & 
   & 1.587723214_wp, 1.721428571_wp, 0.063482143_wp, 0.223928571_wp, & 
   & 0.170446429_wp, 1.480758929_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, 0.250669643_wp, & 
   & 0.277410714_wp, 0.197187500_wp, 0.170446429_wp, 0.223928571_wp, & 
   & 0.357633929_wp, 0.651785714_wp, 1.774910714_wp, 0.544821429_wp, & 
   & 0.437857143_wp, 1.641205357_wp, 1.454017857_wp, 1.427276786_wp, & 
   & 1.454017857_wp, 1.587723214_wp, 0.197187500_wp, 0.223928571_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.170446429_wp, 0.250669643_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.357633929_wp, 0.250669643_wp, & 
   & 1.828392857_wp, 0.304151786_wp, 0.197187500_wp, 0.170446429_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.250669643_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 82) / &
   & 1.507500000_wp, 5.358214286_wp, 0.357633929_wp, 0.250669643_wp, & 
   & 0.945937500_wp, 1.347053571_wp, 1.908616071_wp, 2.924776786_wp, & 
   & 3.165446429_wp, 3.940937500_wp, 0.197187500_wp, 0.090223214_wp, & 
   & 0.491339286_wp, 0.785491071_wp, 1.454017857_wp, 1.988839286_wp, & 
   & 2.256250000_wp, 2.229508929_wp, 0.063482143_wp, 0.277410714_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.170446429_wp, 0.357633929_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.304151786_wp, 0.330892857_wp, & 
   & 0.598303571_wp, 0.384375000_wp, 0.571562500_wp, 0.838973214_wp, & 
   & 1.507500000_wp, 1.881875000_wp, 2.149285714_wp, 1.908616071_wp, & 
   & 0.063482143_wp, 0.250669643_wp, 0.197187500_wp, 0.223928571_wp, & 
   & 0.223928571_wp, 0.330892857_wp, 0.143705357_wp, 0.197187500_wp, & 
   & 0.277410714_wp, 0.357633929_wp, 0.598303571_wp, 0.411116071_wp, & 
   & 0.464598214_wp, 0.678526786_wp, 0.919196429_wp, 1.320312500_wp, & 
   & 1.774910714_wp, 1.427276786_wp, 0.063482143_wp, 0.250669643_wp, & 
   & 0.170446429_wp, 1.240089286_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.197187500_wp, 0.277410714_wp, & 
   & 0.277410714_wp, 0.197187500_wp, 0.170446429_wp, 0.223928571_wp, & 
   & 0.384375000_wp, 0.678526786_wp, 0.972678571_wp, 0.571562500_wp, & 
   & 1.641205357_wp, 0.544821429_wp, 0.812232143_wp, 1.106383929_wp, & 
   & 1.560982143_wp, 1.240089286_wp, 0.223928571_wp, 0.223928571_wp, & 
   & 0.223928571_wp, 0.197187500_wp, 0.170446429_wp, 0.277410714_wp, & 
   & 0.838973214_wp, 0.197187500_wp, 0.411116071_wp, 0.250669643_wp, & 
   & 0.170446429_wp, 0.330892857_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.277410714_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 83) / &
   & 1.667946429_wp, 6.000000000_wp, 0.411116071_wp, 0.250669643_wp, & 
   & 1.213348214_wp, 1.347053571_wp, 1.988839286_wp, 4.903616071_wp, & 
   & 5.331473214_wp, 6.000000000_wp, 0.197187500_wp, 0.090223214_wp, & 
   & 1.908616071_wp, 1.213348214_wp, 2.416696429_wp, 3.753750000_wp, & 
   & 4.101383929_wp, 3.807232143_wp, 0.063482143_wp, 0.330892857_wp, & 
   & 0.223928571_wp, 0.223928571_wp, 0.197187500_wp, 0.330892857_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.330892857_wp, 0.384375000_wp, & 
   & 0.758750000_wp, 0.437857143_wp, 1.774910714_wp, 1.373794643_wp, & 
   & 2.496919643_wp, 3.379375000_wp, 3.620044643_wp, 3.192187500_wp, & 
   & 0.063482143_wp, 0.304151786_wp, 0.223928571_wp, 0.250669643_wp, & 
   & 0.250669643_wp, 0.357633929_wp, 0.143705357_wp, 0.197187500_wp, & 
   & 0.330892857_wp, 0.384375000_wp, 0.785491071_wp, 0.437857143_wp, & 
   & 1.667946429_wp, 1.079642857_wp, 1.828392857_wp, 2.791071429_wp, & 
   & 3.138705357_wp, 2.603883929_wp, 0.063482143_wp, 0.277410714_wp, & 
   & 0.197187500_wp, 2.309732143_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.223928571_wp, 0.197187500_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.197187500_wp, 0.330892857_wp, & 
   & 0.330892857_wp, 0.170446429_wp, 0.170446429_wp, 0.223928571_wp, & 
   & 0.437857143_wp, 0.651785714_wp, 1.507500000_wp, 0.678526786_wp, & 
   & 1.454017857_wp, 0.812232143_wp, 1.641205357_wp, 2.523660714_wp, & 
   & 2.951517857_wp, 2.389955357_wp, 0.277410714_wp, 0.277410714_wp, & 
   & 0.250669643_wp, 0.812232143_wp, 0.972678571_wp, 0.304151786_wp, & 
   & 0.250669643_wp, 0.223928571_wp, 0.598303571_wp, 0.277410714_wp, & 
   & 0.197187500_wp, 0.357633929_wp, 0.223928571_wp, 0.197187500_wp, & 
   & 0.223928571_wp, 0.250669643_wp, 0.304151786_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 84) / &
   & 1.774910714_wp, 6.000000000_wp, 0.384375000_wp, 0.223928571_wp, & 
   & 1.454017857_wp, 1.373794643_wp, 2.069062500_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.197187500_wp, 0.090223214_wp, & 
   & 1.908616071_wp, 1.694687500_wp, 2.710848214_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.063482143_wp, 0.357633929_wp, & 
   & 0.223928571_wp, 0.250669643_wp, 0.197187500_wp, 0.330892857_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.357633929_wp, 0.411116071_wp, & 
   & 0.865714286_wp, 0.437857143_wp, 1.721428571_wp, 1.801651786_wp, & 
   & 2.951517857_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 0.063482143_wp, 0.330892857_wp, 0.223928571_wp, 0.250669643_wp, & 
   & 0.250669643_wp, 0.384375000_wp, 0.143705357_wp, 0.197187500_wp, & 
   & 0.330892857_wp, 0.411116071_wp, 0.892455357_wp, 0.464598214_wp, & 
   & 1.641205357_wp, 1.400535714_wp, 2.844553571_wp, 4.047901786_wp, & 
   & 5.491919643_wp, 6.000000000_wp, 0.063482143_wp, 0.330892857_wp, & 
   & 0.197187500_wp, 4.903616071_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.223928571_wp, 0.223928571_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.197187500_wp, 0.411116071_wp, & 
   & 0.357633929_wp, 0.170446429_wp, 0.170446429_wp, 0.223928571_wp, & 
   & 0.464598214_wp, 0.651785714_wp, 2.122544643_wp, 0.705267857_wp, & 
   & 1.427276786_wp, 1.106383929_wp, 2.523660714_wp, 3.727008929_wp, & 
   & 5.090803571_wp, 5.491919643_wp, 0.304151786_wp, 0.330892857_wp, & 
   & 0.277410714_wp, 0.785491071_wp, 0.223928571_wp, 0.330892857_wp, & 
   & 0.277410714_wp, 0.250669643_wp, 0.758750000_wp, 0.304151786_wp, & 
   & 0.945937500_wp, 0.384375000_wp, 0.223928571_wp, 0.223928571_wp, & 
   & 1.881875000_wp, 0.277410714_wp, 0.330892857_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 85) / &
   & 1.881875000_wp, 6.000000000_wp, 0.384375000_wp, 0.250669643_wp, & 
   & 1.721428571_wp, 1.427276786_wp, 2.176026786_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.197187500_wp, 0.090223214_wp, & 
   & 1.988839286_wp, 2.042321429_wp, 2.791071429_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.063482143_wp, 0.411116071_wp, & 
   & 0.250669643_wp, 0.277410714_wp, 0.197187500_wp, 0.357633929_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.384375000_wp, 0.411116071_wp, & 
   & 0.945937500_wp, 0.464598214_wp, 1.748169643_wp, 2.256250000_wp, & 
   & 3.031741071_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 0.063482143_wp, 0.357633929_wp, 0.250669643_wp, 0.277410714_wp, & 
   & 0.277410714_wp, 0.411116071_wp, 0.143705357_wp, 0.197187500_wp, & 
   & 0.357633929_wp, 0.437857143_wp, 0.972678571_wp, 0.491339286_wp, & 
   & 1.721428571_wp, 1.855133929_wp, 2.924776786_wp, 5.732589286_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.063482143_wp, 0.357633929_wp, & 
   & 0.223928571_wp, 6.000000000_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.250669643_wp, 0.223928571_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.223928571_wp, 0.464598214_wp, & 
   & 0.384375000_wp, 0.197187500_wp, 0.170446429_wp, 0.223928571_wp, & 
   & 0.518080357_wp, 0.651785714_wp, 3.138705357_wp, 0.758750000_wp, & 
   & 1.454017857_wp, 1.560982143_wp, 2.951517857_wp, 5.090803571_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.330892857_wp, 0.357633929_wp, & 
   & 0.304151786_wp, 0.785491071_wp, 0.250669643_wp, 0.357633929_wp, & 
   & 0.304151786_wp, 0.250669643_wp, 0.838973214_wp, 0.330892857_wp, & 
   & 0.892455357_wp, 0.411116071_wp, 0.250669643_wp, 0.250669643_wp, & 
   & 1.801651786_wp, 0.304151786_wp, 0.357633929_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 86) / &
   & 1.935357143_wp, 6.000000000_wp, 0.437857143_wp, 0.250669643_wp, & 
   & 1.641205357_wp, 1.507500000_wp, 2.229508929_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.223928571_wp, 0.116964286_wp, & 
   & 2.069062500_wp, 1.801651786_wp, 2.951517857_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.090223214_wp, 0.411116071_wp, & 
   & 0.277410714_wp, 0.304151786_wp, 0.223928571_wp, 0.357633929_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.411116071_wp, 0.437857143_wp, & 
   & 0.972678571_wp, 0.491339286_wp, 1.881875000_wp, 1.855133929_wp, & 
   & 3.192187500_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 0.063482143_wp, 0.384375000_wp, 0.250669643_wp, 0.304151786_wp, & 
   & 0.304151786_wp, 0.437857143_wp, 0.143705357_wp, 0.223928571_wp, & 
   & 0.384375000_wp, 0.437857143_wp, 0.999419643_wp, 0.518080357_wp, & 
   & 1.801651786_wp, 1.480758929_wp, 3.058482143_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.063482143_wp, 0.384375000_wp, & 
   & 0.223928571_wp, 6.000000000_wp, 0.170446429_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.277410714_wp, 0.223928571_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.223928571_wp, 0.464598214_wp, & 
   & 0.411116071_wp, 0.197187500_wp, 0.170446429_wp, 0.250669643_wp, & 
   & 0.544821429_wp, 0.705267857_wp, 2.229508929_wp, 0.785491071_wp, & 
   & 1.587723214_wp, 1.240089286_wp, 2.389955357_wp, 5.491919643_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 0.357633929_wp, 2.229508929_wp, & 
   & 0.304151786_wp, 0.812232143_wp, 0.865714286_wp, 0.384375000_wp, & 
   & 0.357633929_wp, 0.277410714_wp, 0.838973214_wp, 0.357633929_wp, & 
   & 0.972678571_wp, 0.437857143_wp, 0.277410714_wp, 0.250669643_wp, & 
   & 1.962098214_wp, 0.330892857_wp, 0.384375000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 87) / &
   & 0.785491071_wp, 1.748169643_wp, 0.090223214_wp, 0.197187500_wp, & 
   & 0.357633929_wp, 0.838973214_wp, 0.865714286_wp, 0.945937500_wp, & 
   & 1.106383929_wp, 1.320312500_wp, 0.170446429_wp, 0.090223214_wp, & 
   & 0.197187500_wp, 0.304151786_wp, 0.411116071_wp, 0.491339286_wp, & 
   & 0.571562500_wp, 0.651785714_wp, 0.036741071_wp, 0.116964286_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, 0.170446429_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.250669643_wp, 0.197187500_wp, 0.250669643_wp, 0.277410714_wp, & 
   & 0.357633929_wp, 0.411116071_wp, 0.464598214_wp, 0.518080357_wp, & 
   & 0.036741071_wp, 0.116964286_wp, 0.116964286_wp, 0.090223214_wp, & 
   & 0.116964286_wp, 0.170446429_wp, 0.090223214_wp, 0.170446429_wp, & 
   & 0.143705357_wp, 0.197187500_wp, 0.250669643_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.304151786_wp, 0.330892857_wp, & 
   & 0.357633929_wp, 0.411116071_wp, 0.036741071_wp, 0.116964286_wp, & 
   & 0.090223214_wp, 0.304151786_wp, 0.063482143_wp, 0.063482143_wp, & 
   & 0.063482143_wp, 0.063482143_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.063482143_wp, 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, 0.116964286_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.116964286_wp, 0.170446429_wp, & 
   & 0.197187500_wp, 0.277410714_wp, 0.330892857_wp, 0.277410714_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.277410714_wp, 0.304151786_wp, & 
   & 0.330892857_wp, 0.357633929_wp, 0.063482143_wp, 0.090223214_wp, & 
   & 0.116964286_wp, 0.090223214_wp, 0.090223214_wp, 0.116964286_wp, & 
   & 0.090223214_wp, 0.116964286_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.090223214_wp, 0.143705357_wp, 0.116964286_wp, 0.090223214_wp, & 
   & 0.116964286_wp, 0.143705357_wp, 0.116964286_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 88) / &
   & 0.812232143_wp, 3.218928571_wp, 0.116964286_wp, 0.197187500_wp, & 
   & 0.384375000_wp, 0.999419643_wp, 0.999419643_wp, 2.496919643_wp, & 
   & 2.496919643_wp, 2.871294643_wp, 0.170446429_wp, 0.090223214_wp, & 
   & 0.223928571_wp, 0.304151786_wp, 0.437857143_wp, 0.518080357_wp, & 
   & 2.176026786_wp, 2.363214286_wp, 0.036741071_wp, 0.143705357_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.090223214_wp, 0.197187500_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, 0.197187500_wp, & 
   & 0.277410714_wp, 0.223928571_wp, 0.250669643_wp, 0.304151786_wp, & 
   & 2.176026786_wp, 0.464598214_wp, 0.518080357_wp, 2.282991071_wp, & 
   & 0.036741071_wp, 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.197187500_wp, 0.090223214_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.277410714_wp, 0.223928571_wp, & 
   & 0.197187500_wp, 0.250669643_wp, 0.304151786_wp, 0.357633929_wp, & 
   & 0.411116071_wp, 2.256250000_wp, 0.036741071_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.357633929_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.116964286_wp, 0.170446429_wp, & 
   & 0.197187500_wp, 0.304151786_wp, 0.357633929_wp, 0.304151786_wp, & 
   & 0.223928571_wp, 0.223928571_wp, 0.277410714_wp, 0.330892857_wp, & 
   & 0.357633929_wp, 2.229508929_wp, 0.090223214_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.090223214_wp, 0.143705357_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.170446429_wp, 0.143705357_wp, & 
   & 0.090223214_wp, 0.143705357_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.143705357_wp, 0.143705357_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 89) / &
   & 0.785491071_wp, 1.988839286_wp, 0.223928571_wp, 0.170446429_wp, & 
   & 0.357633929_wp, 0.705267857_wp, 0.838973214_wp, 1.052901786_wp, & 
   & 1.400535714_wp, 1.534241071_wp, 0.170446429_wp, 0.090223214_wp, & 
   & 0.223928571_wp, 0.277410714_wp, 0.357633929_wp, 0.437857143_wp, & 
   & 0.518080357_wp, 0.598303571_wp, 0.036741071_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.116964286_wp, 0.223928571_wp, & 
   & 0.116964286_wp, 0.143705357_wp, 0.197187500_wp, 0.223928571_wp, & 
   & 0.277410714_wp, 0.250669643_wp, 0.250669643_wp, 0.277410714_wp, & 
   & 0.330892857_wp, 0.384375000_wp, 0.411116071_wp, 0.464598214_wp, & 
   & 0.036741071_wp, 0.143705357_wp, 0.116964286_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.223928571_wp, 0.090223214_wp, 0.143705357_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.277410714_wp, 0.250669643_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.277410714_wp, 0.304151786_wp, & 
   & 0.330892857_wp, 0.357633929_wp, 0.036741071_wp, 0.116964286_wp, & 
   & 0.090223214_wp, 0.277410714_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.116964286_wp, 0.116964286_wp, 0.143705357_wp, & 
   & 0.223928571_wp, 0.304151786_wp, 0.304151786_wp, 0.304151786_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.250669643_wp, 0.277410714_wp, & 
   & 0.304151786_wp, 0.304151786_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, 0.197187500_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.197187500_wp, 0.143705357_wp, & 
   & 0.116964286_wp, 0.223928571_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.143705357_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 90) / &
   & 1.106383929_wp, 2.791071429_wp, 0.197187500_wp, 0.223928571_wp, & 
   & 0.437857143_wp, 0.919196429_wp, 1.427276786_wp, 1.587723214_wp, & 
   & 1.855133929_wp, 2.095803571_wp, 0.170446429_wp, 0.090223214_wp, & 
   & 0.197187500_wp, 0.277410714_wp, 0.972678571_wp, 0.999419643_wp, & 
   & 1.052901786_wp, 1.159866071_wp, 0.063482143_wp, 0.143705357_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, 0.197187500_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.170446429_wp, 0.197187500_wp, & 
   & 0.250669643_wp, 0.223928571_wp, 0.223928571_wp, 0.892455357_wp, & 
   & 0.919196429_wp, 0.892455357_wp, 0.945937500_wp, 1.026160714_wp, & 
   & 0.036741071_wp, 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.170446429_wp, 0.116964286_wp, 0.197187500_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.250669643_wp, 0.223928571_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.838973214_wp, 0.785491071_wp, & 
   & 0.812232143_wp, 0.865714286_wp, 0.036741071_wp, 0.116964286_wp, & 
   & 0.090223214_wp, 0.785491071_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.143705357_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.277410714_wp, 0.838973214_wp, 0.277410714_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.812232143_wp, 0.785491071_wp, & 
   & 0.785491071_wp, 0.812232143_wp, 0.090223214_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.090223214_wp, 0.170446429_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.170446429_wp, 0.143705357_wp, & 
   & 0.090223214_wp, 0.170446429_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.143705357_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 91) / &
   & 1.079642857_wp, 3.780491071_wp, 0.170446429_wp, 0.223928571_wp, & 
   & 0.357633929_wp, 0.838973214_wp, 1.694687500_wp, 2.042321429_wp, & 
   & 2.389955357_wp, 2.737589286_wp, 0.143705357_wp, 0.090223214_wp, & 
   & 0.197187500_wp, 0.732008929_wp, 0.919196429_wp, 1.186607143_wp, & 
   & 1.293571429_wp, 1.454017857_wp, 0.063482143_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.223928571_wp, 0.197187500_wp, 0.197187500_wp, 0.865714286_wp, & 
   & 0.945937500_wp, 0.892455357_wp, 0.999419643_wp, 1.240089286_wp, & 
   & 0.063482143_wp, 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.170446429_wp, 0.116964286_wp, 0.170446429_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.223928571_wp, 0.197187500_wp, & 
   & 0.170446429_wp, 0.785491071_wp, 0.945937500_wp, 0.250669643_wp, & 
   & 0.812232143_wp, 0.945937500_wp, 0.036741071_wp, 0.090223214_wp, & 
   & 0.090223214_wp, 0.250669643_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.143705357_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.250669643_wp, 0.945937500_wp, 0.250669643_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.972678571_wp, 0.223928571_wp, & 
   & 0.250669643_wp, 0.865714286_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.116964286_wp, 0.090223214_wp, 0.090223214_wp, 0.170446429_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.143705357_wp, 0.116964286_wp, & 
   & 0.090223214_wp, 0.170446429_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.143705357_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 92) / &
   & 0.892455357_wp, 1.240089286_wp, 0.197187500_wp, 0.223928571_wp, & 
   & 0.411116071_wp, 0.518080357_wp, 0.678526786_wp, 0.732008929_wp, & 
   & 0.865714286_wp, 0.919196429_wp, 0.197187500_wp, 0.090223214_wp, & 
   & 0.250669643_wp, 0.357633929_wp, 0.384375000_wp, 0.437857143_wp, & 
   & 0.518080357_wp, 0.544821429_wp, 0.063482143_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.143705357_wp, 0.170446429_wp, 0.223928571_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.223928571_wp, 0.223928571_wp, & 
   & 0.304151786_wp, 0.277410714_wp, 0.304151786_wp, 0.330892857_wp, & 
   & 0.384375000_wp, 0.411116071_wp, 0.464598214_wp, 0.464598214_wp, & 
   & 0.063482143_wp, 0.143705357_wp, 0.223928571_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.223928571_wp, 0.143705357_wp, 0.197187500_wp, & 
   & 0.223928571_wp, 0.250669643_wp, 0.304151786_wp, 0.277410714_wp, & 
   & 0.250669643_wp, 0.304151786_wp, 0.330892857_wp, 0.357633929_wp, & 
   & 0.384375000_wp, 0.411116071_wp, 0.036741071_wp, 0.143705357_wp, & 
   & 0.223928571_wp, 0.330892857_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, & 
   & 0.197187500_wp, 0.170446429_wp, 0.170446429_wp, 0.197187500_wp, & 
   & 0.277410714_wp, 0.330892857_wp, 0.357633929_wp, 0.330892857_wp, & 
   & 0.250669643_wp, 0.277410714_wp, 0.304151786_wp, 0.330892857_wp, & 
   & 0.357633929_wp, 0.384375000_wp, 0.116964286_wp, 0.143705357_wp, & 
   & 0.197187500_wp, 0.170446429_wp, 0.170446429_wp, 0.223928571_wp, & 
   & 0.170446429_wp, 0.277410714_wp, 0.250669643_wp, 0.223928571_wp, & 
   & 0.170446429_wp, 0.223928571_wp, 0.411116071_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.250669643_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 93) / &
   & 1.293571429_wp, 3.245669643_wp, 0.170446429_wp, 0.223928571_wp, & 
   & 0.919196429_wp, 0.812232143_wp, 1.480758929_wp, 1.828392857_wp, & 
   & 2.149285714_wp, 2.470178571_wp, 0.143705357_wp, 0.090223214_wp, & 
   & 1.079642857_wp, 0.785491071_wp, 0.625044643_wp, 0.758750000_wp, & 
   & 0.865714286_wp, 1.026160714_wp, 0.063482143_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.116964286_wp, 0.197187500_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.250669643_wp, 0.223928571_wp, 1.855133929_wp, 0.277410714_wp, & 
   & 0.411116071_wp, 0.571562500_wp, 0.678526786_wp, 0.838973214_wp, & 
   & 0.063482143_wp, 0.116964286_wp, 0.116964286_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.116964286_wp, 0.197187500_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.250669643_wp, 0.223928571_wp, & 
   & 0.892455357_wp, 0.223928571_wp, 0.277410714_wp, 0.304151786_wp, & 
   & 0.384375000_wp, 0.544821429_wp, 0.036741071_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.277410714_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, 0.143705357_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.143705357_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.812232143_wp, 0.330892857_wp, 0.277410714_wp, & 
   & 0.197187500_wp, 0.838973214_wp, 0.250669643_wp, 0.277410714_wp, & 
   & 0.304151786_wp, 0.357633929_wp, 0.090223214_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, 0.170446429_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.170446429_wp, 0.143705357_wp, & 
   & 0.116964286_wp, 0.197187500_wp, 0.143705357_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.143705357_wp, 0.143705357_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 94) / &
   & 0.758750000_wp, 2.710848214_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.330892857_wp, 0.544821429_wp, 0.678526786_wp, 0.812232143_wp, & 
   & 1.801651786_wp, 2.042321429_wp, 0.170446429_wp, 0.090223214_wp, & 
   & 0.197187500_wp, 0.250669643_wp, 0.330892857_wp, 0.357633929_wp, & 
   & 0.437857143_wp, 0.491339286_wp, 0.063482143_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.116964286_wp, 0.197187500_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.197187500_wp, 0.223928571_wp, & 
   & 0.250669643_wp, 0.250669643_wp, 0.223928571_wp, 0.250669643_wp, & 
   & 0.304151786_wp, 0.330892857_wp, 0.357633929_wp, 0.384375000_wp, & 
   & 0.063482143_wp, 0.143705357_wp, 0.116964286_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.197187500_wp, 0.116964286_wp, 0.170446429_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.250669643_wp, 0.223928571_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.250669643_wp, 0.250669643_wp, & 
   & 0.277410714_wp, 0.304151786_wp, 0.036741071_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.250669643_wp, 0.116964286_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.143705357_wp, 0.143705357_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.250669643_wp, 0.277410714_wp, 0.277410714_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.223928571_wp, 0.250669643_wp, & 
   & 0.250669643_wp, 0.277410714_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, 0.277410714_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.197187500_wp, 0.143705357_wp, & 
   & 0.116964286_wp, 0.250669643_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.143705357_wp, 0.143705357_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 95) / &
   & 1.828392857_wp, 2.443437500_wp, 0.277410714_wp, 0.197187500_wp, & 
   & 0.732008929_wp, 1.347053571_wp, 1.240089286_wp, 1.400535714_wp, & 
   & 1.748169643_wp, 1.935357143_wp, 0.197187500_wp, 0.090223214_wp, & 
   & 0.357633929_wp, 0.625044643_wp, 0.838973214_wp, 0.919196429_wp, & 
   & 1.133125000_wp, 1.159866071_wp, 0.063482143_wp, 0.197187500_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.143705357_wp, 0.277410714_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.277410714_wp, 0.277410714_wp, & 
   & 0.464598214_wp, 0.330892857_wp, 0.437857143_wp, 0.625044643_wp, & 
   & 0.838973214_wp, 0.919196429_wp, 0.999419643_wp, 0.999419643_wp, & 
   & 0.036741071_wp, 0.170446429_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.277410714_wp, 0.116964286_wp, 0.170446429_wp, & 
   & 0.250669643_wp, 0.304151786_wp, 0.437857143_wp, 0.330892857_wp, & 
   & 0.357633929_wp, 0.571562500_wp, 0.651785714_wp, 0.758750000_wp, & 
   & 0.838973214_wp, 0.945937500_wp, 0.036741071_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.705267857_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, 0.223928571_wp, & 
   & 0.250669643_wp, 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, & 
   & 0.330892857_wp, 0.571562500_wp, 0.732008929_wp, 0.518080357_wp, & 
   & 0.357633929_wp, 0.411116071_wp, 0.598303571_wp, 0.758750000_wp, & 
   & 0.838973214_wp, 0.838973214_wp, 0.143705357_wp, 0.170446429_wp, & 
   & 0.197187500_wp, 0.170446429_wp, 0.143705357_wp, 0.250669643_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.277410714_wp, 0.223928571_wp, & 
   & 0.143705357_wp, 0.277410714_wp, 0.197187500_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.250669643_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 96) / &
   & 0.945937500_wp, 2.550401786_wp, 0.250669643_wp, 0.197187500_wp, & 
   & 0.411116071_wp, 1.186607143_wp, 1.266830357_wp, 1.507500000_wp, & 
   & 1.694687500_wp, 1.935357143_wp, 0.197187500_wp, 0.090223214_wp, & 
   & 0.250669643_wp, 0.330892857_wp, 0.411116071_wp, 0.491339286_wp, & 
   & 0.571562500_wp, 0.651785714_wp, 0.063482143_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.143705357_wp, 0.250669643_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.223928571_wp, 0.250669643_wp, & 
   & 0.304151786_wp, 0.277410714_wp, 0.277410714_wp, 0.330892857_wp, & 
   & 0.384375000_wp, 0.411116071_wp, 0.464598214_wp, 0.518080357_wp, & 
   & 0.036741071_wp, 0.170446429_wp, 0.143705357_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.250669643_wp, 0.116964286_wp, 0.170446429_wp, & 
   & 0.223928571_wp, 0.250669643_wp, 0.304151786_wp, 0.277410714_wp, & 
   & 0.250669643_wp, 0.277410714_wp, 0.304151786_wp, 0.330892857_wp, & 
   & 0.357633929_wp, 0.384375000_wp, 0.036741071_wp, 0.143705357_wp, & 
   & 0.116964286_wp, 0.330892857_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, & 
   & 0.250669643_wp, 0.330892857_wp, 0.357633929_wp, 0.330892857_wp, & 
   & 0.250669643_wp, 0.250669643_wp, 0.277410714_wp, 0.304151786_wp, & 
   & 0.330892857_wp, 0.357633929_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.116964286_wp, 0.223928571_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.223928571_wp, 0.143705357_wp, & 
   & 0.116964286_wp, 0.277410714_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 97) / &
   & 1.079642857_wp, 3.593303571_wp, 0.143705357_wp, 0.223928571_wp, & 
   & 0.357633929_wp, 1.026160714_wp, 1.587723214_wp, 2.149285714_wp, & 
   & 2.309732143_wp, 2.844553571_wp, 0.143705357_wp, 0.090223214_wp, & 
   & 0.197187500_wp, 0.250669643_wp, 0.999419643_wp, 1.133125000_wp, & 
   & 1.266830357_wp, 1.373794643_wp, 0.063482143_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.223928571_wp, 0.197187500_wp, 0.197187500_wp, 0.223928571_wp, & 
   & 0.999419643_wp, 1.026160714_wp, 0.999419643_wp, 1.159866071_wp, & 
   & 0.063482143_wp, 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.170446429_wp, 0.143705357_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.223928571_wp, 0.197187500_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.838973214_wp, 0.972678571_wp, & 
   & 0.945937500_wp, 1.026160714_wp, 0.036741071_wp, 0.090223214_wp, & 
   & 0.090223214_wp, 0.972678571_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.090223214_wp, 0.090223214_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.223928571_wp, 0.838973214_wp, 0.250669643_wp, & 
   & 1.828392857_wp, 0.170446429_wp, 0.197187500_wp, 0.945937500_wp, & 
   & 0.892455357_wp, 0.972678571_wp, 0.090223214_wp, 0.090223214_wp, & 
   & 0.116964286_wp, 0.090223214_wp, 0.090223214_wp, 0.170446429_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.143705357_wp, 0.116964286_wp, & 
   & 0.090223214_wp, 0.170446429_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.143705357_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 98) / &
   & 2.924776786_wp, 3.459598214_wp, 0.250669643_wp, 0.197187500_wp, & 
   & 0.705267857_wp, 0.812232143_wp, 1.774910714_wp, 2.042321429_wp, & 
   & 2.336473214_wp, 2.710848214_wp, 0.197187500_wp, 0.090223214_wp, & 
   & 0.304151786_wp, 0.437857143_wp, 0.518080357_wp, 0.598303571_wp, & 
   & 0.732008929_wp, 0.892455357_wp, 0.063482143_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, 0.250669643_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.250669643_wp, 0.277410714_wp, & 
   & 0.357633929_wp, 0.304151786_wp, 0.330892857_wp, 0.411116071_wp, & 
   & 0.464598214_wp, 0.491339286_wp, 0.544821429_wp, 0.651785714_wp, & 
   & 0.036741071_wp, 0.170446429_wp, 0.250669643_wp, 0.170446429_wp, & 
   & 0.197187500_wp, 0.250669643_wp, 0.116964286_wp, 0.170446429_wp, & 
   & 0.250669643_wp, 0.277410714_wp, 0.357633929_wp, 0.304151786_wp, & 
   & 0.277410714_wp, 0.330892857_wp, 0.384375000_wp, 0.384375000_wp, & 
   & 0.437857143_wp, 0.491339286_wp, 0.036741071_wp, 0.170446429_wp, & 
   & 0.197187500_wp, 0.384375000_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, 0.197187500_wp, & 
   & 0.223928571_wp, 0.143705357_wp, 0.143705357_wp, 0.197187500_wp, & 
   & 0.304151786_wp, 0.384375000_wp, 0.437857143_wp, 0.384375000_wp, & 
   & 0.304151786_wp, 0.330892857_wp, 0.357633929_wp, 0.384375000_wp, & 
   & 0.411116071_wp, 0.437857143_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.223928571_wp, 0.170446429_wp, 0.170446429_wp, 0.223928571_wp, & 
   & 0.197187500_wp, 0.250669643_wp, 0.277410714_wp, 0.277410714_wp, & 
   & 0.170446429_wp, 0.223928571_wp, 0.223928571_wp, 0.170446429_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.384375000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 99) / &
   & 0.732008929_wp, 2.764330357_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.330892857_wp, 1.774910714_wp, 2.042321429_wp, 0.732008929_wp, & 
   & 2.122544643_wp, 2.336473214_wp, 0.170446429_wp, 0.090223214_wp, & 
   & 0.223928571_wp, 0.250669643_wp, 0.304151786_wp, 0.357633929_wp, & 
   & 0.411116071_wp, 0.464598214_wp, 0.063482143_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.143705357_wp, 0.197187500_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.197187500_wp, 0.223928571_wp, & 
   & 0.250669643_wp, 0.250669643_wp, 0.223928571_wp, 0.250669643_wp, & 
   & 0.277410714_wp, 0.304151786_wp, 0.330892857_wp, 0.384375000_wp, & 
   & 0.036741071_wp, 0.143705357_wp, 0.116964286_wp, 0.143705357_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.116964286_wp, 0.170446429_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.223928571_wp, 0.223928571_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.250669643_wp, 0.250669643_wp, & 
   & 0.277410714_wp, 0.304151786_wp, 0.036741071_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.250669643_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, & 
   & 0.223928571_wp, 0.250669643_wp, 0.277410714_wp, 0.250669643_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.223928571_wp, 0.223928571_wp, & 
   & 0.250669643_wp, 0.277410714_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, 0.411116071_wp, & 
   & 0.143705357_wp, 0.116964286_wp, 0.197187500_wp, 0.143705357_wp, & 
   & 0.116964286_wp, 0.223928571_wp, 0.143705357_wp, 0.116964286_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 100) / &
   & 1.052901786_wp, 3.620044643_wp, 0.170446429_wp, 0.197187500_wp, & 
   & 0.357633929_wp, 1.454017857_wp, 1.881875000_wp, 2.550401786_wp, & 
   & 2.550401786_wp, 3.031741071_wp, 0.143705357_wp, 0.090223214_wp, & 
   & 0.197187500_wp, 0.250669643_wp, 0.304151786_wp, 0.411116071_wp, & 
   & 0.945937500_wp, 1.320312500_wp, 0.063482143_wp, 0.116964286_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.116964286_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, 0.197187500_wp, & 
   & 0.223928571_wp, 0.223928571_wp, 0.197187500_wp, 0.223928571_wp, & 
   & 0.277410714_wp, 0.330892857_wp, 0.384375000_wp, 0.598303571_wp, & 
   & 0.036741071_wp, 0.116964286_wp, 0.116964286_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.116964286_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.223928571_wp, 0.197187500_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.223928571_wp, 0.250669643_wp, & 
   & 0.250669643_wp, 0.304151786_wp, 0.036741071_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.223928571_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, 0.143705357_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.250669643_wp, 0.250669643_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.197187500_wp, 0.223928571_wp, & 
   & 0.250669643_wp, 0.250669643_wp, 0.090223214_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, 0.197187500_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.170446429_wp, 0.143705357_wp, & 
   & 0.116964286_wp, 0.170446429_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.143705357_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 101) / &
   & 1.079642857_wp, 3.673526786_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.384375000_wp, 1.427276786_wp, 1.855133929_wp, 2.523660714_wp, & 
   & 2.523660714_wp, 3.031741071_wp, 0.170446429_wp, 0.090223214_wp, & 
   & 0.223928571_wp, 0.277410714_wp, 0.357633929_wp, 1.962098214_wp, & 
   & 1.988839286_wp, 2.149285714_wp, 0.063482143_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.116964286_wp, 0.197187500_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.197187500_wp, 0.197187500_wp, & 
   & 0.250669643_wp, 0.250669643_wp, 0.223928571_wp, 0.250669643_wp, & 
   & 1.935357143_wp, 1.881875000_wp, 1.828392857_wp, 2.069062500_wp, & 
   & 0.036741071_wp, 0.116964286_wp, 0.116964286_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.197187500_wp, 0.116964286_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.250669643_wp, 0.223928571_wp, & 
   & 1.908616071_wp, 0.223928571_wp, 0.250669643_wp, 1.935357143_wp, & 
   & 1.881875000_wp, 1.962098214_wp, 0.036741071_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 1.881875000_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, 0.143705357_wp, & 
   & 0.116964286_wp, 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.170446429_wp, 0.143705357_wp, 0.143705357_wp, 0.197187500_wp, & 
   & 0.197187500_wp, 0.277410714_wp, 0.304151786_wp, 0.277410714_wp, & 
   & 0.197187500_wp, 0.197187500_wp, 0.223928571_wp, 1.881875000_wp, & 
   & 1.801651786_wp, 1.962098214_wp, 0.116964286_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, 0.197187500_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.170446429_wp, 0.143705357_wp, & 
   & 0.116964286_wp, 0.197187500_wp, 0.143705357_wp, 0.116964286_wp, & 
   & 0.116964286_wp, 0.143705357_wp, 0.143705357_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 102) / &
   & 1.106383929_wp, 3.700267857_wp, 0.223928571_wp, 0.197187500_wp, & 
   & 0.411116071_wp, 1.507500000_wp, 1.881875000_wp, 2.470178571_wp, & 
   & 2.603883929_wp, 3.005000000_wp, 0.143705357_wp, 0.090223214_wp, & 
   & 0.223928571_wp, 0.304151786_wp, 0.384375000_wp, 1.721428571_wp, & 
   & 1.881875000_wp, 1.935357143_wp, 0.063482143_wp, 0.170446429_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.143705357_wp, 0.223928571_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.223928571_wp, 0.223928571_wp, & 
   & 0.277410714_wp, 0.250669643_wp, 1.908616071_wp, 0.277410714_wp, & 
   & 0.357633929_wp, 1.694687500_wp, 1.694687500_wp, 1.855133929_wp, & 
   & 0.036741071_wp, 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.116964286_wp, 0.170446429_wp, & 
   & 0.197187500_wp, 0.223928571_wp, 0.277410714_wp, 0.250669643_wp, & 
   & 0.223928571_wp, 0.250669643_wp, 0.277410714_wp, 0.304151786_wp, & 
   & 0.330892857_wp, 0.384375000_wp, 0.036741071_wp, 0.143705357_wp, & 
   & 0.116964286_wp, 0.304151786_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.143705357_wp, 0.116964286_wp, 0.170446429_wp, & 
   & 0.223928571_wp, 0.277410714_wp, 0.330892857_wp, 0.304151786_wp, & 
   & 0.223928571_wp, 0.223928571_wp, 0.250669643_wp, 0.277410714_wp, & 
   & 0.304151786_wp, 0.330892857_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.116964286_wp, 0.116964286_wp, 0.116964286_wp, 0.223928571_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.197187500_wp, 0.143705357_wp, & 
   & 0.116964286_wp, 0.223928571_wp, 0.143705357_wp, 0.116964286_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.170446429_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 103) / &
   & 1.079642857_wp, 2.550401786_wp, 0.223928571_wp, 0.170446429_wp, & 
   & 0.464598214_wp, 1.106383929_wp, 1.320312500_wp, 1.507500000_wp, & 
   & 1.774910714_wp, 1.935357143_wp, 0.170446429_wp, 0.090223214_wp, & 
   & 0.277410714_wp, 0.357633929_wp, 0.437857143_wp, 0.518080357_wp, & 
   & 0.625044643_wp, 0.732008929_wp, 0.036741071_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.197187500_wp, 0.143705357_wp, 0.250669643_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.250669643_wp, 0.277410714_wp, & 
   & 0.330892857_wp, 0.304151786_wp, 0.304151786_wp, 0.357633929_wp, & 
   & 0.411116071_wp, 0.464598214_wp, 0.518080357_wp, 0.571562500_wp, & 
   & 0.036741071_wp, 0.170446429_wp, 0.143705357_wp, 0.197187500_wp, & 
   & 0.170446429_wp, 0.250669643_wp, 0.116964286_wp, 0.170446429_wp, & 
   & 0.223928571_wp, 0.277410714_wp, 0.304151786_wp, 0.304151786_wp, & 
   & 0.250669643_wp, 0.304151786_wp, 0.330892857_wp, 0.357633929_wp, & 
   & 0.384375000_wp, 0.437857143_wp, 0.036741071_wp, 0.143705357_wp, & 
   & 0.116964286_wp, 0.357633929_wp, 0.143705357_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, 0.197187500_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, 0.170446429_wp, & 
   & 0.170446429_wp, 0.170446429_wp, 0.197187500_wp, 0.223928571_wp, & 
   & 0.223928571_wp, 0.143705357_wp, 0.116964286_wp, 0.170446429_wp, & 
   & 0.277410714_wp, 0.357633929_wp, 0.357633929_wp, 0.357633929_wp, & 
   & 0.250669643_wp, 0.277410714_wp, 0.304151786_wp, 0.330892857_wp, & 
   & 0.357633929_wp, 0.384375000_wp, 0.116964286_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.143705357_wp, 0.250669643_wp, & 
   & 0.143705357_wp, 0.143705357_wp, 0.250669643_wp, 0.170446429_wp, & 
   & 0.143705357_wp, 0.384375000_wp, 0.143705357_wp, 0.143705357_wp, & 
   & 0.143705357_wp, 0.170446429_wp, 0.143705357_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 104) / &
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 105) / &
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 106) / &
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 107) / &
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 108) / &
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 109) / &
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 110) / &
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 111) / &
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 112) / &
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 113) / &
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 114) / &
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 115) / &
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 116) / &
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 117) / &
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /

   data weight_factors(:, 118) / &
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, 6.000000000_wp, & 
   & 6.000000000_wp, 6.000000000_wp /


contains


!> Get pairwise CN weighting factor for a given element symbol pair
elemental function get_wfpair_val_sym(symi, symj) result(wfpair)

   !> Element symbol i
   character(len=*), intent(in) :: symi

   !> Element symbol j
   character(len=*), intent(in) :: symj

   !> Pairwise CN weighting factor
   real(wp) :: wfpair

   wfpair = get_wfpair_val(to_number(symi), to_number(symj))

end function get_wfpair_val_sym


!> Get pairwise CN weighting factor for a given atomic number pair
elemental function get_wfpair_val_num(numi, numj) result(wfpair)

   !> Atomic number i
   integer, intent(in) :: numi

   !> Atomic number i
   integer, intent(in) :: numj

   !> Pairwise CN weighting factor
   real(wp) :: wfpair

   wfpair = weight_factors(numi, numj)

end function get_wfpair_val_num


end module dftd4_data_wfpair
