# Local Resolution of Identity

## Introduction

Density functional theory (DFT) calculations in CP2K employ the Gaussian and plane waves (GPW)
method. In GPW, the description of the total density on realspace grids is typically the
computationally most expensive part. By introducing a local resolution-of-the-identity (LRI)
approach, the linear scaling of the GPW approach can be retained, while reducing the prefactor for
the grid operations. The combined approach, LRIGPW, is comprehensively described in [](#Golze2017b).

In LRIGPW, the atomic pair densities $\rho_{\mathrm{AB}}$ are approximated by an expansion in a set
of fit functions centered at atom A $\{f_i^{\mathrm{A}}(\mathbf{r})\}$ and atom B
$\{f_j^{\mathrm{B}}(\mathbf{r})\}$,

$$
\rho_{\mathrm{AB}}\approx \sum_i{a_i^{\mathrm{A},(\mathrm{AB})}f_i^{\mathrm{A}}}(\mathbf{r}) +
\sum_j{a_j^{\mathrm{B},(\mathrm{AB})}f_j^{\mathrm{B}}}(\mathbf{r}).
$$

The fit functions are also Gaussian-type functions and provided as auxiliary basis set.

## How to use it

LRIGPW is specified in the [QS](#CP2K_INPUT.FORCE_EVAL.DFT.QS) section by setting METHOD LRIGPW.

```
&QS
  METHOD LRIGPW
  &LRIGPW
     LRI_OVERLAP_MATRIX INVERSE
     SHG_LRI_INTEGRALS
  &END
&END QS
```

Further specifications can be given in the [LRIGPW](#CP2K_INPUT.FORCE_EVAL.DFT.QS.LRIGPW)
subsection. LRIGPW requires additionally an auxiliary basis set as input.

```
 &DFT
    BASIS_SET_FILE_NAME BASIS_LRIGPW_AUXMOLOPT
    BASIS_SET_FILE_NAME BASIS_MOLOPT
    ...
 &END DFT
 &SUBSYS
    &KIND O
      BASIS_SET DZVP-MOLOPT-GTH
      POTENTIAL GTH-PBE-q6
      LRI_BASIS_SET LRI-DZVP-MOLOPT-GTH-MEDIUM
    &END KIND
    ...
 &END SUBSYS
```

Auxiliary basis sets are available for the MOLOPT basis sets. All auxiliary basis sets have been
generated by simple geometric progression without any need for further optimization. These basis
sets are available in different sizes: `MEDIUM` and `LARGE`. Using the large auxiliary basis sets,
the accuracy is improved, but the computational overhead increases.

The LRI auxiliary basis sets are generally quite large leading to a potentially ill-conditioned
overlap matrix, Equation (10) in [](#Golze2017b). The inversion of this matrix can thus be numerical
instable.

If the SCF is not converging, set
[LRI_OVERLAP_MATRIX](#CP2K_INPUT.FORCE_EVAL.DFT.QS.LRIGPW.LRI_OVERLAP_MATRIX) to `AUTOSELECT`. In
this case, the atomic pairs are identified that have extremely large condition numbers. For these
pairs, the pseudoinverse instead of the regular inverse is calculated. The threshold for the
condition number can be given by
[MAX_CONDITION_NUM](#CP2K_INPUT.FORCE_EVAL.DFT.QS.LRIGPW.MAX_CONDITION_NUM).

The LRI integrals, Equations (31)-(34) in [](#Golze2017b), are calculated prior to the SCF. The
traditionally used Obara-Saika scheme is computationally too demanding here. Therefore, a more
efficient integral scheme based on solid harmonic Gaussians (SHG) is employed and invoked by
[SHG_LRI_INTEGRALS](#CP2K_INPUT.FORCE_EVAL.DFT.QS.LRIGPW.SHG_LRI_INTEGRALS), see [](#Golze2017) for
details.

## When to use it

LRIGPW is only beneficial when the operations on the realspace grids, i.e. collocation of the
density and integration of the potential, are dominating the timings. This is typically not the case
for metallic systems, where the diagonalization of the Kohn-Sham matrix contributes strongly to the
computational cost. LRIGPW is efficient for condensed phase systems such as liquids, molecular
crystals etc. Particularly large speed-ups can be obtained for:

- non-orthorhombic cells
- large grid cutoffs
- many SCF steps

Using LRI, the SCF step is accelerated and therefore single point calculations profit most. For
molecular dynamics, where the wave function can be extrapolated from the previous step, the SCF
converges quickly. Also in this case speed-ups can be obtained depending on the grid cutoff and
system. Note that LRIGPW comes with higher memory requirements than the standard GPW scheme.
However, this is typically not a problem on HPC platforms, but might limit the usage on smaller
clusters.

## Example input files

- Ice XV: <path:lrigpw_example.inp>
