#ifndef _CEGOTRANSACTIONMANAGER_H_INCLUDED_
#define _CEGOTRANSACTIONMANAGER_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoTransactionManager.h
// ------------------------
// Cego transaction manager class definition
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2019 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoTransactionManager
// 
// Description: Transaction data structures
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/SetT.h>
#include <lfcbase/Chain.h>

// cego includes
#include "CegoDefs.h"
#include "CegoTableManager.h"
#include "CegoTableObject.h"
#include "CegoQueryHelper.h"

#define MAXTRANSACTION 30

// forward declaration
class CegoTableManager;

class CegoTransactionManager {
    
public:

    CegoTransactionManager(CegoTableManager* pTM);
    ~CegoTransactionManager();
       
    void release(int tabSetId);
    
    void reorgSystemSpace(int tabSetId);

    void recordUpdate(int tabSetId, unsigned long long tid, const CegoDataPointer& dp );
    void commitUpdate(int tabSetId, const Chain& idxName, const CegoObject::ObjectType idxType, unsigned long long tid, bool doAppend);
    void abortUpdate(int tabSetId, unsigned long long tid);
    
    void getRBDataPtr(int tabSetId, unsigned long long tid, PageIdType pageId, int offset, int& rbfileId, int& rbpageId, int& rboffset);
    
    void newRBEntry(int tabSetId, unsigned long long tid, PageIdType pageId, int offset, const Chain& tableName);
    
    unsigned long long commitTransaction(int tabSetId, unsigned long long tid);

    void getCrashAffectedTables(int tabSetId, SetT<Chain>& tableList);
    void getTransactionAffectedTables(int tabSetId, unsigned long long tid, SetT<Chain>& tableList);

    bool hasOpenTransaction(int tabSetId, const Chain& tableName) const;
    void finishOpenTransaction(int tabSetId);
    unsigned long long rollbackTransaction(int tabSetId, unsigned long long tid);
    
    void getTransactionInfo(int tabSetId, const Chain& rbo, int& numop);
     
private:

    unsigned long long doCommit(int tabSetId, const Chain& rbo);
    unsigned long long doRollback(int tabSetId, const Chain& rbo);
    
    class TAEntry {
	
    public:
	
	TAEntry();
	TAEntry(const unsigned long long tid);
	TAEntry(const unsigned long long tid,
		// const CegoBufferPage& bp,
		const CegoTableObject& oe);
	~TAEntry();
	
	const unsigned long long getTid() const;
	
	CegoTableObject& getTableObject();
	
	TAEntry& operator = ( const TAEntry& t);
        bool operator == ( const TAEntry& t);
	
	friend ostream& operator << (ostream& s, const TAEntry& t)
	{
	    s << "(" << t._tid << ")";
	    return s;
	}

    private:

	unsigned long long _tid;
	CegoTableObject _oe;
    };
    
    ListT<TAEntry> _taList;
    ListT<TAEntry> _udList;
    
    CegoDatabaseManager *_pDBMng;
    CegoTableManager* _pTabMng;

    ListT<CegoField> _updSchema;
    ListT<CegoField> _rbcatSchema;

    CegoQueryHelper _qh;

    unsigned long _modId;
};

#endif
