#ifndef _CEGOQUERY_H_INCLUDED_
#define _CEGOQUERY_H_INCLUDED_
///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoQuery.h
// -----------
// Cego query handling
//
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2019 Bjoern Lemke
//
// INTERFACE MODULE
//
// Class: CegoQuery
// 
// Description: CegoQuery implements a container class for insert, update and delete queries.
//              This is used for representation of such queries in the native parser but also 
//              inside stored procedures.    
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// base includes
#include <lfcbase/Chain.h>
#include <lfcbase/ListT.h>

// cego includes
#include "CegoDistManager.h"
#include "CegoPredDesc.h"
#include "CegoExpr.h"
#include "CegoAlterDesc.h"
#include "CegoReturnVar.h"
#include "CegoSelect.h"

class CegoDatabaseFormater;

class CegoQuery {
    
public:

    enum QueryMode { INSERT_QUERY, 
		     INSERTBYSELECT_QUERY, 
		     DELETE_QUERY,
		     UPDATE_QUERY,
		     ALTER_QUERY,
		     RENAME_QUERY,
		     START_QUERY,
		     COMMIT_QUERY,
		     ROLLBACK_QUERY,
		     LOCK_QUERY,
		     UNLOCK_QUERY };

    enum TransactionOp { START, COMMIT, ROLLBACK };

    CegoQuery(CegoDistManager* pGTM, const Chain& tableSet, TransactionOp to);

    CegoQuery(CegoDistManager* pGTM, const Chain& tableSet, const Chain& tableName, const Chain& tableAlias, CegoPredDesc* pPred);
    CegoQuery(CegoDistManager* pGTM, const Chain& tableSet, const Chain& tableName, const Chain& tableAlias,  CegoPredDesc* pPred, ListT<CegoField>& updSchema, const ListT<CegoExpr*>& updList, const ListT<CegoReturnVar*> retVarList, bool onFirst);

    CegoQuery(CegoDistManager* pGTM, const Chain& tableSet, const Chain& tableName, bool doLock);
    
    CegoQuery(CegoDistManager* pGTM, const Chain& tableSet, const Chain& tableName,  const ListT<CegoField>& schema, const ListT<ListT<CegoExpr*> >& exprListArray);

    CegoQuery(CegoDistManager* pGTM, const Chain& tableSet, const Chain& tableName,   const ListT<CegoField>& schema, CegoSelect* pSelect);

    CegoQuery(CegoDistManager* pGTM, const Chain& tableSet, const Chain& tableName,  const ListT<CegoAlterDesc>& alterList);
    
    CegoQuery(CegoDistManager* pGTM, const Chain& tableSet, const Chain& objName, CegoObject::ObjectType objType, const Chain& newObjName );    
   
    ~CegoQuery();

    void setBlock(CegoProcBlock *pBlock);

    Chain execute(CegoProcBlock* pBlock = 0);

    long getAffectedCount() const;
    
    Chain toChain(const Chain& indent) const;
    Chain dbFormat(CegoDatabaseFormater *pForm) const;
    
private:

    void prepareFieldValue(CegoField *pFV, CegoFieldValue& fv, int pos);

    QueryMode _mode;
    CegoDistManager* _pGTM;
    Chain _tableName;
    Chain _tableAlias;
    Chain _objName;
    CegoObject::ObjectType _objType;

    Chain _newObjName;
    Chain _tableSet;

    ListT<CegoField> _schema;
    ListT<CegoExpr*> _updList;
    ListT<ListT<CegoExpr*> > _exprListArray;
    ListT<CegoReturnVar*> _retVarList;
    bool _returnOnFirst;
    
    ListT<CegoAlterDesc> _alterList; 
    CegoPredDesc *_pPred;
    CegoSelect *_pSelect;
    long _affCount;
};

#endif
