///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoProcCursor.cc
// -----------------
// Cego stored procedure cursor 
//      
// Design and Implementation by Bjoern Lemke
//     
// (C)opyright 2000-2019 Bjoern Lemke
//
// IMPLEMENTATION MODULE
//
// Class: CegoProcCursor
//
// Description: Stored procedure cursor handle
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// CEGO INCLUDES
#include "CegoProcCursor.h"
#include "CegoSelect.h"

CegoProcCursor::CegoProcCursor()
{
    _pSelect = 0;
}

CegoProcCursor::CegoProcCursor(const CegoProcCursor& pc)
{
    _name = pc._name;
    _pSelect = pc._pSelect;
    _status = pc._status;
}

CegoProcCursor::CegoProcCursor(const Chain& name)
{
    _name = name;
    _pSelect = 0;
    _status = CLOSED;
}

CegoProcCursor::CegoProcCursor(const Chain& name, CegoSelect *pSelect)
{
    _name = name;
    _pSelect = pSelect;
    _status = CLOSED;
}

CegoProcCursor::~CegoProcCursor()
{
    if ( _pSelect )
	delete _pSelect;
}
   
void CegoProcCursor::setName(const Chain& name)
{
    _name = name;
}
 
const Chain& CegoProcCursor::getName() const
{
    return _name;
}
    
void CegoProcCursor::setSelect(CegoSelect* pSelect)
{
    _pSelect = pSelect;
}

CegoSelect* CegoProcCursor::getSelect() const
{
    return _pSelect;
}

void CegoProcCursor::open()
{
    if ( _pSelect )
    {
	_pSelect->prepare();	
	_status = OPEN;
    }
    else
    {
	throw Exception(EXLOC, "Invalid select handle");
    }
}

void CegoProcCursor::close()
{
    if ( _pSelect )
    {
	_pSelect->cleanUp();
	_status = CLOSED;
    }
    else
    {
	throw Exception(EXLOC, "Invalid select handle");
    }
}

void CegoProcCursor::reset()
{
    if ( _pSelect )
    {
	_pSelect->reset(true);
	_status = CLOSED;
    }
    else
    {
	throw Exception(EXLOC, "Invalid select handle");
    }
}

bool CegoProcCursor::nextTuple(ListT<CegoField>& fl)
{
    if ( _status == CLOSED  )
	open();

    if ( _pSelect )
    {
	bool retVal = _pSelect->nextTuple(fl);
	if ( retVal == false )
	    _status = CLOSED;
	return retVal;
    }
    else
    {
	throw Exception(EXLOC, "Invalid select handle");
    }
}
        
CegoProcCursor& CegoProcCursor::operator = ( const CegoProcCursor& pc)
{
    _name = pc._name;
    _pSelect = pc._pSelect;
    _status = pc._status;
    return (*this);
}
    
bool CegoProcCursor::operator == ( const CegoProcCursor& pc)
{
    if ( _name == pc._name )
	return true;
    return false;
}

Chain CegoProcCursor::toChain() const
{
    Chain s;
    s = _name;
    return s;
}

ostream& operator << (ostream& s, const CegoProcCursor& pc)
{    
    s <<  pc._name;
    return s;
}
