drop if exists table amounttab;
create table amounttab ( vtid int, region string(10), amount int);

drop if exists table vehicletab;
create table vehicletab ( vtid int, reg1fac float, reg2fac float, reg3fac float);

drop if exists procedure getWeight;
@
create procedure getWeight(vtid in int, reg in string(10)) return float
begin
	var s float;
	var a float;
	
	:s = ( select sum(amount) from amounttab where vtid = 1 );
	:a = ( select sum(amount) from amounttab where vtid = :vtid and region = :reg);

	return :a / :s;	
end;
@

insert into amounttab values ( 1, 'R1', 4000);
insert into amounttab values ( 1, 'R2', 2000);
insert into amounttab values ( 1, 'R3', 8000);
insert into amounttab values ( 2, 'R1', 34000);
insert into amounttab values ( 2, 'R2', 35000);
insert into amounttab values ( 2, 'R3', 9000);


insert into vehicletab values ( 1, 66.5, 2.3, 5.6);
insert into vehicletab values ( 1, 0.91, 1.43, 2.8);
insert into vehicletab values ( 1, 2.23, 8.243, 4.46);
insert into vehicletab values ( 2, 1.23, 66.43, 12.26);


select vtid, getWeight(vtid, 'R1') * reg1fac +
       	     getWeight(vtid, 'R2') * reg2fac +
       	     getWeight(vtid, 'R3') * reg3fac from vehicletab;

select vtid, getWeight(vtid, 'R1') * reg1fac +
       	     getWeight(vtid, 'R2') * reg2fac +
       	     getWeight(vtid, 'R3') * reg3fac from vehicletab;

show pool;

select vtid, getWeight(vtid, 'R1') * reg1fac from vehicletab;
