# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.2.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""Probabilistic meta-package."""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _uncertainty
else:
    import _uncertainty

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _uncertainty.delete_SwigPyIterator

    def value(self):
        return _uncertainty.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _uncertainty.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _uncertainty.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _uncertainty.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _uncertainty.SwigPyIterator_equal(self, x)

    def copy(self):
        return _uncertainty.SwigPyIterator_copy(self)

    def next(self):
        return _uncertainty.SwigPyIterator_next(self)

    def __next__(self):
        return _uncertainty.SwigPyIterator___next__(self)

    def previous(self):
        return _uncertainty.SwigPyIterator_previous(self)

    def advance(self, n):
        return _uncertainty.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _uncertainty.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _uncertainty.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _uncertainty.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _uncertainty.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _uncertainty.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _uncertainty.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _uncertainty:
_uncertainty.SwigPyIterator_swigregister(SwigPyIterator)
import openturns.base
import openturns.common
import openturns.typ
import openturns.statistics
import openturns.graph
import openturns.func
import openturns.geom
import openturns.iterative_statistics
import openturns.diff
import openturns.optim
import openturns.experiment
import openturns.solver
import openturns.algo
import openturns.model_copula
import openturns.randomvector
import openturns.dist_bundle1
import openturns.dist_bundle2
import openturns.weightedexperiment
import openturns.classification
import openturns.orthogonalbasis
import openturns.metamodel
class TaylorExpansionMoments(openturns.common.PersistentObject):
    r"""
    Moments approximations from Taylor expansions.


    Parameters
    ----------
    limitStateVariable : :class:`~openturns.RandomVector`
        It must be of type *Composite*, which means it must have
        been defined with the class :class:`~openturns.CompositeRandomVector`.

    Notes
    -----
    Assuming that :math:`\uX` has finite first and second order moments and that :math:`h` is sufficiently smooth,
    a Taylor expansion of the function :math:`h` is used to approximate the mean and variance
    of the random vector :math:`\uY = h(\uX)`.

    Refer to Refer to :ref:`Taylor Expansion Moments <taylor_expansion_moments>` for details on the expressions of the approximations:

    - the first-order  expansion of :math:`h` yields an approximation of the mean and the variance of :math:`\uY`;
    - the second-order  expansion of :math:`h` yields an approximation of the mean :math:`\uY`.

    Refer to :ref:`Taylor Importance Factors <taylor_importance_factors>` for details on the importance factors of each input on the output.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> myFunc = ot.SymbolicFunction(['x1', 'x2', 'x3', 'x4'],
    ...     ['(x1*x1+x2^3*x1)/(2*x3*x3+x4^4+1)', 'cos(x2*x2+x4)/(x1*x1+1+x3^4)'])
    >>> R = ot.CorrelationMatrix(4)
    >>> for i in range(4):
    ...     R[i, i - 1] = 0.25
    >>> distribution = ot.Normal([0.2]*4, [0.1, 0.2, 0.3, 0.4], R)
    >>> # We create a distribution-based RandomVector
    >>> X = ot.RandomVector(distribution)
    >>> # We create a composite RandomVector Y from X and myFunc
    >>> Y = ot.CompositeRandomVector(myFunc, X)
    >>> # We create a Taylor expansion method to approximate moments
    >>> myTaylorExpansionMoments = ot.TaylorExpansionMoments(Y)
    >>> print(myTaylorExpansionMoments.getMeanFirstOrder())
    [0.0384615,0.932544]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _uncertainty.TaylorExpansionMoments_getClassName(self)

    def __repr__(self):
        return _uncertainty.TaylorExpansionMoments___repr__(self)

    def getLimitStateVariable(self):
        r"""
        Get the limit state variable.

        Returns
        -------
        limitStateVariable : :class:`~openturns.RandomVector`
            The :math:`Y` output random vector.
        """
        return _uncertainty.TaylorExpansionMoments_getLimitStateVariable(self)

    def getMeanFirstOrder(self):
        r"""
        Get the first-order approximation of the mean.

        Returns
        -------
        mean : :class:`~openturns.Point`
            Approximation of :math:`\Expect{Y}` 
            from the first-order Taylor expansion.
        """
        return _uncertainty.TaylorExpansionMoments_getMeanFirstOrder(self)

    def getMeanSecondOrder(self):
        r"""
        Get the second-order approximation of the mean.

        Returns
        -------
        mean : :class:`~openturns.Point`
            Approximation of :math:`\Expect{Y}` 
            from the second-order Taylor expansion.
        """
        return _uncertainty.TaylorExpansionMoments_getMeanSecondOrder(self)

    def getCovariance(self):
        r"""
        Get the approximation of the covariance matrix.

        Returns
        -------
        covariance : :class:`~openturns.CovarianceMatrix`
            Approximation of the covariance matrix from 
            the first-order Taylor expansion.
        """
        return _uncertainty.TaylorExpansionMoments_getCovariance(self)

    def getValueAtMean(self):
        r"""
        Get the value of the function at the mean point.

        Returns
        -------
        value : :class:`~openturns.Point`
            Value :math:`h(\Expect{\uX})`.
        """
        return _uncertainty.TaylorExpansionMoments_getValueAtMean(self)

    def getGradientAtMean(self):
        r"""
        Get the gradient of the function at the mean point.

        Returns
        -------
        gradient : :class:`~openturns.Matrix`
            Gradient of :math:`h` at
            the mean point of the input random vector.
        """
        return _uncertainty.TaylorExpansionMoments_getGradientAtMean(self)

    def getHessianAtMean(self):
        r"""
        Get the hessian of the function.

        Returns
        -------
        hessian : :class:`~openturns.SymmetricTensor`
            Hessian of the Function which defines the random vector at
            the mean point of the input random vector.
        """
        return _uncertainty.TaylorExpansionMoments_getHessianAtMean(self)

    def getImportanceFactors(self):
        r"""
        Get the importance factors.

        Returns
        -------
        factors : :class:`~openturns.Point`
            Importance factors of the inputs : only when randVect is of dimension 1.
        """
        return _uncertainty.TaylorExpansionMoments_getImportanceFactors(self)

    def drawImportanceFactors(self):
        r"""
        Draw the importance factors.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            Pie graph of the importance factors.
        """
        return _uncertainty.TaylorExpansionMoments_drawImportanceFactors(self)

    def __init__(self, *args):
        _uncertainty.TaylorExpansionMoments_swiginit(self, _uncertainty.new_TaylorExpansionMoments(*args))
    __swig_destroy__ = _uncertainty.delete_TaylorExpansionMoments

# Register TaylorExpansionMoments in _uncertainty:
_uncertainty.TaylorExpansionMoments_swigregister(TaylorExpansionMoments)
class EfficientGlobalOptimization(openturns.optim.OptimizationAlgorithmImplementation):
    r"""
    Efficient Global Optimization algorithm.

    The EGO algorithm [jones1998]_ is an adaptative optimization method based on
    kriging.
    An initial design of experiment is used to build a first metamodel.
    At each iteration a new point that maximizes a criterion is chosen as
    optimizer candidate.
    The criterion uses a tradeoff between the metamodel value and the conditional
    variance.
    Then the new point is evaluated using the original model and the metamodel is
    relearnt on the extended design of experiment.

    Parameters
    ----------
    problem : :class:`~openturns.OptimizationProblem`
        The optimization problem to solve
    krigingResult : :class:`~openturns.KrigingResult`
        The result of the meta-model on the first design of experiment
    noise : :class:`~openturns.Function`
        Noise model used on design experiment points, and also for improvement optimization

    Notes
    -----
    Each point added to the metamodel design seeks to improve the current minimum.
    We chose the point so as to maximize an improvement criterion based on the
    metamodel.

    .. math::

        I(x_{new}) = max(f_{min} - Y_{new}, 0)

    The default criteria is called EI (Expected Improvement) and aims at maximizing
    the mean improvement:

    .. math::

        \mathbb{E}\left[I(x_{new})\right] = \mathbb{E}\left[max(f_{min} - Y_{new}, 0)\right]

    This criterion is explicited using the kriging mean and variance:

    .. math::

        \mathbb{E}\left[I(x_{new})\right] = (f_{min} - m_K(x_{new})) \Phi\left( \frac{f_{min} - m_K(x_{new})}{s_K(x_{new})} \right) + s_K(x_{new}) \phi\left( \frac{f_{min} - m_K(x_{new})}{s_K(x_{new})} \right)

    An optional observation noise variance can be provided:

    .. math:: Y_{obs} = Y(x) + \sigma_{\epsilon}(x) \epsilon

    In that case the AEI (Augmented Expected Improvement) formulation is used.
    As we don't have access to the real minimum of the function anymore a quantile
    of the kriging prediction is used, with the constant :math:`c`:

    .. math:: u(x) = m_K(x) + c s_K(x)

    This criterion is minimized over the design points:

    .. math:: x_{min} = \argmax_{x_i} (u(x_i))

    The AEI criterion reads:

    .. math::

        AEI(x_{new}) = \mathbb{E}\left[max(m_K(x_{min}) - Y_{new}, 0)\right] \times \left(1 - \frac{\sigma_{\epsilon}(x_{new})}{\sqrt{\sigma_{\epsilon}^2(x_{new})+s^2_K(x_{new})}} \right)

    with

    .. math::

        \mathbb{E}\left[max(m_K(x_{min}) - Y_{new}, 0)\right] = (m_K(x_{min}) - m_K(x_{new})) \Phi\left( \frac{m_K(x_{min}) - m_K(x_{new})}{s_K(x_{new})} \right) + s_K(x_{new}) \phi\left( \frac{m_K(x_{min}) - m_K(x_{new})}{s_K(x_{new})} \right)

    A less computationally expensive noise function can be provided through
    :func:`setNoiseModel()` to evaluate :math:`\sigma^2_{\epsilon}(x)`
    for the improvement criterion optimization, the objective being only used to
    compute values and associated noise at design points.

    By default the criteria is minimized using :class:`~openturns.MultiStart`
    with starting points uniformly sampled in the optimization problem bounds,
    see :func:`setMultiStartExperimentSize` and :func:`setMultiStartNumber`.
    This behavior can be overridden by using another solver with :func:`setOptimizationAlgorithm`.

    Examples
    --------
    >>> import openturns as ot
    >>> ot.RandomGenerator.SetSeed(0)
    >>> dim = 4
    >>> model = ot.SymbolicFunction(['x1', 'x2', 'x3', 'x4'],
    ...     ['x1*x1+x2^3*x1+x3+x4'])
    >>> model = ot.MemoizeFunction(model)
    >>> bounds = ot.Interval([-5.0] * dim, [5.0] * dim)
    >>> problem = ot.OptimizationProblem()
    >>> problem.setObjective(model)
    >>> problem.setBounds(bounds)
    >>> experiment = ot.Composite([0.0] * dim, [1.0, 2.0, 4.0])
    >>> inputSample = experiment.generate()
    >>> outputSample = model(inputSample)
    >>> print('Initial minimum output value: ', outputSample.getMin())
    Initial minimum output value:  [-248]
    >>> covarianceModel = ot.SquaredExponential([2.0] * dim, [0.1])
    >>> basis = ot.ConstantBasisFactory(dim).build()
    >>> kriging = ot.KrigingAlgorithm(inputSample, outputSample, covarianceModel, basis)
    >>> kriging.run()
    >>> algo = ot.EfficientGlobalOptimization(problem, kriging.getResult())
    >>> algo.setMaximumCallsNumber(2)
    >>> algo.run()
    >>> result = algo.getResult()
    >>> updatedKrigingResult = algo.getKrigingResult()
    >>> updatedOutputSample = updatedKrigingResult.getOutputSample()
    >>> yMin = updatedOutputSample.getMin()

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _uncertainty.EfficientGlobalOptimization_getClassName(self)

    def __repr__(self):
        return _uncertainty.EfficientGlobalOptimization___repr__(self)

    def run(self):
        r"""Launch the optimization."""
        return _uncertainty.EfficientGlobalOptimization_run(self)

    def setOptimizationAlgorithm(self, solver):
        r"""
        Expected improvement solver accessor.

        Parameters
        ----------
        solver : :class:`~openturns.OptimizationAlgorithm`
            The solver used to optimize the expected improvement
        """
        return _uncertainty.EfficientGlobalOptimization_setOptimizationAlgorithm(self, solver)

    def getOptimizationAlgorithm(self):
        r"""
        Expected improvement solver accessor.

        Returns
        -------
        solver : :class:`~openturns.OptimizationAlgorithm`
            The solver used to optimize the expected improvement
        """
        return _uncertainty.EfficientGlobalOptimization_getOptimizationAlgorithm(self)

    def getMultiStartExperimentSize(self):
        r"""
        Size of the design to draw starting points.

        Returns
        -------
        multiStartExperimentSize : int
            The size of the Monte Carlo design from which to select the best starting
            points.
        """
        return _uncertainty.EfficientGlobalOptimization_getMultiStartExperimentSize(self)

    def setMultiStartExperimentSize(self, multiStartExperimentSize):
        r"""
        Size of the design to draw starting points.

        Parameters
        ----------
        multiStartExperimentSize : int
            The size of the Monte Carlo design from which to select the best starting
            points.
            The default number can be tweaked with the
            `EfficientGlobalOptimization-DefaultMultiStartExperimentSize` key from
            :class:`~openturns.ResourceMap`.
        """
        return _uncertainty.EfficientGlobalOptimization_setMultiStartExperimentSize(self, multiStartExperimentSize)

    def getMultiStartNumber(self):
        r"""
        Number of starting points for the criterion optimization.

        Returns
        -------
        multiStartNumber : int
            The number of starting points for the criterion optimization.
        """
        return _uncertainty.EfficientGlobalOptimization_getMultiStartNumber(self)

    def setMultiStartNumber(self, multiStartNumberSize):
        r"""
        Number of starting points for the criterion optimization.

        Parameters
        ----------
        multiStartNumber : int
            The number of starting points for the criterion optimization.
            The default number can be tweaked with the
            `EfficientGlobalOptimization-DefaultMultiStartNumber` key from
            :class:`~openturns.ResourceMap`.
        """
        return _uncertainty.EfficientGlobalOptimization_setMultiStartNumber(self, multiStartNumberSize)

    def getParameterEstimationPeriod(self):
        r"""
        Parameter estimation period accessor.

        Returns
        -------
        period : int
            The number of iterations between covariance parameters re-learn.
            Default is 1 (each iteration). Can be set to 0 (never).
        """
        return _uncertainty.EfficientGlobalOptimization_getParameterEstimationPeriod(self)

    def setParameterEstimationPeriod(self, parameterEstimationPeriod):
        r"""
        Parameter estimation period accessor.

        Parameters
        ----------
        period : int
            The number of iterations between covariance parameters re-learn.
            Default is 1 (each iteration). Can be set to 0 (never).
            The default number can be tweaked with the
            `EfficientGlobalOptimization-DefaultParameterEstimationPeriod` key from
            :class:`~openturns.ResourceMap`.
        """
        return _uncertainty.EfficientGlobalOptimization_setParameterEstimationPeriod(self, parameterEstimationPeriod)

    def setImprovementFactor(self, improvementFactor):
        r"""
        Improvement criterion factor accessor.

        Parameters
        ----------
        alpha : positive float, default=0.0 (disables the criterion)
            Used to define a stopping criterion on the improvement criterion:
            :math:`I_{max} < \alpha |Y_{min}|`
            with :math:`I_{max}` the current maximum of the improvement
            and :math:`Y_{min}` the current optimum.
        """
        return _uncertainty.EfficientGlobalOptimization_setImprovementFactor(self, improvementFactor)

    def getImprovementFactor(self):
        r"""
        Improvement criterion factor accessor.

        Returns
        -------
        alpha : positive float, default=0.0 (disables the criterion)
            Used to define a stopping criterion on the improvement criterion:
            :math:`I_{max} < \alpha |Y_{min}|`
            with :math:`I_{max}` the current maximum of the improvement
            and :math:`Y_{min}` the current optimum.
        """
        return _uncertainty.EfficientGlobalOptimization_getImprovementFactor(self)

    def setCorrelationLengthFactor(self, b):
        r"""
        Correlation length stopping criterion factor accessor.

        When a correlation length becomes smaller than the minimal distance between
        design point for a single component that means the model tends to be noisy,
        and the EGO formulation is not adapted anymore.

        Parameters
        ----------
        b : float
            Used to define a stopping criterion on the minimum correlation length:
            :math:`\theta_i < \frac{\Delta_i^{min}}{b}`
            with :math:`\Delta^{min}` the minimum distance between design points.
        """
        return _uncertainty.EfficientGlobalOptimization_setCorrelationLengthFactor(self, b)

    def getCorrelationLengthFactor(self):
        r"""
        Correlation length stopping criterion factor accessor.

        When a correlation length becomes smaller than the minimal distance between
        design point for a single component that means the model tends to be noisy,
        and the EGO formulation is not adapted anymore.

        Returns
        -------
        b : float
            Used to define a stopping criterion on the minimum correlation length:
            :math:`\theta_i < \frac{\Delta_i^{min}}{b}`
            with :math:`\Delta^{min}` the minimum distance between design points.
        """
        return _uncertainty.EfficientGlobalOptimization_getCorrelationLengthFactor(self)

    def setAEITradeoff(self, c):
        r"""
        AEI tradeoff constant accessor.

        Parameters
        ----------
        c : float
            Used to define a quantile of the kriging prediction at the design points.
            :math:`u(x)=m_K(x)+c*s_K(x)`
        """
        return _uncertainty.EfficientGlobalOptimization_setAEITradeoff(self, c)

    def getAEITradeoff(self):
        r"""
        AEI tradeoff constant accessor.

        Returns
        -------
        c : float
            Used to define a quantile of the kriging prediction at the design points.
            :math:`u(x)=m_K(x)+c*s_K(x)`
        """
        return _uncertainty.EfficientGlobalOptimization_getAEITradeoff(self)

    def setMetamodelNoise(self, metaModelNoise):
        r"""
        Metamodel noise model accessor.

        Parameters
        ----------
        noiseModel : :class:`~openturns.Function`
            The noise variance function :math:`\sigma^2_{\epsilon}(x)` used for the AEI
            design update only.
            Of same input dimension as the objective and 1-d output.
        """
        return _uncertainty.EfficientGlobalOptimization_setMetamodelNoise(self, metaModelNoise)

    def getMetamodelNoise(self):
        r"""
        Metamodel noise model accessor.

        Returns
        -------
        noiseModel : :class:`~openturns.Function`
            The noise variance function :math:`\sigma^2_{\epsilon}(x)` used for the AEI
            design update only.
            Of same input dimension as the objective and 1-d output.
        """
        return _uncertainty.EfficientGlobalOptimization_getMetamodelNoise(self)

    def setNoiseModel(self, noiseModel):
        r"""
        Improvement noise model accessor.

        Parameters
        ----------
        noiseModel : :class:`~openturns.Function`
            The noise variance function :math:`\sigma^2_{\epsilon}(x)` used for the AEI
            criterion optimization only.
            Of same input dimension as the objective and 1-d output.
        """
        return _uncertainty.EfficientGlobalOptimization_setNoiseModel(self, noiseModel)

    def getNoiseModel(self):
        r"""
        Improvement noise model accessor.

        Returns
        -------
        noiseModel : :class:`~openturns.Function`
            The noise variance function :math:`\sigma^2_{\epsilon}(x)` used for the AEI
            criterion optimization only.
            Of same input dimension as the objective and 1-d output.
        """
        return _uncertainty.EfficientGlobalOptimization_getNoiseModel(self)

    def getExpectedImprovement(self):
        r"""
        Expected improvement values.

        Returns
        -------
        ei : :class:`~openturns.Sample`
            The expected improvement optimal values.
        """
        return _uncertainty.EfficientGlobalOptimization_getExpectedImprovement(self)

    def getKrigingResult(self):
        r"""
        Retrieve the Kriging result.

        Notes
        -----
        Before :meth:`run` is called, this method returns the
        :class:`~openturns.KrigingResult` passed to the constructor.
        Once :meth:`run` has been called, it returns an updated
        :class:`~openturns.KrigingResult` that takes new observations into account.

        Returns
        -------
        krigingResult : :class:`~openturns.KrigingResult`
            Kriging result that takes all observations into account.
        """
        return _uncertainty.EfficientGlobalOptimization_getKrigingResult(self)

    def __init__(self, *args):
        _uncertainty.EfficientGlobalOptimization_swiginit(self, _uncertainty.new_EfficientGlobalOptimization(*args))
    __swig_destroy__ = _uncertainty.delete_EfficientGlobalOptimization

# Register EfficientGlobalOptimization in _uncertainty:
_uncertainty.EfficientGlobalOptimization_swigregister(EfficientGlobalOptimization)
import openturns.transformation
import openturns.analytical
import openturns.simulation
import openturns.stattests
import openturns.model_process
import openturns.dist_bundle3
class HSICStatImplementation(openturns.common.PersistentObject):
    r"""
    Base class of HSICStat.

    Notes
    -----
    This is a base class for the implementation of an HSIC statistic
    but cannot be used by itself. An HSIC statistic object can be created by using the
    derived classes: :class:`~openturns.HSICUStat` and :class:`~openturns.HSICVStat`.

    See also
    --------
    :class:`~openturns.HSICUStat`, :class:`~openturns.HSICVStat`
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _uncertainty.HSICStatImplementation_getClassName(self)

    def __init__(self):
        _uncertainty.HSICStatImplementation_swiginit(self, _uncertainty.new_HSICStatImplementation())

    def computeHSICIndex(self, *args):
        r"""
        Compute the HSIC index between two samples.

        Parameters
        ----------

        covarianceMatrixX : :class:`~openturns.CovarianceMatrix`
            The xi-covariance model discretized over the input marginal sample xi.

        covarianceMatrixY : :class:`~openturns.CovarianceMatrix`
            The covariance model associated with the output sample, discretized
            over the last one.

        weights : :class:`~openturns.Point` or :class:`~openturns.Matrix` (deprecated)
            The weight argument used for the statistic.

        Returns
        -------
        hsicIndex : the HSIC index of the two :class:`~openturns.Sample`.


        """
        return _uncertainty.HSICStatImplementation_computeHSICIndex(self, *args)

    def computePValue(self, distribution, n, HSICObs, mHSIC):
        r"""
        Compute the p-value of the statistic.

        Parameters
        ----------
        dist : :class:`~openturns.Gamma`
            A :class:`~openturns.Gamma` distribution to compute the p-value.

        n : int
            The size of the samples.

        HSIC_obs : float
            The previously computed HSIC index.

        mHSIC : float
            Bias-correcting term (only actually used by U-statistics).

        Returns
        -------
        pvalue : the p-value of the statistic.
        """
        return _uncertainty.HSICStatImplementation_computePValue(self, distribution, n, HSICObs, mHSIC)

    def isCompatibleWithConditionalAnalysis(self):
        r"""
        Indicate the compatibility with a conditional HSIC estimator.

        Returns
        -------
        isCompatible : bool
            Indicate the compatibility with a conditional HSIC estimator.
        """
        return _uncertainty.HSICStatImplementation_isCompatibleWithConditionalAnalysis(self)
    __swig_destroy__ = _uncertainty.delete_HSICStatImplementation

# Register HSICStatImplementation in _uncertainty:
_uncertainty.HSICStatImplementation_swigregister(HSICStatImplementation)
class _HSICStatImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _uncertainty._HSICStatImplementationTypedInterfaceObject_swiginit(self, _uncertainty.new__HSICStatImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            A copy of the underlying implementation object.
        """
        return _uncertainty._HSICStatImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _uncertainty._HSICStatImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _uncertainty._HSICStatImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _uncertainty._HSICStatImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _uncertainty._HSICStatImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _uncertainty.delete__HSICStatImplementationTypedInterfaceObject

# Register _HSICStatImplementationTypedInterfaceObject in _uncertainty:
_uncertainty._HSICStatImplementationTypedInterfaceObject_swigregister(_HSICStatImplementationTypedInterfaceObject)
class HSICStat(_HSICStatImplementationTypedInterfaceObject):
    r"""
    Base class of HSICStat.

    Notes
    -----
    This is a base class for the implementation of an HSIC statistic
    but cannot be used by itself. An HSIC statistic object can be created by using the
    derived classes: :class:`~openturns.HSICUStat` and :class:`~openturns.HSICVStat`.

    See also
    --------
    :class:`~openturns.HSICUStat`, :class:`~openturns.HSICVStat`
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _uncertainty.HSICStat_getClassName(self)

    def computeHSICIndex(self, *args):
        r"""
        Compute the HSIC index between two samples.

        Parameters
        ----------

        covarianceMatrixX : :class:`~openturns.CovarianceMatrix`
            The xi-covariance model discretized over the input marginal sample xi.

        covarianceMatrixY : :class:`~openturns.CovarianceMatrix`
            The covariance model associated with the output sample, discretized
            over the last one.

        weights : :class:`~openturns.Point` or :class:`~openturns.Matrix` (deprecated)
            The weight argument used for the statistic.

        Returns
        -------
        hsicIndex : the HSIC index of the two :class:`~openturns.Sample`.


        """
        return _uncertainty.HSICStat_computeHSICIndex(self, *args)

    def computePValue(self, distribution, n, HSICObs, mHSIC):
        r"""
        Compute the p-value of the statistic.

        Parameters
        ----------
        dist : :class:`~openturns.Gamma`
            A :class:`~openturns.Gamma` distribution to compute the p-value.

        n : int
            The size of the samples.

        HSIC_obs : float
            The previously computed HSIC index.

        mHSIC : float
            Bias-correcting term (only actually used by U-statistics).

        Returns
        -------
        pvalue : the p-value of the statistic.
        """
        return _uncertainty.HSICStat_computePValue(self, distribution, n, HSICObs, mHSIC)

    def isCompatibleWithConditionalAnalysis(self):
        r"""
        Indicate the compatibility with a conditional HSIC estimator.

        Returns
        -------
        isCompatible : bool
            Indicate the compatibility with a conditional HSIC estimator.
        """
        return _uncertainty.HSICStat_isCompatibleWithConditionalAnalysis(self)

    def __init__(self, *args):
        _uncertainty.HSICStat_swiginit(self, _uncertainty.new_HSICStat(*args))
    __swig_destroy__ = _uncertainty.delete_HSICStat

# Register HSICStat in _uncertainty:
_uncertainty.HSICStat_swigregister(HSICStat)
class HSICUStat(HSICStatImplementation):
    r"""
    Unbiased HSIC statistics.

    Notes
    -----
    This an unbiased estimator for the computation of an HSIC index.

    See also
    --------
    :class:`~openturns.HSICVStat`
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _uncertainty.HSICUStat_getClassName(self)

    def computeHSICIndex(self, CovMat1, CovMat2, weights):
        r"""
        Compute the HSIC index between two samples.

        Parameters
        ----------

        covarianceMatrixX : :class:`~openturns.CovarianceMatrix`
            The xi-covariance model discretized over the input marginal sample xi.

        covarianceMatrixY : :class:`~openturns.CovarianceMatrix`
            The covariance model associated with the output sample, discretized
            over the last one.

        weights : :class:`~openturns.Point` or :class:`~openturns.Matrix` (deprecated)
            The weight argument used for the statistic.

        Returns
        -------
        hsicIndex : the HSIC index of the two :class:`~openturns.Sample`.


        """
        return _uncertainty.HSICUStat_computeHSICIndex(self, CovMat1, CovMat2, weights)

    def computePValue(self, dist, n, HSIC_obs, mHSIC):
        r"""
        Compute the p-value of the statistic.

        Parameters
        ----------
        dist : :class:`~openturns.Gamma`
            A :class:`~openturns.Gamma` distribution to compute the p-value.

        n : int
            The size of the samples.

        HSIC_obs : float
            The previously computed HSIC index.

        mHSIC : float
            Bias-correcting term (only actually used by U-statistics).

        Returns
        -------
        pvalue : the p-value of the statistic.
        """
        return _uncertainty.HSICUStat_computePValue(self, dist, n, HSIC_obs, mHSIC)

    def isCompatibleWithConditionalAnalysis(self):
        r"""
        Indicate the compatibility with a conditional HSIC estimator.

        Returns
        -------
        isCompatible : bool
            Indicate the compatibility with a conditional HSIC estimator (false).
        """
        return _uncertainty.HSICUStat_isCompatibleWithConditionalAnalysis(self)

    def __init__(self, *args):
        _uncertainty.HSICUStat_swiginit(self, _uncertainty.new_HSICUStat(*args))
    __swig_destroy__ = _uncertainty.delete_HSICUStat

# Register HSICUStat in _uncertainty:
_uncertainty.HSICUStat_swigregister(HSICUStat)
class HSICVStat(HSICStatImplementation):
    r"""
    Biased HSIC statistics.

    Notes
    -----
    This a biased estimator for the computation of an HSIC index.

    See also
    --------
    :class:`~openturns.HSICUStat`
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _uncertainty.HSICVStat_getClassName(self)

    def computeHSICIndex(self, CovMat1, CovMat2, weights):
        r"""
        Compute the HSIC index between two samples.

        Parameters
        ----------

        covarianceMatrixX : :class:`~openturns.CovarianceMatrix`
            The xi-covariance model discretized over the input marginal sample xi.

        covarianceMatrixY : :class:`~openturns.CovarianceMatrix`
            The covariance model associated with the output sample, discretized
            over the last one.

        weights : :class:`~openturns.Point` or :class:`~openturns.Matrix` (deprecated)
            The weight argument used for the statistic.

        Returns
        -------
        hsicIndex : the HSIC index of the two :class:`~openturns.Sample`.


        """
        return _uncertainty.HSICVStat_computeHSICIndex(self, CovMat1, CovMat2, weights)

    def computePValue(self, distribution, n, HSICObs, mHSIC):
        r"""
        Compute the p-value of the statistic.

        Parameters
        ----------
        dist : :class:`~openturns.Gamma`
            A :class:`~openturns.Gamma` distribution to compute the p-value.

        n : int
            The size of the samples.

        HSIC_obs : float
            The previously computed HSIC index.

        mHSIC : float
            Bias-correcting term (only actually used by U-statistics).

        Returns
        -------
        pvalue : the p-value of the statistic.
        """
        return _uncertainty.HSICVStat_computePValue(self, distribution, n, HSICObs, mHSIC)

    def isCompatibleWithConditionalAnalysis(self):
        r"""
        Indicate the compatibility with a conditional HSIC estimator.

        Returns
        -------
        isCompatible : bool
            Indicate the compatibility with a conditional HSIC estimator (true).
        """
        return _uncertainty.HSICVStat_isCompatibleWithConditionalAnalysis(self)

    def __init__(self, *args):
        _uncertainty.HSICVStat_swiginit(self, _uncertainty.new_HSICVStat(*args))
    __swig_destroy__ = _uncertainty.delete_HSICVStat

# Register HSICVStat in _uncertainty:
_uncertainty.HSICVStat_swigregister(HSICVStat)
class HSICEstimatorImplementation(openturns.common.PersistentObject):
    r"""
    Base class of HSIC estimators.

    Notes
    -----
    HSIC-based analyses must be performed by using the derived classes: :class:`~openturns.HSICEstimatorConditionalSensitivity`, :class:`~openturns.HSICEstimatorGlobalSensitivity` and :class:`~openturns.HSICEstimatorTargetSensitivity`.

    The :class:`~openturns.ResourceMap` key `HSICEstimator-InputCovarianceMatrixCacheSizeMb`
    allows one to limit the total size (in mega bytes) of the input matrix cached.

    See also
    --------
    :class:`~openturns.HSICEstimatorConditionalSensitivity`, :class:`~openturns.HSICEstimatorGlobalSensitivity`, :class:`~openturns.HSICEstimatorTargetSensitivity`
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _uncertainty.HSICEstimatorImplementation_getClassName(self)

    def __init__(self, *args):
        _uncertainty.HSICEstimatorImplementation_swiginit(self, _uncertainty.new_HSICEstimatorImplementation(*args))

    def setPermutationSize(self, B):
        r"""
        Set the number of permutations to be used for p-value estimate.

        Parameters
        ----------
        B : int
            The number of permutation used for p-value estimates.
        """
        return _uncertainty.HSICEstimatorImplementation_setPermutationSize(self, B)

    def getPermutationSize(self):
        r"""
        Get the number of permutations.

        Returns
        -------
        permutationSize : int
            The number of permutations.
        """
        return _uncertainty.HSICEstimatorImplementation_getPermutationSize(self)

    def getCovarianceModelCollection(self):
        r"""
        Get the list of all covariance models used.

        Returns
        -------
        coll : CovarianceModelCollection
            The list of all covariance models used. The last one is the output covariance model.
        """
        return _uncertainty.HSICEstimatorImplementation_getCovarianceModelCollection(self)

    def setCovarianceModelCollection(self, coll):
        r"""
        Set the covariance models.

        Parameters
        ----------
        coll : CovarianceModelCollection
            The list of all covariance models.
        """
        return _uncertainty.HSICEstimatorImplementation_setCovarianceModelCollection(self, coll)

    def getInputSample(self):
        r"""
        Get the input sample.

        Returns
        -------
        inSample : :class:`~openturns.Sample`
            The input sample used for analysis.
        """
        return _uncertainty.HSICEstimatorImplementation_getInputSample(self)

    def setInputSample(self, inputSample):
        r"""
        Set the input sample.

        Parameters
        ----------
        inputSample : 2-d sequence of float
            The input sample to be used.
        """
        return _uncertainty.HSICEstimatorImplementation_setInputSample(self, inputSample)

    def getOutputSample(self):
        r"""
        Get the output sample.

        Returns
        -------
        outSample : :class:`~openturns.Sample`
            The output sample used for analysis.
        """
        return _uncertainty.HSICEstimatorImplementation_getOutputSample(self)

    def setOutputSample(self, outputSample):
        r"""
        Set the output sample.

        Parameters
        ----------
        outputSample : 2-d sequence of float
            The output sample to be used.
        """
        return _uncertainty.HSICEstimatorImplementation_setOutputSample(self, outputSample)

    def getDimension(self):
        r"""
        Get the dimension of the input sample.

        Returns
        -------
        dim : int
            The dimension of the input sample.
        """
        return _uncertainty.HSICEstimatorImplementation_getDimension(self)

    def getSize(self):
        r"""
        Get the size of the input sample.

        Returns
        -------
        size : int
            The size of the input sample.
        """
        return _uncertainty.HSICEstimatorImplementation_getSize(self)

    def getEstimator(self):
        r"""
        Get the estimator used for computations.

        Returns
        -------
        estimator : :class:`~openturns.HSICStat`
            The estimator used for internal computations.
        """
        return _uncertainty.HSICEstimatorImplementation_getEstimator(self)

    def getHSICIndices(self):
        r"""
        Get the HSIC indices.

        Returns
        -------
        hsicIndices : :class:`~openturns.Point`
            The HSIC indices of all components.
        """
        return _uncertainty.HSICEstimatorImplementation_getHSICIndices(self)

    def getR2HSICIndices(self):
        r"""
        Get the R2-HSIC indices.

        Returns
        -------
        r2hsicIndices : :class:`~openturns.Point`
            The R2-HSIC indices of all components.
        """
        return _uncertainty.HSICEstimatorImplementation_getR2HSICIndices(self)

    def getPValuesPermutation(self):
        r"""
        Get the p-value estimated through permutations.

        Returns
        -------
        pval : :class:`~openturns.Point`
            The p-values of all components estimated with permutations of the data.
        """
        return _uncertainty.HSICEstimatorImplementation_getPValuesPermutation(self)

    def getPValuesAsymptotic(self):
        r"""
        Get the p-values obtained with an asymptotic formula.

        Returns
        -------
        pval : sequence of float
            The p-values for all components.
        """
        return _uncertainty.HSICEstimatorImplementation_getPValuesAsymptotic(self)

    def run(self):
        r"""Compute all values at once."""
        return _uncertainty.HSICEstimatorImplementation_run(self)

    def drawHSICIndices(self):
        r"""
        Draw the HSIC indices.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            The graph of all HSIC indices according to components.
        """
        return _uncertainty.HSICEstimatorImplementation_drawHSICIndices(self)

    def drawR2HSICIndices(self):
        r"""
        Draw the R2-HSIC indices.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            The graph of all R2-HSIC indices according to components.
        """
        return _uncertainty.HSICEstimatorImplementation_drawR2HSICIndices(self)

    def drawPValuesPermutation(self):
        r"""
        Draw the p-values obtained by permutation.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            The graph of all p-values by permutation according to components.
        """
        return _uncertainty.HSICEstimatorImplementation_drawPValuesPermutation(self)

    def drawPValuesAsymptotic(self):
        r"""
        Draw the p-values obtained with an asymptotic formula.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            The graph of all p-values estimated with an asymptotic formula.
        """
        return _uncertainty.HSICEstimatorImplementation_drawPValuesAsymptotic(self)
    __swig_destroy__ = _uncertainty.delete_HSICEstimatorImplementation

# Register HSICEstimatorImplementation in _uncertainty:
_uncertainty.HSICEstimatorImplementation_swigregister(HSICEstimatorImplementation)
class _HSICEstimatorImplementationTypedInterfaceObject(openturns.common.InterfaceObject):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _uncertainty._HSICEstimatorImplementationTypedInterfaceObject_swiginit(self, _uncertainty.new__HSICEstimatorImplementationTypedInterfaceObject(*args))

    def getImplementation(self):
        r"""
        Accessor to the underlying implementation.

        Returns
        -------
        impl : Implementation
            A copy of the underlying implementation object.
        """
        return _uncertainty._HSICEstimatorImplementationTypedInterfaceObject_getImplementation(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _uncertainty._HSICEstimatorImplementationTypedInterfaceObject_setName(self, name)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _uncertainty._HSICEstimatorImplementationTypedInterfaceObject_getName(self)

    def __eq__(self, other):
        return _uncertainty._HSICEstimatorImplementationTypedInterfaceObject___eq__(self, other)

    def __ne__(self, other):
        return _uncertainty._HSICEstimatorImplementationTypedInterfaceObject___ne__(self, other)
    __swig_destroy__ = _uncertainty.delete__HSICEstimatorImplementationTypedInterfaceObject

# Register _HSICEstimatorImplementationTypedInterfaceObject in _uncertainty:
_uncertainty._HSICEstimatorImplementationTypedInterfaceObject_swigregister(_HSICEstimatorImplementationTypedInterfaceObject)
class HSICEstimator(_HSICEstimatorImplementationTypedInterfaceObject):
    r"""
    Base class of HSIC estimators.

    Notes
    -----
    HSIC-based analyses must be performed by using the derived classes: :class:`~openturns.HSICEstimatorConditionalSensitivity`, :class:`~openturns.HSICEstimatorGlobalSensitivity` and :class:`~openturns.HSICEstimatorTargetSensitivity`.

    The :class:`~openturns.ResourceMap` key `HSICEstimator-InputCovarianceMatrixCacheSizeMb`
    allows one to limit the total size (in mega bytes) of the input matrix cached.

    See also
    --------
    :class:`~openturns.HSICEstimatorConditionalSensitivity`, :class:`~openturns.HSICEstimatorGlobalSensitivity`, :class:`~openturns.HSICEstimatorTargetSensitivity`
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _uncertainty.HSICEstimator_getClassName(self)

    def __init__(self, *args):
        _uncertainty.HSICEstimator_swiginit(self, _uncertainty.new_HSICEstimator(*args))

    def getHSICIndices(self):
        r"""
        Get the HSIC indices.

        Returns
        -------
        hsicIndices : :class:`~openturns.Point`
            The HSIC indices of all components.
        """
        return _uncertainty.HSICEstimator_getHSICIndices(self)

    def getR2HSICIndices(self):
        r"""
        Get the R2-HSIC indices.

        Returns
        -------
        r2hsicIndices : :class:`~openturns.Point`
            The R2-HSIC indices of all components.
        """
        return _uncertainty.HSICEstimator_getR2HSICIndices(self)

    def getPValuesPermutation(self):
        r"""
        Get the p-value estimated through permutations.

        Returns
        -------
        pval : :class:`~openturns.Point`
            The p-values of all components estimated with permutations of the data.
        """
        return _uncertainty.HSICEstimator_getPValuesPermutation(self)

    def getPValuesAsymptotic(self):
        r"""
        Get the p-values obtained with an asymptotic formula.

        Returns
        -------
        pval : sequence of float
            The p-values for all components.
        """
        return _uncertainty.HSICEstimator_getPValuesAsymptotic(self)

    def drawHSICIndices(self):
        r"""
        Draw the HSIC indices.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            The graph of all HSIC indices according to components.
        """
        return _uncertainty.HSICEstimator_drawHSICIndices(self)

    def drawR2HSICIndices(self):
        r"""
        Draw the R2-HSIC indices.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            The graph of all R2-HSIC indices according to components.
        """
        return _uncertainty.HSICEstimator_drawR2HSICIndices(self)

    def drawPValuesPermutation(self):
        r"""
        Draw the p-values obtained by permutation.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            The graph of all p-values by permutation according to components.
        """
        return _uncertainty.HSICEstimator_drawPValuesPermutation(self)

    def drawPValuesAsymptotic(self):
        r"""
        Draw the p-values obtained with an asymptotic formula.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            The graph of all p-values estimated with an asymptotic formula.
        """
        return _uncertainty.HSICEstimator_drawPValuesAsymptotic(self)

    def run(self):
        r"""Compute all values at once."""
        return _uncertainty.HSICEstimator_run(self)

    def setPermutationSize(self, B):
        r"""
        Set the number of permutations to be used for p-value estimate.

        Parameters
        ----------
        B : int
            The number of permutation used for p-value estimates.
        """
        return _uncertainty.HSICEstimator_setPermutationSize(self, B)

    def getPermutationSize(self):
        r"""
        Get the number of permutations.

        Returns
        -------
        permutationSize : int
            The number of permutations.
        """
        return _uncertainty.HSICEstimator_getPermutationSize(self)

    def getCovarianceModelCollection(self):
        r"""
        Get the list of all covariance models used.

        Returns
        -------
        coll : CovarianceModelCollection
            The list of all covariance models used. The last one is the output covariance model.
        """
        return _uncertainty.HSICEstimator_getCovarianceModelCollection(self)

    def setCovarianceModelCollection(self, coll):
        r"""
        Set the covariance models.

        Parameters
        ----------
        coll : CovarianceModelCollection
            The list of all covariance models.
        """
        return _uncertainty.HSICEstimator_setCovarianceModelCollection(self, coll)

    def getInputSample(self):
        r"""
        Get the input sample.

        Returns
        -------
        inSample : :class:`~openturns.Sample`
            The input sample used for analysis.
        """
        return _uncertainty.HSICEstimator_getInputSample(self)

    def setInputSample(self, inputSample):
        r"""
        Set the input sample.

        Parameters
        ----------
        inputSample : 2-d sequence of float
            The input sample to be used.
        """
        return _uncertainty.HSICEstimator_setInputSample(self, inputSample)

    def getOutputSample(self):
        r"""
        Get the output sample.

        Returns
        -------
        outSample : :class:`~openturns.Sample`
            The output sample used for analysis.
        """
        return _uncertainty.HSICEstimator_getOutputSample(self)

    def setOutputSample(self, outputSample):
        r"""
        Set the output sample.

        Parameters
        ----------
        outputSample : 2-d sequence of float
            The output sample to be used.
        """
        return _uncertainty.HSICEstimator_setOutputSample(self, outputSample)

    def getDimension(self):
        r"""
        Get the dimension of the input sample.

        Returns
        -------
        dim : int
            The dimension of the input sample.
        """
        return _uncertainty.HSICEstimator_getDimension(self)

    def getSize(self):
        r"""
        Get the size of the input sample.

        Returns
        -------
        size : int
            The size of the input sample.
        """
        return _uncertainty.HSICEstimator_getSize(self)

    def getEstimator(self):
        r"""
        Get the estimator used for computations.

        Returns
        -------
        estimator : :class:`~openturns.HSICStat`
            The estimator used for internal computations.
        """
        return _uncertainty.HSICEstimator_getEstimator(self)
    __swig_destroy__ = _uncertainty.delete_HSICEstimator

# Register HSICEstimator in _uncertainty:
_uncertainty.HSICEstimator_swigregister(HSICEstimator)
class HSICEstimatorConditionalSensitivity(HSICEstimatorImplementation):
    r"""
    Implement a HSIC estimator for conditional analysis.

    Parameters
    ----------
    covarianceModelCollection : list of :class:`~openturns.CovarianceModel`
        List of all covariance kernels. The :math:`d` first kernels are linked to the input 
        and the last one is for the output.

    X : 2-d sequence of float
        The input sample used for the HSIC analysis of dimension :math:`d`.

    Y : 2-d sequence of float
        The output sample used for the HSIC analysis of dimension 1.

    weightFunction : :class:`~openturns.Function`
        A weight function used for the inputs.

    See also
    --------
    :class:`~openturns.HSICEstimatorGlobalSensitivity`, :class:`~openturns.HSICEstimatorTargetSensitivity`

    Notes
    -----
    Conditional sensitivity analysis relies on the :class:`~openturns.HSICVStat` estimator. Also it does not provides an
    asymptotic estimate of the p-values thus the generic methods `getPValuesAsymptotic` and `drawPValuesAsymptotic`
    throws an exception in that case.

    Examples
    --------
    >>> import openturns as ot
    >>> from math import pi
    >>> ot.RandomGenerator.SetSeed(0)

    Generate input and output samples.

    >>> # 3d input distribution with an independent copula
    >>> distX = ot.JointDistribution([ot.Uniform(-pi, pi)] * 3)
    >>> X = distX.getSample(100) # get a sample
    >>>
    >>> # Apply the Ishigami model.
    >>> inputs = ['X1', 'X2', 'X3']
    >>> formula = ['sin(X1) + 5.0 * (sin(X2))^2 + 0.1 * X3^4 * sin(X1)']
    >>> modelIshigami = ot.SymbolicFunction(inputs, formula)
    >>> Y = modelIshigami(X) # Y = modelIshigami(X)

    Define covariance kernels for the model inputs.
    Put them in a list.

    >>> covarianceModelCollection = []
    >>> for i in range(3):
    ...     Xi = X.getMarginal(i)
    ...     Cov = ot.SquaredExponential(1)
    ...     Cov.setScale(Xi.computeStandardDeviation())
    ...     covarianceModelCollection.append(Cov)

    Append the list with the covariance kernel for the model output.

    >>> covarianceModelCollection.append(ot.SquaredExponential(Y.computeStandardDeviation()))

    To perform sensititivity analysis under the condition that the output belongs or is near a domain,
    define a weight function based on the distance to this domain.

    >>> dist = ot.DistanceToDomainFunction(ot.Interval(5, float('inf')))
    >>> func = ot.SymbolicFunction('x', 'exp(-0.5 * x)')
    >>> weight = ot.ComposedFunction(func, dist)

    Build and use the HSIC estimator for conditional sensitivity analysis.

    >>> hsic = ot.HSICEstimatorConditionalSensitivity(covarianceModelCollection, X, Y, weight)
    >>> print(hsic.getR2HSICIndices())
    [0.23014,0.0158769,0.107919]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _uncertainty.HSICEstimatorConditionalSensitivity_getClassName(self)

    def __init__(self, *args):
        _uncertainty.HSICEstimatorConditionalSensitivity_swiginit(self, _uncertainty.new_HSICEstimatorConditionalSensitivity(*args))

    def getWeightFunction(self):
        r"""
        Get the weight function used.

        Returns
        -------
        weightFunction : :class:`~openturns.Function`
            The weight function used for the conditional estimator.
        """
        return _uncertainty.HSICEstimatorConditionalSensitivity_getWeightFunction(self)

    def setWeightFunction(self, weightFunction):
        r"""
        Set the weight function.

        Parameters
        ----------
        weightFunction : :class:`~openturns.Function`
            The weight function used for the conditional estimator.
        """
        return _uncertainty.HSICEstimatorConditionalSensitivity_setWeightFunction(self, weightFunction)
    __swig_destroy__ = _uncertainty.delete_HSICEstimatorConditionalSensitivity

# Register HSICEstimatorConditionalSensitivity in _uncertainty:
_uncertainty.HSICEstimatorConditionalSensitivity_swigregister(HSICEstimatorConditionalSensitivity)
class HSICEstimatorGlobalSensitivity(HSICEstimatorImplementation):
    r"""
    Implement a HSIC estimator for global analysis.

    Parameters
    ----------
    covarianceModelCollection : list of :class:`~openturns.CovarianceModel`
        List of all covariance kernels. The :math:`d` first kernels are linked to the input 
        and the last one is for the output.

    X : 2-d sequence of float
        The input sample used for the HSIC analysis of dimension :math:`d`.

    Y : 2-d sequence of float
        The output sample used for the HSIC analysis of dimension 1.

    estimatorType : :class:`~openturns.HSICStat`
        An estimator for internal computations.

    See also
    --------
    :class:`~openturns.HSICEstimatorConditionalSensitivity`, :class:`~openturns.HSICEstimatorTargetSensitivity`

    Examples
    --------
    >>> import openturns as ot
    >>> from math import pi
    >>> ot.RandomGenerator.SetSeed(0)

    Generate input and output samples.

    >>> # 3d input distribution with an independent copula
    >>> distX = ot.JointDistribution([ot.Uniform(-pi, pi)] * 3)
    >>> X = distX.getSample(100) # get a sample
    >>>
    >>> # Apply the Ishigami model.
    >>> inputs = ['X1', 'X2', 'X3']
    >>> formula = ['sin(X1) + 5.0 * (sin(X2))^2 + 0.1 * X3^4 * sin(X1)']
    >>> modelIshigami = ot.SymbolicFunction(inputs, formula)
    >>> Y = modelIshigami(X) # Y = modelIshigami(X)

    Define covariance kernels for the model inputs.
    Put them in a list.

    >>> covarianceModelCollection = []
    >>> for i in range(3):
    ...     Xi = X.getMarginal(i)
    ...     Cov = ot.SquaredExponential(1)
    ...     Cov.setScale(Xi.computeStandardDeviation())
    ...     covarianceModelCollection.append(Cov)

    Append the list with the covariance kernel for the model output.

    >>> covarianceModelCollection.append(ot.SquaredExponential(Y.computeStandardDeviation()))

    Choose the statistic that will be used to estimate the HSIC indices.

    >>> estimatorType = ot.HSICUStat() # could be HSICVStat instead

    Build and use the HSIC estimator for global sensitivity analysis.

    >>> hsic = ot.HSICEstimatorGlobalSensitivity(covarianceModelCollection, X, Y, estimatorType)
    >>> print(hsic.getR2HSICIndices())
    [0.298073,0.00344498,0.0772657]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _uncertainty.HSICEstimatorGlobalSensitivity_getClassName(self)

    def __init__(self, *args):
        _uncertainty.HSICEstimatorGlobalSensitivity_swiginit(self, _uncertainty.new_HSICEstimatorGlobalSensitivity(*args))
    __swig_destroy__ = _uncertainty.delete_HSICEstimatorGlobalSensitivity

# Register HSICEstimatorGlobalSensitivity in _uncertainty:
_uncertainty.HSICEstimatorGlobalSensitivity_swigregister(HSICEstimatorGlobalSensitivity)
class HSICEstimatorTargetSensitivity(HSICEstimatorImplementation):
    r"""
    Implement a HSIC estimator for target analysis.

    Parameters
    ----------
    covarianceModelCollection : list of :class:`~openturns.CovarianceModel`
        List of all covariance kernels. The :math:`d` first kernels are linked to the input 
        and the last one is for the output.

    X : 2-d sequence of float
        The input sample used for the HSIC analysis of dimension :math:`d`.

    Y : 2-d sequence of float
        The output sample used for the HSIC analysis of dimension 1.

    estimatorType : :class:`~openturns.HSICStat`
        An estimator for internal computations.

    filterFunction : :class:`~openturns.Function`
        A filter function used for the output.

    See also
    --------
    :class:`~openturns.HSICEstimatorConditionalSensitivity`, :class:`~openturns.HSICEstimatorGlobalSensitivity`

    Examples
    --------
    >>> import openturns as ot
    >>> from math import pi
    >>> ot.RandomGenerator.SetSeed(0)

    Generate input and output samples.

    >>> # 3d input distribution with an independent copula
    >>> distX = ot.JointDistribution([ot.Uniform(-pi, pi)] * 3)
    >>> X = distX.getSample(100) # get a sample
    >>>
    >>> # Apply the Ishigami model.
    >>> inputs = ['X1', 'X2', 'X3']
    >>> formula = ['sin(X1) + 5.0 * (sin(X2))^2 + 0.1 * X3^4 * sin(X1)']
    >>> modelIshigami = ot.SymbolicFunction(inputs, formula)
    >>> Y = modelIshigami(X) # Y = modelIshigami(X)

    Define covariance kernels for the model inputs.
    Put them in a list.

    >>> covarianceModelCollection = []
    >>> for i in range(3):
    ...     Xi = X.getMarginal(i)
    ...     Cov = ot.SquaredExponential(1)
    ...     Cov.setScale(Xi.computeStandardDeviation())
    ...     covarianceModelCollection.append(Cov)

    Append the list with the covariance kernel for the model output.

    >>> covarianceModelCollection.append(ot.SquaredExponential(Y.computeStandardDeviation()))

    Choose the statistic that will be used to estimate the HSIC indices.

    >>> estimatorType = ot.HSICUStat() # could be HSICVStat instead

    Define a filter function to apply to the model output.

    >>> filter = ot.IndicatorFunction(ot.Interval(5, float('inf')))

    Build and use the HSIC estimator for target sensitivity analysis.

    >>> hsic = ot.HSICEstimatorTargetSensitivity(covarianceModelCollection, X, Y, estimatorType, filter)
    >>> print(hsic.getR2HSICIndices())
    [0.238014,0.00167123,0.000377241]
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _uncertainty.HSICEstimatorTargetSensitivity_getClassName(self)

    def __init__(self, *args):
        _uncertainty.HSICEstimatorTargetSensitivity_swiginit(self, _uncertainty.new_HSICEstimatorTargetSensitivity(*args))

    def getFilterFunction(self):
        r"""
        Get the filter function used.

        Returns
        -------
        filterFunction : :class:`~openturns.Function`
            The filter function used for the target estimator.
        """
        return _uncertainty.HSICEstimatorTargetSensitivity_getFilterFunction(self)

    def setFilterFunction(self, filterFunction):
        r"""
        Set the filter function.

        Parameters
        ----------
        filterFunction : :class:`~openturns.Function`
            The filter function used for the target estimator.
        """
        return _uncertainty.HSICEstimatorTargetSensitivity_setFilterFunction(self, filterFunction)
    __swig_destroy__ = _uncertainty.delete_HSICEstimatorTargetSensitivity

# Register HSICEstimatorTargetSensitivity in _uncertainty:
_uncertainty.HSICEstimatorTargetSensitivity_swigregister(HSICEstimatorTargetSensitivity)
class _HSICStatImplementationPointer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    ptr_ = property(_uncertainty._HSICStatImplementationPointer_ptr__get, _uncertainty._HSICStatImplementationPointer_ptr__set)

    def __init__(self, *args):
        _uncertainty._HSICStatImplementationPointer_swiginit(self, _uncertainty.new__HSICStatImplementationPointer(*args))
    __swig_destroy__ = _uncertainty.delete__HSICStatImplementationPointer

    def reset(self):
        return _uncertainty._HSICStatImplementationPointer_reset(self)

    def __ref__(self, *args):
        return _uncertainty._HSICStatImplementationPointer___ref__(self, *args)

    def __deref__(self, *args):
        return _uncertainty._HSICStatImplementationPointer___deref__(self, *args)

    def isNull(self):
        return _uncertainty._HSICStatImplementationPointer_isNull(self)

    def __nonzero__(self):
        return _uncertainty._HSICStatImplementationPointer___nonzero__(self)
    __bool__ = __nonzero__



    def get(self):
        return _uncertainty._HSICStatImplementationPointer_get(self)

    def getImplementation(self):
        return _uncertainty._HSICStatImplementationPointer_getImplementation(self)

    def unique(self):
        return _uncertainty._HSICStatImplementationPointer_unique(self)

    def use_count(self):
        return _uncertainty._HSICStatImplementationPointer_use_count(self)

    def swap(self, other):
        return _uncertainty._HSICStatImplementationPointer_swap(self, other)

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _uncertainty._HSICStatImplementationPointer_getClassName(self)

    def computeHSICIndex(self, *args):
        r"""
        Compute the HSIC index between two samples.

        Parameters
        ----------

        covarianceMatrixX : :class:`~openturns.CovarianceMatrix`
            The xi-covariance model discretized over the input marginal sample xi.

        covarianceMatrixY : :class:`~openturns.CovarianceMatrix`
            The covariance model associated with the output sample, discretized
            over the last one.

        weights : :class:`~openturns.Point` or :class:`~openturns.Matrix` (deprecated)
            The weight argument used for the statistic.

        Returns
        -------
        hsicIndex : the HSIC index of the two :class:`~openturns.Sample`.


        """
        return _uncertainty._HSICStatImplementationPointer_computeHSICIndex(self, *args)

    def computePValue(self, distribution, n, HSICObs, mHSIC):
        r"""
        Compute the p-value of the statistic.

        Parameters
        ----------
        dist : :class:`~openturns.Gamma`
            A :class:`~openturns.Gamma` distribution to compute the p-value.

        n : int
            The size of the samples.

        HSIC_obs : float
            The previously computed HSIC index.

        mHSIC : float
            Bias-correcting term (only actually used by U-statistics).

        Returns
        -------
        pvalue : the p-value of the statistic.
        """
        return _uncertainty._HSICStatImplementationPointer_computePValue(self, distribution, n, HSICObs, mHSIC)

    def isCompatibleWithConditionalAnalysis(self):
        r"""
        Indicate the compatibility with a conditional HSIC estimator.

        Returns
        -------
        isCompatible : bool
            Indicate the compatibility with a conditional HSIC estimator.
        """
        return _uncertainty._HSICStatImplementationPointer_isCompatibleWithConditionalAnalysis(self)

    def __eq__(self, other):
        return _uncertainty._HSICStatImplementationPointer___eq__(self, other)

    def __ne__(self, other):
        return _uncertainty._HSICStatImplementationPointer___ne__(self, other)

    def __repr__(self):
        return _uncertainty._HSICStatImplementationPointer___repr__(self)

    def __str__(self, *args):
        return _uncertainty._HSICStatImplementationPointer___str__(self, *args)

    def __repr_markdown__(self):
        return _uncertainty._HSICStatImplementationPointer___repr_markdown__(self)

    def _repr_html_(self):
        return _uncertainty._HSICStatImplementationPointer__repr_html_(self)

    def hasName(self):
        r"""
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _uncertainty._HSICStatImplementationPointer_hasName(self)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _uncertainty._HSICStatImplementationPointer_getName(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _uncertainty._HSICStatImplementationPointer_setName(self, name)

# Register _HSICStatImplementationPointer in _uncertainty:
_uncertainty._HSICStatImplementationPointer_swigregister(_HSICStatImplementationPointer)
class _HSICEstimatorImplementationPointer(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    ptr_ = property(_uncertainty._HSICEstimatorImplementationPointer_ptr__get, _uncertainty._HSICEstimatorImplementationPointer_ptr__set)

    def __init__(self, *args):
        _uncertainty._HSICEstimatorImplementationPointer_swiginit(self, _uncertainty.new__HSICEstimatorImplementationPointer(*args))
    __swig_destroy__ = _uncertainty.delete__HSICEstimatorImplementationPointer

    def reset(self):
        return _uncertainty._HSICEstimatorImplementationPointer_reset(self)

    def __ref__(self, *args):
        return _uncertainty._HSICEstimatorImplementationPointer___ref__(self, *args)

    def __deref__(self, *args):
        return _uncertainty._HSICEstimatorImplementationPointer___deref__(self, *args)

    def isNull(self):
        return _uncertainty._HSICEstimatorImplementationPointer_isNull(self)

    def __nonzero__(self):
        return _uncertainty._HSICEstimatorImplementationPointer___nonzero__(self)
    __bool__ = __nonzero__



    def get(self):
        return _uncertainty._HSICEstimatorImplementationPointer_get(self)

    def getImplementation(self):
        return _uncertainty._HSICEstimatorImplementationPointer_getImplementation(self)

    def unique(self):
        return _uncertainty._HSICEstimatorImplementationPointer_unique(self)

    def use_count(self):
        return _uncertainty._HSICEstimatorImplementationPointer_use_count(self)

    def swap(self, other):
        return _uncertainty._HSICEstimatorImplementationPointer_swap(self, other)

    def getClassName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        class_name : str
            The object class name (`object.__class__.__name__`).
        """
        return _uncertainty._HSICEstimatorImplementationPointer_getClassName(self)

    def setPermutationSize(self, B):
        r"""
        Set the number of permutations to be used for p-value estimate.

        Parameters
        ----------
        B : int
            The number of permutation used for p-value estimates.
        """
        return _uncertainty._HSICEstimatorImplementationPointer_setPermutationSize(self, B)

    def getPermutationSize(self):
        r"""
        Get the number of permutations.

        Returns
        -------
        permutationSize : int
            The number of permutations.
        """
        return _uncertainty._HSICEstimatorImplementationPointer_getPermutationSize(self)

    def getCovarianceModelCollection(self):
        r"""
        Get the list of all covariance models used.

        Returns
        -------
        coll : CovarianceModelCollection
            The list of all covariance models used. The last one is the output covariance model.
        """
        return _uncertainty._HSICEstimatorImplementationPointer_getCovarianceModelCollection(self)

    def setCovarianceModelCollection(self, coll):
        r"""
        Set the covariance models.

        Parameters
        ----------
        coll : CovarianceModelCollection
            The list of all covariance models.
        """
        return _uncertainty._HSICEstimatorImplementationPointer_setCovarianceModelCollection(self, coll)

    def getInputSample(self):
        r"""
        Get the input sample.

        Returns
        -------
        inSample : :class:`~openturns.Sample`
            The input sample used for analysis.
        """
        return _uncertainty._HSICEstimatorImplementationPointer_getInputSample(self)

    def setInputSample(self, inputSample):
        r"""
        Set the input sample.

        Parameters
        ----------
        inputSample : 2-d sequence of float
            The input sample to be used.
        """
        return _uncertainty._HSICEstimatorImplementationPointer_setInputSample(self, inputSample)

    def getOutputSample(self):
        r"""
        Get the output sample.

        Returns
        -------
        outSample : :class:`~openturns.Sample`
            The output sample used for analysis.
        """
        return _uncertainty._HSICEstimatorImplementationPointer_getOutputSample(self)

    def setOutputSample(self, outputSample):
        r"""
        Set the output sample.

        Parameters
        ----------
        outputSample : 2-d sequence of float
            The output sample to be used.
        """
        return _uncertainty._HSICEstimatorImplementationPointer_setOutputSample(self, outputSample)

    def getDimension(self):
        r"""
        Get the dimension of the input sample.

        Returns
        -------
        dim : int
            The dimension of the input sample.
        """
        return _uncertainty._HSICEstimatorImplementationPointer_getDimension(self)

    def getSize(self):
        r"""
        Get the size of the input sample.

        Returns
        -------
        size : int
            The size of the input sample.
        """
        return _uncertainty._HSICEstimatorImplementationPointer_getSize(self)

    def getEstimator(self):
        r"""
        Get the estimator used for computations.

        Returns
        -------
        estimator : :class:`~openturns.HSICStat`
            The estimator used for internal computations.
        """
        return _uncertainty._HSICEstimatorImplementationPointer_getEstimator(self)

    def getHSICIndices(self):
        r"""
        Get the HSIC indices.

        Returns
        -------
        hsicIndices : :class:`~openturns.Point`
            The HSIC indices of all components.
        """
        return _uncertainty._HSICEstimatorImplementationPointer_getHSICIndices(self)

    def getR2HSICIndices(self):
        r"""
        Get the R2-HSIC indices.

        Returns
        -------
        r2hsicIndices : :class:`~openturns.Point`
            The R2-HSIC indices of all components.
        """
        return _uncertainty._HSICEstimatorImplementationPointer_getR2HSICIndices(self)

    def getPValuesPermutation(self):
        r"""
        Get the p-value estimated through permutations.

        Returns
        -------
        pval : :class:`~openturns.Point`
            The p-values of all components estimated with permutations of the data.
        """
        return _uncertainty._HSICEstimatorImplementationPointer_getPValuesPermutation(self)

    def getPValuesAsymptotic(self):
        r"""
        Get the p-values obtained with an asymptotic formula.

        Returns
        -------
        pval : sequence of float
            The p-values for all components.
        """
        return _uncertainty._HSICEstimatorImplementationPointer_getPValuesAsymptotic(self)

    def run(self):
        r"""Compute all values at once."""
        return _uncertainty._HSICEstimatorImplementationPointer_run(self)

    def drawHSICIndices(self):
        r"""
        Draw the HSIC indices.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            The graph of all HSIC indices according to components.
        """
        return _uncertainty._HSICEstimatorImplementationPointer_drawHSICIndices(self)

    def drawR2HSICIndices(self):
        r"""
        Draw the R2-HSIC indices.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            The graph of all R2-HSIC indices according to components.
        """
        return _uncertainty._HSICEstimatorImplementationPointer_drawR2HSICIndices(self)

    def drawPValuesPermutation(self):
        r"""
        Draw the p-values obtained by permutation.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            The graph of all p-values by permutation according to components.
        """
        return _uncertainty._HSICEstimatorImplementationPointer_drawPValuesPermutation(self)

    def drawPValuesAsymptotic(self):
        r"""
        Draw the p-values obtained with an asymptotic formula.

        Returns
        -------
        graph : :class:`~openturns.Graph`
            The graph of all p-values estimated with an asymptotic formula.
        """
        return _uncertainty._HSICEstimatorImplementationPointer_drawPValuesAsymptotic(self)

    def __eq__(self, other):
        return _uncertainty._HSICEstimatorImplementationPointer___eq__(self, other)

    def __ne__(self, other):
        return _uncertainty._HSICEstimatorImplementationPointer___ne__(self, other)

    def __repr__(self):
        return _uncertainty._HSICEstimatorImplementationPointer___repr__(self)

    def __str__(self, *args):
        return _uncertainty._HSICEstimatorImplementationPointer___str__(self, *args)

    def __repr_markdown__(self):
        return _uncertainty._HSICEstimatorImplementationPointer___repr_markdown__(self)

    def _repr_html_(self):
        return _uncertainty._HSICEstimatorImplementationPointer__repr_html_(self)

    def hasName(self):
        r"""
        Test if the object is named.

        Returns
        -------
        hasName : bool
            True if the name is not empty.
        """
        return _uncertainty._HSICEstimatorImplementationPointer_hasName(self)

    def getName(self):
        r"""
        Accessor to the object's name.

        Returns
        -------
        name : str
            The name of the object.
        """
        return _uncertainty._HSICEstimatorImplementationPointer_getName(self)

    def setName(self, name):
        r"""
        Accessor to the object's name.

        Parameters
        ----------
        name : str
            The name of the object.
        """
        return _uncertainty._HSICEstimatorImplementationPointer_setName(self, name)

# Register _HSICEstimatorImplementationPointer in _uncertainty:
_uncertainty._HSICEstimatorImplementationPointer_swigregister(_HSICEstimatorImplementationPointer)

