%feature("docstring") OT::FieldToPointConnection
"Composition function :math:`f \\circ g` where :math:`g` acts on fields and :math:`f` produces points.

Available constructors:
   FieldToPointConnection(*f_Function, g_FieldToPoint*)

   FieldToPointConnection(*f_FieldToPoint, g_FieldFunction*)

Parameters
----------
f_Function :  :class:`~openturns.Function`
    Function that acts on points and produces points
g_FieldFunction : :class:`~openturns.FieldFunction`
    Function that acts on fields and produces fields
f_FieldToPoint, g_FieldToPoint : :class:`~openturns.FieldToPointFunction`
    Function that acts on fields and produces points

Notes
-----
This class is a particular case  of the general class :class:`~openturns.FieldToPointFunction`. Thus it doesn't implement the  gradient nor the hessian."

// ---------------------------------------------------------------------

%feature("docstring") OT::FieldToPointConnection::getFunction
"Accessor to the function :math:`f` of class :class:`~openturns.Function`.

Returns
-------
f : :class:`~openturns.Function`
    The function :math:`f` that acts on points to produce points."

// ---------------------------------------------------------------------

%feature("docstring") OT::FieldToPointConnection::getFieldFunction
"Accessor to the function :math:`g` of class :class:`~openturns.FieldFunction`.

Returns
-------
g : :class:`~openturns.FieldFunction`
    The function :math:`f` that acts on fields to produce fields."

// ---------------------------------------------------------------------

%feature("docstring") OT::FieldToPointConnection::getFieldToPointFunction
"Accessor to the function  of class :class:`~openturns.FieldToPointFunction`.

Returns
-------
func : :class:`~openturns.FieldToPointFunction`
    The function :math:`f` or :math:`g` that acts on fields to produce points."





