--
--  Copyright (C) 2014-2022, AdaCore
--  SPDX-License-Identifier: Apache-2.0
--

--  This package provides contants to refer to Libadalang types and struct
--  members in the generic introspection API
--  (``Langkit_Support.Generic_API.Introspection``).

with Langkit_Support.Generic_API.Introspection;

package Libadalang.Generic_API.Introspection is

   package G renames Langkit_Support.Generic_API.Introspection;

   ---------------------
   -- Type references --
   ---------------------

   package Type_Refs is
         Analysis_Unit : constant G.Type_Ref :=
           G.From_Index (Self_Id, 1);
         Big_Integer : constant G.Type_Ref :=
           G.From_Index (Self_Id, 2);
         Boolean : constant G.Type_Ref :=
           G.From_Index (Self_Id, 3);
         Character_Type : constant G.Type_Ref :=
           G.From_Index (Self_Id, 4);
         Integer : constant G.Type_Ref :=
           G.From_Index (Self_Id, 5);
         Source_Location_Range : constant G.Type_Ref :=
           G.From_Index (Self_Id, 6);
         Text_Type : constant G.Type_Ref :=
           G.From_Index (Self_Id, 7);
         Token_Reference : constant G.Type_Ref :=
           G.From_Index (Self_Id, 8);
         Unbounded_Text_Type : constant G.Type_Ref :=
           G.From_Index (Self_Id, 9);
         Analysis_Unit_Kind : constant G.Type_Ref :=
           G.From_Index (Self_Id, 10);
         Lookup_Kind : constant G.Type_Ref :=
           G.From_Index (Self_Id, 11);
         Designated_Env_Kind : constant G.Type_Ref :=
           G.From_Index (Self_Id, 12);
         Ref_Result_Kind : constant G.Type_Ref :=
           G.From_Index (Self_Id, 13);
         Call_Expr_Kind : constant G.Type_Ref :=
           G.From_Index (Self_Id, 14);
         Grammar_Rule : constant G.Type_Ref :=
           G.From_Index (Self_Id, 15);
         Discriminant_Values_Array : constant G.Type_Ref :=
           G.From_Index (Self_Id, 16);
         Doc_Annotation_Array : constant G.Type_Ref :=
           G.From_Index (Self_Id, 17);
         Accept_Stmt_Array : constant G.Type_Ref :=
           G.From_Index (Self_Id, 18);
         Ada_Node_Array : constant G.Type_Ref :=
           G.From_Index (Self_Id, 19);
         Base_Formal_Param_Decl_Array : constant G.Type_Ref :=
           G.From_Index (Self_Id, 20);
         Base_Type_Decl_Array : constant G.Type_Ref :=
           G.From_Index (Self_Id, 21);
         Basic_Decl_Array : constant G.Type_Ref :=
           G.From_Index (Self_Id, 22);
         Compilation_Unit_Array : constant G.Type_Ref :=
           G.From_Index (Self_Id, 23);
         Defining_Name_Array : constant G.Type_Ref :=
           G.From_Index (Self_Id, 24);
         Expr_Array : constant G.Type_Ref :=
           G.From_Index (Self_Id, 25);
         Generic_Instantiation_Array : constant G.Type_Ref :=
           G.From_Index (Self_Id, 26);
         Param_Spec_Array : constant G.Type_Ref :=
           G.From_Index (Self_Id, 27);
         Pragma_Node_Array : constant G.Type_Ref :=
           G.From_Index (Self_Id, 28);
         Type_Decl_Array : constant G.Type_Ref :=
           G.From_Index (Self_Id, 29);
         Param_Actual_Array : constant G.Type_Ref :=
           G.From_Index (Self_Id, 30);
         Ref_Result_Array : constant G.Type_Ref :=
           G.From_Index (Self_Id, 31);
         Shape_Array : constant G.Type_Ref :=
           G.From_Index (Self_Id, 32);
         Substitution_Array : constant G.Type_Ref :=
           G.From_Index (Self_Id, 33);
         Analysis_Unit_Array : constant G.Type_Ref :=
           G.From_Index (Self_Id, 34);
         Unbounded_Text_Type_Array : constant G.Type_Ref :=
           G.From_Index (Self_Id, 35);
         Completion_Item_Iterator : constant G.Type_Ref :=
           G.From_Index (Self_Id, 36);
         Aspect : constant G.Type_Ref :=
           G.From_Index (Self_Id, 37);
         Completion_Item : constant G.Type_Ref :=
           G.From_Index (Self_Id, 38);
         Discrete_Range : constant G.Type_Ref :=
           G.From_Index (Self_Id, 39);
         Discriminant_Values : constant G.Type_Ref :=
           G.From_Index (Self_Id, 40);
         Doc_Annotation : constant G.Type_Ref :=
           G.From_Index (Self_Id, 41);
         Param_Actual : constant G.Type_Ref :=
           G.From_Index (Self_Id, 42);
         Ref_Result : constant G.Type_Ref :=
           G.From_Index (Self_Id, 43);
         Refd_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 44);
         Refd_Def : constant G.Type_Ref :=
           G.From_Index (Self_Id, 45);
         Shape : constant G.Type_Ref :=
           G.From_Index (Self_Id, 46);
         Substitution : constant G.Type_Ref :=
           G.From_Index (Self_Id, 47);
         Ada_Node : constant G.Type_Ref :=
           G.From_Index (Self_Id, 48);
         Abort_Node : constant G.Type_Ref :=
           G.From_Index (Self_Id, 49);
         Abort_Absent : constant G.Type_Ref :=
           G.From_Index (Self_Id, 50);
         Abort_Present : constant G.Type_Ref :=
           G.From_Index (Self_Id, 51);
         Abstract_Node : constant G.Type_Ref :=
           G.From_Index (Self_Id, 52);
         Abstract_Absent : constant G.Type_Ref :=
           G.From_Index (Self_Id, 53);
         Abstract_Present : constant G.Type_Ref :=
           G.From_Index (Self_Id, 54);
         Ada_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 55);
         Ada_Node_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 56);
         Abstract_State_Decl_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 57);
         Alternatives_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 58);
         Constraint_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 59);
         Decl_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 60);
         Stmt_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 61);
         Aspect_Assoc_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 62);
         Base_Assoc_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 63);
         Basic_Assoc_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 64);
         Assoc_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 65);
         Basic_Decl_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 66);
         Case_Expr_Alternative_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 67);
         Case_Stmt_Alternative_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 68);
         Compilation_Unit_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 69);
         Concat_Operand_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 70);
         Contract_Case_Assoc_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 71);
         Defining_Name_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 72);
         Discriminant_Spec_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 73);
         Elsif_Expr_Part_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 74);
         Elsif_Stmt_Part_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 75);
         Enum_Literal_Decl_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 76);
         Expr_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 77);
         Expr_Alternatives_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 78);
         Identifier_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 79);
         Discriminant_Choice_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 80);
         Name_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 81);
         Parent_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 82);
         Param_Spec_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 83);
         Pragma_Node_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 84);
         Select_When_Part_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 85);
         Unconstrained_Array_Index_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 86);
         Variant_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 87);
         Aliased_Node : constant G.Type_Ref :=
           G.From_Index (Self_Id, 88);
         Aliased_Absent : constant G.Type_Ref :=
           G.From_Index (Self_Id, 89);
         Aliased_Present : constant G.Type_Ref :=
           G.From_Index (Self_Id, 90);
         All_Node : constant G.Type_Ref :=
           G.From_Index (Self_Id, 91);
         All_Absent : constant G.Type_Ref :=
           G.From_Index (Self_Id, 92);
         All_Present : constant G.Type_Ref :=
           G.From_Index (Self_Id, 93);
         Array_Indices : constant G.Type_Ref :=
           G.From_Index (Self_Id, 94);
         Constrained_Array_Indices : constant G.Type_Ref :=
           G.From_Index (Self_Id, 95);
         Unconstrained_Array_Indices : constant G.Type_Ref :=
           G.From_Index (Self_Id, 96);
         Aspect_Assoc : constant G.Type_Ref :=
           G.From_Index (Self_Id, 97);
         Aspect_Clause : constant G.Type_Ref :=
           G.From_Index (Self_Id, 98);
         At_Clause : constant G.Type_Ref :=
           G.From_Index (Self_Id, 99);
         Attribute_Def_Clause : constant G.Type_Ref :=
           G.From_Index (Self_Id, 100);
         Enum_Rep_Clause : constant G.Type_Ref :=
           G.From_Index (Self_Id, 101);
         Record_Rep_Clause : constant G.Type_Ref :=
           G.From_Index (Self_Id, 102);
         Aspect_Spec : constant G.Type_Ref :=
           G.From_Index (Self_Id, 103);
         Base_Assoc : constant G.Type_Ref :=
           G.From_Index (Self_Id, 104);
         Contract_Case_Assoc : constant G.Type_Ref :=
           G.From_Index (Self_Id, 105);
         Pragma_Argument_Assoc : constant G.Type_Ref :=
           G.From_Index (Self_Id, 106);
         Base_Formal_Param_Holder : constant G.Type_Ref :=
           G.From_Index (Self_Id, 107);
         Base_Subp_Spec : constant G.Type_Ref :=
           G.From_Index (Self_Id, 108);
         Entry_Spec : constant G.Type_Ref :=
           G.From_Index (Self_Id, 109);
         Enum_Subp_Spec : constant G.Type_Ref :=
           G.From_Index (Self_Id, 110);
         Subp_Spec : constant G.Type_Ref :=
           G.From_Index (Self_Id, 111);
         Synthetic_Binary_Spec : constant G.Type_Ref :=
           G.From_Index (Self_Id, 112);
         Synthetic_Unary_Spec : constant G.Type_Ref :=
           G.From_Index (Self_Id, 113);
         Component_List : constant G.Type_Ref :=
           G.From_Index (Self_Id, 114);
         Discriminant_Part : constant G.Type_Ref :=
           G.From_Index (Self_Id, 115);
         Known_Discriminant_Part : constant G.Type_Ref :=
           G.From_Index (Self_Id, 116);
         Unknown_Discriminant_Part : constant G.Type_Ref :=
           G.From_Index (Self_Id, 117);
         Entry_Completion_Formal_Params : constant G.Type_Ref :=
           G.From_Index (Self_Id, 118);
         Generic_Formal_Part : constant G.Type_Ref :=
           G.From_Index (Self_Id, 119);
         Base_Record_Def : constant G.Type_Ref :=
           G.From_Index (Self_Id, 120);
         Null_Record_Def : constant G.Type_Ref :=
           G.From_Index (Self_Id, 121);
         Record_Def : constant G.Type_Ref :=
           G.From_Index (Self_Id, 122);
         Basic_Assoc : constant G.Type_Ref :=
           G.From_Index (Self_Id, 123);
         Aggregate_Assoc : constant G.Type_Ref :=
           G.From_Index (Self_Id, 124);
         Multi_Dim_Array_Assoc : constant G.Type_Ref :=
           G.From_Index (Self_Id, 125);
         Composite_Constraint_Assoc : constant G.Type_Ref :=
           G.From_Index (Self_Id, 126);
         Iterated_Assoc : constant G.Type_Ref :=
           G.From_Index (Self_Id, 127);
         Param_Assoc : constant G.Type_Ref :=
           G.From_Index (Self_Id, 128);
         Basic_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 129);
         Abstract_State_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 130);
         Anonymous_Expr_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 131);
         Base_Formal_Param_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 132);
         Component_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 133);
         Discriminant_Spec : constant G.Type_Ref :=
           G.From_Index (Self_Id, 134);
         Generic_Formal : constant G.Type_Ref :=
           G.From_Index (Self_Id, 135);
         Generic_Formal_Obj_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 136);
         Generic_Formal_Package : constant G.Type_Ref :=
           G.From_Index (Self_Id, 137);
         Generic_Formal_Subp_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 138);
         Generic_Formal_Type_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 139);
         Param_Spec : constant G.Type_Ref :=
           G.From_Index (Self_Id, 140);
         Synthetic_Formal_Param_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 141);
         Base_Package_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 142);
         Generic_Package_Internal : constant G.Type_Ref :=
           G.From_Index (Self_Id, 143);
         Package_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 144);
         Base_Type_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 145);
         Base_Subtype_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 146);
         Discrete_Base_Subtype_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 147);
         Subtype_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 148);
         Classwide_Type_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 149);
         Incomplete_Type_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 150);
         Incomplete_Formal_Type_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 151);
         Incomplete_Tagged_Type_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 152);
         Protected_Type_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 153);
         Task_Type_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 154);
         Single_Task_Type_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 155);
         Type_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 156);
         Anonymous_Type_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 157);
         Synth_Anonymous_Type_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 158);
         Concrete_Type_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 159);
         Formal_Type_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 160);
         Basic_Subp_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 161);
         Classic_Subp_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 162);
         Abstract_Subp_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 163);
         Formal_Subp_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 164);
         Abstract_Formal_Subp_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 165);
         Concrete_Formal_Subp_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 166);
         Subp_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 167);
         Entry_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 168);
         Enum_Literal_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 169);
         Synthetic_Char_Enum_Lit : constant G.Type_Ref :=
           G.From_Index (Self_Id, 170);
         Generic_Subp_Internal : constant G.Type_Ref :=
           G.From_Index (Self_Id, 171);
         Synthetic_Subp_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 172);
         Body_Node : constant G.Type_Ref :=
           G.From_Index (Self_Id, 173);
         Accept_Stmt_Body : constant G.Type_Ref :=
           G.From_Index (Self_Id, 174);
         Base_Subp_Body : constant G.Type_Ref :=
           G.From_Index (Self_Id, 175);
         Expr_Function : constant G.Type_Ref :=
           G.From_Index (Self_Id, 176);
         Null_Subp_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 177);
         Subp_Body : constant G.Type_Ref :=
           G.From_Index (Self_Id, 178);
         Subp_Renaming_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 179);
         Body_Stub : constant G.Type_Ref :=
           G.From_Index (Self_Id, 180);
         Package_Body_Stub : constant G.Type_Ref :=
           G.From_Index (Self_Id, 181);
         Protected_Body_Stub : constant G.Type_Ref :=
           G.From_Index (Self_Id, 182);
         Subp_Body_Stub : constant G.Type_Ref :=
           G.From_Index (Self_Id, 183);
         Task_Body_Stub : constant G.Type_Ref :=
           G.From_Index (Self_Id, 184);
         Entry_Body : constant G.Type_Ref :=
           G.From_Index (Self_Id, 185);
         Package_Body : constant G.Type_Ref :=
           G.From_Index (Self_Id, 186);
         Protected_Body : constant G.Type_Ref :=
           G.From_Index (Self_Id, 187);
         Task_Body : constant G.Type_Ref :=
           G.From_Index (Self_Id, 188);
         Entry_Index_Spec : constant G.Type_Ref :=
           G.From_Index (Self_Id, 189);
         Error_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 190);
         Exception_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 191);
         Exception_Handler : constant G.Type_Ref :=
           G.From_Index (Self_Id, 192);
         For_Loop_Var_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 193);
         Generic_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 194);
         Generic_Package_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 195);
         Generic_Subp_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 196);
         Generic_Instantiation : constant G.Type_Ref :=
           G.From_Index (Self_Id, 197);
         Generic_Package_Instantiation : constant G.Type_Ref :=
           G.From_Index (Self_Id, 198);
         Generic_Subp_Instantiation : constant G.Type_Ref :=
           G.From_Index (Self_Id, 199);
         Generic_Renaming_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 200);
         Generic_Package_Renaming_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 201);
         Generic_Subp_Renaming_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 202);
         Label_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 203);
         Named_Stmt_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 204);
         Number_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 205);
         Object_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 206);
         Extended_Return_Stmt_Object_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 207);
         No_Type_Object_Renaming_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 208);
         Package_Renaming_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 209);
         Single_Protected_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 210);
         Single_Task_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 211);
         Case_Stmt_Alternative : constant G.Type_Ref :=
           G.From_Index (Self_Id, 212);
         Compilation_Unit : constant G.Type_Ref :=
           G.From_Index (Self_Id, 213);
         Component_Clause : constant G.Type_Ref :=
           G.From_Index (Self_Id, 214);
         Component_Def : constant G.Type_Ref :=
           G.From_Index (Self_Id, 215);
         Constant_Node : constant G.Type_Ref :=
           G.From_Index (Self_Id, 216);
         Constant_Absent : constant G.Type_Ref :=
           G.From_Index (Self_Id, 217);
         Constant_Present : constant G.Type_Ref :=
           G.From_Index (Self_Id, 218);
         Constraint : constant G.Type_Ref :=
           G.From_Index (Self_Id, 219);
         Composite_Constraint : constant G.Type_Ref :=
           G.From_Index (Self_Id, 220);
         Delta_Constraint : constant G.Type_Ref :=
           G.From_Index (Self_Id, 221);
         Digits_Constraint : constant G.Type_Ref :=
           G.From_Index (Self_Id, 222);
         Range_Constraint : constant G.Type_Ref :=
           G.From_Index (Self_Id, 223);
         Declarative_Part : constant G.Type_Ref :=
           G.From_Index (Self_Id, 224);
         Private_Part : constant G.Type_Ref :=
           G.From_Index (Self_Id, 225);
         Public_Part : constant G.Type_Ref :=
           G.From_Index (Self_Id, 226);
         Elsif_Expr_Part : constant G.Type_Ref :=
           G.From_Index (Self_Id, 227);
         Elsif_Stmt_Part : constant G.Type_Ref :=
           G.From_Index (Self_Id, 228);
         Expr : constant G.Type_Ref :=
           G.From_Index (Self_Id, 229);
         Abstract_State_Decl_Expr : constant G.Type_Ref :=
           G.From_Index (Self_Id, 230);
         Allocator : constant G.Type_Ref :=
           G.From_Index (Self_Id, 231);
         Base_Aggregate : constant G.Type_Ref :=
           G.From_Index (Self_Id, 232);
         Aggregate : constant G.Type_Ref :=
           G.From_Index (Self_Id, 233);
         Bracket_Aggregate : constant G.Type_Ref :=
           G.From_Index (Self_Id, 234);
         Delta_Aggregate : constant G.Type_Ref :=
           G.From_Index (Self_Id, 235);
         Bracket_Delta_Aggregate : constant G.Type_Ref :=
           G.From_Index (Self_Id, 236);
         Null_Record_Aggregate : constant G.Type_Ref :=
           G.From_Index (Self_Id, 237);
         Bin_Op : constant G.Type_Ref :=
           G.From_Index (Self_Id, 238);
         Relation_Op : constant G.Type_Ref :=
           G.From_Index (Self_Id, 239);
         Box_Expr : constant G.Type_Ref :=
           G.From_Index (Self_Id, 240);
         Case_Expr_Alternative : constant G.Type_Ref :=
           G.From_Index (Self_Id, 241);
         Concat_Op : constant G.Type_Ref :=
           G.From_Index (Self_Id, 242);
         Concat_Operand : constant G.Type_Ref :=
           G.From_Index (Self_Id, 243);
         Cond_Expr : constant G.Type_Ref :=
           G.From_Index (Self_Id, 244);
         Case_Expr : constant G.Type_Ref :=
           G.From_Index (Self_Id, 245);
         If_Expr : constant G.Type_Ref :=
           G.From_Index (Self_Id, 246);
         Contract_Cases : constant G.Type_Ref :=
           G.From_Index (Self_Id, 247);
         Decl_Expr : constant G.Type_Ref :=
           G.From_Index (Self_Id, 248);
         Membership_Expr : constant G.Type_Ref :=
           G.From_Index (Self_Id, 249);
         Name : constant G.Type_Ref :=
           G.From_Index (Self_Id, 250);
         Attribute_Ref : constant G.Type_Ref :=
           G.From_Index (Self_Id, 251);
         Call_Expr : constant G.Type_Ref :=
           G.From_Index (Self_Id, 252);
         Defining_Name : constant G.Type_Ref :=
           G.From_Index (Self_Id, 253);
         Synthetic_Defining_Name : constant G.Type_Ref :=
           G.From_Index (Self_Id, 254);
         Discrete_Subtype_Name : constant G.Type_Ref :=
           G.From_Index (Self_Id, 255);
         Dotted_Name : constant G.Type_Ref :=
           G.From_Index (Self_Id, 256);
         End_Name : constant G.Type_Ref :=
           G.From_Index (Self_Id, 257);
         Explicit_Deref : constant G.Type_Ref :=
           G.From_Index (Self_Id, 258);
         Qual_Expr : constant G.Type_Ref :=
           G.From_Index (Self_Id, 259);
         Reduce_Attribute_Ref : constant G.Type_Ref :=
           G.From_Index (Self_Id, 260);
         Single_Tok_Node : constant G.Type_Ref :=
           G.From_Index (Self_Id, 261);
         Base_Id : constant G.Type_Ref :=
           G.From_Index (Self_Id, 262);
         Char_Literal : constant G.Type_Ref :=
           G.From_Index (Self_Id, 263);
         Identifier : constant G.Type_Ref :=
           G.From_Index (Self_Id, 264);
         Op : constant G.Type_Ref :=
           G.From_Index (Self_Id, 265);
         Op_Abs : constant G.Type_Ref :=
           G.From_Index (Self_Id, 266);
         Op_And : constant G.Type_Ref :=
           G.From_Index (Self_Id, 267);
         Op_And_Then : constant G.Type_Ref :=
           G.From_Index (Self_Id, 268);
         Op_Concat : constant G.Type_Ref :=
           G.From_Index (Self_Id, 269);
         Op_Div : constant G.Type_Ref :=
           G.From_Index (Self_Id, 270);
         Op_Double_Dot : constant G.Type_Ref :=
           G.From_Index (Self_Id, 271);
         Op_Eq : constant G.Type_Ref :=
           G.From_Index (Self_Id, 272);
         Op_Gt : constant G.Type_Ref :=
           G.From_Index (Self_Id, 273);
         Op_Gte : constant G.Type_Ref :=
           G.From_Index (Self_Id, 274);
         Op_In : constant G.Type_Ref :=
           G.From_Index (Self_Id, 275);
         Op_Lt : constant G.Type_Ref :=
           G.From_Index (Self_Id, 276);
         Op_Lte : constant G.Type_Ref :=
           G.From_Index (Self_Id, 277);
         Op_Minus : constant G.Type_Ref :=
           G.From_Index (Self_Id, 278);
         Op_Mod : constant G.Type_Ref :=
           G.From_Index (Self_Id, 279);
         Op_Mult : constant G.Type_Ref :=
           G.From_Index (Self_Id, 280);
         Op_Neq : constant G.Type_Ref :=
           G.From_Index (Self_Id, 281);
         Op_Not : constant G.Type_Ref :=
           G.From_Index (Self_Id, 282);
         Op_Not_In : constant G.Type_Ref :=
           G.From_Index (Self_Id, 283);
         Op_Or : constant G.Type_Ref :=
           G.From_Index (Self_Id, 284);
         Op_Or_Else : constant G.Type_Ref :=
           G.From_Index (Self_Id, 285);
         Op_Plus : constant G.Type_Ref :=
           G.From_Index (Self_Id, 286);
         Op_Pow : constant G.Type_Ref :=
           G.From_Index (Self_Id, 287);
         Op_Rem : constant G.Type_Ref :=
           G.From_Index (Self_Id, 288);
         Op_Xor : constant G.Type_Ref :=
           G.From_Index (Self_Id, 289);
         String_Literal : constant G.Type_Ref :=
           G.From_Index (Self_Id, 290);
         Null_Literal : constant G.Type_Ref :=
           G.From_Index (Self_Id, 291);
         Num_Literal : constant G.Type_Ref :=
           G.From_Index (Self_Id, 292);
         Int_Literal : constant G.Type_Ref :=
           G.From_Index (Self_Id, 293);
         Real_Literal : constant G.Type_Ref :=
           G.From_Index (Self_Id, 294);
         Synthetic_Identifier : constant G.Type_Ref :=
           G.From_Index (Self_Id, 295);
         Target_Name : constant G.Type_Ref :=
           G.From_Index (Self_Id, 296);
         Update_Attribute_Ref : constant G.Type_Ref :=
           G.From_Index (Self_Id, 297);
         Paren_Expr : constant G.Type_Ref :=
           G.From_Index (Self_Id, 298);
         Quantified_Expr : constant G.Type_Ref :=
           G.From_Index (Self_Id, 299);
         Raise_Expr : constant G.Type_Ref :=
           G.From_Index (Self_Id, 300);
         Un_Op : constant G.Type_Ref :=
           G.From_Index (Self_Id, 301);
         Handled_Stmts : constant G.Type_Ref :=
           G.From_Index (Self_Id, 302);
         Interface_Kind : constant G.Type_Ref :=
           G.From_Index (Self_Id, 303);
         Interface_Kind_Limited : constant G.Type_Ref :=
           G.From_Index (Self_Id, 304);
         Interface_Kind_Protected : constant G.Type_Ref :=
           G.From_Index (Self_Id, 305);
         Interface_Kind_Synchronized : constant G.Type_Ref :=
           G.From_Index (Self_Id, 306);
         Interface_Kind_Task : constant G.Type_Ref :=
           G.From_Index (Self_Id, 307);
         Iter_Type : constant G.Type_Ref :=
           G.From_Index (Self_Id, 308);
         Iter_Type_In : constant G.Type_Ref :=
           G.From_Index (Self_Id, 309);
         Iter_Type_Of : constant G.Type_Ref :=
           G.From_Index (Self_Id, 310);
         Library_Item : constant G.Type_Ref :=
           G.From_Index (Self_Id, 311);
         Limited_Node : constant G.Type_Ref :=
           G.From_Index (Self_Id, 312);
         Limited_Absent : constant G.Type_Ref :=
           G.From_Index (Self_Id, 313);
         Limited_Present : constant G.Type_Ref :=
           G.From_Index (Self_Id, 314);
         Loop_Spec : constant G.Type_Ref :=
           G.From_Index (Self_Id, 315);
         For_Loop_Spec : constant G.Type_Ref :=
           G.From_Index (Self_Id, 316);
         While_Loop_Spec : constant G.Type_Ref :=
           G.From_Index (Self_Id, 317);
         Mode : constant G.Type_Ref :=
           G.From_Index (Self_Id, 318);
         Mode_Default : constant G.Type_Ref :=
           G.From_Index (Self_Id, 319);
         Mode_In : constant G.Type_Ref :=
           G.From_Index (Self_Id, 320);
         Mode_In_Out : constant G.Type_Ref :=
           G.From_Index (Self_Id, 321);
         Mode_Out : constant G.Type_Ref :=
           G.From_Index (Self_Id, 322);
         Multi_Abstract_State_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 323);
         Not_Null : constant G.Type_Ref :=
           G.From_Index (Self_Id, 324);
         Not_Null_Absent : constant G.Type_Ref :=
           G.From_Index (Self_Id, 325);
         Not_Null_Present : constant G.Type_Ref :=
           G.From_Index (Self_Id, 326);
         Null_Component_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 327);
         Others_Designator : constant G.Type_Ref :=
           G.From_Index (Self_Id, 328);
         Overriding_Node : constant G.Type_Ref :=
           G.From_Index (Self_Id, 329);
         Overriding_Not_Overriding : constant G.Type_Ref :=
           G.From_Index (Self_Id, 330);
         Overriding_Overriding : constant G.Type_Ref :=
           G.From_Index (Self_Id, 331);
         Overriding_Unspecified : constant G.Type_Ref :=
           G.From_Index (Self_Id, 332);
         Params : constant G.Type_Ref :=
           G.From_Index (Self_Id, 333);
         Paren_Abstract_State_Decl : constant G.Type_Ref :=
           G.From_Index (Self_Id, 334);
         Pp_Directive : constant G.Type_Ref :=
           G.From_Index (Self_Id, 335);
         Pp_Else_Directive : constant G.Type_Ref :=
           G.From_Index (Self_Id, 336);
         Pp_Elsif_Directive : constant G.Type_Ref :=
           G.From_Index (Self_Id, 337);
         Pp_End_If_Directive : constant G.Type_Ref :=
           G.From_Index (Self_Id, 338);
         Pp_If_Directive : constant G.Type_Ref :=
           G.From_Index (Self_Id, 339);
         Pp_Then_Kw : constant G.Type_Ref :=
           G.From_Index (Self_Id, 340);
         Pragma_Node : constant G.Type_Ref :=
           G.From_Index (Self_Id, 341);
         Private_Node : constant G.Type_Ref :=
           G.From_Index (Self_Id, 342);
         Private_Absent : constant G.Type_Ref :=
           G.From_Index (Self_Id, 343);
         Private_Present : constant G.Type_Ref :=
           G.From_Index (Self_Id, 344);
         Protected_Def : constant G.Type_Ref :=
           G.From_Index (Self_Id, 345);
         Protected_Node : constant G.Type_Ref :=
           G.From_Index (Self_Id, 346);
         Protected_Absent : constant G.Type_Ref :=
           G.From_Index (Self_Id, 347);
         Protected_Present : constant G.Type_Ref :=
           G.From_Index (Self_Id, 348);
         Quantifier : constant G.Type_Ref :=
           G.From_Index (Self_Id, 349);
         Quantifier_All : constant G.Type_Ref :=
           G.From_Index (Self_Id, 350);
         Quantifier_Some : constant G.Type_Ref :=
           G.From_Index (Self_Id, 351);
         Range_Spec : constant G.Type_Ref :=
           G.From_Index (Self_Id, 352);
         Renaming_Clause : constant G.Type_Ref :=
           G.From_Index (Self_Id, 353);
         Synthetic_Renaming_Clause : constant G.Type_Ref :=
           G.From_Index (Self_Id, 354);
         Reverse_Node : constant G.Type_Ref :=
           G.From_Index (Self_Id, 355);
         Reverse_Absent : constant G.Type_Ref :=
           G.From_Index (Self_Id, 356);
         Reverse_Present : constant G.Type_Ref :=
           G.From_Index (Self_Id, 357);
         Select_When_Part : constant G.Type_Ref :=
           G.From_Index (Self_Id, 358);
         Stmt : constant G.Type_Ref :=
           G.From_Index (Self_Id, 359);
         Composite_Stmt : constant G.Type_Ref :=
           G.From_Index (Self_Id, 360);
         Accept_Stmt : constant G.Type_Ref :=
           G.From_Index (Self_Id, 361);
         Accept_Stmt_With_Stmts : constant G.Type_Ref :=
           G.From_Index (Self_Id, 362);
         Base_Loop_Stmt : constant G.Type_Ref :=
           G.From_Index (Self_Id, 363);
         For_Loop_Stmt : constant G.Type_Ref :=
           G.From_Index (Self_Id, 364);
         Loop_Stmt : constant G.Type_Ref :=
           G.From_Index (Self_Id, 365);
         While_Loop_Stmt : constant G.Type_Ref :=
           G.From_Index (Self_Id, 366);
         Block_Stmt : constant G.Type_Ref :=
           G.From_Index (Self_Id, 367);
         Begin_Block : constant G.Type_Ref :=
           G.From_Index (Self_Id, 368);
         Decl_Block : constant G.Type_Ref :=
           G.From_Index (Self_Id, 369);
         Case_Stmt : constant G.Type_Ref :=
           G.From_Index (Self_Id, 370);
         Extended_Return_Stmt : constant G.Type_Ref :=
           G.From_Index (Self_Id, 371);
         If_Stmt : constant G.Type_Ref :=
           G.From_Index (Self_Id, 372);
         Named_Stmt : constant G.Type_Ref :=
           G.From_Index (Self_Id, 373);
         Select_Stmt : constant G.Type_Ref :=
           G.From_Index (Self_Id, 374);
         Error_Stmt : constant G.Type_Ref :=
           G.From_Index (Self_Id, 375);
         Simple_Stmt : constant G.Type_Ref :=
           G.From_Index (Self_Id, 376);
         Abort_Stmt : constant G.Type_Ref :=
           G.From_Index (Self_Id, 377);
         Assign_Stmt : constant G.Type_Ref :=
           G.From_Index (Self_Id, 378);
         Call_Stmt : constant G.Type_Ref :=
           G.From_Index (Self_Id, 379);
         Delay_Stmt : constant G.Type_Ref :=
           G.From_Index (Self_Id, 380);
         Exit_Stmt : constant G.Type_Ref :=
           G.From_Index (Self_Id, 381);
         Goto_Stmt : constant G.Type_Ref :=
           G.From_Index (Self_Id, 382);
         Label : constant G.Type_Ref :=
           G.From_Index (Self_Id, 383);
         Null_Stmt : constant G.Type_Ref :=
           G.From_Index (Self_Id, 384);
         Raise_Stmt : constant G.Type_Ref :=
           G.From_Index (Self_Id, 385);
         Requeue_Stmt : constant G.Type_Ref :=
           G.From_Index (Self_Id, 386);
         Return_Stmt : constant G.Type_Ref :=
           G.From_Index (Self_Id, 387);
         Terminate_Alternative : constant G.Type_Ref :=
           G.From_Index (Self_Id, 388);
         Subp_Kind : constant G.Type_Ref :=
           G.From_Index (Self_Id, 389);
         Subp_Kind_Function : constant G.Type_Ref :=
           G.From_Index (Self_Id, 390);
         Subp_Kind_Procedure : constant G.Type_Ref :=
           G.From_Index (Self_Id, 391);
         Subunit : constant G.Type_Ref :=
           G.From_Index (Self_Id, 392);
         Synchronized_Node : constant G.Type_Ref :=
           G.From_Index (Self_Id, 393);
         Synchronized_Absent : constant G.Type_Ref :=
           G.From_Index (Self_Id, 394);
         Synchronized_Present : constant G.Type_Ref :=
           G.From_Index (Self_Id, 395);
         Tagged_Node : constant G.Type_Ref :=
           G.From_Index (Self_Id, 396);
         Tagged_Absent : constant G.Type_Ref :=
           G.From_Index (Self_Id, 397);
         Tagged_Present : constant G.Type_Ref :=
           G.From_Index (Self_Id, 398);
         Task_Def : constant G.Type_Ref :=
           G.From_Index (Self_Id, 399);
         Type_Attributes_Repository : constant G.Type_Ref :=
           G.From_Index (Self_Id, 400);
         Type_Def : constant G.Type_Ref :=
           G.From_Index (Self_Id, 401);
         Access_Def : constant G.Type_Ref :=
           G.From_Index (Self_Id, 402);
         Access_To_Subp_Def : constant G.Type_Ref :=
           G.From_Index (Self_Id, 403);
         Base_Type_Access_Def : constant G.Type_Ref :=
           G.From_Index (Self_Id, 404);
         Anonymous_Type_Access_Def : constant G.Type_Ref :=
           G.From_Index (Self_Id, 405);
         Type_Access_Def : constant G.Type_Ref :=
           G.From_Index (Self_Id, 406);
         Array_Type_Def : constant G.Type_Ref :=
           G.From_Index (Self_Id, 407);
         Derived_Type_Def : constant G.Type_Ref :=
           G.From_Index (Self_Id, 408);
         Enum_Type_Def : constant G.Type_Ref :=
           G.From_Index (Self_Id, 409);
         Formal_Discrete_Type_Def : constant G.Type_Ref :=
           G.From_Index (Self_Id, 410);
         Interface_Type_Def : constant G.Type_Ref :=
           G.From_Index (Self_Id, 411);
         Mod_Int_Type_Def : constant G.Type_Ref :=
           G.From_Index (Self_Id, 412);
         Private_Type_Def : constant G.Type_Ref :=
           G.From_Index (Self_Id, 413);
         Real_Type_Def : constant G.Type_Ref :=
           G.From_Index (Self_Id, 414);
         Decimal_Fixed_Point_Def : constant G.Type_Ref :=
           G.From_Index (Self_Id, 415);
         Floating_Point_Def : constant G.Type_Ref :=
           G.From_Index (Self_Id, 416);
         Ordinary_Fixed_Point_Def : constant G.Type_Ref :=
           G.From_Index (Self_Id, 417);
         Record_Type_Def : constant G.Type_Ref :=
           G.From_Index (Self_Id, 418);
         Signed_Int_Type_Def : constant G.Type_Ref :=
           G.From_Index (Self_Id, 419);
         Type_Expr : constant G.Type_Ref :=
           G.From_Index (Self_Id, 420);
         Anonymous_Type : constant G.Type_Ref :=
           G.From_Index (Self_Id, 421);
         Enum_Lit_Synth_Type_Expr : constant G.Type_Ref :=
           G.From_Index (Self_Id, 422);
         Subtype_Indication : constant G.Type_Ref :=
           G.From_Index (Self_Id, 423);
         Constrained_Subtype_Indication : constant G.Type_Ref :=
           G.From_Index (Self_Id, 424);
         Discrete_Subtype_Indication : constant G.Type_Ref :=
           G.From_Index (Self_Id, 425);
         Synthetic_Type_Expr : constant G.Type_Ref :=
           G.From_Index (Self_Id, 426);
         Unconstrained_Array_Index : constant G.Type_Ref :=
           G.From_Index (Self_Id, 427);
         Until_Node : constant G.Type_Ref :=
           G.From_Index (Self_Id, 428);
         Until_Absent : constant G.Type_Ref :=
           G.From_Index (Self_Id, 429);
         Until_Present : constant G.Type_Ref :=
           G.From_Index (Self_Id, 430);
         Use_Clause : constant G.Type_Ref :=
           G.From_Index (Self_Id, 431);
         Use_Package_Clause : constant G.Type_Ref :=
           G.From_Index (Self_Id, 432);
         Use_Type_Clause : constant G.Type_Ref :=
           G.From_Index (Self_Id, 433);
         Value_Sequence : constant G.Type_Ref :=
           G.From_Index (Self_Id, 434);
         Variant : constant G.Type_Ref :=
           G.From_Index (Self_Id, 435);
         Variant_Part : constant G.Type_Ref :=
           G.From_Index (Self_Id, 436);
         With_Clause : constant G.Type_Ref :=
           G.From_Index (Self_Id, 437);
         With_Private : constant G.Type_Ref :=
           G.From_Index (Self_Id, 438);
         With_Private_Absent : constant G.Type_Ref :=
           G.From_Index (Self_Id, 439);
         With_Private_Present : constant G.Type_Ref :=
           G.From_Index (Self_Id, 440);
   end Type_Refs;

   Kind_To_Type : constant array (Ada_Node_Kind_Type) of G.Type_Ref := (
      Ada_Abort_Absent => Type_Refs.Abort_Absent,
Ada_Abort_Present => Type_Refs.Abort_Present,
Ada_Abstract_Absent => Type_Refs.Abstract_Absent,
Ada_Abstract_Present => Type_Refs.Abstract_Present,
Ada_Ada_Node_List => Type_Refs.Ada_Node_List,
Ada_Abstract_State_Decl_List => Type_Refs.Abstract_State_Decl_List,
Ada_Alternatives_List => Type_Refs.Alternatives_List,
Ada_Constraint_List => Type_Refs.Constraint_List,
Ada_Decl_List => Type_Refs.Decl_List,
Ada_Stmt_List => Type_Refs.Stmt_List,
Ada_Aspect_Assoc_List => Type_Refs.Aspect_Assoc_List,
Ada_Base_Assoc_List => Type_Refs.Base_Assoc_List,
Ada_Assoc_List => Type_Refs.Assoc_List,
Ada_Basic_Decl_List => Type_Refs.Basic_Decl_List,
Ada_Case_Expr_Alternative_List => Type_Refs.Case_Expr_Alternative_List,
Ada_Case_Stmt_Alternative_List => Type_Refs.Case_Stmt_Alternative_List,
Ada_Compilation_Unit_List => Type_Refs.Compilation_Unit_List,
Ada_Concat_Operand_List => Type_Refs.Concat_Operand_List,
Ada_Contract_Case_Assoc_List => Type_Refs.Contract_Case_Assoc_List,
Ada_Defining_Name_List => Type_Refs.Defining_Name_List,
Ada_Discriminant_Spec_List => Type_Refs.Discriminant_Spec_List,
Ada_Elsif_Expr_Part_List => Type_Refs.Elsif_Expr_Part_List,
Ada_Elsif_Stmt_Part_List => Type_Refs.Elsif_Stmt_Part_List,
Ada_Enum_Literal_Decl_List => Type_Refs.Enum_Literal_Decl_List,
Ada_Expr_Alternatives_List => Type_Refs.Expr_Alternatives_List,
Ada_Discriminant_Choice_List => Type_Refs.Discriminant_Choice_List,
Ada_Name_List => Type_Refs.Name_List,
Ada_Parent_List => Type_Refs.Parent_List,
Ada_Param_Spec_List => Type_Refs.Param_Spec_List,
Ada_Pragma_Node_List => Type_Refs.Pragma_Node_List,
Ada_Select_When_Part_List => Type_Refs.Select_When_Part_List,
Ada_Unconstrained_Array_Index_List => Type_Refs.Unconstrained_Array_Index_List,
Ada_Variant_List => Type_Refs.Variant_List,
Ada_Aliased_Absent => Type_Refs.Aliased_Absent,
Ada_Aliased_Present => Type_Refs.Aliased_Present,
Ada_All_Absent => Type_Refs.All_Absent,
Ada_All_Present => Type_Refs.All_Present,
Ada_Constrained_Array_Indices => Type_Refs.Constrained_Array_Indices,
Ada_Unconstrained_Array_Indices => Type_Refs.Unconstrained_Array_Indices,
Ada_Aspect_Assoc => Type_Refs.Aspect_Assoc,
Ada_At_Clause => Type_Refs.At_Clause,
Ada_Attribute_Def_Clause => Type_Refs.Attribute_Def_Clause,
Ada_Enum_Rep_Clause => Type_Refs.Enum_Rep_Clause,
Ada_Record_Rep_Clause => Type_Refs.Record_Rep_Clause,
Ada_Aspect_Spec => Type_Refs.Aspect_Spec,
Ada_Contract_Case_Assoc => Type_Refs.Contract_Case_Assoc,
Ada_Pragma_Argument_Assoc => Type_Refs.Pragma_Argument_Assoc,
Ada_Entry_Spec => Type_Refs.Entry_Spec,
Ada_Enum_Subp_Spec => Type_Refs.Enum_Subp_Spec,
Ada_Subp_Spec => Type_Refs.Subp_Spec,
Ada_Synthetic_Binary_Spec => Type_Refs.Synthetic_Binary_Spec,
Ada_Synthetic_Unary_Spec => Type_Refs.Synthetic_Unary_Spec,
Ada_Component_List => Type_Refs.Component_List,
Ada_Known_Discriminant_Part => Type_Refs.Known_Discriminant_Part,
Ada_Unknown_Discriminant_Part => Type_Refs.Unknown_Discriminant_Part,
Ada_Entry_Completion_Formal_Params => Type_Refs.Entry_Completion_Formal_Params,
Ada_Generic_Formal_Part => Type_Refs.Generic_Formal_Part,
Ada_Null_Record_Def => Type_Refs.Null_Record_Def,
Ada_Record_Def => Type_Refs.Record_Def,
Ada_Aggregate_Assoc => Type_Refs.Aggregate_Assoc,
Ada_Multi_Dim_Array_Assoc => Type_Refs.Multi_Dim_Array_Assoc,
Ada_Composite_Constraint_Assoc => Type_Refs.Composite_Constraint_Assoc,
Ada_Iterated_Assoc => Type_Refs.Iterated_Assoc,
Ada_Param_Assoc => Type_Refs.Param_Assoc,
Ada_Abstract_State_Decl => Type_Refs.Abstract_State_Decl,
Ada_Anonymous_Expr_Decl => Type_Refs.Anonymous_Expr_Decl,
Ada_Component_Decl => Type_Refs.Component_Decl,
Ada_Discriminant_Spec => Type_Refs.Discriminant_Spec,
Ada_Generic_Formal_Obj_Decl => Type_Refs.Generic_Formal_Obj_Decl,
Ada_Generic_Formal_Package => Type_Refs.Generic_Formal_Package,
Ada_Generic_Formal_Subp_Decl => Type_Refs.Generic_Formal_Subp_Decl,
Ada_Generic_Formal_Type_Decl => Type_Refs.Generic_Formal_Type_Decl,
Ada_Param_Spec => Type_Refs.Param_Spec,
Ada_Synthetic_Formal_Param_Decl => Type_Refs.Synthetic_Formal_Param_Decl,
Ada_Generic_Package_Internal => Type_Refs.Generic_Package_Internal,
Ada_Package_Decl => Type_Refs.Package_Decl,
Ada_Discrete_Base_Subtype_Decl => Type_Refs.Discrete_Base_Subtype_Decl,
Ada_Subtype_Decl => Type_Refs.Subtype_Decl,
Ada_Classwide_Type_Decl => Type_Refs.Classwide_Type_Decl,
Ada_Incomplete_Type_Decl => Type_Refs.Incomplete_Type_Decl,
Ada_Incomplete_Formal_Type_Decl => Type_Refs.Incomplete_Formal_Type_Decl,
Ada_Incomplete_Tagged_Type_Decl => Type_Refs.Incomplete_Tagged_Type_Decl,
Ada_Protected_Type_Decl => Type_Refs.Protected_Type_Decl,
Ada_Task_Type_Decl => Type_Refs.Task_Type_Decl,
Ada_Single_Task_Type_Decl => Type_Refs.Single_Task_Type_Decl,
Ada_Anonymous_Type_Decl => Type_Refs.Anonymous_Type_Decl,
Ada_Synth_Anonymous_Type_Decl => Type_Refs.Synth_Anonymous_Type_Decl,
Ada_Concrete_Type_Decl => Type_Refs.Concrete_Type_Decl,
Ada_Formal_Type_Decl => Type_Refs.Formal_Type_Decl,
Ada_Abstract_Subp_Decl => Type_Refs.Abstract_Subp_Decl,
Ada_Abstract_Formal_Subp_Decl => Type_Refs.Abstract_Formal_Subp_Decl,
Ada_Concrete_Formal_Subp_Decl => Type_Refs.Concrete_Formal_Subp_Decl,
Ada_Subp_Decl => Type_Refs.Subp_Decl,
Ada_Entry_Decl => Type_Refs.Entry_Decl,
Ada_Enum_Literal_Decl => Type_Refs.Enum_Literal_Decl,
Ada_Synthetic_Char_Enum_Lit => Type_Refs.Synthetic_Char_Enum_Lit,
Ada_Generic_Subp_Internal => Type_Refs.Generic_Subp_Internal,
Ada_Synthetic_Subp_Decl => Type_Refs.Synthetic_Subp_Decl,
Ada_Accept_Stmt_Body => Type_Refs.Accept_Stmt_Body,
Ada_Expr_Function => Type_Refs.Expr_Function,
Ada_Null_Subp_Decl => Type_Refs.Null_Subp_Decl,
Ada_Subp_Body => Type_Refs.Subp_Body,
Ada_Subp_Renaming_Decl => Type_Refs.Subp_Renaming_Decl,
Ada_Package_Body_Stub => Type_Refs.Package_Body_Stub,
Ada_Protected_Body_Stub => Type_Refs.Protected_Body_Stub,
Ada_Subp_Body_Stub => Type_Refs.Subp_Body_Stub,
Ada_Task_Body_Stub => Type_Refs.Task_Body_Stub,
Ada_Entry_Body => Type_Refs.Entry_Body,
Ada_Package_Body => Type_Refs.Package_Body,
Ada_Protected_Body => Type_Refs.Protected_Body,
Ada_Task_Body => Type_Refs.Task_Body,
Ada_Entry_Index_Spec => Type_Refs.Entry_Index_Spec,
Ada_Error_Decl => Type_Refs.Error_Decl,
Ada_Exception_Decl => Type_Refs.Exception_Decl,
Ada_Exception_Handler => Type_Refs.Exception_Handler,
Ada_For_Loop_Var_Decl => Type_Refs.For_Loop_Var_Decl,
Ada_Generic_Package_Decl => Type_Refs.Generic_Package_Decl,
Ada_Generic_Subp_Decl => Type_Refs.Generic_Subp_Decl,
Ada_Generic_Package_Instantiation => Type_Refs.Generic_Package_Instantiation,
Ada_Generic_Subp_Instantiation => Type_Refs.Generic_Subp_Instantiation,
Ada_Generic_Package_Renaming_Decl => Type_Refs.Generic_Package_Renaming_Decl,
Ada_Generic_Subp_Renaming_Decl => Type_Refs.Generic_Subp_Renaming_Decl,
Ada_Label_Decl => Type_Refs.Label_Decl,
Ada_Named_Stmt_Decl => Type_Refs.Named_Stmt_Decl,
Ada_Number_Decl => Type_Refs.Number_Decl,
Ada_Object_Decl => Type_Refs.Object_Decl,
Ada_Extended_Return_Stmt_Object_Decl => Type_Refs.Extended_Return_Stmt_Object_Decl,
Ada_No_Type_Object_Renaming_Decl => Type_Refs.No_Type_Object_Renaming_Decl,
Ada_Package_Renaming_Decl => Type_Refs.Package_Renaming_Decl,
Ada_Single_Protected_Decl => Type_Refs.Single_Protected_Decl,
Ada_Single_Task_Decl => Type_Refs.Single_Task_Decl,
Ada_Case_Stmt_Alternative => Type_Refs.Case_Stmt_Alternative,
Ada_Compilation_Unit => Type_Refs.Compilation_Unit,
Ada_Component_Clause => Type_Refs.Component_Clause,
Ada_Component_Def => Type_Refs.Component_Def,
Ada_Constant_Absent => Type_Refs.Constant_Absent,
Ada_Constant_Present => Type_Refs.Constant_Present,
Ada_Composite_Constraint => Type_Refs.Composite_Constraint,
Ada_Delta_Constraint => Type_Refs.Delta_Constraint,
Ada_Digits_Constraint => Type_Refs.Digits_Constraint,
Ada_Range_Constraint => Type_Refs.Range_Constraint,
Ada_Declarative_Part => Type_Refs.Declarative_Part,
Ada_Private_Part => Type_Refs.Private_Part,
Ada_Public_Part => Type_Refs.Public_Part,
Ada_Elsif_Expr_Part => Type_Refs.Elsif_Expr_Part,
Ada_Elsif_Stmt_Part => Type_Refs.Elsif_Stmt_Part,
Ada_Abstract_State_Decl_Expr => Type_Refs.Abstract_State_Decl_Expr,
Ada_Allocator => Type_Refs.Allocator,
Ada_Aggregate => Type_Refs.Aggregate,
Ada_Bracket_Aggregate => Type_Refs.Bracket_Aggregate,
Ada_Delta_Aggregate => Type_Refs.Delta_Aggregate,
Ada_Bracket_Delta_Aggregate => Type_Refs.Bracket_Delta_Aggregate,
Ada_Null_Record_Aggregate => Type_Refs.Null_Record_Aggregate,
Ada_Bin_Op => Type_Refs.Bin_Op,
Ada_Relation_Op => Type_Refs.Relation_Op,
Ada_Box_Expr => Type_Refs.Box_Expr,
Ada_Case_Expr_Alternative => Type_Refs.Case_Expr_Alternative,
Ada_Concat_Op => Type_Refs.Concat_Op,
Ada_Concat_Operand => Type_Refs.Concat_Operand,
Ada_Case_Expr => Type_Refs.Case_Expr,
Ada_If_Expr => Type_Refs.If_Expr,
Ada_Contract_Cases => Type_Refs.Contract_Cases,
Ada_Decl_Expr => Type_Refs.Decl_Expr,
Ada_Membership_Expr => Type_Refs.Membership_Expr,
Ada_Attribute_Ref => Type_Refs.Attribute_Ref,
Ada_Call_Expr => Type_Refs.Call_Expr,
Ada_Defining_Name => Type_Refs.Defining_Name,
Ada_Synthetic_Defining_Name => Type_Refs.Synthetic_Defining_Name,
Ada_Discrete_Subtype_Name => Type_Refs.Discrete_Subtype_Name,
Ada_Dotted_Name => Type_Refs.Dotted_Name,
Ada_End_Name => Type_Refs.End_Name,
Ada_Explicit_Deref => Type_Refs.Explicit_Deref,
Ada_Qual_Expr => Type_Refs.Qual_Expr,
Ada_Reduce_Attribute_Ref => Type_Refs.Reduce_Attribute_Ref,
Ada_Char_Literal => Type_Refs.Char_Literal,
Ada_Identifier => Type_Refs.Identifier,
Ada_Op_Abs => Type_Refs.Op_Abs,
Ada_Op_And => Type_Refs.Op_And,
Ada_Op_And_Then => Type_Refs.Op_And_Then,
Ada_Op_Concat => Type_Refs.Op_Concat,
Ada_Op_Div => Type_Refs.Op_Div,
Ada_Op_Double_Dot => Type_Refs.Op_Double_Dot,
Ada_Op_Eq => Type_Refs.Op_Eq,
Ada_Op_Gt => Type_Refs.Op_Gt,
Ada_Op_Gte => Type_Refs.Op_Gte,
Ada_Op_In => Type_Refs.Op_In,
Ada_Op_Lt => Type_Refs.Op_Lt,
Ada_Op_Lte => Type_Refs.Op_Lte,
Ada_Op_Minus => Type_Refs.Op_Minus,
Ada_Op_Mod => Type_Refs.Op_Mod,
Ada_Op_Mult => Type_Refs.Op_Mult,
Ada_Op_Neq => Type_Refs.Op_Neq,
Ada_Op_Not => Type_Refs.Op_Not,
Ada_Op_Not_In => Type_Refs.Op_Not_In,
Ada_Op_Or => Type_Refs.Op_Or,
Ada_Op_Or_Else => Type_Refs.Op_Or_Else,
Ada_Op_Plus => Type_Refs.Op_Plus,
Ada_Op_Pow => Type_Refs.Op_Pow,
Ada_Op_Rem => Type_Refs.Op_Rem,
Ada_Op_Xor => Type_Refs.Op_Xor,
Ada_String_Literal => Type_Refs.String_Literal,
Ada_Null_Literal => Type_Refs.Null_Literal,
Ada_Int_Literal => Type_Refs.Int_Literal,
Ada_Real_Literal => Type_Refs.Real_Literal,
Ada_Synthetic_Identifier => Type_Refs.Synthetic_Identifier,
Ada_Target_Name => Type_Refs.Target_Name,
Ada_Update_Attribute_Ref => Type_Refs.Update_Attribute_Ref,
Ada_Paren_Expr => Type_Refs.Paren_Expr,
Ada_Quantified_Expr => Type_Refs.Quantified_Expr,
Ada_Raise_Expr => Type_Refs.Raise_Expr,
Ada_Un_Op => Type_Refs.Un_Op,
Ada_Handled_Stmts => Type_Refs.Handled_Stmts,
Ada_Interface_Kind_Limited => Type_Refs.Interface_Kind_Limited,
Ada_Interface_Kind_Protected => Type_Refs.Interface_Kind_Protected,
Ada_Interface_Kind_Synchronized => Type_Refs.Interface_Kind_Synchronized,
Ada_Interface_Kind_Task => Type_Refs.Interface_Kind_Task,
Ada_Iter_Type_In => Type_Refs.Iter_Type_In,
Ada_Iter_Type_Of => Type_Refs.Iter_Type_Of,
Ada_Library_Item => Type_Refs.Library_Item,
Ada_Limited_Absent => Type_Refs.Limited_Absent,
Ada_Limited_Present => Type_Refs.Limited_Present,
Ada_For_Loop_Spec => Type_Refs.For_Loop_Spec,
Ada_While_Loop_Spec => Type_Refs.While_Loop_Spec,
Ada_Mode_Default => Type_Refs.Mode_Default,
Ada_Mode_In => Type_Refs.Mode_In,
Ada_Mode_In_Out => Type_Refs.Mode_In_Out,
Ada_Mode_Out => Type_Refs.Mode_Out,
Ada_Multi_Abstract_State_Decl => Type_Refs.Multi_Abstract_State_Decl,
Ada_Not_Null_Absent => Type_Refs.Not_Null_Absent,
Ada_Not_Null_Present => Type_Refs.Not_Null_Present,
Ada_Null_Component_Decl => Type_Refs.Null_Component_Decl,
Ada_Others_Designator => Type_Refs.Others_Designator,
Ada_Overriding_Not_Overriding => Type_Refs.Overriding_Not_Overriding,
Ada_Overriding_Overriding => Type_Refs.Overriding_Overriding,
Ada_Overriding_Unspecified => Type_Refs.Overriding_Unspecified,
Ada_Params => Type_Refs.Params,
Ada_Paren_Abstract_State_Decl => Type_Refs.Paren_Abstract_State_Decl,
Ada_Pp_Else_Directive => Type_Refs.Pp_Else_Directive,
Ada_Pp_Elsif_Directive => Type_Refs.Pp_Elsif_Directive,
Ada_Pp_End_If_Directive => Type_Refs.Pp_End_If_Directive,
Ada_Pp_If_Directive => Type_Refs.Pp_If_Directive,
Ada_Pp_Then_Kw => Type_Refs.Pp_Then_Kw,
Ada_Pragma_Node => Type_Refs.Pragma_Node,
Ada_Private_Absent => Type_Refs.Private_Absent,
Ada_Private_Present => Type_Refs.Private_Present,
Ada_Protected_Def => Type_Refs.Protected_Def,
Ada_Protected_Absent => Type_Refs.Protected_Absent,
Ada_Protected_Present => Type_Refs.Protected_Present,
Ada_Quantifier_All => Type_Refs.Quantifier_All,
Ada_Quantifier_Some => Type_Refs.Quantifier_Some,
Ada_Range_Spec => Type_Refs.Range_Spec,
Ada_Renaming_Clause => Type_Refs.Renaming_Clause,
Ada_Synthetic_Renaming_Clause => Type_Refs.Synthetic_Renaming_Clause,
Ada_Reverse_Absent => Type_Refs.Reverse_Absent,
Ada_Reverse_Present => Type_Refs.Reverse_Present,
Ada_Select_When_Part => Type_Refs.Select_When_Part,
Ada_Accept_Stmt => Type_Refs.Accept_Stmt,
Ada_Accept_Stmt_With_Stmts => Type_Refs.Accept_Stmt_With_Stmts,
Ada_For_Loop_Stmt => Type_Refs.For_Loop_Stmt,
Ada_Loop_Stmt => Type_Refs.Loop_Stmt,
Ada_While_Loop_Stmt => Type_Refs.While_Loop_Stmt,
Ada_Begin_Block => Type_Refs.Begin_Block,
Ada_Decl_Block => Type_Refs.Decl_Block,
Ada_Case_Stmt => Type_Refs.Case_Stmt,
Ada_Extended_Return_Stmt => Type_Refs.Extended_Return_Stmt,
Ada_If_Stmt => Type_Refs.If_Stmt,
Ada_Named_Stmt => Type_Refs.Named_Stmt,
Ada_Select_Stmt => Type_Refs.Select_Stmt,
Ada_Error_Stmt => Type_Refs.Error_Stmt,
Ada_Abort_Stmt => Type_Refs.Abort_Stmt,
Ada_Assign_Stmt => Type_Refs.Assign_Stmt,
Ada_Call_Stmt => Type_Refs.Call_Stmt,
Ada_Delay_Stmt => Type_Refs.Delay_Stmt,
Ada_Exit_Stmt => Type_Refs.Exit_Stmt,
Ada_Goto_Stmt => Type_Refs.Goto_Stmt,
Ada_Label => Type_Refs.Label,
Ada_Null_Stmt => Type_Refs.Null_Stmt,
Ada_Raise_Stmt => Type_Refs.Raise_Stmt,
Ada_Requeue_Stmt => Type_Refs.Requeue_Stmt,
Ada_Return_Stmt => Type_Refs.Return_Stmt,
Ada_Terminate_Alternative => Type_Refs.Terminate_Alternative,
Ada_Subp_Kind_Function => Type_Refs.Subp_Kind_Function,
Ada_Subp_Kind_Procedure => Type_Refs.Subp_Kind_Procedure,
Ada_Subunit => Type_Refs.Subunit,
Ada_Synchronized_Absent => Type_Refs.Synchronized_Absent,
Ada_Synchronized_Present => Type_Refs.Synchronized_Present,
Ada_Tagged_Absent => Type_Refs.Tagged_Absent,
Ada_Tagged_Present => Type_Refs.Tagged_Present,
Ada_Task_Def => Type_Refs.Task_Def,
Ada_Type_Attributes_Repository => Type_Refs.Type_Attributes_Repository,
Ada_Access_To_Subp_Def => Type_Refs.Access_To_Subp_Def,
Ada_Anonymous_Type_Access_Def => Type_Refs.Anonymous_Type_Access_Def,
Ada_Type_Access_Def => Type_Refs.Type_Access_Def,
Ada_Array_Type_Def => Type_Refs.Array_Type_Def,
Ada_Derived_Type_Def => Type_Refs.Derived_Type_Def,
Ada_Enum_Type_Def => Type_Refs.Enum_Type_Def,
Ada_Formal_Discrete_Type_Def => Type_Refs.Formal_Discrete_Type_Def,
Ada_Interface_Type_Def => Type_Refs.Interface_Type_Def,
Ada_Mod_Int_Type_Def => Type_Refs.Mod_Int_Type_Def,
Ada_Private_Type_Def => Type_Refs.Private_Type_Def,
Ada_Decimal_Fixed_Point_Def => Type_Refs.Decimal_Fixed_Point_Def,
Ada_Floating_Point_Def => Type_Refs.Floating_Point_Def,
Ada_Ordinary_Fixed_Point_Def => Type_Refs.Ordinary_Fixed_Point_Def,
Ada_Record_Type_Def => Type_Refs.Record_Type_Def,
Ada_Signed_Int_Type_Def => Type_Refs.Signed_Int_Type_Def,
Ada_Anonymous_Type => Type_Refs.Anonymous_Type,
Ada_Enum_Lit_Synth_Type_Expr => Type_Refs.Enum_Lit_Synth_Type_Expr,
Ada_Subtype_Indication => Type_Refs.Subtype_Indication,
Ada_Constrained_Subtype_Indication => Type_Refs.Constrained_Subtype_Indication,
Ada_Discrete_Subtype_Indication => Type_Refs.Discrete_Subtype_Indication,
Ada_Synthetic_Type_Expr => Type_Refs.Synthetic_Type_Expr,
Ada_Unconstrained_Array_Index => Type_Refs.Unconstrained_Array_Index,
Ada_Until_Absent => Type_Refs.Until_Absent,
Ada_Until_Present => Type_Refs.Until_Present,
Ada_Use_Package_Clause => Type_Refs.Use_Package_Clause,
Ada_Use_Type_Clause => Type_Refs.Use_Type_Clause,
Ada_Value_Sequence => Type_Refs.Value_Sequence,
Ada_Variant => Type_Refs.Variant,
Ada_Variant_Part => Type_Refs.Variant_Part,
Ada_With_Clause => Type_Refs.With_Clause,
Ada_With_Private_Absent => Type_Refs.With_Private_Absent,
Ada_With_Private_Present => Type_Refs.With_Private_Present
   );

   -----------------------
   -- Member references --
   -----------------------

   package Member_Refs is
         Aspect_Exists : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 1);
         Aspect_Node : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 2);
         Aspect_Value : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 3);
         Aspect_Inherited : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 4);
         Completion_Item_Decl : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 5);
         Completion_Item_Is_Dot_Call : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 6);
         Completion_Item_Is_Visible : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 7);
         Completion_Item_Weight : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 8);
         Discrete_Range_Low_Bound : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 9);
         Discrete_Range_High_Bound : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 10);
         Discriminant_Values_Discriminant : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 11);
         Discriminant_Values_Values : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 12);
         Doc_Annotation_Key : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 13);
         Doc_Annotation_Value : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 14);
         Param_Actual_Param : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 15);
         Param_Actual_Actual : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 16);
         Ref_Result_Ref : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 17);
         Ref_Result_Kind : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 18);
         Refd_Decl_Decl : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 19);
         Refd_Decl_Kind : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 20);
         Refd_Def_Def_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 21);
         Refd_Def_Kind : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 22);
         Shape_Components : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 23);
         Shape_Discriminants_Values : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 24);
         Substitution_From_Decl : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 25);
         Substitution_To_Value : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 26);
         Substitution_Value_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 27);
         Constrained_Array_Indices_F_List : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 28);
         Unconstrained_Array_Indices_F_Types : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 29);
         Aspect_Assoc_F_Id : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 30);
         Aspect_Assoc_F_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 31);
         At_Clause_F_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 32);
         At_Clause_F_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 33);
         Attribute_Def_Clause_F_Attribute_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 34);
         Attribute_Def_Clause_F_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 35);
         Enum_Rep_Clause_F_Type_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 36);
         Enum_Rep_Clause_F_Aggregate : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 37);
         Record_Rep_Clause_F_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 38);
         Record_Rep_Clause_F_At_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 39);
         Record_Rep_Clause_F_Components : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 40);
         Aspect_Spec_F_Aspect_Assocs : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 41);
         Contract_Case_Assoc_F_Guard : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 42);
         Contract_Case_Assoc_F_Consequence : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 43);
         Pragma_Argument_Assoc_F_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 44);
         Pragma_Argument_Assoc_F_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 45);
         Entry_Spec_F_Entry_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 46);
         Entry_Spec_F_Family_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 47);
         Entry_Spec_F_Entry_Params : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 48);
         Subp_Spec_F_Subp_Kind : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 49);
         Subp_Spec_F_Subp_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 50);
         Subp_Spec_F_Subp_Params : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 51);
         Subp_Spec_F_Subp_Returns : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 52);
         Synthetic_Binary_Spec_F_Left_Param : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 53);
         Synthetic_Binary_Spec_F_Right_Param : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 54);
         Synthetic_Binary_Spec_F_Return_Type_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 55);
         Synthetic_Unary_Spec_F_Right_Param : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 56);
         Synthetic_Unary_Spec_F_Return_Type_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 57);
         Component_List_F_Components : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 58);
         Component_List_F_Variant_Part : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 59);
         Known_Discriminant_Part_F_Discr_Specs : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 60);
         Entry_Completion_Formal_Params_F_Params : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 61);
         Generic_Formal_Part_F_Decls : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 62);
         Base_Record_Def_F_Components : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 63);
         Aggregate_Assoc_F_Designators : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 64);
         Aggregate_Assoc_F_R_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 65);
         Composite_Constraint_Assoc_F_Ids : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 66);
         Composite_Constraint_Assoc_F_Constraint_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 67);
         Iterated_Assoc_F_Spec : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 68);
         Iterated_Assoc_F_R_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 69);
         Param_Assoc_F_Designator : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 70);
         Param_Assoc_F_R_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 71);
         Basic_Decl_F_Aspects : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 72);
         Abstract_State_Decl_F_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 73);
         Anonymous_Expr_Decl_F_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 74);
         Component_Decl_F_Ids : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 75);
         Component_Decl_F_Component_Def : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 76);
         Component_Decl_F_Default_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 77);
         Discriminant_Spec_F_Ids : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 78);
         Discriminant_Spec_F_Type_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 79);
         Discriminant_Spec_F_Default_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 80);
         Generic_Formal_F_Decl : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 81);
         Param_Spec_F_Ids : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 82);
         Param_Spec_F_Has_Aliased : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 83);
         Param_Spec_F_Mode : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 84);
         Param_Spec_F_Type_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 85);
         Param_Spec_F_Default_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 86);
         Synthetic_Formal_Param_Decl_F_Param_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 87);
         Base_Package_Decl_F_Package_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 88);
         Base_Package_Decl_F_Public_Part : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 89);
         Base_Package_Decl_F_Private_Part : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 90);
         Base_Package_Decl_F_End_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 91);
         Base_Type_Decl_F_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 92);
         Subtype_Decl_F_Subtype : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 93);
         Incomplete_Type_Decl_F_Discriminants : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 94);
         Incomplete_Formal_Type_Decl_F_Is_Tagged : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 95);
         Incomplete_Formal_Type_Decl_F_Default_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 96);
         Incomplete_Tagged_Type_Decl_F_Has_Abstract : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 97);
         Protected_Type_Decl_F_Discriminants : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 98);
         Protected_Type_Decl_F_Interfaces : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 99);
         Protected_Type_Decl_F_Definition : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 100);
         Task_Type_Decl_F_Discriminants : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 101);
         Task_Type_Decl_F_Definition : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 102);
         Type_Decl_F_Discriminants : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 103);
         Type_Decl_F_Type_Def : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 104);
         Formal_Type_Decl_F_Default_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 105);
         Classic_Subp_Decl_F_Overriding : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 106);
         Classic_Subp_Decl_F_Subp_Spec : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 107);
         Formal_Subp_Decl_F_Default_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 108);
         Entry_Decl_F_Overriding : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 109);
         Entry_Decl_F_Spec : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 110);
         Enum_Literal_Decl_F_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 111);
         Generic_Subp_Internal_F_Subp_Spec : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 112);
         Synthetic_Subp_Decl_F_Spec : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 113);
         Accept_Stmt_Body_F_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 114);
         Base_Subp_Body_F_Overriding : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 115);
         Base_Subp_Body_F_Subp_Spec : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 116);
         Expr_Function_F_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 117);
         Subp_Body_F_Decls : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 118);
         Subp_Body_F_Stmts : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 119);
         Subp_Body_F_End_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 120);
         Subp_Renaming_Decl_F_Renames : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 121);
         Package_Body_Stub_F_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 122);
         Protected_Body_Stub_F_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 123);
         Subp_Body_Stub_F_Overriding : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 124);
         Subp_Body_Stub_F_Subp_Spec : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 125);
         Task_Body_Stub_F_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 126);
         Entry_Body_F_Entry_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 127);
         Entry_Body_F_Index_Spec : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 128);
         Entry_Body_F_Params : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 129);
         Entry_Body_F_Barrier : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 130);
         Entry_Body_F_Decls : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 131);
         Entry_Body_F_Stmts : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 132);
         Entry_Body_F_End_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 133);
         Package_Body_F_Package_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 134);
         Package_Body_F_Decls : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 135);
         Package_Body_F_Stmts : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 136);
         Package_Body_F_End_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 137);
         Protected_Body_F_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 138);
         Protected_Body_F_Decls : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 139);
         Protected_Body_F_End_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 140);
         Task_Body_F_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 141);
         Task_Body_F_Decls : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 142);
         Task_Body_F_Stmts : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 143);
         Task_Body_F_End_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 144);
         Entry_Index_Spec_F_Id : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 145);
         Entry_Index_Spec_F_Subtype : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 146);
         Exception_Decl_F_Ids : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 147);
         Exception_Decl_F_Renames : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 148);
         Exception_Handler_F_Exception_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 149);
         Exception_Handler_F_Handled_Exceptions : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 150);
         Exception_Handler_F_Stmts : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 151);
         For_Loop_Var_Decl_F_Id : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 152);
         For_Loop_Var_Decl_F_Id_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 153);
         Generic_Decl_F_Formal_Part : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 154);
         Generic_Package_Decl_F_Package_Decl : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 155);
         Generic_Subp_Decl_F_Subp_Decl : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 156);
         Generic_Package_Instantiation_F_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 157);
         Generic_Package_Instantiation_F_Generic_Pkg_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 158);
         Generic_Package_Instantiation_F_Params : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 159);
         Generic_Subp_Instantiation_F_Overriding : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 160);
         Generic_Subp_Instantiation_F_Kind : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 161);
         Generic_Subp_Instantiation_F_Subp_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 162);
         Generic_Subp_Instantiation_F_Generic_Subp_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 163);
         Generic_Subp_Instantiation_F_Params : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 164);
         Generic_Package_Renaming_Decl_F_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 165);
         Generic_Package_Renaming_Decl_F_Renames : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 166);
         Generic_Subp_Renaming_Decl_F_Kind : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 167);
         Generic_Subp_Renaming_Decl_F_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 168);
         Generic_Subp_Renaming_Decl_F_Renames : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 169);
         Label_Decl_F_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 170);
         Named_Stmt_Decl_F_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 171);
         Number_Decl_F_Ids : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 172);
         Number_Decl_F_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 173);
         Object_Decl_F_Ids : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 174);
         Object_Decl_F_Has_Aliased : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 175);
         Object_Decl_F_Has_Constant : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 176);
         Object_Decl_F_Mode : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 177);
         Object_Decl_F_Type_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 178);
         Object_Decl_F_Default_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 179);
         Object_Decl_F_Renaming_Clause : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 180);
         Package_Renaming_Decl_F_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 181);
         Package_Renaming_Decl_F_Renames : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 182);
         Single_Protected_Decl_F_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 183);
         Single_Protected_Decl_F_Interfaces : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 184);
         Single_Protected_Decl_F_Definition : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 185);
         Single_Task_Decl_F_Task_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 186);
         Case_Stmt_Alternative_F_Choices : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 187);
         Case_Stmt_Alternative_F_Stmts : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 188);
         Compilation_Unit_F_Prelude : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 189);
         Compilation_Unit_F_Body : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 190);
         Compilation_Unit_F_Pragmas : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 191);
         Component_Clause_F_Id : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 192);
         Component_Clause_F_Position : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 193);
         Component_Clause_F_Range : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 194);
         Component_Def_F_Has_Aliased : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 195);
         Component_Def_F_Has_Constant : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 196);
         Component_Def_F_Type_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 197);
         Composite_Constraint_F_Constraints : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 198);
         Delta_Constraint_F_Digits : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 199);
         Delta_Constraint_F_Range : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 200);
         Digits_Constraint_F_Digits : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 201);
         Digits_Constraint_F_Range : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 202);
         Range_Constraint_F_Range : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 203);
         Declarative_Part_F_Decls : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 204);
         Elsif_Expr_Part_F_Cond_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 205);
         Elsif_Expr_Part_F_Then_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 206);
         Elsif_Stmt_Part_F_Cond_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 207);
         Elsif_Stmt_Part_F_Stmts : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 208);
         Abstract_State_Decl_Expr_F_State_Decl : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 209);
         Allocator_F_Subpool : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 210);
         Allocator_F_Type_Or_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 211);
         Base_Aggregate_F_Ancestor_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 212);
         Base_Aggregate_F_Assocs : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 213);
         Bin_Op_F_Left : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 214);
         Bin_Op_F_Op : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 215);
         Bin_Op_F_Right : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 216);
         Case_Expr_Alternative_F_Choices : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 217);
         Case_Expr_Alternative_F_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 218);
         Concat_Op_F_First_Operand : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 219);
         Concat_Op_F_Other_Operands : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 220);
         Concat_Operand_F_Operator : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 221);
         Concat_Operand_F_Operand : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 222);
         Case_Expr_F_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 223);
         Case_Expr_F_Cases : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 224);
         If_Expr_F_Cond_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 225);
         If_Expr_F_Then_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 226);
         If_Expr_F_Alternatives : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 227);
         If_Expr_F_Else_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 228);
         Contract_Cases_F_Contract_Cases : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 229);
         Decl_Expr_F_Decls : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 230);
         Decl_Expr_F_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 231);
         Membership_Expr_F_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 232);
         Membership_Expr_F_Op : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 233);
         Membership_Expr_F_Membership_Exprs : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 234);
         Attribute_Ref_F_Prefix : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 235);
         Attribute_Ref_F_Attribute : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 236);
         Attribute_Ref_F_Args : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 237);
         Call_Expr_F_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 238);
         Call_Expr_F_Suffix : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 239);
         Defining_Name_F_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 240);
         Discrete_Subtype_Name_F_Subtype : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 241);
         Dotted_Name_F_Prefix : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 242);
         Dotted_Name_F_Suffix : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 243);
         End_Name_F_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 244);
         Explicit_Deref_F_Prefix : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 245);
         Qual_Expr_F_Prefix : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 246);
         Qual_Expr_F_Suffix : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 247);
         Reduce_Attribute_Ref_F_Prefix : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 248);
         Reduce_Attribute_Ref_F_Attribute : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 249);
         Reduce_Attribute_Ref_F_Args : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 250);
         Update_Attribute_Ref_F_Prefix : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 251);
         Update_Attribute_Ref_F_Attribute : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 252);
         Update_Attribute_Ref_F_Values : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 253);
         Paren_Expr_F_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 254);
         Quantified_Expr_F_Quantifier : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 255);
         Quantified_Expr_F_Loop_Spec : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 256);
         Quantified_Expr_F_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 257);
         Raise_Expr_F_Exception_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 258);
         Raise_Expr_F_Error_Message : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 259);
         Un_Op_F_Op : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 260);
         Un_Op_F_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 261);
         Handled_Stmts_F_Stmts : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 262);
         Handled_Stmts_F_Exceptions : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 263);
         Library_Item_F_Has_Private : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 264);
         Library_Item_F_Item : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 265);
         For_Loop_Spec_F_Var_Decl : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 266);
         For_Loop_Spec_F_Loop_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 267);
         For_Loop_Spec_F_Has_Reverse : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 268);
         For_Loop_Spec_F_Iter_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 269);
         For_Loop_Spec_F_Iter_Filter : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 270);
         While_Loop_Spec_F_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 271);
         Multi_Abstract_State_Decl_F_Decls : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 272);
         Params_F_Params : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 273);
         Paren_Abstract_State_Decl_F_Decl : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 274);
         Pp_Elsif_Directive_F_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 275);
         Pp_Elsif_Directive_F_Then_Kw : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 276);
         Pp_If_Directive_F_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 277);
         Pp_If_Directive_F_Then_Kw : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 278);
         Pragma_Node_F_Id : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 279);
         Pragma_Node_F_Args : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 280);
         Protected_Def_F_Public_Part : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 281);
         Protected_Def_F_Private_Part : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 282);
         Protected_Def_F_End_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 283);
         Range_Spec_F_Range : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 284);
         Renaming_Clause_F_Renamed_Object : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 285);
         Select_When_Part_F_Cond_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 286);
         Select_When_Part_F_Stmts : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 287);
         Accept_Stmt_F_Body_Decl : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 288);
         Accept_Stmt_F_Entry_Index_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 289);
         Accept_Stmt_F_Params : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 290);
         Accept_Stmt_With_Stmts_F_Stmts : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 291);
         Accept_Stmt_With_Stmts_F_End_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 292);
         Base_Loop_Stmt_F_Spec : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 293);
         Base_Loop_Stmt_F_Stmts : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 294);
         Base_Loop_Stmt_F_End_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 295);
         Begin_Block_F_Stmts : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 296);
         Begin_Block_F_End_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 297);
         Decl_Block_F_Decls : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 298);
         Decl_Block_F_Stmts : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 299);
         Decl_Block_F_End_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 300);
         Case_Stmt_F_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 301);
         Case_Stmt_F_Pragmas : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 302);
         Case_Stmt_F_Alternatives : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 303);
         Extended_Return_Stmt_F_Decl : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 304);
         Extended_Return_Stmt_F_Stmts : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 305);
         If_Stmt_F_Cond_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 306);
         If_Stmt_F_Then_Stmts : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 307);
         If_Stmt_F_Alternatives : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 308);
         If_Stmt_F_Else_Stmts : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 309);
         Named_Stmt_F_Decl : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 310);
         Named_Stmt_F_Stmt : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 311);
         Select_Stmt_F_Guards : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 312);
         Select_Stmt_F_Else_Stmts : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 313);
         Select_Stmt_F_Abort_Stmts : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 314);
         Abort_Stmt_F_Names : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 315);
         Assign_Stmt_F_Dest : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 316);
         Assign_Stmt_F_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 317);
         Call_Stmt_F_Call : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 318);
         Delay_Stmt_F_Has_Until : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 319);
         Delay_Stmt_F_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 320);
         Exit_Stmt_F_Loop_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 321);
         Exit_Stmt_F_Cond_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 322);
         Goto_Stmt_F_Label_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 323);
         Label_F_Decl : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 324);
         Raise_Stmt_F_Exception_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 325);
         Raise_Stmt_F_Error_Message : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 326);
         Requeue_Stmt_F_Call_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 327);
         Requeue_Stmt_F_Has_Abort : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 328);
         Return_Stmt_F_Return_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 329);
         Subunit_F_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 330);
         Subunit_F_Body : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 331);
         Task_Def_F_Interfaces : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 332);
         Task_Def_F_Public_Part : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 333);
         Task_Def_F_Private_Part : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 334);
         Task_Def_F_End_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 335);
         Access_Def_F_Has_Not_Null : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 336);
         Access_To_Subp_Def_F_Has_Protected : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 337);
         Access_To_Subp_Def_F_Subp_Spec : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 338);
         Anonymous_Type_Access_Def_F_Type_Decl : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 339);
         Type_Access_Def_F_Has_All : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 340);
         Type_Access_Def_F_Has_Constant : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 341);
         Type_Access_Def_F_Subtype_Indication : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 342);
         Array_Type_Def_F_Indices : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 343);
         Array_Type_Def_F_Component_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 344);
         Derived_Type_Def_F_Has_Abstract : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 345);
         Derived_Type_Def_F_Has_Limited : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 346);
         Derived_Type_Def_F_Has_Synchronized : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 347);
         Derived_Type_Def_F_Subtype_Indication : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 348);
         Derived_Type_Def_F_Interfaces : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 349);
         Derived_Type_Def_F_Record_Extension : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 350);
         Derived_Type_Def_F_Has_With_Private : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 351);
         Enum_Type_Def_F_Enum_Literals : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 352);
         Interface_Type_Def_F_Interface_Kind : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 353);
         Interface_Type_Def_F_Interfaces : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 354);
         Mod_Int_Type_Def_F_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 355);
         Private_Type_Def_F_Has_Abstract : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 356);
         Private_Type_Def_F_Has_Tagged : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 357);
         Private_Type_Def_F_Has_Limited : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 358);
         Decimal_Fixed_Point_Def_F_Delta : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 359);
         Decimal_Fixed_Point_Def_F_Digits : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 360);
         Decimal_Fixed_Point_Def_F_Range : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 361);
         Floating_Point_Def_F_Num_Digits : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 362);
         Floating_Point_Def_F_Range : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 363);
         Ordinary_Fixed_Point_Def_F_Delta : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 364);
         Ordinary_Fixed_Point_Def_F_Range : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 365);
         Record_Type_Def_F_Has_Abstract : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 366);
         Record_Type_Def_F_Has_Tagged : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 367);
         Record_Type_Def_F_Has_Limited : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 368);
         Record_Type_Def_F_Record_Def : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 369);
         Signed_Int_Type_Def_F_Range : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 370);
         Anonymous_Type_F_Type_Decl : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 371);
         Subtype_Indication_F_Has_Not_Null : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 372);
         Subtype_Indication_F_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 373);
         Subtype_Indication_F_Constraint : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 374);
         Synthetic_Type_Expr_F_Target_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 375);
         Unconstrained_Array_Index_F_Subtype_Indication : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 376);
         Use_Package_Clause_F_Packages : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 377);
         Use_Type_Clause_F_Has_All : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 378);
         Use_Type_Clause_F_Types : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 379);
         Value_Sequence_F_Iter_Assoc : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 380);
         Variant_F_Choices : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 381);
         Variant_F_Components : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 382);
         Variant_Part_F_Discr_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 383);
         Variant_Part_F_Variant : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 384);
         With_Clause_F_Has_Limited : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 385);
         With_Clause_F_Has_Private : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 386);
         With_Clause_F_Packages : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 387);
         Ada_Node_P_Declarative_Scope : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 388);
         Ada_Node_P_Enclosing_Compilation_Unit : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 389);
         Ada_Node_P_Get_Uninstantiated_Node : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 390);
         Ada_Node_P_Complete : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 391);
         Ada_Node_P_Valid_Keywords : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 392);
         Ada_Node_P_Generic_Instantiations : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 393);
         Ada_Node_P_Semantic_Parent : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 394);
         Ada_Node_P_Parent_Basic_Decl : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 395);
         Ada_Node_P_Filter_Is_Imported_By : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 396);
         Ada_Node_P_Xref_Entry_Point : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 397);
         Ada_Node_P_Resolve_Names : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 398);
         Ada_Node_P_Standard_Unit : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 399);
         Ada_Node_P_Std_Entity : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 400);
         Ada_Node_P_Bool_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 401);
         Ada_Node_P_Int_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 402);
         Ada_Node_P_Universal_Int_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 403);
         Ada_Node_P_Universal_Real_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 404);
         Ada_Node_P_Std_Char_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 405);
         Ada_Node_P_Std_Wide_Char_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 406);
         Ada_Node_P_Std_Wide_Wide_Char_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 407);
         Ada_Node_P_Top_Level_Decl : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 408);
         Ada_Node_P_Choice_Match : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 409);
         Ada_Node_P_Gnat_Xref : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 410);
         Parent : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 411);
         Parents : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 412);
         Children : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 413);
         Token_Start : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 414);
         Token_End : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 415);
         Child_Index : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 416);
         Previous_Sibling : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 417);
         Next_Sibling : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 418);
         Unit : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 419);
         Is_Ghost : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 420);
         Full_Sloc_Image : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 421);
         Abort_Node_P_As_Bool : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 422);
         Abstract_Node_P_As_Bool : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 423);
         Assoc_List_P_Zip_With_Params : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 424);
         Aliased_Node_P_As_Bool : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 425);
         All_Node_P_As_Bool : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 426);
         Aspect_Assoc_P_Is_Ghost_Code : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 427);
         Enum_Rep_Clause_P_Params : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 428);
         Base_Assoc_P_Assoc_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 429);
         Base_Formal_Param_Holder_P_Abstract_Formal_Params : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 430);
         Base_Formal_Param_Holder_P_Formal_Params : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 431);
         Base_Formal_Param_Holder_P_Nb_Min_Params : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 432);
         Base_Formal_Param_Holder_P_Nb_Max_Params : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 433);
         Base_Formal_Param_Holder_P_Param_Types : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 434);
         Base_Subp_Spec_P_Returns : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 435);
         Base_Subp_Spec_P_Params : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 436);
         Base_Subp_Spec_P_Primitive_Subp_Types : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 437);
         Base_Subp_Spec_P_Primitive_Subp_First_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 438);
         Base_Subp_Spec_P_Primitive_Subp_Tagged_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 439);
         Base_Subp_Spec_P_Return_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 440);
         Basic_Assoc_P_Get_Params : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 441);
         Basic_Decl_P_Is_Formal : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 442);
         Basic_Decl_P_Doc_Annotations : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 443);
         Basic_Decl_P_Doc : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 444);
         Basic_Decl_P_Previous_Part_For_Decl : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 445);
         Basic_Decl_P_Canonical_Part : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 446);
         Basic_Decl_P_All_Parts : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 447);
         Basic_Decl_P_Is_Static_Decl : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 448);
         Basic_Decl_P_Get_Aspect_Assoc : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 449);
         Basic_Decl_P_Get_Aspect_Spec_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 450);
         Basic_Decl_P_Get_Aspect : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 451);
         Basic_Decl_P_Has_Aspect : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 452);
         Basic_Decl_P_Get_Pragma : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 453);
         Basic_Decl_P_Get_Representation_Clause : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 454);
         Basic_Decl_P_Get_At_Clause : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 455);
         Basic_Decl_P_Is_Imported : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 456);
         Basic_Decl_P_Is_Ghost_Code : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 457);
         Basic_Decl_P_Is_Compilation_Unit_Root : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 458);
         Basic_Decl_P_Is_Visible : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 459);
         Basic_Decl_P_Base_Subp_Declarations : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 460);
         Basic_Decl_P_Root_Subp_Declarations : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 461);
         Basic_Decl_P_Find_All_Overrides : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 462);
         Basic_Decl_P_Defining_Names : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 463);
         Basic_Decl_P_Defining_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 464);
         Basic_Decl_P_Type_Expression : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 465);
         Basic_Decl_P_Subp_Spec_Or_Null : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 466);
         Basic_Decl_P_Is_Subprogram : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 467);
         Basic_Decl_P_Relative_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 468);
         Basic_Decl_P_Relative_Name_Text : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 469);
         Basic_Decl_P_Next_Part_For_Decl : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 470);
         Basic_Decl_P_Body_Part_For_Decl : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 471);
         Basic_Decl_P_Most_Visible_Part : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 472);
         Basic_Decl_P_Fully_Qualified_Name_Array : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 473);
         Basic_Decl_P_Fully_Qualified_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 474);
         Basic_Decl_P_Canonical_Fully_Qualified_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 475);
         Basic_Decl_P_Unique_Identifying_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 476);
         Basic_Decl_P_Is_Constant_Object : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 477);
         Anonymous_Expr_Decl_P_Get_Formal : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 478);
         Base_Formal_Param_Decl_P_Formal_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 479);
         Base_Package_Decl_P_Body_Part : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 480);
         Base_Type_Decl_P_Base_Subtype : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 481);
         Base_Type_Decl_P_Private_Completion : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 482);
         Base_Type_Decl_P_Is_Inherited_Primitive : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 483);
         Base_Type_Decl_P_Get_Record_Representation_Clause : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 484);
         Base_Type_Decl_P_Get_Enum_Representation_Clause : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 485);
         Base_Type_Decl_P_Is_Record_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 486);
         Base_Type_Decl_P_Is_Array_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 487);
         Base_Type_Decl_P_Find_Derived_Types : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 488);
         Base_Type_Decl_P_Is_Real_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 489);
         Base_Type_Decl_P_Is_Float_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 490);
         Base_Type_Decl_P_Is_Fixed_Point : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 491);
         Base_Type_Decl_P_Is_Scalar_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 492);
         Base_Type_Decl_P_Is_Enum_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 493);
         Base_Type_Decl_P_Is_Access_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 494);
         Base_Type_Decl_P_Specific_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 495);
         Base_Type_Decl_P_Is_Char_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 496);
         Base_Type_Decl_P_Classwide_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 497);
         Base_Type_Decl_P_Discrete_Range : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 498);
         Base_Type_Decl_P_Is_Discrete_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 499);
         Base_Type_Decl_P_Is_Int_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 500);
         Base_Type_Decl_P_Accessed_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 501);
         Base_Type_Decl_P_Is_Tagged_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 502);
         Base_Type_Decl_P_Base_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 503);
         Base_Type_Decl_P_Base_Types : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 504);
         Base_Type_Decl_P_Find_All_Derived_Types : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 505);
         Base_Type_Decl_P_Comp_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 506);
         Base_Type_Decl_P_Index_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 507);
         Base_Type_Decl_P_Is_Derived_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 508);
         Base_Type_Decl_P_Is_Interface_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 509);
         Base_Type_Decl_P_Matching_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 510);
         Base_Type_Decl_P_Canonical_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 511);
         Base_Type_Decl_P_Previous_Part : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 512);
         Base_Type_Decl_P_Next_Part : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 513);
         Base_Type_Decl_P_Full_View : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 514);
         Base_Type_Decl_P_Is_Definite_Subtype : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 515);
         Base_Type_Decl_P_Is_Private : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 516);
         Base_Type_Decl_P_Discriminants_List : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 517);
         Base_Type_Decl_P_Root_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 518);
         Base_Type_Decl_P_Shapes : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 519);
         Base_Subtype_Decl_P_Get_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 520);
         Type_Decl_P_Get_Primitives : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 521);
         Basic_Subp_Decl_P_Has_Spark_Mode_On : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 522);
         Basic_Subp_Decl_P_Subp_Decl_Spec : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 523);
         Classic_Subp_Decl_P_Body_Part : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 524);
         Entry_Decl_P_Body_Part : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 525);
         Entry_Decl_P_Accept_Stmts : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 526);
         Enum_Literal_Decl_P_Enum_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 527);
         Enum_Literal_Decl_P_Enum_Rep : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 528);
         Synthetic_Char_Enum_Lit_P_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 529);
         Body_Node_P_Previous_Part : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 530);
         Body_Node_P_Decl_Part : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 531);
         Body_Node_P_Subunit_Root : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 532);
         Base_Subp_Body_P_Is_Subject_To_Proof : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 533);
         Base_Subp_Body_P_Has_Spark_Mode_On : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 534);
         Body_Stub_P_Syntactic_Fully_Qualified_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 535);
         Generic_Package_Decl_P_Body_Part : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 536);
         Generic_Subp_Decl_P_Body_Part : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 537);
         Generic_Instantiation_P_Designated_Generic_Decl : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 538);
         Generic_Instantiation_P_Inst_Params : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 539);
         Generic_Subp_Instantiation_P_Designated_Subp : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 540);
         Object_Decl_P_Private_Part_Decl : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 541);
         Object_Decl_P_Public_Part_Decl : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 542);
         Package_Renaming_Decl_P_Renamed_Package : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 543);
         Package_Renaming_Decl_P_Final_Renamed_Package : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 544);
         Compilation_Unit_P_Syntactic_Fully_Qualified_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 545);
         Compilation_Unit_P_Unit_Kind : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 546);
         Compilation_Unit_P_Withed_Units : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 547);
         Compilation_Unit_P_Imported_Units : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 548);
         Compilation_Unit_P_Unit_Dependencies : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 549);
         Compilation_Unit_P_Decl : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 550);
         Compilation_Unit_P_Is_Preelaborable : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 551);
         Compilation_Unit_P_Other_Part : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 552);
         Compilation_Unit_P_Has_Restriction : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 553);
         Compilation_Unit_P_All_Config_Pragmas : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 554);
         Compilation_Unit_P_Config_Pragmas : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 555);
         Constant_Node_P_As_Bool : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 556);
         Composite_Constraint_P_Is_Index_Constraint : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 557);
         Composite_Constraint_P_Is_Discriminant_Constraint : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 558);
         Expr_P_Expression_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 559);
         Expr_P_Expected_Expression_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 560);
         Expr_P_Is_Dynamically_Tagged : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 561);
         Expr_P_Is_Dispatching_Call : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 562);
         Expr_P_Is_Static_Expr : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 563);
         Expr_P_First_Corresponding_Decl : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 564);
         Expr_P_Eval_As_Int : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 565);
         Expr_P_Eval_As_Int_In_Env : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 566);
         Expr_P_Eval_As_String : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 567);
         Expr_P_Eval_As_String_In_Env : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 568);
         Expr_P_Matching_Nodes : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 569);
         Allocator_P_Get_Allocated_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 570);
         Base_Aggregate_P_Aggregate_Params : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 571);
         Base_Aggregate_P_Is_Subaggregate : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 572);
         Concat_Op_P_Operands : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 573);
         Cond_Expr_P_Dependent_Exprs : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 574);
         Name_P_Enclosing_Defining_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 575);
         Name_P_Is_Defining : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 576);
         Name_P_Name_Is : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 577);
         Name_P_Is_Direct_Call : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 578);
         Name_P_Is_Access_Call : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 579);
         Name_P_Is_Call : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 580);
         Name_P_Is_Dot_Call : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 581);
         Name_P_Failsafe_Referenced_Def_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 582);
         Name_P_Referenced_Defining_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 583);
         Name_P_All_Env_Elements : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 584);
         Name_P_Called_Subp_Spec : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 585);
         Name_P_Referenced_Decl : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 586);
         Name_P_Failsafe_Referenced_Decl : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 587);
         Name_P_Name_Designated_Type : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 588);
         Name_P_Is_Static_Subtype : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 589);
         Name_P_Name_Matches : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 590);
         Name_P_Relative_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 591);
         Name_P_Is_Operator_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 592);
         Name_P_Is_Write_Reference : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 593);
         Name_P_Is_Static_Call : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 594);
         Name_P_As_Symbol_Array : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 595);
         Name_P_Canonical_Text : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 596);
         Name_P_Is_Constant : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 597);
         Name_P_Call_Params : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 598);
         Call_Expr_P_Kind : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 599);
         Call_Expr_P_Is_Array_Slice : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 600);
         Defining_Name_P_Canonical_Fully_Qualified_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 601);
         Defining_Name_P_Unique_Identifying_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 602);
         Defining_Name_P_Fully_Qualified_Name_Array : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 603);
         Defining_Name_P_Fully_Qualified_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 604);
         Defining_Name_P_Basic_Decl : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 605);
         Defining_Name_P_Find_Refs : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 606);
         Defining_Name_P_Find_All_References : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 607);
         Defining_Name_P_Find_All_Calls : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 608);
         Defining_Name_P_Next_Part : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 609);
         Defining_Name_P_Previous_Part : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 610);
         Defining_Name_P_Canonical_Part : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 611);
         Defining_Name_P_Most_Visible_Part : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 612);
         Defining_Name_P_All_Parts : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 613);
         Defining_Name_P_Get_Aspect : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 614);
         Defining_Name_P_Has_Aspect : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 615);
         Defining_Name_P_Get_Pragma : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 616);
         Defining_Name_P_Get_Representation_Clause : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 617);
         Defining_Name_P_Get_At_Clause : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 618);
         Defining_Name_P_Is_Imported : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 619);
         Defining_Name_P_Is_Ghost_Code : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 620);
         End_Name_P_Basic_Decl : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 621);
         Char_Literal_P_Denoted_Value : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 622);
         String_Literal_P_Denoted_Value : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 623);
         Int_Literal_P_Denoted_Value : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 624);
         Limited_Node_P_As_Bool : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 625);
         Not_Null_P_As_Bool : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 626);
         Pragma_Node_P_Is_Ghost_Code : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 627);
         Pragma_Node_P_Associated_Entities : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 628);
         Private_Node_P_As_Bool : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 629);
         Protected_Node_P_As_Bool : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 630);
         Reverse_Node_P_As_Bool : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 631);
         Stmt_P_Is_Ghost_Code : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 632);
         Accept_Stmt_P_Corresponding_Entry : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 633);
         Subunit_P_Body_Root : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 634);
         Synchronized_Node_P_As_Bool : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 635);
         Tagged_Node_P_As_Bool : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 636);
         Type_Expr_P_Type_Name : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 637);
         Type_Expr_P_Designated_Type_Decl : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 638);
         Type_Expr_P_Designated_Type_Decl_From : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 639);
         Subtype_Indication_P_Subtype_Constraints : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 640);
         Subtype_Indication_P_Is_Static_Subtype : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 641);
         Until_Node_P_As_Bool : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 642);
         With_Private_P_As_Bool : constant G.Struct_Member_Ref :=
           G.From_Index (Self_Id, 643);
   end Member_Refs;

end Libadalang.Generic_API.Introspection;
