/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.arara.core.session;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import org.islandoftex.arara.api.AraraException;
import org.islandoftex.arara.api.session.Command;
import org.islandoftex.arara.core.localization.LanguageController;
import org.islandoftex.arara.core.session.Environment;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.listener.ShutdownHookProcessDestroyer;
import org.zeroturnaround.exec.stream.TeeOutputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0010H\u0007J=\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00100\u00152\u0006\u0010\u0011\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u00062\b\b\u0002\u0010\u0018\u001a\u00020\u0019H\u0007\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0018\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u0010H\u0007J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001d\u001a\u00020\u0010H\u0007J\u0010\u0010 \u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0010H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006!"}, d2={"Lorg/islandoftex/arara/core/session/Environment;", "", "()V", "errorExitStatus", "", "inCygwinEnvironment", "", "getInCygwinEnvironment", "()Z", "inCygwinEnvironment$delegate", "Lkotlin/Lazy;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "appendExtensions", "", "", "command", "checkOS", "value", "executeSystemCommand", "Lkotlin/Pair;", "Lorg/islandoftex/arara/api/session/Command;", "silenceSystemOut", "timeout", "Lkotlin/time/Duration;", "executeSystemCommand-SxA4cEA", "(Lorg/islandoftex/arara/api/session/Command;ZJ)Lkotlin/Pair;", "getSystemProperty", "key", "fallback", "getSystemPropertyOrNull", "isOnPath", "core"})
public final class Environment {
    @NotNull
    public static final Environment INSTANCE = new Environment();
    private static final Logger logger = LoggerFactory.getLogger(Environment.class);
    @NotNull
    private static final Lazy inCygwinEnvironment$delegate = LazyKt.lazy(inCygwinEnvironment.2.INSTANCE);
    public static final int errorExitStatus = -99;

    private Environment() {
    }

    @JvmStatic
    @NotNull
    public static final String getSystemProperty(@NotNull String key, @NotNull String fallback) {
        Object object;
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(fallback, "fallback");
        Object object2 = System.getProperties();
        try {
            String string;
            Properties $this$getSystemProperty_u24lambda_u2d1 = object2;
            boolean bl = false;
            String it = string = $this$getSystemProperty_u24lambda_u2d1.getOrDefault((Object)key, fallback).toString();
            boolean bl2 = false;
            object = Result.constructor-impl(!Intrinsics.areEqual(it, "") ? string : null);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl(ResultKt.createFailure(throwable));
        }
        object2 = object;
        String string = (String)(Result.isFailure-impl(object2) ? null : object2);
        return string == null ? fallback : string;
    }

    @JvmStatic
    @Nullable
    public static final String getSystemPropertyOrNull(@NotNull String key) {
        Object object;
        Intrinsics.checkNotNullParameter(key, "key");
        Object object2 = System.getProperties();
        try {
            Properties $this$getSystemPropertyOrNull_u24lambda_u2d2 = object2;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue($this$getSystemPropertyOrNull_u24lambda_u2d2, "");
            object = Result.constructor-impl(MapsKt.getValue($this$getSystemPropertyOrNull_u24lambda_u2d2, key).toString());
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl(ResultKt.createFailure(throwable));
        }
        object2 = object;
        return (String)(Result.isFailure-impl(object2) ? null : object2);
    }

    private final boolean getInCygwinEnvironment() {
        Lazy lazy = inCygwinEnvironment$delegate;
        return (Boolean)lazy.getValue();
    }

    @JvmStatic
    public static final boolean checkOS(@NotNull String value) throws AraraException {
        Intrinsics.checkNotNullParameter(value, "value");
        Map values2 = new LinkedHashMap();
        values2.put("windows", Environment.checkOS$checkOSProperty("Windows"));
        values2.put("linux", Environment.checkOS$checkOSProperty("Linux"));
        values2.put("mac", Environment.checkOS$checkOSProperty("Mac OS X"));
        values2.put("unix", Environment.checkOS$checkOSProperty("Mac OS X") || Environment.checkOS$checkOSProperty("Linux"));
        values2.put("cygwin", INSTANCE.getInCygwinEnvironment());
        Object[] objectArray = value.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(objectArray, "this as java.lang.String).toLowerCase(Locale.ROOT)");
        if (!values2.containsKey(objectArray)) {
            objectArray = new Object[]{value};
            String string = String.format(LanguageController.getMessages().getERROR_CHECKOS_INVALID_OPERATING_SYSTEM(), Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string, "format(this, *args)");
            throw new AraraException(string);
        }
        objectArray = value.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(objectArray, "this as java.lang.String).toLowerCase(Locale.ROOT)");
        return (Boolean)MapsKt.getValue(values2, objectArray);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> appendExtensions(String command) {
        void $this$mapTo$iv$iv;
        List<String> list;
        if (Environment.checkOS("windows")) {
            String[] stringArray = new String[]{".com", ".exe", ".bat", ".cmd"};
            list = CollectionsKt.listOf(stringArray);
        } else {
            list = CollectionsKt.listOf("");
        }
        List<String> extensions = list;
        Iterable $this$map$iv = extensions;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Intrinsics.stringPlus(command, it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final boolean isOnPath(@NotNull String command) {
        Object object;
        Intrinsics.checkNotNullParameter(command, "command");
        List<String> filenames = INSTANCE.appendExtensions(command);
        try {
            Boolean bl;
            Object v3;
            block8: {
                void $this$firstOrNull$iv;
                boolean bl2 = false;
                String[] stringArray = System.getenv("PATH");
                if (stringArray == null) {
                    stringArray = System.getenv("Path");
                }
                Object object2 = stringArray;
                Intrinsics.checkNotNullExpressionValue(object2, "System.getenv(\"PATH\") ?: System.getenv(\"Path\")");
                CharSequence charSequence = (CharSequence)object2;
                object2 = new String[1];
                String string = File.pathSeparator;
                Intrinsics.checkNotNullExpressionValue(string, "pathSeparator");
                object2[0] = string;
                object2 = SequencesKt.mapNotNull(CollectionsKt.asSequence(StringsKt.split$default(charSequence, object2, false, 0, 6, null)), isOnPath.1.1.INSTANCE);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    boolean bl3;
                    block7: {
                        File[] it = (File[])element$iv;
                        boolean bl4 = false;
                        File[] $this$any$iv = it;
                        boolean $i$f$any = false;
                        for (File element$iv2 : $this$any$iv) {
                            File file2 = element$iv2;
                            boolean bl5 = false;
                            if (!(filenames.contains(file2.getName()) && !file2.isDirectory())) continue;
                            bl3 = true;
                            break block7;
                        }
                        bl3 = false;
                    }
                    if (!bl3) continue;
                    v3 = element$iv;
                    break block8;
                }
                v3 = null;
            }
            File[] fileArray = v3;
            if (fileArray == null) {
                bl = null;
            } else {
                File[] it = fileArray;
                boolean bl6 = false;
                bl = true;
            }
            object = Result.constructor-impl(bl);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl(ResultKt.createFailure(throwable));
        }
        Boolean bl = (Boolean)(Result.isFailure-impl(object) ? null : object);
        return bl == null ? false : bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @NotNull
    public static final Pair<Integer, String> executeSystemCommand-SxA4cEA(@NotNull Command command, boolean silenceSystemOut, long timeout) {
        Pair pair2;
        Intrinsics.checkNotNullParameter(command, "command");
        Closeable closeable = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            Pair<Integer, String> pair3;
            Object object;
            ByteArrayOutputStream buffer = (ByteArrayOutputStream)closeable;
            boolean bl = false;
            Pair<Integer, String> pair4 = new ProcessExecutor(command.getElements());
            try {
                OutputStream outputStream2;
                ProcessExecutor $this$executeSystemCommand_SxA4cEA_u24lambda_u2d10_u24lambda_u2d8 = pair4;
                boolean bl2 = false;
                $this$executeSystemCommand_SxA4cEA_u24lambda_u2d10_u24lambda_u2d8.addDestroyer(new ShutdownHookProcessDestroyer());
                Path path2 = command.getWorkingDirectory();
                Path workingDirectory = path2 == null ? Paths.get("", new String[0]) : path2;
                $this$executeSystemCommand_SxA4cEA_u24lambda_u2d10_u24lambda_u2d8.directory(workingDirectory.toFile().getAbsoluteFile());
                if (silenceSystemOut) {
                    outputStream2 = buffer;
                } else {
                    $this$executeSystemCommand_SxA4cEA_u24lambda_u2d10_u24lambda_u2d8.redirectInput(System.in);
                    outputStream2 = new TeeOutputStream(System.out, buffer);
                }
                OutputStream tee = outputStream2;
                $this$executeSystemCommand_SxA4cEA_u24lambda_u2d10_u24lambda_u2d8.redirectOutput(tee).redirectError(tee);
                if (!Duration.equals-impl0(timeout, Duration.Companion.getZERO-UwyO8pc())) {
                    $this$executeSystemCommand_SxA4cEA_u24lambda_u2d10_u24lambda_u2d8.timeout(Duration.getInWholeNanoseconds-impl(timeout), TimeUnit.NANOSECONDS);
                }
                object = Result.constructor-impl(TuplesKt.to($this$executeSystemCommand_SxA4cEA_u24lambda_u2d10_u24lambda_u2d8.execute().getExitValue(), buffer.toString()));
            }
            catch (Throwable $this$executeSystemCommand_SxA4cEA_u24lambda_u2d10_u24lambda_u2d8) {
                object = Result.constructor-impl(ResultKt.createFailure($this$executeSystemCommand_SxA4cEA_u24lambda_u2d10_u24lambda_u2d8));
            }
            pair4 = object;
            Throwable throwable2 = Result.exceptionOrNull-impl(pair4);
            if (throwable2 == null) {
                pair3 = pair4;
            } else {
                Throwable it = throwable2;
                boolean bl3 = false;
                logger.debug("Caught an exception when executing " + command + " returning -99");
                pair3 = TuplesKt.to(-99, it.getClass().getName() + ": " + it.getMessage());
            }
            pair2 = pair3;
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        return pair2;
    }

    public static /* synthetic */ Pair executeSystemCommand-SxA4cEA$default(Command command, boolean bl, long l, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            l = Duration.Companion.getZERO-UwyO8pc();
        }
        return Environment.executeSystemCommand-SxA4cEA(command, bl, l);
    }

    private static final boolean checkOS$checkOSProperty(String key) {
        boolean bl;
        String string = Environment.getSystemPropertyOrNull("os.name");
        if (string == null) {
            bl = false;
        } else {
            boolean bl2;
            String string2 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).toLowerCase(Locale.ROOT)");
            String string3 = string2;
            String string4 = key.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string4, "this as java.lang.String).toLowerCase(Locale.ROOT)");
            bl = bl2 = StringsKt.startsWith$default(string3, string4, false, 2, null);
        }
        return bl;
    }
}

