
#ifndef KDNSSD_EXPORT_H
#define KDNSSD_EXPORT_H

#ifdef KDNSSD_STATIC_DEFINE
#  define KDNSSD_EXPORT
#  define KDNSSD_NO_EXPORT
#else
#  ifndef KDNSSD_EXPORT
#    ifdef KF6DNSSD_EXPORTS
        /* We are building this library */
#      define KDNSSD_EXPORT __declspec(dllexport)
#    else
        /* We are using this library */
#      define KDNSSD_EXPORT __declspec(dllimport)
#    endif
#  endif

#  ifndef KDNSSD_NO_EXPORT
#    define KDNSSD_NO_EXPORT 
#  endif
#endif

#ifndef KDNSSD_DECL_DEPRECATED
#  define KDNSSD_DECL_DEPRECATED __declspec(deprecated)
#endif

#ifndef KDNSSD_DECL_DEPRECATED_EXPORT
#  define KDNSSD_DECL_DEPRECATED_EXPORT KDNSSD_EXPORT KDNSSD_DECL_DEPRECATED
#endif

#ifndef KDNSSD_DECL_DEPRECATED_NO_EXPORT
#  define KDNSSD_DECL_DEPRECATED_NO_EXPORT KDNSSD_NO_EXPORT KDNSSD_DECL_DEPRECATED
#endif

#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KDNSSD_NO_DEPRECATED
#    define KDNSSD_NO_DEPRECATED
#  endif
#endif
#include <kdnssd_version.h>

#define KDNSSD_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

/* Take any defaults from group settings */
#if !defined(KDNSSD_NO_DEPRECATED) && !defined(KDNSSD_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define KDNSSD_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define KDNSSD_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(KDNSSD_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define KDNSSD_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(KDNSSD_NO_DEPRECATED_WARNINGS) && !defined(KDNSSD_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define KDNSSD_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define KDNSSD_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(KDNSSD_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define KDNSSD_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(KDNSSD_NO_DEPRECATED)
#  undef KDNSSD_DEPRECATED
#  define KDNSSD_DEPRECATED_EXPORT KDNSSD_EXPORT
#  define KDNSSD_DEPRECATED_NO_EXPORT KDNSSD_NO_EXPORT
#elif defined(KDNSSD_NO_DEPRECATED_WARNINGS)
#  define KDNSSD_DEPRECATED
#  define KDNSSD_DEPRECATED_EXPORT KDNSSD_EXPORT
#  define KDNSSD_DEPRECATED_NO_EXPORT KDNSSD_NO_EXPORT
#else
#  define KDNSSD_DEPRECATED KDNSSD_DECL_DEPRECATED
#  define KDNSSD_DEPRECATED_EXPORT KDNSSD_DECL_DEPRECATED_EXPORT
#  define KDNSSD_DEPRECATED_NO_EXPORT KDNSSD_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KDNSSD_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KDNSSD_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KDNSSD_NO_DEPRECATED
#  define KDNSSD_DISABLE_DEPRECATED_BEFORE_AND_AT KDNSSD_VERSION
#endif
#ifdef KDNSSD_NO_DEPRECATED_WARNINGS
#  define KDNSSD_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KDNSSD_DEPRECATED_WARNINGS_SINCE
#  ifdef KDNSSD_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KDNSSD_DEPRECATED_WARNINGS_SINCE KDNSSD_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KDNSSD_DEPRECATED_WARNINGS_SINCE KDNSSD_VERSION
#  endif
#endif

#ifndef KDNSSD_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KDNSSD_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KDNSSD_DEPRECATED
#  define KDNSSD_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > KDNSSD_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KDNSSD_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#endif /* KDNSSD_EXPORT_H */
