#ifndef _CGWRAP_H
#define _CGWRAP_H   1
///////////////////////////////////////////////////////////////////////////////
//                                                         
// cgwrap.h
// --------
// Cego C wrapper API
//                                               
// Design and Implementation by Bjoern Lemke               
//                                                         
// (C)opyright 2000-2019 Bjoern Lemke
//
// Description: This is a wrapper module which implements a plain C client interface to the
//              cego database system
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

#ifdef  __cplusplus
#include <lfcbase/Logger.h>
#include <lfcbase/NetHandler.h>

#include "CegoDefs.h"
#include "CegoDbHandler.h"
#endif

#define CG_INT      1
#define CG_VARCHAR  2
#define CG_LONG     3
#define CG_BOOL     4
#define CG_DATETIME 5
#define CG_BIGINT   6
#define CG_FLOAT    7
#define CG_DOUBLE   8
#define CG_DECIMAL  9
#define CG_FIXED    10
#define CG_SMALLINT 11
#define CG_TINYINT  12
#define CG_BLOB     13
#define CG_CLOB     13
#define CG_NULL     100

#define CG_LOG_ERROR 1
#define CG_LOG_NOTICE 2
#define CG_LOG_DEBUG 3

extern char cgerrmsg[];

typedef struct CegoDBHandle
#ifdef  __cplusplus
{
    CegoModule *pModule;
    NetHandler *pNet;
    CegoDbHandler *pDB;
} 
#endif
CGDB;

typedef struct CegoFetchHandle
#ifdef  __cplusplus
{
    CGDB *cgdb;
    bool isActive;
    ListT<CegoField> *pSchema;
} 
#endif
CGFetch;

typedef struct CegoValue
{
    int type;
    int len;
    void *val;
} CGVal;

typedef struct CegoBlobValue
{
    PageIdType pageId;
    int len;
    unsigned char *buf;
} CGBlob;

#ifdef  __cplusplus
class CegoBindValue
{
public:
    
    enum BindType { BINDIN, BINDOUT, BINDINOUT };
    
    int pos;
    CGVal* cgval;
    BindType type;

    CegoBindValue() {}
    CegoBindValue(int p)
    {
	pos = p;
    }
    
    CegoBindValue& operator = ( const CegoBindValue& bv)
    {
	pos = bv.pos;
	cgval = bv.cgval;
        type = bv.type;
	return (*this);
    }
    bool operator == ( const CegoBindValue& bv)
    {
	if ( pos == bv.pos )
	    return true;
	return false;
    }
};
#endif

typedef struct CegoStatement
#ifdef  __cplusplus
{
    int numParams;
    bool isOut;
    ListT<Chain> *pStmtChunks;
    ListT<CegoBindValue> *pParamList;
} 
#endif
CGStmt;

#ifdef  __cplusplus
extern "C" {
#endif

    void cego_modlog(char* module, int level);
    
    CGDB* cego_connect(char *servername, int portno, char *prot, char *tsname, char *user, char *pass, char* logfile);
    void cego_disconnect (CGDB *cgdb);

    CGFetch* cego_allocate_fetch();
    void cego_free_fetch(CGFetch *cgfetch);
    int cego_num_col(CGFetch* cgfetch);
    int cego_getpos(CGFetch* cgfetch, char* attr);
    char* cego_getcol(CGFetch* cgfetch, int pos);
    
    CGStmt* cego_prepare (char* stmt);
    int cego_bind_in (CGStmt* cgstmt, CGVal* cgval, int pos);
    int cego_bind_out (CGStmt* cgstmt, CGVal* cgval, int pos);
    int cego_bind_inout (CGStmt* cgstmt, CGVal* cgval, int pos);

    int cego_execute (CGDB *cgdb, CGStmt* cgstmt, CGFetch* cgfetch);

    void cego_free_stmt(CGStmt* cgstmt);
    
    int cego_query (CGDB* cgdb, char* stmt, CGFetch* cgfetch);
    

    int cego_fetch (CGFetch* cgfetch, CGVal cgval[], int numCol);
    int cego_abort (CGFetch* cgfetch);
    int cego_reset (CGFetch* cgfetch);

    int cego_putblob (CGDB *cgdb, CGBlob* cgblob);
    int cego_getblob (CGDB *cgdb, CGBlob* cgblob);
    int cego_delblob (CGDB *cgdb, CGBlob* cgblob);

    char* cego_error ();
#ifdef  __cplusplus
}
#endif

#endif 

