/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.BDFileSystemImpl;
import java.io.File;
import java.io.FileSystem;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import org.videolan.BDJXletContext;
import org.videolan.Logger;

public abstract class BDFileSystem
extends FileSystem {
    private static final Logger logger = Logger.getLogger(BDFileSystem.class.getName());
    protected final FileSystem fs;

    public static void init(Class c) {
        try {
            Field filesystem = c.getDeclaredField("fs");
            filesystem.setAccessible(true);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(filesystem, filesystem.getModifiers() & 0xFFFFFFEF);
            FileSystem fs = (FileSystem)filesystem.get(null);
            if (!(fs instanceof BDFileSystemImpl)) {
                filesystem.set(null, new BDFileSystemImpl(fs));
            }
        }
        catch (Throwable t) {
            System.err.print("Hooking FileSystem class failed: " + t);
        }
    }

    public BDFileSystem(FileSystem fs) {
        this.fs = fs;
    }

    public char getSeparator() {
        return this.fs.getSeparator();
    }

    public char getPathSeparator() {
        return this.fs.getPathSeparator();
    }

    public String normalize(String pathname) {
        return this.fs.normalize(pathname);
    }

    public int prefixLength(String pathname) {
        return this.fs.prefixLength(pathname);
    }

    public String resolve(String parent, String child) {
        return this.fs.resolve(parent, child);
    }

    public String getDefaultParent() {
        return this.fs.getDefaultParent();
    }

    public String fromURIPath(String path) {
        return this.fs.fromURIPath(path);
    }

    public boolean isAbsolute(File f) {
        return this.fs.isAbsolute(f);
    }

    public String resolve(File f) {
        if (!f.isAbsolute()) {
            System.err.println("***** resolve " + f + " -> " + this.fs.resolve(f));
        }
        return this.fs.resolve(f);
    }

    public String canonicalize(String path) throws IOException {
        return this.fs.canonicalize(path);
    }

    public int getBooleanAttributes(File f) {
        if (f.isAbsolute()) {
            return this.fs.getBooleanAttributes(f);
        }
        URL url = BDJXletContext.getCurrentResource(f.getPath());
        if (url == null) {
            return 0;
        }
        logger.info("Relative path " + f.getPath() + " translated to " + url);
        return 1;
    }

    public long getLastModifiedTime(File f) {
        return this.fs.getLastModifiedTime(f);
    }

    public long getLength(File f) {
        return this.fs.getLength(f);
    }

    public boolean createFileExclusively(String path, boolean restrictive) throws IOException {
        return this.createFileExclusivelyImpl(path, restrictive);
    }

    public boolean createFileExclusively(String path) throws IOException {
        return this.createFileExclusivelyImpl(path, false);
    }

    private boolean createFileExclusivelyImpl(String path, boolean restrictive) throws IOException {
        Object[] args;
        Method m;
        try {
            try {
                m = this.fs.getClass().getDeclaredMethod("createFileExclusively", String.class);
                args = new Object[]{path};
            }
            catch (NoSuchMethodException e) {
                m = this.fs.getClass().getDeclaredMethod("createFileExclusively", String.class, Boolean.TYPE);
                args = new Object[]{path, new Boolean(restrictive)};
            }
        }
        catch (NoSuchMethodException e) {
            logger.error("no matching FileSystem.createFileExclusively found !");
            throw new IOException();
        }
        try {
            Boolean result = (Boolean)m.invoke((Object)this.fs, args);
            return result;
        }
        catch (IllegalAccessException e) {
            logger.error("" + e);
            throw new IOException();
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            logger.error("" + t);
            throw new IOException();
        }
    }

    public boolean delete(File f) {
        return this.fs.delete(f);
    }

    public String[] list(File f) {
        return this.fs.list(f);
    }

    public boolean createDirectory(File f) {
        return this.fs.createDirectory(f);
    }

    public boolean rename(File f1, File f2) {
        return this.fs.rename(f1, f2);
    }

    public boolean setLastModifiedTime(File f, long time) {
        return this.fs.setLastModifiedTime(f, time);
    }

    public boolean setReadOnly(File f) {
        return this.fs.setReadOnly(f);
    }

    public File[] listRoots() {
        return this.fs.listRoots();
    }

    public int compare(File f1, File f2) {
        return this.fs.compare(f1, f2);
    }

    public int hashCode(File f) {
        return this.fs.hashCode(f);
    }
}

