/*
 * Decompiled with CFR 0.152.
 */
package esecurity.crypto.gui.utils;

import esecurity.crypto.gui.beans.RemoteCertificateListHandler;
import esecurity.crypto.gui.functionality.ValidationFacade;
import esecurity.crypto.gui.model.signer.RemoteSigner;
import esecurity.crypto.gui.properties.ClientProperties;
import esecurity.crypto.gui.properties.ServerProperties;
import esecurity.validator.bean.ValidatedCertificate;
import esecurity.validator.constants.ValidationProfile;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.TokenHelper;
import it.actalis.ellips.capi.core.TokenParameters;
import it.actalis.ellips.capi.core.TokenSpi;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.logging.EllipsLogger;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.rs.RemoteHsmIdentity;
import it.actalis.ellips.capi.rs.RemoteHsmInitializeParameters;
import it.actalis.vol.utils.Constants;
import it.arubapec.ca.provider.remotesign.ASUtils;
import it.arubapec.ca.utils.UserData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class RemoteSignatureHandler {
    private static final EllipsLogger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private static final List<String> b = new ArrayList<String>();
    private static final List<Runnable> c = new ArrayList<Runnable>();
    private static RemoteState d = RemoteState.NOT_LOGGED;
    private static String e;
    private static String f;
    private static UserData g;
    private static boolean h;
    private static boolean i;

    public static RemoteState getState() {
        return d;
    }

    public static String getLoggedUser() {
        return e;
    }

    public static String getLoggedUserPassword() {
        return f;
    }

    public static List<String> getUsers() {
        return b;
    }

    public static void addUser(String string) {
        if (!string.isEmpty() && b.add(string)) {
            c.forEach(runnable -> new Thread((Runnable)runnable).start());
        }
    }

    public static void removeUser(String string) {
        if (b.remove(string)) {
            c.forEach(runnable -> new Thread((Runnable)runnable).start());
        }
    }

    public static void addUsersListeners(Runnable runnable) {
        c.add(runnable);
    }

    public static boolean hasArubaCall() {
        return h;
    }

    public static boolean hasArubaSms() {
        return i;
    }

    public static void login(String stringArray, String string) throws Exception {
        ClientProperties clientProperties = ClientProperties.getInstance();
        if (string == null || string.equals("") || stringArray == null || stringArray.equals("")) {
            return;
        }
        a.info("Try to call ASUtils.checkPassword");
        a.info("Url1 = " + clientProperties.get(ServerProperties.REMOTE_SIGNATURE_SERVER_1, ""));
        a.info("Url2 = " + clientProperties.get(ServerProperties.REMOTE_SIGNATURE_SERVER_2, ""));
        a.info("Username = " + (String)stringArray);
        a.info("Domain = " + clientProperties.get(ServerProperties.REMOTE_SIGNATURE_DOMAIN, "firma"));
        g = new UserData();
        g.setDomain(clientProperties.get(ServerProperties.REMOTE_SIGNATURE_DOMAIN, "firma"));
        g.setUsername((String)stringArray);
        g.setPassword(string);
        if ("true".equals(clientProperties.get(ServerProperties.USE_DSD, "true"))) {
            clientProperties.remove(ServerProperties.REMOTE_SIGNATURE_SERVER_1, ClientProperties.Priority.FILE);
            clientProperties.remove(ServerProperties.REMOTE_SIGNATURE_SERVER_2, ClientProperties.Priority.FILE);
        }
        g.setServerUrl1(clientProperties.get(ServerProperties.REMOTE_SIGNATURE_SERVER_1, ""));
        g.setServerUrl2(clientProperties.get(ServerProperties.REMOTE_SIGNATURE_SERVER_2, ""));
        ASUtils.userStatus((UserData)g, (NetworkConfig)clientProperties.getNetworkConfig());
        RemoteCertificateListHandler.getInstance().clear();
        List<RemoteSigner> object2 = RemoteSignatureHandler.a((String)stringArray, string);
        RemoteCertificateListHandler.getInstance().addAll(object2);
        d = RemoteState.LOGGED;
        e = stringArray;
        f = string;
        stringArray = ASUtils.auth_methods((UserData)g, (NetworkConfig)clientProperties.getNetworkConfig(), null);
        if (stringArray == null || stringArray.length <= 0) {
            return;
        }
        for (String string2 : stringArray) {
            if (string2.equals("ARUBACALL")) {
                h = true;
            }
            if (!string2.equals("SMS")) continue;
            i = true;
        }
    }

    public static String sendCredentials(CredentialType credentialType) {
        switch (credentialType) {
            case CALL: {
                return ASUtils.sendCred((UserData)g, (NetworkConfig)ClientProperties.getInstance().getNetworkConfig(), (String)"ARUBACALL");
            }
            case SMS: {
                return ASUtils.sendCred((UserData)g, (NetworkConfig)ClientProperties.getInstance().getNetworkConfig(), (String)"SMS");
            }
        }
        return "";
    }

    private static List<RemoteSigner> a(String string, String stringArray) throws IOException {
        if (string == null || string.isEmpty() || stringArray == null || stringArray.isEmpty() || stringArray.equals("-1")) {
            return new ArrayList<RemoteSigner>();
        }
        ArrayList<RemoteSigner> arrayList = new ArrayList<RemoteSigner>();
        try {
            ClientProperties clientProperties = ClientProperties.getInstance();
            RemoteHsmInitializeParameters remoteHsmInitializeParameters = new RemoteHsmInitializeParameters();
            remoteHsmInitializeParameters.setNetworkConfig(clientProperties.getNetworkConfig());
            Object object = new RemoteHsmIdentity();
            remoteHsmInitializeParameters.setUrl1(clientProperties.get(ServerProperties.REMOTE_SIGNATURE_SERVER_1, ""));
            remoteHsmInitializeParameters.setUrl2(clientProperties.get(ServerProperties.REMOTE_SIGNATURE_SERVER_2, ""));
            remoteHsmInitializeParameters.setIdentity(object);
            object.setUserid(string + "@" + clientProperties.get(ServerProperties.REMOTE_SIGNATURE_DOMAIN, ""));
            object.setPassword((String)stringArray);
            remoteHsmInitializeParameters.setEnforceMode(ClientProperties.getInstance().getNetworkConfig().getEnforceMode() != null && ClientProperties.getInstance().getNetworkConfig().getEnforceMode().equals("V"));
            string = TokenHelper.initToken((String)"RemoteSignatureTokenV2", (TokenParameters)remoteHsmInitializeParameters);
            TokenHelper.openPublicSession((TokenSpi)string);
            String[] stringArray2 = TokenHelper.listObjects((TokenSpi)string, null, (byte)18);
            stringArray = stringArray2;
            stringArray = stringArray2;
            int n = stringArray2.length;
            for (int i = 0; i < n; ++i) {
                object = stringArray[i];
                String string2 = TokenHelper.getCertificate((TokenSpi)string, (String)object);
                string2 = new Certificate(string2.getBytes());
                a.info("Start remote signature cert validation");
                string2 = ValidationFacade.verifyCertificate((Certificate)string2, ValidationProfile.QUALIFIED_ELECTRONIC_SIGNATURE_PROFILE, null);
                a.info("Certificate validated");
                arrayList.add(new RemoteSigner((TokenSpi)string, (String)object, (ValidatedCertificate)string2));
            }
            TokenHelper.logout((TokenSpi)string);
        }
        catch (CapiException capiException) {
            a.error(capiException.getMessage(), (Throwable)capiException);
            throw new IOException(capiException);
        }
        catch (Throwable throwable) {
            a.error(throwable.getMessage(), throwable);
        }
        return arrayList;
    }

    public static void logout() {
        RemoteCertificateListHandler.getInstance().clear();
        d = RemoteState.NOT_LOGGED;
        e = null;
        f = null;
        h = false;
        i = false;
        g = null;
    }

    static {
        g = null;
        h = false;
        i = false;
    }

    public static enum CredentialType {
        CALL,
        SMS;

    }

    public static enum RemoteState {
        LOGGED,
        NOT_LOGGED;

    }
}

