/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.mc;

import org.sqlite.mc.CipherAlgorithm;
import org.sqlite.mc.SQLiteMCConfig;

public class SQLiteMCChacha20Config
extends SQLiteMCConfig.Builder {
    public SQLiteMCChacha20Config() {
        this.setCipher(CipherAlgorithm.CHACHA20);
    }

    @Override
    public SQLiteMCChacha20Config setLegacy(int value) {
        assert (this.isValid(value, 0, 4));
        super.setLegacy(value);
        return this;
    }

    @Override
    public SQLiteMCChacha20Config setLegacyPageSize(int value) {
        assert (this.isValid(value, 0, 65536));
        super.setLegacyPageSize(value);
        return this;
    }

    @Override
    public SQLiteMCChacha20Config setKdfIter(int value) {
        assert (this.isValid(value, 1, Integer.MAX_VALUE));
        super.setKdfIter(value);
        return this;
    }

    public SQLiteMCChacha20Config withRawUnsaltedKey(byte[] key) {
        if (key.length != 32) {
            throw new IllegalArgumentException(String.format("Raw unsalted key must be exactly 32 bytes long (provided: %s)", key.length));
        }
        return this.withRawKey(this.toHexString(key));
    }

    public SQLiteMCChacha20Config withRawSaltedKey(byte[] key) {
        if (key.length != 48) {
            throw new IllegalArgumentException(String.format("Raw unsalted key must be exactly 48 bytes long (provided: %s)", key.length));
        }
        return this.withRawKey(this.toHexString(key));
    }

    private SQLiteMCChacha20Config withRawKey(String key) {
        if (key.length() != 64 && key.length() != 96) {
            throw new IllegalArgumentException(String.format("Raw unsalted key must be exactly 64 or 96 char long (provided: %s)", key.length()));
        }
        return (SQLiteMCChacha20Config)this.withKey(String.format("raw:%s", key));
    }

    public static SQLiteMCChacha20Config getDefault() {
        return new SQLiteMCChacha20Config().setKdfIter(64007).setLegacy(0).setLegacyPageSize(4096);
    }

    public static SQLiteMCChacha20Config getSqlleetDefaults() {
        return new SQLiteMCChacha20Config().setKdfIter(12345).setLegacy(1).setLegacyPageSize(4096);
    }
}

