/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator;

import esecurity.tsl.CertChain;
import esecurity.tsl.CertDb;
import esecurity.tsl.CertDbBuilder;
import esecurity.tsl.CertDbType;
import esecurity.tsl.sqllite.ArubaCdbManifestValidator;
import esecurity.tsl.sqllite.ManifestValidator;
import esecurity.validator.DateSource;
import esecurity.validator.ValidationDate;
import esecurity.validator.ValidatorConfig;
import esecurity.validator.bean.LevelValidation;
import esecurity.validator.bean.RefCertificate;
import esecurity.validator.bean.RefOcsp;
import esecurity.validator.bean.SignatureInformation;
import esecurity.validator.bean.TransientDocument;
import esecurity.validator.bean.ValidatedBean;
import esecurity.validator.bean.ValidatedCertificate;
import esecurity.validator.bean.ValidatedDocument;
import esecurity.validator.bean.ValidatedSigner;
import esecurity.validator.constants.ValidationProfile;
import esecurity.validator.constants.ValidationSignatureFormats;
import esecurity.validator.constants.ValidationType;
import esecurity.validator.parser.utils.EventHandlerSelector;
import esecurity.validator.parser.utils.ParserUtils;
import esecurity.validator.steps.ExtraStepStore;
import esecurity.validator.steps.MultipleValidationStep;
import esecurity.validator.steps.SingleValidationStep;
import esecurity.validator.steps.SingleValidationStepImpl;
import esecurity.validator.steps.StepsUtils;
import esecurity.validator.steps.ValidationContextParameters;
import esecurity.validator.steps.ValidationStep;
import esecurity.validator.steps.ValidationStepStore;
import esecurity.validator.steps.annotations.StepContext;
import esecurity.validator.steps.core.StepValidationLevel;
import esecurity.validator.x509status.X509StatusService;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageFactory;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import it.actalis.ellips.capi.datahandlers.inputs.InputHandler;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.signature.SignatureLevel;
import it.actalis.ellips.util.File;
import it.actalis.ellips.util.TmpFileUtils;
import it.actalis.vol.utils.Constants;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ServiceLoader;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.slf4j.Logger;

public class Validator {
    private Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private LinkedList<ValidationStep> b = new LinkedList();
    private LinkedList<ValidationStep> c = new LinkedList();
    private ValidatorConfig d = null;
    private CertDb e;
    private X509StatusService f;

    public Validator(ValidatorConfig validatorConfig, Logger logger) throws CapiException {
        this(validatorConfig, logger, new ArubaCdbManifestValidator());
    }

    public Validator(ValidatorConfig validatorConfig, Logger object, ManifestValidator object2) throws CapiException {
        Object object3;
        this.d = validatorConfig;
        if (object != null) {
            this.a = object;
        }
        object = ServiceLoader.load(ValidationStepStore.class, Validator.class.getClassLoader());
        object = ((ServiceLoader)object).iterator();
        while (object.hasNext()) {
            object3 = (ValidationStepStore)object.next();
            this.b.addAll(object3.getSteps());
        }
        try {
            Collections.sort(this.b);
        }
        catch (Throwable throwable) {
            this.a.error(throwable.getMessage());
        }
        object3 = ServiceLoader.load(ExtraStepStore.class, ExtraStepStore.class.getClassLoader());
        object = ((ServiceLoader)object3).iterator();
        while (object.hasNext()) {
            object3 = (ExtraStepStore)object.next();
            this.c.addAll(object3.getSteps());
        }
        try {
            Collections.sort(this.c);
        }
        catch (Throwable throwable) {
            this.a.error(throwable.getMessage());
        }
        Object object4 = object3 = validatorConfig.getElement("certdb.file");
        object3 = object2;
        object2 = object4;
        object = this;
        try {
            ((Validator)object).e = CertDbBuilder.get().setFile(new java.io.File((String)object2)).setNetworkConfig(((Validator)object).d.getNetConfiguration()).setType(CertDbType.SQLLITE).setManifestValidator((ManifestValidator)object3).build();
        }
        catch (IOException iOException) {
            throw new CapiException("Unable to initialize the cdb", 1003, iOException);
        }
        this.f = X509StatusService.getInstance(validatorConfig, this.a);
        this.a.info("validator initialized");
    }

    public ValidatedDocument validate(InputHandler inputHandler, ValidationProfile validationProfile, ValidationDate validationDate) {
        return this.validate(inputHandler, validationProfile, validationDate, null);
    }

    public ValidatedDocument validate(InputHandler inputHandler, ValidationProfile validationProfile, ValidationDate validationDate, EventHandlerSelector eventHandlerSelector) {
        File file = null;
        try {
            file = TmpFileUtils.createTempDirectory("vrf", null);
        }
        catch (IOException iOException) {
            this.a.error(iOException.getMessage(), (Throwable)iOException);
        }
        TransientDocument transientDocument = ParserUtils.parseDoc(inputHandler, eventHandlerSelector, this.d.getNetConfiguration(), this.d.getTimeZone(), file);
        return this.validate(transientDocument, validationProfile, validationDate);
    }

    public ValidatedCertificate validate(Certificate object, ValidationProfile validationProfile, ValidationDate validationDate) {
        Object object2;
        boolean bl = false;
        if (((Certificate)object).getValidatedChain() == null) {
            object2 = this.a(null, (Certificate)object);
            ((Certificate)object).setValidatedChain((CertChain)object2);
            if (((CertChain)object2).getStartEntry().getParent() != null) {
                try {
                    bl = ((Certificate)object).isAltered(((CertChain)object2).getStartEntry().getParent().getCert());
                }
                catch (CapiException capiException) {
                    this.a.error(capiException.getMessage(), (Throwable)capiException);
                }
            }
        }
        object2 = ValidatedCertificate.newInstance((Certificate)object);
        ((ValidatedCertificate)object2).setCertCorrupted(bl);
        ValidationContextParameters validationContextParameters = this.a(null, null, (ValidatedCertificate)object2, validationProfile, validationDate);
        object = this.a((ValidatedCertificate)object2, validationContextParameters);
        if (((ValidatedCertificate)object).getIssuer() != null) {
            Object object3 = object;
            Validator.a((ValidatedCertificate)object3, ((ValidatedCertificate)object3).getIssuer(), validationContextParameters.getConfig().getMessageFactory(), validationProfile);
        }
        return object;
    }

    public ValidatedDocument validate(TransientDocument transientDocument, ValidationProfile validationProfile, ValidationDate validationDate) {
        return this.a(transientDocument, null, validationProfile, validationDate);
    }

    private ValidatedDocument a(TransientDocument transientDocument, ValidatedDocument object, ValidationProfile validationProfile, ValidationDate validationDate) {
        ValidatedDocument validatedDocument = new ValidatedDocument();
        validatedDocument.setInternalDocument(transientDocument);
        validatedDocument.setId(transientDocument.getId());
        validatedDocument.setSigned(transientDocument.isSigned());
        LinkedList<ValidatedSigner> object22 = this.a(validatedDocument, transientDocument, validationProfile, validationDate);
        validatedDocument.setSigners(object22);
        validatedDocument.setParent((ValidatedDocument)((Object)object));
        TransientDocument transientDocument2 = transientDocument;
        this.a(validatedDocument, transientDocument2, transientDocument2.getSignerInfo());
        validationDate = Validator.a(object22, validationDate);
        for (TransientDocument transientDocument3 : transientDocument.getRefsDocs()) {
            ValidatedDocument validatedDocument2 = this.a(transientDocument3, validatedDocument, validationProfile, validationDate);
            validatedDocument.addSubResult(validatedDocument2);
            this.a(validatedDocument2, transientDocument3, transientDocument.getSignerInfo());
        }
        return validatedDocument;
    }

    private static ValidationDate a(List<ValidatedSigner> object, ValidationDate object2) {
        if (object == null || object.isEmpty()) {
            return object2;
        }
        object = object.iterator();
        while (object.hasNext()) {
            Object object3 = (ValidatedSigner)object.next();
            if ((object3 = ((ValidatedSigner)object3).getVerificationDate()) == null || ((ValidationDate)object3).getDateSource() == null || !((ValidationDate)object3).getDateSource().equals((Object)DateSource.TIMESTAMP)) continue;
            object2 = object3;
        }
        return object2;
    }

    private void a(ValidatedDocument validatedDocument, TransientDocument transientDocument, List<SignatureInformation> list) {
        if (!transientDocument.isSigned()) {
            for (ValidationStep validationStep : this.c) {
                LinkedList<ValidatorMessage> linkedList = new LinkedList<ValidatorMessage>();
                ValidationContextParameters validationContextParameters = this.a(transientDocument, null, null, null, null);
                if (validationStep instanceof SingleValidationStep) {
                    ValidatorMessage validatorMessage = ((SingleValidationStep)((Object)validationStep)).check(validationContextParameters);
                    if (validatorMessage != null) {
                        linkedList.add(validatorMessage);
                    }
                } else {
                    linkedList.addAll(((MultipleValidationStep)((Object)validationStep)).checks(validationContextParameters));
                }
                if (linkedList.isEmpty()) continue;
                validatedDocument.setMessages(linkedList);
            }
            return;
        }
        for (ValidationStep validationStep : this.b) {
            if (validationStep.getType() != ValidationType.DOCUMENT) continue;
            LinkedList<ValidatorMessage> linkedList = new LinkedList<ValidatorMessage>();
            for (SignatureInformation signatureInformation : list) {
                ValidationContextParameters validationContextParameters = this.a(transientDocument, signatureInformation, null, null, null);
                if (validationStep instanceof SingleValidationStep) {
                    ValidatorMessage validatorMessage = ((SingleValidationStep)((Object)validationStep)).check(validationContextParameters);
                    if (validatorMessage != null) {
                        linkedList.add(validatorMessage);
                    }
                } else {
                    linkedList.addAll(((MultipleValidationStep)((Object)validationStep)).checks(validationContextParameters));
                }
                if (linkedList.isEmpty()) continue;
                validatedDocument.setMessages(linkedList);
            }
        }
    }

    private LinkedList<ValidatedSigner> a(ValidatedDocument validatedDocument, TransientDocument transientDocument, ValidationProfile validationProfile, ValidationDate validationDate) {
        LinkedList<ValidatedSigner> linkedList = new LinkedList<ValidatedSigner>();
        for (SignatureInformation signatureInformation : transientDocument.getSignerInfo()) {
            linkedList.add(this.a(validatedDocument, transientDocument, signatureInformation, validationProfile, validationDate));
        }
        return linkedList;
    }

    private ValidationContextParameters a(TransientDocument transientDocument, SignatureInformation signatureInformation, ValidatedCertificate validatedCertificate, ValidationProfile validationProfile, ValidationDate validationDate) {
        ValidationContextParameters validationContextParameters = new ValidationContextParameters();
        validationContextParameters.setValidator(this);
        validationContextParameters.setConfig(this.d);
        validationContextParameters.setDoc(transientDocument);
        validationContextParameters.setSignature(signatureInformation);
        validationContextParameters.setCertDB(this.e);
        if (validatedCertificate != null) {
            validationContextParameters.setSignerCertificate(validatedCertificate);
        }
        validationContextParameters.setTimeZone(this.d.getTimeZone());
        validationContextParameters.setValidationDate(validationDate);
        validationContextParameters.setProfile(validationProfile);
        return validationContextParameters;
    }

    private ValidatedSigner a(ValidatedDocument validatedDocument, TransientDocument transientDocument, SignatureInformation signatureInformation, ValidationProfile validationProfile, ValidationDate validationDate) {
        Object object2;
        ValidatedSigner validatedSigner = new ValidatedSigner();
        validatedSigner.setContainerFormat(signatureInformation.getContainerFormat());
        validatedSigner.setFormat(signatureInformation.getFormat());
        validatedSigner.setRefDocs(signatureInformation.getRefDocs());
        try {
            object2 = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss zzz");
            ((DateFormat)object2).setTimeZone(Constants.DEFAULT_TIMEZONE);
            validatedSigner.setSignatureDate(((DateFormat)object2).parse(signatureInformation.getSignatureDate()));
        }
        catch (ParseException parseException) {
            this.a.error("Signature date parsing error: " + parseException.getMessage());
        }
        validatedSigner.setSignerName(signatureInformation.getSignerName());
        validatedSigner.setSignatureInformation(signatureInformation);
        try {
            object2 = Validator.a(transientDocument, signatureInformation);
        }
        catch (CapiException capiException) {
            object2 = null;
            this.a.error("user certificate not found");
        }
        ValidationContextParameters validationContextParameters = this.a(transientDocument, signatureInformation, (ValidatedCertificate)object2, validationProfile, validationDate);
        for (RefCertificate object3 : transientDocument.getCerts()) {
            if (object3.getCapiCertificate() != null) {
                validationContextParameters.getLstCert().add(object3.getCapiCertificate());
                continue;
            }
            try {
                Certificate certificate = new Certificate(object3.getContent());
                validationContextParameters.getLstCert().add(certificate);
            }
            catch (CapiException capiException) {
                this.a.error("Errore parsing certificato verr\u00e0 ignorato");
            }
        }
        for (RefOcsp refOcsp : transientDocument.getOcspresps()) {
            try {
                BasicOCSPResp basicOCSPResp = new BasicOCSPResp(BasicOCSPResponse.getInstance((Object)DERSequence.fromByteArray((byte[])refOcsp.getContent())));
                validationContextParameters.getLstOcsp().add(basicOCSPResp);
            }
            catch (Exception exception) {
                this.a.error("Errore parsing ocsp verr\u00e0 ignorato");
            }
        }
        Object object4 = new StepValidationLevel();
        ((SingleValidationStepImpl)object4).check(validationContextParameters);
        if (validationContextParameters.getLevelValidation() != null) {
            validatedSigner.setLevel(validationContextParameters.getLevelValidation().getLevel());
        } else {
            validatedSigner.setLevel(SignatureLevel.BES);
        }
        validatedSigner.setVerificationDate(validationContextParameters.getCalculatedValidationDate());
        if (object2 != null) {
            CertChain certChain = this.a(validationContextParameters.getLevelValidation(), ((ValidatedCertificate)object2).getCert());
            validationContextParameters.getSignerCertificate().getCert().setValidatedChain(certChain);
            if (certChain.getStartEntry().getParent() != null) {
                try {
                    LinkedList<ValidatorMessage> linkedList = object2;
                    ((ValidatedCertificate)((Object)linkedList)).setCertCorrupted(((ValidatedCertificate)((Object)linkedList)).getCert().isAltered(certChain.getStartEntry().getParent().getCert()));
                }
                catch (CapiException capiException) {
                    this.a.error(capiException.getMessage(), (Throwable)capiException);
                }
            }
        }
        if ((object2 = this.a((ValidatedCertificate)object2, validationContextParameters)) != null && ((ValidatedCertificate)object2).getIssuer() != null) {
            LinkedList<ValidatorMessage> linkedList = object2;
            Validator.a((ValidatedCertificate)((Object)linkedList), ((ValidatedCertificate)((Object)linkedList)).getIssuer(), validationContextParameters.getConfig().getMessageFactory(), validationProfile);
        }
        validatedSigner.setCert((ValidatedCertificate)object2);
        for (ValidationStep validationStep : this.b) {
            if (validationStep.getType() != ValidationType.SIGNATURE || !Validator.a(validationStep, validationContextParameters)) continue;
            object2 = new LinkedList<ValidatorMessage>();
            if (validationStep instanceof SingleValidationStep) {
                object4 = ((SingleValidationStep)((Object)validationStep)).check(validationContextParameters);
                if (object4 != null && (((ValidatorMessage)object4).getProfile() == ValidationProfile.ALL_PROFILES || ((ValidatorMessage)object4).getProfile() == validationProfile)) {
                    ((LinkedList)object2).add(object4);
                }
            } else {
                ((LinkedList)object2).addAll(((MultipleValidationStep)((Object)validationStep)).checks(validationContextParameters));
            }
            StepsUtils.filterMessageByProfile((List<ValidatorMessage>)object2, validationContextParameters.getProfile());
            if (((AbstractCollection)object2).isEmpty()) continue;
            validatedSigner.setMessages((LinkedList<ValidatorMessage>)object2);
        }
        if (signatureInformation.getCounterSignaturesInformation() != null && !signatureInformation.getCounterSignaturesInformation().isEmpty()) {
            for (SignatureInformation signatureInformation2 : signatureInformation.getCounterSignaturesInformation()) {
                object2 = this.a(validatedDocument, transientDocument, signatureInformation2, validationProfile, validationDate);
                validatedSigner.addCounterSigner((ValidatedSigner)object2);
            }
        }
        if (signatureInformation.getTimeStampTokens() != null && !signatureInformation.getTimeStampTokens().isEmpty()) {
            for (SignatureInformation signatureInformation3 : signatureInformation.getTimeStampTokens()) {
                object2 = this.a(validatedDocument, transientDocument, signatureInformation3, validationProfile, validationDate);
                validatedSigner.addTimeStamp((ValidatedSigner)object2);
            }
        }
        return validatedSigner;
    }

    private static ValidatedCertificate a(TransientDocument object, SignatureInformation signatureInformation) throws CapiException {
        RefCertificate refCertificate = null;
        for (RefCertificate refCertificate2 : ((TransientDocument)object).getCerts()) {
            if (!refCertificate2.getId().equals(signatureInformation.getRefsCertId())) continue;
            refCertificate = refCertificate2;
            break;
        }
        if (refCertificate != null) {
            return ValidatedCertificate.newInstance(new Certificate(refCertificate.getContent()));
        }
        return null;
    }

    private static boolean a(ValidationStep validationSignatureFormatsArray, ValidationContextParameters validationContextParameters) {
        StepContext stepContext = SingleValidationStepImpl.retrieveAnnotationContext((ValidationStep)validationSignatureFormatsArray);
        validationSignatureFormatsArray = SingleValidationStepImpl.retrieveAnnotationOrder((ValidationStep)validationSignatureFormatsArray);
        boolean bl = false;
        if (validationSignatureFormatsArray == null || validationSignatureFormatsArray.order() != 0) {
            if (stepContext != null) {
                if (validationContextParameters.getSignature() != null) {
                    for (ValidationSignatureFormats validationSignatureFormats : stepContext.formats()) {
                        if (validationSignatureFormats.getFormat() != null && validationSignatureFormats.getFormat() == validationContextParameters.getSignature().getFormat()) {
                            bl = true;
                            continue;
                        }
                        if (validationSignatureFormats.getFormat() != null || validationSignatureFormats != ValidationSignatureFormats.ALL_SIGNATURE_FORMATS) continue;
                        bl = true;
                    }
                }
            } else {
                bl = true;
            }
        }
        return bl;
    }

    private ValidatedCertificate a(ValidatedCertificate validatedCertificate, ValidationContextParameters validationContextParameters) {
        for (ValidationStep validationStep : this.b) {
            if (validationStep.getType() != ValidationType.CERTIFICATE || !Validator.a(validationStep, validationContextParameters)) continue;
            LinkedList<ValidatorMessage> linkedList = new LinkedList<ValidatorMessage>();
            if (validationStep instanceof SingleValidationStep) {
                ValidatorMessage validatorMessage = ((SingleValidationStep)((Object)validationStep)).check(validationContextParameters);
                if (validatorMessage != null && (validatorMessage.getProfile() == ValidationProfile.ALL_PROFILES || validatorMessage.getProfile() == validationContextParameters.getProfile())) {
                    linkedList.add(validatorMessage);
                }
            } else {
                linkedList.addAll(((MultipleValidationStep)((Object)validationStep)).checks(validationContextParameters));
            }
            StepsUtils.filterMessageByProfile(linkedList, validationContextParameters.getProfile());
            if (validatedCertificate == null || linkedList.isEmpty()) continue;
            validatedCertificate.setMessages(linkedList);
        }
        return validatedCertificate;
    }

    private static void a(ValidatedCertificate validatedCertificate, ValidatedCertificate validatedCertificate2, MessageFactory messageFactory, ValidationProfile validationProfile) {
        if (validatedCertificate2.hasMessage(ValidatorMessageEnum.EC0001_CERT_NOT_VALID) && !validatedCertificate.hasMessage(ValidatorMessageEnum.EC0001_CERT_NOT_VALID)) {
            validatedCertificate.addMessage(new ValidatorMessage(messageFactory, MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0001_CERT_NOT_VALID, validationProfile, new Object[0]));
        }
        if (validatedCertificate2.hasMessage(ValidatorMessageEnum.EC0005_CERT_NOT_TIME_VALID) && !validatedCertificate.hasMessage(ValidatorMessageEnum.EC0005_CERT_NOT_TIME_VALID)) {
            validatedCertificate.addMessage(new ValidatorMessage(messageFactory, MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0005_CERT_NOT_TIME_VALID, validationProfile, new Object[0]));
        }
        if (validatedCertificate2.hasMessage(ValidatorMessageEnum.EC0006_CERT_SUSPENDED) && !validatedCertificate.hasMessage(ValidatorMessageEnum.EC0006_CERT_SUSPENDED)) {
            validatedCertificate.addMessage(new ValidatorMessage(messageFactory, MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0006_CERT_SUSPENDED, validationProfile, new Object[0]));
        }
        if (validatedCertificate2.hasMessage(ValidatorMessageEnum.EC0007_CERT_REVOKED) && !validatedCertificate.hasMessage(ValidatorMessageEnum.EC0007_CERT_REVOKED)) {
            validatedCertificate.addMessage(new ValidatorMessage(messageFactory, MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0007_CERT_REVOKED, validationProfile, new Object[0]));
        }
        if (validatedCertificate2.hasMessage(ValidatorMessageEnum.EC0026_DIGEST_ALGORITHM_FORBIDDEN) && !validatedCertificate.hasMessage(ValidatorMessageEnum.EC0026_DIGEST_ALGORITHM_FORBIDDEN)) {
            validatedCertificate.addMessage(new ValidatorMessage(messageFactory, MessageLevel.ERROR, (EsecurityMessage)ValidatorMessageEnum.EC0026_DIGEST_ALGORITHM_FORBIDDEN, validationProfile, new Object[0]));
        }
    }

    public void updateValidationDate(ValidatedDocument validatedDocument, ValidationProfile validationProfile, ValidationDate validationDate) {
        for (ValidatedSigner validatedBean : validatedDocument.getSigners()) {
            this.a(validatedDocument, validatedBean, validationProfile, validationDate);
        }
        ValidatedDocument validatedDocument2 = validatedDocument;
        this.a(validatedDocument2, validatedDocument2.getInternalDocument(), validatedDocument.getInternalDocument().getSignerInfo());
        validationDate = Validator.a(validatedDocument.getSigners(), validationDate);
        for (ValidatedDocument validatedDocument3 : validatedDocument.getSubResults()) {
            this.updateValidationDate(validatedDocument3, validationProfile, validationDate);
        }
    }

    private void a(ValidatedDocument validatedDocument, ValidatedSigner validatedSigner, ValidationProfile validationProfile, ValidationDate validationDate) {
        Object object2 = validatedSigner.getCert();
        ValidationContextParameters validationContextParameters = this.a(validatedDocument.getInternalDocument(), validatedSigner.getSignatureInformation(), (ValidatedCertificate)object2, validationProfile, validationDate);
        for (RefCertificate object3 : validatedDocument.getInternalDocument().getCerts()) {
            if (object3.getCapiCertificate() != null) {
                validationContextParameters.getLstCert().add(object3.getCapiCertificate());
                continue;
            }
            try {
                Certificate certificate = new Certificate(object3.getContent());
                validationContextParameters.getLstCert().add(certificate);
            }
            catch (CapiException capiException) {
                this.a.error("Errore parsing certificato verr\u00e0 ignorato");
            }
        }
        for (RefOcsp refOcsp : validatedDocument.getInternalDocument().getOcspresps()) {
            try {
                BasicOCSPResp basicOCSPResp = new BasicOCSPResp(BasicOCSPResponse.getInstance((Object)DERSequence.fromByteArray((byte[])refOcsp.getContent())));
                validationContextParameters.getLstOcsp().add(basicOCSPResp);
            }
            catch (Exception exception) {
                this.a.error("Errore parsing ocsp verr\u00e0 ignorato");
            }
        }
        Object object4 = new StepValidationLevel();
        ((SingleValidationStepImpl)object4).check(validationContextParameters);
        validatedSigner.setVerificationDate(validationContextParameters.getCalculatedValidationDate());
        if (object2 != null) {
            ((ValidatedBean)object2).getMessages().clear();
            if (((ValidatedCertificate)object2).getCert().getValidatedChain() == null) {
                CertChain certChain = this.a(validationContextParameters.getLevelValidation(), ((ValidatedCertificate)object2).getCert());
                validationContextParameters.getSignerCertificate().getCert().setValidatedChain(certChain);
                if (certChain.getStartEntry().getParent() != null) {
                    try {
                        ValidatedCertificate validatedCertificate = object2;
                        validatedCertificate.setCertCorrupted(validatedCertificate.getCert().isAltered(certChain.getStartEntry().getParent().getCert()));
                    }
                    catch (CapiException capiException) {
                        this.a.error(capiException.getMessage(), (Throwable)capiException);
                    }
                }
            }
        }
        if ((object2 = this.a((ValidatedCertificate)object2, validationContextParameters)) != null && ((ValidatedCertificate)object2).getIssuer() != null) {
            ValidatedCertificate validatedCertificate = object2;
            Validator.a(validatedCertificate, validatedCertificate.getIssuer(), validationContextParameters.getConfig().getMessageFactory(), validationProfile);
        }
        validatedSigner.getMessages().clear();
        for (ValidationStep validationStep : this.b) {
            if (validationStep.getType() != ValidationType.SIGNATURE || !Validator.a(validationStep, validationContextParameters)) continue;
            object2 = new LinkedList();
            if (validationStep instanceof SingleValidationStep) {
                object4 = ((SingleValidationStep)((Object)validationStep)).check(validationContextParameters);
                if (object4 != null) {
                    ((LinkedList)object2).add(object4);
                }
            } else {
                ((LinkedList)object2).addAll(((MultipleValidationStep)((Object)validationStep)).checks(validationContextParameters));
            }
            if (((AbstractCollection)object2).isEmpty()) continue;
            validatedSigner.setMessages((LinkedList<ValidatorMessage>)object2);
        }
        if (validatedSigner.getCounterSigners() != null) {
            for (ValidatedSigner validatedSigner2 : validatedSigner.getCounterSigners()) {
                this.a(validatedDocument, validatedSigner2, validationProfile, validationDate);
            }
        }
        if (validatedSigner.getTimeStamps() != null) {
            for (ValidatedSigner validatedSigner3 : validatedSigner.getTimeStamps()) {
                this.a(validatedDocument, validatedSigner3, validationProfile, validationDate);
            }
        }
    }

    private CertChain a(LevelValidation levelValidation, Certificate certificate) {
        if (levelValidation != null && levelValidation.getLevel().compareTo(SignatureLevel.T) > 0) {
            return levelValidation.getChain(certificate);
        }
        return this.e.retrieveCertificateChain(certificate);
    }

    public X509StatusService getStatusService() {
        return this.f;
    }
}

