/*
 * Decompiled with CFR 0.152.
 */
package esecurity.dts;

import esecurity.dts.DTSClient;
import esecurity.dts.TimeStampToken;
import esecurity.dts.util.ApiGeneralException;
import esecurity.dts.util.DTMPException;
import esecurity.dts.util.DTMPThread;
import esecurity.dts.util.IllegalParamException;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.http.HTTP;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.signature.DigestAlgorithm;
import it.actalis.ellips.capi.signature.TimeStampOptions;
import it.actalis.ellips.capi.tsa.TSAData;
import it.actalis.ellips.capi.tsa.TSAException;
import it.actalis.ellips.capi.tsa.TSAMessageEnum;
import it.actalis.ellips.capi.util.DigestUtils;
import it.actalis.vol.utils.Constants;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.tsp.TimeStampRequest;
import org.bouncycastle.tsp.TimeStampRequestGenerator;
import org.bouncycastle.tsp.TimeStampResponse;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;

public class Client
extends DTSClient {
    private Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    public static final int RFC_DEFAULT_PORT = 318;
    public static final long MIN_TIMEOUT = 100L;
    public static final long DEFAULT_TIMEOUT = 5000L;
    public static final long MAX_TIMEOUT = 60000L;
    private String b = null;
    private HTTP c = null;
    private long d;
    private String e;
    private int f;

    public Client() throws IllegalParamException {
        this.setServer("tsa.actalis.it", 318);
        this.setTimeout(5000L);
    }

    @Override
    public void initializeClient(TSAData tSAData, NetworkConfig networkConfig, String string) throws IllegalParamException {
        this.tsaData = tSAData;
        this.netConf = networkConfig == null ? new NetworkConfig() : networkConfig;
        this.requestedUrl = string;
    }

    @Override
    public void setServer(String string, int n) {
        this.e = string;
        this.f = n;
    }

    @Override
    public void setServer(String string, HTTP hTTP) throws IllegalParamException {
        this.b = string;
        this.c = hTTP;
    }

    @Override
    public void setTimeout(long l) throws IllegalParamException {
        this.d = l;
    }

    @Override
    public TimeStampToken timeStamp(String string, String string2, byte[] byArray) throws CapiException, TSAException {
        return this.timeStamp(string, string2, byArray, null, true);
    }

    @Override
    public TimeStampToken timeStamp(String string, String string2, InputStream inputStream) throws CapiException, TSAException {
        return this.timeStamp(string, string2, inputStream, null, true);
    }

    @Override
    public TimeStampToken timeStamp(String object, String string, byte[] byArray, BigInteger bigInteger, boolean bl) throws CapiException {
        try {
            object = this.a((String)object, string, byArray, bigInteger, bl, false, false);
            object = this.a((byte[])object);
        }
        catch (Exception exception) {
            throw new CapiException(exception.getMessage(), 1003);
        }
        return object;
    }

    private byte[] a(String object, String string, Object object2, BigInteger bigInteger, boolean bl, boolean bl2, boolean bl3) throws IllegalParamException, CapiException {
        if (string == null) {
            throw new IllegalParamException("hashAlgorithm", "null");
        }
        if (object2 == null) {
            throw new IllegalParamException("message", "null");
        }
        try {
            TimeStampRequestGenerator timeStampRequestGenerator = new TimeStampRequestGenerator();
            timeStampRequestGenerator.setReqPolicy(new ASN1ObjectIdentifier((String)object));
            timeStampRequestGenerator.setCertReq(bl);
            object = DigestAlgorithm.valueFromJavaName(string);
            if (object == null) {
                object = DigestAlgorithm.valueFromCadesId(string);
            }
            if (bl2) {
                this.a.debug("hash=" + new String(Hex.encode((byte[])((byte[])object2))));
                object = (byte[])object2;
            } else {
                object = object2 instanceof InputStream ? (Object)DigestUtils.calculate((DigestAlgorithm)((Object)object), (InputStream)object2) : (Object)DigestUtils.calculate((DigestAlgorithm)((Object)object), (byte[])object2);
            }
            object = timeStampRequestGenerator.generate(new ASN1ObjectIdentifier(string), (byte[])object, bigInteger);
            if (bl3) {
                return Base64.encode((byte[])object.getEncoded());
            }
            return object.getEncoded();
        }
        catch (Exception exception) {
            this.a.debug(null, (Throwable)exception);
            throw new CapiException(exception.getMessage(), 1003);
        }
    }

    @Override
    public TimeStampToken timeStamp(String object, String string, InputStream inputStream, BigInteger bigInteger, boolean bl) throws IllegalParamException, CapiException, TSAException {
        try {
            object = this.a((String)object, string, inputStream, bigInteger, bl, false, false);
            object = this.a((byte[])object);
        }
        catch (Exception exception) {
            throw new CapiException(exception.getMessage(), 1003);
        }
        return object;
    }

    @Override
    public TimeStampToken timeStampHash(String string, String string2, byte[] byArray) throws CapiException, IOException, TSAException {
        return this.timeStampHash(string, string2, byArray, null, true);
    }

    @Override
    public TimeStampToken timeStampHash(String object, String string, byte[] byArray, BigInteger bigInteger, boolean bl) throws IOException, CapiException {
        try {
            object = this.a((String)object, string, byArray, bigInteger, bl, true, false);
            object = this.a((byte[])object);
        }
        catch (InterruptedException interruptedException) {
            throw new CapiException(interruptedException.getMessage(), 1003);
        }
        return object;
    }

    @Override
    public TimeStampResponse getMark(InputStream inputStream, boolean bl) throws ApiGeneralException, IOException, TSAException {
        throw new UnsupportedOperationException("Not Implemented");
    }

    public String getRequest(String object, String string, byte[] byArray, boolean bl, BigInteger bigInteger, boolean bl2) throws IllegalParamException, CapiException {
        object = this.a((String)object, string, byArray, bigInteger, bl2, bl, true);
        return new String((byte[])object);
    }

    public String getRequest(String object, String string, InputStream inputStream, BigInteger bigInteger, boolean bl) throws IllegalParamException, CapiException {
        object = this.a((String)object, string, inputStream, bigInteger, bl, false, true);
        return new String((byte[])object);
    }

    public TimeStampToken sendRequest(String object) throws CapiException, IOException, InterruptedException {
        try {
            object = Base64.decode((String)object);
            object = new TimeStampRequest((byte[])object);
            object = object.getEncoded();
        }
        catch (Exception exception) {
            this.a.debug(null, (Throwable)exception);
            throw new CapiException(exception.getMessage(), 50040);
        }
        object = this.a((byte[])object);
        return object;
    }

    private TimeStampToken a(byte[] object) throws IOException, InterruptedException, CapiException {
        if (this.c != null) {
            try {
                object = this.c.doPost(this.b, "application/timestamp-query", new ByteArrayInputStream((byte[])object), null);
            }
            catch (CapiException capiException) {
                this.a.debug(null, (Throwable)capiException);
                throw new CapiException("Capi Error: " + capiException.getMessage(), 50040);
            }
            return new TimeStampToken((byte[])object);
        }
        try {
            DTMPThread dTMPThread = new DTMPThread(this.e, this.f, (byte[])object);
            object = dTMPThread;
            dTMPThread.setDaemon(true);
            ((Thread)object).start();
            ((Thread)object).join(this.d);
            if (((Thread)object).isAlive()) {
                ((Thread)object).stop();
                throw new InterruptedException("Server timeout: " + this.d);
            }
            return new TimeStampToken(((DTMPThread)object).getData());
        }
        catch (DTMPException dTMPException) {
            this.a.debug(null, (Throwable)dTMPException);
            throw new CapiException("Protocol Error: " + dTMPException.getMessage(), 50040);
        }
        catch (CapiException capiException) {
            this.a.debug(null, (Throwable)capiException);
            throw new CapiException("Capi Error: " + capiException.getMessage(), 50040);
        }
    }

    @Override
    public byte[] stamp(InputStream inputStream, TimeStampOptions timeStampOptions) {
        BigInteger bigInteger = new BigInteger(64, Util.secureRandom);
        try {
            return this.timeStamp(timeStampOptions.getTSAPolicy(), timeStampOptions.getTSADigestAlgorithm().toString(), inputStream, bigInteger, timeStampOptions.isTSACertReq()).toByteArray(false, true);
        }
        catch (Exception exception) {
            this.a.error(exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    @Override
    public byte[] stampEx(InputStream inputStream, TimeStampOptions timeStampOptions) throws TSAException {
        BigInteger bigInteger = new BigInteger(64, Util.secureRandom);
        try {
            return this.timeStamp(timeStampOptions.getTSAPolicy(), timeStampOptions.getTSADigestAlgorithm().toString(), inputStream, bigInteger, timeStampOptions.isTSACertReq()).toByteArray(false, true);
        }
        catch (IOException iOException) {
            this.a.error(iOException.getMessage(), (Throwable)iOException);
            throw new TSAException(TSAMessageEnum.INTERNAL_ERROR);
        }
        catch (CapiException capiException) {
            this.a.error(capiException.getMessage(), (Throwable)capiException);
            throw new TSAException(TSAMessageEnum.INTERNAL_ERROR);
        }
    }
}

