/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.steps.core.x509;

import esecurity.tsl.CertDb;
import esecurity.tsl.ServiceDbItem;
import esecurity.validator.bean.ValidatedCertificate;
import esecurity.validator.constants.SignatureFormat;
import esecurity.validator.constants.ValidationType;
import esecurity.validator.steps.SingleValidationSubStepImpl;
import esecurity.validator.steps.ValidationContextParameters;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Certificate;
import it.actalis.ellips.capi.core.msg.EsecurityMessage;
import it.actalis.ellips.capi.core.msg.MessageLevel;
import it.actalis.ellips.capi.core.msg.ValidatorMessage;
import it.actalis.ellips.capi.core.msg.ValidatorMessageEnum;
import java.util.LinkedList;

public class StepX509AIACheck
extends SingleValidationSubStepImpl {
    public StepX509AIACheck() {
        super(ValidationType.CERTIFICATE);
    }

    @Override
    protected ValidatorMessage innerCheck(LinkedList<ValidatorMessage> object, ValidationContextParameters validationContextParameters) {
        if (validationContextParameters == null || validationContextParameters.getSignerCertificate() == null || validationContextParameters.getSignature() != null && (validationContextParameters.getSignature().getFormat() == null || validationContextParameters.getSignature().getFormat().equals((Object)SignatureFormat.TST))) {
            return null;
        }
        if (validationContextParameters.getSignerCertificate().getIssuer() == null) {
            return null;
        }
        try {
            object = validationContextParameters.getSignerCertificate().getCert().getAuthorityInfoAccess();
            if (object == null || ((String[])object).length == 0) {
                return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WC0007_AIA_NOT_PRESENT, new Object[0]);
            }
        }
        catch (CapiException capiException) {}
        CertDb certDb = validationContextParameters.getCertDB();
        object = validationContextParameters.getSignerCertificate();
        object = ((ValidatedCertificate)object).getIssuer().getCert();
        if (certDb.containsCertificate((Certificate)object) && (object = certDb.queryServiceItems((Certificate)object)) != null && !object.isEmpty() && ((ServiceDbItem)object.get(0)).getCert().getSubjectDN().equals(((ServiceDbItem)object.get(0)).getCert().getIssuerDN())) {
            return null;
        }
        object = validationContextParameters.getSignerCertificate().getCert().getCaIssuer();
        if (object == null || ((String)object).isEmpty()) {
            return new ValidatorMessage(validationContextParameters.getConfig().getMessageFactory(), MessageLevel.WARNING, (EsecurityMessage)ValidatorMessageEnum.WC0015_CAISSUER_NOT_PRESENT, new Object[0]);
        }
        return null;
    }
}

