/*
 * Decompiled with CFR 0.152.
 */
package esecurity.dts;

import esecurity.dts.DTSClient;
import esecurity.dts.TimeStampToken;
import esecurity.dts.util.ApiGeneralException;
import esecurity.dts.util.IllegalParamException;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.Util;
import it.actalis.ellips.capi.http.ArubaTrustStore;
import it.actalis.ellips.capi.http.HTTP;
import it.actalis.ellips.capi.http.arubautils.NetworkConfig;
import it.actalis.ellips.capi.http.arubautils.soap.SOAPConnection;
import it.actalis.ellips.capi.logging.EllipsLoggerFactory;
import it.actalis.ellips.capi.signature.TimeStampOptions;
import it.actalis.ellips.capi.tsa.TSAData;
import it.actalis.ellips.capi.tsa.TSAException;
import it.actalis.ellips.capi.tsa.TSAMessageEnum;
import it.actalis.vol.utils.Constants;
import it.actalis.vol.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.KeyStore;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampResponse;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.w3c.dom.Element;

public class ARSSDTSClient
extends DTSClient {
    private static Logger a = EllipsLoggerFactory.getLogger((String)Constants.CAPI_LOGGER_NAME);
    private static DocumentBuilderFactory b = DocumentBuilderFactory.newInstance();

    public ARSSDTSClient(String string, String string2, String string3) {
        this.tsaData = new TSAData("", "", "", string2, string3, "", "");
        this.requestedUrl = string;
        this.netConf = new NetworkConfig();
    }

    public ARSSDTSClient(String string, String string2, String string3, NetworkConfig networkConfig) {
        this.tsaData = new TSAData("", "", "", string2, string3, "", "");
        this.requestedUrl = string;
        this.netConf = networkConfig;
    }

    @Override
    public void initializeClient(TSAData tSAData, NetworkConfig networkConfig, String string) throws IllegalParamException {
        if (string == null) {
            throw new IllegalParamException("requestedUrl cannot be null in ARSSDTSClient");
        }
        this.tsaData = tSAData;
        this.netConf = networkConfig == null ? new NetworkConfig() : networkConfig;
        this.requestedUrl = string;
    }

    @Override
    public void setServer(String string, HTTP hTTP) throws IllegalParamException {
        throw new UnsupportedOperationException("Funzionalit\u00e0 non supportata");
    }

    @Override
    public void setServer(String string, int n) throws IllegalParamException {
        throw new UnsupportedOperationException("Funzionalit\u00e0 non supportata");
    }

    @Override
    public void setTimeout(long l) throws IllegalParamException {
        throw new UnsupportedOperationException("Funzionalit\u00e0 non supportata");
    }

    @Override
    public TimeStampToken timeStamp(String string, String string2, byte[] byArray) throws CapiException, IOException {
        return this.timeStamp(string, string2, byArray, null, true);
    }

    @Override
    public TimeStampToken timeStamp(String string, String string2, InputStream inputStream) throws CapiException, TSAException, IOException {
        return this.timeStamp(string, string2, inputStream, null, true);
    }

    @Override
    public TimeStampToken timeStamp(String object, String string, byte[] byArray, BigInteger bigInteger, boolean bl) throws TSAException, CapiException, IOException {
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            object = this.timeStamp((String)object, string, byteArrayInputStream, bigInteger, bl);
        }
        catch (Throwable throwable) {
            if (byteArrayInputStream != null) {
                try {
                    byteArrayInputStream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        try {
            byteArrayInputStream.close();
        }
        catch (IOException iOException) {}
        return object;
    }

    @Override
    public TimeStampToken timeStamp(String object, String string, InputStream object2, BigInteger bigInteger, boolean bl) throws CapiException, IOException {
        try {
            object2 = Utils.base64Encode(IOUtils.toByteArray((InputStream)object2));
            object = this.timeStampHash((String)object, string, (byte[])object2, bigInteger, bl);
            return object;
        }
        catch (CapiException capiException) {
            throw new TSAException(TSAMessageEnum.INTERNAL_ERROR);
        }
    }

    @Override
    public TimeStampToken timeStampHash(String string, String string2, byte[] byArray) throws ApiGeneralException, IOException {
        return this.timeStampHash(string, string2, byArray, null, true);
    }

    @Override
    public TimeStampToken timeStampHash(String object, String string, byte[] byArray, BigInteger bigInteger, boolean bl) throws ApiGeneralException, IOException {
        object = null;
        try {
            string = new TimeStampResponse(this.a(byArray));
            object = new TimeStampToken(string.getTimeStampToken().getEncoded());
        }
        catch (TSPException tSPException) {
            a.error(tSPException.getMessage(), (Throwable)tSPException);
        }
        catch (CapiException capiException) {
            a.error(capiException.getMessage(), (Throwable)capiException);
        }
        return object;
    }

    @Override
    public TimeStampResponse getMark(InputStream object, boolean bl) throws ApiGeneralException, IOException, TSAException {
        TimeStampResponse timeStampResponse = null;
        try {
            object = Utils.base64Encode(IOUtils.toByteArray((InputStream)object));
            timeStampResponse = new TimeStampResponse(this.a((byte[])object));
        }
        catch (TSPException tSPException) {
            a.error(tSPException.getMessage(), (Throwable)tSPException);
        }
        return timeStampResponse;
    }

    private byte[] a(byte[] object) throws IOException {
        byte[] byArray = null;
        Object object2 = "";
        if (this.tsaData.getTSAUrl() != null && !this.tsaData.getTSAUrl().isEmpty()) {
            object2 = "<url>" + this.tsaData.getTSAUrl() + "</url>\n";
        }
        object = String.format("<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:arub=\"http://arubasignservice.arubapec.it/\">\n   <soapenv:Header/>\n   <soapenv:Body>\n      <arub:tsr>\n         <MarkRequest>\n            <user>%s</user>\n            <password>%s</password>\n%s            <transport>BYNARYNET</transport>\n            <binaryinput>%s</binaryinput>\n         </MarkRequest>\n      </arub:tsr>\n   </soapenv:Body>\n</soapenv:Envelope>", this.tsaData.getTSAUser(), this.tsaData.getTSAPassword(), object2, new String((byte[])object));
        object = SOAPConnection.sendXMLUrl2((String)this.requestedUrl, (String)object, (NetworkConfig)this.netConf, (String)"\"\"", null, (KeyStore)ArubaTrustStore.getTSRS(), (boolean)false);
        try {
            object2 = b.newDocumentBuilder();
            object = ((DocumentBuilder)object2).parse(new ByteArrayInputStream(((String)object).getBytes()));
            object2 = object.getElementsByTagName("return");
            if (object2.getLength() > 0 && (object = object.getElementsByTagName("return")).getLength() > 0 && (object2 = (object = (Element)object.item(0)).getElementsByTagName("return_code")).getLength() > 0 && object2.item(0).getTextContent().equals("0000") && (object = object.getElementsByTagName("binaryoutput")).getLength() > 0) {
                byArray = Base64.decode((String)object.item(0).getTextContent());
            }
        }
        catch (Exception exception) {
            a.error(exception.getMessage(), (Throwable)exception);
        }
        if (byArray == null) {
            throw new IOException("Errore nella richiesta TSA");
        }
        return byArray;
    }

    @Override
    public byte[] stamp(InputStream inputStream, TimeStampOptions timeStampOptions) {
        BigInteger bigInteger = new BigInteger(64, Util.secureRandom);
        try {
            return this.timeStamp(timeStampOptions.getTSAPolicy(), timeStampOptions.getTSADigestAlgorithm().toString(), inputStream, bigInteger, timeStampOptions.isTSACertReq()).toByteArray(false, true);
        }
        catch (TSAException tSAException) {
            a.error(tSAException.getMessage(), (Throwable)tSAException);
        }
        catch (IOException iOException) {
            a.error(iOException.getMessage(), (Throwable)iOException);
        }
        catch (ApiGeneralException apiGeneralException) {
            a.error(apiGeneralException.getMessage(), (Throwable)apiGeneralException);
        }
        catch (CapiException capiException) {
            a.error(capiException.getMessage(), (Throwable)capiException);
        }
        return null;
    }

    public void setNetConf(NetworkConfig networkConfig) {
        this.netConf = networkConfig;
    }

    @Override
    public byte[] stampEx(InputStream inputStream, TimeStampOptions timeStampOptions) throws TSAException {
        BigInteger bigInteger = new BigInteger(64, Util.secureRandom);
        try {
            return this.timeStamp(timeStampOptions.getTSAPolicy(), timeStampOptions.getTSADigestAlgorithm().toString(), inputStream, bigInteger, timeStampOptions.isTSACertReq()).toByteArray(false, true);
        }
        catch (IOException iOException) {
            a.error(iOException.getMessage(), (Throwable)iOException);
            throw new TSAException(TSAMessageEnum.INTERNAL_ERROR);
        }
        catch (ApiGeneralException apiGeneralException) {
            a.error(apiGeneralException.getMessage(), (Throwable)apiGeneralException);
            throw new TSAException(TSAMessageEnum.INTERNAL_ERROR);
        }
        catch (CapiException capiException) {
            a.error(capiException.getMessage(), (Throwable)capiException);
            throw new TSAException(TSAMessageEnum.INTERNAL_ERROR);
        }
    }
}

