/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.asymmetric.rsa;

import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.RIPEMD160Digest;
import org.bouncycastle.crypto.digests.WhirlpoolDigest;
import org.bouncycastle.crypto.engines.RSABlindedEngine;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.signers.ISO9796d2Signer;
import org.bouncycastle.crypto.util.DigestFactory;
import org.bouncycastle.jcajce.provider.asymmetric.rsa.RSAUtil;

public class ISOSignatureSpi
extends SignatureSpi {
    private ISO9796d2Signer signer;

    protected ISOSignatureSpi(Digest digest, AsymmetricBlockCipher cipher) {
        this.signer = new ISO9796d2Signer(cipher, digest, true);
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        RSAKeyParameters param = RSAUtil.generatePublicKeyParameter((RSAPublicKey)publicKey);
        this.signer.init(false, (CipherParameters)param);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        RSAKeyParameters param = RSAUtil.generatePrivateKeyParameter((RSAPrivateKey)privateKey);
        this.signer.init(true, (CipherParameters)param);
    }

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        this.signer.update(b);
    }

    @Override
    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        this.signer.update(b, off, len);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        try {
            byte[] sig = this.signer.generateSignature();
            return sig;
        }
        catch (Exception e) {
            throw new SignatureException(e.toString());
        }
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        boolean yes = this.signer.verifySignature(sigBytes);
        return yes;
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec params) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected void engineSetParameter(String param, Object value) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected Object engineGetParameter(String param) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    public static class WhirlpoolWithRSAEncryption
    extends ISOSignatureSpi {
        public WhirlpoolWithRSAEncryption() {
            super((Digest)new WhirlpoolDigest(), (AsymmetricBlockCipher)new RSABlindedEngine());
        }
    }

    public static class SHA512_256WithRSAEncryption
    extends ISOSignatureSpi {
        public SHA512_256WithRSAEncryption() {
            super(DigestFactory.createSHA512_256(), (AsymmetricBlockCipher)new RSABlindedEngine());
        }
    }

    public static class SHA512_224WithRSAEncryption
    extends ISOSignatureSpi {
        public SHA512_224WithRSAEncryption() {
            super(DigestFactory.createSHA512_224(), (AsymmetricBlockCipher)new RSABlindedEngine());
        }
    }

    public static class SHA512WithRSAEncryption
    extends ISOSignatureSpi {
        public SHA512WithRSAEncryption() {
            super(DigestFactory.createSHA512(), (AsymmetricBlockCipher)new RSABlindedEngine());
        }
    }

    public static class SHA384WithRSAEncryption
    extends ISOSignatureSpi {
        public SHA384WithRSAEncryption() {
            super(DigestFactory.createSHA384(), (AsymmetricBlockCipher)new RSABlindedEngine());
        }
    }

    public static class SHA256WithRSAEncryption
    extends ISOSignatureSpi {
        public SHA256WithRSAEncryption() {
            super(DigestFactory.createSHA256(), (AsymmetricBlockCipher)new RSABlindedEngine());
        }
    }

    public static class SHA224WithRSAEncryption
    extends ISOSignatureSpi {
        public SHA224WithRSAEncryption() {
            super(DigestFactory.createSHA224(), (AsymmetricBlockCipher)new RSABlindedEngine());
        }
    }

    public static class RIPEMD160WithRSAEncryption
    extends ISOSignatureSpi {
        public RIPEMD160WithRSAEncryption() {
            super((Digest)new RIPEMD160Digest(), (AsymmetricBlockCipher)new RSABlindedEngine());
        }
    }

    public static class MD5WithRSAEncryption
    extends ISOSignatureSpi {
        public MD5WithRSAEncryption() {
            super(DigestFactory.createMD5(), (AsymmetricBlockCipher)new RSABlindedEngine());
        }
    }

    public static class SHA1WithRSAEncryption
    extends ISOSignatureSpi {
        public SHA1WithRSAEncryption() {
            super(DigestFactory.createSHA1(), (AsymmetricBlockCipher)new RSABlindedEngine());
        }
    }
}

