/*
 * Decompiled with CFR 0.152.
 */
package esecurity.validator.utils;

import esecurity.dts.TimeStampToken;
import esecurity.dts.util.ApiGeneralException;
import esecurity.validator.bean.CertStatusValidation;
import esecurity.validator.bean.LevelValidation;
import esecurity.validator.bean.RefCRL;
import esecurity.validator.bean.VerifiedSerial;
import esecurity.validator.constants.StatusValidation;
import esecurity.validator.parser.utils.CRLUtils;
import it.actalis.ellips.capi.certdb.CertDB;
import it.actalis.ellips.capi.certdb.CertDBException;
import it.actalis.ellips.capi.certdb.CertDBItem;
import it.actalis.ellips.capi.core.CRL;
import it.actalis.ellips.capi.core.CapiException;
import it.actalis.ellips.capi.core.ProvUtils;
import it.actalis.ellips.capi.signature.SignatureLevel;
import it.actalis.ellips.util.TmpFileUtils;
import java.io.File;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.AbstractSequentialList;
import java.util.Date;
import java.util.LinkedList;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.RevokedStatus;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.slf4j.Logger;

public class LevelValidationUtils {
    public static LevelValidation validateLevel(TimeStampToken timeStampToken, X509Certificate x509Certificate, LinkedList<X509Certificate> linkedList, LinkedList<BasicOCSPResp> linkedList2, LinkedList<CRL> object, Logger logger) {
        LevelValidation levelValidation;
        block9: {
            levelValidation = new LevelValidation();
            levelValidation.setSignerCertificate(x509Certificate);
            if (timeStampToken == null) {
                return levelValidation;
            }
            LinkedList<X509Certificate> linkedList3 = new LinkedList<X509Certificate>();
            try {
                it.actalis.ellips.capi.core.Certificate certificate = timeStampToken.getTSACert();
                if (certificate == null) {
                    return levelValidation;
                }
                if (linkedList != null) {
                    linkedList3.addAll(linkedList);
                }
                linkedList3.add(certificate.getInternalCert());
                LinkedList<RefCRL> linkedList4 = new LinkedList<RefCRL>();
                if (object != null) {
                    object = ((AbstractSequentialList)object).iterator();
                    while (object.hasNext()) {
                        CRL cRL = (CRL)object.next();
                        CRLUtils.addRefCrl(linkedList4, cRL, linkedList3);
                    }
                }
                return LevelValidationUtils.validateLevelByRefCRL(timeStampToken.getDate(), x509Certificate, certificate.getInternalCert(), linkedList, linkedList2, linkedList4, logger);
            }
            catch (ApiGeneralException apiGeneralException) {
                if (logger != null) {
                    logger.error("Invalid timestamp: " + apiGeneralException.getMessage());
                }
            }
            catch (CapiException capiException) {
                if (logger == null) break block9;
                logger.error("Invalid timestamp: " + capiException.getMessage());
            }
        }
        return levelValidation;
    }

    public static LevelValidation validateLevelByRefCRL(Date date, X509Certificate x509Certificate, X509Certificate x509Certificate2, LinkedList<X509Certificate> linkedList, LinkedList<BasicOCSPResp> linkedList2, LinkedList<RefCRL> linkedList3, Logger logger) {
        Object object;
        CertDBItem[] certDBItemArray;
        LevelValidation levelValidation;
        block33: {
            block32: {
                levelValidation = new LevelValidation();
                levelValidation.setSignerCertificate(x509Certificate);
                levelValidation.setChain(linkedList);
                levelValidation.setOcsps(linkedList2);
                levelValidation.setCrls(linkedList3);
                levelValidation.setVerificationDate(date);
                if (x509Certificate2 != null) {
                    levelValidation.setTsaCertificate(x509Certificate2);
                    levelValidation.setLevel(SignatureLevel.T);
                }
                it.actalis.ellips.util.File file = null;
                if (linkedList != null) {
                    try {
                        file = TmpFileUtils.createTempFile("tempCDB", "");
                        certDBItemArray = CertDB.instanceFromList(linkedList, file.getAbsolutePath(), "12345678");
                        object = certDBItemArray.contains(x509Certificate.getEncoded());
                        if (object != null) {
                            certDBItemArray.delete((CertDBItem)object);
                        }
                        if ((certDBItemArray = certDBItemArray.verify(x509Certificate.getEncoded())) != null && certDBItemArray.length > 0) {
                            levelValidation.setSignerChain(certDBItemArray);
                        }
                    }
                    catch (CapiException | IOException | NullPointerException | CertificateEncodingException exception) {
                        if (logger != null) {
                            logger.error("Error verifying signer certificate chain: " + exception.getMessage());
                        }
                    }
                    finally {
                        if (file != null) {
                            ((File)file).delete();
                        }
                    }
                }
                if (linkedList != null) {
                    try {
                        file = TmpFileUtils.createTempFile("tempCDB", "");
                        certDBItemArray = CertDB.instanceFromList(linkedList, file.getAbsolutePath(), "12345678");
                        object = certDBItemArray.contains(x509Certificate2.getEncoded());
                        if (object != null) {
                            certDBItemArray.delete((CertDBItem)object);
                        }
                        if ((certDBItemArray = certDBItemArray.verify(x509Certificate2.getEncoded())) != null && certDBItemArray.length > 0) {
                            levelValidation.setTsaChain(certDBItemArray);
                        }
                    }
                    catch (CapiException | IOException | NullPointerException | CertificateEncodingException exception) {
                        if (logger != null) {
                            logger.error("Error verifying TSA certificate chain: " + exception.getMessage());
                        }
                    }
                    finally {
                        if (file != null) {
                            ((File)file).delete();
                        }
                    }
                }
                try {
                    levelValidation.setSignerStatus(LevelValidationUtils.a(date, x509Certificate, linkedList, linkedList2, linkedList3));
                }
                catch (CapiException | IOException | NullPointerException | CertificateException | OCSPException | OperatorCreationException throwable) {
                    if (logger == null) break block32;
                    logger.error("Error checking CRL/OCSP status for signer: " + throwable.getMessage());
                }
            }
            try {
                levelValidation.setTsaSignerStatus(LevelValidationUtils.a(date, x509Certificate2, linkedList, linkedList2, linkedList3));
            }
            catch (CapiException | IOException | NullPointerException | CertificateException | OCSPException | OperatorCreationException throwable) {
                if (logger == null) break block33;
                logger.error("Error checking CRL/OCSP status for TSA: " + throwable.getMessage());
            }
        }
        certDBItemArray = levelValidation.getSignerStatus();
        object = levelValidation.getTsaSignerStatus();
        if (certDBItemArray != null && object != null) {
            boolean bl = certDBItemArray.getValidationType() == StatusValidation.EMBEDDED_CRL || certDBItemArray.getValidationType() == StatusValidation.EMBEDDED_OCSP;
            boolean bl2 = ((CertStatusValidation)object).getValidationType() == StatusValidation.EMBEDDED_CRL || ((CertStatusValidation)object).getValidationType() == StatusValidation.EMBEDDED_OCSP;
            boolean bl3 = levelValidation.getSignerChain() != null && levelValidation.getTsaChain() != null;
            if (bl3) {
                if (!bl) {
                    logger.info("Formato non LT: non sono state trovate informazioni di revoca embedded per il signer {}", (Object)x509Certificate.getSubjectDN());
                }
                if (!bl2) {
                    logger.info("Formato non LT non sono state trovate informazioni di revoca embedded per la TSA {}", (Object)x509Certificate2.getSubjectDN());
                }
            }
            if (bl && bl2 && bl3) {
                levelValidation.setLevel(SignatureLevel.LT);
            }
        }
        return levelValidation;
    }

    private static CertStatusValidation a(Date date, X509Certificate x509Certificate, LinkedList<X509Certificate> revokedStatus, LinkedList<BasicOCSPResp> linkedList, LinkedList<RefCRL> object) throws CertDBException, CapiException, CertificateEncodingException, CertificateException, OCSPException, IOException, OperatorCreationException {
        Object object2;
        CertStatusValidation certStatusValidation = new CertStatusValidation();
        if (x509Certificate == null) {
            return certStatusValidation;
        }
        if (object != null) {
            object = ((AbstractSequentialList)object).iterator();
            while (object.hasNext()) {
                object2 = (RefCRL)object.next();
                if (((RefCRL)object2).getNextUpdate().before(date)) continue;
                for (VerifiedSerial verifiedSerial : ((RefCRL)object2).getVerifiedSerial()) {
                    if (!verifiedSerial.getSerial().equals(x509Certificate.getSerialNumber().toString(16))) continue;
                    certStatusValidation.setValidationType(StatusValidation.EMBEDDED_CRL);
                    certStatusValidation.setCrl((RefCRL)object2);
                    if (verifiedSerial.isRevoked() && verifiedSerial.getRevocationDate().before(date)) {
                        certStatusValidation.setReasonCode(verifiedSerial.getReasonCode());
                        certStatusValidation.setRevocationDate(verifiedSerial.getRevocationDate());
                        certStatusValidation.setRevoked(true);
                        break;
                    }
                    certStatusValidation.setRevoked(false);
                    break;
                }
                if (certStatusValidation.getValidationType() == StatusValidation.NONE) continue;
            }
        }
        if (certStatusValidation.getValidationType() != StatusValidation.NONE) {
            return certStatusValidation;
        }
        if (linkedList != null) {
            object = null;
            try {
                object = TmpFileUtils.createTempFile("tempCDB", "");
                object2 = CertDB.instanceFromList((LinkedList<X509Certificate>)revokedStatus, ((File)object).getAbsolutePath(), "12345678");
                for (BasicOCSPResp basicOCSPResp : linkedList) {
                    if (basicOCSPResp.getProducedAt().before(date) || !x509Certificate.getSerialNumber().equals(basicOCSPResp.getResponses()[0].getCertID().getSerialNumber())) continue;
                    RevokedStatus revokedStatus2 = basicOCSPResp.getCerts();
                    revokedStatus = revokedStatus2;
                    revokedStatus = revokedStatus2;
                    int n = ((X509CertificateHolder[])revokedStatus2).length;
                    for (int i = 0; i < n; ++i) {
                        Object object3 = revokedStatus[i];
                        object3 = new JcaX509CertificateConverter().setProvider(ProvUtils.bcProvider).getCertificate((X509CertificateHolder)object3);
                        JcaContentVerifierProviderBuilder jcaContentVerifierProviderBuilder = ((CertDB)object2).contains(((Certificate)object3).getEncoded());
                        if (jcaContentVerifierProviderBuilder != null) {
                            ((CertDB)object2).delete((CertDBItem)jcaContentVerifierProviderBuilder);
                        }
                        if ((jcaContentVerifierProviderBuilder = ((CertDB)object2).verify(((Certificate)object3).getEncoded())) != null && ((CertDBItem[])jcaContentVerifierProviderBuilder).length > 0 && basicOCSPResp.getResponses()[0].getCertID().matchesIssuer(new X509CertificateHolder(jcaContentVerifierProviderBuilder[0].getCertificate().getInternalCert().getEncoded()), new JcaDigestCalculatorProviderBuilder().build())) {
                            jcaContentVerifierProviderBuilder = new JcaContentVerifierProviderBuilder();
                            jcaContentVerifierProviderBuilder.setProvider(ProvUtils.bcProvider);
                            if (basicOCSPResp.isSignatureValid(jcaContentVerifierProviderBuilder.build(((Certificate)object3).getPublicKey()))) {
                                certStatusValidation.setValidationType(StatusValidation.EMBEDDED_OCSP);
                                certStatusValidation.setOcsp(basicOCSPResp);
                                revokedStatus = (RevokedStatus)basicOCSPResp.getResponses()[0].getCertStatus();
                                if (revokedStatus != null && revokedStatus.getRevocationTime().before(date)) {
                                    certStatusValidation.setRevocationDate(revokedStatus.getRevocationTime());
                                    certStatusValidation.setReasonCode(revokedStatus.getRevocationReason());
                                    certStatusValidation.setRevoked(true);
                                    break;
                                }
                                certStatusValidation.setRevoked(false);
                                break;
                            }
                        }
                        if (certStatusValidation.getValidationType() != StatusValidation.NONE) break;
                    }
                    if (certStatusValidation.getValidationType() == StatusValidation.NONE) {
                        continue;
                    }
                    break;
                }
            }
            finally {
                if (object != null) {
                    ((File)object).delete();
                }
            }
        }
        return certStatusValidation;
    }

    public static CertStatusValidation retrieveCertificateStatus(X509Certificate x509Certificate, LevelValidation levelValidation) throws CertDBException, CapiException, CertificateEncodingException, CertificateException, OCSPException, IOException, OperatorCreationException {
        return LevelValidationUtils.a(levelValidation.getVerificationDate(), x509Certificate, levelValidation.getChain(), levelValidation.getOcsps(), levelValidation.getCrls());
    }
}

