/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.build;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import proguard.retrace.ReTrace;

public class FlushingReTrace {
    private static final String LOGCAT_PREFIX = "(?:[VDIWEF]/.*?\\( *\\d+\\): |\\d\\d-\\d\\d [0-9:. ]+[VDIWEF] .*?: )?";
    private static final String LINE_PARSE_REGEX = "(?:[VDIWEF]/.*?\\( *\\d+\\): |\\d\\d-\\d\\d [0-9:. ]+[VDIWEF] .*?: )?(?:(?:.*?(?::|\\bat)\\s+%c\\.%m\\s*\\(\\s*%s(?:\\s*:\\s*%l\\s*)?\\))|(?:.*java\\.lang\\.NullPointerException.*[\"']%t\\s*%c\\.(?:%f|%m\\(%a\\))[\"'].*)|(?:java\\.lang\\.VerifyError: %c)|(?:java\\.lang\\.NoSuchFieldError: No instance field %f of type .*? in class L%C;)|(?:.*?Object of type %c .*)|(?:.*L%C;.*)|(?:.*?%c#%m.*?)|(?:.* isTestClass for %c)|(?:Caused by: %c:.*)|(?:.*?%c\\.%m)|(?:.*?\"%c\\.%m\".*)|(?:.*\\b(?:[Cc]lass|[Tt]ype)\\b.*?\"%c\".*)|(?:.*\\b(?:[Cc]lass|[Tt]ype)\\b.*?%c)|(?:%c:.*)|(?:%c))";

    private static void usage() {
        System.err.println("Usage: echo $OBFUSCATED_CLASS | java_deobfuscate Foo.apk.mapping");
        System.err.println("Usage: java_deobfuscate Foo.apk.mapping < foo.log");
        System.err.println("Note: Deobfuscation of symbols outside the context of stack traces will work only when lines match the regular expression defined in FlushingReTrace.java.");
        System.err.println("Also: Deobfuscation of method names without associated line numbers does not seem to work.");
        System.exit(1);
    }

    public static void main(String[] args) {
        if (args.length != 1 || args[0].startsWith("-")) {
            FlushingReTrace.usage();
        }
        File mappingFile = new File(args[0]);
        try {
            LineNumberReader reader = new LineNumberReader(new BufferedReader(new InputStreamReader(System.in, "UTF-8")));
            boolean autoFlush = true;
            PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.out, "UTF-8"), autoFlush);
            boolean verbose = false;
            new ReTrace(LINE_PARSE_REGEX, verbose, mappingFile).retrace(reader, writer);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
}

