/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSAudioParam.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSAudioParam.h"
#include "JSAutomationRate.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsAudioParamPrototypeFunction_setValueAtTime);
static JSC_DECLARE_HOST_FUNCTION(jsAudioParamPrototypeFunction_linearRampToValueAtTime);
static JSC_DECLARE_HOST_FUNCTION(jsAudioParamPrototypeFunction_exponentialRampToValueAtTime);
static JSC_DECLARE_HOST_FUNCTION(jsAudioParamPrototypeFunction_setTargetAtTime);
static JSC_DECLARE_HOST_FUNCTION(jsAudioParamPrototypeFunction_setValueCurveAtTime);
static JSC_DECLARE_HOST_FUNCTION(jsAudioParamPrototypeFunction_cancelScheduledValues);
static JSC_DECLARE_HOST_FUNCTION(jsAudioParamPrototypeFunction_cancelAndHoldAtTime);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsAudioParamConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsAudioParam_value);
static JSC_DECLARE_CUSTOM_SETTER(setJSAudioParam_value);
static JSC_DECLARE_CUSTOM_GETTER(jsAudioParam_automationRate);
static JSC_DECLARE_CUSTOM_SETTER(setJSAudioParam_automationRate);
static JSC_DECLARE_CUSTOM_GETTER(jsAudioParam_defaultValue);
static JSC_DECLARE_CUSTOM_GETTER(jsAudioParam_minValue);
static JSC_DECLARE_CUSTOM_GETTER(jsAudioParam_maxValue);

class JSAudioParamPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSAudioParamPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSAudioParamPrototype* ptr = new (NotNull, JSC::allocateCell<JSAudioParamPrototype>(vm)) JSAudioParamPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSAudioParamPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSAudioParamPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSAudioParamPrototype, JSAudioParamPrototype::Base);

using JSAudioParamDOMConstructor = JSDOMConstructorNotConstructable<JSAudioParam>;

template<> const ClassInfo JSAudioParamDOMConstructor::s_info = { "AudioParam"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAudioParamDOMConstructor) };

template<> JSValue JSAudioParamDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSAudioParamDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "AudioParam"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSAudioParam::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSAudioParamPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsAudioParamConstructor, 0 } },
    { "value"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsAudioParam_value, setJSAudioParam_value } },
    { "automationRate"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsAudioParam_automationRate, setJSAudioParam_automationRate } },
    { "defaultValue"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsAudioParam_defaultValue, 0 } },
    { "minValue"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsAudioParam_minValue, 0 } },
    { "maxValue"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsAudioParam_maxValue, 0 } },
    { "setValueAtTime"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsAudioParamPrototypeFunction_setValueAtTime, 2 } },
    { "linearRampToValueAtTime"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsAudioParamPrototypeFunction_linearRampToValueAtTime, 2 } },
    { "exponentialRampToValueAtTime"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsAudioParamPrototypeFunction_exponentialRampToValueAtTime, 2 } },
    { "setTargetAtTime"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsAudioParamPrototypeFunction_setTargetAtTime, 3 } },
    { "setValueCurveAtTime"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsAudioParamPrototypeFunction_setValueCurveAtTime, 3 } },
    { "cancelScheduledValues"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsAudioParamPrototypeFunction_cancelScheduledValues, 1 } },
    { "cancelAndHoldAtTime"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsAudioParamPrototypeFunction_cancelAndHoldAtTime, 1 } },
};

const ClassInfo JSAudioParamPrototype::s_info = { "AudioParam"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAudioParamPrototype) };

void JSAudioParamPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSAudioParam::info(), JSAudioParamPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSAudioParam::s_info = { "AudioParam"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSAudioParam) };

JSAudioParam::JSAudioParam(Structure* structure, JSDOMGlobalObject& globalObject, Ref<AudioParam>&& impl)
    : JSDOMWrapper<AudioParam>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, AudioParam>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSAudioParam::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSAudioParamPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSAudioParamPrototype::create(vm, &globalObject, structure);
}

JSObject* JSAudioParam::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSAudioParam>(vm, globalObject);
}

JSValue JSAudioParam::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSAudioParamDOMConstructor, DOMConstructorID::AudioParam>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSAudioParam::destroy(JSC::JSCell* cell)
{
    JSAudioParam* thisObject = static_cast<JSAudioParam*>(cell);
    thisObject->JSAudioParam::~JSAudioParam();
}

JSC_DEFINE_CUSTOM_GETTER(jsAudioParamConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSAudioParamPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSAudioParam::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsAudioParam_valueGetter(JSGlobalObject& lexicalGlobalObject, JSAudioParam& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLFloat>(lexicalGlobalObject, throwScope, impl.valueForBindings())));
}

JSC_DEFINE_CUSTOM_GETTER(jsAudioParam_value, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSAudioParam>::get<jsAudioParam_valueGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSAudioParam_valueSetter(JSGlobalObject& lexicalGlobalObject, JSAudioParam& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLFloat>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setValueForBindings(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSAudioParam_value, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSAudioParam>::set<setJSAudioParam_valueSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsAudioParam_automationRateGetter(JSGlobalObject& lexicalGlobalObject, JSAudioParam& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLEnumeration<AutomationRate>>(lexicalGlobalObject, throwScope, impl.automationRate())));
}

JSC_DEFINE_CUSTOM_GETTER(jsAudioParam_automationRate, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSAudioParam>::get<jsAudioParam_automationRateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSAudioParam_automationRateSetter(JSGlobalObject& lexicalGlobalObject, JSAudioParam& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto optionalNativeValue = parseEnumeration<AutomationRate>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(!optionalNativeValue))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setAutomationRate(optionalNativeValue.value());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSAudioParam_automationRate, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSAudioParam>::set<setJSAudioParam_automationRateSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsAudioParam_defaultValueGetter(JSGlobalObject& lexicalGlobalObject, JSAudioParam& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLFloat>(lexicalGlobalObject, throwScope, impl.defaultValue())));
}

JSC_DEFINE_CUSTOM_GETTER(jsAudioParam_defaultValue, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSAudioParam>::get<jsAudioParam_defaultValueGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsAudioParam_minValueGetter(JSGlobalObject& lexicalGlobalObject, JSAudioParam& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLFloat>(lexicalGlobalObject, throwScope, impl.minValue())));
}

JSC_DEFINE_CUSTOM_GETTER(jsAudioParam_minValue, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSAudioParam>::get<jsAudioParam_minValueGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsAudioParam_maxValueGetter(JSGlobalObject& lexicalGlobalObject, JSAudioParam& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLFloat>(lexicalGlobalObject, throwScope, impl.maxValue())));
}

JSC_DEFINE_CUSTOM_GETTER(jsAudioParam_maxValue, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSAudioParam>::get<jsAudioParam_maxValueGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsAudioParamPrototypeFunction_setValueAtTimeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAudioParam>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLFloat>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(valueConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto startTimeConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(startTimeConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<AudioParam>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.setValueAtTime(valueConversionResult.releaseReturnValue(), startTimeConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsAudioParamPrototypeFunction_setValueAtTime, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSAudioParam>::call<jsAudioParamPrototypeFunction_setValueAtTimeBody>(*lexicalGlobalObject, *callFrame, "setValueAtTime");
}

static inline JSC::EncodedJSValue jsAudioParamPrototypeFunction_linearRampToValueAtTimeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAudioParam>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLFloat>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(valueConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto endTimeConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(endTimeConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<AudioParam>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.linearRampToValueAtTime(valueConversionResult.releaseReturnValue(), endTimeConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsAudioParamPrototypeFunction_linearRampToValueAtTime, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSAudioParam>::call<jsAudioParamPrototypeFunction_linearRampToValueAtTimeBody>(*lexicalGlobalObject, *callFrame, "linearRampToValueAtTime");
}

static inline JSC::EncodedJSValue jsAudioParamPrototypeFunction_exponentialRampToValueAtTimeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAudioParam>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valueConversionResult = convert<IDLFloat>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(valueConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto endTimeConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(endTimeConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<AudioParam>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.exponentialRampToValueAtTime(valueConversionResult.releaseReturnValue(), endTimeConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsAudioParamPrototypeFunction_exponentialRampToValueAtTime, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSAudioParam>::call<jsAudioParamPrototypeFunction_exponentialRampToValueAtTimeBody>(*lexicalGlobalObject, *callFrame, "exponentialRampToValueAtTime");
}

static inline JSC::EncodedJSValue jsAudioParamPrototypeFunction_setTargetAtTimeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAudioParam>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto targetConversionResult = convert<IDLFloat>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(targetConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto startTimeConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(startTimeConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto timeConstantConversionResult = convert<IDLFloat>(*lexicalGlobalObject, argument2.value());
    if (UNLIKELY(timeConstantConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<AudioParam>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.setTargetAtTime(targetConversionResult.releaseReturnValue(), startTimeConversionResult.releaseReturnValue(), timeConstantConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsAudioParamPrototypeFunction_setTargetAtTime, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSAudioParam>::call<jsAudioParamPrototypeFunction_setTargetAtTimeBody>(*lexicalGlobalObject, *callFrame, "setTargetAtTime");
}

static inline JSC::EncodedJSValue jsAudioParamPrototypeFunction_setValueCurveAtTimeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAudioParam>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto valuesConversionResult = convert<IDLSequence<IDLFloat>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(valuesConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto startTimeConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(startTimeConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto durationConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument2.value());
    if (UNLIKELY(durationConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<AudioParam>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.setValueCurveAtTime(valuesConversionResult.releaseReturnValue(), startTimeConversionResult.releaseReturnValue(), durationConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsAudioParamPrototypeFunction_setValueCurveAtTime, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSAudioParam>::call<jsAudioParamPrototypeFunction_setValueCurveAtTimeBody>(*lexicalGlobalObject, *callFrame, "setValueCurveAtTime");
}

static inline JSC::EncodedJSValue jsAudioParamPrototypeFunction_cancelScheduledValuesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAudioParam>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto cancelTimeConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(cancelTimeConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<AudioParam>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.cancelScheduledValues(cancelTimeConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsAudioParamPrototypeFunction_cancelScheduledValues, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSAudioParam>::call<jsAudioParamPrototypeFunction_cancelScheduledValuesBody>(*lexicalGlobalObject, *callFrame, "cancelScheduledValues");
}

static inline JSC::EncodedJSValue jsAudioParamPrototypeFunction_cancelAndHoldAtTimeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSAudioParam>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto cancelTimeConversionResult = convert<IDLDouble>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(cancelTimeConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<AudioParam>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.cancelAndHoldAtTime(cancelTimeConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsAudioParamPrototypeFunction_cancelAndHoldAtTime, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSAudioParam>::call<jsAudioParamPrototypeFunction_cancelAndHoldAtTimeBody>(*lexicalGlobalObject, *callFrame, "cancelAndHoldAtTime");
}

JSC::GCClient::IsoSubspace* JSAudioParam::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSAudioParam, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForAudioParam.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForAudioParam = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForAudioParam.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForAudioParam = std::forward<decltype(space)>(space); }
    );
}

void JSAudioParam::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSAudioParam*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSAudioParamOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSAudioParamOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsAudioParam = static_cast<JSAudioParam*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsAudioParam->protectedWrapped().ptr(), jsAudioParam);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7AudioParam@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore10AudioParamE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, AudioParam>, void>> static inline void verifyVTable(AudioParam* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7AudioParam@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore10AudioParamE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // AudioParam has subclasses. If AudioParam has subclasses that get passed
        // to toJS() we currently require AudioParam you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<AudioParam>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<AudioParam>(impl.ptr());
#endif
    return createWrapper<AudioParam>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, AudioParam& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

AudioParam* JSAudioParam::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSAudioParam*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEB_AUDIO)
