/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Display an image in an external viewer (Fiji by default)


The ImageViewer class displays an image with an external image display application.
By default the class will search for a Fiji executable. The image is written out to a temporary file and then
passed to the application.

When the first ImageViewer object is constructed the following environment variables are queried
to set up the external viewer:

SITK_SHOW_EXTENSION: file format extension of the temporary image
file. The default is '.mha', the MetaIO file format.

SITK_SHOW_COMMAND: The user can specify an application other than Fiji
to view images.

The environment variables are not checked for subsequent ImageViewer objects.

C++ includes: sitkImageViewer.h
*/
public class ImageViewer {
  private transient long swigCPtr;
  protected transient boolean swigCMemOwn;

  protected ImageViewer(long cPtr, boolean cMemoryOwn) {
    swigCMemOwn = cMemoryOwn;
    swigCPtr = cPtr;
  }

  protected static long getCPtr(ImageViewer obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(ImageViewer obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_ImageViewer(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  /**
itk::simple::ImageViewer::ImageViewer()
*/
public  ImageViewer() {
    this(SimpleITKJNI.new_ImageViewer(), true);
  }

  /**
virtual std::string itk::simple::ImageViewer::GetName() const

Return the user readable name of the class

*/
public  String getName() {
    return SimpleITKJNI.ImageViewer_getName(swigCPtr, this);
  }

  public static void setGlobalDefaultSearchPath(VectorString path) {
    SimpleITKJNI.ImageViewer_setGlobalDefaultSearchPath(VectorString.getCPtr(path), path);
  }

  public static VectorString getGlobalDefaultSearchPath() {
    return new VectorString(SimpleITKJNI.ImageViewer_getGlobalDefaultSearchPath(), false);
  }

  public static void setGlobalDefaultExecutableNames(VectorString names) {
    SimpleITKJNI.ImageViewer_setGlobalDefaultExecutableNames(VectorString.getCPtr(names), names);
  }

  public static VectorString getGlobalDefaultExecutableNames() {
    return new VectorString(SimpleITKJNI.ImageViewer_getGlobalDefaultExecutableNames(), false);
  }

  public static void setGlobalDefaultFileExtension(String ext) {
    SimpleITKJNI.ImageViewer_setGlobalDefaultFileExtension(ext);
  }

  public static String getGlobalDefaultFileExtension() {
    return SimpleITKJNI.ImageViewer_getGlobalDefaultFileExtension();
  }

  public static void setGlobalDefaultApplication(String app) {
    SimpleITKJNI.ImageViewer_setGlobalDefaultApplication(app);
  }

  public static String getGlobalDefaultApplication() {
    return SimpleITKJNI.ImageViewer_getGlobalDefaultApplication();
  }

  /**
void itk::simple::ImageViewer::SetApplication(const PathType &amp;app, const std::string &amp;command="%a %f")

Set the full path to the viewing application used in the command
string.


The SetApplication method expects the app parameter to be a full path name to the display application's
executable. For instance, on Windows when using Fiji, one would use
the full path to the ImageJ-win64.exe such as:'C:\\Users\\dave\\Fiji.app\\ImageJ-win64.exe'

On Linux, app would be set to something like:'/home/dave/bin/Fiji.app/ImageJ-linux64'

Using this method overrides the default application search.

By default, when this method is called, the command string is set to "%a %f" which simply means the application path followed by the temporary image file.

*/
public  void setApplication(String app, String command) {
    SimpleITKJNI.ImageViewer_setApplication__SWIG_0(swigCPtr, this, app, command);
  }

  /**
void itk::simple::ImageViewer::SetApplication(const PathType &amp;app, const std::string &amp;command="%a %f")

Set the full path to the viewing application used in the command
string.


The SetApplication method expects the app parameter to be a full path name to the display application's
executable. For instance, on Windows when using Fiji, one would use
the full path to the ImageJ-win64.exe such as:'C:\\Users\\dave\\Fiji.app\\ImageJ-win64.exe'

On Linux, app would be set to something like:'/home/dave/bin/Fiji.app/ImageJ-linux64'

Using this method overrides the default application search.

By default, when this method is called, the command string is set to "%a %f" which simply means the application path followed by the temporary image file.

*/
public  void setApplication(String app) {
    SimpleITKJNI.ImageViewer_setApplication__SWIG_1(swigCPtr, this, app);
  }

  /**
const PathType&amp; itk::simple::ImageViewer::GetApplication() const

Get the full path to the viewing application used in the command
string.

*/
public  String getApplication() {
    return SimpleITKJNI.ImageViewer_getApplication(swigCPtr, this);
  }

  /**
void itk::simple::ImageViewer::SetCommand(const std::string &amp;command)

Set the command string used to launch the viewing application.


This command string may include the following tokens:


'a' for the image viewing application (Fiji by default)

'f' for SimpleITK's temporary image file
 For example, the default command string on Linux systems is:


After token substitution it may become:


For another example, the default command string on Mac OS X is:


After token substitution the string may become:


The string after '-eval' is an ImageJ macro the opens the file and sets the title of the
window.

If the 'f' token is not found in the command string, the temporary file name is
automatically appended to the command argument list.

Note: Using the ImageViewer::SetCommand method overrides the default command and/or the SITK_SHOW_COMMAND
environment variable.

*/
public  void setCommand(String command) {
    SimpleITKJNI.ImageViewer_setCommand(swigCPtr, this, command);
  }

  /**
const std::string&amp; itk::simple::ImageViewer::GetCommand() const
*/
public  String getCommand() {
    return SimpleITKJNI.ImageViewer_getCommand(swigCPtr, this);
  }

  public void setFileExtension(String ext) {
    SimpleITKJNI.ImageViewer_setFileExtension(swigCPtr, this, ext);
  }

  public String getFileExtension() {
    return SimpleITKJNI.ImageViewer_getFileExtension(swigCPtr, this);
  }

  public static void setGlobalDefaultDebug(boolean dbg) {
    SimpleITKJNI.ImageViewer_setGlobalDefaultDebug(dbg);
  }

  public static boolean getGlobalDefaultDebug() {
    return SimpleITKJNI.ImageViewer_getGlobalDefaultDebug();
  }

  public static void setGlobalDefaultDebugOn() {
    SimpleITKJNI.ImageViewer_setGlobalDefaultDebugOn();
  }

  public static void setGlobalDefaultDebugOff() {
    SimpleITKJNI.ImageViewer_setGlobalDefaultDebugOff();
  }

  public static void setProcessDelay(long delay) {
    SimpleITKJNI.ImageViewer_setProcessDelay(delay);
  }

  public static long getProcessDelay() {
    return SimpleITKJNI.ImageViewer_getProcessDelay();
  }

  public void setTitle(String t) {
    SimpleITKJNI.ImageViewer_setTitle(swigCPtr, this, t);
  }

  public String getTitle() {
    return SimpleITKJNI.ImageViewer_getTitle(swigCPtr, this);
  }

  /**
void itk::simple::ImageViewer::Execute(const Image &amp;image)

Launch the viewing application to display the given image.

*/
public  void execute(Image image) {
    SimpleITKJNI.ImageViewer_execute(swigCPtr, this, Image.getCPtr(image), image);
  }

  /**
std::string itk::simple::ImageViewer::ToString() const

Print ourself out to a string.

*/
public  String toString() {
    return SimpleITKJNI.ImageViewer_toString(swigCPtr, this);
  }

}
