/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs;

import java.io.File;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import javax.swing.event.ChangeListener;
import org.netbeans.spi.queries.VisibilityQueryImplementation2;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.NbPreferences;

public class GlobalVisibilityQueryImpl
implements VisibilityQueryImplementation2 {
    private final ChangeSupport cs = new ChangeSupport((Object)this);
    private static final String PROP_IGNORED_FILES = "IgnoredFiles";
    private static final String PROP_IGNORE_HIDDEN_FILES_IN_USER_HOME = "IgnoreHiddenFilesInUserHome";
    private Pattern ignoreFilesPattern = null;
    private boolean ignoreHiddenInHome = true;
    private boolean ignoreHiddenInHomeInitialized = false;
    private FileObject home = null;
    private String homePath = null;
    private boolean homeInitialized = false;
    private PreferenceChangeListener preferencesListener = null;

    private static Preferences getPreferences() {
        return NbPreferences.root().node("/org/netbeans/core");
    }

    public boolean isVisible(FileObject fileObject) {
        String string = fileObject.getNameExt();
        if (this.isIgnoreHiddenInHome() && this.isHidden(string) && this.isInHomeFolder(fileObject)) {
            return false;
        }
        return this.isVisible(string);
    }

    public boolean isVisible(File file) {
        String string = file.getName();
        if (this.isIgnoreHiddenInHome() && this.isHidden(string) && this.isInHomeFolder(file)) {
            return false;
        }
        return this.isVisible(string);
    }

    boolean isVisible(String string) {
        Pattern pattern = this.getIgnoreFilesPattern();
        return pattern != null ? !pattern.matcher(string).find() : true;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.cs.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.cs.removeChangeListener(changeListener);
    }

    private boolean isIgnoreHiddenInHome() {
        if (!this.ignoreHiddenInHomeInitialized) {
            this.ignoreHiddenInHome = GlobalVisibilityQueryImpl.getPreferences().getBoolean(PROP_IGNORE_HIDDEN_FILES_IN_USER_HOME, true);
            this.ignoreHiddenInHomeInitialized = true;
        }
        return this.ignoreHiddenInHome;
    }

    private Pattern getIgnoreFilesPattern() {
        if (this.ignoreFilesPattern == null) {
            String string = this.getIgnoredFiles();
            this.ignoreFilesPattern = string != null && string.length() > 0 ? Pattern.compile(string) : null;
        }
        return this.ignoreFilesPattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getIgnoredFiles() {
        PreferenceChangeListener preferenceChangeListener;
        String string = GlobalVisibilityQueryImpl.getPreferences().get(PROP_IGNORED_FILES, "^(CVS|SCCS|vssver.?\\.scc|#.*#|%.*%|_svn)$|~$|^\\.(git|hg|svn|cache|gradle|DS_Store)$|^Thumbs.db$");
        GlobalVisibilityQueryImpl globalVisibilityQueryImpl = this;
        synchronized (globalVisibilityQueryImpl) {
            preferenceChangeListener = this.preferencesListener == null ? (this.preferencesListener = new PreferenceChangeListener(){

                @Override
                public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
                    if (GlobalVisibilityQueryImpl.PROP_IGNORED_FILES.equals(preferenceChangeEvent.getKey())) {
                        GlobalVisibilityQueryImpl.this.ignoreFilesPattern = null;
                        GlobalVisibilityQueryImpl.this.cs.fireChange();
                    } else if (GlobalVisibilityQueryImpl.PROP_IGNORE_HIDDEN_FILES_IN_USER_HOME.equals(preferenceChangeEvent.getKey())) {
                        GlobalVisibilityQueryImpl.this.ignoreHiddenInHomeInitialized = false;
                        GlobalVisibilityQueryImpl.this.cs.fireChange();
                    }
                }
            }) : null;
        }
        if (preferenceChangeListener != null) {
            GlobalVisibilityQueryImpl.getPreferences().addPreferenceChangeListener(preferenceChangeListener);
        }
        return string;
    }

    private boolean isHidden(String string) {
        return string.startsWith(".");
    }

    private boolean isInHomeFolder(FileObject fileObject) {
        FileObject fileObject2;
        if (!this.homeInitialized) {
            this.initializeHome();
        }
        return (fileObject2 = fileObject.getParent()) != null && fileObject2 == this.home;
    }

    private boolean isInHomeFolder(File file) {
        String string;
        if (!this.homeInitialized) {
            this.initializeHome();
        }
        return (string = file.getParent()) != null && string.equals(this.homePath);
    }

    private void initializeHome() {
        String string = System.getProperty("user.home");
        if (string != null) {
            this.homePath = FileUtil.normalizePath((String)string);
            this.home = FileUtil.toFileObject((File)new File(this.homePath));
        }
        this.homeInitialized = true;
    }
}

