// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from LPC408x_7x_v0.7.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/NXP

// +build nxp,lpc408x_7x

// LPC408x/7x M4
//

package nxp

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "LPC408x_7x"
	CPU          = "CM4"
	FPUPresent   = false
	NVICPrioBits = 3
)

// Interrupt numbers.
const (
	// Windowed Watchdog Timer (WWDT)
	IRQ_WWDT = 0

	// Timer0/1/2/3
	IRQ_TIMER0 = 1

	IRQ_TIMER1 = 2

	IRQ_TIMER2 = 3

	IRQ_TIMER3 = 4

	// UART0/2/3
	IRQ_UART0 = 5

	// UART1
	IRQ_UART1 = 6

	IRQ_UART2 = 7

	IRQ_UART3 = 8

	IRQ_PWM1 = 9

	// I2C bus interface
	IRQ_I2C0 = 10

	IRQ_I2C1 = 11

	IRQ_I2C2 = 12

	// SSP controller
	IRQ_SSP0 = 14

	// SSP1 controller
	IRQ_SSP1 = 15

	// Real Time Clock (RTC)
	IRQ_RTC = 17

	// System and clock control
	IRQ_EINT0 = 18

	// System and clock control
	IRQ_EINT1 = 19

	// System and clock control
	IRQ_EINT2 = 20

	// System and clock control
	IRQ_EINT3 = 21

	// Analog-to-Digital Converter (ADC)
	IRQ_ADC = 22

	// System and clock control
	IRQ_BOD = 23

	// USB device controller
	IRQ_USB = 24

	// CAN controller
	IRQ_CAN = 25

	// General Purpose DMA controller Modification
	IRQ_GPDMA = 26

	// I2S interface
	IRQ_I2S = 27

	// Ethernet
	IRQ_ETHERNET = 28

	// SD card
	IRQ_SDMMC = 29

	// Motor Control PWM
	IRQ_MCPWM = 30

	// Quadrature Encoder Interface (QEI)
	IRQ_QEI = 31

	// USB device controller
	IRQ_USB_NEED_CLK = 33

	// UART4
	IRQ_UART4 = 35

	IRQ_SSP2 = 36

	// LCD controller Modification
	IRQ_LCD = 37

	// GPIO
	IRQ_GPIOINT = 38

	// Pulse Width Modulators (PWM0/1)
	IRQ_PWM0 = 39

	// EEPROM/flash
	IRQ_EEPROM = 40

	// Comparators
	IRQ_CMP0 = 41

	// Comparators
	IRQ_CMP1 = 42

	// Highest interrupt number on this device.
	IRQ_max = 42
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export WWDT_IRQHandler
func interruptWWDT() {
	callHandlers(IRQ_WWDT)
}

//export TIMER0_IRQHandler
func interruptTIMER0() {
	callHandlers(IRQ_TIMER0)
}

//export TIMER1_IRQHandler
func interruptTIMER1() {
	callHandlers(IRQ_TIMER1)
}

//export TIMER2_IRQHandler
func interruptTIMER2() {
	callHandlers(IRQ_TIMER2)
}

//export TIMER3_IRQHandler
func interruptTIMER3() {
	callHandlers(IRQ_TIMER3)
}

//export UART0_IRQHandler
func interruptUART0() {
	callHandlers(IRQ_UART0)
}

//export UART1_IRQHandler
func interruptUART1() {
	callHandlers(IRQ_UART1)
}

//export UART2_IRQHandler
func interruptUART2() {
	callHandlers(IRQ_UART2)
}

//export UART3_IRQHandler
func interruptUART3() {
	callHandlers(IRQ_UART3)
}

//export PWM1_IRQHandler
func interruptPWM1() {
	callHandlers(IRQ_PWM1)
}

//export I2C0_IRQHandler
func interruptI2C0() {
	callHandlers(IRQ_I2C0)
}

//export I2C1_IRQHandler
func interruptI2C1() {
	callHandlers(IRQ_I2C1)
}

//export I2C2_IRQHandler
func interruptI2C2() {
	callHandlers(IRQ_I2C2)
}

//export SSP0_IRQHandler
func interruptSSP0() {
	callHandlers(IRQ_SSP0)
}

//export SSP1_IRQHandler
func interruptSSP1() {
	callHandlers(IRQ_SSP1)
}

//export RTC_IRQHandler
func interruptRTC() {
	callHandlers(IRQ_RTC)
}

//export EINT0_IRQHandler
func interruptEINT0() {
	callHandlers(IRQ_EINT0)
}

//export EINT1_IRQHandler
func interruptEINT1() {
	callHandlers(IRQ_EINT1)
}

//export EINT2_IRQHandler
func interruptEINT2() {
	callHandlers(IRQ_EINT2)
}

//export EINT3_IRQHandler
func interruptEINT3() {
	callHandlers(IRQ_EINT3)
}

//export ADC_IRQHandler
func interruptADC() {
	callHandlers(IRQ_ADC)
}

//export BOD_IRQHandler
func interruptBOD() {
	callHandlers(IRQ_BOD)
}

//export USB_IRQHandler
func interruptUSB() {
	callHandlers(IRQ_USB)
}

//export CAN_IRQHandler
func interruptCAN() {
	callHandlers(IRQ_CAN)
}

//export GPDMA_IRQHandler
func interruptGPDMA() {
	callHandlers(IRQ_GPDMA)
}

//export I2S_IRQHandler
func interruptI2S() {
	callHandlers(IRQ_I2S)
}

//export ETHERNET_IRQHandler
func interruptETHERNET() {
	callHandlers(IRQ_ETHERNET)
}

//export SDMMC_IRQHandler
func interruptSDMMC() {
	callHandlers(IRQ_SDMMC)
}

//export MCPWM_IRQHandler
func interruptMCPWM() {
	callHandlers(IRQ_MCPWM)
}

//export QEI_IRQHandler
func interruptQEI() {
	callHandlers(IRQ_QEI)
}

//export USB_NEED_CLK_IRQHandler
func interruptUSB_NEED_CLK() {
	callHandlers(IRQ_USB_NEED_CLK)
}

//export UART4_IRQHandler
func interruptUART4() {
	callHandlers(IRQ_UART4)
}

//export SSP2_IRQHandler
func interruptSSP2() {
	callHandlers(IRQ_SSP2)
}

//export LCD_IRQHandler
func interruptLCD() {
	callHandlers(IRQ_LCD)
}

//export GPIOINT_IRQHandler
func interruptGPIOINT() {
	callHandlers(IRQ_GPIOINT)
}

//export PWM0_IRQHandler
func interruptPWM0() {
	callHandlers(IRQ_PWM0)
}

//export EEPROM_IRQHandler
func interruptEEPROM() {
	callHandlers(IRQ_EEPROM)
}

//export CMP0_IRQHandler
func interruptCMP0() {
	callHandlers(IRQ_CMP0)
}

//export CMP1_IRQHandler
func interruptCMP1() {
	callHandlers(IRQ_CMP1)
}

// Peripherals.
var (
	// EEPROM/flash
	FLASHCTRL = (*FLASHCTRL_Type)(unsafe.Pointer(uintptr(0x200000)))

	// General Purpose DMA controller Modification
	GPDMA = (*GPDMA_Type)(unsafe.Pointer(uintptr(0x20080000)))

	// Ethernet
	ETHERNET = (*ETHERNET_Type)(unsafe.Pointer(uintptr(0x20084000)))

	// LCD controller Modification
	LCD = (*LCD_Type)(unsafe.Pointer(uintptr(0x20088000)))

	// USB device controller
	USB = (*USB_Type)(unsafe.Pointer(uintptr(0x2008c000)))

	// CRC engine
	CRC = (*CRC_Type)(unsafe.Pointer(uintptr(0x20090000)))

	// GPIO
	GPIO = (*GPIO_Type)(unsafe.Pointer(uintptr(0x20098000)))

	// External Memory Controller (EMC)
	EMC = (*EMC_Type)(unsafe.Pointer(uintptr(0x2009c000)))

	// Windowed Watchdog Timer (WWDT)
	WWDT = (*WWDT_Type)(unsafe.Pointer(uintptr(0x40000000)))

	// Timer0/1/2/3
	TIMER0 = (*TIMER0_Type)(unsafe.Pointer(uintptr(0x40004000)))

	// Timer0/1/2/3
	TIMER1 = (*TIMER0_Type)(unsafe.Pointer(uintptr(0x40008000)))

	// UART0/2/3
	UART0 = (*UART0_Type)(unsafe.Pointer(uintptr(0x4000c000)))

	// UART1
	UART1 = (*UART1_Type)(unsafe.Pointer(uintptr(0x40010000)))

	// Pulse Width Modulators (PWM0/1)
	PWM0 = (*PWM_Type)(unsafe.Pointer(uintptr(0x40014000)))

	// I2C bus interface
	I2C0 = (*I2C_Type)(unsafe.Pointer(uintptr(0x4001c000)))

	// Comparators
	COMPARATOR = (*COMPARATOR_Type)(unsafe.Pointer(uintptr(0x40020000)))

	// Real Time Clock (RTC)
	RTC = (*RTC_Type)(unsafe.Pointer(uintptr(0x40024000)))

	// GPIO
	GPIOINT = (*GPIOINT_Type)(unsafe.Pointer(uintptr(0x40028080)))

	// IOCON pin configuration
	IOCON = (*IOCON_Type)(unsafe.Pointer(uintptr(0x4002c000)))

	// SSP1 controller
	SSP1 = (*SSP1_Type)(unsafe.Pointer(uintptr(0x40030000)))

	// Analog-to-Digital Converter (ADC)
	ADC = (*ADC_Type)(unsafe.Pointer(uintptr(0x40034000)))

	// CAN acceptance filter RAM
	CANAFRAM = (*CANAFRAM_Type)(unsafe.Pointer(uintptr(0x40038000)))

	// CAN controller
	CANAF = (*CANAF_Type)(unsafe.Pointer(uintptr(0x4003c000)))

	// CAN controller
	CCAN = (*CCAN_Type)(unsafe.Pointer(uintptr(0x40040000)))

	// CAN controller
	CAN1 = (*CAN_Type)(unsafe.Pointer(uintptr(0x40044000)))

	// SSP controller
	SSP0 = (*SSP1_Type)(unsafe.Pointer(uintptr(0x40088000)))

	// Digital-to-Analog Converter (DAC) Modification
	DAC = (*DAC_Type)(unsafe.Pointer(uintptr(0x4008c000)))

	// Timer0/1/2/3
	TIMER2 = (*TIMER0_Type)(unsafe.Pointer(uintptr(0x40090000)))

	// Timer0/1/2/3
	TIMER3 = (*TIMER0_Type)(unsafe.Pointer(uintptr(0x40094000)))

	// UART0/2/3
	UART2 = (*UART0_Type)(unsafe.Pointer(uintptr(0x40098000)))

	// UART0/2/3
	UART3 = (*UART0_Type)(unsafe.Pointer(uintptr(0x4009c000)))

	// UART4
	UART4 = (*UART4_Type)(unsafe.Pointer(uintptr(0x400a4000)))

	// I2S interface
	I2S = (*I2S_Type)(unsafe.Pointer(uintptr(0x400a8000)))

	// Motor Control PWM
	MCPWM = (*MCPWM_Type)(unsafe.Pointer(uintptr(0x400b8000)))

	// Quadrature Encoder Interface (QEI)
	QEI = (*QEI_Type)(unsafe.Pointer(uintptr(0x400bc000)))

	// SD card
	SDMMC = (*SDMMC_Type)(unsafe.Pointer(uintptr(0x400c0000)))

	// System and clock control
	SYSCON = (*SYSCON_Type)(unsafe.Pointer(uintptr(0x400fc000)))

	// Pulse Width Modulators (PWM0/1)
	PWM1 = (*PWM_Type)(unsafe.Pointer(uintptr(0x40018000)))

	// CAN controller
	CAN2 = (*CAN_Type)(unsafe.Pointer(uintptr(0x40048000)))

	// I2C bus interface
	I2C1 = (*I2C_Type)(unsafe.Pointer(uintptr(0x4005c000)))

	// I2C bus interface
	I2C2 = (*I2C_Type)(unsafe.Pointer(uintptr(0x400a0000)))

	// SSP controller
	SSP2 = (*SSP1_Type)(unsafe.Pointer(uintptr(0x400ac000)))
)

// EEPROM/flash
type FLASHCTRL_Type struct {
	_        [32]byte
	FMSSTART volatile.Register32 // 0x20
	FMSSTOP  volatile.Register32 // 0x24
	_        [4]byte
	FMSW0    volatile.Register32 // 0x2C
	FMSW1    volatile.Register32 // 0x30
	FMSW2    volatile.Register32 // 0x34
	FMSW3    volatile.Register32 // 0x38
	_        [68]byte
	EECMD    volatile.Register32 // 0x80
	EEADDR   volatile.Register32 // 0x84
	EEWDATA  volatile.Register32 // 0x88
	EERDATA  volatile.Register32 // 0x8C
	EEWSTATE volatile.Register32 // 0x90
	EECLKDIV volatile.Register32 // 0x94
	EEPWRDWN volatile.Register32 // 0x98
	_        [3900]byte
	ENCLR    volatile.Register32 // 0xFD8
	ENSET    volatile.Register32 // 0xFDC
	STAT     volatile.Register32 // 0xFE0
	INTEN    volatile.Register32 // 0xFE4
	STATCLR  volatile.Register32 // 0xFE8
}

// FLASHCTRL.FMSSTART: Signature start address register
func (o *FLASHCTRL_Type) SetFMSSTART_START(value uint32) {
	volatile.StoreUint32(&o.FMSSTART.Reg, volatile.LoadUint32(&o.FMSSTART.Reg)&^(0x1ffff)|value)
}
func (o *FLASHCTRL_Type) GetFMSSTART_START() uint32 {
	return volatile.LoadUint32(&o.FMSSTART.Reg) & 0x1ffff
}
func (o *FLASHCTRL_Type) SetFMSSTART_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FMSSTART.Reg, volatile.LoadUint32(&o.FMSSTART.Reg)&^(0xfffe0000)|value<<17)
}
func (o *FLASHCTRL_Type) GetFMSSTART_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FMSSTART.Reg) & 0xfffe0000) >> 17
}

// FLASHCTRL.FMSSTOP: Signature stop-address register
func (o *FLASHCTRL_Type) SetFMSSTOP_STOP(value uint32) {
	volatile.StoreUint32(&o.FMSSTOP.Reg, volatile.LoadUint32(&o.FMSSTOP.Reg)&^(0x1ffff)|value)
}
func (o *FLASHCTRL_Type) GetFMSSTOP_STOP() uint32 {
	return volatile.LoadUint32(&o.FMSSTOP.Reg) & 0x1ffff
}
func (o *FLASHCTRL_Type) SetFMSSTOP_SIG_START(value uint32) {
	volatile.StoreUint32(&o.FMSSTOP.Reg, volatile.LoadUint32(&o.FMSSTOP.Reg)&^(0x20000)|value<<17)
}
func (o *FLASHCTRL_Type) GetFMSSTOP_SIG_START() uint32 {
	return (volatile.LoadUint32(&o.FMSSTOP.Reg) & 0x20000) >> 17
}
func (o *FLASHCTRL_Type) SetFMSSTOP_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FMSSTOP.Reg, volatile.LoadUint32(&o.FMSSTOP.Reg)&^(0xfffc0000)|value<<18)
}
func (o *FLASHCTRL_Type) GetFMSSTOP_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FMSSTOP.Reg) & 0xfffc0000) >> 18
}

// FLASHCTRL.FMSW0: 128-bit signature Word 0
func (o *FLASHCTRL_Type) SetFMSW0(value uint32) {
	volatile.StoreUint32(&o.FMSW0.Reg, value)
}
func (o *FLASHCTRL_Type) GetFMSW0() uint32 {
	return volatile.LoadUint32(&o.FMSW0.Reg)
}

// FLASHCTRL.FMSW1: 128-bit signature Word 1
func (o *FLASHCTRL_Type) SetFMSW1(value uint32) {
	volatile.StoreUint32(&o.FMSW1.Reg, value)
}
func (o *FLASHCTRL_Type) GetFMSW1() uint32 {
	return volatile.LoadUint32(&o.FMSW1.Reg)
}

// FLASHCTRL.FMSW2: 128-bit signature Word 2
func (o *FLASHCTRL_Type) SetFMSW2(value uint32) {
	volatile.StoreUint32(&o.FMSW2.Reg, value)
}
func (o *FLASHCTRL_Type) GetFMSW2() uint32 {
	return volatile.LoadUint32(&o.FMSW2.Reg)
}

// FLASHCTRL.FMSW3: 128-bit signature Word 3
func (o *FLASHCTRL_Type) SetFMSW3(value uint32) {
	volatile.StoreUint32(&o.FMSW3.Reg, value)
}
func (o *FLASHCTRL_Type) GetFMSW3() uint32 {
	return volatile.LoadUint32(&o.FMSW3.Reg)
}

// FLASHCTRL.EECMD: EEPROM command register
func (o *FLASHCTRL_Type) SetEECMD_CMD(value uint32) {
	volatile.StoreUint32(&o.EECMD.Reg, volatile.LoadUint32(&o.EECMD.Reg)&^(0x7)|value)
}
func (o *FLASHCTRL_Type) GetEECMD_CMD() uint32 {
	return volatile.LoadUint32(&o.EECMD.Reg) & 0x7
}
func (o *FLASHCTRL_Type) SetEECMD_RDPREFETCH(value uint32) {
	volatile.StoreUint32(&o.EECMD.Reg, volatile.LoadUint32(&o.EECMD.Reg)&^(0x8)|value<<3)
}
func (o *FLASHCTRL_Type) GetEECMD_RDPREFETCH() uint32 {
	return (volatile.LoadUint32(&o.EECMD.Reg) & 0x8) >> 3
}
func (o *FLASHCTRL_Type) SetEECMD_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EECMD.Reg, volatile.LoadUint32(&o.EECMD.Reg)&^(0xfffffff0)|value<<4)
}
func (o *FLASHCTRL_Type) GetEECMD_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EECMD.Reg) & 0xfffffff0) >> 4
}

// FLASHCTRL.EEADDR: EEPROM address register
func (o *FLASHCTRL_Type) SetEEADDR_ADDR(value uint32) {
	volatile.StoreUint32(&o.EEADDR.Reg, volatile.LoadUint32(&o.EEADDR.Reg)&^(0xfff)|value)
}
func (o *FLASHCTRL_Type) GetEEADDR_ADDR() uint32 {
	return volatile.LoadUint32(&o.EEADDR.Reg) & 0xfff
}
func (o *FLASHCTRL_Type) SetEEADDR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EEADDR.Reg, volatile.LoadUint32(&o.EEADDR.Reg)&^(0xfffff000)|value<<12)
}
func (o *FLASHCTRL_Type) GetEEADDR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EEADDR.Reg) & 0xfffff000) >> 12
}

// FLASHCTRL.EEWDATA: EEPROM write data register
func (o *FLASHCTRL_Type) SetEEWDATA(value uint32) {
	volatile.StoreUint32(&o.EEWDATA.Reg, value)
}
func (o *FLASHCTRL_Type) GetEEWDATA() uint32 {
	return volatile.LoadUint32(&o.EEWDATA.Reg)
}

// FLASHCTRL.EERDATA: EEPROM read data register
func (o *FLASHCTRL_Type) SetEERDATA(value uint32) {
	volatile.StoreUint32(&o.EERDATA.Reg, value)
}
func (o *FLASHCTRL_Type) GetEERDATA() uint32 {
	return volatile.LoadUint32(&o.EERDATA.Reg)
}

// FLASHCTRL.EEWSTATE: EEPROM wait state register
func (o *FLASHCTRL_Type) SetEEWSTATE_PHASE3(value uint32) {
	volatile.StoreUint32(&o.EEWSTATE.Reg, volatile.LoadUint32(&o.EEWSTATE.Reg)&^(0xff)|value)
}
func (o *FLASHCTRL_Type) GetEEWSTATE_PHASE3() uint32 {
	return volatile.LoadUint32(&o.EEWSTATE.Reg) & 0xff
}
func (o *FLASHCTRL_Type) SetEEWSTATE_PHASE2(value uint32) {
	volatile.StoreUint32(&o.EEWSTATE.Reg, volatile.LoadUint32(&o.EEWSTATE.Reg)&^(0xff00)|value<<8)
}
func (o *FLASHCTRL_Type) GetEEWSTATE_PHASE2() uint32 {
	return (volatile.LoadUint32(&o.EEWSTATE.Reg) & 0xff00) >> 8
}
func (o *FLASHCTRL_Type) SetEEWSTATE_PHASE1(value uint32) {
	volatile.StoreUint32(&o.EEWSTATE.Reg, volatile.LoadUint32(&o.EEWSTATE.Reg)&^(0xff0000)|value<<16)
}
func (o *FLASHCTRL_Type) GetEEWSTATE_PHASE1() uint32 {
	return (volatile.LoadUint32(&o.EEWSTATE.Reg) & 0xff0000) >> 16
}
func (o *FLASHCTRL_Type) SetEEWSTATE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EEWSTATE.Reg, volatile.LoadUint32(&o.EEWSTATE.Reg)&^(0xff000000)|value<<24)
}
func (o *FLASHCTRL_Type) GetEEWSTATE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EEWSTATE.Reg) & 0xff000000) >> 24
}

// FLASHCTRL.EECLKDIV: EEPROM clock divider register
func (o *FLASHCTRL_Type) SetEECLKDIV_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.EECLKDIV.Reg, volatile.LoadUint32(&o.EECLKDIV.Reg)&^(0xffff)|value)
}
func (o *FLASHCTRL_Type) GetEECLKDIV_CLKDIV() uint32 {
	return volatile.LoadUint32(&o.EECLKDIV.Reg) & 0xffff
}
func (o *FLASHCTRL_Type) SetEECLKDIV_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EECLKDIV.Reg, volatile.LoadUint32(&o.EECLKDIV.Reg)&^(0xffff0000)|value<<16)
}
func (o *FLASHCTRL_Type) GetEECLKDIV_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EECLKDIV.Reg) & 0xffff0000) >> 16
}

// FLASHCTRL.EEPWRDWN: EEPROM power-down register
func (o *FLASHCTRL_Type) SetEEPWRDWN_PWRDWN(value uint32) {
	volatile.StoreUint32(&o.EEPWRDWN.Reg, volatile.LoadUint32(&o.EEPWRDWN.Reg)&^(0x1)|value)
}
func (o *FLASHCTRL_Type) GetEEPWRDWN_PWRDWN() uint32 {
	return volatile.LoadUint32(&o.EEPWRDWN.Reg) & 0x1
}
func (o *FLASHCTRL_Type) SetEEPWRDWN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EEPWRDWN.Reg, volatile.LoadUint32(&o.EEPWRDWN.Reg)&^(0xfffffffe)|value<<1)
}
func (o *FLASHCTRL_Type) GetEEPWRDWN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EEPWRDWN.Reg) & 0xfffffffe) >> 1
}

// FLASHCTRL.ENCLR: EEPROM interrupt enable clear
func (o *FLASHCTRL_Type) SetENCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENCLR.Reg, volatile.LoadUint32(&o.ENCLR.Reg)&^(0x3ffffff)|value)
}
func (o *FLASHCTRL_Type) GetENCLR_RESERVED() uint32 {
	return volatile.LoadUint32(&o.ENCLR.Reg) & 0x3ffffff
}
func (o *FLASHCTRL_Type) SetENCLR_RDWR_CLR_EN(value uint32) {
	volatile.StoreUint32(&o.ENCLR.Reg, volatile.LoadUint32(&o.ENCLR.Reg)&^(0x4000000)|value<<26)
}
func (o *FLASHCTRL_Type) GetENCLR_RDWR_CLR_EN() uint32 {
	return (volatile.LoadUint32(&o.ENCLR.Reg) & 0x4000000) >> 26
}
func (o *FLASHCTRL_Type) SetENCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENCLR.Reg, volatile.LoadUint32(&o.ENCLR.Reg)&^(0x8000000)|value<<27)
}
func (o *FLASHCTRL_Type) GetENCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENCLR.Reg) & 0x8000000) >> 27
}
func (o *FLASHCTRL_Type) SetENCLR_PROG1_CLR_EN(value uint32) {
	volatile.StoreUint32(&o.ENCLR.Reg, volatile.LoadUint32(&o.ENCLR.Reg)&^(0x10000000)|value<<28)
}
func (o *FLASHCTRL_Type) GetENCLR_PROG1_CLR_EN() uint32 {
	return (volatile.LoadUint32(&o.ENCLR.Reg) & 0x10000000) >> 28
}
func (o *FLASHCTRL_Type) SetENCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENCLR.Reg, volatile.LoadUint32(&o.ENCLR.Reg)&^(0xe0000000)|value<<29)
}
func (o *FLASHCTRL_Type) GetENCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENCLR.Reg) & 0xe0000000) >> 29
}

// FLASHCTRL.ENSET: EEPROM interrupt enable set
func (o *FLASHCTRL_Type) SetENSET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENSET.Reg, volatile.LoadUint32(&o.ENSET.Reg)&^(0x3ffffff)|value)
}
func (o *FLASHCTRL_Type) GetENSET_RESERVED() uint32 {
	return volatile.LoadUint32(&o.ENSET.Reg) & 0x3ffffff
}
func (o *FLASHCTRL_Type) SetENSET_RDWR_SET_EN(value uint32) {
	volatile.StoreUint32(&o.ENSET.Reg, volatile.LoadUint32(&o.ENSET.Reg)&^(0x4000000)|value<<26)
}
func (o *FLASHCTRL_Type) GetENSET_RDWR_SET_EN() uint32 {
	return (volatile.LoadUint32(&o.ENSET.Reg) & 0x4000000) >> 26
}
func (o *FLASHCTRL_Type) SetENSET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENSET.Reg, volatile.LoadUint32(&o.ENSET.Reg)&^(0x8000000)|value<<27)
}
func (o *FLASHCTRL_Type) GetENSET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENSET.Reg) & 0x8000000) >> 27
}
func (o *FLASHCTRL_Type) SetENSET_PROG1_SET_EN(value uint32) {
	volatile.StoreUint32(&o.ENSET.Reg, volatile.LoadUint32(&o.ENSET.Reg)&^(0x10000000)|value<<28)
}
func (o *FLASHCTRL_Type) GetENSET_PROG1_SET_EN() uint32 {
	return (volatile.LoadUint32(&o.ENSET.Reg) & 0x10000000) >> 28
}
func (o *FLASHCTRL_Type) SetENSET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENSET.Reg, volatile.LoadUint32(&o.ENSET.Reg)&^(0xe0000000)|value<<29)
}
func (o *FLASHCTRL_Type) GetENSET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENSET.Reg) & 0xe0000000) >> 29
}

// FLASHCTRL.STAT: Signature generation status register
func (o *FLASHCTRL_Type) SetSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x3)|value)
}
func (o *FLASHCTRL_Type) GetSTAT_RESERVED() uint32 {
	return volatile.LoadUint32(&o.STAT.Reg) & 0x3
}
func (o *FLASHCTRL_Type) SetSTAT_SIG_DONE(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x4)|value<<2)
}
func (o *FLASHCTRL_Type) GetSTAT_SIG_DONE() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x4) >> 2
}
func (o *FLASHCTRL_Type) SetSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x3fffff8)|value<<3)
}
func (o *FLASHCTRL_Type) GetSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x3fffff8) >> 3
}
func (o *FLASHCTRL_Type) SetSTAT_END_OF_RDWR(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x4000000)|value<<26)
}
func (o *FLASHCTRL_Type) GetSTAT_END_OF_RDWR() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x4000000) >> 26
}
func (o *FLASHCTRL_Type) SetSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x8000000)|value<<27)
}
func (o *FLASHCTRL_Type) GetSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x8000000) >> 27
}
func (o *FLASHCTRL_Type) SetSTAT_END_OF_PROG1(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x10000000)|value<<28)
}
func (o *FLASHCTRL_Type) GetSTAT_END_OF_PROG1() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x10000000) >> 28
}
func (o *FLASHCTRL_Type) SetSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0xe0000000)|value<<29)
}
func (o *FLASHCTRL_Type) GetSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0xe0000000) >> 29
}

// FLASHCTRL.INTEN: EEPROM interrupt enable
func (o *FLASHCTRL_Type) SetINTEN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x3ffffff)|value)
}
func (o *FLASHCTRL_Type) GetINTEN_RESERVED() uint32 {
	return volatile.LoadUint32(&o.INTEN.Reg) & 0x3ffffff
}
func (o *FLASHCTRL_Type) SetINTEN_EE_RW_DONE(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4000000)|value<<26)
}
func (o *FLASHCTRL_Type) GetINTEN_EE_RW_DONE() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4000000) >> 26
}
func (o *FLASHCTRL_Type) SetINTEN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x8000000)|value<<27)
}
func (o *FLASHCTRL_Type) GetINTEN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x8000000) >> 27
}
func (o *FLASHCTRL_Type) SetINTEN_EE_PROG_DONE(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x10000000)|value<<28)
}
func (o *FLASHCTRL_Type) GetINTEN_EE_PROG_DONE() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x10000000) >> 28
}
func (o *FLASHCTRL_Type) SetINTEN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0xe0000000)|value<<29)
}
func (o *FLASHCTRL_Type) GetINTEN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0xe0000000) >> 29
}

// FLASHCTRL.STATCLR: Signature generation status clear register
func (o *FLASHCTRL_Type) SetSTATCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATCLR.Reg, volatile.LoadUint32(&o.STATCLR.Reg)&^(0x3)|value)
}
func (o *FLASHCTRL_Type) GetSTATCLR_RESERVED() uint32 {
	return volatile.LoadUint32(&o.STATCLR.Reg) & 0x3
}
func (o *FLASHCTRL_Type) SetSTATCLR_SIG_DONE_CLR(value uint32) {
	volatile.StoreUint32(&o.STATCLR.Reg, volatile.LoadUint32(&o.STATCLR.Reg)&^(0x4)|value<<2)
}
func (o *FLASHCTRL_Type) GetSTATCLR_SIG_DONE_CLR() uint32 {
	return (volatile.LoadUint32(&o.STATCLR.Reg) & 0x4) >> 2
}
func (o *FLASHCTRL_Type) SetSTATCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATCLR.Reg, volatile.LoadUint32(&o.STATCLR.Reg)&^(0x3fffff8)|value<<3)
}
func (o *FLASHCTRL_Type) GetSTATCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATCLR.Reg) & 0x3fffff8) >> 3
}
func (o *FLASHCTRL_Type) SetSTATCLR_RDWR_CLR_ST(value uint32) {
	volatile.StoreUint32(&o.STATCLR.Reg, volatile.LoadUint32(&o.STATCLR.Reg)&^(0x4000000)|value<<26)
}
func (o *FLASHCTRL_Type) GetSTATCLR_RDWR_CLR_ST() uint32 {
	return (volatile.LoadUint32(&o.STATCLR.Reg) & 0x4000000) >> 26
}
func (o *FLASHCTRL_Type) SetSTATCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATCLR.Reg, volatile.LoadUint32(&o.STATCLR.Reg)&^(0x8000000)|value<<27)
}
func (o *FLASHCTRL_Type) GetSTATCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATCLR.Reg) & 0x8000000) >> 27
}
func (o *FLASHCTRL_Type) SetSTATCLR_PROG1_CLR_ST(value uint32) {
	volatile.StoreUint32(&o.STATCLR.Reg, volatile.LoadUint32(&o.STATCLR.Reg)&^(0x10000000)|value<<28)
}
func (o *FLASHCTRL_Type) GetSTATCLR_PROG1_CLR_ST() uint32 {
	return (volatile.LoadUint32(&o.STATCLR.Reg) & 0x10000000) >> 28
}
func (o *FLASHCTRL_Type) SetSTATCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATCLR.Reg, volatile.LoadUint32(&o.STATCLR.Reg)&^(0xe0000000)|value<<29)
}
func (o *FLASHCTRL_Type) GetSTATCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATCLR.Reg) & 0xe0000000) >> 29
}

// General Purpose DMA controller Modification
type GPDMA_Type struct {
	INTSTAT       volatile.Register32 // 0x0
	INTTCSTAT     volatile.Register32 // 0x4
	INTTCCLEAR    volatile.Register32 // 0x8
	INTERRSTAT    volatile.Register32 // 0xC
	INTERRCLR     volatile.Register32 // 0x10
	RAWINTTCSTAT  volatile.Register32 // 0x14
	RAWINTERRSTAT volatile.Register32 // 0x18
	ENBLDCHNS     volatile.Register32 // 0x1C
	SOFTBREQ      volatile.Register32 // 0x20
	SOFTSREQ      volatile.Register32 // 0x24
	SOFTLBREQ     volatile.Register32 // 0x28
	SOFTLSREQ     volatile.Register32 // 0x2C
	CONFIG        volatile.Register32 // 0x30
	SYNC          volatile.Register32 // 0x34
	_             [200]byte
	SRCADDR0      volatile.Register32 // 0x100
	DESTADDR0     volatile.Register32 // 0x104
	LLI0          volatile.Register32 // 0x108
	CONTROL0      volatile.Register32 // 0x10C
	CONFIG0       volatile.Register32 // 0x110
	_             [12]byte
	SRCADDR1      volatile.Register32 // 0x120
	DESTADDR1     volatile.Register32 // 0x124
	LLI1          volatile.Register32 // 0x128
	CONTROL1      volatile.Register32 // 0x12C
	CONFIG1       volatile.Register32 // 0x130
	_             [12]byte
	SRCADDR2      volatile.Register32 // 0x140
	DESTADDR2     volatile.Register32 // 0x144
	LLI2          volatile.Register32 // 0x148
	CONTROL2      volatile.Register32 // 0x14C
	CONFIG2       volatile.Register32 // 0x150
	_             [12]byte
	SRCADDR3      volatile.Register32 // 0x160
	DESTADDR3     volatile.Register32 // 0x164
	LLI3          volatile.Register32 // 0x168
	CONTROL3      volatile.Register32 // 0x16C
	CONFIG3       volatile.Register32 // 0x170
	_             [12]byte
	SRCADDR4      volatile.Register32 // 0x180
	DESTADDR4     volatile.Register32 // 0x184
	LLI4          volatile.Register32 // 0x188
	CONTROL4      volatile.Register32 // 0x18C
	CONFIG4       volatile.Register32 // 0x190
	_             [12]byte
	SRCADDR5      volatile.Register32 // 0x1A0
	DESTADDR5     volatile.Register32 // 0x1A4
	LLI5          volatile.Register32 // 0x1A8
	CONTROL5      volatile.Register32 // 0x1AC
	CONFIG5       volatile.Register32 // 0x1B0
	_             [12]byte
	SRCADDR6      volatile.Register32 // 0x1C0
	DESTADDR6     volatile.Register32 // 0x1C4
	LLI6          volatile.Register32 // 0x1C8
	CONTROL6      volatile.Register32 // 0x1CC
	CONFIG6       volatile.Register32 // 0x1D0
	_             [12]byte
	SRCADDR7      volatile.Register32 // 0x1E0
	DESTADDR7     volatile.Register32 // 0x1E4
	LLI7          volatile.Register32 // 0x1E8
	CONTROL7      volatile.Register32 // 0x1EC
	CONFIG7       volatile.Register32 // 0x1F0
}

// GPDMA.INTSTAT: DMA Interrupt Status Register
func (o *GPDMA_Type) SetINTSTAT_INTSTAT0(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetINTSTAT_INTSTAT0() uint32 {
	return volatile.LoadUint32(&o.INTSTAT.Reg) & 0x1
}
func (o *GPDMA_Type) SetINTSTAT_INTSTAT1(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x2)|value<<1)
}
func (o *GPDMA_Type) GetINTSTAT_INTSTAT1() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x2) >> 1
}
func (o *GPDMA_Type) SetINTSTAT_INTSTAT2(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x4)|value<<2)
}
func (o *GPDMA_Type) GetINTSTAT_INTSTAT2() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x4) >> 2
}
func (o *GPDMA_Type) SetINTSTAT_INTSTAT3(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x8)|value<<3)
}
func (o *GPDMA_Type) GetINTSTAT_INTSTAT3() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x8) >> 3
}
func (o *GPDMA_Type) SetINTSTAT_INTSTAT4(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x10)|value<<4)
}
func (o *GPDMA_Type) GetINTSTAT_INTSTAT4() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x10) >> 4
}
func (o *GPDMA_Type) SetINTSTAT_INTSTAT5(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x20)|value<<5)
}
func (o *GPDMA_Type) GetINTSTAT_INTSTAT5() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x20) >> 5
}
func (o *GPDMA_Type) SetINTSTAT_INTSTAT6(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x40)|value<<6)
}
func (o *GPDMA_Type) GetINTSTAT_INTSTAT6() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x40) >> 6
}
func (o *GPDMA_Type) SetINTSTAT_INTSTAT7(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x80)|value<<7)
}
func (o *GPDMA_Type) GetINTSTAT_INTSTAT7() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x80) >> 7
}
func (o *GPDMA_Type) SetINTSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0xffffff00)|value<<8)
}
func (o *GPDMA_Type) GetINTSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0xffffff00) >> 8
}

// GPDMA.INTTCSTAT: DMA Interrupt Terminal Count Request Status Register
func (o *GPDMA_Type) SetINTTCSTAT_INTTCSTAT0(value uint32) {
	volatile.StoreUint32(&o.INTTCSTAT.Reg, volatile.LoadUint32(&o.INTTCSTAT.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetINTTCSTAT_INTTCSTAT0() uint32 {
	return volatile.LoadUint32(&o.INTTCSTAT.Reg) & 0x1
}
func (o *GPDMA_Type) SetINTTCSTAT_INTTCSTAT1(value uint32) {
	volatile.StoreUint32(&o.INTTCSTAT.Reg, volatile.LoadUint32(&o.INTTCSTAT.Reg)&^(0x2)|value<<1)
}
func (o *GPDMA_Type) GetINTTCSTAT_INTTCSTAT1() uint32 {
	return (volatile.LoadUint32(&o.INTTCSTAT.Reg) & 0x2) >> 1
}
func (o *GPDMA_Type) SetINTTCSTAT_INTTCSTAT2(value uint32) {
	volatile.StoreUint32(&o.INTTCSTAT.Reg, volatile.LoadUint32(&o.INTTCSTAT.Reg)&^(0x4)|value<<2)
}
func (o *GPDMA_Type) GetINTTCSTAT_INTTCSTAT2() uint32 {
	return (volatile.LoadUint32(&o.INTTCSTAT.Reg) & 0x4) >> 2
}
func (o *GPDMA_Type) SetINTTCSTAT_INTTCSTAT3(value uint32) {
	volatile.StoreUint32(&o.INTTCSTAT.Reg, volatile.LoadUint32(&o.INTTCSTAT.Reg)&^(0x8)|value<<3)
}
func (o *GPDMA_Type) GetINTTCSTAT_INTTCSTAT3() uint32 {
	return (volatile.LoadUint32(&o.INTTCSTAT.Reg) & 0x8) >> 3
}
func (o *GPDMA_Type) SetINTTCSTAT_INTTCSTAT4(value uint32) {
	volatile.StoreUint32(&o.INTTCSTAT.Reg, volatile.LoadUint32(&o.INTTCSTAT.Reg)&^(0x10)|value<<4)
}
func (o *GPDMA_Type) GetINTTCSTAT_INTTCSTAT4() uint32 {
	return (volatile.LoadUint32(&o.INTTCSTAT.Reg) & 0x10) >> 4
}
func (o *GPDMA_Type) SetINTTCSTAT_INTTCSTAT5(value uint32) {
	volatile.StoreUint32(&o.INTTCSTAT.Reg, volatile.LoadUint32(&o.INTTCSTAT.Reg)&^(0x20)|value<<5)
}
func (o *GPDMA_Type) GetINTTCSTAT_INTTCSTAT5() uint32 {
	return (volatile.LoadUint32(&o.INTTCSTAT.Reg) & 0x20) >> 5
}
func (o *GPDMA_Type) SetINTTCSTAT_INTTCSTAT6(value uint32) {
	volatile.StoreUint32(&o.INTTCSTAT.Reg, volatile.LoadUint32(&o.INTTCSTAT.Reg)&^(0x40)|value<<6)
}
func (o *GPDMA_Type) GetINTTCSTAT_INTTCSTAT6() uint32 {
	return (volatile.LoadUint32(&o.INTTCSTAT.Reg) & 0x40) >> 6
}
func (o *GPDMA_Type) SetINTTCSTAT_INTTCSTAT7(value uint32) {
	volatile.StoreUint32(&o.INTTCSTAT.Reg, volatile.LoadUint32(&o.INTTCSTAT.Reg)&^(0x80)|value<<7)
}
func (o *GPDMA_Type) GetINTTCSTAT_INTTCSTAT7() uint32 {
	return (volatile.LoadUint32(&o.INTTCSTAT.Reg) & 0x80) >> 7
}
func (o *GPDMA_Type) SetINTTCSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTTCSTAT.Reg, volatile.LoadUint32(&o.INTTCSTAT.Reg)&^(0xffffff00)|value<<8)
}
func (o *GPDMA_Type) GetINTTCSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTTCSTAT.Reg) & 0xffffff00) >> 8
}

// GPDMA.INTTCCLEAR: DMA Interrupt Terminal Count Request Clear Register
func (o *GPDMA_Type) SetINTTCCLEAR_INTTCCLEAR0(value uint32) {
	volatile.StoreUint32(&o.INTTCCLEAR.Reg, volatile.LoadUint32(&o.INTTCCLEAR.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetINTTCCLEAR_INTTCCLEAR0() uint32 {
	return volatile.LoadUint32(&o.INTTCCLEAR.Reg) & 0x1
}
func (o *GPDMA_Type) SetINTTCCLEAR_INTTCCLEAR1(value uint32) {
	volatile.StoreUint32(&o.INTTCCLEAR.Reg, volatile.LoadUint32(&o.INTTCCLEAR.Reg)&^(0x2)|value<<1)
}
func (o *GPDMA_Type) GetINTTCCLEAR_INTTCCLEAR1() uint32 {
	return (volatile.LoadUint32(&o.INTTCCLEAR.Reg) & 0x2) >> 1
}
func (o *GPDMA_Type) SetINTTCCLEAR_INTTCCLEAR2(value uint32) {
	volatile.StoreUint32(&o.INTTCCLEAR.Reg, volatile.LoadUint32(&o.INTTCCLEAR.Reg)&^(0x4)|value<<2)
}
func (o *GPDMA_Type) GetINTTCCLEAR_INTTCCLEAR2() uint32 {
	return (volatile.LoadUint32(&o.INTTCCLEAR.Reg) & 0x4) >> 2
}
func (o *GPDMA_Type) SetINTTCCLEAR_INTTCCLEAR3(value uint32) {
	volatile.StoreUint32(&o.INTTCCLEAR.Reg, volatile.LoadUint32(&o.INTTCCLEAR.Reg)&^(0x8)|value<<3)
}
func (o *GPDMA_Type) GetINTTCCLEAR_INTTCCLEAR3() uint32 {
	return (volatile.LoadUint32(&o.INTTCCLEAR.Reg) & 0x8) >> 3
}
func (o *GPDMA_Type) SetINTTCCLEAR_INTTCCLEAR4(value uint32) {
	volatile.StoreUint32(&o.INTTCCLEAR.Reg, volatile.LoadUint32(&o.INTTCCLEAR.Reg)&^(0x10)|value<<4)
}
func (o *GPDMA_Type) GetINTTCCLEAR_INTTCCLEAR4() uint32 {
	return (volatile.LoadUint32(&o.INTTCCLEAR.Reg) & 0x10) >> 4
}
func (o *GPDMA_Type) SetINTTCCLEAR_INTTCCLEAR5(value uint32) {
	volatile.StoreUint32(&o.INTTCCLEAR.Reg, volatile.LoadUint32(&o.INTTCCLEAR.Reg)&^(0x20)|value<<5)
}
func (o *GPDMA_Type) GetINTTCCLEAR_INTTCCLEAR5() uint32 {
	return (volatile.LoadUint32(&o.INTTCCLEAR.Reg) & 0x20) >> 5
}
func (o *GPDMA_Type) SetINTTCCLEAR_INTTCCLEAR6(value uint32) {
	volatile.StoreUint32(&o.INTTCCLEAR.Reg, volatile.LoadUint32(&o.INTTCCLEAR.Reg)&^(0x40)|value<<6)
}
func (o *GPDMA_Type) GetINTTCCLEAR_INTTCCLEAR6() uint32 {
	return (volatile.LoadUint32(&o.INTTCCLEAR.Reg) & 0x40) >> 6
}
func (o *GPDMA_Type) SetINTTCCLEAR_INTTCCLEAR7(value uint32) {
	volatile.StoreUint32(&o.INTTCCLEAR.Reg, volatile.LoadUint32(&o.INTTCCLEAR.Reg)&^(0x80)|value<<7)
}
func (o *GPDMA_Type) GetINTTCCLEAR_INTTCCLEAR7() uint32 {
	return (volatile.LoadUint32(&o.INTTCCLEAR.Reg) & 0x80) >> 7
}
func (o *GPDMA_Type) SetINTTCCLEAR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTTCCLEAR.Reg, volatile.LoadUint32(&o.INTTCCLEAR.Reg)&^(0xffffff00)|value<<8)
}
func (o *GPDMA_Type) GetINTTCCLEAR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTTCCLEAR.Reg) & 0xffffff00) >> 8
}

// GPDMA.INTERRSTAT: DMA Interrupt Error Status Register
func (o *GPDMA_Type) SetINTERRSTAT_INTERRSTAT0(value uint32) {
	volatile.StoreUint32(&o.INTERRSTAT.Reg, volatile.LoadUint32(&o.INTERRSTAT.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetINTERRSTAT_INTERRSTAT0() uint32 {
	return volatile.LoadUint32(&o.INTERRSTAT.Reg) & 0x1
}
func (o *GPDMA_Type) SetINTERRSTAT_INTERRSTAT1(value uint32) {
	volatile.StoreUint32(&o.INTERRSTAT.Reg, volatile.LoadUint32(&o.INTERRSTAT.Reg)&^(0x2)|value<<1)
}
func (o *GPDMA_Type) GetINTERRSTAT_INTERRSTAT1() uint32 {
	return (volatile.LoadUint32(&o.INTERRSTAT.Reg) & 0x2) >> 1
}
func (o *GPDMA_Type) SetINTERRSTAT_INTERRSTAT2(value uint32) {
	volatile.StoreUint32(&o.INTERRSTAT.Reg, volatile.LoadUint32(&o.INTERRSTAT.Reg)&^(0x4)|value<<2)
}
func (o *GPDMA_Type) GetINTERRSTAT_INTERRSTAT2() uint32 {
	return (volatile.LoadUint32(&o.INTERRSTAT.Reg) & 0x4) >> 2
}
func (o *GPDMA_Type) SetINTERRSTAT_INTERRSTAT3(value uint32) {
	volatile.StoreUint32(&o.INTERRSTAT.Reg, volatile.LoadUint32(&o.INTERRSTAT.Reg)&^(0x8)|value<<3)
}
func (o *GPDMA_Type) GetINTERRSTAT_INTERRSTAT3() uint32 {
	return (volatile.LoadUint32(&o.INTERRSTAT.Reg) & 0x8) >> 3
}
func (o *GPDMA_Type) SetINTERRSTAT_INTERRSTAT4(value uint32) {
	volatile.StoreUint32(&o.INTERRSTAT.Reg, volatile.LoadUint32(&o.INTERRSTAT.Reg)&^(0x10)|value<<4)
}
func (o *GPDMA_Type) GetINTERRSTAT_INTERRSTAT4() uint32 {
	return (volatile.LoadUint32(&o.INTERRSTAT.Reg) & 0x10) >> 4
}
func (o *GPDMA_Type) SetINTERRSTAT_INTERRSTAT5(value uint32) {
	volatile.StoreUint32(&o.INTERRSTAT.Reg, volatile.LoadUint32(&o.INTERRSTAT.Reg)&^(0x20)|value<<5)
}
func (o *GPDMA_Type) GetINTERRSTAT_INTERRSTAT5() uint32 {
	return (volatile.LoadUint32(&o.INTERRSTAT.Reg) & 0x20) >> 5
}
func (o *GPDMA_Type) SetINTERRSTAT_INTERRSTAT6(value uint32) {
	volatile.StoreUint32(&o.INTERRSTAT.Reg, volatile.LoadUint32(&o.INTERRSTAT.Reg)&^(0x40)|value<<6)
}
func (o *GPDMA_Type) GetINTERRSTAT_INTERRSTAT6() uint32 {
	return (volatile.LoadUint32(&o.INTERRSTAT.Reg) & 0x40) >> 6
}
func (o *GPDMA_Type) SetINTERRSTAT_INTERRSTAT7(value uint32) {
	volatile.StoreUint32(&o.INTERRSTAT.Reg, volatile.LoadUint32(&o.INTERRSTAT.Reg)&^(0x80)|value<<7)
}
func (o *GPDMA_Type) GetINTERRSTAT_INTERRSTAT7() uint32 {
	return (volatile.LoadUint32(&o.INTERRSTAT.Reg) & 0x80) >> 7
}
func (o *GPDMA_Type) SetINTERRSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTERRSTAT.Reg, volatile.LoadUint32(&o.INTERRSTAT.Reg)&^(0xffffff00)|value<<8)
}
func (o *GPDMA_Type) GetINTERRSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTERRSTAT.Reg) & 0xffffff00) >> 8
}

// GPDMA.INTERRCLR: DMA Interrupt Error Clear Register
func (o *GPDMA_Type) SetINTERRCLR_INTERRCLR0(value uint32) {
	volatile.StoreUint32(&o.INTERRCLR.Reg, volatile.LoadUint32(&o.INTERRCLR.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetINTERRCLR_INTERRCLR0() uint32 {
	return volatile.LoadUint32(&o.INTERRCLR.Reg) & 0x1
}
func (o *GPDMA_Type) SetINTERRCLR_INTERRCLR1(value uint32) {
	volatile.StoreUint32(&o.INTERRCLR.Reg, volatile.LoadUint32(&o.INTERRCLR.Reg)&^(0x2)|value<<1)
}
func (o *GPDMA_Type) GetINTERRCLR_INTERRCLR1() uint32 {
	return (volatile.LoadUint32(&o.INTERRCLR.Reg) & 0x2) >> 1
}
func (o *GPDMA_Type) SetINTERRCLR_INTERRCLR2(value uint32) {
	volatile.StoreUint32(&o.INTERRCLR.Reg, volatile.LoadUint32(&o.INTERRCLR.Reg)&^(0x4)|value<<2)
}
func (o *GPDMA_Type) GetINTERRCLR_INTERRCLR2() uint32 {
	return (volatile.LoadUint32(&o.INTERRCLR.Reg) & 0x4) >> 2
}
func (o *GPDMA_Type) SetINTERRCLR_INTERRCLR3(value uint32) {
	volatile.StoreUint32(&o.INTERRCLR.Reg, volatile.LoadUint32(&o.INTERRCLR.Reg)&^(0x8)|value<<3)
}
func (o *GPDMA_Type) GetINTERRCLR_INTERRCLR3() uint32 {
	return (volatile.LoadUint32(&o.INTERRCLR.Reg) & 0x8) >> 3
}
func (o *GPDMA_Type) SetINTERRCLR_INTERRCLR4(value uint32) {
	volatile.StoreUint32(&o.INTERRCLR.Reg, volatile.LoadUint32(&o.INTERRCLR.Reg)&^(0x10)|value<<4)
}
func (o *GPDMA_Type) GetINTERRCLR_INTERRCLR4() uint32 {
	return (volatile.LoadUint32(&o.INTERRCLR.Reg) & 0x10) >> 4
}
func (o *GPDMA_Type) SetINTERRCLR_INTERRCLR5(value uint32) {
	volatile.StoreUint32(&o.INTERRCLR.Reg, volatile.LoadUint32(&o.INTERRCLR.Reg)&^(0x20)|value<<5)
}
func (o *GPDMA_Type) GetINTERRCLR_INTERRCLR5() uint32 {
	return (volatile.LoadUint32(&o.INTERRCLR.Reg) & 0x20) >> 5
}
func (o *GPDMA_Type) SetINTERRCLR_INTERRCLR6(value uint32) {
	volatile.StoreUint32(&o.INTERRCLR.Reg, volatile.LoadUint32(&o.INTERRCLR.Reg)&^(0x40)|value<<6)
}
func (o *GPDMA_Type) GetINTERRCLR_INTERRCLR6() uint32 {
	return (volatile.LoadUint32(&o.INTERRCLR.Reg) & 0x40) >> 6
}
func (o *GPDMA_Type) SetINTERRCLR_INTERRCLR7(value uint32) {
	volatile.StoreUint32(&o.INTERRCLR.Reg, volatile.LoadUint32(&o.INTERRCLR.Reg)&^(0x80)|value<<7)
}
func (o *GPDMA_Type) GetINTERRCLR_INTERRCLR7() uint32 {
	return (volatile.LoadUint32(&o.INTERRCLR.Reg) & 0x80) >> 7
}
func (o *GPDMA_Type) SetINTERRCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTERRCLR.Reg, volatile.LoadUint32(&o.INTERRCLR.Reg)&^(0xffffff00)|value<<8)
}
func (o *GPDMA_Type) GetINTERRCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTERRCLR.Reg) & 0xffffff00) >> 8
}

// GPDMA.RAWINTTCSTAT: DMA Raw Interrupt Terminal Count Status Register
func (o *GPDMA_Type) SetRAWINTTCSTAT_RAWINTTCSTAT0(value uint32) {
	volatile.StoreUint32(&o.RAWINTTCSTAT.Reg, volatile.LoadUint32(&o.RAWINTTCSTAT.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetRAWINTTCSTAT_RAWINTTCSTAT0() uint32 {
	return volatile.LoadUint32(&o.RAWINTTCSTAT.Reg) & 0x1
}
func (o *GPDMA_Type) SetRAWINTTCSTAT_RAWINTTCSTAT1(value uint32) {
	volatile.StoreUint32(&o.RAWINTTCSTAT.Reg, volatile.LoadUint32(&o.RAWINTTCSTAT.Reg)&^(0x2)|value<<1)
}
func (o *GPDMA_Type) GetRAWINTTCSTAT_RAWINTTCSTAT1() uint32 {
	return (volatile.LoadUint32(&o.RAWINTTCSTAT.Reg) & 0x2) >> 1
}
func (o *GPDMA_Type) SetRAWINTTCSTAT_RAWINTTCSTAT2(value uint32) {
	volatile.StoreUint32(&o.RAWINTTCSTAT.Reg, volatile.LoadUint32(&o.RAWINTTCSTAT.Reg)&^(0x4)|value<<2)
}
func (o *GPDMA_Type) GetRAWINTTCSTAT_RAWINTTCSTAT2() uint32 {
	return (volatile.LoadUint32(&o.RAWINTTCSTAT.Reg) & 0x4) >> 2
}
func (o *GPDMA_Type) SetRAWINTTCSTAT_RAWINTTCSTAT3(value uint32) {
	volatile.StoreUint32(&o.RAWINTTCSTAT.Reg, volatile.LoadUint32(&o.RAWINTTCSTAT.Reg)&^(0x8)|value<<3)
}
func (o *GPDMA_Type) GetRAWINTTCSTAT_RAWINTTCSTAT3() uint32 {
	return (volatile.LoadUint32(&o.RAWINTTCSTAT.Reg) & 0x8) >> 3
}
func (o *GPDMA_Type) SetRAWINTTCSTAT_RAWINTTCSTAT4(value uint32) {
	volatile.StoreUint32(&o.RAWINTTCSTAT.Reg, volatile.LoadUint32(&o.RAWINTTCSTAT.Reg)&^(0x10)|value<<4)
}
func (o *GPDMA_Type) GetRAWINTTCSTAT_RAWINTTCSTAT4() uint32 {
	return (volatile.LoadUint32(&o.RAWINTTCSTAT.Reg) & 0x10) >> 4
}
func (o *GPDMA_Type) SetRAWINTTCSTAT_RAWINTTCSTAT5(value uint32) {
	volatile.StoreUint32(&o.RAWINTTCSTAT.Reg, volatile.LoadUint32(&o.RAWINTTCSTAT.Reg)&^(0x20)|value<<5)
}
func (o *GPDMA_Type) GetRAWINTTCSTAT_RAWINTTCSTAT5() uint32 {
	return (volatile.LoadUint32(&o.RAWINTTCSTAT.Reg) & 0x20) >> 5
}
func (o *GPDMA_Type) SetRAWINTTCSTAT_RAWINTTCSTAT6(value uint32) {
	volatile.StoreUint32(&o.RAWINTTCSTAT.Reg, volatile.LoadUint32(&o.RAWINTTCSTAT.Reg)&^(0x40)|value<<6)
}
func (o *GPDMA_Type) GetRAWINTTCSTAT_RAWINTTCSTAT6() uint32 {
	return (volatile.LoadUint32(&o.RAWINTTCSTAT.Reg) & 0x40) >> 6
}
func (o *GPDMA_Type) SetRAWINTTCSTAT_RAWINTTCSTAT7(value uint32) {
	volatile.StoreUint32(&o.RAWINTTCSTAT.Reg, volatile.LoadUint32(&o.RAWINTTCSTAT.Reg)&^(0x80)|value<<7)
}
func (o *GPDMA_Type) GetRAWINTTCSTAT_RAWINTTCSTAT7() uint32 {
	return (volatile.LoadUint32(&o.RAWINTTCSTAT.Reg) & 0x80) >> 7
}
func (o *GPDMA_Type) SetRAWINTTCSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RAWINTTCSTAT.Reg, volatile.LoadUint32(&o.RAWINTTCSTAT.Reg)&^(0xffffff00)|value<<8)
}
func (o *GPDMA_Type) GetRAWINTTCSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RAWINTTCSTAT.Reg) & 0xffffff00) >> 8
}

// GPDMA.RAWINTERRSTAT: DMA Raw Error Interrupt Status Register
func (o *GPDMA_Type) SetRAWINTERRSTAT_RAWINTERRSTAT0(value uint32) {
	volatile.StoreUint32(&o.RAWINTERRSTAT.Reg, volatile.LoadUint32(&o.RAWINTERRSTAT.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetRAWINTERRSTAT_RAWINTERRSTAT0() uint32 {
	return volatile.LoadUint32(&o.RAWINTERRSTAT.Reg) & 0x1
}
func (o *GPDMA_Type) SetRAWINTERRSTAT_RAWINTERRSTAT1(value uint32) {
	volatile.StoreUint32(&o.RAWINTERRSTAT.Reg, volatile.LoadUint32(&o.RAWINTERRSTAT.Reg)&^(0x2)|value<<1)
}
func (o *GPDMA_Type) GetRAWINTERRSTAT_RAWINTERRSTAT1() uint32 {
	return (volatile.LoadUint32(&o.RAWINTERRSTAT.Reg) & 0x2) >> 1
}
func (o *GPDMA_Type) SetRAWINTERRSTAT_RAWINTERRSTAT2(value uint32) {
	volatile.StoreUint32(&o.RAWINTERRSTAT.Reg, volatile.LoadUint32(&o.RAWINTERRSTAT.Reg)&^(0x4)|value<<2)
}
func (o *GPDMA_Type) GetRAWINTERRSTAT_RAWINTERRSTAT2() uint32 {
	return (volatile.LoadUint32(&o.RAWINTERRSTAT.Reg) & 0x4) >> 2
}
func (o *GPDMA_Type) SetRAWINTERRSTAT_RAWINTERRSTAT3(value uint32) {
	volatile.StoreUint32(&o.RAWINTERRSTAT.Reg, volatile.LoadUint32(&o.RAWINTERRSTAT.Reg)&^(0x8)|value<<3)
}
func (o *GPDMA_Type) GetRAWINTERRSTAT_RAWINTERRSTAT3() uint32 {
	return (volatile.LoadUint32(&o.RAWINTERRSTAT.Reg) & 0x8) >> 3
}
func (o *GPDMA_Type) SetRAWINTERRSTAT_RAWINTERRSTAT4(value uint32) {
	volatile.StoreUint32(&o.RAWINTERRSTAT.Reg, volatile.LoadUint32(&o.RAWINTERRSTAT.Reg)&^(0x10)|value<<4)
}
func (o *GPDMA_Type) GetRAWINTERRSTAT_RAWINTERRSTAT4() uint32 {
	return (volatile.LoadUint32(&o.RAWINTERRSTAT.Reg) & 0x10) >> 4
}
func (o *GPDMA_Type) SetRAWINTERRSTAT_RAWINTERRSTAT5(value uint32) {
	volatile.StoreUint32(&o.RAWINTERRSTAT.Reg, volatile.LoadUint32(&o.RAWINTERRSTAT.Reg)&^(0x20)|value<<5)
}
func (o *GPDMA_Type) GetRAWINTERRSTAT_RAWINTERRSTAT5() uint32 {
	return (volatile.LoadUint32(&o.RAWINTERRSTAT.Reg) & 0x20) >> 5
}
func (o *GPDMA_Type) SetRAWINTERRSTAT_RAWINTERRSTAT6(value uint32) {
	volatile.StoreUint32(&o.RAWINTERRSTAT.Reg, volatile.LoadUint32(&o.RAWINTERRSTAT.Reg)&^(0x40)|value<<6)
}
func (o *GPDMA_Type) GetRAWINTERRSTAT_RAWINTERRSTAT6() uint32 {
	return (volatile.LoadUint32(&o.RAWINTERRSTAT.Reg) & 0x40) >> 6
}
func (o *GPDMA_Type) SetRAWINTERRSTAT_RAWINTERRSTAT7(value uint32) {
	volatile.StoreUint32(&o.RAWINTERRSTAT.Reg, volatile.LoadUint32(&o.RAWINTERRSTAT.Reg)&^(0x80)|value<<7)
}
func (o *GPDMA_Type) GetRAWINTERRSTAT_RAWINTERRSTAT7() uint32 {
	return (volatile.LoadUint32(&o.RAWINTERRSTAT.Reg) & 0x80) >> 7
}
func (o *GPDMA_Type) SetRAWINTERRSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RAWINTERRSTAT.Reg, volatile.LoadUint32(&o.RAWINTERRSTAT.Reg)&^(0xffffff00)|value<<8)
}
func (o *GPDMA_Type) GetRAWINTERRSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RAWINTERRSTAT.Reg) & 0xffffff00) >> 8
}

// GPDMA.ENBLDCHNS: DMA Enabled Channel Register
func (o *GPDMA_Type) SetENBLDCHNS_ENABLEDCHANNELS0(value uint32) {
	volatile.StoreUint32(&o.ENBLDCHNS.Reg, volatile.LoadUint32(&o.ENBLDCHNS.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetENBLDCHNS_ENABLEDCHANNELS0() uint32 {
	return volatile.LoadUint32(&o.ENBLDCHNS.Reg) & 0x1
}
func (o *GPDMA_Type) SetENBLDCHNS_ENABLEDCHANNELS1(value uint32) {
	volatile.StoreUint32(&o.ENBLDCHNS.Reg, volatile.LoadUint32(&o.ENBLDCHNS.Reg)&^(0x2)|value<<1)
}
func (o *GPDMA_Type) GetENBLDCHNS_ENABLEDCHANNELS1() uint32 {
	return (volatile.LoadUint32(&o.ENBLDCHNS.Reg) & 0x2) >> 1
}
func (o *GPDMA_Type) SetENBLDCHNS_ENABLEDCHANNELS2(value uint32) {
	volatile.StoreUint32(&o.ENBLDCHNS.Reg, volatile.LoadUint32(&o.ENBLDCHNS.Reg)&^(0x4)|value<<2)
}
func (o *GPDMA_Type) GetENBLDCHNS_ENABLEDCHANNELS2() uint32 {
	return (volatile.LoadUint32(&o.ENBLDCHNS.Reg) & 0x4) >> 2
}
func (o *GPDMA_Type) SetENBLDCHNS_ENABLEDCHANNELS3(value uint32) {
	volatile.StoreUint32(&o.ENBLDCHNS.Reg, volatile.LoadUint32(&o.ENBLDCHNS.Reg)&^(0x8)|value<<3)
}
func (o *GPDMA_Type) GetENBLDCHNS_ENABLEDCHANNELS3() uint32 {
	return (volatile.LoadUint32(&o.ENBLDCHNS.Reg) & 0x8) >> 3
}
func (o *GPDMA_Type) SetENBLDCHNS_ENABLEDCHANNELS4(value uint32) {
	volatile.StoreUint32(&o.ENBLDCHNS.Reg, volatile.LoadUint32(&o.ENBLDCHNS.Reg)&^(0x10)|value<<4)
}
func (o *GPDMA_Type) GetENBLDCHNS_ENABLEDCHANNELS4() uint32 {
	return (volatile.LoadUint32(&o.ENBLDCHNS.Reg) & 0x10) >> 4
}
func (o *GPDMA_Type) SetENBLDCHNS_ENABLEDCHANNELS5(value uint32) {
	volatile.StoreUint32(&o.ENBLDCHNS.Reg, volatile.LoadUint32(&o.ENBLDCHNS.Reg)&^(0x20)|value<<5)
}
func (o *GPDMA_Type) GetENBLDCHNS_ENABLEDCHANNELS5() uint32 {
	return (volatile.LoadUint32(&o.ENBLDCHNS.Reg) & 0x20) >> 5
}
func (o *GPDMA_Type) SetENBLDCHNS_ENABLEDCHANNELS6(value uint32) {
	volatile.StoreUint32(&o.ENBLDCHNS.Reg, volatile.LoadUint32(&o.ENBLDCHNS.Reg)&^(0x40)|value<<6)
}
func (o *GPDMA_Type) GetENBLDCHNS_ENABLEDCHANNELS6() uint32 {
	return (volatile.LoadUint32(&o.ENBLDCHNS.Reg) & 0x40) >> 6
}
func (o *GPDMA_Type) SetENBLDCHNS_ENABLEDCHANNELS7(value uint32) {
	volatile.StoreUint32(&o.ENBLDCHNS.Reg, volatile.LoadUint32(&o.ENBLDCHNS.Reg)&^(0x80)|value<<7)
}
func (o *GPDMA_Type) GetENBLDCHNS_ENABLEDCHANNELS7() uint32 {
	return (volatile.LoadUint32(&o.ENBLDCHNS.Reg) & 0x80) >> 7
}
func (o *GPDMA_Type) SetENBLDCHNS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENBLDCHNS.Reg, volatile.LoadUint32(&o.ENBLDCHNS.Reg)&^(0xffffff00)|value<<8)
}
func (o *GPDMA_Type) GetENBLDCHNS_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENBLDCHNS.Reg) & 0xffffff00) >> 8
}

// GPDMA.SOFTBREQ: DMA Software Burst Request Register
func (o *GPDMA_Type) SetSOFTBREQ_SOFTBREQ0(value uint32) {
	volatile.StoreUint32(&o.SOFTBREQ.Reg, volatile.LoadUint32(&o.SOFTBREQ.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetSOFTBREQ_SOFTBREQ0() uint32 {
	return volatile.LoadUint32(&o.SOFTBREQ.Reg) & 0x1
}
func (o *GPDMA_Type) SetSOFTBREQ_SOFTBREQ1(value uint32) {
	volatile.StoreUint32(&o.SOFTBREQ.Reg, volatile.LoadUint32(&o.SOFTBREQ.Reg)&^(0x2)|value<<1)
}
func (o *GPDMA_Type) GetSOFTBREQ_SOFTBREQ1() uint32 {
	return (volatile.LoadUint32(&o.SOFTBREQ.Reg) & 0x2) >> 1
}
func (o *GPDMA_Type) SetSOFTBREQ_SOFTBREQ2(value uint32) {
	volatile.StoreUint32(&o.SOFTBREQ.Reg, volatile.LoadUint32(&o.SOFTBREQ.Reg)&^(0x4)|value<<2)
}
func (o *GPDMA_Type) GetSOFTBREQ_SOFTBREQ2() uint32 {
	return (volatile.LoadUint32(&o.SOFTBREQ.Reg) & 0x4) >> 2
}
func (o *GPDMA_Type) SetSOFTBREQ_SOFTBREQ3(value uint32) {
	volatile.StoreUint32(&o.SOFTBREQ.Reg, volatile.LoadUint32(&o.SOFTBREQ.Reg)&^(0x8)|value<<3)
}
func (o *GPDMA_Type) GetSOFTBREQ_SOFTBREQ3() uint32 {
	return (volatile.LoadUint32(&o.SOFTBREQ.Reg) & 0x8) >> 3
}
func (o *GPDMA_Type) SetSOFTBREQ_SOFTBREQ4(value uint32) {
	volatile.StoreUint32(&o.SOFTBREQ.Reg, volatile.LoadUint32(&o.SOFTBREQ.Reg)&^(0x10)|value<<4)
}
func (o *GPDMA_Type) GetSOFTBREQ_SOFTBREQ4() uint32 {
	return (volatile.LoadUint32(&o.SOFTBREQ.Reg) & 0x10) >> 4
}
func (o *GPDMA_Type) SetSOFTBREQ_SOFTBREQ5(value uint32) {
	volatile.StoreUint32(&o.SOFTBREQ.Reg, volatile.LoadUint32(&o.SOFTBREQ.Reg)&^(0x20)|value<<5)
}
func (o *GPDMA_Type) GetSOFTBREQ_SOFTBREQ5() uint32 {
	return (volatile.LoadUint32(&o.SOFTBREQ.Reg) & 0x20) >> 5
}
func (o *GPDMA_Type) SetSOFTBREQ_SOFTBREQ6(value uint32) {
	volatile.StoreUint32(&o.SOFTBREQ.Reg, volatile.LoadUint32(&o.SOFTBREQ.Reg)&^(0x40)|value<<6)
}
func (o *GPDMA_Type) GetSOFTBREQ_SOFTBREQ6() uint32 {
	return (volatile.LoadUint32(&o.SOFTBREQ.Reg) & 0x40) >> 6
}
func (o *GPDMA_Type) SetSOFTBREQ_SOFTBREQ7(value uint32) {
	volatile.StoreUint32(&o.SOFTBREQ.Reg, volatile.LoadUint32(&o.SOFTBREQ.Reg)&^(0x80)|value<<7)
}
func (o *GPDMA_Type) GetSOFTBREQ_SOFTBREQ7() uint32 {
	return (volatile.LoadUint32(&o.SOFTBREQ.Reg) & 0x80) >> 7
}
func (o *GPDMA_Type) SetSOFTBREQ_SOFTBREQ8(value uint32) {
	volatile.StoreUint32(&o.SOFTBREQ.Reg, volatile.LoadUint32(&o.SOFTBREQ.Reg)&^(0x100)|value<<8)
}
func (o *GPDMA_Type) GetSOFTBREQ_SOFTBREQ8() uint32 {
	return (volatile.LoadUint32(&o.SOFTBREQ.Reg) & 0x100) >> 8
}
func (o *GPDMA_Type) SetSOFTBREQ_SOFTBREQ9(value uint32) {
	volatile.StoreUint32(&o.SOFTBREQ.Reg, volatile.LoadUint32(&o.SOFTBREQ.Reg)&^(0x200)|value<<9)
}
func (o *GPDMA_Type) GetSOFTBREQ_SOFTBREQ9() uint32 {
	return (volatile.LoadUint32(&o.SOFTBREQ.Reg) & 0x200) >> 9
}
func (o *GPDMA_Type) SetSOFTBREQ_SOFTBREQ10(value uint32) {
	volatile.StoreUint32(&o.SOFTBREQ.Reg, volatile.LoadUint32(&o.SOFTBREQ.Reg)&^(0x400)|value<<10)
}
func (o *GPDMA_Type) GetSOFTBREQ_SOFTBREQ10() uint32 {
	return (volatile.LoadUint32(&o.SOFTBREQ.Reg) & 0x400) >> 10
}
func (o *GPDMA_Type) SetSOFTBREQ_SOFTBREQ11(value uint32) {
	volatile.StoreUint32(&o.SOFTBREQ.Reg, volatile.LoadUint32(&o.SOFTBREQ.Reg)&^(0x800)|value<<11)
}
func (o *GPDMA_Type) GetSOFTBREQ_SOFTBREQ11() uint32 {
	return (volatile.LoadUint32(&o.SOFTBREQ.Reg) & 0x800) >> 11
}
func (o *GPDMA_Type) SetSOFTBREQ_SOFTBREQ12(value uint32) {
	volatile.StoreUint32(&o.SOFTBREQ.Reg, volatile.LoadUint32(&o.SOFTBREQ.Reg)&^(0x1000)|value<<12)
}
func (o *GPDMA_Type) GetSOFTBREQ_SOFTBREQ12() uint32 {
	return (volatile.LoadUint32(&o.SOFTBREQ.Reg) & 0x1000) >> 12
}
func (o *GPDMA_Type) SetSOFTBREQ_SOFTBREQ13(value uint32) {
	volatile.StoreUint32(&o.SOFTBREQ.Reg, volatile.LoadUint32(&o.SOFTBREQ.Reg)&^(0x2000)|value<<13)
}
func (o *GPDMA_Type) GetSOFTBREQ_SOFTBREQ13() uint32 {
	return (volatile.LoadUint32(&o.SOFTBREQ.Reg) & 0x2000) >> 13
}
func (o *GPDMA_Type) SetSOFTBREQ_SOFTBREQ14(value uint32) {
	volatile.StoreUint32(&o.SOFTBREQ.Reg, volatile.LoadUint32(&o.SOFTBREQ.Reg)&^(0x4000)|value<<14)
}
func (o *GPDMA_Type) GetSOFTBREQ_SOFTBREQ14() uint32 {
	return (volatile.LoadUint32(&o.SOFTBREQ.Reg) & 0x4000) >> 14
}
func (o *GPDMA_Type) SetSOFTBREQ_SOFTBREQ15(value uint32) {
	volatile.StoreUint32(&o.SOFTBREQ.Reg, volatile.LoadUint32(&o.SOFTBREQ.Reg)&^(0x8000)|value<<15)
}
func (o *GPDMA_Type) GetSOFTBREQ_SOFTBREQ15() uint32 {
	return (volatile.LoadUint32(&o.SOFTBREQ.Reg) & 0x8000) >> 15
}
func (o *GPDMA_Type) SetSOFTBREQ_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SOFTBREQ.Reg, volatile.LoadUint32(&o.SOFTBREQ.Reg)&^(0xffff0000)|value<<16)
}
func (o *GPDMA_Type) GetSOFTBREQ_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SOFTBREQ.Reg) & 0xffff0000) >> 16
}

// GPDMA.SOFTSREQ: DMA Software Single Request Register
func (o *GPDMA_Type) SetSOFTSREQ_SOFTSREQ0(value uint32) {
	volatile.StoreUint32(&o.SOFTSREQ.Reg, volatile.LoadUint32(&o.SOFTSREQ.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetSOFTSREQ_SOFTSREQ0() uint32 {
	return volatile.LoadUint32(&o.SOFTSREQ.Reg) & 0x1
}
func (o *GPDMA_Type) SetSOFTSREQ_SOFTSREQ1(value uint32) {
	volatile.StoreUint32(&o.SOFTSREQ.Reg, volatile.LoadUint32(&o.SOFTSREQ.Reg)&^(0x2)|value<<1)
}
func (o *GPDMA_Type) GetSOFTSREQ_SOFTSREQ1() uint32 {
	return (volatile.LoadUint32(&o.SOFTSREQ.Reg) & 0x2) >> 1
}
func (o *GPDMA_Type) SetSOFTSREQ_SOFTSREQ2(value uint32) {
	volatile.StoreUint32(&o.SOFTSREQ.Reg, volatile.LoadUint32(&o.SOFTSREQ.Reg)&^(0x4)|value<<2)
}
func (o *GPDMA_Type) GetSOFTSREQ_SOFTSREQ2() uint32 {
	return (volatile.LoadUint32(&o.SOFTSREQ.Reg) & 0x4) >> 2
}
func (o *GPDMA_Type) SetSOFTSREQ_SOFTSREQ3(value uint32) {
	volatile.StoreUint32(&o.SOFTSREQ.Reg, volatile.LoadUint32(&o.SOFTSREQ.Reg)&^(0x8)|value<<3)
}
func (o *GPDMA_Type) GetSOFTSREQ_SOFTSREQ3() uint32 {
	return (volatile.LoadUint32(&o.SOFTSREQ.Reg) & 0x8) >> 3
}
func (o *GPDMA_Type) SetSOFTSREQ_SOFTSREQ4(value uint32) {
	volatile.StoreUint32(&o.SOFTSREQ.Reg, volatile.LoadUint32(&o.SOFTSREQ.Reg)&^(0x10)|value<<4)
}
func (o *GPDMA_Type) GetSOFTSREQ_SOFTSREQ4() uint32 {
	return (volatile.LoadUint32(&o.SOFTSREQ.Reg) & 0x10) >> 4
}
func (o *GPDMA_Type) SetSOFTSREQ_SOFTSREQ5(value uint32) {
	volatile.StoreUint32(&o.SOFTSREQ.Reg, volatile.LoadUint32(&o.SOFTSREQ.Reg)&^(0x20)|value<<5)
}
func (o *GPDMA_Type) GetSOFTSREQ_SOFTSREQ5() uint32 {
	return (volatile.LoadUint32(&o.SOFTSREQ.Reg) & 0x20) >> 5
}
func (o *GPDMA_Type) SetSOFTSREQ_SOFTSREQ6(value uint32) {
	volatile.StoreUint32(&o.SOFTSREQ.Reg, volatile.LoadUint32(&o.SOFTSREQ.Reg)&^(0x40)|value<<6)
}
func (o *GPDMA_Type) GetSOFTSREQ_SOFTSREQ6() uint32 {
	return (volatile.LoadUint32(&o.SOFTSREQ.Reg) & 0x40) >> 6
}
func (o *GPDMA_Type) SetSOFTSREQ_SOFTSREQ7(value uint32) {
	volatile.StoreUint32(&o.SOFTSREQ.Reg, volatile.LoadUint32(&o.SOFTSREQ.Reg)&^(0x80)|value<<7)
}
func (o *GPDMA_Type) GetSOFTSREQ_SOFTSREQ7() uint32 {
	return (volatile.LoadUint32(&o.SOFTSREQ.Reg) & 0x80) >> 7
}
func (o *GPDMA_Type) SetSOFTSREQ_SOFTSREQ8(value uint32) {
	volatile.StoreUint32(&o.SOFTSREQ.Reg, volatile.LoadUint32(&o.SOFTSREQ.Reg)&^(0x100)|value<<8)
}
func (o *GPDMA_Type) GetSOFTSREQ_SOFTSREQ8() uint32 {
	return (volatile.LoadUint32(&o.SOFTSREQ.Reg) & 0x100) >> 8
}
func (o *GPDMA_Type) SetSOFTSREQ_SOFTSREQ9(value uint32) {
	volatile.StoreUint32(&o.SOFTSREQ.Reg, volatile.LoadUint32(&o.SOFTSREQ.Reg)&^(0x200)|value<<9)
}
func (o *GPDMA_Type) GetSOFTSREQ_SOFTSREQ9() uint32 {
	return (volatile.LoadUint32(&o.SOFTSREQ.Reg) & 0x200) >> 9
}
func (o *GPDMA_Type) SetSOFTSREQ_SOFTSREQ10(value uint32) {
	volatile.StoreUint32(&o.SOFTSREQ.Reg, volatile.LoadUint32(&o.SOFTSREQ.Reg)&^(0x400)|value<<10)
}
func (o *GPDMA_Type) GetSOFTSREQ_SOFTSREQ10() uint32 {
	return (volatile.LoadUint32(&o.SOFTSREQ.Reg) & 0x400) >> 10
}
func (o *GPDMA_Type) SetSOFTSREQ_SOFTSREQ11(value uint32) {
	volatile.StoreUint32(&o.SOFTSREQ.Reg, volatile.LoadUint32(&o.SOFTSREQ.Reg)&^(0x800)|value<<11)
}
func (o *GPDMA_Type) GetSOFTSREQ_SOFTSREQ11() uint32 {
	return (volatile.LoadUint32(&o.SOFTSREQ.Reg) & 0x800) >> 11
}
func (o *GPDMA_Type) SetSOFTSREQ_SOFTSREQ12(value uint32) {
	volatile.StoreUint32(&o.SOFTSREQ.Reg, volatile.LoadUint32(&o.SOFTSREQ.Reg)&^(0x1000)|value<<12)
}
func (o *GPDMA_Type) GetSOFTSREQ_SOFTSREQ12() uint32 {
	return (volatile.LoadUint32(&o.SOFTSREQ.Reg) & 0x1000) >> 12
}
func (o *GPDMA_Type) SetSOFTSREQ_SOFTSREQ13(value uint32) {
	volatile.StoreUint32(&o.SOFTSREQ.Reg, volatile.LoadUint32(&o.SOFTSREQ.Reg)&^(0x2000)|value<<13)
}
func (o *GPDMA_Type) GetSOFTSREQ_SOFTSREQ13() uint32 {
	return (volatile.LoadUint32(&o.SOFTSREQ.Reg) & 0x2000) >> 13
}
func (o *GPDMA_Type) SetSOFTSREQ_SOFTSREQ14(value uint32) {
	volatile.StoreUint32(&o.SOFTSREQ.Reg, volatile.LoadUint32(&o.SOFTSREQ.Reg)&^(0x4000)|value<<14)
}
func (o *GPDMA_Type) GetSOFTSREQ_SOFTSREQ14() uint32 {
	return (volatile.LoadUint32(&o.SOFTSREQ.Reg) & 0x4000) >> 14
}
func (o *GPDMA_Type) SetSOFTSREQ_SOFTSREQ15(value uint32) {
	volatile.StoreUint32(&o.SOFTSREQ.Reg, volatile.LoadUint32(&o.SOFTSREQ.Reg)&^(0x8000)|value<<15)
}
func (o *GPDMA_Type) GetSOFTSREQ_SOFTSREQ15() uint32 {
	return (volatile.LoadUint32(&o.SOFTSREQ.Reg) & 0x8000) >> 15
}
func (o *GPDMA_Type) SetSOFTSREQ_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SOFTSREQ.Reg, volatile.LoadUint32(&o.SOFTSREQ.Reg)&^(0xffff0000)|value<<16)
}
func (o *GPDMA_Type) GetSOFTSREQ_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SOFTSREQ.Reg) & 0xffff0000) >> 16
}

// GPDMA.SOFTLBREQ: DMA Software Last Burst Request Register
func (o *GPDMA_Type) SetSOFTLBREQ_SOFTLBREQ0(value uint32) {
	volatile.StoreUint32(&o.SOFTLBREQ.Reg, volatile.LoadUint32(&o.SOFTLBREQ.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetSOFTLBREQ_SOFTLBREQ0() uint32 {
	return volatile.LoadUint32(&o.SOFTLBREQ.Reg) & 0x1
}
func (o *GPDMA_Type) SetSOFTLBREQ_SOFTLBREQ1(value uint32) {
	volatile.StoreUint32(&o.SOFTLBREQ.Reg, volatile.LoadUint32(&o.SOFTLBREQ.Reg)&^(0x2)|value<<1)
}
func (o *GPDMA_Type) GetSOFTLBREQ_SOFTLBREQ1() uint32 {
	return (volatile.LoadUint32(&o.SOFTLBREQ.Reg) & 0x2) >> 1
}
func (o *GPDMA_Type) SetSOFTLBREQ_SOFTLBREQ2(value uint32) {
	volatile.StoreUint32(&o.SOFTLBREQ.Reg, volatile.LoadUint32(&o.SOFTLBREQ.Reg)&^(0x4)|value<<2)
}
func (o *GPDMA_Type) GetSOFTLBREQ_SOFTLBREQ2() uint32 {
	return (volatile.LoadUint32(&o.SOFTLBREQ.Reg) & 0x4) >> 2
}
func (o *GPDMA_Type) SetSOFTLBREQ_SOFTLBREQ3(value uint32) {
	volatile.StoreUint32(&o.SOFTLBREQ.Reg, volatile.LoadUint32(&o.SOFTLBREQ.Reg)&^(0x8)|value<<3)
}
func (o *GPDMA_Type) GetSOFTLBREQ_SOFTLBREQ3() uint32 {
	return (volatile.LoadUint32(&o.SOFTLBREQ.Reg) & 0x8) >> 3
}
func (o *GPDMA_Type) SetSOFTLBREQ_SOFTLBREQ4(value uint32) {
	volatile.StoreUint32(&o.SOFTLBREQ.Reg, volatile.LoadUint32(&o.SOFTLBREQ.Reg)&^(0x10)|value<<4)
}
func (o *GPDMA_Type) GetSOFTLBREQ_SOFTLBREQ4() uint32 {
	return (volatile.LoadUint32(&o.SOFTLBREQ.Reg) & 0x10) >> 4
}
func (o *GPDMA_Type) SetSOFTLBREQ_SOFTLBREQ5(value uint32) {
	volatile.StoreUint32(&o.SOFTLBREQ.Reg, volatile.LoadUint32(&o.SOFTLBREQ.Reg)&^(0x20)|value<<5)
}
func (o *GPDMA_Type) GetSOFTLBREQ_SOFTLBREQ5() uint32 {
	return (volatile.LoadUint32(&o.SOFTLBREQ.Reg) & 0x20) >> 5
}
func (o *GPDMA_Type) SetSOFTLBREQ_SOFTLBREQ6(value uint32) {
	volatile.StoreUint32(&o.SOFTLBREQ.Reg, volatile.LoadUint32(&o.SOFTLBREQ.Reg)&^(0x40)|value<<6)
}
func (o *GPDMA_Type) GetSOFTLBREQ_SOFTLBREQ6() uint32 {
	return (volatile.LoadUint32(&o.SOFTLBREQ.Reg) & 0x40) >> 6
}
func (o *GPDMA_Type) SetSOFTLBREQ_SOFTLBREQ7(value uint32) {
	volatile.StoreUint32(&o.SOFTLBREQ.Reg, volatile.LoadUint32(&o.SOFTLBREQ.Reg)&^(0x80)|value<<7)
}
func (o *GPDMA_Type) GetSOFTLBREQ_SOFTLBREQ7() uint32 {
	return (volatile.LoadUint32(&o.SOFTLBREQ.Reg) & 0x80) >> 7
}
func (o *GPDMA_Type) SetSOFTLBREQ_SOFTLBREQ8(value uint32) {
	volatile.StoreUint32(&o.SOFTLBREQ.Reg, volatile.LoadUint32(&o.SOFTLBREQ.Reg)&^(0x100)|value<<8)
}
func (o *GPDMA_Type) GetSOFTLBREQ_SOFTLBREQ8() uint32 {
	return (volatile.LoadUint32(&o.SOFTLBREQ.Reg) & 0x100) >> 8
}
func (o *GPDMA_Type) SetSOFTLBREQ_SOFTLBREQ9(value uint32) {
	volatile.StoreUint32(&o.SOFTLBREQ.Reg, volatile.LoadUint32(&o.SOFTLBREQ.Reg)&^(0x200)|value<<9)
}
func (o *GPDMA_Type) GetSOFTLBREQ_SOFTLBREQ9() uint32 {
	return (volatile.LoadUint32(&o.SOFTLBREQ.Reg) & 0x200) >> 9
}
func (o *GPDMA_Type) SetSOFTLBREQ_SOFTLBREQ10(value uint32) {
	volatile.StoreUint32(&o.SOFTLBREQ.Reg, volatile.LoadUint32(&o.SOFTLBREQ.Reg)&^(0x400)|value<<10)
}
func (o *GPDMA_Type) GetSOFTLBREQ_SOFTLBREQ10() uint32 {
	return (volatile.LoadUint32(&o.SOFTLBREQ.Reg) & 0x400) >> 10
}
func (o *GPDMA_Type) SetSOFTLBREQ_SOFTLBREQ11(value uint32) {
	volatile.StoreUint32(&o.SOFTLBREQ.Reg, volatile.LoadUint32(&o.SOFTLBREQ.Reg)&^(0x800)|value<<11)
}
func (o *GPDMA_Type) GetSOFTLBREQ_SOFTLBREQ11() uint32 {
	return (volatile.LoadUint32(&o.SOFTLBREQ.Reg) & 0x800) >> 11
}
func (o *GPDMA_Type) SetSOFTLBREQ_SOFTLBREQ12(value uint32) {
	volatile.StoreUint32(&o.SOFTLBREQ.Reg, volatile.LoadUint32(&o.SOFTLBREQ.Reg)&^(0x1000)|value<<12)
}
func (o *GPDMA_Type) GetSOFTLBREQ_SOFTLBREQ12() uint32 {
	return (volatile.LoadUint32(&o.SOFTLBREQ.Reg) & 0x1000) >> 12
}
func (o *GPDMA_Type) SetSOFTLBREQ_SOFTLBREQ13(value uint32) {
	volatile.StoreUint32(&o.SOFTLBREQ.Reg, volatile.LoadUint32(&o.SOFTLBREQ.Reg)&^(0x2000)|value<<13)
}
func (o *GPDMA_Type) GetSOFTLBREQ_SOFTLBREQ13() uint32 {
	return (volatile.LoadUint32(&o.SOFTLBREQ.Reg) & 0x2000) >> 13
}
func (o *GPDMA_Type) SetSOFTLBREQ_SOFTLBREQ14(value uint32) {
	volatile.StoreUint32(&o.SOFTLBREQ.Reg, volatile.LoadUint32(&o.SOFTLBREQ.Reg)&^(0x4000)|value<<14)
}
func (o *GPDMA_Type) GetSOFTLBREQ_SOFTLBREQ14() uint32 {
	return (volatile.LoadUint32(&o.SOFTLBREQ.Reg) & 0x4000) >> 14
}
func (o *GPDMA_Type) SetSOFTLBREQ_SOFTLBREQ15(value uint32) {
	volatile.StoreUint32(&o.SOFTLBREQ.Reg, volatile.LoadUint32(&o.SOFTLBREQ.Reg)&^(0x8000)|value<<15)
}
func (o *GPDMA_Type) GetSOFTLBREQ_SOFTLBREQ15() uint32 {
	return (volatile.LoadUint32(&o.SOFTLBREQ.Reg) & 0x8000) >> 15
}
func (o *GPDMA_Type) SetSOFTLBREQ_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SOFTLBREQ.Reg, volatile.LoadUint32(&o.SOFTLBREQ.Reg)&^(0xffff0000)|value<<16)
}
func (o *GPDMA_Type) GetSOFTLBREQ_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SOFTLBREQ.Reg) & 0xffff0000) >> 16
}

// GPDMA.SOFTLSREQ: DMA Software Last Single Request Register
func (o *GPDMA_Type) SetSOFTLSREQ_SOFTLSREQ0(value uint32) {
	volatile.StoreUint32(&o.SOFTLSREQ.Reg, volatile.LoadUint32(&o.SOFTLSREQ.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetSOFTLSREQ_SOFTLSREQ0() uint32 {
	return volatile.LoadUint32(&o.SOFTLSREQ.Reg) & 0x1
}
func (o *GPDMA_Type) SetSOFTLSREQ_SOFTLSREQ1(value uint32) {
	volatile.StoreUint32(&o.SOFTLSREQ.Reg, volatile.LoadUint32(&o.SOFTLSREQ.Reg)&^(0x2)|value<<1)
}
func (o *GPDMA_Type) GetSOFTLSREQ_SOFTLSREQ1() uint32 {
	return (volatile.LoadUint32(&o.SOFTLSREQ.Reg) & 0x2) >> 1
}
func (o *GPDMA_Type) SetSOFTLSREQ_SOFTLSREQ2(value uint32) {
	volatile.StoreUint32(&o.SOFTLSREQ.Reg, volatile.LoadUint32(&o.SOFTLSREQ.Reg)&^(0x4)|value<<2)
}
func (o *GPDMA_Type) GetSOFTLSREQ_SOFTLSREQ2() uint32 {
	return (volatile.LoadUint32(&o.SOFTLSREQ.Reg) & 0x4) >> 2
}
func (o *GPDMA_Type) SetSOFTLSREQ_SOFTLSREQ3(value uint32) {
	volatile.StoreUint32(&o.SOFTLSREQ.Reg, volatile.LoadUint32(&o.SOFTLSREQ.Reg)&^(0x8)|value<<3)
}
func (o *GPDMA_Type) GetSOFTLSREQ_SOFTLSREQ3() uint32 {
	return (volatile.LoadUint32(&o.SOFTLSREQ.Reg) & 0x8) >> 3
}
func (o *GPDMA_Type) SetSOFTLSREQ_SOFTLSREQ4(value uint32) {
	volatile.StoreUint32(&o.SOFTLSREQ.Reg, volatile.LoadUint32(&o.SOFTLSREQ.Reg)&^(0x10)|value<<4)
}
func (o *GPDMA_Type) GetSOFTLSREQ_SOFTLSREQ4() uint32 {
	return (volatile.LoadUint32(&o.SOFTLSREQ.Reg) & 0x10) >> 4
}
func (o *GPDMA_Type) SetSOFTLSREQ_SOFTLSREQ5(value uint32) {
	volatile.StoreUint32(&o.SOFTLSREQ.Reg, volatile.LoadUint32(&o.SOFTLSREQ.Reg)&^(0x20)|value<<5)
}
func (o *GPDMA_Type) GetSOFTLSREQ_SOFTLSREQ5() uint32 {
	return (volatile.LoadUint32(&o.SOFTLSREQ.Reg) & 0x20) >> 5
}
func (o *GPDMA_Type) SetSOFTLSREQ_SOFTLSREQ6(value uint32) {
	volatile.StoreUint32(&o.SOFTLSREQ.Reg, volatile.LoadUint32(&o.SOFTLSREQ.Reg)&^(0x40)|value<<6)
}
func (o *GPDMA_Type) GetSOFTLSREQ_SOFTLSREQ6() uint32 {
	return (volatile.LoadUint32(&o.SOFTLSREQ.Reg) & 0x40) >> 6
}
func (o *GPDMA_Type) SetSOFTLSREQ_SOFTLSREQ7(value uint32) {
	volatile.StoreUint32(&o.SOFTLSREQ.Reg, volatile.LoadUint32(&o.SOFTLSREQ.Reg)&^(0x80)|value<<7)
}
func (o *GPDMA_Type) GetSOFTLSREQ_SOFTLSREQ7() uint32 {
	return (volatile.LoadUint32(&o.SOFTLSREQ.Reg) & 0x80) >> 7
}
func (o *GPDMA_Type) SetSOFTLSREQ_SOFTLSREQ8(value uint32) {
	volatile.StoreUint32(&o.SOFTLSREQ.Reg, volatile.LoadUint32(&o.SOFTLSREQ.Reg)&^(0x100)|value<<8)
}
func (o *GPDMA_Type) GetSOFTLSREQ_SOFTLSREQ8() uint32 {
	return (volatile.LoadUint32(&o.SOFTLSREQ.Reg) & 0x100) >> 8
}
func (o *GPDMA_Type) SetSOFTLSREQ_SOFTLSREQ9(value uint32) {
	volatile.StoreUint32(&o.SOFTLSREQ.Reg, volatile.LoadUint32(&o.SOFTLSREQ.Reg)&^(0x200)|value<<9)
}
func (o *GPDMA_Type) GetSOFTLSREQ_SOFTLSREQ9() uint32 {
	return (volatile.LoadUint32(&o.SOFTLSREQ.Reg) & 0x200) >> 9
}
func (o *GPDMA_Type) SetSOFTLSREQ_SOFTLSREQ10(value uint32) {
	volatile.StoreUint32(&o.SOFTLSREQ.Reg, volatile.LoadUint32(&o.SOFTLSREQ.Reg)&^(0x400)|value<<10)
}
func (o *GPDMA_Type) GetSOFTLSREQ_SOFTLSREQ10() uint32 {
	return (volatile.LoadUint32(&o.SOFTLSREQ.Reg) & 0x400) >> 10
}
func (o *GPDMA_Type) SetSOFTLSREQ_SOFTLSREQ11(value uint32) {
	volatile.StoreUint32(&o.SOFTLSREQ.Reg, volatile.LoadUint32(&o.SOFTLSREQ.Reg)&^(0x800)|value<<11)
}
func (o *GPDMA_Type) GetSOFTLSREQ_SOFTLSREQ11() uint32 {
	return (volatile.LoadUint32(&o.SOFTLSREQ.Reg) & 0x800) >> 11
}
func (o *GPDMA_Type) SetSOFTLSREQ_SOFTLSREQ12(value uint32) {
	volatile.StoreUint32(&o.SOFTLSREQ.Reg, volatile.LoadUint32(&o.SOFTLSREQ.Reg)&^(0x1000)|value<<12)
}
func (o *GPDMA_Type) GetSOFTLSREQ_SOFTLSREQ12() uint32 {
	return (volatile.LoadUint32(&o.SOFTLSREQ.Reg) & 0x1000) >> 12
}
func (o *GPDMA_Type) SetSOFTLSREQ_SOFTLSREQ13(value uint32) {
	volatile.StoreUint32(&o.SOFTLSREQ.Reg, volatile.LoadUint32(&o.SOFTLSREQ.Reg)&^(0x2000)|value<<13)
}
func (o *GPDMA_Type) GetSOFTLSREQ_SOFTLSREQ13() uint32 {
	return (volatile.LoadUint32(&o.SOFTLSREQ.Reg) & 0x2000) >> 13
}
func (o *GPDMA_Type) SetSOFTLSREQ_SOFTLSREQ14(value uint32) {
	volatile.StoreUint32(&o.SOFTLSREQ.Reg, volatile.LoadUint32(&o.SOFTLSREQ.Reg)&^(0x4000)|value<<14)
}
func (o *GPDMA_Type) GetSOFTLSREQ_SOFTLSREQ14() uint32 {
	return (volatile.LoadUint32(&o.SOFTLSREQ.Reg) & 0x4000) >> 14
}
func (o *GPDMA_Type) SetSOFTLSREQ_SOFTLSREQ15(value uint32) {
	volatile.StoreUint32(&o.SOFTLSREQ.Reg, volatile.LoadUint32(&o.SOFTLSREQ.Reg)&^(0x8000)|value<<15)
}
func (o *GPDMA_Type) GetSOFTLSREQ_SOFTLSREQ15() uint32 {
	return (volatile.LoadUint32(&o.SOFTLSREQ.Reg) & 0x8000) >> 15
}
func (o *GPDMA_Type) SetSOFTLSREQ_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SOFTLSREQ.Reg, volatile.LoadUint32(&o.SOFTLSREQ.Reg)&^(0xffff0000)|value<<16)
}
func (o *GPDMA_Type) GetSOFTLSREQ_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SOFTLSREQ.Reg) & 0xffff0000) >> 16
}

// GPDMA.CONFIG: DMA Configuration Register
func (o *GPDMA_Type) SetCONFIG_E(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetCONFIG_E() uint32 {
	return volatile.LoadUint32(&o.CONFIG.Reg) & 0x1
}
func (o *GPDMA_Type) SetCONFIG_M(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x2)|value<<1)
}
func (o *GPDMA_Type) GetCONFIG_M() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x2) >> 1
}
func (o *GPDMA_Type) SetCONFIG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0xfffffffc)|value<<2)
}
func (o *GPDMA_Type) GetCONFIG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0xfffffffc) >> 2
}

// GPDMA.SYNC: DMA Synchronization Register
func (o *GPDMA_Type) SetSYNC_DMACSYNC0(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetSYNC_DMACSYNC0() uint32 {
	return volatile.LoadUint32(&o.SYNC.Reg) & 0x1
}
func (o *GPDMA_Type) SetSYNC_DMACSYNC1(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0x2)|value<<1)
}
func (o *GPDMA_Type) GetSYNC_DMACSYNC1() uint32 {
	return (volatile.LoadUint32(&o.SYNC.Reg) & 0x2) >> 1
}
func (o *GPDMA_Type) SetSYNC_DMACSYNC2(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0x4)|value<<2)
}
func (o *GPDMA_Type) GetSYNC_DMACSYNC2() uint32 {
	return (volatile.LoadUint32(&o.SYNC.Reg) & 0x4) >> 2
}
func (o *GPDMA_Type) SetSYNC_DMACSYNC3(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0x8)|value<<3)
}
func (o *GPDMA_Type) GetSYNC_DMACSYNC3() uint32 {
	return (volatile.LoadUint32(&o.SYNC.Reg) & 0x8) >> 3
}
func (o *GPDMA_Type) SetSYNC_DMACSYNC4(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0x10)|value<<4)
}
func (o *GPDMA_Type) GetSYNC_DMACSYNC4() uint32 {
	return (volatile.LoadUint32(&o.SYNC.Reg) & 0x10) >> 4
}
func (o *GPDMA_Type) SetSYNC_DMACSYNC5(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0x20)|value<<5)
}
func (o *GPDMA_Type) GetSYNC_DMACSYNC5() uint32 {
	return (volatile.LoadUint32(&o.SYNC.Reg) & 0x20) >> 5
}
func (o *GPDMA_Type) SetSYNC_DMACSYNC6(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0x40)|value<<6)
}
func (o *GPDMA_Type) GetSYNC_DMACSYNC6() uint32 {
	return (volatile.LoadUint32(&o.SYNC.Reg) & 0x40) >> 6
}
func (o *GPDMA_Type) SetSYNC_DMACSYNC7(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0x80)|value<<7)
}
func (o *GPDMA_Type) GetSYNC_DMACSYNC7() uint32 {
	return (volatile.LoadUint32(&o.SYNC.Reg) & 0x80) >> 7
}
func (o *GPDMA_Type) SetSYNC_DMACSYNC8(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0x100)|value<<8)
}
func (o *GPDMA_Type) GetSYNC_DMACSYNC8() uint32 {
	return (volatile.LoadUint32(&o.SYNC.Reg) & 0x100) >> 8
}
func (o *GPDMA_Type) SetSYNC_DMACSYNC9(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0x200)|value<<9)
}
func (o *GPDMA_Type) GetSYNC_DMACSYNC9() uint32 {
	return (volatile.LoadUint32(&o.SYNC.Reg) & 0x200) >> 9
}
func (o *GPDMA_Type) SetSYNC_DMACSYNC10(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0x400)|value<<10)
}
func (o *GPDMA_Type) GetSYNC_DMACSYNC10() uint32 {
	return (volatile.LoadUint32(&o.SYNC.Reg) & 0x400) >> 10
}
func (o *GPDMA_Type) SetSYNC_DMACSYNC11(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0x800)|value<<11)
}
func (o *GPDMA_Type) GetSYNC_DMACSYNC11() uint32 {
	return (volatile.LoadUint32(&o.SYNC.Reg) & 0x800) >> 11
}
func (o *GPDMA_Type) SetSYNC_DMACSYNC12(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0x1000)|value<<12)
}
func (o *GPDMA_Type) GetSYNC_DMACSYNC12() uint32 {
	return (volatile.LoadUint32(&o.SYNC.Reg) & 0x1000) >> 12
}
func (o *GPDMA_Type) SetSYNC_DMACSYNC13(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0x2000)|value<<13)
}
func (o *GPDMA_Type) GetSYNC_DMACSYNC13() uint32 {
	return (volatile.LoadUint32(&o.SYNC.Reg) & 0x2000) >> 13
}
func (o *GPDMA_Type) SetSYNC_DMACSYNC14(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0x4000)|value<<14)
}
func (o *GPDMA_Type) GetSYNC_DMACSYNC14() uint32 {
	return (volatile.LoadUint32(&o.SYNC.Reg) & 0x4000) >> 14
}
func (o *GPDMA_Type) SetSYNC_DMACSYNC15(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0x8000)|value<<15)
}
func (o *GPDMA_Type) GetSYNC_DMACSYNC15() uint32 {
	return (volatile.LoadUint32(&o.SYNC.Reg) & 0x8000) >> 15
}
func (o *GPDMA_Type) SetSYNC_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0xffff0000)|value<<16)
}
func (o *GPDMA_Type) GetSYNC_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SYNC.Reg) & 0xffff0000) >> 16
}

// GPDMA.SRCADDR0: DMA Channel 0 Source Address Register
func (o *GPDMA_Type) SetSRCADDR0(value uint32) {
	volatile.StoreUint32(&o.SRCADDR0.Reg, value)
}
func (o *GPDMA_Type) GetSRCADDR0() uint32 {
	return volatile.LoadUint32(&o.SRCADDR0.Reg)
}

// GPDMA.DESTADDR0: DMA Channel 0 Destination Address Register
func (o *GPDMA_Type) SetDESTADDR0(value uint32) {
	volatile.StoreUint32(&o.DESTADDR0.Reg, value)
}
func (o *GPDMA_Type) GetDESTADDR0() uint32 {
	return volatile.LoadUint32(&o.DESTADDR0.Reg)
}

// GPDMA.LLI0: DMA Channel 0 Linked List Item Register
func (o *GPDMA_Type) SetLLI0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.LLI0.Reg, volatile.LoadUint32(&o.LLI0.Reg)&^(0x3)|value)
}
func (o *GPDMA_Type) GetLLI0_RESERVED() uint32 {
	return volatile.LoadUint32(&o.LLI0.Reg) & 0x3
}
func (o *GPDMA_Type) SetLLI0_LLI(value uint32) {
	volatile.StoreUint32(&o.LLI0.Reg, volatile.LoadUint32(&o.LLI0.Reg)&^(0xfffffffc)|value<<2)
}
func (o *GPDMA_Type) GetLLI0_LLI() uint32 {
	return (volatile.LoadUint32(&o.LLI0.Reg) & 0xfffffffc) >> 2
}

// GPDMA.CONTROL0: DMA Channel 0 Control Register
func (o *GPDMA_Type) SetCONTROL0_TRANSFERSIZE(value uint32) {
	volatile.StoreUint32(&o.CONTROL0.Reg, volatile.LoadUint32(&o.CONTROL0.Reg)&^(0xfff)|value)
}
func (o *GPDMA_Type) GetCONTROL0_TRANSFERSIZE() uint32 {
	return volatile.LoadUint32(&o.CONTROL0.Reg) & 0xfff
}
func (o *GPDMA_Type) SetCONTROL0_SBSIZE(value uint32) {
	volatile.StoreUint32(&o.CONTROL0.Reg, volatile.LoadUint32(&o.CONTROL0.Reg)&^(0x7000)|value<<12)
}
func (o *GPDMA_Type) GetCONTROL0_SBSIZE() uint32 {
	return (volatile.LoadUint32(&o.CONTROL0.Reg) & 0x7000) >> 12
}
func (o *GPDMA_Type) SetCONTROL0_DBSIZE(value uint32) {
	volatile.StoreUint32(&o.CONTROL0.Reg, volatile.LoadUint32(&o.CONTROL0.Reg)&^(0x38000)|value<<15)
}
func (o *GPDMA_Type) GetCONTROL0_DBSIZE() uint32 {
	return (volatile.LoadUint32(&o.CONTROL0.Reg) & 0x38000) >> 15
}
func (o *GPDMA_Type) SetCONTROL0_SWIDTH(value uint32) {
	volatile.StoreUint32(&o.CONTROL0.Reg, volatile.LoadUint32(&o.CONTROL0.Reg)&^(0x1c0000)|value<<18)
}
func (o *GPDMA_Type) GetCONTROL0_SWIDTH() uint32 {
	return (volatile.LoadUint32(&o.CONTROL0.Reg) & 0x1c0000) >> 18
}
func (o *GPDMA_Type) SetCONTROL0_DWIDTH(value uint32) {
	volatile.StoreUint32(&o.CONTROL0.Reg, volatile.LoadUint32(&o.CONTROL0.Reg)&^(0xe00000)|value<<21)
}
func (o *GPDMA_Type) GetCONTROL0_DWIDTH() uint32 {
	return (volatile.LoadUint32(&o.CONTROL0.Reg) & 0xe00000) >> 21
}
func (o *GPDMA_Type) SetCONTROL0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONTROL0.Reg, volatile.LoadUint32(&o.CONTROL0.Reg)&^(0x3000000)|value<<24)
}
func (o *GPDMA_Type) GetCONTROL0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONTROL0.Reg) & 0x3000000) >> 24
}
func (o *GPDMA_Type) SetCONTROL0_SI(value uint32) {
	volatile.StoreUint32(&o.CONTROL0.Reg, volatile.LoadUint32(&o.CONTROL0.Reg)&^(0x4000000)|value<<26)
}
func (o *GPDMA_Type) GetCONTROL0_SI() uint32 {
	return (volatile.LoadUint32(&o.CONTROL0.Reg) & 0x4000000) >> 26
}
func (o *GPDMA_Type) SetCONTROL0_DI(value uint32) {
	volatile.StoreUint32(&o.CONTROL0.Reg, volatile.LoadUint32(&o.CONTROL0.Reg)&^(0x8000000)|value<<27)
}
func (o *GPDMA_Type) GetCONTROL0_DI() uint32 {
	return (volatile.LoadUint32(&o.CONTROL0.Reg) & 0x8000000) >> 27
}
func (o *GPDMA_Type) SetCONTROL0_PROT1(value uint32) {
	volatile.StoreUint32(&o.CONTROL0.Reg, volatile.LoadUint32(&o.CONTROL0.Reg)&^(0x10000000)|value<<28)
}
func (o *GPDMA_Type) GetCONTROL0_PROT1() uint32 {
	return (volatile.LoadUint32(&o.CONTROL0.Reg) & 0x10000000) >> 28
}
func (o *GPDMA_Type) SetCONTROL0_PROT2(value uint32) {
	volatile.StoreUint32(&o.CONTROL0.Reg, volatile.LoadUint32(&o.CONTROL0.Reg)&^(0x20000000)|value<<29)
}
func (o *GPDMA_Type) GetCONTROL0_PROT2() uint32 {
	return (volatile.LoadUint32(&o.CONTROL0.Reg) & 0x20000000) >> 29
}
func (o *GPDMA_Type) SetCONTROL0_PROT3(value uint32) {
	volatile.StoreUint32(&o.CONTROL0.Reg, volatile.LoadUint32(&o.CONTROL0.Reg)&^(0x40000000)|value<<30)
}
func (o *GPDMA_Type) GetCONTROL0_PROT3() uint32 {
	return (volatile.LoadUint32(&o.CONTROL0.Reg) & 0x40000000) >> 30
}
func (o *GPDMA_Type) SetCONTROL0_I(value uint32) {
	volatile.StoreUint32(&o.CONTROL0.Reg, volatile.LoadUint32(&o.CONTROL0.Reg)&^(0x80000000)|value<<31)
}
func (o *GPDMA_Type) GetCONTROL0_I() uint32 {
	return (volatile.LoadUint32(&o.CONTROL0.Reg) & 0x80000000) >> 31
}

// GPDMA.CONFIG0: DMA Channel 0 Configuration Register[1]
func (o *GPDMA_Type) SetCONFIG0_E(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetCONFIG0_E() uint32 {
	return volatile.LoadUint32(&o.CONFIG0.Reg) & 0x1
}
func (o *GPDMA_Type) SetCONFIG0_SRCPERIPHERAL(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0x3e)|value<<1)
}
func (o *GPDMA_Type) GetCONFIG0_SRCPERIPHERAL() uint32 {
	return (volatile.LoadUint32(&o.CONFIG0.Reg) & 0x3e) >> 1
}
func (o *GPDMA_Type) SetCONFIG0_DESTPERIPHERAL(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0x7c0)|value<<6)
}
func (o *GPDMA_Type) GetCONFIG0_DESTPERIPHERAL() uint32 {
	return (volatile.LoadUint32(&o.CONFIG0.Reg) & 0x7c0) >> 6
}
func (o *GPDMA_Type) SetCONFIG0_TRANSFERTYPE(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0x3800)|value<<11)
}
func (o *GPDMA_Type) GetCONFIG0_TRANSFERTYPE() uint32 {
	return (volatile.LoadUint32(&o.CONFIG0.Reg) & 0x3800) >> 11
}
func (o *GPDMA_Type) SetCONFIG0_IE(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0x4000)|value<<14)
}
func (o *GPDMA_Type) GetCONFIG0_IE() uint32 {
	return (volatile.LoadUint32(&o.CONFIG0.Reg) & 0x4000) >> 14
}
func (o *GPDMA_Type) SetCONFIG0_ITC(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0x8000)|value<<15)
}
func (o *GPDMA_Type) GetCONFIG0_ITC() uint32 {
	return (volatile.LoadUint32(&o.CONFIG0.Reg) & 0x8000) >> 15
}
func (o *GPDMA_Type) SetCONFIG0_L(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0x10000)|value<<16)
}
func (o *GPDMA_Type) GetCONFIG0_L() uint32 {
	return (volatile.LoadUint32(&o.CONFIG0.Reg) & 0x10000) >> 16
}
func (o *GPDMA_Type) SetCONFIG0_A(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0x20000)|value<<17)
}
func (o *GPDMA_Type) GetCONFIG0_A() uint32 {
	return (volatile.LoadUint32(&o.CONFIG0.Reg) & 0x20000) >> 17
}
func (o *GPDMA_Type) SetCONFIG0_H(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0x40000)|value<<18)
}
func (o *GPDMA_Type) GetCONFIG0_H() uint32 {
	return (volatile.LoadUint32(&o.CONFIG0.Reg) & 0x40000) >> 18
}
func (o *GPDMA_Type) SetCONFIG0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0xfff80000)|value<<19)
}
func (o *GPDMA_Type) GetCONFIG0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONFIG0.Reg) & 0xfff80000) >> 19
}

// GPDMA.SRCADDR1: DMA Channel 0 Source Address Register
func (o *GPDMA_Type) SetSRCADDR1(value uint32) {
	volatile.StoreUint32(&o.SRCADDR1.Reg, value)
}
func (o *GPDMA_Type) GetSRCADDR1() uint32 {
	return volatile.LoadUint32(&o.SRCADDR1.Reg)
}

// GPDMA.DESTADDR1: DMA Channel 0 Destination Address Register
func (o *GPDMA_Type) SetDESTADDR1(value uint32) {
	volatile.StoreUint32(&o.DESTADDR1.Reg, value)
}
func (o *GPDMA_Type) GetDESTADDR1() uint32 {
	return volatile.LoadUint32(&o.DESTADDR1.Reg)
}

// GPDMA.LLI1: DMA Channel 0 Linked List Item Register
func (o *GPDMA_Type) SetLLI1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.LLI1.Reg, volatile.LoadUint32(&o.LLI1.Reg)&^(0x3)|value)
}
func (o *GPDMA_Type) GetLLI1_RESERVED() uint32 {
	return volatile.LoadUint32(&o.LLI1.Reg) & 0x3
}
func (o *GPDMA_Type) SetLLI1_LLI(value uint32) {
	volatile.StoreUint32(&o.LLI1.Reg, volatile.LoadUint32(&o.LLI1.Reg)&^(0xfffffffc)|value<<2)
}
func (o *GPDMA_Type) GetLLI1_LLI() uint32 {
	return (volatile.LoadUint32(&o.LLI1.Reg) & 0xfffffffc) >> 2
}

// GPDMA.CONTROL1: DMA Channel 0 Control Register
func (o *GPDMA_Type) SetCONTROL1_TRANSFERSIZE(value uint32) {
	volatile.StoreUint32(&o.CONTROL1.Reg, volatile.LoadUint32(&o.CONTROL1.Reg)&^(0xfff)|value)
}
func (o *GPDMA_Type) GetCONTROL1_TRANSFERSIZE() uint32 {
	return volatile.LoadUint32(&o.CONTROL1.Reg) & 0xfff
}
func (o *GPDMA_Type) SetCONTROL1_SBSIZE(value uint32) {
	volatile.StoreUint32(&o.CONTROL1.Reg, volatile.LoadUint32(&o.CONTROL1.Reg)&^(0x7000)|value<<12)
}
func (o *GPDMA_Type) GetCONTROL1_SBSIZE() uint32 {
	return (volatile.LoadUint32(&o.CONTROL1.Reg) & 0x7000) >> 12
}
func (o *GPDMA_Type) SetCONTROL1_DBSIZE(value uint32) {
	volatile.StoreUint32(&o.CONTROL1.Reg, volatile.LoadUint32(&o.CONTROL1.Reg)&^(0x38000)|value<<15)
}
func (o *GPDMA_Type) GetCONTROL1_DBSIZE() uint32 {
	return (volatile.LoadUint32(&o.CONTROL1.Reg) & 0x38000) >> 15
}
func (o *GPDMA_Type) SetCONTROL1_SWIDTH(value uint32) {
	volatile.StoreUint32(&o.CONTROL1.Reg, volatile.LoadUint32(&o.CONTROL1.Reg)&^(0x1c0000)|value<<18)
}
func (o *GPDMA_Type) GetCONTROL1_SWIDTH() uint32 {
	return (volatile.LoadUint32(&o.CONTROL1.Reg) & 0x1c0000) >> 18
}
func (o *GPDMA_Type) SetCONTROL1_DWIDTH(value uint32) {
	volatile.StoreUint32(&o.CONTROL1.Reg, volatile.LoadUint32(&o.CONTROL1.Reg)&^(0xe00000)|value<<21)
}
func (o *GPDMA_Type) GetCONTROL1_DWIDTH() uint32 {
	return (volatile.LoadUint32(&o.CONTROL1.Reg) & 0xe00000) >> 21
}
func (o *GPDMA_Type) SetCONTROL1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONTROL1.Reg, volatile.LoadUint32(&o.CONTROL1.Reg)&^(0x3000000)|value<<24)
}
func (o *GPDMA_Type) GetCONTROL1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONTROL1.Reg) & 0x3000000) >> 24
}
func (o *GPDMA_Type) SetCONTROL1_SI(value uint32) {
	volatile.StoreUint32(&o.CONTROL1.Reg, volatile.LoadUint32(&o.CONTROL1.Reg)&^(0x4000000)|value<<26)
}
func (o *GPDMA_Type) GetCONTROL1_SI() uint32 {
	return (volatile.LoadUint32(&o.CONTROL1.Reg) & 0x4000000) >> 26
}
func (o *GPDMA_Type) SetCONTROL1_DI(value uint32) {
	volatile.StoreUint32(&o.CONTROL1.Reg, volatile.LoadUint32(&o.CONTROL1.Reg)&^(0x8000000)|value<<27)
}
func (o *GPDMA_Type) GetCONTROL1_DI() uint32 {
	return (volatile.LoadUint32(&o.CONTROL1.Reg) & 0x8000000) >> 27
}
func (o *GPDMA_Type) SetCONTROL1_PROT1(value uint32) {
	volatile.StoreUint32(&o.CONTROL1.Reg, volatile.LoadUint32(&o.CONTROL1.Reg)&^(0x10000000)|value<<28)
}
func (o *GPDMA_Type) GetCONTROL1_PROT1() uint32 {
	return (volatile.LoadUint32(&o.CONTROL1.Reg) & 0x10000000) >> 28
}
func (o *GPDMA_Type) SetCONTROL1_PROT2(value uint32) {
	volatile.StoreUint32(&o.CONTROL1.Reg, volatile.LoadUint32(&o.CONTROL1.Reg)&^(0x20000000)|value<<29)
}
func (o *GPDMA_Type) GetCONTROL1_PROT2() uint32 {
	return (volatile.LoadUint32(&o.CONTROL1.Reg) & 0x20000000) >> 29
}
func (o *GPDMA_Type) SetCONTROL1_PROT3(value uint32) {
	volatile.StoreUint32(&o.CONTROL1.Reg, volatile.LoadUint32(&o.CONTROL1.Reg)&^(0x40000000)|value<<30)
}
func (o *GPDMA_Type) GetCONTROL1_PROT3() uint32 {
	return (volatile.LoadUint32(&o.CONTROL1.Reg) & 0x40000000) >> 30
}
func (o *GPDMA_Type) SetCONTROL1_I(value uint32) {
	volatile.StoreUint32(&o.CONTROL1.Reg, volatile.LoadUint32(&o.CONTROL1.Reg)&^(0x80000000)|value<<31)
}
func (o *GPDMA_Type) GetCONTROL1_I() uint32 {
	return (volatile.LoadUint32(&o.CONTROL1.Reg) & 0x80000000) >> 31
}

// GPDMA.CONFIG1: DMA Channel 0 Configuration Register[1]
func (o *GPDMA_Type) SetCONFIG1_E(value uint32) {
	volatile.StoreUint32(&o.CONFIG1.Reg, volatile.LoadUint32(&o.CONFIG1.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetCONFIG1_E() uint32 {
	return volatile.LoadUint32(&o.CONFIG1.Reg) & 0x1
}
func (o *GPDMA_Type) SetCONFIG1_SRCPERIPHERAL(value uint32) {
	volatile.StoreUint32(&o.CONFIG1.Reg, volatile.LoadUint32(&o.CONFIG1.Reg)&^(0x3e)|value<<1)
}
func (o *GPDMA_Type) GetCONFIG1_SRCPERIPHERAL() uint32 {
	return (volatile.LoadUint32(&o.CONFIG1.Reg) & 0x3e) >> 1
}
func (o *GPDMA_Type) SetCONFIG1_DESTPERIPHERAL(value uint32) {
	volatile.StoreUint32(&o.CONFIG1.Reg, volatile.LoadUint32(&o.CONFIG1.Reg)&^(0x7c0)|value<<6)
}
func (o *GPDMA_Type) GetCONFIG1_DESTPERIPHERAL() uint32 {
	return (volatile.LoadUint32(&o.CONFIG1.Reg) & 0x7c0) >> 6
}
func (o *GPDMA_Type) SetCONFIG1_TRANSFERTYPE(value uint32) {
	volatile.StoreUint32(&o.CONFIG1.Reg, volatile.LoadUint32(&o.CONFIG1.Reg)&^(0x3800)|value<<11)
}
func (o *GPDMA_Type) GetCONFIG1_TRANSFERTYPE() uint32 {
	return (volatile.LoadUint32(&o.CONFIG1.Reg) & 0x3800) >> 11
}
func (o *GPDMA_Type) SetCONFIG1_IE(value uint32) {
	volatile.StoreUint32(&o.CONFIG1.Reg, volatile.LoadUint32(&o.CONFIG1.Reg)&^(0x4000)|value<<14)
}
func (o *GPDMA_Type) GetCONFIG1_IE() uint32 {
	return (volatile.LoadUint32(&o.CONFIG1.Reg) & 0x4000) >> 14
}
func (o *GPDMA_Type) SetCONFIG1_ITC(value uint32) {
	volatile.StoreUint32(&o.CONFIG1.Reg, volatile.LoadUint32(&o.CONFIG1.Reg)&^(0x8000)|value<<15)
}
func (o *GPDMA_Type) GetCONFIG1_ITC() uint32 {
	return (volatile.LoadUint32(&o.CONFIG1.Reg) & 0x8000) >> 15
}
func (o *GPDMA_Type) SetCONFIG1_L(value uint32) {
	volatile.StoreUint32(&o.CONFIG1.Reg, volatile.LoadUint32(&o.CONFIG1.Reg)&^(0x10000)|value<<16)
}
func (o *GPDMA_Type) GetCONFIG1_L() uint32 {
	return (volatile.LoadUint32(&o.CONFIG1.Reg) & 0x10000) >> 16
}
func (o *GPDMA_Type) SetCONFIG1_A(value uint32) {
	volatile.StoreUint32(&o.CONFIG1.Reg, volatile.LoadUint32(&o.CONFIG1.Reg)&^(0x20000)|value<<17)
}
func (o *GPDMA_Type) GetCONFIG1_A() uint32 {
	return (volatile.LoadUint32(&o.CONFIG1.Reg) & 0x20000) >> 17
}
func (o *GPDMA_Type) SetCONFIG1_H(value uint32) {
	volatile.StoreUint32(&o.CONFIG1.Reg, volatile.LoadUint32(&o.CONFIG1.Reg)&^(0x40000)|value<<18)
}
func (o *GPDMA_Type) GetCONFIG1_H() uint32 {
	return (volatile.LoadUint32(&o.CONFIG1.Reg) & 0x40000) >> 18
}
func (o *GPDMA_Type) SetCONFIG1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONFIG1.Reg, volatile.LoadUint32(&o.CONFIG1.Reg)&^(0xfff80000)|value<<19)
}
func (o *GPDMA_Type) GetCONFIG1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONFIG1.Reg) & 0xfff80000) >> 19
}

// GPDMA.SRCADDR2: DMA Channel 0 Source Address Register
func (o *GPDMA_Type) SetSRCADDR2(value uint32) {
	volatile.StoreUint32(&o.SRCADDR2.Reg, value)
}
func (o *GPDMA_Type) GetSRCADDR2() uint32 {
	return volatile.LoadUint32(&o.SRCADDR2.Reg)
}

// GPDMA.DESTADDR2: DMA Channel 0 Destination Address Register
func (o *GPDMA_Type) SetDESTADDR2(value uint32) {
	volatile.StoreUint32(&o.DESTADDR2.Reg, value)
}
func (o *GPDMA_Type) GetDESTADDR2() uint32 {
	return volatile.LoadUint32(&o.DESTADDR2.Reg)
}

// GPDMA.LLI2: DMA Channel 0 Linked List Item Register
func (o *GPDMA_Type) SetLLI2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.LLI2.Reg, volatile.LoadUint32(&o.LLI2.Reg)&^(0x3)|value)
}
func (o *GPDMA_Type) GetLLI2_RESERVED() uint32 {
	return volatile.LoadUint32(&o.LLI2.Reg) & 0x3
}
func (o *GPDMA_Type) SetLLI2_LLI(value uint32) {
	volatile.StoreUint32(&o.LLI2.Reg, volatile.LoadUint32(&o.LLI2.Reg)&^(0xfffffffc)|value<<2)
}
func (o *GPDMA_Type) GetLLI2_LLI() uint32 {
	return (volatile.LoadUint32(&o.LLI2.Reg) & 0xfffffffc) >> 2
}

// GPDMA.CONTROL2: DMA Channel 0 Control Register
func (o *GPDMA_Type) SetCONTROL2_TRANSFERSIZE(value uint32) {
	volatile.StoreUint32(&o.CONTROL2.Reg, volatile.LoadUint32(&o.CONTROL2.Reg)&^(0xfff)|value)
}
func (o *GPDMA_Type) GetCONTROL2_TRANSFERSIZE() uint32 {
	return volatile.LoadUint32(&o.CONTROL2.Reg) & 0xfff
}
func (o *GPDMA_Type) SetCONTROL2_SBSIZE(value uint32) {
	volatile.StoreUint32(&o.CONTROL2.Reg, volatile.LoadUint32(&o.CONTROL2.Reg)&^(0x7000)|value<<12)
}
func (o *GPDMA_Type) GetCONTROL2_SBSIZE() uint32 {
	return (volatile.LoadUint32(&o.CONTROL2.Reg) & 0x7000) >> 12
}
func (o *GPDMA_Type) SetCONTROL2_DBSIZE(value uint32) {
	volatile.StoreUint32(&o.CONTROL2.Reg, volatile.LoadUint32(&o.CONTROL2.Reg)&^(0x38000)|value<<15)
}
func (o *GPDMA_Type) GetCONTROL2_DBSIZE() uint32 {
	return (volatile.LoadUint32(&o.CONTROL2.Reg) & 0x38000) >> 15
}
func (o *GPDMA_Type) SetCONTROL2_SWIDTH(value uint32) {
	volatile.StoreUint32(&o.CONTROL2.Reg, volatile.LoadUint32(&o.CONTROL2.Reg)&^(0x1c0000)|value<<18)
}
func (o *GPDMA_Type) GetCONTROL2_SWIDTH() uint32 {
	return (volatile.LoadUint32(&o.CONTROL2.Reg) & 0x1c0000) >> 18
}
func (o *GPDMA_Type) SetCONTROL2_DWIDTH(value uint32) {
	volatile.StoreUint32(&o.CONTROL2.Reg, volatile.LoadUint32(&o.CONTROL2.Reg)&^(0xe00000)|value<<21)
}
func (o *GPDMA_Type) GetCONTROL2_DWIDTH() uint32 {
	return (volatile.LoadUint32(&o.CONTROL2.Reg) & 0xe00000) >> 21
}
func (o *GPDMA_Type) SetCONTROL2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONTROL2.Reg, volatile.LoadUint32(&o.CONTROL2.Reg)&^(0x3000000)|value<<24)
}
func (o *GPDMA_Type) GetCONTROL2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONTROL2.Reg) & 0x3000000) >> 24
}
func (o *GPDMA_Type) SetCONTROL2_SI(value uint32) {
	volatile.StoreUint32(&o.CONTROL2.Reg, volatile.LoadUint32(&o.CONTROL2.Reg)&^(0x4000000)|value<<26)
}
func (o *GPDMA_Type) GetCONTROL2_SI() uint32 {
	return (volatile.LoadUint32(&o.CONTROL2.Reg) & 0x4000000) >> 26
}
func (o *GPDMA_Type) SetCONTROL2_DI(value uint32) {
	volatile.StoreUint32(&o.CONTROL2.Reg, volatile.LoadUint32(&o.CONTROL2.Reg)&^(0x8000000)|value<<27)
}
func (o *GPDMA_Type) GetCONTROL2_DI() uint32 {
	return (volatile.LoadUint32(&o.CONTROL2.Reg) & 0x8000000) >> 27
}
func (o *GPDMA_Type) SetCONTROL2_PROT1(value uint32) {
	volatile.StoreUint32(&o.CONTROL2.Reg, volatile.LoadUint32(&o.CONTROL2.Reg)&^(0x10000000)|value<<28)
}
func (o *GPDMA_Type) GetCONTROL2_PROT1() uint32 {
	return (volatile.LoadUint32(&o.CONTROL2.Reg) & 0x10000000) >> 28
}
func (o *GPDMA_Type) SetCONTROL2_PROT2(value uint32) {
	volatile.StoreUint32(&o.CONTROL2.Reg, volatile.LoadUint32(&o.CONTROL2.Reg)&^(0x20000000)|value<<29)
}
func (o *GPDMA_Type) GetCONTROL2_PROT2() uint32 {
	return (volatile.LoadUint32(&o.CONTROL2.Reg) & 0x20000000) >> 29
}
func (o *GPDMA_Type) SetCONTROL2_PROT3(value uint32) {
	volatile.StoreUint32(&o.CONTROL2.Reg, volatile.LoadUint32(&o.CONTROL2.Reg)&^(0x40000000)|value<<30)
}
func (o *GPDMA_Type) GetCONTROL2_PROT3() uint32 {
	return (volatile.LoadUint32(&o.CONTROL2.Reg) & 0x40000000) >> 30
}
func (o *GPDMA_Type) SetCONTROL2_I(value uint32) {
	volatile.StoreUint32(&o.CONTROL2.Reg, volatile.LoadUint32(&o.CONTROL2.Reg)&^(0x80000000)|value<<31)
}
func (o *GPDMA_Type) GetCONTROL2_I() uint32 {
	return (volatile.LoadUint32(&o.CONTROL2.Reg) & 0x80000000) >> 31
}

// GPDMA.CONFIG2: DMA Channel 0 Configuration Register[1]
func (o *GPDMA_Type) SetCONFIG2_E(value uint32) {
	volatile.StoreUint32(&o.CONFIG2.Reg, volatile.LoadUint32(&o.CONFIG2.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetCONFIG2_E() uint32 {
	return volatile.LoadUint32(&o.CONFIG2.Reg) & 0x1
}
func (o *GPDMA_Type) SetCONFIG2_SRCPERIPHERAL(value uint32) {
	volatile.StoreUint32(&o.CONFIG2.Reg, volatile.LoadUint32(&o.CONFIG2.Reg)&^(0x3e)|value<<1)
}
func (o *GPDMA_Type) GetCONFIG2_SRCPERIPHERAL() uint32 {
	return (volatile.LoadUint32(&o.CONFIG2.Reg) & 0x3e) >> 1
}
func (o *GPDMA_Type) SetCONFIG2_DESTPERIPHERAL(value uint32) {
	volatile.StoreUint32(&o.CONFIG2.Reg, volatile.LoadUint32(&o.CONFIG2.Reg)&^(0x7c0)|value<<6)
}
func (o *GPDMA_Type) GetCONFIG2_DESTPERIPHERAL() uint32 {
	return (volatile.LoadUint32(&o.CONFIG2.Reg) & 0x7c0) >> 6
}
func (o *GPDMA_Type) SetCONFIG2_TRANSFERTYPE(value uint32) {
	volatile.StoreUint32(&o.CONFIG2.Reg, volatile.LoadUint32(&o.CONFIG2.Reg)&^(0x3800)|value<<11)
}
func (o *GPDMA_Type) GetCONFIG2_TRANSFERTYPE() uint32 {
	return (volatile.LoadUint32(&o.CONFIG2.Reg) & 0x3800) >> 11
}
func (o *GPDMA_Type) SetCONFIG2_IE(value uint32) {
	volatile.StoreUint32(&o.CONFIG2.Reg, volatile.LoadUint32(&o.CONFIG2.Reg)&^(0x4000)|value<<14)
}
func (o *GPDMA_Type) GetCONFIG2_IE() uint32 {
	return (volatile.LoadUint32(&o.CONFIG2.Reg) & 0x4000) >> 14
}
func (o *GPDMA_Type) SetCONFIG2_ITC(value uint32) {
	volatile.StoreUint32(&o.CONFIG2.Reg, volatile.LoadUint32(&o.CONFIG2.Reg)&^(0x8000)|value<<15)
}
func (o *GPDMA_Type) GetCONFIG2_ITC() uint32 {
	return (volatile.LoadUint32(&o.CONFIG2.Reg) & 0x8000) >> 15
}
func (o *GPDMA_Type) SetCONFIG2_L(value uint32) {
	volatile.StoreUint32(&o.CONFIG2.Reg, volatile.LoadUint32(&o.CONFIG2.Reg)&^(0x10000)|value<<16)
}
func (o *GPDMA_Type) GetCONFIG2_L() uint32 {
	return (volatile.LoadUint32(&o.CONFIG2.Reg) & 0x10000) >> 16
}
func (o *GPDMA_Type) SetCONFIG2_A(value uint32) {
	volatile.StoreUint32(&o.CONFIG2.Reg, volatile.LoadUint32(&o.CONFIG2.Reg)&^(0x20000)|value<<17)
}
func (o *GPDMA_Type) GetCONFIG2_A() uint32 {
	return (volatile.LoadUint32(&o.CONFIG2.Reg) & 0x20000) >> 17
}
func (o *GPDMA_Type) SetCONFIG2_H(value uint32) {
	volatile.StoreUint32(&o.CONFIG2.Reg, volatile.LoadUint32(&o.CONFIG2.Reg)&^(0x40000)|value<<18)
}
func (o *GPDMA_Type) GetCONFIG2_H() uint32 {
	return (volatile.LoadUint32(&o.CONFIG2.Reg) & 0x40000) >> 18
}
func (o *GPDMA_Type) SetCONFIG2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONFIG2.Reg, volatile.LoadUint32(&o.CONFIG2.Reg)&^(0xfff80000)|value<<19)
}
func (o *GPDMA_Type) GetCONFIG2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONFIG2.Reg) & 0xfff80000) >> 19
}

// GPDMA.SRCADDR3: DMA Channel 0 Source Address Register
func (o *GPDMA_Type) SetSRCADDR3(value uint32) {
	volatile.StoreUint32(&o.SRCADDR3.Reg, value)
}
func (o *GPDMA_Type) GetSRCADDR3() uint32 {
	return volatile.LoadUint32(&o.SRCADDR3.Reg)
}

// GPDMA.DESTADDR3: DMA Channel 0 Destination Address Register
func (o *GPDMA_Type) SetDESTADDR3(value uint32) {
	volatile.StoreUint32(&o.DESTADDR3.Reg, value)
}
func (o *GPDMA_Type) GetDESTADDR3() uint32 {
	return volatile.LoadUint32(&o.DESTADDR3.Reg)
}

// GPDMA.LLI3: DMA Channel 0 Linked List Item Register
func (o *GPDMA_Type) SetLLI3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.LLI3.Reg, volatile.LoadUint32(&o.LLI3.Reg)&^(0x3)|value)
}
func (o *GPDMA_Type) GetLLI3_RESERVED() uint32 {
	return volatile.LoadUint32(&o.LLI3.Reg) & 0x3
}
func (o *GPDMA_Type) SetLLI3_LLI(value uint32) {
	volatile.StoreUint32(&o.LLI3.Reg, volatile.LoadUint32(&o.LLI3.Reg)&^(0xfffffffc)|value<<2)
}
func (o *GPDMA_Type) GetLLI3_LLI() uint32 {
	return (volatile.LoadUint32(&o.LLI3.Reg) & 0xfffffffc) >> 2
}

// GPDMA.CONTROL3: DMA Channel 0 Control Register
func (o *GPDMA_Type) SetCONTROL3_TRANSFERSIZE(value uint32) {
	volatile.StoreUint32(&o.CONTROL3.Reg, volatile.LoadUint32(&o.CONTROL3.Reg)&^(0xfff)|value)
}
func (o *GPDMA_Type) GetCONTROL3_TRANSFERSIZE() uint32 {
	return volatile.LoadUint32(&o.CONTROL3.Reg) & 0xfff
}
func (o *GPDMA_Type) SetCONTROL3_SBSIZE(value uint32) {
	volatile.StoreUint32(&o.CONTROL3.Reg, volatile.LoadUint32(&o.CONTROL3.Reg)&^(0x7000)|value<<12)
}
func (o *GPDMA_Type) GetCONTROL3_SBSIZE() uint32 {
	return (volatile.LoadUint32(&o.CONTROL3.Reg) & 0x7000) >> 12
}
func (o *GPDMA_Type) SetCONTROL3_DBSIZE(value uint32) {
	volatile.StoreUint32(&o.CONTROL3.Reg, volatile.LoadUint32(&o.CONTROL3.Reg)&^(0x38000)|value<<15)
}
func (o *GPDMA_Type) GetCONTROL3_DBSIZE() uint32 {
	return (volatile.LoadUint32(&o.CONTROL3.Reg) & 0x38000) >> 15
}
func (o *GPDMA_Type) SetCONTROL3_SWIDTH(value uint32) {
	volatile.StoreUint32(&o.CONTROL3.Reg, volatile.LoadUint32(&o.CONTROL3.Reg)&^(0x1c0000)|value<<18)
}
func (o *GPDMA_Type) GetCONTROL3_SWIDTH() uint32 {
	return (volatile.LoadUint32(&o.CONTROL3.Reg) & 0x1c0000) >> 18
}
func (o *GPDMA_Type) SetCONTROL3_DWIDTH(value uint32) {
	volatile.StoreUint32(&o.CONTROL3.Reg, volatile.LoadUint32(&o.CONTROL3.Reg)&^(0xe00000)|value<<21)
}
func (o *GPDMA_Type) GetCONTROL3_DWIDTH() uint32 {
	return (volatile.LoadUint32(&o.CONTROL3.Reg) & 0xe00000) >> 21
}
func (o *GPDMA_Type) SetCONTROL3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONTROL3.Reg, volatile.LoadUint32(&o.CONTROL3.Reg)&^(0x3000000)|value<<24)
}
func (o *GPDMA_Type) GetCONTROL3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONTROL3.Reg) & 0x3000000) >> 24
}
func (o *GPDMA_Type) SetCONTROL3_SI(value uint32) {
	volatile.StoreUint32(&o.CONTROL3.Reg, volatile.LoadUint32(&o.CONTROL3.Reg)&^(0x4000000)|value<<26)
}
func (o *GPDMA_Type) GetCONTROL3_SI() uint32 {
	return (volatile.LoadUint32(&o.CONTROL3.Reg) & 0x4000000) >> 26
}
func (o *GPDMA_Type) SetCONTROL3_DI(value uint32) {
	volatile.StoreUint32(&o.CONTROL3.Reg, volatile.LoadUint32(&o.CONTROL3.Reg)&^(0x8000000)|value<<27)
}
func (o *GPDMA_Type) GetCONTROL3_DI() uint32 {
	return (volatile.LoadUint32(&o.CONTROL3.Reg) & 0x8000000) >> 27
}
func (o *GPDMA_Type) SetCONTROL3_PROT1(value uint32) {
	volatile.StoreUint32(&o.CONTROL3.Reg, volatile.LoadUint32(&o.CONTROL3.Reg)&^(0x10000000)|value<<28)
}
func (o *GPDMA_Type) GetCONTROL3_PROT1() uint32 {
	return (volatile.LoadUint32(&o.CONTROL3.Reg) & 0x10000000) >> 28
}
func (o *GPDMA_Type) SetCONTROL3_PROT2(value uint32) {
	volatile.StoreUint32(&o.CONTROL3.Reg, volatile.LoadUint32(&o.CONTROL3.Reg)&^(0x20000000)|value<<29)
}
func (o *GPDMA_Type) GetCONTROL3_PROT2() uint32 {
	return (volatile.LoadUint32(&o.CONTROL3.Reg) & 0x20000000) >> 29
}
func (o *GPDMA_Type) SetCONTROL3_PROT3(value uint32) {
	volatile.StoreUint32(&o.CONTROL3.Reg, volatile.LoadUint32(&o.CONTROL3.Reg)&^(0x40000000)|value<<30)
}
func (o *GPDMA_Type) GetCONTROL3_PROT3() uint32 {
	return (volatile.LoadUint32(&o.CONTROL3.Reg) & 0x40000000) >> 30
}
func (o *GPDMA_Type) SetCONTROL3_I(value uint32) {
	volatile.StoreUint32(&o.CONTROL3.Reg, volatile.LoadUint32(&o.CONTROL3.Reg)&^(0x80000000)|value<<31)
}
func (o *GPDMA_Type) GetCONTROL3_I() uint32 {
	return (volatile.LoadUint32(&o.CONTROL3.Reg) & 0x80000000) >> 31
}

// GPDMA.CONFIG3: DMA Channel 0 Configuration Register[1]
func (o *GPDMA_Type) SetCONFIG3_E(value uint32) {
	volatile.StoreUint32(&o.CONFIG3.Reg, volatile.LoadUint32(&o.CONFIG3.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetCONFIG3_E() uint32 {
	return volatile.LoadUint32(&o.CONFIG3.Reg) & 0x1
}
func (o *GPDMA_Type) SetCONFIG3_SRCPERIPHERAL(value uint32) {
	volatile.StoreUint32(&o.CONFIG3.Reg, volatile.LoadUint32(&o.CONFIG3.Reg)&^(0x3e)|value<<1)
}
func (o *GPDMA_Type) GetCONFIG3_SRCPERIPHERAL() uint32 {
	return (volatile.LoadUint32(&o.CONFIG3.Reg) & 0x3e) >> 1
}
func (o *GPDMA_Type) SetCONFIG3_DESTPERIPHERAL(value uint32) {
	volatile.StoreUint32(&o.CONFIG3.Reg, volatile.LoadUint32(&o.CONFIG3.Reg)&^(0x7c0)|value<<6)
}
func (o *GPDMA_Type) GetCONFIG3_DESTPERIPHERAL() uint32 {
	return (volatile.LoadUint32(&o.CONFIG3.Reg) & 0x7c0) >> 6
}
func (o *GPDMA_Type) SetCONFIG3_TRANSFERTYPE(value uint32) {
	volatile.StoreUint32(&o.CONFIG3.Reg, volatile.LoadUint32(&o.CONFIG3.Reg)&^(0x3800)|value<<11)
}
func (o *GPDMA_Type) GetCONFIG3_TRANSFERTYPE() uint32 {
	return (volatile.LoadUint32(&o.CONFIG3.Reg) & 0x3800) >> 11
}
func (o *GPDMA_Type) SetCONFIG3_IE(value uint32) {
	volatile.StoreUint32(&o.CONFIG3.Reg, volatile.LoadUint32(&o.CONFIG3.Reg)&^(0x4000)|value<<14)
}
func (o *GPDMA_Type) GetCONFIG3_IE() uint32 {
	return (volatile.LoadUint32(&o.CONFIG3.Reg) & 0x4000) >> 14
}
func (o *GPDMA_Type) SetCONFIG3_ITC(value uint32) {
	volatile.StoreUint32(&o.CONFIG3.Reg, volatile.LoadUint32(&o.CONFIG3.Reg)&^(0x8000)|value<<15)
}
func (o *GPDMA_Type) GetCONFIG3_ITC() uint32 {
	return (volatile.LoadUint32(&o.CONFIG3.Reg) & 0x8000) >> 15
}
func (o *GPDMA_Type) SetCONFIG3_L(value uint32) {
	volatile.StoreUint32(&o.CONFIG3.Reg, volatile.LoadUint32(&o.CONFIG3.Reg)&^(0x10000)|value<<16)
}
func (o *GPDMA_Type) GetCONFIG3_L() uint32 {
	return (volatile.LoadUint32(&o.CONFIG3.Reg) & 0x10000) >> 16
}
func (o *GPDMA_Type) SetCONFIG3_A(value uint32) {
	volatile.StoreUint32(&o.CONFIG3.Reg, volatile.LoadUint32(&o.CONFIG3.Reg)&^(0x20000)|value<<17)
}
func (o *GPDMA_Type) GetCONFIG3_A() uint32 {
	return (volatile.LoadUint32(&o.CONFIG3.Reg) & 0x20000) >> 17
}
func (o *GPDMA_Type) SetCONFIG3_H(value uint32) {
	volatile.StoreUint32(&o.CONFIG3.Reg, volatile.LoadUint32(&o.CONFIG3.Reg)&^(0x40000)|value<<18)
}
func (o *GPDMA_Type) GetCONFIG3_H() uint32 {
	return (volatile.LoadUint32(&o.CONFIG3.Reg) & 0x40000) >> 18
}
func (o *GPDMA_Type) SetCONFIG3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONFIG3.Reg, volatile.LoadUint32(&o.CONFIG3.Reg)&^(0xfff80000)|value<<19)
}
func (o *GPDMA_Type) GetCONFIG3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONFIG3.Reg) & 0xfff80000) >> 19
}

// GPDMA.SRCADDR4: DMA Channel 0 Source Address Register
func (o *GPDMA_Type) SetSRCADDR4(value uint32) {
	volatile.StoreUint32(&o.SRCADDR4.Reg, value)
}
func (o *GPDMA_Type) GetSRCADDR4() uint32 {
	return volatile.LoadUint32(&o.SRCADDR4.Reg)
}

// GPDMA.DESTADDR4: DMA Channel 0 Destination Address Register
func (o *GPDMA_Type) SetDESTADDR4(value uint32) {
	volatile.StoreUint32(&o.DESTADDR4.Reg, value)
}
func (o *GPDMA_Type) GetDESTADDR4() uint32 {
	return volatile.LoadUint32(&o.DESTADDR4.Reg)
}

// GPDMA.LLI4: DMA Channel 0 Linked List Item Register
func (o *GPDMA_Type) SetLLI4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.LLI4.Reg, volatile.LoadUint32(&o.LLI4.Reg)&^(0x3)|value)
}
func (o *GPDMA_Type) GetLLI4_RESERVED() uint32 {
	return volatile.LoadUint32(&o.LLI4.Reg) & 0x3
}
func (o *GPDMA_Type) SetLLI4_LLI(value uint32) {
	volatile.StoreUint32(&o.LLI4.Reg, volatile.LoadUint32(&o.LLI4.Reg)&^(0xfffffffc)|value<<2)
}
func (o *GPDMA_Type) GetLLI4_LLI() uint32 {
	return (volatile.LoadUint32(&o.LLI4.Reg) & 0xfffffffc) >> 2
}

// GPDMA.CONTROL4: DMA Channel 0 Control Register
func (o *GPDMA_Type) SetCONTROL4_TRANSFERSIZE(value uint32) {
	volatile.StoreUint32(&o.CONTROL4.Reg, volatile.LoadUint32(&o.CONTROL4.Reg)&^(0xfff)|value)
}
func (o *GPDMA_Type) GetCONTROL4_TRANSFERSIZE() uint32 {
	return volatile.LoadUint32(&o.CONTROL4.Reg) & 0xfff
}
func (o *GPDMA_Type) SetCONTROL4_SBSIZE(value uint32) {
	volatile.StoreUint32(&o.CONTROL4.Reg, volatile.LoadUint32(&o.CONTROL4.Reg)&^(0x7000)|value<<12)
}
func (o *GPDMA_Type) GetCONTROL4_SBSIZE() uint32 {
	return (volatile.LoadUint32(&o.CONTROL4.Reg) & 0x7000) >> 12
}
func (o *GPDMA_Type) SetCONTROL4_DBSIZE(value uint32) {
	volatile.StoreUint32(&o.CONTROL4.Reg, volatile.LoadUint32(&o.CONTROL4.Reg)&^(0x38000)|value<<15)
}
func (o *GPDMA_Type) GetCONTROL4_DBSIZE() uint32 {
	return (volatile.LoadUint32(&o.CONTROL4.Reg) & 0x38000) >> 15
}
func (o *GPDMA_Type) SetCONTROL4_SWIDTH(value uint32) {
	volatile.StoreUint32(&o.CONTROL4.Reg, volatile.LoadUint32(&o.CONTROL4.Reg)&^(0x1c0000)|value<<18)
}
func (o *GPDMA_Type) GetCONTROL4_SWIDTH() uint32 {
	return (volatile.LoadUint32(&o.CONTROL4.Reg) & 0x1c0000) >> 18
}
func (o *GPDMA_Type) SetCONTROL4_DWIDTH(value uint32) {
	volatile.StoreUint32(&o.CONTROL4.Reg, volatile.LoadUint32(&o.CONTROL4.Reg)&^(0xe00000)|value<<21)
}
func (o *GPDMA_Type) GetCONTROL4_DWIDTH() uint32 {
	return (volatile.LoadUint32(&o.CONTROL4.Reg) & 0xe00000) >> 21
}
func (o *GPDMA_Type) SetCONTROL4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONTROL4.Reg, volatile.LoadUint32(&o.CONTROL4.Reg)&^(0x3000000)|value<<24)
}
func (o *GPDMA_Type) GetCONTROL4_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONTROL4.Reg) & 0x3000000) >> 24
}
func (o *GPDMA_Type) SetCONTROL4_SI(value uint32) {
	volatile.StoreUint32(&o.CONTROL4.Reg, volatile.LoadUint32(&o.CONTROL4.Reg)&^(0x4000000)|value<<26)
}
func (o *GPDMA_Type) GetCONTROL4_SI() uint32 {
	return (volatile.LoadUint32(&o.CONTROL4.Reg) & 0x4000000) >> 26
}
func (o *GPDMA_Type) SetCONTROL4_DI(value uint32) {
	volatile.StoreUint32(&o.CONTROL4.Reg, volatile.LoadUint32(&o.CONTROL4.Reg)&^(0x8000000)|value<<27)
}
func (o *GPDMA_Type) GetCONTROL4_DI() uint32 {
	return (volatile.LoadUint32(&o.CONTROL4.Reg) & 0x8000000) >> 27
}
func (o *GPDMA_Type) SetCONTROL4_PROT1(value uint32) {
	volatile.StoreUint32(&o.CONTROL4.Reg, volatile.LoadUint32(&o.CONTROL4.Reg)&^(0x10000000)|value<<28)
}
func (o *GPDMA_Type) GetCONTROL4_PROT1() uint32 {
	return (volatile.LoadUint32(&o.CONTROL4.Reg) & 0x10000000) >> 28
}
func (o *GPDMA_Type) SetCONTROL4_PROT2(value uint32) {
	volatile.StoreUint32(&o.CONTROL4.Reg, volatile.LoadUint32(&o.CONTROL4.Reg)&^(0x20000000)|value<<29)
}
func (o *GPDMA_Type) GetCONTROL4_PROT2() uint32 {
	return (volatile.LoadUint32(&o.CONTROL4.Reg) & 0x20000000) >> 29
}
func (o *GPDMA_Type) SetCONTROL4_PROT3(value uint32) {
	volatile.StoreUint32(&o.CONTROL4.Reg, volatile.LoadUint32(&o.CONTROL4.Reg)&^(0x40000000)|value<<30)
}
func (o *GPDMA_Type) GetCONTROL4_PROT3() uint32 {
	return (volatile.LoadUint32(&o.CONTROL4.Reg) & 0x40000000) >> 30
}
func (o *GPDMA_Type) SetCONTROL4_I(value uint32) {
	volatile.StoreUint32(&o.CONTROL4.Reg, volatile.LoadUint32(&o.CONTROL4.Reg)&^(0x80000000)|value<<31)
}
func (o *GPDMA_Type) GetCONTROL4_I() uint32 {
	return (volatile.LoadUint32(&o.CONTROL4.Reg) & 0x80000000) >> 31
}

// GPDMA.CONFIG4: DMA Channel 0 Configuration Register[1]
func (o *GPDMA_Type) SetCONFIG4_E(value uint32) {
	volatile.StoreUint32(&o.CONFIG4.Reg, volatile.LoadUint32(&o.CONFIG4.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetCONFIG4_E() uint32 {
	return volatile.LoadUint32(&o.CONFIG4.Reg) & 0x1
}
func (o *GPDMA_Type) SetCONFIG4_SRCPERIPHERAL(value uint32) {
	volatile.StoreUint32(&o.CONFIG4.Reg, volatile.LoadUint32(&o.CONFIG4.Reg)&^(0x3e)|value<<1)
}
func (o *GPDMA_Type) GetCONFIG4_SRCPERIPHERAL() uint32 {
	return (volatile.LoadUint32(&o.CONFIG4.Reg) & 0x3e) >> 1
}
func (o *GPDMA_Type) SetCONFIG4_DESTPERIPHERAL(value uint32) {
	volatile.StoreUint32(&o.CONFIG4.Reg, volatile.LoadUint32(&o.CONFIG4.Reg)&^(0x7c0)|value<<6)
}
func (o *GPDMA_Type) GetCONFIG4_DESTPERIPHERAL() uint32 {
	return (volatile.LoadUint32(&o.CONFIG4.Reg) & 0x7c0) >> 6
}
func (o *GPDMA_Type) SetCONFIG4_TRANSFERTYPE(value uint32) {
	volatile.StoreUint32(&o.CONFIG4.Reg, volatile.LoadUint32(&o.CONFIG4.Reg)&^(0x3800)|value<<11)
}
func (o *GPDMA_Type) GetCONFIG4_TRANSFERTYPE() uint32 {
	return (volatile.LoadUint32(&o.CONFIG4.Reg) & 0x3800) >> 11
}
func (o *GPDMA_Type) SetCONFIG4_IE(value uint32) {
	volatile.StoreUint32(&o.CONFIG4.Reg, volatile.LoadUint32(&o.CONFIG4.Reg)&^(0x4000)|value<<14)
}
func (o *GPDMA_Type) GetCONFIG4_IE() uint32 {
	return (volatile.LoadUint32(&o.CONFIG4.Reg) & 0x4000) >> 14
}
func (o *GPDMA_Type) SetCONFIG4_ITC(value uint32) {
	volatile.StoreUint32(&o.CONFIG4.Reg, volatile.LoadUint32(&o.CONFIG4.Reg)&^(0x8000)|value<<15)
}
func (o *GPDMA_Type) GetCONFIG4_ITC() uint32 {
	return (volatile.LoadUint32(&o.CONFIG4.Reg) & 0x8000) >> 15
}
func (o *GPDMA_Type) SetCONFIG4_L(value uint32) {
	volatile.StoreUint32(&o.CONFIG4.Reg, volatile.LoadUint32(&o.CONFIG4.Reg)&^(0x10000)|value<<16)
}
func (o *GPDMA_Type) GetCONFIG4_L() uint32 {
	return (volatile.LoadUint32(&o.CONFIG4.Reg) & 0x10000) >> 16
}
func (o *GPDMA_Type) SetCONFIG4_A(value uint32) {
	volatile.StoreUint32(&o.CONFIG4.Reg, volatile.LoadUint32(&o.CONFIG4.Reg)&^(0x20000)|value<<17)
}
func (o *GPDMA_Type) GetCONFIG4_A() uint32 {
	return (volatile.LoadUint32(&o.CONFIG4.Reg) & 0x20000) >> 17
}
func (o *GPDMA_Type) SetCONFIG4_H(value uint32) {
	volatile.StoreUint32(&o.CONFIG4.Reg, volatile.LoadUint32(&o.CONFIG4.Reg)&^(0x40000)|value<<18)
}
func (o *GPDMA_Type) GetCONFIG4_H() uint32 {
	return (volatile.LoadUint32(&o.CONFIG4.Reg) & 0x40000) >> 18
}
func (o *GPDMA_Type) SetCONFIG4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONFIG4.Reg, volatile.LoadUint32(&o.CONFIG4.Reg)&^(0xfff80000)|value<<19)
}
func (o *GPDMA_Type) GetCONFIG4_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONFIG4.Reg) & 0xfff80000) >> 19
}

// GPDMA.SRCADDR5: DMA Channel 0 Source Address Register
func (o *GPDMA_Type) SetSRCADDR5(value uint32) {
	volatile.StoreUint32(&o.SRCADDR5.Reg, value)
}
func (o *GPDMA_Type) GetSRCADDR5() uint32 {
	return volatile.LoadUint32(&o.SRCADDR5.Reg)
}

// GPDMA.DESTADDR5: DMA Channel 0 Destination Address Register
func (o *GPDMA_Type) SetDESTADDR5(value uint32) {
	volatile.StoreUint32(&o.DESTADDR5.Reg, value)
}
func (o *GPDMA_Type) GetDESTADDR5() uint32 {
	return volatile.LoadUint32(&o.DESTADDR5.Reg)
}

// GPDMA.LLI5: DMA Channel 0 Linked List Item Register
func (o *GPDMA_Type) SetLLI5_RESERVED(value uint32) {
	volatile.StoreUint32(&o.LLI5.Reg, volatile.LoadUint32(&o.LLI5.Reg)&^(0x3)|value)
}
func (o *GPDMA_Type) GetLLI5_RESERVED() uint32 {
	return volatile.LoadUint32(&o.LLI5.Reg) & 0x3
}
func (o *GPDMA_Type) SetLLI5_LLI(value uint32) {
	volatile.StoreUint32(&o.LLI5.Reg, volatile.LoadUint32(&o.LLI5.Reg)&^(0xfffffffc)|value<<2)
}
func (o *GPDMA_Type) GetLLI5_LLI() uint32 {
	return (volatile.LoadUint32(&o.LLI5.Reg) & 0xfffffffc) >> 2
}

// GPDMA.CONTROL5: DMA Channel 0 Control Register
func (o *GPDMA_Type) SetCONTROL5_TRANSFERSIZE(value uint32) {
	volatile.StoreUint32(&o.CONTROL5.Reg, volatile.LoadUint32(&o.CONTROL5.Reg)&^(0xfff)|value)
}
func (o *GPDMA_Type) GetCONTROL5_TRANSFERSIZE() uint32 {
	return volatile.LoadUint32(&o.CONTROL5.Reg) & 0xfff
}
func (o *GPDMA_Type) SetCONTROL5_SBSIZE(value uint32) {
	volatile.StoreUint32(&o.CONTROL5.Reg, volatile.LoadUint32(&o.CONTROL5.Reg)&^(0x7000)|value<<12)
}
func (o *GPDMA_Type) GetCONTROL5_SBSIZE() uint32 {
	return (volatile.LoadUint32(&o.CONTROL5.Reg) & 0x7000) >> 12
}
func (o *GPDMA_Type) SetCONTROL5_DBSIZE(value uint32) {
	volatile.StoreUint32(&o.CONTROL5.Reg, volatile.LoadUint32(&o.CONTROL5.Reg)&^(0x38000)|value<<15)
}
func (o *GPDMA_Type) GetCONTROL5_DBSIZE() uint32 {
	return (volatile.LoadUint32(&o.CONTROL5.Reg) & 0x38000) >> 15
}
func (o *GPDMA_Type) SetCONTROL5_SWIDTH(value uint32) {
	volatile.StoreUint32(&o.CONTROL5.Reg, volatile.LoadUint32(&o.CONTROL5.Reg)&^(0x1c0000)|value<<18)
}
func (o *GPDMA_Type) GetCONTROL5_SWIDTH() uint32 {
	return (volatile.LoadUint32(&o.CONTROL5.Reg) & 0x1c0000) >> 18
}
func (o *GPDMA_Type) SetCONTROL5_DWIDTH(value uint32) {
	volatile.StoreUint32(&o.CONTROL5.Reg, volatile.LoadUint32(&o.CONTROL5.Reg)&^(0xe00000)|value<<21)
}
func (o *GPDMA_Type) GetCONTROL5_DWIDTH() uint32 {
	return (volatile.LoadUint32(&o.CONTROL5.Reg) & 0xe00000) >> 21
}
func (o *GPDMA_Type) SetCONTROL5_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONTROL5.Reg, volatile.LoadUint32(&o.CONTROL5.Reg)&^(0x3000000)|value<<24)
}
func (o *GPDMA_Type) GetCONTROL5_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONTROL5.Reg) & 0x3000000) >> 24
}
func (o *GPDMA_Type) SetCONTROL5_SI(value uint32) {
	volatile.StoreUint32(&o.CONTROL5.Reg, volatile.LoadUint32(&o.CONTROL5.Reg)&^(0x4000000)|value<<26)
}
func (o *GPDMA_Type) GetCONTROL5_SI() uint32 {
	return (volatile.LoadUint32(&o.CONTROL5.Reg) & 0x4000000) >> 26
}
func (o *GPDMA_Type) SetCONTROL5_DI(value uint32) {
	volatile.StoreUint32(&o.CONTROL5.Reg, volatile.LoadUint32(&o.CONTROL5.Reg)&^(0x8000000)|value<<27)
}
func (o *GPDMA_Type) GetCONTROL5_DI() uint32 {
	return (volatile.LoadUint32(&o.CONTROL5.Reg) & 0x8000000) >> 27
}
func (o *GPDMA_Type) SetCONTROL5_PROT1(value uint32) {
	volatile.StoreUint32(&o.CONTROL5.Reg, volatile.LoadUint32(&o.CONTROL5.Reg)&^(0x10000000)|value<<28)
}
func (o *GPDMA_Type) GetCONTROL5_PROT1() uint32 {
	return (volatile.LoadUint32(&o.CONTROL5.Reg) & 0x10000000) >> 28
}
func (o *GPDMA_Type) SetCONTROL5_PROT2(value uint32) {
	volatile.StoreUint32(&o.CONTROL5.Reg, volatile.LoadUint32(&o.CONTROL5.Reg)&^(0x20000000)|value<<29)
}
func (o *GPDMA_Type) GetCONTROL5_PROT2() uint32 {
	return (volatile.LoadUint32(&o.CONTROL5.Reg) & 0x20000000) >> 29
}
func (o *GPDMA_Type) SetCONTROL5_PROT3(value uint32) {
	volatile.StoreUint32(&o.CONTROL5.Reg, volatile.LoadUint32(&o.CONTROL5.Reg)&^(0x40000000)|value<<30)
}
func (o *GPDMA_Type) GetCONTROL5_PROT3() uint32 {
	return (volatile.LoadUint32(&o.CONTROL5.Reg) & 0x40000000) >> 30
}
func (o *GPDMA_Type) SetCONTROL5_I(value uint32) {
	volatile.StoreUint32(&o.CONTROL5.Reg, volatile.LoadUint32(&o.CONTROL5.Reg)&^(0x80000000)|value<<31)
}
func (o *GPDMA_Type) GetCONTROL5_I() uint32 {
	return (volatile.LoadUint32(&o.CONTROL5.Reg) & 0x80000000) >> 31
}

// GPDMA.CONFIG5: DMA Channel 0 Configuration Register[1]
func (o *GPDMA_Type) SetCONFIG5_E(value uint32) {
	volatile.StoreUint32(&o.CONFIG5.Reg, volatile.LoadUint32(&o.CONFIG5.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetCONFIG5_E() uint32 {
	return volatile.LoadUint32(&o.CONFIG5.Reg) & 0x1
}
func (o *GPDMA_Type) SetCONFIG5_SRCPERIPHERAL(value uint32) {
	volatile.StoreUint32(&o.CONFIG5.Reg, volatile.LoadUint32(&o.CONFIG5.Reg)&^(0x3e)|value<<1)
}
func (o *GPDMA_Type) GetCONFIG5_SRCPERIPHERAL() uint32 {
	return (volatile.LoadUint32(&o.CONFIG5.Reg) & 0x3e) >> 1
}
func (o *GPDMA_Type) SetCONFIG5_DESTPERIPHERAL(value uint32) {
	volatile.StoreUint32(&o.CONFIG5.Reg, volatile.LoadUint32(&o.CONFIG5.Reg)&^(0x7c0)|value<<6)
}
func (o *GPDMA_Type) GetCONFIG5_DESTPERIPHERAL() uint32 {
	return (volatile.LoadUint32(&o.CONFIG5.Reg) & 0x7c0) >> 6
}
func (o *GPDMA_Type) SetCONFIG5_TRANSFERTYPE(value uint32) {
	volatile.StoreUint32(&o.CONFIG5.Reg, volatile.LoadUint32(&o.CONFIG5.Reg)&^(0x3800)|value<<11)
}
func (o *GPDMA_Type) GetCONFIG5_TRANSFERTYPE() uint32 {
	return (volatile.LoadUint32(&o.CONFIG5.Reg) & 0x3800) >> 11
}
func (o *GPDMA_Type) SetCONFIG5_IE(value uint32) {
	volatile.StoreUint32(&o.CONFIG5.Reg, volatile.LoadUint32(&o.CONFIG5.Reg)&^(0x4000)|value<<14)
}
func (o *GPDMA_Type) GetCONFIG5_IE() uint32 {
	return (volatile.LoadUint32(&o.CONFIG5.Reg) & 0x4000) >> 14
}
func (o *GPDMA_Type) SetCONFIG5_ITC(value uint32) {
	volatile.StoreUint32(&o.CONFIG5.Reg, volatile.LoadUint32(&o.CONFIG5.Reg)&^(0x8000)|value<<15)
}
func (o *GPDMA_Type) GetCONFIG5_ITC() uint32 {
	return (volatile.LoadUint32(&o.CONFIG5.Reg) & 0x8000) >> 15
}
func (o *GPDMA_Type) SetCONFIG5_L(value uint32) {
	volatile.StoreUint32(&o.CONFIG5.Reg, volatile.LoadUint32(&o.CONFIG5.Reg)&^(0x10000)|value<<16)
}
func (o *GPDMA_Type) GetCONFIG5_L() uint32 {
	return (volatile.LoadUint32(&o.CONFIG5.Reg) & 0x10000) >> 16
}
func (o *GPDMA_Type) SetCONFIG5_A(value uint32) {
	volatile.StoreUint32(&o.CONFIG5.Reg, volatile.LoadUint32(&o.CONFIG5.Reg)&^(0x20000)|value<<17)
}
func (o *GPDMA_Type) GetCONFIG5_A() uint32 {
	return (volatile.LoadUint32(&o.CONFIG5.Reg) & 0x20000) >> 17
}
func (o *GPDMA_Type) SetCONFIG5_H(value uint32) {
	volatile.StoreUint32(&o.CONFIG5.Reg, volatile.LoadUint32(&o.CONFIG5.Reg)&^(0x40000)|value<<18)
}
func (o *GPDMA_Type) GetCONFIG5_H() uint32 {
	return (volatile.LoadUint32(&o.CONFIG5.Reg) & 0x40000) >> 18
}
func (o *GPDMA_Type) SetCONFIG5_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONFIG5.Reg, volatile.LoadUint32(&o.CONFIG5.Reg)&^(0xfff80000)|value<<19)
}
func (o *GPDMA_Type) GetCONFIG5_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONFIG5.Reg) & 0xfff80000) >> 19
}

// GPDMA.SRCADDR6: DMA Channel 0 Source Address Register
func (o *GPDMA_Type) SetSRCADDR6(value uint32) {
	volatile.StoreUint32(&o.SRCADDR6.Reg, value)
}
func (o *GPDMA_Type) GetSRCADDR6() uint32 {
	return volatile.LoadUint32(&o.SRCADDR6.Reg)
}

// GPDMA.DESTADDR6: DMA Channel 0 Destination Address Register
func (o *GPDMA_Type) SetDESTADDR6(value uint32) {
	volatile.StoreUint32(&o.DESTADDR6.Reg, value)
}
func (o *GPDMA_Type) GetDESTADDR6() uint32 {
	return volatile.LoadUint32(&o.DESTADDR6.Reg)
}

// GPDMA.LLI6: DMA Channel 0 Linked List Item Register
func (o *GPDMA_Type) SetLLI6_RESERVED(value uint32) {
	volatile.StoreUint32(&o.LLI6.Reg, volatile.LoadUint32(&o.LLI6.Reg)&^(0x3)|value)
}
func (o *GPDMA_Type) GetLLI6_RESERVED() uint32 {
	return volatile.LoadUint32(&o.LLI6.Reg) & 0x3
}
func (o *GPDMA_Type) SetLLI6_LLI(value uint32) {
	volatile.StoreUint32(&o.LLI6.Reg, volatile.LoadUint32(&o.LLI6.Reg)&^(0xfffffffc)|value<<2)
}
func (o *GPDMA_Type) GetLLI6_LLI() uint32 {
	return (volatile.LoadUint32(&o.LLI6.Reg) & 0xfffffffc) >> 2
}

// GPDMA.CONTROL6: DMA Channel 0 Control Register
func (o *GPDMA_Type) SetCONTROL6_TRANSFERSIZE(value uint32) {
	volatile.StoreUint32(&o.CONTROL6.Reg, volatile.LoadUint32(&o.CONTROL6.Reg)&^(0xfff)|value)
}
func (o *GPDMA_Type) GetCONTROL6_TRANSFERSIZE() uint32 {
	return volatile.LoadUint32(&o.CONTROL6.Reg) & 0xfff
}
func (o *GPDMA_Type) SetCONTROL6_SBSIZE(value uint32) {
	volatile.StoreUint32(&o.CONTROL6.Reg, volatile.LoadUint32(&o.CONTROL6.Reg)&^(0x7000)|value<<12)
}
func (o *GPDMA_Type) GetCONTROL6_SBSIZE() uint32 {
	return (volatile.LoadUint32(&o.CONTROL6.Reg) & 0x7000) >> 12
}
func (o *GPDMA_Type) SetCONTROL6_DBSIZE(value uint32) {
	volatile.StoreUint32(&o.CONTROL6.Reg, volatile.LoadUint32(&o.CONTROL6.Reg)&^(0x38000)|value<<15)
}
func (o *GPDMA_Type) GetCONTROL6_DBSIZE() uint32 {
	return (volatile.LoadUint32(&o.CONTROL6.Reg) & 0x38000) >> 15
}
func (o *GPDMA_Type) SetCONTROL6_SWIDTH(value uint32) {
	volatile.StoreUint32(&o.CONTROL6.Reg, volatile.LoadUint32(&o.CONTROL6.Reg)&^(0x1c0000)|value<<18)
}
func (o *GPDMA_Type) GetCONTROL6_SWIDTH() uint32 {
	return (volatile.LoadUint32(&o.CONTROL6.Reg) & 0x1c0000) >> 18
}
func (o *GPDMA_Type) SetCONTROL6_DWIDTH(value uint32) {
	volatile.StoreUint32(&o.CONTROL6.Reg, volatile.LoadUint32(&o.CONTROL6.Reg)&^(0xe00000)|value<<21)
}
func (o *GPDMA_Type) GetCONTROL6_DWIDTH() uint32 {
	return (volatile.LoadUint32(&o.CONTROL6.Reg) & 0xe00000) >> 21
}
func (o *GPDMA_Type) SetCONTROL6_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONTROL6.Reg, volatile.LoadUint32(&o.CONTROL6.Reg)&^(0x3000000)|value<<24)
}
func (o *GPDMA_Type) GetCONTROL6_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONTROL6.Reg) & 0x3000000) >> 24
}
func (o *GPDMA_Type) SetCONTROL6_SI(value uint32) {
	volatile.StoreUint32(&o.CONTROL6.Reg, volatile.LoadUint32(&o.CONTROL6.Reg)&^(0x4000000)|value<<26)
}
func (o *GPDMA_Type) GetCONTROL6_SI() uint32 {
	return (volatile.LoadUint32(&o.CONTROL6.Reg) & 0x4000000) >> 26
}
func (o *GPDMA_Type) SetCONTROL6_DI(value uint32) {
	volatile.StoreUint32(&o.CONTROL6.Reg, volatile.LoadUint32(&o.CONTROL6.Reg)&^(0x8000000)|value<<27)
}
func (o *GPDMA_Type) GetCONTROL6_DI() uint32 {
	return (volatile.LoadUint32(&o.CONTROL6.Reg) & 0x8000000) >> 27
}
func (o *GPDMA_Type) SetCONTROL6_PROT1(value uint32) {
	volatile.StoreUint32(&o.CONTROL6.Reg, volatile.LoadUint32(&o.CONTROL6.Reg)&^(0x10000000)|value<<28)
}
func (o *GPDMA_Type) GetCONTROL6_PROT1() uint32 {
	return (volatile.LoadUint32(&o.CONTROL6.Reg) & 0x10000000) >> 28
}
func (o *GPDMA_Type) SetCONTROL6_PROT2(value uint32) {
	volatile.StoreUint32(&o.CONTROL6.Reg, volatile.LoadUint32(&o.CONTROL6.Reg)&^(0x20000000)|value<<29)
}
func (o *GPDMA_Type) GetCONTROL6_PROT2() uint32 {
	return (volatile.LoadUint32(&o.CONTROL6.Reg) & 0x20000000) >> 29
}
func (o *GPDMA_Type) SetCONTROL6_PROT3(value uint32) {
	volatile.StoreUint32(&o.CONTROL6.Reg, volatile.LoadUint32(&o.CONTROL6.Reg)&^(0x40000000)|value<<30)
}
func (o *GPDMA_Type) GetCONTROL6_PROT3() uint32 {
	return (volatile.LoadUint32(&o.CONTROL6.Reg) & 0x40000000) >> 30
}
func (o *GPDMA_Type) SetCONTROL6_I(value uint32) {
	volatile.StoreUint32(&o.CONTROL6.Reg, volatile.LoadUint32(&o.CONTROL6.Reg)&^(0x80000000)|value<<31)
}
func (o *GPDMA_Type) GetCONTROL6_I() uint32 {
	return (volatile.LoadUint32(&o.CONTROL6.Reg) & 0x80000000) >> 31
}

// GPDMA.CONFIG6: DMA Channel 0 Configuration Register[1]
func (o *GPDMA_Type) SetCONFIG6_E(value uint32) {
	volatile.StoreUint32(&o.CONFIG6.Reg, volatile.LoadUint32(&o.CONFIG6.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetCONFIG6_E() uint32 {
	return volatile.LoadUint32(&o.CONFIG6.Reg) & 0x1
}
func (o *GPDMA_Type) SetCONFIG6_SRCPERIPHERAL(value uint32) {
	volatile.StoreUint32(&o.CONFIG6.Reg, volatile.LoadUint32(&o.CONFIG6.Reg)&^(0x3e)|value<<1)
}
func (o *GPDMA_Type) GetCONFIG6_SRCPERIPHERAL() uint32 {
	return (volatile.LoadUint32(&o.CONFIG6.Reg) & 0x3e) >> 1
}
func (o *GPDMA_Type) SetCONFIG6_DESTPERIPHERAL(value uint32) {
	volatile.StoreUint32(&o.CONFIG6.Reg, volatile.LoadUint32(&o.CONFIG6.Reg)&^(0x7c0)|value<<6)
}
func (o *GPDMA_Type) GetCONFIG6_DESTPERIPHERAL() uint32 {
	return (volatile.LoadUint32(&o.CONFIG6.Reg) & 0x7c0) >> 6
}
func (o *GPDMA_Type) SetCONFIG6_TRANSFERTYPE(value uint32) {
	volatile.StoreUint32(&o.CONFIG6.Reg, volatile.LoadUint32(&o.CONFIG6.Reg)&^(0x3800)|value<<11)
}
func (o *GPDMA_Type) GetCONFIG6_TRANSFERTYPE() uint32 {
	return (volatile.LoadUint32(&o.CONFIG6.Reg) & 0x3800) >> 11
}
func (o *GPDMA_Type) SetCONFIG6_IE(value uint32) {
	volatile.StoreUint32(&o.CONFIG6.Reg, volatile.LoadUint32(&o.CONFIG6.Reg)&^(0x4000)|value<<14)
}
func (o *GPDMA_Type) GetCONFIG6_IE() uint32 {
	return (volatile.LoadUint32(&o.CONFIG6.Reg) & 0x4000) >> 14
}
func (o *GPDMA_Type) SetCONFIG6_ITC(value uint32) {
	volatile.StoreUint32(&o.CONFIG6.Reg, volatile.LoadUint32(&o.CONFIG6.Reg)&^(0x8000)|value<<15)
}
func (o *GPDMA_Type) GetCONFIG6_ITC() uint32 {
	return (volatile.LoadUint32(&o.CONFIG6.Reg) & 0x8000) >> 15
}
func (o *GPDMA_Type) SetCONFIG6_L(value uint32) {
	volatile.StoreUint32(&o.CONFIG6.Reg, volatile.LoadUint32(&o.CONFIG6.Reg)&^(0x10000)|value<<16)
}
func (o *GPDMA_Type) GetCONFIG6_L() uint32 {
	return (volatile.LoadUint32(&o.CONFIG6.Reg) & 0x10000) >> 16
}
func (o *GPDMA_Type) SetCONFIG6_A(value uint32) {
	volatile.StoreUint32(&o.CONFIG6.Reg, volatile.LoadUint32(&o.CONFIG6.Reg)&^(0x20000)|value<<17)
}
func (o *GPDMA_Type) GetCONFIG6_A() uint32 {
	return (volatile.LoadUint32(&o.CONFIG6.Reg) & 0x20000) >> 17
}
func (o *GPDMA_Type) SetCONFIG6_H(value uint32) {
	volatile.StoreUint32(&o.CONFIG6.Reg, volatile.LoadUint32(&o.CONFIG6.Reg)&^(0x40000)|value<<18)
}
func (o *GPDMA_Type) GetCONFIG6_H() uint32 {
	return (volatile.LoadUint32(&o.CONFIG6.Reg) & 0x40000) >> 18
}
func (o *GPDMA_Type) SetCONFIG6_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONFIG6.Reg, volatile.LoadUint32(&o.CONFIG6.Reg)&^(0xfff80000)|value<<19)
}
func (o *GPDMA_Type) GetCONFIG6_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONFIG6.Reg) & 0xfff80000) >> 19
}

// GPDMA.SRCADDR7: DMA Channel 0 Source Address Register
func (o *GPDMA_Type) SetSRCADDR7(value uint32) {
	volatile.StoreUint32(&o.SRCADDR7.Reg, value)
}
func (o *GPDMA_Type) GetSRCADDR7() uint32 {
	return volatile.LoadUint32(&o.SRCADDR7.Reg)
}

// GPDMA.DESTADDR7: DMA Channel 0 Destination Address Register
func (o *GPDMA_Type) SetDESTADDR7(value uint32) {
	volatile.StoreUint32(&o.DESTADDR7.Reg, value)
}
func (o *GPDMA_Type) GetDESTADDR7() uint32 {
	return volatile.LoadUint32(&o.DESTADDR7.Reg)
}

// GPDMA.LLI7: DMA Channel 0 Linked List Item Register
func (o *GPDMA_Type) SetLLI7_RESERVED(value uint32) {
	volatile.StoreUint32(&o.LLI7.Reg, volatile.LoadUint32(&o.LLI7.Reg)&^(0x3)|value)
}
func (o *GPDMA_Type) GetLLI7_RESERVED() uint32 {
	return volatile.LoadUint32(&o.LLI7.Reg) & 0x3
}
func (o *GPDMA_Type) SetLLI7_LLI(value uint32) {
	volatile.StoreUint32(&o.LLI7.Reg, volatile.LoadUint32(&o.LLI7.Reg)&^(0xfffffffc)|value<<2)
}
func (o *GPDMA_Type) GetLLI7_LLI() uint32 {
	return (volatile.LoadUint32(&o.LLI7.Reg) & 0xfffffffc) >> 2
}

// GPDMA.CONTROL7: DMA Channel 0 Control Register
func (o *GPDMA_Type) SetCONTROL7_TRANSFERSIZE(value uint32) {
	volatile.StoreUint32(&o.CONTROL7.Reg, volatile.LoadUint32(&o.CONTROL7.Reg)&^(0xfff)|value)
}
func (o *GPDMA_Type) GetCONTROL7_TRANSFERSIZE() uint32 {
	return volatile.LoadUint32(&o.CONTROL7.Reg) & 0xfff
}
func (o *GPDMA_Type) SetCONTROL7_SBSIZE(value uint32) {
	volatile.StoreUint32(&o.CONTROL7.Reg, volatile.LoadUint32(&o.CONTROL7.Reg)&^(0x7000)|value<<12)
}
func (o *GPDMA_Type) GetCONTROL7_SBSIZE() uint32 {
	return (volatile.LoadUint32(&o.CONTROL7.Reg) & 0x7000) >> 12
}
func (o *GPDMA_Type) SetCONTROL7_DBSIZE(value uint32) {
	volatile.StoreUint32(&o.CONTROL7.Reg, volatile.LoadUint32(&o.CONTROL7.Reg)&^(0x38000)|value<<15)
}
func (o *GPDMA_Type) GetCONTROL7_DBSIZE() uint32 {
	return (volatile.LoadUint32(&o.CONTROL7.Reg) & 0x38000) >> 15
}
func (o *GPDMA_Type) SetCONTROL7_SWIDTH(value uint32) {
	volatile.StoreUint32(&o.CONTROL7.Reg, volatile.LoadUint32(&o.CONTROL7.Reg)&^(0x1c0000)|value<<18)
}
func (o *GPDMA_Type) GetCONTROL7_SWIDTH() uint32 {
	return (volatile.LoadUint32(&o.CONTROL7.Reg) & 0x1c0000) >> 18
}
func (o *GPDMA_Type) SetCONTROL7_DWIDTH(value uint32) {
	volatile.StoreUint32(&o.CONTROL7.Reg, volatile.LoadUint32(&o.CONTROL7.Reg)&^(0xe00000)|value<<21)
}
func (o *GPDMA_Type) GetCONTROL7_DWIDTH() uint32 {
	return (volatile.LoadUint32(&o.CONTROL7.Reg) & 0xe00000) >> 21
}
func (o *GPDMA_Type) SetCONTROL7_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONTROL7.Reg, volatile.LoadUint32(&o.CONTROL7.Reg)&^(0x3000000)|value<<24)
}
func (o *GPDMA_Type) GetCONTROL7_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONTROL7.Reg) & 0x3000000) >> 24
}
func (o *GPDMA_Type) SetCONTROL7_SI(value uint32) {
	volatile.StoreUint32(&o.CONTROL7.Reg, volatile.LoadUint32(&o.CONTROL7.Reg)&^(0x4000000)|value<<26)
}
func (o *GPDMA_Type) GetCONTROL7_SI() uint32 {
	return (volatile.LoadUint32(&o.CONTROL7.Reg) & 0x4000000) >> 26
}
func (o *GPDMA_Type) SetCONTROL7_DI(value uint32) {
	volatile.StoreUint32(&o.CONTROL7.Reg, volatile.LoadUint32(&o.CONTROL7.Reg)&^(0x8000000)|value<<27)
}
func (o *GPDMA_Type) GetCONTROL7_DI() uint32 {
	return (volatile.LoadUint32(&o.CONTROL7.Reg) & 0x8000000) >> 27
}
func (o *GPDMA_Type) SetCONTROL7_PROT1(value uint32) {
	volatile.StoreUint32(&o.CONTROL7.Reg, volatile.LoadUint32(&o.CONTROL7.Reg)&^(0x10000000)|value<<28)
}
func (o *GPDMA_Type) GetCONTROL7_PROT1() uint32 {
	return (volatile.LoadUint32(&o.CONTROL7.Reg) & 0x10000000) >> 28
}
func (o *GPDMA_Type) SetCONTROL7_PROT2(value uint32) {
	volatile.StoreUint32(&o.CONTROL7.Reg, volatile.LoadUint32(&o.CONTROL7.Reg)&^(0x20000000)|value<<29)
}
func (o *GPDMA_Type) GetCONTROL7_PROT2() uint32 {
	return (volatile.LoadUint32(&o.CONTROL7.Reg) & 0x20000000) >> 29
}
func (o *GPDMA_Type) SetCONTROL7_PROT3(value uint32) {
	volatile.StoreUint32(&o.CONTROL7.Reg, volatile.LoadUint32(&o.CONTROL7.Reg)&^(0x40000000)|value<<30)
}
func (o *GPDMA_Type) GetCONTROL7_PROT3() uint32 {
	return (volatile.LoadUint32(&o.CONTROL7.Reg) & 0x40000000) >> 30
}
func (o *GPDMA_Type) SetCONTROL7_I(value uint32) {
	volatile.StoreUint32(&o.CONTROL7.Reg, volatile.LoadUint32(&o.CONTROL7.Reg)&^(0x80000000)|value<<31)
}
func (o *GPDMA_Type) GetCONTROL7_I() uint32 {
	return (volatile.LoadUint32(&o.CONTROL7.Reg) & 0x80000000) >> 31
}

// GPDMA.CONFIG7: DMA Channel 0 Configuration Register[1]
func (o *GPDMA_Type) SetCONFIG7_E(value uint32) {
	volatile.StoreUint32(&o.CONFIG7.Reg, volatile.LoadUint32(&o.CONFIG7.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetCONFIG7_E() uint32 {
	return volatile.LoadUint32(&o.CONFIG7.Reg) & 0x1
}
func (o *GPDMA_Type) SetCONFIG7_SRCPERIPHERAL(value uint32) {
	volatile.StoreUint32(&o.CONFIG7.Reg, volatile.LoadUint32(&o.CONFIG7.Reg)&^(0x3e)|value<<1)
}
func (o *GPDMA_Type) GetCONFIG7_SRCPERIPHERAL() uint32 {
	return (volatile.LoadUint32(&o.CONFIG7.Reg) & 0x3e) >> 1
}
func (o *GPDMA_Type) SetCONFIG7_DESTPERIPHERAL(value uint32) {
	volatile.StoreUint32(&o.CONFIG7.Reg, volatile.LoadUint32(&o.CONFIG7.Reg)&^(0x7c0)|value<<6)
}
func (o *GPDMA_Type) GetCONFIG7_DESTPERIPHERAL() uint32 {
	return (volatile.LoadUint32(&o.CONFIG7.Reg) & 0x7c0) >> 6
}
func (o *GPDMA_Type) SetCONFIG7_TRANSFERTYPE(value uint32) {
	volatile.StoreUint32(&o.CONFIG7.Reg, volatile.LoadUint32(&o.CONFIG7.Reg)&^(0x3800)|value<<11)
}
func (o *GPDMA_Type) GetCONFIG7_TRANSFERTYPE() uint32 {
	return (volatile.LoadUint32(&o.CONFIG7.Reg) & 0x3800) >> 11
}
func (o *GPDMA_Type) SetCONFIG7_IE(value uint32) {
	volatile.StoreUint32(&o.CONFIG7.Reg, volatile.LoadUint32(&o.CONFIG7.Reg)&^(0x4000)|value<<14)
}
func (o *GPDMA_Type) GetCONFIG7_IE() uint32 {
	return (volatile.LoadUint32(&o.CONFIG7.Reg) & 0x4000) >> 14
}
func (o *GPDMA_Type) SetCONFIG7_ITC(value uint32) {
	volatile.StoreUint32(&o.CONFIG7.Reg, volatile.LoadUint32(&o.CONFIG7.Reg)&^(0x8000)|value<<15)
}
func (o *GPDMA_Type) GetCONFIG7_ITC() uint32 {
	return (volatile.LoadUint32(&o.CONFIG7.Reg) & 0x8000) >> 15
}
func (o *GPDMA_Type) SetCONFIG7_L(value uint32) {
	volatile.StoreUint32(&o.CONFIG7.Reg, volatile.LoadUint32(&o.CONFIG7.Reg)&^(0x10000)|value<<16)
}
func (o *GPDMA_Type) GetCONFIG7_L() uint32 {
	return (volatile.LoadUint32(&o.CONFIG7.Reg) & 0x10000) >> 16
}
func (o *GPDMA_Type) SetCONFIG7_A(value uint32) {
	volatile.StoreUint32(&o.CONFIG7.Reg, volatile.LoadUint32(&o.CONFIG7.Reg)&^(0x20000)|value<<17)
}
func (o *GPDMA_Type) GetCONFIG7_A() uint32 {
	return (volatile.LoadUint32(&o.CONFIG7.Reg) & 0x20000) >> 17
}
func (o *GPDMA_Type) SetCONFIG7_H(value uint32) {
	volatile.StoreUint32(&o.CONFIG7.Reg, volatile.LoadUint32(&o.CONFIG7.Reg)&^(0x40000)|value<<18)
}
func (o *GPDMA_Type) GetCONFIG7_H() uint32 {
	return (volatile.LoadUint32(&o.CONFIG7.Reg) & 0x40000) >> 18
}
func (o *GPDMA_Type) SetCONFIG7_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONFIG7.Reg, volatile.LoadUint32(&o.CONFIG7.Reg)&^(0xfff80000)|value<<19)
}
func (o *GPDMA_Type) GetCONFIG7_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONFIG7.Reg) & 0xfff80000) >> 19
}

// Ethernet
type ETHERNET_Type struct {
	MAC1               volatile.Register32 // 0x0
	MAC2               volatile.Register32 // 0x4
	IPGT               volatile.Register32 // 0x8
	IPGR               volatile.Register32 // 0xC
	CLRT               volatile.Register32 // 0x10
	MAXF               volatile.Register32 // 0x14
	SUPP               volatile.Register32 // 0x18
	TEST               volatile.Register32 // 0x1C
	MCFG               volatile.Register32 // 0x20
	MCMD               volatile.Register32 // 0x24
	MADR               volatile.Register32 // 0x28
	MWTD               volatile.Register32 // 0x2C
	MRDD               volatile.Register32 // 0x30
	MIND               volatile.Register32 // 0x34
	_                  [8]byte
	SA0                volatile.Register32 // 0x40
	SA1                volatile.Register32 // 0x44
	SA2                volatile.Register32 // 0x48
	_                  [180]byte
	COMMAND            volatile.Register32 // 0x100
	STATUS             volatile.Register32 // 0x104
	RXDESCRIPTOR       volatile.Register32 // 0x108
	RXSTATUS           volatile.Register32 // 0x10C
	RXDESCRIPTORNUMBER volatile.Register32 // 0x110
	RXPRODUCEINDEX     volatile.Register32 // 0x114
	RXCONSUMEINDEX     volatile.Register32 // 0x118
	TXDESCRIPTOR       volatile.Register32 // 0x11C
	TXSTATUS           volatile.Register32 // 0x120
	TXDESCRIPTORNUMBER volatile.Register32 // 0x124
	TXPRODUCEINDEX     volatile.Register32 // 0x128
	TXCONSUMEINDEX     volatile.Register32 // 0x12C
	_                  [40]byte
	TSV0               volatile.Register32 // 0x158
	TSV1               volatile.Register32 // 0x15C
	RSV                volatile.Register32 // 0x160
	_                  [12]byte
	FLOWCONTROLCOUNTER volatile.Register32 // 0x170
	FLOWCONTROLSTATUS  volatile.Register32 // 0x174
	_                  [136]byte
	RXFILTERCTRL       volatile.Register32 // 0x200
	RXFILTERWOLSTATUS  volatile.Register32 // 0x204
	RXFILTERWOLCLEAR   volatile.Register32 // 0x208
	_                  [4]byte
	HASHFILTERL        volatile.Register32 // 0x210
	HASHFILTERH        volatile.Register32 // 0x214
	_                  [3528]byte
	INTSTATUS          volatile.Register32 // 0xFE0
	INTENABLE          volatile.Register32 // 0xFE4
	INTCLEAR           volatile.Register32 // 0xFE8
	INTSET             volatile.Register32 // 0xFEC
	_                  [4]byte
	POWERDOWN          volatile.Register32 // 0xFF4
}

// ETHERNET.MAC1: MAC configuration register 1.
func (o *ETHERNET_Type) SetMAC1_RXENABLE(value uint32) {
	volatile.StoreUint32(&o.MAC1.Reg, volatile.LoadUint32(&o.MAC1.Reg)&^(0x1)|value)
}
func (o *ETHERNET_Type) GetMAC1_RXENABLE() uint32 {
	return volatile.LoadUint32(&o.MAC1.Reg) & 0x1
}
func (o *ETHERNET_Type) SetMAC1_PARF(value uint32) {
	volatile.StoreUint32(&o.MAC1.Reg, volatile.LoadUint32(&o.MAC1.Reg)&^(0x2)|value<<1)
}
func (o *ETHERNET_Type) GetMAC1_PARF() uint32 {
	return (volatile.LoadUint32(&o.MAC1.Reg) & 0x2) >> 1
}
func (o *ETHERNET_Type) SetMAC1_RXFLOWCTRL(value uint32) {
	volatile.StoreUint32(&o.MAC1.Reg, volatile.LoadUint32(&o.MAC1.Reg)&^(0x4)|value<<2)
}
func (o *ETHERNET_Type) GetMAC1_RXFLOWCTRL() uint32 {
	return (volatile.LoadUint32(&o.MAC1.Reg) & 0x4) >> 2
}
func (o *ETHERNET_Type) SetMAC1_TXFLOWCTRL(value uint32) {
	volatile.StoreUint32(&o.MAC1.Reg, volatile.LoadUint32(&o.MAC1.Reg)&^(0x8)|value<<3)
}
func (o *ETHERNET_Type) GetMAC1_TXFLOWCTRL() uint32 {
	return (volatile.LoadUint32(&o.MAC1.Reg) & 0x8) >> 3
}
func (o *ETHERNET_Type) SetMAC1_LOOPBACK(value uint32) {
	volatile.StoreUint32(&o.MAC1.Reg, volatile.LoadUint32(&o.MAC1.Reg)&^(0x10)|value<<4)
}
func (o *ETHERNET_Type) GetMAC1_LOOPBACK() uint32 {
	return (volatile.LoadUint32(&o.MAC1.Reg) & 0x10) >> 4
}
func (o *ETHERNET_Type) SetMAC1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MAC1.Reg, volatile.LoadUint32(&o.MAC1.Reg)&^(0xe0)|value<<5)
}
func (o *ETHERNET_Type) GetMAC1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MAC1.Reg) & 0xe0) >> 5
}
func (o *ETHERNET_Type) SetMAC1_RESETTX(value uint32) {
	volatile.StoreUint32(&o.MAC1.Reg, volatile.LoadUint32(&o.MAC1.Reg)&^(0x100)|value<<8)
}
func (o *ETHERNET_Type) GetMAC1_RESETTX() uint32 {
	return (volatile.LoadUint32(&o.MAC1.Reg) & 0x100) >> 8
}
func (o *ETHERNET_Type) SetMAC1_RESETMCSTX(value uint32) {
	volatile.StoreUint32(&o.MAC1.Reg, volatile.LoadUint32(&o.MAC1.Reg)&^(0x200)|value<<9)
}
func (o *ETHERNET_Type) GetMAC1_RESETMCSTX() uint32 {
	return (volatile.LoadUint32(&o.MAC1.Reg) & 0x200) >> 9
}
func (o *ETHERNET_Type) SetMAC1_RESETRX(value uint32) {
	volatile.StoreUint32(&o.MAC1.Reg, volatile.LoadUint32(&o.MAC1.Reg)&^(0x400)|value<<10)
}
func (o *ETHERNET_Type) GetMAC1_RESETRX() uint32 {
	return (volatile.LoadUint32(&o.MAC1.Reg) & 0x400) >> 10
}
func (o *ETHERNET_Type) SetMAC1_RESETMCSRX(value uint32) {
	volatile.StoreUint32(&o.MAC1.Reg, volatile.LoadUint32(&o.MAC1.Reg)&^(0x800)|value<<11)
}
func (o *ETHERNET_Type) GetMAC1_RESETMCSRX() uint32 {
	return (volatile.LoadUint32(&o.MAC1.Reg) & 0x800) >> 11
}
func (o *ETHERNET_Type) SetMAC1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MAC1.Reg, volatile.LoadUint32(&o.MAC1.Reg)&^(0x3000)|value<<12)
}
func (o *ETHERNET_Type) GetMAC1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MAC1.Reg) & 0x3000) >> 12
}
func (o *ETHERNET_Type) SetMAC1_SIMRESET(value uint32) {
	volatile.StoreUint32(&o.MAC1.Reg, volatile.LoadUint32(&o.MAC1.Reg)&^(0x4000)|value<<14)
}
func (o *ETHERNET_Type) GetMAC1_SIMRESET() uint32 {
	return (volatile.LoadUint32(&o.MAC1.Reg) & 0x4000) >> 14
}
func (o *ETHERNET_Type) SetMAC1_SOFTRESET(value uint32) {
	volatile.StoreUint32(&o.MAC1.Reg, volatile.LoadUint32(&o.MAC1.Reg)&^(0x8000)|value<<15)
}
func (o *ETHERNET_Type) GetMAC1_SOFTRESET() uint32 {
	return (volatile.LoadUint32(&o.MAC1.Reg) & 0x8000) >> 15
}
func (o *ETHERNET_Type) SetMAC1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MAC1.Reg, volatile.LoadUint32(&o.MAC1.Reg)&^(0xffff0000)|value<<16)
}
func (o *ETHERNET_Type) GetMAC1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MAC1.Reg) & 0xffff0000) >> 16
}

// ETHERNET.MAC2: MAC configuration register 2.
func (o *ETHERNET_Type) SetMAC2_FULLDUPLEX(value uint32) {
	volatile.StoreUint32(&o.MAC2.Reg, volatile.LoadUint32(&o.MAC2.Reg)&^(0x1)|value)
}
func (o *ETHERNET_Type) GetMAC2_FULLDUPLEX() uint32 {
	return volatile.LoadUint32(&o.MAC2.Reg) & 0x1
}
func (o *ETHERNET_Type) SetMAC2_FLC(value uint32) {
	volatile.StoreUint32(&o.MAC2.Reg, volatile.LoadUint32(&o.MAC2.Reg)&^(0x2)|value<<1)
}
func (o *ETHERNET_Type) GetMAC2_FLC() uint32 {
	return (volatile.LoadUint32(&o.MAC2.Reg) & 0x2) >> 1
}
func (o *ETHERNET_Type) SetMAC2_HFEN(value uint32) {
	volatile.StoreUint32(&o.MAC2.Reg, volatile.LoadUint32(&o.MAC2.Reg)&^(0x4)|value<<2)
}
func (o *ETHERNET_Type) GetMAC2_HFEN() uint32 {
	return (volatile.LoadUint32(&o.MAC2.Reg) & 0x4) >> 2
}
func (o *ETHERNET_Type) SetMAC2_DELAYEDCRC(value uint32) {
	volatile.StoreUint32(&o.MAC2.Reg, volatile.LoadUint32(&o.MAC2.Reg)&^(0x8)|value<<3)
}
func (o *ETHERNET_Type) GetMAC2_DELAYEDCRC() uint32 {
	return (volatile.LoadUint32(&o.MAC2.Reg) & 0x8) >> 3
}
func (o *ETHERNET_Type) SetMAC2_CRCEN(value uint32) {
	volatile.StoreUint32(&o.MAC2.Reg, volatile.LoadUint32(&o.MAC2.Reg)&^(0x10)|value<<4)
}
func (o *ETHERNET_Type) GetMAC2_CRCEN() uint32 {
	return (volatile.LoadUint32(&o.MAC2.Reg) & 0x10) >> 4
}
func (o *ETHERNET_Type) SetMAC2_PADCRCEN(value uint32) {
	volatile.StoreUint32(&o.MAC2.Reg, volatile.LoadUint32(&o.MAC2.Reg)&^(0x20)|value<<5)
}
func (o *ETHERNET_Type) GetMAC2_PADCRCEN() uint32 {
	return (volatile.LoadUint32(&o.MAC2.Reg) & 0x20) >> 5
}
func (o *ETHERNET_Type) SetMAC2_VLANPADEN(value uint32) {
	volatile.StoreUint32(&o.MAC2.Reg, volatile.LoadUint32(&o.MAC2.Reg)&^(0x40)|value<<6)
}
func (o *ETHERNET_Type) GetMAC2_VLANPADEN() uint32 {
	return (volatile.LoadUint32(&o.MAC2.Reg) & 0x40) >> 6
}
func (o *ETHERNET_Type) SetMAC2_AUTODETPADEN(value uint32) {
	volatile.StoreUint32(&o.MAC2.Reg, volatile.LoadUint32(&o.MAC2.Reg)&^(0x80)|value<<7)
}
func (o *ETHERNET_Type) GetMAC2_AUTODETPADEN() uint32 {
	return (volatile.LoadUint32(&o.MAC2.Reg) & 0x80) >> 7
}
func (o *ETHERNET_Type) SetMAC2_PPENF(value uint32) {
	volatile.StoreUint32(&o.MAC2.Reg, volatile.LoadUint32(&o.MAC2.Reg)&^(0x100)|value<<8)
}
func (o *ETHERNET_Type) GetMAC2_PPENF() uint32 {
	return (volatile.LoadUint32(&o.MAC2.Reg) & 0x100) >> 8
}
func (o *ETHERNET_Type) SetMAC2_LPENF(value uint32) {
	volatile.StoreUint32(&o.MAC2.Reg, volatile.LoadUint32(&o.MAC2.Reg)&^(0x200)|value<<9)
}
func (o *ETHERNET_Type) GetMAC2_LPENF() uint32 {
	return (volatile.LoadUint32(&o.MAC2.Reg) & 0x200) >> 9
}
func (o *ETHERNET_Type) SetMAC2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MAC2.Reg, volatile.LoadUint32(&o.MAC2.Reg)&^(0xc00)|value<<10)
}
func (o *ETHERNET_Type) GetMAC2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MAC2.Reg) & 0xc00) >> 10
}
func (o *ETHERNET_Type) SetMAC2_NOBACKOFF(value uint32) {
	volatile.StoreUint32(&o.MAC2.Reg, volatile.LoadUint32(&o.MAC2.Reg)&^(0x1000)|value<<12)
}
func (o *ETHERNET_Type) GetMAC2_NOBACKOFF() uint32 {
	return (volatile.LoadUint32(&o.MAC2.Reg) & 0x1000) >> 12
}
func (o *ETHERNET_Type) SetMAC2_BP_NOBACKOFF(value uint32) {
	volatile.StoreUint32(&o.MAC2.Reg, volatile.LoadUint32(&o.MAC2.Reg)&^(0x2000)|value<<13)
}
func (o *ETHERNET_Type) GetMAC2_BP_NOBACKOFF() uint32 {
	return (volatile.LoadUint32(&o.MAC2.Reg) & 0x2000) >> 13
}
func (o *ETHERNET_Type) SetMAC2_EXCESSDEFER(value uint32) {
	volatile.StoreUint32(&o.MAC2.Reg, volatile.LoadUint32(&o.MAC2.Reg)&^(0x4000)|value<<14)
}
func (o *ETHERNET_Type) GetMAC2_EXCESSDEFER() uint32 {
	return (volatile.LoadUint32(&o.MAC2.Reg) & 0x4000) >> 14
}
func (o *ETHERNET_Type) SetMAC2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MAC2.Reg, volatile.LoadUint32(&o.MAC2.Reg)&^(0xffff8000)|value<<15)
}
func (o *ETHERNET_Type) GetMAC2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MAC2.Reg) & 0xffff8000) >> 15
}

// ETHERNET.IPGT: Back-to-Back Inter-Packet-Gap register.
func (o *ETHERNET_Type) SetIPGT_BTOBINTEGAP(value uint32) {
	volatile.StoreUint32(&o.IPGT.Reg, volatile.LoadUint32(&o.IPGT.Reg)&^(0x7f)|value)
}
func (o *ETHERNET_Type) GetIPGT_BTOBINTEGAP() uint32 {
	return volatile.LoadUint32(&o.IPGT.Reg) & 0x7f
}
func (o *ETHERNET_Type) SetIPGT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IPGT.Reg, volatile.LoadUint32(&o.IPGT.Reg)&^(0xffffff80)|value<<7)
}
func (o *ETHERNET_Type) GetIPGT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IPGT.Reg) & 0xffffff80) >> 7
}

// ETHERNET.IPGR: Non Back-to-Back Inter-Packet-Gap register.
func (o *ETHERNET_Type) SetIPGR_NBTOBINTEGAP2(value uint32) {
	volatile.StoreUint32(&o.IPGR.Reg, volatile.LoadUint32(&o.IPGR.Reg)&^(0x7f)|value)
}
func (o *ETHERNET_Type) GetIPGR_NBTOBINTEGAP2() uint32 {
	return volatile.LoadUint32(&o.IPGR.Reg) & 0x7f
}
func (o *ETHERNET_Type) SetIPGR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IPGR.Reg, volatile.LoadUint32(&o.IPGR.Reg)&^(0x80)|value<<7)
}
func (o *ETHERNET_Type) GetIPGR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IPGR.Reg) & 0x80) >> 7
}
func (o *ETHERNET_Type) SetIPGR_NBTOBINTEGAP1(value uint32) {
	volatile.StoreUint32(&o.IPGR.Reg, volatile.LoadUint32(&o.IPGR.Reg)&^(0x7f00)|value<<8)
}
func (o *ETHERNET_Type) GetIPGR_NBTOBINTEGAP1() uint32 {
	return (volatile.LoadUint32(&o.IPGR.Reg) & 0x7f00) >> 8
}
func (o *ETHERNET_Type) SetIPGR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IPGR.Reg, volatile.LoadUint32(&o.IPGR.Reg)&^(0xffff8000)|value<<15)
}
func (o *ETHERNET_Type) GetIPGR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IPGR.Reg) & 0xffff8000) >> 15
}

// ETHERNET.CLRT: Collision window / Retry register.
func (o *ETHERNET_Type) SetCLRT_RETRANSMAX(value uint32) {
	volatile.StoreUint32(&o.CLRT.Reg, volatile.LoadUint32(&o.CLRT.Reg)&^(0xf)|value)
}
func (o *ETHERNET_Type) GetCLRT_RETRANSMAX() uint32 {
	return volatile.LoadUint32(&o.CLRT.Reg) & 0xf
}
func (o *ETHERNET_Type) SetCLRT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CLRT.Reg, volatile.LoadUint32(&o.CLRT.Reg)&^(0xf0)|value<<4)
}
func (o *ETHERNET_Type) GetCLRT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CLRT.Reg) & 0xf0) >> 4
}
func (o *ETHERNET_Type) SetCLRT_COLLWIN(value uint32) {
	volatile.StoreUint32(&o.CLRT.Reg, volatile.LoadUint32(&o.CLRT.Reg)&^(0x3f00)|value<<8)
}
func (o *ETHERNET_Type) GetCLRT_COLLWIN() uint32 {
	return (volatile.LoadUint32(&o.CLRT.Reg) & 0x3f00) >> 8
}
func (o *ETHERNET_Type) SetCLRT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CLRT.Reg, volatile.LoadUint32(&o.CLRT.Reg)&^(0xffffc000)|value<<14)
}
func (o *ETHERNET_Type) GetCLRT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CLRT.Reg) & 0xffffc000) >> 14
}

// ETHERNET.MAXF: Maximum Frame register.
func (o *ETHERNET_Type) SetMAXF_MAXFLEN(value uint32) {
	volatile.StoreUint32(&o.MAXF.Reg, volatile.LoadUint32(&o.MAXF.Reg)&^(0xffff)|value)
}
func (o *ETHERNET_Type) GetMAXF_MAXFLEN() uint32 {
	return volatile.LoadUint32(&o.MAXF.Reg) & 0xffff
}
func (o *ETHERNET_Type) SetMAXF_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MAXF.Reg, volatile.LoadUint32(&o.MAXF.Reg)&^(0xffff0000)|value<<16)
}
func (o *ETHERNET_Type) GetMAXF_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MAXF.Reg) & 0xffff0000) >> 16
}

// ETHERNET.SUPP: PHY Support register.
func (o *ETHERNET_Type) SetSUPP_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SUPP.Reg, volatile.LoadUint32(&o.SUPP.Reg)&^(0xff)|value)
}
func (o *ETHERNET_Type) GetSUPP_RESERVED() uint32 {
	return volatile.LoadUint32(&o.SUPP.Reg) & 0xff
}
func (o *ETHERNET_Type) SetSUPP_SPEED(value uint32) {
	volatile.StoreUint32(&o.SUPP.Reg, volatile.LoadUint32(&o.SUPP.Reg)&^(0x100)|value<<8)
}
func (o *ETHERNET_Type) GetSUPP_SPEED() uint32 {
	return (volatile.LoadUint32(&o.SUPP.Reg) & 0x100) >> 8
}
func (o *ETHERNET_Type) SetSUPP_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SUPP.Reg, volatile.LoadUint32(&o.SUPP.Reg)&^(0xfffffe00)|value<<9)
}
func (o *ETHERNET_Type) GetSUPP_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SUPP.Reg) & 0xfffffe00) >> 9
}

// ETHERNET.TEST: Test register.
func (o *ETHERNET_Type) SetTEST_SCPQ(value uint32) {
	volatile.StoreUint32(&o.TEST.Reg, volatile.LoadUint32(&o.TEST.Reg)&^(0x1)|value)
}
func (o *ETHERNET_Type) GetTEST_SCPQ() uint32 {
	return volatile.LoadUint32(&o.TEST.Reg) & 0x1
}
func (o *ETHERNET_Type) SetTEST_TESTPAUSE(value uint32) {
	volatile.StoreUint32(&o.TEST.Reg, volatile.LoadUint32(&o.TEST.Reg)&^(0x2)|value<<1)
}
func (o *ETHERNET_Type) GetTEST_TESTPAUSE() uint32 {
	return (volatile.LoadUint32(&o.TEST.Reg) & 0x2) >> 1
}
func (o *ETHERNET_Type) SetTEST_TESTBP(value uint32) {
	volatile.StoreUint32(&o.TEST.Reg, volatile.LoadUint32(&o.TEST.Reg)&^(0x4)|value<<2)
}
func (o *ETHERNET_Type) GetTEST_TESTBP() uint32 {
	return (volatile.LoadUint32(&o.TEST.Reg) & 0x4) >> 2
}
func (o *ETHERNET_Type) SetTEST_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TEST.Reg, volatile.LoadUint32(&o.TEST.Reg)&^(0xfffffff8)|value<<3)
}
func (o *ETHERNET_Type) GetTEST_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TEST.Reg) & 0xfffffff8) >> 3
}

// ETHERNET.MCFG: MII Mgmt Configuration register.
func (o *ETHERNET_Type) SetMCFG_SCANINC(value uint32) {
	volatile.StoreUint32(&o.MCFG.Reg, volatile.LoadUint32(&o.MCFG.Reg)&^(0x1)|value)
}
func (o *ETHERNET_Type) GetMCFG_SCANINC() uint32 {
	return volatile.LoadUint32(&o.MCFG.Reg) & 0x1
}
func (o *ETHERNET_Type) SetMCFG_SUPPPREAMBLE(value uint32) {
	volatile.StoreUint32(&o.MCFG.Reg, volatile.LoadUint32(&o.MCFG.Reg)&^(0x2)|value<<1)
}
func (o *ETHERNET_Type) GetMCFG_SUPPPREAMBLE() uint32 {
	return (volatile.LoadUint32(&o.MCFG.Reg) & 0x2) >> 1
}
func (o *ETHERNET_Type) SetMCFG_CLOCKSEL(value uint32) {
	volatile.StoreUint32(&o.MCFG.Reg, volatile.LoadUint32(&o.MCFG.Reg)&^(0x3c)|value<<2)
}
func (o *ETHERNET_Type) GetMCFG_CLOCKSEL() uint32 {
	return (volatile.LoadUint32(&o.MCFG.Reg) & 0x3c) >> 2
}
func (o *ETHERNET_Type) SetMCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MCFG.Reg, volatile.LoadUint32(&o.MCFG.Reg)&^(0x7fc0)|value<<6)
}
func (o *ETHERNET_Type) GetMCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MCFG.Reg) & 0x7fc0) >> 6
}
func (o *ETHERNET_Type) SetMCFG_RESETMIIMGMT(value uint32) {
	volatile.StoreUint32(&o.MCFG.Reg, volatile.LoadUint32(&o.MCFG.Reg)&^(0x8000)|value<<15)
}
func (o *ETHERNET_Type) GetMCFG_RESETMIIMGMT() uint32 {
	return (volatile.LoadUint32(&o.MCFG.Reg) & 0x8000) >> 15
}
func (o *ETHERNET_Type) SetMCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MCFG.Reg, volatile.LoadUint32(&o.MCFG.Reg)&^(0xffff0000)|value<<16)
}
func (o *ETHERNET_Type) GetMCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MCFG.Reg) & 0xffff0000) >> 16
}

// ETHERNET.MCMD: MII Mgmt Command register.
func (o *ETHERNET_Type) SetMCMD_READ(value uint32) {
	volatile.StoreUint32(&o.MCMD.Reg, volatile.LoadUint32(&o.MCMD.Reg)&^(0x1)|value)
}
func (o *ETHERNET_Type) GetMCMD_READ() uint32 {
	return volatile.LoadUint32(&o.MCMD.Reg) & 0x1
}
func (o *ETHERNET_Type) SetMCMD_SCAN(value uint32) {
	volatile.StoreUint32(&o.MCMD.Reg, volatile.LoadUint32(&o.MCMD.Reg)&^(0x2)|value<<1)
}
func (o *ETHERNET_Type) GetMCMD_SCAN() uint32 {
	return (volatile.LoadUint32(&o.MCMD.Reg) & 0x2) >> 1
}
func (o *ETHERNET_Type) SetMCMD_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MCMD.Reg, volatile.LoadUint32(&o.MCMD.Reg)&^(0xfffffffc)|value<<2)
}
func (o *ETHERNET_Type) GetMCMD_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MCMD.Reg) & 0xfffffffc) >> 2
}

// ETHERNET.MADR: MII Mgmt Address register.
func (o *ETHERNET_Type) SetMADR_REGADDR(value uint32) {
	volatile.StoreUint32(&o.MADR.Reg, volatile.LoadUint32(&o.MADR.Reg)&^(0x1f)|value)
}
func (o *ETHERNET_Type) GetMADR_REGADDR() uint32 {
	return volatile.LoadUint32(&o.MADR.Reg) & 0x1f
}
func (o *ETHERNET_Type) SetMADR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MADR.Reg, volatile.LoadUint32(&o.MADR.Reg)&^(0xe0)|value<<5)
}
func (o *ETHERNET_Type) GetMADR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MADR.Reg) & 0xe0) >> 5
}
func (o *ETHERNET_Type) SetMADR_PHYADDR(value uint32) {
	volatile.StoreUint32(&o.MADR.Reg, volatile.LoadUint32(&o.MADR.Reg)&^(0x1f00)|value<<8)
}
func (o *ETHERNET_Type) GetMADR_PHYADDR() uint32 {
	return (volatile.LoadUint32(&o.MADR.Reg) & 0x1f00) >> 8
}
func (o *ETHERNET_Type) SetMADR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MADR.Reg, volatile.LoadUint32(&o.MADR.Reg)&^(0xffffe000)|value<<13)
}
func (o *ETHERNET_Type) GetMADR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MADR.Reg) & 0xffffe000) >> 13
}

// ETHERNET.MWTD: MII Mgmt Write Data register.
func (o *ETHERNET_Type) SetMWTD_WRITEDATA(value uint32) {
	volatile.StoreUint32(&o.MWTD.Reg, volatile.LoadUint32(&o.MWTD.Reg)&^(0xffff)|value)
}
func (o *ETHERNET_Type) GetMWTD_WRITEDATA() uint32 {
	return volatile.LoadUint32(&o.MWTD.Reg) & 0xffff
}
func (o *ETHERNET_Type) SetMWTD_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MWTD.Reg, volatile.LoadUint32(&o.MWTD.Reg)&^(0xffff0000)|value<<16)
}
func (o *ETHERNET_Type) GetMWTD_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MWTD.Reg) & 0xffff0000) >> 16
}

// ETHERNET.MRDD: MII Mgmt Read Data register.
func (o *ETHERNET_Type) SetMRDD_READDATA(value uint32) {
	volatile.StoreUint32(&o.MRDD.Reg, volatile.LoadUint32(&o.MRDD.Reg)&^(0xffff)|value)
}
func (o *ETHERNET_Type) GetMRDD_READDATA() uint32 {
	return volatile.LoadUint32(&o.MRDD.Reg) & 0xffff
}
func (o *ETHERNET_Type) SetMRDD_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MRDD.Reg, volatile.LoadUint32(&o.MRDD.Reg)&^(0xffff0000)|value<<16)
}
func (o *ETHERNET_Type) GetMRDD_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MRDD.Reg) & 0xffff0000) >> 16
}

// ETHERNET.MIND: MII Mgmt Indicators register.
func (o *ETHERNET_Type) SetMIND_BUSY(value uint32) {
	volatile.StoreUint32(&o.MIND.Reg, volatile.LoadUint32(&o.MIND.Reg)&^(0x1)|value)
}
func (o *ETHERNET_Type) GetMIND_BUSY() uint32 {
	return volatile.LoadUint32(&o.MIND.Reg) & 0x1
}
func (o *ETHERNET_Type) SetMIND_SCANNING(value uint32) {
	volatile.StoreUint32(&o.MIND.Reg, volatile.LoadUint32(&o.MIND.Reg)&^(0x2)|value<<1)
}
func (o *ETHERNET_Type) GetMIND_SCANNING() uint32 {
	return (volatile.LoadUint32(&o.MIND.Reg) & 0x2) >> 1
}
func (o *ETHERNET_Type) SetMIND_NOTVALID(value uint32) {
	volatile.StoreUint32(&o.MIND.Reg, volatile.LoadUint32(&o.MIND.Reg)&^(0x4)|value<<2)
}
func (o *ETHERNET_Type) GetMIND_NOTVALID() uint32 {
	return (volatile.LoadUint32(&o.MIND.Reg) & 0x4) >> 2
}
func (o *ETHERNET_Type) SetMIND_MIILINKFAIL(value uint32) {
	volatile.StoreUint32(&o.MIND.Reg, volatile.LoadUint32(&o.MIND.Reg)&^(0x8)|value<<3)
}
func (o *ETHERNET_Type) GetMIND_MIILINKFAIL() uint32 {
	return (volatile.LoadUint32(&o.MIND.Reg) & 0x8) >> 3
}
func (o *ETHERNET_Type) SetMIND_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MIND.Reg, volatile.LoadUint32(&o.MIND.Reg)&^(0xfffffff0)|value<<4)
}
func (o *ETHERNET_Type) GetMIND_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MIND.Reg) & 0xfffffff0) >> 4
}

// ETHERNET.SA0: Station Address 0 register.
func (o *ETHERNET_Type) SetSA0_SADDR2(value uint32) {
	volatile.StoreUint32(&o.SA0.Reg, volatile.LoadUint32(&o.SA0.Reg)&^(0xff)|value)
}
func (o *ETHERNET_Type) GetSA0_SADDR2() uint32 {
	return volatile.LoadUint32(&o.SA0.Reg) & 0xff
}
func (o *ETHERNET_Type) SetSA0_SADDR1(value uint32) {
	volatile.StoreUint32(&o.SA0.Reg, volatile.LoadUint32(&o.SA0.Reg)&^(0xff00)|value<<8)
}
func (o *ETHERNET_Type) GetSA0_SADDR1() uint32 {
	return (volatile.LoadUint32(&o.SA0.Reg) & 0xff00) >> 8
}
func (o *ETHERNET_Type) SetSA0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SA0.Reg, volatile.LoadUint32(&o.SA0.Reg)&^(0xffff0000)|value<<16)
}
func (o *ETHERNET_Type) GetSA0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SA0.Reg) & 0xffff0000) >> 16
}

// ETHERNET.SA1: Station Address 1 register.
func (o *ETHERNET_Type) SetSA1_SADDR4(value uint32) {
	volatile.StoreUint32(&o.SA1.Reg, volatile.LoadUint32(&o.SA1.Reg)&^(0xff)|value)
}
func (o *ETHERNET_Type) GetSA1_SADDR4() uint32 {
	return volatile.LoadUint32(&o.SA1.Reg) & 0xff
}
func (o *ETHERNET_Type) SetSA1_SADDR3(value uint32) {
	volatile.StoreUint32(&o.SA1.Reg, volatile.LoadUint32(&o.SA1.Reg)&^(0xff00)|value<<8)
}
func (o *ETHERNET_Type) GetSA1_SADDR3() uint32 {
	return (volatile.LoadUint32(&o.SA1.Reg) & 0xff00) >> 8
}
func (o *ETHERNET_Type) SetSA1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SA1.Reg, volatile.LoadUint32(&o.SA1.Reg)&^(0xffff0000)|value<<16)
}
func (o *ETHERNET_Type) GetSA1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SA1.Reg) & 0xffff0000) >> 16
}

// ETHERNET.SA2: Station Address 2 register.
func (o *ETHERNET_Type) SetSA2_SADDR6(value uint32) {
	volatile.StoreUint32(&o.SA2.Reg, volatile.LoadUint32(&o.SA2.Reg)&^(0xff)|value)
}
func (o *ETHERNET_Type) GetSA2_SADDR6() uint32 {
	return volatile.LoadUint32(&o.SA2.Reg) & 0xff
}
func (o *ETHERNET_Type) SetSA2_SADDR5(value uint32) {
	volatile.StoreUint32(&o.SA2.Reg, volatile.LoadUint32(&o.SA2.Reg)&^(0xff00)|value<<8)
}
func (o *ETHERNET_Type) GetSA2_SADDR5() uint32 {
	return (volatile.LoadUint32(&o.SA2.Reg) & 0xff00) >> 8
}
func (o *ETHERNET_Type) SetSA2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SA2.Reg, volatile.LoadUint32(&o.SA2.Reg)&^(0xffff0000)|value<<16)
}
func (o *ETHERNET_Type) GetSA2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SA2.Reg) & 0xffff0000) >> 16
}

// ETHERNET.COMMAND: Command register.
func (o *ETHERNET_Type) SetCOMMAND_RXENABLE(value uint32) {
	volatile.StoreUint32(&o.COMMAND.Reg, volatile.LoadUint32(&o.COMMAND.Reg)&^(0x1)|value)
}
func (o *ETHERNET_Type) GetCOMMAND_RXENABLE() uint32 {
	return volatile.LoadUint32(&o.COMMAND.Reg) & 0x1
}
func (o *ETHERNET_Type) SetCOMMAND_TXENABLE(value uint32) {
	volatile.StoreUint32(&o.COMMAND.Reg, volatile.LoadUint32(&o.COMMAND.Reg)&^(0x2)|value<<1)
}
func (o *ETHERNET_Type) GetCOMMAND_TXENABLE() uint32 {
	return (volatile.LoadUint32(&o.COMMAND.Reg) & 0x2) >> 1
}
func (o *ETHERNET_Type) SetCOMMAND_RESERVED(value uint32) {
	volatile.StoreUint32(&o.COMMAND.Reg, volatile.LoadUint32(&o.COMMAND.Reg)&^(0x4)|value<<2)
}
func (o *ETHERNET_Type) GetCOMMAND_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.COMMAND.Reg) & 0x4) >> 2
}
func (o *ETHERNET_Type) SetCOMMAND_REGRESET(value uint32) {
	volatile.StoreUint32(&o.COMMAND.Reg, volatile.LoadUint32(&o.COMMAND.Reg)&^(0x8)|value<<3)
}
func (o *ETHERNET_Type) GetCOMMAND_REGRESET() uint32 {
	return (volatile.LoadUint32(&o.COMMAND.Reg) & 0x8) >> 3
}
func (o *ETHERNET_Type) SetCOMMAND_TXRESET(value uint32) {
	volatile.StoreUint32(&o.COMMAND.Reg, volatile.LoadUint32(&o.COMMAND.Reg)&^(0x10)|value<<4)
}
func (o *ETHERNET_Type) GetCOMMAND_TXRESET() uint32 {
	return (volatile.LoadUint32(&o.COMMAND.Reg) & 0x10) >> 4
}
func (o *ETHERNET_Type) SetCOMMAND_RXRESET(value uint32) {
	volatile.StoreUint32(&o.COMMAND.Reg, volatile.LoadUint32(&o.COMMAND.Reg)&^(0x20)|value<<5)
}
func (o *ETHERNET_Type) GetCOMMAND_RXRESET() uint32 {
	return (volatile.LoadUint32(&o.COMMAND.Reg) & 0x20) >> 5
}
func (o *ETHERNET_Type) SetCOMMAND_PASSRUNTFRAME(value uint32) {
	volatile.StoreUint32(&o.COMMAND.Reg, volatile.LoadUint32(&o.COMMAND.Reg)&^(0x40)|value<<6)
}
func (o *ETHERNET_Type) GetCOMMAND_PASSRUNTFRAME() uint32 {
	return (volatile.LoadUint32(&o.COMMAND.Reg) & 0x40) >> 6
}
func (o *ETHERNET_Type) SetCOMMAND_PASSRXFILTER(value uint32) {
	volatile.StoreUint32(&o.COMMAND.Reg, volatile.LoadUint32(&o.COMMAND.Reg)&^(0x80)|value<<7)
}
func (o *ETHERNET_Type) GetCOMMAND_PASSRXFILTER() uint32 {
	return (volatile.LoadUint32(&o.COMMAND.Reg) & 0x80) >> 7
}
func (o *ETHERNET_Type) SetCOMMAND_TXFLOWCONTROL(value uint32) {
	volatile.StoreUint32(&o.COMMAND.Reg, volatile.LoadUint32(&o.COMMAND.Reg)&^(0x100)|value<<8)
}
func (o *ETHERNET_Type) GetCOMMAND_TXFLOWCONTROL() uint32 {
	return (volatile.LoadUint32(&o.COMMAND.Reg) & 0x100) >> 8
}
func (o *ETHERNET_Type) SetCOMMAND_RMII(value uint32) {
	volatile.StoreUint32(&o.COMMAND.Reg, volatile.LoadUint32(&o.COMMAND.Reg)&^(0x200)|value<<9)
}
func (o *ETHERNET_Type) GetCOMMAND_RMII() uint32 {
	return (volatile.LoadUint32(&o.COMMAND.Reg) & 0x200) >> 9
}
func (o *ETHERNET_Type) SetCOMMAND_FULLDUPLEX(value uint32) {
	volatile.StoreUint32(&o.COMMAND.Reg, volatile.LoadUint32(&o.COMMAND.Reg)&^(0x400)|value<<10)
}
func (o *ETHERNET_Type) GetCOMMAND_FULLDUPLEX() uint32 {
	return (volatile.LoadUint32(&o.COMMAND.Reg) & 0x400) >> 10
}
func (o *ETHERNET_Type) SetCOMMAND_RESERVED(value uint32) {
	volatile.StoreUint32(&o.COMMAND.Reg, volatile.LoadUint32(&o.COMMAND.Reg)&^(0xfffff800)|value<<11)
}
func (o *ETHERNET_Type) GetCOMMAND_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.COMMAND.Reg) & 0xfffff800) >> 11
}

// ETHERNET.STATUS: Status register.
func (o *ETHERNET_Type) SetSTATUS_RXSTATUS(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x1)|value)
}
func (o *ETHERNET_Type) GetSTATUS_RXSTATUS() uint32 {
	return volatile.LoadUint32(&o.STATUS.Reg) & 0x1
}
func (o *ETHERNET_Type) SetSTATUS_TXSTATUS(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x2)|value<<1)
}
func (o *ETHERNET_Type) GetSTATUS_TXSTATUS() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x2) >> 1
}
func (o *ETHERNET_Type) SetSTATUS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0xfffffffc)|value<<2)
}
func (o *ETHERNET_Type) GetSTATUS_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0xfffffffc) >> 2
}

// ETHERNET.RXDESCRIPTOR: Receive descriptor base address register.
func (o *ETHERNET_Type) SetRXDESCRIPTOR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RXDESCRIPTOR.Reg, volatile.LoadUint32(&o.RXDESCRIPTOR.Reg)&^(0x3)|value)
}
func (o *ETHERNET_Type) GetRXDESCRIPTOR_RESERVED() uint32 {
	return volatile.LoadUint32(&o.RXDESCRIPTOR.Reg) & 0x3
}
func (o *ETHERNET_Type) SetRXDESCRIPTOR(value uint32) {
	volatile.StoreUint32(&o.RXDESCRIPTOR.Reg, volatile.LoadUint32(&o.RXDESCRIPTOR.Reg)&^(0xfffffffc)|value<<2)
}
func (o *ETHERNET_Type) GetRXDESCRIPTOR() uint32 {
	return (volatile.LoadUint32(&o.RXDESCRIPTOR.Reg) & 0xfffffffc) >> 2
}

// ETHERNET.RXSTATUS: Receive status base address register.
func (o *ETHERNET_Type) SetRXSTATUS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RXSTATUS.Reg, volatile.LoadUint32(&o.RXSTATUS.Reg)&^(0x7)|value)
}
func (o *ETHERNET_Type) GetRXSTATUS_RESERVED() uint32 {
	return volatile.LoadUint32(&o.RXSTATUS.Reg) & 0x7
}
func (o *ETHERNET_Type) SetRXSTATUS(value uint32) {
	volatile.StoreUint32(&o.RXSTATUS.Reg, volatile.LoadUint32(&o.RXSTATUS.Reg)&^(0xfffffff8)|value<<3)
}
func (o *ETHERNET_Type) GetRXSTATUS() uint32 {
	return (volatile.LoadUint32(&o.RXSTATUS.Reg) & 0xfffffff8) >> 3
}

// ETHERNET.RXDESCRIPTORNUMBER: Receive number of descriptors register.
func (o *ETHERNET_Type) SetRXDESCRIPTORNUMBER_RXDESCRIPTORN(value uint32) {
	volatile.StoreUint32(&o.RXDESCRIPTORNUMBER.Reg, volatile.LoadUint32(&o.RXDESCRIPTORNUMBER.Reg)&^(0xffff)|value)
}
func (o *ETHERNET_Type) GetRXDESCRIPTORNUMBER_RXDESCRIPTORN() uint32 {
	return volatile.LoadUint32(&o.RXDESCRIPTORNUMBER.Reg) & 0xffff
}
func (o *ETHERNET_Type) SetRXDESCRIPTORNUMBER_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RXDESCRIPTORNUMBER.Reg, volatile.LoadUint32(&o.RXDESCRIPTORNUMBER.Reg)&^(0xffff0000)|value<<16)
}
func (o *ETHERNET_Type) GetRXDESCRIPTORNUMBER_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RXDESCRIPTORNUMBER.Reg) & 0xffff0000) >> 16
}

// ETHERNET.RXPRODUCEINDEX: Receive produce index register.
func (o *ETHERNET_Type) SetRXPRODUCEINDEX_RXPRODUCEIX(value uint32) {
	volatile.StoreUint32(&o.RXPRODUCEINDEX.Reg, volatile.LoadUint32(&o.RXPRODUCEINDEX.Reg)&^(0xffff)|value)
}
func (o *ETHERNET_Type) GetRXPRODUCEINDEX_RXPRODUCEIX() uint32 {
	return volatile.LoadUint32(&o.RXPRODUCEINDEX.Reg) & 0xffff
}
func (o *ETHERNET_Type) SetRXPRODUCEINDEX_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RXPRODUCEINDEX.Reg, volatile.LoadUint32(&o.RXPRODUCEINDEX.Reg)&^(0xffff0000)|value<<16)
}
func (o *ETHERNET_Type) GetRXPRODUCEINDEX_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RXPRODUCEINDEX.Reg) & 0xffff0000) >> 16
}

// ETHERNET.RXCONSUMEINDEX: Receive consume index register.
func (o *ETHERNET_Type) SetRXCONSUMEINDEX_RXCONSUMEIX(value uint32) {
	volatile.StoreUint32(&o.RXCONSUMEINDEX.Reg, volatile.LoadUint32(&o.RXCONSUMEINDEX.Reg)&^(0xffff)|value)
}
func (o *ETHERNET_Type) GetRXCONSUMEINDEX_RXCONSUMEIX() uint32 {
	return volatile.LoadUint32(&o.RXCONSUMEINDEX.Reg) & 0xffff
}
func (o *ETHERNET_Type) SetRXCONSUMEINDEX_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RXCONSUMEINDEX.Reg, volatile.LoadUint32(&o.RXCONSUMEINDEX.Reg)&^(0xffff0000)|value<<16)
}
func (o *ETHERNET_Type) GetRXCONSUMEINDEX_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RXCONSUMEINDEX.Reg) & 0xffff0000) >> 16
}

// ETHERNET.TXDESCRIPTOR: Transmit descriptor base address register.
func (o *ETHERNET_Type) SetTXDESCRIPTOR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TXDESCRIPTOR.Reg, volatile.LoadUint32(&o.TXDESCRIPTOR.Reg)&^(0x3)|value)
}
func (o *ETHERNET_Type) GetTXDESCRIPTOR_RESERVED() uint32 {
	return volatile.LoadUint32(&o.TXDESCRIPTOR.Reg) & 0x3
}
func (o *ETHERNET_Type) SetTXDESCRIPTOR_TXD(value uint32) {
	volatile.StoreUint32(&o.TXDESCRIPTOR.Reg, volatile.LoadUint32(&o.TXDESCRIPTOR.Reg)&^(0xfffffffc)|value<<2)
}
func (o *ETHERNET_Type) GetTXDESCRIPTOR_TXD() uint32 {
	return (volatile.LoadUint32(&o.TXDESCRIPTOR.Reg) & 0xfffffffc) >> 2
}

// ETHERNET.TXSTATUS: Transmit status base address register.
func (o *ETHERNET_Type) SetTXSTATUS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TXSTATUS.Reg, volatile.LoadUint32(&o.TXSTATUS.Reg)&^(0x3)|value)
}
func (o *ETHERNET_Type) GetTXSTATUS_RESERVED() uint32 {
	return volatile.LoadUint32(&o.TXSTATUS.Reg) & 0x3
}
func (o *ETHERNET_Type) SetTXSTATUS_TXSTAT(value uint32) {
	volatile.StoreUint32(&o.TXSTATUS.Reg, volatile.LoadUint32(&o.TXSTATUS.Reg)&^(0xfffffffc)|value<<2)
}
func (o *ETHERNET_Type) GetTXSTATUS_TXSTAT() uint32 {
	return (volatile.LoadUint32(&o.TXSTATUS.Reg) & 0xfffffffc) >> 2
}

// ETHERNET.TXDESCRIPTORNUMBER: Transmit number of descriptors register.
func (o *ETHERNET_Type) SetTXDESCRIPTORNUMBER_TXDN(value uint32) {
	volatile.StoreUint32(&o.TXDESCRIPTORNUMBER.Reg, volatile.LoadUint32(&o.TXDESCRIPTORNUMBER.Reg)&^(0xffff)|value)
}
func (o *ETHERNET_Type) GetTXDESCRIPTORNUMBER_TXDN() uint32 {
	return volatile.LoadUint32(&o.TXDESCRIPTORNUMBER.Reg) & 0xffff
}
func (o *ETHERNET_Type) SetTXDESCRIPTORNUMBER_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TXDESCRIPTORNUMBER.Reg, volatile.LoadUint32(&o.TXDESCRIPTORNUMBER.Reg)&^(0xffff0000)|value<<16)
}
func (o *ETHERNET_Type) GetTXDESCRIPTORNUMBER_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TXDESCRIPTORNUMBER.Reg) & 0xffff0000) >> 16
}

// ETHERNET.TXPRODUCEINDEX: Transmit produce index register.
func (o *ETHERNET_Type) SetTXPRODUCEINDEX_TXPI(value uint32) {
	volatile.StoreUint32(&o.TXPRODUCEINDEX.Reg, volatile.LoadUint32(&o.TXPRODUCEINDEX.Reg)&^(0xffff)|value)
}
func (o *ETHERNET_Type) GetTXPRODUCEINDEX_TXPI() uint32 {
	return volatile.LoadUint32(&o.TXPRODUCEINDEX.Reg) & 0xffff
}
func (o *ETHERNET_Type) SetTXPRODUCEINDEX_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TXPRODUCEINDEX.Reg, volatile.LoadUint32(&o.TXPRODUCEINDEX.Reg)&^(0xffff0000)|value<<16)
}
func (o *ETHERNET_Type) GetTXPRODUCEINDEX_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TXPRODUCEINDEX.Reg) & 0xffff0000) >> 16
}

// ETHERNET.TXCONSUMEINDEX: Transmit consume index register.
func (o *ETHERNET_Type) SetTXCONSUMEINDEX_TXCI(value uint32) {
	volatile.StoreUint32(&o.TXCONSUMEINDEX.Reg, volatile.LoadUint32(&o.TXCONSUMEINDEX.Reg)&^(0xffff)|value)
}
func (o *ETHERNET_Type) GetTXCONSUMEINDEX_TXCI() uint32 {
	return volatile.LoadUint32(&o.TXCONSUMEINDEX.Reg) & 0xffff
}
func (o *ETHERNET_Type) SetTXCONSUMEINDEX_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TXCONSUMEINDEX.Reg, volatile.LoadUint32(&o.TXCONSUMEINDEX.Reg)&^(0xffff0000)|value<<16)
}
func (o *ETHERNET_Type) GetTXCONSUMEINDEX_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TXCONSUMEINDEX.Reg) & 0xffff0000) >> 16
}

// ETHERNET.TSV0: Transmit status vector 0 register.
func (o *ETHERNET_Type) SetTSV0_CRCERR(value uint32) {
	volatile.StoreUint32(&o.TSV0.Reg, volatile.LoadUint32(&o.TSV0.Reg)&^(0x1)|value)
}
func (o *ETHERNET_Type) GetTSV0_CRCERR() uint32 {
	return volatile.LoadUint32(&o.TSV0.Reg) & 0x1
}
func (o *ETHERNET_Type) SetTSV0_LCE(value uint32) {
	volatile.StoreUint32(&o.TSV0.Reg, volatile.LoadUint32(&o.TSV0.Reg)&^(0x2)|value<<1)
}
func (o *ETHERNET_Type) GetTSV0_LCE() uint32 {
	return (volatile.LoadUint32(&o.TSV0.Reg) & 0x2) >> 1
}
func (o *ETHERNET_Type) SetTSV0_LOR(value uint32) {
	volatile.StoreUint32(&o.TSV0.Reg, volatile.LoadUint32(&o.TSV0.Reg)&^(0x4)|value<<2)
}
func (o *ETHERNET_Type) GetTSV0_LOR() uint32 {
	return (volatile.LoadUint32(&o.TSV0.Reg) & 0x4) >> 2
}
func (o *ETHERNET_Type) SetTSV0_DONE(value uint32) {
	volatile.StoreUint32(&o.TSV0.Reg, volatile.LoadUint32(&o.TSV0.Reg)&^(0x8)|value<<3)
}
func (o *ETHERNET_Type) GetTSV0_DONE() uint32 {
	return (volatile.LoadUint32(&o.TSV0.Reg) & 0x8) >> 3
}
func (o *ETHERNET_Type) SetTSV0_MULTICAST(value uint32) {
	volatile.StoreUint32(&o.TSV0.Reg, volatile.LoadUint32(&o.TSV0.Reg)&^(0x10)|value<<4)
}
func (o *ETHERNET_Type) GetTSV0_MULTICAST() uint32 {
	return (volatile.LoadUint32(&o.TSV0.Reg) & 0x10) >> 4
}
func (o *ETHERNET_Type) SetTSV0_BROADCAST(value uint32) {
	volatile.StoreUint32(&o.TSV0.Reg, volatile.LoadUint32(&o.TSV0.Reg)&^(0x20)|value<<5)
}
func (o *ETHERNET_Type) GetTSV0_BROADCAST() uint32 {
	return (volatile.LoadUint32(&o.TSV0.Reg) & 0x20) >> 5
}
func (o *ETHERNET_Type) SetTSV0_PACKETDEFER(value uint32) {
	volatile.StoreUint32(&o.TSV0.Reg, volatile.LoadUint32(&o.TSV0.Reg)&^(0x40)|value<<6)
}
func (o *ETHERNET_Type) GetTSV0_PACKETDEFER() uint32 {
	return (volatile.LoadUint32(&o.TSV0.Reg) & 0x40) >> 6
}
func (o *ETHERNET_Type) SetTSV0_EXDF(value uint32) {
	volatile.StoreUint32(&o.TSV0.Reg, volatile.LoadUint32(&o.TSV0.Reg)&^(0x80)|value<<7)
}
func (o *ETHERNET_Type) GetTSV0_EXDF() uint32 {
	return (volatile.LoadUint32(&o.TSV0.Reg) & 0x80) >> 7
}
func (o *ETHERNET_Type) SetTSV0_EXCOL(value uint32) {
	volatile.StoreUint32(&o.TSV0.Reg, volatile.LoadUint32(&o.TSV0.Reg)&^(0x100)|value<<8)
}
func (o *ETHERNET_Type) GetTSV0_EXCOL() uint32 {
	return (volatile.LoadUint32(&o.TSV0.Reg) & 0x100) >> 8
}
func (o *ETHERNET_Type) SetTSV0_LCOL(value uint32) {
	volatile.StoreUint32(&o.TSV0.Reg, volatile.LoadUint32(&o.TSV0.Reg)&^(0x200)|value<<9)
}
func (o *ETHERNET_Type) GetTSV0_LCOL() uint32 {
	return (volatile.LoadUint32(&o.TSV0.Reg) & 0x200) >> 9
}
func (o *ETHERNET_Type) SetTSV0_GIANT(value uint32) {
	volatile.StoreUint32(&o.TSV0.Reg, volatile.LoadUint32(&o.TSV0.Reg)&^(0x400)|value<<10)
}
func (o *ETHERNET_Type) GetTSV0_GIANT() uint32 {
	return (volatile.LoadUint32(&o.TSV0.Reg) & 0x400) >> 10
}
func (o *ETHERNET_Type) SetTSV0_UNDERRUN(value uint32) {
	volatile.StoreUint32(&o.TSV0.Reg, volatile.LoadUint32(&o.TSV0.Reg)&^(0x800)|value<<11)
}
func (o *ETHERNET_Type) GetTSV0_UNDERRUN() uint32 {
	return (volatile.LoadUint32(&o.TSV0.Reg) & 0x800) >> 11
}
func (o *ETHERNET_Type) SetTSV0_TOTALBYTES(value uint32) {
	volatile.StoreUint32(&o.TSV0.Reg, volatile.LoadUint32(&o.TSV0.Reg)&^(0xffff000)|value<<12)
}
func (o *ETHERNET_Type) GetTSV0_TOTALBYTES() uint32 {
	return (volatile.LoadUint32(&o.TSV0.Reg) & 0xffff000) >> 12
}
func (o *ETHERNET_Type) SetTSV0_CONTROLFRAME(value uint32) {
	volatile.StoreUint32(&o.TSV0.Reg, volatile.LoadUint32(&o.TSV0.Reg)&^(0x10000000)|value<<28)
}
func (o *ETHERNET_Type) GetTSV0_CONTROLFRAME() uint32 {
	return (volatile.LoadUint32(&o.TSV0.Reg) & 0x10000000) >> 28
}
func (o *ETHERNET_Type) SetTSV0_PAUSE(value uint32) {
	volatile.StoreUint32(&o.TSV0.Reg, volatile.LoadUint32(&o.TSV0.Reg)&^(0x20000000)|value<<29)
}
func (o *ETHERNET_Type) GetTSV0_PAUSE() uint32 {
	return (volatile.LoadUint32(&o.TSV0.Reg) & 0x20000000) >> 29
}
func (o *ETHERNET_Type) SetTSV0_BACKPRESSURE(value uint32) {
	volatile.StoreUint32(&o.TSV0.Reg, volatile.LoadUint32(&o.TSV0.Reg)&^(0x40000000)|value<<30)
}
func (o *ETHERNET_Type) GetTSV0_BACKPRESSURE() uint32 {
	return (volatile.LoadUint32(&o.TSV0.Reg) & 0x40000000) >> 30
}
func (o *ETHERNET_Type) SetTSV0_VLAN(value uint32) {
	volatile.StoreUint32(&o.TSV0.Reg, volatile.LoadUint32(&o.TSV0.Reg)&^(0x80000000)|value<<31)
}
func (o *ETHERNET_Type) GetTSV0_VLAN() uint32 {
	return (volatile.LoadUint32(&o.TSV0.Reg) & 0x80000000) >> 31
}

// ETHERNET.TSV1: Transmit status vector 1 register.
func (o *ETHERNET_Type) SetTSV1_TBC(value uint32) {
	volatile.StoreUint32(&o.TSV1.Reg, volatile.LoadUint32(&o.TSV1.Reg)&^(0xffff)|value)
}
func (o *ETHERNET_Type) GetTSV1_TBC() uint32 {
	return volatile.LoadUint32(&o.TSV1.Reg) & 0xffff
}
func (o *ETHERNET_Type) SetTSV1_TCC(value uint32) {
	volatile.StoreUint32(&o.TSV1.Reg, volatile.LoadUint32(&o.TSV1.Reg)&^(0xf0000)|value<<16)
}
func (o *ETHERNET_Type) GetTSV1_TCC() uint32 {
	return (volatile.LoadUint32(&o.TSV1.Reg) & 0xf0000) >> 16
}
func (o *ETHERNET_Type) SetTSV1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TSV1.Reg, volatile.LoadUint32(&o.TSV1.Reg)&^(0xfff00000)|value<<20)
}
func (o *ETHERNET_Type) GetTSV1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TSV1.Reg) & 0xfff00000) >> 20
}

// ETHERNET.RSV: Receive status vector register.
func (o *ETHERNET_Type) SetRSV_RBC(value uint32) {
	volatile.StoreUint32(&o.RSV.Reg, volatile.LoadUint32(&o.RSV.Reg)&^(0xffff)|value)
}
func (o *ETHERNET_Type) GetRSV_RBC() uint32 {
	return volatile.LoadUint32(&o.RSV.Reg) & 0xffff
}
func (o *ETHERNET_Type) SetRSV_PPI(value uint32) {
	volatile.StoreUint32(&o.RSV.Reg, volatile.LoadUint32(&o.RSV.Reg)&^(0x10000)|value<<16)
}
func (o *ETHERNET_Type) GetRSV_PPI() uint32 {
	return (volatile.LoadUint32(&o.RSV.Reg) & 0x10000) >> 16
}
func (o *ETHERNET_Type) SetRSV_RXDVSEEN(value uint32) {
	volatile.StoreUint32(&o.RSV.Reg, volatile.LoadUint32(&o.RSV.Reg)&^(0x20000)|value<<17)
}
func (o *ETHERNET_Type) GetRSV_RXDVSEEN() uint32 {
	return (volatile.LoadUint32(&o.RSV.Reg) & 0x20000) >> 17
}
func (o *ETHERNET_Type) SetRSV_CESEEN(value uint32) {
	volatile.StoreUint32(&o.RSV.Reg, volatile.LoadUint32(&o.RSV.Reg)&^(0x40000)|value<<18)
}
func (o *ETHERNET_Type) GetRSV_CESEEN() uint32 {
	return (volatile.LoadUint32(&o.RSV.Reg) & 0x40000) >> 18
}
func (o *ETHERNET_Type) SetRSV_RCV(value uint32) {
	volatile.StoreUint32(&o.RSV.Reg, volatile.LoadUint32(&o.RSV.Reg)&^(0x80000)|value<<19)
}
func (o *ETHERNET_Type) GetRSV_RCV() uint32 {
	return (volatile.LoadUint32(&o.RSV.Reg) & 0x80000) >> 19
}
func (o *ETHERNET_Type) SetRSV_CRCERR(value uint32) {
	volatile.StoreUint32(&o.RSV.Reg, volatile.LoadUint32(&o.RSV.Reg)&^(0x100000)|value<<20)
}
func (o *ETHERNET_Type) GetRSV_CRCERR() uint32 {
	return (volatile.LoadUint32(&o.RSV.Reg) & 0x100000) >> 20
}
func (o *ETHERNET_Type) SetRSV_LCERR(value uint32) {
	volatile.StoreUint32(&o.RSV.Reg, volatile.LoadUint32(&o.RSV.Reg)&^(0x200000)|value<<21)
}
func (o *ETHERNET_Type) GetRSV_LCERR() uint32 {
	return (volatile.LoadUint32(&o.RSV.Reg) & 0x200000) >> 21
}
func (o *ETHERNET_Type) SetRSV_LOR(value uint32) {
	volatile.StoreUint32(&o.RSV.Reg, volatile.LoadUint32(&o.RSV.Reg)&^(0x400000)|value<<22)
}
func (o *ETHERNET_Type) GetRSV_LOR() uint32 {
	return (volatile.LoadUint32(&o.RSV.Reg) & 0x400000) >> 22
}
func (o *ETHERNET_Type) SetRSV_ROK(value uint32) {
	volatile.StoreUint32(&o.RSV.Reg, volatile.LoadUint32(&o.RSV.Reg)&^(0x800000)|value<<23)
}
func (o *ETHERNET_Type) GetRSV_ROK() uint32 {
	return (volatile.LoadUint32(&o.RSV.Reg) & 0x800000) >> 23
}
func (o *ETHERNET_Type) SetRSV_MULTICAST(value uint32) {
	volatile.StoreUint32(&o.RSV.Reg, volatile.LoadUint32(&o.RSV.Reg)&^(0x1000000)|value<<24)
}
func (o *ETHERNET_Type) GetRSV_MULTICAST() uint32 {
	return (volatile.LoadUint32(&o.RSV.Reg) & 0x1000000) >> 24
}
func (o *ETHERNET_Type) SetRSV_BROADCAST(value uint32) {
	volatile.StoreUint32(&o.RSV.Reg, volatile.LoadUint32(&o.RSV.Reg)&^(0x2000000)|value<<25)
}
func (o *ETHERNET_Type) GetRSV_BROADCAST() uint32 {
	return (volatile.LoadUint32(&o.RSV.Reg) & 0x2000000) >> 25
}
func (o *ETHERNET_Type) SetRSV_DRIBBLENIBBLE(value uint32) {
	volatile.StoreUint32(&o.RSV.Reg, volatile.LoadUint32(&o.RSV.Reg)&^(0x4000000)|value<<26)
}
func (o *ETHERNET_Type) GetRSV_DRIBBLENIBBLE() uint32 {
	return (volatile.LoadUint32(&o.RSV.Reg) & 0x4000000) >> 26
}
func (o *ETHERNET_Type) SetRSV_CONTROLFRAME(value uint32) {
	volatile.StoreUint32(&o.RSV.Reg, volatile.LoadUint32(&o.RSV.Reg)&^(0x8000000)|value<<27)
}
func (o *ETHERNET_Type) GetRSV_CONTROLFRAME() uint32 {
	return (volatile.LoadUint32(&o.RSV.Reg) & 0x8000000) >> 27
}
func (o *ETHERNET_Type) SetRSV_PAUSE(value uint32) {
	volatile.StoreUint32(&o.RSV.Reg, volatile.LoadUint32(&o.RSV.Reg)&^(0x10000000)|value<<28)
}
func (o *ETHERNET_Type) GetRSV_PAUSE() uint32 {
	return (volatile.LoadUint32(&o.RSV.Reg) & 0x10000000) >> 28
}
func (o *ETHERNET_Type) SetRSV_UO(value uint32) {
	volatile.StoreUint32(&o.RSV.Reg, volatile.LoadUint32(&o.RSV.Reg)&^(0x20000000)|value<<29)
}
func (o *ETHERNET_Type) GetRSV_UO() uint32 {
	return (volatile.LoadUint32(&o.RSV.Reg) & 0x20000000) >> 29
}
func (o *ETHERNET_Type) SetRSV_VLAN(value uint32) {
	volatile.StoreUint32(&o.RSV.Reg, volatile.LoadUint32(&o.RSV.Reg)&^(0x40000000)|value<<30)
}
func (o *ETHERNET_Type) GetRSV_VLAN() uint32 {
	return (volatile.LoadUint32(&o.RSV.Reg) & 0x40000000) >> 30
}
func (o *ETHERNET_Type) SetRSV_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RSV.Reg, volatile.LoadUint32(&o.RSV.Reg)&^(0x80000000)|value<<31)
}
func (o *ETHERNET_Type) GetRSV_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RSV.Reg) & 0x80000000) >> 31
}

// ETHERNET.FLOWCONTROLCOUNTER: Flow control counter register.
func (o *ETHERNET_Type) SetFLOWCONTROLCOUNTER_MC(value uint32) {
	volatile.StoreUint32(&o.FLOWCONTROLCOUNTER.Reg, volatile.LoadUint32(&o.FLOWCONTROLCOUNTER.Reg)&^(0xffff)|value)
}
func (o *ETHERNET_Type) GetFLOWCONTROLCOUNTER_MC() uint32 {
	return volatile.LoadUint32(&o.FLOWCONTROLCOUNTER.Reg) & 0xffff
}
func (o *ETHERNET_Type) SetFLOWCONTROLCOUNTER_PT(value uint32) {
	volatile.StoreUint32(&o.FLOWCONTROLCOUNTER.Reg, volatile.LoadUint32(&o.FLOWCONTROLCOUNTER.Reg)&^(0xffff0000)|value<<16)
}
func (o *ETHERNET_Type) GetFLOWCONTROLCOUNTER_PT() uint32 {
	return (volatile.LoadUint32(&o.FLOWCONTROLCOUNTER.Reg) & 0xffff0000) >> 16
}

// ETHERNET.FLOWCONTROLSTATUS: Flow control status register.
func (o *ETHERNET_Type) SetFLOWCONTROLSTATUS_MCC(value uint32) {
	volatile.StoreUint32(&o.FLOWCONTROLSTATUS.Reg, volatile.LoadUint32(&o.FLOWCONTROLSTATUS.Reg)&^(0xffff)|value)
}
func (o *ETHERNET_Type) GetFLOWCONTROLSTATUS_MCC() uint32 {
	return volatile.LoadUint32(&o.FLOWCONTROLSTATUS.Reg) & 0xffff
}
func (o *ETHERNET_Type) SetFLOWCONTROLSTATUS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FLOWCONTROLSTATUS.Reg, volatile.LoadUint32(&o.FLOWCONTROLSTATUS.Reg)&^(0xffff0000)|value<<16)
}
func (o *ETHERNET_Type) GetFLOWCONTROLSTATUS_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FLOWCONTROLSTATUS.Reg) & 0xffff0000) >> 16
}

// ETHERNET.RXFILTERCTRL: Receive filter control register.
func (o *ETHERNET_Type) SetRXFILTERCTRL_AUE(value uint32) {
	volatile.StoreUint32(&o.RXFILTERCTRL.Reg, volatile.LoadUint32(&o.RXFILTERCTRL.Reg)&^(0x1)|value)
}
func (o *ETHERNET_Type) GetRXFILTERCTRL_AUE() uint32 {
	return volatile.LoadUint32(&o.RXFILTERCTRL.Reg) & 0x1
}
func (o *ETHERNET_Type) SetRXFILTERCTRL_ABE(value uint32) {
	volatile.StoreUint32(&o.RXFILTERCTRL.Reg, volatile.LoadUint32(&o.RXFILTERCTRL.Reg)&^(0x2)|value<<1)
}
func (o *ETHERNET_Type) GetRXFILTERCTRL_ABE() uint32 {
	return (volatile.LoadUint32(&o.RXFILTERCTRL.Reg) & 0x2) >> 1
}
func (o *ETHERNET_Type) SetRXFILTERCTRL_AME(value uint32) {
	volatile.StoreUint32(&o.RXFILTERCTRL.Reg, volatile.LoadUint32(&o.RXFILTERCTRL.Reg)&^(0x4)|value<<2)
}
func (o *ETHERNET_Type) GetRXFILTERCTRL_AME() uint32 {
	return (volatile.LoadUint32(&o.RXFILTERCTRL.Reg) & 0x4) >> 2
}
func (o *ETHERNET_Type) SetRXFILTERCTRL_AUHE(value uint32) {
	volatile.StoreUint32(&o.RXFILTERCTRL.Reg, volatile.LoadUint32(&o.RXFILTERCTRL.Reg)&^(0x8)|value<<3)
}
func (o *ETHERNET_Type) GetRXFILTERCTRL_AUHE() uint32 {
	return (volatile.LoadUint32(&o.RXFILTERCTRL.Reg) & 0x8) >> 3
}
func (o *ETHERNET_Type) SetRXFILTERCTRL_AMHE(value uint32) {
	volatile.StoreUint32(&o.RXFILTERCTRL.Reg, volatile.LoadUint32(&o.RXFILTERCTRL.Reg)&^(0x10)|value<<4)
}
func (o *ETHERNET_Type) GetRXFILTERCTRL_AMHE() uint32 {
	return (volatile.LoadUint32(&o.RXFILTERCTRL.Reg) & 0x10) >> 4
}
func (o *ETHERNET_Type) SetRXFILTERCTRL_APE(value uint32) {
	volatile.StoreUint32(&o.RXFILTERCTRL.Reg, volatile.LoadUint32(&o.RXFILTERCTRL.Reg)&^(0x20)|value<<5)
}
func (o *ETHERNET_Type) GetRXFILTERCTRL_APE() uint32 {
	return (volatile.LoadUint32(&o.RXFILTERCTRL.Reg) & 0x20) >> 5
}
func (o *ETHERNET_Type) SetRXFILTERCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RXFILTERCTRL.Reg, volatile.LoadUint32(&o.RXFILTERCTRL.Reg)&^(0xfc0)|value<<6)
}
func (o *ETHERNET_Type) GetRXFILTERCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RXFILTERCTRL.Reg) & 0xfc0) >> 6
}
func (o *ETHERNET_Type) SetRXFILTERCTRL_MPEW(value uint32) {
	volatile.StoreUint32(&o.RXFILTERCTRL.Reg, volatile.LoadUint32(&o.RXFILTERCTRL.Reg)&^(0x1000)|value<<12)
}
func (o *ETHERNET_Type) GetRXFILTERCTRL_MPEW() uint32 {
	return (volatile.LoadUint32(&o.RXFILTERCTRL.Reg) & 0x1000) >> 12
}
func (o *ETHERNET_Type) SetRXFILTERCTRL_RFEW(value uint32) {
	volatile.StoreUint32(&o.RXFILTERCTRL.Reg, volatile.LoadUint32(&o.RXFILTERCTRL.Reg)&^(0x2000)|value<<13)
}
func (o *ETHERNET_Type) GetRXFILTERCTRL_RFEW() uint32 {
	return (volatile.LoadUint32(&o.RXFILTERCTRL.Reg) & 0x2000) >> 13
}
func (o *ETHERNET_Type) SetRXFILTERCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RXFILTERCTRL.Reg, volatile.LoadUint32(&o.RXFILTERCTRL.Reg)&^(0xffffc000)|value<<14)
}
func (o *ETHERNET_Type) GetRXFILTERCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RXFILTERCTRL.Reg) & 0xffffc000) >> 14
}

// ETHERNET.RXFILTERWOLSTATUS: Receive filter WoL status register.
func (o *ETHERNET_Type) SetRXFILTERWOLSTATUS_AUW(value uint32) {
	volatile.StoreUint32(&o.RXFILTERWOLSTATUS.Reg, volatile.LoadUint32(&o.RXFILTERWOLSTATUS.Reg)&^(0x1)|value)
}
func (o *ETHERNET_Type) GetRXFILTERWOLSTATUS_AUW() uint32 {
	return volatile.LoadUint32(&o.RXFILTERWOLSTATUS.Reg) & 0x1
}
func (o *ETHERNET_Type) SetRXFILTERWOLSTATUS_ABW(value uint32) {
	volatile.StoreUint32(&o.RXFILTERWOLSTATUS.Reg, volatile.LoadUint32(&o.RXFILTERWOLSTATUS.Reg)&^(0x2)|value<<1)
}
func (o *ETHERNET_Type) GetRXFILTERWOLSTATUS_ABW() uint32 {
	return (volatile.LoadUint32(&o.RXFILTERWOLSTATUS.Reg) & 0x2) >> 1
}
func (o *ETHERNET_Type) SetRXFILTERWOLSTATUS_AMW(value uint32) {
	volatile.StoreUint32(&o.RXFILTERWOLSTATUS.Reg, volatile.LoadUint32(&o.RXFILTERWOLSTATUS.Reg)&^(0x4)|value<<2)
}
func (o *ETHERNET_Type) GetRXFILTERWOLSTATUS_AMW() uint32 {
	return (volatile.LoadUint32(&o.RXFILTERWOLSTATUS.Reg) & 0x4) >> 2
}
func (o *ETHERNET_Type) SetRXFILTERWOLSTATUS_AUHW(value uint32) {
	volatile.StoreUint32(&o.RXFILTERWOLSTATUS.Reg, volatile.LoadUint32(&o.RXFILTERWOLSTATUS.Reg)&^(0x8)|value<<3)
}
func (o *ETHERNET_Type) GetRXFILTERWOLSTATUS_AUHW() uint32 {
	return (volatile.LoadUint32(&o.RXFILTERWOLSTATUS.Reg) & 0x8) >> 3
}
func (o *ETHERNET_Type) SetRXFILTERWOLSTATUS_AMHW(value uint32) {
	volatile.StoreUint32(&o.RXFILTERWOLSTATUS.Reg, volatile.LoadUint32(&o.RXFILTERWOLSTATUS.Reg)&^(0x10)|value<<4)
}
func (o *ETHERNET_Type) GetRXFILTERWOLSTATUS_AMHW() uint32 {
	return (volatile.LoadUint32(&o.RXFILTERWOLSTATUS.Reg) & 0x10) >> 4
}
func (o *ETHERNET_Type) SetRXFILTERWOLSTATUS_APW(value uint32) {
	volatile.StoreUint32(&o.RXFILTERWOLSTATUS.Reg, volatile.LoadUint32(&o.RXFILTERWOLSTATUS.Reg)&^(0x20)|value<<5)
}
func (o *ETHERNET_Type) GetRXFILTERWOLSTATUS_APW() uint32 {
	return (volatile.LoadUint32(&o.RXFILTERWOLSTATUS.Reg) & 0x20) >> 5
}
func (o *ETHERNET_Type) SetRXFILTERWOLSTATUS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RXFILTERWOLSTATUS.Reg, volatile.LoadUint32(&o.RXFILTERWOLSTATUS.Reg)&^(0x40)|value<<6)
}
func (o *ETHERNET_Type) GetRXFILTERWOLSTATUS_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RXFILTERWOLSTATUS.Reg) & 0x40) >> 6
}
func (o *ETHERNET_Type) SetRXFILTERWOLSTATUS_RFW(value uint32) {
	volatile.StoreUint32(&o.RXFILTERWOLSTATUS.Reg, volatile.LoadUint32(&o.RXFILTERWOLSTATUS.Reg)&^(0x80)|value<<7)
}
func (o *ETHERNET_Type) GetRXFILTERWOLSTATUS_RFW() uint32 {
	return (volatile.LoadUint32(&o.RXFILTERWOLSTATUS.Reg) & 0x80) >> 7
}
func (o *ETHERNET_Type) SetRXFILTERWOLSTATUS_MPW(value uint32) {
	volatile.StoreUint32(&o.RXFILTERWOLSTATUS.Reg, volatile.LoadUint32(&o.RXFILTERWOLSTATUS.Reg)&^(0x100)|value<<8)
}
func (o *ETHERNET_Type) GetRXFILTERWOLSTATUS_MPW() uint32 {
	return (volatile.LoadUint32(&o.RXFILTERWOLSTATUS.Reg) & 0x100) >> 8
}
func (o *ETHERNET_Type) SetRXFILTERWOLSTATUS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RXFILTERWOLSTATUS.Reg, volatile.LoadUint32(&o.RXFILTERWOLSTATUS.Reg)&^(0xfffffe00)|value<<9)
}
func (o *ETHERNET_Type) GetRXFILTERWOLSTATUS_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RXFILTERWOLSTATUS.Reg) & 0xfffffe00) >> 9
}

// ETHERNET.RXFILTERWOLCLEAR: Receive filter WoL clear register.
func (o *ETHERNET_Type) SetRXFILTERWOLCLEAR_AUWCLR(value uint32) {
	volatile.StoreUint32(&o.RXFILTERWOLCLEAR.Reg, volatile.LoadUint32(&o.RXFILTERWOLCLEAR.Reg)&^(0x1)|value)
}
func (o *ETHERNET_Type) GetRXFILTERWOLCLEAR_AUWCLR() uint32 {
	return volatile.LoadUint32(&o.RXFILTERWOLCLEAR.Reg) & 0x1
}
func (o *ETHERNET_Type) SetRXFILTERWOLCLEAR_ABWCLR(value uint32) {
	volatile.StoreUint32(&o.RXFILTERWOLCLEAR.Reg, volatile.LoadUint32(&o.RXFILTERWOLCLEAR.Reg)&^(0x2)|value<<1)
}
func (o *ETHERNET_Type) GetRXFILTERWOLCLEAR_ABWCLR() uint32 {
	return (volatile.LoadUint32(&o.RXFILTERWOLCLEAR.Reg) & 0x2) >> 1
}
func (o *ETHERNET_Type) SetRXFILTERWOLCLEAR_AMWCLR(value uint32) {
	volatile.StoreUint32(&o.RXFILTERWOLCLEAR.Reg, volatile.LoadUint32(&o.RXFILTERWOLCLEAR.Reg)&^(0x4)|value<<2)
}
func (o *ETHERNET_Type) GetRXFILTERWOLCLEAR_AMWCLR() uint32 {
	return (volatile.LoadUint32(&o.RXFILTERWOLCLEAR.Reg) & 0x4) >> 2
}
func (o *ETHERNET_Type) SetRXFILTERWOLCLEAR_AUHWCLR(value uint32) {
	volatile.StoreUint32(&o.RXFILTERWOLCLEAR.Reg, volatile.LoadUint32(&o.RXFILTERWOLCLEAR.Reg)&^(0x8)|value<<3)
}
func (o *ETHERNET_Type) GetRXFILTERWOLCLEAR_AUHWCLR() uint32 {
	return (volatile.LoadUint32(&o.RXFILTERWOLCLEAR.Reg) & 0x8) >> 3
}
func (o *ETHERNET_Type) SetRXFILTERWOLCLEAR_AMHWCLR(value uint32) {
	volatile.StoreUint32(&o.RXFILTERWOLCLEAR.Reg, volatile.LoadUint32(&o.RXFILTERWOLCLEAR.Reg)&^(0x10)|value<<4)
}
func (o *ETHERNET_Type) GetRXFILTERWOLCLEAR_AMHWCLR() uint32 {
	return (volatile.LoadUint32(&o.RXFILTERWOLCLEAR.Reg) & 0x10) >> 4
}
func (o *ETHERNET_Type) SetRXFILTERWOLCLEAR_APWCLR(value uint32) {
	volatile.StoreUint32(&o.RXFILTERWOLCLEAR.Reg, volatile.LoadUint32(&o.RXFILTERWOLCLEAR.Reg)&^(0x20)|value<<5)
}
func (o *ETHERNET_Type) GetRXFILTERWOLCLEAR_APWCLR() uint32 {
	return (volatile.LoadUint32(&o.RXFILTERWOLCLEAR.Reg) & 0x20) >> 5
}
func (o *ETHERNET_Type) SetRXFILTERWOLCLEAR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RXFILTERWOLCLEAR.Reg, volatile.LoadUint32(&o.RXFILTERWOLCLEAR.Reg)&^(0x40)|value<<6)
}
func (o *ETHERNET_Type) GetRXFILTERWOLCLEAR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RXFILTERWOLCLEAR.Reg) & 0x40) >> 6
}
func (o *ETHERNET_Type) SetRXFILTERWOLCLEAR_RFWCLR(value uint32) {
	volatile.StoreUint32(&o.RXFILTERWOLCLEAR.Reg, volatile.LoadUint32(&o.RXFILTERWOLCLEAR.Reg)&^(0x80)|value<<7)
}
func (o *ETHERNET_Type) GetRXFILTERWOLCLEAR_RFWCLR() uint32 {
	return (volatile.LoadUint32(&o.RXFILTERWOLCLEAR.Reg) & 0x80) >> 7
}
func (o *ETHERNET_Type) SetRXFILTERWOLCLEAR_MPWCLR(value uint32) {
	volatile.StoreUint32(&o.RXFILTERWOLCLEAR.Reg, volatile.LoadUint32(&o.RXFILTERWOLCLEAR.Reg)&^(0x100)|value<<8)
}
func (o *ETHERNET_Type) GetRXFILTERWOLCLEAR_MPWCLR() uint32 {
	return (volatile.LoadUint32(&o.RXFILTERWOLCLEAR.Reg) & 0x100) >> 8
}
func (o *ETHERNET_Type) SetRXFILTERWOLCLEAR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RXFILTERWOLCLEAR.Reg, volatile.LoadUint32(&o.RXFILTERWOLCLEAR.Reg)&^(0xfffffe00)|value<<9)
}
func (o *ETHERNET_Type) GetRXFILTERWOLCLEAR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RXFILTERWOLCLEAR.Reg) & 0xfffffe00) >> 9
}

// ETHERNET.HASHFILTERL: Hash filter table LSBs register.
func (o *ETHERNET_Type) SetHASHFILTERL(value uint32) {
	volatile.StoreUint32(&o.HASHFILTERL.Reg, value)
}
func (o *ETHERNET_Type) GetHASHFILTERL() uint32 {
	return volatile.LoadUint32(&o.HASHFILTERL.Reg)
}

// ETHERNET.HASHFILTERH: Hash filter table MSBs register.
func (o *ETHERNET_Type) SetHASHFILTERH(value uint32) {
	volatile.StoreUint32(&o.HASHFILTERH.Reg, value)
}
func (o *ETHERNET_Type) GetHASHFILTERH() uint32 {
	return volatile.LoadUint32(&o.HASHFILTERH.Reg)
}

// ETHERNET.INTSTATUS: Interrupt status register.
func (o *ETHERNET_Type) SetINTSTATUS_RXOVERRUNINT(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x1)|value)
}
func (o *ETHERNET_Type) GetINTSTATUS_RXOVERRUNINT() uint32 {
	return volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x1
}
func (o *ETHERNET_Type) SetINTSTATUS_RXERRORINT(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x2)|value<<1)
}
func (o *ETHERNET_Type) GetINTSTATUS_RXERRORINT() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x2) >> 1
}
func (o *ETHERNET_Type) SetINTSTATUS_RXFINISHEDINT(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x4)|value<<2)
}
func (o *ETHERNET_Type) GetINTSTATUS_RXFINISHEDINT() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x4) >> 2
}
func (o *ETHERNET_Type) SetINTSTATUS_RXDONEINT(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x8)|value<<3)
}
func (o *ETHERNET_Type) GetINTSTATUS_RXDONEINT() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x8) >> 3
}
func (o *ETHERNET_Type) SetINTSTATUS_TXUNDERRUNINT(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x10)|value<<4)
}
func (o *ETHERNET_Type) GetINTSTATUS_TXUNDERRUNINT() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x10) >> 4
}
func (o *ETHERNET_Type) SetINTSTATUS_TXERRORINT(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x20)|value<<5)
}
func (o *ETHERNET_Type) GetINTSTATUS_TXERRORINT() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x20) >> 5
}
func (o *ETHERNET_Type) SetINTSTATUS_TXFINISHEDINT(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x40)|value<<6)
}
func (o *ETHERNET_Type) GetINTSTATUS_TXFINISHEDINT() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x40) >> 6
}
func (o *ETHERNET_Type) SetINTSTATUS_TXDONEINT(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x80)|value<<7)
}
func (o *ETHERNET_Type) GetINTSTATUS_TXDONEINT() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x80) >> 7
}
func (o *ETHERNET_Type) SetINTSTATUS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0xf00)|value<<8)
}
func (o *ETHERNET_Type) GetINTSTATUS_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0xf00) >> 8
}
func (o *ETHERNET_Type) SetINTSTATUS_SOFTINT(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x1000)|value<<12)
}
func (o *ETHERNET_Type) GetINTSTATUS_SOFTINT() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x1000) >> 12
}
func (o *ETHERNET_Type) SetINTSTATUS_WAKEUPINT(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x2000)|value<<13)
}
func (o *ETHERNET_Type) GetINTSTATUS_WAKEUPINT() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x2000) >> 13
}
func (o *ETHERNET_Type) SetINTSTATUS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0xffffc000)|value<<14)
}
func (o *ETHERNET_Type) GetINTSTATUS_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0xffffc000) >> 14
}

// ETHERNET.INTENABLE: Interrupt enable register.
func (o *ETHERNET_Type) SetINTENABLE_RXOVERRUNINTEN(value uint32) {
	volatile.StoreUint32(&o.INTENABLE.Reg, volatile.LoadUint32(&o.INTENABLE.Reg)&^(0x1)|value)
}
func (o *ETHERNET_Type) GetINTENABLE_RXOVERRUNINTEN() uint32 {
	return volatile.LoadUint32(&o.INTENABLE.Reg) & 0x1
}
func (o *ETHERNET_Type) SetINTENABLE_RXERRORINTEN(value uint32) {
	volatile.StoreUint32(&o.INTENABLE.Reg, volatile.LoadUint32(&o.INTENABLE.Reg)&^(0x2)|value<<1)
}
func (o *ETHERNET_Type) GetINTENABLE_RXERRORINTEN() uint32 {
	return (volatile.LoadUint32(&o.INTENABLE.Reg) & 0x2) >> 1
}
func (o *ETHERNET_Type) SetINTENABLE_RXFINISHEDINTEN(value uint32) {
	volatile.StoreUint32(&o.INTENABLE.Reg, volatile.LoadUint32(&o.INTENABLE.Reg)&^(0x4)|value<<2)
}
func (o *ETHERNET_Type) GetINTENABLE_RXFINISHEDINTEN() uint32 {
	return (volatile.LoadUint32(&o.INTENABLE.Reg) & 0x4) >> 2
}
func (o *ETHERNET_Type) SetINTENABLE_RXDONEINTEN(value uint32) {
	volatile.StoreUint32(&o.INTENABLE.Reg, volatile.LoadUint32(&o.INTENABLE.Reg)&^(0x8)|value<<3)
}
func (o *ETHERNET_Type) GetINTENABLE_RXDONEINTEN() uint32 {
	return (volatile.LoadUint32(&o.INTENABLE.Reg) & 0x8) >> 3
}
func (o *ETHERNET_Type) SetINTENABLE_TXUNDERRUNINTEN(value uint32) {
	volatile.StoreUint32(&o.INTENABLE.Reg, volatile.LoadUint32(&o.INTENABLE.Reg)&^(0x10)|value<<4)
}
func (o *ETHERNET_Type) GetINTENABLE_TXUNDERRUNINTEN() uint32 {
	return (volatile.LoadUint32(&o.INTENABLE.Reg) & 0x10) >> 4
}
func (o *ETHERNET_Type) SetINTENABLE_TXERRORINTEN(value uint32) {
	volatile.StoreUint32(&o.INTENABLE.Reg, volatile.LoadUint32(&o.INTENABLE.Reg)&^(0x20)|value<<5)
}
func (o *ETHERNET_Type) GetINTENABLE_TXERRORINTEN() uint32 {
	return (volatile.LoadUint32(&o.INTENABLE.Reg) & 0x20) >> 5
}
func (o *ETHERNET_Type) SetINTENABLE_TXFINISHEDINTEN(value uint32) {
	volatile.StoreUint32(&o.INTENABLE.Reg, volatile.LoadUint32(&o.INTENABLE.Reg)&^(0x40)|value<<6)
}
func (o *ETHERNET_Type) GetINTENABLE_TXFINISHEDINTEN() uint32 {
	return (volatile.LoadUint32(&o.INTENABLE.Reg) & 0x40) >> 6
}
func (o *ETHERNET_Type) SetINTENABLE_TXDONEINTEN(value uint32) {
	volatile.StoreUint32(&o.INTENABLE.Reg, volatile.LoadUint32(&o.INTENABLE.Reg)&^(0x80)|value<<7)
}
func (o *ETHERNET_Type) GetINTENABLE_TXDONEINTEN() uint32 {
	return (volatile.LoadUint32(&o.INTENABLE.Reg) & 0x80) >> 7
}
func (o *ETHERNET_Type) SetINTENABLE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENABLE.Reg, volatile.LoadUint32(&o.INTENABLE.Reg)&^(0xf00)|value<<8)
}
func (o *ETHERNET_Type) GetINTENABLE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENABLE.Reg) & 0xf00) >> 8
}
func (o *ETHERNET_Type) SetINTENABLE_SOFTINTEN(value uint32) {
	volatile.StoreUint32(&o.INTENABLE.Reg, volatile.LoadUint32(&o.INTENABLE.Reg)&^(0x1000)|value<<12)
}
func (o *ETHERNET_Type) GetINTENABLE_SOFTINTEN() uint32 {
	return (volatile.LoadUint32(&o.INTENABLE.Reg) & 0x1000) >> 12
}
func (o *ETHERNET_Type) SetINTENABLE_WAKEUPINTEN(value uint32) {
	volatile.StoreUint32(&o.INTENABLE.Reg, volatile.LoadUint32(&o.INTENABLE.Reg)&^(0x2000)|value<<13)
}
func (o *ETHERNET_Type) GetINTENABLE_WAKEUPINTEN() uint32 {
	return (volatile.LoadUint32(&o.INTENABLE.Reg) & 0x2000) >> 13
}
func (o *ETHERNET_Type) SetINTENABLE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENABLE.Reg, volatile.LoadUint32(&o.INTENABLE.Reg)&^(0xffffc000)|value<<14)
}
func (o *ETHERNET_Type) GetINTENABLE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENABLE.Reg) & 0xffffc000) >> 14
}

// ETHERNET.INTCLEAR: Interrupt clear register.
func (o *ETHERNET_Type) SetINTCLEAR_RXOVERRUNINTCLR(value uint32) {
	volatile.StoreUint32(&o.INTCLEAR.Reg, volatile.LoadUint32(&o.INTCLEAR.Reg)&^(0x1)|value)
}
func (o *ETHERNET_Type) GetINTCLEAR_RXOVERRUNINTCLR() uint32 {
	return volatile.LoadUint32(&o.INTCLEAR.Reg) & 0x1
}
func (o *ETHERNET_Type) SetINTCLEAR_RXERRORINTCLR(value uint32) {
	volatile.StoreUint32(&o.INTCLEAR.Reg, volatile.LoadUint32(&o.INTCLEAR.Reg)&^(0x2)|value<<1)
}
func (o *ETHERNET_Type) GetINTCLEAR_RXERRORINTCLR() uint32 {
	return (volatile.LoadUint32(&o.INTCLEAR.Reg) & 0x2) >> 1
}
func (o *ETHERNET_Type) SetINTCLEAR_RXFINISHEDINTCLR(value uint32) {
	volatile.StoreUint32(&o.INTCLEAR.Reg, volatile.LoadUint32(&o.INTCLEAR.Reg)&^(0x4)|value<<2)
}
func (o *ETHERNET_Type) GetINTCLEAR_RXFINISHEDINTCLR() uint32 {
	return (volatile.LoadUint32(&o.INTCLEAR.Reg) & 0x4) >> 2
}
func (o *ETHERNET_Type) SetINTCLEAR_RXDONEINTCLR(value uint32) {
	volatile.StoreUint32(&o.INTCLEAR.Reg, volatile.LoadUint32(&o.INTCLEAR.Reg)&^(0x8)|value<<3)
}
func (o *ETHERNET_Type) GetINTCLEAR_RXDONEINTCLR() uint32 {
	return (volatile.LoadUint32(&o.INTCLEAR.Reg) & 0x8) >> 3
}
func (o *ETHERNET_Type) SetINTCLEAR_TXUNDERRUNINTCLR(value uint32) {
	volatile.StoreUint32(&o.INTCLEAR.Reg, volatile.LoadUint32(&o.INTCLEAR.Reg)&^(0x10)|value<<4)
}
func (o *ETHERNET_Type) GetINTCLEAR_TXUNDERRUNINTCLR() uint32 {
	return (volatile.LoadUint32(&o.INTCLEAR.Reg) & 0x10) >> 4
}
func (o *ETHERNET_Type) SetINTCLEAR_TXERRORINTCLR(value uint32) {
	volatile.StoreUint32(&o.INTCLEAR.Reg, volatile.LoadUint32(&o.INTCLEAR.Reg)&^(0x20)|value<<5)
}
func (o *ETHERNET_Type) GetINTCLEAR_TXERRORINTCLR() uint32 {
	return (volatile.LoadUint32(&o.INTCLEAR.Reg) & 0x20) >> 5
}
func (o *ETHERNET_Type) SetINTCLEAR_TXFINISHEDINTCLR(value uint32) {
	volatile.StoreUint32(&o.INTCLEAR.Reg, volatile.LoadUint32(&o.INTCLEAR.Reg)&^(0x40)|value<<6)
}
func (o *ETHERNET_Type) GetINTCLEAR_TXFINISHEDINTCLR() uint32 {
	return (volatile.LoadUint32(&o.INTCLEAR.Reg) & 0x40) >> 6
}
func (o *ETHERNET_Type) SetINTCLEAR_TXDONEINTCLR(value uint32) {
	volatile.StoreUint32(&o.INTCLEAR.Reg, volatile.LoadUint32(&o.INTCLEAR.Reg)&^(0x80)|value<<7)
}
func (o *ETHERNET_Type) GetINTCLEAR_TXDONEINTCLR() uint32 {
	return (volatile.LoadUint32(&o.INTCLEAR.Reg) & 0x80) >> 7
}
func (o *ETHERNET_Type) SetINTCLEAR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTCLEAR.Reg, volatile.LoadUint32(&o.INTCLEAR.Reg)&^(0xf00)|value<<8)
}
func (o *ETHERNET_Type) GetINTCLEAR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTCLEAR.Reg) & 0xf00) >> 8
}
func (o *ETHERNET_Type) SetINTCLEAR_SOFTINTCLR(value uint32) {
	volatile.StoreUint32(&o.INTCLEAR.Reg, volatile.LoadUint32(&o.INTCLEAR.Reg)&^(0x1000)|value<<12)
}
func (o *ETHERNET_Type) GetINTCLEAR_SOFTINTCLR() uint32 {
	return (volatile.LoadUint32(&o.INTCLEAR.Reg) & 0x1000) >> 12
}
func (o *ETHERNET_Type) SetINTCLEAR_WAKEUPINTCLR(value uint32) {
	volatile.StoreUint32(&o.INTCLEAR.Reg, volatile.LoadUint32(&o.INTCLEAR.Reg)&^(0x2000)|value<<13)
}
func (o *ETHERNET_Type) GetINTCLEAR_WAKEUPINTCLR() uint32 {
	return (volatile.LoadUint32(&o.INTCLEAR.Reg) & 0x2000) >> 13
}
func (o *ETHERNET_Type) SetINTCLEAR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTCLEAR.Reg, volatile.LoadUint32(&o.INTCLEAR.Reg)&^(0xffffc000)|value<<14)
}
func (o *ETHERNET_Type) GetINTCLEAR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTCLEAR.Reg) & 0xffffc000) >> 14
}

// ETHERNET.INTSET: Interrupt set register.
func (o *ETHERNET_Type) SetINTSET_RXOVERRUNINTSET(value uint32) {
	volatile.StoreUint32(&o.INTSET.Reg, volatile.LoadUint32(&o.INTSET.Reg)&^(0x1)|value)
}
func (o *ETHERNET_Type) GetINTSET_RXOVERRUNINTSET() uint32 {
	return volatile.LoadUint32(&o.INTSET.Reg) & 0x1
}
func (o *ETHERNET_Type) SetINTSET_RXERRORINTSET(value uint32) {
	volatile.StoreUint32(&o.INTSET.Reg, volatile.LoadUint32(&o.INTSET.Reg)&^(0x2)|value<<1)
}
func (o *ETHERNET_Type) GetINTSET_RXERRORINTSET() uint32 {
	return (volatile.LoadUint32(&o.INTSET.Reg) & 0x2) >> 1
}
func (o *ETHERNET_Type) SetINTSET_RXFINISHEDINTSET(value uint32) {
	volatile.StoreUint32(&o.INTSET.Reg, volatile.LoadUint32(&o.INTSET.Reg)&^(0x4)|value<<2)
}
func (o *ETHERNET_Type) GetINTSET_RXFINISHEDINTSET() uint32 {
	return (volatile.LoadUint32(&o.INTSET.Reg) & 0x4) >> 2
}
func (o *ETHERNET_Type) SetINTSET_RXDONEINTSET(value uint32) {
	volatile.StoreUint32(&o.INTSET.Reg, volatile.LoadUint32(&o.INTSET.Reg)&^(0x8)|value<<3)
}
func (o *ETHERNET_Type) GetINTSET_RXDONEINTSET() uint32 {
	return (volatile.LoadUint32(&o.INTSET.Reg) & 0x8) >> 3
}
func (o *ETHERNET_Type) SetINTSET_TXUNDERRUNINTSET(value uint32) {
	volatile.StoreUint32(&o.INTSET.Reg, volatile.LoadUint32(&o.INTSET.Reg)&^(0x10)|value<<4)
}
func (o *ETHERNET_Type) GetINTSET_TXUNDERRUNINTSET() uint32 {
	return (volatile.LoadUint32(&o.INTSET.Reg) & 0x10) >> 4
}
func (o *ETHERNET_Type) SetINTSET_TXERRORINTSET(value uint32) {
	volatile.StoreUint32(&o.INTSET.Reg, volatile.LoadUint32(&o.INTSET.Reg)&^(0x20)|value<<5)
}
func (o *ETHERNET_Type) GetINTSET_TXERRORINTSET() uint32 {
	return (volatile.LoadUint32(&o.INTSET.Reg) & 0x20) >> 5
}
func (o *ETHERNET_Type) SetINTSET_TXFINISHEDINTSET(value uint32) {
	volatile.StoreUint32(&o.INTSET.Reg, volatile.LoadUint32(&o.INTSET.Reg)&^(0x40)|value<<6)
}
func (o *ETHERNET_Type) GetINTSET_TXFINISHEDINTSET() uint32 {
	return (volatile.LoadUint32(&o.INTSET.Reg) & 0x40) >> 6
}
func (o *ETHERNET_Type) SetINTSET_TXDONEINTSET(value uint32) {
	volatile.StoreUint32(&o.INTSET.Reg, volatile.LoadUint32(&o.INTSET.Reg)&^(0x80)|value<<7)
}
func (o *ETHERNET_Type) GetINTSET_TXDONEINTSET() uint32 {
	return (volatile.LoadUint32(&o.INTSET.Reg) & 0x80) >> 7
}
func (o *ETHERNET_Type) SetINTSET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTSET.Reg, volatile.LoadUint32(&o.INTSET.Reg)&^(0xf00)|value<<8)
}
func (o *ETHERNET_Type) GetINTSET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTSET.Reg) & 0xf00) >> 8
}
func (o *ETHERNET_Type) SetINTSET_SOFTINTSET(value uint32) {
	volatile.StoreUint32(&o.INTSET.Reg, volatile.LoadUint32(&o.INTSET.Reg)&^(0x1000)|value<<12)
}
func (o *ETHERNET_Type) GetINTSET_SOFTINTSET() uint32 {
	return (volatile.LoadUint32(&o.INTSET.Reg) & 0x1000) >> 12
}
func (o *ETHERNET_Type) SetINTSET_WAKEUPINTSET(value uint32) {
	volatile.StoreUint32(&o.INTSET.Reg, volatile.LoadUint32(&o.INTSET.Reg)&^(0x2000)|value<<13)
}
func (o *ETHERNET_Type) GetINTSET_WAKEUPINTSET() uint32 {
	return (volatile.LoadUint32(&o.INTSET.Reg) & 0x2000) >> 13
}
func (o *ETHERNET_Type) SetINTSET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTSET.Reg, volatile.LoadUint32(&o.INTSET.Reg)&^(0xffffc000)|value<<14)
}
func (o *ETHERNET_Type) GetINTSET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTSET.Reg) & 0xffffc000) >> 14
}

// ETHERNET.POWERDOWN: Power-down register.
func (o *ETHERNET_Type) SetPOWERDOWN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.POWERDOWN.Reg, volatile.LoadUint32(&o.POWERDOWN.Reg)&^(0x7fffffff)|value)
}
func (o *ETHERNET_Type) GetPOWERDOWN_RESERVED() uint32 {
	return volatile.LoadUint32(&o.POWERDOWN.Reg) & 0x7fffffff
}
func (o *ETHERNET_Type) SetPOWERDOWN_PD(value uint32) {
	volatile.StoreUint32(&o.POWERDOWN.Reg, volatile.LoadUint32(&o.POWERDOWN.Reg)&^(0x80000000)|value<<31)
}
func (o *ETHERNET_Type) GetPOWERDOWN_PD() uint32 {
	return (volatile.LoadUint32(&o.POWERDOWN.Reg) & 0x80000000) >> 31
}

// LCD controller Modification
type LCD_Type struct {
	TIMH         volatile.Register32 // 0x0
	TIMV         volatile.Register32 // 0x4
	POL          volatile.Register32 // 0x8
	LE           volatile.Register32 // 0xC
	UPBASE       volatile.Register32 // 0x10
	LPBASE       volatile.Register32 // 0x14
	CTRL         volatile.Register32 // 0x18
	INTMSK       volatile.Register32 // 0x1C
	INTRAW       volatile.Register32 // 0x20
	INTSTAT      volatile.Register32 // 0x24
	INTCLR       volatile.Register32 // 0x28
	UPCURR       volatile.Register32 // 0x2C
	LPCURR       volatile.Register32 // 0x30
	_            [460]byte
	PAL          [128]volatile.Register32 // 0x200
	_            [1024]byte
	CRSR_IMG     [256]volatile.Register32 // 0x800
	CRSR_CTRL    volatile.Register32      // 0xC00
	CRSR_CFG     volatile.Register32      // 0xC04
	CRSR_PAL0    volatile.Register32      // 0xC08
	CRSR_PAL1    volatile.Register32      // 0xC0C
	CRSR_XY      volatile.Register32      // 0xC10
	CRSR_CLIP    volatile.Register32      // 0xC14
	_            [8]byte
	CRSR_INTMSK  volatile.Register32 // 0xC20
	CRSR_INTCLR  volatile.Register32 // 0xC24
	CRSR_INTRAW  volatile.Register32 // 0xC28
	CRSR_INTSTAT volatile.Register32 // 0xC2C
}

// LCD.TIMH: Horizontal Timing Control register
func (o *LCD_Type) SetTIMH_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TIMH.Reg, volatile.LoadUint32(&o.TIMH.Reg)&^(0x3)|value)
}
func (o *LCD_Type) GetTIMH_RESERVED() uint32 {
	return volatile.LoadUint32(&o.TIMH.Reg) & 0x3
}
func (o *LCD_Type) SetTIMH_PPL(value uint32) {
	volatile.StoreUint32(&o.TIMH.Reg, volatile.LoadUint32(&o.TIMH.Reg)&^(0xfc)|value<<2)
}
func (o *LCD_Type) GetTIMH_PPL() uint32 {
	return (volatile.LoadUint32(&o.TIMH.Reg) & 0xfc) >> 2
}
func (o *LCD_Type) SetTIMH_HSW(value uint32) {
	volatile.StoreUint32(&o.TIMH.Reg, volatile.LoadUint32(&o.TIMH.Reg)&^(0xff00)|value<<8)
}
func (o *LCD_Type) GetTIMH_HSW() uint32 {
	return (volatile.LoadUint32(&o.TIMH.Reg) & 0xff00) >> 8
}
func (o *LCD_Type) SetTIMH_HFP(value uint32) {
	volatile.StoreUint32(&o.TIMH.Reg, volatile.LoadUint32(&o.TIMH.Reg)&^(0xff0000)|value<<16)
}
func (o *LCD_Type) GetTIMH_HFP() uint32 {
	return (volatile.LoadUint32(&o.TIMH.Reg) & 0xff0000) >> 16
}
func (o *LCD_Type) SetTIMH_HBP(value uint32) {
	volatile.StoreUint32(&o.TIMH.Reg, volatile.LoadUint32(&o.TIMH.Reg)&^(0xff000000)|value<<24)
}
func (o *LCD_Type) GetTIMH_HBP() uint32 {
	return (volatile.LoadUint32(&o.TIMH.Reg) & 0xff000000) >> 24
}

// LCD.TIMV: Vertical Timing Control register
func (o *LCD_Type) SetTIMV_LPP(value uint32) {
	volatile.StoreUint32(&o.TIMV.Reg, volatile.LoadUint32(&o.TIMV.Reg)&^(0x3ff)|value)
}
func (o *LCD_Type) GetTIMV_LPP() uint32 {
	return volatile.LoadUint32(&o.TIMV.Reg) & 0x3ff
}
func (o *LCD_Type) SetTIMV_VSW(value uint32) {
	volatile.StoreUint32(&o.TIMV.Reg, volatile.LoadUint32(&o.TIMV.Reg)&^(0xfc00)|value<<10)
}
func (o *LCD_Type) GetTIMV_VSW() uint32 {
	return (volatile.LoadUint32(&o.TIMV.Reg) & 0xfc00) >> 10
}
func (o *LCD_Type) SetTIMV_VFP(value uint32) {
	volatile.StoreUint32(&o.TIMV.Reg, volatile.LoadUint32(&o.TIMV.Reg)&^(0xff0000)|value<<16)
}
func (o *LCD_Type) GetTIMV_VFP() uint32 {
	return (volatile.LoadUint32(&o.TIMV.Reg) & 0xff0000) >> 16
}
func (o *LCD_Type) SetTIMV_VBP(value uint32) {
	volatile.StoreUint32(&o.TIMV.Reg, volatile.LoadUint32(&o.TIMV.Reg)&^(0xff000000)|value<<24)
}
func (o *LCD_Type) GetTIMV_VBP() uint32 {
	return (volatile.LoadUint32(&o.TIMV.Reg) & 0xff000000) >> 24
}

// LCD.POL: Clock and Signal Polarity Control register
func (o *LCD_Type) SetPOL_PCD_LO(value uint32) {
	volatile.StoreUint32(&o.POL.Reg, volatile.LoadUint32(&o.POL.Reg)&^(0x1f)|value)
}
func (o *LCD_Type) GetPOL_PCD_LO() uint32 {
	return volatile.LoadUint32(&o.POL.Reg) & 0x1f
}
func (o *LCD_Type) SetPOL_CLKSEL(value uint32) {
	volatile.StoreUint32(&o.POL.Reg, volatile.LoadUint32(&o.POL.Reg)&^(0x20)|value<<5)
}
func (o *LCD_Type) GetPOL_CLKSEL() uint32 {
	return (volatile.LoadUint32(&o.POL.Reg) & 0x20) >> 5
}
func (o *LCD_Type) SetPOL_ACB(value uint32) {
	volatile.StoreUint32(&o.POL.Reg, volatile.LoadUint32(&o.POL.Reg)&^(0x7c0)|value<<6)
}
func (o *LCD_Type) GetPOL_ACB() uint32 {
	return (volatile.LoadUint32(&o.POL.Reg) & 0x7c0) >> 6
}
func (o *LCD_Type) SetPOL_IVS(value uint32) {
	volatile.StoreUint32(&o.POL.Reg, volatile.LoadUint32(&o.POL.Reg)&^(0x800)|value<<11)
}
func (o *LCD_Type) GetPOL_IVS() uint32 {
	return (volatile.LoadUint32(&o.POL.Reg) & 0x800) >> 11
}
func (o *LCD_Type) SetPOL_IHS(value uint32) {
	volatile.StoreUint32(&o.POL.Reg, volatile.LoadUint32(&o.POL.Reg)&^(0x1000)|value<<12)
}
func (o *LCD_Type) GetPOL_IHS() uint32 {
	return (volatile.LoadUint32(&o.POL.Reg) & 0x1000) >> 12
}
func (o *LCD_Type) SetPOL_IPC(value uint32) {
	volatile.StoreUint32(&o.POL.Reg, volatile.LoadUint32(&o.POL.Reg)&^(0x2000)|value<<13)
}
func (o *LCD_Type) GetPOL_IPC() uint32 {
	return (volatile.LoadUint32(&o.POL.Reg) & 0x2000) >> 13
}
func (o *LCD_Type) SetPOL_IOE(value uint32) {
	volatile.StoreUint32(&o.POL.Reg, volatile.LoadUint32(&o.POL.Reg)&^(0x4000)|value<<14)
}
func (o *LCD_Type) GetPOL_IOE() uint32 {
	return (volatile.LoadUint32(&o.POL.Reg) & 0x4000) >> 14
}
func (o *LCD_Type) SetPOL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.POL.Reg, volatile.LoadUint32(&o.POL.Reg)&^(0x8000)|value<<15)
}
func (o *LCD_Type) GetPOL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.POL.Reg) & 0x8000) >> 15
}
func (o *LCD_Type) SetPOL_CPL(value uint32) {
	volatile.StoreUint32(&o.POL.Reg, volatile.LoadUint32(&o.POL.Reg)&^(0x3ff0000)|value<<16)
}
func (o *LCD_Type) GetPOL_CPL() uint32 {
	return (volatile.LoadUint32(&o.POL.Reg) & 0x3ff0000) >> 16
}
func (o *LCD_Type) SetPOL_BCD(value uint32) {
	volatile.StoreUint32(&o.POL.Reg, volatile.LoadUint32(&o.POL.Reg)&^(0x4000000)|value<<26)
}
func (o *LCD_Type) GetPOL_BCD() uint32 {
	return (volatile.LoadUint32(&o.POL.Reg) & 0x4000000) >> 26
}
func (o *LCD_Type) SetPOL_PCD_HI(value uint32) {
	volatile.StoreUint32(&o.POL.Reg, volatile.LoadUint32(&o.POL.Reg)&^(0xf8000000)|value<<27)
}
func (o *LCD_Type) GetPOL_PCD_HI() uint32 {
	return (volatile.LoadUint32(&o.POL.Reg) & 0xf8000000) >> 27
}

// LCD.LE: Line End Control register
func (o *LCD_Type) SetLE_LED(value uint32) {
	volatile.StoreUint32(&o.LE.Reg, volatile.LoadUint32(&o.LE.Reg)&^(0x7f)|value)
}
func (o *LCD_Type) GetLE_LED() uint32 {
	return volatile.LoadUint32(&o.LE.Reg) & 0x7f
}
func (o *LCD_Type) SetLE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.LE.Reg, volatile.LoadUint32(&o.LE.Reg)&^(0xff80)|value<<7)
}
func (o *LCD_Type) GetLE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.LE.Reg) & 0xff80) >> 7
}
func (o *LCD_Type) SetLE_LEE(value uint32) {
	volatile.StoreUint32(&o.LE.Reg, volatile.LoadUint32(&o.LE.Reg)&^(0x10000)|value<<16)
}
func (o *LCD_Type) GetLE_LEE() uint32 {
	return (volatile.LoadUint32(&o.LE.Reg) & 0x10000) >> 16
}
func (o *LCD_Type) SetLE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.LE.Reg, volatile.LoadUint32(&o.LE.Reg)&^(0xfffe0000)|value<<17)
}
func (o *LCD_Type) GetLE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.LE.Reg) & 0xfffe0000) >> 17
}

// LCD.UPBASE: Upper Panel Frame Base Address register
func (o *LCD_Type) SetUPBASE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.UPBASE.Reg, volatile.LoadUint32(&o.UPBASE.Reg)&^(0x7)|value)
}
func (o *LCD_Type) GetUPBASE_RESERVED() uint32 {
	return volatile.LoadUint32(&o.UPBASE.Reg) & 0x7
}
func (o *LCD_Type) SetUPBASE_LCDUPBASE(value uint32) {
	volatile.StoreUint32(&o.UPBASE.Reg, volatile.LoadUint32(&o.UPBASE.Reg)&^(0xfffffff8)|value<<3)
}
func (o *LCD_Type) GetUPBASE_LCDUPBASE() uint32 {
	return (volatile.LoadUint32(&o.UPBASE.Reg) & 0xfffffff8) >> 3
}

// LCD.LPBASE: Lower Panel Frame Base Address register
func (o *LCD_Type) SetLPBASE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.LPBASE.Reg, volatile.LoadUint32(&o.LPBASE.Reg)&^(0x7)|value)
}
func (o *LCD_Type) GetLPBASE_RESERVED() uint32 {
	return volatile.LoadUint32(&o.LPBASE.Reg) & 0x7
}
func (o *LCD_Type) SetLPBASE_LCDLPBASE(value uint32) {
	volatile.StoreUint32(&o.LPBASE.Reg, volatile.LoadUint32(&o.LPBASE.Reg)&^(0xfffffff8)|value<<3)
}
func (o *LCD_Type) GetLPBASE_LCDLPBASE() uint32 {
	return (volatile.LoadUint32(&o.LPBASE.Reg) & 0xfffffff8) >> 3
}

// LCD.CTRL: LCD Control register
func (o *LCD_Type) SetCTRL_LCDEN(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *LCD_Type) GetCTRL_LCDEN() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x1
}
func (o *LCD_Type) SetCTRL_LCDBPP(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xe)|value<<1)
}
func (o *LCD_Type) GetCTRL_LCDBPP() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xe) >> 1
}
func (o *LCD_Type) SetCTRL_LCDBW(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x10)|value<<4)
}
func (o *LCD_Type) GetCTRL_LCDBW() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x10) >> 4
}
func (o *LCD_Type) SetCTRL_LCDTFT(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x20)|value<<5)
}
func (o *LCD_Type) GetCTRL_LCDTFT() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x20) >> 5
}
func (o *LCD_Type) SetCTRL_LCDMONO8(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x40)|value<<6)
}
func (o *LCD_Type) GetCTRL_LCDMONO8() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x40) >> 6
}
func (o *LCD_Type) SetCTRL_LCDDUAL(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x80)|value<<7)
}
func (o *LCD_Type) GetCTRL_LCDDUAL() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x80) >> 7
}
func (o *LCD_Type) SetCTRL_BGR(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x100)|value<<8)
}
func (o *LCD_Type) GetCTRL_BGR() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x100) >> 8
}
func (o *LCD_Type) SetCTRL_BEBO(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x200)|value<<9)
}
func (o *LCD_Type) GetCTRL_BEBO() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x200) >> 9
}
func (o *LCD_Type) SetCTRL_BEPO(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x400)|value<<10)
}
func (o *LCD_Type) GetCTRL_BEPO() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x400) >> 10
}
func (o *LCD_Type) SetCTRL_LCDPWR(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x800)|value<<11)
}
func (o *LCD_Type) GetCTRL_LCDPWR() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x800) >> 11
}
func (o *LCD_Type) SetCTRL_LCDVCOMP(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x3000)|value<<12)
}
func (o *LCD_Type) GetCTRL_LCDVCOMP() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x3000) >> 12
}
func (o *LCD_Type) SetCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xc000)|value<<14)
}
func (o *LCD_Type) GetCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xc000) >> 14
}
func (o *LCD_Type) SetCTRL_WATERMARK(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x10000)|value<<16)
}
func (o *LCD_Type) GetCTRL_WATERMARK() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x10000) >> 16
}
func (o *LCD_Type) SetCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xfffe0000)|value<<17)
}
func (o *LCD_Type) GetCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xfffe0000) >> 17
}

// LCD.INTMSK: Interrupt Mask register
func (o *LCD_Type) SetINTMSK_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTMSK.Reg, volatile.LoadUint32(&o.INTMSK.Reg)&^(0x1)|value)
}
func (o *LCD_Type) GetINTMSK_RESERVED() uint32 {
	return volatile.LoadUint32(&o.INTMSK.Reg) & 0x1
}
func (o *LCD_Type) SetINTMSK_FUFIM(value uint32) {
	volatile.StoreUint32(&o.INTMSK.Reg, volatile.LoadUint32(&o.INTMSK.Reg)&^(0x2)|value<<1)
}
func (o *LCD_Type) GetINTMSK_FUFIM() uint32 {
	return (volatile.LoadUint32(&o.INTMSK.Reg) & 0x2) >> 1
}
func (o *LCD_Type) SetINTMSK_LNBUIM(value uint32) {
	volatile.StoreUint32(&o.INTMSK.Reg, volatile.LoadUint32(&o.INTMSK.Reg)&^(0x4)|value<<2)
}
func (o *LCD_Type) GetINTMSK_LNBUIM() uint32 {
	return (volatile.LoadUint32(&o.INTMSK.Reg) & 0x4) >> 2
}
func (o *LCD_Type) SetINTMSK_VCOMPIM(value uint32) {
	volatile.StoreUint32(&o.INTMSK.Reg, volatile.LoadUint32(&o.INTMSK.Reg)&^(0x8)|value<<3)
}
func (o *LCD_Type) GetINTMSK_VCOMPIM() uint32 {
	return (volatile.LoadUint32(&o.INTMSK.Reg) & 0x8) >> 3
}
func (o *LCD_Type) SetINTMSK_BERIM(value uint32) {
	volatile.StoreUint32(&o.INTMSK.Reg, volatile.LoadUint32(&o.INTMSK.Reg)&^(0x10)|value<<4)
}
func (o *LCD_Type) GetINTMSK_BERIM() uint32 {
	return (volatile.LoadUint32(&o.INTMSK.Reg) & 0x10) >> 4
}
func (o *LCD_Type) SetINTMSK_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTMSK.Reg, volatile.LoadUint32(&o.INTMSK.Reg)&^(0xffffffe0)|value<<5)
}
func (o *LCD_Type) GetINTMSK_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTMSK.Reg) & 0xffffffe0) >> 5
}

// LCD.INTRAW: Raw Interrupt Status register
func (o *LCD_Type) SetINTRAW_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTRAW.Reg, volatile.LoadUint32(&o.INTRAW.Reg)&^(0x1)|value)
}
func (o *LCD_Type) GetINTRAW_RESERVED() uint32 {
	return volatile.LoadUint32(&o.INTRAW.Reg) & 0x1
}
func (o *LCD_Type) SetINTRAW_FUFRIS(value uint32) {
	volatile.StoreUint32(&o.INTRAW.Reg, volatile.LoadUint32(&o.INTRAW.Reg)&^(0x2)|value<<1)
}
func (o *LCD_Type) GetINTRAW_FUFRIS() uint32 {
	return (volatile.LoadUint32(&o.INTRAW.Reg) & 0x2) >> 1
}
func (o *LCD_Type) SetINTRAW_LNBURIS(value uint32) {
	volatile.StoreUint32(&o.INTRAW.Reg, volatile.LoadUint32(&o.INTRAW.Reg)&^(0x4)|value<<2)
}
func (o *LCD_Type) GetINTRAW_LNBURIS() uint32 {
	return (volatile.LoadUint32(&o.INTRAW.Reg) & 0x4) >> 2
}
func (o *LCD_Type) SetINTRAW_VCOMPRIS(value uint32) {
	volatile.StoreUint32(&o.INTRAW.Reg, volatile.LoadUint32(&o.INTRAW.Reg)&^(0x8)|value<<3)
}
func (o *LCD_Type) GetINTRAW_VCOMPRIS() uint32 {
	return (volatile.LoadUint32(&o.INTRAW.Reg) & 0x8) >> 3
}
func (o *LCD_Type) SetINTRAW_BERRAW(value uint32) {
	volatile.StoreUint32(&o.INTRAW.Reg, volatile.LoadUint32(&o.INTRAW.Reg)&^(0x10)|value<<4)
}
func (o *LCD_Type) GetINTRAW_BERRAW() uint32 {
	return (volatile.LoadUint32(&o.INTRAW.Reg) & 0x10) >> 4
}
func (o *LCD_Type) SetINTRAW_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTRAW.Reg, volatile.LoadUint32(&o.INTRAW.Reg)&^(0xffffffe0)|value<<5)
}
func (o *LCD_Type) GetINTRAW_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTRAW.Reg) & 0xffffffe0) >> 5
}

// LCD.INTSTAT: Masked Interrupt Status register
func (o *LCD_Type) SetINTSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x1)|value)
}
func (o *LCD_Type) GetINTSTAT_RESERVED() uint32 {
	return volatile.LoadUint32(&o.INTSTAT.Reg) & 0x1
}
func (o *LCD_Type) SetINTSTAT_FUFMIS(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x2)|value<<1)
}
func (o *LCD_Type) GetINTSTAT_FUFMIS() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x2) >> 1
}
func (o *LCD_Type) SetINTSTAT_LNBUMIS(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x4)|value<<2)
}
func (o *LCD_Type) GetINTSTAT_LNBUMIS() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x4) >> 2
}
func (o *LCD_Type) SetINTSTAT_VCOMPMIS(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x8)|value<<3)
}
func (o *LCD_Type) GetINTSTAT_VCOMPMIS() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x8) >> 3
}
func (o *LCD_Type) SetINTSTAT_BERMIS(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x10)|value<<4)
}
func (o *LCD_Type) GetINTSTAT_BERMIS() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x10) >> 4
}
func (o *LCD_Type) SetINTSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0xffffffe0)|value<<5)
}
func (o *LCD_Type) GetINTSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0xffffffe0) >> 5
}

// LCD.INTCLR: Interrupt Clear register
func (o *LCD_Type) SetINTCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTCLR.Reg, volatile.LoadUint32(&o.INTCLR.Reg)&^(0x1)|value)
}
func (o *LCD_Type) GetINTCLR_RESERVED() uint32 {
	return volatile.LoadUint32(&o.INTCLR.Reg) & 0x1
}
func (o *LCD_Type) SetINTCLR_FUFIC(value uint32) {
	volatile.StoreUint32(&o.INTCLR.Reg, volatile.LoadUint32(&o.INTCLR.Reg)&^(0x2)|value<<1)
}
func (o *LCD_Type) GetINTCLR_FUFIC() uint32 {
	return (volatile.LoadUint32(&o.INTCLR.Reg) & 0x2) >> 1
}
func (o *LCD_Type) SetINTCLR_LNBUIC(value uint32) {
	volatile.StoreUint32(&o.INTCLR.Reg, volatile.LoadUint32(&o.INTCLR.Reg)&^(0x4)|value<<2)
}
func (o *LCD_Type) GetINTCLR_LNBUIC() uint32 {
	return (volatile.LoadUint32(&o.INTCLR.Reg) & 0x4) >> 2
}
func (o *LCD_Type) SetINTCLR_VCOMPIC(value uint32) {
	volatile.StoreUint32(&o.INTCLR.Reg, volatile.LoadUint32(&o.INTCLR.Reg)&^(0x8)|value<<3)
}
func (o *LCD_Type) GetINTCLR_VCOMPIC() uint32 {
	return (volatile.LoadUint32(&o.INTCLR.Reg) & 0x8) >> 3
}
func (o *LCD_Type) SetINTCLR_BERIC(value uint32) {
	volatile.StoreUint32(&o.INTCLR.Reg, volatile.LoadUint32(&o.INTCLR.Reg)&^(0x10)|value<<4)
}
func (o *LCD_Type) GetINTCLR_BERIC() uint32 {
	return (volatile.LoadUint32(&o.INTCLR.Reg) & 0x10) >> 4
}
func (o *LCD_Type) SetINTCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTCLR.Reg, volatile.LoadUint32(&o.INTCLR.Reg)&^(0xffffffe0)|value<<5)
}
func (o *LCD_Type) GetINTCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTCLR.Reg) & 0xffffffe0) >> 5
}

// LCD.UPCURR: Upper Panel Current Address Value register
func (o *LCD_Type) SetUPCURR(value uint32) {
	volatile.StoreUint32(&o.UPCURR.Reg, value)
}
func (o *LCD_Type) GetUPCURR() uint32 {
	return volatile.LoadUint32(&o.UPCURR.Reg)
}

// LCD.LPCURR: Lower Panel Current Address Value register
func (o *LCD_Type) SetLPCURR(value uint32) {
	volatile.StoreUint32(&o.LPCURR.Reg, value)
}
func (o *LCD_Type) GetLPCURR() uint32 {
	return volatile.LoadUint32(&o.LPCURR.Reg)
}

// LCD.PAL: 256x16-bit Color Palette registers
func (o *LCD_Type) SetPAL_R04_0(idx int, value uint32) {
	volatile.StoreUint32(&o.PAL[idx].Reg, volatile.LoadUint32(&o.PAL[idx].Reg)&^(0x1f)|value)
}
func (o *LCD_Type) GetPAL_R04_0(idx int) uint32 {
	return volatile.LoadUint32(&o.PAL[idx].Reg) & 0x1f
}
func (o *LCD_Type) SetPAL_G04_0(idx int, value uint32) {
	volatile.StoreUint32(&o.PAL[idx].Reg, volatile.LoadUint32(&o.PAL[idx].Reg)&^(0x3e0)|value<<5)
}
func (o *LCD_Type) GetPAL_G04_0(idx int) uint32 {
	return (volatile.LoadUint32(&o.PAL[idx].Reg) & 0x3e0) >> 5
}
func (o *LCD_Type) SetPAL_B04_0(idx int, value uint32) {
	volatile.StoreUint32(&o.PAL[idx].Reg, volatile.LoadUint32(&o.PAL[idx].Reg)&^(0x7c00)|value<<10)
}
func (o *LCD_Type) GetPAL_B04_0(idx int) uint32 {
	return (volatile.LoadUint32(&o.PAL[idx].Reg) & 0x7c00) >> 10
}
func (o *LCD_Type) SetPAL_I0(idx int, value uint32) {
	volatile.StoreUint32(&o.PAL[idx].Reg, volatile.LoadUint32(&o.PAL[idx].Reg)&^(0x8000)|value<<15)
}
func (o *LCD_Type) GetPAL_I0(idx int) uint32 {
	return (volatile.LoadUint32(&o.PAL[idx].Reg) & 0x8000) >> 15
}
func (o *LCD_Type) SetPAL_R14_0(idx int, value uint32) {
	volatile.StoreUint32(&o.PAL[idx].Reg, volatile.LoadUint32(&o.PAL[idx].Reg)&^(0x1f0000)|value<<16)
}
func (o *LCD_Type) GetPAL_R14_0(idx int) uint32 {
	return (volatile.LoadUint32(&o.PAL[idx].Reg) & 0x1f0000) >> 16
}
func (o *LCD_Type) SetPAL_G14_0(idx int, value uint32) {
	volatile.StoreUint32(&o.PAL[idx].Reg, volatile.LoadUint32(&o.PAL[idx].Reg)&^(0x3e00000)|value<<21)
}
func (o *LCD_Type) GetPAL_G14_0(idx int) uint32 {
	return (volatile.LoadUint32(&o.PAL[idx].Reg) & 0x3e00000) >> 21
}
func (o *LCD_Type) SetPAL_B14_0(idx int, value uint32) {
	volatile.StoreUint32(&o.PAL[idx].Reg, volatile.LoadUint32(&o.PAL[idx].Reg)&^(0x7c000000)|value<<26)
}
func (o *LCD_Type) GetPAL_B14_0(idx int) uint32 {
	return (volatile.LoadUint32(&o.PAL[idx].Reg) & 0x7c000000) >> 26
}
func (o *LCD_Type) SetPAL_I1(idx int, value uint32) {
	volatile.StoreUint32(&o.PAL[idx].Reg, volatile.LoadUint32(&o.PAL[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *LCD_Type) GetPAL_I1(idx int) uint32 {
	return (volatile.LoadUint32(&o.PAL[idx].Reg) & 0x80000000) >> 31
}

// LCD.CRSR_IMG: Cursor Image registers
func (o *LCD_Type) SetCRSR_IMG(idx int, value uint32) {
	volatile.StoreUint32(&o.CRSR_IMG[idx].Reg, value)
}
func (o *LCD_Type) GetCRSR_IMG(idx int) uint32 {
	return volatile.LoadUint32(&o.CRSR_IMG[idx].Reg)
}

// LCD.CRSR_CTRL: Cursor Control register
func (o *LCD_Type) SetCRSR_CTRL_CRSRON(value uint32) {
	volatile.StoreUint32(&o.CRSR_CTRL.Reg, volatile.LoadUint32(&o.CRSR_CTRL.Reg)&^(0x1)|value)
}
func (o *LCD_Type) GetCRSR_CTRL_CRSRON() uint32 {
	return volatile.LoadUint32(&o.CRSR_CTRL.Reg) & 0x1
}
func (o *LCD_Type) SetCRSR_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CRSR_CTRL.Reg, volatile.LoadUint32(&o.CRSR_CTRL.Reg)&^(0xe)|value<<1)
}
func (o *LCD_Type) GetCRSR_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CRSR_CTRL.Reg) & 0xe) >> 1
}
func (o *LCD_Type) SetCRSR_CTRL_CRSRNUM1_0(value uint32) {
	volatile.StoreUint32(&o.CRSR_CTRL.Reg, volatile.LoadUint32(&o.CRSR_CTRL.Reg)&^(0x30)|value<<4)
}
func (o *LCD_Type) GetCRSR_CTRL_CRSRNUM1_0() uint32 {
	return (volatile.LoadUint32(&o.CRSR_CTRL.Reg) & 0x30) >> 4
}
func (o *LCD_Type) SetCRSR_CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CRSR_CTRL.Reg, volatile.LoadUint32(&o.CRSR_CTRL.Reg)&^(0xffffffc0)|value<<6)
}
func (o *LCD_Type) GetCRSR_CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CRSR_CTRL.Reg) & 0xffffffc0) >> 6
}

// LCD.CRSR_CFG: Cursor Configuration register
func (o *LCD_Type) SetCRSR_CFG_CRSRSIZE(value uint32) {
	volatile.StoreUint32(&o.CRSR_CFG.Reg, volatile.LoadUint32(&o.CRSR_CFG.Reg)&^(0x1)|value)
}
func (o *LCD_Type) GetCRSR_CFG_CRSRSIZE() uint32 {
	return volatile.LoadUint32(&o.CRSR_CFG.Reg) & 0x1
}
func (o *LCD_Type) SetCRSR_CFG_FRAMESYNC(value uint32) {
	volatile.StoreUint32(&o.CRSR_CFG.Reg, volatile.LoadUint32(&o.CRSR_CFG.Reg)&^(0x2)|value<<1)
}
func (o *LCD_Type) GetCRSR_CFG_FRAMESYNC() uint32 {
	return (volatile.LoadUint32(&o.CRSR_CFG.Reg) & 0x2) >> 1
}
func (o *LCD_Type) SetCRSR_CFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CRSR_CFG.Reg, volatile.LoadUint32(&o.CRSR_CFG.Reg)&^(0xfffffffc)|value<<2)
}
func (o *LCD_Type) GetCRSR_CFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CRSR_CFG.Reg) & 0xfffffffc) >> 2
}

// LCD.CRSR_PAL0: Cursor Palette register 0
func (o *LCD_Type) SetCRSR_PAL0_RED(value uint32) {
	volatile.StoreUint32(&o.CRSR_PAL0.Reg, volatile.LoadUint32(&o.CRSR_PAL0.Reg)&^(0xff)|value)
}
func (o *LCD_Type) GetCRSR_PAL0_RED() uint32 {
	return volatile.LoadUint32(&o.CRSR_PAL0.Reg) & 0xff
}
func (o *LCD_Type) SetCRSR_PAL0_GREEN(value uint32) {
	volatile.StoreUint32(&o.CRSR_PAL0.Reg, volatile.LoadUint32(&o.CRSR_PAL0.Reg)&^(0xff00)|value<<8)
}
func (o *LCD_Type) GetCRSR_PAL0_GREEN() uint32 {
	return (volatile.LoadUint32(&o.CRSR_PAL0.Reg) & 0xff00) >> 8
}
func (o *LCD_Type) SetCRSR_PAL0_BLUE(value uint32) {
	volatile.StoreUint32(&o.CRSR_PAL0.Reg, volatile.LoadUint32(&o.CRSR_PAL0.Reg)&^(0xff0000)|value<<16)
}
func (o *LCD_Type) GetCRSR_PAL0_BLUE() uint32 {
	return (volatile.LoadUint32(&o.CRSR_PAL0.Reg) & 0xff0000) >> 16
}
func (o *LCD_Type) SetCRSR_PAL0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CRSR_PAL0.Reg, volatile.LoadUint32(&o.CRSR_PAL0.Reg)&^(0xff000000)|value<<24)
}
func (o *LCD_Type) GetCRSR_PAL0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CRSR_PAL0.Reg) & 0xff000000) >> 24
}

// LCD.CRSR_PAL1: Cursor Palette register 1
func (o *LCD_Type) SetCRSR_PAL1_RED(value uint32) {
	volatile.StoreUint32(&o.CRSR_PAL1.Reg, volatile.LoadUint32(&o.CRSR_PAL1.Reg)&^(0xff)|value)
}
func (o *LCD_Type) GetCRSR_PAL1_RED() uint32 {
	return volatile.LoadUint32(&o.CRSR_PAL1.Reg) & 0xff
}
func (o *LCD_Type) SetCRSR_PAL1_GREEN(value uint32) {
	volatile.StoreUint32(&o.CRSR_PAL1.Reg, volatile.LoadUint32(&o.CRSR_PAL1.Reg)&^(0xff00)|value<<8)
}
func (o *LCD_Type) GetCRSR_PAL1_GREEN() uint32 {
	return (volatile.LoadUint32(&o.CRSR_PAL1.Reg) & 0xff00) >> 8
}
func (o *LCD_Type) SetCRSR_PAL1_BLUE(value uint32) {
	volatile.StoreUint32(&o.CRSR_PAL1.Reg, volatile.LoadUint32(&o.CRSR_PAL1.Reg)&^(0xff0000)|value<<16)
}
func (o *LCD_Type) GetCRSR_PAL1_BLUE() uint32 {
	return (volatile.LoadUint32(&o.CRSR_PAL1.Reg) & 0xff0000) >> 16
}
func (o *LCD_Type) SetCRSR_PAL1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CRSR_PAL1.Reg, volatile.LoadUint32(&o.CRSR_PAL1.Reg)&^(0xff000000)|value<<24)
}
func (o *LCD_Type) GetCRSR_PAL1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CRSR_PAL1.Reg) & 0xff000000) >> 24
}

// LCD.CRSR_XY: Cursor XY Position register
func (o *LCD_Type) SetCRSR_XY_CRSRX(value uint32) {
	volatile.StoreUint32(&o.CRSR_XY.Reg, volatile.LoadUint32(&o.CRSR_XY.Reg)&^(0x3ff)|value)
}
func (o *LCD_Type) GetCRSR_XY_CRSRX() uint32 {
	return volatile.LoadUint32(&o.CRSR_XY.Reg) & 0x3ff
}
func (o *LCD_Type) SetCRSR_XY_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CRSR_XY.Reg, volatile.LoadUint32(&o.CRSR_XY.Reg)&^(0xfc00)|value<<10)
}
func (o *LCD_Type) GetCRSR_XY_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CRSR_XY.Reg) & 0xfc00) >> 10
}
func (o *LCD_Type) SetCRSR_XY_CRSRY(value uint32) {
	volatile.StoreUint32(&o.CRSR_XY.Reg, volatile.LoadUint32(&o.CRSR_XY.Reg)&^(0x3ff0000)|value<<16)
}
func (o *LCD_Type) GetCRSR_XY_CRSRY() uint32 {
	return (volatile.LoadUint32(&o.CRSR_XY.Reg) & 0x3ff0000) >> 16
}
func (o *LCD_Type) SetCRSR_XY_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CRSR_XY.Reg, volatile.LoadUint32(&o.CRSR_XY.Reg)&^(0xfc000000)|value<<26)
}
func (o *LCD_Type) GetCRSR_XY_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CRSR_XY.Reg) & 0xfc000000) >> 26
}

// LCD.CRSR_CLIP: Cursor Clip Position register
func (o *LCD_Type) SetCRSR_CLIP_CRSRCLIPX(value uint32) {
	volatile.StoreUint32(&o.CRSR_CLIP.Reg, volatile.LoadUint32(&o.CRSR_CLIP.Reg)&^(0x3f)|value)
}
func (o *LCD_Type) GetCRSR_CLIP_CRSRCLIPX() uint32 {
	return volatile.LoadUint32(&o.CRSR_CLIP.Reg) & 0x3f
}
func (o *LCD_Type) SetCRSR_CLIP_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CRSR_CLIP.Reg, volatile.LoadUint32(&o.CRSR_CLIP.Reg)&^(0xc0)|value<<6)
}
func (o *LCD_Type) GetCRSR_CLIP_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CRSR_CLIP.Reg) & 0xc0) >> 6
}
func (o *LCD_Type) SetCRSR_CLIP_CRSRCLIPY(value uint32) {
	volatile.StoreUint32(&o.CRSR_CLIP.Reg, volatile.LoadUint32(&o.CRSR_CLIP.Reg)&^(0x3f00)|value<<8)
}
func (o *LCD_Type) GetCRSR_CLIP_CRSRCLIPY() uint32 {
	return (volatile.LoadUint32(&o.CRSR_CLIP.Reg) & 0x3f00) >> 8
}
func (o *LCD_Type) SetCRSR_CLIP_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CRSR_CLIP.Reg, volatile.LoadUint32(&o.CRSR_CLIP.Reg)&^(0xffffc000)|value<<14)
}
func (o *LCD_Type) GetCRSR_CLIP_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CRSR_CLIP.Reg) & 0xffffc000) >> 14
}

// LCD.CRSR_INTMSK: Cursor Interrupt Mask register
func (o *LCD_Type) SetCRSR_INTMSK_CRSRIM(value uint32) {
	volatile.StoreUint32(&o.CRSR_INTMSK.Reg, volatile.LoadUint32(&o.CRSR_INTMSK.Reg)&^(0x1)|value)
}
func (o *LCD_Type) GetCRSR_INTMSK_CRSRIM() uint32 {
	return volatile.LoadUint32(&o.CRSR_INTMSK.Reg) & 0x1
}
func (o *LCD_Type) SetCRSR_INTMSK_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CRSR_INTMSK.Reg, volatile.LoadUint32(&o.CRSR_INTMSK.Reg)&^(0xfffffffe)|value<<1)
}
func (o *LCD_Type) GetCRSR_INTMSK_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CRSR_INTMSK.Reg) & 0xfffffffe) >> 1
}

// LCD.CRSR_INTCLR: Cursor Interrupt Clear register
func (o *LCD_Type) SetCRSR_INTCLR_CRSRIC(value uint32) {
	volatile.StoreUint32(&o.CRSR_INTCLR.Reg, volatile.LoadUint32(&o.CRSR_INTCLR.Reg)&^(0x1)|value)
}
func (o *LCD_Type) GetCRSR_INTCLR_CRSRIC() uint32 {
	return volatile.LoadUint32(&o.CRSR_INTCLR.Reg) & 0x1
}
func (o *LCD_Type) SetCRSR_INTCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CRSR_INTCLR.Reg, volatile.LoadUint32(&o.CRSR_INTCLR.Reg)&^(0xfffffffe)|value<<1)
}
func (o *LCD_Type) GetCRSR_INTCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CRSR_INTCLR.Reg) & 0xfffffffe) >> 1
}

// LCD.CRSR_INTRAW: Cursor Raw Interrupt Status register
func (o *LCD_Type) SetCRSR_INTRAW_CRSRRIS(value uint32) {
	volatile.StoreUint32(&o.CRSR_INTRAW.Reg, volatile.LoadUint32(&o.CRSR_INTRAW.Reg)&^(0x1)|value)
}
func (o *LCD_Type) GetCRSR_INTRAW_CRSRRIS() uint32 {
	return volatile.LoadUint32(&o.CRSR_INTRAW.Reg) & 0x1
}
func (o *LCD_Type) SetCRSR_INTRAW_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CRSR_INTRAW.Reg, volatile.LoadUint32(&o.CRSR_INTRAW.Reg)&^(0xfffffffe)|value<<1)
}
func (o *LCD_Type) GetCRSR_INTRAW_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CRSR_INTRAW.Reg) & 0xfffffffe) >> 1
}

// LCD.CRSR_INTSTAT: Cursor Masked Interrupt Status register
func (o *LCD_Type) SetCRSR_INTSTAT_CRSRMIS(value uint32) {
	volatile.StoreUint32(&o.CRSR_INTSTAT.Reg, volatile.LoadUint32(&o.CRSR_INTSTAT.Reg)&^(0x1)|value)
}
func (o *LCD_Type) GetCRSR_INTSTAT_CRSRMIS() uint32 {
	return volatile.LoadUint32(&o.CRSR_INTSTAT.Reg) & 0x1
}
func (o *LCD_Type) SetCRSR_INTSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CRSR_INTSTAT.Reg, volatile.LoadUint32(&o.CRSR_INTSTAT.Reg)&^(0xfffffffe)|value<<1)
}
func (o *LCD_Type) GetCRSR_INTSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CRSR_INTSTAT.Reg) & 0xfffffffe) >> 1
}

// USB device controller
type USB_Type struct {
	_            [220]byte
	RXPLEN       volatile.Register32 // 0xDC
	_            [32]byte
	INTST        volatile.Register32 // 0x100
	INTEN        volatile.Register32 // 0x104
	INTSET       volatile.Register32 // 0x108
	INCLR        volatile.Register32 // 0x10C
	PORTSEL      volatile.Register32 // 0x110
	TMR          volatile.Register32 // 0x114
	_            [232]byte
	DEVINTST     volatile.Register32 // 0x200
	DEVINTEN     volatile.Register32 // 0x204
	DEVINTCLR    volatile.Register32 // 0x208
	DEVINTSET    volatile.Register32 // 0x20C
	CMDCODE      volatile.Register32 // 0x210
	CMDDATA      volatile.Register32 // 0x214
	RXDATA       volatile.Register32 // 0x218
	TXDATA       volatile.Register32 // 0x21C
	_            [4]byte
	TXPLEN       volatile.Register32 // 0x224
	CTRL         volatile.Register32 // 0x228
	DEVINTPRI    volatile.Register32 // 0x22C
	EPINTST      volatile.Register32 // 0x230
	EPINTEN      volatile.Register32 // 0x234
	EPINTCLR     volatile.Register32 // 0x238
	EPINTSET     volatile.Register32 // 0x23C
	EPINTPRI     volatile.Register32 // 0x240
	REEP         volatile.Register32 // 0x244
	EPIN         volatile.Register32 // 0x248
	MAXPSIZE     volatile.Register32 // 0x24C
	DMARST       volatile.Register32 // 0x250
	DMARCLR      volatile.Register32 // 0x254
	DMARSET      volatile.Register32 // 0x258
	_            [36]byte
	UDCAH        volatile.Register32 // 0x280
	EPDMAST      volatile.Register32 // 0x284
	EPDMAEN      volatile.Register32 // 0x288
	EPDMADIS     volatile.Register32 // 0x28C
	DMAINTST     volatile.Register32 // 0x290
	DMAINTEN     volatile.Register32 // 0x294
	_            [8]byte
	EOTINTST     volatile.Register32 // 0x2A0
	EOTINTCLR    volatile.Register32 // 0x2A4
	EOTINTSET    volatile.Register32 // 0x2A8
	NDDRINTST    volatile.Register32 // 0x2AC
	NDDRINTCLR   volatile.Register32 // 0x2B0
	NDDRINTSET   volatile.Register32 // 0x2B4
	SYSERRINTST  volatile.Register32 // 0x2B8
	SYSERRINTCLR volatile.Register32 // 0x2BC
	SYSERRINTSET volatile.Register32 // 0x2C0
	_            [60]byte
	I2C_RX       volatile.Register32 // 0x300
	I2C_STS      volatile.Register32 // 0x304
	I2C_CTL      volatile.Register32 // 0x308
	I2C_CLKHI    volatile.Register32 // 0x30C
	I2C_CLKLO    volatile.Register32 // 0x310
	_            [3296]byte
	CLKCTRL      volatile.Register32 // 0xFF4
	OTGClkSt     volatile.Register32 // 0xFF8
}

// USB.RXPLEN: USB Receive Packet Length
func (o *USB_Type) SetRXPLEN_PKT_LNGTH(value uint32) {
	volatile.StoreUint32(&o.RXPLEN.Reg, volatile.LoadUint32(&o.RXPLEN.Reg)&^(0x3ff)|value)
}
func (o *USB_Type) GetRXPLEN_PKT_LNGTH() uint32 {
	return volatile.LoadUint32(&o.RXPLEN.Reg) & 0x3ff
}
func (o *USB_Type) SetRXPLEN_DV(value uint32) {
	volatile.StoreUint32(&o.RXPLEN.Reg, volatile.LoadUint32(&o.RXPLEN.Reg)&^(0x400)|value<<10)
}
func (o *USB_Type) GetRXPLEN_DV() uint32 {
	return (volatile.LoadUint32(&o.RXPLEN.Reg) & 0x400) >> 10
}
func (o *USB_Type) SetRXPLEN_PKT_RDY(value uint32) {
	volatile.StoreUint32(&o.RXPLEN.Reg, volatile.LoadUint32(&o.RXPLEN.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetRXPLEN_PKT_RDY() uint32 {
	return (volatile.LoadUint32(&o.RXPLEN.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetRXPLEN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RXPLEN.Reg, volatile.LoadUint32(&o.RXPLEN.Reg)&^(0xfffff000)|value<<12)
}
func (o *USB_Type) GetRXPLEN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RXPLEN.Reg) & 0xfffff000) >> 12
}

// USB.INTST: OTG Interrupt Status
func (o *USB_Type) SetINTST_TMR(value uint32) {
	volatile.StoreUint32(&o.INTST.Reg, volatile.LoadUint32(&o.INTST.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetINTST_TMR() uint32 {
	return volatile.LoadUint32(&o.INTST.Reg) & 0x1
}
func (o *USB_Type) SetINTST_REMOVE_PU(value uint32) {
	volatile.StoreUint32(&o.INTST.Reg, volatile.LoadUint32(&o.INTST.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetINTST_REMOVE_PU() uint32 {
	return (volatile.LoadUint32(&o.INTST.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetINTST_HNP_FAILURE(value uint32) {
	volatile.StoreUint32(&o.INTST.Reg, volatile.LoadUint32(&o.INTST.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetINTST_HNP_FAILURE() uint32 {
	return (volatile.LoadUint32(&o.INTST.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetINTST_HNP_SUCCESS(value uint32) {
	volatile.StoreUint32(&o.INTST.Reg, volatile.LoadUint32(&o.INTST.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetINTST_HNP_SUCCESS() uint32 {
	return (volatile.LoadUint32(&o.INTST.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetINTST_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTST.Reg, volatile.LoadUint32(&o.INTST.Reg)&^(0xfffffff0)|value<<4)
}
func (o *USB_Type) GetINTST_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTST.Reg) & 0xfffffff0) >> 4
}

// USB.INTEN: OTG Interrupt Enable
func (o *USB_Type) SetINTEN_TMR_EN(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetINTEN_TMR_EN() uint32 {
	return volatile.LoadUint32(&o.INTEN.Reg) & 0x1
}
func (o *USB_Type) SetINTEN_REMOVE_PU_EN(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetINTEN_REMOVE_PU_EN() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetINTEN_HNP_FAILURE_EN(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetINTEN_HNP_FAILURE_EN() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetINTEN_HNP_SUCCES_EN(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetINTEN_HNP_SUCCES_EN() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetINTEN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0xfffffff0)|value<<4)
}
func (o *USB_Type) GetINTEN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0xfffffff0) >> 4
}

// USB.INTSET: OTG Interrupt Set
func (o *USB_Type) SetINTSET_TMR_SET(value uint32) {
	volatile.StoreUint32(&o.INTSET.Reg, volatile.LoadUint32(&o.INTSET.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetINTSET_TMR_SET() uint32 {
	return volatile.LoadUint32(&o.INTSET.Reg) & 0x1
}
func (o *USB_Type) SetINTSET_REMOVE_PU_SET(value uint32) {
	volatile.StoreUint32(&o.INTSET.Reg, volatile.LoadUint32(&o.INTSET.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetINTSET_REMOVE_PU_SET() uint32 {
	return (volatile.LoadUint32(&o.INTSET.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetINTSET_HNP_FAILURE_SET(value uint32) {
	volatile.StoreUint32(&o.INTSET.Reg, volatile.LoadUint32(&o.INTSET.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetINTSET_HNP_FAILURE_SET() uint32 {
	return (volatile.LoadUint32(&o.INTSET.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetINTSET_HNP_SUCCES_SET(value uint32) {
	volatile.StoreUint32(&o.INTSET.Reg, volatile.LoadUint32(&o.INTSET.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetINTSET_HNP_SUCCES_SET() uint32 {
	return (volatile.LoadUint32(&o.INTSET.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetINTSET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTSET.Reg, volatile.LoadUint32(&o.INTSET.Reg)&^(0xfffffff0)|value<<4)
}
func (o *USB_Type) GetINTSET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTSET.Reg) & 0xfffffff0) >> 4
}

// USB.INCLR: OTG Interrupt Clear
func (o *USB_Type) SetINCLR_TMR_CLR(value uint32) {
	volatile.StoreUint32(&o.INCLR.Reg, volatile.LoadUint32(&o.INCLR.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetINCLR_TMR_CLR() uint32 {
	return volatile.LoadUint32(&o.INCLR.Reg) & 0x1
}
func (o *USB_Type) SetINCLR_REMOVE_PU_CLR(value uint32) {
	volatile.StoreUint32(&o.INCLR.Reg, volatile.LoadUint32(&o.INCLR.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetINCLR_REMOVE_PU_CLR() uint32 {
	return (volatile.LoadUint32(&o.INCLR.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetINCLR_HNP_FAILURE_CLR(value uint32) {
	volatile.StoreUint32(&o.INCLR.Reg, volatile.LoadUint32(&o.INCLR.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetINCLR_HNP_FAILURE_CLR() uint32 {
	return (volatile.LoadUint32(&o.INCLR.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetINCLR_HNP_SUCCES_CLR(value uint32) {
	volatile.StoreUint32(&o.INCLR.Reg, volatile.LoadUint32(&o.INCLR.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetINCLR_HNP_SUCCES_CLR() uint32 {
	return (volatile.LoadUint32(&o.INCLR.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetINCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INCLR.Reg, volatile.LoadUint32(&o.INCLR.Reg)&^(0xfffffff0)|value<<4)
}
func (o *USB_Type) GetINCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INCLR.Reg) & 0xfffffff0) >> 4
}

// USB.PORTSEL: USB Port Select. The USBPortSel register is identical to the OTGStCtrl register (see Section 15.8.6). In device-only operations only bits 0 and 1 of this register are used to control the routing of USB pins to Port 1 or Port 2.
func (o *USB_Type) SetPORTSEL(value uint32) {
	volatile.StoreUint32(&o.PORTSEL.Reg, volatile.LoadUint32(&o.PORTSEL.Reg)&^(0x3)|value)
}
func (o *USB_Type) GetPORTSEL() uint32 {
	return volatile.LoadUint32(&o.PORTSEL.Reg) & 0x3
}
func (o *USB_Type) SetPORTSEL_TMR_SCALE(value uint32) {
	volatile.StoreUint32(&o.PORTSEL.Reg, volatile.LoadUint32(&o.PORTSEL.Reg)&^(0xc)|value<<2)
}
func (o *USB_Type) GetPORTSEL_TMR_SCALE() uint32 {
	return (volatile.LoadUint32(&o.PORTSEL.Reg) & 0xc) >> 2
}
func (o *USB_Type) SetPORTSEL_TMR_MODE(value uint32) {
	volatile.StoreUint32(&o.PORTSEL.Reg, volatile.LoadUint32(&o.PORTSEL.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetPORTSEL_TMR_MODE() uint32 {
	return (volatile.LoadUint32(&o.PORTSEL.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetPORTSEL_TMR_EN(value uint32) {
	volatile.StoreUint32(&o.PORTSEL.Reg, volatile.LoadUint32(&o.PORTSEL.Reg)&^(0x20)|value<<5)
}
func (o *USB_Type) GetPORTSEL_TMR_EN() uint32 {
	return (volatile.LoadUint32(&o.PORTSEL.Reg) & 0x20) >> 5
}
func (o *USB_Type) SetPORTSEL_TMR_RST(value uint32) {
	volatile.StoreUint32(&o.PORTSEL.Reg, volatile.LoadUint32(&o.PORTSEL.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetPORTSEL_TMR_RST() uint32 {
	return (volatile.LoadUint32(&o.PORTSEL.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetPORTSEL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PORTSEL.Reg, volatile.LoadUint32(&o.PORTSEL.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetPORTSEL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PORTSEL.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetPORTSEL_B_HNP_TRACK(value uint32) {
	volatile.StoreUint32(&o.PORTSEL.Reg, volatile.LoadUint32(&o.PORTSEL.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetPORTSEL_B_HNP_TRACK() uint32 {
	return (volatile.LoadUint32(&o.PORTSEL.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetPORTSEL_A_HNP_TRACK(value uint32) {
	volatile.StoreUint32(&o.PORTSEL.Reg, volatile.LoadUint32(&o.PORTSEL.Reg)&^(0x200)|value<<9)
}
func (o *USB_Type) GetPORTSEL_A_HNP_TRACK() uint32 {
	return (volatile.LoadUint32(&o.PORTSEL.Reg) & 0x200) >> 9
}
func (o *USB_Type) SetPORTSEL_PU_REMOVED(value uint32) {
	volatile.StoreUint32(&o.PORTSEL.Reg, volatile.LoadUint32(&o.PORTSEL.Reg)&^(0x400)|value<<10)
}
func (o *USB_Type) GetPORTSEL_PU_REMOVED() uint32 {
	return (volatile.LoadUint32(&o.PORTSEL.Reg) & 0x400) >> 10
}
func (o *USB_Type) SetPORTSEL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PORTSEL.Reg, volatile.LoadUint32(&o.PORTSEL.Reg)&^(0xf800)|value<<11)
}
func (o *USB_Type) GetPORTSEL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PORTSEL.Reg) & 0xf800) >> 11
}
func (o *USB_Type) SetPORTSEL_TMR_CNT(value uint32) {
	volatile.StoreUint32(&o.PORTSEL.Reg, volatile.LoadUint32(&o.PORTSEL.Reg)&^(0xffff0000)|value<<16)
}
func (o *USB_Type) GetPORTSEL_TMR_CNT() uint32 {
	return (volatile.LoadUint32(&o.PORTSEL.Reg) & 0xffff0000) >> 16
}
func (o *USB_Type) SetPORTSEL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PORTSEL.Reg, volatile.LoadUint32(&o.PORTSEL.Reg)&^(0xfffffffc)|value<<2)
}
func (o *USB_Type) GetPORTSEL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PORTSEL.Reg) & 0xfffffffc) >> 2
}

// USB.TMR: OTG Timer
func (o *USB_Type) SetTMR_TIMEOUT_CNT(value uint32) {
	volatile.StoreUint32(&o.TMR.Reg, volatile.LoadUint32(&o.TMR.Reg)&^(0xffff)|value)
}
func (o *USB_Type) GetTMR_TIMEOUT_CNT() uint32 {
	return volatile.LoadUint32(&o.TMR.Reg) & 0xffff
}
func (o *USB_Type) SetTMR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TMR.Reg, volatile.LoadUint32(&o.TMR.Reg)&^(0xffff0000)|value<<16)
}
func (o *USB_Type) GetTMR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TMR.Reg) & 0xffff0000) >> 16
}

// USB.DEVINTST: USB Device Interrupt Status
func (o *USB_Type) SetDEVINTST_FRAME(value uint32) {
	volatile.StoreUint32(&o.DEVINTST.Reg, volatile.LoadUint32(&o.DEVINTST.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetDEVINTST_FRAME() uint32 {
	return volatile.LoadUint32(&o.DEVINTST.Reg) & 0x1
}
func (o *USB_Type) SetDEVINTST_EP_FAST(value uint32) {
	volatile.StoreUint32(&o.DEVINTST.Reg, volatile.LoadUint32(&o.DEVINTST.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetDEVINTST_EP_FAST() uint32 {
	return (volatile.LoadUint32(&o.DEVINTST.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetDEVINTST_EP_SLOW(value uint32) {
	volatile.StoreUint32(&o.DEVINTST.Reg, volatile.LoadUint32(&o.DEVINTST.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetDEVINTST_EP_SLOW() uint32 {
	return (volatile.LoadUint32(&o.DEVINTST.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetDEVINTST_DEV_STAT(value uint32) {
	volatile.StoreUint32(&o.DEVINTST.Reg, volatile.LoadUint32(&o.DEVINTST.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetDEVINTST_DEV_STAT() uint32 {
	return (volatile.LoadUint32(&o.DEVINTST.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetDEVINTST_CCEMPTY(value uint32) {
	volatile.StoreUint32(&o.DEVINTST.Reg, volatile.LoadUint32(&o.DEVINTST.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetDEVINTST_CCEMPTY() uint32 {
	return (volatile.LoadUint32(&o.DEVINTST.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetDEVINTST_CDFULL(value uint32) {
	volatile.StoreUint32(&o.DEVINTST.Reg, volatile.LoadUint32(&o.DEVINTST.Reg)&^(0x20)|value<<5)
}
func (o *USB_Type) GetDEVINTST_CDFULL() uint32 {
	return (volatile.LoadUint32(&o.DEVINTST.Reg) & 0x20) >> 5
}
func (o *USB_Type) SetDEVINTST_RxENDPKT(value uint32) {
	volatile.StoreUint32(&o.DEVINTST.Reg, volatile.LoadUint32(&o.DEVINTST.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetDEVINTST_RxENDPKT() uint32 {
	return (volatile.LoadUint32(&o.DEVINTST.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetDEVINTST_TxENDPKT(value uint32) {
	volatile.StoreUint32(&o.DEVINTST.Reg, volatile.LoadUint32(&o.DEVINTST.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetDEVINTST_TxENDPKT() uint32 {
	return (volatile.LoadUint32(&o.DEVINTST.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetDEVINTST_EP_RLZED(value uint32) {
	volatile.StoreUint32(&o.DEVINTST.Reg, volatile.LoadUint32(&o.DEVINTST.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetDEVINTST_EP_RLZED() uint32 {
	return (volatile.LoadUint32(&o.DEVINTST.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetDEVINTST_ERR_INT(value uint32) {
	volatile.StoreUint32(&o.DEVINTST.Reg, volatile.LoadUint32(&o.DEVINTST.Reg)&^(0x200)|value<<9)
}
func (o *USB_Type) GetDEVINTST_ERR_INT() uint32 {
	return (volatile.LoadUint32(&o.DEVINTST.Reg) & 0x200) >> 9
}
func (o *USB_Type) SetDEVINTST_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DEVINTST.Reg, volatile.LoadUint32(&o.DEVINTST.Reg)&^(0xfffffc00)|value<<10)
}
func (o *USB_Type) GetDEVINTST_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DEVINTST.Reg) & 0xfffffc00) >> 10
}

// USB.DEVINTEN: USB Device Interrupt Enable
func (o *USB_Type) SetDEVINTEN_FRAMEEN(value uint32) {
	volatile.StoreUint32(&o.DEVINTEN.Reg, volatile.LoadUint32(&o.DEVINTEN.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetDEVINTEN_FRAMEEN() uint32 {
	return volatile.LoadUint32(&o.DEVINTEN.Reg) & 0x1
}
func (o *USB_Type) SetDEVINTEN_EP_FASTEN(value uint32) {
	volatile.StoreUint32(&o.DEVINTEN.Reg, volatile.LoadUint32(&o.DEVINTEN.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetDEVINTEN_EP_FASTEN() uint32 {
	return (volatile.LoadUint32(&o.DEVINTEN.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetDEVINTEN_EP_SLOWEN(value uint32) {
	volatile.StoreUint32(&o.DEVINTEN.Reg, volatile.LoadUint32(&o.DEVINTEN.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetDEVINTEN_EP_SLOWEN() uint32 {
	return (volatile.LoadUint32(&o.DEVINTEN.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetDEVINTEN_DEV_STATEN(value uint32) {
	volatile.StoreUint32(&o.DEVINTEN.Reg, volatile.LoadUint32(&o.DEVINTEN.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetDEVINTEN_DEV_STATEN() uint32 {
	return (volatile.LoadUint32(&o.DEVINTEN.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetDEVINTEN_CCEMPTYEN(value uint32) {
	volatile.StoreUint32(&o.DEVINTEN.Reg, volatile.LoadUint32(&o.DEVINTEN.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetDEVINTEN_CCEMPTYEN() uint32 {
	return (volatile.LoadUint32(&o.DEVINTEN.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetDEVINTEN_CDFULLEN(value uint32) {
	volatile.StoreUint32(&o.DEVINTEN.Reg, volatile.LoadUint32(&o.DEVINTEN.Reg)&^(0x20)|value<<5)
}
func (o *USB_Type) GetDEVINTEN_CDFULLEN() uint32 {
	return (volatile.LoadUint32(&o.DEVINTEN.Reg) & 0x20) >> 5
}
func (o *USB_Type) SetDEVINTEN_RxENDPKTEN(value uint32) {
	volatile.StoreUint32(&o.DEVINTEN.Reg, volatile.LoadUint32(&o.DEVINTEN.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetDEVINTEN_RxENDPKTEN() uint32 {
	return (volatile.LoadUint32(&o.DEVINTEN.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetDEVINTEN_TxENDPKTEN(value uint32) {
	volatile.StoreUint32(&o.DEVINTEN.Reg, volatile.LoadUint32(&o.DEVINTEN.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetDEVINTEN_TxENDPKTEN() uint32 {
	return (volatile.LoadUint32(&o.DEVINTEN.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetDEVINTEN_EP_RLZEDEN(value uint32) {
	volatile.StoreUint32(&o.DEVINTEN.Reg, volatile.LoadUint32(&o.DEVINTEN.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetDEVINTEN_EP_RLZEDEN() uint32 {
	return (volatile.LoadUint32(&o.DEVINTEN.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetDEVINTEN_ERR_INTEN(value uint32) {
	volatile.StoreUint32(&o.DEVINTEN.Reg, volatile.LoadUint32(&o.DEVINTEN.Reg)&^(0x200)|value<<9)
}
func (o *USB_Type) GetDEVINTEN_ERR_INTEN() uint32 {
	return (volatile.LoadUint32(&o.DEVINTEN.Reg) & 0x200) >> 9
}
func (o *USB_Type) SetDEVINTEN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DEVINTEN.Reg, volatile.LoadUint32(&o.DEVINTEN.Reg)&^(0xfffffc00)|value<<10)
}
func (o *USB_Type) GetDEVINTEN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DEVINTEN.Reg) & 0xfffffc00) >> 10
}

// USB.DEVINTCLR: USB Device Interrupt Clear
func (o *USB_Type) SetDEVINTCLR_FRAMECLR(value uint32) {
	volatile.StoreUint32(&o.DEVINTCLR.Reg, volatile.LoadUint32(&o.DEVINTCLR.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetDEVINTCLR_FRAMECLR() uint32 {
	return volatile.LoadUint32(&o.DEVINTCLR.Reg) & 0x1
}
func (o *USB_Type) SetDEVINTCLR_EP_FASTCLR(value uint32) {
	volatile.StoreUint32(&o.DEVINTCLR.Reg, volatile.LoadUint32(&o.DEVINTCLR.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetDEVINTCLR_EP_FASTCLR() uint32 {
	return (volatile.LoadUint32(&o.DEVINTCLR.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetDEVINTCLR_EP_SLOWCLR(value uint32) {
	volatile.StoreUint32(&o.DEVINTCLR.Reg, volatile.LoadUint32(&o.DEVINTCLR.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetDEVINTCLR_EP_SLOWCLR() uint32 {
	return (volatile.LoadUint32(&o.DEVINTCLR.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetDEVINTCLR_DEV_STATCLR(value uint32) {
	volatile.StoreUint32(&o.DEVINTCLR.Reg, volatile.LoadUint32(&o.DEVINTCLR.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetDEVINTCLR_DEV_STATCLR() uint32 {
	return (volatile.LoadUint32(&o.DEVINTCLR.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetDEVINTCLR_CCEMPTYCLR(value uint32) {
	volatile.StoreUint32(&o.DEVINTCLR.Reg, volatile.LoadUint32(&o.DEVINTCLR.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetDEVINTCLR_CCEMPTYCLR() uint32 {
	return (volatile.LoadUint32(&o.DEVINTCLR.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetDEVINTCLR_CDFULLCLR(value uint32) {
	volatile.StoreUint32(&o.DEVINTCLR.Reg, volatile.LoadUint32(&o.DEVINTCLR.Reg)&^(0x20)|value<<5)
}
func (o *USB_Type) GetDEVINTCLR_CDFULLCLR() uint32 {
	return (volatile.LoadUint32(&o.DEVINTCLR.Reg) & 0x20) >> 5
}
func (o *USB_Type) SetDEVINTCLR_RxENDPKTCLR(value uint32) {
	volatile.StoreUint32(&o.DEVINTCLR.Reg, volatile.LoadUint32(&o.DEVINTCLR.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetDEVINTCLR_RxENDPKTCLR() uint32 {
	return (volatile.LoadUint32(&o.DEVINTCLR.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetDEVINTCLR_TxENDPKTCLR(value uint32) {
	volatile.StoreUint32(&o.DEVINTCLR.Reg, volatile.LoadUint32(&o.DEVINTCLR.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetDEVINTCLR_TxENDPKTCLR() uint32 {
	return (volatile.LoadUint32(&o.DEVINTCLR.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetDEVINTCLR_EP_RLZEDCLR(value uint32) {
	volatile.StoreUint32(&o.DEVINTCLR.Reg, volatile.LoadUint32(&o.DEVINTCLR.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetDEVINTCLR_EP_RLZEDCLR() uint32 {
	return (volatile.LoadUint32(&o.DEVINTCLR.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetDEVINTCLR_ERR_INTCLR(value uint32) {
	volatile.StoreUint32(&o.DEVINTCLR.Reg, volatile.LoadUint32(&o.DEVINTCLR.Reg)&^(0x200)|value<<9)
}
func (o *USB_Type) GetDEVINTCLR_ERR_INTCLR() uint32 {
	return (volatile.LoadUint32(&o.DEVINTCLR.Reg) & 0x200) >> 9
}
func (o *USB_Type) SetDEVINTCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DEVINTCLR.Reg, volatile.LoadUint32(&o.DEVINTCLR.Reg)&^(0xfffffc00)|value<<10)
}
func (o *USB_Type) GetDEVINTCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DEVINTCLR.Reg) & 0xfffffc00) >> 10
}

// USB.DEVINTSET: USB Device Interrupt Set
func (o *USB_Type) SetDEVINTSET_FRAMESET(value uint32) {
	volatile.StoreUint32(&o.DEVINTSET.Reg, volatile.LoadUint32(&o.DEVINTSET.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetDEVINTSET_FRAMESET() uint32 {
	return volatile.LoadUint32(&o.DEVINTSET.Reg) & 0x1
}
func (o *USB_Type) SetDEVINTSET_EP_FASTSET(value uint32) {
	volatile.StoreUint32(&o.DEVINTSET.Reg, volatile.LoadUint32(&o.DEVINTSET.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetDEVINTSET_EP_FASTSET() uint32 {
	return (volatile.LoadUint32(&o.DEVINTSET.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetDEVINTSET_EP_SLOWSET(value uint32) {
	volatile.StoreUint32(&o.DEVINTSET.Reg, volatile.LoadUint32(&o.DEVINTSET.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetDEVINTSET_EP_SLOWSET() uint32 {
	return (volatile.LoadUint32(&o.DEVINTSET.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetDEVINTSET_DEV_STATSET(value uint32) {
	volatile.StoreUint32(&o.DEVINTSET.Reg, volatile.LoadUint32(&o.DEVINTSET.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetDEVINTSET_DEV_STATSET() uint32 {
	return (volatile.LoadUint32(&o.DEVINTSET.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetDEVINTSET_CCEMPTYSET(value uint32) {
	volatile.StoreUint32(&o.DEVINTSET.Reg, volatile.LoadUint32(&o.DEVINTSET.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetDEVINTSET_CCEMPTYSET() uint32 {
	return (volatile.LoadUint32(&o.DEVINTSET.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetDEVINTSET_CDFULLSET(value uint32) {
	volatile.StoreUint32(&o.DEVINTSET.Reg, volatile.LoadUint32(&o.DEVINTSET.Reg)&^(0x20)|value<<5)
}
func (o *USB_Type) GetDEVINTSET_CDFULLSET() uint32 {
	return (volatile.LoadUint32(&o.DEVINTSET.Reg) & 0x20) >> 5
}
func (o *USB_Type) SetDEVINTSET_RxENDPKTSET(value uint32) {
	volatile.StoreUint32(&o.DEVINTSET.Reg, volatile.LoadUint32(&o.DEVINTSET.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetDEVINTSET_RxENDPKTSET() uint32 {
	return (volatile.LoadUint32(&o.DEVINTSET.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetDEVINTSET_TxENDPKTSET(value uint32) {
	volatile.StoreUint32(&o.DEVINTSET.Reg, volatile.LoadUint32(&o.DEVINTSET.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetDEVINTSET_TxENDPKTSET() uint32 {
	return (volatile.LoadUint32(&o.DEVINTSET.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetDEVINTSET_EP_RLZEDSET(value uint32) {
	volatile.StoreUint32(&o.DEVINTSET.Reg, volatile.LoadUint32(&o.DEVINTSET.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetDEVINTSET_EP_RLZEDSET() uint32 {
	return (volatile.LoadUint32(&o.DEVINTSET.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetDEVINTSET_ERR_INTSET(value uint32) {
	volatile.StoreUint32(&o.DEVINTSET.Reg, volatile.LoadUint32(&o.DEVINTSET.Reg)&^(0x200)|value<<9)
}
func (o *USB_Type) GetDEVINTSET_ERR_INTSET() uint32 {
	return (volatile.LoadUint32(&o.DEVINTSET.Reg) & 0x200) >> 9
}
func (o *USB_Type) SetDEVINTSET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DEVINTSET.Reg, volatile.LoadUint32(&o.DEVINTSET.Reg)&^(0xfffffc00)|value<<10)
}
func (o *USB_Type) GetDEVINTSET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DEVINTSET.Reg) & 0xfffffc00) >> 10
}

// USB.CMDCODE: USB Command Code
func (o *USB_Type) SetCMDCODE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CMDCODE.Reg, volatile.LoadUint32(&o.CMDCODE.Reg)&^(0xff)|value)
}
func (o *USB_Type) GetCMDCODE_RESERVED() uint32 {
	return volatile.LoadUint32(&o.CMDCODE.Reg) & 0xff
}
func (o *USB_Type) SetCMDCODE_CMD_PHASE(value uint32) {
	volatile.StoreUint32(&o.CMDCODE.Reg, volatile.LoadUint32(&o.CMDCODE.Reg)&^(0xff00)|value<<8)
}
func (o *USB_Type) GetCMDCODE_CMD_PHASE() uint32 {
	return (volatile.LoadUint32(&o.CMDCODE.Reg) & 0xff00) >> 8
}
func (o *USB_Type) SetCMDCODE_CMD_CODE_WDATA(value uint32) {
	volatile.StoreUint32(&o.CMDCODE.Reg, volatile.LoadUint32(&o.CMDCODE.Reg)&^(0xff0000)|value<<16)
}
func (o *USB_Type) GetCMDCODE_CMD_CODE_WDATA() uint32 {
	return (volatile.LoadUint32(&o.CMDCODE.Reg) & 0xff0000) >> 16
}
func (o *USB_Type) SetCMDCODE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CMDCODE.Reg, volatile.LoadUint32(&o.CMDCODE.Reg)&^(0xff000000)|value<<24)
}
func (o *USB_Type) GetCMDCODE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CMDCODE.Reg) & 0xff000000) >> 24
}

// USB.CMDDATA: USB Command Data
func (o *USB_Type) SetCMDDATA_CMD_RDATA(value uint32) {
	volatile.StoreUint32(&o.CMDDATA.Reg, volatile.LoadUint32(&o.CMDDATA.Reg)&^(0xff)|value)
}
func (o *USB_Type) GetCMDDATA_CMD_RDATA() uint32 {
	return volatile.LoadUint32(&o.CMDDATA.Reg) & 0xff
}
func (o *USB_Type) SetCMDDATA_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CMDDATA.Reg, volatile.LoadUint32(&o.CMDDATA.Reg)&^(0xffffff00)|value<<8)
}
func (o *USB_Type) GetCMDDATA_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CMDDATA.Reg) & 0xffffff00) >> 8
}

// USB.RXDATA: USB Receive Data
func (o *USB_Type) SetRXDATA(value uint32) {
	volatile.StoreUint32(&o.RXDATA.Reg, value)
}
func (o *USB_Type) GetRXDATA() uint32 {
	return volatile.LoadUint32(&o.RXDATA.Reg)
}

// USB.TXDATA: USB Transmit Data
func (o *USB_Type) SetTXDATA(value uint32) {
	volatile.StoreUint32(&o.TXDATA.Reg, value)
}
func (o *USB_Type) GetTXDATA() uint32 {
	return volatile.LoadUint32(&o.TXDATA.Reg)
}

// USB.TXPLEN: USB Transmit Packet Length
func (o *USB_Type) SetTXPLEN_PKT_LNGTH(value uint32) {
	volatile.StoreUint32(&o.TXPLEN.Reg, volatile.LoadUint32(&o.TXPLEN.Reg)&^(0x3ff)|value)
}
func (o *USB_Type) GetTXPLEN_PKT_LNGTH() uint32 {
	return volatile.LoadUint32(&o.TXPLEN.Reg) & 0x3ff
}
func (o *USB_Type) SetTXPLEN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TXPLEN.Reg, volatile.LoadUint32(&o.TXPLEN.Reg)&^(0xfffffc00)|value<<10)
}
func (o *USB_Type) GetTXPLEN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TXPLEN.Reg) & 0xfffffc00) >> 10
}

// USB.CTRL: USB Control
func (o *USB_Type) SetCTRL_RD_EN(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetCTRL_RD_EN() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x1
}
func (o *USB_Type) SetCTRL_WR_EN(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetCTRL_WR_EN() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetCTRL_LOG_ENDPOINT(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x3c)|value<<2)
}
func (o *USB_Type) GetCTRL_LOG_ENDPOINT() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x3c) >> 2
}
func (o *USB_Type) SetCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xffffffc0)|value<<6)
}
func (o *USB_Type) GetCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xffffffc0) >> 6
}

// USB.DEVINTPRI: USB Device Interrupt Priority
func (o *USB_Type) SetDEVINTPRI_FRAME(value uint32) {
	volatile.StoreUint32(&o.DEVINTPRI.Reg, volatile.LoadUint32(&o.DEVINTPRI.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetDEVINTPRI_FRAME() uint32 {
	return volatile.LoadUint32(&o.DEVINTPRI.Reg) & 0x1
}
func (o *USB_Type) SetDEVINTPRI_EP_FAST(value uint32) {
	volatile.StoreUint32(&o.DEVINTPRI.Reg, volatile.LoadUint32(&o.DEVINTPRI.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetDEVINTPRI_EP_FAST() uint32 {
	return (volatile.LoadUint32(&o.DEVINTPRI.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetDEVINTPRI_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DEVINTPRI.Reg, volatile.LoadUint32(&o.DEVINTPRI.Reg)&^(0xfffffffc)|value<<2)
}
func (o *USB_Type) GetDEVINTPRI_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DEVINTPRI.Reg) & 0xfffffffc) >> 2
}

// USB.EPINTST: USB Endpoint Interrupt Status
func (o *USB_Type) SetEPINTST_EPST0(value uint32) {
	volatile.StoreUint32(&o.EPINTST.Reg, volatile.LoadUint32(&o.EPINTST.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetEPINTST_EPST0() uint32 {
	return volatile.LoadUint32(&o.EPINTST.Reg) & 0x1
}
func (o *USB_Type) SetEPINTST_EPST1(value uint32) {
	volatile.StoreUint32(&o.EPINTST.Reg, volatile.LoadUint32(&o.EPINTST.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetEPINTST_EPST1() uint32 {
	return (volatile.LoadUint32(&o.EPINTST.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetEPINTST_EPST2(value uint32) {
	volatile.StoreUint32(&o.EPINTST.Reg, volatile.LoadUint32(&o.EPINTST.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetEPINTST_EPST2() uint32 {
	return (volatile.LoadUint32(&o.EPINTST.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetEPINTST_EPST3(value uint32) {
	volatile.StoreUint32(&o.EPINTST.Reg, volatile.LoadUint32(&o.EPINTST.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetEPINTST_EPST3() uint32 {
	return (volatile.LoadUint32(&o.EPINTST.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetEPINTST_EPST4(value uint32) {
	volatile.StoreUint32(&o.EPINTST.Reg, volatile.LoadUint32(&o.EPINTST.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetEPINTST_EPST4() uint32 {
	return (volatile.LoadUint32(&o.EPINTST.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetEPINTST_EPST5(value uint32) {
	volatile.StoreUint32(&o.EPINTST.Reg, volatile.LoadUint32(&o.EPINTST.Reg)&^(0x20)|value<<5)
}
func (o *USB_Type) GetEPINTST_EPST5() uint32 {
	return (volatile.LoadUint32(&o.EPINTST.Reg) & 0x20) >> 5
}
func (o *USB_Type) SetEPINTST_EPST6(value uint32) {
	volatile.StoreUint32(&o.EPINTST.Reg, volatile.LoadUint32(&o.EPINTST.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetEPINTST_EPST6() uint32 {
	return (volatile.LoadUint32(&o.EPINTST.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetEPINTST_EPST7(value uint32) {
	volatile.StoreUint32(&o.EPINTST.Reg, volatile.LoadUint32(&o.EPINTST.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetEPINTST_EPST7() uint32 {
	return (volatile.LoadUint32(&o.EPINTST.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetEPINTST_EPST8(value uint32) {
	volatile.StoreUint32(&o.EPINTST.Reg, volatile.LoadUint32(&o.EPINTST.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetEPINTST_EPST8() uint32 {
	return (volatile.LoadUint32(&o.EPINTST.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetEPINTST_EPST9(value uint32) {
	volatile.StoreUint32(&o.EPINTST.Reg, volatile.LoadUint32(&o.EPINTST.Reg)&^(0x200)|value<<9)
}
func (o *USB_Type) GetEPINTST_EPST9() uint32 {
	return (volatile.LoadUint32(&o.EPINTST.Reg) & 0x200) >> 9
}
func (o *USB_Type) SetEPINTST_EPST10(value uint32) {
	volatile.StoreUint32(&o.EPINTST.Reg, volatile.LoadUint32(&o.EPINTST.Reg)&^(0x400)|value<<10)
}
func (o *USB_Type) GetEPINTST_EPST10() uint32 {
	return (volatile.LoadUint32(&o.EPINTST.Reg) & 0x400) >> 10
}
func (o *USB_Type) SetEPINTST_EPST11(value uint32) {
	volatile.StoreUint32(&o.EPINTST.Reg, volatile.LoadUint32(&o.EPINTST.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetEPINTST_EPST11() uint32 {
	return (volatile.LoadUint32(&o.EPINTST.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetEPINTST_EPST12(value uint32) {
	volatile.StoreUint32(&o.EPINTST.Reg, volatile.LoadUint32(&o.EPINTST.Reg)&^(0x1000)|value<<12)
}
func (o *USB_Type) GetEPINTST_EPST12() uint32 {
	return (volatile.LoadUint32(&o.EPINTST.Reg) & 0x1000) >> 12
}
func (o *USB_Type) SetEPINTST_EPST13(value uint32) {
	volatile.StoreUint32(&o.EPINTST.Reg, volatile.LoadUint32(&o.EPINTST.Reg)&^(0x2000)|value<<13)
}
func (o *USB_Type) GetEPINTST_EPST13() uint32 {
	return (volatile.LoadUint32(&o.EPINTST.Reg) & 0x2000) >> 13
}
func (o *USB_Type) SetEPINTST_EPST14(value uint32) {
	volatile.StoreUint32(&o.EPINTST.Reg, volatile.LoadUint32(&o.EPINTST.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetEPINTST_EPST14() uint32 {
	return (volatile.LoadUint32(&o.EPINTST.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetEPINTST_EPST15(value uint32) {
	volatile.StoreUint32(&o.EPINTST.Reg, volatile.LoadUint32(&o.EPINTST.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetEPINTST_EPST15() uint32 {
	return (volatile.LoadUint32(&o.EPINTST.Reg) & 0x8000) >> 15
}
func (o *USB_Type) SetEPINTST_EPST16(value uint32) {
	volatile.StoreUint32(&o.EPINTST.Reg, volatile.LoadUint32(&o.EPINTST.Reg)&^(0x10000)|value<<16)
}
func (o *USB_Type) GetEPINTST_EPST16() uint32 {
	return (volatile.LoadUint32(&o.EPINTST.Reg) & 0x10000) >> 16
}
func (o *USB_Type) SetEPINTST_EPST17(value uint32) {
	volatile.StoreUint32(&o.EPINTST.Reg, volatile.LoadUint32(&o.EPINTST.Reg)&^(0x20000)|value<<17)
}
func (o *USB_Type) GetEPINTST_EPST17() uint32 {
	return (volatile.LoadUint32(&o.EPINTST.Reg) & 0x20000) >> 17
}
func (o *USB_Type) SetEPINTST_EPST18(value uint32) {
	volatile.StoreUint32(&o.EPINTST.Reg, volatile.LoadUint32(&o.EPINTST.Reg)&^(0x40000)|value<<18)
}
func (o *USB_Type) GetEPINTST_EPST18() uint32 {
	return (volatile.LoadUint32(&o.EPINTST.Reg) & 0x40000) >> 18
}
func (o *USB_Type) SetEPINTST_EPST19(value uint32) {
	volatile.StoreUint32(&o.EPINTST.Reg, volatile.LoadUint32(&o.EPINTST.Reg)&^(0x80000)|value<<19)
}
func (o *USB_Type) GetEPINTST_EPST19() uint32 {
	return (volatile.LoadUint32(&o.EPINTST.Reg) & 0x80000) >> 19
}
func (o *USB_Type) SetEPINTST_EPST20(value uint32) {
	volatile.StoreUint32(&o.EPINTST.Reg, volatile.LoadUint32(&o.EPINTST.Reg)&^(0x100000)|value<<20)
}
func (o *USB_Type) GetEPINTST_EPST20() uint32 {
	return (volatile.LoadUint32(&o.EPINTST.Reg) & 0x100000) >> 20
}
func (o *USB_Type) SetEPINTST_EPST21(value uint32) {
	volatile.StoreUint32(&o.EPINTST.Reg, volatile.LoadUint32(&o.EPINTST.Reg)&^(0x200000)|value<<21)
}
func (o *USB_Type) GetEPINTST_EPST21() uint32 {
	return (volatile.LoadUint32(&o.EPINTST.Reg) & 0x200000) >> 21
}
func (o *USB_Type) SetEPINTST_EPST22(value uint32) {
	volatile.StoreUint32(&o.EPINTST.Reg, volatile.LoadUint32(&o.EPINTST.Reg)&^(0x400000)|value<<22)
}
func (o *USB_Type) GetEPINTST_EPST22() uint32 {
	return (volatile.LoadUint32(&o.EPINTST.Reg) & 0x400000) >> 22
}
func (o *USB_Type) SetEPINTST_EPST23(value uint32) {
	volatile.StoreUint32(&o.EPINTST.Reg, volatile.LoadUint32(&o.EPINTST.Reg)&^(0x800000)|value<<23)
}
func (o *USB_Type) GetEPINTST_EPST23() uint32 {
	return (volatile.LoadUint32(&o.EPINTST.Reg) & 0x800000) >> 23
}
func (o *USB_Type) SetEPINTST_EPST24(value uint32) {
	volatile.StoreUint32(&o.EPINTST.Reg, volatile.LoadUint32(&o.EPINTST.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_Type) GetEPINTST_EPST24() uint32 {
	return (volatile.LoadUint32(&o.EPINTST.Reg) & 0x1000000) >> 24
}
func (o *USB_Type) SetEPINTST_EPST25(value uint32) {
	volatile.StoreUint32(&o.EPINTST.Reg, volatile.LoadUint32(&o.EPINTST.Reg)&^(0x2000000)|value<<25)
}
func (o *USB_Type) GetEPINTST_EPST25() uint32 {
	return (volatile.LoadUint32(&o.EPINTST.Reg) & 0x2000000) >> 25
}
func (o *USB_Type) SetEPINTST_EPST26(value uint32) {
	volatile.StoreUint32(&o.EPINTST.Reg, volatile.LoadUint32(&o.EPINTST.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_Type) GetEPINTST_EPST26() uint32 {
	return (volatile.LoadUint32(&o.EPINTST.Reg) & 0x4000000) >> 26
}
func (o *USB_Type) SetEPINTST_EPST27(value uint32) {
	volatile.StoreUint32(&o.EPINTST.Reg, volatile.LoadUint32(&o.EPINTST.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_Type) GetEPINTST_EPST27() uint32 {
	return (volatile.LoadUint32(&o.EPINTST.Reg) & 0x8000000) >> 27
}
func (o *USB_Type) SetEPINTST_EPST28(value uint32) {
	volatile.StoreUint32(&o.EPINTST.Reg, volatile.LoadUint32(&o.EPINTST.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_Type) GetEPINTST_EPST28() uint32 {
	return (volatile.LoadUint32(&o.EPINTST.Reg) & 0x10000000) >> 28
}
func (o *USB_Type) SetEPINTST_EPST29(value uint32) {
	volatile.StoreUint32(&o.EPINTST.Reg, volatile.LoadUint32(&o.EPINTST.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_Type) GetEPINTST_EPST29() uint32 {
	return (volatile.LoadUint32(&o.EPINTST.Reg) & 0x20000000) >> 29
}
func (o *USB_Type) SetEPINTST_EPST30(value uint32) {
	volatile.StoreUint32(&o.EPINTST.Reg, volatile.LoadUint32(&o.EPINTST.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_Type) GetEPINTST_EPST30() uint32 {
	return (volatile.LoadUint32(&o.EPINTST.Reg) & 0x40000000) >> 30
}
func (o *USB_Type) SetEPINTST_EPST31(value uint32) {
	volatile.StoreUint32(&o.EPINTST.Reg, volatile.LoadUint32(&o.EPINTST.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_Type) GetEPINTST_EPST31() uint32 {
	return (volatile.LoadUint32(&o.EPINTST.Reg) & 0x80000000) >> 31
}

// USB.EPINTEN: USB Endpoint Interrupt Enable
func (o *USB_Type) SetEPINTEN_EPEN0(value uint32) {
	volatile.StoreUint32(&o.EPINTEN.Reg, volatile.LoadUint32(&o.EPINTEN.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetEPINTEN_EPEN0() uint32 {
	return volatile.LoadUint32(&o.EPINTEN.Reg) & 0x1
}
func (o *USB_Type) SetEPINTEN_EPEN1(value uint32) {
	volatile.StoreUint32(&o.EPINTEN.Reg, volatile.LoadUint32(&o.EPINTEN.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetEPINTEN_EPEN1() uint32 {
	return (volatile.LoadUint32(&o.EPINTEN.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetEPINTEN_EPEN2(value uint32) {
	volatile.StoreUint32(&o.EPINTEN.Reg, volatile.LoadUint32(&o.EPINTEN.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetEPINTEN_EPEN2() uint32 {
	return (volatile.LoadUint32(&o.EPINTEN.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetEPINTEN_EPEN3(value uint32) {
	volatile.StoreUint32(&o.EPINTEN.Reg, volatile.LoadUint32(&o.EPINTEN.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetEPINTEN_EPEN3() uint32 {
	return (volatile.LoadUint32(&o.EPINTEN.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetEPINTEN_EPEN4(value uint32) {
	volatile.StoreUint32(&o.EPINTEN.Reg, volatile.LoadUint32(&o.EPINTEN.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetEPINTEN_EPEN4() uint32 {
	return (volatile.LoadUint32(&o.EPINTEN.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetEPINTEN_EPEN5(value uint32) {
	volatile.StoreUint32(&o.EPINTEN.Reg, volatile.LoadUint32(&o.EPINTEN.Reg)&^(0x20)|value<<5)
}
func (o *USB_Type) GetEPINTEN_EPEN5() uint32 {
	return (volatile.LoadUint32(&o.EPINTEN.Reg) & 0x20) >> 5
}
func (o *USB_Type) SetEPINTEN_EPEN6(value uint32) {
	volatile.StoreUint32(&o.EPINTEN.Reg, volatile.LoadUint32(&o.EPINTEN.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetEPINTEN_EPEN6() uint32 {
	return (volatile.LoadUint32(&o.EPINTEN.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetEPINTEN_EPEN7(value uint32) {
	volatile.StoreUint32(&o.EPINTEN.Reg, volatile.LoadUint32(&o.EPINTEN.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetEPINTEN_EPEN7() uint32 {
	return (volatile.LoadUint32(&o.EPINTEN.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetEPINTEN_EPEN8(value uint32) {
	volatile.StoreUint32(&o.EPINTEN.Reg, volatile.LoadUint32(&o.EPINTEN.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetEPINTEN_EPEN8() uint32 {
	return (volatile.LoadUint32(&o.EPINTEN.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetEPINTEN_EPEN9(value uint32) {
	volatile.StoreUint32(&o.EPINTEN.Reg, volatile.LoadUint32(&o.EPINTEN.Reg)&^(0x200)|value<<9)
}
func (o *USB_Type) GetEPINTEN_EPEN9() uint32 {
	return (volatile.LoadUint32(&o.EPINTEN.Reg) & 0x200) >> 9
}
func (o *USB_Type) SetEPINTEN_EPEN10(value uint32) {
	volatile.StoreUint32(&o.EPINTEN.Reg, volatile.LoadUint32(&o.EPINTEN.Reg)&^(0x400)|value<<10)
}
func (o *USB_Type) GetEPINTEN_EPEN10() uint32 {
	return (volatile.LoadUint32(&o.EPINTEN.Reg) & 0x400) >> 10
}
func (o *USB_Type) SetEPINTEN_EPEN11(value uint32) {
	volatile.StoreUint32(&o.EPINTEN.Reg, volatile.LoadUint32(&o.EPINTEN.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetEPINTEN_EPEN11() uint32 {
	return (volatile.LoadUint32(&o.EPINTEN.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetEPINTEN_EPEN12(value uint32) {
	volatile.StoreUint32(&o.EPINTEN.Reg, volatile.LoadUint32(&o.EPINTEN.Reg)&^(0x1000)|value<<12)
}
func (o *USB_Type) GetEPINTEN_EPEN12() uint32 {
	return (volatile.LoadUint32(&o.EPINTEN.Reg) & 0x1000) >> 12
}
func (o *USB_Type) SetEPINTEN_EPEN13(value uint32) {
	volatile.StoreUint32(&o.EPINTEN.Reg, volatile.LoadUint32(&o.EPINTEN.Reg)&^(0x2000)|value<<13)
}
func (o *USB_Type) GetEPINTEN_EPEN13() uint32 {
	return (volatile.LoadUint32(&o.EPINTEN.Reg) & 0x2000) >> 13
}
func (o *USB_Type) SetEPINTEN_EPEN14(value uint32) {
	volatile.StoreUint32(&o.EPINTEN.Reg, volatile.LoadUint32(&o.EPINTEN.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetEPINTEN_EPEN14() uint32 {
	return (volatile.LoadUint32(&o.EPINTEN.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetEPINTEN_EPEN15(value uint32) {
	volatile.StoreUint32(&o.EPINTEN.Reg, volatile.LoadUint32(&o.EPINTEN.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetEPINTEN_EPEN15() uint32 {
	return (volatile.LoadUint32(&o.EPINTEN.Reg) & 0x8000) >> 15
}
func (o *USB_Type) SetEPINTEN_EPEN16(value uint32) {
	volatile.StoreUint32(&o.EPINTEN.Reg, volatile.LoadUint32(&o.EPINTEN.Reg)&^(0x10000)|value<<16)
}
func (o *USB_Type) GetEPINTEN_EPEN16() uint32 {
	return (volatile.LoadUint32(&o.EPINTEN.Reg) & 0x10000) >> 16
}
func (o *USB_Type) SetEPINTEN_EPEN17(value uint32) {
	volatile.StoreUint32(&o.EPINTEN.Reg, volatile.LoadUint32(&o.EPINTEN.Reg)&^(0x20000)|value<<17)
}
func (o *USB_Type) GetEPINTEN_EPEN17() uint32 {
	return (volatile.LoadUint32(&o.EPINTEN.Reg) & 0x20000) >> 17
}
func (o *USB_Type) SetEPINTEN_EPEN18(value uint32) {
	volatile.StoreUint32(&o.EPINTEN.Reg, volatile.LoadUint32(&o.EPINTEN.Reg)&^(0x40000)|value<<18)
}
func (o *USB_Type) GetEPINTEN_EPEN18() uint32 {
	return (volatile.LoadUint32(&o.EPINTEN.Reg) & 0x40000) >> 18
}
func (o *USB_Type) SetEPINTEN_EPEN19(value uint32) {
	volatile.StoreUint32(&o.EPINTEN.Reg, volatile.LoadUint32(&o.EPINTEN.Reg)&^(0x80000)|value<<19)
}
func (o *USB_Type) GetEPINTEN_EPEN19() uint32 {
	return (volatile.LoadUint32(&o.EPINTEN.Reg) & 0x80000) >> 19
}
func (o *USB_Type) SetEPINTEN_EPEN20(value uint32) {
	volatile.StoreUint32(&o.EPINTEN.Reg, volatile.LoadUint32(&o.EPINTEN.Reg)&^(0x100000)|value<<20)
}
func (o *USB_Type) GetEPINTEN_EPEN20() uint32 {
	return (volatile.LoadUint32(&o.EPINTEN.Reg) & 0x100000) >> 20
}
func (o *USB_Type) SetEPINTEN_EPEN21(value uint32) {
	volatile.StoreUint32(&o.EPINTEN.Reg, volatile.LoadUint32(&o.EPINTEN.Reg)&^(0x200000)|value<<21)
}
func (o *USB_Type) GetEPINTEN_EPEN21() uint32 {
	return (volatile.LoadUint32(&o.EPINTEN.Reg) & 0x200000) >> 21
}
func (o *USB_Type) SetEPINTEN_EPEN22(value uint32) {
	volatile.StoreUint32(&o.EPINTEN.Reg, volatile.LoadUint32(&o.EPINTEN.Reg)&^(0x400000)|value<<22)
}
func (o *USB_Type) GetEPINTEN_EPEN22() uint32 {
	return (volatile.LoadUint32(&o.EPINTEN.Reg) & 0x400000) >> 22
}
func (o *USB_Type) SetEPINTEN_EPEN23(value uint32) {
	volatile.StoreUint32(&o.EPINTEN.Reg, volatile.LoadUint32(&o.EPINTEN.Reg)&^(0x800000)|value<<23)
}
func (o *USB_Type) GetEPINTEN_EPEN23() uint32 {
	return (volatile.LoadUint32(&o.EPINTEN.Reg) & 0x800000) >> 23
}
func (o *USB_Type) SetEPINTEN_EPEN24(value uint32) {
	volatile.StoreUint32(&o.EPINTEN.Reg, volatile.LoadUint32(&o.EPINTEN.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_Type) GetEPINTEN_EPEN24() uint32 {
	return (volatile.LoadUint32(&o.EPINTEN.Reg) & 0x1000000) >> 24
}
func (o *USB_Type) SetEPINTEN_EPEN25(value uint32) {
	volatile.StoreUint32(&o.EPINTEN.Reg, volatile.LoadUint32(&o.EPINTEN.Reg)&^(0x2000000)|value<<25)
}
func (o *USB_Type) GetEPINTEN_EPEN25() uint32 {
	return (volatile.LoadUint32(&o.EPINTEN.Reg) & 0x2000000) >> 25
}
func (o *USB_Type) SetEPINTEN_EPEN26(value uint32) {
	volatile.StoreUint32(&o.EPINTEN.Reg, volatile.LoadUint32(&o.EPINTEN.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_Type) GetEPINTEN_EPEN26() uint32 {
	return (volatile.LoadUint32(&o.EPINTEN.Reg) & 0x4000000) >> 26
}
func (o *USB_Type) SetEPINTEN_EPEN27(value uint32) {
	volatile.StoreUint32(&o.EPINTEN.Reg, volatile.LoadUint32(&o.EPINTEN.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_Type) GetEPINTEN_EPEN27() uint32 {
	return (volatile.LoadUint32(&o.EPINTEN.Reg) & 0x8000000) >> 27
}
func (o *USB_Type) SetEPINTEN_EPEN28(value uint32) {
	volatile.StoreUint32(&o.EPINTEN.Reg, volatile.LoadUint32(&o.EPINTEN.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_Type) GetEPINTEN_EPEN28() uint32 {
	return (volatile.LoadUint32(&o.EPINTEN.Reg) & 0x10000000) >> 28
}
func (o *USB_Type) SetEPINTEN_EPEN29(value uint32) {
	volatile.StoreUint32(&o.EPINTEN.Reg, volatile.LoadUint32(&o.EPINTEN.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_Type) GetEPINTEN_EPEN29() uint32 {
	return (volatile.LoadUint32(&o.EPINTEN.Reg) & 0x20000000) >> 29
}
func (o *USB_Type) SetEPINTEN_EPEN30(value uint32) {
	volatile.StoreUint32(&o.EPINTEN.Reg, volatile.LoadUint32(&o.EPINTEN.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_Type) GetEPINTEN_EPEN30() uint32 {
	return (volatile.LoadUint32(&o.EPINTEN.Reg) & 0x40000000) >> 30
}
func (o *USB_Type) SetEPINTEN_EPEN31(value uint32) {
	volatile.StoreUint32(&o.EPINTEN.Reg, volatile.LoadUint32(&o.EPINTEN.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_Type) GetEPINTEN_EPEN31() uint32 {
	return (volatile.LoadUint32(&o.EPINTEN.Reg) & 0x80000000) >> 31
}

// USB.EPINTCLR: USB Endpoint Interrupt Clear
func (o *USB_Type) SetEPINTCLR_EPCLR0(value uint32) {
	volatile.StoreUint32(&o.EPINTCLR.Reg, volatile.LoadUint32(&o.EPINTCLR.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetEPINTCLR_EPCLR0() uint32 {
	return volatile.LoadUint32(&o.EPINTCLR.Reg) & 0x1
}
func (o *USB_Type) SetEPINTCLR_EPCLR1(value uint32) {
	volatile.StoreUint32(&o.EPINTCLR.Reg, volatile.LoadUint32(&o.EPINTCLR.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetEPINTCLR_EPCLR1() uint32 {
	return (volatile.LoadUint32(&o.EPINTCLR.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetEPINTCLR_EPCLR2(value uint32) {
	volatile.StoreUint32(&o.EPINTCLR.Reg, volatile.LoadUint32(&o.EPINTCLR.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetEPINTCLR_EPCLR2() uint32 {
	return (volatile.LoadUint32(&o.EPINTCLR.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetEPINTCLR_EPCLR3(value uint32) {
	volatile.StoreUint32(&o.EPINTCLR.Reg, volatile.LoadUint32(&o.EPINTCLR.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetEPINTCLR_EPCLR3() uint32 {
	return (volatile.LoadUint32(&o.EPINTCLR.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetEPINTCLR_EPCLR4(value uint32) {
	volatile.StoreUint32(&o.EPINTCLR.Reg, volatile.LoadUint32(&o.EPINTCLR.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetEPINTCLR_EPCLR4() uint32 {
	return (volatile.LoadUint32(&o.EPINTCLR.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetEPINTCLR_EPCLR5(value uint32) {
	volatile.StoreUint32(&o.EPINTCLR.Reg, volatile.LoadUint32(&o.EPINTCLR.Reg)&^(0x20)|value<<5)
}
func (o *USB_Type) GetEPINTCLR_EPCLR5() uint32 {
	return (volatile.LoadUint32(&o.EPINTCLR.Reg) & 0x20) >> 5
}
func (o *USB_Type) SetEPINTCLR_EPCLR6(value uint32) {
	volatile.StoreUint32(&o.EPINTCLR.Reg, volatile.LoadUint32(&o.EPINTCLR.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetEPINTCLR_EPCLR6() uint32 {
	return (volatile.LoadUint32(&o.EPINTCLR.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetEPINTCLR_EPCLR7(value uint32) {
	volatile.StoreUint32(&o.EPINTCLR.Reg, volatile.LoadUint32(&o.EPINTCLR.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetEPINTCLR_EPCLR7() uint32 {
	return (volatile.LoadUint32(&o.EPINTCLR.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetEPINTCLR_EPCLR8(value uint32) {
	volatile.StoreUint32(&o.EPINTCLR.Reg, volatile.LoadUint32(&o.EPINTCLR.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetEPINTCLR_EPCLR8() uint32 {
	return (volatile.LoadUint32(&o.EPINTCLR.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetEPINTCLR_EPCLR9(value uint32) {
	volatile.StoreUint32(&o.EPINTCLR.Reg, volatile.LoadUint32(&o.EPINTCLR.Reg)&^(0x200)|value<<9)
}
func (o *USB_Type) GetEPINTCLR_EPCLR9() uint32 {
	return (volatile.LoadUint32(&o.EPINTCLR.Reg) & 0x200) >> 9
}
func (o *USB_Type) SetEPINTCLR_EPCLR10(value uint32) {
	volatile.StoreUint32(&o.EPINTCLR.Reg, volatile.LoadUint32(&o.EPINTCLR.Reg)&^(0x400)|value<<10)
}
func (o *USB_Type) GetEPINTCLR_EPCLR10() uint32 {
	return (volatile.LoadUint32(&o.EPINTCLR.Reg) & 0x400) >> 10
}
func (o *USB_Type) SetEPINTCLR_EPCLR11(value uint32) {
	volatile.StoreUint32(&o.EPINTCLR.Reg, volatile.LoadUint32(&o.EPINTCLR.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetEPINTCLR_EPCLR11() uint32 {
	return (volatile.LoadUint32(&o.EPINTCLR.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetEPINTCLR_EPCLR12(value uint32) {
	volatile.StoreUint32(&o.EPINTCLR.Reg, volatile.LoadUint32(&o.EPINTCLR.Reg)&^(0x1000)|value<<12)
}
func (o *USB_Type) GetEPINTCLR_EPCLR12() uint32 {
	return (volatile.LoadUint32(&o.EPINTCLR.Reg) & 0x1000) >> 12
}
func (o *USB_Type) SetEPINTCLR_EPCLR13(value uint32) {
	volatile.StoreUint32(&o.EPINTCLR.Reg, volatile.LoadUint32(&o.EPINTCLR.Reg)&^(0x2000)|value<<13)
}
func (o *USB_Type) GetEPINTCLR_EPCLR13() uint32 {
	return (volatile.LoadUint32(&o.EPINTCLR.Reg) & 0x2000) >> 13
}
func (o *USB_Type) SetEPINTCLR_EPCLR14(value uint32) {
	volatile.StoreUint32(&o.EPINTCLR.Reg, volatile.LoadUint32(&o.EPINTCLR.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetEPINTCLR_EPCLR14() uint32 {
	return (volatile.LoadUint32(&o.EPINTCLR.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetEPINTCLR_EPCLR15(value uint32) {
	volatile.StoreUint32(&o.EPINTCLR.Reg, volatile.LoadUint32(&o.EPINTCLR.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetEPINTCLR_EPCLR15() uint32 {
	return (volatile.LoadUint32(&o.EPINTCLR.Reg) & 0x8000) >> 15
}
func (o *USB_Type) SetEPINTCLR_EPCLR16(value uint32) {
	volatile.StoreUint32(&o.EPINTCLR.Reg, volatile.LoadUint32(&o.EPINTCLR.Reg)&^(0x10000)|value<<16)
}
func (o *USB_Type) GetEPINTCLR_EPCLR16() uint32 {
	return (volatile.LoadUint32(&o.EPINTCLR.Reg) & 0x10000) >> 16
}
func (o *USB_Type) SetEPINTCLR_EPCLR17(value uint32) {
	volatile.StoreUint32(&o.EPINTCLR.Reg, volatile.LoadUint32(&o.EPINTCLR.Reg)&^(0x20000)|value<<17)
}
func (o *USB_Type) GetEPINTCLR_EPCLR17() uint32 {
	return (volatile.LoadUint32(&o.EPINTCLR.Reg) & 0x20000) >> 17
}
func (o *USB_Type) SetEPINTCLR_EPCLR18(value uint32) {
	volatile.StoreUint32(&o.EPINTCLR.Reg, volatile.LoadUint32(&o.EPINTCLR.Reg)&^(0x40000)|value<<18)
}
func (o *USB_Type) GetEPINTCLR_EPCLR18() uint32 {
	return (volatile.LoadUint32(&o.EPINTCLR.Reg) & 0x40000) >> 18
}
func (o *USB_Type) SetEPINTCLR_EPCLR19(value uint32) {
	volatile.StoreUint32(&o.EPINTCLR.Reg, volatile.LoadUint32(&o.EPINTCLR.Reg)&^(0x80000)|value<<19)
}
func (o *USB_Type) GetEPINTCLR_EPCLR19() uint32 {
	return (volatile.LoadUint32(&o.EPINTCLR.Reg) & 0x80000) >> 19
}
func (o *USB_Type) SetEPINTCLR_EPCLR20(value uint32) {
	volatile.StoreUint32(&o.EPINTCLR.Reg, volatile.LoadUint32(&o.EPINTCLR.Reg)&^(0x100000)|value<<20)
}
func (o *USB_Type) GetEPINTCLR_EPCLR20() uint32 {
	return (volatile.LoadUint32(&o.EPINTCLR.Reg) & 0x100000) >> 20
}
func (o *USB_Type) SetEPINTCLR_EPCLR21(value uint32) {
	volatile.StoreUint32(&o.EPINTCLR.Reg, volatile.LoadUint32(&o.EPINTCLR.Reg)&^(0x200000)|value<<21)
}
func (o *USB_Type) GetEPINTCLR_EPCLR21() uint32 {
	return (volatile.LoadUint32(&o.EPINTCLR.Reg) & 0x200000) >> 21
}
func (o *USB_Type) SetEPINTCLR_EPCLR22(value uint32) {
	volatile.StoreUint32(&o.EPINTCLR.Reg, volatile.LoadUint32(&o.EPINTCLR.Reg)&^(0x400000)|value<<22)
}
func (o *USB_Type) GetEPINTCLR_EPCLR22() uint32 {
	return (volatile.LoadUint32(&o.EPINTCLR.Reg) & 0x400000) >> 22
}
func (o *USB_Type) SetEPINTCLR_EPCLR23(value uint32) {
	volatile.StoreUint32(&o.EPINTCLR.Reg, volatile.LoadUint32(&o.EPINTCLR.Reg)&^(0x800000)|value<<23)
}
func (o *USB_Type) GetEPINTCLR_EPCLR23() uint32 {
	return (volatile.LoadUint32(&o.EPINTCLR.Reg) & 0x800000) >> 23
}
func (o *USB_Type) SetEPINTCLR_EPCLR24(value uint32) {
	volatile.StoreUint32(&o.EPINTCLR.Reg, volatile.LoadUint32(&o.EPINTCLR.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_Type) GetEPINTCLR_EPCLR24() uint32 {
	return (volatile.LoadUint32(&o.EPINTCLR.Reg) & 0x1000000) >> 24
}
func (o *USB_Type) SetEPINTCLR_EPCLR25(value uint32) {
	volatile.StoreUint32(&o.EPINTCLR.Reg, volatile.LoadUint32(&o.EPINTCLR.Reg)&^(0x2000000)|value<<25)
}
func (o *USB_Type) GetEPINTCLR_EPCLR25() uint32 {
	return (volatile.LoadUint32(&o.EPINTCLR.Reg) & 0x2000000) >> 25
}
func (o *USB_Type) SetEPINTCLR_EPCLR26(value uint32) {
	volatile.StoreUint32(&o.EPINTCLR.Reg, volatile.LoadUint32(&o.EPINTCLR.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_Type) GetEPINTCLR_EPCLR26() uint32 {
	return (volatile.LoadUint32(&o.EPINTCLR.Reg) & 0x4000000) >> 26
}
func (o *USB_Type) SetEPINTCLR_EPCLR27(value uint32) {
	volatile.StoreUint32(&o.EPINTCLR.Reg, volatile.LoadUint32(&o.EPINTCLR.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_Type) GetEPINTCLR_EPCLR27() uint32 {
	return (volatile.LoadUint32(&o.EPINTCLR.Reg) & 0x8000000) >> 27
}
func (o *USB_Type) SetEPINTCLR_EPCLR28(value uint32) {
	volatile.StoreUint32(&o.EPINTCLR.Reg, volatile.LoadUint32(&o.EPINTCLR.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_Type) GetEPINTCLR_EPCLR28() uint32 {
	return (volatile.LoadUint32(&o.EPINTCLR.Reg) & 0x10000000) >> 28
}
func (o *USB_Type) SetEPINTCLR_EPCLR29(value uint32) {
	volatile.StoreUint32(&o.EPINTCLR.Reg, volatile.LoadUint32(&o.EPINTCLR.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_Type) GetEPINTCLR_EPCLR29() uint32 {
	return (volatile.LoadUint32(&o.EPINTCLR.Reg) & 0x20000000) >> 29
}
func (o *USB_Type) SetEPINTCLR_EPCLR30(value uint32) {
	volatile.StoreUint32(&o.EPINTCLR.Reg, volatile.LoadUint32(&o.EPINTCLR.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_Type) GetEPINTCLR_EPCLR30() uint32 {
	return (volatile.LoadUint32(&o.EPINTCLR.Reg) & 0x40000000) >> 30
}
func (o *USB_Type) SetEPINTCLR_EPCLR31(value uint32) {
	volatile.StoreUint32(&o.EPINTCLR.Reg, volatile.LoadUint32(&o.EPINTCLR.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_Type) GetEPINTCLR_EPCLR31() uint32 {
	return (volatile.LoadUint32(&o.EPINTCLR.Reg) & 0x80000000) >> 31
}

// USB.EPINTSET: USB Endpoint Interrupt Set
func (o *USB_Type) SetEPINTSET_EPSET0(value uint32) {
	volatile.StoreUint32(&o.EPINTSET.Reg, volatile.LoadUint32(&o.EPINTSET.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetEPINTSET_EPSET0() uint32 {
	return volatile.LoadUint32(&o.EPINTSET.Reg) & 0x1
}
func (o *USB_Type) SetEPINTSET_EPSET1(value uint32) {
	volatile.StoreUint32(&o.EPINTSET.Reg, volatile.LoadUint32(&o.EPINTSET.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetEPINTSET_EPSET1() uint32 {
	return (volatile.LoadUint32(&o.EPINTSET.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetEPINTSET_EPSET2(value uint32) {
	volatile.StoreUint32(&o.EPINTSET.Reg, volatile.LoadUint32(&o.EPINTSET.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetEPINTSET_EPSET2() uint32 {
	return (volatile.LoadUint32(&o.EPINTSET.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetEPINTSET_EPSET3(value uint32) {
	volatile.StoreUint32(&o.EPINTSET.Reg, volatile.LoadUint32(&o.EPINTSET.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetEPINTSET_EPSET3() uint32 {
	return (volatile.LoadUint32(&o.EPINTSET.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetEPINTSET_EPSET4(value uint32) {
	volatile.StoreUint32(&o.EPINTSET.Reg, volatile.LoadUint32(&o.EPINTSET.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetEPINTSET_EPSET4() uint32 {
	return (volatile.LoadUint32(&o.EPINTSET.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetEPINTSET_EPSET5(value uint32) {
	volatile.StoreUint32(&o.EPINTSET.Reg, volatile.LoadUint32(&o.EPINTSET.Reg)&^(0x20)|value<<5)
}
func (o *USB_Type) GetEPINTSET_EPSET5() uint32 {
	return (volatile.LoadUint32(&o.EPINTSET.Reg) & 0x20) >> 5
}
func (o *USB_Type) SetEPINTSET_EPSET6(value uint32) {
	volatile.StoreUint32(&o.EPINTSET.Reg, volatile.LoadUint32(&o.EPINTSET.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetEPINTSET_EPSET6() uint32 {
	return (volatile.LoadUint32(&o.EPINTSET.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetEPINTSET_EPSET7(value uint32) {
	volatile.StoreUint32(&o.EPINTSET.Reg, volatile.LoadUint32(&o.EPINTSET.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetEPINTSET_EPSET7() uint32 {
	return (volatile.LoadUint32(&o.EPINTSET.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetEPINTSET_EPSET8(value uint32) {
	volatile.StoreUint32(&o.EPINTSET.Reg, volatile.LoadUint32(&o.EPINTSET.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetEPINTSET_EPSET8() uint32 {
	return (volatile.LoadUint32(&o.EPINTSET.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetEPINTSET_EPSET9(value uint32) {
	volatile.StoreUint32(&o.EPINTSET.Reg, volatile.LoadUint32(&o.EPINTSET.Reg)&^(0x200)|value<<9)
}
func (o *USB_Type) GetEPINTSET_EPSET9() uint32 {
	return (volatile.LoadUint32(&o.EPINTSET.Reg) & 0x200) >> 9
}
func (o *USB_Type) SetEPINTSET_EPSET10(value uint32) {
	volatile.StoreUint32(&o.EPINTSET.Reg, volatile.LoadUint32(&o.EPINTSET.Reg)&^(0x400)|value<<10)
}
func (o *USB_Type) GetEPINTSET_EPSET10() uint32 {
	return (volatile.LoadUint32(&o.EPINTSET.Reg) & 0x400) >> 10
}
func (o *USB_Type) SetEPINTSET_EPSET11(value uint32) {
	volatile.StoreUint32(&o.EPINTSET.Reg, volatile.LoadUint32(&o.EPINTSET.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetEPINTSET_EPSET11() uint32 {
	return (volatile.LoadUint32(&o.EPINTSET.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetEPINTSET_EPSET12(value uint32) {
	volatile.StoreUint32(&o.EPINTSET.Reg, volatile.LoadUint32(&o.EPINTSET.Reg)&^(0x1000)|value<<12)
}
func (o *USB_Type) GetEPINTSET_EPSET12() uint32 {
	return (volatile.LoadUint32(&o.EPINTSET.Reg) & 0x1000) >> 12
}
func (o *USB_Type) SetEPINTSET_EPSET13(value uint32) {
	volatile.StoreUint32(&o.EPINTSET.Reg, volatile.LoadUint32(&o.EPINTSET.Reg)&^(0x2000)|value<<13)
}
func (o *USB_Type) GetEPINTSET_EPSET13() uint32 {
	return (volatile.LoadUint32(&o.EPINTSET.Reg) & 0x2000) >> 13
}
func (o *USB_Type) SetEPINTSET_EPSET14(value uint32) {
	volatile.StoreUint32(&o.EPINTSET.Reg, volatile.LoadUint32(&o.EPINTSET.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetEPINTSET_EPSET14() uint32 {
	return (volatile.LoadUint32(&o.EPINTSET.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetEPINTSET_EPSET15(value uint32) {
	volatile.StoreUint32(&o.EPINTSET.Reg, volatile.LoadUint32(&o.EPINTSET.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetEPINTSET_EPSET15() uint32 {
	return (volatile.LoadUint32(&o.EPINTSET.Reg) & 0x8000) >> 15
}
func (o *USB_Type) SetEPINTSET_EPSET16(value uint32) {
	volatile.StoreUint32(&o.EPINTSET.Reg, volatile.LoadUint32(&o.EPINTSET.Reg)&^(0x10000)|value<<16)
}
func (o *USB_Type) GetEPINTSET_EPSET16() uint32 {
	return (volatile.LoadUint32(&o.EPINTSET.Reg) & 0x10000) >> 16
}
func (o *USB_Type) SetEPINTSET_EPSET17(value uint32) {
	volatile.StoreUint32(&o.EPINTSET.Reg, volatile.LoadUint32(&o.EPINTSET.Reg)&^(0x20000)|value<<17)
}
func (o *USB_Type) GetEPINTSET_EPSET17() uint32 {
	return (volatile.LoadUint32(&o.EPINTSET.Reg) & 0x20000) >> 17
}
func (o *USB_Type) SetEPINTSET_EPSET18(value uint32) {
	volatile.StoreUint32(&o.EPINTSET.Reg, volatile.LoadUint32(&o.EPINTSET.Reg)&^(0x40000)|value<<18)
}
func (o *USB_Type) GetEPINTSET_EPSET18() uint32 {
	return (volatile.LoadUint32(&o.EPINTSET.Reg) & 0x40000) >> 18
}
func (o *USB_Type) SetEPINTSET_EPSET19(value uint32) {
	volatile.StoreUint32(&o.EPINTSET.Reg, volatile.LoadUint32(&o.EPINTSET.Reg)&^(0x80000)|value<<19)
}
func (o *USB_Type) GetEPINTSET_EPSET19() uint32 {
	return (volatile.LoadUint32(&o.EPINTSET.Reg) & 0x80000) >> 19
}
func (o *USB_Type) SetEPINTSET_EPSET20(value uint32) {
	volatile.StoreUint32(&o.EPINTSET.Reg, volatile.LoadUint32(&o.EPINTSET.Reg)&^(0x100000)|value<<20)
}
func (o *USB_Type) GetEPINTSET_EPSET20() uint32 {
	return (volatile.LoadUint32(&o.EPINTSET.Reg) & 0x100000) >> 20
}
func (o *USB_Type) SetEPINTSET_EPSET21(value uint32) {
	volatile.StoreUint32(&o.EPINTSET.Reg, volatile.LoadUint32(&o.EPINTSET.Reg)&^(0x200000)|value<<21)
}
func (o *USB_Type) GetEPINTSET_EPSET21() uint32 {
	return (volatile.LoadUint32(&o.EPINTSET.Reg) & 0x200000) >> 21
}
func (o *USB_Type) SetEPINTSET_EPSET22(value uint32) {
	volatile.StoreUint32(&o.EPINTSET.Reg, volatile.LoadUint32(&o.EPINTSET.Reg)&^(0x400000)|value<<22)
}
func (o *USB_Type) GetEPINTSET_EPSET22() uint32 {
	return (volatile.LoadUint32(&o.EPINTSET.Reg) & 0x400000) >> 22
}
func (o *USB_Type) SetEPINTSET_EPSET23(value uint32) {
	volatile.StoreUint32(&o.EPINTSET.Reg, volatile.LoadUint32(&o.EPINTSET.Reg)&^(0x800000)|value<<23)
}
func (o *USB_Type) GetEPINTSET_EPSET23() uint32 {
	return (volatile.LoadUint32(&o.EPINTSET.Reg) & 0x800000) >> 23
}
func (o *USB_Type) SetEPINTSET_EPSET24(value uint32) {
	volatile.StoreUint32(&o.EPINTSET.Reg, volatile.LoadUint32(&o.EPINTSET.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_Type) GetEPINTSET_EPSET24() uint32 {
	return (volatile.LoadUint32(&o.EPINTSET.Reg) & 0x1000000) >> 24
}
func (o *USB_Type) SetEPINTSET_EPSET25(value uint32) {
	volatile.StoreUint32(&o.EPINTSET.Reg, volatile.LoadUint32(&o.EPINTSET.Reg)&^(0x2000000)|value<<25)
}
func (o *USB_Type) GetEPINTSET_EPSET25() uint32 {
	return (volatile.LoadUint32(&o.EPINTSET.Reg) & 0x2000000) >> 25
}
func (o *USB_Type) SetEPINTSET_EPSET26(value uint32) {
	volatile.StoreUint32(&o.EPINTSET.Reg, volatile.LoadUint32(&o.EPINTSET.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_Type) GetEPINTSET_EPSET26() uint32 {
	return (volatile.LoadUint32(&o.EPINTSET.Reg) & 0x4000000) >> 26
}
func (o *USB_Type) SetEPINTSET_EPSET27(value uint32) {
	volatile.StoreUint32(&o.EPINTSET.Reg, volatile.LoadUint32(&o.EPINTSET.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_Type) GetEPINTSET_EPSET27() uint32 {
	return (volatile.LoadUint32(&o.EPINTSET.Reg) & 0x8000000) >> 27
}
func (o *USB_Type) SetEPINTSET_EPSET28(value uint32) {
	volatile.StoreUint32(&o.EPINTSET.Reg, volatile.LoadUint32(&o.EPINTSET.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_Type) GetEPINTSET_EPSET28() uint32 {
	return (volatile.LoadUint32(&o.EPINTSET.Reg) & 0x10000000) >> 28
}
func (o *USB_Type) SetEPINTSET_EPSET29(value uint32) {
	volatile.StoreUint32(&o.EPINTSET.Reg, volatile.LoadUint32(&o.EPINTSET.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_Type) GetEPINTSET_EPSET29() uint32 {
	return (volatile.LoadUint32(&o.EPINTSET.Reg) & 0x20000000) >> 29
}
func (o *USB_Type) SetEPINTSET_EPSET30(value uint32) {
	volatile.StoreUint32(&o.EPINTSET.Reg, volatile.LoadUint32(&o.EPINTSET.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_Type) GetEPINTSET_EPSET30() uint32 {
	return (volatile.LoadUint32(&o.EPINTSET.Reg) & 0x40000000) >> 30
}
func (o *USB_Type) SetEPINTSET_EPSET31(value uint32) {
	volatile.StoreUint32(&o.EPINTSET.Reg, volatile.LoadUint32(&o.EPINTSET.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_Type) GetEPINTSET_EPSET31() uint32 {
	return (volatile.LoadUint32(&o.EPINTSET.Reg) & 0x80000000) >> 31
}

// USB.EPINTPRI: USB Endpoint Priority
func (o *USB_Type) SetEPINTPRI_EPPRI0(value uint32) {
	volatile.StoreUint32(&o.EPINTPRI.Reg, volatile.LoadUint32(&o.EPINTPRI.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetEPINTPRI_EPPRI0() uint32 {
	return volatile.LoadUint32(&o.EPINTPRI.Reg) & 0x1
}
func (o *USB_Type) SetEPINTPRI_EPPRI1(value uint32) {
	volatile.StoreUint32(&o.EPINTPRI.Reg, volatile.LoadUint32(&o.EPINTPRI.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetEPINTPRI_EPPRI1() uint32 {
	return (volatile.LoadUint32(&o.EPINTPRI.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetEPINTPRI_EPPRI2(value uint32) {
	volatile.StoreUint32(&o.EPINTPRI.Reg, volatile.LoadUint32(&o.EPINTPRI.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetEPINTPRI_EPPRI2() uint32 {
	return (volatile.LoadUint32(&o.EPINTPRI.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetEPINTPRI_EPPRI3(value uint32) {
	volatile.StoreUint32(&o.EPINTPRI.Reg, volatile.LoadUint32(&o.EPINTPRI.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetEPINTPRI_EPPRI3() uint32 {
	return (volatile.LoadUint32(&o.EPINTPRI.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetEPINTPRI_EPPRI4(value uint32) {
	volatile.StoreUint32(&o.EPINTPRI.Reg, volatile.LoadUint32(&o.EPINTPRI.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetEPINTPRI_EPPRI4() uint32 {
	return (volatile.LoadUint32(&o.EPINTPRI.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetEPINTPRI_EPPRI5(value uint32) {
	volatile.StoreUint32(&o.EPINTPRI.Reg, volatile.LoadUint32(&o.EPINTPRI.Reg)&^(0x20)|value<<5)
}
func (o *USB_Type) GetEPINTPRI_EPPRI5() uint32 {
	return (volatile.LoadUint32(&o.EPINTPRI.Reg) & 0x20) >> 5
}
func (o *USB_Type) SetEPINTPRI_EPPRI6(value uint32) {
	volatile.StoreUint32(&o.EPINTPRI.Reg, volatile.LoadUint32(&o.EPINTPRI.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetEPINTPRI_EPPRI6() uint32 {
	return (volatile.LoadUint32(&o.EPINTPRI.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetEPINTPRI_EPPRI7(value uint32) {
	volatile.StoreUint32(&o.EPINTPRI.Reg, volatile.LoadUint32(&o.EPINTPRI.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetEPINTPRI_EPPRI7() uint32 {
	return (volatile.LoadUint32(&o.EPINTPRI.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetEPINTPRI_EPPRI8(value uint32) {
	volatile.StoreUint32(&o.EPINTPRI.Reg, volatile.LoadUint32(&o.EPINTPRI.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetEPINTPRI_EPPRI8() uint32 {
	return (volatile.LoadUint32(&o.EPINTPRI.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetEPINTPRI_EPPRI9(value uint32) {
	volatile.StoreUint32(&o.EPINTPRI.Reg, volatile.LoadUint32(&o.EPINTPRI.Reg)&^(0x200)|value<<9)
}
func (o *USB_Type) GetEPINTPRI_EPPRI9() uint32 {
	return (volatile.LoadUint32(&o.EPINTPRI.Reg) & 0x200) >> 9
}
func (o *USB_Type) SetEPINTPRI_EPPRI10(value uint32) {
	volatile.StoreUint32(&o.EPINTPRI.Reg, volatile.LoadUint32(&o.EPINTPRI.Reg)&^(0x400)|value<<10)
}
func (o *USB_Type) GetEPINTPRI_EPPRI10() uint32 {
	return (volatile.LoadUint32(&o.EPINTPRI.Reg) & 0x400) >> 10
}
func (o *USB_Type) SetEPINTPRI_EPPRI11(value uint32) {
	volatile.StoreUint32(&o.EPINTPRI.Reg, volatile.LoadUint32(&o.EPINTPRI.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetEPINTPRI_EPPRI11() uint32 {
	return (volatile.LoadUint32(&o.EPINTPRI.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetEPINTPRI_EPPRI12(value uint32) {
	volatile.StoreUint32(&o.EPINTPRI.Reg, volatile.LoadUint32(&o.EPINTPRI.Reg)&^(0x1000)|value<<12)
}
func (o *USB_Type) GetEPINTPRI_EPPRI12() uint32 {
	return (volatile.LoadUint32(&o.EPINTPRI.Reg) & 0x1000) >> 12
}
func (o *USB_Type) SetEPINTPRI_EPPRI13(value uint32) {
	volatile.StoreUint32(&o.EPINTPRI.Reg, volatile.LoadUint32(&o.EPINTPRI.Reg)&^(0x2000)|value<<13)
}
func (o *USB_Type) GetEPINTPRI_EPPRI13() uint32 {
	return (volatile.LoadUint32(&o.EPINTPRI.Reg) & 0x2000) >> 13
}
func (o *USB_Type) SetEPINTPRI_EPPRI14(value uint32) {
	volatile.StoreUint32(&o.EPINTPRI.Reg, volatile.LoadUint32(&o.EPINTPRI.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetEPINTPRI_EPPRI14() uint32 {
	return (volatile.LoadUint32(&o.EPINTPRI.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetEPINTPRI_EPPRI15(value uint32) {
	volatile.StoreUint32(&o.EPINTPRI.Reg, volatile.LoadUint32(&o.EPINTPRI.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetEPINTPRI_EPPRI15() uint32 {
	return (volatile.LoadUint32(&o.EPINTPRI.Reg) & 0x8000) >> 15
}
func (o *USB_Type) SetEPINTPRI_EPPRI16(value uint32) {
	volatile.StoreUint32(&o.EPINTPRI.Reg, volatile.LoadUint32(&o.EPINTPRI.Reg)&^(0x10000)|value<<16)
}
func (o *USB_Type) GetEPINTPRI_EPPRI16() uint32 {
	return (volatile.LoadUint32(&o.EPINTPRI.Reg) & 0x10000) >> 16
}
func (o *USB_Type) SetEPINTPRI_EPPRI17(value uint32) {
	volatile.StoreUint32(&o.EPINTPRI.Reg, volatile.LoadUint32(&o.EPINTPRI.Reg)&^(0x20000)|value<<17)
}
func (o *USB_Type) GetEPINTPRI_EPPRI17() uint32 {
	return (volatile.LoadUint32(&o.EPINTPRI.Reg) & 0x20000) >> 17
}
func (o *USB_Type) SetEPINTPRI_EPPRI18(value uint32) {
	volatile.StoreUint32(&o.EPINTPRI.Reg, volatile.LoadUint32(&o.EPINTPRI.Reg)&^(0x40000)|value<<18)
}
func (o *USB_Type) GetEPINTPRI_EPPRI18() uint32 {
	return (volatile.LoadUint32(&o.EPINTPRI.Reg) & 0x40000) >> 18
}
func (o *USB_Type) SetEPINTPRI_EPPRI19(value uint32) {
	volatile.StoreUint32(&o.EPINTPRI.Reg, volatile.LoadUint32(&o.EPINTPRI.Reg)&^(0x80000)|value<<19)
}
func (o *USB_Type) GetEPINTPRI_EPPRI19() uint32 {
	return (volatile.LoadUint32(&o.EPINTPRI.Reg) & 0x80000) >> 19
}
func (o *USB_Type) SetEPINTPRI_EPPRI20(value uint32) {
	volatile.StoreUint32(&o.EPINTPRI.Reg, volatile.LoadUint32(&o.EPINTPRI.Reg)&^(0x100000)|value<<20)
}
func (o *USB_Type) GetEPINTPRI_EPPRI20() uint32 {
	return (volatile.LoadUint32(&o.EPINTPRI.Reg) & 0x100000) >> 20
}
func (o *USB_Type) SetEPINTPRI_EPPRI21(value uint32) {
	volatile.StoreUint32(&o.EPINTPRI.Reg, volatile.LoadUint32(&o.EPINTPRI.Reg)&^(0x200000)|value<<21)
}
func (o *USB_Type) GetEPINTPRI_EPPRI21() uint32 {
	return (volatile.LoadUint32(&o.EPINTPRI.Reg) & 0x200000) >> 21
}
func (o *USB_Type) SetEPINTPRI_EPPRI22(value uint32) {
	volatile.StoreUint32(&o.EPINTPRI.Reg, volatile.LoadUint32(&o.EPINTPRI.Reg)&^(0x400000)|value<<22)
}
func (o *USB_Type) GetEPINTPRI_EPPRI22() uint32 {
	return (volatile.LoadUint32(&o.EPINTPRI.Reg) & 0x400000) >> 22
}
func (o *USB_Type) SetEPINTPRI_EPPRI23(value uint32) {
	volatile.StoreUint32(&o.EPINTPRI.Reg, volatile.LoadUint32(&o.EPINTPRI.Reg)&^(0x800000)|value<<23)
}
func (o *USB_Type) GetEPINTPRI_EPPRI23() uint32 {
	return (volatile.LoadUint32(&o.EPINTPRI.Reg) & 0x800000) >> 23
}
func (o *USB_Type) SetEPINTPRI_EPPRI24(value uint32) {
	volatile.StoreUint32(&o.EPINTPRI.Reg, volatile.LoadUint32(&o.EPINTPRI.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_Type) GetEPINTPRI_EPPRI24() uint32 {
	return (volatile.LoadUint32(&o.EPINTPRI.Reg) & 0x1000000) >> 24
}
func (o *USB_Type) SetEPINTPRI_EPPRI25(value uint32) {
	volatile.StoreUint32(&o.EPINTPRI.Reg, volatile.LoadUint32(&o.EPINTPRI.Reg)&^(0x2000000)|value<<25)
}
func (o *USB_Type) GetEPINTPRI_EPPRI25() uint32 {
	return (volatile.LoadUint32(&o.EPINTPRI.Reg) & 0x2000000) >> 25
}
func (o *USB_Type) SetEPINTPRI_EPPRI26(value uint32) {
	volatile.StoreUint32(&o.EPINTPRI.Reg, volatile.LoadUint32(&o.EPINTPRI.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_Type) GetEPINTPRI_EPPRI26() uint32 {
	return (volatile.LoadUint32(&o.EPINTPRI.Reg) & 0x4000000) >> 26
}
func (o *USB_Type) SetEPINTPRI_EPPRI27(value uint32) {
	volatile.StoreUint32(&o.EPINTPRI.Reg, volatile.LoadUint32(&o.EPINTPRI.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_Type) GetEPINTPRI_EPPRI27() uint32 {
	return (volatile.LoadUint32(&o.EPINTPRI.Reg) & 0x8000000) >> 27
}
func (o *USB_Type) SetEPINTPRI_EPPRI28(value uint32) {
	volatile.StoreUint32(&o.EPINTPRI.Reg, volatile.LoadUint32(&o.EPINTPRI.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_Type) GetEPINTPRI_EPPRI28() uint32 {
	return (volatile.LoadUint32(&o.EPINTPRI.Reg) & 0x10000000) >> 28
}
func (o *USB_Type) SetEPINTPRI_EPPRI29(value uint32) {
	volatile.StoreUint32(&o.EPINTPRI.Reg, volatile.LoadUint32(&o.EPINTPRI.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_Type) GetEPINTPRI_EPPRI29() uint32 {
	return (volatile.LoadUint32(&o.EPINTPRI.Reg) & 0x20000000) >> 29
}
func (o *USB_Type) SetEPINTPRI_EPPRI30(value uint32) {
	volatile.StoreUint32(&o.EPINTPRI.Reg, volatile.LoadUint32(&o.EPINTPRI.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_Type) GetEPINTPRI_EPPRI30() uint32 {
	return (volatile.LoadUint32(&o.EPINTPRI.Reg) & 0x40000000) >> 30
}
func (o *USB_Type) SetEPINTPRI_EPPRI31(value uint32) {
	volatile.StoreUint32(&o.EPINTPRI.Reg, volatile.LoadUint32(&o.EPINTPRI.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_Type) GetEPINTPRI_EPPRI31() uint32 {
	return (volatile.LoadUint32(&o.EPINTPRI.Reg) & 0x80000000) >> 31
}

// USB.REEP: USB Realize Endpoint
func (o *USB_Type) SetREEP_EPR0(value uint32) {
	volatile.StoreUint32(&o.REEP.Reg, volatile.LoadUint32(&o.REEP.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetREEP_EPR0() uint32 {
	return volatile.LoadUint32(&o.REEP.Reg) & 0x1
}
func (o *USB_Type) SetREEP_EPR1(value uint32) {
	volatile.StoreUint32(&o.REEP.Reg, volatile.LoadUint32(&o.REEP.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetREEP_EPR1() uint32 {
	return (volatile.LoadUint32(&o.REEP.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetREEP_EPR2(value uint32) {
	volatile.StoreUint32(&o.REEP.Reg, volatile.LoadUint32(&o.REEP.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetREEP_EPR2() uint32 {
	return (volatile.LoadUint32(&o.REEP.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetREEP_EPR3(value uint32) {
	volatile.StoreUint32(&o.REEP.Reg, volatile.LoadUint32(&o.REEP.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetREEP_EPR3() uint32 {
	return (volatile.LoadUint32(&o.REEP.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetREEP_EPR4(value uint32) {
	volatile.StoreUint32(&o.REEP.Reg, volatile.LoadUint32(&o.REEP.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetREEP_EPR4() uint32 {
	return (volatile.LoadUint32(&o.REEP.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetREEP_EPR5(value uint32) {
	volatile.StoreUint32(&o.REEP.Reg, volatile.LoadUint32(&o.REEP.Reg)&^(0x20)|value<<5)
}
func (o *USB_Type) GetREEP_EPR5() uint32 {
	return (volatile.LoadUint32(&o.REEP.Reg) & 0x20) >> 5
}
func (o *USB_Type) SetREEP_EPR6(value uint32) {
	volatile.StoreUint32(&o.REEP.Reg, volatile.LoadUint32(&o.REEP.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetREEP_EPR6() uint32 {
	return (volatile.LoadUint32(&o.REEP.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetREEP_EPR7(value uint32) {
	volatile.StoreUint32(&o.REEP.Reg, volatile.LoadUint32(&o.REEP.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetREEP_EPR7() uint32 {
	return (volatile.LoadUint32(&o.REEP.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetREEP_EPR8(value uint32) {
	volatile.StoreUint32(&o.REEP.Reg, volatile.LoadUint32(&o.REEP.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetREEP_EPR8() uint32 {
	return (volatile.LoadUint32(&o.REEP.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetREEP_EPR9(value uint32) {
	volatile.StoreUint32(&o.REEP.Reg, volatile.LoadUint32(&o.REEP.Reg)&^(0x200)|value<<9)
}
func (o *USB_Type) GetREEP_EPR9() uint32 {
	return (volatile.LoadUint32(&o.REEP.Reg) & 0x200) >> 9
}
func (o *USB_Type) SetREEP_EPR10(value uint32) {
	volatile.StoreUint32(&o.REEP.Reg, volatile.LoadUint32(&o.REEP.Reg)&^(0x400)|value<<10)
}
func (o *USB_Type) GetREEP_EPR10() uint32 {
	return (volatile.LoadUint32(&o.REEP.Reg) & 0x400) >> 10
}
func (o *USB_Type) SetREEP_EPR11(value uint32) {
	volatile.StoreUint32(&o.REEP.Reg, volatile.LoadUint32(&o.REEP.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetREEP_EPR11() uint32 {
	return (volatile.LoadUint32(&o.REEP.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetREEP_EPR12(value uint32) {
	volatile.StoreUint32(&o.REEP.Reg, volatile.LoadUint32(&o.REEP.Reg)&^(0x1000)|value<<12)
}
func (o *USB_Type) GetREEP_EPR12() uint32 {
	return (volatile.LoadUint32(&o.REEP.Reg) & 0x1000) >> 12
}
func (o *USB_Type) SetREEP_EPR13(value uint32) {
	volatile.StoreUint32(&o.REEP.Reg, volatile.LoadUint32(&o.REEP.Reg)&^(0x2000)|value<<13)
}
func (o *USB_Type) GetREEP_EPR13() uint32 {
	return (volatile.LoadUint32(&o.REEP.Reg) & 0x2000) >> 13
}
func (o *USB_Type) SetREEP_EPR14(value uint32) {
	volatile.StoreUint32(&o.REEP.Reg, volatile.LoadUint32(&o.REEP.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetREEP_EPR14() uint32 {
	return (volatile.LoadUint32(&o.REEP.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetREEP_EPR15(value uint32) {
	volatile.StoreUint32(&o.REEP.Reg, volatile.LoadUint32(&o.REEP.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetREEP_EPR15() uint32 {
	return (volatile.LoadUint32(&o.REEP.Reg) & 0x8000) >> 15
}
func (o *USB_Type) SetREEP_EPR16(value uint32) {
	volatile.StoreUint32(&o.REEP.Reg, volatile.LoadUint32(&o.REEP.Reg)&^(0x10000)|value<<16)
}
func (o *USB_Type) GetREEP_EPR16() uint32 {
	return (volatile.LoadUint32(&o.REEP.Reg) & 0x10000) >> 16
}
func (o *USB_Type) SetREEP_EPR17(value uint32) {
	volatile.StoreUint32(&o.REEP.Reg, volatile.LoadUint32(&o.REEP.Reg)&^(0x20000)|value<<17)
}
func (o *USB_Type) GetREEP_EPR17() uint32 {
	return (volatile.LoadUint32(&o.REEP.Reg) & 0x20000) >> 17
}
func (o *USB_Type) SetREEP_EPR18(value uint32) {
	volatile.StoreUint32(&o.REEP.Reg, volatile.LoadUint32(&o.REEP.Reg)&^(0x40000)|value<<18)
}
func (o *USB_Type) GetREEP_EPR18() uint32 {
	return (volatile.LoadUint32(&o.REEP.Reg) & 0x40000) >> 18
}
func (o *USB_Type) SetREEP_EPR19(value uint32) {
	volatile.StoreUint32(&o.REEP.Reg, volatile.LoadUint32(&o.REEP.Reg)&^(0x80000)|value<<19)
}
func (o *USB_Type) GetREEP_EPR19() uint32 {
	return (volatile.LoadUint32(&o.REEP.Reg) & 0x80000) >> 19
}
func (o *USB_Type) SetREEP_EPR20(value uint32) {
	volatile.StoreUint32(&o.REEP.Reg, volatile.LoadUint32(&o.REEP.Reg)&^(0x100000)|value<<20)
}
func (o *USB_Type) GetREEP_EPR20() uint32 {
	return (volatile.LoadUint32(&o.REEP.Reg) & 0x100000) >> 20
}
func (o *USB_Type) SetREEP_EPR21(value uint32) {
	volatile.StoreUint32(&o.REEP.Reg, volatile.LoadUint32(&o.REEP.Reg)&^(0x200000)|value<<21)
}
func (o *USB_Type) GetREEP_EPR21() uint32 {
	return (volatile.LoadUint32(&o.REEP.Reg) & 0x200000) >> 21
}
func (o *USB_Type) SetREEP_EPR22(value uint32) {
	volatile.StoreUint32(&o.REEP.Reg, volatile.LoadUint32(&o.REEP.Reg)&^(0x400000)|value<<22)
}
func (o *USB_Type) GetREEP_EPR22() uint32 {
	return (volatile.LoadUint32(&o.REEP.Reg) & 0x400000) >> 22
}
func (o *USB_Type) SetREEP_EPR23(value uint32) {
	volatile.StoreUint32(&o.REEP.Reg, volatile.LoadUint32(&o.REEP.Reg)&^(0x800000)|value<<23)
}
func (o *USB_Type) GetREEP_EPR23() uint32 {
	return (volatile.LoadUint32(&o.REEP.Reg) & 0x800000) >> 23
}
func (o *USB_Type) SetREEP_EPR24(value uint32) {
	volatile.StoreUint32(&o.REEP.Reg, volatile.LoadUint32(&o.REEP.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_Type) GetREEP_EPR24() uint32 {
	return (volatile.LoadUint32(&o.REEP.Reg) & 0x1000000) >> 24
}
func (o *USB_Type) SetREEP_EPR25(value uint32) {
	volatile.StoreUint32(&o.REEP.Reg, volatile.LoadUint32(&o.REEP.Reg)&^(0x2000000)|value<<25)
}
func (o *USB_Type) GetREEP_EPR25() uint32 {
	return (volatile.LoadUint32(&o.REEP.Reg) & 0x2000000) >> 25
}
func (o *USB_Type) SetREEP_EPR26(value uint32) {
	volatile.StoreUint32(&o.REEP.Reg, volatile.LoadUint32(&o.REEP.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_Type) GetREEP_EPR26() uint32 {
	return (volatile.LoadUint32(&o.REEP.Reg) & 0x4000000) >> 26
}
func (o *USB_Type) SetREEP_EPR27(value uint32) {
	volatile.StoreUint32(&o.REEP.Reg, volatile.LoadUint32(&o.REEP.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_Type) GetREEP_EPR27() uint32 {
	return (volatile.LoadUint32(&o.REEP.Reg) & 0x8000000) >> 27
}
func (o *USB_Type) SetREEP_EPR28(value uint32) {
	volatile.StoreUint32(&o.REEP.Reg, volatile.LoadUint32(&o.REEP.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_Type) GetREEP_EPR28() uint32 {
	return (volatile.LoadUint32(&o.REEP.Reg) & 0x10000000) >> 28
}
func (o *USB_Type) SetREEP_EPR29(value uint32) {
	volatile.StoreUint32(&o.REEP.Reg, volatile.LoadUint32(&o.REEP.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_Type) GetREEP_EPR29() uint32 {
	return (volatile.LoadUint32(&o.REEP.Reg) & 0x20000000) >> 29
}
func (o *USB_Type) SetREEP_EPR30(value uint32) {
	volatile.StoreUint32(&o.REEP.Reg, volatile.LoadUint32(&o.REEP.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_Type) GetREEP_EPR30() uint32 {
	return (volatile.LoadUint32(&o.REEP.Reg) & 0x40000000) >> 30
}
func (o *USB_Type) SetREEP_EPR31(value uint32) {
	volatile.StoreUint32(&o.REEP.Reg, volatile.LoadUint32(&o.REEP.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_Type) GetREEP_EPR31() uint32 {
	return (volatile.LoadUint32(&o.REEP.Reg) & 0x80000000) >> 31
}

// USB.EPIN: USB Endpoint Index
func (o *USB_Type) SetEPIN_PHY_EP(value uint32) {
	volatile.StoreUint32(&o.EPIN.Reg, volatile.LoadUint32(&o.EPIN.Reg)&^(0x1f)|value)
}
func (o *USB_Type) GetEPIN_PHY_EP() uint32 {
	return volatile.LoadUint32(&o.EPIN.Reg) & 0x1f
}
func (o *USB_Type) SetEPIN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EPIN.Reg, volatile.LoadUint32(&o.EPIN.Reg)&^(0xffffffe0)|value<<5)
}
func (o *USB_Type) GetEPIN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EPIN.Reg) & 0xffffffe0) >> 5
}

// USB.MAXPSIZE: USB MaxPacketSize
func (o *USB_Type) SetMAXPSIZE_MPS(value uint32) {
	volatile.StoreUint32(&o.MAXPSIZE.Reg, volatile.LoadUint32(&o.MAXPSIZE.Reg)&^(0x3ff)|value)
}
func (o *USB_Type) GetMAXPSIZE_MPS() uint32 {
	return volatile.LoadUint32(&o.MAXPSIZE.Reg) & 0x3ff
}
func (o *USB_Type) SetMAXPSIZE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MAXPSIZE.Reg, volatile.LoadUint32(&o.MAXPSIZE.Reg)&^(0xfffffc00)|value<<10)
}
func (o *USB_Type) GetMAXPSIZE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MAXPSIZE.Reg) & 0xfffffc00) >> 10
}

// USB.DMARST: USB DMA Request Status
func (o *USB_Type) SetDMARST_EPRST0(value uint32) {
	volatile.StoreUint32(&o.DMARST.Reg, volatile.LoadUint32(&o.DMARST.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetDMARST_EPRST0() uint32 {
	return volatile.LoadUint32(&o.DMARST.Reg) & 0x1
}
func (o *USB_Type) SetDMARST_EPRST1(value uint32) {
	volatile.StoreUint32(&o.DMARST.Reg, volatile.LoadUint32(&o.DMARST.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetDMARST_EPRST1() uint32 {
	return (volatile.LoadUint32(&o.DMARST.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetDMARST_EPRST2(value uint32) {
	volatile.StoreUint32(&o.DMARST.Reg, volatile.LoadUint32(&o.DMARST.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetDMARST_EPRST2() uint32 {
	return (volatile.LoadUint32(&o.DMARST.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetDMARST_EPRST3(value uint32) {
	volatile.StoreUint32(&o.DMARST.Reg, volatile.LoadUint32(&o.DMARST.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetDMARST_EPRST3() uint32 {
	return (volatile.LoadUint32(&o.DMARST.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetDMARST_EPRST4(value uint32) {
	volatile.StoreUint32(&o.DMARST.Reg, volatile.LoadUint32(&o.DMARST.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetDMARST_EPRST4() uint32 {
	return (volatile.LoadUint32(&o.DMARST.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetDMARST_EPRST5(value uint32) {
	volatile.StoreUint32(&o.DMARST.Reg, volatile.LoadUint32(&o.DMARST.Reg)&^(0x20)|value<<5)
}
func (o *USB_Type) GetDMARST_EPRST5() uint32 {
	return (volatile.LoadUint32(&o.DMARST.Reg) & 0x20) >> 5
}
func (o *USB_Type) SetDMARST_EPRST6(value uint32) {
	volatile.StoreUint32(&o.DMARST.Reg, volatile.LoadUint32(&o.DMARST.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetDMARST_EPRST6() uint32 {
	return (volatile.LoadUint32(&o.DMARST.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetDMARST_EPRST7(value uint32) {
	volatile.StoreUint32(&o.DMARST.Reg, volatile.LoadUint32(&o.DMARST.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetDMARST_EPRST7() uint32 {
	return (volatile.LoadUint32(&o.DMARST.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetDMARST_EPRST8(value uint32) {
	volatile.StoreUint32(&o.DMARST.Reg, volatile.LoadUint32(&o.DMARST.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetDMARST_EPRST8() uint32 {
	return (volatile.LoadUint32(&o.DMARST.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetDMARST_EPRST9(value uint32) {
	volatile.StoreUint32(&o.DMARST.Reg, volatile.LoadUint32(&o.DMARST.Reg)&^(0x200)|value<<9)
}
func (o *USB_Type) GetDMARST_EPRST9() uint32 {
	return (volatile.LoadUint32(&o.DMARST.Reg) & 0x200) >> 9
}
func (o *USB_Type) SetDMARST_EPRST10(value uint32) {
	volatile.StoreUint32(&o.DMARST.Reg, volatile.LoadUint32(&o.DMARST.Reg)&^(0x400)|value<<10)
}
func (o *USB_Type) GetDMARST_EPRST10() uint32 {
	return (volatile.LoadUint32(&o.DMARST.Reg) & 0x400) >> 10
}
func (o *USB_Type) SetDMARST_EPRST11(value uint32) {
	volatile.StoreUint32(&o.DMARST.Reg, volatile.LoadUint32(&o.DMARST.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetDMARST_EPRST11() uint32 {
	return (volatile.LoadUint32(&o.DMARST.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetDMARST_EPRST12(value uint32) {
	volatile.StoreUint32(&o.DMARST.Reg, volatile.LoadUint32(&o.DMARST.Reg)&^(0x1000)|value<<12)
}
func (o *USB_Type) GetDMARST_EPRST12() uint32 {
	return (volatile.LoadUint32(&o.DMARST.Reg) & 0x1000) >> 12
}
func (o *USB_Type) SetDMARST_EPRST13(value uint32) {
	volatile.StoreUint32(&o.DMARST.Reg, volatile.LoadUint32(&o.DMARST.Reg)&^(0x2000)|value<<13)
}
func (o *USB_Type) GetDMARST_EPRST13() uint32 {
	return (volatile.LoadUint32(&o.DMARST.Reg) & 0x2000) >> 13
}
func (o *USB_Type) SetDMARST_EPRST14(value uint32) {
	volatile.StoreUint32(&o.DMARST.Reg, volatile.LoadUint32(&o.DMARST.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetDMARST_EPRST14() uint32 {
	return (volatile.LoadUint32(&o.DMARST.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetDMARST_EPRST15(value uint32) {
	volatile.StoreUint32(&o.DMARST.Reg, volatile.LoadUint32(&o.DMARST.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetDMARST_EPRST15() uint32 {
	return (volatile.LoadUint32(&o.DMARST.Reg) & 0x8000) >> 15
}
func (o *USB_Type) SetDMARST_EPRST16(value uint32) {
	volatile.StoreUint32(&o.DMARST.Reg, volatile.LoadUint32(&o.DMARST.Reg)&^(0x10000)|value<<16)
}
func (o *USB_Type) GetDMARST_EPRST16() uint32 {
	return (volatile.LoadUint32(&o.DMARST.Reg) & 0x10000) >> 16
}
func (o *USB_Type) SetDMARST_EPRST17(value uint32) {
	volatile.StoreUint32(&o.DMARST.Reg, volatile.LoadUint32(&o.DMARST.Reg)&^(0x20000)|value<<17)
}
func (o *USB_Type) GetDMARST_EPRST17() uint32 {
	return (volatile.LoadUint32(&o.DMARST.Reg) & 0x20000) >> 17
}
func (o *USB_Type) SetDMARST_EPRST18(value uint32) {
	volatile.StoreUint32(&o.DMARST.Reg, volatile.LoadUint32(&o.DMARST.Reg)&^(0x40000)|value<<18)
}
func (o *USB_Type) GetDMARST_EPRST18() uint32 {
	return (volatile.LoadUint32(&o.DMARST.Reg) & 0x40000) >> 18
}
func (o *USB_Type) SetDMARST_EPRST19(value uint32) {
	volatile.StoreUint32(&o.DMARST.Reg, volatile.LoadUint32(&o.DMARST.Reg)&^(0x80000)|value<<19)
}
func (o *USB_Type) GetDMARST_EPRST19() uint32 {
	return (volatile.LoadUint32(&o.DMARST.Reg) & 0x80000) >> 19
}
func (o *USB_Type) SetDMARST_EPRST20(value uint32) {
	volatile.StoreUint32(&o.DMARST.Reg, volatile.LoadUint32(&o.DMARST.Reg)&^(0x100000)|value<<20)
}
func (o *USB_Type) GetDMARST_EPRST20() uint32 {
	return (volatile.LoadUint32(&o.DMARST.Reg) & 0x100000) >> 20
}
func (o *USB_Type) SetDMARST_EPRST21(value uint32) {
	volatile.StoreUint32(&o.DMARST.Reg, volatile.LoadUint32(&o.DMARST.Reg)&^(0x200000)|value<<21)
}
func (o *USB_Type) GetDMARST_EPRST21() uint32 {
	return (volatile.LoadUint32(&o.DMARST.Reg) & 0x200000) >> 21
}
func (o *USB_Type) SetDMARST_EPRST22(value uint32) {
	volatile.StoreUint32(&o.DMARST.Reg, volatile.LoadUint32(&o.DMARST.Reg)&^(0x400000)|value<<22)
}
func (o *USB_Type) GetDMARST_EPRST22() uint32 {
	return (volatile.LoadUint32(&o.DMARST.Reg) & 0x400000) >> 22
}
func (o *USB_Type) SetDMARST_EPRST23(value uint32) {
	volatile.StoreUint32(&o.DMARST.Reg, volatile.LoadUint32(&o.DMARST.Reg)&^(0x800000)|value<<23)
}
func (o *USB_Type) GetDMARST_EPRST23() uint32 {
	return (volatile.LoadUint32(&o.DMARST.Reg) & 0x800000) >> 23
}
func (o *USB_Type) SetDMARST_EPRST24(value uint32) {
	volatile.StoreUint32(&o.DMARST.Reg, volatile.LoadUint32(&o.DMARST.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_Type) GetDMARST_EPRST24() uint32 {
	return (volatile.LoadUint32(&o.DMARST.Reg) & 0x1000000) >> 24
}
func (o *USB_Type) SetDMARST_EPRST25(value uint32) {
	volatile.StoreUint32(&o.DMARST.Reg, volatile.LoadUint32(&o.DMARST.Reg)&^(0x2000000)|value<<25)
}
func (o *USB_Type) GetDMARST_EPRST25() uint32 {
	return (volatile.LoadUint32(&o.DMARST.Reg) & 0x2000000) >> 25
}
func (o *USB_Type) SetDMARST_EPRST26(value uint32) {
	volatile.StoreUint32(&o.DMARST.Reg, volatile.LoadUint32(&o.DMARST.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_Type) GetDMARST_EPRST26() uint32 {
	return (volatile.LoadUint32(&o.DMARST.Reg) & 0x4000000) >> 26
}
func (o *USB_Type) SetDMARST_EPRST27(value uint32) {
	volatile.StoreUint32(&o.DMARST.Reg, volatile.LoadUint32(&o.DMARST.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_Type) GetDMARST_EPRST27() uint32 {
	return (volatile.LoadUint32(&o.DMARST.Reg) & 0x8000000) >> 27
}
func (o *USB_Type) SetDMARST_EPRST28(value uint32) {
	volatile.StoreUint32(&o.DMARST.Reg, volatile.LoadUint32(&o.DMARST.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_Type) GetDMARST_EPRST28() uint32 {
	return (volatile.LoadUint32(&o.DMARST.Reg) & 0x10000000) >> 28
}
func (o *USB_Type) SetDMARST_EPRST29(value uint32) {
	volatile.StoreUint32(&o.DMARST.Reg, volatile.LoadUint32(&o.DMARST.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_Type) GetDMARST_EPRST29() uint32 {
	return (volatile.LoadUint32(&o.DMARST.Reg) & 0x20000000) >> 29
}
func (o *USB_Type) SetDMARST_EPRST30(value uint32) {
	volatile.StoreUint32(&o.DMARST.Reg, volatile.LoadUint32(&o.DMARST.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_Type) GetDMARST_EPRST30() uint32 {
	return (volatile.LoadUint32(&o.DMARST.Reg) & 0x40000000) >> 30
}
func (o *USB_Type) SetDMARST_EPRST31(value uint32) {
	volatile.StoreUint32(&o.DMARST.Reg, volatile.LoadUint32(&o.DMARST.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_Type) GetDMARST_EPRST31() uint32 {
	return (volatile.LoadUint32(&o.DMARST.Reg) & 0x80000000) >> 31
}

// USB.DMARCLR: USB DMA Request Clear
func (o *USB_Type) SetDMARCLR_EPRCLR0(value uint32) {
	volatile.StoreUint32(&o.DMARCLR.Reg, volatile.LoadUint32(&o.DMARCLR.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetDMARCLR_EPRCLR0() uint32 {
	return volatile.LoadUint32(&o.DMARCLR.Reg) & 0x1
}
func (o *USB_Type) SetDMARCLR_EPRCLR1(value uint32) {
	volatile.StoreUint32(&o.DMARCLR.Reg, volatile.LoadUint32(&o.DMARCLR.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetDMARCLR_EPRCLR1() uint32 {
	return (volatile.LoadUint32(&o.DMARCLR.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetDMARCLR_EPRCLR2(value uint32) {
	volatile.StoreUint32(&o.DMARCLR.Reg, volatile.LoadUint32(&o.DMARCLR.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetDMARCLR_EPRCLR2() uint32 {
	return (volatile.LoadUint32(&o.DMARCLR.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetDMARCLR_EPRCLR3(value uint32) {
	volatile.StoreUint32(&o.DMARCLR.Reg, volatile.LoadUint32(&o.DMARCLR.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetDMARCLR_EPRCLR3() uint32 {
	return (volatile.LoadUint32(&o.DMARCLR.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetDMARCLR_EPRCLR4(value uint32) {
	volatile.StoreUint32(&o.DMARCLR.Reg, volatile.LoadUint32(&o.DMARCLR.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetDMARCLR_EPRCLR4() uint32 {
	return (volatile.LoadUint32(&o.DMARCLR.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetDMARCLR_EPRCLR5(value uint32) {
	volatile.StoreUint32(&o.DMARCLR.Reg, volatile.LoadUint32(&o.DMARCLR.Reg)&^(0x20)|value<<5)
}
func (o *USB_Type) GetDMARCLR_EPRCLR5() uint32 {
	return (volatile.LoadUint32(&o.DMARCLR.Reg) & 0x20) >> 5
}
func (o *USB_Type) SetDMARCLR_EPRCLR6(value uint32) {
	volatile.StoreUint32(&o.DMARCLR.Reg, volatile.LoadUint32(&o.DMARCLR.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetDMARCLR_EPRCLR6() uint32 {
	return (volatile.LoadUint32(&o.DMARCLR.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetDMARCLR_EPRCLR7(value uint32) {
	volatile.StoreUint32(&o.DMARCLR.Reg, volatile.LoadUint32(&o.DMARCLR.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetDMARCLR_EPRCLR7() uint32 {
	return (volatile.LoadUint32(&o.DMARCLR.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetDMARCLR_EPRCLR8(value uint32) {
	volatile.StoreUint32(&o.DMARCLR.Reg, volatile.LoadUint32(&o.DMARCLR.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetDMARCLR_EPRCLR8() uint32 {
	return (volatile.LoadUint32(&o.DMARCLR.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetDMARCLR_EPRCLR9(value uint32) {
	volatile.StoreUint32(&o.DMARCLR.Reg, volatile.LoadUint32(&o.DMARCLR.Reg)&^(0x200)|value<<9)
}
func (o *USB_Type) GetDMARCLR_EPRCLR9() uint32 {
	return (volatile.LoadUint32(&o.DMARCLR.Reg) & 0x200) >> 9
}
func (o *USB_Type) SetDMARCLR_EPRCLR10(value uint32) {
	volatile.StoreUint32(&o.DMARCLR.Reg, volatile.LoadUint32(&o.DMARCLR.Reg)&^(0x400)|value<<10)
}
func (o *USB_Type) GetDMARCLR_EPRCLR10() uint32 {
	return (volatile.LoadUint32(&o.DMARCLR.Reg) & 0x400) >> 10
}
func (o *USB_Type) SetDMARCLR_EPRCLR11(value uint32) {
	volatile.StoreUint32(&o.DMARCLR.Reg, volatile.LoadUint32(&o.DMARCLR.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetDMARCLR_EPRCLR11() uint32 {
	return (volatile.LoadUint32(&o.DMARCLR.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetDMARCLR_EPRCLR12(value uint32) {
	volatile.StoreUint32(&o.DMARCLR.Reg, volatile.LoadUint32(&o.DMARCLR.Reg)&^(0x1000)|value<<12)
}
func (o *USB_Type) GetDMARCLR_EPRCLR12() uint32 {
	return (volatile.LoadUint32(&o.DMARCLR.Reg) & 0x1000) >> 12
}
func (o *USB_Type) SetDMARCLR_EPRCLR13(value uint32) {
	volatile.StoreUint32(&o.DMARCLR.Reg, volatile.LoadUint32(&o.DMARCLR.Reg)&^(0x2000)|value<<13)
}
func (o *USB_Type) GetDMARCLR_EPRCLR13() uint32 {
	return (volatile.LoadUint32(&o.DMARCLR.Reg) & 0x2000) >> 13
}
func (o *USB_Type) SetDMARCLR_EPRCLR14(value uint32) {
	volatile.StoreUint32(&o.DMARCLR.Reg, volatile.LoadUint32(&o.DMARCLR.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetDMARCLR_EPRCLR14() uint32 {
	return (volatile.LoadUint32(&o.DMARCLR.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetDMARCLR_EPRCLR15(value uint32) {
	volatile.StoreUint32(&o.DMARCLR.Reg, volatile.LoadUint32(&o.DMARCLR.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetDMARCLR_EPRCLR15() uint32 {
	return (volatile.LoadUint32(&o.DMARCLR.Reg) & 0x8000) >> 15
}
func (o *USB_Type) SetDMARCLR_EPRCLR16(value uint32) {
	volatile.StoreUint32(&o.DMARCLR.Reg, volatile.LoadUint32(&o.DMARCLR.Reg)&^(0x10000)|value<<16)
}
func (o *USB_Type) GetDMARCLR_EPRCLR16() uint32 {
	return (volatile.LoadUint32(&o.DMARCLR.Reg) & 0x10000) >> 16
}
func (o *USB_Type) SetDMARCLR_EPRCLR17(value uint32) {
	volatile.StoreUint32(&o.DMARCLR.Reg, volatile.LoadUint32(&o.DMARCLR.Reg)&^(0x20000)|value<<17)
}
func (o *USB_Type) GetDMARCLR_EPRCLR17() uint32 {
	return (volatile.LoadUint32(&o.DMARCLR.Reg) & 0x20000) >> 17
}
func (o *USB_Type) SetDMARCLR_EPRCLR18(value uint32) {
	volatile.StoreUint32(&o.DMARCLR.Reg, volatile.LoadUint32(&o.DMARCLR.Reg)&^(0x40000)|value<<18)
}
func (o *USB_Type) GetDMARCLR_EPRCLR18() uint32 {
	return (volatile.LoadUint32(&o.DMARCLR.Reg) & 0x40000) >> 18
}
func (o *USB_Type) SetDMARCLR_EPRCLR19(value uint32) {
	volatile.StoreUint32(&o.DMARCLR.Reg, volatile.LoadUint32(&o.DMARCLR.Reg)&^(0x80000)|value<<19)
}
func (o *USB_Type) GetDMARCLR_EPRCLR19() uint32 {
	return (volatile.LoadUint32(&o.DMARCLR.Reg) & 0x80000) >> 19
}
func (o *USB_Type) SetDMARCLR_EPRCLR20(value uint32) {
	volatile.StoreUint32(&o.DMARCLR.Reg, volatile.LoadUint32(&o.DMARCLR.Reg)&^(0x100000)|value<<20)
}
func (o *USB_Type) GetDMARCLR_EPRCLR20() uint32 {
	return (volatile.LoadUint32(&o.DMARCLR.Reg) & 0x100000) >> 20
}
func (o *USB_Type) SetDMARCLR_EPRCLR21(value uint32) {
	volatile.StoreUint32(&o.DMARCLR.Reg, volatile.LoadUint32(&o.DMARCLR.Reg)&^(0x200000)|value<<21)
}
func (o *USB_Type) GetDMARCLR_EPRCLR21() uint32 {
	return (volatile.LoadUint32(&o.DMARCLR.Reg) & 0x200000) >> 21
}
func (o *USB_Type) SetDMARCLR_EPRCLR22(value uint32) {
	volatile.StoreUint32(&o.DMARCLR.Reg, volatile.LoadUint32(&o.DMARCLR.Reg)&^(0x400000)|value<<22)
}
func (o *USB_Type) GetDMARCLR_EPRCLR22() uint32 {
	return (volatile.LoadUint32(&o.DMARCLR.Reg) & 0x400000) >> 22
}
func (o *USB_Type) SetDMARCLR_EPRCLR23(value uint32) {
	volatile.StoreUint32(&o.DMARCLR.Reg, volatile.LoadUint32(&o.DMARCLR.Reg)&^(0x800000)|value<<23)
}
func (o *USB_Type) GetDMARCLR_EPRCLR23() uint32 {
	return (volatile.LoadUint32(&o.DMARCLR.Reg) & 0x800000) >> 23
}
func (o *USB_Type) SetDMARCLR_EPRCLR24(value uint32) {
	volatile.StoreUint32(&o.DMARCLR.Reg, volatile.LoadUint32(&o.DMARCLR.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_Type) GetDMARCLR_EPRCLR24() uint32 {
	return (volatile.LoadUint32(&o.DMARCLR.Reg) & 0x1000000) >> 24
}
func (o *USB_Type) SetDMARCLR_EPRCLR25(value uint32) {
	volatile.StoreUint32(&o.DMARCLR.Reg, volatile.LoadUint32(&o.DMARCLR.Reg)&^(0x2000000)|value<<25)
}
func (o *USB_Type) GetDMARCLR_EPRCLR25() uint32 {
	return (volatile.LoadUint32(&o.DMARCLR.Reg) & 0x2000000) >> 25
}
func (o *USB_Type) SetDMARCLR_EPRCLR26(value uint32) {
	volatile.StoreUint32(&o.DMARCLR.Reg, volatile.LoadUint32(&o.DMARCLR.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_Type) GetDMARCLR_EPRCLR26() uint32 {
	return (volatile.LoadUint32(&o.DMARCLR.Reg) & 0x4000000) >> 26
}
func (o *USB_Type) SetDMARCLR_EPRCLR27(value uint32) {
	volatile.StoreUint32(&o.DMARCLR.Reg, volatile.LoadUint32(&o.DMARCLR.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_Type) GetDMARCLR_EPRCLR27() uint32 {
	return (volatile.LoadUint32(&o.DMARCLR.Reg) & 0x8000000) >> 27
}
func (o *USB_Type) SetDMARCLR_EPRCLR28(value uint32) {
	volatile.StoreUint32(&o.DMARCLR.Reg, volatile.LoadUint32(&o.DMARCLR.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_Type) GetDMARCLR_EPRCLR28() uint32 {
	return (volatile.LoadUint32(&o.DMARCLR.Reg) & 0x10000000) >> 28
}
func (o *USB_Type) SetDMARCLR_EPRCLR29(value uint32) {
	volatile.StoreUint32(&o.DMARCLR.Reg, volatile.LoadUint32(&o.DMARCLR.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_Type) GetDMARCLR_EPRCLR29() uint32 {
	return (volatile.LoadUint32(&o.DMARCLR.Reg) & 0x20000000) >> 29
}
func (o *USB_Type) SetDMARCLR_EPRCLR30(value uint32) {
	volatile.StoreUint32(&o.DMARCLR.Reg, volatile.LoadUint32(&o.DMARCLR.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_Type) GetDMARCLR_EPRCLR30() uint32 {
	return (volatile.LoadUint32(&o.DMARCLR.Reg) & 0x40000000) >> 30
}
func (o *USB_Type) SetDMARCLR_EPRCLR31(value uint32) {
	volatile.StoreUint32(&o.DMARCLR.Reg, volatile.LoadUint32(&o.DMARCLR.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_Type) GetDMARCLR_EPRCLR31() uint32 {
	return (volatile.LoadUint32(&o.DMARCLR.Reg) & 0x80000000) >> 31
}

// USB.DMARSET: USB DMA Request Set
func (o *USB_Type) SetDMARSET_EPRSET0(value uint32) {
	volatile.StoreUint32(&o.DMARSET.Reg, volatile.LoadUint32(&o.DMARSET.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetDMARSET_EPRSET0() uint32 {
	return volatile.LoadUint32(&o.DMARSET.Reg) & 0x1
}
func (o *USB_Type) SetDMARSET_EPRSET1(value uint32) {
	volatile.StoreUint32(&o.DMARSET.Reg, volatile.LoadUint32(&o.DMARSET.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetDMARSET_EPRSET1() uint32 {
	return (volatile.LoadUint32(&o.DMARSET.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetDMARSET_EPRSET2(value uint32) {
	volatile.StoreUint32(&o.DMARSET.Reg, volatile.LoadUint32(&o.DMARSET.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetDMARSET_EPRSET2() uint32 {
	return (volatile.LoadUint32(&o.DMARSET.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetDMARSET_EPRSET3(value uint32) {
	volatile.StoreUint32(&o.DMARSET.Reg, volatile.LoadUint32(&o.DMARSET.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetDMARSET_EPRSET3() uint32 {
	return (volatile.LoadUint32(&o.DMARSET.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetDMARSET_EPRSET4(value uint32) {
	volatile.StoreUint32(&o.DMARSET.Reg, volatile.LoadUint32(&o.DMARSET.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetDMARSET_EPRSET4() uint32 {
	return (volatile.LoadUint32(&o.DMARSET.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetDMARSET_EPRSET5(value uint32) {
	volatile.StoreUint32(&o.DMARSET.Reg, volatile.LoadUint32(&o.DMARSET.Reg)&^(0x20)|value<<5)
}
func (o *USB_Type) GetDMARSET_EPRSET5() uint32 {
	return (volatile.LoadUint32(&o.DMARSET.Reg) & 0x20) >> 5
}
func (o *USB_Type) SetDMARSET_EPRSET6(value uint32) {
	volatile.StoreUint32(&o.DMARSET.Reg, volatile.LoadUint32(&o.DMARSET.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetDMARSET_EPRSET6() uint32 {
	return (volatile.LoadUint32(&o.DMARSET.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetDMARSET_EPRSET7(value uint32) {
	volatile.StoreUint32(&o.DMARSET.Reg, volatile.LoadUint32(&o.DMARSET.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetDMARSET_EPRSET7() uint32 {
	return (volatile.LoadUint32(&o.DMARSET.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetDMARSET_EPRSET8(value uint32) {
	volatile.StoreUint32(&o.DMARSET.Reg, volatile.LoadUint32(&o.DMARSET.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetDMARSET_EPRSET8() uint32 {
	return (volatile.LoadUint32(&o.DMARSET.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetDMARSET_EPRSET9(value uint32) {
	volatile.StoreUint32(&o.DMARSET.Reg, volatile.LoadUint32(&o.DMARSET.Reg)&^(0x200)|value<<9)
}
func (o *USB_Type) GetDMARSET_EPRSET9() uint32 {
	return (volatile.LoadUint32(&o.DMARSET.Reg) & 0x200) >> 9
}
func (o *USB_Type) SetDMARSET_EPRSET10(value uint32) {
	volatile.StoreUint32(&o.DMARSET.Reg, volatile.LoadUint32(&o.DMARSET.Reg)&^(0x400)|value<<10)
}
func (o *USB_Type) GetDMARSET_EPRSET10() uint32 {
	return (volatile.LoadUint32(&o.DMARSET.Reg) & 0x400) >> 10
}
func (o *USB_Type) SetDMARSET_EPRSET11(value uint32) {
	volatile.StoreUint32(&o.DMARSET.Reg, volatile.LoadUint32(&o.DMARSET.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetDMARSET_EPRSET11() uint32 {
	return (volatile.LoadUint32(&o.DMARSET.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetDMARSET_EPRSET12(value uint32) {
	volatile.StoreUint32(&o.DMARSET.Reg, volatile.LoadUint32(&o.DMARSET.Reg)&^(0x1000)|value<<12)
}
func (o *USB_Type) GetDMARSET_EPRSET12() uint32 {
	return (volatile.LoadUint32(&o.DMARSET.Reg) & 0x1000) >> 12
}
func (o *USB_Type) SetDMARSET_EPRSET13(value uint32) {
	volatile.StoreUint32(&o.DMARSET.Reg, volatile.LoadUint32(&o.DMARSET.Reg)&^(0x2000)|value<<13)
}
func (o *USB_Type) GetDMARSET_EPRSET13() uint32 {
	return (volatile.LoadUint32(&o.DMARSET.Reg) & 0x2000) >> 13
}
func (o *USB_Type) SetDMARSET_EPRSET14(value uint32) {
	volatile.StoreUint32(&o.DMARSET.Reg, volatile.LoadUint32(&o.DMARSET.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetDMARSET_EPRSET14() uint32 {
	return (volatile.LoadUint32(&o.DMARSET.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetDMARSET_EPRSET15(value uint32) {
	volatile.StoreUint32(&o.DMARSET.Reg, volatile.LoadUint32(&o.DMARSET.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetDMARSET_EPRSET15() uint32 {
	return (volatile.LoadUint32(&o.DMARSET.Reg) & 0x8000) >> 15
}
func (o *USB_Type) SetDMARSET_EPRSET16(value uint32) {
	volatile.StoreUint32(&o.DMARSET.Reg, volatile.LoadUint32(&o.DMARSET.Reg)&^(0x10000)|value<<16)
}
func (o *USB_Type) GetDMARSET_EPRSET16() uint32 {
	return (volatile.LoadUint32(&o.DMARSET.Reg) & 0x10000) >> 16
}
func (o *USB_Type) SetDMARSET_EPRSET17(value uint32) {
	volatile.StoreUint32(&o.DMARSET.Reg, volatile.LoadUint32(&o.DMARSET.Reg)&^(0x20000)|value<<17)
}
func (o *USB_Type) GetDMARSET_EPRSET17() uint32 {
	return (volatile.LoadUint32(&o.DMARSET.Reg) & 0x20000) >> 17
}
func (o *USB_Type) SetDMARSET_EPRSET18(value uint32) {
	volatile.StoreUint32(&o.DMARSET.Reg, volatile.LoadUint32(&o.DMARSET.Reg)&^(0x40000)|value<<18)
}
func (o *USB_Type) GetDMARSET_EPRSET18() uint32 {
	return (volatile.LoadUint32(&o.DMARSET.Reg) & 0x40000) >> 18
}
func (o *USB_Type) SetDMARSET_EPRSET19(value uint32) {
	volatile.StoreUint32(&o.DMARSET.Reg, volatile.LoadUint32(&o.DMARSET.Reg)&^(0x80000)|value<<19)
}
func (o *USB_Type) GetDMARSET_EPRSET19() uint32 {
	return (volatile.LoadUint32(&o.DMARSET.Reg) & 0x80000) >> 19
}
func (o *USB_Type) SetDMARSET_EPRSET20(value uint32) {
	volatile.StoreUint32(&o.DMARSET.Reg, volatile.LoadUint32(&o.DMARSET.Reg)&^(0x100000)|value<<20)
}
func (o *USB_Type) GetDMARSET_EPRSET20() uint32 {
	return (volatile.LoadUint32(&o.DMARSET.Reg) & 0x100000) >> 20
}
func (o *USB_Type) SetDMARSET_EPRSET21(value uint32) {
	volatile.StoreUint32(&o.DMARSET.Reg, volatile.LoadUint32(&o.DMARSET.Reg)&^(0x200000)|value<<21)
}
func (o *USB_Type) GetDMARSET_EPRSET21() uint32 {
	return (volatile.LoadUint32(&o.DMARSET.Reg) & 0x200000) >> 21
}
func (o *USB_Type) SetDMARSET_EPRSET22(value uint32) {
	volatile.StoreUint32(&o.DMARSET.Reg, volatile.LoadUint32(&o.DMARSET.Reg)&^(0x400000)|value<<22)
}
func (o *USB_Type) GetDMARSET_EPRSET22() uint32 {
	return (volatile.LoadUint32(&o.DMARSET.Reg) & 0x400000) >> 22
}
func (o *USB_Type) SetDMARSET_EPRSET23(value uint32) {
	volatile.StoreUint32(&o.DMARSET.Reg, volatile.LoadUint32(&o.DMARSET.Reg)&^(0x800000)|value<<23)
}
func (o *USB_Type) GetDMARSET_EPRSET23() uint32 {
	return (volatile.LoadUint32(&o.DMARSET.Reg) & 0x800000) >> 23
}
func (o *USB_Type) SetDMARSET_EPRSET24(value uint32) {
	volatile.StoreUint32(&o.DMARSET.Reg, volatile.LoadUint32(&o.DMARSET.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_Type) GetDMARSET_EPRSET24() uint32 {
	return (volatile.LoadUint32(&o.DMARSET.Reg) & 0x1000000) >> 24
}
func (o *USB_Type) SetDMARSET_EPRSET25(value uint32) {
	volatile.StoreUint32(&o.DMARSET.Reg, volatile.LoadUint32(&o.DMARSET.Reg)&^(0x2000000)|value<<25)
}
func (o *USB_Type) GetDMARSET_EPRSET25() uint32 {
	return (volatile.LoadUint32(&o.DMARSET.Reg) & 0x2000000) >> 25
}
func (o *USB_Type) SetDMARSET_EPRSET26(value uint32) {
	volatile.StoreUint32(&o.DMARSET.Reg, volatile.LoadUint32(&o.DMARSET.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_Type) GetDMARSET_EPRSET26() uint32 {
	return (volatile.LoadUint32(&o.DMARSET.Reg) & 0x4000000) >> 26
}
func (o *USB_Type) SetDMARSET_EPRSET27(value uint32) {
	volatile.StoreUint32(&o.DMARSET.Reg, volatile.LoadUint32(&o.DMARSET.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_Type) GetDMARSET_EPRSET27() uint32 {
	return (volatile.LoadUint32(&o.DMARSET.Reg) & 0x8000000) >> 27
}
func (o *USB_Type) SetDMARSET_EPRSET28(value uint32) {
	volatile.StoreUint32(&o.DMARSET.Reg, volatile.LoadUint32(&o.DMARSET.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_Type) GetDMARSET_EPRSET28() uint32 {
	return (volatile.LoadUint32(&o.DMARSET.Reg) & 0x10000000) >> 28
}
func (o *USB_Type) SetDMARSET_EPRSET29(value uint32) {
	volatile.StoreUint32(&o.DMARSET.Reg, volatile.LoadUint32(&o.DMARSET.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_Type) GetDMARSET_EPRSET29() uint32 {
	return (volatile.LoadUint32(&o.DMARSET.Reg) & 0x20000000) >> 29
}
func (o *USB_Type) SetDMARSET_EPRSET30(value uint32) {
	volatile.StoreUint32(&o.DMARSET.Reg, volatile.LoadUint32(&o.DMARSET.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_Type) GetDMARSET_EPRSET30() uint32 {
	return (volatile.LoadUint32(&o.DMARSET.Reg) & 0x40000000) >> 30
}
func (o *USB_Type) SetDMARSET_EPRSET31(value uint32) {
	volatile.StoreUint32(&o.DMARSET.Reg, volatile.LoadUint32(&o.DMARSET.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_Type) GetDMARSET_EPRSET31() uint32 {
	return (volatile.LoadUint32(&o.DMARSET.Reg) & 0x80000000) >> 31
}

// USB.UDCAH: USB UDCA Head
func (o *USB_Type) SetUDCAH_RESERVED(value uint32) {
	volatile.StoreUint32(&o.UDCAH.Reg, volatile.LoadUint32(&o.UDCAH.Reg)&^(0x7f)|value)
}
func (o *USB_Type) GetUDCAH_RESERVED() uint32 {
	return volatile.LoadUint32(&o.UDCAH.Reg) & 0x7f
}
func (o *USB_Type) SetUDCAH_UDCA_ADDR(value uint32) {
	volatile.StoreUint32(&o.UDCAH.Reg, volatile.LoadUint32(&o.UDCAH.Reg)&^(0xffffff80)|value<<7)
}
func (o *USB_Type) GetUDCAH_UDCA_ADDR() uint32 {
	return (volatile.LoadUint32(&o.UDCAH.Reg) & 0xffffff80) >> 7
}

// USB.EPDMAST: USB Endpoint DMA Status
func (o *USB_Type) SetEPDMAST_EP_DMA_ST0(value uint32) {
	volatile.StoreUint32(&o.EPDMAST.Reg, volatile.LoadUint32(&o.EPDMAST.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetEPDMAST_EP_DMA_ST0() uint32 {
	return volatile.LoadUint32(&o.EPDMAST.Reg) & 0x1
}
func (o *USB_Type) SetEPDMAST_EP_DMA_ST1(value uint32) {
	volatile.StoreUint32(&o.EPDMAST.Reg, volatile.LoadUint32(&o.EPDMAST.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetEPDMAST_EP_DMA_ST1() uint32 {
	return (volatile.LoadUint32(&o.EPDMAST.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetEPDMAST_EP_DMA_ST2(value uint32) {
	volatile.StoreUint32(&o.EPDMAST.Reg, volatile.LoadUint32(&o.EPDMAST.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetEPDMAST_EP_DMA_ST2() uint32 {
	return (volatile.LoadUint32(&o.EPDMAST.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetEPDMAST_EP_DMA_ST3(value uint32) {
	volatile.StoreUint32(&o.EPDMAST.Reg, volatile.LoadUint32(&o.EPDMAST.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetEPDMAST_EP_DMA_ST3() uint32 {
	return (volatile.LoadUint32(&o.EPDMAST.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetEPDMAST_EP_DMA_ST4(value uint32) {
	volatile.StoreUint32(&o.EPDMAST.Reg, volatile.LoadUint32(&o.EPDMAST.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetEPDMAST_EP_DMA_ST4() uint32 {
	return (volatile.LoadUint32(&o.EPDMAST.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetEPDMAST_EP_DMA_ST5(value uint32) {
	volatile.StoreUint32(&o.EPDMAST.Reg, volatile.LoadUint32(&o.EPDMAST.Reg)&^(0x20)|value<<5)
}
func (o *USB_Type) GetEPDMAST_EP_DMA_ST5() uint32 {
	return (volatile.LoadUint32(&o.EPDMAST.Reg) & 0x20) >> 5
}
func (o *USB_Type) SetEPDMAST_EP_DMA_ST6(value uint32) {
	volatile.StoreUint32(&o.EPDMAST.Reg, volatile.LoadUint32(&o.EPDMAST.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetEPDMAST_EP_DMA_ST6() uint32 {
	return (volatile.LoadUint32(&o.EPDMAST.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetEPDMAST_EP_DMA_ST7(value uint32) {
	volatile.StoreUint32(&o.EPDMAST.Reg, volatile.LoadUint32(&o.EPDMAST.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetEPDMAST_EP_DMA_ST7() uint32 {
	return (volatile.LoadUint32(&o.EPDMAST.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetEPDMAST_EP_DMA_ST8(value uint32) {
	volatile.StoreUint32(&o.EPDMAST.Reg, volatile.LoadUint32(&o.EPDMAST.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetEPDMAST_EP_DMA_ST8() uint32 {
	return (volatile.LoadUint32(&o.EPDMAST.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetEPDMAST_EP_DMA_ST9(value uint32) {
	volatile.StoreUint32(&o.EPDMAST.Reg, volatile.LoadUint32(&o.EPDMAST.Reg)&^(0x200)|value<<9)
}
func (o *USB_Type) GetEPDMAST_EP_DMA_ST9() uint32 {
	return (volatile.LoadUint32(&o.EPDMAST.Reg) & 0x200) >> 9
}
func (o *USB_Type) SetEPDMAST_EP_DMA_ST10(value uint32) {
	volatile.StoreUint32(&o.EPDMAST.Reg, volatile.LoadUint32(&o.EPDMAST.Reg)&^(0x400)|value<<10)
}
func (o *USB_Type) GetEPDMAST_EP_DMA_ST10() uint32 {
	return (volatile.LoadUint32(&o.EPDMAST.Reg) & 0x400) >> 10
}
func (o *USB_Type) SetEPDMAST_EP_DMA_ST11(value uint32) {
	volatile.StoreUint32(&o.EPDMAST.Reg, volatile.LoadUint32(&o.EPDMAST.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetEPDMAST_EP_DMA_ST11() uint32 {
	return (volatile.LoadUint32(&o.EPDMAST.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetEPDMAST_EP_DMA_ST12(value uint32) {
	volatile.StoreUint32(&o.EPDMAST.Reg, volatile.LoadUint32(&o.EPDMAST.Reg)&^(0x1000)|value<<12)
}
func (o *USB_Type) GetEPDMAST_EP_DMA_ST12() uint32 {
	return (volatile.LoadUint32(&o.EPDMAST.Reg) & 0x1000) >> 12
}
func (o *USB_Type) SetEPDMAST_EP_DMA_ST13(value uint32) {
	volatile.StoreUint32(&o.EPDMAST.Reg, volatile.LoadUint32(&o.EPDMAST.Reg)&^(0x2000)|value<<13)
}
func (o *USB_Type) GetEPDMAST_EP_DMA_ST13() uint32 {
	return (volatile.LoadUint32(&o.EPDMAST.Reg) & 0x2000) >> 13
}
func (o *USB_Type) SetEPDMAST_EP_DMA_ST14(value uint32) {
	volatile.StoreUint32(&o.EPDMAST.Reg, volatile.LoadUint32(&o.EPDMAST.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetEPDMAST_EP_DMA_ST14() uint32 {
	return (volatile.LoadUint32(&o.EPDMAST.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetEPDMAST_EP_DMA_ST15(value uint32) {
	volatile.StoreUint32(&o.EPDMAST.Reg, volatile.LoadUint32(&o.EPDMAST.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetEPDMAST_EP_DMA_ST15() uint32 {
	return (volatile.LoadUint32(&o.EPDMAST.Reg) & 0x8000) >> 15
}
func (o *USB_Type) SetEPDMAST_EP_DMA_ST16(value uint32) {
	volatile.StoreUint32(&o.EPDMAST.Reg, volatile.LoadUint32(&o.EPDMAST.Reg)&^(0x10000)|value<<16)
}
func (o *USB_Type) GetEPDMAST_EP_DMA_ST16() uint32 {
	return (volatile.LoadUint32(&o.EPDMAST.Reg) & 0x10000) >> 16
}
func (o *USB_Type) SetEPDMAST_EP_DMA_ST17(value uint32) {
	volatile.StoreUint32(&o.EPDMAST.Reg, volatile.LoadUint32(&o.EPDMAST.Reg)&^(0x20000)|value<<17)
}
func (o *USB_Type) GetEPDMAST_EP_DMA_ST17() uint32 {
	return (volatile.LoadUint32(&o.EPDMAST.Reg) & 0x20000) >> 17
}
func (o *USB_Type) SetEPDMAST_EP_DMA_ST18(value uint32) {
	volatile.StoreUint32(&o.EPDMAST.Reg, volatile.LoadUint32(&o.EPDMAST.Reg)&^(0x40000)|value<<18)
}
func (o *USB_Type) GetEPDMAST_EP_DMA_ST18() uint32 {
	return (volatile.LoadUint32(&o.EPDMAST.Reg) & 0x40000) >> 18
}
func (o *USB_Type) SetEPDMAST_EP_DMA_ST19(value uint32) {
	volatile.StoreUint32(&o.EPDMAST.Reg, volatile.LoadUint32(&o.EPDMAST.Reg)&^(0x80000)|value<<19)
}
func (o *USB_Type) GetEPDMAST_EP_DMA_ST19() uint32 {
	return (volatile.LoadUint32(&o.EPDMAST.Reg) & 0x80000) >> 19
}
func (o *USB_Type) SetEPDMAST_EP_DMA_ST20(value uint32) {
	volatile.StoreUint32(&o.EPDMAST.Reg, volatile.LoadUint32(&o.EPDMAST.Reg)&^(0x100000)|value<<20)
}
func (o *USB_Type) GetEPDMAST_EP_DMA_ST20() uint32 {
	return (volatile.LoadUint32(&o.EPDMAST.Reg) & 0x100000) >> 20
}
func (o *USB_Type) SetEPDMAST_EP_DMA_ST21(value uint32) {
	volatile.StoreUint32(&o.EPDMAST.Reg, volatile.LoadUint32(&o.EPDMAST.Reg)&^(0x200000)|value<<21)
}
func (o *USB_Type) GetEPDMAST_EP_DMA_ST21() uint32 {
	return (volatile.LoadUint32(&o.EPDMAST.Reg) & 0x200000) >> 21
}
func (o *USB_Type) SetEPDMAST_EP_DMA_ST22(value uint32) {
	volatile.StoreUint32(&o.EPDMAST.Reg, volatile.LoadUint32(&o.EPDMAST.Reg)&^(0x400000)|value<<22)
}
func (o *USB_Type) GetEPDMAST_EP_DMA_ST22() uint32 {
	return (volatile.LoadUint32(&o.EPDMAST.Reg) & 0x400000) >> 22
}
func (o *USB_Type) SetEPDMAST_EP_DMA_ST23(value uint32) {
	volatile.StoreUint32(&o.EPDMAST.Reg, volatile.LoadUint32(&o.EPDMAST.Reg)&^(0x800000)|value<<23)
}
func (o *USB_Type) GetEPDMAST_EP_DMA_ST23() uint32 {
	return (volatile.LoadUint32(&o.EPDMAST.Reg) & 0x800000) >> 23
}
func (o *USB_Type) SetEPDMAST_EP_DMA_ST24(value uint32) {
	volatile.StoreUint32(&o.EPDMAST.Reg, volatile.LoadUint32(&o.EPDMAST.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_Type) GetEPDMAST_EP_DMA_ST24() uint32 {
	return (volatile.LoadUint32(&o.EPDMAST.Reg) & 0x1000000) >> 24
}
func (o *USB_Type) SetEPDMAST_EP_DMA_ST25(value uint32) {
	volatile.StoreUint32(&o.EPDMAST.Reg, volatile.LoadUint32(&o.EPDMAST.Reg)&^(0x2000000)|value<<25)
}
func (o *USB_Type) GetEPDMAST_EP_DMA_ST25() uint32 {
	return (volatile.LoadUint32(&o.EPDMAST.Reg) & 0x2000000) >> 25
}
func (o *USB_Type) SetEPDMAST_EP_DMA_ST26(value uint32) {
	volatile.StoreUint32(&o.EPDMAST.Reg, volatile.LoadUint32(&o.EPDMAST.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_Type) GetEPDMAST_EP_DMA_ST26() uint32 {
	return (volatile.LoadUint32(&o.EPDMAST.Reg) & 0x4000000) >> 26
}
func (o *USB_Type) SetEPDMAST_EP_DMA_ST27(value uint32) {
	volatile.StoreUint32(&o.EPDMAST.Reg, volatile.LoadUint32(&o.EPDMAST.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_Type) GetEPDMAST_EP_DMA_ST27() uint32 {
	return (volatile.LoadUint32(&o.EPDMAST.Reg) & 0x8000000) >> 27
}
func (o *USB_Type) SetEPDMAST_EP_DMA_ST28(value uint32) {
	volatile.StoreUint32(&o.EPDMAST.Reg, volatile.LoadUint32(&o.EPDMAST.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_Type) GetEPDMAST_EP_DMA_ST28() uint32 {
	return (volatile.LoadUint32(&o.EPDMAST.Reg) & 0x10000000) >> 28
}
func (o *USB_Type) SetEPDMAST_EP_DMA_ST29(value uint32) {
	volatile.StoreUint32(&o.EPDMAST.Reg, volatile.LoadUint32(&o.EPDMAST.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_Type) GetEPDMAST_EP_DMA_ST29() uint32 {
	return (volatile.LoadUint32(&o.EPDMAST.Reg) & 0x20000000) >> 29
}
func (o *USB_Type) SetEPDMAST_EP_DMA_ST30(value uint32) {
	volatile.StoreUint32(&o.EPDMAST.Reg, volatile.LoadUint32(&o.EPDMAST.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_Type) GetEPDMAST_EP_DMA_ST30() uint32 {
	return (volatile.LoadUint32(&o.EPDMAST.Reg) & 0x40000000) >> 30
}
func (o *USB_Type) SetEPDMAST_EP_DMA_ST31(value uint32) {
	volatile.StoreUint32(&o.EPDMAST.Reg, volatile.LoadUint32(&o.EPDMAST.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_Type) GetEPDMAST_EP_DMA_ST31() uint32 {
	return (volatile.LoadUint32(&o.EPDMAST.Reg) & 0x80000000) >> 31
}

// USB.EPDMAEN: USB Endpoint DMA Enable
func (o *USB_Type) SetEPDMAEN_EP_DMA_EN0(value uint32) {
	volatile.StoreUint32(&o.EPDMAEN.Reg, volatile.LoadUint32(&o.EPDMAEN.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetEPDMAEN_EP_DMA_EN0() uint32 {
	return volatile.LoadUint32(&o.EPDMAEN.Reg) & 0x1
}
func (o *USB_Type) SetEPDMAEN_EP_DMA_EN1(value uint32) {
	volatile.StoreUint32(&o.EPDMAEN.Reg, volatile.LoadUint32(&o.EPDMAEN.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetEPDMAEN_EP_DMA_EN1() uint32 {
	return (volatile.LoadUint32(&o.EPDMAEN.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetEPDMAEN_EP_DMA_EN(value uint32) {
	volatile.StoreUint32(&o.EPDMAEN.Reg, volatile.LoadUint32(&o.EPDMAEN.Reg)&^(0xfffffffc)|value<<2)
}
func (o *USB_Type) GetEPDMAEN_EP_DMA_EN() uint32 {
	return (volatile.LoadUint32(&o.EPDMAEN.Reg) & 0xfffffffc) >> 2
}

// USB.EPDMADIS: USB Endpoint DMA Disable
func (o *USB_Type) SetEPDMADIS_EP_DMA_DIS0(value uint32) {
	volatile.StoreUint32(&o.EPDMADIS.Reg, volatile.LoadUint32(&o.EPDMADIS.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetEPDMADIS_EP_DMA_DIS0() uint32 {
	return volatile.LoadUint32(&o.EPDMADIS.Reg) & 0x1
}
func (o *USB_Type) SetEPDMADIS_EP_DMA_DIS1(value uint32) {
	volatile.StoreUint32(&o.EPDMADIS.Reg, volatile.LoadUint32(&o.EPDMADIS.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetEPDMADIS_EP_DMA_DIS1() uint32 {
	return (volatile.LoadUint32(&o.EPDMADIS.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetEPDMADIS_EP_DMA_DIS2(value uint32) {
	volatile.StoreUint32(&o.EPDMADIS.Reg, volatile.LoadUint32(&o.EPDMADIS.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetEPDMADIS_EP_DMA_DIS2() uint32 {
	return (volatile.LoadUint32(&o.EPDMADIS.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetEPDMADIS_EP_DMA_DIS3(value uint32) {
	volatile.StoreUint32(&o.EPDMADIS.Reg, volatile.LoadUint32(&o.EPDMADIS.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetEPDMADIS_EP_DMA_DIS3() uint32 {
	return (volatile.LoadUint32(&o.EPDMADIS.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetEPDMADIS_EP_DMA_DIS4(value uint32) {
	volatile.StoreUint32(&o.EPDMADIS.Reg, volatile.LoadUint32(&o.EPDMADIS.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetEPDMADIS_EP_DMA_DIS4() uint32 {
	return (volatile.LoadUint32(&o.EPDMADIS.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetEPDMADIS_EP_DMA_DIS5(value uint32) {
	volatile.StoreUint32(&o.EPDMADIS.Reg, volatile.LoadUint32(&o.EPDMADIS.Reg)&^(0x20)|value<<5)
}
func (o *USB_Type) GetEPDMADIS_EP_DMA_DIS5() uint32 {
	return (volatile.LoadUint32(&o.EPDMADIS.Reg) & 0x20) >> 5
}
func (o *USB_Type) SetEPDMADIS_EP_DMA_DIS6(value uint32) {
	volatile.StoreUint32(&o.EPDMADIS.Reg, volatile.LoadUint32(&o.EPDMADIS.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetEPDMADIS_EP_DMA_DIS6() uint32 {
	return (volatile.LoadUint32(&o.EPDMADIS.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetEPDMADIS_EP_DMA_DIS7(value uint32) {
	volatile.StoreUint32(&o.EPDMADIS.Reg, volatile.LoadUint32(&o.EPDMADIS.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetEPDMADIS_EP_DMA_DIS7() uint32 {
	return (volatile.LoadUint32(&o.EPDMADIS.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetEPDMADIS_EP_DMA_DIS8(value uint32) {
	volatile.StoreUint32(&o.EPDMADIS.Reg, volatile.LoadUint32(&o.EPDMADIS.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetEPDMADIS_EP_DMA_DIS8() uint32 {
	return (volatile.LoadUint32(&o.EPDMADIS.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetEPDMADIS_EP_DMA_DIS9(value uint32) {
	volatile.StoreUint32(&o.EPDMADIS.Reg, volatile.LoadUint32(&o.EPDMADIS.Reg)&^(0x200)|value<<9)
}
func (o *USB_Type) GetEPDMADIS_EP_DMA_DIS9() uint32 {
	return (volatile.LoadUint32(&o.EPDMADIS.Reg) & 0x200) >> 9
}
func (o *USB_Type) SetEPDMADIS_EP_DMA_DIS10(value uint32) {
	volatile.StoreUint32(&o.EPDMADIS.Reg, volatile.LoadUint32(&o.EPDMADIS.Reg)&^(0x400)|value<<10)
}
func (o *USB_Type) GetEPDMADIS_EP_DMA_DIS10() uint32 {
	return (volatile.LoadUint32(&o.EPDMADIS.Reg) & 0x400) >> 10
}
func (o *USB_Type) SetEPDMADIS_EP_DMA_DIS11(value uint32) {
	volatile.StoreUint32(&o.EPDMADIS.Reg, volatile.LoadUint32(&o.EPDMADIS.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetEPDMADIS_EP_DMA_DIS11() uint32 {
	return (volatile.LoadUint32(&o.EPDMADIS.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetEPDMADIS_EP_DMA_DIS12(value uint32) {
	volatile.StoreUint32(&o.EPDMADIS.Reg, volatile.LoadUint32(&o.EPDMADIS.Reg)&^(0x1000)|value<<12)
}
func (o *USB_Type) GetEPDMADIS_EP_DMA_DIS12() uint32 {
	return (volatile.LoadUint32(&o.EPDMADIS.Reg) & 0x1000) >> 12
}
func (o *USB_Type) SetEPDMADIS_EP_DMA_DIS13(value uint32) {
	volatile.StoreUint32(&o.EPDMADIS.Reg, volatile.LoadUint32(&o.EPDMADIS.Reg)&^(0x2000)|value<<13)
}
func (o *USB_Type) GetEPDMADIS_EP_DMA_DIS13() uint32 {
	return (volatile.LoadUint32(&o.EPDMADIS.Reg) & 0x2000) >> 13
}
func (o *USB_Type) SetEPDMADIS_EP_DMA_DIS14(value uint32) {
	volatile.StoreUint32(&o.EPDMADIS.Reg, volatile.LoadUint32(&o.EPDMADIS.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetEPDMADIS_EP_DMA_DIS14() uint32 {
	return (volatile.LoadUint32(&o.EPDMADIS.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetEPDMADIS_EP_DMA_DIS15(value uint32) {
	volatile.StoreUint32(&o.EPDMADIS.Reg, volatile.LoadUint32(&o.EPDMADIS.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetEPDMADIS_EP_DMA_DIS15() uint32 {
	return (volatile.LoadUint32(&o.EPDMADIS.Reg) & 0x8000) >> 15
}
func (o *USB_Type) SetEPDMADIS_EP_DMA_DIS16(value uint32) {
	volatile.StoreUint32(&o.EPDMADIS.Reg, volatile.LoadUint32(&o.EPDMADIS.Reg)&^(0x10000)|value<<16)
}
func (o *USB_Type) GetEPDMADIS_EP_DMA_DIS16() uint32 {
	return (volatile.LoadUint32(&o.EPDMADIS.Reg) & 0x10000) >> 16
}
func (o *USB_Type) SetEPDMADIS_EP_DMA_DIS17(value uint32) {
	volatile.StoreUint32(&o.EPDMADIS.Reg, volatile.LoadUint32(&o.EPDMADIS.Reg)&^(0x20000)|value<<17)
}
func (o *USB_Type) GetEPDMADIS_EP_DMA_DIS17() uint32 {
	return (volatile.LoadUint32(&o.EPDMADIS.Reg) & 0x20000) >> 17
}
func (o *USB_Type) SetEPDMADIS_EP_DMA_DIS18(value uint32) {
	volatile.StoreUint32(&o.EPDMADIS.Reg, volatile.LoadUint32(&o.EPDMADIS.Reg)&^(0x40000)|value<<18)
}
func (o *USB_Type) GetEPDMADIS_EP_DMA_DIS18() uint32 {
	return (volatile.LoadUint32(&o.EPDMADIS.Reg) & 0x40000) >> 18
}
func (o *USB_Type) SetEPDMADIS_EP_DMA_DIS19(value uint32) {
	volatile.StoreUint32(&o.EPDMADIS.Reg, volatile.LoadUint32(&o.EPDMADIS.Reg)&^(0x80000)|value<<19)
}
func (o *USB_Type) GetEPDMADIS_EP_DMA_DIS19() uint32 {
	return (volatile.LoadUint32(&o.EPDMADIS.Reg) & 0x80000) >> 19
}
func (o *USB_Type) SetEPDMADIS_EP_DMA_DIS20(value uint32) {
	volatile.StoreUint32(&o.EPDMADIS.Reg, volatile.LoadUint32(&o.EPDMADIS.Reg)&^(0x100000)|value<<20)
}
func (o *USB_Type) GetEPDMADIS_EP_DMA_DIS20() uint32 {
	return (volatile.LoadUint32(&o.EPDMADIS.Reg) & 0x100000) >> 20
}
func (o *USB_Type) SetEPDMADIS_EP_DMA_DIS21(value uint32) {
	volatile.StoreUint32(&o.EPDMADIS.Reg, volatile.LoadUint32(&o.EPDMADIS.Reg)&^(0x200000)|value<<21)
}
func (o *USB_Type) GetEPDMADIS_EP_DMA_DIS21() uint32 {
	return (volatile.LoadUint32(&o.EPDMADIS.Reg) & 0x200000) >> 21
}
func (o *USB_Type) SetEPDMADIS_EP_DMA_DIS22(value uint32) {
	volatile.StoreUint32(&o.EPDMADIS.Reg, volatile.LoadUint32(&o.EPDMADIS.Reg)&^(0x400000)|value<<22)
}
func (o *USB_Type) GetEPDMADIS_EP_DMA_DIS22() uint32 {
	return (volatile.LoadUint32(&o.EPDMADIS.Reg) & 0x400000) >> 22
}
func (o *USB_Type) SetEPDMADIS_EP_DMA_DIS23(value uint32) {
	volatile.StoreUint32(&o.EPDMADIS.Reg, volatile.LoadUint32(&o.EPDMADIS.Reg)&^(0x800000)|value<<23)
}
func (o *USB_Type) GetEPDMADIS_EP_DMA_DIS23() uint32 {
	return (volatile.LoadUint32(&o.EPDMADIS.Reg) & 0x800000) >> 23
}
func (o *USB_Type) SetEPDMADIS_EP_DMA_DIS24(value uint32) {
	volatile.StoreUint32(&o.EPDMADIS.Reg, volatile.LoadUint32(&o.EPDMADIS.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_Type) GetEPDMADIS_EP_DMA_DIS24() uint32 {
	return (volatile.LoadUint32(&o.EPDMADIS.Reg) & 0x1000000) >> 24
}
func (o *USB_Type) SetEPDMADIS_EP_DMA_DIS25(value uint32) {
	volatile.StoreUint32(&o.EPDMADIS.Reg, volatile.LoadUint32(&o.EPDMADIS.Reg)&^(0x2000000)|value<<25)
}
func (o *USB_Type) GetEPDMADIS_EP_DMA_DIS25() uint32 {
	return (volatile.LoadUint32(&o.EPDMADIS.Reg) & 0x2000000) >> 25
}
func (o *USB_Type) SetEPDMADIS_EP_DMA_DIS26(value uint32) {
	volatile.StoreUint32(&o.EPDMADIS.Reg, volatile.LoadUint32(&o.EPDMADIS.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_Type) GetEPDMADIS_EP_DMA_DIS26() uint32 {
	return (volatile.LoadUint32(&o.EPDMADIS.Reg) & 0x4000000) >> 26
}
func (o *USB_Type) SetEPDMADIS_EP_DMA_DIS27(value uint32) {
	volatile.StoreUint32(&o.EPDMADIS.Reg, volatile.LoadUint32(&o.EPDMADIS.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_Type) GetEPDMADIS_EP_DMA_DIS27() uint32 {
	return (volatile.LoadUint32(&o.EPDMADIS.Reg) & 0x8000000) >> 27
}
func (o *USB_Type) SetEPDMADIS_EP_DMA_DIS28(value uint32) {
	volatile.StoreUint32(&o.EPDMADIS.Reg, volatile.LoadUint32(&o.EPDMADIS.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_Type) GetEPDMADIS_EP_DMA_DIS28() uint32 {
	return (volatile.LoadUint32(&o.EPDMADIS.Reg) & 0x10000000) >> 28
}
func (o *USB_Type) SetEPDMADIS_EP_DMA_DIS29(value uint32) {
	volatile.StoreUint32(&o.EPDMADIS.Reg, volatile.LoadUint32(&o.EPDMADIS.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_Type) GetEPDMADIS_EP_DMA_DIS29() uint32 {
	return (volatile.LoadUint32(&o.EPDMADIS.Reg) & 0x20000000) >> 29
}
func (o *USB_Type) SetEPDMADIS_EP_DMA_DIS30(value uint32) {
	volatile.StoreUint32(&o.EPDMADIS.Reg, volatile.LoadUint32(&o.EPDMADIS.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_Type) GetEPDMADIS_EP_DMA_DIS30() uint32 {
	return (volatile.LoadUint32(&o.EPDMADIS.Reg) & 0x40000000) >> 30
}
func (o *USB_Type) SetEPDMADIS_EP_DMA_DIS31(value uint32) {
	volatile.StoreUint32(&o.EPDMADIS.Reg, volatile.LoadUint32(&o.EPDMADIS.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_Type) GetEPDMADIS_EP_DMA_DIS31() uint32 {
	return (volatile.LoadUint32(&o.EPDMADIS.Reg) & 0x80000000) >> 31
}

// USB.DMAINTST: USB DMA Interrupt Status
func (o *USB_Type) SetDMAINTST_EOT(value uint32) {
	volatile.StoreUint32(&o.DMAINTST.Reg, volatile.LoadUint32(&o.DMAINTST.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetDMAINTST_EOT() uint32 {
	return volatile.LoadUint32(&o.DMAINTST.Reg) & 0x1
}
func (o *USB_Type) SetDMAINTST_NDDR(value uint32) {
	volatile.StoreUint32(&o.DMAINTST.Reg, volatile.LoadUint32(&o.DMAINTST.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetDMAINTST_NDDR() uint32 {
	return (volatile.LoadUint32(&o.DMAINTST.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetDMAINTST_ERR(value uint32) {
	volatile.StoreUint32(&o.DMAINTST.Reg, volatile.LoadUint32(&o.DMAINTST.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetDMAINTST_ERR() uint32 {
	return (volatile.LoadUint32(&o.DMAINTST.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetDMAINTST_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DMAINTST.Reg, volatile.LoadUint32(&o.DMAINTST.Reg)&^(0xfffffff8)|value<<3)
}
func (o *USB_Type) GetDMAINTST_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DMAINTST.Reg) & 0xfffffff8) >> 3
}

// USB.DMAINTEN: USB DMA Interrupt Enable
func (o *USB_Type) SetDMAINTEN_EOT(value uint32) {
	volatile.StoreUint32(&o.DMAINTEN.Reg, volatile.LoadUint32(&o.DMAINTEN.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetDMAINTEN_EOT() uint32 {
	return volatile.LoadUint32(&o.DMAINTEN.Reg) & 0x1
}
func (o *USB_Type) SetDMAINTEN_NDDR(value uint32) {
	volatile.StoreUint32(&o.DMAINTEN.Reg, volatile.LoadUint32(&o.DMAINTEN.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetDMAINTEN_NDDR() uint32 {
	return (volatile.LoadUint32(&o.DMAINTEN.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetDMAINTEN_ERR(value uint32) {
	volatile.StoreUint32(&o.DMAINTEN.Reg, volatile.LoadUint32(&o.DMAINTEN.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetDMAINTEN_ERR() uint32 {
	return (volatile.LoadUint32(&o.DMAINTEN.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetDMAINTEN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DMAINTEN.Reg, volatile.LoadUint32(&o.DMAINTEN.Reg)&^(0xfffffff8)|value<<3)
}
func (o *USB_Type) GetDMAINTEN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DMAINTEN.Reg) & 0xfffffff8) >> 3
}

// USB.EOTINTST: USB End of Transfer Interrupt Status
func (o *USB_Type) SetEOTINTST_EPTXINTST0(value uint32) {
	volatile.StoreUint32(&o.EOTINTST.Reg, volatile.LoadUint32(&o.EOTINTST.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetEOTINTST_EPTXINTST0() uint32 {
	return volatile.LoadUint32(&o.EOTINTST.Reg) & 0x1
}
func (o *USB_Type) SetEOTINTST_EPTXINTST1(value uint32) {
	volatile.StoreUint32(&o.EOTINTST.Reg, volatile.LoadUint32(&o.EOTINTST.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetEOTINTST_EPTXINTST1() uint32 {
	return (volatile.LoadUint32(&o.EOTINTST.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetEOTINTST_EPTXINTST2(value uint32) {
	volatile.StoreUint32(&o.EOTINTST.Reg, volatile.LoadUint32(&o.EOTINTST.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetEOTINTST_EPTXINTST2() uint32 {
	return (volatile.LoadUint32(&o.EOTINTST.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetEOTINTST_EPTXINTST3(value uint32) {
	volatile.StoreUint32(&o.EOTINTST.Reg, volatile.LoadUint32(&o.EOTINTST.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetEOTINTST_EPTXINTST3() uint32 {
	return (volatile.LoadUint32(&o.EOTINTST.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetEOTINTST_EPTXINTST4(value uint32) {
	volatile.StoreUint32(&o.EOTINTST.Reg, volatile.LoadUint32(&o.EOTINTST.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetEOTINTST_EPTXINTST4() uint32 {
	return (volatile.LoadUint32(&o.EOTINTST.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetEOTINTST_EPTXINTST5(value uint32) {
	volatile.StoreUint32(&o.EOTINTST.Reg, volatile.LoadUint32(&o.EOTINTST.Reg)&^(0x20)|value<<5)
}
func (o *USB_Type) GetEOTINTST_EPTXINTST5() uint32 {
	return (volatile.LoadUint32(&o.EOTINTST.Reg) & 0x20) >> 5
}
func (o *USB_Type) SetEOTINTST_EPTXINTST6(value uint32) {
	volatile.StoreUint32(&o.EOTINTST.Reg, volatile.LoadUint32(&o.EOTINTST.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetEOTINTST_EPTXINTST6() uint32 {
	return (volatile.LoadUint32(&o.EOTINTST.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetEOTINTST_EPTXINTST7(value uint32) {
	volatile.StoreUint32(&o.EOTINTST.Reg, volatile.LoadUint32(&o.EOTINTST.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetEOTINTST_EPTXINTST7() uint32 {
	return (volatile.LoadUint32(&o.EOTINTST.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetEOTINTST_EPTXINTST8(value uint32) {
	volatile.StoreUint32(&o.EOTINTST.Reg, volatile.LoadUint32(&o.EOTINTST.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetEOTINTST_EPTXINTST8() uint32 {
	return (volatile.LoadUint32(&o.EOTINTST.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetEOTINTST_EPTXINTST9(value uint32) {
	volatile.StoreUint32(&o.EOTINTST.Reg, volatile.LoadUint32(&o.EOTINTST.Reg)&^(0x200)|value<<9)
}
func (o *USB_Type) GetEOTINTST_EPTXINTST9() uint32 {
	return (volatile.LoadUint32(&o.EOTINTST.Reg) & 0x200) >> 9
}
func (o *USB_Type) SetEOTINTST_EPTXINTST10(value uint32) {
	volatile.StoreUint32(&o.EOTINTST.Reg, volatile.LoadUint32(&o.EOTINTST.Reg)&^(0x400)|value<<10)
}
func (o *USB_Type) GetEOTINTST_EPTXINTST10() uint32 {
	return (volatile.LoadUint32(&o.EOTINTST.Reg) & 0x400) >> 10
}
func (o *USB_Type) SetEOTINTST_EPTXINTST11(value uint32) {
	volatile.StoreUint32(&o.EOTINTST.Reg, volatile.LoadUint32(&o.EOTINTST.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetEOTINTST_EPTXINTST11() uint32 {
	return (volatile.LoadUint32(&o.EOTINTST.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetEOTINTST_EPTXINTST12(value uint32) {
	volatile.StoreUint32(&o.EOTINTST.Reg, volatile.LoadUint32(&o.EOTINTST.Reg)&^(0x1000)|value<<12)
}
func (o *USB_Type) GetEOTINTST_EPTXINTST12() uint32 {
	return (volatile.LoadUint32(&o.EOTINTST.Reg) & 0x1000) >> 12
}
func (o *USB_Type) SetEOTINTST_EPTXINTST13(value uint32) {
	volatile.StoreUint32(&o.EOTINTST.Reg, volatile.LoadUint32(&o.EOTINTST.Reg)&^(0x2000)|value<<13)
}
func (o *USB_Type) GetEOTINTST_EPTXINTST13() uint32 {
	return (volatile.LoadUint32(&o.EOTINTST.Reg) & 0x2000) >> 13
}
func (o *USB_Type) SetEOTINTST_EPTXINTST14(value uint32) {
	volatile.StoreUint32(&o.EOTINTST.Reg, volatile.LoadUint32(&o.EOTINTST.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetEOTINTST_EPTXINTST14() uint32 {
	return (volatile.LoadUint32(&o.EOTINTST.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetEOTINTST_EPTXINTST15(value uint32) {
	volatile.StoreUint32(&o.EOTINTST.Reg, volatile.LoadUint32(&o.EOTINTST.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetEOTINTST_EPTXINTST15() uint32 {
	return (volatile.LoadUint32(&o.EOTINTST.Reg) & 0x8000) >> 15
}
func (o *USB_Type) SetEOTINTST_EPTXINTST16(value uint32) {
	volatile.StoreUint32(&o.EOTINTST.Reg, volatile.LoadUint32(&o.EOTINTST.Reg)&^(0x10000)|value<<16)
}
func (o *USB_Type) GetEOTINTST_EPTXINTST16() uint32 {
	return (volatile.LoadUint32(&o.EOTINTST.Reg) & 0x10000) >> 16
}
func (o *USB_Type) SetEOTINTST_EPTXINTST17(value uint32) {
	volatile.StoreUint32(&o.EOTINTST.Reg, volatile.LoadUint32(&o.EOTINTST.Reg)&^(0x20000)|value<<17)
}
func (o *USB_Type) GetEOTINTST_EPTXINTST17() uint32 {
	return (volatile.LoadUint32(&o.EOTINTST.Reg) & 0x20000) >> 17
}
func (o *USB_Type) SetEOTINTST_EPTXINTST18(value uint32) {
	volatile.StoreUint32(&o.EOTINTST.Reg, volatile.LoadUint32(&o.EOTINTST.Reg)&^(0x40000)|value<<18)
}
func (o *USB_Type) GetEOTINTST_EPTXINTST18() uint32 {
	return (volatile.LoadUint32(&o.EOTINTST.Reg) & 0x40000) >> 18
}
func (o *USB_Type) SetEOTINTST_EPTXINTST19(value uint32) {
	volatile.StoreUint32(&o.EOTINTST.Reg, volatile.LoadUint32(&o.EOTINTST.Reg)&^(0x80000)|value<<19)
}
func (o *USB_Type) GetEOTINTST_EPTXINTST19() uint32 {
	return (volatile.LoadUint32(&o.EOTINTST.Reg) & 0x80000) >> 19
}
func (o *USB_Type) SetEOTINTST_EPTXINTST20(value uint32) {
	volatile.StoreUint32(&o.EOTINTST.Reg, volatile.LoadUint32(&o.EOTINTST.Reg)&^(0x100000)|value<<20)
}
func (o *USB_Type) GetEOTINTST_EPTXINTST20() uint32 {
	return (volatile.LoadUint32(&o.EOTINTST.Reg) & 0x100000) >> 20
}
func (o *USB_Type) SetEOTINTST_EPTXINTST21(value uint32) {
	volatile.StoreUint32(&o.EOTINTST.Reg, volatile.LoadUint32(&o.EOTINTST.Reg)&^(0x200000)|value<<21)
}
func (o *USB_Type) GetEOTINTST_EPTXINTST21() uint32 {
	return (volatile.LoadUint32(&o.EOTINTST.Reg) & 0x200000) >> 21
}
func (o *USB_Type) SetEOTINTST_EPTXINTST22(value uint32) {
	volatile.StoreUint32(&o.EOTINTST.Reg, volatile.LoadUint32(&o.EOTINTST.Reg)&^(0x400000)|value<<22)
}
func (o *USB_Type) GetEOTINTST_EPTXINTST22() uint32 {
	return (volatile.LoadUint32(&o.EOTINTST.Reg) & 0x400000) >> 22
}
func (o *USB_Type) SetEOTINTST_EPTXINTST23(value uint32) {
	volatile.StoreUint32(&o.EOTINTST.Reg, volatile.LoadUint32(&o.EOTINTST.Reg)&^(0x800000)|value<<23)
}
func (o *USB_Type) GetEOTINTST_EPTXINTST23() uint32 {
	return (volatile.LoadUint32(&o.EOTINTST.Reg) & 0x800000) >> 23
}
func (o *USB_Type) SetEOTINTST_EPTXINTST24(value uint32) {
	volatile.StoreUint32(&o.EOTINTST.Reg, volatile.LoadUint32(&o.EOTINTST.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_Type) GetEOTINTST_EPTXINTST24() uint32 {
	return (volatile.LoadUint32(&o.EOTINTST.Reg) & 0x1000000) >> 24
}
func (o *USB_Type) SetEOTINTST_EPTXINTST25(value uint32) {
	volatile.StoreUint32(&o.EOTINTST.Reg, volatile.LoadUint32(&o.EOTINTST.Reg)&^(0x2000000)|value<<25)
}
func (o *USB_Type) GetEOTINTST_EPTXINTST25() uint32 {
	return (volatile.LoadUint32(&o.EOTINTST.Reg) & 0x2000000) >> 25
}
func (o *USB_Type) SetEOTINTST_EPTXINTST26(value uint32) {
	volatile.StoreUint32(&o.EOTINTST.Reg, volatile.LoadUint32(&o.EOTINTST.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_Type) GetEOTINTST_EPTXINTST26() uint32 {
	return (volatile.LoadUint32(&o.EOTINTST.Reg) & 0x4000000) >> 26
}
func (o *USB_Type) SetEOTINTST_EPTXINTST27(value uint32) {
	volatile.StoreUint32(&o.EOTINTST.Reg, volatile.LoadUint32(&o.EOTINTST.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_Type) GetEOTINTST_EPTXINTST27() uint32 {
	return (volatile.LoadUint32(&o.EOTINTST.Reg) & 0x8000000) >> 27
}
func (o *USB_Type) SetEOTINTST_EPTXINTST28(value uint32) {
	volatile.StoreUint32(&o.EOTINTST.Reg, volatile.LoadUint32(&o.EOTINTST.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_Type) GetEOTINTST_EPTXINTST28() uint32 {
	return (volatile.LoadUint32(&o.EOTINTST.Reg) & 0x10000000) >> 28
}
func (o *USB_Type) SetEOTINTST_EPTXINTST29(value uint32) {
	volatile.StoreUint32(&o.EOTINTST.Reg, volatile.LoadUint32(&o.EOTINTST.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_Type) GetEOTINTST_EPTXINTST29() uint32 {
	return (volatile.LoadUint32(&o.EOTINTST.Reg) & 0x20000000) >> 29
}
func (o *USB_Type) SetEOTINTST_EPTXINTST30(value uint32) {
	volatile.StoreUint32(&o.EOTINTST.Reg, volatile.LoadUint32(&o.EOTINTST.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_Type) GetEOTINTST_EPTXINTST30() uint32 {
	return (volatile.LoadUint32(&o.EOTINTST.Reg) & 0x40000000) >> 30
}
func (o *USB_Type) SetEOTINTST_EPTXINTST31(value uint32) {
	volatile.StoreUint32(&o.EOTINTST.Reg, volatile.LoadUint32(&o.EOTINTST.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_Type) GetEOTINTST_EPTXINTST31() uint32 {
	return (volatile.LoadUint32(&o.EOTINTST.Reg) & 0x80000000) >> 31
}

// USB.EOTINTCLR: USB End of Transfer Interrupt Clear
func (o *USB_Type) SetEOTINTCLR_EPTXINTCLR0(value uint32) {
	volatile.StoreUint32(&o.EOTINTCLR.Reg, volatile.LoadUint32(&o.EOTINTCLR.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetEOTINTCLR_EPTXINTCLR0() uint32 {
	return volatile.LoadUint32(&o.EOTINTCLR.Reg) & 0x1
}
func (o *USB_Type) SetEOTINTCLR_EPTXINTCLR1(value uint32) {
	volatile.StoreUint32(&o.EOTINTCLR.Reg, volatile.LoadUint32(&o.EOTINTCLR.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetEOTINTCLR_EPTXINTCLR1() uint32 {
	return (volatile.LoadUint32(&o.EOTINTCLR.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetEOTINTCLR_EPTXINTCLR2(value uint32) {
	volatile.StoreUint32(&o.EOTINTCLR.Reg, volatile.LoadUint32(&o.EOTINTCLR.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetEOTINTCLR_EPTXINTCLR2() uint32 {
	return (volatile.LoadUint32(&o.EOTINTCLR.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetEOTINTCLR_EPTXINTCLR3(value uint32) {
	volatile.StoreUint32(&o.EOTINTCLR.Reg, volatile.LoadUint32(&o.EOTINTCLR.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetEOTINTCLR_EPTXINTCLR3() uint32 {
	return (volatile.LoadUint32(&o.EOTINTCLR.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetEOTINTCLR_EPTXINTCLR4(value uint32) {
	volatile.StoreUint32(&o.EOTINTCLR.Reg, volatile.LoadUint32(&o.EOTINTCLR.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetEOTINTCLR_EPTXINTCLR4() uint32 {
	return (volatile.LoadUint32(&o.EOTINTCLR.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetEOTINTCLR_EPTXINTCLR5(value uint32) {
	volatile.StoreUint32(&o.EOTINTCLR.Reg, volatile.LoadUint32(&o.EOTINTCLR.Reg)&^(0x20)|value<<5)
}
func (o *USB_Type) GetEOTINTCLR_EPTXINTCLR5() uint32 {
	return (volatile.LoadUint32(&o.EOTINTCLR.Reg) & 0x20) >> 5
}
func (o *USB_Type) SetEOTINTCLR_EPTXINTCLR6(value uint32) {
	volatile.StoreUint32(&o.EOTINTCLR.Reg, volatile.LoadUint32(&o.EOTINTCLR.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetEOTINTCLR_EPTXINTCLR6() uint32 {
	return (volatile.LoadUint32(&o.EOTINTCLR.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetEOTINTCLR_EPTXINTCLR7(value uint32) {
	volatile.StoreUint32(&o.EOTINTCLR.Reg, volatile.LoadUint32(&o.EOTINTCLR.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetEOTINTCLR_EPTXINTCLR7() uint32 {
	return (volatile.LoadUint32(&o.EOTINTCLR.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetEOTINTCLR_EPTXINTCLR8(value uint32) {
	volatile.StoreUint32(&o.EOTINTCLR.Reg, volatile.LoadUint32(&o.EOTINTCLR.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetEOTINTCLR_EPTXINTCLR8() uint32 {
	return (volatile.LoadUint32(&o.EOTINTCLR.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetEOTINTCLR_EPTXINTCLR9(value uint32) {
	volatile.StoreUint32(&o.EOTINTCLR.Reg, volatile.LoadUint32(&o.EOTINTCLR.Reg)&^(0x200)|value<<9)
}
func (o *USB_Type) GetEOTINTCLR_EPTXINTCLR9() uint32 {
	return (volatile.LoadUint32(&o.EOTINTCLR.Reg) & 0x200) >> 9
}
func (o *USB_Type) SetEOTINTCLR_EPTXINTCLR10(value uint32) {
	volatile.StoreUint32(&o.EOTINTCLR.Reg, volatile.LoadUint32(&o.EOTINTCLR.Reg)&^(0x400)|value<<10)
}
func (o *USB_Type) GetEOTINTCLR_EPTXINTCLR10() uint32 {
	return (volatile.LoadUint32(&o.EOTINTCLR.Reg) & 0x400) >> 10
}
func (o *USB_Type) SetEOTINTCLR_EPTXINTCLR11(value uint32) {
	volatile.StoreUint32(&o.EOTINTCLR.Reg, volatile.LoadUint32(&o.EOTINTCLR.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetEOTINTCLR_EPTXINTCLR11() uint32 {
	return (volatile.LoadUint32(&o.EOTINTCLR.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetEOTINTCLR_EPTXINTCLR12(value uint32) {
	volatile.StoreUint32(&o.EOTINTCLR.Reg, volatile.LoadUint32(&o.EOTINTCLR.Reg)&^(0x1000)|value<<12)
}
func (o *USB_Type) GetEOTINTCLR_EPTXINTCLR12() uint32 {
	return (volatile.LoadUint32(&o.EOTINTCLR.Reg) & 0x1000) >> 12
}
func (o *USB_Type) SetEOTINTCLR_EPTXINTCLR13(value uint32) {
	volatile.StoreUint32(&o.EOTINTCLR.Reg, volatile.LoadUint32(&o.EOTINTCLR.Reg)&^(0x2000)|value<<13)
}
func (o *USB_Type) GetEOTINTCLR_EPTXINTCLR13() uint32 {
	return (volatile.LoadUint32(&o.EOTINTCLR.Reg) & 0x2000) >> 13
}
func (o *USB_Type) SetEOTINTCLR_EPTXINTCLR14(value uint32) {
	volatile.StoreUint32(&o.EOTINTCLR.Reg, volatile.LoadUint32(&o.EOTINTCLR.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetEOTINTCLR_EPTXINTCLR14() uint32 {
	return (volatile.LoadUint32(&o.EOTINTCLR.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetEOTINTCLR_EPTXINTCLR15(value uint32) {
	volatile.StoreUint32(&o.EOTINTCLR.Reg, volatile.LoadUint32(&o.EOTINTCLR.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetEOTINTCLR_EPTXINTCLR15() uint32 {
	return (volatile.LoadUint32(&o.EOTINTCLR.Reg) & 0x8000) >> 15
}
func (o *USB_Type) SetEOTINTCLR_EPTXINTCLR16(value uint32) {
	volatile.StoreUint32(&o.EOTINTCLR.Reg, volatile.LoadUint32(&o.EOTINTCLR.Reg)&^(0x10000)|value<<16)
}
func (o *USB_Type) GetEOTINTCLR_EPTXINTCLR16() uint32 {
	return (volatile.LoadUint32(&o.EOTINTCLR.Reg) & 0x10000) >> 16
}
func (o *USB_Type) SetEOTINTCLR_EPTXINTCLR17(value uint32) {
	volatile.StoreUint32(&o.EOTINTCLR.Reg, volatile.LoadUint32(&o.EOTINTCLR.Reg)&^(0x20000)|value<<17)
}
func (o *USB_Type) GetEOTINTCLR_EPTXINTCLR17() uint32 {
	return (volatile.LoadUint32(&o.EOTINTCLR.Reg) & 0x20000) >> 17
}
func (o *USB_Type) SetEOTINTCLR_EPTXINTCLR18(value uint32) {
	volatile.StoreUint32(&o.EOTINTCLR.Reg, volatile.LoadUint32(&o.EOTINTCLR.Reg)&^(0x40000)|value<<18)
}
func (o *USB_Type) GetEOTINTCLR_EPTXINTCLR18() uint32 {
	return (volatile.LoadUint32(&o.EOTINTCLR.Reg) & 0x40000) >> 18
}
func (o *USB_Type) SetEOTINTCLR_EPTXINTCLR19(value uint32) {
	volatile.StoreUint32(&o.EOTINTCLR.Reg, volatile.LoadUint32(&o.EOTINTCLR.Reg)&^(0x80000)|value<<19)
}
func (o *USB_Type) GetEOTINTCLR_EPTXINTCLR19() uint32 {
	return (volatile.LoadUint32(&o.EOTINTCLR.Reg) & 0x80000) >> 19
}
func (o *USB_Type) SetEOTINTCLR_EPTXINTCLR20(value uint32) {
	volatile.StoreUint32(&o.EOTINTCLR.Reg, volatile.LoadUint32(&o.EOTINTCLR.Reg)&^(0x100000)|value<<20)
}
func (o *USB_Type) GetEOTINTCLR_EPTXINTCLR20() uint32 {
	return (volatile.LoadUint32(&o.EOTINTCLR.Reg) & 0x100000) >> 20
}
func (o *USB_Type) SetEOTINTCLR_EPTXINTCLR21(value uint32) {
	volatile.StoreUint32(&o.EOTINTCLR.Reg, volatile.LoadUint32(&o.EOTINTCLR.Reg)&^(0x200000)|value<<21)
}
func (o *USB_Type) GetEOTINTCLR_EPTXINTCLR21() uint32 {
	return (volatile.LoadUint32(&o.EOTINTCLR.Reg) & 0x200000) >> 21
}
func (o *USB_Type) SetEOTINTCLR_EPTXINTCLR22(value uint32) {
	volatile.StoreUint32(&o.EOTINTCLR.Reg, volatile.LoadUint32(&o.EOTINTCLR.Reg)&^(0x400000)|value<<22)
}
func (o *USB_Type) GetEOTINTCLR_EPTXINTCLR22() uint32 {
	return (volatile.LoadUint32(&o.EOTINTCLR.Reg) & 0x400000) >> 22
}
func (o *USB_Type) SetEOTINTCLR_EPTXINTCLR23(value uint32) {
	volatile.StoreUint32(&o.EOTINTCLR.Reg, volatile.LoadUint32(&o.EOTINTCLR.Reg)&^(0x800000)|value<<23)
}
func (o *USB_Type) GetEOTINTCLR_EPTXINTCLR23() uint32 {
	return (volatile.LoadUint32(&o.EOTINTCLR.Reg) & 0x800000) >> 23
}
func (o *USB_Type) SetEOTINTCLR_EPTXINTCLR24(value uint32) {
	volatile.StoreUint32(&o.EOTINTCLR.Reg, volatile.LoadUint32(&o.EOTINTCLR.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_Type) GetEOTINTCLR_EPTXINTCLR24() uint32 {
	return (volatile.LoadUint32(&o.EOTINTCLR.Reg) & 0x1000000) >> 24
}
func (o *USB_Type) SetEOTINTCLR_EPTXINTCLR25(value uint32) {
	volatile.StoreUint32(&o.EOTINTCLR.Reg, volatile.LoadUint32(&o.EOTINTCLR.Reg)&^(0x2000000)|value<<25)
}
func (o *USB_Type) GetEOTINTCLR_EPTXINTCLR25() uint32 {
	return (volatile.LoadUint32(&o.EOTINTCLR.Reg) & 0x2000000) >> 25
}
func (o *USB_Type) SetEOTINTCLR_EPTXINTCLR26(value uint32) {
	volatile.StoreUint32(&o.EOTINTCLR.Reg, volatile.LoadUint32(&o.EOTINTCLR.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_Type) GetEOTINTCLR_EPTXINTCLR26() uint32 {
	return (volatile.LoadUint32(&o.EOTINTCLR.Reg) & 0x4000000) >> 26
}
func (o *USB_Type) SetEOTINTCLR_EPTXINTCLR27(value uint32) {
	volatile.StoreUint32(&o.EOTINTCLR.Reg, volatile.LoadUint32(&o.EOTINTCLR.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_Type) GetEOTINTCLR_EPTXINTCLR27() uint32 {
	return (volatile.LoadUint32(&o.EOTINTCLR.Reg) & 0x8000000) >> 27
}
func (o *USB_Type) SetEOTINTCLR_EPTXINTCLR28(value uint32) {
	volatile.StoreUint32(&o.EOTINTCLR.Reg, volatile.LoadUint32(&o.EOTINTCLR.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_Type) GetEOTINTCLR_EPTXINTCLR28() uint32 {
	return (volatile.LoadUint32(&o.EOTINTCLR.Reg) & 0x10000000) >> 28
}
func (o *USB_Type) SetEOTINTCLR_EPTXINTCLR29(value uint32) {
	volatile.StoreUint32(&o.EOTINTCLR.Reg, volatile.LoadUint32(&o.EOTINTCLR.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_Type) GetEOTINTCLR_EPTXINTCLR29() uint32 {
	return (volatile.LoadUint32(&o.EOTINTCLR.Reg) & 0x20000000) >> 29
}
func (o *USB_Type) SetEOTINTCLR_EPTXINTCLR30(value uint32) {
	volatile.StoreUint32(&o.EOTINTCLR.Reg, volatile.LoadUint32(&o.EOTINTCLR.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_Type) GetEOTINTCLR_EPTXINTCLR30() uint32 {
	return (volatile.LoadUint32(&o.EOTINTCLR.Reg) & 0x40000000) >> 30
}
func (o *USB_Type) SetEOTINTCLR_EPTXINTCLR31(value uint32) {
	volatile.StoreUint32(&o.EOTINTCLR.Reg, volatile.LoadUint32(&o.EOTINTCLR.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_Type) GetEOTINTCLR_EPTXINTCLR31() uint32 {
	return (volatile.LoadUint32(&o.EOTINTCLR.Reg) & 0x80000000) >> 31
}

// USB.EOTINTSET: USB End of Transfer Interrupt Set
func (o *USB_Type) SetEOTINTSET_EPTXINTSET0(value uint32) {
	volatile.StoreUint32(&o.EOTINTSET.Reg, volatile.LoadUint32(&o.EOTINTSET.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetEOTINTSET_EPTXINTSET0() uint32 {
	return volatile.LoadUint32(&o.EOTINTSET.Reg) & 0x1
}
func (o *USB_Type) SetEOTINTSET_EPTXINTSET1(value uint32) {
	volatile.StoreUint32(&o.EOTINTSET.Reg, volatile.LoadUint32(&o.EOTINTSET.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetEOTINTSET_EPTXINTSET1() uint32 {
	return (volatile.LoadUint32(&o.EOTINTSET.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetEOTINTSET_EPTXINTSET2(value uint32) {
	volatile.StoreUint32(&o.EOTINTSET.Reg, volatile.LoadUint32(&o.EOTINTSET.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetEOTINTSET_EPTXINTSET2() uint32 {
	return (volatile.LoadUint32(&o.EOTINTSET.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetEOTINTSET_EPTXINTSET3(value uint32) {
	volatile.StoreUint32(&o.EOTINTSET.Reg, volatile.LoadUint32(&o.EOTINTSET.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetEOTINTSET_EPTXINTSET3() uint32 {
	return (volatile.LoadUint32(&o.EOTINTSET.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetEOTINTSET_EPTXINTSET4(value uint32) {
	volatile.StoreUint32(&o.EOTINTSET.Reg, volatile.LoadUint32(&o.EOTINTSET.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetEOTINTSET_EPTXINTSET4() uint32 {
	return (volatile.LoadUint32(&o.EOTINTSET.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetEOTINTSET_EPTXINTSET5(value uint32) {
	volatile.StoreUint32(&o.EOTINTSET.Reg, volatile.LoadUint32(&o.EOTINTSET.Reg)&^(0x20)|value<<5)
}
func (o *USB_Type) GetEOTINTSET_EPTXINTSET5() uint32 {
	return (volatile.LoadUint32(&o.EOTINTSET.Reg) & 0x20) >> 5
}
func (o *USB_Type) SetEOTINTSET_EPTXINTSET6(value uint32) {
	volatile.StoreUint32(&o.EOTINTSET.Reg, volatile.LoadUint32(&o.EOTINTSET.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetEOTINTSET_EPTXINTSET6() uint32 {
	return (volatile.LoadUint32(&o.EOTINTSET.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetEOTINTSET_EPTXINTSET7(value uint32) {
	volatile.StoreUint32(&o.EOTINTSET.Reg, volatile.LoadUint32(&o.EOTINTSET.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetEOTINTSET_EPTXINTSET7() uint32 {
	return (volatile.LoadUint32(&o.EOTINTSET.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetEOTINTSET_EPTXINTSET8(value uint32) {
	volatile.StoreUint32(&o.EOTINTSET.Reg, volatile.LoadUint32(&o.EOTINTSET.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetEOTINTSET_EPTXINTSET8() uint32 {
	return (volatile.LoadUint32(&o.EOTINTSET.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetEOTINTSET_EPTXINTSET9(value uint32) {
	volatile.StoreUint32(&o.EOTINTSET.Reg, volatile.LoadUint32(&o.EOTINTSET.Reg)&^(0x200)|value<<9)
}
func (o *USB_Type) GetEOTINTSET_EPTXINTSET9() uint32 {
	return (volatile.LoadUint32(&o.EOTINTSET.Reg) & 0x200) >> 9
}
func (o *USB_Type) SetEOTINTSET_EPTXINTSET10(value uint32) {
	volatile.StoreUint32(&o.EOTINTSET.Reg, volatile.LoadUint32(&o.EOTINTSET.Reg)&^(0x400)|value<<10)
}
func (o *USB_Type) GetEOTINTSET_EPTXINTSET10() uint32 {
	return (volatile.LoadUint32(&o.EOTINTSET.Reg) & 0x400) >> 10
}
func (o *USB_Type) SetEOTINTSET_EPTXINTSET11(value uint32) {
	volatile.StoreUint32(&o.EOTINTSET.Reg, volatile.LoadUint32(&o.EOTINTSET.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetEOTINTSET_EPTXINTSET11() uint32 {
	return (volatile.LoadUint32(&o.EOTINTSET.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetEOTINTSET_EPTXINTSET12(value uint32) {
	volatile.StoreUint32(&o.EOTINTSET.Reg, volatile.LoadUint32(&o.EOTINTSET.Reg)&^(0x1000)|value<<12)
}
func (o *USB_Type) GetEOTINTSET_EPTXINTSET12() uint32 {
	return (volatile.LoadUint32(&o.EOTINTSET.Reg) & 0x1000) >> 12
}
func (o *USB_Type) SetEOTINTSET_EPTXINTSET13(value uint32) {
	volatile.StoreUint32(&o.EOTINTSET.Reg, volatile.LoadUint32(&o.EOTINTSET.Reg)&^(0x2000)|value<<13)
}
func (o *USB_Type) GetEOTINTSET_EPTXINTSET13() uint32 {
	return (volatile.LoadUint32(&o.EOTINTSET.Reg) & 0x2000) >> 13
}
func (o *USB_Type) SetEOTINTSET_EPTXINTSET14(value uint32) {
	volatile.StoreUint32(&o.EOTINTSET.Reg, volatile.LoadUint32(&o.EOTINTSET.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetEOTINTSET_EPTXINTSET14() uint32 {
	return (volatile.LoadUint32(&o.EOTINTSET.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetEOTINTSET_EPTXINTSET15(value uint32) {
	volatile.StoreUint32(&o.EOTINTSET.Reg, volatile.LoadUint32(&o.EOTINTSET.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetEOTINTSET_EPTXINTSET15() uint32 {
	return (volatile.LoadUint32(&o.EOTINTSET.Reg) & 0x8000) >> 15
}
func (o *USB_Type) SetEOTINTSET_EPTXINTSET16(value uint32) {
	volatile.StoreUint32(&o.EOTINTSET.Reg, volatile.LoadUint32(&o.EOTINTSET.Reg)&^(0x10000)|value<<16)
}
func (o *USB_Type) GetEOTINTSET_EPTXINTSET16() uint32 {
	return (volatile.LoadUint32(&o.EOTINTSET.Reg) & 0x10000) >> 16
}
func (o *USB_Type) SetEOTINTSET_EPTXINTSET17(value uint32) {
	volatile.StoreUint32(&o.EOTINTSET.Reg, volatile.LoadUint32(&o.EOTINTSET.Reg)&^(0x20000)|value<<17)
}
func (o *USB_Type) GetEOTINTSET_EPTXINTSET17() uint32 {
	return (volatile.LoadUint32(&o.EOTINTSET.Reg) & 0x20000) >> 17
}
func (o *USB_Type) SetEOTINTSET_EPTXINTSET18(value uint32) {
	volatile.StoreUint32(&o.EOTINTSET.Reg, volatile.LoadUint32(&o.EOTINTSET.Reg)&^(0x40000)|value<<18)
}
func (o *USB_Type) GetEOTINTSET_EPTXINTSET18() uint32 {
	return (volatile.LoadUint32(&o.EOTINTSET.Reg) & 0x40000) >> 18
}
func (o *USB_Type) SetEOTINTSET_EPTXINTSET19(value uint32) {
	volatile.StoreUint32(&o.EOTINTSET.Reg, volatile.LoadUint32(&o.EOTINTSET.Reg)&^(0x80000)|value<<19)
}
func (o *USB_Type) GetEOTINTSET_EPTXINTSET19() uint32 {
	return (volatile.LoadUint32(&o.EOTINTSET.Reg) & 0x80000) >> 19
}
func (o *USB_Type) SetEOTINTSET_EPTXINTSET20(value uint32) {
	volatile.StoreUint32(&o.EOTINTSET.Reg, volatile.LoadUint32(&o.EOTINTSET.Reg)&^(0x100000)|value<<20)
}
func (o *USB_Type) GetEOTINTSET_EPTXINTSET20() uint32 {
	return (volatile.LoadUint32(&o.EOTINTSET.Reg) & 0x100000) >> 20
}
func (o *USB_Type) SetEOTINTSET_EPTXINTSET21(value uint32) {
	volatile.StoreUint32(&o.EOTINTSET.Reg, volatile.LoadUint32(&o.EOTINTSET.Reg)&^(0x200000)|value<<21)
}
func (o *USB_Type) GetEOTINTSET_EPTXINTSET21() uint32 {
	return (volatile.LoadUint32(&o.EOTINTSET.Reg) & 0x200000) >> 21
}
func (o *USB_Type) SetEOTINTSET_EPTXINTSET22(value uint32) {
	volatile.StoreUint32(&o.EOTINTSET.Reg, volatile.LoadUint32(&o.EOTINTSET.Reg)&^(0x400000)|value<<22)
}
func (o *USB_Type) GetEOTINTSET_EPTXINTSET22() uint32 {
	return (volatile.LoadUint32(&o.EOTINTSET.Reg) & 0x400000) >> 22
}
func (o *USB_Type) SetEOTINTSET_EPTXINTSET23(value uint32) {
	volatile.StoreUint32(&o.EOTINTSET.Reg, volatile.LoadUint32(&o.EOTINTSET.Reg)&^(0x800000)|value<<23)
}
func (o *USB_Type) GetEOTINTSET_EPTXINTSET23() uint32 {
	return (volatile.LoadUint32(&o.EOTINTSET.Reg) & 0x800000) >> 23
}
func (o *USB_Type) SetEOTINTSET_EPTXINTSET24(value uint32) {
	volatile.StoreUint32(&o.EOTINTSET.Reg, volatile.LoadUint32(&o.EOTINTSET.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_Type) GetEOTINTSET_EPTXINTSET24() uint32 {
	return (volatile.LoadUint32(&o.EOTINTSET.Reg) & 0x1000000) >> 24
}
func (o *USB_Type) SetEOTINTSET_EPTXINTSET25(value uint32) {
	volatile.StoreUint32(&o.EOTINTSET.Reg, volatile.LoadUint32(&o.EOTINTSET.Reg)&^(0x2000000)|value<<25)
}
func (o *USB_Type) GetEOTINTSET_EPTXINTSET25() uint32 {
	return (volatile.LoadUint32(&o.EOTINTSET.Reg) & 0x2000000) >> 25
}
func (o *USB_Type) SetEOTINTSET_EPTXINTSET26(value uint32) {
	volatile.StoreUint32(&o.EOTINTSET.Reg, volatile.LoadUint32(&o.EOTINTSET.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_Type) GetEOTINTSET_EPTXINTSET26() uint32 {
	return (volatile.LoadUint32(&o.EOTINTSET.Reg) & 0x4000000) >> 26
}
func (o *USB_Type) SetEOTINTSET_EPTXINTSET27(value uint32) {
	volatile.StoreUint32(&o.EOTINTSET.Reg, volatile.LoadUint32(&o.EOTINTSET.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_Type) GetEOTINTSET_EPTXINTSET27() uint32 {
	return (volatile.LoadUint32(&o.EOTINTSET.Reg) & 0x8000000) >> 27
}
func (o *USB_Type) SetEOTINTSET_EPTXINTSET28(value uint32) {
	volatile.StoreUint32(&o.EOTINTSET.Reg, volatile.LoadUint32(&o.EOTINTSET.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_Type) GetEOTINTSET_EPTXINTSET28() uint32 {
	return (volatile.LoadUint32(&o.EOTINTSET.Reg) & 0x10000000) >> 28
}
func (o *USB_Type) SetEOTINTSET_EPTXINTSET29(value uint32) {
	volatile.StoreUint32(&o.EOTINTSET.Reg, volatile.LoadUint32(&o.EOTINTSET.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_Type) GetEOTINTSET_EPTXINTSET29() uint32 {
	return (volatile.LoadUint32(&o.EOTINTSET.Reg) & 0x20000000) >> 29
}
func (o *USB_Type) SetEOTINTSET_EPTXINTSET30(value uint32) {
	volatile.StoreUint32(&o.EOTINTSET.Reg, volatile.LoadUint32(&o.EOTINTSET.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_Type) GetEOTINTSET_EPTXINTSET30() uint32 {
	return (volatile.LoadUint32(&o.EOTINTSET.Reg) & 0x40000000) >> 30
}
func (o *USB_Type) SetEOTINTSET_EPTXINTSET31(value uint32) {
	volatile.StoreUint32(&o.EOTINTSET.Reg, volatile.LoadUint32(&o.EOTINTSET.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_Type) GetEOTINTSET_EPTXINTSET31() uint32 {
	return (volatile.LoadUint32(&o.EOTINTSET.Reg) & 0x80000000) >> 31
}

// USB.NDDRINTST: USB New DD Request Interrupt Status
func (o *USB_Type) SetNDDRINTST_EPNDDINTST0(value uint32) {
	volatile.StoreUint32(&o.NDDRINTST.Reg, volatile.LoadUint32(&o.NDDRINTST.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetNDDRINTST_EPNDDINTST0() uint32 {
	return volatile.LoadUint32(&o.NDDRINTST.Reg) & 0x1
}
func (o *USB_Type) SetNDDRINTST_EPNDDINTST1(value uint32) {
	volatile.StoreUint32(&o.NDDRINTST.Reg, volatile.LoadUint32(&o.NDDRINTST.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetNDDRINTST_EPNDDINTST1() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTST.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetNDDRINTST_EPNDDINTST2(value uint32) {
	volatile.StoreUint32(&o.NDDRINTST.Reg, volatile.LoadUint32(&o.NDDRINTST.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetNDDRINTST_EPNDDINTST2() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTST.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetNDDRINTST_EPNDDINTST3(value uint32) {
	volatile.StoreUint32(&o.NDDRINTST.Reg, volatile.LoadUint32(&o.NDDRINTST.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetNDDRINTST_EPNDDINTST3() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTST.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetNDDRINTST_EPNDDINTST4(value uint32) {
	volatile.StoreUint32(&o.NDDRINTST.Reg, volatile.LoadUint32(&o.NDDRINTST.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetNDDRINTST_EPNDDINTST4() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTST.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetNDDRINTST_EPNDDINTST5(value uint32) {
	volatile.StoreUint32(&o.NDDRINTST.Reg, volatile.LoadUint32(&o.NDDRINTST.Reg)&^(0x20)|value<<5)
}
func (o *USB_Type) GetNDDRINTST_EPNDDINTST5() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTST.Reg) & 0x20) >> 5
}
func (o *USB_Type) SetNDDRINTST_EPNDDINTST6(value uint32) {
	volatile.StoreUint32(&o.NDDRINTST.Reg, volatile.LoadUint32(&o.NDDRINTST.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetNDDRINTST_EPNDDINTST6() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTST.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetNDDRINTST_EPNDDINTST7(value uint32) {
	volatile.StoreUint32(&o.NDDRINTST.Reg, volatile.LoadUint32(&o.NDDRINTST.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetNDDRINTST_EPNDDINTST7() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTST.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetNDDRINTST_EPNDDINTST8(value uint32) {
	volatile.StoreUint32(&o.NDDRINTST.Reg, volatile.LoadUint32(&o.NDDRINTST.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetNDDRINTST_EPNDDINTST8() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTST.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetNDDRINTST_EPNDDINTST9(value uint32) {
	volatile.StoreUint32(&o.NDDRINTST.Reg, volatile.LoadUint32(&o.NDDRINTST.Reg)&^(0x200)|value<<9)
}
func (o *USB_Type) GetNDDRINTST_EPNDDINTST9() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTST.Reg) & 0x200) >> 9
}
func (o *USB_Type) SetNDDRINTST_EPNDDINTST10(value uint32) {
	volatile.StoreUint32(&o.NDDRINTST.Reg, volatile.LoadUint32(&o.NDDRINTST.Reg)&^(0x400)|value<<10)
}
func (o *USB_Type) GetNDDRINTST_EPNDDINTST10() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTST.Reg) & 0x400) >> 10
}
func (o *USB_Type) SetNDDRINTST_EPNDDINTST11(value uint32) {
	volatile.StoreUint32(&o.NDDRINTST.Reg, volatile.LoadUint32(&o.NDDRINTST.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetNDDRINTST_EPNDDINTST11() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTST.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetNDDRINTST_EPNDDINTST12(value uint32) {
	volatile.StoreUint32(&o.NDDRINTST.Reg, volatile.LoadUint32(&o.NDDRINTST.Reg)&^(0x1000)|value<<12)
}
func (o *USB_Type) GetNDDRINTST_EPNDDINTST12() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTST.Reg) & 0x1000) >> 12
}
func (o *USB_Type) SetNDDRINTST_EPNDDINTST13(value uint32) {
	volatile.StoreUint32(&o.NDDRINTST.Reg, volatile.LoadUint32(&o.NDDRINTST.Reg)&^(0x2000)|value<<13)
}
func (o *USB_Type) GetNDDRINTST_EPNDDINTST13() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTST.Reg) & 0x2000) >> 13
}
func (o *USB_Type) SetNDDRINTST_EPNDDINTST14(value uint32) {
	volatile.StoreUint32(&o.NDDRINTST.Reg, volatile.LoadUint32(&o.NDDRINTST.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetNDDRINTST_EPNDDINTST14() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTST.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetNDDRINTST_EPNDDINTST15(value uint32) {
	volatile.StoreUint32(&o.NDDRINTST.Reg, volatile.LoadUint32(&o.NDDRINTST.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetNDDRINTST_EPNDDINTST15() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTST.Reg) & 0x8000) >> 15
}
func (o *USB_Type) SetNDDRINTST_EPNDDINTST16(value uint32) {
	volatile.StoreUint32(&o.NDDRINTST.Reg, volatile.LoadUint32(&o.NDDRINTST.Reg)&^(0x10000)|value<<16)
}
func (o *USB_Type) GetNDDRINTST_EPNDDINTST16() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTST.Reg) & 0x10000) >> 16
}
func (o *USB_Type) SetNDDRINTST_EPNDDINTST17(value uint32) {
	volatile.StoreUint32(&o.NDDRINTST.Reg, volatile.LoadUint32(&o.NDDRINTST.Reg)&^(0x20000)|value<<17)
}
func (o *USB_Type) GetNDDRINTST_EPNDDINTST17() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTST.Reg) & 0x20000) >> 17
}
func (o *USB_Type) SetNDDRINTST_EPNDDINTST18(value uint32) {
	volatile.StoreUint32(&o.NDDRINTST.Reg, volatile.LoadUint32(&o.NDDRINTST.Reg)&^(0x40000)|value<<18)
}
func (o *USB_Type) GetNDDRINTST_EPNDDINTST18() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTST.Reg) & 0x40000) >> 18
}
func (o *USB_Type) SetNDDRINTST_EPNDDINTST19(value uint32) {
	volatile.StoreUint32(&o.NDDRINTST.Reg, volatile.LoadUint32(&o.NDDRINTST.Reg)&^(0x80000)|value<<19)
}
func (o *USB_Type) GetNDDRINTST_EPNDDINTST19() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTST.Reg) & 0x80000) >> 19
}
func (o *USB_Type) SetNDDRINTST_EPNDDINTST20(value uint32) {
	volatile.StoreUint32(&o.NDDRINTST.Reg, volatile.LoadUint32(&o.NDDRINTST.Reg)&^(0x100000)|value<<20)
}
func (o *USB_Type) GetNDDRINTST_EPNDDINTST20() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTST.Reg) & 0x100000) >> 20
}
func (o *USB_Type) SetNDDRINTST_EPNDDINTST21(value uint32) {
	volatile.StoreUint32(&o.NDDRINTST.Reg, volatile.LoadUint32(&o.NDDRINTST.Reg)&^(0x200000)|value<<21)
}
func (o *USB_Type) GetNDDRINTST_EPNDDINTST21() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTST.Reg) & 0x200000) >> 21
}
func (o *USB_Type) SetNDDRINTST_EPNDDINTST22(value uint32) {
	volatile.StoreUint32(&o.NDDRINTST.Reg, volatile.LoadUint32(&o.NDDRINTST.Reg)&^(0x400000)|value<<22)
}
func (o *USB_Type) GetNDDRINTST_EPNDDINTST22() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTST.Reg) & 0x400000) >> 22
}
func (o *USB_Type) SetNDDRINTST_EPNDDINTST23(value uint32) {
	volatile.StoreUint32(&o.NDDRINTST.Reg, volatile.LoadUint32(&o.NDDRINTST.Reg)&^(0x800000)|value<<23)
}
func (o *USB_Type) GetNDDRINTST_EPNDDINTST23() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTST.Reg) & 0x800000) >> 23
}
func (o *USB_Type) SetNDDRINTST_EPNDDINTST24(value uint32) {
	volatile.StoreUint32(&o.NDDRINTST.Reg, volatile.LoadUint32(&o.NDDRINTST.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_Type) GetNDDRINTST_EPNDDINTST24() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTST.Reg) & 0x1000000) >> 24
}
func (o *USB_Type) SetNDDRINTST_EPNDDINTST25(value uint32) {
	volatile.StoreUint32(&o.NDDRINTST.Reg, volatile.LoadUint32(&o.NDDRINTST.Reg)&^(0x2000000)|value<<25)
}
func (o *USB_Type) GetNDDRINTST_EPNDDINTST25() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTST.Reg) & 0x2000000) >> 25
}
func (o *USB_Type) SetNDDRINTST_EPNDDINTST26(value uint32) {
	volatile.StoreUint32(&o.NDDRINTST.Reg, volatile.LoadUint32(&o.NDDRINTST.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_Type) GetNDDRINTST_EPNDDINTST26() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTST.Reg) & 0x4000000) >> 26
}
func (o *USB_Type) SetNDDRINTST_EPNDDINTST27(value uint32) {
	volatile.StoreUint32(&o.NDDRINTST.Reg, volatile.LoadUint32(&o.NDDRINTST.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_Type) GetNDDRINTST_EPNDDINTST27() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTST.Reg) & 0x8000000) >> 27
}
func (o *USB_Type) SetNDDRINTST_EPNDDINTST28(value uint32) {
	volatile.StoreUint32(&o.NDDRINTST.Reg, volatile.LoadUint32(&o.NDDRINTST.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_Type) GetNDDRINTST_EPNDDINTST28() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTST.Reg) & 0x10000000) >> 28
}
func (o *USB_Type) SetNDDRINTST_EPNDDINTST29(value uint32) {
	volatile.StoreUint32(&o.NDDRINTST.Reg, volatile.LoadUint32(&o.NDDRINTST.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_Type) GetNDDRINTST_EPNDDINTST29() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTST.Reg) & 0x20000000) >> 29
}
func (o *USB_Type) SetNDDRINTST_EPNDDINTST30(value uint32) {
	volatile.StoreUint32(&o.NDDRINTST.Reg, volatile.LoadUint32(&o.NDDRINTST.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_Type) GetNDDRINTST_EPNDDINTST30() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTST.Reg) & 0x40000000) >> 30
}
func (o *USB_Type) SetNDDRINTST_EPNDDINTST31(value uint32) {
	volatile.StoreUint32(&o.NDDRINTST.Reg, volatile.LoadUint32(&o.NDDRINTST.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_Type) GetNDDRINTST_EPNDDINTST31() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTST.Reg) & 0x80000000) >> 31
}

// USB.NDDRINTCLR: USB New DD Request Interrupt Clear
func (o *USB_Type) SetNDDRINTCLR_EPNDDINTCLR0(value uint32) {
	volatile.StoreUint32(&o.NDDRINTCLR.Reg, volatile.LoadUint32(&o.NDDRINTCLR.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetNDDRINTCLR_EPNDDINTCLR0() uint32 {
	return volatile.LoadUint32(&o.NDDRINTCLR.Reg) & 0x1
}
func (o *USB_Type) SetNDDRINTCLR_EPNDDINTCLR1(value uint32) {
	volatile.StoreUint32(&o.NDDRINTCLR.Reg, volatile.LoadUint32(&o.NDDRINTCLR.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetNDDRINTCLR_EPNDDINTCLR1() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTCLR.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetNDDRINTCLR_EPNDDINTCLR2(value uint32) {
	volatile.StoreUint32(&o.NDDRINTCLR.Reg, volatile.LoadUint32(&o.NDDRINTCLR.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetNDDRINTCLR_EPNDDINTCLR2() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTCLR.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetNDDRINTCLR_EPNDDINTCLR3(value uint32) {
	volatile.StoreUint32(&o.NDDRINTCLR.Reg, volatile.LoadUint32(&o.NDDRINTCLR.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetNDDRINTCLR_EPNDDINTCLR3() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTCLR.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetNDDRINTCLR_EPNDDINTCLR4(value uint32) {
	volatile.StoreUint32(&o.NDDRINTCLR.Reg, volatile.LoadUint32(&o.NDDRINTCLR.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetNDDRINTCLR_EPNDDINTCLR4() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTCLR.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetNDDRINTCLR_EPNDDINTCLR5(value uint32) {
	volatile.StoreUint32(&o.NDDRINTCLR.Reg, volatile.LoadUint32(&o.NDDRINTCLR.Reg)&^(0x20)|value<<5)
}
func (o *USB_Type) GetNDDRINTCLR_EPNDDINTCLR5() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTCLR.Reg) & 0x20) >> 5
}
func (o *USB_Type) SetNDDRINTCLR_EPNDDINTCLR6(value uint32) {
	volatile.StoreUint32(&o.NDDRINTCLR.Reg, volatile.LoadUint32(&o.NDDRINTCLR.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetNDDRINTCLR_EPNDDINTCLR6() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTCLR.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetNDDRINTCLR_EPNDDINTCLR7(value uint32) {
	volatile.StoreUint32(&o.NDDRINTCLR.Reg, volatile.LoadUint32(&o.NDDRINTCLR.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetNDDRINTCLR_EPNDDINTCLR7() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTCLR.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetNDDRINTCLR_EPNDDINTCLR8(value uint32) {
	volatile.StoreUint32(&o.NDDRINTCLR.Reg, volatile.LoadUint32(&o.NDDRINTCLR.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetNDDRINTCLR_EPNDDINTCLR8() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTCLR.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetNDDRINTCLR_EPNDDINTCLR9(value uint32) {
	volatile.StoreUint32(&o.NDDRINTCLR.Reg, volatile.LoadUint32(&o.NDDRINTCLR.Reg)&^(0x200)|value<<9)
}
func (o *USB_Type) GetNDDRINTCLR_EPNDDINTCLR9() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTCLR.Reg) & 0x200) >> 9
}
func (o *USB_Type) SetNDDRINTCLR_EPNDDINTCLR10(value uint32) {
	volatile.StoreUint32(&o.NDDRINTCLR.Reg, volatile.LoadUint32(&o.NDDRINTCLR.Reg)&^(0x400)|value<<10)
}
func (o *USB_Type) GetNDDRINTCLR_EPNDDINTCLR10() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTCLR.Reg) & 0x400) >> 10
}
func (o *USB_Type) SetNDDRINTCLR_EPNDDINTCLR11(value uint32) {
	volatile.StoreUint32(&o.NDDRINTCLR.Reg, volatile.LoadUint32(&o.NDDRINTCLR.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetNDDRINTCLR_EPNDDINTCLR11() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTCLR.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetNDDRINTCLR_EPNDDINTCLR12(value uint32) {
	volatile.StoreUint32(&o.NDDRINTCLR.Reg, volatile.LoadUint32(&o.NDDRINTCLR.Reg)&^(0x1000)|value<<12)
}
func (o *USB_Type) GetNDDRINTCLR_EPNDDINTCLR12() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTCLR.Reg) & 0x1000) >> 12
}
func (o *USB_Type) SetNDDRINTCLR_EPNDDINTCLR13(value uint32) {
	volatile.StoreUint32(&o.NDDRINTCLR.Reg, volatile.LoadUint32(&o.NDDRINTCLR.Reg)&^(0x2000)|value<<13)
}
func (o *USB_Type) GetNDDRINTCLR_EPNDDINTCLR13() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTCLR.Reg) & 0x2000) >> 13
}
func (o *USB_Type) SetNDDRINTCLR_EPNDDINTCLR14(value uint32) {
	volatile.StoreUint32(&o.NDDRINTCLR.Reg, volatile.LoadUint32(&o.NDDRINTCLR.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetNDDRINTCLR_EPNDDINTCLR14() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTCLR.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetNDDRINTCLR_EPNDDINTCLR15(value uint32) {
	volatile.StoreUint32(&o.NDDRINTCLR.Reg, volatile.LoadUint32(&o.NDDRINTCLR.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetNDDRINTCLR_EPNDDINTCLR15() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTCLR.Reg) & 0x8000) >> 15
}
func (o *USB_Type) SetNDDRINTCLR_EPNDDINTCLR16(value uint32) {
	volatile.StoreUint32(&o.NDDRINTCLR.Reg, volatile.LoadUint32(&o.NDDRINTCLR.Reg)&^(0x10000)|value<<16)
}
func (o *USB_Type) GetNDDRINTCLR_EPNDDINTCLR16() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTCLR.Reg) & 0x10000) >> 16
}
func (o *USB_Type) SetNDDRINTCLR_EPNDDINTCLR17(value uint32) {
	volatile.StoreUint32(&o.NDDRINTCLR.Reg, volatile.LoadUint32(&o.NDDRINTCLR.Reg)&^(0x20000)|value<<17)
}
func (o *USB_Type) GetNDDRINTCLR_EPNDDINTCLR17() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTCLR.Reg) & 0x20000) >> 17
}
func (o *USB_Type) SetNDDRINTCLR_EPNDDINTCLR18(value uint32) {
	volatile.StoreUint32(&o.NDDRINTCLR.Reg, volatile.LoadUint32(&o.NDDRINTCLR.Reg)&^(0x40000)|value<<18)
}
func (o *USB_Type) GetNDDRINTCLR_EPNDDINTCLR18() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTCLR.Reg) & 0x40000) >> 18
}
func (o *USB_Type) SetNDDRINTCLR_EPNDDINTCLR19(value uint32) {
	volatile.StoreUint32(&o.NDDRINTCLR.Reg, volatile.LoadUint32(&o.NDDRINTCLR.Reg)&^(0x80000)|value<<19)
}
func (o *USB_Type) GetNDDRINTCLR_EPNDDINTCLR19() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTCLR.Reg) & 0x80000) >> 19
}
func (o *USB_Type) SetNDDRINTCLR_EPNDDINTCLR20(value uint32) {
	volatile.StoreUint32(&o.NDDRINTCLR.Reg, volatile.LoadUint32(&o.NDDRINTCLR.Reg)&^(0x100000)|value<<20)
}
func (o *USB_Type) GetNDDRINTCLR_EPNDDINTCLR20() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTCLR.Reg) & 0x100000) >> 20
}
func (o *USB_Type) SetNDDRINTCLR_EPNDDINTCLR21(value uint32) {
	volatile.StoreUint32(&o.NDDRINTCLR.Reg, volatile.LoadUint32(&o.NDDRINTCLR.Reg)&^(0x200000)|value<<21)
}
func (o *USB_Type) GetNDDRINTCLR_EPNDDINTCLR21() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTCLR.Reg) & 0x200000) >> 21
}
func (o *USB_Type) SetNDDRINTCLR_EPNDDINTCLR22(value uint32) {
	volatile.StoreUint32(&o.NDDRINTCLR.Reg, volatile.LoadUint32(&o.NDDRINTCLR.Reg)&^(0x400000)|value<<22)
}
func (o *USB_Type) GetNDDRINTCLR_EPNDDINTCLR22() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTCLR.Reg) & 0x400000) >> 22
}
func (o *USB_Type) SetNDDRINTCLR_EPNDDINTCLR23(value uint32) {
	volatile.StoreUint32(&o.NDDRINTCLR.Reg, volatile.LoadUint32(&o.NDDRINTCLR.Reg)&^(0x800000)|value<<23)
}
func (o *USB_Type) GetNDDRINTCLR_EPNDDINTCLR23() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTCLR.Reg) & 0x800000) >> 23
}
func (o *USB_Type) SetNDDRINTCLR_EPNDDINTCLR24(value uint32) {
	volatile.StoreUint32(&o.NDDRINTCLR.Reg, volatile.LoadUint32(&o.NDDRINTCLR.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_Type) GetNDDRINTCLR_EPNDDINTCLR24() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTCLR.Reg) & 0x1000000) >> 24
}
func (o *USB_Type) SetNDDRINTCLR_EPNDDINTCLR25(value uint32) {
	volatile.StoreUint32(&o.NDDRINTCLR.Reg, volatile.LoadUint32(&o.NDDRINTCLR.Reg)&^(0x2000000)|value<<25)
}
func (o *USB_Type) GetNDDRINTCLR_EPNDDINTCLR25() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTCLR.Reg) & 0x2000000) >> 25
}
func (o *USB_Type) SetNDDRINTCLR_EPNDDINTCLR26(value uint32) {
	volatile.StoreUint32(&o.NDDRINTCLR.Reg, volatile.LoadUint32(&o.NDDRINTCLR.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_Type) GetNDDRINTCLR_EPNDDINTCLR26() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTCLR.Reg) & 0x4000000) >> 26
}
func (o *USB_Type) SetNDDRINTCLR_EPNDDINTCLR27(value uint32) {
	volatile.StoreUint32(&o.NDDRINTCLR.Reg, volatile.LoadUint32(&o.NDDRINTCLR.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_Type) GetNDDRINTCLR_EPNDDINTCLR27() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTCLR.Reg) & 0x8000000) >> 27
}
func (o *USB_Type) SetNDDRINTCLR_EPNDDINTCLR28(value uint32) {
	volatile.StoreUint32(&o.NDDRINTCLR.Reg, volatile.LoadUint32(&o.NDDRINTCLR.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_Type) GetNDDRINTCLR_EPNDDINTCLR28() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTCLR.Reg) & 0x10000000) >> 28
}
func (o *USB_Type) SetNDDRINTCLR_EPNDDINTCLR29(value uint32) {
	volatile.StoreUint32(&o.NDDRINTCLR.Reg, volatile.LoadUint32(&o.NDDRINTCLR.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_Type) GetNDDRINTCLR_EPNDDINTCLR29() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTCLR.Reg) & 0x20000000) >> 29
}
func (o *USB_Type) SetNDDRINTCLR_EPNDDINTCLR30(value uint32) {
	volatile.StoreUint32(&o.NDDRINTCLR.Reg, volatile.LoadUint32(&o.NDDRINTCLR.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_Type) GetNDDRINTCLR_EPNDDINTCLR30() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTCLR.Reg) & 0x40000000) >> 30
}
func (o *USB_Type) SetNDDRINTCLR_EPNDDINTCLR31(value uint32) {
	volatile.StoreUint32(&o.NDDRINTCLR.Reg, volatile.LoadUint32(&o.NDDRINTCLR.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_Type) GetNDDRINTCLR_EPNDDINTCLR31() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTCLR.Reg) & 0x80000000) >> 31
}

// USB.NDDRINTSET: USB New DD Request Interrupt Set
func (o *USB_Type) SetNDDRINTSET_EPNDDINTSET0(value uint32) {
	volatile.StoreUint32(&o.NDDRINTSET.Reg, volatile.LoadUint32(&o.NDDRINTSET.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetNDDRINTSET_EPNDDINTSET0() uint32 {
	return volatile.LoadUint32(&o.NDDRINTSET.Reg) & 0x1
}
func (o *USB_Type) SetNDDRINTSET_EPNDDINTSET1(value uint32) {
	volatile.StoreUint32(&o.NDDRINTSET.Reg, volatile.LoadUint32(&o.NDDRINTSET.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetNDDRINTSET_EPNDDINTSET1() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTSET.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetNDDRINTSET_EPNDDINTSET2(value uint32) {
	volatile.StoreUint32(&o.NDDRINTSET.Reg, volatile.LoadUint32(&o.NDDRINTSET.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetNDDRINTSET_EPNDDINTSET2() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTSET.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetNDDRINTSET_EPNDDINTSET3(value uint32) {
	volatile.StoreUint32(&o.NDDRINTSET.Reg, volatile.LoadUint32(&o.NDDRINTSET.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetNDDRINTSET_EPNDDINTSET3() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTSET.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetNDDRINTSET_EPNDDINTSET4(value uint32) {
	volatile.StoreUint32(&o.NDDRINTSET.Reg, volatile.LoadUint32(&o.NDDRINTSET.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetNDDRINTSET_EPNDDINTSET4() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTSET.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetNDDRINTSET_EPNDDINTSET5(value uint32) {
	volatile.StoreUint32(&o.NDDRINTSET.Reg, volatile.LoadUint32(&o.NDDRINTSET.Reg)&^(0x20)|value<<5)
}
func (o *USB_Type) GetNDDRINTSET_EPNDDINTSET5() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTSET.Reg) & 0x20) >> 5
}
func (o *USB_Type) SetNDDRINTSET_EPNDDINTSET6(value uint32) {
	volatile.StoreUint32(&o.NDDRINTSET.Reg, volatile.LoadUint32(&o.NDDRINTSET.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetNDDRINTSET_EPNDDINTSET6() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTSET.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetNDDRINTSET_EPNDDINTSET7(value uint32) {
	volatile.StoreUint32(&o.NDDRINTSET.Reg, volatile.LoadUint32(&o.NDDRINTSET.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetNDDRINTSET_EPNDDINTSET7() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTSET.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetNDDRINTSET_EPNDDINTSET8(value uint32) {
	volatile.StoreUint32(&o.NDDRINTSET.Reg, volatile.LoadUint32(&o.NDDRINTSET.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetNDDRINTSET_EPNDDINTSET8() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTSET.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetNDDRINTSET_EPNDDINTSET9(value uint32) {
	volatile.StoreUint32(&o.NDDRINTSET.Reg, volatile.LoadUint32(&o.NDDRINTSET.Reg)&^(0x200)|value<<9)
}
func (o *USB_Type) GetNDDRINTSET_EPNDDINTSET9() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTSET.Reg) & 0x200) >> 9
}
func (o *USB_Type) SetNDDRINTSET_EPNDDINTSET10(value uint32) {
	volatile.StoreUint32(&o.NDDRINTSET.Reg, volatile.LoadUint32(&o.NDDRINTSET.Reg)&^(0x400)|value<<10)
}
func (o *USB_Type) GetNDDRINTSET_EPNDDINTSET10() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTSET.Reg) & 0x400) >> 10
}
func (o *USB_Type) SetNDDRINTSET_EPNDDINTSET11(value uint32) {
	volatile.StoreUint32(&o.NDDRINTSET.Reg, volatile.LoadUint32(&o.NDDRINTSET.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetNDDRINTSET_EPNDDINTSET11() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTSET.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetNDDRINTSET_EPNDDINTSET12(value uint32) {
	volatile.StoreUint32(&o.NDDRINTSET.Reg, volatile.LoadUint32(&o.NDDRINTSET.Reg)&^(0x1000)|value<<12)
}
func (o *USB_Type) GetNDDRINTSET_EPNDDINTSET12() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTSET.Reg) & 0x1000) >> 12
}
func (o *USB_Type) SetNDDRINTSET_EPNDDINTSET13(value uint32) {
	volatile.StoreUint32(&o.NDDRINTSET.Reg, volatile.LoadUint32(&o.NDDRINTSET.Reg)&^(0x2000)|value<<13)
}
func (o *USB_Type) GetNDDRINTSET_EPNDDINTSET13() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTSET.Reg) & 0x2000) >> 13
}
func (o *USB_Type) SetNDDRINTSET_EPNDDINTSET14(value uint32) {
	volatile.StoreUint32(&o.NDDRINTSET.Reg, volatile.LoadUint32(&o.NDDRINTSET.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetNDDRINTSET_EPNDDINTSET14() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTSET.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetNDDRINTSET_EPNDDINTSET15(value uint32) {
	volatile.StoreUint32(&o.NDDRINTSET.Reg, volatile.LoadUint32(&o.NDDRINTSET.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetNDDRINTSET_EPNDDINTSET15() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTSET.Reg) & 0x8000) >> 15
}
func (o *USB_Type) SetNDDRINTSET_EPNDDINTSET16(value uint32) {
	volatile.StoreUint32(&o.NDDRINTSET.Reg, volatile.LoadUint32(&o.NDDRINTSET.Reg)&^(0x10000)|value<<16)
}
func (o *USB_Type) GetNDDRINTSET_EPNDDINTSET16() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTSET.Reg) & 0x10000) >> 16
}
func (o *USB_Type) SetNDDRINTSET_EPNDDINTSET17(value uint32) {
	volatile.StoreUint32(&o.NDDRINTSET.Reg, volatile.LoadUint32(&o.NDDRINTSET.Reg)&^(0x20000)|value<<17)
}
func (o *USB_Type) GetNDDRINTSET_EPNDDINTSET17() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTSET.Reg) & 0x20000) >> 17
}
func (o *USB_Type) SetNDDRINTSET_EPNDDINTSET18(value uint32) {
	volatile.StoreUint32(&o.NDDRINTSET.Reg, volatile.LoadUint32(&o.NDDRINTSET.Reg)&^(0x40000)|value<<18)
}
func (o *USB_Type) GetNDDRINTSET_EPNDDINTSET18() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTSET.Reg) & 0x40000) >> 18
}
func (o *USB_Type) SetNDDRINTSET_EPNDDINTSET19(value uint32) {
	volatile.StoreUint32(&o.NDDRINTSET.Reg, volatile.LoadUint32(&o.NDDRINTSET.Reg)&^(0x80000)|value<<19)
}
func (o *USB_Type) GetNDDRINTSET_EPNDDINTSET19() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTSET.Reg) & 0x80000) >> 19
}
func (o *USB_Type) SetNDDRINTSET_EPNDDINTSET20(value uint32) {
	volatile.StoreUint32(&o.NDDRINTSET.Reg, volatile.LoadUint32(&o.NDDRINTSET.Reg)&^(0x100000)|value<<20)
}
func (o *USB_Type) GetNDDRINTSET_EPNDDINTSET20() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTSET.Reg) & 0x100000) >> 20
}
func (o *USB_Type) SetNDDRINTSET_EPNDDINTSET21(value uint32) {
	volatile.StoreUint32(&o.NDDRINTSET.Reg, volatile.LoadUint32(&o.NDDRINTSET.Reg)&^(0x200000)|value<<21)
}
func (o *USB_Type) GetNDDRINTSET_EPNDDINTSET21() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTSET.Reg) & 0x200000) >> 21
}
func (o *USB_Type) SetNDDRINTSET_EPNDDINTSET22(value uint32) {
	volatile.StoreUint32(&o.NDDRINTSET.Reg, volatile.LoadUint32(&o.NDDRINTSET.Reg)&^(0x400000)|value<<22)
}
func (o *USB_Type) GetNDDRINTSET_EPNDDINTSET22() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTSET.Reg) & 0x400000) >> 22
}
func (o *USB_Type) SetNDDRINTSET_EPNDDINTSET23(value uint32) {
	volatile.StoreUint32(&o.NDDRINTSET.Reg, volatile.LoadUint32(&o.NDDRINTSET.Reg)&^(0x800000)|value<<23)
}
func (o *USB_Type) GetNDDRINTSET_EPNDDINTSET23() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTSET.Reg) & 0x800000) >> 23
}
func (o *USB_Type) SetNDDRINTSET_EPNDDINTSET24(value uint32) {
	volatile.StoreUint32(&o.NDDRINTSET.Reg, volatile.LoadUint32(&o.NDDRINTSET.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_Type) GetNDDRINTSET_EPNDDINTSET24() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTSET.Reg) & 0x1000000) >> 24
}
func (o *USB_Type) SetNDDRINTSET_EPNDDINTSET25(value uint32) {
	volatile.StoreUint32(&o.NDDRINTSET.Reg, volatile.LoadUint32(&o.NDDRINTSET.Reg)&^(0x2000000)|value<<25)
}
func (o *USB_Type) GetNDDRINTSET_EPNDDINTSET25() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTSET.Reg) & 0x2000000) >> 25
}
func (o *USB_Type) SetNDDRINTSET_EPNDDINTSET26(value uint32) {
	volatile.StoreUint32(&o.NDDRINTSET.Reg, volatile.LoadUint32(&o.NDDRINTSET.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_Type) GetNDDRINTSET_EPNDDINTSET26() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTSET.Reg) & 0x4000000) >> 26
}
func (o *USB_Type) SetNDDRINTSET_EPNDDINTSET27(value uint32) {
	volatile.StoreUint32(&o.NDDRINTSET.Reg, volatile.LoadUint32(&o.NDDRINTSET.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_Type) GetNDDRINTSET_EPNDDINTSET27() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTSET.Reg) & 0x8000000) >> 27
}
func (o *USB_Type) SetNDDRINTSET_EPNDDINTSET28(value uint32) {
	volatile.StoreUint32(&o.NDDRINTSET.Reg, volatile.LoadUint32(&o.NDDRINTSET.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_Type) GetNDDRINTSET_EPNDDINTSET28() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTSET.Reg) & 0x10000000) >> 28
}
func (o *USB_Type) SetNDDRINTSET_EPNDDINTSET29(value uint32) {
	volatile.StoreUint32(&o.NDDRINTSET.Reg, volatile.LoadUint32(&o.NDDRINTSET.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_Type) GetNDDRINTSET_EPNDDINTSET29() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTSET.Reg) & 0x20000000) >> 29
}
func (o *USB_Type) SetNDDRINTSET_EPNDDINTSET30(value uint32) {
	volatile.StoreUint32(&o.NDDRINTSET.Reg, volatile.LoadUint32(&o.NDDRINTSET.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_Type) GetNDDRINTSET_EPNDDINTSET30() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTSET.Reg) & 0x40000000) >> 30
}
func (o *USB_Type) SetNDDRINTSET_EPNDDINTSET31(value uint32) {
	volatile.StoreUint32(&o.NDDRINTSET.Reg, volatile.LoadUint32(&o.NDDRINTSET.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_Type) GetNDDRINTSET_EPNDDINTSET31() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTSET.Reg) & 0x80000000) >> 31
}

// USB.SYSERRINTST: USB System Error Interrupt Status
func (o *USB_Type) SetSYSERRINTST_EPERRINTST0(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTST.Reg, volatile.LoadUint32(&o.SYSERRINTST.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetSYSERRINTST_EPERRINTST0() uint32 {
	return volatile.LoadUint32(&o.SYSERRINTST.Reg) & 0x1
}
func (o *USB_Type) SetSYSERRINTST_EPERRINTST1(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTST.Reg, volatile.LoadUint32(&o.SYSERRINTST.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetSYSERRINTST_EPERRINTST1() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTST.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetSYSERRINTST_EPERRINTST2(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTST.Reg, volatile.LoadUint32(&o.SYSERRINTST.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetSYSERRINTST_EPERRINTST2() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTST.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetSYSERRINTST_EPERRINTST3(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTST.Reg, volatile.LoadUint32(&o.SYSERRINTST.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetSYSERRINTST_EPERRINTST3() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTST.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetSYSERRINTST_EPERRINTST4(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTST.Reg, volatile.LoadUint32(&o.SYSERRINTST.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetSYSERRINTST_EPERRINTST4() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTST.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetSYSERRINTST_EPERRINTST5(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTST.Reg, volatile.LoadUint32(&o.SYSERRINTST.Reg)&^(0x20)|value<<5)
}
func (o *USB_Type) GetSYSERRINTST_EPERRINTST5() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTST.Reg) & 0x20) >> 5
}
func (o *USB_Type) SetSYSERRINTST_EPERRINTST6(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTST.Reg, volatile.LoadUint32(&o.SYSERRINTST.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetSYSERRINTST_EPERRINTST6() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTST.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetSYSERRINTST_EPERRINTST7(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTST.Reg, volatile.LoadUint32(&o.SYSERRINTST.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetSYSERRINTST_EPERRINTST7() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTST.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetSYSERRINTST_EPERRINTST8(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTST.Reg, volatile.LoadUint32(&o.SYSERRINTST.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetSYSERRINTST_EPERRINTST8() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTST.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetSYSERRINTST_EPERRINTST9(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTST.Reg, volatile.LoadUint32(&o.SYSERRINTST.Reg)&^(0x200)|value<<9)
}
func (o *USB_Type) GetSYSERRINTST_EPERRINTST9() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTST.Reg) & 0x200) >> 9
}
func (o *USB_Type) SetSYSERRINTST_EPERRINTST10(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTST.Reg, volatile.LoadUint32(&o.SYSERRINTST.Reg)&^(0x400)|value<<10)
}
func (o *USB_Type) GetSYSERRINTST_EPERRINTST10() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTST.Reg) & 0x400) >> 10
}
func (o *USB_Type) SetSYSERRINTST_EPERRINTST11(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTST.Reg, volatile.LoadUint32(&o.SYSERRINTST.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetSYSERRINTST_EPERRINTST11() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTST.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetSYSERRINTST_EPERRINTST12(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTST.Reg, volatile.LoadUint32(&o.SYSERRINTST.Reg)&^(0x1000)|value<<12)
}
func (o *USB_Type) GetSYSERRINTST_EPERRINTST12() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTST.Reg) & 0x1000) >> 12
}
func (o *USB_Type) SetSYSERRINTST_EPERRINTST13(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTST.Reg, volatile.LoadUint32(&o.SYSERRINTST.Reg)&^(0x2000)|value<<13)
}
func (o *USB_Type) GetSYSERRINTST_EPERRINTST13() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTST.Reg) & 0x2000) >> 13
}
func (o *USB_Type) SetSYSERRINTST_EPERRINTST14(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTST.Reg, volatile.LoadUint32(&o.SYSERRINTST.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetSYSERRINTST_EPERRINTST14() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTST.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetSYSERRINTST_EPERRINTST15(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTST.Reg, volatile.LoadUint32(&o.SYSERRINTST.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetSYSERRINTST_EPERRINTST15() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTST.Reg) & 0x8000) >> 15
}
func (o *USB_Type) SetSYSERRINTST_EPERRINTST16(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTST.Reg, volatile.LoadUint32(&o.SYSERRINTST.Reg)&^(0x10000)|value<<16)
}
func (o *USB_Type) GetSYSERRINTST_EPERRINTST16() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTST.Reg) & 0x10000) >> 16
}
func (o *USB_Type) SetSYSERRINTST_EPERRINTST17(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTST.Reg, volatile.LoadUint32(&o.SYSERRINTST.Reg)&^(0x20000)|value<<17)
}
func (o *USB_Type) GetSYSERRINTST_EPERRINTST17() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTST.Reg) & 0x20000) >> 17
}
func (o *USB_Type) SetSYSERRINTST_EPERRINTST18(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTST.Reg, volatile.LoadUint32(&o.SYSERRINTST.Reg)&^(0x40000)|value<<18)
}
func (o *USB_Type) GetSYSERRINTST_EPERRINTST18() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTST.Reg) & 0x40000) >> 18
}
func (o *USB_Type) SetSYSERRINTST_EPERRINTST19(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTST.Reg, volatile.LoadUint32(&o.SYSERRINTST.Reg)&^(0x80000)|value<<19)
}
func (o *USB_Type) GetSYSERRINTST_EPERRINTST19() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTST.Reg) & 0x80000) >> 19
}
func (o *USB_Type) SetSYSERRINTST_EPERRINTST20(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTST.Reg, volatile.LoadUint32(&o.SYSERRINTST.Reg)&^(0x100000)|value<<20)
}
func (o *USB_Type) GetSYSERRINTST_EPERRINTST20() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTST.Reg) & 0x100000) >> 20
}
func (o *USB_Type) SetSYSERRINTST_EPERRINTST21(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTST.Reg, volatile.LoadUint32(&o.SYSERRINTST.Reg)&^(0x200000)|value<<21)
}
func (o *USB_Type) GetSYSERRINTST_EPERRINTST21() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTST.Reg) & 0x200000) >> 21
}
func (o *USB_Type) SetSYSERRINTST_EPERRINTST22(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTST.Reg, volatile.LoadUint32(&o.SYSERRINTST.Reg)&^(0x400000)|value<<22)
}
func (o *USB_Type) GetSYSERRINTST_EPERRINTST22() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTST.Reg) & 0x400000) >> 22
}
func (o *USB_Type) SetSYSERRINTST_EPERRINTST23(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTST.Reg, volatile.LoadUint32(&o.SYSERRINTST.Reg)&^(0x800000)|value<<23)
}
func (o *USB_Type) GetSYSERRINTST_EPERRINTST23() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTST.Reg) & 0x800000) >> 23
}
func (o *USB_Type) SetSYSERRINTST_EPERRINTST24(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTST.Reg, volatile.LoadUint32(&o.SYSERRINTST.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_Type) GetSYSERRINTST_EPERRINTST24() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTST.Reg) & 0x1000000) >> 24
}
func (o *USB_Type) SetSYSERRINTST_EPERRINTST25(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTST.Reg, volatile.LoadUint32(&o.SYSERRINTST.Reg)&^(0x2000000)|value<<25)
}
func (o *USB_Type) GetSYSERRINTST_EPERRINTST25() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTST.Reg) & 0x2000000) >> 25
}
func (o *USB_Type) SetSYSERRINTST_EPERRINTST26(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTST.Reg, volatile.LoadUint32(&o.SYSERRINTST.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_Type) GetSYSERRINTST_EPERRINTST26() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTST.Reg) & 0x4000000) >> 26
}
func (o *USB_Type) SetSYSERRINTST_EPERRINTST27(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTST.Reg, volatile.LoadUint32(&o.SYSERRINTST.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_Type) GetSYSERRINTST_EPERRINTST27() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTST.Reg) & 0x8000000) >> 27
}
func (o *USB_Type) SetSYSERRINTST_EPERRINTST28(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTST.Reg, volatile.LoadUint32(&o.SYSERRINTST.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_Type) GetSYSERRINTST_EPERRINTST28() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTST.Reg) & 0x10000000) >> 28
}
func (o *USB_Type) SetSYSERRINTST_EPERRINTST29(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTST.Reg, volatile.LoadUint32(&o.SYSERRINTST.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_Type) GetSYSERRINTST_EPERRINTST29() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTST.Reg) & 0x20000000) >> 29
}
func (o *USB_Type) SetSYSERRINTST_EPERRINTST30(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTST.Reg, volatile.LoadUint32(&o.SYSERRINTST.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_Type) GetSYSERRINTST_EPERRINTST30() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTST.Reg) & 0x40000000) >> 30
}
func (o *USB_Type) SetSYSERRINTST_EPERRINTST31(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTST.Reg, volatile.LoadUint32(&o.SYSERRINTST.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_Type) GetSYSERRINTST_EPERRINTST31() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTST.Reg) & 0x80000000) >> 31
}

// USB.SYSERRINTCLR: USB System Error Interrupt Clear
func (o *USB_Type) SetSYSERRINTCLR_EPERRINTCLR0(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTCLR.Reg, volatile.LoadUint32(&o.SYSERRINTCLR.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetSYSERRINTCLR_EPERRINTCLR0() uint32 {
	return volatile.LoadUint32(&o.SYSERRINTCLR.Reg) & 0x1
}
func (o *USB_Type) SetSYSERRINTCLR_EPERRINTCLR1(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTCLR.Reg, volatile.LoadUint32(&o.SYSERRINTCLR.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetSYSERRINTCLR_EPERRINTCLR1() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTCLR.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetSYSERRINTCLR_EPERRINTCLR2(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTCLR.Reg, volatile.LoadUint32(&o.SYSERRINTCLR.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetSYSERRINTCLR_EPERRINTCLR2() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTCLR.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetSYSERRINTCLR_EPERRINTCLR3(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTCLR.Reg, volatile.LoadUint32(&o.SYSERRINTCLR.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetSYSERRINTCLR_EPERRINTCLR3() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTCLR.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetSYSERRINTCLR_EPERRINTCLR4(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTCLR.Reg, volatile.LoadUint32(&o.SYSERRINTCLR.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetSYSERRINTCLR_EPERRINTCLR4() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTCLR.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetSYSERRINTCLR_EPERRINTCLR5(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTCLR.Reg, volatile.LoadUint32(&o.SYSERRINTCLR.Reg)&^(0x20)|value<<5)
}
func (o *USB_Type) GetSYSERRINTCLR_EPERRINTCLR5() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTCLR.Reg) & 0x20) >> 5
}
func (o *USB_Type) SetSYSERRINTCLR_EPERRINTCLR6(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTCLR.Reg, volatile.LoadUint32(&o.SYSERRINTCLR.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetSYSERRINTCLR_EPERRINTCLR6() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTCLR.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetSYSERRINTCLR_EPERRINTCLR7(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTCLR.Reg, volatile.LoadUint32(&o.SYSERRINTCLR.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetSYSERRINTCLR_EPERRINTCLR7() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTCLR.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetSYSERRINTCLR_EPERRINTCLR8(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTCLR.Reg, volatile.LoadUint32(&o.SYSERRINTCLR.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetSYSERRINTCLR_EPERRINTCLR8() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTCLR.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetSYSERRINTCLR_EPERRINTCLR9(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTCLR.Reg, volatile.LoadUint32(&o.SYSERRINTCLR.Reg)&^(0x200)|value<<9)
}
func (o *USB_Type) GetSYSERRINTCLR_EPERRINTCLR9() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTCLR.Reg) & 0x200) >> 9
}
func (o *USB_Type) SetSYSERRINTCLR_EPERRINTCLR10(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTCLR.Reg, volatile.LoadUint32(&o.SYSERRINTCLR.Reg)&^(0x400)|value<<10)
}
func (o *USB_Type) GetSYSERRINTCLR_EPERRINTCLR10() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTCLR.Reg) & 0x400) >> 10
}
func (o *USB_Type) SetSYSERRINTCLR_EPERRINTCLR11(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTCLR.Reg, volatile.LoadUint32(&o.SYSERRINTCLR.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetSYSERRINTCLR_EPERRINTCLR11() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTCLR.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetSYSERRINTCLR_EPERRINTCLR12(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTCLR.Reg, volatile.LoadUint32(&o.SYSERRINTCLR.Reg)&^(0x1000)|value<<12)
}
func (o *USB_Type) GetSYSERRINTCLR_EPERRINTCLR12() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTCLR.Reg) & 0x1000) >> 12
}
func (o *USB_Type) SetSYSERRINTCLR_EPERRINTCLR13(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTCLR.Reg, volatile.LoadUint32(&o.SYSERRINTCLR.Reg)&^(0x2000)|value<<13)
}
func (o *USB_Type) GetSYSERRINTCLR_EPERRINTCLR13() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTCLR.Reg) & 0x2000) >> 13
}
func (o *USB_Type) SetSYSERRINTCLR_EPERRINTCLR14(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTCLR.Reg, volatile.LoadUint32(&o.SYSERRINTCLR.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetSYSERRINTCLR_EPERRINTCLR14() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTCLR.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetSYSERRINTCLR_EPERRINTCLR15(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTCLR.Reg, volatile.LoadUint32(&o.SYSERRINTCLR.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetSYSERRINTCLR_EPERRINTCLR15() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTCLR.Reg) & 0x8000) >> 15
}
func (o *USB_Type) SetSYSERRINTCLR_EPERRINTCLR16(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTCLR.Reg, volatile.LoadUint32(&o.SYSERRINTCLR.Reg)&^(0x10000)|value<<16)
}
func (o *USB_Type) GetSYSERRINTCLR_EPERRINTCLR16() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTCLR.Reg) & 0x10000) >> 16
}
func (o *USB_Type) SetSYSERRINTCLR_EPERRINTCLR17(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTCLR.Reg, volatile.LoadUint32(&o.SYSERRINTCLR.Reg)&^(0x20000)|value<<17)
}
func (o *USB_Type) GetSYSERRINTCLR_EPERRINTCLR17() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTCLR.Reg) & 0x20000) >> 17
}
func (o *USB_Type) SetSYSERRINTCLR_EPERRINTCLR18(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTCLR.Reg, volatile.LoadUint32(&o.SYSERRINTCLR.Reg)&^(0x40000)|value<<18)
}
func (o *USB_Type) GetSYSERRINTCLR_EPERRINTCLR18() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTCLR.Reg) & 0x40000) >> 18
}
func (o *USB_Type) SetSYSERRINTCLR_EPERRINTCLR19(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTCLR.Reg, volatile.LoadUint32(&o.SYSERRINTCLR.Reg)&^(0x80000)|value<<19)
}
func (o *USB_Type) GetSYSERRINTCLR_EPERRINTCLR19() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTCLR.Reg) & 0x80000) >> 19
}
func (o *USB_Type) SetSYSERRINTCLR_EPERRINTCLR20(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTCLR.Reg, volatile.LoadUint32(&o.SYSERRINTCLR.Reg)&^(0x100000)|value<<20)
}
func (o *USB_Type) GetSYSERRINTCLR_EPERRINTCLR20() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTCLR.Reg) & 0x100000) >> 20
}
func (o *USB_Type) SetSYSERRINTCLR_EPERRINTCLR21(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTCLR.Reg, volatile.LoadUint32(&o.SYSERRINTCLR.Reg)&^(0x200000)|value<<21)
}
func (o *USB_Type) GetSYSERRINTCLR_EPERRINTCLR21() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTCLR.Reg) & 0x200000) >> 21
}
func (o *USB_Type) SetSYSERRINTCLR_EPERRINTCLR22(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTCLR.Reg, volatile.LoadUint32(&o.SYSERRINTCLR.Reg)&^(0x400000)|value<<22)
}
func (o *USB_Type) GetSYSERRINTCLR_EPERRINTCLR22() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTCLR.Reg) & 0x400000) >> 22
}
func (o *USB_Type) SetSYSERRINTCLR_EPERRINTCLR23(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTCLR.Reg, volatile.LoadUint32(&o.SYSERRINTCLR.Reg)&^(0x800000)|value<<23)
}
func (o *USB_Type) GetSYSERRINTCLR_EPERRINTCLR23() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTCLR.Reg) & 0x800000) >> 23
}
func (o *USB_Type) SetSYSERRINTCLR_EPERRINTCLR24(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTCLR.Reg, volatile.LoadUint32(&o.SYSERRINTCLR.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_Type) GetSYSERRINTCLR_EPERRINTCLR24() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTCLR.Reg) & 0x1000000) >> 24
}
func (o *USB_Type) SetSYSERRINTCLR_EPERRINTCLR25(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTCLR.Reg, volatile.LoadUint32(&o.SYSERRINTCLR.Reg)&^(0x2000000)|value<<25)
}
func (o *USB_Type) GetSYSERRINTCLR_EPERRINTCLR25() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTCLR.Reg) & 0x2000000) >> 25
}
func (o *USB_Type) SetSYSERRINTCLR_EPERRINTCLR26(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTCLR.Reg, volatile.LoadUint32(&o.SYSERRINTCLR.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_Type) GetSYSERRINTCLR_EPERRINTCLR26() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTCLR.Reg) & 0x4000000) >> 26
}
func (o *USB_Type) SetSYSERRINTCLR_EPERRINTCLR27(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTCLR.Reg, volatile.LoadUint32(&o.SYSERRINTCLR.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_Type) GetSYSERRINTCLR_EPERRINTCLR27() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTCLR.Reg) & 0x8000000) >> 27
}
func (o *USB_Type) SetSYSERRINTCLR_EPERRINTCLR28(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTCLR.Reg, volatile.LoadUint32(&o.SYSERRINTCLR.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_Type) GetSYSERRINTCLR_EPERRINTCLR28() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTCLR.Reg) & 0x10000000) >> 28
}
func (o *USB_Type) SetSYSERRINTCLR_EPERRINTCLR29(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTCLR.Reg, volatile.LoadUint32(&o.SYSERRINTCLR.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_Type) GetSYSERRINTCLR_EPERRINTCLR29() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTCLR.Reg) & 0x20000000) >> 29
}
func (o *USB_Type) SetSYSERRINTCLR_EPERRINTCLR30(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTCLR.Reg, volatile.LoadUint32(&o.SYSERRINTCLR.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_Type) GetSYSERRINTCLR_EPERRINTCLR30() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTCLR.Reg) & 0x40000000) >> 30
}
func (o *USB_Type) SetSYSERRINTCLR_EPERRINTCLR31(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTCLR.Reg, volatile.LoadUint32(&o.SYSERRINTCLR.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_Type) GetSYSERRINTCLR_EPERRINTCLR31() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTCLR.Reg) & 0x80000000) >> 31
}

// USB.SYSERRINTSET: USB System Error Interrupt Set
func (o *USB_Type) SetSYSERRINTSET_EPERRINTSET0(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTSET.Reg, volatile.LoadUint32(&o.SYSERRINTSET.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetSYSERRINTSET_EPERRINTSET0() uint32 {
	return volatile.LoadUint32(&o.SYSERRINTSET.Reg) & 0x1
}
func (o *USB_Type) SetSYSERRINTSET_EPERRINTSET1(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTSET.Reg, volatile.LoadUint32(&o.SYSERRINTSET.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetSYSERRINTSET_EPERRINTSET1() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTSET.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetSYSERRINTSET_EPERRINTSET2(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTSET.Reg, volatile.LoadUint32(&o.SYSERRINTSET.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetSYSERRINTSET_EPERRINTSET2() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTSET.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetSYSERRINTSET_EPERRINTSET3(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTSET.Reg, volatile.LoadUint32(&o.SYSERRINTSET.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetSYSERRINTSET_EPERRINTSET3() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTSET.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetSYSERRINTSET_EPERRINTSET4(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTSET.Reg, volatile.LoadUint32(&o.SYSERRINTSET.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetSYSERRINTSET_EPERRINTSET4() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTSET.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetSYSERRINTSET_EPERRINTSET5(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTSET.Reg, volatile.LoadUint32(&o.SYSERRINTSET.Reg)&^(0x20)|value<<5)
}
func (o *USB_Type) GetSYSERRINTSET_EPERRINTSET5() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTSET.Reg) & 0x20) >> 5
}
func (o *USB_Type) SetSYSERRINTSET_EPERRINTSET6(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTSET.Reg, volatile.LoadUint32(&o.SYSERRINTSET.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetSYSERRINTSET_EPERRINTSET6() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTSET.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetSYSERRINTSET_EPERRINTSET7(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTSET.Reg, volatile.LoadUint32(&o.SYSERRINTSET.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetSYSERRINTSET_EPERRINTSET7() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTSET.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetSYSERRINTSET_EPERRINTSET8(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTSET.Reg, volatile.LoadUint32(&o.SYSERRINTSET.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetSYSERRINTSET_EPERRINTSET8() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTSET.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetSYSERRINTSET_EPERRINTSET9(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTSET.Reg, volatile.LoadUint32(&o.SYSERRINTSET.Reg)&^(0x200)|value<<9)
}
func (o *USB_Type) GetSYSERRINTSET_EPERRINTSET9() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTSET.Reg) & 0x200) >> 9
}
func (o *USB_Type) SetSYSERRINTSET_EPERRINTSET10(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTSET.Reg, volatile.LoadUint32(&o.SYSERRINTSET.Reg)&^(0x400)|value<<10)
}
func (o *USB_Type) GetSYSERRINTSET_EPERRINTSET10() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTSET.Reg) & 0x400) >> 10
}
func (o *USB_Type) SetSYSERRINTSET_EPERRINTSET11(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTSET.Reg, volatile.LoadUint32(&o.SYSERRINTSET.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetSYSERRINTSET_EPERRINTSET11() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTSET.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetSYSERRINTSET_EPERRINTSET12(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTSET.Reg, volatile.LoadUint32(&o.SYSERRINTSET.Reg)&^(0x1000)|value<<12)
}
func (o *USB_Type) GetSYSERRINTSET_EPERRINTSET12() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTSET.Reg) & 0x1000) >> 12
}
func (o *USB_Type) SetSYSERRINTSET_EPERRINTSET13(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTSET.Reg, volatile.LoadUint32(&o.SYSERRINTSET.Reg)&^(0x2000)|value<<13)
}
func (o *USB_Type) GetSYSERRINTSET_EPERRINTSET13() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTSET.Reg) & 0x2000) >> 13
}
func (o *USB_Type) SetSYSERRINTSET_EPERRINTSET14(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTSET.Reg, volatile.LoadUint32(&o.SYSERRINTSET.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetSYSERRINTSET_EPERRINTSET14() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTSET.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetSYSERRINTSET_EPERRINTSET15(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTSET.Reg, volatile.LoadUint32(&o.SYSERRINTSET.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetSYSERRINTSET_EPERRINTSET15() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTSET.Reg) & 0x8000) >> 15
}
func (o *USB_Type) SetSYSERRINTSET_EPERRINTSET16(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTSET.Reg, volatile.LoadUint32(&o.SYSERRINTSET.Reg)&^(0x10000)|value<<16)
}
func (o *USB_Type) GetSYSERRINTSET_EPERRINTSET16() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTSET.Reg) & 0x10000) >> 16
}
func (o *USB_Type) SetSYSERRINTSET_EPERRINTSET17(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTSET.Reg, volatile.LoadUint32(&o.SYSERRINTSET.Reg)&^(0x20000)|value<<17)
}
func (o *USB_Type) GetSYSERRINTSET_EPERRINTSET17() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTSET.Reg) & 0x20000) >> 17
}
func (o *USB_Type) SetSYSERRINTSET_EPERRINTSET18(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTSET.Reg, volatile.LoadUint32(&o.SYSERRINTSET.Reg)&^(0x40000)|value<<18)
}
func (o *USB_Type) GetSYSERRINTSET_EPERRINTSET18() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTSET.Reg) & 0x40000) >> 18
}
func (o *USB_Type) SetSYSERRINTSET_EPERRINTSET19(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTSET.Reg, volatile.LoadUint32(&o.SYSERRINTSET.Reg)&^(0x80000)|value<<19)
}
func (o *USB_Type) GetSYSERRINTSET_EPERRINTSET19() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTSET.Reg) & 0x80000) >> 19
}
func (o *USB_Type) SetSYSERRINTSET_EPERRINTSET20(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTSET.Reg, volatile.LoadUint32(&o.SYSERRINTSET.Reg)&^(0x100000)|value<<20)
}
func (o *USB_Type) GetSYSERRINTSET_EPERRINTSET20() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTSET.Reg) & 0x100000) >> 20
}
func (o *USB_Type) SetSYSERRINTSET_EPERRINTSET21(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTSET.Reg, volatile.LoadUint32(&o.SYSERRINTSET.Reg)&^(0x200000)|value<<21)
}
func (o *USB_Type) GetSYSERRINTSET_EPERRINTSET21() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTSET.Reg) & 0x200000) >> 21
}
func (o *USB_Type) SetSYSERRINTSET_EPERRINTSET22(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTSET.Reg, volatile.LoadUint32(&o.SYSERRINTSET.Reg)&^(0x400000)|value<<22)
}
func (o *USB_Type) GetSYSERRINTSET_EPERRINTSET22() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTSET.Reg) & 0x400000) >> 22
}
func (o *USB_Type) SetSYSERRINTSET_EPERRINTSET23(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTSET.Reg, volatile.LoadUint32(&o.SYSERRINTSET.Reg)&^(0x800000)|value<<23)
}
func (o *USB_Type) GetSYSERRINTSET_EPERRINTSET23() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTSET.Reg) & 0x800000) >> 23
}
func (o *USB_Type) SetSYSERRINTSET_EPERRINTSET24(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTSET.Reg, volatile.LoadUint32(&o.SYSERRINTSET.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_Type) GetSYSERRINTSET_EPERRINTSET24() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTSET.Reg) & 0x1000000) >> 24
}
func (o *USB_Type) SetSYSERRINTSET_EPERRINTSET25(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTSET.Reg, volatile.LoadUint32(&o.SYSERRINTSET.Reg)&^(0x2000000)|value<<25)
}
func (o *USB_Type) GetSYSERRINTSET_EPERRINTSET25() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTSET.Reg) & 0x2000000) >> 25
}
func (o *USB_Type) SetSYSERRINTSET_EPERRINTSET26(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTSET.Reg, volatile.LoadUint32(&o.SYSERRINTSET.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_Type) GetSYSERRINTSET_EPERRINTSET26() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTSET.Reg) & 0x4000000) >> 26
}
func (o *USB_Type) SetSYSERRINTSET_EPERRINTSET27(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTSET.Reg, volatile.LoadUint32(&o.SYSERRINTSET.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_Type) GetSYSERRINTSET_EPERRINTSET27() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTSET.Reg) & 0x8000000) >> 27
}
func (o *USB_Type) SetSYSERRINTSET_EPERRINTSET28(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTSET.Reg, volatile.LoadUint32(&o.SYSERRINTSET.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_Type) GetSYSERRINTSET_EPERRINTSET28() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTSET.Reg) & 0x10000000) >> 28
}
func (o *USB_Type) SetSYSERRINTSET_EPERRINTSET29(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTSET.Reg, volatile.LoadUint32(&o.SYSERRINTSET.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_Type) GetSYSERRINTSET_EPERRINTSET29() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTSET.Reg) & 0x20000000) >> 29
}
func (o *USB_Type) SetSYSERRINTSET_EPERRINTSET30(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTSET.Reg, volatile.LoadUint32(&o.SYSERRINTSET.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_Type) GetSYSERRINTSET_EPERRINTSET30() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTSET.Reg) & 0x40000000) >> 30
}
func (o *USB_Type) SetSYSERRINTSET_EPERRINTSET31(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTSET.Reg, volatile.LoadUint32(&o.SYSERRINTSET.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_Type) GetSYSERRINTSET_EPERRINTSET31() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTSET.Reg) & 0x80000000) >> 31
}

// USB.I2C_RX: I2C Receive
func (o *USB_Type) SetI2C_RX_RX_DATA(value uint32) {
	volatile.StoreUint32(&o.I2C_RX.Reg, volatile.LoadUint32(&o.I2C_RX.Reg)&^(0xff)|value)
}
func (o *USB_Type) GetI2C_RX_RX_DATA() uint32 {
	return volatile.LoadUint32(&o.I2C_RX.Reg) & 0xff
}
func (o *USB_Type) SetI2C_RX_RESERVED(value uint32) {
	volatile.StoreUint32(&o.I2C_RX.Reg, volatile.LoadUint32(&o.I2C_RX.Reg)&^(0xffffff00)|value<<8)
}
func (o *USB_Type) GetI2C_RX_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.I2C_RX.Reg) & 0xffffff00) >> 8
}

// USB.I2C_STS: I2C Status
func (o *USB_Type) SetI2C_STS_TDI(value uint32) {
	volatile.StoreUint32(&o.I2C_STS.Reg, volatile.LoadUint32(&o.I2C_STS.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetI2C_STS_TDI() uint32 {
	return volatile.LoadUint32(&o.I2C_STS.Reg) & 0x1
}
func (o *USB_Type) SetI2C_STS_AFI(value uint32) {
	volatile.StoreUint32(&o.I2C_STS.Reg, volatile.LoadUint32(&o.I2C_STS.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetI2C_STS_AFI() uint32 {
	return (volatile.LoadUint32(&o.I2C_STS.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetI2C_STS_NAI(value uint32) {
	volatile.StoreUint32(&o.I2C_STS.Reg, volatile.LoadUint32(&o.I2C_STS.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetI2C_STS_NAI() uint32 {
	return (volatile.LoadUint32(&o.I2C_STS.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetI2C_STS_DRMI(value uint32) {
	volatile.StoreUint32(&o.I2C_STS.Reg, volatile.LoadUint32(&o.I2C_STS.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetI2C_STS_DRMI() uint32 {
	return (volatile.LoadUint32(&o.I2C_STS.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetI2C_STS_DRSI(value uint32) {
	volatile.StoreUint32(&o.I2C_STS.Reg, volatile.LoadUint32(&o.I2C_STS.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetI2C_STS_DRSI() uint32 {
	return (volatile.LoadUint32(&o.I2C_STS.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetI2C_STS_Active(value uint32) {
	volatile.StoreUint32(&o.I2C_STS.Reg, volatile.LoadUint32(&o.I2C_STS.Reg)&^(0x20)|value<<5)
}
func (o *USB_Type) GetI2C_STS_Active() uint32 {
	return (volatile.LoadUint32(&o.I2C_STS.Reg) & 0x20) >> 5
}
func (o *USB_Type) SetI2C_STS_SCL(value uint32) {
	volatile.StoreUint32(&o.I2C_STS.Reg, volatile.LoadUint32(&o.I2C_STS.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetI2C_STS_SCL() uint32 {
	return (volatile.LoadUint32(&o.I2C_STS.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetI2C_STS_SDA(value uint32) {
	volatile.StoreUint32(&o.I2C_STS.Reg, volatile.LoadUint32(&o.I2C_STS.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetI2C_STS_SDA() uint32 {
	return (volatile.LoadUint32(&o.I2C_STS.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetI2C_STS_RFF(value uint32) {
	volatile.StoreUint32(&o.I2C_STS.Reg, volatile.LoadUint32(&o.I2C_STS.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetI2C_STS_RFF() uint32 {
	return (volatile.LoadUint32(&o.I2C_STS.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetI2C_STS_RFE(value uint32) {
	volatile.StoreUint32(&o.I2C_STS.Reg, volatile.LoadUint32(&o.I2C_STS.Reg)&^(0x200)|value<<9)
}
func (o *USB_Type) GetI2C_STS_RFE() uint32 {
	return (volatile.LoadUint32(&o.I2C_STS.Reg) & 0x200) >> 9
}
func (o *USB_Type) SetI2C_STS_TFF(value uint32) {
	volatile.StoreUint32(&o.I2C_STS.Reg, volatile.LoadUint32(&o.I2C_STS.Reg)&^(0x400)|value<<10)
}
func (o *USB_Type) GetI2C_STS_TFF() uint32 {
	return (volatile.LoadUint32(&o.I2C_STS.Reg) & 0x400) >> 10
}
func (o *USB_Type) SetI2C_STS_TFE(value uint32) {
	volatile.StoreUint32(&o.I2C_STS.Reg, volatile.LoadUint32(&o.I2C_STS.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetI2C_STS_TFE() uint32 {
	return (volatile.LoadUint32(&o.I2C_STS.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetI2C_STS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.I2C_STS.Reg, volatile.LoadUint32(&o.I2C_STS.Reg)&^(0xfffff000)|value<<12)
}
func (o *USB_Type) GetI2C_STS_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.I2C_STS.Reg) & 0xfffff000) >> 12
}

// USB.I2C_CTL: I2C Control
func (o *USB_Type) SetI2C_CTL_TDIE(value uint32) {
	volatile.StoreUint32(&o.I2C_CTL.Reg, volatile.LoadUint32(&o.I2C_CTL.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetI2C_CTL_TDIE() uint32 {
	return volatile.LoadUint32(&o.I2C_CTL.Reg) & 0x1
}
func (o *USB_Type) SetI2C_CTL_AFIE(value uint32) {
	volatile.StoreUint32(&o.I2C_CTL.Reg, volatile.LoadUint32(&o.I2C_CTL.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetI2C_CTL_AFIE() uint32 {
	return (volatile.LoadUint32(&o.I2C_CTL.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetI2C_CTL_NAIE(value uint32) {
	volatile.StoreUint32(&o.I2C_CTL.Reg, volatile.LoadUint32(&o.I2C_CTL.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetI2C_CTL_NAIE() uint32 {
	return (volatile.LoadUint32(&o.I2C_CTL.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetI2C_CTL_DRMIE(value uint32) {
	volatile.StoreUint32(&o.I2C_CTL.Reg, volatile.LoadUint32(&o.I2C_CTL.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetI2C_CTL_DRMIE() uint32 {
	return (volatile.LoadUint32(&o.I2C_CTL.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetI2C_CTL_DRSIE(value uint32) {
	volatile.StoreUint32(&o.I2C_CTL.Reg, volatile.LoadUint32(&o.I2C_CTL.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetI2C_CTL_DRSIE() uint32 {
	return (volatile.LoadUint32(&o.I2C_CTL.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetI2C_CTL_REFIE(value uint32) {
	volatile.StoreUint32(&o.I2C_CTL.Reg, volatile.LoadUint32(&o.I2C_CTL.Reg)&^(0x20)|value<<5)
}
func (o *USB_Type) GetI2C_CTL_REFIE() uint32 {
	return (volatile.LoadUint32(&o.I2C_CTL.Reg) & 0x20) >> 5
}
func (o *USB_Type) SetI2C_CTL_RFDAIE(value uint32) {
	volatile.StoreUint32(&o.I2C_CTL.Reg, volatile.LoadUint32(&o.I2C_CTL.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetI2C_CTL_RFDAIE() uint32 {
	return (volatile.LoadUint32(&o.I2C_CTL.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetI2C_CTL_TFFIE(value uint32) {
	volatile.StoreUint32(&o.I2C_CTL.Reg, volatile.LoadUint32(&o.I2C_CTL.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetI2C_CTL_TFFIE() uint32 {
	return (volatile.LoadUint32(&o.I2C_CTL.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetI2C_CTL_SRST(value uint32) {
	volatile.StoreUint32(&o.I2C_CTL.Reg, volatile.LoadUint32(&o.I2C_CTL.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetI2C_CTL_SRST() uint32 {
	return (volatile.LoadUint32(&o.I2C_CTL.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetI2C_CTL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.I2C_CTL.Reg, volatile.LoadUint32(&o.I2C_CTL.Reg)&^(0xfffffe00)|value<<9)
}
func (o *USB_Type) GetI2C_CTL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.I2C_CTL.Reg) & 0xfffffe00) >> 9
}

// USB.I2C_CLKHI: I2C Clock High
func (o *USB_Type) SetI2C_CLKHI_CDHI(value uint32) {
	volatile.StoreUint32(&o.I2C_CLKHI.Reg, volatile.LoadUint32(&o.I2C_CLKHI.Reg)&^(0xff)|value)
}
func (o *USB_Type) GetI2C_CLKHI_CDHI() uint32 {
	return volatile.LoadUint32(&o.I2C_CLKHI.Reg) & 0xff
}
func (o *USB_Type) SetI2C_CLKHI_RESERVED(value uint32) {
	volatile.StoreUint32(&o.I2C_CLKHI.Reg, volatile.LoadUint32(&o.I2C_CLKHI.Reg)&^(0xffffff00)|value<<8)
}
func (o *USB_Type) GetI2C_CLKHI_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.I2C_CLKHI.Reg) & 0xffffff00) >> 8
}

// USB.I2C_CLKLO: I2C Clock Low
func (o *USB_Type) SetI2C_CLKLO_CDLO(value uint32) {
	volatile.StoreUint32(&o.I2C_CLKLO.Reg, volatile.LoadUint32(&o.I2C_CLKLO.Reg)&^(0xff)|value)
}
func (o *USB_Type) GetI2C_CLKLO_CDLO() uint32 {
	return volatile.LoadUint32(&o.I2C_CLKLO.Reg) & 0xff
}
func (o *USB_Type) SetI2C_CLKLO_RESERVED(value uint32) {
	volatile.StoreUint32(&o.I2C_CLKLO.Reg, volatile.LoadUint32(&o.I2C_CLKLO.Reg)&^(0xffffff00)|value<<8)
}
func (o *USB_Type) GetI2C_CLKLO_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.I2C_CLKLO.Reg) & 0xffffff00) >> 8
}

// USB.CLKCTRL: OTG clock controller
func (o *USB_Type) SetCLKCTRL_HOST_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLKCTRL.Reg, volatile.LoadUint32(&o.CLKCTRL.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetCLKCTRL_HOST_CLK_EN() uint32 {
	return volatile.LoadUint32(&o.CLKCTRL.Reg) & 0x1
}
func (o *USB_Type) SetCLKCTRL_DEV_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLKCTRL.Reg, volatile.LoadUint32(&o.CLKCTRL.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetCLKCTRL_DEV_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CLKCTRL.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetCLKCTRL_I2C_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLKCTRL.Reg, volatile.LoadUint32(&o.CLKCTRL.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetCLKCTRL_I2C_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CLKCTRL.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetCLKCTRL_OTG_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLKCTRL.Reg, volatile.LoadUint32(&o.CLKCTRL.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetCLKCTRL_OTG_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CLKCTRL.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetCLKCTRL_AHB_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.CLKCTRL.Reg, volatile.LoadUint32(&o.CLKCTRL.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetCLKCTRL_AHB_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.CLKCTRL.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetCLKCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CLKCTRL.Reg, volatile.LoadUint32(&o.CLKCTRL.Reg)&^(0xffffffe0)|value<<5)
}
func (o *USB_Type) GetCLKCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CLKCTRL.Reg) & 0xffffffe0) >> 5
}

// USB.OTGClkSt: OTG clock status
func (o *USB_Type) SetOTGClkSt_HOST_CLK_ON(value uint32) {
	volatile.StoreUint32(&o.OTGClkSt.Reg, volatile.LoadUint32(&o.OTGClkSt.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetOTGClkSt_HOST_CLK_ON() uint32 {
	return volatile.LoadUint32(&o.OTGClkSt.Reg) & 0x1
}
func (o *USB_Type) SetOTGClkSt_DEV_CLK_ON(value uint32) {
	volatile.StoreUint32(&o.OTGClkSt.Reg, volatile.LoadUint32(&o.OTGClkSt.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetOTGClkSt_DEV_CLK_ON() uint32 {
	return (volatile.LoadUint32(&o.OTGClkSt.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetOTGClkSt_I2C_CLK_ON(value uint32) {
	volatile.StoreUint32(&o.OTGClkSt.Reg, volatile.LoadUint32(&o.OTGClkSt.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetOTGClkSt_I2C_CLK_ON() uint32 {
	return (volatile.LoadUint32(&o.OTGClkSt.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetOTGClkSt_OTG_CLK_ON(value uint32) {
	volatile.StoreUint32(&o.OTGClkSt.Reg, volatile.LoadUint32(&o.OTGClkSt.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetOTGClkSt_OTG_CLK_ON() uint32 {
	return (volatile.LoadUint32(&o.OTGClkSt.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetOTGClkSt_AHB_CLK_ON(value uint32) {
	volatile.StoreUint32(&o.OTGClkSt.Reg, volatile.LoadUint32(&o.OTGClkSt.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetOTGClkSt_AHB_CLK_ON() uint32 {
	return (volatile.LoadUint32(&o.OTGClkSt.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetOTGClkSt_RESERVED(value uint32) {
	volatile.StoreUint32(&o.OTGClkSt.Reg, volatile.LoadUint32(&o.OTGClkSt.Reg)&^(0xffffffe0)|value<<5)
}
func (o *USB_Type) GetOTGClkSt_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.OTGClkSt.Reg) & 0xffffffe0) >> 5
}

// CRC engine
type CRC_Type struct {
	MODE volatile.Register32 // 0x0
	SEED volatile.Register32 // 0x4
	SUM  volatile.Register32 // 0x8
}

// CRC.MODE: CRC mode register
func (o *CRC_Type) SetMODE_CRC_POLY(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x3)|value)
}
func (o *CRC_Type) GetMODE_CRC_POLY() uint32 {
	return volatile.LoadUint32(&o.MODE.Reg) & 0x3
}
func (o *CRC_Type) SetMODE_BIT_RVS_WR(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x4)|value<<2)
}
func (o *CRC_Type) GetMODE_BIT_RVS_WR() uint32 {
	return (volatile.LoadUint32(&o.MODE.Reg) & 0x4) >> 2
}
func (o *CRC_Type) SetMODE_CMPL_WR(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x8)|value<<3)
}
func (o *CRC_Type) GetMODE_CMPL_WR() uint32 {
	return (volatile.LoadUint32(&o.MODE.Reg) & 0x8) >> 3
}
func (o *CRC_Type) SetMODE_BIT_RVS_SUM(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x10)|value<<4)
}
func (o *CRC_Type) GetMODE_BIT_RVS_SUM() uint32 {
	return (volatile.LoadUint32(&o.MODE.Reg) & 0x10) >> 4
}
func (o *CRC_Type) SetMODE_CMPL_SUM(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x20)|value<<5)
}
func (o *CRC_Type) GetMODE_CMPL_SUM() uint32 {
	return (volatile.LoadUint32(&o.MODE.Reg) & 0x20) >> 5
}
func (o *CRC_Type) SetMODE_Reserved(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0xffffffc0)|value<<6)
}
func (o *CRC_Type) GetMODE_Reserved() uint32 {
	return (volatile.LoadUint32(&o.MODE.Reg) & 0xffffffc0) >> 6
}

// CRC.SEED: CRC seed register
func (o *CRC_Type) SetSEED(value uint32) {
	volatile.StoreUint32(&o.SEED.Reg, value)
}
func (o *CRC_Type) GetSEED() uint32 {
	return volatile.LoadUint32(&o.SEED.Reg)
}

// CRC.SUM: CRC checksum register
func (o *CRC_Type) SetSUM(value uint32) {
	volatile.StoreUint32(&o.SUM.Reg, value)
}
func (o *CRC_Type) GetSUM() uint32 {
	return volatile.LoadUint32(&o.SUM.Reg)
}

// GPIO
type GPIO_Type struct {
	DIR0  volatile.Register32 // 0x0
	_     [12]byte
	MASK0 volatile.Register32 // 0x10
	PIN0  volatile.Register32 // 0x14
	SET0  volatile.Register32 // 0x18
	CLR0  volatile.Register32 // 0x1C
	DIR1  volatile.Register32 // 0x20
	_     [12]byte
	MASK1 volatile.Register32 // 0x30
	PIN1  volatile.Register32 // 0x34
	SET1  volatile.Register32 // 0x38
	CLR1  volatile.Register32 // 0x3C
	DIR2  volatile.Register32 // 0x40
	_     [12]byte
	MASK2 volatile.Register32 // 0x50
	PIN2  volatile.Register32 // 0x54
	SET2  volatile.Register32 // 0x58
	CLR2  volatile.Register32 // 0x5C
	DIR3  volatile.Register32 // 0x60
	_     [12]byte
	MASK3 volatile.Register32 // 0x70
	PIN3  volatile.Register32 // 0x74
	SET3  volatile.Register32 // 0x78
	CLR3  volatile.Register32 // 0x7C
	DIR4  volatile.Register32 // 0x80
	_     [12]byte
	MASK4 volatile.Register32 // 0x90
	PIN4  volatile.Register32 // 0x94
	SET4  volatile.Register32 // 0x98
	CLR4  volatile.Register32 // 0x9C
	DIR5  volatile.Register32 // 0xA0
	_     [12]byte
	MASK5 volatile.Register32 // 0xB0
	PIN5  volatile.Register32 // 0xB4
	SET5  volatile.Register32 // 0xB8
	CLR5  volatile.Register32 // 0xBC
}

// GPIO.DIR0: GPIO Port Direction control register.
func (o *GPIO_Type) SetDIR0_PDIR0(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetDIR0_PDIR0() uint32 {
	return volatile.LoadUint32(&o.DIR0.Reg) & 0x1
}
func (o *GPIO_Type) SetDIR0_PDIR1(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetDIR0_PDIR1() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetDIR0_PDIR2(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetDIR0_PDIR2() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetDIR0_PDIR3(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetDIR0_PDIR3() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetDIR0_PDIR4(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetDIR0_PDIR4() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetDIR0_PDIR5(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetDIR0_PDIR5() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetDIR0_PDIR6(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetDIR0_PDIR6() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetDIR0_PDIR7(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetDIR0_PDIR7() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetDIR0_PDIR8(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetDIR0_PDIR8() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetDIR0_PDIR9(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetDIR0_PDIR9() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetDIR0_PDIR10(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetDIR0_PDIR10() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetDIR0_PDIR11(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetDIR0_PDIR11() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetDIR0_PDIR12(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetDIR0_PDIR12() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetDIR0_PDIR13(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetDIR0_PDIR13() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetDIR0_PDIR14(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetDIR0_PDIR14() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetDIR0_PDIR15(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetDIR0_PDIR15() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetDIR0_PDIR16(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetDIR0_PDIR16() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetDIR0_PDIR17(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetDIR0_PDIR17() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetDIR0_PDIR18(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetDIR0_PDIR18() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetDIR0_PDIR19(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetDIR0_PDIR19() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetDIR0_PDIR20(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetDIR0_PDIR20() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetDIR0_PDIR21(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetDIR0_PDIR21() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetDIR0_PDIR22(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetDIR0_PDIR22() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetDIR0_PDIR23(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetDIR0_PDIR23() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetDIR0_PDIR24(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetDIR0_PDIR24() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetDIR0_PDIR25(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetDIR0_PDIR25() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetDIR0_PDIR26(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetDIR0_PDIR26() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetDIR0_PDIR27(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetDIR0_PDIR27() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetDIR0_PDIR28(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetDIR0_PDIR28() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetDIR0_PDIR29(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetDIR0_PDIR29() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetDIR0_PDIR30(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetDIR0_PDIR30() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetDIR0_PDIR31(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetDIR0_PDIR31() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x80000000) >> 31
}

// GPIO.MASK0: Mask register for Port.
func (o *GPIO_Type) SetMASK0_PMASK0(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetMASK0_PMASK0() uint32 {
	return volatile.LoadUint32(&o.MASK0.Reg) & 0x1
}
func (o *GPIO_Type) SetMASK0_PMASK1(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetMASK0_PMASK1() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetMASK0_PMASK2(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetMASK0_PMASK2() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetMASK0_PMASK3(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetMASK0_PMASK3() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetMASK0_PMASK4(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetMASK0_PMASK4() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetMASK0_PMASK5(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetMASK0_PMASK5() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetMASK0_PMASK6(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetMASK0_PMASK6() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetMASK0_PMASK7(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetMASK0_PMASK7() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetMASK0_PMASK8(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetMASK0_PMASK8() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetMASK0_PMASK9(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetMASK0_PMASK9() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetMASK0_PMASK10(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetMASK0_PMASK10() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetMASK0_PMASK11(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetMASK0_PMASK11() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetMASK0_PMASK12(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetMASK0_PMASK12() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetMASK0_PMASK13(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetMASK0_PMASK13() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetMASK0_PMASK14(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetMASK0_PMASK14() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetMASK0_PMASK15(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetMASK0_PMASK15() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetMASK0_PMASK16(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetMASK0_PMASK16() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetMASK0_PMASK17(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetMASK0_PMASK17() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetMASK0_PMASK18(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetMASK0_PMASK18() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetMASK0_PMASK19(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetMASK0_PMASK19() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetMASK0_PMASK20(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetMASK0_PMASK20() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetMASK0_PMASK21(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetMASK0_PMASK21() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetMASK0_PMASK22(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetMASK0_PMASK22() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetMASK0_PMASK23(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetMASK0_PMASK23() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetMASK0_PMASK24(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetMASK0_PMASK24() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetMASK0_PMASK25(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetMASK0_PMASK25() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetMASK0_PMASK26(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetMASK0_PMASK26() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetMASK0_PMASK27(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetMASK0_PMASK27() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetMASK0_PMASK28(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetMASK0_PMASK28() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetMASK0_PMASK29(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetMASK0_PMASK29() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetMASK0_PMASK30(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetMASK0_PMASK30() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetMASK0_PMASK31(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetMASK0_PMASK31() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x80000000) >> 31
}

// GPIO.PIN0: Port Pin value register using MASK.
func (o *GPIO_Type) SetPIN0_VAL0(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetPIN0_VAL0() uint32 {
	return volatile.LoadUint32(&o.PIN0.Reg) & 0x1
}
func (o *GPIO_Type) SetPIN0_VAL1(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetPIN0_VAL1() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetPIN0_VAL2(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN0_VAL2() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN0_VAL3(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetPIN0_VAL3() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetPIN0_VAL4(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetPIN0_VAL4() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetPIN0_VAL5(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetPIN0_VAL5() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetPIN0_VAL6(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetPIN0_VAL6() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetPIN0_VAL7(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetPIN0_VAL7() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetPIN0_VAL8(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetPIN0_VAL8() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetPIN0_VAL9(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetPIN0_VAL9() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetPIN0_VAL10(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN0_VAL10() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN0_VAL11(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetPIN0_VAL11() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetPIN0_VAL12(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetPIN0_VAL12() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetPIN0_VAL13(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetPIN0_VAL13() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetPIN0_VAL14(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetPIN0_VAL14() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetPIN0_VAL15(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetPIN0_VAL15() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetPIN0_VAL16(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetPIN0_VAL16() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetPIN0_VAL17(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetPIN0_VAL17() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetPIN0_VAL18(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetPIN0_VAL18() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetPIN0_VAL19(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetPIN0_VAL19() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetPIN0_VAL20(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetPIN0_VAL20() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetPIN0_VAL21(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetPIN0_VAL21() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetPIN0_VAL22(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetPIN0_VAL22() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetPIN0_VAL23(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetPIN0_VAL23() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetPIN0_VAL24(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetPIN0_VAL24() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetPIN0_VAL25(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetPIN0_VAL25() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetPIN0_VAL26(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetPIN0_VAL26() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetPIN0_VAL27(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetPIN0_VAL27() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetPIN0_VAL28(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetPIN0_VAL28() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetPIN0_VAL29(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetPIN0_VAL29() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetPIN0_VAL30(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetPIN0_VAL30() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetPIN0_VAL31(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetPIN0_VAL31() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x80000000) >> 31
}

// GPIO.SET0: Port Output Set register using MASK.
func (o *GPIO_Type) SetSET0_PSET0(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetSET0_PSET0() uint32 {
	return volatile.LoadUint32(&o.SET0.Reg) & 0x1
}
func (o *GPIO_Type) SetSET0_PSET1(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetSET0_PSET1() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetSET0_PSET2(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetSET0_PSET2() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetSET0_PSET3(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetSET0_PSET3() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetSET0_PSET4(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetSET0_PSET4() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetSET0_PSET5(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetSET0_PSET5() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetSET0_PSET6(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetSET0_PSET6() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetSET0_PSET7(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetSET0_PSET7() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetSET0_PSET8(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetSET0_PSET8() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetSET0_PSET9(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetSET0_PSET9() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetSET0_PSET10(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetSET0_PSET10() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetSET0_PSET11(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetSET0_PSET11() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetSET0_PSET12(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetSET0_PSET12() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetSET0_PSET13(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetSET0_PSET13() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetSET0_PSET14(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetSET0_PSET14() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetSET0_PSET15(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetSET0_PSET15() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetSET0_PSET16(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetSET0_PSET16() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetSET0_PSET17(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetSET0_PSET17() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetSET0_PSET18(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetSET0_PSET18() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetSET0_PSET19(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetSET0_PSET19() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetSET0_PSET20(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetSET0_PSET20() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetSET0_PSET21(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetSET0_PSET21() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetSET0_PSET22(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetSET0_PSET22() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetSET0_PSET23(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetSET0_PSET23() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetSET0_PSET24(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetSET0_PSET24() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetSET0_PSET25(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetSET0_PSET25() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetSET0_PSET26(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetSET0_PSET26() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetSET0_PSET27(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetSET0_PSET27() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetSET0_PSET28(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetSET0_PSET28() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetSET0_PSET29(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetSET0_PSET29() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetSET0_PSET30(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetSET0_PSET30() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetSET0_PSET31(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetSET0_PSET31() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x80000000) >> 31
}

// GPIO.CLR0: Port Output Clear register using MASK.
func (o *GPIO_Type) SetCLR0_PCLR0(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetCLR0_PCLR0() uint32 {
	return volatile.LoadUint32(&o.CLR0.Reg) & 0x1
}
func (o *GPIO_Type) SetCLR0_PCLR1(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetCLR0_PCLR1() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetCLR0_PCLR2(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetCLR0_PCLR2() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetCLR0_PCLR3(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetCLR0_PCLR3() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetCLR0_PCLR4(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetCLR0_PCLR4() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetCLR0_PCLR5(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetCLR0_PCLR5() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetCLR0_PCLR6(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetCLR0_PCLR6() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetCLR0_PCLR7(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetCLR0_PCLR7() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetCLR0_PCLR8(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetCLR0_PCLR8() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetCLR0_PCLR9(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetCLR0_PCLR9() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetCLR0_PCLR10(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetCLR0_PCLR10() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetCLR0_PCLR11(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetCLR0_PCLR11() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetCLR0_PCLR12(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetCLR0_PCLR12() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetCLR0_PCLR13(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetCLR0_PCLR13() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetCLR0_PCLR14(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetCLR0_PCLR14() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetCLR0_PCLR15(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetCLR0_PCLR15() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetCLR0_PCLR16(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetCLR0_PCLR16() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetCLR0_PCLR17(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetCLR0_PCLR17() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetCLR0_PCLR18(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetCLR0_PCLR18() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetCLR0_PCLR19(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetCLR0_PCLR19() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetCLR0_PCLR20(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetCLR0_PCLR20() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetCLR0_PCLR21(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetCLR0_PCLR21() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetCLR0_PCLR22(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetCLR0_PCLR22() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetCLR0_PCLR23(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetCLR0_PCLR23() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetCLR0_PCLR24(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetCLR0_PCLR24() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetCLR0_PCLR25(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetCLR0_PCLR25() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetCLR0_PCLR26(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetCLR0_PCLR26() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetCLR0_PCLR27(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetCLR0_PCLR27() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetCLR0_PCLR28(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetCLR0_PCLR28() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetCLR0_PCLR29(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetCLR0_PCLR29() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetCLR0_PCLR30(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetCLR0_PCLR30() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetCLR0_PCLR31(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetCLR0_PCLR31() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x80000000) >> 31
}

// GPIO.DIR1: GPIO Port Direction control register.
func (o *GPIO_Type) SetDIR1_PDIR0(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetDIR1_PDIR0() uint32 {
	return volatile.LoadUint32(&o.DIR1.Reg) & 0x1
}
func (o *GPIO_Type) SetDIR1_PDIR1(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetDIR1_PDIR1() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetDIR1_PDIR2(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetDIR1_PDIR2() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetDIR1_PDIR3(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetDIR1_PDIR3() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetDIR1_PDIR4(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetDIR1_PDIR4() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetDIR1_PDIR5(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetDIR1_PDIR5() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetDIR1_PDIR6(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetDIR1_PDIR6() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetDIR1_PDIR7(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetDIR1_PDIR7() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetDIR1_PDIR8(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetDIR1_PDIR8() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetDIR1_PDIR9(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetDIR1_PDIR9() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetDIR1_PDIR10(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetDIR1_PDIR10() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetDIR1_PDIR11(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetDIR1_PDIR11() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetDIR1_PDIR12(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetDIR1_PDIR12() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetDIR1_PDIR13(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetDIR1_PDIR13() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetDIR1_PDIR14(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetDIR1_PDIR14() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetDIR1_PDIR15(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetDIR1_PDIR15() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetDIR1_PDIR16(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetDIR1_PDIR16() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetDIR1_PDIR17(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetDIR1_PDIR17() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetDIR1_PDIR18(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetDIR1_PDIR18() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetDIR1_PDIR19(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetDIR1_PDIR19() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetDIR1_PDIR20(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetDIR1_PDIR20() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetDIR1_PDIR21(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetDIR1_PDIR21() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetDIR1_PDIR22(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetDIR1_PDIR22() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetDIR1_PDIR23(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetDIR1_PDIR23() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetDIR1_PDIR24(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetDIR1_PDIR24() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetDIR1_PDIR25(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetDIR1_PDIR25() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetDIR1_PDIR26(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetDIR1_PDIR26() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetDIR1_PDIR27(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetDIR1_PDIR27() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetDIR1_PDIR28(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetDIR1_PDIR28() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetDIR1_PDIR29(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetDIR1_PDIR29() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetDIR1_PDIR30(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetDIR1_PDIR30() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetDIR1_PDIR31(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetDIR1_PDIR31() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x80000000) >> 31
}

// GPIO.MASK1: Mask register for Port.
func (o *GPIO_Type) SetMASK1_PMASK0(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetMASK1_PMASK0() uint32 {
	return volatile.LoadUint32(&o.MASK1.Reg) & 0x1
}
func (o *GPIO_Type) SetMASK1_PMASK1(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetMASK1_PMASK1() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetMASK1_PMASK2(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetMASK1_PMASK2() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetMASK1_PMASK3(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetMASK1_PMASK3() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetMASK1_PMASK4(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetMASK1_PMASK4() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetMASK1_PMASK5(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetMASK1_PMASK5() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetMASK1_PMASK6(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetMASK1_PMASK6() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetMASK1_PMASK7(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetMASK1_PMASK7() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetMASK1_PMASK8(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetMASK1_PMASK8() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetMASK1_PMASK9(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetMASK1_PMASK9() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetMASK1_PMASK10(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetMASK1_PMASK10() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetMASK1_PMASK11(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetMASK1_PMASK11() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetMASK1_PMASK12(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetMASK1_PMASK12() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetMASK1_PMASK13(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetMASK1_PMASK13() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetMASK1_PMASK14(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetMASK1_PMASK14() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetMASK1_PMASK15(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetMASK1_PMASK15() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetMASK1_PMASK16(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetMASK1_PMASK16() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetMASK1_PMASK17(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetMASK1_PMASK17() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetMASK1_PMASK18(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetMASK1_PMASK18() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetMASK1_PMASK19(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetMASK1_PMASK19() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetMASK1_PMASK20(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetMASK1_PMASK20() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetMASK1_PMASK21(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetMASK1_PMASK21() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetMASK1_PMASK22(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetMASK1_PMASK22() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetMASK1_PMASK23(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetMASK1_PMASK23() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetMASK1_PMASK24(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetMASK1_PMASK24() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetMASK1_PMASK25(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetMASK1_PMASK25() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetMASK1_PMASK26(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetMASK1_PMASK26() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetMASK1_PMASK27(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetMASK1_PMASK27() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetMASK1_PMASK28(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetMASK1_PMASK28() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetMASK1_PMASK29(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetMASK1_PMASK29() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetMASK1_PMASK30(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetMASK1_PMASK30() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetMASK1_PMASK31(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetMASK1_PMASK31() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x80000000) >> 31
}

// GPIO.PIN1: Port Pin value register using MASK.
func (o *GPIO_Type) SetPIN1_VAL0(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetPIN1_VAL0() uint32 {
	return volatile.LoadUint32(&o.PIN1.Reg) & 0x1
}
func (o *GPIO_Type) SetPIN1_VAL1(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetPIN1_VAL1() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetPIN1_VAL2(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN1_VAL2() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN1_VAL3(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetPIN1_VAL3() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetPIN1_VAL4(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetPIN1_VAL4() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetPIN1_VAL5(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetPIN1_VAL5() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetPIN1_VAL6(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetPIN1_VAL6() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetPIN1_VAL7(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetPIN1_VAL7() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetPIN1_VAL8(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetPIN1_VAL8() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetPIN1_VAL9(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetPIN1_VAL9() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetPIN1_VAL10(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN1_VAL10() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN1_VAL11(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetPIN1_VAL11() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetPIN1_VAL12(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetPIN1_VAL12() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetPIN1_VAL13(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetPIN1_VAL13() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetPIN1_VAL14(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetPIN1_VAL14() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetPIN1_VAL15(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetPIN1_VAL15() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetPIN1_VAL16(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetPIN1_VAL16() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetPIN1_VAL17(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetPIN1_VAL17() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetPIN1_VAL18(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetPIN1_VAL18() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetPIN1_VAL19(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetPIN1_VAL19() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetPIN1_VAL20(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetPIN1_VAL20() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetPIN1_VAL21(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetPIN1_VAL21() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetPIN1_VAL22(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetPIN1_VAL22() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetPIN1_VAL23(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetPIN1_VAL23() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetPIN1_VAL24(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetPIN1_VAL24() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetPIN1_VAL25(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetPIN1_VAL25() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetPIN1_VAL26(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetPIN1_VAL26() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetPIN1_VAL27(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetPIN1_VAL27() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetPIN1_VAL28(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetPIN1_VAL28() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetPIN1_VAL29(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetPIN1_VAL29() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetPIN1_VAL30(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetPIN1_VAL30() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetPIN1_VAL31(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetPIN1_VAL31() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x80000000) >> 31
}

// GPIO.SET1: Port Output Set register using MASK.
func (o *GPIO_Type) SetSET1_PSET0(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetSET1_PSET0() uint32 {
	return volatile.LoadUint32(&o.SET1.Reg) & 0x1
}
func (o *GPIO_Type) SetSET1_PSET1(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetSET1_PSET1() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetSET1_PSET2(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetSET1_PSET2() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetSET1_PSET3(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetSET1_PSET3() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetSET1_PSET4(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetSET1_PSET4() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetSET1_PSET5(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetSET1_PSET5() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetSET1_PSET6(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetSET1_PSET6() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetSET1_PSET7(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetSET1_PSET7() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetSET1_PSET8(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetSET1_PSET8() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetSET1_PSET9(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetSET1_PSET9() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetSET1_PSET10(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetSET1_PSET10() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetSET1_PSET11(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetSET1_PSET11() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetSET1_PSET12(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetSET1_PSET12() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetSET1_PSET13(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetSET1_PSET13() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetSET1_PSET14(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetSET1_PSET14() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetSET1_PSET15(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetSET1_PSET15() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetSET1_PSET16(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetSET1_PSET16() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetSET1_PSET17(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetSET1_PSET17() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetSET1_PSET18(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetSET1_PSET18() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetSET1_PSET19(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetSET1_PSET19() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetSET1_PSET20(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetSET1_PSET20() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetSET1_PSET21(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetSET1_PSET21() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetSET1_PSET22(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetSET1_PSET22() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetSET1_PSET23(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetSET1_PSET23() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetSET1_PSET24(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetSET1_PSET24() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetSET1_PSET25(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetSET1_PSET25() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetSET1_PSET26(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetSET1_PSET26() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetSET1_PSET27(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetSET1_PSET27() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetSET1_PSET28(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetSET1_PSET28() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetSET1_PSET29(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetSET1_PSET29() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetSET1_PSET30(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetSET1_PSET30() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetSET1_PSET31(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetSET1_PSET31() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x80000000) >> 31
}

// GPIO.CLR1: Port Output Clear register using MASK.
func (o *GPIO_Type) SetCLR1_PCLR0(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetCLR1_PCLR0() uint32 {
	return volatile.LoadUint32(&o.CLR1.Reg) & 0x1
}
func (o *GPIO_Type) SetCLR1_PCLR1(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetCLR1_PCLR1() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetCLR1_PCLR2(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetCLR1_PCLR2() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetCLR1_PCLR3(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetCLR1_PCLR3() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetCLR1_PCLR4(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetCLR1_PCLR4() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetCLR1_PCLR5(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetCLR1_PCLR5() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetCLR1_PCLR6(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetCLR1_PCLR6() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetCLR1_PCLR7(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetCLR1_PCLR7() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetCLR1_PCLR8(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetCLR1_PCLR8() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetCLR1_PCLR9(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetCLR1_PCLR9() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetCLR1_PCLR10(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetCLR1_PCLR10() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetCLR1_PCLR11(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetCLR1_PCLR11() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetCLR1_PCLR12(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetCLR1_PCLR12() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetCLR1_PCLR13(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetCLR1_PCLR13() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetCLR1_PCLR14(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetCLR1_PCLR14() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetCLR1_PCLR15(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetCLR1_PCLR15() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetCLR1_PCLR16(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetCLR1_PCLR16() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetCLR1_PCLR17(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetCLR1_PCLR17() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetCLR1_PCLR18(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetCLR1_PCLR18() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetCLR1_PCLR19(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetCLR1_PCLR19() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetCLR1_PCLR20(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetCLR1_PCLR20() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetCLR1_PCLR21(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetCLR1_PCLR21() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetCLR1_PCLR22(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetCLR1_PCLR22() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetCLR1_PCLR23(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetCLR1_PCLR23() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetCLR1_PCLR24(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetCLR1_PCLR24() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetCLR1_PCLR25(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetCLR1_PCLR25() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetCLR1_PCLR26(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetCLR1_PCLR26() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetCLR1_PCLR27(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetCLR1_PCLR27() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetCLR1_PCLR28(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetCLR1_PCLR28() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetCLR1_PCLR29(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetCLR1_PCLR29() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetCLR1_PCLR30(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetCLR1_PCLR30() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetCLR1_PCLR31(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetCLR1_PCLR31() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x80000000) >> 31
}

// GPIO.DIR2: GPIO Port Direction control register.
func (o *GPIO_Type) SetDIR2_PDIR0(value uint32) {
	volatile.StoreUint32(&o.DIR2.Reg, volatile.LoadUint32(&o.DIR2.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetDIR2_PDIR0() uint32 {
	return volatile.LoadUint32(&o.DIR2.Reg) & 0x1
}
func (o *GPIO_Type) SetDIR2_PDIR1(value uint32) {
	volatile.StoreUint32(&o.DIR2.Reg, volatile.LoadUint32(&o.DIR2.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetDIR2_PDIR1() uint32 {
	return (volatile.LoadUint32(&o.DIR2.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetDIR2_PDIR2(value uint32) {
	volatile.StoreUint32(&o.DIR2.Reg, volatile.LoadUint32(&o.DIR2.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetDIR2_PDIR2() uint32 {
	return (volatile.LoadUint32(&o.DIR2.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetDIR2_PDIR3(value uint32) {
	volatile.StoreUint32(&o.DIR2.Reg, volatile.LoadUint32(&o.DIR2.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetDIR2_PDIR3() uint32 {
	return (volatile.LoadUint32(&o.DIR2.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetDIR2_PDIR4(value uint32) {
	volatile.StoreUint32(&o.DIR2.Reg, volatile.LoadUint32(&o.DIR2.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetDIR2_PDIR4() uint32 {
	return (volatile.LoadUint32(&o.DIR2.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetDIR2_PDIR5(value uint32) {
	volatile.StoreUint32(&o.DIR2.Reg, volatile.LoadUint32(&o.DIR2.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetDIR2_PDIR5() uint32 {
	return (volatile.LoadUint32(&o.DIR2.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetDIR2_PDIR6(value uint32) {
	volatile.StoreUint32(&o.DIR2.Reg, volatile.LoadUint32(&o.DIR2.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetDIR2_PDIR6() uint32 {
	return (volatile.LoadUint32(&o.DIR2.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetDIR2_PDIR7(value uint32) {
	volatile.StoreUint32(&o.DIR2.Reg, volatile.LoadUint32(&o.DIR2.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetDIR2_PDIR7() uint32 {
	return (volatile.LoadUint32(&o.DIR2.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetDIR2_PDIR8(value uint32) {
	volatile.StoreUint32(&o.DIR2.Reg, volatile.LoadUint32(&o.DIR2.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetDIR2_PDIR8() uint32 {
	return (volatile.LoadUint32(&o.DIR2.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetDIR2_PDIR9(value uint32) {
	volatile.StoreUint32(&o.DIR2.Reg, volatile.LoadUint32(&o.DIR2.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetDIR2_PDIR9() uint32 {
	return (volatile.LoadUint32(&o.DIR2.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetDIR2_PDIR10(value uint32) {
	volatile.StoreUint32(&o.DIR2.Reg, volatile.LoadUint32(&o.DIR2.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetDIR2_PDIR10() uint32 {
	return (volatile.LoadUint32(&o.DIR2.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetDIR2_PDIR11(value uint32) {
	volatile.StoreUint32(&o.DIR2.Reg, volatile.LoadUint32(&o.DIR2.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetDIR2_PDIR11() uint32 {
	return (volatile.LoadUint32(&o.DIR2.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetDIR2_PDIR12(value uint32) {
	volatile.StoreUint32(&o.DIR2.Reg, volatile.LoadUint32(&o.DIR2.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetDIR2_PDIR12() uint32 {
	return (volatile.LoadUint32(&o.DIR2.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetDIR2_PDIR13(value uint32) {
	volatile.StoreUint32(&o.DIR2.Reg, volatile.LoadUint32(&o.DIR2.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetDIR2_PDIR13() uint32 {
	return (volatile.LoadUint32(&o.DIR2.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetDIR2_PDIR14(value uint32) {
	volatile.StoreUint32(&o.DIR2.Reg, volatile.LoadUint32(&o.DIR2.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetDIR2_PDIR14() uint32 {
	return (volatile.LoadUint32(&o.DIR2.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetDIR2_PDIR15(value uint32) {
	volatile.StoreUint32(&o.DIR2.Reg, volatile.LoadUint32(&o.DIR2.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetDIR2_PDIR15() uint32 {
	return (volatile.LoadUint32(&o.DIR2.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetDIR2_PDIR16(value uint32) {
	volatile.StoreUint32(&o.DIR2.Reg, volatile.LoadUint32(&o.DIR2.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetDIR2_PDIR16() uint32 {
	return (volatile.LoadUint32(&o.DIR2.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetDIR2_PDIR17(value uint32) {
	volatile.StoreUint32(&o.DIR2.Reg, volatile.LoadUint32(&o.DIR2.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetDIR2_PDIR17() uint32 {
	return (volatile.LoadUint32(&o.DIR2.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetDIR2_PDIR18(value uint32) {
	volatile.StoreUint32(&o.DIR2.Reg, volatile.LoadUint32(&o.DIR2.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetDIR2_PDIR18() uint32 {
	return (volatile.LoadUint32(&o.DIR2.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetDIR2_PDIR19(value uint32) {
	volatile.StoreUint32(&o.DIR2.Reg, volatile.LoadUint32(&o.DIR2.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetDIR2_PDIR19() uint32 {
	return (volatile.LoadUint32(&o.DIR2.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetDIR2_PDIR20(value uint32) {
	volatile.StoreUint32(&o.DIR2.Reg, volatile.LoadUint32(&o.DIR2.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetDIR2_PDIR20() uint32 {
	return (volatile.LoadUint32(&o.DIR2.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetDIR2_PDIR21(value uint32) {
	volatile.StoreUint32(&o.DIR2.Reg, volatile.LoadUint32(&o.DIR2.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetDIR2_PDIR21() uint32 {
	return (volatile.LoadUint32(&o.DIR2.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetDIR2_PDIR22(value uint32) {
	volatile.StoreUint32(&o.DIR2.Reg, volatile.LoadUint32(&o.DIR2.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetDIR2_PDIR22() uint32 {
	return (volatile.LoadUint32(&o.DIR2.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetDIR2_PDIR23(value uint32) {
	volatile.StoreUint32(&o.DIR2.Reg, volatile.LoadUint32(&o.DIR2.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetDIR2_PDIR23() uint32 {
	return (volatile.LoadUint32(&o.DIR2.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetDIR2_PDIR24(value uint32) {
	volatile.StoreUint32(&o.DIR2.Reg, volatile.LoadUint32(&o.DIR2.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetDIR2_PDIR24() uint32 {
	return (volatile.LoadUint32(&o.DIR2.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetDIR2_PDIR25(value uint32) {
	volatile.StoreUint32(&o.DIR2.Reg, volatile.LoadUint32(&o.DIR2.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetDIR2_PDIR25() uint32 {
	return (volatile.LoadUint32(&o.DIR2.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetDIR2_PDIR26(value uint32) {
	volatile.StoreUint32(&o.DIR2.Reg, volatile.LoadUint32(&o.DIR2.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetDIR2_PDIR26() uint32 {
	return (volatile.LoadUint32(&o.DIR2.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetDIR2_PDIR27(value uint32) {
	volatile.StoreUint32(&o.DIR2.Reg, volatile.LoadUint32(&o.DIR2.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetDIR2_PDIR27() uint32 {
	return (volatile.LoadUint32(&o.DIR2.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetDIR2_PDIR28(value uint32) {
	volatile.StoreUint32(&o.DIR2.Reg, volatile.LoadUint32(&o.DIR2.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetDIR2_PDIR28() uint32 {
	return (volatile.LoadUint32(&o.DIR2.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetDIR2_PDIR29(value uint32) {
	volatile.StoreUint32(&o.DIR2.Reg, volatile.LoadUint32(&o.DIR2.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetDIR2_PDIR29() uint32 {
	return (volatile.LoadUint32(&o.DIR2.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetDIR2_PDIR30(value uint32) {
	volatile.StoreUint32(&o.DIR2.Reg, volatile.LoadUint32(&o.DIR2.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetDIR2_PDIR30() uint32 {
	return (volatile.LoadUint32(&o.DIR2.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetDIR2_PDIR31(value uint32) {
	volatile.StoreUint32(&o.DIR2.Reg, volatile.LoadUint32(&o.DIR2.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetDIR2_PDIR31() uint32 {
	return (volatile.LoadUint32(&o.DIR2.Reg) & 0x80000000) >> 31
}

// GPIO.MASK2: Mask register for Port.
func (o *GPIO_Type) SetMASK2_PMASK0(value uint32) {
	volatile.StoreUint32(&o.MASK2.Reg, volatile.LoadUint32(&o.MASK2.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetMASK2_PMASK0() uint32 {
	return volatile.LoadUint32(&o.MASK2.Reg) & 0x1
}
func (o *GPIO_Type) SetMASK2_PMASK1(value uint32) {
	volatile.StoreUint32(&o.MASK2.Reg, volatile.LoadUint32(&o.MASK2.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetMASK2_PMASK1() uint32 {
	return (volatile.LoadUint32(&o.MASK2.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetMASK2_PMASK2(value uint32) {
	volatile.StoreUint32(&o.MASK2.Reg, volatile.LoadUint32(&o.MASK2.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetMASK2_PMASK2() uint32 {
	return (volatile.LoadUint32(&o.MASK2.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetMASK2_PMASK3(value uint32) {
	volatile.StoreUint32(&o.MASK2.Reg, volatile.LoadUint32(&o.MASK2.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetMASK2_PMASK3() uint32 {
	return (volatile.LoadUint32(&o.MASK2.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetMASK2_PMASK4(value uint32) {
	volatile.StoreUint32(&o.MASK2.Reg, volatile.LoadUint32(&o.MASK2.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetMASK2_PMASK4() uint32 {
	return (volatile.LoadUint32(&o.MASK2.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetMASK2_PMASK5(value uint32) {
	volatile.StoreUint32(&o.MASK2.Reg, volatile.LoadUint32(&o.MASK2.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetMASK2_PMASK5() uint32 {
	return (volatile.LoadUint32(&o.MASK2.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetMASK2_PMASK6(value uint32) {
	volatile.StoreUint32(&o.MASK2.Reg, volatile.LoadUint32(&o.MASK2.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetMASK2_PMASK6() uint32 {
	return (volatile.LoadUint32(&o.MASK2.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetMASK2_PMASK7(value uint32) {
	volatile.StoreUint32(&o.MASK2.Reg, volatile.LoadUint32(&o.MASK2.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetMASK2_PMASK7() uint32 {
	return (volatile.LoadUint32(&o.MASK2.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetMASK2_PMASK8(value uint32) {
	volatile.StoreUint32(&o.MASK2.Reg, volatile.LoadUint32(&o.MASK2.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetMASK2_PMASK8() uint32 {
	return (volatile.LoadUint32(&o.MASK2.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetMASK2_PMASK9(value uint32) {
	volatile.StoreUint32(&o.MASK2.Reg, volatile.LoadUint32(&o.MASK2.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetMASK2_PMASK9() uint32 {
	return (volatile.LoadUint32(&o.MASK2.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetMASK2_PMASK10(value uint32) {
	volatile.StoreUint32(&o.MASK2.Reg, volatile.LoadUint32(&o.MASK2.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetMASK2_PMASK10() uint32 {
	return (volatile.LoadUint32(&o.MASK2.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetMASK2_PMASK11(value uint32) {
	volatile.StoreUint32(&o.MASK2.Reg, volatile.LoadUint32(&o.MASK2.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetMASK2_PMASK11() uint32 {
	return (volatile.LoadUint32(&o.MASK2.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetMASK2_PMASK12(value uint32) {
	volatile.StoreUint32(&o.MASK2.Reg, volatile.LoadUint32(&o.MASK2.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetMASK2_PMASK12() uint32 {
	return (volatile.LoadUint32(&o.MASK2.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetMASK2_PMASK13(value uint32) {
	volatile.StoreUint32(&o.MASK2.Reg, volatile.LoadUint32(&o.MASK2.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetMASK2_PMASK13() uint32 {
	return (volatile.LoadUint32(&o.MASK2.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetMASK2_PMASK14(value uint32) {
	volatile.StoreUint32(&o.MASK2.Reg, volatile.LoadUint32(&o.MASK2.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetMASK2_PMASK14() uint32 {
	return (volatile.LoadUint32(&o.MASK2.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetMASK2_PMASK15(value uint32) {
	volatile.StoreUint32(&o.MASK2.Reg, volatile.LoadUint32(&o.MASK2.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetMASK2_PMASK15() uint32 {
	return (volatile.LoadUint32(&o.MASK2.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetMASK2_PMASK16(value uint32) {
	volatile.StoreUint32(&o.MASK2.Reg, volatile.LoadUint32(&o.MASK2.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetMASK2_PMASK16() uint32 {
	return (volatile.LoadUint32(&o.MASK2.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetMASK2_PMASK17(value uint32) {
	volatile.StoreUint32(&o.MASK2.Reg, volatile.LoadUint32(&o.MASK2.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetMASK2_PMASK17() uint32 {
	return (volatile.LoadUint32(&o.MASK2.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetMASK2_PMASK18(value uint32) {
	volatile.StoreUint32(&o.MASK2.Reg, volatile.LoadUint32(&o.MASK2.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetMASK2_PMASK18() uint32 {
	return (volatile.LoadUint32(&o.MASK2.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetMASK2_PMASK19(value uint32) {
	volatile.StoreUint32(&o.MASK2.Reg, volatile.LoadUint32(&o.MASK2.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetMASK2_PMASK19() uint32 {
	return (volatile.LoadUint32(&o.MASK2.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetMASK2_PMASK20(value uint32) {
	volatile.StoreUint32(&o.MASK2.Reg, volatile.LoadUint32(&o.MASK2.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetMASK2_PMASK20() uint32 {
	return (volatile.LoadUint32(&o.MASK2.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetMASK2_PMASK21(value uint32) {
	volatile.StoreUint32(&o.MASK2.Reg, volatile.LoadUint32(&o.MASK2.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetMASK2_PMASK21() uint32 {
	return (volatile.LoadUint32(&o.MASK2.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetMASK2_PMASK22(value uint32) {
	volatile.StoreUint32(&o.MASK2.Reg, volatile.LoadUint32(&o.MASK2.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetMASK2_PMASK22() uint32 {
	return (volatile.LoadUint32(&o.MASK2.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetMASK2_PMASK23(value uint32) {
	volatile.StoreUint32(&o.MASK2.Reg, volatile.LoadUint32(&o.MASK2.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetMASK2_PMASK23() uint32 {
	return (volatile.LoadUint32(&o.MASK2.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetMASK2_PMASK24(value uint32) {
	volatile.StoreUint32(&o.MASK2.Reg, volatile.LoadUint32(&o.MASK2.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetMASK2_PMASK24() uint32 {
	return (volatile.LoadUint32(&o.MASK2.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetMASK2_PMASK25(value uint32) {
	volatile.StoreUint32(&o.MASK2.Reg, volatile.LoadUint32(&o.MASK2.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetMASK2_PMASK25() uint32 {
	return (volatile.LoadUint32(&o.MASK2.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetMASK2_PMASK26(value uint32) {
	volatile.StoreUint32(&o.MASK2.Reg, volatile.LoadUint32(&o.MASK2.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetMASK2_PMASK26() uint32 {
	return (volatile.LoadUint32(&o.MASK2.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetMASK2_PMASK27(value uint32) {
	volatile.StoreUint32(&o.MASK2.Reg, volatile.LoadUint32(&o.MASK2.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetMASK2_PMASK27() uint32 {
	return (volatile.LoadUint32(&o.MASK2.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetMASK2_PMASK28(value uint32) {
	volatile.StoreUint32(&o.MASK2.Reg, volatile.LoadUint32(&o.MASK2.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetMASK2_PMASK28() uint32 {
	return (volatile.LoadUint32(&o.MASK2.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetMASK2_PMASK29(value uint32) {
	volatile.StoreUint32(&o.MASK2.Reg, volatile.LoadUint32(&o.MASK2.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetMASK2_PMASK29() uint32 {
	return (volatile.LoadUint32(&o.MASK2.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetMASK2_PMASK30(value uint32) {
	volatile.StoreUint32(&o.MASK2.Reg, volatile.LoadUint32(&o.MASK2.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetMASK2_PMASK30() uint32 {
	return (volatile.LoadUint32(&o.MASK2.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetMASK2_PMASK31(value uint32) {
	volatile.StoreUint32(&o.MASK2.Reg, volatile.LoadUint32(&o.MASK2.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetMASK2_PMASK31() uint32 {
	return (volatile.LoadUint32(&o.MASK2.Reg) & 0x80000000) >> 31
}

// GPIO.PIN2: Port Pin value register using MASK.
func (o *GPIO_Type) SetPIN2_VAL0(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetPIN2_VAL0() uint32 {
	return volatile.LoadUint32(&o.PIN2.Reg) & 0x1
}
func (o *GPIO_Type) SetPIN2_VAL1(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetPIN2_VAL1() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetPIN2_VAL2(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN2_VAL2() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN2_VAL3(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetPIN2_VAL3() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetPIN2_VAL4(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetPIN2_VAL4() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetPIN2_VAL5(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetPIN2_VAL5() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetPIN2_VAL6(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetPIN2_VAL6() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetPIN2_VAL7(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetPIN2_VAL7() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetPIN2_VAL8(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetPIN2_VAL8() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetPIN2_VAL9(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetPIN2_VAL9() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetPIN2_VAL10(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN2_VAL10() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN2_VAL11(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetPIN2_VAL11() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetPIN2_VAL12(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetPIN2_VAL12() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetPIN2_VAL13(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetPIN2_VAL13() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetPIN2_VAL14(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetPIN2_VAL14() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetPIN2_VAL15(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetPIN2_VAL15() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetPIN2_VAL16(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetPIN2_VAL16() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetPIN2_VAL17(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetPIN2_VAL17() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetPIN2_VAL18(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetPIN2_VAL18() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetPIN2_VAL19(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetPIN2_VAL19() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetPIN2_VAL20(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetPIN2_VAL20() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetPIN2_VAL21(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetPIN2_VAL21() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetPIN2_VAL22(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetPIN2_VAL22() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetPIN2_VAL23(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetPIN2_VAL23() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetPIN2_VAL24(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetPIN2_VAL24() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetPIN2_VAL25(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetPIN2_VAL25() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetPIN2_VAL26(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetPIN2_VAL26() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetPIN2_VAL27(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetPIN2_VAL27() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetPIN2_VAL28(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetPIN2_VAL28() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetPIN2_VAL29(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetPIN2_VAL29() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetPIN2_VAL30(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetPIN2_VAL30() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetPIN2_VAL31(value uint32) {
	volatile.StoreUint32(&o.PIN2.Reg, volatile.LoadUint32(&o.PIN2.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetPIN2_VAL31() uint32 {
	return (volatile.LoadUint32(&o.PIN2.Reg) & 0x80000000) >> 31
}

// GPIO.SET2: Port Output Set register using MASK.
func (o *GPIO_Type) SetSET2_PSET0(value uint32) {
	volatile.StoreUint32(&o.SET2.Reg, volatile.LoadUint32(&o.SET2.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetSET2_PSET0() uint32 {
	return volatile.LoadUint32(&o.SET2.Reg) & 0x1
}
func (o *GPIO_Type) SetSET2_PSET1(value uint32) {
	volatile.StoreUint32(&o.SET2.Reg, volatile.LoadUint32(&o.SET2.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetSET2_PSET1() uint32 {
	return (volatile.LoadUint32(&o.SET2.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetSET2_PSET2(value uint32) {
	volatile.StoreUint32(&o.SET2.Reg, volatile.LoadUint32(&o.SET2.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetSET2_PSET2() uint32 {
	return (volatile.LoadUint32(&o.SET2.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetSET2_PSET3(value uint32) {
	volatile.StoreUint32(&o.SET2.Reg, volatile.LoadUint32(&o.SET2.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetSET2_PSET3() uint32 {
	return (volatile.LoadUint32(&o.SET2.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetSET2_PSET4(value uint32) {
	volatile.StoreUint32(&o.SET2.Reg, volatile.LoadUint32(&o.SET2.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetSET2_PSET4() uint32 {
	return (volatile.LoadUint32(&o.SET2.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetSET2_PSET5(value uint32) {
	volatile.StoreUint32(&o.SET2.Reg, volatile.LoadUint32(&o.SET2.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetSET2_PSET5() uint32 {
	return (volatile.LoadUint32(&o.SET2.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetSET2_PSET6(value uint32) {
	volatile.StoreUint32(&o.SET2.Reg, volatile.LoadUint32(&o.SET2.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetSET2_PSET6() uint32 {
	return (volatile.LoadUint32(&o.SET2.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetSET2_PSET7(value uint32) {
	volatile.StoreUint32(&o.SET2.Reg, volatile.LoadUint32(&o.SET2.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetSET2_PSET7() uint32 {
	return (volatile.LoadUint32(&o.SET2.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetSET2_PSET8(value uint32) {
	volatile.StoreUint32(&o.SET2.Reg, volatile.LoadUint32(&o.SET2.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetSET2_PSET8() uint32 {
	return (volatile.LoadUint32(&o.SET2.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetSET2_PSET9(value uint32) {
	volatile.StoreUint32(&o.SET2.Reg, volatile.LoadUint32(&o.SET2.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetSET2_PSET9() uint32 {
	return (volatile.LoadUint32(&o.SET2.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetSET2_PSET10(value uint32) {
	volatile.StoreUint32(&o.SET2.Reg, volatile.LoadUint32(&o.SET2.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetSET2_PSET10() uint32 {
	return (volatile.LoadUint32(&o.SET2.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetSET2_PSET11(value uint32) {
	volatile.StoreUint32(&o.SET2.Reg, volatile.LoadUint32(&o.SET2.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetSET2_PSET11() uint32 {
	return (volatile.LoadUint32(&o.SET2.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetSET2_PSET12(value uint32) {
	volatile.StoreUint32(&o.SET2.Reg, volatile.LoadUint32(&o.SET2.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetSET2_PSET12() uint32 {
	return (volatile.LoadUint32(&o.SET2.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetSET2_PSET13(value uint32) {
	volatile.StoreUint32(&o.SET2.Reg, volatile.LoadUint32(&o.SET2.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetSET2_PSET13() uint32 {
	return (volatile.LoadUint32(&o.SET2.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetSET2_PSET14(value uint32) {
	volatile.StoreUint32(&o.SET2.Reg, volatile.LoadUint32(&o.SET2.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetSET2_PSET14() uint32 {
	return (volatile.LoadUint32(&o.SET2.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetSET2_PSET15(value uint32) {
	volatile.StoreUint32(&o.SET2.Reg, volatile.LoadUint32(&o.SET2.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetSET2_PSET15() uint32 {
	return (volatile.LoadUint32(&o.SET2.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetSET2_PSET16(value uint32) {
	volatile.StoreUint32(&o.SET2.Reg, volatile.LoadUint32(&o.SET2.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetSET2_PSET16() uint32 {
	return (volatile.LoadUint32(&o.SET2.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetSET2_PSET17(value uint32) {
	volatile.StoreUint32(&o.SET2.Reg, volatile.LoadUint32(&o.SET2.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetSET2_PSET17() uint32 {
	return (volatile.LoadUint32(&o.SET2.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetSET2_PSET18(value uint32) {
	volatile.StoreUint32(&o.SET2.Reg, volatile.LoadUint32(&o.SET2.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetSET2_PSET18() uint32 {
	return (volatile.LoadUint32(&o.SET2.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetSET2_PSET19(value uint32) {
	volatile.StoreUint32(&o.SET2.Reg, volatile.LoadUint32(&o.SET2.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetSET2_PSET19() uint32 {
	return (volatile.LoadUint32(&o.SET2.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetSET2_PSET20(value uint32) {
	volatile.StoreUint32(&o.SET2.Reg, volatile.LoadUint32(&o.SET2.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetSET2_PSET20() uint32 {
	return (volatile.LoadUint32(&o.SET2.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetSET2_PSET21(value uint32) {
	volatile.StoreUint32(&o.SET2.Reg, volatile.LoadUint32(&o.SET2.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetSET2_PSET21() uint32 {
	return (volatile.LoadUint32(&o.SET2.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetSET2_PSET22(value uint32) {
	volatile.StoreUint32(&o.SET2.Reg, volatile.LoadUint32(&o.SET2.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetSET2_PSET22() uint32 {
	return (volatile.LoadUint32(&o.SET2.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetSET2_PSET23(value uint32) {
	volatile.StoreUint32(&o.SET2.Reg, volatile.LoadUint32(&o.SET2.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetSET2_PSET23() uint32 {
	return (volatile.LoadUint32(&o.SET2.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetSET2_PSET24(value uint32) {
	volatile.StoreUint32(&o.SET2.Reg, volatile.LoadUint32(&o.SET2.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetSET2_PSET24() uint32 {
	return (volatile.LoadUint32(&o.SET2.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetSET2_PSET25(value uint32) {
	volatile.StoreUint32(&o.SET2.Reg, volatile.LoadUint32(&o.SET2.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetSET2_PSET25() uint32 {
	return (volatile.LoadUint32(&o.SET2.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetSET2_PSET26(value uint32) {
	volatile.StoreUint32(&o.SET2.Reg, volatile.LoadUint32(&o.SET2.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetSET2_PSET26() uint32 {
	return (volatile.LoadUint32(&o.SET2.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetSET2_PSET27(value uint32) {
	volatile.StoreUint32(&o.SET2.Reg, volatile.LoadUint32(&o.SET2.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetSET2_PSET27() uint32 {
	return (volatile.LoadUint32(&o.SET2.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetSET2_PSET28(value uint32) {
	volatile.StoreUint32(&o.SET2.Reg, volatile.LoadUint32(&o.SET2.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetSET2_PSET28() uint32 {
	return (volatile.LoadUint32(&o.SET2.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetSET2_PSET29(value uint32) {
	volatile.StoreUint32(&o.SET2.Reg, volatile.LoadUint32(&o.SET2.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetSET2_PSET29() uint32 {
	return (volatile.LoadUint32(&o.SET2.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetSET2_PSET30(value uint32) {
	volatile.StoreUint32(&o.SET2.Reg, volatile.LoadUint32(&o.SET2.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetSET2_PSET30() uint32 {
	return (volatile.LoadUint32(&o.SET2.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetSET2_PSET31(value uint32) {
	volatile.StoreUint32(&o.SET2.Reg, volatile.LoadUint32(&o.SET2.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetSET2_PSET31() uint32 {
	return (volatile.LoadUint32(&o.SET2.Reg) & 0x80000000) >> 31
}

// GPIO.CLR2: Port Output Clear register using MASK.
func (o *GPIO_Type) SetCLR2_PCLR0(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetCLR2_PCLR0() uint32 {
	return volatile.LoadUint32(&o.CLR2.Reg) & 0x1
}
func (o *GPIO_Type) SetCLR2_PCLR1(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetCLR2_PCLR1() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetCLR2_PCLR2(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetCLR2_PCLR2() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetCLR2_PCLR3(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetCLR2_PCLR3() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetCLR2_PCLR4(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetCLR2_PCLR4() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetCLR2_PCLR5(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetCLR2_PCLR5() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetCLR2_PCLR6(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetCLR2_PCLR6() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetCLR2_PCLR7(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetCLR2_PCLR7() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetCLR2_PCLR8(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetCLR2_PCLR8() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetCLR2_PCLR9(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetCLR2_PCLR9() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetCLR2_PCLR10(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetCLR2_PCLR10() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetCLR2_PCLR11(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetCLR2_PCLR11() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetCLR2_PCLR12(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetCLR2_PCLR12() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetCLR2_PCLR13(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetCLR2_PCLR13() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetCLR2_PCLR14(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetCLR2_PCLR14() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetCLR2_PCLR15(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetCLR2_PCLR15() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetCLR2_PCLR16(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetCLR2_PCLR16() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetCLR2_PCLR17(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetCLR2_PCLR17() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetCLR2_PCLR18(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetCLR2_PCLR18() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetCLR2_PCLR19(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetCLR2_PCLR19() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetCLR2_PCLR20(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetCLR2_PCLR20() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetCLR2_PCLR21(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetCLR2_PCLR21() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetCLR2_PCLR22(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetCLR2_PCLR22() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetCLR2_PCLR23(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetCLR2_PCLR23() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetCLR2_PCLR24(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetCLR2_PCLR24() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetCLR2_PCLR25(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetCLR2_PCLR25() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetCLR2_PCLR26(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetCLR2_PCLR26() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetCLR2_PCLR27(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetCLR2_PCLR27() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetCLR2_PCLR28(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetCLR2_PCLR28() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetCLR2_PCLR29(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetCLR2_PCLR29() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetCLR2_PCLR30(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetCLR2_PCLR30() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetCLR2_PCLR31(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetCLR2_PCLR31() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x80000000) >> 31
}

// GPIO.DIR3: GPIO Port Direction control register.
func (o *GPIO_Type) SetDIR3_PDIR0(value uint32) {
	volatile.StoreUint32(&o.DIR3.Reg, volatile.LoadUint32(&o.DIR3.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetDIR3_PDIR0() uint32 {
	return volatile.LoadUint32(&o.DIR3.Reg) & 0x1
}
func (o *GPIO_Type) SetDIR3_PDIR1(value uint32) {
	volatile.StoreUint32(&o.DIR3.Reg, volatile.LoadUint32(&o.DIR3.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetDIR3_PDIR1() uint32 {
	return (volatile.LoadUint32(&o.DIR3.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetDIR3_PDIR2(value uint32) {
	volatile.StoreUint32(&o.DIR3.Reg, volatile.LoadUint32(&o.DIR3.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetDIR3_PDIR2() uint32 {
	return (volatile.LoadUint32(&o.DIR3.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetDIR3_PDIR3(value uint32) {
	volatile.StoreUint32(&o.DIR3.Reg, volatile.LoadUint32(&o.DIR3.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetDIR3_PDIR3() uint32 {
	return (volatile.LoadUint32(&o.DIR3.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetDIR3_PDIR4(value uint32) {
	volatile.StoreUint32(&o.DIR3.Reg, volatile.LoadUint32(&o.DIR3.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetDIR3_PDIR4() uint32 {
	return (volatile.LoadUint32(&o.DIR3.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetDIR3_PDIR5(value uint32) {
	volatile.StoreUint32(&o.DIR3.Reg, volatile.LoadUint32(&o.DIR3.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetDIR3_PDIR5() uint32 {
	return (volatile.LoadUint32(&o.DIR3.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetDIR3_PDIR6(value uint32) {
	volatile.StoreUint32(&o.DIR3.Reg, volatile.LoadUint32(&o.DIR3.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetDIR3_PDIR6() uint32 {
	return (volatile.LoadUint32(&o.DIR3.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetDIR3_PDIR7(value uint32) {
	volatile.StoreUint32(&o.DIR3.Reg, volatile.LoadUint32(&o.DIR3.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetDIR3_PDIR7() uint32 {
	return (volatile.LoadUint32(&o.DIR3.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetDIR3_PDIR8(value uint32) {
	volatile.StoreUint32(&o.DIR3.Reg, volatile.LoadUint32(&o.DIR3.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetDIR3_PDIR8() uint32 {
	return (volatile.LoadUint32(&o.DIR3.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetDIR3_PDIR9(value uint32) {
	volatile.StoreUint32(&o.DIR3.Reg, volatile.LoadUint32(&o.DIR3.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetDIR3_PDIR9() uint32 {
	return (volatile.LoadUint32(&o.DIR3.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetDIR3_PDIR10(value uint32) {
	volatile.StoreUint32(&o.DIR3.Reg, volatile.LoadUint32(&o.DIR3.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetDIR3_PDIR10() uint32 {
	return (volatile.LoadUint32(&o.DIR3.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetDIR3_PDIR11(value uint32) {
	volatile.StoreUint32(&o.DIR3.Reg, volatile.LoadUint32(&o.DIR3.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetDIR3_PDIR11() uint32 {
	return (volatile.LoadUint32(&o.DIR3.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetDIR3_PDIR12(value uint32) {
	volatile.StoreUint32(&o.DIR3.Reg, volatile.LoadUint32(&o.DIR3.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetDIR3_PDIR12() uint32 {
	return (volatile.LoadUint32(&o.DIR3.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetDIR3_PDIR13(value uint32) {
	volatile.StoreUint32(&o.DIR3.Reg, volatile.LoadUint32(&o.DIR3.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetDIR3_PDIR13() uint32 {
	return (volatile.LoadUint32(&o.DIR3.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetDIR3_PDIR14(value uint32) {
	volatile.StoreUint32(&o.DIR3.Reg, volatile.LoadUint32(&o.DIR3.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetDIR3_PDIR14() uint32 {
	return (volatile.LoadUint32(&o.DIR3.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetDIR3_PDIR15(value uint32) {
	volatile.StoreUint32(&o.DIR3.Reg, volatile.LoadUint32(&o.DIR3.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetDIR3_PDIR15() uint32 {
	return (volatile.LoadUint32(&o.DIR3.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetDIR3_PDIR16(value uint32) {
	volatile.StoreUint32(&o.DIR3.Reg, volatile.LoadUint32(&o.DIR3.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetDIR3_PDIR16() uint32 {
	return (volatile.LoadUint32(&o.DIR3.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetDIR3_PDIR17(value uint32) {
	volatile.StoreUint32(&o.DIR3.Reg, volatile.LoadUint32(&o.DIR3.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetDIR3_PDIR17() uint32 {
	return (volatile.LoadUint32(&o.DIR3.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetDIR3_PDIR18(value uint32) {
	volatile.StoreUint32(&o.DIR3.Reg, volatile.LoadUint32(&o.DIR3.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetDIR3_PDIR18() uint32 {
	return (volatile.LoadUint32(&o.DIR3.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetDIR3_PDIR19(value uint32) {
	volatile.StoreUint32(&o.DIR3.Reg, volatile.LoadUint32(&o.DIR3.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetDIR3_PDIR19() uint32 {
	return (volatile.LoadUint32(&o.DIR3.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetDIR3_PDIR20(value uint32) {
	volatile.StoreUint32(&o.DIR3.Reg, volatile.LoadUint32(&o.DIR3.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetDIR3_PDIR20() uint32 {
	return (volatile.LoadUint32(&o.DIR3.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetDIR3_PDIR21(value uint32) {
	volatile.StoreUint32(&o.DIR3.Reg, volatile.LoadUint32(&o.DIR3.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetDIR3_PDIR21() uint32 {
	return (volatile.LoadUint32(&o.DIR3.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetDIR3_PDIR22(value uint32) {
	volatile.StoreUint32(&o.DIR3.Reg, volatile.LoadUint32(&o.DIR3.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetDIR3_PDIR22() uint32 {
	return (volatile.LoadUint32(&o.DIR3.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetDIR3_PDIR23(value uint32) {
	volatile.StoreUint32(&o.DIR3.Reg, volatile.LoadUint32(&o.DIR3.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetDIR3_PDIR23() uint32 {
	return (volatile.LoadUint32(&o.DIR3.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetDIR3_PDIR24(value uint32) {
	volatile.StoreUint32(&o.DIR3.Reg, volatile.LoadUint32(&o.DIR3.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetDIR3_PDIR24() uint32 {
	return (volatile.LoadUint32(&o.DIR3.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetDIR3_PDIR25(value uint32) {
	volatile.StoreUint32(&o.DIR3.Reg, volatile.LoadUint32(&o.DIR3.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetDIR3_PDIR25() uint32 {
	return (volatile.LoadUint32(&o.DIR3.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetDIR3_PDIR26(value uint32) {
	volatile.StoreUint32(&o.DIR3.Reg, volatile.LoadUint32(&o.DIR3.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetDIR3_PDIR26() uint32 {
	return (volatile.LoadUint32(&o.DIR3.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetDIR3_PDIR27(value uint32) {
	volatile.StoreUint32(&o.DIR3.Reg, volatile.LoadUint32(&o.DIR3.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetDIR3_PDIR27() uint32 {
	return (volatile.LoadUint32(&o.DIR3.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetDIR3_PDIR28(value uint32) {
	volatile.StoreUint32(&o.DIR3.Reg, volatile.LoadUint32(&o.DIR3.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetDIR3_PDIR28() uint32 {
	return (volatile.LoadUint32(&o.DIR3.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetDIR3_PDIR29(value uint32) {
	volatile.StoreUint32(&o.DIR3.Reg, volatile.LoadUint32(&o.DIR3.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetDIR3_PDIR29() uint32 {
	return (volatile.LoadUint32(&o.DIR3.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetDIR3_PDIR30(value uint32) {
	volatile.StoreUint32(&o.DIR3.Reg, volatile.LoadUint32(&o.DIR3.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetDIR3_PDIR30() uint32 {
	return (volatile.LoadUint32(&o.DIR3.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetDIR3_PDIR31(value uint32) {
	volatile.StoreUint32(&o.DIR3.Reg, volatile.LoadUint32(&o.DIR3.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetDIR3_PDIR31() uint32 {
	return (volatile.LoadUint32(&o.DIR3.Reg) & 0x80000000) >> 31
}

// GPIO.MASK3: Mask register for Port.
func (o *GPIO_Type) SetMASK3_PMASK0(value uint32) {
	volatile.StoreUint32(&o.MASK3.Reg, volatile.LoadUint32(&o.MASK3.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetMASK3_PMASK0() uint32 {
	return volatile.LoadUint32(&o.MASK3.Reg) & 0x1
}
func (o *GPIO_Type) SetMASK3_PMASK1(value uint32) {
	volatile.StoreUint32(&o.MASK3.Reg, volatile.LoadUint32(&o.MASK3.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetMASK3_PMASK1() uint32 {
	return (volatile.LoadUint32(&o.MASK3.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetMASK3_PMASK2(value uint32) {
	volatile.StoreUint32(&o.MASK3.Reg, volatile.LoadUint32(&o.MASK3.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetMASK3_PMASK2() uint32 {
	return (volatile.LoadUint32(&o.MASK3.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetMASK3_PMASK3(value uint32) {
	volatile.StoreUint32(&o.MASK3.Reg, volatile.LoadUint32(&o.MASK3.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetMASK3_PMASK3() uint32 {
	return (volatile.LoadUint32(&o.MASK3.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetMASK3_PMASK4(value uint32) {
	volatile.StoreUint32(&o.MASK3.Reg, volatile.LoadUint32(&o.MASK3.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetMASK3_PMASK4() uint32 {
	return (volatile.LoadUint32(&o.MASK3.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetMASK3_PMASK5(value uint32) {
	volatile.StoreUint32(&o.MASK3.Reg, volatile.LoadUint32(&o.MASK3.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetMASK3_PMASK5() uint32 {
	return (volatile.LoadUint32(&o.MASK3.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetMASK3_PMASK6(value uint32) {
	volatile.StoreUint32(&o.MASK3.Reg, volatile.LoadUint32(&o.MASK3.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetMASK3_PMASK6() uint32 {
	return (volatile.LoadUint32(&o.MASK3.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetMASK3_PMASK7(value uint32) {
	volatile.StoreUint32(&o.MASK3.Reg, volatile.LoadUint32(&o.MASK3.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetMASK3_PMASK7() uint32 {
	return (volatile.LoadUint32(&o.MASK3.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetMASK3_PMASK8(value uint32) {
	volatile.StoreUint32(&o.MASK3.Reg, volatile.LoadUint32(&o.MASK3.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetMASK3_PMASK8() uint32 {
	return (volatile.LoadUint32(&o.MASK3.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetMASK3_PMASK9(value uint32) {
	volatile.StoreUint32(&o.MASK3.Reg, volatile.LoadUint32(&o.MASK3.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetMASK3_PMASK9() uint32 {
	return (volatile.LoadUint32(&o.MASK3.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetMASK3_PMASK10(value uint32) {
	volatile.StoreUint32(&o.MASK3.Reg, volatile.LoadUint32(&o.MASK3.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetMASK3_PMASK10() uint32 {
	return (volatile.LoadUint32(&o.MASK3.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetMASK3_PMASK11(value uint32) {
	volatile.StoreUint32(&o.MASK3.Reg, volatile.LoadUint32(&o.MASK3.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetMASK3_PMASK11() uint32 {
	return (volatile.LoadUint32(&o.MASK3.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetMASK3_PMASK12(value uint32) {
	volatile.StoreUint32(&o.MASK3.Reg, volatile.LoadUint32(&o.MASK3.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetMASK3_PMASK12() uint32 {
	return (volatile.LoadUint32(&o.MASK3.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetMASK3_PMASK13(value uint32) {
	volatile.StoreUint32(&o.MASK3.Reg, volatile.LoadUint32(&o.MASK3.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetMASK3_PMASK13() uint32 {
	return (volatile.LoadUint32(&o.MASK3.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetMASK3_PMASK14(value uint32) {
	volatile.StoreUint32(&o.MASK3.Reg, volatile.LoadUint32(&o.MASK3.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetMASK3_PMASK14() uint32 {
	return (volatile.LoadUint32(&o.MASK3.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetMASK3_PMASK15(value uint32) {
	volatile.StoreUint32(&o.MASK3.Reg, volatile.LoadUint32(&o.MASK3.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetMASK3_PMASK15() uint32 {
	return (volatile.LoadUint32(&o.MASK3.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetMASK3_PMASK16(value uint32) {
	volatile.StoreUint32(&o.MASK3.Reg, volatile.LoadUint32(&o.MASK3.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetMASK3_PMASK16() uint32 {
	return (volatile.LoadUint32(&o.MASK3.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetMASK3_PMASK17(value uint32) {
	volatile.StoreUint32(&o.MASK3.Reg, volatile.LoadUint32(&o.MASK3.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetMASK3_PMASK17() uint32 {
	return (volatile.LoadUint32(&o.MASK3.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetMASK3_PMASK18(value uint32) {
	volatile.StoreUint32(&o.MASK3.Reg, volatile.LoadUint32(&o.MASK3.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetMASK3_PMASK18() uint32 {
	return (volatile.LoadUint32(&o.MASK3.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetMASK3_PMASK19(value uint32) {
	volatile.StoreUint32(&o.MASK3.Reg, volatile.LoadUint32(&o.MASK3.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetMASK3_PMASK19() uint32 {
	return (volatile.LoadUint32(&o.MASK3.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetMASK3_PMASK20(value uint32) {
	volatile.StoreUint32(&o.MASK3.Reg, volatile.LoadUint32(&o.MASK3.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetMASK3_PMASK20() uint32 {
	return (volatile.LoadUint32(&o.MASK3.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetMASK3_PMASK21(value uint32) {
	volatile.StoreUint32(&o.MASK3.Reg, volatile.LoadUint32(&o.MASK3.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetMASK3_PMASK21() uint32 {
	return (volatile.LoadUint32(&o.MASK3.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetMASK3_PMASK22(value uint32) {
	volatile.StoreUint32(&o.MASK3.Reg, volatile.LoadUint32(&o.MASK3.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetMASK3_PMASK22() uint32 {
	return (volatile.LoadUint32(&o.MASK3.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetMASK3_PMASK23(value uint32) {
	volatile.StoreUint32(&o.MASK3.Reg, volatile.LoadUint32(&o.MASK3.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetMASK3_PMASK23() uint32 {
	return (volatile.LoadUint32(&o.MASK3.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetMASK3_PMASK24(value uint32) {
	volatile.StoreUint32(&o.MASK3.Reg, volatile.LoadUint32(&o.MASK3.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetMASK3_PMASK24() uint32 {
	return (volatile.LoadUint32(&o.MASK3.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetMASK3_PMASK25(value uint32) {
	volatile.StoreUint32(&o.MASK3.Reg, volatile.LoadUint32(&o.MASK3.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetMASK3_PMASK25() uint32 {
	return (volatile.LoadUint32(&o.MASK3.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetMASK3_PMASK26(value uint32) {
	volatile.StoreUint32(&o.MASK3.Reg, volatile.LoadUint32(&o.MASK3.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetMASK3_PMASK26() uint32 {
	return (volatile.LoadUint32(&o.MASK3.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetMASK3_PMASK27(value uint32) {
	volatile.StoreUint32(&o.MASK3.Reg, volatile.LoadUint32(&o.MASK3.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetMASK3_PMASK27() uint32 {
	return (volatile.LoadUint32(&o.MASK3.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetMASK3_PMASK28(value uint32) {
	volatile.StoreUint32(&o.MASK3.Reg, volatile.LoadUint32(&o.MASK3.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetMASK3_PMASK28() uint32 {
	return (volatile.LoadUint32(&o.MASK3.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetMASK3_PMASK29(value uint32) {
	volatile.StoreUint32(&o.MASK3.Reg, volatile.LoadUint32(&o.MASK3.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetMASK3_PMASK29() uint32 {
	return (volatile.LoadUint32(&o.MASK3.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetMASK3_PMASK30(value uint32) {
	volatile.StoreUint32(&o.MASK3.Reg, volatile.LoadUint32(&o.MASK3.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetMASK3_PMASK30() uint32 {
	return (volatile.LoadUint32(&o.MASK3.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetMASK3_PMASK31(value uint32) {
	volatile.StoreUint32(&o.MASK3.Reg, volatile.LoadUint32(&o.MASK3.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetMASK3_PMASK31() uint32 {
	return (volatile.LoadUint32(&o.MASK3.Reg) & 0x80000000) >> 31
}

// GPIO.PIN3: Port Pin value register using MASK.
func (o *GPIO_Type) SetPIN3_VAL0(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetPIN3_VAL0() uint32 {
	return volatile.LoadUint32(&o.PIN3.Reg) & 0x1
}
func (o *GPIO_Type) SetPIN3_VAL1(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetPIN3_VAL1() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetPIN3_VAL2(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN3_VAL2() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN3_VAL3(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetPIN3_VAL3() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetPIN3_VAL4(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetPIN3_VAL4() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetPIN3_VAL5(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetPIN3_VAL5() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetPIN3_VAL6(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetPIN3_VAL6() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetPIN3_VAL7(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetPIN3_VAL7() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetPIN3_VAL8(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetPIN3_VAL8() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetPIN3_VAL9(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetPIN3_VAL9() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetPIN3_VAL10(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN3_VAL10() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN3_VAL11(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetPIN3_VAL11() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetPIN3_VAL12(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetPIN3_VAL12() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetPIN3_VAL13(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetPIN3_VAL13() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetPIN3_VAL14(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetPIN3_VAL14() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetPIN3_VAL15(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetPIN3_VAL15() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetPIN3_VAL16(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetPIN3_VAL16() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetPIN3_VAL17(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetPIN3_VAL17() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetPIN3_VAL18(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetPIN3_VAL18() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetPIN3_VAL19(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetPIN3_VAL19() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetPIN3_VAL20(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetPIN3_VAL20() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetPIN3_VAL21(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetPIN3_VAL21() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetPIN3_VAL22(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetPIN3_VAL22() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetPIN3_VAL23(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetPIN3_VAL23() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetPIN3_VAL24(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetPIN3_VAL24() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetPIN3_VAL25(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetPIN3_VAL25() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetPIN3_VAL26(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetPIN3_VAL26() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetPIN3_VAL27(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetPIN3_VAL27() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetPIN3_VAL28(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetPIN3_VAL28() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetPIN3_VAL29(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetPIN3_VAL29() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetPIN3_VAL30(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetPIN3_VAL30() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetPIN3_VAL31(value uint32) {
	volatile.StoreUint32(&o.PIN3.Reg, volatile.LoadUint32(&o.PIN3.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetPIN3_VAL31() uint32 {
	return (volatile.LoadUint32(&o.PIN3.Reg) & 0x80000000) >> 31
}

// GPIO.SET3: Port Output Set register using MASK.
func (o *GPIO_Type) SetSET3_PSET0(value uint32) {
	volatile.StoreUint32(&o.SET3.Reg, volatile.LoadUint32(&o.SET3.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetSET3_PSET0() uint32 {
	return volatile.LoadUint32(&o.SET3.Reg) & 0x1
}
func (o *GPIO_Type) SetSET3_PSET1(value uint32) {
	volatile.StoreUint32(&o.SET3.Reg, volatile.LoadUint32(&o.SET3.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetSET3_PSET1() uint32 {
	return (volatile.LoadUint32(&o.SET3.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetSET3_PSET2(value uint32) {
	volatile.StoreUint32(&o.SET3.Reg, volatile.LoadUint32(&o.SET3.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetSET3_PSET2() uint32 {
	return (volatile.LoadUint32(&o.SET3.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetSET3_PSET3(value uint32) {
	volatile.StoreUint32(&o.SET3.Reg, volatile.LoadUint32(&o.SET3.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetSET3_PSET3() uint32 {
	return (volatile.LoadUint32(&o.SET3.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetSET3_PSET4(value uint32) {
	volatile.StoreUint32(&o.SET3.Reg, volatile.LoadUint32(&o.SET3.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetSET3_PSET4() uint32 {
	return (volatile.LoadUint32(&o.SET3.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetSET3_PSET5(value uint32) {
	volatile.StoreUint32(&o.SET3.Reg, volatile.LoadUint32(&o.SET3.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetSET3_PSET5() uint32 {
	return (volatile.LoadUint32(&o.SET3.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetSET3_PSET6(value uint32) {
	volatile.StoreUint32(&o.SET3.Reg, volatile.LoadUint32(&o.SET3.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetSET3_PSET6() uint32 {
	return (volatile.LoadUint32(&o.SET3.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetSET3_PSET7(value uint32) {
	volatile.StoreUint32(&o.SET3.Reg, volatile.LoadUint32(&o.SET3.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetSET3_PSET7() uint32 {
	return (volatile.LoadUint32(&o.SET3.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetSET3_PSET8(value uint32) {
	volatile.StoreUint32(&o.SET3.Reg, volatile.LoadUint32(&o.SET3.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetSET3_PSET8() uint32 {
	return (volatile.LoadUint32(&o.SET3.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetSET3_PSET9(value uint32) {
	volatile.StoreUint32(&o.SET3.Reg, volatile.LoadUint32(&o.SET3.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetSET3_PSET9() uint32 {
	return (volatile.LoadUint32(&o.SET3.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetSET3_PSET10(value uint32) {
	volatile.StoreUint32(&o.SET3.Reg, volatile.LoadUint32(&o.SET3.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetSET3_PSET10() uint32 {
	return (volatile.LoadUint32(&o.SET3.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetSET3_PSET11(value uint32) {
	volatile.StoreUint32(&o.SET3.Reg, volatile.LoadUint32(&o.SET3.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetSET3_PSET11() uint32 {
	return (volatile.LoadUint32(&o.SET3.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetSET3_PSET12(value uint32) {
	volatile.StoreUint32(&o.SET3.Reg, volatile.LoadUint32(&o.SET3.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetSET3_PSET12() uint32 {
	return (volatile.LoadUint32(&o.SET3.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetSET3_PSET13(value uint32) {
	volatile.StoreUint32(&o.SET3.Reg, volatile.LoadUint32(&o.SET3.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetSET3_PSET13() uint32 {
	return (volatile.LoadUint32(&o.SET3.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetSET3_PSET14(value uint32) {
	volatile.StoreUint32(&o.SET3.Reg, volatile.LoadUint32(&o.SET3.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetSET3_PSET14() uint32 {
	return (volatile.LoadUint32(&o.SET3.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetSET3_PSET15(value uint32) {
	volatile.StoreUint32(&o.SET3.Reg, volatile.LoadUint32(&o.SET3.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetSET3_PSET15() uint32 {
	return (volatile.LoadUint32(&o.SET3.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetSET3_PSET16(value uint32) {
	volatile.StoreUint32(&o.SET3.Reg, volatile.LoadUint32(&o.SET3.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetSET3_PSET16() uint32 {
	return (volatile.LoadUint32(&o.SET3.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetSET3_PSET17(value uint32) {
	volatile.StoreUint32(&o.SET3.Reg, volatile.LoadUint32(&o.SET3.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetSET3_PSET17() uint32 {
	return (volatile.LoadUint32(&o.SET3.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetSET3_PSET18(value uint32) {
	volatile.StoreUint32(&o.SET3.Reg, volatile.LoadUint32(&o.SET3.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetSET3_PSET18() uint32 {
	return (volatile.LoadUint32(&o.SET3.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetSET3_PSET19(value uint32) {
	volatile.StoreUint32(&o.SET3.Reg, volatile.LoadUint32(&o.SET3.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetSET3_PSET19() uint32 {
	return (volatile.LoadUint32(&o.SET3.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetSET3_PSET20(value uint32) {
	volatile.StoreUint32(&o.SET3.Reg, volatile.LoadUint32(&o.SET3.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetSET3_PSET20() uint32 {
	return (volatile.LoadUint32(&o.SET3.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetSET3_PSET21(value uint32) {
	volatile.StoreUint32(&o.SET3.Reg, volatile.LoadUint32(&o.SET3.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetSET3_PSET21() uint32 {
	return (volatile.LoadUint32(&o.SET3.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetSET3_PSET22(value uint32) {
	volatile.StoreUint32(&o.SET3.Reg, volatile.LoadUint32(&o.SET3.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetSET3_PSET22() uint32 {
	return (volatile.LoadUint32(&o.SET3.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetSET3_PSET23(value uint32) {
	volatile.StoreUint32(&o.SET3.Reg, volatile.LoadUint32(&o.SET3.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetSET3_PSET23() uint32 {
	return (volatile.LoadUint32(&o.SET3.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetSET3_PSET24(value uint32) {
	volatile.StoreUint32(&o.SET3.Reg, volatile.LoadUint32(&o.SET3.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetSET3_PSET24() uint32 {
	return (volatile.LoadUint32(&o.SET3.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetSET3_PSET25(value uint32) {
	volatile.StoreUint32(&o.SET3.Reg, volatile.LoadUint32(&o.SET3.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetSET3_PSET25() uint32 {
	return (volatile.LoadUint32(&o.SET3.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetSET3_PSET26(value uint32) {
	volatile.StoreUint32(&o.SET3.Reg, volatile.LoadUint32(&o.SET3.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetSET3_PSET26() uint32 {
	return (volatile.LoadUint32(&o.SET3.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetSET3_PSET27(value uint32) {
	volatile.StoreUint32(&o.SET3.Reg, volatile.LoadUint32(&o.SET3.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetSET3_PSET27() uint32 {
	return (volatile.LoadUint32(&o.SET3.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetSET3_PSET28(value uint32) {
	volatile.StoreUint32(&o.SET3.Reg, volatile.LoadUint32(&o.SET3.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetSET3_PSET28() uint32 {
	return (volatile.LoadUint32(&o.SET3.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetSET3_PSET29(value uint32) {
	volatile.StoreUint32(&o.SET3.Reg, volatile.LoadUint32(&o.SET3.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetSET3_PSET29() uint32 {
	return (volatile.LoadUint32(&o.SET3.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetSET3_PSET30(value uint32) {
	volatile.StoreUint32(&o.SET3.Reg, volatile.LoadUint32(&o.SET3.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetSET3_PSET30() uint32 {
	return (volatile.LoadUint32(&o.SET3.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetSET3_PSET31(value uint32) {
	volatile.StoreUint32(&o.SET3.Reg, volatile.LoadUint32(&o.SET3.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetSET3_PSET31() uint32 {
	return (volatile.LoadUint32(&o.SET3.Reg) & 0x80000000) >> 31
}

// GPIO.CLR3: Port Output Clear register using MASK.
func (o *GPIO_Type) SetCLR3_PCLR0(value uint32) {
	volatile.StoreUint32(&o.CLR3.Reg, volatile.LoadUint32(&o.CLR3.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetCLR3_PCLR0() uint32 {
	return volatile.LoadUint32(&o.CLR3.Reg) & 0x1
}
func (o *GPIO_Type) SetCLR3_PCLR1(value uint32) {
	volatile.StoreUint32(&o.CLR3.Reg, volatile.LoadUint32(&o.CLR3.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetCLR3_PCLR1() uint32 {
	return (volatile.LoadUint32(&o.CLR3.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetCLR3_PCLR2(value uint32) {
	volatile.StoreUint32(&o.CLR3.Reg, volatile.LoadUint32(&o.CLR3.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetCLR3_PCLR2() uint32 {
	return (volatile.LoadUint32(&o.CLR3.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetCLR3_PCLR3(value uint32) {
	volatile.StoreUint32(&o.CLR3.Reg, volatile.LoadUint32(&o.CLR3.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetCLR3_PCLR3() uint32 {
	return (volatile.LoadUint32(&o.CLR3.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetCLR3_PCLR4(value uint32) {
	volatile.StoreUint32(&o.CLR3.Reg, volatile.LoadUint32(&o.CLR3.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetCLR3_PCLR4() uint32 {
	return (volatile.LoadUint32(&o.CLR3.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetCLR3_PCLR5(value uint32) {
	volatile.StoreUint32(&o.CLR3.Reg, volatile.LoadUint32(&o.CLR3.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetCLR3_PCLR5() uint32 {
	return (volatile.LoadUint32(&o.CLR3.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetCLR3_PCLR6(value uint32) {
	volatile.StoreUint32(&o.CLR3.Reg, volatile.LoadUint32(&o.CLR3.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetCLR3_PCLR6() uint32 {
	return (volatile.LoadUint32(&o.CLR3.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetCLR3_PCLR7(value uint32) {
	volatile.StoreUint32(&o.CLR3.Reg, volatile.LoadUint32(&o.CLR3.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetCLR3_PCLR7() uint32 {
	return (volatile.LoadUint32(&o.CLR3.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetCLR3_PCLR8(value uint32) {
	volatile.StoreUint32(&o.CLR3.Reg, volatile.LoadUint32(&o.CLR3.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetCLR3_PCLR8() uint32 {
	return (volatile.LoadUint32(&o.CLR3.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetCLR3_PCLR9(value uint32) {
	volatile.StoreUint32(&o.CLR3.Reg, volatile.LoadUint32(&o.CLR3.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetCLR3_PCLR9() uint32 {
	return (volatile.LoadUint32(&o.CLR3.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetCLR3_PCLR10(value uint32) {
	volatile.StoreUint32(&o.CLR3.Reg, volatile.LoadUint32(&o.CLR3.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetCLR3_PCLR10() uint32 {
	return (volatile.LoadUint32(&o.CLR3.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetCLR3_PCLR11(value uint32) {
	volatile.StoreUint32(&o.CLR3.Reg, volatile.LoadUint32(&o.CLR3.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetCLR3_PCLR11() uint32 {
	return (volatile.LoadUint32(&o.CLR3.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetCLR3_PCLR12(value uint32) {
	volatile.StoreUint32(&o.CLR3.Reg, volatile.LoadUint32(&o.CLR3.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetCLR3_PCLR12() uint32 {
	return (volatile.LoadUint32(&o.CLR3.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetCLR3_PCLR13(value uint32) {
	volatile.StoreUint32(&o.CLR3.Reg, volatile.LoadUint32(&o.CLR3.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetCLR3_PCLR13() uint32 {
	return (volatile.LoadUint32(&o.CLR3.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetCLR3_PCLR14(value uint32) {
	volatile.StoreUint32(&o.CLR3.Reg, volatile.LoadUint32(&o.CLR3.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetCLR3_PCLR14() uint32 {
	return (volatile.LoadUint32(&o.CLR3.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetCLR3_PCLR15(value uint32) {
	volatile.StoreUint32(&o.CLR3.Reg, volatile.LoadUint32(&o.CLR3.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetCLR3_PCLR15() uint32 {
	return (volatile.LoadUint32(&o.CLR3.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetCLR3_PCLR16(value uint32) {
	volatile.StoreUint32(&o.CLR3.Reg, volatile.LoadUint32(&o.CLR3.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetCLR3_PCLR16() uint32 {
	return (volatile.LoadUint32(&o.CLR3.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetCLR3_PCLR17(value uint32) {
	volatile.StoreUint32(&o.CLR3.Reg, volatile.LoadUint32(&o.CLR3.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetCLR3_PCLR17() uint32 {
	return (volatile.LoadUint32(&o.CLR3.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetCLR3_PCLR18(value uint32) {
	volatile.StoreUint32(&o.CLR3.Reg, volatile.LoadUint32(&o.CLR3.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetCLR3_PCLR18() uint32 {
	return (volatile.LoadUint32(&o.CLR3.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetCLR3_PCLR19(value uint32) {
	volatile.StoreUint32(&o.CLR3.Reg, volatile.LoadUint32(&o.CLR3.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetCLR3_PCLR19() uint32 {
	return (volatile.LoadUint32(&o.CLR3.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetCLR3_PCLR20(value uint32) {
	volatile.StoreUint32(&o.CLR3.Reg, volatile.LoadUint32(&o.CLR3.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetCLR3_PCLR20() uint32 {
	return (volatile.LoadUint32(&o.CLR3.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetCLR3_PCLR21(value uint32) {
	volatile.StoreUint32(&o.CLR3.Reg, volatile.LoadUint32(&o.CLR3.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetCLR3_PCLR21() uint32 {
	return (volatile.LoadUint32(&o.CLR3.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetCLR3_PCLR22(value uint32) {
	volatile.StoreUint32(&o.CLR3.Reg, volatile.LoadUint32(&o.CLR3.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetCLR3_PCLR22() uint32 {
	return (volatile.LoadUint32(&o.CLR3.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetCLR3_PCLR23(value uint32) {
	volatile.StoreUint32(&o.CLR3.Reg, volatile.LoadUint32(&o.CLR3.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetCLR3_PCLR23() uint32 {
	return (volatile.LoadUint32(&o.CLR3.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetCLR3_PCLR24(value uint32) {
	volatile.StoreUint32(&o.CLR3.Reg, volatile.LoadUint32(&o.CLR3.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetCLR3_PCLR24() uint32 {
	return (volatile.LoadUint32(&o.CLR3.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetCLR3_PCLR25(value uint32) {
	volatile.StoreUint32(&o.CLR3.Reg, volatile.LoadUint32(&o.CLR3.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetCLR3_PCLR25() uint32 {
	return (volatile.LoadUint32(&o.CLR3.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetCLR3_PCLR26(value uint32) {
	volatile.StoreUint32(&o.CLR3.Reg, volatile.LoadUint32(&o.CLR3.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetCLR3_PCLR26() uint32 {
	return (volatile.LoadUint32(&o.CLR3.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetCLR3_PCLR27(value uint32) {
	volatile.StoreUint32(&o.CLR3.Reg, volatile.LoadUint32(&o.CLR3.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetCLR3_PCLR27() uint32 {
	return (volatile.LoadUint32(&o.CLR3.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetCLR3_PCLR28(value uint32) {
	volatile.StoreUint32(&o.CLR3.Reg, volatile.LoadUint32(&o.CLR3.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetCLR3_PCLR28() uint32 {
	return (volatile.LoadUint32(&o.CLR3.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetCLR3_PCLR29(value uint32) {
	volatile.StoreUint32(&o.CLR3.Reg, volatile.LoadUint32(&o.CLR3.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetCLR3_PCLR29() uint32 {
	return (volatile.LoadUint32(&o.CLR3.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetCLR3_PCLR30(value uint32) {
	volatile.StoreUint32(&o.CLR3.Reg, volatile.LoadUint32(&o.CLR3.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetCLR3_PCLR30() uint32 {
	return (volatile.LoadUint32(&o.CLR3.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetCLR3_PCLR31(value uint32) {
	volatile.StoreUint32(&o.CLR3.Reg, volatile.LoadUint32(&o.CLR3.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetCLR3_PCLR31() uint32 {
	return (volatile.LoadUint32(&o.CLR3.Reg) & 0x80000000) >> 31
}

// GPIO.DIR4: GPIO Port Direction control register.
func (o *GPIO_Type) SetDIR4_PDIR0(value uint32) {
	volatile.StoreUint32(&o.DIR4.Reg, volatile.LoadUint32(&o.DIR4.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetDIR4_PDIR0() uint32 {
	return volatile.LoadUint32(&o.DIR4.Reg) & 0x1
}
func (o *GPIO_Type) SetDIR4_PDIR1(value uint32) {
	volatile.StoreUint32(&o.DIR4.Reg, volatile.LoadUint32(&o.DIR4.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetDIR4_PDIR1() uint32 {
	return (volatile.LoadUint32(&o.DIR4.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetDIR4_PDIR2(value uint32) {
	volatile.StoreUint32(&o.DIR4.Reg, volatile.LoadUint32(&o.DIR4.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetDIR4_PDIR2() uint32 {
	return (volatile.LoadUint32(&o.DIR4.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetDIR4_PDIR3(value uint32) {
	volatile.StoreUint32(&o.DIR4.Reg, volatile.LoadUint32(&o.DIR4.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetDIR4_PDIR3() uint32 {
	return (volatile.LoadUint32(&o.DIR4.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetDIR4_PDIR4(value uint32) {
	volatile.StoreUint32(&o.DIR4.Reg, volatile.LoadUint32(&o.DIR4.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetDIR4_PDIR4() uint32 {
	return (volatile.LoadUint32(&o.DIR4.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetDIR4_PDIR5(value uint32) {
	volatile.StoreUint32(&o.DIR4.Reg, volatile.LoadUint32(&o.DIR4.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetDIR4_PDIR5() uint32 {
	return (volatile.LoadUint32(&o.DIR4.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetDIR4_PDIR6(value uint32) {
	volatile.StoreUint32(&o.DIR4.Reg, volatile.LoadUint32(&o.DIR4.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetDIR4_PDIR6() uint32 {
	return (volatile.LoadUint32(&o.DIR4.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetDIR4_PDIR7(value uint32) {
	volatile.StoreUint32(&o.DIR4.Reg, volatile.LoadUint32(&o.DIR4.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetDIR4_PDIR7() uint32 {
	return (volatile.LoadUint32(&o.DIR4.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetDIR4_PDIR8(value uint32) {
	volatile.StoreUint32(&o.DIR4.Reg, volatile.LoadUint32(&o.DIR4.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetDIR4_PDIR8() uint32 {
	return (volatile.LoadUint32(&o.DIR4.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetDIR4_PDIR9(value uint32) {
	volatile.StoreUint32(&o.DIR4.Reg, volatile.LoadUint32(&o.DIR4.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetDIR4_PDIR9() uint32 {
	return (volatile.LoadUint32(&o.DIR4.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetDIR4_PDIR10(value uint32) {
	volatile.StoreUint32(&o.DIR4.Reg, volatile.LoadUint32(&o.DIR4.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetDIR4_PDIR10() uint32 {
	return (volatile.LoadUint32(&o.DIR4.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetDIR4_PDIR11(value uint32) {
	volatile.StoreUint32(&o.DIR4.Reg, volatile.LoadUint32(&o.DIR4.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetDIR4_PDIR11() uint32 {
	return (volatile.LoadUint32(&o.DIR4.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetDIR4_PDIR12(value uint32) {
	volatile.StoreUint32(&o.DIR4.Reg, volatile.LoadUint32(&o.DIR4.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetDIR4_PDIR12() uint32 {
	return (volatile.LoadUint32(&o.DIR4.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetDIR4_PDIR13(value uint32) {
	volatile.StoreUint32(&o.DIR4.Reg, volatile.LoadUint32(&o.DIR4.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetDIR4_PDIR13() uint32 {
	return (volatile.LoadUint32(&o.DIR4.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetDIR4_PDIR14(value uint32) {
	volatile.StoreUint32(&o.DIR4.Reg, volatile.LoadUint32(&o.DIR4.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetDIR4_PDIR14() uint32 {
	return (volatile.LoadUint32(&o.DIR4.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetDIR4_PDIR15(value uint32) {
	volatile.StoreUint32(&o.DIR4.Reg, volatile.LoadUint32(&o.DIR4.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetDIR4_PDIR15() uint32 {
	return (volatile.LoadUint32(&o.DIR4.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetDIR4_PDIR16(value uint32) {
	volatile.StoreUint32(&o.DIR4.Reg, volatile.LoadUint32(&o.DIR4.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetDIR4_PDIR16() uint32 {
	return (volatile.LoadUint32(&o.DIR4.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetDIR4_PDIR17(value uint32) {
	volatile.StoreUint32(&o.DIR4.Reg, volatile.LoadUint32(&o.DIR4.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetDIR4_PDIR17() uint32 {
	return (volatile.LoadUint32(&o.DIR4.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetDIR4_PDIR18(value uint32) {
	volatile.StoreUint32(&o.DIR4.Reg, volatile.LoadUint32(&o.DIR4.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetDIR4_PDIR18() uint32 {
	return (volatile.LoadUint32(&o.DIR4.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetDIR4_PDIR19(value uint32) {
	volatile.StoreUint32(&o.DIR4.Reg, volatile.LoadUint32(&o.DIR4.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetDIR4_PDIR19() uint32 {
	return (volatile.LoadUint32(&o.DIR4.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetDIR4_PDIR20(value uint32) {
	volatile.StoreUint32(&o.DIR4.Reg, volatile.LoadUint32(&o.DIR4.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetDIR4_PDIR20() uint32 {
	return (volatile.LoadUint32(&o.DIR4.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetDIR4_PDIR21(value uint32) {
	volatile.StoreUint32(&o.DIR4.Reg, volatile.LoadUint32(&o.DIR4.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetDIR4_PDIR21() uint32 {
	return (volatile.LoadUint32(&o.DIR4.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetDIR4_PDIR22(value uint32) {
	volatile.StoreUint32(&o.DIR4.Reg, volatile.LoadUint32(&o.DIR4.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetDIR4_PDIR22() uint32 {
	return (volatile.LoadUint32(&o.DIR4.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetDIR4_PDIR23(value uint32) {
	volatile.StoreUint32(&o.DIR4.Reg, volatile.LoadUint32(&o.DIR4.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetDIR4_PDIR23() uint32 {
	return (volatile.LoadUint32(&o.DIR4.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetDIR4_PDIR24(value uint32) {
	volatile.StoreUint32(&o.DIR4.Reg, volatile.LoadUint32(&o.DIR4.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetDIR4_PDIR24() uint32 {
	return (volatile.LoadUint32(&o.DIR4.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetDIR4_PDIR25(value uint32) {
	volatile.StoreUint32(&o.DIR4.Reg, volatile.LoadUint32(&o.DIR4.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetDIR4_PDIR25() uint32 {
	return (volatile.LoadUint32(&o.DIR4.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetDIR4_PDIR26(value uint32) {
	volatile.StoreUint32(&o.DIR4.Reg, volatile.LoadUint32(&o.DIR4.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetDIR4_PDIR26() uint32 {
	return (volatile.LoadUint32(&o.DIR4.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetDIR4_PDIR27(value uint32) {
	volatile.StoreUint32(&o.DIR4.Reg, volatile.LoadUint32(&o.DIR4.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetDIR4_PDIR27() uint32 {
	return (volatile.LoadUint32(&o.DIR4.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetDIR4_PDIR28(value uint32) {
	volatile.StoreUint32(&o.DIR4.Reg, volatile.LoadUint32(&o.DIR4.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetDIR4_PDIR28() uint32 {
	return (volatile.LoadUint32(&o.DIR4.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetDIR4_PDIR29(value uint32) {
	volatile.StoreUint32(&o.DIR4.Reg, volatile.LoadUint32(&o.DIR4.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetDIR4_PDIR29() uint32 {
	return (volatile.LoadUint32(&o.DIR4.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetDIR4_PDIR30(value uint32) {
	volatile.StoreUint32(&o.DIR4.Reg, volatile.LoadUint32(&o.DIR4.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetDIR4_PDIR30() uint32 {
	return (volatile.LoadUint32(&o.DIR4.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetDIR4_PDIR31(value uint32) {
	volatile.StoreUint32(&o.DIR4.Reg, volatile.LoadUint32(&o.DIR4.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetDIR4_PDIR31() uint32 {
	return (volatile.LoadUint32(&o.DIR4.Reg) & 0x80000000) >> 31
}

// GPIO.MASK4: Mask register for Port.
func (o *GPIO_Type) SetMASK4_PMASK0(value uint32) {
	volatile.StoreUint32(&o.MASK4.Reg, volatile.LoadUint32(&o.MASK4.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetMASK4_PMASK0() uint32 {
	return volatile.LoadUint32(&o.MASK4.Reg) & 0x1
}
func (o *GPIO_Type) SetMASK4_PMASK1(value uint32) {
	volatile.StoreUint32(&o.MASK4.Reg, volatile.LoadUint32(&o.MASK4.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetMASK4_PMASK1() uint32 {
	return (volatile.LoadUint32(&o.MASK4.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetMASK4_PMASK2(value uint32) {
	volatile.StoreUint32(&o.MASK4.Reg, volatile.LoadUint32(&o.MASK4.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetMASK4_PMASK2() uint32 {
	return (volatile.LoadUint32(&o.MASK4.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetMASK4_PMASK3(value uint32) {
	volatile.StoreUint32(&o.MASK4.Reg, volatile.LoadUint32(&o.MASK4.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetMASK4_PMASK3() uint32 {
	return (volatile.LoadUint32(&o.MASK4.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetMASK4_PMASK4(value uint32) {
	volatile.StoreUint32(&o.MASK4.Reg, volatile.LoadUint32(&o.MASK4.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetMASK4_PMASK4() uint32 {
	return (volatile.LoadUint32(&o.MASK4.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetMASK4_PMASK5(value uint32) {
	volatile.StoreUint32(&o.MASK4.Reg, volatile.LoadUint32(&o.MASK4.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetMASK4_PMASK5() uint32 {
	return (volatile.LoadUint32(&o.MASK4.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetMASK4_PMASK6(value uint32) {
	volatile.StoreUint32(&o.MASK4.Reg, volatile.LoadUint32(&o.MASK4.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetMASK4_PMASK6() uint32 {
	return (volatile.LoadUint32(&o.MASK4.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetMASK4_PMASK7(value uint32) {
	volatile.StoreUint32(&o.MASK4.Reg, volatile.LoadUint32(&o.MASK4.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetMASK4_PMASK7() uint32 {
	return (volatile.LoadUint32(&o.MASK4.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetMASK4_PMASK8(value uint32) {
	volatile.StoreUint32(&o.MASK4.Reg, volatile.LoadUint32(&o.MASK4.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetMASK4_PMASK8() uint32 {
	return (volatile.LoadUint32(&o.MASK4.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetMASK4_PMASK9(value uint32) {
	volatile.StoreUint32(&o.MASK4.Reg, volatile.LoadUint32(&o.MASK4.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetMASK4_PMASK9() uint32 {
	return (volatile.LoadUint32(&o.MASK4.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetMASK4_PMASK10(value uint32) {
	volatile.StoreUint32(&o.MASK4.Reg, volatile.LoadUint32(&o.MASK4.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetMASK4_PMASK10() uint32 {
	return (volatile.LoadUint32(&o.MASK4.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetMASK4_PMASK11(value uint32) {
	volatile.StoreUint32(&o.MASK4.Reg, volatile.LoadUint32(&o.MASK4.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetMASK4_PMASK11() uint32 {
	return (volatile.LoadUint32(&o.MASK4.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetMASK4_PMASK12(value uint32) {
	volatile.StoreUint32(&o.MASK4.Reg, volatile.LoadUint32(&o.MASK4.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetMASK4_PMASK12() uint32 {
	return (volatile.LoadUint32(&o.MASK4.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetMASK4_PMASK13(value uint32) {
	volatile.StoreUint32(&o.MASK4.Reg, volatile.LoadUint32(&o.MASK4.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetMASK4_PMASK13() uint32 {
	return (volatile.LoadUint32(&o.MASK4.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetMASK4_PMASK14(value uint32) {
	volatile.StoreUint32(&o.MASK4.Reg, volatile.LoadUint32(&o.MASK4.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetMASK4_PMASK14() uint32 {
	return (volatile.LoadUint32(&o.MASK4.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetMASK4_PMASK15(value uint32) {
	volatile.StoreUint32(&o.MASK4.Reg, volatile.LoadUint32(&o.MASK4.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetMASK4_PMASK15() uint32 {
	return (volatile.LoadUint32(&o.MASK4.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetMASK4_PMASK16(value uint32) {
	volatile.StoreUint32(&o.MASK4.Reg, volatile.LoadUint32(&o.MASK4.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetMASK4_PMASK16() uint32 {
	return (volatile.LoadUint32(&o.MASK4.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetMASK4_PMASK17(value uint32) {
	volatile.StoreUint32(&o.MASK4.Reg, volatile.LoadUint32(&o.MASK4.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetMASK4_PMASK17() uint32 {
	return (volatile.LoadUint32(&o.MASK4.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetMASK4_PMASK18(value uint32) {
	volatile.StoreUint32(&o.MASK4.Reg, volatile.LoadUint32(&o.MASK4.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetMASK4_PMASK18() uint32 {
	return (volatile.LoadUint32(&o.MASK4.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetMASK4_PMASK19(value uint32) {
	volatile.StoreUint32(&o.MASK4.Reg, volatile.LoadUint32(&o.MASK4.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetMASK4_PMASK19() uint32 {
	return (volatile.LoadUint32(&o.MASK4.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetMASK4_PMASK20(value uint32) {
	volatile.StoreUint32(&o.MASK4.Reg, volatile.LoadUint32(&o.MASK4.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetMASK4_PMASK20() uint32 {
	return (volatile.LoadUint32(&o.MASK4.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetMASK4_PMASK21(value uint32) {
	volatile.StoreUint32(&o.MASK4.Reg, volatile.LoadUint32(&o.MASK4.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetMASK4_PMASK21() uint32 {
	return (volatile.LoadUint32(&o.MASK4.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetMASK4_PMASK22(value uint32) {
	volatile.StoreUint32(&o.MASK4.Reg, volatile.LoadUint32(&o.MASK4.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetMASK4_PMASK22() uint32 {
	return (volatile.LoadUint32(&o.MASK4.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetMASK4_PMASK23(value uint32) {
	volatile.StoreUint32(&o.MASK4.Reg, volatile.LoadUint32(&o.MASK4.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetMASK4_PMASK23() uint32 {
	return (volatile.LoadUint32(&o.MASK4.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetMASK4_PMASK24(value uint32) {
	volatile.StoreUint32(&o.MASK4.Reg, volatile.LoadUint32(&o.MASK4.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetMASK4_PMASK24() uint32 {
	return (volatile.LoadUint32(&o.MASK4.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetMASK4_PMASK25(value uint32) {
	volatile.StoreUint32(&o.MASK4.Reg, volatile.LoadUint32(&o.MASK4.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetMASK4_PMASK25() uint32 {
	return (volatile.LoadUint32(&o.MASK4.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetMASK4_PMASK26(value uint32) {
	volatile.StoreUint32(&o.MASK4.Reg, volatile.LoadUint32(&o.MASK4.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetMASK4_PMASK26() uint32 {
	return (volatile.LoadUint32(&o.MASK4.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetMASK4_PMASK27(value uint32) {
	volatile.StoreUint32(&o.MASK4.Reg, volatile.LoadUint32(&o.MASK4.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetMASK4_PMASK27() uint32 {
	return (volatile.LoadUint32(&o.MASK4.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetMASK4_PMASK28(value uint32) {
	volatile.StoreUint32(&o.MASK4.Reg, volatile.LoadUint32(&o.MASK4.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetMASK4_PMASK28() uint32 {
	return (volatile.LoadUint32(&o.MASK4.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetMASK4_PMASK29(value uint32) {
	volatile.StoreUint32(&o.MASK4.Reg, volatile.LoadUint32(&o.MASK4.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetMASK4_PMASK29() uint32 {
	return (volatile.LoadUint32(&o.MASK4.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetMASK4_PMASK30(value uint32) {
	volatile.StoreUint32(&o.MASK4.Reg, volatile.LoadUint32(&o.MASK4.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetMASK4_PMASK30() uint32 {
	return (volatile.LoadUint32(&o.MASK4.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetMASK4_PMASK31(value uint32) {
	volatile.StoreUint32(&o.MASK4.Reg, volatile.LoadUint32(&o.MASK4.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetMASK4_PMASK31() uint32 {
	return (volatile.LoadUint32(&o.MASK4.Reg) & 0x80000000) >> 31
}

// GPIO.PIN4: Port Pin value register using MASK.
func (o *GPIO_Type) SetPIN4_VAL0(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetPIN4_VAL0() uint32 {
	return volatile.LoadUint32(&o.PIN4.Reg) & 0x1
}
func (o *GPIO_Type) SetPIN4_VAL1(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetPIN4_VAL1() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetPIN4_VAL2(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN4_VAL2() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN4_VAL3(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetPIN4_VAL3() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetPIN4_VAL4(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetPIN4_VAL4() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetPIN4_VAL5(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetPIN4_VAL5() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetPIN4_VAL6(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetPIN4_VAL6() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetPIN4_VAL7(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetPIN4_VAL7() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetPIN4_VAL8(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetPIN4_VAL8() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetPIN4_VAL9(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetPIN4_VAL9() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetPIN4_VAL10(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN4_VAL10() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN4_VAL11(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetPIN4_VAL11() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetPIN4_VAL12(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetPIN4_VAL12() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetPIN4_VAL13(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetPIN4_VAL13() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetPIN4_VAL14(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetPIN4_VAL14() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetPIN4_VAL15(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetPIN4_VAL15() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetPIN4_VAL16(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetPIN4_VAL16() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetPIN4_VAL17(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetPIN4_VAL17() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetPIN4_VAL18(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetPIN4_VAL18() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetPIN4_VAL19(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetPIN4_VAL19() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetPIN4_VAL20(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetPIN4_VAL20() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetPIN4_VAL21(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetPIN4_VAL21() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetPIN4_VAL22(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetPIN4_VAL22() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetPIN4_VAL23(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetPIN4_VAL23() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetPIN4_VAL24(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetPIN4_VAL24() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetPIN4_VAL25(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetPIN4_VAL25() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetPIN4_VAL26(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetPIN4_VAL26() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetPIN4_VAL27(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetPIN4_VAL27() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetPIN4_VAL28(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetPIN4_VAL28() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetPIN4_VAL29(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetPIN4_VAL29() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetPIN4_VAL30(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetPIN4_VAL30() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetPIN4_VAL31(value uint32) {
	volatile.StoreUint32(&o.PIN4.Reg, volatile.LoadUint32(&o.PIN4.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetPIN4_VAL31() uint32 {
	return (volatile.LoadUint32(&o.PIN4.Reg) & 0x80000000) >> 31
}

// GPIO.SET4: Port Output Set register using MASK.
func (o *GPIO_Type) SetSET4_PSET0(value uint32) {
	volatile.StoreUint32(&o.SET4.Reg, volatile.LoadUint32(&o.SET4.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetSET4_PSET0() uint32 {
	return volatile.LoadUint32(&o.SET4.Reg) & 0x1
}
func (o *GPIO_Type) SetSET4_PSET1(value uint32) {
	volatile.StoreUint32(&o.SET4.Reg, volatile.LoadUint32(&o.SET4.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetSET4_PSET1() uint32 {
	return (volatile.LoadUint32(&o.SET4.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetSET4_PSET2(value uint32) {
	volatile.StoreUint32(&o.SET4.Reg, volatile.LoadUint32(&o.SET4.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetSET4_PSET2() uint32 {
	return (volatile.LoadUint32(&o.SET4.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetSET4_PSET3(value uint32) {
	volatile.StoreUint32(&o.SET4.Reg, volatile.LoadUint32(&o.SET4.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetSET4_PSET3() uint32 {
	return (volatile.LoadUint32(&o.SET4.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetSET4_PSET4(value uint32) {
	volatile.StoreUint32(&o.SET4.Reg, volatile.LoadUint32(&o.SET4.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetSET4_PSET4() uint32 {
	return (volatile.LoadUint32(&o.SET4.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetSET4_PSET5(value uint32) {
	volatile.StoreUint32(&o.SET4.Reg, volatile.LoadUint32(&o.SET4.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetSET4_PSET5() uint32 {
	return (volatile.LoadUint32(&o.SET4.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetSET4_PSET6(value uint32) {
	volatile.StoreUint32(&o.SET4.Reg, volatile.LoadUint32(&o.SET4.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetSET4_PSET6() uint32 {
	return (volatile.LoadUint32(&o.SET4.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetSET4_PSET7(value uint32) {
	volatile.StoreUint32(&o.SET4.Reg, volatile.LoadUint32(&o.SET4.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetSET4_PSET7() uint32 {
	return (volatile.LoadUint32(&o.SET4.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetSET4_PSET8(value uint32) {
	volatile.StoreUint32(&o.SET4.Reg, volatile.LoadUint32(&o.SET4.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetSET4_PSET8() uint32 {
	return (volatile.LoadUint32(&o.SET4.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetSET4_PSET9(value uint32) {
	volatile.StoreUint32(&o.SET4.Reg, volatile.LoadUint32(&o.SET4.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetSET4_PSET9() uint32 {
	return (volatile.LoadUint32(&o.SET4.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetSET4_PSET10(value uint32) {
	volatile.StoreUint32(&o.SET4.Reg, volatile.LoadUint32(&o.SET4.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetSET4_PSET10() uint32 {
	return (volatile.LoadUint32(&o.SET4.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetSET4_PSET11(value uint32) {
	volatile.StoreUint32(&o.SET4.Reg, volatile.LoadUint32(&o.SET4.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetSET4_PSET11() uint32 {
	return (volatile.LoadUint32(&o.SET4.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetSET4_PSET12(value uint32) {
	volatile.StoreUint32(&o.SET4.Reg, volatile.LoadUint32(&o.SET4.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetSET4_PSET12() uint32 {
	return (volatile.LoadUint32(&o.SET4.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetSET4_PSET13(value uint32) {
	volatile.StoreUint32(&o.SET4.Reg, volatile.LoadUint32(&o.SET4.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetSET4_PSET13() uint32 {
	return (volatile.LoadUint32(&o.SET4.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetSET4_PSET14(value uint32) {
	volatile.StoreUint32(&o.SET4.Reg, volatile.LoadUint32(&o.SET4.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetSET4_PSET14() uint32 {
	return (volatile.LoadUint32(&o.SET4.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetSET4_PSET15(value uint32) {
	volatile.StoreUint32(&o.SET4.Reg, volatile.LoadUint32(&o.SET4.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetSET4_PSET15() uint32 {
	return (volatile.LoadUint32(&o.SET4.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetSET4_PSET16(value uint32) {
	volatile.StoreUint32(&o.SET4.Reg, volatile.LoadUint32(&o.SET4.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetSET4_PSET16() uint32 {
	return (volatile.LoadUint32(&o.SET4.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetSET4_PSET17(value uint32) {
	volatile.StoreUint32(&o.SET4.Reg, volatile.LoadUint32(&o.SET4.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetSET4_PSET17() uint32 {
	return (volatile.LoadUint32(&o.SET4.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetSET4_PSET18(value uint32) {
	volatile.StoreUint32(&o.SET4.Reg, volatile.LoadUint32(&o.SET4.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetSET4_PSET18() uint32 {
	return (volatile.LoadUint32(&o.SET4.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetSET4_PSET19(value uint32) {
	volatile.StoreUint32(&o.SET4.Reg, volatile.LoadUint32(&o.SET4.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetSET4_PSET19() uint32 {
	return (volatile.LoadUint32(&o.SET4.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetSET4_PSET20(value uint32) {
	volatile.StoreUint32(&o.SET4.Reg, volatile.LoadUint32(&o.SET4.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetSET4_PSET20() uint32 {
	return (volatile.LoadUint32(&o.SET4.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetSET4_PSET21(value uint32) {
	volatile.StoreUint32(&o.SET4.Reg, volatile.LoadUint32(&o.SET4.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetSET4_PSET21() uint32 {
	return (volatile.LoadUint32(&o.SET4.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetSET4_PSET22(value uint32) {
	volatile.StoreUint32(&o.SET4.Reg, volatile.LoadUint32(&o.SET4.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetSET4_PSET22() uint32 {
	return (volatile.LoadUint32(&o.SET4.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetSET4_PSET23(value uint32) {
	volatile.StoreUint32(&o.SET4.Reg, volatile.LoadUint32(&o.SET4.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetSET4_PSET23() uint32 {
	return (volatile.LoadUint32(&o.SET4.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetSET4_PSET24(value uint32) {
	volatile.StoreUint32(&o.SET4.Reg, volatile.LoadUint32(&o.SET4.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetSET4_PSET24() uint32 {
	return (volatile.LoadUint32(&o.SET4.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetSET4_PSET25(value uint32) {
	volatile.StoreUint32(&o.SET4.Reg, volatile.LoadUint32(&o.SET4.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetSET4_PSET25() uint32 {
	return (volatile.LoadUint32(&o.SET4.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetSET4_PSET26(value uint32) {
	volatile.StoreUint32(&o.SET4.Reg, volatile.LoadUint32(&o.SET4.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetSET4_PSET26() uint32 {
	return (volatile.LoadUint32(&o.SET4.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetSET4_PSET27(value uint32) {
	volatile.StoreUint32(&o.SET4.Reg, volatile.LoadUint32(&o.SET4.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetSET4_PSET27() uint32 {
	return (volatile.LoadUint32(&o.SET4.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetSET4_PSET28(value uint32) {
	volatile.StoreUint32(&o.SET4.Reg, volatile.LoadUint32(&o.SET4.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetSET4_PSET28() uint32 {
	return (volatile.LoadUint32(&o.SET4.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetSET4_PSET29(value uint32) {
	volatile.StoreUint32(&o.SET4.Reg, volatile.LoadUint32(&o.SET4.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetSET4_PSET29() uint32 {
	return (volatile.LoadUint32(&o.SET4.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetSET4_PSET30(value uint32) {
	volatile.StoreUint32(&o.SET4.Reg, volatile.LoadUint32(&o.SET4.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetSET4_PSET30() uint32 {
	return (volatile.LoadUint32(&o.SET4.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetSET4_PSET31(value uint32) {
	volatile.StoreUint32(&o.SET4.Reg, volatile.LoadUint32(&o.SET4.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetSET4_PSET31() uint32 {
	return (volatile.LoadUint32(&o.SET4.Reg) & 0x80000000) >> 31
}

// GPIO.CLR4: Port Output Clear register using MASK.
func (o *GPIO_Type) SetCLR4_PCLR0(value uint32) {
	volatile.StoreUint32(&o.CLR4.Reg, volatile.LoadUint32(&o.CLR4.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetCLR4_PCLR0() uint32 {
	return volatile.LoadUint32(&o.CLR4.Reg) & 0x1
}
func (o *GPIO_Type) SetCLR4_PCLR1(value uint32) {
	volatile.StoreUint32(&o.CLR4.Reg, volatile.LoadUint32(&o.CLR4.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetCLR4_PCLR1() uint32 {
	return (volatile.LoadUint32(&o.CLR4.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetCLR4_PCLR2(value uint32) {
	volatile.StoreUint32(&o.CLR4.Reg, volatile.LoadUint32(&o.CLR4.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetCLR4_PCLR2() uint32 {
	return (volatile.LoadUint32(&o.CLR4.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetCLR4_PCLR3(value uint32) {
	volatile.StoreUint32(&o.CLR4.Reg, volatile.LoadUint32(&o.CLR4.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetCLR4_PCLR3() uint32 {
	return (volatile.LoadUint32(&o.CLR4.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetCLR4_PCLR4(value uint32) {
	volatile.StoreUint32(&o.CLR4.Reg, volatile.LoadUint32(&o.CLR4.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetCLR4_PCLR4() uint32 {
	return (volatile.LoadUint32(&o.CLR4.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetCLR4_PCLR5(value uint32) {
	volatile.StoreUint32(&o.CLR4.Reg, volatile.LoadUint32(&o.CLR4.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetCLR4_PCLR5() uint32 {
	return (volatile.LoadUint32(&o.CLR4.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetCLR4_PCLR6(value uint32) {
	volatile.StoreUint32(&o.CLR4.Reg, volatile.LoadUint32(&o.CLR4.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetCLR4_PCLR6() uint32 {
	return (volatile.LoadUint32(&o.CLR4.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetCLR4_PCLR7(value uint32) {
	volatile.StoreUint32(&o.CLR4.Reg, volatile.LoadUint32(&o.CLR4.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetCLR4_PCLR7() uint32 {
	return (volatile.LoadUint32(&o.CLR4.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetCLR4_PCLR8(value uint32) {
	volatile.StoreUint32(&o.CLR4.Reg, volatile.LoadUint32(&o.CLR4.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetCLR4_PCLR8() uint32 {
	return (volatile.LoadUint32(&o.CLR4.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetCLR4_PCLR9(value uint32) {
	volatile.StoreUint32(&o.CLR4.Reg, volatile.LoadUint32(&o.CLR4.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetCLR4_PCLR9() uint32 {
	return (volatile.LoadUint32(&o.CLR4.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetCLR4_PCLR10(value uint32) {
	volatile.StoreUint32(&o.CLR4.Reg, volatile.LoadUint32(&o.CLR4.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetCLR4_PCLR10() uint32 {
	return (volatile.LoadUint32(&o.CLR4.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetCLR4_PCLR11(value uint32) {
	volatile.StoreUint32(&o.CLR4.Reg, volatile.LoadUint32(&o.CLR4.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetCLR4_PCLR11() uint32 {
	return (volatile.LoadUint32(&o.CLR4.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetCLR4_PCLR12(value uint32) {
	volatile.StoreUint32(&o.CLR4.Reg, volatile.LoadUint32(&o.CLR4.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetCLR4_PCLR12() uint32 {
	return (volatile.LoadUint32(&o.CLR4.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetCLR4_PCLR13(value uint32) {
	volatile.StoreUint32(&o.CLR4.Reg, volatile.LoadUint32(&o.CLR4.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetCLR4_PCLR13() uint32 {
	return (volatile.LoadUint32(&o.CLR4.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetCLR4_PCLR14(value uint32) {
	volatile.StoreUint32(&o.CLR4.Reg, volatile.LoadUint32(&o.CLR4.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetCLR4_PCLR14() uint32 {
	return (volatile.LoadUint32(&o.CLR4.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetCLR4_PCLR15(value uint32) {
	volatile.StoreUint32(&o.CLR4.Reg, volatile.LoadUint32(&o.CLR4.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetCLR4_PCLR15() uint32 {
	return (volatile.LoadUint32(&o.CLR4.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetCLR4_PCLR16(value uint32) {
	volatile.StoreUint32(&o.CLR4.Reg, volatile.LoadUint32(&o.CLR4.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetCLR4_PCLR16() uint32 {
	return (volatile.LoadUint32(&o.CLR4.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetCLR4_PCLR17(value uint32) {
	volatile.StoreUint32(&o.CLR4.Reg, volatile.LoadUint32(&o.CLR4.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetCLR4_PCLR17() uint32 {
	return (volatile.LoadUint32(&o.CLR4.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetCLR4_PCLR18(value uint32) {
	volatile.StoreUint32(&o.CLR4.Reg, volatile.LoadUint32(&o.CLR4.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetCLR4_PCLR18() uint32 {
	return (volatile.LoadUint32(&o.CLR4.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetCLR4_PCLR19(value uint32) {
	volatile.StoreUint32(&o.CLR4.Reg, volatile.LoadUint32(&o.CLR4.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetCLR4_PCLR19() uint32 {
	return (volatile.LoadUint32(&o.CLR4.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetCLR4_PCLR20(value uint32) {
	volatile.StoreUint32(&o.CLR4.Reg, volatile.LoadUint32(&o.CLR4.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetCLR4_PCLR20() uint32 {
	return (volatile.LoadUint32(&o.CLR4.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetCLR4_PCLR21(value uint32) {
	volatile.StoreUint32(&o.CLR4.Reg, volatile.LoadUint32(&o.CLR4.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetCLR4_PCLR21() uint32 {
	return (volatile.LoadUint32(&o.CLR4.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetCLR4_PCLR22(value uint32) {
	volatile.StoreUint32(&o.CLR4.Reg, volatile.LoadUint32(&o.CLR4.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetCLR4_PCLR22() uint32 {
	return (volatile.LoadUint32(&o.CLR4.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetCLR4_PCLR23(value uint32) {
	volatile.StoreUint32(&o.CLR4.Reg, volatile.LoadUint32(&o.CLR4.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetCLR4_PCLR23() uint32 {
	return (volatile.LoadUint32(&o.CLR4.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetCLR4_PCLR24(value uint32) {
	volatile.StoreUint32(&o.CLR4.Reg, volatile.LoadUint32(&o.CLR4.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetCLR4_PCLR24() uint32 {
	return (volatile.LoadUint32(&o.CLR4.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetCLR4_PCLR25(value uint32) {
	volatile.StoreUint32(&o.CLR4.Reg, volatile.LoadUint32(&o.CLR4.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetCLR4_PCLR25() uint32 {
	return (volatile.LoadUint32(&o.CLR4.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetCLR4_PCLR26(value uint32) {
	volatile.StoreUint32(&o.CLR4.Reg, volatile.LoadUint32(&o.CLR4.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetCLR4_PCLR26() uint32 {
	return (volatile.LoadUint32(&o.CLR4.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetCLR4_PCLR27(value uint32) {
	volatile.StoreUint32(&o.CLR4.Reg, volatile.LoadUint32(&o.CLR4.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetCLR4_PCLR27() uint32 {
	return (volatile.LoadUint32(&o.CLR4.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetCLR4_PCLR28(value uint32) {
	volatile.StoreUint32(&o.CLR4.Reg, volatile.LoadUint32(&o.CLR4.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetCLR4_PCLR28() uint32 {
	return (volatile.LoadUint32(&o.CLR4.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetCLR4_PCLR29(value uint32) {
	volatile.StoreUint32(&o.CLR4.Reg, volatile.LoadUint32(&o.CLR4.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetCLR4_PCLR29() uint32 {
	return (volatile.LoadUint32(&o.CLR4.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetCLR4_PCLR30(value uint32) {
	volatile.StoreUint32(&o.CLR4.Reg, volatile.LoadUint32(&o.CLR4.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetCLR4_PCLR30() uint32 {
	return (volatile.LoadUint32(&o.CLR4.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetCLR4_PCLR31(value uint32) {
	volatile.StoreUint32(&o.CLR4.Reg, volatile.LoadUint32(&o.CLR4.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetCLR4_PCLR31() uint32 {
	return (volatile.LoadUint32(&o.CLR4.Reg) & 0x80000000) >> 31
}

// GPIO.DIR5: GPIO Port Direction control register.
func (o *GPIO_Type) SetDIR5_PDIR0(value uint32) {
	volatile.StoreUint32(&o.DIR5.Reg, volatile.LoadUint32(&o.DIR5.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetDIR5_PDIR0() uint32 {
	return volatile.LoadUint32(&o.DIR5.Reg) & 0x1
}
func (o *GPIO_Type) SetDIR5_PDIR1(value uint32) {
	volatile.StoreUint32(&o.DIR5.Reg, volatile.LoadUint32(&o.DIR5.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetDIR5_PDIR1() uint32 {
	return (volatile.LoadUint32(&o.DIR5.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetDIR5_PDIR2(value uint32) {
	volatile.StoreUint32(&o.DIR5.Reg, volatile.LoadUint32(&o.DIR5.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetDIR5_PDIR2() uint32 {
	return (volatile.LoadUint32(&o.DIR5.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetDIR5_PDIR3(value uint32) {
	volatile.StoreUint32(&o.DIR5.Reg, volatile.LoadUint32(&o.DIR5.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetDIR5_PDIR3() uint32 {
	return (volatile.LoadUint32(&o.DIR5.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetDIR5_PDIR4(value uint32) {
	volatile.StoreUint32(&o.DIR5.Reg, volatile.LoadUint32(&o.DIR5.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetDIR5_PDIR4() uint32 {
	return (volatile.LoadUint32(&o.DIR5.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetDIR5_PDIR5(value uint32) {
	volatile.StoreUint32(&o.DIR5.Reg, volatile.LoadUint32(&o.DIR5.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetDIR5_PDIR5() uint32 {
	return (volatile.LoadUint32(&o.DIR5.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetDIR5_PDIR6(value uint32) {
	volatile.StoreUint32(&o.DIR5.Reg, volatile.LoadUint32(&o.DIR5.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetDIR5_PDIR6() uint32 {
	return (volatile.LoadUint32(&o.DIR5.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetDIR5_PDIR7(value uint32) {
	volatile.StoreUint32(&o.DIR5.Reg, volatile.LoadUint32(&o.DIR5.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetDIR5_PDIR7() uint32 {
	return (volatile.LoadUint32(&o.DIR5.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetDIR5_PDIR8(value uint32) {
	volatile.StoreUint32(&o.DIR5.Reg, volatile.LoadUint32(&o.DIR5.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetDIR5_PDIR8() uint32 {
	return (volatile.LoadUint32(&o.DIR5.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetDIR5_PDIR9(value uint32) {
	volatile.StoreUint32(&o.DIR5.Reg, volatile.LoadUint32(&o.DIR5.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetDIR5_PDIR9() uint32 {
	return (volatile.LoadUint32(&o.DIR5.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetDIR5_PDIR10(value uint32) {
	volatile.StoreUint32(&o.DIR5.Reg, volatile.LoadUint32(&o.DIR5.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetDIR5_PDIR10() uint32 {
	return (volatile.LoadUint32(&o.DIR5.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetDIR5_PDIR11(value uint32) {
	volatile.StoreUint32(&o.DIR5.Reg, volatile.LoadUint32(&o.DIR5.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetDIR5_PDIR11() uint32 {
	return (volatile.LoadUint32(&o.DIR5.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetDIR5_PDIR12(value uint32) {
	volatile.StoreUint32(&o.DIR5.Reg, volatile.LoadUint32(&o.DIR5.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetDIR5_PDIR12() uint32 {
	return (volatile.LoadUint32(&o.DIR5.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetDIR5_PDIR13(value uint32) {
	volatile.StoreUint32(&o.DIR5.Reg, volatile.LoadUint32(&o.DIR5.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetDIR5_PDIR13() uint32 {
	return (volatile.LoadUint32(&o.DIR5.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetDIR5_PDIR14(value uint32) {
	volatile.StoreUint32(&o.DIR5.Reg, volatile.LoadUint32(&o.DIR5.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetDIR5_PDIR14() uint32 {
	return (volatile.LoadUint32(&o.DIR5.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetDIR5_PDIR15(value uint32) {
	volatile.StoreUint32(&o.DIR5.Reg, volatile.LoadUint32(&o.DIR5.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetDIR5_PDIR15() uint32 {
	return (volatile.LoadUint32(&o.DIR5.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetDIR5_PDIR16(value uint32) {
	volatile.StoreUint32(&o.DIR5.Reg, volatile.LoadUint32(&o.DIR5.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetDIR5_PDIR16() uint32 {
	return (volatile.LoadUint32(&o.DIR5.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetDIR5_PDIR17(value uint32) {
	volatile.StoreUint32(&o.DIR5.Reg, volatile.LoadUint32(&o.DIR5.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetDIR5_PDIR17() uint32 {
	return (volatile.LoadUint32(&o.DIR5.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetDIR5_PDIR18(value uint32) {
	volatile.StoreUint32(&o.DIR5.Reg, volatile.LoadUint32(&o.DIR5.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetDIR5_PDIR18() uint32 {
	return (volatile.LoadUint32(&o.DIR5.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetDIR5_PDIR19(value uint32) {
	volatile.StoreUint32(&o.DIR5.Reg, volatile.LoadUint32(&o.DIR5.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetDIR5_PDIR19() uint32 {
	return (volatile.LoadUint32(&o.DIR5.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetDIR5_PDIR20(value uint32) {
	volatile.StoreUint32(&o.DIR5.Reg, volatile.LoadUint32(&o.DIR5.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetDIR5_PDIR20() uint32 {
	return (volatile.LoadUint32(&o.DIR5.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetDIR5_PDIR21(value uint32) {
	volatile.StoreUint32(&o.DIR5.Reg, volatile.LoadUint32(&o.DIR5.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetDIR5_PDIR21() uint32 {
	return (volatile.LoadUint32(&o.DIR5.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetDIR5_PDIR22(value uint32) {
	volatile.StoreUint32(&o.DIR5.Reg, volatile.LoadUint32(&o.DIR5.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetDIR5_PDIR22() uint32 {
	return (volatile.LoadUint32(&o.DIR5.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetDIR5_PDIR23(value uint32) {
	volatile.StoreUint32(&o.DIR5.Reg, volatile.LoadUint32(&o.DIR5.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetDIR5_PDIR23() uint32 {
	return (volatile.LoadUint32(&o.DIR5.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetDIR5_PDIR24(value uint32) {
	volatile.StoreUint32(&o.DIR5.Reg, volatile.LoadUint32(&o.DIR5.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetDIR5_PDIR24() uint32 {
	return (volatile.LoadUint32(&o.DIR5.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetDIR5_PDIR25(value uint32) {
	volatile.StoreUint32(&o.DIR5.Reg, volatile.LoadUint32(&o.DIR5.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetDIR5_PDIR25() uint32 {
	return (volatile.LoadUint32(&o.DIR5.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetDIR5_PDIR26(value uint32) {
	volatile.StoreUint32(&o.DIR5.Reg, volatile.LoadUint32(&o.DIR5.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetDIR5_PDIR26() uint32 {
	return (volatile.LoadUint32(&o.DIR5.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetDIR5_PDIR27(value uint32) {
	volatile.StoreUint32(&o.DIR5.Reg, volatile.LoadUint32(&o.DIR5.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetDIR5_PDIR27() uint32 {
	return (volatile.LoadUint32(&o.DIR5.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetDIR5_PDIR28(value uint32) {
	volatile.StoreUint32(&o.DIR5.Reg, volatile.LoadUint32(&o.DIR5.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetDIR5_PDIR28() uint32 {
	return (volatile.LoadUint32(&o.DIR5.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetDIR5_PDIR29(value uint32) {
	volatile.StoreUint32(&o.DIR5.Reg, volatile.LoadUint32(&o.DIR5.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetDIR5_PDIR29() uint32 {
	return (volatile.LoadUint32(&o.DIR5.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetDIR5_PDIR30(value uint32) {
	volatile.StoreUint32(&o.DIR5.Reg, volatile.LoadUint32(&o.DIR5.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetDIR5_PDIR30() uint32 {
	return (volatile.LoadUint32(&o.DIR5.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetDIR5_PDIR31(value uint32) {
	volatile.StoreUint32(&o.DIR5.Reg, volatile.LoadUint32(&o.DIR5.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetDIR5_PDIR31() uint32 {
	return (volatile.LoadUint32(&o.DIR5.Reg) & 0x80000000) >> 31
}

// GPIO.MASK5: Mask register for Port.
func (o *GPIO_Type) SetMASK5_PMASK0(value uint32) {
	volatile.StoreUint32(&o.MASK5.Reg, volatile.LoadUint32(&o.MASK5.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetMASK5_PMASK0() uint32 {
	return volatile.LoadUint32(&o.MASK5.Reg) & 0x1
}
func (o *GPIO_Type) SetMASK5_PMASK1(value uint32) {
	volatile.StoreUint32(&o.MASK5.Reg, volatile.LoadUint32(&o.MASK5.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetMASK5_PMASK1() uint32 {
	return (volatile.LoadUint32(&o.MASK5.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetMASK5_PMASK2(value uint32) {
	volatile.StoreUint32(&o.MASK5.Reg, volatile.LoadUint32(&o.MASK5.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetMASK5_PMASK2() uint32 {
	return (volatile.LoadUint32(&o.MASK5.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetMASK5_PMASK3(value uint32) {
	volatile.StoreUint32(&o.MASK5.Reg, volatile.LoadUint32(&o.MASK5.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetMASK5_PMASK3() uint32 {
	return (volatile.LoadUint32(&o.MASK5.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetMASK5_PMASK4(value uint32) {
	volatile.StoreUint32(&o.MASK5.Reg, volatile.LoadUint32(&o.MASK5.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetMASK5_PMASK4() uint32 {
	return (volatile.LoadUint32(&o.MASK5.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetMASK5_PMASK5(value uint32) {
	volatile.StoreUint32(&o.MASK5.Reg, volatile.LoadUint32(&o.MASK5.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetMASK5_PMASK5() uint32 {
	return (volatile.LoadUint32(&o.MASK5.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetMASK5_PMASK6(value uint32) {
	volatile.StoreUint32(&o.MASK5.Reg, volatile.LoadUint32(&o.MASK5.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetMASK5_PMASK6() uint32 {
	return (volatile.LoadUint32(&o.MASK5.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetMASK5_PMASK7(value uint32) {
	volatile.StoreUint32(&o.MASK5.Reg, volatile.LoadUint32(&o.MASK5.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetMASK5_PMASK7() uint32 {
	return (volatile.LoadUint32(&o.MASK5.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetMASK5_PMASK8(value uint32) {
	volatile.StoreUint32(&o.MASK5.Reg, volatile.LoadUint32(&o.MASK5.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetMASK5_PMASK8() uint32 {
	return (volatile.LoadUint32(&o.MASK5.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetMASK5_PMASK9(value uint32) {
	volatile.StoreUint32(&o.MASK5.Reg, volatile.LoadUint32(&o.MASK5.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetMASK5_PMASK9() uint32 {
	return (volatile.LoadUint32(&o.MASK5.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetMASK5_PMASK10(value uint32) {
	volatile.StoreUint32(&o.MASK5.Reg, volatile.LoadUint32(&o.MASK5.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetMASK5_PMASK10() uint32 {
	return (volatile.LoadUint32(&o.MASK5.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetMASK5_PMASK11(value uint32) {
	volatile.StoreUint32(&o.MASK5.Reg, volatile.LoadUint32(&o.MASK5.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetMASK5_PMASK11() uint32 {
	return (volatile.LoadUint32(&o.MASK5.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetMASK5_PMASK12(value uint32) {
	volatile.StoreUint32(&o.MASK5.Reg, volatile.LoadUint32(&o.MASK5.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetMASK5_PMASK12() uint32 {
	return (volatile.LoadUint32(&o.MASK5.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetMASK5_PMASK13(value uint32) {
	volatile.StoreUint32(&o.MASK5.Reg, volatile.LoadUint32(&o.MASK5.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetMASK5_PMASK13() uint32 {
	return (volatile.LoadUint32(&o.MASK5.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetMASK5_PMASK14(value uint32) {
	volatile.StoreUint32(&o.MASK5.Reg, volatile.LoadUint32(&o.MASK5.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetMASK5_PMASK14() uint32 {
	return (volatile.LoadUint32(&o.MASK5.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetMASK5_PMASK15(value uint32) {
	volatile.StoreUint32(&o.MASK5.Reg, volatile.LoadUint32(&o.MASK5.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetMASK5_PMASK15() uint32 {
	return (volatile.LoadUint32(&o.MASK5.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetMASK5_PMASK16(value uint32) {
	volatile.StoreUint32(&o.MASK5.Reg, volatile.LoadUint32(&o.MASK5.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetMASK5_PMASK16() uint32 {
	return (volatile.LoadUint32(&o.MASK5.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetMASK5_PMASK17(value uint32) {
	volatile.StoreUint32(&o.MASK5.Reg, volatile.LoadUint32(&o.MASK5.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetMASK5_PMASK17() uint32 {
	return (volatile.LoadUint32(&o.MASK5.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetMASK5_PMASK18(value uint32) {
	volatile.StoreUint32(&o.MASK5.Reg, volatile.LoadUint32(&o.MASK5.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetMASK5_PMASK18() uint32 {
	return (volatile.LoadUint32(&o.MASK5.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetMASK5_PMASK19(value uint32) {
	volatile.StoreUint32(&o.MASK5.Reg, volatile.LoadUint32(&o.MASK5.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetMASK5_PMASK19() uint32 {
	return (volatile.LoadUint32(&o.MASK5.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetMASK5_PMASK20(value uint32) {
	volatile.StoreUint32(&o.MASK5.Reg, volatile.LoadUint32(&o.MASK5.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetMASK5_PMASK20() uint32 {
	return (volatile.LoadUint32(&o.MASK5.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetMASK5_PMASK21(value uint32) {
	volatile.StoreUint32(&o.MASK5.Reg, volatile.LoadUint32(&o.MASK5.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetMASK5_PMASK21() uint32 {
	return (volatile.LoadUint32(&o.MASK5.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetMASK5_PMASK22(value uint32) {
	volatile.StoreUint32(&o.MASK5.Reg, volatile.LoadUint32(&o.MASK5.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetMASK5_PMASK22() uint32 {
	return (volatile.LoadUint32(&o.MASK5.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetMASK5_PMASK23(value uint32) {
	volatile.StoreUint32(&o.MASK5.Reg, volatile.LoadUint32(&o.MASK5.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetMASK5_PMASK23() uint32 {
	return (volatile.LoadUint32(&o.MASK5.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetMASK5_PMASK24(value uint32) {
	volatile.StoreUint32(&o.MASK5.Reg, volatile.LoadUint32(&o.MASK5.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetMASK5_PMASK24() uint32 {
	return (volatile.LoadUint32(&o.MASK5.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetMASK5_PMASK25(value uint32) {
	volatile.StoreUint32(&o.MASK5.Reg, volatile.LoadUint32(&o.MASK5.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetMASK5_PMASK25() uint32 {
	return (volatile.LoadUint32(&o.MASK5.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetMASK5_PMASK26(value uint32) {
	volatile.StoreUint32(&o.MASK5.Reg, volatile.LoadUint32(&o.MASK5.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetMASK5_PMASK26() uint32 {
	return (volatile.LoadUint32(&o.MASK5.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetMASK5_PMASK27(value uint32) {
	volatile.StoreUint32(&o.MASK5.Reg, volatile.LoadUint32(&o.MASK5.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetMASK5_PMASK27() uint32 {
	return (volatile.LoadUint32(&o.MASK5.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetMASK5_PMASK28(value uint32) {
	volatile.StoreUint32(&o.MASK5.Reg, volatile.LoadUint32(&o.MASK5.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetMASK5_PMASK28() uint32 {
	return (volatile.LoadUint32(&o.MASK5.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetMASK5_PMASK29(value uint32) {
	volatile.StoreUint32(&o.MASK5.Reg, volatile.LoadUint32(&o.MASK5.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetMASK5_PMASK29() uint32 {
	return (volatile.LoadUint32(&o.MASK5.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetMASK5_PMASK30(value uint32) {
	volatile.StoreUint32(&o.MASK5.Reg, volatile.LoadUint32(&o.MASK5.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetMASK5_PMASK30() uint32 {
	return (volatile.LoadUint32(&o.MASK5.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetMASK5_PMASK31(value uint32) {
	volatile.StoreUint32(&o.MASK5.Reg, volatile.LoadUint32(&o.MASK5.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetMASK5_PMASK31() uint32 {
	return (volatile.LoadUint32(&o.MASK5.Reg) & 0x80000000) >> 31
}

// GPIO.PIN5: Port Pin value register using MASK.
func (o *GPIO_Type) SetPIN5_VAL0(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetPIN5_VAL0() uint32 {
	return volatile.LoadUint32(&o.PIN5.Reg) & 0x1
}
func (o *GPIO_Type) SetPIN5_VAL1(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetPIN5_VAL1() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetPIN5_VAL2(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN5_VAL2() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN5_VAL3(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetPIN5_VAL3() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetPIN5_VAL4(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetPIN5_VAL4() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetPIN5_VAL5(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetPIN5_VAL5() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetPIN5_VAL6(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetPIN5_VAL6() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetPIN5_VAL7(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetPIN5_VAL7() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetPIN5_VAL8(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetPIN5_VAL8() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetPIN5_VAL9(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetPIN5_VAL9() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetPIN5_VAL10(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN5_VAL10() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN5_VAL11(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetPIN5_VAL11() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetPIN5_VAL12(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetPIN5_VAL12() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetPIN5_VAL13(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetPIN5_VAL13() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetPIN5_VAL14(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetPIN5_VAL14() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetPIN5_VAL15(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetPIN5_VAL15() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetPIN5_VAL16(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetPIN5_VAL16() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetPIN5_VAL17(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetPIN5_VAL17() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetPIN5_VAL18(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetPIN5_VAL18() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetPIN5_VAL19(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetPIN5_VAL19() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetPIN5_VAL20(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetPIN5_VAL20() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetPIN5_VAL21(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetPIN5_VAL21() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetPIN5_VAL22(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetPIN5_VAL22() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetPIN5_VAL23(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetPIN5_VAL23() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetPIN5_VAL24(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetPIN5_VAL24() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetPIN5_VAL25(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetPIN5_VAL25() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetPIN5_VAL26(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetPIN5_VAL26() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetPIN5_VAL27(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetPIN5_VAL27() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetPIN5_VAL28(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetPIN5_VAL28() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetPIN5_VAL29(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetPIN5_VAL29() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetPIN5_VAL30(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetPIN5_VAL30() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetPIN5_VAL31(value uint32) {
	volatile.StoreUint32(&o.PIN5.Reg, volatile.LoadUint32(&o.PIN5.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetPIN5_VAL31() uint32 {
	return (volatile.LoadUint32(&o.PIN5.Reg) & 0x80000000) >> 31
}

// GPIO.SET5: Port Output Set register using MASK.
func (o *GPIO_Type) SetSET5_PSET0(value uint32) {
	volatile.StoreUint32(&o.SET5.Reg, volatile.LoadUint32(&o.SET5.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetSET5_PSET0() uint32 {
	return volatile.LoadUint32(&o.SET5.Reg) & 0x1
}
func (o *GPIO_Type) SetSET5_PSET1(value uint32) {
	volatile.StoreUint32(&o.SET5.Reg, volatile.LoadUint32(&o.SET5.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetSET5_PSET1() uint32 {
	return (volatile.LoadUint32(&o.SET5.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetSET5_PSET2(value uint32) {
	volatile.StoreUint32(&o.SET5.Reg, volatile.LoadUint32(&o.SET5.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetSET5_PSET2() uint32 {
	return (volatile.LoadUint32(&o.SET5.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetSET5_PSET3(value uint32) {
	volatile.StoreUint32(&o.SET5.Reg, volatile.LoadUint32(&o.SET5.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetSET5_PSET3() uint32 {
	return (volatile.LoadUint32(&o.SET5.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetSET5_PSET4(value uint32) {
	volatile.StoreUint32(&o.SET5.Reg, volatile.LoadUint32(&o.SET5.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetSET5_PSET4() uint32 {
	return (volatile.LoadUint32(&o.SET5.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetSET5_PSET5(value uint32) {
	volatile.StoreUint32(&o.SET5.Reg, volatile.LoadUint32(&o.SET5.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetSET5_PSET5() uint32 {
	return (volatile.LoadUint32(&o.SET5.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetSET5_PSET6(value uint32) {
	volatile.StoreUint32(&o.SET5.Reg, volatile.LoadUint32(&o.SET5.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetSET5_PSET6() uint32 {
	return (volatile.LoadUint32(&o.SET5.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetSET5_PSET7(value uint32) {
	volatile.StoreUint32(&o.SET5.Reg, volatile.LoadUint32(&o.SET5.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetSET5_PSET7() uint32 {
	return (volatile.LoadUint32(&o.SET5.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetSET5_PSET8(value uint32) {
	volatile.StoreUint32(&o.SET5.Reg, volatile.LoadUint32(&o.SET5.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetSET5_PSET8() uint32 {
	return (volatile.LoadUint32(&o.SET5.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetSET5_PSET9(value uint32) {
	volatile.StoreUint32(&o.SET5.Reg, volatile.LoadUint32(&o.SET5.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetSET5_PSET9() uint32 {
	return (volatile.LoadUint32(&o.SET5.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetSET5_PSET10(value uint32) {
	volatile.StoreUint32(&o.SET5.Reg, volatile.LoadUint32(&o.SET5.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetSET5_PSET10() uint32 {
	return (volatile.LoadUint32(&o.SET5.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetSET5_PSET11(value uint32) {
	volatile.StoreUint32(&o.SET5.Reg, volatile.LoadUint32(&o.SET5.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetSET5_PSET11() uint32 {
	return (volatile.LoadUint32(&o.SET5.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetSET5_PSET12(value uint32) {
	volatile.StoreUint32(&o.SET5.Reg, volatile.LoadUint32(&o.SET5.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetSET5_PSET12() uint32 {
	return (volatile.LoadUint32(&o.SET5.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetSET5_PSET13(value uint32) {
	volatile.StoreUint32(&o.SET5.Reg, volatile.LoadUint32(&o.SET5.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetSET5_PSET13() uint32 {
	return (volatile.LoadUint32(&o.SET5.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetSET5_PSET14(value uint32) {
	volatile.StoreUint32(&o.SET5.Reg, volatile.LoadUint32(&o.SET5.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetSET5_PSET14() uint32 {
	return (volatile.LoadUint32(&o.SET5.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetSET5_PSET15(value uint32) {
	volatile.StoreUint32(&o.SET5.Reg, volatile.LoadUint32(&o.SET5.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetSET5_PSET15() uint32 {
	return (volatile.LoadUint32(&o.SET5.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetSET5_PSET16(value uint32) {
	volatile.StoreUint32(&o.SET5.Reg, volatile.LoadUint32(&o.SET5.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetSET5_PSET16() uint32 {
	return (volatile.LoadUint32(&o.SET5.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetSET5_PSET17(value uint32) {
	volatile.StoreUint32(&o.SET5.Reg, volatile.LoadUint32(&o.SET5.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetSET5_PSET17() uint32 {
	return (volatile.LoadUint32(&o.SET5.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetSET5_PSET18(value uint32) {
	volatile.StoreUint32(&o.SET5.Reg, volatile.LoadUint32(&o.SET5.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetSET5_PSET18() uint32 {
	return (volatile.LoadUint32(&o.SET5.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetSET5_PSET19(value uint32) {
	volatile.StoreUint32(&o.SET5.Reg, volatile.LoadUint32(&o.SET5.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetSET5_PSET19() uint32 {
	return (volatile.LoadUint32(&o.SET5.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetSET5_PSET20(value uint32) {
	volatile.StoreUint32(&o.SET5.Reg, volatile.LoadUint32(&o.SET5.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetSET5_PSET20() uint32 {
	return (volatile.LoadUint32(&o.SET5.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetSET5_PSET21(value uint32) {
	volatile.StoreUint32(&o.SET5.Reg, volatile.LoadUint32(&o.SET5.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetSET5_PSET21() uint32 {
	return (volatile.LoadUint32(&o.SET5.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetSET5_PSET22(value uint32) {
	volatile.StoreUint32(&o.SET5.Reg, volatile.LoadUint32(&o.SET5.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetSET5_PSET22() uint32 {
	return (volatile.LoadUint32(&o.SET5.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetSET5_PSET23(value uint32) {
	volatile.StoreUint32(&o.SET5.Reg, volatile.LoadUint32(&o.SET5.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetSET5_PSET23() uint32 {
	return (volatile.LoadUint32(&o.SET5.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetSET5_PSET24(value uint32) {
	volatile.StoreUint32(&o.SET5.Reg, volatile.LoadUint32(&o.SET5.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetSET5_PSET24() uint32 {
	return (volatile.LoadUint32(&o.SET5.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetSET5_PSET25(value uint32) {
	volatile.StoreUint32(&o.SET5.Reg, volatile.LoadUint32(&o.SET5.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetSET5_PSET25() uint32 {
	return (volatile.LoadUint32(&o.SET5.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetSET5_PSET26(value uint32) {
	volatile.StoreUint32(&o.SET5.Reg, volatile.LoadUint32(&o.SET5.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetSET5_PSET26() uint32 {
	return (volatile.LoadUint32(&o.SET5.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetSET5_PSET27(value uint32) {
	volatile.StoreUint32(&o.SET5.Reg, volatile.LoadUint32(&o.SET5.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetSET5_PSET27() uint32 {
	return (volatile.LoadUint32(&o.SET5.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetSET5_PSET28(value uint32) {
	volatile.StoreUint32(&o.SET5.Reg, volatile.LoadUint32(&o.SET5.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetSET5_PSET28() uint32 {
	return (volatile.LoadUint32(&o.SET5.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetSET5_PSET29(value uint32) {
	volatile.StoreUint32(&o.SET5.Reg, volatile.LoadUint32(&o.SET5.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetSET5_PSET29() uint32 {
	return (volatile.LoadUint32(&o.SET5.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetSET5_PSET30(value uint32) {
	volatile.StoreUint32(&o.SET5.Reg, volatile.LoadUint32(&o.SET5.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetSET5_PSET30() uint32 {
	return (volatile.LoadUint32(&o.SET5.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetSET5_PSET31(value uint32) {
	volatile.StoreUint32(&o.SET5.Reg, volatile.LoadUint32(&o.SET5.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetSET5_PSET31() uint32 {
	return (volatile.LoadUint32(&o.SET5.Reg) & 0x80000000) >> 31
}

// GPIO.CLR5: Port Output Clear register using MASK.
func (o *GPIO_Type) SetCLR5_PCLR0(value uint32) {
	volatile.StoreUint32(&o.CLR5.Reg, volatile.LoadUint32(&o.CLR5.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetCLR5_PCLR0() uint32 {
	return volatile.LoadUint32(&o.CLR5.Reg) & 0x1
}
func (o *GPIO_Type) SetCLR5_PCLR1(value uint32) {
	volatile.StoreUint32(&o.CLR5.Reg, volatile.LoadUint32(&o.CLR5.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetCLR5_PCLR1() uint32 {
	return (volatile.LoadUint32(&o.CLR5.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetCLR5_PCLR2(value uint32) {
	volatile.StoreUint32(&o.CLR5.Reg, volatile.LoadUint32(&o.CLR5.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetCLR5_PCLR2() uint32 {
	return (volatile.LoadUint32(&o.CLR5.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetCLR5_PCLR3(value uint32) {
	volatile.StoreUint32(&o.CLR5.Reg, volatile.LoadUint32(&o.CLR5.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetCLR5_PCLR3() uint32 {
	return (volatile.LoadUint32(&o.CLR5.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetCLR5_PCLR4(value uint32) {
	volatile.StoreUint32(&o.CLR5.Reg, volatile.LoadUint32(&o.CLR5.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetCLR5_PCLR4() uint32 {
	return (volatile.LoadUint32(&o.CLR5.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetCLR5_PCLR5(value uint32) {
	volatile.StoreUint32(&o.CLR5.Reg, volatile.LoadUint32(&o.CLR5.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetCLR5_PCLR5() uint32 {
	return (volatile.LoadUint32(&o.CLR5.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetCLR5_PCLR6(value uint32) {
	volatile.StoreUint32(&o.CLR5.Reg, volatile.LoadUint32(&o.CLR5.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetCLR5_PCLR6() uint32 {
	return (volatile.LoadUint32(&o.CLR5.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetCLR5_PCLR7(value uint32) {
	volatile.StoreUint32(&o.CLR5.Reg, volatile.LoadUint32(&o.CLR5.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetCLR5_PCLR7() uint32 {
	return (volatile.LoadUint32(&o.CLR5.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetCLR5_PCLR8(value uint32) {
	volatile.StoreUint32(&o.CLR5.Reg, volatile.LoadUint32(&o.CLR5.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetCLR5_PCLR8() uint32 {
	return (volatile.LoadUint32(&o.CLR5.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetCLR5_PCLR9(value uint32) {
	volatile.StoreUint32(&o.CLR5.Reg, volatile.LoadUint32(&o.CLR5.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetCLR5_PCLR9() uint32 {
	return (volatile.LoadUint32(&o.CLR5.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetCLR5_PCLR10(value uint32) {
	volatile.StoreUint32(&o.CLR5.Reg, volatile.LoadUint32(&o.CLR5.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetCLR5_PCLR10() uint32 {
	return (volatile.LoadUint32(&o.CLR5.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetCLR5_PCLR11(value uint32) {
	volatile.StoreUint32(&o.CLR5.Reg, volatile.LoadUint32(&o.CLR5.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetCLR5_PCLR11() uint32 {
	return (volatile.LoadUint32(&o.CLR5.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetCLR5_PCLR12(value uint32) {
	volatile.StoreUint32(&o.CLR5.Reg, volatile.LoadUint32(&o.CLR5.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetCLR5_PCLR12() uint32 {
	return (volatile.LoadUint32(&o.CLR5.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetCLR5_PCLR13(value uint32) {
	volatile.StoreUint32(&o.CLR5.Reg, volatile.LoadUint32(&o.CLR5.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetCLR5_PCLR13() uint32 {
	return (volatile.LoadUint32(&o.CLR5.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetCLR5_PCLR14(value uint32) {
	volatile.StoreUint32(&o.CLR5.Reg, volatile.LoadUint32(&o.CLR5.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetCLR5_PCLR14() uint32 {
	return (volatile.LoadUint32(&o.CLR5.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetCLR5_PCLR15(value uint32) {
	volatile.StoreUint32(&o.CLR5.Reg, volatile.LoadUint32(&o.CLR5.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetCLR5_PCLR15() uint32 {
	return (volatile.LoadUint32(&o.CLR5.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetCLR5_PCLR16(value uint32) {
	volatile.StoreUint32(&o.CLR5.Reg, volatile.LoadUint32(&o.CLR5.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetCLR5_PCLR16() uint32 {
	return (volatile.LoadUint32(&o.CLR5.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetCLR5_PCLR17(value uint32) {
	volatile.StoreUint32(&o.CLR5.Reg, volatile.LoadUint32(&o.CLR5.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetCLR5_PCLR17() uint32 {
	return (volatile.LoadUint32(&o.CLR5.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetCLR5_PCLR18(value uint32) {
	volatile.StoreUint32(&o.CLR5.Reg, volatile.LoadUint32(&o.CLR5.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetCLR5_PCLR18() uint32 {
	return (volatile.LoadUint32(&o.CLR5.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetCLR5_PCLR19(value uint32) {
	volatile.StoreUint32(&o.CLR5.Reg, volatile.LoadUint32(&o.CLR5.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetCLR5_PCLR19() uint32 {
	return (volatile.LoadUint32(&o.CLR5.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetCLR5_PCLR20(value uint32) {
	volatile.StoreUint32(&o.CLR5.Reg, volatile.LoadUint32(&o.CLR5.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetCLR5_PCLR20() uint32 {
	return (volatile.LoadUint32(&o.CLR5.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetCLR5_PCLR21(value uint32) {
	volatile.StoreUint32(&o.CLR5.Reg, volatile.LoadUint32(&o.CLR5.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetCLR5_PCLR21() uint32 {
	return (volatile.LoadUint32(&o.CLR5.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetCLR5_PCLR22(value uint32) {
	volatile.StoreUint32(&o.CLR5.Reg, volatile.LoadUint32(&o.CLR5.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetCLR5_PCLR22() uint32 {
	return (volatile.LoadUint32(&o.CLR5.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetCLR5_PCLR23(value uint32) {
	volatile.StoreUint32(&o.CLR5.Reg, volatile.LoadUint32(&o.CLR5.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetCLR5_PCLR23() uint32 {
	return (volatile.LoadUint32(&o.CLR5.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetCLR5_PCLR24(value uint32) {
	volatile.StoreUint32(&o.CLR5.Reg, volatile.LoadUint32(&o.CLR5.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetCLR5_PCLR24() uint32 {
	return (volatile.LoadUint32(&o.CLR5.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetCLR5_PCLR25(value uint32) {
	volatile.StoreUint32(&o.CLR5.Reg, volatile.LoadUint32(&o.CLR5.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetCLR5_PCLR25() uint32 {
	return (volatile.LoadUint32(&o.CLR5.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetCLR5_PCLR26(value uint32) {
	volatile.StoreUint32(&o.CLR5.Reg, volatile.LoadUint32(&o.CLR5.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetCLR5_PCLR26() uint32 {
	return (volatile.LoadUint32(&o.CLR5.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetCLR5_PCLR27(value uint32) {
	volatile.StoreUint32(&o.CLR5.Reg, volatile.LoadUint32(&o.CLR5.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetCLR5_PCLR27() uint32 {
	return (volatile.LoadUint32(&o.CLR5.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetCLR5_PCLR28(value uint32) {
	volatile.StoreUint32(&o.CLR5.Reg, volatile.LoadUint32(&o.CLR5.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetCLR5_PCLR28() uint32 {
	return (volatile.LoadUint32(&o.CLR5.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetCLR5_PCLR29(value uint32) {
	volatile.StoreUint32(&o.CLR5.Reg, volatile.LoadUint32(&o.CLR5.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetCLR5_PCLR29() uint32 {
	return (volatile.LoadUint32(&o.CLR5.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetCLR5_PCLR30(value uint32) {
	volatile.StoreUint32(&o.CLR5.Reg, volatile.LoadUint32(&o.CLR5.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetCLR5_PCLR30() uint32 {
	return (volatile.LoadUint32(&o.CLR5.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetCLR5_PCLR31(value uint32) {
	volatile.StoreUint32(&o.CLR5.Reg, volatile.LoadUint32(&o.CLR5.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetCLR5_PCLR31() uint32 {
	return (volatile.LoadUint32(&o.CLR5.Reg) & 0x80000000) >> 31
}

// External Memory Controller (EMC)
type EMC_Type struct {
	CONTROL            volatile.Register32 // 0x0
	STATUS             volatile.Register32 // 0x4
	CONFIG             volatile.Register32 // 0x8
	_                  [20]byte
	DYNAMICCONTROL     volatile.Register32 // 0x20
	DYNAMICREFRESH     volatile.Register32 // 0x24
	DYNAMICREADCONFIG  volatile.Register32 // 0x28
	_                  [4]byte
	DYNAMICRP          volatile.Register32 // 0x30
	DYNAMICRAS         volatile.Register32 // 0x34
	DYNAMICSREX        volatile.Register32 // 0x38
	DYNAMICAPR         volatile.Register32 // 0x3C
	DYNAMICDAL         volatile.Register32 // 0x40
	DYNAMICWR          volatile.Register32 // 0x44
	DYNAMICRC          volatile.Register32 // 0x48
	DYNAMICRFC         volatile.Register32 // 0x4C
	DYNAMICXSR         volatile.Register32 // 0x50
	DYNAMICRRD         volatile.Register32 // 0x54
	DYNAMICMRD         volatile.Register32 // 0x58
	_                  [36]byte
	STATICEXTENDEDWAIT volatile.Register32 // 0x80
	_                  [124]byte
	DYNAMICCONFIG0     volatile.Register32 // 0x100
	DYNAMICRASCAS0     volatile.Register32 // 0x104
	_                  [24]byte
	DYNAMICCONFIG1     volatile.Register32 // 0x120
	DYNAMICRASCAS1     volatile.Register32 // 0x124
	_                  [24]byte
	DYNAMICCONFIG2     volatile.Register32 // 0x140
	DYNAMICRASCAS2     volatile.Register32 // 0x144
	_                  [24]byte
	DYNAMICCONFIG3     volatile.Register32 // 0x160
	DYNAMICRASCAS3     volatile.Register32 // 0x164
	_                  [152]byte
	STATICCONFIG0      volatile.Register32 // 0x200
	STATICWAITWEN0     volatile.Register32 // 0x204
	STATICWAITOEN0     volatile.Register32 // 0x208
	STATICWAITRD0      volatile.Register32 // 0x20C
	STATICWAITPAGE0    volatile.Register32 // 0x210
	STATICWAITWR0      volatile.Register32 // 0x214
	STATICWAITTURN0    volatile.Register32 // 0x218
	_                  [4]byte
	STATICCONFIG1      volatile.Register32 // 0x220
	STATICWAITWEN1     volatile.Register32 // 0x224
	STATICWAITOEN1     volatile.Register32 // 0x228
	STATICWAITRD1      volatile.Register32 // 0x22C
	STATICWAITPAGE1    volatile.Register32 // 0x230
	STATICWAITWR1      volatile.Register32 // 0x234
	STATICWAITTURN1    volatile.Register32 // 0x238
	_                  [4]byte
	STATICCONFIG2      volatile.Register32 // 0x240
	STATICWAITWEN2     volatile.Register32 // 0x244
	STATICWAITOEN2     volatile.Register32 // 0x248
	STATICWAITRD2      volatile.Register32 // 0x24C
	STATICWAITPAGE2    volatile.Register32 // 0x250
	STATICWAITWR2      volatile.Register32 // 0x254
	STATICWAITTURN2    volatile.Register32 // 0x258
	_                  [4]byte
	STATICCONFIG3      volatile.Register32 // 0x260
	STATICWAITWEN3     volatile.Register32 // 0x264
	STATICWAITOEN3     volatile.Register32 // 0x268
	STATICWAITRD3      volatile.Register32 // 0x26C
	STATICWAITPAGE3    volatile.Register32 // 0x270
	STATICWAITWR3      volatile.Register32 // 0x274
	STATICWAITTURN3    volatile.Register32 // 0x278
}

// EMC.CONTROL: Controls operation of the memory controller.
func (o *EMC_Type) SetCONTROL_E(value uint32) {
	volatile.StoreUint32(&o.CONTROL.Reg, volatile.LoadUint32(&o.CONTROL.Reg)&^(0x1)|value)
}
func (o *EMC_Type) GetCONTROL_E() uint32 {
	return volatile.LoadUint32(&o.CONTROL.Reg) & 0x1
}
func (o *EMC_Type) SetCONTROL_M(value uint32) {
	volatile.StoreUint32(&o.CONTROL.Reg, volatile.LoadUint32(&o.CONTROL.Reg)&^(0x2)|value<<1)
}
func (o *EMC_Type) GetCONTROL_M() uint32 {
	return (volatile.LoadUint32(&o.CONTROL.Reg) & 0x2) >> 1
}
func (o *EMC_Type) SetCONTROL_L(value uint32) {
	volatile.StoreUint32(&o.CONTROL.Reg, volatile.LoadUint32(&o.CONTROL.Reg)&^(0x4)|value<<2)
}
func (o *EMC_Type) GetCONTROL_L() uint32 {
	return (volatile.LoadUint32(&o.CONTROL.Reg) & 0x4) >> 2
}
func (o *EMC_Type) SetCONTROL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONTROL.Reg, volatile.LoadUint32(&o.CONTROL.Reg)&^(0xfffffff8)|value<<3)
}
func (o *EMC_Type) GetCONTROL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONTROL.Reg) & 0xfffffff8) >> 3
}

// EMC.STATUS: Provides EMC status information.
func (o *EMC_Type) SetSTATUS_B(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x1)|value)
}
func (o *EMC_Type) GetSTATUS_B() uint32 {
	return volatile.LoadUint32(&o.STATUS.Reg) & 0x1
}
func (o *EMC_Type) SetSTATUS_S(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x2)|value<<1)
}
func (o *EMC_Type) GetSTATUS_S() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x2) >> 1
}
func (o *EMC_Type) SetSTATUS_SA(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x4)|value<<2)
}
func (o *EMC_Type) GetSTATUS_SA() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x4) >> 2
}
func (o *EMC_Type) SetSTATUS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0xfffffff8)|value<<3)
}
func (o *EMC_Type) GetSTATUS_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0xfffffff8) >> 3
}

// EMC.CONFIG: Configures operation of the memory controller
func (o *EMC_Type) SetCONFIG_EM(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x1)|value)
}
func (o *EMC_Type) GetCONFIG_EM() uint32 {
	return volatile.LoadUint32(&o.CONFIG.Reg) & 0x1
}
func (o *EMC_Type) SetCONFIG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0xfe)|value<<1)
}
func (o *EMC_Type) GetCONFIG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0xfe) >> 1
}
func (o *EMC_Type) SetCONFIG_CLKR(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x100)|value<<8)
}
func (o *EMC_Type) GetCONFIG_CLKR() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x100) >> 8
}
func (o *EMC_Type) SetCONFIG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0xfffffe00)|value<<9)
}
func (o *EMC_Type) GetCONFIG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0xfffffe00) >> 9
}

// EMC.DYNAMICCONTROL: Controls dynamic memory operation.
func (o *EMC_Type) SetDYNAMICCONTROL_CE(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONTROL.Reg, volatile.LoadUint32(&o.DYNAMICCONTROL.Reg)&^(0x1)|value)
}
func (o *EMC_Type) GetDYNAMICCONTROL_CE() uint32 {
	return volatile.LoadUint32(&o.DYNAMICCONTROL.Reg) & 0x1
}
func (o *EMC_Type) SetDYNAMICCONTROL_CS(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONTROL.Reg, volatile.LoadUint32(&o.DYNAMICCONTROL.Reg)&^(0x2)|value<<1)
}
func (o *EMC_Type) GetDYNAMICCONTROL_CS() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONTROL.Reg) & 0x2) >> 1
}
func (o *EMC_Type) SetDYNAMICCONTROL_SR(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONTROL.Reg, volatile.LoadUint32(&o.DYNAMICCONTROL.Reg)&^(0x4)|value<<2)
}
func (o *EMC_Type) GetDYNAMICCONTROL_SR() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONTROL.Reg) & 0x4) >> 2
}
func (o *EMC_Type) SetDYNAMICCONTROL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONTROL.Reg, volatile.LoadUint32(&o.DYNAMICCONTROL.Reg)&^(0x18)|value<<3)
}
func (o *EMC_Type) GetDYNAMICCONTROL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONTROL.Reg) & 0x18) >> 3
}
func (o *EMC_Type) SetDYNAMICCONTROL_MMC(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONTROL.Reg, volatile.LoadUint32(&o.DYNAMICCONTROL.Reg)&^(0x20)|value<<5)
}
func (o *EMC_Type) GetDYNAMICCONTROL_MMC() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONTROL.Reg) & 0x20) >> 5
}
func (o *EMC_Type) SetDYNAMICCONTROL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONTROL.Reg, volatile.LoadUint32(&o.DYNAMICCONTROL.Reg)&^(0x40)|value<<6)
}
func (o *EMC_Type) GetDYNAMICCONTROL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONTROL.Reg) & 0x40) >> 6
}
func (o *EMC_Type) SetDYNAMICCONTROL_I(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONTROL.Reg, volatile.LoadUint32(&o.DYNAMICCONTROL.Reg)&^(0x180)|value<<7)
}
func (o *EMC_Type) GetDYNAMICCONTROL_I() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONTROL.Reg) & 0x180) >> 7
}
func (o *EMC_Type) SetDYNAMICCONTROL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONTROL.Reg, volatile.LoadUint32(&o.DYNAMICCONTROL.Reg)&^(0x3e00)|value<<9)
}
func (o *EMC_Type) GetDYNAMICCONTROL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONTROL.Reg) & 0x3e00) >> 9
}
func (o *EMC_Type) SetDYNAMICCONTROL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONTROL.Reg, volatile.LoadUint32(&o.DYNAMICCONTROL.Reg)&^(0xffffc000)|value<<14)
}
func (o *EMC_Type) GetDYNAMICCONTROL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONTROL.Reg) & 0xffffc000) >> 14
}

// EMC.DYNAMICREFRESH: Configures dynamic memory refresh.
func (o *EMC_Type) SetDYNAMICREFRESH_REFRESH(value uint32) {
	volatile.StoreUint32(&o.DYNAMICREFRESH.Reg, volatile.LoadUint32(&o.DYNAMICREFRESH.Reg)&^(0x7ff)|value)
}
func (o *EMC_Type) GetDYNAMICREFRESH_REFRESH() uint32 {
	return volatile.LoadUint32(&o.DYNAMICREFRESH.Reg) & 0x7ff
}
func (o *EMC_Type) SetDYNAMICREFRESH_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICREFRESH.Reg, volatile.LoadUint32(&o.DYNAMICREFRESH.Reg)&^(0xfffff800)|value<<11)
}
func (o *EMC_Type) GetDYNAMICREFRESH_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICREFRESH.Reg) & 0xfffff800) >> 11
}

// EMC.DYNAMICREADCONFIG: Configures dynamic memory read strategy.
func (o *EMC_Type) SetDYNAMICREADCONFIG_RD(value uint32) {
	volatile.StoreUint32(&o.DYNAMICREADCONFIG.Reg, volatile.LoadUint32(&o.DYNAMICREADCONFIG.Reg)&^(0x3)|value)
}
func (o *EMC_Type) GetDYNAMICREADCONFIG_RD() uint32 {
	return volatile.LoadUint32(&o.DYNAMICREADCONFIG.Reg) & 0x3
}
func (o *EMC_Type) SetDYNAMICREADCONFIG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICREADCONFIG.Reg, volatile.LoadUint32(&o.DYNAMICREADCONFIG.Reg)&^(0xfffffffc)|value<<2)
}
func (o *EMC_Type) GetDYNAMICREADCONFIG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICREADCONFIG.Reg) & 0xfffffffc) >> 2
}

// EMC.DYNAMICRP: Precharge command period.
func (o *EMC_Type) SetDYNAMICRP_TRP(value uint32) {
	volatile.StoreUint32(&o.DYNAMICRP.Reg, volatile.LoadUint32(&o.DYNAMICRP.Reg)&^(0xf)|value)
}
func (o *EMC_Type) GetDYNAMICRP_TRP() uint32 {
	return volatile.LoadUint32(&o.DYNAMICRP.Reg) & 0xf
}
func (o *EMC_Type) SetDYNAMICRP_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICRP.Reg, volatile.LoadUint32(&o.DYNAMICRP.Reg)&^(0xfffffff0)|value<<4)
}
func (o *EMC_Type) GetDYNAMICRP_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICRP.Reg) & 0xfffffff0) >> 4
}

// EMC.DYNAMICRAS: Active to precharge command period.
func (o *EMC_Type) SetDYNAMICRAS_TRAS(value uint32) {
	volatile.StoreUint32(&o.DYNAMICRAS.Reg, volatile.LoadUint32(&o.DYNAMICRAS.Reg)&^(0xf)|value)
}
func (o *EMC_Type) GetDYNAMICRAS_TRAS() uint32 {
	return volatile.LoadUint32(&o.DYNAMICRAS.Reg) & 0xf
}
func (o *EMC_Type) SetDYNAMICRAS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICRAS.Reg, volatile.LoadUint32(&o.DYNAMICRAS.Reg)&^(0xfffffff0)|value<<4)
}
func (o *EMC_Type) GetDYNAMICRAS_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICRAS.Reg) & 0xfffffff0) >> 4
}

// EMC.DYNAMICSREX: Self-refresh exit time.
func (o *EMC_Type) SetDYNAMICSREX_TSREX(value uint32) {
	volatile.StoreUint32(&o.DYNAMICSREX.Reg, volatile.LoadUint32(&o.DYNAMICSREX.Reg)&^(0xf)|value)
}
func (o *EMC_Type) GetDYNAMICSREX_TSREX() uint32 {
	return volatile.LoadUint32(&o.DYNAMICSREX.Reg) & 0xf
}
func (o *EMC_Type) SetDYNAMICSREX_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICSREX.Reg, volatile.LoadUint32(&o.DYNAMICSREX.Reg)&^(0xfffffff0)|value<<4)
}
func (o *EMC_Type) GetDYNAMICSREX_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICSREX.Reg) & 0xfffffff0) >> 4
}

// EMC.DYNAMICAPR: Last-data-out to active command time.
func (o *EMC_Type) SetDYNAMICAPR_TAPR(value uint32) {
	volatile.StoreUint32(&o.DYNAMICAPR.Reg, volatile.LoadUint32(&o.DYNAMICAPR.Reg)&^(0xf)|value)
}
func (o *EMC_Type) GetDYNAMICAPR_TAPR() uint32 {
	return volatile.LoadUint32(&o.DYNAMICAPR.Reg) & 0xf
}
func (o *EMC_Type) SetDYNAMICAPR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICAPR.Reg, volatile.LoadUint32(&o.DYNAMICAPR.Reg)&^(0xfffffff0)|value<<4)
}
func (o *EMC_Type) GetDYNAMICAPR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICAPR.Reg) & 0xfffffff0) >> 4
}

// EMC.DYNAMICDAL: Data-in to active command time.
func (o *EMC_Type) SetDYNAMICDAL_TDAL(value uint32) {
	volatile.StoreUint32(&o.DYNAMICDAL.Reg, volatile.LoadUint32(&o.DYNAMICDAL.Reg)&^(0xf)|value)
}
func (o *EMC_Type) GetDYNAMICDAL_TDAL() uint32 {
	return volatile.LoadUint32(&o.DYNAMICDAL.Reg) & 0xf
}
func (o *EMC_Type) SetDYNAMICDAL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICDAL.Reg, volatile.LoadUint32(&o.DYNAMICDAL.Reg)&^(0xfffffff0)|value<<4)
}
func (o *EMC_Type) GetDYNAMICDAL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICDAL.Reg) & 0xfffffff0) >> 4
}

// EMC.DYNAMICWR: Write recovery time.
func (o *EMC_Type) SetDYNAMICWR_TWR(value uint32) {
	volatile.StoreUint32(&o.DYNAMICWR.Reg, volatile.LoadUint32(&o.DYNAMICWR.Reg)&^(0xf)|value)
}
func (o *EMC_Type) GetDYNAMICWR_TWR() uint32 {
	return volatile.LoadUint32(&o.DYNAMICWR.Reg) & 0xf
}
func (o *EMC_Type) SetDYNAMICWR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICWR.Reg, volatile.LoadUint32(&o.DYNAMICWR.Reg)&^(0xfffffff0)|value<<4)
}
func (o *EMC_Type) GetDYNAMICWR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICWR.Reg) & 0xfffffff0) >> 4
}

// EMC.DYNAMICRC: Selects the active to active command period.
func (o *EMC_Type) SetDYNAMICRC_TRC(value uint32) {
	volatile.StoreUint32(&o.DYNAMICRC.Reg, volatile.LoadUint32(&o.DYNAMICRC.Reg)&^(0x1f)|value)
}
func (o *EMC_Type) GetDYNAMICRC_TRC() uint32 {
	return volatile.LoadUint32(&o.DYNAMICRC.Reg) & 0x1f
}
func (o *EMC_Type) SetDYNAMICRC_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICRC.Reg, volatile.LoadUint32(&o.DYNAMICRC.Reg)&^(0xffffffe0)|value<<5)
}
func (o *EMC_Type) GetDYNAMICRC_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICRC.Reg) & 0xffffffe0) >> 5
}

// EMC.DYNAMICRFC: Selects the auto-refresh period.
func (o *EMC_Type) SetDYNAMICRFC_TRFC(value uint32) {
	volatile.StoreUint32(&o.DYNAMICRFC.Reg, volatile.LoadUint32(&o.DYNAMICRFC.Reg)&^(0x1f)|value)
}
func (o *EMC_Type) GetDYNAMICRFC_TRFC() uint32 {
	return volatile.LoadUint32(&o.DYNAMICRFC.Reg) & 0x1f
}
func (o *EMC_Type) SetDYNAMICRFC_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICRFC.Reg, volatile.LoadUint32(&o.DYNAMICRFC.Reg)&^(0xffffffe0)|value<<5)
}
func (o *EMC_Type) GetDYNAMICRFC_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICRFC.Reg) & 0xffffffe0) >> 5
}

// EMC.DYNAMICXSR: Time for exit self-refresh to active command.
func (o *EMC_Type) SetDYNAMICXSR_TXSR(value uint32) {
	volatile.StoreUint32(&o.DYNAMICXSR.Reg, volatile.LoadUint32(&o.DYNAMICXSR.Reg)&^(0x1f)|value)
}
func (o *EMC_Type) GetDYNAMICXSR_TXSR() uint32 {
	return volatile.LoadUint32(&o.DYNAMICXSR.Reg) & 0x1f
}
func (o *EMC_Type) SetDYNAMICXSR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICXSR.Reg, volatile.LoadUint32(&o.DYNAMICXSR.Reg)&^(0xffffffe0)|value<<5)
}
func (o *EMC_Type) GetDYNAMICXSR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICXSR.Reg) & 0xffffffe0) >> 5
}

// EMC.DYNAMICRRD: Latency for active bank A to active bank B.
func (o *EMC_Type) SetDYNAMICRRD_TRRD(value uint32) {
	volatile.StoreUint32(&o.DYNAMICRRD.Reg, volatile.LoadUint32(&o.DYNAMICRRD.Reg)&^(0xf)|value)
}
func (o *EMC_Type) GetDYNAMICRRD_TRRD() uint32 {
	return volatile.LoadUint32(&o.DYNAMICRRD.Reg) & 0xf
}
func (o *EMC_Type) SetDYNAMICRRD_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICRRD.Reg, volatile.LoadUint32(&o.DYNAMICRRD.Reg)&^(0xfffffff0)|value<<4)
}
func (o *EMC_Type) GetDYNAMICRRD_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICRRD.Reg) & 0xfffffff0) >> 4
}

// EMC.DYNAMICMRD: Time for load mode register to active command.
func (o *EMC_Type) SetDYNAMICMRD_TMRD(value uint32) {
	volatile.StoreUint32(&o.DYNAMICMRD.Reg, volatile.LoadUint32(&o.DYNAMICMRD.Reg)&^(0xf)|value)
}
func (o *EMC_Type) GetDYNAMICMRD_TMRD() uint32 {
	return volatile.LoadUint32(&o.DYNAMICMRD.Reg) & 0xf
}
func (o *EMC_Type) SetDYNAMICMRD_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICMRD.Reg, volatile.LoadUint32(&o.DYNAMICMRD.Reg)&^(0xfffffff0)|value<<4)
}
func (o *EMC_Type) GetDYNAMICMRD_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICMRD.Reg) & 0xfffffff0) >> 4
}

// EMC.STATICEXTENDEDWAIT: Time for long static memory read and write transfers.
func (o *EMC_Type) SetSTATICEXTENDEDWAIT_EXTENDEDWAIT(value uint32) {
	volatile.StoreUint32(&o.STATICEXTENDEDWAIT.Reg, volatile.LoadUint32(&o.STATICEXTENDEDWAIT.Reg)&^(0x3ff)|value)
}
func (o *EMC_Type) GetSTATICEXTENDEDWAIT_EXTENDEDWAIT() uint32 {
	return volatile.LoadUint32(&o.STATICEXTENDEDWAIT.Reg) & 0x3ff
}
func (o *EMC_Type) SetSTATICEXTENDEDWAIT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICEXTENDEDWAIT.Reg, volatile.LoadUint32(&o.STATICEXTENDEDWAIT.Reg)&^(0xfffffc00)|value<<10)
}
func (o *EMC_Type) GetSTATICEXTENDEDWAIT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICEXTENDEDWAIT.Reg) & 0xfffffc00) >> 10
}

// EMC.DYNAMICCONFIG0: Configuration information for EMC_DYCS0.
func (o *EMC_Type) SetDYNAMICCONFIG0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG0.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG0.Reg)&^(0x7)|value)
}
func (o *EMC_Type) GetDYNAMICCONFIG0_RESERVED() uint32 {
	return volatile.LoadUint32(&o.DYNAMICCONFIG0.Reg) & 0x7
}
func (o *EMC_Type) SetDYNAMICCONFIG0_MD(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG0.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG0.Reg)&^(0x18)|value<<3)
}
func (o *EMC_Type) GetDYNAMICCONFIG0_MD() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG0.Reg) & 0x18) >> 3
}
func (o *EMC_Type) SetDYNAMICCONFIG0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG0.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG0.Reg)&^(0x60)|value<<5)
}
func (o *EMC_Type) GetDYNAMICCONFIG0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG0.Reg) & 0x60) >> 5
}
func (o *EMC_Type) SetDYNAMICCONFIG0_AM0(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG0.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG0.Reg)&^(0x1f80)|value<<7)
}
func (o *EMC_Type) GetDYNAMICCONFIG0_AM0() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG0.Reg) & 0x1f80) >> 7
}
func (o *EMC_Type) SetDYNAMICCONFIG0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG0.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG0.Reg)&^(0x2000)|value<<13)
}
func (o *EMC_Type) GetDYNAMICCONFIG0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG0.Reg) & 0x2000) >> 13
}
func (o *EMC_Type) SetDYNAMICCONFIG0_AM1(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG0.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG0.Reg)&^(0x4000)|value<<14)
}
func (o *EMC_Type) GetDYNAMICCONFIG0_AM1() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG0.Reg) & 0x4000) >> 14
}
func (o *EMC_Type) SetDYNAMICCONFIG0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG0.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG0.Reg)&^(0x78000)|value<<15)
}
func (o *EMC_Type) GetDYNAMICCONFIG0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG0.Reg) & 0x78000) >> 15
}
func (o *EMC_Type) SetDYNAMICCONFIG0_B(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG0.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG0.Reg)&^(0x80000)|value<<19)
}
func (o *EMC_Type) GetDYNAMICCONFIG0_B() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG0.Reg) & 0x80000) >> 19
}
func (o *EMC_Type) SetDYNAMICCONFIG0_P(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG0.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG0.Reg)&^(0x100000)|value<<20)
}
func (o *EMC_Type) GetDYNAMICCONFIG0_P() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG0.Reg) & 0x100000) >> 20
}
func (o *EMC_Type) SetDYNAMICCONFIG0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG0.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG0.Reg)&^(0xffe00000)|value<<21)
}
func (o *EMC_Type) GetDYNAMICCONFIG0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG0.Reg) & 0xffe00000) >> 21
}

// EMC.DYNAMICRASCAS0: RAS and CAS latencies for EMC_DYCS0.
func (o *EMC_Type) SetDYNAMICRASCAS0_RAS(value uint32) {
	volatile.StoreUint32(&o.DYNAMICRASCAS0.Reg, volatile.LoadUint32(&o.DYNAMICRASCAS0.Reg)&^(0x3)|value)
}
func (o *EMC_Type) GetDYNAMICRASCAS0_RAS() uint32 {
	return volatile.LoadUint32(&o.DYNAMICRASCAS0.Reg) & 0x3
}
func (o *EMC_Type) SetDYNAMICRASCAS0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICRASCAS0.Reg, volatile.LoadUint32(&o.DYNAMICRASCAS0.Reg)&^(0xfc)|value<<2)
}
func (o *EMC_Type) GetDYNAMICRASCAS0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICRASCAS0.Reg) & 0xfc) >> 2
}
func (o *EMC_Type) SetDYNAMICRASCAS0_CAS(value uint32) {
	volatile.StoreUint32(&o.DYNAMICRASCAS0.Reg, volatile.LoadUint32(&o.DYNAMICRASCAS0.Reg)&^(0x300)|value<<8)
}
func (o *EMC_Type) GetDYNAMICRASCAS0_CAS() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICRASCAS0.Reg) & 0x300) >> 8
}
func (o *EMC_Type) SetDYNAMICRASCAS0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICRASCAS0.Reg, volatile.LoadUint32(&o.DYNAMICRASCAS0.Reg)&^(0xfffffc00)|value<<10)
}
func (o *EMC_Type) GetDYNAMICRASCAS0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICRASCAS0.Reg) & 0xfffffc00) >> 10
}

// EMC.DYNAMICCONFIG1: Configuration information for EMC_DYCS0.
func (o *EMC_Type) SetDYNAMICCONFIG1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG1.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG1.Reg)&^(0x7)|value)
}
func (o *EMC_Type) GetDYNAMICCONFIG1_RESERVED() uint32 {
	return volatile.LoadUint32(&o.DYNAMICCONFIG1.Reg) & 0x7
}
func (o *EMC_Type) SetDYNAMICCONFIG1_MD(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG1.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG1.Reg)&^(0x18)|value<<3)
}
func (o *EMC_Type) GetDYNAMICCONFIG1_MD() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG1.Reg) & 0x18) >> 3
}
func (o *EMC_Type) SetDYNAMICCONFIG1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG1.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG1.Reg)&^(0x60)|value<<5)
}
func (o *EMC_Type) GetDYNAMICCONFIG1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG1.Reg) & 0x60) >> 5
}
func (o *EMC_Type) SetDYNAMICCONFIG1_AM0(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG1.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG1.Reg)&^(0x1f80)|value<<7)
}
func (o *EMC_Type) GetDYNAMICCONFIG1_AM0() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG1.Reg) & 0x1f80) >> 7
}
func (o *EMC_Type) SetDYNAMICCONFIG1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG1.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG1.Reg)&^(0x2000)|value<<13)
}
func (o *EMC_Type) GetDYNAMICCONFIG1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG1.Reg) & 0x2000) >> 13
}
func (o *EMC_Type) SetDYNAMICCONFIG1_AM1(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG1.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG1.Reg)&^(0x4000)|value<<14)
}
func (o *EMC_Type) GetDYNAMICCONFIG1_AM1() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG1.Reg) & 0x4000) >> 14
}
func (o *EMC_Type) SetDYNAMICCONFIG1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG1.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG1.Reg)&^(0x78000)|value<<15)
}
func (o *EMC_Type) GetDYNAMICCONFIG1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG1.Reg) & 0x78000) >> 15
}
func (o *EMC_Type) SetDYNAMICCONFIG1_B(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG1.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG1.Reg)&^(0x80000)|value<<19)
}
func (o *EMC_Type) GetDYNAMICCONFIG1_B() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG1.Reg) & 0x80000) >> 19
}
func (o *EMC_Type) SetDYNAMICCONFIG1_P(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG1.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG1.Reg)&^(0x100000)|value<<20)
}
func (o *EMC_Type) GetDYNAMICCONFIG1_P() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG1.Reg) & 0x100000) >> 20
}
func (o *EMC_Type) SetDYNAMICCONFIG1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG1.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG1.Reg)&^(0xffe00000)|value<<21)
}
func (o *EMC_Type) GetDYNAMICCONFIG1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG1.Reg) & 0xffe00000) >> 21
}

// EMC.DYNAMICRASCAS1: RAS and CAS latencies for EMC_DYCS0.
func (o *EMC_Type) SetDYNAMICRASCAS1_RAS(value uint32) {
	volatile.StoreUint32(&o.DYNAMICRASCAS1.Reg, volatile.LoadUint32(&o.DYNAMICRASCAS1.Reg)&^(0x3)|value)
}
func (o *EMC_Type) GetDYNAMICRASCAS1_RAS() uint32 {
	return volatile.LoadUint32(&o.DYNAMICRASCAS1.Reg) & 0x3
}
func (o *EMC_Type) SetDYNAMICRASCAS1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICRASCAS1.Reg, volatile.LoadUint32(&o.DYNAMICRASCAS1.Reg)&^(0xfc)|value<<2)
}
func (o *EMC_Type) GetDYNAMICRASCAS1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICRASCAS1.Reg) & 0xfc) >> 2
}
func (o *EMC_Type) SetDYNAMICRASCAS1_CAS(value uint32) {
	volatile.StoreUint32(&o.DYNAMICRASCAS1.Reg, volatile.LoadUint32(&o.DYNAMICRASCAS1.Reg)&^(0x300)|value<<8)
}
func (o *EMC_Type) GetDYNAMICRASCAS1_CAS() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICRASCAS1.Reg) & 0x300) >> 8
}
func (o *EMC_Type) SetDYNAMICRASCAS1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICRASCAS1.Reg, volatile.LoadUint32(&o.DYNAMICRASCAS1.Reg)&^(0xfffffc00)|value<<10)
}
func (o *EMC_Type) GetDYNAMICRASCAS1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICRASCAS1.Reg) & 0xfffffc00) >> 10
}

// EMC.DYNAMICCONFIG2: Configuration information for EMC_DYCS0.
func (o *EMC_Type) SetDYNAMICCONFIG2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG2.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG2.Reg)&^(0x7)|value)
}
func (o *EMC_Type) GetDYNAMICCONFIG2_RESERVED() uint32 {
	return volatile.LoadUint32(&o.DYNAMICCONFIG2.Reg) & 0x7
}
func (o *EMC_Type) SetDYNAMICCONFIG2_MD(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG2.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG2.Reg)&^(0x18)|value<<3)
}
func (o *EMC_Type) GetDYNAMICCONFIG2_MD() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG2.Reg) & 0x18) >> 3
}
func (o *EMC_Type) SetDYNAMICCONFIG2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG2.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG2.Reg)&^(0x60)|value<<5)
}
func (o *EMC_Type) GetDYNAMICCONFIG2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG2.Reg) & 0x60) >> 5
}
func (o *EMC_Type) SetDYNAMICCONFIG2_AM0(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG2.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG2.Reg)&^(0x1f80)|value<<7)
}
func (o *EMC_Type) GetDYNAMICCONFIG2_AM0() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG2.Reg) & 0x1f80) >> 7
}
func (o *EMC_Type) SetDYNAMICCONFIG2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG2.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG2.Reg)&^(0x2000)|value<<13)
}
func (o *EMC_Type) GetDYNAMICCONFIG2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG2.Reg) & 0x2000) >> 13
}
func (o *EMC_Type) SetDYNAMICCONFIG2_AM1(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG2.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG2.Reg)&^(0x4000)|value<<14)
}
func (o *EMC_Type) GetDYNAMICCONFIG2_AM1() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG2.Reg) & 0x4000) >> 14
}
func (o *EMC_Type) SetDYNAMICCONFIG2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG2.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG2.Reg)&^(0x78000)|value<<15)
}
func (o *EMC_Type) GetDYNAMICCONFIG2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG2.Reg) & 0x78000) >> 15
}
func (o *EMC_Type) SetDYNAMICCONFIG2_B(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG2.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG2.Reg)&^(0x80000)|value<<19)
}
func (o *EMC_Type) GetDYNAMICCONFIG2_B() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG2.Reg) & 0x80000) >> 19
}
func (o *EMC_Type) SetDYNAMICCONFIG2_P(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG2.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG2.Reg)&^(0x100000)|value<<20)
}
func (o *EMC_Type) GetDYNAMICCONFIG2_P() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG2.Reg) & 0x100000) >> 20
}
func (o *EMC_Type) SetDYNAMICCONFIG2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG2.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG2.Reg)&^(0xffe00000)|value<<21)
}
func (o *EMC_Type) GetDYNAMICCONFIG2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG2.Reg) & 0xffe00000) >> 21
}

// EMC.DYNAMICRASCAS2: RAS and CAS latencies for EMC_DYCS0.
func (o *EMC_Type) SetDYNAMICRASCAS2_RAS(value uint32) {
	volatile.StoreUint32(&o.DYNAMICRASCAS2.Reg, volatile.LoadUint32(&o.DYNAMICRASCAS2.Reg)&^(0x3)|value)
}
func (o *EMC_Type) GetDYNAMICRASCAS2_RAS() uint32 {
	return volatile.LoadUint32(&o.DYNAMICRASCAS2.Reg) & 0x3
}
func (o *EMC_Type) SetDYNAMICRASCAS2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICRASCAS2.Reg, volatile.LoadUint32(&o.DYNAMICRASCAS2.Reg)&^(0xfc)|value<<2)
}
func (o *EMC_Type) GetDYNAMICRASCAS2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICRASCAS2.Reg) & 0xfc) >> 2
}
func (o *EMC_Type) SetDYNAMICRASCAS2_CAS(value uint32) {
	volatile.StoreUint32(&o.DYNAMICRASCAS2.Reg, volatile.LoadUint32(&o.DYNAMICRASCAS2.Reg)&^(0x300)|value<<8)
}
func (o *EMC_Type) GetDYNAMICRASCAS2_CAS() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICRASCAS2.Reg) & 0x300) >> 8
}
func (o *EMC_Type) SetDYNAMICRASCAS2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICRASCAS2.Reg, volatile.LoadUint32(&o.DYNAMICRASCAS2.Reg)&^(0xfffffc00)|value<<10)
}
func (o *EMC_Type) GetDYNAMICRASCAS2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICRASCAS2.Reg) & 0xfffffc00) >> 10
}

// EMC.DYNAMICCONFIG3: Configuration information for EMC_DYCS0.
func (o *EMC_Type) SetDYNAMICCONFIG3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG3.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG3.Reg)&^(0x7)|value)
}
func (o *EMC_Type) GetDYNAMICCONFIG3_RESERVED() uint32 {
	return volatile.LoadUint32(&o.DYNAMICCONFIG3.Reg) & 0x7
}
func (o *EMC_Type) SetDYNAMICCONFIG3_MD(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG3.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG3.Reg)&^(0x18)|value<<3)
}
func (o *EMC_Type) GetDYNAMICCONFIG3_MD() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG3.Reg) & 0x18) >> 3
}
func (o *EMC_Type) SetDYNAMICCONFIG3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG3.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG3.Reg)&^(0x60)|value<<5)
}
func (o *EMC_Type) GetDYNAMICCONFIG3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG3.Reg) & 0x60) >> 5
}
func (o *EMC_Type) SetDYNAMICCONFIG3_AM0(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG3.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG3.Reg)&^(0x1f80)|value<<7)
}
func (o *EMC_Type) GetDYNAMICCONFIG3_AM0() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG3.Reg) & 0x1f80) >> 7
}
func (o *EMC_Type) SetDYNAMICCONFIG3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG3.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG3.Reg)&^(0x2000)|value<<13)
}
func (o *EMC_Type) GetDYNAMICCONFIG3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG3.Reg) & 0x2000) >> 13
}
func (o *EMC_Type) SetDYNAMICCONFIG3_AM1(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG3.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG3.Reg)&^(0x4000)|value<<14)
}
func (o *EMC_Type) GetDYNAMICCONFIG3_AM1() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG3.Reg) & 0x4000) >> 14
}
func (o *EMC_Type) SetDYNAMICCONFIG3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG3.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG3.Reg)&^(0x78000)|value<<15)
}
func (o *EMC_Type) GetDYNAMICCONFIG3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG3.Reg) & 0x78000) >> 15
}
func (o *EMC_Type) SetDYNAMICCONFIG3_B(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG3.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG3.Reg)&^(0x80000)|value<<19)
}
func (o *EMC_Type) GetDYNAMICCONFIG3_B() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG3.Reg) & 0x80000) >> 19
}
func (o *EMC_Type) SetDYNAMICCONFIG3_P(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG3.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG3.Reg)&^(0x100000)|value<<20)
}
func (o *EMC_Type) GetDYNAMICCONFIG3_P() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG3.Reg) & 0x100000) >> 20
}
func (o *EMC_Type) SetDYNAMICCONFIG3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICCONFIG3.Reg, volatile.LoadUint32(&o.DYNAMICCONFIG3.Reg)&^(0xffe00000)|value<<21)
}
func (o *EMC_Type) GetDYNAMICCONFIG3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICCONFIG3.Reg) & 0xffe00000) >> 21
}

// EMC.DYNAMICRASCAS3: RAS and CAS latencies for EMC_DYCS0.
func (o *EMC_Type) SetDYNAMICRASCAS3_RAS(value uint32) {
	volatile.StoreUint32(&o.DYNAMICRASCAS3.Reg, volatile.LoadUint32(&o.DYNAMICRASCAS3.Reg)&^(0x3)|value)
}
func (o *EMC_Type) GetDYNAMICRASCAS3_RAS() uint32 {
	return volatile.LoadUint32(&o.DYNAMICRASCAS3.Reg) & 0x3
}
func (o *EMC_Type) SetDYNAMICRASCAS3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICRASCAS3.Reg, volatile.LoadUint32(&o.DYNAMICRASCAS3.Reg)&^(0xfc)|value<<2)
}
func (o *EMC_Type) GetDYNAMICRASCAS3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICRASCAS3.Reg) & 0xfc) >> 2
}
func (o *EMC_Type) SetDYNAMICRASCAS3_CAS(value uint32) {
	volatile.StoreUint32(&o.DYNAMICRASCAS3.Reg, volatile.LoadUint32(&o.DYNAMICRASCAS3.Reg)&^(0x300)|value<<8)
}
func (o *EMC_Type) GetDYNAMICRASCAS3_CAS() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICRASCAS3.Reg) & 0x300) >> 8
}
func (o *EMC_Type) SetDYNAMICRASCAS3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DYNAMICRASCAS3.Reg, volatile.LoadUint32(&o.DYNAMICRASCAS3.Reg)&^(0xfffffc00)|value<<10)
}
func (o *EMC_Type) GetDYNAMICRASCAS3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DYNAMICRASCAS3.Reg) & 0xfffffc00) >> 10
}

// EMC.STATICCONFIG0: Configuration for EMC_CS0.
func (o *EMC_Type) SetSTATICCONFIG0_MW(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG0.Reg, volatile.LoadUint32(&o.STATICCONFIG0.Reg)&^(0x3)|value)
}
func (o *EMC_Type) GetSTATICCONFIG0_MW() uint32 {
	return volatile.LoadUint32(&o.STATICCONFIG0.Reg) & 0x3
}
func (o *EMC_Type) SetSTATICCONFIG0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG0.Reg, volatile.LoadUint32(&o.STATICCONFIG0.Reg)&^(0x4)|value<<2)
}
func (o *EMC_Type) GetSTATICCONFIG0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG0.Reg) & 0x4) >> 2
}
func (o *EMC_Type) SetSTATICCONFIG0_PM(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG0.Reg, volatile.LoadUint32(&o.STATICCONFIG0.Reg)&^(0x8)|value<<3)
}
func (o *EMC_Type) GetSTATICCONFIG0_PM() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG0.Reg) & 0x8) >> 3
}
func (o *EMC_Type) SetSTATICCONFIG0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG0.Reg, volatile.LoadUint32(&o.STATICCONFIG0.Reg)&^(0x30)|value<<4)
}
func (o *EMC_Type) GetSTATICCONFIG0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG0.Reg) & 0x30) >> 4
}
func (o *EMC_Type) SetSTATICCONFIG0_PC(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG0.Reg, volatile.LoadUint32(&o.STATICCONFIG0.Reg)&^(0x40)|value<<6)
}
func (o *EMC_Type) GetSTATICCONFIG0_PC() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG0.Reg) & 0x40) >> 6
}
func (o *EMC_Type) SetSTATICCONFIG0_PB(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG0.Reg, volatile.LoadUint32(&o.STATICCONFIG0.Reg)&^(0x80)|value<<7)
}
func (o *EMC_Type) GetSTATICCONFIG0_PB() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG0.Reg) & 0x80) >> 7
}
func (o *EMC_Type) SetSTATICCONFIG0_EW(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG0.Reg, volatile.LoadUint32(&o.STATICCONFIG0.Reg)&^(0x100)|value<<8)
}
func (o *EMC_Type) GetSTATICCONFIG0_EW() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG0.Reg) & 0x100) >> 8
}
func (o *EMC_Type) SetSTATICCONFIG0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG0.Reg, volatile.LoadUint32(&o.STATICCONFIG0.Reg)&^(0x7fe00)|value<<9)
}
func (o *EMC_Type) GetSTATICCONFIG0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG0.Reg) & 0x7fe00) >> 9
}
func (o *EMC_Type) SetSTATICCONFIG0_B(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG0.Reg, volatile.LoadUint32(&o.STATICCONFIG0.Reg)&^(0x80000)|value<<19)
}
func (o *EMC_Type) GetSTATICCONFIG0_B() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG0.Reg) & 0x80000) >> 19
}
func (o *EMC_Type) SetSTATICCONFIG0_P(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG0.Reg, volatile.LoadUint32(&o.STATICCONFIG0.Reg)&^(0x100000)|value<<20)
}
func (o *EMC_Type) GetSTATICCONFIG0_P() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG0.Reg) & 0x100000) >> 20
}
func (o *EMC_Type) SetSTATICCONFIG0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG0.Reg, volatile.LoadUint32(&o.STATICCONFIG0.Reg)&^(0xffe00000)|value<<21)
}
func (o *EMC_Type) GetSTATICCONFIG0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG0.Reg) & 0xffe00000) >> 21
}

// EMC.STATICWAITWEN0: Delay from EMC_CS0 to write enable.
func (o *EMC_Type) SetSTATICWAITWEN0_WAITWEN(value uint32) {
	volatile.StoreUint32(&o.STATICWAITWEN0.Reg, volatile.LoadUint32(&o.STATICWAITWEN0.Reg)&^(0xf)|value)
}
func (o *EMC_Type) GetSTATICWAITWEN0_WAITWEN() uint32 {
	return volatile.LoadUint32(&o.STATICWAITWEN0.Reg) & 0xf
}
func (o *EMC_Type) SetSTATICWAITWEN0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICWAITWEN0.Reg, volatile.LoadUint32(&o.STATICWAITWEN0.Reg)&^(0xfffffff0)|value<<4)
}
func (o *EMC_Type) GetSTATICWAITWEN0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICWAITWEN0.Reg) & 0xfffffff0) >> 4
}

// EMC.STATICWAITOEN0: Delay from EMC_CS0 or address change, whichever is later, to output enable.
func (o *EMC_Type) SetSTATICWAITOEN0_WAITOEN(value uint32) {
	volatile.StoreUint32(&o.STATICWAITOEN0.Reg, volatile.LoadUint32(&o.STATICWAITOEN0.Reg)&^(0xf)|value)
}
func (o *EMC_Type) GetSTATICWAITOEN0_WAITOEN() uint32 {
	return volatile.LoadUint32(&o.STATICWAITOEN0.Reg) & 0xf
}
func (o *EMC_Type) SetSTATICWAITOEN0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICWAITOEN0.Reg, volatile.LoadUint32(&o.STATICWAITOEN0.Reg)&^(0xfffffff0)|value<<4)
}
func (o *EMC_Type) GetSTATICWAITOEN0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICWAITOEN0.Reg) & 0xfffffff0) >> 4
}

// EMC.STATICWAITRD0: Delay from EMC_CS0 to a read access.
func (o *EMC_Type) SetSTATICWAITRD0_WAITRD(value uint32) {
	volatile.StoreUint32(&o.STATICWAITRD0.Reg, volatile.LoadUint32(&o.STATICWAITRD0.Reg)&^(0x1f)|value)
}
func (o *EMC_Type) GetSTATICWAITRD0_WAITRD() uint32 {
	return volatile.LoadUint32(&o.STATICWAITRD0.Reg) & 0x1f
}
func (o *EMC_Type) SetSTATICWAITRD0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICWAITRD0.Reg, volatile.LoadUint32(&o.STATICWAITRD0.Reg)&^(0xffffffe0)|value<<5)
}
func (o *EMC_Type) GetSTATICWAITRD0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICWAITRD0.Reg) & 0xffffffe0) >> 5
}

// EMC.STATICWAITPAGE0: Delay for asynchronous page mode sequential accesses for EMC_CS0.
func (o *EMC_Type) SetSTATICWAITPAGE0_WAITPAGE(value uint32) {
	volatile.StoreUint32(&o.STATICWAITPAGE0.Reg, volatile.LoadUint32(&o.STATICWAITPAGE0.Reg)&^(0x1f)|value)
}
func (o *EMC_Type) GetSTATICWAITPAGE0_WAITPAGE() uint32 {
	return volatile.LoadUint32(&o.STATICWAITPAGE0.Reg) & 0x1f
}
func (o *EMC_Type) SetSTATICWAITPAGE0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICWAITPAGE0.Reg, volatile.LoadUint32(&o.STATICWAITPAGE0.Reg)&^(0xffffffe0)|value<<5)
}
func (o *EMC_Type) GetSTATICWAITPAGE0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICWAITPAGE0.Reg) & 0xffffffe0) >> 5
}

// EMC.STATICWAITWR0: Delay from EMC_CS0 to a write access.
func (o *EMC_Type) SetSTATICWAITWR0_WAITWR(value uint32) {
	volatile.StoreUint32(&o.STATICWAITWR0.Reg, volatile.LoadUint32(&o.STATICWAITWR0.Reg)&^(0x1f)|value)
}
func (o *EMC_Type) GetSTATICWAITWR0_WAITWR() uint32 {
	return volatile.LoadUint32(&o.STATICWAITWR0.Reg) & 0x1f
}
func (o *EMC_Type) SetSTATICWAITWR0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICWAITWR0.Reg, volatile.LoadUint32(&o.STATICWAITWR0.Reg)&^(0xffffffe0)|value<<5)
}
func (o *EMC_Type) GetSTATICWAITWR0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICWAITWR0.Reg) & 0xffffffe0) >> 5
}

// EMC.STATICWAITTURN0: Number of bus turnaround cycles EMC_CS0.
func (o *EMC_Type) SetSTATICWAITTURN0_WAITTURN(value uint32) {
	volatile.StoreUint32(&o.STATICWAITTURN0.Reg, volatile.LoadUint32(&o.STATICWAITTURN0.Reg)&^(0xf)|value)
}
func (o *EMC_Type) GetSTATICWAITTURN0_WAITTURN() uint32 {
	return volatile.LoadUint32(&o.STATICWAITTURN0.Reg) & 0xf
}
func (o *EMC_Type) SetSTATICWAITTURN0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICWAITTURN0.Reg, volatile.LoadUint32(&o.STATICWAITTURN0.Reg)&^(0xfffffff0)|value<<4)
}
func (o *EMC_Type) GetSTATICWAITTURN0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICWAITTURN0.Reg) & 0xfffffff0) >> 4
}

// EMC.STATICCONFIG1: Configuration for EMC_CS0.
func (o *EMC_Type) SetSTATICCONFIG1_MW(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG1.Reg, volatile.LoadUint32(&o.STATICCONFIG1.Reg)&^(0x3)|value)
}
func (o *EMC_Type) GetSTATICCONFIG1_MW() uint32 {
	return volatile.LoadUint32(&o.STATICCONFIG1.Reg) & 0x3
}
func (o *EMC_Type) SetSTATICCONFIG1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG1.Reg, volatile.LoadUint32(&o.STATICCONFIG1.Reg)&^(0x4)|value<<2)
}
func (o *EMC_Type) GetSTATICCONFIG1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG1.Reg) & 0x4) >> 2
}
func (o *EMC_Type) SetSTATICCONFIG1_PM(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG1.Reg, volatile.LoadUint32(&o.STATICCONFIG1.Reg)&^(0x8)|value<<3)
}
func (o *EMC_Type) GetSTATICCONFIG1_PM() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG1.Reg) & 0x8) >> 3
}
func (o *EMC_Type) SetSTATICCONFIG1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG1.Reg, volatile.LoadUint32(&o.STATICCONFIG1.Reg)&^(0x30)|value<<4)
}
func (o *EMC_Type) GetSTATICCONFIG1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG1.Reg) & 0x30) >> 4
}
func (o *EMC_Type) SetSTATICCONFIG1_PC(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG1.Reg, volatile.LoadUint32(&o.STATICCONFIG1.Reg)&^(0x40)|value<<6)
}
func (o *EMC_Type) GetSTATICCONFIG1_PC() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG1.Reg) & 0x40) >> 6
}
func (o *EMC_Type) SetSTATICCONFIG1_PB(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG1.Reg, volatile.LoadUint32(&o.STATICCONFIG1.Reg)&^(0x80)|value<<7)
}
func (o *EMC_Type) GetSTATICCONFIG1_PB() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG1.Reg) & 0x80) >> 7
}
func (o *EMC_Type) SetSTATICCONFIG1_EW(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG1.Reg, volatile.LoadUint32(&o.STATICCONFIG1.Reg)&^(0x100)|value<<8)
}
func (o *EMC_Type) GetSTATICCONFIG1_EW() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG1.Reg) & 0x100) >> 8
}
func (o *EMC_Type) SetSTATICCONFIG1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG1.Reg, volatile.LoadUint32(&o.STATICCONFIG1.Reg)&^(0x7fe00)|value<<9)
}
func (o *EMC_Type) GetSTATICCONFIG1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG1.Reg) & 0x7fe00) >> 9
}
func (o *EMC_Type) SetSTATICCONFIG1_B(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG1.Reg, volatile.LoadUint32(&o.STATICCONFIG1.Reg)&^(0x80000)|value<<19)
}
func (o *EMC_Type) GetSTATICCONFIG1_B() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG1.Reg) & 0x80000) >> 19
}
func (o *EMC_Type) SetSTATICCONFIG1_P(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG1.Reg, volatile.LoadUint32(&o.STATICCONFIG1.Reg)&^(0x100000)|value<<20)
}
func (o *EMC_Type) GetSTATICCONFIG1_P() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG1.Reg) & 0x100000) >> 20
}
func (o *EMC_Type) SetSTATICCONFIG1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG1.Reg, volatile.LoadUint32(&o.STATICCONFIG1.Reg)&^(0xffe00000)|value<<21)
}
func (o *EMC_Type) GetSTATICCONFIG1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG1.Reg) & 0xffe00000) >> 21
}

// EMC.STATICWAITWEN1: Delay from EMC_CS0 to write enable.
func (o *EMC_Type) SetSTATICWAITWEN1_WAITWEN(value uint32) {
	volatile.StoreUint32(&o.STATICWAITWEN1.Reg, volatile.LoadUint32(&o.STATICWAITWEN1.Reg)&^(0xf)|value)
}
func (o *EMC_Type) GetSTATICWAITWEN1_WAITWEN() uint32 {
	return volatile.LoadUint32(&o.STATICWAITWEN1.Reg) & 0xf
}
func (o *EMC_Type) SetSTATICWAITWEN1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICWAITWEN1.Reg, volatile.LoadUint32(&o.STATICWAITWEN1.Reg)&^(0xfffffff0)|value<<4)
}
func (o *EMC_Type) GetSTATICWAITWEN1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICWAITWEN1.Reg) & 0xfffffff0) >> 4
}

// EMC.STATICWAITOEN1: Delay from EMC_CS0 or address change, whichever is later, to output enable.
func (o *EMC_Type) SetSTATICWAITOEN1_WAITOEN(value uint32) {
	volatile.StoreUint32(&o.STATICWAITOEN1.Reg, volatile.LoadUint32(&o.STATICWAITOEN1.Reg)&^(0xf)|value)
}
func (o *EMC_Type) GetSTATICWAITOEN1_WAITOEN() uint32 {
	return volatile.LoadUint32(&o.STATICWAITOEN1.Reg) & 0xf
}
func (o *EMC_Type) SetSTATICWAITOEN1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICWAITOEN1.Reg, volatile.LoadUint32(&o.STATICWAITOEN1.Reg)&^(0xfffffff0)|value<<4)
}
func (o *EMC_Type) GetSTATICWAITOEN1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICWAITOEN1.Reg) & 0xfffffff0) >> 4
}

// EMC.STATICWAITRD1: Delay from EMC_CS0 to a read access.
func (o *EMC_Type) SetSTATICWAITRD1_WAITRD(value uint32) {
	volatile.StoreUint32(&o.STATICWAITRD1.Reg, volatile.LoadUint32(&o.STATICWAITRD1.Reg)&^(0x1f)|value)
}
func (o *EMC_Type) GetSTATICWAITRD1_WAITRD() uint32 {
	return volatile.LoadUint32(&o.STATICWAITRD1.Reg) & 0x1f
}
func (o *EMC_Type) SetSTATICWAITRD1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICWAITRD1.Reg, volatile.LoadUint32(&o.STATICWAITRD1.Reg)&^(0xffffffe0)|value<<5)
}
func (o *EMC_Type) GetSTATICWAITRD1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICWAITRD1.Reg) & 0xffffffe0) >> 5
}

// EMC.STATICWAITPAGE1: Delay for asynchronous page mode sequential accesses for EMC_CS0.
func (o *EMC_Type) SetSTATICWAITPAGE1_WAITPAGE(value uint32) {
	volatile.StoreUint32(&o.STATICWAITPAGE1.Reg, volatile.LoadUint32(&o.STATICWAITPAGE1.Reg)&^(0x1f)|value)
}
func (o *EMC_Type) GetSTATICWAITPAGE1_WAITPAGE() uint32 {
	return volatile.LoadUint32(&o.STATICWAITPAGE1.Reg) & 0x1f
}
func (o *EMC_Type) SetSTATICWAITPAGE1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICWAITPAGE1.Reg, volatile.LoadUint32(&o.STATICWAITPAGE1.Reg)&^(0xffffffe0)|value<<5)
}
func (o *EMC_Type) GetSTATICWAITPAGE1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICWAITPAGE1.Reg) & 0xffffffe0) >> 5
}

// EMC.STATICWAITWR1: Delay from EMC_CS0 to a write access.
func (o *EMC_Type) SetSTATICWAITWR1_WAITWR(value uint32) {
	volatile.StoreUint32(&o.STATICWAITWR1.Reg, volatile.LoadUint32(&o.STATICWAITWR1.Reg)&^(0x1f)|value)
}
func (o *EMC_Type) GetSTATICWAITWR1_WAITWR() uint32 {
	return volatile.LoadUint32(&o.STATICWAITWR1.Reg) & 0x1f
}
func (o *EMC_Type) SetSTATICWAITWR1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICWAITWR1.Reg, volatile.LoadUint32(&o.STATICWAITWR1.Reg)&^(0xffffffe0)|value<<5)
}
func (o *EMC_Type) GetSTATICWAITWR1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICWAITWR1.Reg) & 0xffffffe0) >> 5
}

// EMC.STATICWAITTURN1: Number of bus turnaround cycles EMC_CS0.
func (o *EMC_Type) SetSTATICWAITTURN1_WAITTURN(value uint32) {
	volatile.StoreUint32(&o.STATICWAITTURN1.Reg, volatile.LoadUint32(&o.STATICWAITTURN1.Reg)&^(0xf)|value)
}
func (o *EMC_Type) GetSTATICWAITTURN1_WAITTURN() uint32 {
	return volatile.LoadUint32(&o.STATICWAITTURN1.Reg) & 0xf
}
func (o *EMC_Type) SetSTATICWAITTURN1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICWAITTURN1.Reg, volatile.LoadUint32(&o.STATICWAITTURN1.Reg)&^(0xfffffff0)|value<<4)
}
func (o *EMC_Type) GetSTATICWAITTURN1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICWAITTURN1.Reg) & 0xfffffff0) >> 4
}

// EMC.STATICCONFIG2: Configuration for EMC_CS0.
func (o *EMC_Type) SetSTATICCONFIG2_MW(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG2.Reg, volatile.LoadUint32(&o.STATICCONFIG2.Reg)&^(0x3)|value)
}
func (o *EMC_Type) GetSTATICCONFIG2_MW() uint32 {
	return volatile.LoadUint32(&o.STATICCONFIG2.Reg) & 0x3
}
func (o *EMC_Type) SetSTATICCONFIG2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG2.Reg, volatile.LoadUint32(&o.STATICCONFIG2.Reg)&^(0x4)|value<<2)
}
func (o *EMC_Type) GetSTATICCONFIG2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG2.Reg) & 0x4) >> 2
}
func (o *EMC_Type) SetSTATICCONFIG2_PM(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG2.Reg, volatile.LoadUint32(&o.STATICCONFIG2.Reg)&^(0x8)|value<<3)
}
func (o *EMC_Type) GetSTATICCONFIG2_PM() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG2.Reg) & 0x8) >> 3
}
func (o *EMC_Type) SetSTATICCONFIG2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG2.Reg, volatile.LoadUint32(&o.STATICCONFIG2.Reg)&^(0x30)|value<<4)
}
func (o *EMC_Type) GetSTATICCONFIG2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG2.Reg) & 0x30) >> 4
}
func (o *EMC_Type) SetSTATICCONFIG2_PC(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG2.Reg, volatile.LoadUint32(&o.STATICCONFIG2.Reg)&^(0x40)|value<<6)
}
func (o *EMC_Type) GetSTATICCONFIG2_PC() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG2.Reg) & 0x40) >> 6
}
func (o *EMC_Type) SetSTATICCONFIG2_PB(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG2.Reg, volatile.LoadUint32(&o.STATICCONFIG2.Reg)&^(0x80)|value<<7)
}
func (o *EMC_Type) GetSTATICCONFIG2_PB() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG2.Reg) & 0x80) >> 7
}
func (o *EMC_Type) SetSTATICCONFIG2_EW(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG2.Reg, volatile.LoadUint32(&o.STATICCONFIG2.Reg)&^(0x100)|value<<8)
}
func (o *EMC_Type) GetSTATICCONFIG2_EW() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG2.Reg) & 0x100) >> 8
}
func (o *EMC_Type) SetSTATICCONFIG2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG2.Reg, volatile.LoadUint32(&o.STATICCONFIG2.Reg)&^(0x7fe00)|value<<9)
}
func (o *EMC_Type) GetSTATICCONFIG2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG2.Reg) & 0x7fe00) >> 9
}
func (o *EMC_Type) SetSTATICCONFIG2_B(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG2.Reg, volatile.LoadUint32(&o.STATICCONFIG2.Reg)&^(0x80000)|value<<19)
}
func (o *EMC_Type) GetSTATICCONFIG2_B() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG2.Reg) & 0x80000) >> 19
}
func (o *EMC_Type) SetSTATICCONFIG2_P(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG2.Reg, volatile.LoadUint32(&o.STATICCONFIG2.Reg)&^(0x100000)|value<<20)
}
func (o *EMC_Type) GetSTATICCONFIG2_P() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG2.Reg) & 0x100000) >> 20
}
func (o *EMC_Type) SetSTATICCONFIG2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG2.Reg, volatile.LoadUint32(&o.STATICCONFIG2.Reg)&^(0xffe00000)|value<<21)
}
func (o *EMC_Type) GetSTATICCONFIG2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG2.Reg) & 0xffe00000) >> 21
}

// EMC.STATICWAITWEN2: Delay from EMC_CS0 to write enable.
func (o *EMC_Type) SetSTATICWAITWEN2_WAITWEN(value uint32) {
	volatile.StoreUint32(&o.STATICWAITWEN2.Reg, volatile.LoadUint32(&o.STATICWAITWEN2.Reg)&^(0xf)|value)
}
func (o *EMC_Type) GetSTATICWAITWEN2_WAITWEN() uint32 {
	return volatile.LoadUint32(&o.STATICWAITWEN2.Reg) & 0xf
}
func (o *EMC_Type) SetSTATICWAITWEN2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICWAITWEN2.Reg, volatile.LoadUint32(&o.STATICWAITWEN2.Reg)&^(0xfffffff0)|value<<4)
}
func (o *EMC_Type) GetSTATICWAITWEN2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICWAITWEN2.Reg) & 0xfffffff0) >> 4
}

// EMC.STATICWAITOEN2: Delay from EMC_CS0 or address change, whichever is later, to output enable.
func (o *EMC_Type) SetSTATICWAITOEN2_WAITOEN(value uint32) {
	volatile.StoreUint32(&o.STATICWAITOEN2.Reg, volatile.LoadUint32(&o.STATICWAITOEN2.Reg)&^(0xf)|value)
}
func (o *EMC_Type) GetSTATICWAITOEN2_WAITOEN() uint32 {
	return volatile.LoadUint32(&o.STATICWAITOEN2.Reg) & 0xf
}
func (o *EMC_Type) SetSTATICWAITOEN2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICWAITOEN2.Reg, volatile.LoadUint32(&o.STATICWAITOEN2.Reg)&^(0xfffffff0)|value<<4)
}
func (o *EMC_Type) GetSTATICWAITOEN2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICWAITOEN2.Reg) & 0xfffffff0) >> 4
}

// EMC.STATICWAITRD2: Delay from EMC_CS0 to a read access.
func (o *EMC_Type) SetSTATICWAITRD2_WAITRD(value uint32) {
	volatile.StoreUint32(&o.STATICWAITRD2.Reg, volatile.LoadUint32(&o.STATICWAITRD2.Reg)&^(0x1f)|value)
}
func (o *EMC_Type) GetSTATICWAITRD2_WAITRD() uint32 {
	return volatile.LoadUint32(&o.STATICWAITRD2.Reg) & 0x1f
}
func (o *EMC_Type) SetSTATICWAITRD2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICWAITRD2.Reg, volatile.LoadUint32(&o.STATICWAITRD2.Reg)&^(0xffffffe0)|value<<5)
}
func (o *EMC_Type) GetSTATICWAITRD2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICWAITRD2.Reg) & 0xffffffe0) >> 5
}

// EMC.STATICWAITPAGE2: Delay for asynchronous page mode sequential accesses for EMC_CS0.
func (o *EMC_Type) SetSTATICWAITPAGE2_WAITPAGE(value uint32) {
	volatile.StoreUint32(&o.STATICWAITPAGE2.Reg, volatile.LoadUint32(&o.STATICWAITPAGE2.Reg)&^(0x1f)|value)
}
func (o *EMC_Type) GetSTATICWAITPAGE2_WAITPAGE() uint32 {
	return volatile.LoadUint32(&o.STATICWAITPAGE2.Reg) & 0x1f
}
func (o *EMC_Type) SetSTATICWAITPAGE2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICWAITPAGE2.Reg, volatile.LoadUint32(&o.STATICWAITPAGE2.Reg)&^(0xffffffe0)|value<<5)
}
func (o *EMC_Type) GetSTATICWAITPAGE2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICWAITPAGE2.Reg) & 0xffffffe0) >> 5
}

// EMC.STATICWAITWR2: Delay from EMC_CS0 to a write access.
func (o *EMC_Type) SetSTATICWAITWR2_WAITWR(value uint32) {
	volatile.StoreUint32(&o.STATICWAITWR2.Reg, volatile.LoadUint32(&o.STATICWAITWR2.Reg)&^(0x1f)|value)
}
func (o *EMC_Type) GetSTATICWAITWR2_WAITWR() uint32 {
	return volatile.LoadUint32(&o.STATICWAITWR2.Reg) & 0x1f
}
func (o *EMC_Type) SetSTATICWAITWR2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICWAITWR2.Reg, volatile.LoadUint32(&o.STATICWAITWR2.Reg)&^(0xffffffe0)|value<<5)
}
func (o *EMC_Type) GetSTATICWAITWR2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICWAITWR2.Reg) & 0xffffffe0) >> 5
}

// EMC.STATICWAITTURN2: Number of bus turnaround cycles EMC_CS0.
func (o *EMC_Type) SetSTATICWAITTURN2_WAITTURN(value uint32) {
	volatile.StoreUint32(&o.STATICWAITTURN2.Reg, volatile.LoadUint32(&o.STATICWAITTURN2.Reg)&^(0xf)|value)
}
func (o *EMC_Type) GetSTATICWAITTURN2_WAITTURN() uint32 {
	return volatile.LoadUint32(&o.STATICWAITTURN2.Reg) & 0xf
}
func (o *EMC_Type) SetSTATICWAITTURN2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICWAITTURN2.Reg, volatile.LoadUint32(&o.STATICWAITTURN2.Reg)&^(0xfffffff0)|value<<4)
}
func (o *EMC_Type) GetSTATICWAITTURN2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICWAITTURN2.Reg) & 0xfffffff0) >> 4
}

// EMC.STATICCONFIG3: Configuration for EMC_CS0.
func (o *EMC_Type) SetSTATICCONFIG3_MW(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG3.Reg, volatile.LoadUint32(&o.STATICCONFIG3.Reg)&^(0x3)|value)
}
func (o *EMC_Type) GetSTATICCONFIG3_MW() uint32 {
	return volatile.LoadUint32(&o.STATICCONFIG3.Reg) & 0x3
}
func (o *EMC_Type) SetSTATICCONFIG3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG3.Reg, volatile.LoadUint32(&o.STATICCONFIG3.Reg)&^(0x4)|value<<2)
}
func (o *EMC_Type) GetSTATICCONFIG3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG3.Reg) & 0x4) >> 2
}
func (o *EMC_Type) SetSTATICCONFIG3_PM(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG3.Reg, volatile.LoadUint32(&o.STATICCONFIG3.Reg)&^(0x8)|value<<3)
}
func (o *EMC_Type) GetSTATICCONFIG3_PM() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG3.Reg) & 0x8) >> 3
}
func (o *EMC_Type) SetSTATICCONFIG3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG3.Reg, volatile.LoadUint32(&o.STATICCONFIG3.Reg)&^(0x30)|value<<4)
}
func (o *EMC_Type) GetSTATICCONFIG3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG3.Reg) & 0x30) >> 4
}
func (o *EMC_Type) SetSTATICCONFIG3_PC(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG3.Reg, volatile.LoadUint32(&o.STATICCONFIG3.Reg)&^(0x40)|value<<6)
}
func (o *EMC_Type) GetSTATICCONFIG3_PC() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG3.Reg) & 0x40) >> 6
}
func (o *EMC_Type) SetSTATICCONFIG3_PB(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG3.Reg, volatile.LoadUint32(&o.STATICCONFIG3.Reg)&^(0x80)|value<<7)
}
func (o *EMC_Type) GetSTATICCONFIG3_PB() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG3.Reg) & 0x80) >> 7
}
func (o *EMC_Type) SetSTATICCONFIG3_EW(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG3.Reg, volatile.LoadUint32(&o.STATICCONFIG3.Reg)&^(0x100)|value<<8)
}
func (o *EMC_Type) GetSTATICCONFIG3_EW() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG3.Reg) & 0x100) >> 8
}
func (o *EMC_Type) SetSTATICCONFIG3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG3.Reg, volatile.LoadUint32(&o.STATICCONFIG3.Reg)&^(0x7fe00)|value<<9)
}
func (o *EMC_Type) GetSTATICCONFIG3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG3.Reg) & 0x7fe00) >> 9
}
func (o *EMC_Type) SetSTATICCONFIG3_B(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG3.Reg, volatile.LoadUint32(&o.STATICCONFIG3.Reg)&^(0x80000)|value<<19)
}
func (o *EMC_Type) GetSTATICCONFIG3_B() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG3.Reg) & 0x80000) >> 19
}
func (o *EMC_Type) SetSTATICCONFIG3_P(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG3.Reg, volatile.LoadUint32(&o.STATICCONFIG3.Reg)&^(0x100000)|value<<20)
}
func (o *EMC_Type) GetSTATICCONFIG3_P() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG3.Reg) & 0x100000) >> 20
}
func (o *EMC_Type) SetSTATICCONFIG3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICCONFIG3.Reg, volatile.LoadUint32(&o.STATICCONFIG3.Reg)&^(0xffe00000)|value<<21)
}
func (o *EMC_Type) GetSTATICCONFIG3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICCONFIG3.Reg) & 0xffe00000) >> 21
}

// EMC.STATICWAITWEN3: Delay from EMC_CS0 to write enable.
func (o *EMC_Type) SetSTATICWAITWEN3_WAITWEN(value uint32) {
	volatile.StoreUint32(&o.STATICWAITWEN3.Reg, volatile.LoadUint32(&o.STATICWAITWEN3.Reg)&^(0xf)|value)
}
func (o *EMC_Type) GetSTATICWAITWEN3_WAITWEN() uint32 {
	return volatile.LoadUint32(&o.STATICWAITWEN3.Reg) & 0xf
}
func (o *EMC_Type) SetSTATICWAITWEN3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICWAITWEN3.Reg, volatile.LoadUint32(&o.STATICWAITWEN3.Reg)&^(0xfffffff0)|value<<4)
}
func (o *EMC_Type) GetSTATICWAITWEN3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICWAITWEN3.Reg) & 0xfffffff0) >> 4
}

// EMC.STATICWAITOEN3: Delay from EMC_CS0 or address change, whichever is later, to output enable.
func (o *EMC_Type) SetSTATICWAITOEN3_WAITOEN(value uint32) {
	volatile.StoreUint32(&o.STATICWAITOEN3.Reg, volatile.LoadUint32(&o.STATICWAITOEN3.Reg)&^(0xf)|value)
}
func (o *EMC_Type) GetSTATICWAITOEN3_WAITOEN() uint32 {
	return volatile.LoadUint32(&o.STATICWAITOEN3.Reg) & 0xf
}
func (o *EMC_Type) SetSTATICWAITOEN3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICWAITOEN3.Reg, volatile.LoadUint32(&o.STATICWAITOEN3.Reg)&^(0xfffffff0)|value<<4)
}
func (o *EMC_Type) GetSTATICWAITOEN3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICWAITOEN3.Reg) & 0xfffffff0) >> 4
}

// EMC.STATICWAITRD3: Delay from EMC_CS0 to a read access.
func (o *EMC_Type) SetSTATICWAITRD3_WAITRD(value uint32) {
	volatile.StoreUint32(&o.STATICWAITRD3.Reg, volatile.LoadUint32(&o.STATICWAITRD3.Reg)&^(0x1f)|value)
}
func (o *EMC_Type) GetSTATICWAITRD3_WAITRD() uint32 {
	return volatile.LoadUint32(&o.STATICWAITRD3.Reg) & 0x1f
}
func (o *EMC_Type) SetSTATICWAITRD3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICWAITRD3.Reg, volatile.LoadUint32(&o.STATICWAITRD3.Reg)&^(0xffffffe0)|value<<5)
}
func (o *EMC_Type) GetSTATICWAITRD3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICWAITRD3.Reg) & 0xffffffe0) >> 5
}

// EMC.STATICWAITPAGE3: Delay for asynchronous page mode sequential accesses for EMC_CS0.
func (o *EMC_Type) SetSTATICWAITPAGE3_WAITPAGE(value uint32) {
	volatile.StoreUint32(&o.STATICWAITPAGE3.Reg, volatile.LoadUint32(&o.STATICWAITPAGE3.Reg)&^(0x1f)|value)
}
func (o *EMC_Type) GetSTATICWAITPAGE3_WAITPAGE() uint32 {
	return volatile.LoadUint32(&o.STATICWAITPAGE3.Reg) & 0x1f
}
func (o *EMC_Type) SetSTATICWAITPAGE3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICWAITPAGE3.Reg, volatile.LoadUint32(&o.STATICWAITPAGE3.Reg)&^(0xffffffe0)|value<<5)
}
func (o *EMC_Type) GetSTATICWAITPAGE3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICWAITPAGE3.Reg) & 0xffffffe0) >> 5
}

// EMC.STATICWAITWR3: Delay from EMC_CS0 to a write access.
func (o *EMC_Type) SetSTATICWAITWR3_WAITWR(value uint32) {
	volatile.StoreUint32(&o.STATICWAITWR3.Reg, volatile.LoadUint32(&o.STATICWAITWR3.Reg)&^(0x1f)|value)
}
func (o *EMC_Type) GetSTATICWAITWR3_WAITWR() uint32 {
	return volatile.LoadUint32(&o.STATICWAITWR3.Reg) & 0x1f
}
func (o *EMC_Type) SetSTATICWAITWR3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICWAITWR3.Reg, volatile.LoadUint32(&o.STATICWAITWR3.Reg)&^(0xffffffe0)|value<<5)
}
func (o *EMC_Type) GetSTATICWAITWR3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICWAITWR3.Reg) & 0xffffffe0) >> 5
}

// EMC.STATICWAITTURN3: Number of bus turnaround cycles EMC_CS0.
func (o *EMC_Type) SetSTATICWAITTURN3_WAITTURN(value uint32) {
	volatile.StoreUint32(&o.STATICWAITTURN3.Reg, volatile.LoadUint32(&o.STATICWAITTURN3.Reg)&^(0xf)|value)
}
func (o *EMC_Type) GetSTATICWAITTURN3_WAITTURN() uint32 {
	return volatile.LoadUint32(&o.STATICWAITTURN3.Reg) & 0xf
}
func (o *EMC_Type) SetSTATICWAITTURN3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATICWAITTURN3.Reg, volatile.LoadUint32(&o.STATICWAITTURN3.Reg)&^(0xfffffff0)|value<<4)
}
func (o *EMC_Type) GetSTATICWAITTURN3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATICWAITTURN3.Reg) & 0xfffffff0) >> 4
}

// Windowed Watchdog Timer (WWDT)
type WWDT_Type struct {
	MOD     volatile.Register32 // 0x0
	TC      volatile.Register32 // 0x4
	FEED    volatile.Register32 // 0x8
	TV      volatile.Register32 // 0xC
	_       [4]byte
	WARNINT volatile.Register32 // 0x14
	WINDOW  volatile.Register32 // 0x18
}

// WWDT.MOD: Watchdog mode register. This register determines the basic mode and status of the Watchdog Timer.
func (o *WWDT_Type) SetMOD_WDEN(value uint32) {
	volatile.StoreUint32(&o.MOD.Reg, volatile.LoadUint32(&o.MOD.Reg)&^(0x1)|value)
}
func (o *WWDT_Type) GetMOD_WDEN() uint32 {
	return volatile.LoadUint32(&o.MOD.Reg) & 0x1
}
func (o *WWDT_Type) SetMOD_WDRESET(value uint32) {
	volatile.StoreUint32(&o.MOD.Reg, volatile.LoadUint32(&o.MOD.Reg)&^(0x2)|value<<1)
}
func (o *WWDT_Type) GetMOD_WDRESET() uint32 {
	return (volatile.LoadUint32(&o.MOD.Reg) & 0x2) >> 1
}
func (o *WWDT_Type) SetMOD_WDTOF(value uint32) {
	volatile.StoreUint32(&o.MOD.Reg, volatile.LoadUint32(&o.MOD.Reg)&^(0x4)|value<<2)
}
func (o *WWDT_Type) GetMOD_WDTOF() uint32 {
	return (volatile.LoadUint32(&o.MOD.Reg) & 0x4) >> 2
}
func (o *WWDT_Type) SetMOD_WDINT(value uint32) {
	volatile.StoreUint32(&o.MOD.Reg, volatile.LoadUint32(&o.MOD.Reg)&^(0x8)|value<<3)
}
func (o *WWDT_Type) GetMOD_WDINT() uint32 {
	return (volatile.LoadUint32(&o.MOD.Reg) & 0x8) >> 3
}
func (o *WWDT_Type) SetMOD_WDPROTECT(value uint32) {
	volatile.StoreUint32(&o.MOD.Reg, volatile.LoadUint32(&o.MOD.Reg)&^(0x10)|value<<4)
}
func (o *WWDT_Type) GetMOD_WDPROTECT() uint32 {
	return (volatile.LoadUint32(&o.MOD.Reg) & 0x10) >> 4
}
func (o *WWDT_Type) SetMOD_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MOD.Reg, volatile.LoadUint32(&o.MOD.Reg)&^(0xe0)|value<<5)
}
func (o *WWDT_Type) GetMOD_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MOD.Reg) & 0xe0) >> 5
}

// WWDT.TC: Watchdog timer constant register. The value in this register determines the time-out value.
func (o *WWDT_Type) SetTC_Count(value uint32) {
	volatile.StoreUint32(&o.TC.Reg, volatile.LoadUint32(&o.TC.Reg)&^(0xffffff)|value)
}
func (o *WWDT_Type) GetTC_Count() uint32 {
	return volatile.LoadUint32(&o.TC.Reg) & 0xffffff
}
func (o *WWDT_Type) SetTC_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TC.Reg, volatile.LoadUint32(&o.TC.Reg)&^(0xff000000)|value<<24)
}
func (o *WWDT_Type) GetTC_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TC.Reg) & 0xff000000) >> 24
}

// WWDT.FEED: Watchdog feed sequence register. Writing 0xAA followed by 0x55 to this register reloads the Watchdog timer with the value contained in WDTC.
func (o *WWDT_Type) SetFEED_Feed(value uint32) {
	volatile.StoreUint32(&o.FEED.Reg, volatile.LoadUint32(&o.FEED.Reg)&^(0xff)|value)
}
func (o *WWDT_Type) GetFEED_Feed() uint32 {
	return volatile.LoadUint32(&o.FEED.Reg) & 0xff
}

// WWDT.TV: Watchdog timer value register. This register reads out the current value of the Watchdog timer.
func (o *WWDT_Type) SetTV_Count(value uint32) {
	volatile.StoreUint32(&o.TV.Reg, volatile.LoadUint32(&o.TV.Reg)&^(0xffffff)|value)
}
func (o *WWDT_Type) GetTV_Count() uint32 {
	return volatile.LoadUint32(&o.TV.Reg) & 0xffffff
}
func (o *WWDT_Type) SetTV_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TV.Reg, volatile.LoadUint32(&o.TV.Reg)&^(0xff000000)|value<<24)
}
func (o *WWDT_Type) GetTV_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TV.Reg) & 0xff000000) >> 24
}

// WWDT.WARNINT: Watchdog Warning Interrupt compare value.
func (o *WWDT_Type) SetWARNINT(value uint32) {
	volatile.StoreUint32(&o.WARNINT.Reg, volatile.LoadUint32(&o.WARNINT.Reg)&^(0x3ff)|value)
}
func (o *WWDT_Type) GetWARNINT() uint32 {
	return volatile.LoadUint32(&o.WARNINT.Reg) & 0x3ff
}
func (o *WWDT_Type) SetWARNINT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.WARNINT.Reg, volatile.LoadUint32(&o.WARNINT.Reg)&^(0xfffffc00)|value<<10)
}
func (o *WWDT_Type) GetWARNINT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.WARNINT.Reg) & 0xfffffc00) >> 10
}

// WWDT.WINDOW: Watchdog Window compare value.
func (o *WWDT_Type) SetWINDOW(value uint32) {
	volatile.StoreUint32(&o.WINDOW.Reg, volatile.LoadUint32(&o.WINDOW.Reg)&^(0xffffff)|value)
}
func (o *WWDT_Type) GetWINDOW() uint32 {
	return volatile.LoadUint32(&o.WINDOW.Reg) & 0xffffff
}
func (o *WWDT_Type) SetWINDOW_RESERVED(value uint32) {
	volatile.StoreUint32(&o.WINDOW.Reg, volatile.LoadUint32(&o.WINDOW.Reg)&^(0xff000000)|value<<24)
}
func (o *WWDT_Type) GetWINDOW_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.WINDOW.Reg) & 0xff000000) >> 24
}

// Timer0/1/2/3
type TIMER0_Type struct {
	IR   volatile.Register32    // 0x0
	TCR  volatile.Register32    // 0x4
	TC   volatile.Register32    // 0x8
	PR   volatile.Register32    // 0xC
	PC   volatile.Register32    // 0x10
	MCR  volatile.Register32    // 0x14
	MR   [4]volatile.Register32 // 0x18
	CCR  volatile.Register32    // 0x28
	CR   [2]volatile.Register32 // 0x2C
	_    [8]byte
	EMR  volatile.Register32 // 0x3C
	_    [48]byte
	CTCR volatile.Register32 // 0x70
}

// TIMER0.IR: Interrupt Register. The IR can be written to clear interrupts. The IR can be read to identify which of eight possible interrupt sources are pending.
func (o *TIMER0_Type) SetIR_MR0INT(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x1)|value)
}
func (o *TIMER0_Type) GetIR_MR0INT() uint32 {
	return volatile.LoadUint32(&o.IR.Reg) & 0x1
}
func (o *TIMER0_Type) SetIR_MR1INT(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x2)|value<<1)
}
func (o *TIMER0_Type) GetIR_MR1INT() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x2) >> 1
}
func (o *TIMER0_Type) SetIR_MR2INT(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x4)|value<<2)
}
func (o *TIMER0_Type) GetIR_MR2INT() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x4) >> 2
}
func (o *TIMER0_Type) SetIR_MR3INT(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x8)|value<<3)
}
func (o *TIMER0_Type) GetIR_MR3INT() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x8) >> 3
}
func (o *TIMER0_Type) SetIR_CR0INT(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x10)|value<<4)
}
func (o *TIMER0_Type) GetIR_CR0INT() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x10) >> 4
}
func (o *TIMER0_Type) SetIR_CR1INT(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x20)|value<<5)
}
func (o *TIMER0_Type) GetIR_CR1INT() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x20) >> 5
}
func (o *TIMER0_Type) SetIR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0xffffffc0)|value<<6)
}
func (o *TIMER0_Type) GetIR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0xffffffc0) >> 6
}

// TIMER0.TCR: Timer Control Register. The TCR is used to control the Timer Counter functions. The Timer Counter can be disabled or reset through the TCR.
func (o *TIMER0_Type) SetTCR_CEN(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0x1)|value)
}
func (o *TIMER0_Type) GetTCR_CEN() uint32 {
	return volatile.LoadUint32(&o.TCR.Reg) & 0x1
}
func (o *TIMER0_Type) SetTCR_CRST(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0x2)|value<<1)
}
func (o *TIMER0_Type) GetTCR_CRST() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0x2) >> 1
}
func (o *TIMER0_Type) SetTCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0xfffffffc)|value<<2)
}
func (o *TIMER0_Type) GetTCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0xfffffffc) >> 2
}

// TIMER0.TC: Timer Counter. The 32 bit TC is incremented every PR+1 cycles of PCLK. The TC is controlled through the TCR.
func (o *TIMER0_Type) SetTC(value uint32) {
	volatile.StoreUint32(&o.TC.Reg, value)
}
func (o *TIMER0_Type) GetTC() uint32 {
	return volatile.LoadUint32(&o.TC.Reg)
}

// TIMER0.PR: Prescale Register. When the Prescale Counter (PC) is equal to this value, the next clock increments the TC and clears the PC.
func (o *TIMER0_Type) SetPR(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, value)
}
func (o *TIMER0_Type) GetPR() uint32 {
	return volatile.LoadUint32(&o.PR.Reg)
}

// TIMER0.PC: Prescale Counter. The 32 bit PC is a counter which is incremented to the value stored in PR. When the value in PR is reached, the TC is incremented and the PC is cleared. The PC is observable and controllable through the bus interface.
func (o *TIMER0_Type) SetPC(value uint32) {
	volatile.StoreUint32(&o.PC.Reg, value)
}
func (o *TIMER0_Type) GetPC() uint32 {
	return volatile.LoadUint32(&o.PC.Reg)
}

// TIMER0.MCR: Match Control Register. The MCR is used to control if an interrupt is generated and if the TC is reset when a Match occurs.
func (o *TIMER0_Type) SetMCR_MR0I(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x1)|value)
}
func (o *TIMER0_Type) GetMCR_MR0I() uint32 {
	return volatile.LoadUint32(&o.MCR.Reg) & 0x1
}
func (o *TIMER0_Type) SetMCR_MR0R(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x2)|value<<1)
}
func (o *TIMER0_Type) GetMCR_MR0R() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x2) >> 1
}
func (o *TIMER0_Type) SetMCR_MR0S(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x4)|value<<2)
}
func (o *TIMER0_Type) GetMCR_MR0S() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x4) >> 2
}
func (o *TIMER0_Type) SetMCR_MR1I(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x8)|value<<3)
}
func (o *TIMER0_Type) GetMCR_MR1I() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x8) >> 3
}
func (o *TIMER0_Type) SetMCR_MR1R(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x10)|value<<4)
}
func (o *TIMER0_Type) GetMCR_MR1R() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x10) >> 4
}
func (o *TIMER0_Type) SetMCR_MR1S(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x20)|value<<5)
}
func (o *TIMER0_Type) GetMCR_MR1S() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x20) >> 5
}
func (o *TIMER0_Type) SetMCR_MR2I(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x40)|value<<6)
}
func (o *TIMER0_Type) GetMCR_MR2I() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x40) >> 6
}
func (o *TIMER0_Type) SetMCR_MR2R(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x80)|value<<7)
}
func (o *TIMER0_Type) GetMCR_MR2R() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x80) >> 7
}
func (o *TIMER0_Type) SetMCR_MR2S(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x100)|value<<8)
}
func (o *TIMER0_Type) GetMCR_MR2S() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x100) >> 8
}
func (o *TIMER0_Type) SetMCR_MR3I(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x200)|value<<9)
}
func (o *TIMER0_Type) GetMCR_MR3I() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x200) >> 9
}
func (o *TIMER0_Type) SetMCR_MR3R(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x400)|value<<10)
}
func (o *TIMER0_Type) GetMCR_MR3R() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x400) >> 10
}
func (o *TIMER0_Type) SetMCR_MR3S(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x800)|value<<11)
}
func (o *TIMER0_Type) GetMCR_MR3S() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x800) >> 11
}
func (o *TIMER0_Type) SetMCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0xfffff000)|value<<12)
}
func (o *TIMER0_Type) GetMCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0xfffff000) >> 12
}

// TIMER0.MR: Match Register 0. MR0 can be enabled through the MCR to reset the TC, stop both the TC and PC, and/or generate an interrupt every time MR0 matches the TC.
func (o *TIMER0_Type) SetMR(idx int, value uint32) {
	volatile.StoreUint32(&o.MR[idx].Reg, value)
}
func (o *TIMER0_Type) GetMR(idx int) uint32 {
	return volatile.LoadUint32(&o.MR[idx].Reg)
}

// TIMER0.CCR: Capture Control Register. The CCR controls which edges of the capture inputs are used to load the Capture Registers and whether or not an interrupt is generated when a capture takes place.
func (o *TIMER0_Type) SetCCR_CAP0RE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x1)|value)
}
func (o *TIMER0_Type) GetCCR_CAP0RE() uint32 {
	return volatile.LoadUint32(&o.CCR.Reg) & 0x1
}
func (o *TIMER0_Type) SetCCR_CAP0FE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x2)|value<<1)
}
func (o *TIMER0_Type) GetCCR_CAP0FE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x2) >> 1
}
func (o *TIMER0_Type) SetCCR_CAP0I(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x4)|value<<2)
}
func (o *TIMER0_Type) GetCCR_CAP0I() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x4) >> 2
}
func (o *TIMER0_Type) SetCCR_CAP1RE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x8)|value<<3)
}
func (o *TIMER0_Type) GetCCR_CAP1RE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x8) >> 3
}
func (o *TIMER0_Type) SetCCR_CAP1FE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x10)|value<<4)
}
func (o *TIMER0_Type) GetCCR_CAP1FE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x10) >> 4
}
func (o *TIMER0_Type) SetCCR_CAP1I(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x20)|value<<5)
}
func (o *TIMER0_Type) GetCCR_CAP1I() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x20) >> 5
}
func (o *TIMER0_Type) SetCCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0xffffffc0)|value<<6)
}
func (o *TIMER0_Type) GetCCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0xffffffc0) >> 6
}

// TIMER0.CR: Capture Register 0. CR0 is loaded with the value of TC when there is an event on the CAPn.0 input.
func (o *TIMER0_Type) SetCR(idx int, value uint32) {
	volatile.StoreUint32(&o.CR[idx].Reg, value)
}
func (o *TIMER0_Type) GetCR(idx int) uint32 {
	return volatile.LoadUint32(&o.CR[idx].Reg)
}

// TIMER0.EMR: External Match Register. The EMR controls the external match pins.
func (o *TIMER0_Type) SetEMR_EM0(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x1)|value)
}
func (o *TIMER0_Type) GetEMR_EM0() uint32 {
	return volatile.LoadUint32(&o.EMR.Reg) & 0x1
}
func (o *TIMER0_Type) SetEMR_EM1(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x2)|value<<1)
}
func (o *TIMER0_Type) GetEMR_EM1() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x2) >> 1
}
func (o *TIMER0_Type) SetEMR_EM2(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x4)|value<<2)
}
func (o *TIMER0_Type) GetEMR_EM2() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x4) >> 2
}
func (o *TIMER0_Type) SetEMR_EM3(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x8)|value<<3)
}
func (o *TIMER0_Type) GetEMR_EM3() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x8) >> 3
}
func (o *TIMER0_Type) SetEMR_EMC0(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x30)|value<<4)
}
func (o *TIMER0_Type) GetEMR_EMC0() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x30) >> 4
}
func (o *TIMER0_Type) SetEMR_EMC1(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0xc0)|value<<6)
}
func (o *TIMER0_Type) GetEMR_EMC1() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0xc0) >> 6
}
func (o *TIMER0_Type) SetEMR_EMC2(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x300)|value<<8)
}
func (o *TIMER0_Type) GetEMR_EMC2() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x300) >> 8
}
func (o *TIMER0_Type) SetEMR_EMC3(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0xc00)|value<<10)
}
func (o *TIMER0_Type) GetEMR_EMC3() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0xc00) >> 10
}
func (o *TIMER0_Type) SetEMR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0xfffff000)|value<<12)
}
func (o *TIMER0_Type) GetEMR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0xfffff000) >> 12
}

// TIMER0.CTCR: Count Control Register. The CTCR selects between Timer and Counter mode, and in Counter mode selects the signal and edge(s) for counting.
func (o *TIMER0_Type) SetCTCR_CTMODE(value uint32) {
	volatile.StoreUint32(&o.CTCR.Reg, volatile.LoadUint32(&o.CTCR.Reg)&^(0x3)|value)
}
func (o *TIMER0_Type) GetCTCR_CTMODE() uint32 {
	return volatile.LoadUint32(&o.CTCR.Reg) & 0x3
}
func (o *TIMER0_Type) SetCTCR_CINSEL(value uint32) {
	volatile.StoreUint32(&o.CTCR.Reg, volatile.LoadUint32(&o.CTCR.Reg)&^(0xc)|value<<2)
}
func (o *TIMER0_Type) GetCTCR_CINSEL() uint32 {
	return (volatile.LoadUint32(&o.CTCR.Reg) & 0xc) >> 2
}
func (o *TIMER0_Type) SetCTCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTCR.Reg, volatile.LoadUint32(&o.CTCR.Reg)&^(0xfffffff0)|value<<4)
}
func (o *TIMER0_Type) GetCTCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTCR.Reg) & 0xfffffff0) >> 4
}

// UART0/2/3
type UART0_Type struct {
	RBR           volatile.Register32 // 0x0
	DLM           volatile.Register32 // 0x4
	IIR           volatile.Register32 // 0x8
	LCR           volatile.Register32 // 0xC
	_             [4]byte
	LSR           volatile.Register32 // 0x14
	_             [4]byte
	SCR           volatile.Register32 // 0x1C
	ACR           volatile.Register32 // 0x20
	_             [4]byte
	FDR           volatile.Register32 // 0x28
	_             [4]byte
	TER           volatile.Register32 // 0x30
	_             [24]byte
	RS485CTRL     volatile.Register32 // 0x4C
	RS485ADRMATCH volatile.Register32 // 0x50
	RS485DLY      volatile.Register32 // 0x54
}

// UART0.RBR: Receiver Buffer Register. Contains the next received character to be read (DLAB =0).
func (o *UART0_Type) SetRBR(value uint32) {
	volatile.StoreUint32(&o.RBR.Reg, volatile.LoadUint32(&o.RBR.Reg)&^(0xff)|value)
}
func (o *UART0_Type) GetRBR() uint32 {
	return volatile.LoadUint32(&o.RBR.Reg) & 0xff
}
func (o *UART0_Type) SetRBR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RBR.Reg, volatile.LoadUint32(&o.RBR.Reg)&^(0xffffff00)|value<<8)
}
func (o *UART0_Type) GetRBR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RBR.Reg) & 0xffffff00) >> 8
}

// UART0.DLM: Divisor Latch MSB. Most significant byte of the baud rate divisor value. The full divisor is used to generate a baud rate from the fractional rate divider (DLAB =1).
func (o *UART0_Type) SetDLM_DLMSB(value uint32) {
	volatile.StoreUint32(&o.DLM.Reg, volatile.LoadUint32(&o.DLM.Reg)&^(0xff)|value)
}
func (o *UART0_Type) GetDLM_DLMSB() uint32 {
	return volatile.LoadUint32(&o.DLM.Reg) & 0xff
}
func (o *UART0_Type) SetDLM_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DLM.Reg, volatile.LoadUint32(&o.DLM.Reg)&^(0xffffff00)|value<<8)
}
func (o *UART0_Type) GetDLM_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DLM.Reg) & 0xffffff00) >> 8
}

// UART0.IIR: Interrupt ID Register. Identifies which interrupt(s) are pending.
func (o *UART0_Type) SetIIR_INTSTATUS(value uint32) {
	volatile.StoreUint32(&o.IIR.Reg, volatile.LoadUint32(&o.IIR.Reg)&^(0x1)|value)
}
func (o *UART0_Type) GetIIR_INTSTATUS() uint32 {
	return volatile.LoadUint32(&o.IIR.Reg) & 0x1
}
func (o *UART0_Type) SetIIR_INTID(value uint32) {
	volatile.StoreUint32(&o.IIR.Reg, volatile.LoadUint32(&o.IIR.Reg)&^(0xe)|value<<1)
}
func (o *UART0_Type) GetIIR_INTID() uint32 {
	return (volatile.LoadUint32(&o.IIR.Reg) & 0xe) >> 1
}
func (o *UART0_Type) SetIIR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IIR.Reg, volatile.LoadUint32(&o.IIR.Reg)&^(0x30)|value<<4)
}
func (o *UART0_Type) GetIIR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IIR.Reg) & 0x30) >> 4
}
func (o *UART0_Type) SetIIR_FIFOENABLE(value uint32) {
	volatile.StoreUint32(&o.IIR.Reg, volatile.LoadUint32(&o.IIR.Reg)&^(0xc0)|value<<6)
}
func (o *UART0_Type) GetIIR_FIFOENABLE() uint32 {
	return (volatile.LoadUint32(&o.IIR.Reg) & 0xc0) >> 6
}
func (o *UART0_Type) SetIIR_ABEOINT(value uint32) {
	volatile.StoreUint32(&o.IIR.Reg, volatile.LoadUint32(&o.IIR.Reg)&^(0x100)|value<<8)
}
func (o *UART0_Type) GetIIR_ABEOINT() uint32 {
	return (volatile.LoadUint32(&o.IIR.Reg) & 0x100) >> 8
}
func (o *UART0_Type) SetIIR_ABTOINT(value uint32) {
	volatile.StoreUint32(&o.IIR.Reg, volatile.LoadUint32(&o.IIR.Reg)&^(0x200)|value<<9)
}
func (o *UART0_Type) GetIIR_ABTOINT() uint32 {
	return (volatile.LoadUint32(&o.IIR.Reg) & 0x200) >> 9
}
func (o *UART0_Type) SetIIR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IIR.Reg, volatile.LoadUint32(&o.IIR.Reg)&^(0xfffffc00)|value<<10)
}
func (o *UART0_Type) GetIIR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IIR.Reg) & 0xfffffc00) >> 10
}

// UART0.LCR: Line Control Register. Contains controls for frame formatting and break generation.
func (o *UART0_Type) SetLCR_WLS(value uint32) {
	volatile.StoreUint32(&o.LCR.Reg, volatile.LoadUint32(&o.LCR.Reg)&^(0x3)|value)
}
func (o *UART0_Type) GetLCR_WLS() uint32 {
	return volatile.LoadUint32(&o.LCR.Reg) & 0x3
}
func (o *UART0_Type) SetLCR_SBS(value uint32) {
	volatile.StoreUint32(&o.LCR.Reg, volatile.LoadUint32(&o.LCR.Reg)&^(0x4)|value<<2)
}
func (o *UART0_Type) GetLCR_SBS() uint32 {
	return (volatile.LoadUint32(&o.LCR.Reg) & 0x4) >> 2
}
func (o *UART0_Type) SetLCR_PE(value uint32) {
	volatile.StoreUint32(&o.LCR.Reg, volatile.LoadUint32(&o.LCR.Reg)&^(0x8)|value<<3)
}
func (o *UART0_Type) GetLCR_PE() uint32 {
	return (volatile.LoadUint32(&o.LCR.Reg) & 0x8) >> 3
}
func (o *UART0_Type) SetLCR_PS(value uint32) {
	volatile.StoreUint32(&o.LCR.Reg, volatile.LoadUint32(&o.LCR.Reg)&^(0x30)|value<<4)
}
func (o *UART0_Type) GetLCR_PS() uint32 {
	return (volatile.LoadUint32(&o.LCR.Reg) & 0x30) >> 4
}
func (o *UART0_Type) SetLCR_BC(value uint32) {
	volatile.StoreUint32(&o.LCR.Reg, volatile.LoadUint32(&o.LCR.Reg)&^(0x40)|value<<6)
}
func (o *UART0_Type) GetLCR_BC() uint32 {
	return (volatile.LoadUint32(&o.LCR.Reg) & 0x40) >> 6
}
func (o *UART0_Type) SetLCR_DLAB(value uint32) {
	volatile.StoreUint32(&o.LCR.Reg, volatile.LoadUint32(&o.LCR.Reg)&^(0x80)|value<<7)
}
func (o *UART0_Type) GetLCR_DLAB() uint32 {
	return (volatile.LoadUint32(&o.LCR.Reg) & 0x80) >> 7
}
func (o *UART0_Type) SetLCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.LCR.Reg, volatile.LoadUint32(&o.LCR.Reg)&^(0xffffff00)|value<<8)
}
func (o *UART0_Type) GetLCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.LCR.Reg) & 0xffffff00) >> 8
}

// UART0.LSR: Line Status Register. Contains flags for transmit and receive status, including line errors.
func (o *UART0_Type) SetLSR_RDR(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x1)|value)
}
func (o *UART0_Type) GetLSR_RDR() uint32 {
	return volatile.LoadUint32(&o.LSR.Reg) & 0x1
}
func (o *UART0_Type) SetLSR_OE(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x2)|value<<1)
}
func (o *UART0_Type) GetLSR_OE() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x2) >> 1
}
func (o *UART0_Type) SetLSR_PE(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x4)|value<<2)
}
func (o *UART0_Type) GetLSR_PE() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x4) >> 2
}
func (o *UART0_Type) SetLSR_FE(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x8)|value<<3)
}
func (o *UART0_Type) GetLSR_FE() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x8) >> 3
}
func (o *UART0_Type) SetLSR_BI(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x10)|value<<4)
}
func (o *UART0_Type) GetLSR_BI() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x10) >> 4
}
func (o *UART0_Type) SetLSR_THRE(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x20)|value<<5)
}
func (o *UART0_Type) GetLSR_THRE() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x20) >> 5
}
func (o *UART0_Type) SetLSR_TEMT(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x40)|value<<6)
}
func (o *UART0_Type) GetLSR_TEMT() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x40) >> 6
}
func (o *UART0_Type) SetLSR_RXFE(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x80)|value<<7)
}
func (o *UART0_Type) GetLSR_RXFE() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x80) >> 7
}
func (o *UART0_Type) SetLSR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0xffffff00)|value<<8)
}
func (o *UART0_Type) GetLSR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0xffffff00) >> 8
}

// UART0.SCR: Scratch Pad Register. 8-bit temporary storage for software.
func (o *UART0_Type) SetSCR_PAD(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0xff)|value)
}
func (o *UART0_Type) GetSCR_PAD() uint32 {
	return volatile.LoadUint32(&o.SCR.Reg) & 0xff
}
func (o *UART0_Type) SetSCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0xffffff00)|value<<8)
}
func (o *UART0_Type) GetSCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0xffffff00) >> 8
}

// UART0.ACR: Auto-baud Control Register. Contains controls for the auto-baud feature.
func (o *UART0_Type) SetACR_START(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x1)|value)
}
func (o *UART0_Type) GetACR_START() uint32 {
	return volatile.LoadUint32(&o.ACR.Reg) & 0x1
}
func (o *UART0_Type) SetACR_MODE(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x2)|value<<1)
}
func (o *UART0_Type) GetACR_MODE() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x2) >> 1
}
func (o *UART0_Type) SetACR_AUTORESTART(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x4)|value<<2)
}
func (o *UART0_Type) GetACR_AUTORESTART() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x4) >> 2
}
func (o *UART0_Type) SetACR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0xf8)|value<<3)
}
func (o *UART0_Type) GetACR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0xf8) >> 3
}
func (o *UART0_Type) SetACR_ABEOINTCLR(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x100)|value<<8)
}
func (o *UART0_Type) GetACR_ABEOINTCLR() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x100) >> 8
}
func (o *UART0_Type) SetACR_ABTOINTCLR(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x200)|value<<9)
}
func (o *UART0_Type) GetACR_ABTOINTCLR() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x200) >> 9
}
func (o *UART0_Type) SetACR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0xfffffc00)|value<<10)
}
func (o *UART0_Type) GetACR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0xfffffc00) >> 10
}

// UART0.FDR: Fractional Divider Register. Generates a clock input for the baud rate divider.
func (o *UART0_Type) SetFDR_DIVADDVAL(value uint32) {
	volatile.StoreUint32(&o.FDR.Reg, volatile.LoadUint32(&o.FDR.Reg)&^(0xf)|value)
}
func (o *UART0_Type) GetFDR_DIVADDVAL() uint32 {
	return volatile.LoadUint32(&o.FDR.Reg) & 0xf
}
func (o *UART0_Type) SetFDR_MULVAL(value uint32) {
	volatile.StoreUint32(&o.FDR.Reg, volatile.LoadUint32(&o.FDR.Reg)&^(0xf0)|value<<4)
}
func (o *UART0_Type) GetFDR_MULVAL() uint32 {
	return (volatile.LoadUint32(&o.FDR.Reg) & 0xf0) >> 4
}
func (o *UART0_Type) SetFDR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FDR.Reg, volatile.LoadUint32(&o.FDR.Reg)&^(0xffffff00)|value<<8)
}
func (o *UART0_Type) GetFDR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FDR.Reg) & 0xffffff00) >> 8
}

// UART0.TER: Transmit Enable Register. Turns off UART transmitter for use with software flow control.
func (o *UART0_Type) SetTER_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TER.Reg, volatile.LoadUint32(&o.TER.Reg)&^(0x7f)|value)
}
func (o *UART0_Type) GetTER_RESERVED() uint32 {
	return volatile.LoadUint32(&o.TER.Reg) & 0x7f
}
func (o *UART0_Type) SetTER_TXEN(value uint32) {
	volatile.StoreUint32(&o.TER.Reg, volatile.LoadUint32(&o.TER.Reg)&^(0x80)|value<<7)
}
func (o *UART0_Type) GetTER_TXEN() uint32 {
	return (volatile.LoadUint32(&o.TER.Reg) & 0x80) >> 7
}
func (o *UART0_Type) SetTER_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TER.Reg, volatile.LoadUint32(&o.TER.Reg)&^(0xffffff00)|value<<8)
}
func (o *UART0_Type) GetTER_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TER.Reg) & 0xffffff00) >> 8
}

// UART0.RS485CTRL: RS-485/EIA-485 Control. Contains controls to configure various aspects of RS-485/EIA-485 modes.
func (o *UART0_Type) SetRS485CTRL_NMMEN(value uint32) {
	volatile.StoreUint32(&o.RS485CTRL.Reg, volatile.LoadUint32(&o.RS485CTRL.Reg)&^(0x1)|value)
}
func (o *UART0_Type) GetRS485CTRL_NMMEN() uint32 {
	return volatile.LoadUint32(&o.RS485CTRL.Reg) & 0x1
}
func (o *UART0_Type) SetRS485CTRL_RXDIS(value uint32) {
	volatile.StoreUint32(&o.RS485CTRL.Reg, volatile.LoadUint32(&o.RS485CTRL.Reg)&^(0x2)|value<<1)
}
func (o *UART0_Type) GetRS485CTRL_RXDIS() uint32 {
	return (volatile.LoadUint32(&o.RS485CTRL.Reg) & 0x2) >> 1
}
func (o *UART0_Type) SetRS485CTRL_AADEN(value uint32) {
	volatile.StoreUint32(&o.RS485CTRL.Reg, volatile.LoadUint32(&o.RS485CTRL.Reg)&^(0x4)|value<<2)
}
func (o *UART0_Type) GetRS485CTRL_AADEN() uint32 {
	return (volatile.LoadUint32(&o.RS485CTRL.Reg) & 0x4) >> 2
}
func (o *UART0_Type) SetRS485CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RS485CTRL.Reg, volatile.LoadUint32(&o.RS485CTRL.Reg)&^(0x8)|value<<3)
}
func (o *UART0_Type) GetRS485CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RS485CTRL.Reg) & 0x8) >> 3
}
func (o *UART0_Type) SetRS485CTRL_DCTRL(value uint32) {
	volatile.StoreUint32(&o.RS485CTRL.Reg, volatile.LoadUint32(&o.RS485CTRL.Reg)&^(0x10)|value<<4)
}
func (o *UART0_Type) GetRS485CTRL_DCTRL() uint32 {
	return (volatile.LoadUint32(&o.RS485CTRL.Reg) & 0x10) >> 4
}
func (o *UART0_Type) SetRS485CTRL_OINV(value uint32) {
	volatile.StoreUint32(&o.RS485CTRL.Reg, volatile.LoadUint32(&o.RS485CTRL.Reg)&^(0x20)|value<<5)
}
func (o *UART0_Type) GetRS485CTRL_OINV() uint32 {
	return (volatile.LoadUint32(&o.RS485CTRL.Reg) & 0x20) >> 5
}
func (o *UART0_Type) SetRS485CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RS485CTRL.Reg, volatile.LoadUint32(&o.RS485CTRL.Reg)&^(0xffffffc0)|value<<6)
}
func (o *UART0_Type) GetRS485CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RS485CTRL.Reg) & 0xffffffc0) >> 6
}

// UART0.RS485ADRMATCH: RS-485/EIA-485 address match. Contains the address match value for RS-485/EIA-485 mode.
func (o *UART0_Type) SetRS485ADRMATCH_ADRMATCH(value uint32) {
	volatile.StoreUint32(&o.RS485ADRMATCH.Reg, volatile.LoadUint32(&o.RS485ADRMATCH.Reg)&^(0xff)|value)
}
func (o *UART0_Type) GetRS485ADRMATCH_ADRMATCH() uint32 {
	return volatile.LoadUint32(&o.RS485ADRMATCH.Reg) & 0xff
}
func (o *UART0_Type) SetRS485ADRMATCH_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RS485ADRMATCH.Reg, volatile.LoadUint32(&o.RS485ADRMATCH.Reg)&^(0xffffff00)|value<<8)
}
func (o *UART0_Type) GetRS485ADRMATCH_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RS485ADRMATCH.Reg) & 0xffffff00) >> 8
}

// UART0.RS485DLY: RS-485/EIA-485 direction control delay.
func (o *UART0_Type) SetRS485DLY_DLY(value uint32) {
	volatile.StoreUint32(&o.RS485DLY.Reg, volatile.LoadUint32(&o.RS485DLY.Reg)&^(0xff)|value)
}
func (o *UART0_Type) GetRS485DLY_DLY() uint32 {
	return volatile.LoadUint32(&o.RS485DLY.Reg) & 0xff
}
func (o *UART0_Type) SetRS485DLY_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RS485DLY.Reg, volatile.LoadUint32(&o.RS485DLY.Reg)&^(0xffffff00)|value<<8)
}
func (o *UART0_Type) GetRS485DLY_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RS485DLY.Reg) & 0xffffff00) >> 8
}

// UART1
type UART1_Type struct {
	RBR           volatile.Register32 // 0x0
	DLM           volatile.Register32 // 0x4
	IIR           volatile.Register32 // 0x8
	LCR           volatile.Register32 // 0xC
	MCR           volatile.Register32 // 0x10
	LSR           volatile.Register32 // 0x14
	MSR           volatile.Register32 // 0x18
	SCR           volatile.Register32 // 0x1C
	ACR           volatile.Register32 // 0x20
	_             [4]byte
	FDR           volatile.Register32 // 0x28
	_             [4]byte
	TER           volatile.Register32 // 0x30
	_             [24]byte
	RS485CTRL     volatile.Register32 // 0x4C
	RS485ADRMATCH volatile.Register32 // 0x50
	RS485DLY      volatile.Register32 // 0x54
}

// UART1.RBR: DLAB =0 Receiver Buffer Register. Contains the next received character to be read.
func (o *UART1_Type) SetRBR(value uint32) {
	volatile.StoreUint32(&o.RBR.Reg, volatile.LoadUint32(&o.RBR.Reg)&^(0xff)|value)
}
func (o *UART1_Type) GetRBR() uint32 {
	return volatile.LoadUint32(&o.RBR.Reg) & 0xff
}
func (o *UART1_Type) SetRBR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RBR.Reg, volatile.LoadUint32(&o.RBR.Reg)&^(0xffffff00)|value<<8)
}
func (o *UART1_Type) GetRBR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RBR.Reg) & 0xffffff00) >> 8
}

// UART1.DLM: DLAB =1. Divisor Latch MSB. Most significant byte of the baud rate divisor value. The full divisor is used to generate a baud rate from the fractional rate divider.
func (o *UART1_Type) SetDLM_DLMSB(value uint32) {
	volatile.StoreUint32(&o.DLM.Reg, volatile.LoadUint32(&o.DLM.Reg)&^(0xff)|value)
}
func (o *UART1_Type) GetDLM_DLMSB() uint32 {
	return volatile.LoadUint32(&o.DLM.Reg) & 0xff
}
func (o *UART1_Type) SetDLM_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DLM.Reg, volatile.LoadUint32(&o.DLM.Reg)&^(0xffffff00)|value<<8)
}
func (o *UART1_Type) GetDLM_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DLM.Reg) & 0xffffff00) >> 8
}

// UART1.IIR: Interrupt ID Register. Identifies which interrupt(s) are pending.
func (o *UART1_Type) SetIIR_INTSTATUS(value uint32) {
	volatile.StoreUint32(&o.IIR.Reg, volatile.LoadUint32(&o.IIR.Reg)&^(0x1)|value)
}
func (o *UART1_Type) GetIIR_INTSTATUS() uint32 {
	return volatile.LoadUint32(&o.IIR.Reg) & 0x1
}
func (o *UART1_Type) SetIIR_INTID(value uint32) {
	volatile.StoreUint32(&o.IIR.Reg, volatile.LoadUint32(&o.IIR.Reg)&^(0xe)|value<<1)
}
func (o *UART1_Type) GetIIR_INTID() uint32 {
	return (volatile.LoadUint32(&o.IIR.Reg) & 0xe) >> 1
}
func (o *UART1_Type) SetIIR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IIR.Reg, volatile.LoadUint32(&o.IIR.Reg)&^(0x30)|value<<4)
}
func (o *UART1_Type) GetIIR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IIR.Reg) & 0x30) >> 4
}
func (o *UART1_Type) SetIIR_FIFOENABLE(value uint32) {
	volatile.StoreUint32(&o.IIR.Reg, volatile.LoadUint32(&o.IIR.Reg)&^(0xc0)|value<<6)
}
func (o *UART1_Type) GetIIR_FIFOENABLE() uint32 {
	return (volatile.LoadUint32(&o.IIR.Reg) & 0xc0) >> 6
}
func (o *UART1_Type) SetIIR_ABEOINT(value uint32) {
	volatile.StoreUint32(&o.IIR.Reg, volatile.LoadUint32(&o.IIR.Reg)&^(0x100)|value<<8)
}
func (o *UART1_Type) GetIIR_ABEOINT() uint32 {
	return (volatile.LoadUint32(&o.IIR.Reg) & 0x100) >> 8
}
func (o *UART1_Type) SetIIR_ABTOINT(value uint32) {
	volatile.StoreUint32(&o.IIR.Reg, volatile.LoadUint32(&o.IIR.Reg)&^(0x200)|value<<9)
}
func (o *UART1_Type) GetIIR_ABTOINT() uint32 {
	return (volatile.LoadUint32(&o.IIR.Reg) & 0x200) >> 9
}
func (o *UART1_Type) SetIIR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IIR.Reg, volatile.LoadUint32(&o.IIR.Reg)&^(0xfffffc00)|value<<10)
}
func (o *UART1_Type) GetIIR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IIR.Reg) & 0xfffffc00) >> 10
}

// UART1.LCR: Line Control Register. Contains controls for frame formatting and break generation.
func (o *UART1_Type) SetLCR_WLS(value uint32) {
	volatile.StoreUint32(&o.LCR.Reg, volatile.LoadUint32(&o.LCR.Reg)&^(0x3)|value)
}
func (o *UART1_Type) GetLCR_WLS() uint32 {
	return volatile.LoadUint32(&o.LCR.Reg) & 0x3
}
func (o *UART1_Type) SetLCR_SBS(value uint32) {
	volatile.StoreUint32(&o.LCR.Reg, volatile.LoadUint32(&o.LCR.Reg)&^(0x4)|value<<2)
}
func (o *UART1_Type) GetLCR_SBS() uint32 {
	return (volatile.LoadUint32(&o.LCR.Reg) & 0x4) >> 2
}
func (o *UART1_Type) SetLCR_PE(value uint32) {
	volatile.StoreUint32(&o.LCR.Reg, volatile.LoadUint32(&o.LCR.Reg)&^(0x8)|value<<3)
}
func (o *UART1_Type) GetLCR_PE() uint32 {
	return (volatile.LoadUint32(&o.LCR.Reg) & 0x8) >> 3
}
func (o *UART1_Type) SetLCR_PS(value uint32) {
	volatile.StoreUint32(&o.LCR.Reg, volatile.LoadUint32(&o.LCR.Reg)&^(0x30)|value<<4)
}
func (o *UART1_Type) GetLCR_PS() uint32 {
	return (volatile.LoadUint32(&o.LCR.Reg) & 0x30) >> 4
}
func (o *UART1_Type) SetLCR_BC(value uint32) {
	volatile.StoreUint32(&o.LCR.Reg, volatile.LoadUint32(&o.LCR.Reg)&^(0x40)|value<<6)
}
func (o *UART1_Type) GetLCR_BC() uint32 {
	return (volatile.LoadUint32(&o.LCR.Reg) & 0x40) >> 6
}
func (o *UART1_Type) SetLCR_DLAB(value uint32) {
	volatile.StoreUint32(&o.LCR.Reg, volatile.LoadUint32(&o.LCR.Reg)&^(0x80)|value<<7)
}
func (o *UART1_Type) GetLCR_DLAB() uint32 {
	return (volatile.LoadUint32(&o.LCR.Reg) & 0x80) >> 7
}
func (o *UART1_Type) SetLCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.LCR.Reg, volatile.LoadUint32(&o.LCR.Reg)&^(0xffffff00)|value<<8)
}
func (o *UART1_Type) GetLCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.LCR.Reg) & 0xffffff00) >> 8
}

// UART1.MCR: Modem Control Register. Contains controls for flow control handshaking and loopback mode.
func (o *UART1_Type) SetMCR_DTRCTRL(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x1)|value)
}
func (o *UART1_Type) GetMCR_DTRCTRL() uint32 {
	return volatile.LoadUint32(&o.MCR.Reg) & 0x1
}
func (o *UART1_Type) SetMCR_RTSCTRL(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x2)|value<<1)
}
func (o *UART1_Type) GetMCR_RTSCTRL() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x2) >> 1
}
func (o *UART1_Type) SetMCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0xc)|value<<2)
}
func (o *UART1_Type) GetMCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0xc) >> 2
}
func (o *UART1_Type) SetMCR_LMS(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x10)|value<<4)
}
func (o *UART1_Type) GetMCR_LMS() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x10) >> 4
}
func (o *UART1_Type) SetMCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x20)|value<<5)
}
func (o *UART1_Type) GetMCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x20) >> 5
}
func (o *UART1_Type) SetMCR_RTSEN(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x40)|value<<6)
}
func (o *UART1_Type) GetMCR_RTSEN() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x40) >> 6
}
func (o *UART1_Type) SetMCR_CTSEN(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x80)|value<<7)
}
func (o *UART1_Type) GetMCR_CTSEN() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x80) >> 7
}
func (o *UART1_Type) SetMCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0xffffff00)|value<<8)
}
func (o *UART1_Type) GetMCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0xffffff00) >> 8
}

// UART1.LSR: Line Status Register. Contains flags for transmit and receive status, including line errors.
func (o *UART1_Type) SetLSR_RDR(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x1)|value)
}
func (o *UART1_Type) GetLSR_RDR() uint32 {
	return volatile.LoadUint32(&o.LSR.Reg) & 0x1
}
func (o *UART1_Type) SetLSR_OE(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x2)|value<<1)
}
func (o *UART1_Type) GetLSR_OE() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x2) >> 1
}
func (o *UART1_Type) SetLSR_PE(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x4)|value<<2)
}
func (o *UART1_Type) GetLSR_PE() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x4) >> 2
}
func (o *UART1_Type) SetLSR_FE(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x8)|value<<3)
}
func (o *UART1_Type) GetLSR_FE() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x8) >> 3
}
func (o *UART1_Type) SetLSR_BI(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x10)|value<<4)
}
func (o *UART1_Type) GetLSR_BI() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x10) >> 4
}
func (o *UART1_Type) SetLSR_THRE(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x20)|value<<5)
}
func (o *UART1_Type) GetLSR_THRE() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x20) >> 5
}
func (o *UART1_Type) SetLSR_TEMT(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x40)|value<<6)
}
func (o *UART1_Type) GetLSR_TEMT() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x40) >> 6
}
func (o *UART1_Type) SetLSR_RXFE(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x80)|value<<7)
}
func (o *UART1_Type) GetLSR_RXFE() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x80) >> 7
}
func (o *UART1_Type) SetLSR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0xffffff00)|value<<8)
}
func (o *UART1_Type) GetLSR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0xffffff00) >> 8
}

// UART1.MSR: Modem Status Register. Contains handshake signal status flags.
func (o *UART1_Type) SetMSR_DCTS(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x1)|value)
}
func (o *UART1_Type) GetMSR_DCTS() uint32 {
	return volatile.LoadUint32(&o.MSR.Reg) & 0x1
}
func (o *UART1_Type) SetMSR_DDSR(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x2)|value<<1)
}
func (o *UART1_Type) GetMSR_DDSR() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x2) >> 1
}
func (o *UART1_Type) SetMSR_TERI(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x4)|value<<2)
}
func (o *UART1_Type) GetMSR_TERI() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x4) >> 2
}
func (o *UART1_Type) SetMSR_DDCD(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x8)|value<<3)
}
func (o *UART1_Type) GetMSR_DDCD() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x8) >> 3
}
func (o *UART1_Type) SetMSR_CTS(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x10)|value<<4)
}
func (o *UART1_Type) GetMSR_CTS() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x10) >> 4
}
func (o *UART1_Type) SetMSR_DSR(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x20)|value<<5)
}
func (o *UART1_Type) GetMSR_DSR() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x20) >> 5
}
func (o *UART1_Type) SetMSR_RI(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x40)|value<<6)
}
func (o *UART1_Type) GetMSR_RI() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x40) >> 6
}
func (o *UART1_Type) SetMSR_DCD(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x80)|value<<7)
}
func (o *UART1_Type) GetMSR_DCD() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x80) >> 7
}
func (o *UART1_Type) SetMSR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0xffffff00)|value<<8)
}
func (o *UART1_Type) GetMSR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0xffffff00) >> 8
}

// UART1.SCR: Scratch Pad Register. 8-bit temporary storage for software.
func (o *UART1_Type) SetSCR_Pad(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0xff)|value)
}
func (o *UART1_Type) GetSCR_Pad() uint32 {
	return volatile.LoadUint32(&o.SCR.Reg) & 0xff
}
func (o *UART1_Type) SetSCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0xffffff00)|value<<8)
}
func (o *UART1_Type) GetSCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0xffffff00) >> 8
}

// UART1.ACR: Auto-baud Control Register. Contains controls for the auto-baud feature.
func (o *UART1_Type) SetACR_START(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x1)|value)
}
func (o *UART1_Type) GetACR_START() uint32 {
	return volatile.LoadUint32(&o.ACR.Reg) & 0x1
}
func (o *UART1_Type) SetACR_MODE(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x2)|value<<1)
}
func (o *UART1_Type) GetACR_MODE() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x2) >> 1
}
func (o *UART1_Type) SetACR_AUTORESTART(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x4)|value<<2)
}
func (o *UART1_Type) GetACR_AUTORESTART() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x4) >> 2
}
func (o *UART1_Type) SetACR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0xf8)|value<<3)
}
func (o *UART1_Type) GetACR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0xf8) >> 3
}
func (o *UART1_Type) SetACR_ABEOINTCLR(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x100)|value<<8)
}
func (o *UART1_Type) GetACR_ABEOINTCLR() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x100) >> 8
}
func (o *UART1_Type) SetACR_ABTOINTCLR(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x200)|value<<9)
}
func (o *UART1_Type) GetACR_ABTOINTCLR() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x200) >> 9
}
func (o *UART1_Type) SetACR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0xfffffc00)|value<<10)
}
func (o *UART1_Type) GetACR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0xfffffc00) >> 10
}

// UART1.FDR: Fractional Divider Register. Generates a clock input for the baud rate divider.
func (o *UART1_Type) SetFDR_DIVADDVAL(value uint32) {
	volatile.StoreUint32(&o.FDR.Reg, volatile.LoadUint32(&o.FDR.Reg)&^(0xf)|value)
}
func (o *UART1_Type) GetFDR_DIVADDVAL() uint32 {
	return volatile.LoadUint32(&o.FDR.Reg) & 0xf
}
func (o *UART1_Type) SetFDR_MULVAL(value uint32) {
	volatile.StoreUint32(&o.FDR.Reg, volatile.LoadUint32(&o.FDR.Reg)&^(0xf0)|value<<4)
}
func (o *UART1_Type) GetFDR_MULVAL() uint32 {
	return (volatile.LoadUint32(&o.FDR.Reg) & 0xf0) >> 4
}
func (o *UART1_Type) SetFDR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FDR.Reg, volatile.LoadUint32(&o.FDR.Reg)&^(0xffffff00)|value<<8)
}
func (o *UART1_Type) GetFDR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FDR.Reg) & 0xffffff00) >> 8
}

// UART1.TER: Transmit Enable Register. Turns off UART transmitter for use with software flow control.
func (o *UART1_Type) SetTER_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TER.Reg, volatile.LoadUint32(&o.TER.Reg)&^(0x7f)|value)
}
func (o *UART1_Type) GetTER_RESERVED() uint32 {
	return volatile.LoadUint32(&o.TER.Reg) & 0x7f
}
func (o *UART1_Type) SetTER_TXEN(value uint32) {
	volatile.StoreUint32(&o.TER.Reg, volatile.LoadUint32(&o.TER.Reg)&^(0x80)|value<<7)
}
func (o *UART1_Type) GetTER_TXEN() uint32 {
	return (volatile.LoadUint32(&o.TER.Reg) & 0x80) >> 7
}
func (o *UART1_Type) SetTER_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TER.Reg, volatile.LoadUint32(&o.TER.Reg)&^(0xffffff00)|value<<8)
}
func (o *UART1_Type) GetTER_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TER.Reg) & 0xffffff00) >> 8
}

// UART1.RS485CTRL: RS-485/EIA-485 Control. Contains controls to configure various aspects of RS-485/EIA-485 modes.
func (o *UART1_Type) SetRS485CTRL_NMMEN(value uint32) {
	volatile.StoreUint32(&o.RS485CTRL.Reg, volatile.LoadUint32(&o.RS485CTRL.Reg)&^(0x1)|value)
}
func (o *UART1_Type) GetRS485CTRL_NMMEN() uint32 {
	return volatile.LoadUint32(&o.RS485CTRL.Reg) & 0x1
}
func (o *UART1_Type) SetRS485CTRL_RXDIS(value uint32) {
	volatile.StoreUint32(&o.RS485CTRL.Reg, volatile.LoadUint32(&o.RS485CTRL.Reg)&^(0x2)|value<<1)
}
func (o *UART1_Type) GetRS485CTRL_RXDIS() uint32 {
	return (volatile.LoadUint32(&o.RS485CTRL.Reg) & 0x2) >> 1
}
func (o *UART1_Type) SetRS485CTRL_AADEN(value uint32) {
	volatile.StoreUint32(&o.RS485CTRL.Reg, volatile.LoadUint32(&o.RS485CTRL.Reg)&^(0x4)|value<<2)
}
func (o *UART1_Type) GetRS485CTRL_AADEN() uint32 {
	return (volatile.LoadUint32(&o.RS485CTRL.Reg) & 0x4) >> 2
}
func (o *UART1_Type) SetRS485CTRL_SEL(value uint32) {
	volatile.StoreUint32(&o.RS485CTRL.Reg, volatile.LoadUint32(&o.RS485CTRL.Reg)&^(0x8)|value<<3)
}
func (o *UART1_Type) GetRS485CTRL_SEL() uint32 {
	return (volatile.LoadUint32(&o.RS485CTRL.Reg) & 0x8) >> 3
}
func (o *UART1_Type) SetRS485CTRL_DCTRL(value uint32) {
	volatile.StoreUint32(&o.RS485CTRL.Reg, volatile.LoadUint32(&o.RS485CTRL.Reg)&^(0x10)|value<<4)
}
func (o *UART1_Type) GetRS485CTRL_DCTRL() uint32 {
	return (volatile.LoadUint32(&o.RS485CTRL.Reg) & 0x10) >> 4
}
func (o *UART1_Type) SetRS485CTRL_OINV(value uint32) {
	volatile.StoreUint32(&o.RS485CTRL.Reg, volatile.LoadUint32(&o.RS485CTRL.Reg)&^(0x20)|value<<5)
}
func (o *UART1_Type) GetRS485CTRL_OINV() uint32 {
	return (volatile.LoadUint32(&o.RS485CTRL.Reg) & 0x20) >> 5
}
func (o *UART1_Type) SetRS485CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RS485CTRL.Reg, volatile.LoadUint32(&o.RS485CTRL.Reg)&^(0xffffffc0)|value<<6)
}
func (o *UART1_Type) GetRS485CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RS485CTRL.Reg) & 0xffffffc0) >> 6
}

// UART1.RS485ADRMATCH: RS-485/EIA-485 address match. Contains the address match value for RS-485/EIA-485 mode.
func (o *UART1_Type) SetRS485ADRMATCH_ADRMATCH(value uint32) {
	volatile.StoreUint32(&o.RS485ADRMATCH.Reg, volatile.LoadUint32(&o.RS485ADRMATCH.Reg)&^(0xff)|value)
}
func (o *UART1_Type) GetRS485ADRMATCH_ADRMATCH() uint32 {
	return volatile.LoadUint32(&o.RS485ADRMATCH.Reg) & 0xff
}
func (o *UART1_Type) SetRS485ADRMATCH_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RS485ADRMATCH.Reg, volatile.LoadUint32(&o.RS485ADRMATCH.Reg)&^(0xffffff00)|value<<8)
}
func (o *UART1_Type) GetRS485ADRMATCH_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RS485ADRMATCH.Reg) & 0xffffff00) >> 8
}

// UART1.RS485DLY: RS-485/EIA-485 direction control delay.
func (o *UART1_Type) SetRS485DLY_DLY(value uint32) {
	volatile.StoreUint32(&o.RS485DLY.Reg, volatile.LoadUint32(&o.RS485DLY.Reg)&^(0xff)|value)
}
func (o *UART1_Type) GetRS485DLY_DLY() uint32 {
	return volatile.LoadUint32(&o.RS485DLY.Reg) & 0xff
}
func (o *UART1_Type) SetRS485DLY_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RS485DLY.Reg, volatile.LoadUint32(&o.RS485DLY.Reg)&^(0xffffff00)|value<<8)
}
func (o *UART1_Type) GetRS485DLY_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RS485DLY.Reg) & 0xffffff00) >> 8
}

// Pulse Width Modulators (PWM0/1)
type PWM_Type struct {
	IR   volatile.Register32    // 0x0
	TCR  volatile.Register32    // 0x4
	TC   volatile.Register32    // 0x8
	PR   volatile.Register32    // 0xC
	PC   volatile.Register32    // 0x10
	MCR  volatile.Register32    // 0x14
	MR0  volatile.Register32    // 0x18
	MR1  volatile.Register32    // 0x1C
	MR2  volatile.Register32    // 0x20
	MR3  volatile.Register32    // 0x24
	CCR  volatile.Register32    // 0x28
	CR   [2]volatile.Register32 // 0x2C
	_    [12]byte
	MR4  volatile.Register32 // 0x40
	MR5  volatile.Register32 // 0x44
	MR6  volatile.Register32 // 0x48
	PCR  volatile.Register32 // 0x4C
	LER  volatile.Register32 // 0x50
	_    [28]byte
	CTCR volatile.Register32 // 0x70
}

// PWM.IR: Interrupt Register. The IR can be written to clear interrupts, or read to identify which PWM interrupt sources are pending.
func (o *PWM_Type) SetIR_PWMMR0INT(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetIR_PWMMR0INT() uint32 {
	return volatile.LoadUint32(&o.IR.Reg) & 0x1
}
func (o *PWM_Type) SetIR_PWMMR1INT(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetIR_PWMMR1INT() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetIR_PWMMR2INT(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetIR_PWMMR2INT() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetIR_PWMMR3INT(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetIR_PWMMR3INT() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetIR_PWMCAP0INT(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x10)|value<<4)
}
func (o *PWM_Type) GetIR_PWMCAP0INT() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x10) >> 4
}
func (o *PWM_Type) SetIR_PWMCAP1INT(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x20)|value<<5)
}
func (o *PWM_Type) GetIR_PWMCAP1INT() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x20) >> 5
}
func (o *PWM_Type) SetIR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0xc0)|value<<6)
}
func (o *PWM_Type) GetIR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0xc0) >> 6
}
func (o *PWM_Type) SetIR_PWMMR4INT(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetIR_PWMMR4INT() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetIR_PWMMR5INT(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetIR_PWMMR5INT() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetIR_PWMMR6INT(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetIR_PWMMR6INT() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x400) >> 10
}
func (o *PWM_Type) SetIR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0xfffff800)|value<<11)
}
func (o *PWM_Type) GetIR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0xfffff800) >> 11
}

// PWM.TCR: Timer Control Register. The TCR is used to control the Timer Counter functions.
func (o *PWM_Type) SetTCR_CE(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetTCR_CE() uint32 {
	return volatile.LoadUint32(&o.TCR.Reg) & 0x1
}
func (o *PWM_Type) SetTCR_CR(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetTCR_CR() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetTCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetTCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetTCR_PWMEN(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetTCR_PWMEN() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetTCR_MDIS(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0x10)|value<<4)
}
func (o *PWM_Type) GetTCR_MDIS() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0x10) >> 4
}
func (o *PWM_Type) SetTCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0xffffffe0)|value<<5)
}
func (o *PWM_Type) GetTCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0xffffffe0) >> 5
}

// PWM.TC: Timer Counter. The 32 bit TC is incremented every PR+1 cycles of PCLK. The TC is controlled through the TCR.
func (o *PWM_Type) SetTC(value uint32) {
	volatile.StoreUint32(&o.TC.Reg, value)
}
func (o *PWM_Type) GetTC() uint32 {
	return volatile.LoadUint32(&o.TC.Reg)
}

// PWM.PR: Prescale Register. Determines how often the PWM counter is incremented.
func (o *PWM_Type) SetPR(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, value)
}
func (o *PWM_Type) GetPR() uint32 {
	return volatile.LoadUint32(&o.PR.Reg)
}

// PWM.PC: Prescale Counter. Prescaler for the main PWM counter.
func (o *PWM_Type) SetPC(value uint32) {
	volatile.StoreUint32(&o.PC.Reg, value)
}
func (o *PWM_Type) GetPC() uint32 {
	return volatile.LoadUint32(&o.PC.Reg)
}

// PWM.MCR: Match Control Register. The MCR is used to control whether an interrupt is generated and if the PWM counter is reset when a Match occurs.
func (o *PWM_Type) SetMCR_PWMMR0I(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetMCR_PWMMR0I() uint32 {
	return volatile.LoadUint32(&o.MCR.Reg) & 0x1
}
func (o *PWM_Type) SetMCR_PWMMR0R(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetMCR_PWMMR0R() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetMCR_PWMMR0S(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetMCR_PWMMR0S() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetMCR_PWMMR1I(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetMCR_PWMMR1I() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetMCR_PWMMR1R(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x10)|value<<4)
}
func (o *PWM_Type) GetMCR_PWMMR1R() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x10) >> 4
}
func (o *PWM_Type) SetMCR_PWMMR1S(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x20)|value<<5)
}
func (o *PWM_Type) GetMCR_PWMMR1S() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x20) >> 5
}
func (o *PWM_Type) SetMCR_PWMMR2I(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x40)|value<<6)
}
func (o *PWM_Type) GetMCR_PWMMR2I() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x40) >> 6
}
func (o *PWM_Type) SetMCR_PWMMR2R(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x80)|value<<7)
}
func (o *PWM_Type) GetMCR_PWMMR2R() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x80) >> 7
}
func (o *PWM_Type) SetMCR_PWMMR2S(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetMCR_PWMMR2S() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetMCR_PWMMR3I(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetMCR_PWMMR3I() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetMCR_PWMMR3R(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetMCR_PWMMR3R() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x400) >> 10
}
func (o *PWM_Type) SetMCR_PWMMR3S(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x800)|value<<11)
}
func (o *PWM_Type) GetMCR_PWMMR3S() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x800) >> 11
}
func (o *PWM_Type) SetMCR_PWMMR4I(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x1000)|value<<12)
}
func (o *PWM_Type) GetMCR_PWMMR4I() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x1000) >> 12
}
func (o *PWM_Type) SetMCR_PWMMR4R(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x2000)|value<<13)
}
func (o *PWM_Type) GetMCR_PWMMR4R() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x2000) >> 13
}
func (o *PWM_Type) SetMCR_PWMMR4S(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x4000)|value<<14)
}
func (o *PWM_Type) GetMCR_PWMMR4S() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x4000) >> 14
}
func (o *PWM_Type) SetMCR_PWMMR5I(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x8000)|value<<15)
}
func (o *PWM_Type) GetMCR_PWMMR5I() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x8000) >> 15
}
func (o *PWM_Type) SetMCR_PWMMR5R(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetMCR_PWMMR5R() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetMCR_PWMMR5S(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetMCR_PWMMR5S() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetMCR_PWMMR6I(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetMCR_PWMMR6I() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetMCR_PWMMR6R(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetMCR_PWMMR6R() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x80000) >> 19
}
func (o *PWM_Type) SetMCR_PWMMR6S(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x100000)|value<<20)
}
func (o *PWM_Type) GetMCR_PWMMR6S() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x100000) >> 20
}
func (o *PWM_Type) SetMCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0xffe00000)|value<<21)
}
func (o *PWM_Type) GetMCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0xffe00000) >> 21
}

// PWM.MR0: Match Register. Match registers are continuously compared to the PWM counter in order to control PWM output edges.
func (o *PWM_Type) SetMR0(value uint32) {
	volatile.StoreUint32(&o.MR0.Reg, value)
}
func (o *PWM_Type) GetMR0() uint32 {
	return volatile.LoadUint32(&o.MR0.Reg)
}

// PWM.MR1: Match Register. Match registers are continuously compared to the PWM counter in order to control PWM output edges.
func (o *PWM_Type) SetMR1(value uint32) {
	volatile.StoreUint32(&o.MR1.Reg, value)
}
func (o *PWM_Type) GetMR1() uint32 {
	return volatile.LoadUint32(&o.MR1.Reg)
}

// PWM.MR2: Match Register. Match registers are continuously compared to the PWM counter in order to control PWM output edges.
func (o *PWM_Type) SetMR2(value uint32) {
	volatile.StoreUint32(&o.MR2.Reg, value)
}
func (o *PWM_Type) GetMR2() uint32 {
	return volatile.LoadUint32(&o.MR2.Reg)
}

// PWM.MR3: Match Register. Match registers are continuously compared to the PWM counter in order to control PWM output edges.
func (o *PWM_Type) SetMR3(value uint32) {
	volatile.StoreUint32(&o.MR3.Reg, value)
}
func (o *PWM_Type) GetMR3() uint32 {
	return volatile.LoadUint32(&o.MR3.Reg)
}

// PWM.CCR: Capture Control Register. The CCR controls which edges of the capture inputs are used to load the Capture Registers and whether or not an interrupt is generated for a capture event.
func (o *PWM_Type) SetCCR_CAP0_R(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCCR_CAP0_R() uint32 {
	return volatile.LoadUint32(&o.CCR.Reg) & 0x1
}
func (o *PWM_Type) SetCCR_CAP0_F(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetCCR_CAP0_F() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetCCR_CAP0_I(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetCCR_CAP0_I() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetCCR_CAP1_R(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetCCR_CAP1_R() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetCCR_CAP1_F(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x10)|value<<4)
}
func (o *PWM_Type) GetCCR_CAP1_F() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x10) >> 4
}
func (o *PWM_Type) SetCCR_CAP1_I(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x20)|value<<5)
}
func (o *PWM_Type) GetCCR_CAP1_I() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x20) >> 5
}
func (o *PWM_Type) SetCCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0xffffffc0)|value<<6)
}
func (o *PWM_Type) GetCCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0xffffffc0) >> 6
}

// PWM.CR: PWM Control Register. Enables PWM outputs and selects either single edge or double edge controlled PWM outputs.
func (o *PWM_Type) SetCR_RESERVED(idx int, value uint32) {
	volatile.StoreUint32(&o.CR[idx].Reg, volatile.LoadUint32(&o.CR[idx].Reg)&^(0x3)|value)
}
func (o *PWM_Type) GetCR_RESERVED(idx int) uint32 {
	return volatile.LoadUint32(&o.CR[idx].Reg) & 0x3
}
func (o *PWM_Type) SetCR_PWMSEL2(idx int, value uint32) {
	volatile.StoreUint32(&o.CR[idx].Reg, volatile.LoadUint32(&o.CR[idx].Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetCR_PWMSEL2(idx int) uint32 {
	return (volatile.LoadUint32(&o.CR[idx].Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetCR_PWMSEL3(idx int, value uint32) {
	volatile.StoreUint32(&o.CR[idx].Reg, volatile.LoadUint32(&o.CR[idx].Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetCR_PWMSEL3(idx int) uint32 {
	return (volatile.LoadUint32(&o.CR[idx].Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetCR_PWMSEL4(idx int, value uint32) {
	volatile.StoreUint32(&o.CR[idx].Reg, volatile.LoadUint32(&o.CR[idx].Reg)&^(0x10)|value<<4)
}
func (o *PWM_Type) GetCR_PWMSEL4(idx int) uint32 {
	return (volatile.LoadUint32(&o.CR[idx].Reg) & 0x10) >> 4
}
func (o *PWM_Type) SetCR_PWMSEL5(idx int, value uint32) {
	volatile.StoreUint32(&o.CR[idx].Reg, volatile.LoadUint32(&o.CR[idx].Reg)&^(0x20)|value<<5)
}
func (o *PWM_Type) GetCR_PWMSEL5(idx int) uint32 {
	return (volatile.LoadUint32(&o.CR[idx].Reg) & 0x20) >> 5
}
func (o *PWM_Type) SetCR_PWMSEL6(idx int, value uint32) {
	volatile.StoreUint32(&o.CR[idx].Reg, volatile.LoadUint32(&o.CR[idx].Reg)&^(0x40)|value<<6)
}
func (o *PWM_Type) GetCR_PWMSEL6(idx int) uint32 {
	return (volatile.LoadUint32(&o.CR[idx].Reg) & 0x40) >> 6
}
func (o *PWM_Type) SetCR_RESERVED(idx int, value uint32) {
	volatile.StoreUint32(&o.CR[idx].Reg, volatile.LoadUint32(&o.CR[idx].Reg)&^(0x180)|value<<7)
}
func (o *PWM_Type) GetCR_RESERVED(idx int) uint32 {
	return (volatile.LoadUint32(&o.CR[idx].Reg) & 0x180) >> 7
}
func (o *PWM_Type) SetCR_PWMENA1(idx int, value uint32) {
	volatile.StoreUint32(&o.CR[idx].Reg, volatile.LoadUint32(&o.CR[idx].Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetCR_PWMENA1(idx int) uint32 {
	return (volatile.LoadUint32(&o.CR[idx].Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetCR_PWMENA2(idx int, value uint32) {
	volatile.StoreUint32(&o.CR[idx].Reg, volatile.LoadUint32(&o.CR[idx].Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetCR_PWMENA2(idx int) uint32 {
	return (volatile.LoadUint32(&o.CR[idx].Reg) & 0x400) >> 10
}
func (o *PWM_Type) SetCR_PWMENA3(idx int, value uint32) {
	volatile.StoreUint32(&o.CR[idx].Reg, volatile.LoadUint32(&o.CR[idx].Reg)&^(0x800)|value<<11)
}
func (o *PWM_Type) GetCR_PWMENA3(idx int) uint32 {
	return (volatile.LoadUint32(&o.CR[idx].Reg) & 0x800) >> 11
}
func (o *PWM_Type) SetCR_PWMENA4(idx int, value uint32) {
	volatile.StoreUint32(&o.CR[idx].Reg, volatile.LoadUint32(&o.CR[idx].Reg)&^(0x1000)|value<<12)
}
func (o *PWM_Type) GetCR_PWMENA4(idx int) uint32 {
	return (volatile.LoadUint32(&o.CR[idx].Reg) & 0x1000) >> 12
}
func (o *PWM_Type) SetCR_PWMENA5(idx int, value uint32) {
	volatile.StoreUint32(&o.CR[idx].Reg, volatile.LoadUint32(&o.CR[idx].Reg)&^(0x2000)|value<<13)
}
func (o *PWM_Type) GetCR_PWMENA5(idx int) uint32 {
	return (volatile.LoadUint32(&o.CR[idx].Reg) & 0x2000) >> 13
}
func (o *PWM_Type) SetCR_PWMENA6(idx int, value uint32) {
	volatile.StoreUint32(&o.CR[idx].Reg, volatile.LoadUint32(&o.CR[idx].Reg)&^(0x4000)|value<<14)
}
func (o *PWM_Type) GetCR_PWMENA6(idx int) uint32 {
	return (volatile.LoadUint32(&o.CR[idx].Reg) & 0x4000) >> 14
}
func (o *PWM_Type) SetCR_RESERVED(idx int, value uint32) {
	volatile.StoreUint32(&o.CR[idx].Reg, volatile.LoadUint32(&o.CR[idx].Reg)&^(0xffff8000)|value<<15)
}
func (o *PWM_Type) GetCR_RESERVED(idx int) uint32 {
	return (volatile.LoadUint32(&o.CR[idx].Reg) & 0xffff8000) >> 15
}

// PWM.MR4: Match Register. Match registers are continuously compared to the PWM counter in order to control PWM output edges.
func (o *PWM_Type) SetMR4(value uint32) {
	volatile.StoreUint32(&o.MR4.Reg, value)
}
func (o *PWM_Type) GetMR4() uint32 {
	return volatile.LoadUint32(&o.MR4.Reg)
}

// PWM.MR5: Match Register. Match registers are continuously compared to the PWM counter in order to control PWM output edges.
func (o *PWM_Type) SetMR5(value uint32) {
	volatile.StoreUint32(&o.MR5.Reg, value)
}
func (o *PWM_Type) GetMR5() uint32 {
	return volatile.LoadUint32(&o.MR5.Reg)
}

// PWM.MR6: Match Register. Match registers are continuously compared to the PWM counter in order to control PWM output edges.
func (o *PWM_Type) SetMR6(value uint32) {
	volatile.StoreUint32(&o.MR6.Reg, value)
}
func (o *PWM_Type) GetMR6() uint32 {
	return volatile.LoadUint32(&o.MR6.Reg)
}

// PWM.PCR: PWM Control Register. Enables PWM outputs and selects either single edge or double edge controlled PWM outputs.
func (o *PWM_Type) SetPCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x3)|value)
}
func (o *PWM_Type) GetPCR_RESERVED() uint32 {
	return volatile.LoadUint32(&o.PCR.Reg) & 0x3
}
func (o *PWM_Type) SetPCR_PWMSEL2(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetPCR_PWMSEL2() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetPCR_PWMSEL3(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetPCR_PWMSEL3() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetPCR_PWMSEL4(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x10)|value<<4)
}
func (o *PWM_Type) GetPCR_PWMSEL4() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x10) >> 4
}
func (o *PWM_Type) SetPCR_PWMSEL5(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x20)|value<<5)
}
func (o *PWM_Type) GetPCR_PWMSEL5() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x20) >> 5
}
func (o *PWM_Type) SetPCR_PWMSEL6(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x40)|value<<6)
}
func (o *PWM_Type) GetPCR_PWMSEL6() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x40) >> 6
}
func (o *PWM_Type) SetPCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x180)|value<<7)
}
func (o *PWM_Type) GetPCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x180) >> 7
}
func (o *PWM_Type) SetPCR_PWMENA1(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetPCR_PWMENA1() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetPCR_PWMENA2(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetPCR_PWMENA2() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x400) >> 10
}
func (o *PWM_Type) SetPCR_PWMENA3(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x800)|value<<11)
}
func (o *PWM_Type) GetPCR_PWMENA3() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x800) >> 11
}
func (o *PWM_Type) SetPCR_PWMENA4(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x1000)|value<<12)
}
func (o *PWM_Type) GetPCR_PWMENA4() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x1000) >> 12
}
func (o *PWM_Type) SetPCR_PWMENA5(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x2000)|value<<13)
}
func (o *PWM_Type) GetPCR_PWMENA5() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x2000) >> 13
}
func (o *PWM_Type) SetPCR_PWMENA6(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x4000)|value<<14)
}
func (o *PWM_Type) GetPCR_PWMENA6() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x4000) >> 14
}
func (o *PWM_Type) SetPCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0xffff8000)|value<<15)
}
func (o *PWM_Type) GetPCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0xffff8000) >> 15
}

// PWM.LER: Load Enable Register. Enables use of updated PWM match values.
func (o *PWM_Type) SetLER_MAT0LATCHEN(value uint32) {
	volatile.StoreUint32(&o.LER.Reg, volatile.LoadUint32(&o.LER.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetLER_MAT0LATCHEN() uint32 {
	return volatile.LoadUint32(&o.LER.Reg) & 0x1
}
func (o *PWM_Type) SetLER_MAT1LATCHEN(value uint32) {
	volatile.StoreUint32(&o.LER.Reg, volatile.LoadUint32(&o.LER.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetLER_MAT1LATCHEN() uint32 {
	return (volatile.LoadUint32(&o.LER.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetLER_MAT2LATCHEN(value uint32) {
	volatile.StoreUint32(&o.LER.Reg, volatile.LoadUint32(&o.LER.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetLER_MAT2LATCHEN() uint32 {
	return (volatile.LoadUint32(&o.LER.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetLER_MAT3LATCHEN(value uint32) {
	volatile.StoreUint32(&o.LER.Reg, volatile.LoadUint32(&o.LER.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetLER_MAT3LATCHEN() uint32 {
	return (volatile.LoadUint32(&o.LER.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetLER_MAT4LATCHEN(value uint32) {
	volatile.StoreUint32(&o.LER.Reg, volatile.LoadUint32(&o.LER.Reg)&^(0x10)|value<<4)
}
func (o *PWM_Type) GetLER_MAT4LATCHEN() uint32 {
	return (volatile.LoadUint32(&o.LER.Reg) & 0x10) >> 4
}
func (o *PWM_Type) SetLER_MAT5LATCHEN(value uint32) {
	volatile.StoreUint32(&o.LER.Reg, volatile.LoadUint32(&o.LER.Reg)&^(0x20)|value<<5)
}
func (o *PWM_Type) GetLER_MAT5LATCHEN() uint32 {
	return (volatile.LoadUint32(&o.LER.Reg) & 0x20) >> 5
}
func (o *PWM_Type) SetLER_MAT6LATCHEN(value uint32) {
	volatile.StoreUint32(&o.LER.Reg, volatile.LoadUint32(&o.LER.Reg)&^(0x40)|value<<6)
}
func (o *PWM_Type) GetLER_MAT6LATCHEN() uint32 {
	return (volatile.LoadUint32(&o.LER.Reg) & 0x40) >> 6
}
func (o *PWM_Type) SetLER_RESERVED(value uint32) {
	volatile.StoreUint32(&o.LER.Reg, volatile.LoadUint32(&o.LER.Reg)&^(0xffffff80)|value<<7)
}
func (o *PWM_Type) GetLER_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.LER.Reg) & 0xffffff80) >> 7
}

// PWM.CTCR: Count Control Register. The CTCR selects between Timer and Counter mode, and in Counter mode selects the signal and edge(s) for counting.
func (o *PWM_Type) SetCTCR_MOD(value uint32) {
	volatile.StoreUint32(&o.CTCR.Reg, volatile.LoadUint32(&o.CTCR.Reg)&^(0x3)|value)
}
func (o *PWM_Type) GetCTCR_MOD() uint32 {
	return volatile.LoadUint32(&o.CTCR.Reg) & 0x3
}
func (o *PWM_Type) SetCTCR_CIS(value uint32) {
	volatile.StoreUint32(&o.CTCR.Reg, volatile.LoadUint32(&o.CTCR.Reg)&^(0xc)|value<<2)
}
func (o *PWM_Type) GetCTCR_CIS() uint32 {
	return (volatile.LoadUint32(&o.CTCR.Reg) & 0xc) >> 2
}
func (o *PWM_Type) SetCTCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTCR.Reg, volatile.LoadUint32(&o.CTCR.Reg)&^(0xfffffff0)|value<<4)
}
func (o *PWM_Type) GetCTCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTCR.Reg) & 0xfffffff0) >> 4
}

// I2C bus interface
type I2C_Type struct {
	CONSET      volatile.Register32    // 0x0
	STAT        volatile.Register32    // 0x4
	DAT         volatile.Register32    // 0x8
	ADR0        volatile.Register32    // 0xC
	SCLH        volatile.Register32    // 0x10
	SCLL        volatile.Register32    // 0x14
	CONCLR      volatile.Register32    // 0x18
	MMCTRL      volatile.Register32    // 0x1C
	ADR1        volatile.Register32    // 0x20
	ADR2        volatile.Register32    // 0x24
	ADR3        volatile.Register32    // 0x28
	DATA_BUFFER volatile.Register32    // 0x2C
	MASK        [4]volatile.Register32 // 0x30
}

// I2C.CONSET: I2C Control Set Register. When a one is written to a bit of this register, the corresponding bit in the I2C control register is set. Writing a zero has no effect on the corresponding bit in the I2C control register.
func (o *I2C_Type) SetCONSET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONSET.Reg, volatile.LoadUint32(&o.CONSET.Reg)&^(0x3)|value)
}
func (o *I2C_Type) GetCONSET_RESERVED() uint32 {
	return volatile.LoadUint32(&o.CONSET.Reg) & 0x3
}
func (o *I2C_Type) SetCONSET_AA(value uint32) {
	volatile.StoreUint32(&o.CONSET.Reg, volatile.LoadUint32(&o.CONSET.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetCONSET_AA() uint32 {
	return (volatile.LoadUint32(&o.CONSET.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetCONSET_SI(value uint32) {
	volatile.StoreUint32(&o.CONSET.Reg, volatile.LoadUint32(&o.CONSET.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetCONSET_SI() uint32 {
	return (volatile.LoadUint32(&o.CONSET.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetCONSET_STO(value uint32) {
	volatile.StoreUint32(&o.CONSET.Reg, volatile.LoadUint32(&o.CONSET.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetCONSET_STO() uint32 {
	return (volatile.LoadUint32(&o.CONSET.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetCONSET_STA(value uint32) {
	volatile.StoreUint32(&o.CONSET.Reg, volatile.LoadUint32(&o.CONSET.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetCONSET_STA() uint32 {
	return (volatile.LoadUint32(&o.CONSET.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetCONSET_I2EN(value uint32) {
	volatile.StoreUint32(&o.CONSET.Reg, volatile.LoadUint32(&o.CONSET.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetCONSET_I2EN() uint32 {
	return (volatile.LoadUint32(&o.CONSET.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetCONSET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONSET.Reg, volatile.LoadUint32(&o.CONSET.Reg)&^(0xffffff80)|value<<7)
}
func (o *I2C_Type) GetCONSET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONSET.Reg) & 0xffffff80) >> 7
}

// I2C.STAT: I2C Status Register. During I2C operation, this register provides detailed status codes that allow software to determine the next action needed.
func (o *I2C_Type) SetSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x7)|value)
}
func (o *I2C_Type) GetSTAT_RESERVED() uint32 {
	return volatile.LoadUint32(&o.STAT.Reg) & 0x7
}
func (o *I2C_Type) SetSTAT_Status(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0xf8)|value<<3)
}
func (o *I2C_Type) GetSTAT_Status() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0xf8) >> 3
}
func (o *I2C_Type) SetSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0xffffff00)|value<<8)
}
func (o *I2C_Type) GetSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0xffffff00) >> 8
}

// I2C.DAT: I2C Data Register. During master or slave transmit mode, data to be transmitted is written to this register. During master or slave receive mode, data that has been received may be read from this register.
func (o *I2C_Type) SetDAT_Data(value uint32) {
	volatile.StoreUint32(&o.DAT.Reg, volatile.LoadUint32(&o.DAT.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetDAT_Data() uint32 {
	return volatile.LoadUint32(&o.DAT.Reg) & 0xff
}
func (o *I2C_Type) SetDAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DAT.Reg, volatile.LoadUint32(&o.DAT.Reg)&^(0xffffff00)|value<<8)
}
func (o *I2C_Type) GetDAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DAT.Reg) & 0xffffff00) >> 8
}

// I2C.ADR0: I2C Slave Address Register 0. Contains the 7-bit slave address for operation of the I2C interface in slave mode, and is not used in master mode. The least significant bit determines whether a slave responds to the General Call address.
func (o *I2C_Type) SetADR0_GC(value uint32) {
	volatile.StoreUint32(&o.ADR0.Reg, volatile.LoadUint32(&o.ADR0.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetADR0_GC() uint32 {
	return volatile.LoadUint32(&o.ADR0.Reg) & 0x1
}
func (o *I2C_Type) SetADR0_Address(value uint32) {
	volatile.StoreUint32(&o.ADR0.Reg, volatile.LoadUint32(&o.ADR0.Reg)&^(0xfe)|value<<1)
}
func (o *I2C_Type) GetADR0_Address() uint32 {
	return (volatile.LoadUint32(&o.ADR0.Reg) & 0xfe) >> 1
}
func (o *I2C_Type) SetADR0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ADR0.Reg, volatile.LoadUint32(&o.ADR0.Reg)&^(0xffffff00)|value<<8)
}
func (o *I2C_Type) GetADR0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ADR0.Reg) & 0xffffff00) >> 8
}

// I2C.SCLH: SCH Duty Cycle Register High Half Word. Determines the high time of the I2C clock.
func (o *I2C_Type) SetSCLH(value uint32) {
	volatile.StoreUint32(&o.SCLH.Reg, volatile.LoadUint32(&o.SCLH.Reg)&^(0xffff)|value)
}
func (o *I2C_Type) GetSCLH() uint32 {
	return volatile.LoadUint32(&o.SCLH.Reg) & 0xffff
}
func (o *I2C_Type) SetSCLH_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SCLH.Reg, volatile.LoadUint32(&o.SCLH.Reg)&^(0xffff0000)|value<<16)
}
func (o *I2C_Type) GetSCLH_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SCLH.Reg) & 0xffff0000) >> 16
}

// I2C.SCLL: SCL Duty Cycle Register Low Half Word. Determines the low time of the I2C clock. SCLL and SCLH together determine the clock frequency generated by an I2C master and certain times used in slave mode.
func (o *I2C_Type) SetSCLL(value uint32) {
	volatile.StoreUint32(&o.SCLL.Reg, volatile.LoadUint32(&o.SCLL.Reg)&^(0xffff)|value)
}
func (o *I2C_Type) GetSCLL() uint32 {
	return volatile.LoadUint32(&o.SCLL.Reg) & 0xffff
}
func (o *I2C_Type) SetSCLL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SCLL.Reg, volatile.LoadUint32(&o.SCLL.Reg)&^(0xffff0000)|value<<16)
}
func (o *I2C_Type) GetSCLL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SCLL.Reg) & 0xffff0000) >> 16
}

// I2C.CONCLR: I2C Control Clear Register. When a one is written to a bit of this register, the corresponding bit in the I2C control register is cleared. Writing a zero has no effect on the corresponding bit in the I2C control register.
func (o *I2C_Type) SetCONCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONCLR.Reg, volatile.LoadUint32(&o.CONCLR.Reg)&^(0x3)|value)
}
func (o *I2C_Type) GetCONCLR_RESERVED() uint32 {
	return volatile.LoadUint32(&o.CONCLR.Reg) & 0x3
}
func (o *I2C_Type) SetCONCLR_AAC(value uint32) {
	volatile.StoreUint32(&o.CONCLR.Reg, volatile.LoadUint32(&o.CONCLR.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetCONCLR_AAC() uint32 {
	return (volatile.LoadUint32(&o.CONCLR.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetCONCLR_SIC(value uint32) {
	volatile.StoreUint32(&o.CONCLR.Reg, volatile.LoadUint32(&o.CONCLR.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetCONCLR_SIC() uint32 {
	return (volatile.LoadUint32(&o.CONCLR.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetCONCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONCLR.Reg, volatile.LoadUint32(&o.CONCLR.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetCONCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONCLR.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetCONCLR_STAC(value uint32) {
	volatile.StoreUint32(&o.CONCLR.Reg, volatile.LoadUint32(&o.CONCLR.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetCONCLR_STAC() uint32 {
	return (volatile.LoadUint32(&o.CONCLR.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetCONCLR_I2ENC(value uint32) {
	volatile.StoreUint32(&o.CONCLR.Reg, volatile.LoadUint32(&o.CONCLR.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetCONCLR_I2ENC() uint32 {
	return (volatile.LoadUint32(&o.CONCLR.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetCONCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONCLR.Reg, volatile.LoadUint32(&o.CONCLR.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetCONCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONCLR.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetCONCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONCLR.Reg, volatile.LoadUint32(&o.CONCLR.Reg)&^(0xffffff00)|value<<8)
}
func (o *I2C_Type) GetCONCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONCLR.Reg) & 0xffffff00) >> 8
}

// I2C.MMCTRL: Monitor mode control register.
func (o *I2C_Type) SetMMCTRL_MM_ENA(value uint32) {
	volatile.StoreUint32(&o.MMCTRL.Reg, volatile.LoadUint32(&o.MMCTRL.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetMMCTRL_MM_ENA() uint32 {
	return volatile.LoadUint32(&o.MMCTRL.Reg) & 0x1
}
func (o *I2C_Type) SetMMCTRL_ENA_SCL(value uint32) {
	volatile.StoreUint32(&o.MMCTRL.Reg, volatile.LoadUint32(&o.MMCTRL.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetMMCTRL_ENA_SCL() uint32 {
	return (volatile.LoadUint32(&o.MMCTRL.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetMMCTRL_MATCH_ALL(value uint32) {
	volatile.StoreUint32(&o.MMCTRL.Reg, volatile.LoadUint32(&o.MMCTRL.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetMMCTRL_MATCH_ALL() uint32 {
	return (volatile.LoadUint32(&o.MMCTRL.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetMMCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MMCTRL.Reg, volatile.LoadUint32(&o.MMCTRL.Reg)&^(0xfffffff8)|value<<3)
}
func (o *I2C_Type) GetMMCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MMCTRL.Reg) & 0xfffffff8) >> 3
}

// I2C.ADR1: I2C Slave Address Register. Contains the 7-bit slave address for operation of the I2C interface in slave mode, and is not used in master mode. The least significant bit determines whether a slave responds to the General Call address.
func (o *I2C_Type) SetADR1_GC(value uint32) {
	volatile.StoreUint32(&o.ADR1.Reg, volatile.LoadUint32(&o.ADR1.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetADR1_GC() uint32 {
	return volatile.LoadUint32(&o.ADR1.Reg) & 0x1
}
func (o *I2C_Type) SetADR1_Address(value uint32) {
	volatile.StoreUint32(&o.ADR1.Reg, volatile.LoadUint32(&o.ADR1.Reg)&^(0xfe)|value<<1)
}
func (o *I2C_Type) GetADR1_Address() uint32 {
	return (volatile.LoadUint32(&o.ADR1.Reg) & 0xfe) >> 1
}
func (o *I2C_Type) SetADR1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ADR1.Reg, volatile.LoadUint32(&o.ADR1.Reg)&^(0xffffff00)|value<<8)
}
func (o *I2C_Type) GetADR1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ADR1.Reg) & 0xffffff00) >> 8
}

// I2C.ADR2: I2C Slave Address Register. Contains the 7-bit slave address for operation of the I2C interface in slave mode, and is not used in master mode. The least significant bit determines whether a slave responds to the General Call address.
func (o *I2C_Type) SetADR2_GC(value uint32) {
	volatile.StoreUint32(&o.ADR2.Reg, volatile.LoadUint32(&o.ADR2.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetADR2_GC() uint32 {
	return volatile.LoadUint32(&o.ADR2.Reg) & 0x1
}
func (o *I2C_Type) SetADR2_Address(value uint32) {
	volatile.StoreUint32(&o.ADR2.Reg, volatile.LoadUint32(&o.ADR2.Reg)&^(0xfe)|value<<1)
}
func (o *I2C_Type) GetADR2_Address() uint32 {
	return (volatile.LoadUint32(&o.ADR2.Reg) & 0xfe) >> 1
}
func (o *I2C_Type) SetADR2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ADR2.Reg, volatile.LoadUint32(&o.ADR2.Reg)&^(0xffffff00)|value<<8)
}
func (o *I2C_Type) GetADR2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ADR2.Reg) & 0xffffff00) >> 8
}

// I2C.ADR3: I2C Slave Address Register. Contains the 7-bit slave address for operation of the I2C interface in slave mode, and is not used in master mode. The least significant bit determines whether a slave responds to the General Call address.
func (o *I2C_Type) SetADR3_GC(value uint32) {
	volatile.StoreUint32(&o.ADR3.Reg, volatile.LoadUint32(&o.ADR3.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetADR3_GC() uint32 {
	return volatile.LoadUint32(&o.ADR3.Reg) & 0x1
}
func (o *I2C_Type) SetADR3_Address(value uint32) {
	volatile.StoreUint32(&o.ADR3.Reg, volatile.LoadUint32(&o.ADR3.Reg)&^(0xfe)|value<<1)
}
func (o *I2C_Type) GetADR3_Address() uint32 {
	return (volatile.LoadUint32(&o.ADR3.Reg) & 0xfe) >> 1
}
func (o *I2C_Type) SetADR3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ADR3.Reg, volatile.LoadUint32(&o.ADR3.Reg)&^(0xffffff00)|value<<8)
}
func (o *I2C_Type) GetADR3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ADR3.Reg) & 0xffffff00) >> 8
}

// I2C.DATA_BUFFER: Data buffer register. The contents of the 8 MSBs of the DAT shift register will be transferred to the DATA_BUFFER automatically after every nine bits (8 bits of data plus ACK or NACK) has been received on the bus.
func (o *I2C_Type) SetDATA_BUFFER_Data(value uint32) {
	volatile.StoreUint32(&o.DATA_BUFFER.Reg, volatile.LoadUint32(&o.DATA_BUFFER.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetDATA_BUFFER_Data() uint32 {
	return volatile.LoadUint32(&o.DATA_BUFFER.Reg) & 0xff
}
func (o *I2C_Type) SetDATA_BUFFER_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DATA_BUFFER.Reg, volatile.LoadUint32(&o.DATA_BUFFER.Reg)&^(0xffffff00)|value<<8)
}
func (o *I2C_Type) GetDATA_BUFFER_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DATA_BUFFER.Reg) & 0xffffff00) >> 8
}

// I2C.MASK: I2C Slave address mask register
func (o *I2C_Type) SetMASK_RESERVED(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetMASK_RESERVED(idx int) uint32 {
	return volatile.LoadUint32(&o.MASK[idx].Reg) & 0x1
}
func (o *I2C_Type) SetMASK(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0xfe)|value<<1)
}
func (o *I2C_Type) GetMASK(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0xfe) >> 1
}
func (o *I2C_Type) SetMASK_RESERVED(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0xffffff00)|value<<8)
}
func (o *I2C_Type) GetMASK_RESERVED(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0xffffff00) >> 8
}

// Comparators
type COMPARATOR_Type struct {
	CTRL  volatile.Register32 // 0x0
	CTRL0 volatile.Register32 // 0x4
	CTRL1 volatile.Register32 // 0x8
}

// COMPARATOR.CTRL: Comparator block control register
func (o *COMPARATOR_Type) SetCTRL_CMP_PD_IREF(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x3)|value)
}
func (o *COMPARATOR_Type) GetCTRL_CMP_PD_IREF() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x3
}
func (o *COMPARATOR_Type) SetCTRL_CMP_PD_VBG(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xc)|value<<2)
}
func (o *COMPARATOR_Type) GetCTRL_CMP_PD_VBG() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xc) >> 2
}
func (o *COMPARATOR_Type) SetCTRL_CMP_VTEMP(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x30)|value<<4)
}
func (o *COMPARATOR_Type) GetCTRL_CMP_VTEMP() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x30) >> 4
}
func (o *COMPARATOR_Type) SetCTRL_CMP_TEMPSEN(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xc0)|value<<6)
}
func (o *COMPARATOR_Type) GetCTRL_CMP_TEMPSEN() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xc0) >> 6
}
func (o *COMPARATOR_Type) SetCTRL_CMP_ROSCCTL(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x100)|value<<8)
}
func (o *COMPARATOR_Type) GetCTRL_CMP_ROSCCTL() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x100) >> 8
}
func (o *COMPARATOR_Type) SetCTRL_CMP_EXT_RESET(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x200)|value<<9)
}
func (o *COMPARATOR_Type) GetCTRL_CMP_EXT_RESET() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x200) >> 9
}
func (o *COMPARATOR_Type) SetCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xc00)|value<<10)
}
func (o *COMPARATOR_Type) GetCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xc00) >> 10
}
func (o *COMPARATOR_Type) SetCTRL_CMP_T0CAP2(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1000)|value<<12)
}
func (o *COMPARATOR_Type) GetCTRL_CMP_T0CAP2() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x1000) >> 12
}
func (o *COMPARATOR_Type) SetCTRL_CMP_T0CAP3(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2000)|value<<13)
}
func (o *COMPARATOR_Type) GetCTRL_CMP_T0CAP3() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2000) >> 13
}
func (o *COMPARATOR_Type) SetCTRL_CMP_T1CAP2(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x4000)|value<<14)
}
func (o *COMPARATOR_Type) GetCTRL_CMP_T1CAP2() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x4000) >> 14
}
func (o *COMPARATOR_Type) SetCTRL_CMP_T1CAP3(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x8000)|value<<15)
}
func (o *COMPARATOR_Type) GetCTRL_CMP_T1CAP3() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x8000) >> 15
}
func (o *COMPARATOR_Type) SetCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xffff0000)|value<<16)
}
func (o *COMPARATOR_Type) GetCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xffff0000) >> 16
}

// COMPARATOR.CTRL0: Comparator 0 control register
func (o *COMPARATOR_Type) SetCTRL0_CMP0_EN(value uint32) {
	volatile.StoreUint32(&o.CTRL0.Reg, volatile.LoadUint32(&o.CTRL0.Reg)&^(0x3)|value)
}
func (o *COMPARATOR_Type) GetCTRL0_CMP0_EN() uint32 {
	return volatile.LoadUint32(&o.CTRL0.Reg) & 0x3
}
func (o *COMPARATOR_Type) SetCTRL0_CMP0_OE(value uint32) {
	volatile.StoreUint32(&o.CTRL0.Reg, volatile.LoadUint32(&o.CTRL0.Reg)&^(0x4)|value<<2)
}
func (o *COMPARATOR_Type) GetCTRL0_CMP0_OE() uint32 {
	return (volatile.LoadUint32(&o.CTRL0.Reg) & 0x4) >> 2
}
func (o *COMPARATOR_Type) SetCTRL0_CMP0_STAT(value uint32) {
	volatile.StoreUint32(&o.CTRL0.Reg, volatile.LoadUint32(&o.CTRL0.Reg)&^(0x8)|value<<3)
}
func (o *COMPARATOR_Type) GetCTRL0_CMP0_STAT() uint32 {
	return (volatile.LoadUint32(&o.CTRL0.Reg) & 0x8) >> 3
}
func (o *COMPARATOR_Type) SetCTRL0_CMP0_VM(value uint32) {
	volatile.StoreUint32(&o.CTRL0.Reg, volatile.LoadUint32(&o.CTRL0.Reg)&^(0x70)|value<<4)
}
func (o *COMPARATOR_Type) GetCTRL0_CMP0_VM() uint32 {
	return (volatile.LoadUint32(&o.CTRL0.Reg) & 0x70) >> 4
}
func (o *COMPARATOR_Type) SetCTRL0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL0.Reg, volatile.LoadUint32(&o.CTRL0.Reg)&^(0x80)|value<<7)
}
func (o *COMPARATOR_Type) GetCTRL0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL0.Reg) & 0x80) >> 7
}
func (o *COMPARATOR_Type) SetCTRL0_CMP0_VP(value uint32) {
	volatile.StoreUint32(&o.CTRL0.Reg, volatile.LoadUint32(&o.CTRL0.Reg)&^(0x700)|value<<8)
}
func (o *COMPARATOR_Type) GetCTRL0_CMP0_VP() uint32 {
	return (volatile.LoadUint32(&o.CTRL0.Reg) & 0x700) >> 8
}
func (o *COMPARATOR_Type) SetCTRL0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL0.Reg, volatile.LoadUint32(&o.CTRL0.Reg)&^(0x800)|value<<11)
}
func (o *COMPARATOR_Type) GetCTRL0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL0.Reg) & 0x800) >> 11
}
func (o *COMPARATOR_Type) SetCTRL0_CMP0_SYNC(value uint32) {
	volatile.StoreUint32(&o.CTRL0.Reg, volatile.LoadUint32(&o.CTRL0.Reg)&^(0x1000)|value<<12)
}
func (o *COMPARATOR_Type) GetCTRL0_CMP0_SYNC() uint32 {
	return (volatile.LoadUint32(&o.CTRL0.Reg) & 0x1000) >> 12
}
func (o *COMPARATOR_Type) SetCTRL0_CMP0_HYS(value uint32) {
	volatile.StoreUint32(&o.CTRL0.Reg, volatile.LoadUint32(&o.CTRL0.Reg)&^(0x6000)|value<<13)
}
func (o *COMPARATOR_Type) GetCTRL0_CMP0_HYS() uint32 {
	return (volatile.LoadUint32(&o.CTRL0.Reg) & 0x6000) >> 13
}
func (o *COMPARATOR_Type) SetCTRL0_CMP0_INTPOL(value uint32) {
	volatile.StoreUint32(&o.CTRL0.Reg, volatile.LoadUint32(&o.CTRL0.Reg)&^(0x8000)|value<<15)
}
func (o *COMPARATOR_Type) GetCTRL0_CMP0_INTPOL() uint32 {
	return (volatile.LoadUint32(&o.CTRL0.Reg) & 0x8000) >> 15
}
func (o *COMPARATOR_Type) SetCTRL0_CMP0_INTTYPE(value uint32) {
	volatile.StoreUint32(&o.CTRL0.Reg, volatile.LoadUint32(&o.CTRL0.Reg)&^(0x10000)|value<<16)
}
func (o *COMPARATOR_Type) GetCTRL0_CMP0_INTTYPE() uint32 {
	return (volatile.LoadUint32(&o.CTRL0.Reg) & 0x10000) >> 16
}
func (o *COMPARATOR_Type) SetCTRL0_CMP0_INTEDGE(value uint32) {
	volatile.StoreUint32(&o.CTRL0.Reg, volatile.LoadUint32(&o.CTRL0.Reg)&^(0x60000)|value<<17)
}
func (o *COMPARATOR_Type) GetCTRL0_CMP0_INTEDGE() uint32 {
	return (volatile.LoadUint32(&o.CTRL0.Reg) & 0x60000) >> 17
}
func (o *COMPARATOR_Type) SetCTRL0_CMP0_INTFLAG(value uint32) {
	volatile.StoreUint32(&o.CTRL0.Reg, volatile.LoadUint32(&o.CTRL0.Reg)&^(0x80000)|value<<19)
}
func (o *COMPARATOR_Type) GetCTRL0_CMP0_INTFLAG() uint32 {
	return (volatile.LoadUint32(&o.CTRL0.Reg) & 0x80000) >> 19
}
func (o *COMPARATOR_Type) SetCTRL0_CMP0_VLADEN(value uint32) {
	volatile.StoreUint32(&o.CTRL0.Reg, volatile.LoadUint32(&o.CTRL0.Reg)&^(0x300000)|value<<20)
}
func (o *COMPARATOR_Type) GetCTRL0_CMP0_VLADEN() uint32 {
	return (volatile.LoadUint32(&o.CTRL0.Reg) & 0x300000) >> 20
}
func (o *COMPARATOR_Type) SetCTRL0_CMP0_VLADREF(value uint32) {
	volatile.StoreUint32(&o.CTRL0.Reg, volatile.LoadUint32(&o.CTRL0.Reg)&^(0x400000)|value<<22)
}
func (o *COMPARATOR_Type) GetCTRL0_CMP0_VLADREF() uint32 {
	return (volatile.LoadUint32(&o.CTRL0.Reg) & 0x400000) >> 22
}
func (o *COMPARATOR_Type) SetCTRL0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL0.Reg, volatile.LoadUint32(&o.CTRL0.Reg)&^(0x800000)|value<<23)
}
func (o *COMPARATOR_Type) GetCTRL0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL0.Reg) & 0x800000) >> 23
}
func (o *COMPARATOR_Type) SetCTRL0_CMP0_VSEL(value uint32) {
	volatile.StoreUint32(&o.CTRL0.Reg, volatile.LoadUint32(&o.CTRL0.Reg)&^(0x1f000000)|value<<24)
}
func (o *COMPARATOR_Type) GetCTRL0_CMP0_VSEL() uint32 {
	return (volatile.LoadUint32(&o.CTRL0.Reg) & 0x1f000000) >> 24
}
func (o *COMPARATOR_Type) SetCTRL0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL0.Reg, volatile.LoadUint32(&o.CTRL0.Reg)&^(0xe0000000)|value<<29)
}
func (o *COMPARATOR_Type) GetCTRL0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL0.Reg) & 0xe0000000) >> 29
}

// COMPARATOR.CTRL1: Comparator 1 control register
func (o *COMPARATOR_Type) SetCTRL1_CMP1_EN(value uint32) {
	volatile.StoreUint32(&o.CTRL1.Reg, volatile.LoadUint32(&o.CTRL1.Reg)&^(0x3)|value)
}
func (o *COMPARATOR_Type) GetCTRL1_CMP1_EN() uint32 {
	return volatile.LoadUint32(&o.CTRL1.Reg) & 0x3
}
func (o *COMPARATOR_Type) SetCTRL1_CMP1_OE(value uint32) {
	volatile.StoreUint32(&o.CTRL1.Reg, volatile.LoadUint32(&o.CTRL1.Reg)&^(0x4)|value<<2)
}
func (o *COMPARATOR_Type) GetCTRL1_CMP1_OE() uint32 {
	return (volatile.LoadUint32(&o.CTRL1.Reg) & 0x4) >> 2
}
func (o *COMPARATOR_Type) SetCTRL1_CMP1_STAT(value uint32) {
	volatile.StoreUint32(&o.CTRL1.Reg, volatile.LoadUint32(&o.CTRL1.Reg)&^(0x8)|value<<3)
}
func (o *COMPARATOR_Type) GetCTRL1_CMP1_STAT() uint32 {
	return (volatile.LoadUint32(&o.CTRL1.Reg) & 0x8) >> 3
}
func (o *COMPARATOR_Type) SetCTRL1_CMP1_VM(value uint32) {
	volatile.StoreUint32(&o.CTRL1.Reg, volatile.LoadUint32(&o.CTRL1.Reg)&^(0x70)|value<<4)
}
func (o *COMPARATOR_Type) GetCTRL1_CMP1_VM() uint32 {
	return (volatile.LoadUint32(&o.CTRL1.Reg) & 0x70) >> 4
}
func (o *COMPARATOR_Type) SetCTRL1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL1.Reg, volatile.LoadUint32(&o.CTRL1.Reg)&^(0x80)|value<<7)
}
func (o *COMPARATOR_Type) GetCTRL1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL1.Reg) & 0x80) >> 7
}
func (o *COMPARATOR_Type) SetCTRL1_CMP1_VP(value uint32) {
	volatile.StoreUint32(&o.CTRL1.Reg, volatile.LoadUint32(&o.CTRL1.Reg)&^(0x700)|value<<8)
}
func (o *COMPARATOR_Type) GetCTRL1_CMP1_VP() uint32 {
	return (volatile.LoadUint32(&o.CTRL1.Reg) & 0x700) >> 8
}
func (o *COMPARATOR_Type) SetCTRL1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL1.Reg, volatile.LoadUint32(&o.CTRL1.Reg)&^(0x800)|value<<11)
}
func (o *COMPARATOR_Type) GetCTRL1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL1.Reg) & 0x800) >> 11
}
func (o *COMPARATOR_Type) SetCTRL1_CMP1_SYNC(value uint32) {
	volatile.StoreUint32(&o.CTRL1.Reg, volatile.LoadUint32(&o.CTRL1.Reg)&^(0x1000)|value<<12)
}
func (o *COMPARATOR_Type) GetCTRL1_CMP1_SYNC() uint32 {
	return (volatile.LoadUint32(&o.CTRL1.Reg) & 0x1000) >> 12
}
func (o *COMPARATOR_Type) SetCTRL1_CMP1_HYS(value uint32) {
	volatile.StoreUint32(&o.CTRL1.Reg, volatile.LoadUint32(&o.CTRL1.Reg)&^(0x6000)|value<<13)
}
func (o *COMPARATOR_Type) GetCTRL1_CMP1_HYS() uint32 {
	return (volatile.LoadUint32(&o.CTRL1.Reg) & 0x6000) >> 13
}
func (o *COMPARATOR_Type) SetCTRL1_CMP1_INTPOL(value uint32) {
	volatile.StoreUint32(&o.CTRL1.Reg, volatile.LoadUint32(&o.CTRL1.Reg)&^(0x8000)|value<<15)
}
func (o *COMPARATOR_Type) GetCTRL1_CMP1_INTPOL() uint32 {
	return (volatile.LoadUint32(&o.CTRL1.Reg) & 0x8000) >> 15
}
func (o *COMPARATOR_Type) SetCTRL1_CMP1_INTTYPE(value uint32) {
	volatile.StoreUint32(&o.CTRL1.Reg, volatile.LoadUint32(&o.CTRL1.Reg)&^(0x10000)|value<<16)
}
func (o *COMPARATOR_Type) GetCTRL1_CMP1_INTTYPE() uint32 {
	return (volatile.LoadUint32(&o.CTRL1.Reg) & 0x10000) >> 16
}
func (o *COMPARATOR_Type) SetCTRL1_CMP1_INTEDGE(value uint32) {
	volatile.StoreUint32(&o.CTRL1.Reg, volatile.LoadUint32(&o.CTRL1.Reg)&^(0x60000)|value<<17)
}
func (o *COMPARATOR_Type) GetCTRL1_CMP1_INTEDGE() uint32 {
	return (volatile.LoadUint32(&o.CTRL1.Reg) & 0x60000) >> 17
}
func (o *COMPARATOR_Type) SetCTRL1_CMP1_INTFLAG(value uint32) {
	volatile.StoreUint32(&o.CTRL1.Reg, volatile.LoadUint32(&o.CTRL1.Reg)&^(0x80000)|value<<19)
}
func (o *COMPARATOR_Type) GetCTRL1_CMP1_INTFLAG() uint32 {
	return (volatile.LoadUint32(&o.CTRL1.Reg) & 0x80000) >> 19
}
func (o *COMPARATOR_Type) SetCTRL1_CMP1_VLADEN(value uint32) {
	volatile.StoreUint32(&o.CTRL1.Reg, volatile.LoadUint32(&o.CTRL1.Reg)&^(0x300000)|value<<20)
}
func (o *COMPARATOR_Type) GetCTRL1_CMP1_VLADEN() uint32 {
	return (volatile.LoadUint32(&o.CTRL1.Reg) & 0x300000) >> 20
}
func (o *COMPARATOR_Type) SetCTRL1_CMP1_VLADREF(value uint32) {
	volatile.StoreUint32(&o.CTRL1.Reg, volatile.LoadUint32(&o.CTRL1.Reg)&^(0x400000)|value<<22)
}
func (o *COMPARATOR_Type) GetCTRL1_CMP1_VLADREF() uint32 {
	return (volatile.LoadUint32(&o.CTRL1.Reg) & 0x400000) >> 22
}
func (o *COMPARATOR_Type) SetCTRL1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL1.Reg, volatile.LoadUint32(&o.CTRL1.Reg)&^(0x800000)|value<<23)
}
func (o *COMPARATOR_Type) GetCTRL1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL1.Reg) & 0x800000) >> 23
}
func (o *COMPARATOR_Type) SetCTRL1_CMP1_VSel(value uint32) {
	volatile.StoreUint32(&o.CTRL1.Reg, volatile.LoadUint32(&o.CTRL1.Reg)&^(0x1f000000)|value<<24)
}
func (o *COMPARATOR_Type) GetCTRL1_CMP1_VSel() uint32 {
	return (volatile.LoadUint32(&o.CTRL1.Reg) & 0x1f000000) >> 24
}
func (o *COMPARATOR_Type) SetCTRL1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL1.Reg, volatile.LoadUint32(&o.CTRL1.Reg)&^(0xe0000000)|value<<29)
}
func (o *COMPARATOR_Type) GetCTRL1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL1.Reg) & 0xe0000000) >> 29
}

// Real Time Clock (RTC)
type RTC_Type struct {
	ILR           volatile.Register32 // 0x0
	_             [4]byte
	CCR           volatile.Register32 // 0x8
	CIIR          volatile.Register32 // 0xC
	AMR           volatile.Register32 // 0x10
	CTIME0        volatile.Register32 // 0x14
	CTIME1        volatile.Register32 // 0x18
	CTIME2        volatile.Register32 // 0x1C
	SEC           volatile.Register32 // 0x20
	MIN           volatile.Register32 // 0x24
	HRS           volatile.Register32 // 0x28
	DOM           volatile.Register32 // 0x2C
	DOW           volatile.Register32 // 0x30
	DOY           volatile.Register32 // 0x34
	MONTH         volatile.Register32 // 0x38
	YEAR          volatile.Register32 // 0x3C
	CALIBRATION   volatile.Register32 // 0x40
	GPREG0        volatile.Register32 // 0x44
	GPREG1        volatile.Register32 // 0x48
	GPREG2        volatile.Register32 // 0x4C
	GPREG3        volatile.Register32 // 0x50
	GPREG4        volatile.Register32 // 0x54
	RTC_AUXEN     volatile.Register32 // 0x58
	RTC_AUX       volatile.Register32 // 0x5C
	ASEC          volatile.Register32 // 0x60
	AMIN          volatile.Register32 // 0x64
	AHRS          volatile.Register32 // 0x68
	ADOM          volatile.Register32 // 0x6C
	ADOW          volatile.Register32 // 0x70
	ADOY          volatile.Register32 // 0x74
	AMON          volatile.Register32 // 0x78
	AYRS          volatile.Register32 // 0x7C
	ERSTATUS      volatile.Register32 // 0x80
	ERCONTROL     volatile.Register32 // 0x84
	ERCOUNTERS    volatile.Register32 // 0x88
	_             [4]byte
	ERFIRSTSTAMP0 volatile.Register32 // 0x90
	ERFIRSTSTAMP1 volatile.Register32 // 0x94
	ERFIRSTSTAMP2 volatile.Register32 // 0x98
	_             [4]byte
	ERLASTSTAMP0  volatile.Register32 // 0xA0
	ERLASTSTAMP1  volatile.Register32 // 0xA4
	ERLASTSTAMP2  volatile.Register32 // 0xA8
}

// RTC.ILR: Interrupt Location Register
func (o *RTC_Type) SetILR_RTCCIF(value uint32) {
	volatile.StoreUint32(&o.ILR.Reg, volatile.LoadUint32(&o.ILR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetILR_RTCCIF() uint32 {
	return volatile.LoadUint32(&o.ILR.Reg) & 0x1
}
func (o *RTC_Type) SetILR_RTCALF(value uint32) {
	volatile.StoreUint32(&o.ILR.Reg, volatile.LoadUint32(&o.ILR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetILR_RTCALF() uint32 {
	return (volatile.LoadUint32(&o.ILR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetILR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ILR.Reg, volatile.LoadUint32(&o.ILR.Reg)&^(0xffe00000)|value<<21)
}
func (o *RTC_Type) GetILR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ILR.Reg) & 0xffe00000) >> 21
}

// RTC.CCR: Clock Control Register
func (o *RTC_Type) SetCCR_CLKEN(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetCCR_CLKEN() uint32 {
	return volatile.LoadUint32(&o.CCR.Reg) & 0x1
}
func (o *RTC_Type) SetCCR_CTCRST(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetCCR_CTCRST() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetCCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0xc)|value<<2)
}
func (o *RTC_Type) GetCCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0xc) >> 2
}
func (o *RTC_Type) SetCCR_CCALEN(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetCCR_CCALEN() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetCCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0xffffffe0)|value<<5)
}
func (o *RTC_Type) GetCCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0xffffffe0) >> 5
}

// RTC.CIIR: Counter Increment Interrupt Register
func (o *RTC_Type) SetCIIR_IMSEC(value uint32) {
	volatile.StoreUint32(&o.CIIR.Reg, volatile.LoadUint32(&o.CIIR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetCIIR_IMSEC() uint32 {
	return volatile.LoadUint32(&o.CIIR.Reg) & 0x1
}
func (o *RTC_Type) SetCIIR_IMMIN(value uint32) {
	volatile.StoreUint32(&o.CIIR.Reg, volatile.LoadUint32(&o.CIIR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetCIIR_IMMIN() uint32 {
	return (volatile.LoadUint32(&o.CIIR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetCIIR_IMHOUR(value uint32) {
	volatile.StoreUint32(&o.CIIR.Reg, volatile.LoadUint32(&o.CIIR.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetCIIR_IMHOUR() uint32 {
	return (volatile.LoadUint32(&o.CIIR.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetCIIR_IMDOM(value uint32) {
	volatile.StoreUint32(&o.CIIR.Reg, volatile.LoadUint32(&o.CIIR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetCIIR_IMDOM() uint32 {
	return (volatile.LoadUint32(&o.CIIR.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetCIIR_IMDOW(value uint32) {
	volatile.StoreUint32(&o.CIIR.Reg, volatile.LoadUint32(&o.CIIR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetCIIR_IMDOW() uint32 {
	return (volatile.LoadUint32(&o.CIIR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetCIIR_IMDOY(value uint32) {
	volatile.StoreUint32(&o.CIIR.Reg, volatile.LoadUint32(&o.CIIR.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetCIIR_IMDOY() uint32 {
	return (volatile.LoadUint32(&o.CIIR.Reg) & 0x20) >> 5
}
func (o *RTC_Type) SetCIIR_IMMON(value uint32) {
	volatile.StoreUint32(&o.CIIR.Reg, volatile.LoadUint32(&o.CIIR.Reg)&^(0x40)|value<<6)
}
func (o *RTC_Type) GetCIIR_IMMON() uint32 {
	return (volatile.LoadUint32(&o.CIIR.Reg) & 0x40) >> 6
}
func (o *RTC_Type) SetCIIR_IMYEAR(value uint32) {
	volatile.StoreUint32(&o.CIIR.Reg, volatile.LoadUint32(&o.CIIR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetCIIR_IMYEAR() uint32 {
	return (volatile.LoadUint32(&o.CIIR.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetCIIR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CIIR.Reg, volatile.LoadUint32(&o.CIIR.Reg)&^(0xffffff00)|value<<8)
}
func (o *RTC_Type) GetCIIR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CIIR.Reg) & 0xffffff00) >> 8
}

// RTC.AMR: Alarm Mask Register
func (o *RTC_Type) SetAMR_AMRSEC(value uint32) {
	volatile.StoreUint32(&o.AMR.Reg, volatile.LoadUint32(&o.AMR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetAMR_AMRSEC() uint32 {
	return volatile.LoadUint32(&o.AMR.Reg) & 0x1
}
func (o *RTC_Type) SetAMR_AMRMIN(value uint32) {
	volatile.StoreUint32(&o.AMR.Reg, volatile.LoadUint32(&o.AMR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetAMR_AMRMIN() uint32 {
	return (volatile.LoadUint32(&o.AMR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetAMR_AMRHOUR(value uint32) {
	volatile.StoreUint32(&o.AMR.Reg, volatile.LoadUint32(&o.AMR.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetAMR_AMRHOUR() uint32 {
	return (volatile.LoadUint32(&o.AMR.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetAMR_AMRDOM(value uint32) {
	volatile.StoreUint32(&o.AMR.Reg, volatile.LoadUint32(&o.AMR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetAMR_AMRDOM() uint32 {
	return (volatile.LoadUint32(&o.AMR.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetAMR_AMRDOW(value uint32) {
	volatile.StoreUint32(&o.AMR.Reg, volatile.LoadUint32(&o.AMR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetAMR_AMRDOW() uint32 {
	return (volatile.LoadUint32(&o.AMR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetAMR_AMRDOY(value uint32) {
	volatile.StoreUint32(&o.AMR.Reg, volatile.LoadUint32(&o.AMR.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetAMR_AMRDOY() uint32 {
	return (volatile.LoadUint32(&o.AMR.Reg) & 0x20) >> 5
}
func (o *RTC_Type) SetAMR_AMRMON(value uint32) {
	volatile.StoreUint32(&o.AMR.Reg, volatile.LoadUint32(&o.AMR.Reg)&^(0x40)|value<<6)
}
func (o *RTC_Type) GetAMR_AMRMON() uint32 {
	return (volatile.LoadUint32(&o.AMR.Reg) & 0x40) >> 6
}
func (o *RTC_Type) SetAMR_AMRYEAR(value uint32) {
	volatile.StoreUint32(&o.AMR.Reg, volatile.LoadUint32(&o.AMR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetAMR_AMRYEAR() uint32 {
	return (volatile.LoadUint32(&o.AMR.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetAMR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.AMR.Reg, volatile.LoadUint32(&o.AMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *RTC_Type) GetAMR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.AMR.Reg) & 0xffffff00) >> 8
}

// RTC.CTIME0: Consolidated Time Register 0
func (o *RTC_Type) SetCTIME0_SECONDS(value uint32) {
	volatile.StoreUint32(&o.CTIME0.Reg, volatile.LoadUint32(&o.CTIME0.Reg)&^(0x3f)|value)
}
func (o *RTC_Type) GetCTIME0_SECONDS() uint32 {
	return volatile.LoadUint32(&o.CTIME0.Reg) & 0x3f
}
func (o *RTC_Type) SetCTIME0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTIME0.Reg, volatile.LoadUint32(&o.CTIME0.Reg)&^(0xc0)|value<<6)
}
func (o *RTC_Type) GetCTIME0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTIME0.Reg) & 0xc0) >> 6
}
func (o *RTC_Type) SetCTIME0_MINUTES(value uint32) {
	volatile.StoreUint32(&o.CTIME0.Reg, volatile.LoadUint32(&o.CTIME0.Reg)&^(0x3f00)|value<<8)
}
func (o *RTC_Type) GetCTIME0_MINUTES() uint32 {
	return (volatile.LoadUint32(&o.CTIME0.Reg) & 0x3f00) >> 8
}
func (o *RTC_Type) SetCTIME0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTIME0.Reg, volatile.LoadUint32(&o.CTIME0.Reg)&^(0xc000)|value<<14)
}
func (o *RTC_Type) GetCTIME0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTIME0.Reg) & 0xc000) >> 14
}
func (o *RTC_Type) SetCTIME0_HOURS(value uint32) {
	volatile.StoreUint32(&o.CTIME0.Reg, volatile.LoadUint32(&o.CTIME0.Reg)&^(0x1f0000)|value<<16)
}
func (o *RTC_Type) GetCTIME0_HOURS() uint32 {
	return (volatile.LoadUint32(&o.CTIME0.Reg) & 0x1f0000) >> 16
}
func (o *RTC_Type) SetCTIME0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTIME0.Reg, volatile.LoadUint32(&o.CTIME0.Reg)&^(0xe00000)|value<<21)
}
func (o *RTC_Type) GetCTIME0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTIME0.Reg) & 0xe00000) >> 21
}
func (o *RTC_Type) SetCTIME0_DOW(value uint32) {
	volatile.StoreUint32(&o.CTIME0.Reg, volatile.LoadUint32(&o.CTIME0.Reg)&^(0x7000000)|value<<24)
}
func (o *RTC_Type) GetCTIME0_DOW() uint32 {
	return (volatile.LoadUint32(&o.CTIME0.Reg) & 0x7000000) >> 24
}
func (o *RTC_Type) SetCTIME0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTIME0.Reg, volatile.LoadUint32(&o.CTIME0.Reg)&^(0xf8000000)|value<<27)
}
func (o *RTC_Type) GetCTIME0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTIME0.Reg) & 0xf8000000) >> 27
}

// RTC.CTIME1: Consolidated Time Register 1
func (o *RTC_Type) SetCTIME1_DOM(value uint32) {
	volatile.StoreUint32(&o.CTIME1.Reg, volatile.LoadUint32(&o.CTIME1.Reg)&^(0x1f)|value)
}
func (o *RTC_Type) GetCTIME1_DOM() uint32 {
	return volatile.LoadUint32(&o.CTIME1.Reg) & 0x1f
}
func (o *RTC_Type) SetCTIME1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTIME1.Reg, volatile.LoadUint32(&o.CTIME1.Reg)&^(0xe0)|value<<5)
}
func (o *RTC_Type) GetCTIME1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTIME1.Reg) & 0xe0) >> 5
}
func (o *RTC_Type) SetCTIME1_MONTH(value uint32) {
	volatile.StoreUint32(&o.CTIME1.Reg, volatile.LoadUint32(&o.CTIME1.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetCTIME1_MONTH() uint32 {
	return (volatile.LoadUint32(&o.CTIME1.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetCTIME1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTIME1.Reg, volatile.LoadUint32(&o.CTIME1.Reg)&^(0xf000)|value<<12)
}
func (o *RTC_Type) GetCTIME1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTIME1.Reg) & 0xf000) >> 12
}
func (o *RTC_Type) SetCTIME1_YEAR(value uint32) {
	volatile.StoreUint32(&o.CTIME1.Reg, volatile.LoadUint32(&o.CTIME1.Reg)&^(0xfff0000)|value<<16)
}
func (o *RTC_Type) GetCTIME1_YEAR() uint32 {
	return (volatile.LoadUint32(&o.CTIME1.Reg) & 0xfff0000) >> 16
}
func (o *RTC_Type) SetCTIME1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTIME1.Reg, volatile.LoadUint32(&o.CTIME1.Reg)&^(0xf0000000)|value<<28)
}
func (o *RTC_Type) GetCTIME1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTIME1.Reg) & 0xf0000000) >> 28
}

// RTC.CTIME2: Consolidated Time Register 2
func (o *RTC_Type) SetCTIME2_DOY(value uint32) {
	volatile.StoreUint32(&o.CTIME2.Reg, volatile.LoadUint32(&o.CTIME2.Reg)&^(0xfff)|value)
}
func (o *RTC_Type) GetCTIME2_DOY() uint32 {
	return volatile.LoadUint32(&o.CTIME2.Reg) & 0xfff
}
func (o *RTC_Type) SetCTIME2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTIME2.Reg, volatile.LoadUint32(&o.CTIME2.Reg)&^(0xfffff000)|value<<12)
}
func (o *RTC_Type) GetCTIME2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTIME2.Reg) & 0xfffff000) >> 12
}

// RTC.SEC: Seconds Counter
func (o *RTC_Type) SetSEC_SECONDS(value uint32) {
	volatile.StoreUint32(&o.SEC.Reg, volatile.LoadUint32(&o.SEC.Reg)&^(0x3f)|value)
}
func (o *RTC_Type) GetSEC_SECONDS() uint32 {
	return volatile.LoadUint32(&o.SEC.Reg) & 0x3f
}
func (o *RTC_Type) SetSEC_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SEC.Reg, volatile.LoadUint32(&o.SEC.Reg)&^(0xffffffc0)|value<<6)
}
func (o *RTC_Type) GetSEC_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SEC.Reg) & 0xffffffc0) >> 6
}

// RTC.MIN: Minutes Register
func (o *RTC_Type) SetMIN_MINUTES(value uint32) {
	volatile.StoreUint32(&o.MIN.Reg, volatile.LoadUint32(&o.MIN.Reg)&^(0x3f)|value)
}
func (o *RTC_Type) GetMIN_MINUTES() uint32 {
	return volatile.LoadUint32(&o.MIN.Reg) & 0x3f
}
func (o *RTC_Type) SetMIN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MIN.Reg, volatile.LoadUint32(&o.MIN.Reg)&^(0xffffffc0)|value<<6)
}
func (o *RTC_Type) GetMIN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MIN.Reg) & 0xffffffc0) >> 6
}

// RTC.HRS: Hours Register
func (o *RTC_Type) SetHRS_HOURS(value uint32) {
	volatile.StoreUint32(&o.HRS.Reg, volatile.LoadUint32(&o.HRS.Reg)&^(0x1f)|value)
}
func (o *RTC_Type) GetHRS_HOURS() uint32 {
	return volatile.LoadUint32(&o.HRS.Reg) & 0x1f
}
func (o *RTC_Type) SetHRS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.HRS.Reg, volatile.LoadUint32(&o.HRS.Reg)&^(0xffffffe0)|value<<5)
}
func (o *RTC_Type) GetHRS_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.HRS.Reg) & 0xffffffe0) >> 5
}

// RTC.DOM: Day of Month Register
func (o *RTC_Type) SetDOM(value uint32) {
	volatile.StoreUint32(&o.DOM.Reg, volatile.LoadUint32(&o.DOM.Reg)&^(0x1f)|value)
}
func (o *RTC_Type) GetDOM() uint32 {
	return volatile.LoadUint32(&o.DOM.Reg) & 0x1f
}
func (o *RTC_Type) SetDOM_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DOM.Reg, volatile.LoadUint32(&o.DOM.Reg)&^(0xffffffe0)|value<<5)
}
func (o *RTC_Type) GetDOM_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DOM.Reg) & 0xffffffe0) >> 5
}

// RTC.DOW: Day of Week Register
func (o *RTC_Type) SetDOW(value uint32) {
	volatile.StoreUint32(&o.DOW.Reg, volatile.LoadUint32(&o.DOW.Reg)&^(0x7)|value)
}
func (o *RTC_Type) GetDOW() uint32 {
	return volatile.LoadUint32(&o.DOW.Reg) & 0x7
}
func (o *RTC_Type) SetDOW_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DOW.Reg, volatile.LoadUint32(&o.DOW.Reg)&^(0xfffffff8)|value<<3)
}
func (o *RTC_Type) GetDOW_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DOW.Reg) & 0xfffffff8) >> 3
}

// RTC.DOY: Day of Year Register
func (o *RTC_Type) SetDOY(value uint32) {
	volatile.StoreUint32(&o.DOY.Reg, volatile.LoadUint32(&o.DOY.Reg)&^(0x1ff)|value)
}
func (o *RTC_Type) GetDOY() uint32 {
	return volatile.LoadUint32(&o.DOY.Reg) & 0x1ff
}
func (o *RTC_Type) SetDOY_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DOY.Reg, volatile.LoadUint32(&o.DOY.Reg)&^(0xfffffe00)|value<<9)
}
func (o *RTC_Type) GetDOY_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DOY.Reg) & 0xfffffe00) >> 9
}

// RTC.MONTH: Months Register
func (o *RTC_Type) SetMONTH(value uint32) {
	volatile.StoreUint32(&o.MONTH.Reg, volatile.LoadUint32(&o.MONTH.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetMONTH() uint32 {
	return volatile.LoadUint32(&o.MONTH.Reg) & 0xf
}
func (o *RTC_Type) SetMONTH_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MONTH.Reg, volatile.LoadUint32(&o.MONTH.Reg)&^(0xfffffff0)|value<<4)
}
func (o *RTC_Type) GetMONTH_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MONTH.Reg) & 0xfffffff0) >> 4
}

// RTC.YEAR: Years Register
func (o *RTC_Type) SetYEAR(value uint32) {
	volatile.StoreUint32(&o.YEAR.Reg, volatile.LoadUint32(&o.YEAR.Reg)&^(0xfff)|value)
}
func (o *RTC_Type) GetYEAR() uint32 {
	return volatile.LoadUint32(&o.YEAR.Reg) & 0xfff
}
func (o *RTC_Type) SetYEAR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.YEAR.Reg, volatile.LoadUint32(&o.YEAR.Reg)&^(0xfffff000)|value<<12)
}
func (o *RTC_Type) GetYEAR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.YEAR.Reg) & 0xfffff000) >> 12
}

// RTC.CALIBRATION: Calibration Value Register
func (o *RTC_Type) SetCALIBRATION_CALVAL(value uint32) {
	volatile.StoreUint32(&o.CALIBRATION.Reg, volatile.LoadUint32(&o.CALIBRATION.Reg)&^(0x1ffff)|value)
}
func (o *RTC_Type) GetCALIBRATION_CALVAL() uint32 {
	return volatile.LoadUint32(&o.CALIBRATION.Reg) & 0x1ffff
}
func (o *RTC_Type) SetCALIBRATION_CALDIR(value uint32) {
	volatile.StoreUint32(&o.CALIBRATION.Reg, volatile.LoadUint32(&o.CALIBRATION.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_Type) GetCALIBRATION_CALDIR() uint32 {
	return (volatile.LoadUint32(&o.CALIBRATION.Reg) & 0x20000) >> 17
}

// RTC.GPREG0: General Purpose Register 0
func (o *RTC_Type) SetGPREG0(value uint32) {
	volatile.StoreUint32(&o.GPREG0.Reg, value)
}
func (o *RTC_Type) GetGPREG0() uint32 {
	return volatile.LoadUint32(&o.GPREG0.Reg)
}

// RTC.GPREG1: General Purpose Register 0
func (o *RTC_Type) SetGPREG1(value uint32) {
	volatile.StoreUint32(&o.GPREG1.Reg, value)
}
func (o *RTC_Type) GetGPREG1() uint32 {
	return volatile.LoadUint32(&o.GPREG1.Reg)
}

// RTC.GPREG2: General Purpose Register 0
func (o *RTC_Type) SetGPREG2(value uint32) {
	volatile.StoreUint32(&o.GPREG2.Reg, value)
}
func (o *RTC_Type) GetGPREG2() uint32 {
	return volatile.LoadUint32(&o.GPREG2.Reg)
}

// RTC.GPREG3: General Purpose Register 0
func (o *RTC_Type) SetGPREG3(value uint32) {
	volatile.StoreUint32(&o.GPREG3.Reg, value)
}
func (o *RTC_Type) GetGPREG3() uint32 {
	return volatile.LoadUint32(&o.GPREG3.Reg)
}

// RTC.GPREG4: General Purpose Register 0
func (o *RTC_Type) SetGPREG4(value uint32) {
	volatile.StoreUint32(&o.GPREG4.Reg, value)
}
func (o *RTC_Type) GetGPREG4() uint32 {
	return volatile.LoadUint32(&o.GPREG4.Reg)
}

// RTC.RTC_AUXEN: RTC Auxiliary Enable register
func (o *RTC_Type) SetRTC_AUXEN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RTC_AUXEN.Reg, volatile.LoadUint32(&o.RTC_AUXEN.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetRTC_AUXEN_RESERVED() uint32 {
	return volatile.LoadUint32(&o.RTC_AUXEN.Reg) & 0xf
}
func (o *RTC_Type) SetRTC_AUXEN_RTC_OSCFEN(value uint32) {
	volatile.StoreUint32(&o.RTC_AUXEN.Reg, volatile.LoadUint32(&o.RTC_AUXEN.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetRTC_AUXEN_RTC_OSCFEN() uint32 {
	return (volatile.LoadUint32(&o.RTC_AUXEN.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetRTC_AUXEN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RTC_AUXEN.Reg, volatile.LoadUint32(&o.RTC_AUXEN.Reg)&^(0xffffffe0)|value<<5)
}
func (o *RTC_Type) GetRTC_AUXEN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RTC_AUXEN.Reg) & 0xffffffe0) >> 5
}

// RTC.RTC_AUX: RTC Auxiliary control register
func (o *RTC_Type) SetRTC_AUX_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RTC_AUX.Reg, volatile.LoadUint32(&o.RTC_AUX.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetRTC_AUX_RESERVED() uint32 {
	return volatile.LoadUint32(&o.RTC_AUX.Reg) & 0xf
}
func (o *RTC_Type) SetRTC_AUX_RTC_OSCF(value uint32) {
	volatile.StoreUint32(&o.RTC_AUX.Reg, volatile.LoadUint32(&o.RTC_AUX.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetRTC_AUX_RTC_OSCF() uint32 {
	return (volatile.LoadUint32(&o.RTC_AUX.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetRTC_AUX_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RTC_AUX.Reg, volatile.LoadUint32(&o.RTC_AUX.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetRTC_AUX_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RTC_AUX.Reg) & 0x20) >> 5
}
func (o *RTC_Type) SetRTC_AUX_RTC_PDOUT(value uint32) {
	volatile.StoreUint32(&o.RTC_AUX.Reg, volatile.LoadUint32(&o.RTC_AUX.Reg)&^(0x40)|value<<6)
}
func (o *RTC_Type) GetRTC_AUX_RTC_PDOUT() uint32 {
	return (volatile.LoadUint32(&o.RTC_AUX.Reg) & 0x40) >> 6
}
func (o *RTC_Type) SetRTC_AUX_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RTC_AUX.Reg, volatile.LoadUint32(&o.RTC_AUX.Reg)&^(0xffffff80)|value<<7)
}
func (o *RTC_Type) GetRTC_AUX_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RTC_AUX.Reg) & 0xffffff80) >> 7
}

// RTC.ASEC: Alarm value for Seconds
func (o *RTC_Type) SetASEC_SECONDS(value uint32) {
	volatile.StoreUint32(&o.ASEC.Reg, volatile.LoadUint32(&o.ASEC.Reg)&^(0x3f)|value)
}
func (o *RTC_Type) GetASEC_SECONDS() uint32 {
	return volatile.LoadUint32(&o.ASEC.Reg) & 0x3f
}
func (o *RTC_Type) SetASEC_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ASEC.Reg, volatile.LoadUint32(&o.ASEC.Reg)&^(0xffffffc0)|value<<6)
}
func (o *RTC_Type) GetASEC_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ASEC.Reg) & 0xffffffc0) >> 6
}

// RTC.AMIN: Alarm value for Minutes
func (o *RTC_Type) SetAMIN_MINUTES(value uint32) {
	volatile.StoreUint32(&o.AMIN.Reg, volatile.LoadUint32(&o.AMIN.Reg)&^(0x3f)|value)
}
func (o *RTC_Type) GetAMIN_MINUTES() uint32 {
	return volatile.LoadUint32(&o.AMIN.Reg) & 0x3f
}
func (o *RTC_Type) SetAMIN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.AMIN.Reg, volatile.LoadUint32(&o.AMIN.Reg)&^(0xffffffc0)|value<<6)
}
func (o *RTC_Type) GetAMIN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.AMIN.Reg) & 0xffffffc0) >> 6
}

// RTC.AHRS: Alarm value for Hours
func (o *RTC_Type) SetAHRS_HOURS(value uint32) {
	volatile.StoreUint32(&o.AHRS.Reg, volatile.LoadUint32(&o.AHRS.Reg)&^(0x1f)|value)
}
func (o *RTC_Type) GetAHRS_HOURS() uint32 {
	return volatile.LoadUint32(&o.AHRS.Reg) & 0x1f
}
func (o *RTC_Type) SetAHRS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.AHRS.Reg, volatile.LoadUint32(&o.AHRS.Reg)&^(0xffffffe0)|value<<5)
}
func (o *RTC_Type) GetAHRS_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.AHRS.Reg) & 0xffffffe0) >> 5
}

// RTC.ADOM: Alarm value for Day of Month
func (o *RTC_Type) SetADOM_DOM(value uint32) {
	volatile.StoreUint32(&o.ADOM.Reg, volatile.LoadUint32(&o.ADOM.Reg)&^(0x1f)|value)
}
func (o *RTC_Type) GetADOM_DOM() uint32 {
	return volatile.LoadUint32(&o.ADOM.Reg) & 0x1f
}
func (o *RTC_Type) SetADOM_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ADOM.Reg, volatile.LoadUint32(&o.ADOM.Reg)&^(0xffffffe0)|value<<5)
}
func (o *RTC_Type) GetADOM_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ADOM.Reg) & 0xffffffe0) >> 5
}

// RTC.ADOW: Alarm value for Day of Week
func (o *RTC_Type) SetADOW_DOW(value uint32) {
	volatile.StoreUint32(&o.ADOW.Reg, volatile.LoadUint32(&o.ADOW.Reg)&^(0x7)|value)
}
func (o *RTC_Type) GetADOW_DOW() uint32 {
	return volatile.LoadUint32(&o.ADOW.Reg) & 0x7
}
func (o *RTC_Type) SetADOW_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ADOW.Reg, volatile.LoadUint32(&o.ADOW.Reg)&^(0xfffffff8)|value<<3)
}
func (o *RTC_Type) GetADOW_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ADOW.Reg) & 0xfffffff8) >> 3
}

// RTC.ADOY: Alarm value for Day of Year
func (o *RTC_Type) SetADOY_DOY(value uint32) {
	volatile.StoreUint32(&o.ADOY.Reg, volatile.LoadUint32(&o.ADOY.Reg)&^(0x1ff)|value)
}
func (o *RTC_Type) GetADOY_DOY() uint32 {
	return volatile.LoadUint32(&o.ADOY.Reg) & 0x1ff
}
func (o *RTC_Type) SetADOY_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ADOY.Reg, volatile.LoadUint32(&o.ADOY.Reg)&^(0xfffffe00)|value<<9)
}
func (o *RTC_Type) GetADOY_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ADOY.Reg) & 0xfffffe00) >> 9
}

// RTC.AMON: Alarm value for Months
func (o *RTC_Type) SetAMON_MONTH(value uint32) {
	volatile.StoreUint32(&o.AMON.Reg, volatile.LoadUint32(&o.AMON.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetAMON_MONTH() uint32 {
	return volatile.LoadUint32(&o.AMON.Reg) & 0xf
}
func (o *RTC_Type) SetAMON_RESERVED(value uint32) {
	volatile.StoreUint32(&o.AMON.Reg, volatile.LoadUint32(&o.AMON.Reg)&^(0xfffffff0)|value<<4)
}
func (o *RTC_Type) GetAMON_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.AMON.Reg) & 0xfffffff0) >> 4
}

// RTC.AYRS: Alarm value for Year
func (o *RTC_Type) SetAYRS_YEAR(value uint32) {
	volatile.StoreUint32(&o.AYRS.Reg, volatile.LoadUint32(&o.AYRS.Reg)&^(0xfff)|value)
}
func (o *RTC_Type) GetAYRS_YEAR() uint32 {
	return volatile.LoadUint32(&o.AYRS.Reg) & 0xfff
}
func (o *RTC_Type) SetAYRS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.AYRS.Reg, volatile.LoadUint32(&o.AYRS.Reg)&^(0xfffff000)|value<<12)
}
func (o *RTC_Type) GetAYRS_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.AYRS.Reg) & 0xfffff000) >> 12
}

// RTC.ERSTATUS: Event Monitor/Recorder Status register. Contains status flags for event channels and other Event Monitor/Recorder conditions.
func (o *RTC_Type) SetERSTATUS_EV0(value uint32) {
	volatile.StoreUint32(&o.ERSTATUS.Reg, volatile.LoadUint32(&o.ERSTATUS.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetERSTATUS_EV0() uint32 {
	return volatile.LoadUint32(&o.ERSTATUS.Reg) & 0x1
}
func (o *RTC_Type) SetERSTATUS_EV1(value uint32) {
	volatile.StoreUint32(&o.ERSTATUS.Reg, volatile.LoadUint32(&o.ERSTATUS.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetERSTATUS_EV1() uint32 {
	return (volatile.LoadUint32(&o.ERSTATUS.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetERSTATUS_EV2(value uint32) {
	volatile.StoreUint32(&o.ERSTATUS.Reg, volatile.LoadUint32(&o.ERSTATUS.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetERSTATUS_EV2() uint32 {
	return (volatile.LoadUint32(&o.ERSTATUS.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetERSTATUS_GP_CLEARED(value uint32) {
	volatile.StoreUint32(&o.ERSTATUS.Reg, volatile.LoadUint32(&o.ERSTATUS.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetERSTATUS_GP_CLEARED() uint32 {
	return (volatile.LoadUint32(&o.ERSTATUS.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetERSTATUS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ERSTATUS.Reg, volatile.LoadUint32(&o.ERSTATUS.Reg)&^(0x7ffffff0)|value<<4)
}
func (o *RTC_Type) GetERSTATUS_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ERSTATUS.Reg) & 0x7ffffff0) >> 4
}
func (o *RTC_Type) SetERSTATUS_WAKEUP(value uint32) {
	volatile.StoreUint32(&o.ERSTATUS.Reg, volatile.LoadUint32(&o.ERSTATUS.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetERSTATUS_WAKEUP() uint32 {
	return (volatile.LoadUint32(&o.ERSTATUS.Reg) & 0x80000000) >> 31
}

// RTC.ERCONTROL: Event Monitor/Recorder Control register. Contains bits that control actions for the event channels as well as for Event Monitor/Recorder setup.
func (o *RTC_Type) SetERCONTROL_INTWAKE_EN0(value uint32) {
	volatile.StoreUint32(&o.ERCONTROL.Reg, volatile.LoadUint32(&o.ERCONTROL.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetERCONTROL_INTWAKE_EN0() uint32 {
	return volatile.LoadUint32(&o.ERCONTROL.Reg) & 0x1
}
func (o *RTC_Type) SetERCONTROL_GPCLEAR_EN0(value uint32) {
	volatile.StoreUint32(&o.ERCONTROL.Reg, volatile.LoadUint32(&o.ERCONTROL.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetERCONTROL_GPCLEAR_EN0() uint32 {
	return (volatile.LoadUint32(&o.ERCONTROL.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetERCONTROL_POL0(value uint32) {
	volatile.StoreUint32(&o.ERCONTROL.Reg, volatile.LoadUint32(&o.ERCONTROL.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetERCONTROL_POL0() uint32 {
	return (volatile.LoadUint32(&o.ERCONTROL.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetERCONTROL_EV0_INPUT_EN(value uint32) {
	volatile.StoreUint32(&o.ERCONTROL.Reg, volatile.LoadUint32(&o.ERCONTROL.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetERCONTROL_EV0_INPUT_EN() uint32 {
	return (volatile.LoadUint32(&o.ERCONTROL.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetERCONTROL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ERCONTROL.Reg, volatile.LoadUint32(&o.ERCONTROL.Reg)&^(0x3f0)|value<<4)
}
func (o *RTC_Type) GetERCONTROL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ERCONTROL.Reg) & 0x3f0) >> 4
}
func (o *RTC_Type) SetERCONTROL_INTWAKE_EN1(value uint32) {
	volatile.StoreUint32(&o.ERCONTROL.Reg, volatile.LoadUint32(&o.ERCONTROL.Reg)&^(0x400)|value<<10)
}
func (o *RTC_Type) GetERCONTROL_INTWAKE_EN1() uint32 {
	return (volatile.LoadUint32(&o.ERCONTROL.Reg) & 0x400) >> 10
}
func (o *RTC_Type) SetERCONTROL_GPCLEAR_EN1(value uint32) {
	volatile.StoreUint32(&o.ERCONTROL.Reg, volatile.LoadUint32(&o.ERCONTROL.Reg)&^(0x800)|value<<11)
}
func (o *RTC_Type) GetERCONTROL_GPCLEAR_EN1() uint32 {
	return (volatile.LoadUint32(&o.ERCONTROL.Reg) & 0x800) >> 11
}
func (o *RTC_Type) SetERCONTROL_POL1(value uint32) {
	volatile.StoreUint32(&o.ERCONTROL.Reg, volatile.LoadUint32(&o.ERCONTROL.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_Type) GetERCONTROL_POL1() uint32 {
	return (volatile.LoadUint32(&o.ERCONTROL.Reg) & 0x1000) >> 12
}
func (o *RTC_Type) SetERCONTROL_EV1_INPUT_EN(value uint32) {
	volatile.StoreUint32(&o.ERCONTROL.Reg, volatile.LoadUint32(&o.ERCONTROL.Reg)&^(0x2000)|value<<13)
}
func (o *RTC_Type) GetERCONTROL_EV1_INPUT_EN() uint32 {
	return (volatile.LoadUint32(&o.ERCONTROL.Reg) & 0x2000) >> 13
}
func (o *RTC_Type) SetERCONTROL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ERCONTROL.Reg, volatile.LoadUint32(&o.ERCONTROL.Reg)&^(0xfc000)|value<<14)
}
func (o *RTC_Type) GetERCONTROL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ERCONTROL.Reg) & 0xfc000) >> 14
}
func (o *RTC_Type) SetERCONTROL_INTWAKE_EN2(value uint32) {
	volatile.StoreUint32(&o.ERCONTROL.Reg, volatile.LoadUint32(&o.ERCONTROL.Reg)&^(0x100000)|value<<20)
}
func (o *RTC_Type) GetERCONTROL_INTWAKE_EN2() uint32 {
	return (volatile.LoadUint32(&o.ERCONTROL.Reg) & 0x100000) >> 20
}
func (o *RTC_Type) SetERCONTROL_GPCLEAR_EN2(value uint32) {
	volatile.StoreUint32(&o.ERCONTROL.Reg, volatile.LoadUint32(&o.ERCONTROL.Reg)&^(0x200000)|value<<21)
}
func (o *RTC_Type) GetERCONTROL_GPCLEAR_EN2() uint32 {
	return (volatile.LoadUint32(&o.ERCONTROL.Reg) & 0x200000) >> 21
}
func (o *RTC_Type) SetERCONTROL_POL2(value uint32) {
	volatile.StoreUint32(&o.ERCONTROL.Reg, volatile.LoadUint32(&o.ERCONTROL.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_Type) GetERCONTROL_POL2() uint32 {
	return (volatile.LoadUint32(&o.ERCONTROL.Reg) & 0x400000) >> 22
}
func (o *RTC_Type) SetERCONTROL_EV2_INPUT_EN(value uint32) {
	volatile.StoreUint32(&o.ERCONTROL.Reg, volatile.LoadUint32(&o.ERCONTROL.Reg)&^(0x800000)|value<<23)
}
func (o *RTC_Type) GetERCONTROL_EV2_INPUT_EN() uint32 {
	return (volatile.LoadUint32(&o.ERCONTROL.Reg) & 0x800000) >> 23
}
func (o *RTC_Type) SetERCONTROL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ERCONTROL.Reg, volatile.LoadUint32(&o.ERCONTROL.Reg)&^(0x3f000000)|value<<24)
}
func (o *RTC_Type) GetERCONTROL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ERCONTROL.Reg) & 0x3f000000) >> 24
}
func (o *RTC_Type) SetERCONTROL_ERMODE(value uint32) {
	volatile.StoreUint32(&o.ERCONTROL.Reg, volatile.LoadUint32(&o.ERCONTROL.Reg)&^(0xc0000000)|value<<30)
}
func (o *RTC_Type) GetERCONTROL_ERMODE() uint32 {
	return (volatile.LoadUint32(&o.ERCONTROL.Reg) & 0xc0000000) >> 30
}

// RTC.ERCOUNTERS: Event Monitor/Recorder Counters register. Allows reading the counters associated with the event channels.
func (o *RTC_Type) SetERCOUNTERS_COUNTER0(value uint32) {
	volatile.StoreUint32(&o.ERCOUNTERS.Reg, volatile.LoadUint32(&o.ERCOUNTERS.Reg)&^(0x7)|value)
}
func (o *RTC_Type) GetERCOUNTERS_COUNTER0() uint32 {
	return volatile.LoadUint32(&o.ERCOUNTERS.Reg) & 0x7
}
func (o *RTC_Type) SetERCOUNTERS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ERCOUNTERS.Reg, volatile.LoadUint32(&o.ERCOUNTERS.Reg)&^(0xf8)|value<<3)
}
func (o *RTC_Type) GetERCOUNTERS_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ERCOUNTERS.Reg) & 0xf8) >> 3
}
func (o *RTC_Type) SetERCOUNTERS_COUNTER1(value uint32) {
	volatile.StoreUint32(&o.ERCOUNTERS.Reg, volatile.LoadUint32(&o.ERCOUNTERS.Reg)&^(0x700)|value<<8)
}
func (o *RTC_Type) GetERCOUNTERS_COUNTER1() uint32 {
	return (volatile.LoadUint32(&o.ERCOUNTERS.Reg) & 0x700) >> 8
}
func (o *RTC_Type) SetERCOUNTERS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ERCOUNTERS.Reg, volatile.LoadUint32(&o.ERCOUNTERS.Reg)&^(0xf800)|value<<11)
}
func (o *RTC_Type) GetERCOUNTERS_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ERCOUNTERS.Reg) & 0xf800) >> 11
}
func (o *RTC_Type) SetERCOUNTERS_COUNTER2(value uint32) {
	volatile.StoreUint32(&o.ERCOUNTERS.Reg, volatile.LoadUint32(&o.ERCOUNTERS.Reg)&^(0x70000)|value<<16)
}
func (o *RTC_Type) GetERCOUNTERS_COUNTER2() uint32 {
	return (volatile.LoadUint32(&o.ERCOUNTERS.Reg) & 0x70000) >> 16
}
func (o *RTC_Type) SetERCOUNTERS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ERCOUNTERS.Reg, volatile.LoadUint32(&o.ERCOUNTERS.Reg)&^(0xfff80000)|value<<19)
}
func (o *RTC_Type) GetERCOUNTERS_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ERCOUNTERS.Reg) & 0xfff80000) >> 19
}

// RTC.ERFIRSTSTAMP0: Event Monitor/Recorder First Stamp register for channel 0. Retains the time stamp for the first event on channel 0.
func (o *RTC_Type) SetERFIRSTSTAMP0_SEC(value uint32) {
	volatile.StoreUint32(&o.ERFIRSTSTAMP0.Reg, volatile.LoadUint32(&o.ERFIRSTSTAMP0.Reg)&^(0x3f)|value)
}
func (o *RTC_Type) GetERFIRSTSTAMP0_SEC() uint32 {
	return volatile.LoadUint32(&o.ERFIRSTSTAMP0.Reg) & 0x3f
}
func (o *RTC_Type) SetERFIRSTSTAMP0_MIN(value uint32) {
	volatile.StoreUint32(&o.ERFIRSTSTAMP0.Reg, volatile.LoadUint32(&o.ERFIRSTSTAMP0.Reg)&^(0xfc0)|value<<6)
}
func (o *RTC_Type) GetERFIRSTSTAMP0_MIN() uint32 {
	return (volatile.LoadUint32(&o.ERFIRSTSTAMP0.Reg) & 0xfc0) >> 6
}
func (o *RTC_Type) SetERFIRSTSTAMP0_HOUR(value uint32) {
	volatile.StoreUint32(&o.ERFIRSTSTAMP0.Reg, volatile.LoadUint32(&o.ERFIRSTSTAMP0.Reg)&^(0x1f000)|value<<12)
}
func (o *RTC_Type) GetERFIRSTSTAMP0_HOUR() uint32 {
	return (volatile.LoadUint32(&o.ERFIRSTSTAMP0.Reg) & 0x1f000) >> 12
}
func (o *RTC_Type) SetERFIRSTSTAMP0_DOY(value uint32) {
	volatile.StoreUint32(&o.ERFIRSTSTAMP0.Reg, volatile.LoadUint32(&o.ERFIRSTSTAMP0.Reg)&^(0x3fe0000)|value<<17)
}
func (o *RTC_Type) GetERFIRSTSTAMP0_DOY() uint32 {
	return (volatile.LoadUint32(&o.ERFIRSTSTAMP0.Reg) & 0x3fe0000) >> 17
}
func (o *RTC_Type) SetERFIRSTSTAMP0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ERFIRSTSTAMP0.Reg, volatile.LoadUint32(&o.ERFIRSTSTAMP0.Reg)&^(0xfc000000)|value<<26)
}
func (o *RTC_Type) GetERFIRSTSTAMP0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ERFIRSTSTAMP0.Reg) & 0xfc000000) >> 26
}

// RTC.ERFIRSTSTAMP1: Event Monitor/Recorder First Stamp register for channel 0. Retains the time stamp for the first event on channel 0.
func (o *RTC_Type) SetERFIRSTSTAMP1_SEC(value uint32) {
	volatile.StoreUint32(&o.ERFIRSTSTAMP1.Reg, volatile.LoadUint32(&o.ERFIRSTSTAMP1.Reg)&^(0x3f)|value)
}
func (o *RTC_Type) GetERFIRSTSTAMP1_SEC() uint32 {
	return volatile.LoadUint32(&o.ERFIRSTSTAMP1.Reg) & 0x3f
}
func (o *RTC_Type) SetERFIRSTSTAMP1_MIN(value uint32) {
	volatile.StoreUint32(&o.ERFIRSTSTAMP1.Reg, volatile.LoadUint32(&o.ERFIRSTSTAMP1.Reg)&^(0xfc0)|value<<6)
}
func (o *RTC_Type) GetERFIRSTSTAMP1_MIN() uint32 {
	return (volatile.LoadUint32(&o.ERFIRSTSTAMP1.Reg) & 0xfc0) >> 6
}
func (o *RTC_Type) SetERFIRSTSTAMP1_HOUR(value uint32) {
	volatile.StoreUint32(&o.ERFIRSTSTAMP1.Reg, volatile.LoadUint32(&o.ERFIRSTSTAMP1.Reg)&^(0x1f000)|value<<12)
}
func (o *RTC_Type) GetERFIRSTSTAMP1_HOUR() uint32 {
	return (volatile.LoadUint32(&o.ERFIRSTSTAMP1.Reg) & 0x1f000) >> 12
}
func (o *RTC_Type) SetERFIRSTSTAMP1_DOY(value uint32) {
	volatile.StoreUint32(&o.ERFIRSTSTAMP1.Reg, volatile.LoadUint32(&o.ERFIRSTSTAMP1.Reg)&^(0x3fe0000)|value<<17)
}
func (o *RTC_Type) GetERFIRSTSTAMP1_DOY() uint32 {
	return (volatile.LoadUint32(&o.ERFIRSTSTAMP1.Reg) & 0x3fe0000) >> 17
}
func (o *RTC_Type) SetERFIRSTSTAMP1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ERFIRSTSTAMP1.Reg, volatile.LoadUint32(&o.ERFIRSTSTAMP1.Reg)&^(0xfc000000)|value<<26)
}
func (o *RTC_Type) GetERFIRSTSTAMP1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ERFIRSTSTAMP1.Reg) & 0xfc000000) >> 26
}

// RTC.ERFIRSTSTAMP2: Event Monitor/Recorder First Stamp register for channel 0. Retains the time stamp for the first event on channel 0.
func (o *RTC_Type) SetERFIRSTSTAMP2_SEC(value uint32) {
	volatile.StoreUint32(&o.ERFIRSTSTAMP2.Reg, volatile.LoadUint32(&o.ERFIRSTSTAMP2.Reg)&^(0x3f)|value)
}
func (o *RTC_Type) GetERFIRSTSTAMP2_SEC() uint32 {
	return volatile.LoadUint32(&o.ERFIRSTSTAMP2.Reg) & 0x3f
}
func (o *RTC_Type) SetERFIRSTSTAMP2_MIN(value uint32) {
	volatile.StoreUint32(&o.ERFIRSTSTAMP2.Reg, volatile.LoadUint32(&o.ERFIRSTSTAMP2.Reg)&^(0xfc0)|value<<6)
}
func (o *RTC_Type) GetERFIRSTSTAMP2_MIN() uint32 {
	return (volatile.LoadUint32(&o.ERFIRSTSTAMP2.Reg) & 0xfc0) >> 6
}
func (o *RTC_Type) SetERFIRSTSTAMP2_HOUR(value uint32) {
	volatile.StoreUint32(&o.ERFIRSTSTAMP2.Reg, volatile.LoadUint32(&o.ERFIRSTSTAMP2.Reg)&^(0x1f000)|value<<12)
}
func (o *RTC_Type) GetERFIRSTSTAMP2_HOUR() uint32 {
	return (volatile.LoadUint32(&o.ERFIRSTSTAMP2.Reg) & 0x1f000) >> 12
}
func (o *RTC_Type) SetERFIRSTSTAMP2_DOY(value uint32) {
	volatile.StoreUint32(&o.ERFIRSTSTAMP2.Reg, volatile.LoadUint32(&o.ERFIRSTSTAMP2.Reg)&^(0x3fe0000)|value<<17)
}
func (o *RTC_Type) GetERFIRSTSTAMP2_DOY() uint32 {
	return (volatile.LoadUint32(&o.ERFIRSTSTAMP2.Reg) & 0x3fe0000) >> 17
}
func (o *RTC_Type) SetERFIRSTSTAMP2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ERFIRSTSTAMP2.Reg, volatile.LoadUint32(&o.ERFIRSTSTAMP2.Reg)&^(0xfc000000)|value<<26)
}
func (o *RTC_Type) GetERFIRSTSTAMP2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ERFIRSTSTAMP2.Reg) & 0xfc000000) >> 26
}

// RTC.ERLASTSTAMP0: Event Monitor/Recorder Last Stamp register for channel 0. Retains the time stamp for the last (i.e. most recent) event on channel 0.
func (o *RTC_Type) SetERLASTSTAMP0_SEC(value uint32) {
	volatile.StoreUint32(&o.ERLASTSTAMP0.Reg, volatile.LoadUint32(&o.ERLASTSTAMP0.Reg)&^(0x3f)|value)
}
func (o *RTC_Type) GetERLASTSTAMP0_SEC() uint32 {
	return volatile.LoadUint32(&o.ERLASTSTAMP0.Reg) & 0x3f
}
func (o *RTC_Type) SetERLASTSTAMP0_MIN(value uint32) {
	volatile.StoreUint32(&o.ERLASTSTAMP0.Reg, volatile.LoadUint32(&o.ERLASTSTAMP0.Reg)&^(0xfc0)|value<<6)
}
func (o *RTC_Type) GetERLASTSTAMP0_MIN() uint32 {
	return (volatile.LoadUint32(&o.ERLASTSTAMP0.Reg) & 0xfc0) >> 6
}
func (o *RTC_Type) SetERLASTSTAMP0_HOUR(value uint32) {
	volatile.StoreUint32(&o.ERLASTSTAMP0.Reg, volatile.LoadUint32(&o.ERLASTSTAMP0.Reg)&^(0x1f000)|value<<12)
}
func (o *RTC_Type) GetERLASTSTAMP0_HOUR() uint32 {
	return (volatile.LoadUint32(&o.ERLASTSTAMP0.Reg) & 0x1f000) >> 12
}
func (o *RTC_Type) SetERLASTSTAMP0_DOY(value uint32) {
	volatile.StoreUint32(&o.ERLASTSTAMP0.Reg, volatile.LoadUint32(&o.ERLASTSTAMP0.Reg)&^(0x3fe0000)|value<<17)
}
func (o *RTC_Type) GetERLASTSTAMP0_DOY() uint32 {
	return (volatile.LoadUint32(&o.ERLASTSTAMP0.Reg) & 0x3fe0000) >> 17
}
func (o *RTC_Type) SetERLASTSTAMP0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ERLASTSTAMP0.Reg, volatile.LoadUint32(&o.ERLASTSTAMP0.Reg)&^(0xfc000000)|value<<26)
}
func (o *RTC_Type) GetERLASTSTAMP0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ERLASTSTAMP0.Reg) & 0xfc000000) >> 26
}

// RTC.ERLASTSTAMP1: Event Monitor/Recorder Last Stamp register for channel 0. Retains the time stamp for the last (i.e. most recent) event on channel 0.
func (o *RTC_Type) SetERLASTSTAMP1_SEC(value uint32) {
	volatile.StoreUint32(&o.ERLASTSTAMP1.Reg, volatile.LoadUint32(&o.ERLASTSTAMP1.Reg)&^(0x3f)|value)
}
func (o *RTC_Type) GetERLASTSTAMP1_SEC() uint32 {
	return volatile.LoadUint32(&o.ERLASTSTAMP1.Reg) & 0x3f
}
func (o *RTC_Type) SetERLASTSTAMP1_MIN(value uint32) {
	volatile.StoreUint32(&o.ERLASTSTAMP1.Reg, volatile.LoadUint32(&o.ERLASTSTAMP1.Reg)&^(0xfc0)|value<<6)
}
func (o *RTC_Type) GetERLASTSTAMP1_MIN() uint32 {
	return (volatile.LoadUint32(&o.ERLASTSTAMP1.Reg) & 0xfc0) >> 6
}
func (o *RTC_Type) SetERLASTSTAMP1_HOUR(value uint32) {
	volatile.StoreUint32(&o.ERLASTSTAMP1.Reg, volatile.LoadUint32(&o.ERLASTSTAMP1.Reg)&^(0x1f000)|value<<12)
}
func (o *RTC_Type) GetERLASTSTAMP1_HOUR() uint32 {
	return (volatile.LoadUint32(&o.ERLASTSTAMP1.Reg) & 0x1f000) >> 12
}
func (o *RTC_Type) SetERLASTSTAMP1_DOY(value uint32) {
	volatile.StoreUint32(&o.ERLASTSTAMP1.Reg, volatile.LoadUint32(&o.ERLASTSTAMP1.Reg)&^(0x3fe0000)|value<<17)
}
func (o *RTC_Type) GetERLASTSTAMP1_DOY() uint32 {
	return (volatile.LoadUint32(&o.ERLASTSTAMP1.Reg) & 0x3fe0000) >> 17
}
func (o *RTC_Type) SetERLASTSTAMP1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ERLASTSTAMP1.Reg, volatile.LoadUint32(&o.ERLASTSTAMP1.Reg)&^(0xfc000000)|value<<26)
}
func (o *RTC_Type) GetERLASTSTAMP1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ERLASTSTAMP1.Reg) & 0xfc000000) >> 26
}

// RTC.ERLASTSTAMP2: Event Monitor/Recorder Last Stamp register for channel 0. Retains the time stamp for the last (i.e. most recent) event on channel 0.
func (o *RTC_Type) SetERLASTSTAMP2_SEC(value uint32) {
	volatile.StoreUint32(&o.ERLASTSTAMP2.Reg, volatile.LoadUint32(&o.ERLASTSTAMP2.Reg)&^(0x3f)|value)
}
func (o *RTC_Type) GetERLASTSTAMP2_SEC() uint32 {
	return volatile.LoadUint32(&o.ERLASTSTAMP2.Reg) & 0x3f
}
func (o *RTC_Type) SetERLASTSTAMP2_MIN(value uint32) {
	volatile.StoreUint32(&o.ERLASTSTAMP2.Reg, volatile.LoadUint32(&o.ERLASTSTAMP2.Reg)&^(0xfc0)|value<<6)
}
func (o *RTC_Type) GetERLASTSTAMP2_MIN() uint32 {
	return (volatile.LoadUint32(&o.ERLASTSTAMP2.Reg) & 0xfc0) >> 6
}
func (o *RTC_Type) SetERLASTSTAMP2_HOUR(value uint32) {
	volatile.StoreUint32(&o.ERLASTSTAMP2.Reg, volatile.LoadUint32(&o.ERLASTSTAMP2.Reg)&^(0x1f000)|value<<12)
}
func (o *RTC_Type) GetERLASTSTAMP2_HOUR() uint32 {
	return (volatile.LoadUint32(&o.ERLASTSTAMP2.Reg) & 0x1f000) >> 12
}
func (o *RTC_Type) SetERLASTSTAMP2_DOY(value uint32) {
	volatile.StoreUint32(&o.ERLASTSTAMP2.Reg, volatile.LoadUint32(&o.ERLASTSTAMP2.Reg)&^(0x3fe0000)|value<<17)
}
func (o *RTC_Type) GetERLASTSTAMP2_DOY() uint32 {
	return (volatile.LoadUint32(&o.ERLASTSTAMP2.Reg) & 0x3fe0000) >> 17
}
func (o *RTC_Type) SetERLASTSTAMP2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ERLASTSTAMP2.Reg, volatile.LoadUint32(&o.ERLASTSTAMP2.Reg)&^(0xfc000000)|value<<26)
}
func (o *RTC_Type) GetERLASTSTAMP2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ERLASTSTAMP2.Reg) & 0xfc000000) >> 26
}

// GPIO
type GPIOINT_Type struct {
	STATUS volatile.Register32 // 0x0
	STATR0 volatile.Register32 // 0x4
	STATF0 volatile.Register32 // 0x8
	CLR0   volatile.Register32 // 0xC
	ENR0   volatile.Register32 // 0x10
	ENF0   volatile.Register32 // 0x14
	_      [12]byte
	STATR2 volatile.Register32 // 0x24
	STATF2 volatile.Register32 // 0x28
	CLR2   volatile.Register32 // 0x2C
	ENR2   volatile.Register32 // 0x30
	ENF2   volatile.Register32 // 0x34
}

// GPIOINT.STATUS: GPIO overall Interrupt Status.
func (o *GPIOINT_Type) SetSTATUS_P0Int(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x1)|value)
}
func (o *GPIOINT_Type) GetSTATUS_P0Int() uint32 {
	return volatile.LoadUint32(&o.STATUS.Reg) & 0x1
}
func (o *GPIOINT_Type) SetSTATUS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x2)|value<<1)
}
func (o *GPIOINT_Type) GetSTATUS_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x2) >> 1
}
func (o *GPIOINT_Type) SetSTATUS_P2Int(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x4)|value<<2)
}
func (o *GPIOINT_Type) GetSTATUS_P2Int() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x4) >> 2
}
func (o *GPIOINT_Type) SetSTATUS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0xfffffffc)|value<<2)
}
func (o *GPIOINT_Type) GetSTATUS_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0xfffffffc) >> 2
}

// GPIOINT.STATR0: GPIO Interrupt Status for Rising edge for Port 0.
func (o *GPIOINT_Type) SetSTATR0_P0_0REI(value uint32) {
	volatile.StoreUint32(&o.STATR0.Reg, volatile.LoadUint32(&o.STATR0.Reg)&^(0x1)|value)
}
func (o *GPIOINT_Type) GetSTATR0_P0_0REI() uint32 {
	return volatile.LoadUint32(&o.STATR0.Reg) & 0x1
}
func (o *GPIOINT_Type) SetSTATR0_P0_1REI(value uint32) {
	volatile.StoreUint32(&o.STATR0.Reg, volatile.LoadUint32(&o.STATR0.Reg)&^(0x2)|value<<1)
}
func (o *GPIOINT_Type) GetSTATR0_P0_1REI() uint32 {
	return (volatile.LoadUint32(&o.STATR0.Reg) & 0x2) >> 1
}
func (o *GPIOINT_Type) SetSTATR0_P0_2REI(value uint32) {
	volatile.StoreUint32(&o.STATR0.Reg, volatile.LoadUint32(&o.STATR0.Reg)&^(0x4)|value<<2)
}
func (o *GPIOINT_Type) GetSTATR0_P0_2REI() uint32 {
	return (volatile.LoadUint32(&o.STATR0.Reg) & 0x4) >> 2
}
func (o *GPIOINT_Type) SetSTATR0_P0_3REI(value uint32) {
	volatile.StoreUint32(&o.STATR0.Reg, volatile.LoadUint32(&o.STATR0.Reg)&^(0x8)|value<<3)
}
func (o *GPIOINT_Type) GetSTATR0_P0_3REI() uint32 {
	return (volatile.LoadUint32(&o.STATR0.Reg) & 0x8) >> 3
}
func (o *GPIOINT_Type) SetSTATR0_P0_4REI(value uint32) {
	volatile.StoreUint32(&o.STATR0.Reg, volatile.LoadUint32(&o.STATR0.Reg)&^(0x10)|value<<4)
}
func (o *GPIOINT_Type) GetSTATR0_P0_4REI() uint32 {
	return (volatile.LoadUint32(&o.STATR0.Reg) & 0x10) >> 4
}
func (o *GPIOINT_Type) SetSTATR0_P0_5REI(value uint32) {
	volatile.StoreUint32(&o.STATR0.Reg, volatile.LoadUint32(&o.STATR0.Reg)&^(0x20)|value<<5)
}
func (o *GPIOINT_Type) GetSTATR0_P0_5REI() uint32 {
	return (volatile.LoadUint32(&o.STATR0.Reg) & 0x20) >> 5
}
func (o *GPIOINT_Type) SetSTATR0_P0_6REI(value uint32) {
	volatile.StoreUint32(&o.STATR0.Reg, volatile.LoadUint32(&o.STATR0.Reg)&^(0x40)|value<<6)
}
func (o *GPIOINT_Type) GetSTATR0_P0_6REI() uint32 {
	return (volatile.LoadUint32(&o.STATR0.Reg) & 0x40) >> 6
}
func (o *GPIOINT_Type) SetSTATR0_P0_7REI(value uint32) {
	volatile.StoreUint32(&o.STATR0.Reg, volatile.LoadUint32(&o.STATR0.Reg)&^(0x80)|value<<7)
}
func (o *GPIOINT_Type) GetSTATR0_P0_7REI() uint32 {
	return (volatile.LoadUint32(&o.STATR0.Reg) & 0x80) >> 7
}
func (o *GPIOINT_Type) SetSTATR0_P0_8REI(value uint32) {
	volatile.StoreUint32(&o.STATR0.Reg, volatile.LoadUint32(&o.STATR0.Reg)&^(0x100)|value<<8)
}
func (o *GPIOINT_Type) GetSTATR0_P0_8REI() uint32 {
	return (volatile.LoadUint32(&o.STATR0.Reg) & 0x100) >> 8
}
func (o *GPIOINT_Type) SetSTATR0_P0_9REI(value uint32) {
	volatile.StoreUint32(&o.STATR0.Reg, volatile.LoadUint32(&o.STATR0.Reg)&^(0x200)|value<<9)
}
func (o *GPIOINT_Type) GetSTATR0_P0_9REI() uint32 {
	return (volatile.LoadUint32(&o.STATR0.Reg) & 0x200) >> 9
}
func (o *GPIOINT_Type) SetSTATR0_P0_10REI(value uint32) {
	volatile.StoreUint32(&o.STATR0.Reg, volatile.LoadUint32(&o.STATR0.Reg)&^(0x400)|value<<10)
}
func (o *GPIOINT_Type) GetSTATR0_P0_10REI() uint32 {
	return (volatile.LoadUint32(&o.STATR0.Reg) & 0x400) >> 10
}
func (o *GPIOINT_Type) SetSTATR0_P0_11REI(value uint32) {
	volatile.StoreUint32(&o.STATR0.Reg, volatile.LoadUint32(&o.STATR0.Reg)&^(0x800)|value<<11)
}
func (o *GPIOINT_Type) GetSTATR0_P0_11REI() uint32 {
	return (volatile.LoadUint32(&o.STATR0.Reg) & 0x800) >> 11
}
func (o *GPIOINT_Type) SetSTATR0_P0_12REI(value uint32) {
	volatile.StoreUint32(&o.STATR0.Reg, volatile.LoadUint32(&o.STATR0.Reg)&^(0x1000)|value<<12)
}
func (o *GPIOINT_Type) GetSTATR0_P0_12REI() uint32 {
	return (volatile.LoadUint32(&o.STATR0.Reg) & 0x1000) >> 12
}
func (o *GPIOINT_Type) SetSTATR0_P0_13REI(value uint32) {
	volatile.StoreUint32(&o.STATR0.Reg, volatile.LoadUint32(&o.STATR0.Reg)&^(0x2000)|value<<13)
}
func (o *GPIOINT_Type) GetSTATR0_P0_13REI() uint32 {
	return (volatile.LoadUint32(&o.STATR0.Reg) & 0x2000) >> 13
}
func (o *GPIOINT_Type) SetSTATR0_P0_14REI(value uint32) {
	volatile.StoreUint32(&o.STATR0.Reg, volatile.LoadUint32(&o.STATR0.Reg)&^(0x4000)|value<<14)
}
func (o *GPIOINT_Type) GetSTATR0_P0_14REI() uint32 {
	return (volatile.LoadUint32(&o.STATR0.Reg) & 0x4000) >> 14
}
func (o *GPIOINT_Type) SetSTATR0_P0_15REI(value uint32) {
	volatile.StoreUint32(&o.STATR0.Reg, volatile.LoadUint32(&o.STATR0.Reg)&^(0x8000)|value<<15)
}
func (o *GPIOINT_Type) GetSTATR0_P0_15REI() uint32 {
	return (volatile.LoadUint32(&o.STATR0.Reg) & 0x8000) >> 15
}
func (o *GPIOINT_Type) SetSTATR0_P0_16REI(value uint32) {
	volatile.StoreUint32(&o.STATR0.Reg, volatile.LoadUint32(&o.STATR0.Reg)&^(0x10000)|value<<16)
}
func (o *GPIOINT_Type) GetSTATR0_P0_16REI() uint32 {
	return (volatile.LoadUint32(&o.STATR0.Reg) & 0x10000) >> 16
}
func (o *GPIOINT_Type) SetSTATR0_P0_17REI(value uint32) {
	volatile.StoreUint32(&o.STATR0.Reg, volatile.LoadUint32(&o.STATR0.Reg)&^(0x20000)|value<<17)
}
func (o *GPIOINT_Type) GetSTATR0_P0_17REI() uint32 {
	return (volatile.LoadUint32(&o.STATR0.Reg) & 0x20000) >> 17
}
func (o *GPIOINT_Type) SetSTATR0_P0_18REI(value uint32) {
	volatile.StoreUint32(&o.STATR0.Reg, volatile.LoadUint32(&o.STATR0.Reg)&^(0x40000)|value<<18)
}
func (o *GPIOINT_Type) GetSTATR0_P0_18REI() uint32 {
	return (volatile.LoadUint32(&o.STATR0.Reg) & 0x40000) >> 18
}
func (o *GPIOINT_Type) SetSTATR0_P0_19REI(value uint32) {
	volatile.StoreUint32(&o.STATR0.Reg, volatile.LoadUint32(&o.STATR0.Reg)&^(0x80000)|value<<19)
}
func (o *GPIOINT_Type) GetSTATR0_P0_19REI() uint32 {
	return (volatile.LoadUint32(&o.STATR0.Reg) & 0x80000) >> 19
}
func (o *GPIOINT_Type) SetSTATR0_P0_20REI(value uint32) {
	volatile.StoreUint32(&o.STATR0.Reg, volatile.LoadUint32(&o.STATR0.Reg)&^(0x100000)|value<<20)
}
func (o *GPIOINT_Type) GetSTATR0_P0_20REI() uint32 {
	return (volatile.LoadUint32(&o.STATR0.Reg) & 0x100000) >> 20
}
func (o *GPIOINT_Type) SetSTATR0_P0_21REI(value uint32) {
	volatile.StoreUint32(&o.STATR0.Reg, volatile.LoadUint32(&o.STATR0.Reg)&^(0x200000)|value<<21)
}
func (o *GPIOINT_Type) GetSTATR0_P0_21REI() uint32 {
	return (volatile.LoadUint32(&o.STATR0.Reg) & 0x200000) >> 21
}
func (o *GPIOINT_Type) SetSTATR0_P0_22REI(value uint32) {
	volatile.StoreUint32(&o.STATR0.Reg, volatile.LoadUint32(&o.STATR0.Reg)&^(0x400000)|value<<22)
}
func (o *GPIOINT_Type) GetSTATR0_P0_22REI() uint32 {
	return (volatile.LoadUint32(&o.STATR0.Reg) & 0x400000) >> 22
}
func (o *GPIOINT_Type) SetSTATR0_P0_23REI(value uint32) {
	volatile.StoreUint32(&o.STATR0.Reg, volatile.LoadUint32(&o.STATR0.Reg)&^(0x800000)|value<<23)
}
func (o *GPIOINT_Type) GetSTATR0_P0_23REI() uint32 {
	return (volatile.LoadUint32(&o.STATR0.Reg) & 0x800000) >> 23
}
func (o *GPIOINT_Type) SetSTATR0_P0_24REI(value uint32) {
	volatile.StoreUint32(&o.STATR0.Reg, volatile.LoadUint32(&o.STATR0.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIOINT_Type) GetSTATR0_P0_24REI() uint32 {
	return (volatile.LoadUint32(&o.STATR0.Reg) & 0x1000000) >> 24
}
func (o *GPIOINT_Type) SetSTATR0_P0_25REI(value uint32) {
	volatile.StoreUint32(&o.STATR0.Reg, volatile.LoadUint32(&o.STATR0.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIOINT_Type) GetSTATR0_P0_25REI() uint32 {
	return (volatile.LoadUint32(&o.STATR0.Reg) & 0x2000000) >> 25
}
func (o *GPIOINT_Type) SetSTATR0_P0_26REI(value uint32) {
	volatile.StoreUint32(&o.STATR0.Reg, volatile.LoadUint32(&o.STATR0.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIOINT_Type) GetSTATR0_P0_26REI() uint32 {
	return (volatile.LoadUint32(&o.STATR0.Reg) & 0x4000000) >> 26
}
func (o *GPIOINT_Type) SetSTATR0_P0_27REI(value uint32) {
	volatile.StoreUint32(&o.STATR0.Reg, volatile.LoadUint32(&o.STATR0.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIOINT_Type) GetSTATR0_P0_27REI() uint32 {
	return (volatile.LoadUint32(&o.STATR0.Reg) & 0x8000000) >> 27
}
func (o *GPIOINT_Type) SetSTATR0_P0_28REI(value uint32) {
	volatile.StoreUint32(&o.STATR0.Reg, volatile.LoadUint32(&o.STATR0.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIOINT_Type) GetSTATR0_P0_28REI() uint32 {
	return (volatile.LoadUint32(&o.STATR0.Reg) & 0x10000000) >> 28
}
func (o *GPIOINT_Type) SetSTATR0_P0_29REI(value uint32) {
	volatile.StoreUint32(&o.STATR0.Reg, volatile.LoadUint32(&o.STATR0.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIOINT_Type) GetSTATR0_P0_29REI() uint32 {
	return (volatile.LoadUint32(&o.STATR0.Reg) & 0x20000000) >> 29
}
func (o *GPIOINT_Type) SetSTATR0_P0_30REI(value uint32) {
	volatile.StoreUint32(&o.STATR0.Reg, volatile.LoadUint32(&o.STATR0.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIOINT_Type) GetSTATR0_P0_30REI() uint32 {
	return (volatile.LoadUint32(&o.STATR0.Reg) & 0x40000000) >> 30
}
func (o *GPIOINT_Type) SetSTATR0_P0_31REI(value uint32) {
	volatile.StoreUint32(&o.STATR0.Reg, volatile.LoadUint32(&o.STATR0.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIOINT_Type) GetSTATR0_P0_31REI() uint32 {
	return (volatile.LoadUint32(&o.STATR0.Reg) & 0x80000000) >> 31
}

// GPIOINT.STATF0: GPIO Interrupt Status for Falling edge for Port 0.
func (o *GPIOINT_Type) SetSTATF0_P0_0FEI(value uint32) {
	volatile.StoreUint32(&o.STATF0.Reg, volatile.LoadUint32(&o.STATF0.Reg)&^(0x1)|value)
}
func (o *GPIOINT_Type) GetSTATF0_P0_0FEI() uint32 {
	return volatile.LoadUint32(&o.STATF0.Reg) & 0x1
}
func (o *GPIOINT_Type) SetSTATF0_P0_1FEI(value uint32) {
	volatile.StoreUint32(&o.STATF0.Reg, volatile.LoadUint32(&o.STATF0.Reg)&^(0x2)|value<<1)
}
func (o *GPIOINT_Type) GetSTATF0_P0_1FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF0.Reg) & 0x2) >> 1
}
func (o *GPIOINT_Type) SetSTATF0_P0_2FEI(value uint32) {
	volatile.StoreUint32(&o.STATF0.Reg, volatile.LoadUint32(&o.STATF0.Reg)&^(0x4)|value<<2)
}
func (o *GPIOINT_Type) GetSTATF0_P0_2FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF0.Reg) & 0x4) >> 2
}
func (o *GPIOINT_Type) SetSTATF0_P0_3FEI(value uint32) {
	volatile.StoreUint32(&o.STATF0.Reg, volatile.LoadUint32(&o.STATF0.Reg)&^(0x8)|value<<3)
}
func (o *GPIOINT_Type) GetSTATF0_P0_3FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF0.Reg) & 0x8) >> 3
}
func (o *GPIOINT_Type) SetSTATF0_P0_4FEI(value uint32) {
	volatile.StoreUint32(&o.STATF0.Reg, volatile.LoadUint32(&o.STATF0.Reg)&^(0x10)|value<<4)
}
func (o *GPIOINT_Type) GetSTATF0_P0_4FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF0.Reg) & 0x10) >> 4
}
func (o *GPIOINT_Type) SetSTATF0_P0_5FEI(value uint32) {
	volatile.StoreUint32(&o.STATF0.Reg, volatile.LoadUint32(&o.STATF0.Reg)&^(0x20)|value<<5)
}
func (o *GPIOINT_Type) GetSTATF0_P0_5FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF0.Reg) & 0x20) >> 5
}
func (o *GPIOINT_Type) SetSTATF0_P0_6FEI(value uint32) {
	volatile.StoreUint32(&o.STATF0.Reg, volatile.LoadUint32(&o.STATF0.Reg)&^(0x40)|value<<6)
}
func (o *GPIOINT_Type) GetSTATF0_P0_6FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF0.Reg) & 0x40) >> 6
}
func (o *GPIOINT_Type) SetSTATF0_P0_7FEI(value uint32) {
	volatile.StoreUint32(&o.STATF0.Reg, volatile.LoadUint32(&o.STATF0.Reg)&^(0x80)|value<<7)
}
func (o *GPIOINT_Type) GetSTATF0_P0_7FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF0.Reg) & 0x80) >> 7
}
func (o *GPIOINT_Type) SetSTATF0_P0_8FEI(value uint32) {
	volatile.StoreUint32(&o.STATF0.Reg, volatile.LoadUint32(&o.STATF0.Reg)&^(0x100)|value<<8)
}
func (o *GPIOINT_Type) GetSTATF0_P0_8FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF0.Reg) & 0x100) >> 8
}
func (o *GPIOINT_Type) SetSTATF0_P0_9FEI(value uint32) {
	volatile.StoreUint32(&o.STATF0.Reg, volatile.LoadUint32(&o.STATF0.Reg)&^(0x200)|value<<9)
}
func (o *GPIOINT_Type) GetSTATF0_P0_9FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF0.Reg) & 0x200) >> 9
}
func (o *GPIOINT_Type) SetSTATF0_P0_10FEI(value uint32) {
	volatile.StoreUint32(&o.STATF0.Reg, volatile.LoadUint32(&o.STATF0.Reg)&^(0x400)|value<<10)
}
func (o *GPIOINT_Type) GetSTATF0_P0_10FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF0.Reg) & 0x400) >> 10
}
func (o *GPIOINT_Type) SetSTATF0_P0_11FEI(value uint32) {
	volatile.StoreUint32(&o.STATF0.Reg, volatile.LoadUint32(&o.STATF0.Reg)&^(0x800)|value<<11)
}
func (o *GPIOINT_Type) GetSTATF0_P0_11FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF0.Reg) & 0x800) >> 11
}
func (o *GPIOINT_Type) SetSTATF0_P0_12FEI(value uint32) {
	volatile.StoreUint32(&o.STATF0.Reg, volatile.LoadUint32(&o.STATF0.Reg)&^(0x1000)|value<<12)
}
func (o *GPIOINT_Type) GetSTATF0_P0_12FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF0.Reg) & 0x1000) >> 12
}
func (o *GPIOINT_Type) SetSTATF0_P0_13FEI(value uint32) {
	volatile.StoreUint32(&o.STATF0.Reg, volatile.LoadUint32(&o.STATF0.Reg)&^(0x2000)|value<<13)
}
func (o *GPIOINT_Type) GetSTATF0_P0_13FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF0.Reg) & 0x2000) >> 13
}
func (o *GPIOINT_Type) SetSTATF0_P0_14FEI(value uint32) {
	volatile.StoreUint32(&o.STATF0.Reg, volatile.LoadUint32(&o.STATF0.Reg)&^(0x4000)|value<<14)
}
func (o *GPIOINT_Type) GetSTATF0_P0_14FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF0.Reg) & 0x4000) >> 14
}
func (o *GPIOINT_Type) SetSTATF0_P0_15FEI(value uint32) {
	volatile.StoreUint32(&o.STATF0.Reg, volatile.LoadUint32(&o.STATF0.Reg)&^(0x8000)|value<<15)
}
func (o *GPIOINT_Type) GetSTATF0_P0_15FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF0.Reg) & 0x8000) >> 15
}
func (o *GPIOINT_Type) SetSTATF0_P0_16FEI(value uint32) {
	volatile.StoreUint32(&o.STATF0.Reg, volatile.LoadUint32(&o.STATF0.Reg)&^(0x10000)|value<<16)
}
func (o *GPIOINT_Type) GetSTATF0_P0_16FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF0.Reg) & 0x10000) >> 16
}
func (o *GPIOINT_Type) SetSTATF0_P0_17FEI(value uint32) {
	volatile.StoreUint32(&o.STATF0.Reg, volatile.LoadUint32(&o.STATF0.Reg)&^(0x20000)|value<<17)
}
func (o *GPIOINT_Type) GetSTATF0_P0_17FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF0.Reg) & 0x20000) >> 17
}
func (o *GPIOINT_Type) SetSTATF0_P0_18FEI(value uint32) {
	volatile.StoreUint32(&o.STATF0.Reg, volatile.LoadUint32(&o.STATF0.Reg)&^(0x40000)|value<<18)
}
func (o *GPIOINT_Type) GetSTATF0_P0_18FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF0.Reg) & 0x40000) >> 18
}
func (o *GPIOINT_Type) SetSTATF0_P0_19FEI(value uint32) {
	volatile.StoreUint32(&o.STATF0.Reg, volatile.LoadUint32(&o.STATF0.Reg)&^(0x80000)|value<<19)
}
func (o *GPIOINT_Type) GetSTATF0_P0_19FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF0.Reg) & 0x80000) >> 19
}
func (o *GPIOINT_Type) SetSTATF0_P0_20FEI(value uint32) {
	volatile.StoreUint32(&o.STATF0.Reg, volatile.LoadUint32(&o.STATF0.Reg)&^(0x100000)|value<<20)
}
func (o *GPIOINT_Type) GetSTATF0_P0_20FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF0.Reg) & 0x100000) >> 20
}
func (o *GPIOINT_Type) SetSTATF0_P0_21FEI(value uint32) {
	volatile.StoreUint32(&o.STATF0.Reg, volatile.LoadUint32(&o.STATF0.Reg)&^(0x200000)|value<<21)
}
func (o *GPIOINT_Type) GetSTATF0_P0_21FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF0.Reg) & 0x200000) >> 21
}
func (o *GPIOINT_Type) SetSTATF0_P0_22FEI(value uint32) {
	volatile.StoreUint32(&o.STATF0.Reg, volatile.LoadUint32(&o.STATF0.Reg)&^(0x400000)|value<<22)
}
func (o *GPIOINT_Type) GetSTATF0_P0_22FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF0.Reg) & 0x400000) >> 22
}
func (o *GPIOINT_Type) SetSTATF0_P0_23FEI(value uint32) {
	volatile.StoreUint32(&o.STATF0.Reg, volatile.LoadUint32(&o.STATF0.Reg)&^(0x800000)|value<<23)
}
func (o *GPIOINT_Type) GetSTATF0_P0_23FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF0.Reg) & 0x800000) >> 23
}
func (o *GPIOINT_Type) SetSTATF0_P0_24FEI(value uint32) {
	volatile.StoreUint32(&o.STATF0.Reg, volatile.LoadUint32(&o.STATF0.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIOINT_Type) GetSTATF0_P0_24FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF0.Reg) & 0x1000000) >> 24
}
func (o *GPIOINT_Type) SetSTATF0_P0_25FEI(value uint32) {
	volatile.StoreUint32(&o.STATF0.Reg, volatile.LoadUint32(&o.STATF0.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIOINT_Type) GetSTATF0_P0_25FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF0.Reg) & 0x2000000) >> 25
}
func (o *GPIOINT_Type) SetSTATF0_P0_26FEI(value uint32) {
	volatile.StoreUint32(&o.STATF0.Reg, volatile.LoadUint32(&o.STATF0.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIOINT_Type) GetSTATF0_P0_26FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF0.Reg) & 0x4000000) >> 26
}
func (o *GPIOINT_Type) SetSTATF0_P0_27FEI(value uint32) {
	volatile.StoreUint32(&o.STATF0.Reg, volatile.LoadUint32(&o.STATF0.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIOINT_Type) GetSTATF0_P0_27FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF0.Reg) & 0x8000000) >> 27
}
func (o *GPIOINT_Type) SetSTATF0_P0_28FEI(value uint32) {
	volatile.StoreUint32(&o.STATF0.Reg, volatile.LoadUint32(&o.STATF0.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIOINT_Type) GetSTATF0_P0_28FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF0.Reg) & 0x10000000) >> 28
}
func (o *GPIOINT_Type) SetSTATF0_P0_29FEI(value uint32) {
	volatile.StoreUint32(&o.STATF0.Reg, volatile.LoadUint32(&o.STATF0.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIOINT_Type) GetSTATF0_P0_29FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF0.Reg) & 0x20000000) >> 29
}
func (o *GPIOINT_Type) SetSTATF0_P0_30FEI(value uint32) {
	volatile.StoreUint32(&o.STATF0.Reg, volatile.LoadUint32(&o.STATF0.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIOINT_Type) GetSTATF0_P0_30FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF0.Reg) & 0x40000000) >> 30
}
func (o *GPIOINT_Type) SetSTATF0_P0_31FEI(value uint32) {
	volatile.StoreUint32(&o.STATF0.Reg, volatile.LoadUint32(&o.STATF0.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIOINT_Type) GetSTATF0_P0_31FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF0.Reg) & 0x80000000) >> 31
}

// GPIOINT.CLR0: GPIO Interrupt Clear.
func (o *GPIOINT_Type) SetCLR0_P0_0CI(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x1)|value)
}
func (o *GPIOINT_Type) GetCLR0_P0_0CI() uint32 {
	return volatile.LoadUint32(&o.CLR0.Reg) & 0x1
}
func (o *GPIOINT_Type) SetCLR0_P0_1CI(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x2)|value<<1)
}
func (o *GPIOINT_Type) GetCLR0_P0_1CI() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x2) >> 1
}
func (o *GPIOINT_Type) SetCLR0_P0_2CI(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x4)|value<<2)
}
func (o *GPIOINT_Type) GetCLR0_P0_2CI() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x4) >> 2
}
func (o *GPIOINT_Type) SetCLR0_P0_3CI(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x8)|value<<3)
}
func (o *GPIOINT_Type) GetCLR0_P0_3CI() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x8) >> 3
}
func (o *GPIOINT_Type) SetCLR0_P0_4CI(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x10)|value<<4)
}
func (o *GPIOINT_Type) GetCLR0_P0_4CI() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x10) >> 4
}
func (o *GPIOINT_Type) SetCLR0_P0_5CI(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x20)|value<<5)
}
func (o *GPIOINT_Type) GetCLR0_P0_5CI() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x20) >> 5
}
func (o *GPIOINT_Type) SetCLR0_P0_6CI(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x40)|value<<6)
}
func (o *GPIOINT_Type) GetCLR0_P0_6CI() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x40) >> 6
}
func (o *GPIOINT_Type) SetCLR0_P0_7CI(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x80)|value<<7)
}
func (o *GPIOINT_Type) GetCLR0_P0_7CI() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x80) >> 7
}
func (o *GPIOINT_Type) SetCLR0_P0_8CI(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x100)|value<<8)
}
func (o *GPIOINT_Type) GetCLR0_P0_8CI() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x100) >> 8
}
func (o *GPIOINT_Type) SetCLR0_P0_9CI(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x200)|value<<9)
}
func (o *GPIOINT_Type) GetCLR0_P0_9CI() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x200) >> 9
}
func (o *GPIOINT_Type) SetCLR0_P0_10CI(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x400)|value<<10)
}
func (o *GPIOINT_Type) GetCLR0_P0_10CI() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x400) >> 10
}
func (o *GPIOINT_Type) SetCLR0_P0_11CI(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x800)|value<<11)
}
func (o *GPIOINT_Type) GetCLR0_P0_11CI() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x800) >> 11
}
func (o *GPIOINT_Type) SetCLR0_P0_12CI(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x1000)|value<<12)
}
func (o *GPIOINT_Type) GetCLR0_P0_12CI() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x1000) >> 12
}
func (o *GPIOINT_Type) SetCLR0_P0_13CI(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x2000)|value<<13)
}
func (o *GPIOINT_Type) GetCLR0_P0_13CI() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x2000) >> 13
}
func (o *GPIOINT_Type) SetCLR0_P0_14CI(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x4000)|value<<14)
}
func (o *GPIOINT_Type) GetCLR0_P0_14CI() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x4000) >> 14
}
func (o *GPIOINT_Type) SetCLR0_P0_15CI(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x8000)|value<<15)
}
func (o *GPIOINT_Type) GetCLR0_P0_15CI() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x8000) >> 15
}
func (o *GPIOINT_Type) SetCLR0_P0_16CI(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x10000)|value<<16)
}
func (o *GPIOINT_Type) GetCLR0_P0_16CI() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x10000) >> 16
}
func (o *GPIOINT_Type) SetCLR0_P0_17CI(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x20000)|value<<17)
}
func (o *GPIOINT_Type) GetCLR0_P0_17CI() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x20000) >> 17
}
func (o *GPIOINT_Type) SetCLR0_P0_18CI(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x40000)|value<<18)
}
func (o *GPIOINT_Type) GetCLR0_P0_18CI() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x40000) >> 18
}
func (o *GPIOINT_Type) SetCLR0_P0_19CI(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x80000)|value<<19)
}
func (o *GPIOINT_Type) GetCLR0_P0_19CI() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x80000) >> 19
}
func (o *GPIOINT_Type) SetCLR0_P0_20CI(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x100000)|value<<20)
}
func (o *GPIOINT_Type) GetCLR0_P0_20CI() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x100000) >> 20
}
func (o *GPIOINT_Type) SetCLR0_P0_21CI(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x200000)|value<<21)
}
func (o *GPIOINT_Type) GetCLR0_P0_21CI() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x200000) >> 21
}
func (o *GPIOINT_Type) SetCLR0_P0_22CI(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x400000)|value<<22)
}
func (o *GPIOINT_Type) GetCLR0_P0_22CI() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x400000) >> 22
}
func (o *GPIOINT_Type) SetCLR0_P0_23CI(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x800000)|value<<23)
}
func (o *GPIOINT_Type) GetCLR0_P0_23CI() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x800000) >> 23
}
func (o *GPIOINT_Type) SetCLR0_P0_24CI(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIOINT_Type) GetCLR0_P0_24CI() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x1000000) >> 24
}
func (o *GPIOINT_Type) SetCLR0_P0_25CI(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIOINT_Type) GetCLR0_P0_25CI() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x2000000) >> 25
}
func (o *GPIOINT_Type) SetCLR0_P0_26CI(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIOINT_Type) GetCLR0_P0_26CI() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x4000000) >> 26
}
func (o *GPIOINT_Type) SetCLR0_P0_27CI(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIOINT_Type) GetCLR0_P0_27CI() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x8000000) >> 27
}
func (o *GPIOINT_Type) SetCLR0_P0_28CI(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIOINT_Type) GetCLR0_P0_28CI() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x10000000) >> 28
}
func (o *GPIOINT_Type) SetCLR0_P0_29CI(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIOINT_Type) GetCLR0_P0_29CI() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x20000000) >> 29
}
func (o *GPIOINT_Type) SetCLR0_P0_30CI(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIOINT_Type) GetCLR0_P0_30CI() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x40000000) >> 30
}
func (o *GPIOINT_Type) SetCLR0_P0_31CI(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIOINT_Type) GetCLR0_P0_31CI() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x80000000) >> 31
}

// GPIOINT.ENR0: GPIO Interrupt Enable for Rising edge for Port 0.
func (o *GPIOINT_Type) SetENR0_P0_0ER(value uint32) {
	volatile.StoreUint32(&o.ENR0.Reg, volatile.LoadUint32(&o.ENR0.Reg)&^(0x1)|value)
}
func (o *GPIOINT_Type) GetENR0_P0_0ER() uint32 {
	return volatile.LoadUint32(&o.ENR0.Reg) & 0x1
}
func (o *GPIOINT_Type) SetENR0_P0_1ER(value uint32) {
	volatile.StoreUint32(&o.ENR0.Reg, volatile.LoadUint32(&o.ENR0.Reg)&^(0x2)|value<<1)
}
func (o *GPIOINT_Type) GetENR0_P0_1ER() uint32 {
	return (volatile.LoadUint32(&o.ENR0.Reg) & 0x2) >> 1
}
func (o *GPIOINT_Type) SetENR0_P0_2ER(value uint32) {
	volatile.StoreUint32(&o.ENR0.Reg, volatile.LoadUint32(&o.ENR0.Reg)&^(0x4)|value<<2)
}
func (o *GPIOINT_Type) GetENR0_P0_2ER() uint32 {
	return (volatile.LoadUint32(&o.ENR0.Reg) & 0x4) >> 2
}
func (o *GPIOINT_Type) SetENR0_P0_3ER(value uint32) {
	volatile.StoreUint32(&o.ENR0.Reg, volatile.LoadUint32(&o.ENR0.Reg)&^(0x8)|value<<3)
}
func (o *GPIOINT_Type) GetENR0_P0_3ER() uint32 {
	return (volatile.LoadUint32(&o.ENR0.Reg) & 0x8) >> 3
}
func (o *GPIOINT_Type) SetENR0_P0_4ER(value uint32) {
	volatile.StoreUint32(&o.ENR0.Reg, volatile.LoadUint32(&o.ENR0.Reg)&^(0x10)|value<<4)
}
func (o *GPIOINT_Type) GetENR0_P0_4ER() uint32 {
	return (volatile.LoadUint32(&o.ENR0.Reg) & 0x10) >> 4
}
func (o *GPIOINT_Type) SetENR0_P0_5ER(value uint32) {
	volatile.StoreUint32(&o.ENR0.Reg, volatile.LoadUint32(&o.ENR0.Reg)&^(0x20)|value<<5)
}
func (o *GPIOINT_Type) GetENR0_P0_5ER() uint32 {
	return (volatile.LoadUint32(&o.ENR0.Reg) & 0x20) >> 5
}
func (o *GPIOINT_Type) SetENR0_P0_6ER(value uint32) {
	volatile.StoreUint32(&o.ENR0.Reg, volatile.LoadUint32(&o.ENR0.Reg)&^(0x40)|value<<6)
}
func (o *GPIOINT_Type) GetENR0_P0_6ER() uint32 {
	return (volatile.LoadUint32(&o.ENR0.Reg) & 0x40) >> 6
}
func (o *GPIOINT_Type) SetENR0_P0_7ER(value uint32) {
	volatile.StoreUint32(&o.ENR0.Reg, volatile.LoadUint32(&o.ENR0.Reg)&^(0x80)|value<<7)
}
func (o *GPIOINT_Type) GetENR0_P0_7ER() uint32 {
	return (volatile.LoadUint32(&o.ENR0.Reg) & 0x80) >> 7
}
func (o *GPIOINT_Type) SetENR0_P0_8ER(value uint32) {
	volatile.StoreUint32(&o.ENR0.Reg, volatile.LoadUint32(&o.ENR0.Reg)&^(0x100)|value<<8)
}
func (o *GPIOINT_Type) GetENR0_P0_8ER() uint32 {
	return (volatile.LoadUint32(&o.ENR0.Reg) & 0x100) >> 8
}
func (o *GPIOINT_Type) SetENR0_P0_9ER(value uint32) {
	volatile.StoreUint32(&o.ENR0.Reg, volatile.LoadUint32(&o.ENR0.Reg)&^(0x200)|value<<9)
}
func (o *GPIOINT_Type) GetENR0_P0_9ER() uint32 {
	return (volatile.LoadUint32(&o.ENR0.Reg) & 0x200) >> 9
}
func (o *GPIOINT_Type) SetENR0_P0_10ER(value uint32) {
	volatile.StoreUint32(&o.ENR0.Reg, volatile.LoadUint32(&o.ENR0.Reg)&^(0x400)|value<<10)
}
func (o *GPIOINT_Type) GetENR0_P0_10ER() uint32 {
	return (volatile.LoadUint32(&o.ENR0.Reg) & 0x400) >> 10
}
func (o *GPIOINT_Type) SetENR0_P0_11ER(value uint32) {
	volatile.StoreUint32(&o.ENR0.Reg, volatile.LoadUint32(&o.ENR0.Reg)&^(0x800)|value<<11)
}
func (o *GPIOINT_Type) GetENR0_P0_11ER() uint32 {
	return (volatile.LoadUint32(&o.ENR0.Reg) & 0x800) >> 11
}
func (o *GPIOINT_Type) SetENR0_P0_12ER(value uint32) {
	volatile.StoreUint32(&o.ENR0.Reg, volatile.LoadUint32(&o.ENR0.Reg)&^(0x1000)|value<<12)
}
func (o *GPIOINT_Type) GetENR0_P0_12ER() uint32 {
	return (volatile.LoadUint32(&o.ENR0.Reg) & 0x1000) >> 12
}
func (o *GPIOINT_Type) SetENR0_P0_13ER(value uint32) {
	volatile.StoreUint32(&o.ENR0.Reg, volatile.LoadUint32(&o.ENR0.Reg)&^(0x2000)|value<<13)
}
func (o *GPIOINT_Type) GetENR0_P0_13ER() uint32 {
	return (volatile.LoadUint32(&o.ENR0.Reg) & 0x2000) >> 13
}
func (o *GPIOINT_Type) SetENR0_P0_14ER(value uint32) {
	volatile.StoreUint32(&o.ENR0.Reg, volatile.LoadUint32(&o.ENR0.Reg)&^(0x4000)|value<<14)
}
func (o *GPIOINT_Type) GetENR0_P0_14ER() uint32 {
	return (volatile.LoadUint32(&o.ENR0.Reg) & 0x4000) >> 14
}
func (o *GPIOINT_Type) SetENR0_P0_15ER(value uint32) {
	volatile.StoreUint32(&o.ENR0.Reg, volatile.LoadUint32(&o.ENR0.Reg)&^(0x8000)|value<<15)
}
func (o *GPIOINT_Type) GetENR0_P0_15ER() uint32 {
	return (volatile.LoadUint32(&o.ENR0.Reg) & 0x8000) >> 15
}
func (o *GPIOINT_Type) SetENR0_P0_16ER(value uint32) {
	volatile.StoreUint32(&o.ENR0.Reg, volatile.LoadUint32(&o.ENR0.Reg)&^(0x10000)|value<<16)
}
func (o *GPIOINT_Type) GetENR0_P0_16ER() uint32 {
	return (volatile.LoadUint32(&o.ENR0.Reg) & 0x10000) >> 16
}
func (o *GPIOINT_Type) SetENR0_P0_17ER(value uint32) {
	volatile.StoreUint32(&o.ENR0.Reg, volatile.LoadUint32(&o.ENR0.Reg)&^(0x20000)|value<<17)
}
func (o *GPIOINT_Type) GetENR0_P0_17ER() uint32 {
	return (volatile.LoadUint32(&o.ENR0.Reg) & 0x20000) >> 17
}
func (o *GPIOINT_Type) SetENR0_P0_18ER(value uint32) {
	volatile.StoreUint32(&o.ENR0.Reg, volatile.LoadUint32(&o.ENR0.Reg)&^(0x40000)|value<<18)
}
func (o *GPIOINT_Type) GetENR0_P0_18ER() uint32 {
	return (volatile.LoadUint32(&o.ENR0.Reg) & 0x40000) >> 18
}
func (o *GPIOINT_Type) SetENR0_P0_19ER(value uint32) {
	volatile.StoreUint32(&o.ENR0.Reg, volatile.LoadUint32(&o.ENR0.Reg)&^(0x80000)|value<<19)
}
func (o *GPIOINT_Type) GetENR0_P0_19ER() uint32 {
	return (volatile.LoadUint32(&o.ENR0.Reg) & 0x80000) >> 19
}
func (o *GPIOINT_Type) SetENR0_P0_20ER(value uint32) {
	volatile.StoreUint32(&o.ENR0.Reg, volatile.LoadUint32(&o.ENR0.Reg)&^(0x100000)|value<<20)
}
func (o *GPIOINT_Type) GetENR0_P0_20ER() uint32 {
	return (volatile.LoadUint32(&o.ENR0.Reg) & 0x100000) >> 20
}
func (o *GPIOINT_Type) SetENR0_P0_21ER(value uint32) {
	volatile.StoreUint32(&o.ENR0.Reg, volatile.LoadUint32(&o.ENR0.Reg)&^(0x200000)|value<<21)
}
func (o *GPIOINT_Type) GetENR0_P0_21ER() uint32 {
	return (volatile.LoadUint32(&o.ENR0.Reg) & 0x200000) >> 21
}
func (o *GPIOINT_Type) SetENR0_P0_22ER(value uint32) {
	volatile.StoreUint32(&o.ENR0.Reg, volatile.LoadUint32(&o.ENR0.Reg)&^(0x400000)|value<<22)
}
func (o *GPIOINT_Type) GetENR0_P0_22ER() uint32 {
	return (volatile.LoadUint32(&o.ENR0.Reg) & 0x400000) >> 22
}
func (o *GPIOINT_Type) SetENR0_P0_23ER(value uint32) {
	volatile.StoreUint32(&o.ENR0.Reg, volatile.LoadUint32(&o.ENR0.Reg)&^(0x800000)|value<<23)
}
func (o *GPIOINT_Type) GetENR0_P0_23ER() uint32 {
	return (volatile.LoadUint32(&o.ENR0.Reg) & 0x800000) >> 23
}
func (o *GPIOINT_Type) SetENR0_P0_24ER(value uint32) {
	volatile.StoreUint32(&o.ENR0.Reg, volatile.LoadUint32(&o.ENR0.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIOINT_Type) GetENR0_P0_24ER() uint32 {
	return (volatile.LoadUint32(&o.ENR0.Reg) & 0x1000000) >> 24
}
func (o *GPIOINT_Type) SetENR0_P0_25ER(value uint32) {
	volatile.StoreUint32(&o.ENR0.Reg, volatile.LoadUint32(&o.ENR0.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIOINT_Type) GetENR0_P0_25ER() uint32 {
	return (volatile.LoadUint32(&o.ENR0.Reg) & 0x2000000) >> 25
}
func (o *GPIOINT_Type) SetENR0_P0_26ER(value uint32) {
	volatile.StoreUint32(&o.ENR0.Reg, volatile.LoadUint32(&o.ENR0.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIOINT_Type) GetENR0_P0_26ER() uint32 {
	return (volatile.LoadUint32(&o.ENR0.Reg) & 0x4000000) >> 26
}
func (o *GPIOINT_Type) SetENR0_P0_27ER(value uint32) {
	volatile.StoreUint32(&o.ENR0.Reg, volatile.LoadUint32(&o.ENR0.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIOINT_Type) GetENR0_P0_27ER() uint32 {
	return (volatile.LoadUint32(&o.ENR0.Reg) & 0x8000000) >> 27
}
func (o *GPIOINT_Type) SetENR0_P0_28ER(value uint32) {
	volatile.StoreUint32(&o.ENR0.Reg, volatile.LoadUint32(&o.ENR0.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIOINT_Type) GetENR0_P0_28ER() uint32 {
	return (volatile.LoadUint32(&o.ENR0.Reg) & 0x10000000) >> 28
}
func (o *GPIOINT_Type) SetENR0_P0_29ER(value uint32) {
	volatile.StoreUint32(&o.ENR0.Reg, volatile.LoadUint32(&o.ENR0.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIOINT_Type) GetENR0_P0_29ER() uint32 {
	return (volatile.LoadUint32(&o.ENR0.Reg) & 0x20000000) >> 29
}
func (o *GPIOINT_Type) SetENR0_P0_30ER(value uint32) {
	volatile.StoreUint32(&o.ENR0.Reg, volatile.LoadUint32(&o.ENR0.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIOINT_Type) GetENR0_P0_30ER() uint32 {
	return (volatile.LoadUint32(&o.ENR0.Reg) & 0x40000000) >> 30
}
func (o *GPIOINT_Type) SetENR0_P0_31ER(value uint32) {
	volatile.StoreUint32(&o.ENR0.Reg, volatile.LoadUint32(&o.ENR0.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIOINT_Type) GetENR0_P0_31ER() uint32 {
	return (volatile.LoadUint32(&o.ENR0.Reg) & 0x80000000) >> 31
}

// GPIOINT.ENF0: GPIO Interrupt Enable for Falling edge for Port 0.
func (o *GPIOINT_Type) SetENF0_P0_0EF(value uint32) {
	volatile.StoreUint32(&o.ENF0.Reg, volatile.LoadUint32(&o.ENF0.Reg)&^(0x1)|value)
}
func (o *GPIOINT_Type) GetENF0_P0_0EF() uint32 {
	return volatile.LoadUint32(&o.ENF0.Reg) & 0x1
}
func (o *GPIOINT_Type) SetENF0_P0_1EF(value uint32) {
	volatile.StoreUint32(&o.ENF0.Reg, volatile.LoadUint32(&o.ENF0.Reg)&^(0x2)|value<<1)
}
func (o *GPIOINT_Type) GetENF0_P0_1EF() uint32 {
	return (volatile.LoadUint32(&o.ENF0.Reg) & 0x2) >> 1
}
func (o *GPIOINT_Type) SetENF0_P0_2EF(value uint32) {
	volatile.StoreUint32(&o.ENF0.Reg, volatile.LoadUint32(&o.ENF0.Reg)&^(0x4)|value<<2)
}
func (o *GPIOINT_Type) GetENF0_P0_2EF() uint32 {
	return (volatile.LoadUint32(&o.ENF0.Reg) & 0x4) >> 2
}
func (o *GPIOINT_Type) SetENF0_P0_3EF(value uint32) {
	volatile.StoreUint32(&o.ENF0.Reg, volatile.LoadUint32(&o.ENF0.Reg)&^(0x8)|value<<3)
}
func (o *GPIOINT_Type) GetENF0_P0_3EF() uint32 {
	return (volatile.LoadUint32(&o.ENF0.Reg) & 0x8) >> 3
}
func (o *GPIOINT_Type) SetENF0_P0_4EF(value uint32) {
	volatile.StoreUint32(&o.ENF0.Reg, volatile.LoadUint32(&o.ENF0.Reg)&^(0x10)|value<<4)
}
func (o *GPIOINT_Type) GetENF0_P0_4EF() uint32 {
	return (volatile.LoadUint32(&o.ENF0.Reg) & 0x10) >> 4
}
func (o *GPIOINT_Type) SetENF0_P0_5EF(value uint32) {
	volatile.StoreUint32(&o.ENF0.Reg, volatile.LoadUint32(&o.ENF0.Reg)&^(0x20)|value<<5)
}
func (o *GPIOINT_Type) GetENF0_P0_5EF() uint32 {
	return (volatile.LoadUint32(&o.ENF0.Reg) & 0x20) >> 5
}
func (o *GPIOINT_Type) SetENF0_P0_6EF(value uint32) {
	volatile.StoreUint32(&o.ENF0.Reg, volatile.LoadUint32(&o.ENF0.Reg)&^(0x40)|value<<6)
}
func (o *GPIOINT_Type) GetENF0_P0_6EF() uint32 {
	return (volatile.LoadUint32(&o.ENF0.Reg) & 0x40) >> 6
}
func (o *GPIOINT_Type) SetENF0_P0_7EF(value uint32) {
	volatile.StoreUint32(&o.ENF0.Reg, volatile.LoadUint32(&o.ENF0.Reg)&^(0x80)|value<<7)
}
func (o *GPIOINT_Type) GetENF0_P0_7EF() uint32 {
	return (volatile.LoadUint32(&o.ENF0.Reg) & 0x80) >> 7
}
func (o *GPIOINT_Type) SetENF0_P0_8EF(value uint32) {
	volatile.StoreUint32(&o.ENF0.Reg, volatile.LoadUint32(&o.ENF0.Reg)&^(0x100)|value<<8)
}
func (o *GPIOINT_Type) GetENF0_P0_8EF() uint32 {
	return (volatile.LoadUint32(&o.ENF0.Reg) & 0x100) >> 8
}
func (o *GPIOINT_Type) SetENF0_P0_9EF(value uint32) {
	volatile.StoreUint32(&o.ENF0.Reg, volatile.LoadUint32(&o.ENF0.Reg)&^(0x200)|value<<9)
}
func (o *GPIOINT_Type) GetENF0_P0_9EF() uint32 {
	return (volatile.LoadUint32(&o.ENF0.Reg) & 0x200) >> 9
}
func (o *GPIOINT_Type) SetENF0_P0_10EF(value uint32) {
	volatile.StoreUint32(&o.ENF0.Reg, volatile.LoadUint32(&o.ENF0.Reg)&^(0x400)|value<<10)
}
func (o *GPIOINT_Type) GetENF0_P0_10EF() uint32 {
	return (volatile.LoadUint32(&o.ENF0.Reg) & 0x400) >> 10
}
func (o *GPIOINT_Type) SetENF0_P0_11EF(value uint32) {
	volatile.StoreUint32(&o.ENF0.Reg, volatile.LoadUint32(&o.ENF0.Reg)&^(0x800)|value<<11)
}
func (o *GPIOINT_Type) GetENF0_P0_11EF() uint32 {
	return (volatile.LoadUint32(&o.ENF0.Reg) & 0x800) >> 11
}
func (o *GPIOINT_Type) SetENF0_P0_12EF(value uint32) {
	volatile.StoreUint32(&o.ENF0.Reg, volatile.LoadUint32(&o.ENF0.Reg)&^(0x1000)|value<<12)
}
func (o *GPIOINT_Type) GetENF0_P0_12EF() uint32 {
	return (volatile.LoadUint32(&o.ENF0.Reg) & 0x1000) >> 12
}
func (o *GPIOINT_Type) SetENF0_P0_13EF(value uint32) {
	volatile.StoreUint32(&o.ENF0.Reg, volatile.LoadUint32(&o.ENF0.Reg)&^(0x2000)|value<<13)
}
func (o *GPIOINT_Type) GetENF0_P0_13EF() uint32 {
	return (volatile.LoadUint32(&o.ENF0.Reg) & 0x2000) >> 13
}
func (o *GPIOINT_Type) SetENF0_P0_14EF(value uint32) {
	volatile.StoreUint32(&o.ENF0.Reg, volatile.LoadUint32(&o.ENF0.Reg)&^(0x4000)|value<<14)
}
func (o *GPIOINT_Type) GetENF0_P0_14EF() uint32 {
	return (volatile.LoadUint32(&o.ENF0.Reg) & 0x4000) >> 14
}
func (o *GPIOINT_Type) SetENF0_P0_15EF(value uint32) {
	volatile.StoreUint32(&o.ENF0.Reg, volatile.LoadUint32(&o.ENF0.Reg)&^(0x8000)|value<<15)
}
func (o *GPIOINT_Type) GetENF0_P0_15EF() uint32 {
	return (volatile.LoadUint32(&o.ENF0.Reg) & 0x8000) >> 15
}
func (o *GPIOINT_Type) SetENF0_P0_16EF(value uint32) {
	volatile.StoreUint32(&o.ENF0.Reg, volatile.LoadUint32(&o.ENF0.Reg)&^(0x10000)|value<<16)
}
func (o *GPIOINT_Type) GetENF0_P0_16EF() uint32 {
	return (volatile.LoadUint32(&o.ENF0.Reg) & 0x10000) >> 16
}
func (o *GPIOINT_Type) SetENF0_P0_17EF(value uint32) {
	volatile.StoreUint32(&o.ENF0.Reg, volatile.LoadUint32(&o.ENF0.Reg)&^(0x20000)|value<<17)
}
func (o *GPIOINT_Type) GetENF0_P0_17EF() uint32 {
	return (volatile.LoadUint32(&o.ENF0.Reg) & 0x20000) >> 17
}
func (o *GPIOINT_Type) SetENF0_P0_18EF(value uint32) {
	volatile.StoreUint32(&o.ENF0.Reg, volatile.LoadUint32(&o.ENF0.Reg)&^(0x40000)|value<<18)
}
func (o *GPIOINT_Type) GetENF0_P0_18EF() uint32 {
	return (volatile.LoadUint32(&o.ENF0.Reg) & 0x40000) >> 18
}
func (o *GPIOINT_Type) SetENF0_P0_19EF(value uint32) {
	volatile.StoreUint32(&o.ENF0.Reg, volatile.LoadUint32(&o.ENF0.Reg)&^(0x80000)|value<<19)
}
func (o *GPIOINT_Type) GetENF0_P0_19EF() uint32 {
	return (volatile.LoadUint32(&o.ENF0.Reg) & 0x80000) >> 19
}
func (o *GPIOINT_Type) SetENF0_P0_20EF(value uint32) {
	volatile.StoreUint32(&o.ENF0.Reg, volatile.LoadUint32(&o.ENF0.Reg)&^(0x100000)|value<<20)
}
func (o *GPIOINT_Type) GetENF0_P0_20EF() uint32 {
	return (volatile.LoadUint32(&o.ENF0.Reg) & 0x100000) >> 20
}
func (o *GPIOINT_Type) SetENF0_P0_21EF(value uint32) {
	volatile.StoreUint32(&o.ENF0.Reg, volatile.LoadUint32(&o.ENF0.Reg)&^(0x200000)|value<<21)
}
func (o *GPIOINT_Type) GetENF0_P0_21EF() uint32 {
	return (volatile.LoadUint32(&o.ENF0.Reg) & 0x200000) >> 21
}
func (o *GPIOINT_Type) SetENF0_P0_22EF(value uint32) {
	volatile.StoreUint32(&o.ENF0.Reg, volatile.LoadUint32(&o.ENF0.Reg)&^(0x400000)|value<<22)
}
func (o *GPIOINT_Type) GetENF0_P0_22EF() uint32 {
	return (volatile.LoadUint32(&o.ENF0.Reg) & 0x400000) >> 22
}
func (o *GPIOINT_Type) SetENF0_P0_23EF(value uint32) {
	volatile.StoreUint32(&o.ENF0.Reg, volatile.LoadUint32(&o.ENF0.Reg)&^(0x800000)|value<<23)
}
func (o *GPIOINT_Type) GetENF0_P0_23EF() uint32 {
	return (volatile.LoadUint32(&o.ENF0.Reg) & 0x800000) >> 23
}
func (o *GPIOINT_Type) SetENF0_P0_24EF(value uint32) {
	volatile.StoreUint32(&o.ENF0.Reg, volatile.LoadUint32(&o.ENF0.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIOINT_Type) GetENF0_P0_24EF() uint32 {
	return (volatile.LoadUint32(&o.ENF0.Reg) & 0x1000000) >> 24
}
func (o *GPIOINT_Type) SetENF0_P0_25EF(value uint32) {
	volatile.StoreUint32(&o.ENF0.Reg, volatile.LoadUint32(&o.ENF0.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIOINT_Type) GetENF0_P0_25EF() uint32 {
	return (volatile.LoadUint32(&o.ENF0.Reg) & 0x2000000) >> 25
}
func (o *GPIOINT_Type) SetENF0_P0_26EF(value uint32) {
	volatile.StoreUint32(&o.ENF0.Reg, volatile.LoadUint32(&o.ENF0.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIOINT_Type) GetENF0_P0_26EF() uint32 {
	return (volatile.LoadUint32(&o.ENF0.Reg) & 0x4000000) >> 26
}
func (o *GPIOINT_Type) SetENF0_P0_27EF(value uint32) {
	volatile.StoreUint32(&o.ENF0.Reg, volatile.LoadUint32(&o.ENF0.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIOINT_Type) GetENF0_P0_27EF() uint32 {
	return (volatile.LoadUint32(&o.ENF0.Reg) & 0x8000000) >> 27
}
func (o *GPIOINT_Type) SetENF0_P0_28EF(value uint32) {
	volatile.StoreUint32(&o.ENF0.Reg, volatile.LoadUint32(&o.ENF0.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIOINT_Type) GetENF0_P0_28EF() uint32 {
	return (volatile.LoadUint32(&o.ENF0.Reg) & 0x10000000) >> 28
}
func (o *GPIOINT_Type) SetENF0_P0_29EF(value uint32) {
	volatile.StoreUint32(&o.ENF0.Reg, volatile.LoadUint32(&o.ENF0.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIOINT_Type) GetENF0_P0_29EF() uint32 {
	return (volatile.LoadUint32(&o.ENF0.Reg) & 0x20000000) >> 29
}
func (o *GPIOINT_Type) SetENF0_P0_30EF(value uint32) {
	volatile.StoreUint32(&o.ENF0.Reg, volatile.LoadUint32(&o.ENF0.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIOINT_Type) GetENF0_P0_30EF() uint32 {
	return (volatile.LoadUint32(&o.ENF0.Reg) & 0x40000000) >> 30
}
func (o *GPIOINT_Type) SetENF0_P0_31EF(value uint32) {
	volatile.StoreUint32(&o.ENF0.Reg, volatile.LoadUint32(&o.ENF0.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIOINT_Type) GetENF0_P0_31EF() uint32 {
	return (volatile.LoadUint32(&o.ENF0.Reg) & 0x80000000) >> 31
}

// GPIOINT.STATR2: GPIO Interrupt Status for Rising edge for Port 0.
func (o *GPIOINT_Type) SetSTATR2_P2_0REI(value uint32) {
	volatile.StoreUint32(&o.STATR2.Reg, volatile.LoadUint32(&o.STATR2.Reg)&^(0x1)|value)
}
func (o *GPIOINT_Type) GetSTATR2_P2_0REI() uint32 {
	return volatile.LoadUint32(&o.STATR2.Reg) & 0x1
}
func (o *GPIOINT_Type) SetSTATR2_P2_1REI(value uint32) {
	volatile.StoreUint32(&o.STATR2.Reg, volatile.LoadUint32(&o.STATR2.Reg)&^(0x2)|value<<1)
}
func (o *GPIOINT_Type) GetSTATR2_P2_1REI() uint32 {
	return (volatile.LoadUint32(&o.STATR2.Reg) & 0x2) >> 1
}
func (o *GPIOINT_Type) SetSTATR2_P2_2REI(value uint32) {
	volatile.StoreUint32(&o.STATR2.Reg, volatile.LoadUint32(&o.STATR2.Reg)&^(0x4)|value<<2)
}
func (o *GPIOINT_Type) GetSTATR2_P2_2REI() uint32 {
	return (volatile.LoadUint32(&o.STATR2.Reg) & 0x4) >> 2
}
func (o *GPIOINT_Type) SetSTATR2_P2_3REI(value uint32) {
	volatile.StoreUint32(&o.STATR2.Reg, volatile.LoadUint32(&o.STATR2.Reg)&^(0x8)|value<<3)
}
func (o *GPIOINT_Type) GetSTATR2_P2_3REI() uint32 {
	return (volatile.LoadUint32(&o.STATR2.Reg) & 0x8) >> 3
}
func (o *GPIOINT_Type) SetSTATR2_P2_4REI(value uint32) {
	volatile.StoreUint32(&o.STATR2.Reg, volatile.LoadUint32(&o.STATR2.Reg)&^(0x10)|value<<4)
}
func (o *GPIOINT_Type) GetSTATR2_P2_4REI() uint32 {
	return (volatile.LoadUint32(&o.STATR2.Reg) & 0x10) >> 4
}
func (o *GPIOINT_Type) SetSTATR2_P2_5REI(value uint32) {
	volatile.StoreUint32(&o.STATR2.Reg, volatile.LoadUint32(&o.STATR2.Reg)&^(0x20)|value<<5)
}
func (o *GPIOINT_Type) GetSTATR2_P2_5REI() uint32 {
	return (volatile.LoadUint32(&o.STATR2.Reg) & 0x20) >> 5
}
func (o *GPIOINT_Type) SetSTATR2_P2_6REI(value uint32) {
	volatile.StoreUint32(&o.STATR2.Reg, volatile.LoadUint32(&o.STATR2.Reg)&^(0x40)|value<<6)
}
func (o *GPIOINT_Type) GetSTATR2_P2_6REI() uint32 {
	return (volatile.LoadUint32(&o.STATR2.Reg) & 0x40) >> 6
}
func (o *GPIOINT_Type) SetSTATR2_P2_7REI(value uint32) {
	volatile.StoreUint32(&o.STATR2.Reg, volatile.LoadUint32(&o.STATR2.Reg)&^(0x80)|value<<7)
}
func (o *GPIOINT_Type) GetSTATR2_P2_7REI() uint32 {
	return (volatile.LoadUint32(&o.STATR2.Reg) & 0x80) >> 7
}
func (o *GPIOINT_Type) SetSTATR2_P2_8REI(value uint32) {
	volatile.StoreUint32(&o.STATR2.Reg, volatile.LoadUint32(&o.STATR2.Reg)&^(0x100)|value<<8)
}
func (o *GPIOINT_Type) GetSTATR2_P2_8REI() uint32 {
	return (volatile.LoadUint32(&o.STATR2.Reg) & 0x100) >> 8
}
func (o *GPIOINT_Type) SetSTATR2_P2_9REI(value uint32) {
	volatile.StoreUint32(&o.STATR2.Reg, volatile.LoadUint32(&o.STATR2.Reg)&^(0x200)|value<<9)
}
func (o *GPIOINT_Type) GetSTATR2_P2_9REI() uint32 {
	return (volatile.LoadUint32(&o.STATR2.Reg) & 0x200) >> 9
}
func (o *GPIOINT_Type) SetSTATR2_P2_10REI(value uint32) {
	volatile.StoreUint32(&o.STATR2.Reg, volatile.LoadUint32(&o.STATR2.Reg)&^(0x400)|value<<10)
}
func (o *GPIOINT_Type) GetSTATR2_P2_10REI() uint32 {
	return (volatile.LoadUint32(&o.STATR2.Reg) & 0x400) >> 10
}
func (o *GPIOINT_Type) SetSTATR2_P2_11REI(value uint32) {
	volatile.StoreUint32(&o.STATR2.Reg, volatile.LoadUint32(&o.STATR2.Reg)&^(0x800)|value<<11)
}
func (o *GPIOINT_Type) GetSTATR2_P2_11REI() uint32 {
	return (volatile.LoadUint32(&o.STATR2.Reg) & 0x800) >> 11
}
func (o *GPIOINT_Type) SetSTATR2_P2_12REI(value uint32) {
	volatile.StoreUint32(&o.STATR2.Reg, volatile.LoadUint32(&o.STATR2.Reg)&^(0x1000)|value<<12)
}
func (o *GPIOINT_Type) GetSTATR2_P2_12REI() uint32 {
	return (volatile.LoadUint32(&o.STATR2.Reg) & 0x1000) >> 12
}
func (o *GPIOINT_Type) SetSTATR2_P2_13REI(value uint32) {
	volatile.StoreUint32(&o.STATR2.Reg, volatile.LoadUint32(&o.STATR2.Reg)&^(0x2000)|value<<13)
}
func (o *GPIOINT_Type) GetSTATR2_P2_13REI() uint32 {
	return (volatile.LoadUint32(&o.STATR2.Reg) & 0x2000) >> 13
}
func (o *GPIOINT_Type) SetSTATR2_P2_14REI(value uint32) {
	volatile.StoreUint32(&o.STATR2.Reg, volatile.LoadUint32(&o.STATR2.Reg)&^(0x4000)|value<<14)
}
func (o *GPIOINT_Type) GetSTATR2_P2_14REI() uint32 {
	return (volatile.LoadUint32(&o.STATR2.Reg) & 0x4000) >> 14
}
func (o *GPIOINT_Type) SetSTATR2_P2_15REI(value uint32) {
	volatile.StoreUint32(&o.STATR2.Reg, volatile.LoadUint32(&o.STATR2.Reg)&^(0x8000)|value<<15)
}
func (o *GPIOINT_Type) GetSTATR2_P2_15REI() uint32 {
	return (volatile.LoadUint32(&o.STATR2.Reg) & 0x8000) >> 15
}
func (o *GPIOINT_Type) SetSTATR2_P2_16REI(value uint32) {
	volatile.StoreUint32(&o.STATR2.Reg, volatile.LoadUint32(&o.STATR2.Reg)&^(0x10000)|value<<16)
}
func (o *GPIOINT_Type) GetSTATR2_P2_16REI() uint32 {
	return (volatile.LoadUint32(&o.STATR2.Reg) & 0x10000) >> 16
}
func (o *GPIOINT_Type) SetSTATR2_P2_17REI(value uint32) {
	volatile.StoreUint32(&o.STATR2.Reg, volatile.LoadUint32(&o.STATR2.Reg)&^(0x20000)|value<<17)
}
func (o *GPIOINT_Type) GetSTATR2_P2_17REI() uint32 {
	return (volatile.LoadUint32(&o.STATR2.Reg) & 0x20000) >> 17
}
func (o *GPIOINT_Type) SetSTATR2_P2_18REI(value uint32) {
	volatile.StoreUint32(&o.STATR2.Reg, volatile.LoadUint32(&o.STATR2.Reg)&^(0x40000)|value<<18)
}
func (o *GPIOINT_Type) GetSTATR2_P2_18REI() uint32 {
	return (volatile.LoadUint32(&o.STATR2.Reg) & 0x40000) >> 18
}
func (o *GPIOINT_Type) SetSTATR2_P2_19REI(value uint32) {
	volatile.StoreUint32(&o.STATR2.Reg, volatile.LoadUint32(&o.STATR2.Reg)&^(0x80000)|value<<19)
}
func (o *GPIOINT_Type) GetSTATR2_P2_19REI() uint32 {
	return (volatile.LoadUint32(&o.STATR2.Reg) & 0x80000) >> 19
}
func (o *GPIOINT_Type) SetSTATR2_P2_20REI(value uint32) {
	volatile.StoreUint32(&o.STATR2.Reg, volatile.LoadUint32(&o.STATR2.Reg)&^(0x100000)|value<<20)
}
func (o *GPIOINT_Type) GetSTATR2_P2_20REI() uint32 {
	return (volatile.LoadUint32(&o.STATR2.Reg) & 0x100000) >> 20
}
func (o *GPIOINT_Type) SetSTATR2_P2_21REI(value uint32) {
	volatile.StoreUint32(&o.STATR2.Reg, volatile.LoadUint32(&o.STATR2.Reg)&^(0x200000)|value<<21)
}
func (o *GPIOINT_Type) GetSTATR2_P2_21REI() uint32 {
	return (volatile.LoadUint32(&o.STATR2.Reg) & 0x200000) >> 21
}
func (o *GPIOINT_Type) SetSTATR2_P2_22REI(value uint32) {
	volatile.StoreUint32(&o.STATR2.Reg, volatile.LoadUint32(&o.STATR2.Reg)&^(0x400000)|value<<22)
}
func (o *GPIOINT_Type) GetSTATR2_P2_22REI() uint32 {
	return (volatile.LoadUint32(&o.STATR2.Reg) & 0x400000) >> 22
}
func (o *GPIOINT_Type) SetSTATR2_P2_23REI(value uint32) {
	volatile.StoreUint32(&o.STATR2.Reg, volatile.LoadUint32(&o.STATR2.Reg)&^(0x800000)|value<<23)
}
func (o *GPIOINT_Type) GetSTATR2_P2_23REI() uint32 {
	return (volatile.LoadUint32(&o.STATR2.Reg) & 0x800000) >> 23
}
func (o *GPIOINT_Type) SetSTATR2_P2_24REI(value uint32) {
	volatile.StoreUint32(&o.STATR2.Reg, volatile.LoadUint32(&o.STATR2.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIOINT_Type) GetSTATR2_P2_24REI() uint32 {
	return (volatile.LoadUint32(&o.STATR2.Reg) & 0x1000000) >> 24
}
func (o *GPIOINT_Type) SetSTATR2_P2_25REI(value uint32) {
	volatile.StoreUint32(&o.STATR2.Reg, volatile.LoadUint32(&o.STATR2.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIOINT_Type) GetSTATR2_P2_25REI() uint32 {
	return (volatile.LoadUint32(&o.STATR2.Reg) & 0x2000000) >> 25
}
func (o *GPIOINT_Type) SetSTATR2_P2_26REI(value uint32) {
	volatile.StoreUint32(&o.STATR2.Reg, volatile.LoadUint32(&o.STATR2.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIOINT_Type) GetSTATR2_P2_26REI() uint32 {
	return (volatile.LoadUint32(&o.STATR2.Reg) & 0x4000000) >> 26
}
func (o *GPIOINT_Type) SetSTATR2_P2_27REI(value uint32) {
	volatile.StoreUint32(&o.STATR2.Reg, volatile.LoadUint32(&o.STATR2.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIOINT_Type) GetSTATR2_P2_27REI() uint32 {
	return (volatile.LoadUint32(&o.STATR2.Reg) & 0x8000000) >> 27
}
func (o *GPIOINT_Type) SetSTATR2_P2_28REI(value uint32) {
	volatile.StoreUint32(&o.STATR2.Reg, volatile.LoadUint32(&o.STATR2.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIOINT_Type) GetSTATR2_P2_28REI() uint32 {
	return (volatile.LoadUint32(&o.STATR2.Reg) & 0x10000000) >> 28
}
func (o *GPIOINT_Type) SetSTATR2_P2_29REI(value uint32) {
	volatile.StoreUint32(&o.STATR2.Reg, volatile.LoadUint32(&o.STATR2.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIOINT_Type) GetSTATR2_P2_29REI() uint32 {
	return (volatile.LoadUint32(&o.STATR2.Reg) & 0x20000000) >> 29
}
func (o *GPIOINT_Type) SetSTATR2_P2_30REI(value uint32) {
	volatile.StoreUint32(&o.STATR2.Reg, volatile.LoadUint32(&o.STATR2.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIOINT_Type) GetSTATR2_P2_30REI() uint32 {
	return (volatile.LoadUint32(&o.STATR2.Reg) & 0x40000000) >> 30
}
func (o *GPIOINT_Type) SetSTATR2_P2_31REI(value uint32) {
	volatile.StoreUint32(&o.STATR2.Reg, volatile.LoadUint32(&o.STATR2.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIOINT_Type) GetSTATR2_P2_31REI() uint32 {
	return (volatile.LoadUint32(&o.STATR2.Reg) & 0x80000000) >> 31
}

// GPIOINT.STATF2: GPIO Interrupt Status for Falling edge for Port 0.
func (o *GPIOINT_Type) SetSTATF2_P2_0FEI(value uint32) {
	volatile.StoreUint32(&o.STATF2.Reg, volatile.LoadUint32(&o.STATF2.Reg)&^(0x1)|value)
}
func (o *GPIOINT_Type) GetSTATF2_P2_0FEI() uint32 {
	return volatile.LoadUint32(&o.STATF2.Reg) & 0x1
}
func (o *GPIOINT_Type) SetSTATF2_P2_1FEI(value uint32) {
	volatile.StoreUint32(&o.STATF2.Reg, volatile.LoadUint32(&o.STATF2.Reg)&^(0x2)|value<<1)
}
func (o *GPIOINT_Type) GetSTATF2_P2_1FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF2.Reg) & 0x2) >> 1
}
func (o *GPIOINT_Type) SetSTATF2_P2_2FEI(value uint32) {
	volatile.StoreUint32(&o.STATF2.Reg, volatile.LoadUint32(&o.STATF2.Reg)&^(0x4)|value<<2)
}
func (o *GPIOINT_Type) GetSTATF2_P2_2FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF2.Reg) & 0x4) >> 2
}
func (o *GPIOINT_Type) SetSTATF2_P2_3FEI(value uint32) {
	volatile.StoreUint32(&o.STATF2.Reg, volatile.LoadUint32(&o.STATF2.Reg)&^(0x8)|value<<3)
}
func (o *GPIOINT_Type) GetSTATF2_P2_3FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF2.Reg) & 0x8) >> 3
}
func (o *GPIOINT_Type) SetSTATF2_P2_4FEI(value uint32) {
	volatile.StoreUint32(&o.STATF2.Reg, volatile.LoadUint32(&o.STATF2.Reg)&^(0x10)|value<<4)
}
func (o *GPIOINT_Type) GetSTATF2_P2_4FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF2.Reg) & 0x10) >> 4
}
func (o *GPIOINT_Type) SetSTATF2_P2_5FEI(value uint32) {
	volatile.StoreUint32(&o.STATF2.Reg, volatile.LoadUint32(&o.STATF2.Reg)&^(0x20)|value<<5)
}
func (o *GPIOINT_Type) GetSTATF2_P2_5FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF2.Reg) & 0x20) >> 5
}
func (o *GPIOINT_Type) SetSTATF2_P2_6FEI(value uint32) {
	volatile.StoreUint32(&o.STATF2.Reg, volatile.LoadUint32(&o.STATF2.Reg)&^(0x40)|value<<6)
}
func (o *GPIOINT_Type) GetSTATF2_P2_6FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF2.Reg) & 0x40) >> 6
}
func (o *GPIOINT_Type) SetSTATF2_P2_7FEI(value uint32) {
	volatile.StoreUint32(&o.STATF2.Reg, volatile.LoadUint32(&o.STATF2.Reg)&^(0x80)|value<<7)
}
func (o *GPIOINT_Type) GetSTATF2_P2_7FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF2.Reg) & 0x80) >> 7
}
func (o *GPIOINT_Type) SetSTATF2_P2_8FEI(value uint32) {
	volatile.StoreUint32(&o.STATF2.Reg, volatile.LoadUint32(&o.STATF2.Reg)&^(0x100)|value<<8)
}
func (o *GPIOINT_Type) GetSTATF2_P2_8FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF2.Reg) & 0x100) >> 8
}
func (o *GPIOINT_Type) SetSTATF2_P2_9FEI(value uint32) {
	volatile.StoreUint32(&o.STATF2.Reg, volatile.LoadUint32(&o.STATF2.Reg)&^(0x200)|value<<9)
}
func (o *GPIOINT_Type) GetSTATF2_P2_9FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF2.Reg) & 0x200) >> 9
}
func (o *GPIOINT_Type) SetSTATF2_P2_10FEI(value uint32) {
	volatile.StoreUint32(&o.STATF2.Reg, volatile.LoadUint32(&o.STATF2.Reg)&^(0x400)|value<<10)
}
func (o *GPIOINT_Type) GetSTATF2_P2_10FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF2.Reg) & 0x400) >> 10
}
func (o *GPIOINT_Type) SetSTATF2_P2_11FEI(value uint32) {
	volatile.StoreUint32(&o.STATF2.Reg, volatile.LoadUint32(&o.STATF2.Reg)&^(0x800)|value<<11)
}
func (o *GPIOINT_Type) GetSTATF2_P2_11FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF2.Reg) & 0x800) >> 11
}
func (o *GPIOINT_Type) SetSTATF2_P2_12FEI(value uint32) {
	volatile.StoreUint32(&o.STATF2.Reg, volatile.LoadUint32(&o.STATF2.Reg)&^(0x1000)|value<<12)
}
func (o *GPIOINT_Type) GetSTATF2_P2_12FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF2.Reg) & 0x1000) >> 12
}
func (o *GPIOINT_Type) SetSTATF2_P2_13FEI(value uint32) {
	volatile.StoreUint32(&o.STATF2.Reg, volatile.LoadUint32(&o.STATF2.Reg)&^(0x2000)|value<<13)
}
func (o *GPIOINT_Type) GetSTATF2_P2_13FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF2.Reg) & 0x2000) >> 13
}
func (o *GPIOINT_Type) SetSTATF2_P2_14FEI(value uint32) {
	volatile.StoreUint32(&o.STATF2.Reg, volatile.LoadUint32(&o.STATF2.Reg)&^(0x4000)|value<<14)
}
func (o *GPIOINT_Type) GetSTATF2_P2_14FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF2.Reg) & 0x4000) >> 14
}
func (o *GPIOINT_Type) SetSTATF2_P2_15FEI(value uint32) {
	volatile.StoreUint32(&o.STATF2.Reg, volatile.LoadUint32(&o.STATF2.Reg)&^(0x8000)|value<<15)
}
func (o *GPIOINT_Type) GetSTATF2_P2_15FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF2.Reg) & 0x8000) >> 15
}
func (o *GPIOINT_Type) SetSTATF2_P2_16FEI(value uint32) {
	volatile.StoreUint32(&o.STATF2.Reg, volatile.LoadUint32(&o.STATF2.Reg)&^(0x10000)|value<<16)
}
func (o *GPIOINT_Type) GetSTATF2_P2_16FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF2.Reg) & 0x10000) >> 16
}
func (o *GPIOINT_Type) SetSTATF2_P2_17FEI(value uint32) {
	volatile.StoreUint32(&o.STATF2.Reg, volatile.LoadUint32(&o.STATF2.Reg)&^(0x20000)|value<<17)
}
func (o *GPIOINT_Type) GetSTATF2_P2_17FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF2.Reg) & 0x20000) >> 17
}
func (o *GPIOINT_Type) SetSTATF2_P2_18FEI(value uint32) {
	volatile.StoreUint32(&o.STATF2.Reg, volatile.LoadUint32(&o.STATF2.Reg)&^(0x40000)|value<<18)
}
func (o *GPIOINT_Type) GetSTATF2_P2_18FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF2.Reg) & 0x40000) >> 18
}
func (o *GPIOINT_Type) SetSTATF2_P2_19FEI(value uint32) {
	volatile.StoreUint32(&o.STATF2.Reg, volatile.LoadUint32(&o.STATF2.Reg)&^(0x80000)|value<<19)
}
func (o *GPIOINT_Type) GetSTATF2_P2_19FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF2.Reg) & 0x80000) >> 19
}
func (o *GPIOINT_Type) SetSTATF2_P2_20FEI(value uint32) {
	volatile.StoreUint32(&o.STATF2.Reg, volatile.LoadUint32(&o.STATF2.Reg)&^(0x100000)|value<<20)
}
func (o *GPIOINT_Type) GetSTATF2_P2_20FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF2.Reg) & 0x100000) >> 20
}
func (o *GPIOINT_Type) SetSTATF2_P2_21FEI(value uint32) {
	volatile.StoreUint32(&o.STATF2.Reg, volatile.LoadUint32(&o.STATF2.Reg)&^(0x200000)|value<<21)
}
func (o *GPIOINT_Type) GetSTATF2_P2_21FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF2.Reg) & 0x200000) >> 21
}
func (o *GPIOINT_Type) SetSTATF2_P2_22FEI(value uint32) {
	volatile.StoreUint32(&o.STATF2.Reg, volatile.LoadUint32(&o.STATF2.Reg)&^(0x400000)|value<<22)
}
func (o *GPIOINT_Type) GetSTATF2_P2_22FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF2.Reg) & 0x400000) >> 22
}
func (o *GPIOINT_Type) SetSTATF2_P2_23FEI(value uint32) {
	volatile.StoreUint32(&o.STATF2.Reg, volatile.LoadUint32(&o.STATF2.Reg)&^(0x800000)|value<<23)
}
func (o *GPIOINT_Type) GetSTATF2_P2_23FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF2.Reg) & 0x800000) >> 23
}
func (o *GPIOINT_Type) SetSTATF2_P2_24FEI(value uint32) {
	volatile.StoreUint32(&o.STATF2.Reg, volatile.LoadUint32(&o.STATF2.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIOINT_Type) GetSTATF2_P2_24FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF2.Reg) & 0x1000000) >> 24
}
func (o *GPIOINT_Type) SetSTATF2_P2_25FEI(value uint32) {
	volatile.StoreUint32(&o.STATF2.Reg, volatile.LoadUint32(&o.STATF2.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIOINT_Type) GetSTATF2_P2_25FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF2.Reg) & 0x2000000) >> 25
}
func (o *GPIOINT_Type) SetSTATF2_P2_26FEI(value uint32) {
	volatile.StoreUint32(&o.STATF2.Reg, volatile.LoadUint32(&o.STATF2.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIOINT_Type) GetSTATF2_P2_26FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF2.Reg) & 0x4000000) >> 26
}
func (o *GPIOINT_Type) SetSTATF2_P2_27FEI(value uint32) {
	volatile.StoreUint32(&o.STATF2.Reg, volatile.LoadUint32(&o.STATF2.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIOINT_Type) GetSTATF2_P2_27FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF2.Reg) & 0x8000000) >> 27
}
func (o *GPIOINT_Type) SetSTATF2_P2_28FEI(value uint32) {
	volatile.StoreUint32(&o.STATF2.Reg, volatile.LoadUint32(&o.STATF2.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIOINT_Type) GetSTATF2_P2_28FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF2.Reg) & 0x10000000) >> 28
}
func (o *GPIOINT_Type) SetSTATF2_P2_29FEI(value uint32) {
	volatile.StoreUint32(&o.STATF2.Reg, volatile.LoadUint32(&o.STATF2.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIOINT_Type) GetSTATF2_P2_29FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF2.Reg) & 0x20000000) >> 29
}
func (o *GPIOINT_Type) SetSTATF2_P2_30FEI(value uint32) {
	volatile.StoreUint32(&o.STATF2.Reg, volatile.LoadUint32(&o.STATF2.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIOINT_Type) GetSTATF2_P2_30FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF2.Reg) & 0x40000000) >> 30
}
func (o *GPIOINT_Type) SetSTATF2_P2_31FEI(value uint32) {
	volatile.StoreUint32(&o.STATF2.Reg, volatile.LoadUint32(&o.STATF2.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIOINT_Type) GetSTATF2_P2_31FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF2.Reg) & 0x80000000) >> 31
}

// GPIOINT.CLR2: GPIO Interrupt Clear.
func (o *GPIOINT_Type) SetCLR2_P2_0CI(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x1)|value)
}
func (o *GPIOINT_Type) GetCLR2_P2_0CI() uint32 {
	return volatile.LoadUint32(&o.CLR2.Reg) & 0x1
}
func (o *GPIOINT_Type) SetCLR2_P2_1CI(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x2)|value<<1)
}
func (o *GPIOINT_Type) GetCLR2_P2_1CI() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x2) >> 1
}
func (o *GPIOINT_Type) SetCLR2_P2_2CI(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x4)|value<<2)
}
func (o *GPIOINT_Type) GetCLR2_P2_2CI() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x4) >> 2
}
func (o *GPIOINT_Type) SetCLR2_P2_3CI(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x8)|value<<3)
}
func (o *GPIOINT_Type) GetCLR2_P2_3CI() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x8) >> 3
}
func (o *GPIOINT_Type) SetCLR2_P2_4CI(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x10)|value<<4)
}
func (o *GPIOINT_Type) GetCLR2_P2_4CI() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x10) >> 4
}
func (o *GPIOINT_Type) SetCLR2_P2_5CI(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x20)|value<<5)
}
func (o *GPIOINT_Type) GetCLR2_P2_5CI() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x20) >> 5
}
func (o *GPIOINT_Type) SetCLR2_P2_6CI(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x40)|value<<6)
}
func (o *GPIOINT_Type) GetCLR2_P2_6CI() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x40) >> 6
}
func (o *GPIOINT_Type) SetCLR2_P2_7CI(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x80)|value<<7)
}
func (o *GPIOINT_Type) GetCLR2_P2_7CI() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x80) >> 7
}
func (o *GPIOINT_Type) SetCLR2_P2_8CI(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x100)|value<<8)
}
func (o *GPIOINT_Type) GetCLR2_P2_8CI() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x100) >> 8
}
func (o *GPIOINT_Type) SetCLR2_P2_9CI(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x200)|value<<9)
}
func (o *GPIOINT_Type) GetCLR2_P2_9CI() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x200) >> 9
}
func (o *GPIOINT_Type) SetCLR2_P2_10CI(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x400)|value<<10)
}
func (o *GPIOINT_Type) GetCLR2_P2_10CI() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x400) >> 10
}
func (o *GPIOINT_Type) SetCLR2_P2_11CI(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x800)|value<<11)
}
func (o *GPIOINT_Type) GetCLR2_P2_11CI() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x800) >> 11
}
func (o *GPIOINT_Type) SetCLR2_P2_12CI(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x1000)|value<<12)
}
func (o *GPIOINT_Type) GetCLR2_P2_12CI() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x1000) >> 12
}
func (o *GPIOINT_Type) SetCLR2_P2_13CI(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x2000)|value<<13)
}
func (o *GPIOINT_Type) GetCLR2_P2_13CI() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x2000) >> 13
}
func (o *GPIOINT_Type) SetCLR2_P2_14CI(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x4000)|value<<14)
}
func (o *GPIOINT_Type) GetCLR2_P2_14CI() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x4000) >> 14
}
func (o *GPIOINT_Type) SetCLR2_P2_15CI(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x8000)|value<<15)
}
func (o *GPIOINT_Type) GetCLR2_P2_15CI() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x8000) >> 15
}
func (o *GPIOINT_Type) SetCLR2_P2_16CI(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x10000)|value<<16)
}
func (o *GPIOINT_Type) GetCLR2_P2_16CI() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x10000) >> 16
}
func (o *GPIOINT_Type) SetCLR2_P2_17CI(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x20000)|value<<17)
}
func (o *GPIOINT_Type) GetCLR2_P2_17CI() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x20000) >> 17
}
func (o *GPIOINT_Type) SetCLR2_P2_18CI(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x40000)|value<<18)
}
func (o *GPIOINT_Type) GetCLR2_P2_18CI() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x40000) >> 18
}
func (o *GPIOINT_Type) SetCLR2_P2_19CI(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x80000)|value<<19)
}
func (o *GPIOINT_Type) GetCLR2_P2_19CI() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x80000) >> 19
}
func (o *GPIOINT_Type) SetCLR2_P2_20CI(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x100000)|value<<20)
}
func (o *GPIOINT_Type) GetCLR2_P2_20CI() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x100000) >> 20
}
func (o *GPIOINT_Type) SetCLR2_P2_21CI(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x200000)|value<<21)
}
func (o *GPIOINT_Type) GetCLR2_P2_21CI() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x200000) >> 21
}
func (o *GPIOINT_Type) SetCLR2_P2_22CI(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x400000)|value<<22)
}
func (o *GPIOINT_Type) GetCLR2_P2_22CI() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x400000) >> 22
}
func (o *GPIOINT_Type) SetCLR2_P2_23CI(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x800000)|value<<23)
}
func (o *GPIOINT_Type) GetCLR2_P2_23CI() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x800000) >> 23
}
func (o *GPIOINT_Type) SetCLR2_P2_24CI(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIOINT_Type) GetCLR2_P2_24CI() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x1000000) >> 24
}
func (o *GPIOINT_Type) SetCLR2_P2_25CI(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIOINT_Type) GetCLR2_P2_25CI() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x2000000) >> 25
}
func (o *GPIOINT_Type) SetCLR2_P2_26CI(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIOINT_Type) GetCLR2_P2_26CI() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x4000000) >> 26
}
func (o *GPIOINT_Type) SetCLR2_P2_27CI(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIOINT_Type) GetCLR2_P2_27CI() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x8000000) >> 27
}
func (o *GPIOINT_Type) SetCLR2_P2_28CI(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIOINT_Type) GetCLR2_P2_28CI() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x10000000) >> 28
}
func (o *GPIOINT_Type) SetCLR2_P2_29CI(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIOINT_Type) GetCLR2_P2_29CI() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x20000000) >> 29
}
func (o *GPIOINT_Type) SetCLR2_P2_30CI(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIOINT_Type) GetCLR2_P2_30CI() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x40000000) >> 30
}
func (o *GPIOINT_Type) SetCLR2_P2_31CI(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIOINT_Type) GetCLR2_P2_31CI() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x80000000) >> 31
}

// GPIOINT.ENR2: GPIO Interrupt Enable for Rising edge for Port 0.
func (o *GPIOINT_Type) SetENR2_P2_0ER(value uint32) {
	volatile.StoreUint32(&o.ENR2.Reg, volatile.LoadUint32(&o.ENR2.Reg)&^(0x1)|value)
}
func (o *GPIOINT_Type) GetENR2_P2_0ER() uint32 {
	return volatile.LoadUint32(&o.ENR2.Reg) & 0x1
}
func (o *GPIOINT_Type) SetENR2_P2_1ER(value uint32) {
	volatile.StoreUint32(&o.ENR2.Reg, volatile.LoadUint32(&o.ENR2.Reg)&^(0x2)|value<<1)
}
func (o *GPIOINT_Type) GetENR2_P2_1ER() uint32 {
	return (volatile.LoadUint32(&o.ENR2.Reg) & 0x2) >> 1
}
func (o *GPIOINT_Type) SetENR2_P2_2ER(value uint32) {
	volatile.StoreUint32(&o.ENR2.Reg, volatile.LoadUint32(&o.ENR2.Reg)&^(0x4)|value<<2)
}
func (o *GPIOINT_Type) GetENR2_P2_2ER() uint32 {
	return (volatile.LoadUint32(&o.ENR2.Reg) & 0x4) >> 2
}
func (o *GPIOINT_Type) SetENR2_P2_3ER(value uint32) {
	volatile.StoreUint32(&o.ENR2.Reg, volatile.LoadUint32(&o.ENR2.Reg)&^(0x8)|value<<3)
}
func (o *GPIOINT_Type) GetENR2_P2_3ER() uint32 {
	return (volatile.LoadUint32(&o.ENR2.Reg) & 0x8) >> 3
}
func (o *GPIOINT_Type) SetENR2_P2_4ER(value uint32) {
	volatile.StoreUint32(&o.ENR2.Reg, volatile.LoadUint32(&o.ENR2.Reg)&^(0x10)|value<<4)
}
func (o *GPIOINT_Type) GetENR2_P2_4ER() uint32 {
	return (volatile.LoadUint32(&o.ENR2.Reg) & 0x10) >> 4
}
func (o *GPIOINT_Type) SetENR2_P2_5ER(value uint32) {
	volatile.StoreUint32(&o.ENR2.Reg, volatile.LoadUint32(&o.ENR2.Reg)&^(0x20)|value<<5)
}
func (o *GPIOINT_Type) GetENR2_P2_5ER() uint32 {
	return (volatile.LoadUint32(&o.ENR2.Reg) & 0x20) >> 5
}
func (o *GPIOINT_Type) SetENR2_P2_6ER(value uint32) {
	volatile.StoreUint32(&o.ENR2.Reg, volatile.LoadUint32(&o.ENR2.Reg)&^(0x40)|value<<6)
}
func (o *GPIOINT_Type) GetENR2_P2_6ER() uint32 {
	return (volatile.LoadUint32(&o.ENR2.Reg) & 0x40) >> 6
}
func (o *GPIOINT_Type) SetENR2_P2_7ER(value uint32) {
	volatile.StoreUint32(&o.ENR2.Reg, volatile.LoadUint32(&o.ENR2.Reg)&^(0x80)|value<<7)
}
func (o *GPIOINT_Type) GetENR2_P2_7ER() uint32 {
	return (volatile.LoadUint32(&o.ENR2.Reg) & 0x80) >> 7
}
func (o *GPIOINT_Type) SetENR2_P2_8ER(value uint32) {
	volatile.StoreUint32(&o.ENR2.Reg, volatile.LoadUint32(&o.ENR2.Reg)&^(0x100)|value<<8)
}
func (o *GPIOINT_Type) GetENR2_P2_8ER() uint32 {
	return (volatile.LoadUint32(&o.ENR2.Reg) & 0x100) >> 8
}
func (o *GPIOINT_Type) SetENR2_P2_9ER(value uint32) {
	volatile.StoreUint32(&o.ENR2.Reg, volatile.LoadUint32(&o.ENR2.Reg)&^(0x200)|value<<9)
}
func (o *GPIOINT_Type) GetENR2_P2_9ER() uint32 {
	return (volatile.LoadUint32(&o.ENR2.Reg) & 0x200) >> 9
}
func (o *GPIOINT_Type) SetENR2_P2_10ER(value uint32) {
	volatile.StoreUint32(&o.ENR2.Reg, volatile.LoadUint32(&o.ENR2.Reg)&^(0x400)|value<<10)
}
func (o *GPIOINT_Type) GetENR2_P2_10ER() uint32 {
	return (volatile.LoadUint32(&o.ENR2.Reg) & 0x400) >> 10
}
func (o *GPIOINT_Type) SetENR2_P2_11ER(value uint32) {
	volatile.StoreUint32(&o.ENR2.Reg, volatile.LoadUint32(&o.ENR2.Reg)&^(0x800)|value<<11)
}
func (o *GPIOINT_Type) GetENR2_P2_11ER() uint32 {
	return (volatile.LoadUint32(&o.ENR2.Reg) & 0x800) >> 11
}
func (o *GPIOINT_Type) SetENR2_P2_12ER(value uint32) {
	volatile.StoreUint32(&o.ENR2.Reg, volatile.LoadUint32(&o.ENR2.Reg)&^(0x1000)|value<<12)
}
func (o *GPIOINT_Type) GetENR2_P2_12ER() uint32 {
	return (volatile.LoadUint32(&o.ENR2.Reg) & 0x1000) >> 12
}
func (o *GPIOINT_Type) SetENR2_P2_13ER(value uint32) {
	volatile.StoreUint32(&o.ENR2.Reg, volatile.LoadUint32(&o.ENR2.Reg)&^(0x2000)|value<<13)
}
func (o *GPIOINT_Type) GetENR2_P2_13ER() uint32 {
	return (volatile.LoadUint32(&o.ENR2.Reg) & 0x2000) >> 13
}
func (o *GPIOINT_Type) SetENR2_P2_14ER(value uint32) {
	volatile.StoreUint32(&o.ENR2.Reg, volatile.LoadUint32(&o.ENR2.Reg)&^(0x4000)|value<<14)
}
func (o *GPIOINT_Type) GetENR2_P2_14ER() uint32 {
	return (volatile.LoadUint32(&o.ENR2.Reg) & 0x4000) >> 14
}
func (o *GPIOINT_Type) SetENR2_P2_15ER(value uint32) {
	volatile.StoreUint32(&o.ENR2.Reg, volatile.LoadUint32(&o.ENR2.Reg)&^(0x8000)|value<<15)
}
func (o *GPIOINT_Type) GetENR2_P2_15ER() uint32 {
	return (volatile.LoadUint32(&o.ENR2.Reg) & 0x8000) >> 15
}
func (o *GPIOINT_Type) SetENR2_P2_16ER(value uint32) {
	volatile.StoreUint32(&o.ENR2.Reg, volatile.LoadUint32(&o.ENR2.Reg)&^(0x10000)|value<<16)
}
func (o *GPIOINT_Type) GetENR2_P2_16ER() uint32 {
	return (volatile.LoadUint32(&o.ENR2.Reg) & 0x10000) >> 16
}
func (o *GPIOINT_Type) SetENR2_P2_17ER(value uint32) {
	volatile.StoreUint32(&o.ENR2.Reg, volatile.LoadUint32(&o.ENR2.Reg)&^(0x20000)|value<<17)
}
func (o *GPIOINT_Type) GetENR2_P2_17ER() uint32 {
	return (volatile.LoadUint32(&o.ENR2.Reg) & 0x20000) >> 17
}
func (o *GPIOINT_Type) SetENR2_P2_18ER(value uint32) {
	volatile.StoreUint32(&o.ENR2.Reg, volatile.LoadUint32(&o.ENR2.Reg)&^(0x40000)|value<<18)
}
func (o *GPIOINT_Type) GetENR2_P2_18ER() uint32 {
	return (volatile.LoadUint32(&o.ENR2.Reg) & 0x40000) >> 18
}
func (o *GPIOINT_Type) SetENR2_P2_19ER(value uint32) {
	volatile.StoreUint32(&o.ENR2.Reg, volatile.LoadUint32(&o.ENR2.Reg)&^(0x80000)|value<<19)
}
func (o *GPIOINT_Type) GetENR2_P2_19ER() uint32 {
	return (volatile.LoadUint32(&o.ENR2.Reg) & 0x80000) >> 19
}
func (o *GPIOINT_Type) SetENR2_P2_20ER(value uint32) {
	volatile.StoreUint32(&o.ENR2.Reg, volatile.LoadUint32(&o.ENR2.Reg)&^(0x100000)|value<<20)
}
func (o *GPIOINT_Type) GetENR2_P2_20ER() uint32 {
	return (volatile.LoadUint32(&o.ENR2.Reg) & 0x100000) >> 20
}
func (o *GPIOINT_Type) SetENR2_P2_21ER(value uint32) {
	volatile.StoreUint32(&o.ENR2.Reg, volatile.LoadUint32(&o.ENR2.Reg)&^(0x200000)|value<<21)
}
func (o *GPIOINT_Type) GetENR2_P2_21ER() uint32 {
	return (volatile.LoadUint32(&o.ENR2.Reg) & 0x200000) >> 21
}
func (o *GPIOINT_Type) SetENR2_P2_22ER(value uint32) {
	volatile.StoreUint32(&o.ENR2.Reg, volatile.LoadUint32(&o.ENR2.Reg)&^(0x400000)|value<<22)
}
func (o *GPIOINT_Type) GetENR2_P2_22ER() uint32 {
	return (volatile.LoadUint32(&o.ENR2.Reg) & 0x400000) >> 22
}
func (o *GPIOINT_Type) SetENR2_P2_23ER(value uint32) {
	volatile.StoreUint32(&o.ENR2.Reg, volatile.LoadUint32(&o.ENR2.Reg)&^(0x800000)|value<<23)
}
func (o *GPIOINT_Type) GetENR2_P2_23ER() uint32 {
	return (volatile.LoadUint32(&o.ENR2.Reg) & 0x800000) >> 23
}
func (o *GPIOINT_Type) SetENR2_P2_24ER(value uint32) {
	volatile.StoreUint32(&o.ENR2.Reg, volatile.LoadUint32(&o.ENR2.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIOINT_Type) GetENR2_P2_24ER() uint32 {
	return (volatile.LoadUint32(&o.ENR2.Reg) & 0x1000000) >> 24
}
func (o *GPIOINT_Type) SetENR2_P2_25ER(value uint32) {
	volatile.StoreUint32(&o.ENR2.Reg, volatile.LoadUint32(&o.ENR2.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIOINT_Type) GetENR2_P2_25ER() uint32 {
	return (volatile.LoadUint32(&o.ENR2.Reg) & 0x2000000) >> 25
}
func (o *GPIOINT_Type) SetENR2_P2_26ER(value uint32) {
	volatile.StoreUint32(&o.ENR2.Reg, volatile.LoadUint32(&o.ENR2.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIOINT_Type) GetENR2_P2_26ER() uint32 {
	return (volatile.LoadUint32(&o.ENR2.Reg) & 0x4000000) >> 26
}
func (o *GPIOINT_Type) SetENR2_P2_27ER(value uint32) {
	volatile.StoreUint32(&o.ENR2.Reg, volatile.LoadUint32(&o.ENR2.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIOINT_Type) GetENR2_P2_27ER() uint32 {
	return (volatile.LoadUint32(&o.ENR2.Reg) & 0x8000000) >> 27
}
func (o *GPIOINT_Type) SetENR2_P2_28ER(value uint32) {
	volatile.StoreUint32(&o.ENR2.Reg, volatile.LoadUint32(&o.ENR2.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIOINT_Type) GetENR2_P2_28ER() uint32 {
	return (volatile.LoadUint32(&o.ENR2.Reg) & 0x10000000) >> 28
}
func (o *GPIOINT_Type) SetENR2_P2_29ER(value uint32) {
	volatile.StoreUint32(&o.ENR2.Reg, volatile.LoadUint32(&o.ENR2.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIOINT_Type) GetENR2_P2_29ER() uint32 {
	return (volatile.LoadUint32(&o.ENR2.Reg) & 0x20000000) >> 29
}
func (o *GPIOINT_Type) SetENR2_P2_30ER(value uint32) {
	volatile.StoreUint32(&o.ENR2.Reg, volatile.LoadUint32(&o.ENR2.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIOINT_Type) GetENR2_P2_30ER() uint32 {
	return (volatile.LoadUint32(&o.ENR2.Reg) & 0x40000000) >> 30
}
func (o *GPIOINT_Type) SetENR2_P2_31ER(value uint32) {
	volatile.StoreUint32(&o.ENR2.Reg, volatile.LoadUint32(&o.ENR2.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIOINT_Type) GetENR2_P2_31ER() uint32 {
	return (volatile.LoadUint32(&o.ENR2.Reg) & 0x80000000) >> 31
}

// GPIOINT.ENF2: GPIO Interrupt Enable for Falling edge for Port 0.
func (o *GPIOINT_Type) SetENF2_P2_0EF(value uint32) {
	volatile.StoreUint32(&o.ENF2.Reg, volatile.LoadUint32(&o.ENF2.Reg)&^(0x1)|value)
}
func (o *GPIOINT_Type) GetENF2_P2_0EF() uint32 {
	return volatile.LoadUint32(&o.ENF2.Reg) & 0x1
}
func (o *GPIOINT_Type) SetENF2_P2_1EF(value uint32) {
	volatile.StoreUint32(&o.ENF2.Reg, volatile.LoadUint32(&o.ENF2.Reg)&^(0x2)|value<<1)
}
func (o *GPIOINT_Type) GetENF2_P2_1EF() uint32 {
	return (volatile.LoadUint32(&o.ENF2.Reg) & 0x2) >> 1
}
func (o *GPIOINT_Type) SetENF2_P2_2EF(value uint32) {
	volatile.StoreUint32(&o.ENF2.Reg, volatile.LoadUint32(&o.ENF2.Reg)&^(0x4)|value<<2)
}
func (o *GPIOINT_Type) GetENF2_P2_2EF() uint32 {
	return (volatile.LoadUint32(&o.ENF2.Reg) & 0x4) >> 2
}
func (o *GPIOINT_Type) SetENF2_P2_3EF(value uint32) {
	volatile.StoreUint32(&o.ENF2.Reg, volatile.LoadUint32(&o.ENF2.Reg)&^(0x8)|value<<3)
}
func (o *GPIOINT_Type) GetENF2_P2_3EF() uint32 {
	return (volatile.LoadUint32(&o.ENF2.Reg) & 0x8) >> 3
}
func (o *GPIOINT_Type) SetENF2_P2_4EF(value uint32) {
	volatile.StoreUint32(&o.ENF2.Reg, volatile.LoadUint32(&o.ENF2.Reg)&^(0x10)|value<<4)
}
func (o *GPIOINT_Type) GetENF2_P2_4EF() uint32 {
	return (volatile.LoadUint32(&o.ENF2.Reg) & 0x10) >> 4
}
func (o *GPIOINT_Type) SetENF2_P2_5EF(value uint32) {
	volatile.StoreUint32(&o.ENF2.Reg, volatile.LoadUint32(&o.ENF2.Reg)&^(0x20)|value<<5)
}
func (o *GPIOINT_Type) GetENF2_P2_5EF() uint32 {
	return (volatile.LoadUint32(&o.ENF2.Reg) & 0x20) >> 5
}
func (o *GPIOINT_Type) SetENF2_P2_6EF(value uint32) {
	volatile.StoreUint32(&o.ENF2.Reg, volatile.LoadUint32(&o.ENF2.Reg)&^(0x40)|value<<6)
}
func (o *GPIOINT_Type) GetENF2_P2_6EF() uint32 {
	return (volatile.LoadUint32(&o.ENF2.Reg) & 0x40) >> 6
}
func (o *GPIOINT_Type) SetENF2_P2_7EF(value uint32) {
	volatile.StoreUint32(&o.ENF2.Reg, volatile.LoadUint32(&o.ENF2.Reg)&^(0x80)|value<<7)
}
func (o *GPIOINT_Type) GetENF2_P2_7EF() uint32 {
	return (volatile.LoadUint32(&o.ENF2.Reg) & 0x80) >> 7
}
func (o *GPIOINT_Type) SetENF2_P2_8EF(value uint32) {
	volatile.StoreUint32(&o.ENF2.Reg, volatile.LoadUint32(&o.ENF2.Reg)&^(0x100)|value<<8)
}
func (o *GPIOINT_Type) GetENF2_P2_8EF() uint32 {
	return (volatile.LoadUint32(&o.ENF2.Reg) & 0x100) >> 8
}
func (o *GPIOINT_Type) SetENF2_P2_9EF(value uint32) {
	volatile.StoreUint32(&o.ENF2.Reg, volatile.LoadUint32(&o.ENF2.Reg)&^(0x200)|value<<9)
}
func (o *GPIOINT_Type) GetENF2_P2_9EF() uint32 {
	return (volatile.LoadUint32(&o.ENF2.Reg) & 0x200) >> 9
}
func (o *GPIOINT_Type) SetENF2_P2_10EF(value uint32) {
	volatile.StoreUint32(&o.ENF2.Reg, volatile.LoadUint32(&o.ENF2.Reg)&^(0x400)|value<<10)
}
func (o *GPIOINT_Type) GetENF2_P2_10EF() uint32 {
	return (volatile.LoadUint32(&o.ENF2.Reg) & 0x400) >> 10
}
func (o *GPIOINT_Type) SetENF2_P2_11EF(value uint32) {
	volatile.StoreUint32(&o.ENF2.Reg, volatile.LoadUint32(&o.ENF2.Reg)&^(0x800)|value<<11)
}
func (o *GPIOINT_Type) GetENF2_P2_11EF() uint32 {
	return (volatile.LoadUint32(&o.ENF2.Reg) & 0x800) >> 11
}
func (o *GPIOINT_Type) SetENF2_P2_12EF(value uint32) {
	volatile.StoreUint32(&o.ENF2.Reg, volatile.LoadUint32(&o.ENF2.Reg)&^(0x1000)|value<<12)
}
func (o *GPIOINT_Type) GetENF2_P2_12EF() uint32 {
	return (volatile.LoadUint32(&o.ENF2.Reg) & 0x1000) >> 12
}
func (o *GPIOINT_Type) SetENF2_P2_13EF(value uint32) {
	volatile.StoreUint32(&o.ENF2.Reg, volatile.LoadUint32(&o.ENF2.Reg)&^(0x2000)|value<<13)
}
func (o *GPIOINT_Type) GetENF2_P2_13EF() uint32 {
	return (volatile.LoadUint32(&o.ENF2.Reg) & 0x2000) >> 13
}
func (o *GPIOINT_Type) SetENF2_P2_14EF(value uint32) {
	volatile.StoreUint32(&o.ENF2.Reg, volatile.LoadUint32(&o.ENF2.Reg)&^(0x4000)|value<<14)
}
func (o *GPIOINT_Type) GetENF2_P2_14EF() uint32 {
	return (volatile.LoadUint32(&o.ENF2.Reg) & 0x4000) >> 14
}
func (o *GPIOINT_Type) SetENF2_P2_15EF(value uint32) {
	volatile.StoreUint32(&o.ENF2.Reg, volatile.LoadUint32(&o.ENF2.Reg)&^(0x8000)|value<<15)
}
func (o *GPIOINT_Type) GetENF2_P2_15EF() uint32 {
	return (volatile.LoadUint32(&o.ENF2.Reg) & 0x8000) >> 15
}
func (o *GPIOINT_Type) SetENF2_P2_16EF(value uint32) {
	volatile.StoreUint32(&o.ENF2.Reg, volatile.LoadUint32(&o.ENF2.Reg)&^(0x10000)|value<<16)
}
func (o *GPIOINT_Type) GetENF2_P2_16EF() uint32 {
	return (volatile.LoadUint32(&o.ENF2.Reg) & 0x10000) >> 16
}
func (o *GPIOINT_Type) SetENF2_P2_17EF(value uint32) {
	volatile.StoreUint32(&o.ENF2.Reg, volatile.LoadUint32(&o.ENF2.Reg)&^(0x20000)|value<<17)
}
func (o *GPIOINT_Type) GetENF2_P2_17EF() uint32 {
	return (volatile.LoadUint32(&o.ENF2.Reg) & 0x20000) >> 17
}
func (o *GPIOINT_Type) SetENF2_P2_18EF(value uint32) {
	volatile.StoreUint32(&o.ENF2.Reg, volatile.LoadUint32(&o.ENF2.Reg)&^(0x40000)|value<<18)
}
func (o *GPIOINT_Type) GetENF2_P2_18EF() uint32 {
	return (volatile.LoadUint32(&o.ENF2.Reg) & 0x40000) >> 18
}
func (o *GPIOINT_Type) SetENF2_P2_19EF(value uint32) {
	volatile.StoreUint32(&o.ENF2.Reg, volatile.LoadUint32(&o.ENF2.Reg)&^(0x80000)|value<<19)
}
func (o *GPIOINT_Type) GetENF2_P2_19EF() uint32 {
	return (volatile.LoadUint32(&o.ENF2.Reg) & 0x80000) >> 19
}
func (o *GPIOINT_Type) SetENF2_P2_20EF(value uint32) {
	volatile.StoreUint32(&o.ENF2.Reg, volatile.LoadUint32(&o.ENF2.Reg)&^(0x100000)|value<<20)
}
func (o *GPIOINT_Type) GetENF2_P2_20EF() uint32 {
	return (volatile.LoadUint32(&o.ENF2.Reg) & 0x100000) >> 20
}
func (o *GPIOINT_Type) SetENF2_P2_21EF(value uint32) {
	volatile.StoreUint32(&o.ENF2.Reg, volatile.LoadUint32(&o.ENF2.Reg)&^(0x200000)|value<<21)
}
func (o *GPIOINT_Type) GetENF2_P2_21EF() uint32 {
	return (volatile.LoadUint32(&o.ENF2.Reg) & 0x200000) >> 21
}
func (o *GPIOINT_Type) SetENF2_P2_22EF(value uint32) {
	volatile.StoreUint32(&o.ENF2.Reg, volatile.LoadUint32(&o.ENF2.Reg)&^(0x400000)|value<<22)
}
func (o *GPIOINT_Type) GetENF2_P2_22EF() uint32 {
	return (volatile.LoadUint32(&o.ENF2.Reg) & 0x400000) >> 22
}
func (o *GPIOINT_Type) SetENF2_P2_23EF(value uint32) {
	volatile.StoreUint32(&o.ENF2.Reg, volatile.LoadUint32(&o.ENF2.Reg)&^(0x800000)|value<<23)
}
func (o *GPIOINT_Type) GetENF2_P2_23EF() uint32 {
	return (volatile.LoadUint32(&o.ENF2.Reg) & 0x800000) >> 23
}
func (o *GPIOINT_Type) SetENF2_P2_24EF(value uint32) {
	volatile.StoreUint32(&o.ENF2.Reg, volatile.LoadUint32(&o.ENF2.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIOINT_Type) GetENF2_P2_24EF() uint32 {
	return (volatile.LoadUint32(&o.ENF2.Reg) & 0x1000000) >> 24
}
func (o *GPIOINT_Type) SetENF2_P2_25EF(value uint32) {
	volatile.StoreUint32(&o.ENF2.Reg, volatile.LoadUint32(&o.ENF2.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIOINT_Type) GetENF2_P2_25EF() uint32 {
	return (volatile.LoadUint32(&o.ENF2.Reg) & 0x2000000) >> 25
}
func (o *GPIOINT_Type) SetENF2_P2_26EF(value uint32) {
	volatile.StoreUint32(&o.ENF2.Reg, volatile.LoadUint32(&o.ENF2.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIOINT_Type) GetENF2_P2_26EF() uint32 {
	return (volatile.LoadUint32(&o.ENF2.Reg) & 0x4000000) >> 26
}
func (o *GPIOINT_Type) SetENF2_P2_27EF(value uint32) {
	volatile.StoreUint32(&o.ENF2.Reg, volatile.LoadUint32(&o.ENF2.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIOINT_Type) GetENF2_P2_27EF() uint32 {
	return (volatile.LoadUint32(&o.ENF2.Reg) & 0x8000000) >> 27
}
func (o *GPIOINT_Type) SetENF2_P2_28EF(value uint32) {
	volatile.StoreUint32(&o.ENF2.Reg, volatile.LoadUint32(&o.ENF2.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIOINT_Type) GetENF2_P2_28EF() uint32 {
	return (volatile.LoadUint32(&o.ENF2.Reg) & 0x10000000) >> 28
}
func (o *GPIOINT_Type) SetENF2_P2_29EF(value uint32) {
	volatile.StoreUint32(&o.ENF2.Reg, volatile.LoadUint32(&o.ENF2.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIOINT_Type) GetENF2_P2_29EF() uint32 {
	return (volatile.LoadUint32(&o.ENF2.Reg) & 0x20000000) >> 29
}
func (o *GPIOINT_Type) SetENF2_P2_30EF(value uint32) {
	volatile.StoreUint32(&o.ENF2.Reg, volatile.LoadUint32(&o.ENF2.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIOINT_Type) GetENF2_P2_30EF() uint32 {
	return (volatile.LoadUint32(&o.ENF2.Reg) & 0x40000000) >> 30
}
func (o *GPIOINT_Type) SetENF2_P2_31EF(value uint32) {
	volatile.StoreUint32(&o.ENF2.Reg, volatile.LoadUint32(&o.ENF2.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIOINT_Type) GetENF2_P2_31EF() uint32 {
	return (volatile.LoadUint32(&o.ENF2.Reg) & 0x80000000) >> 31
}

// IOCON pin configuration
type IOCON_Type struct {
	P0_0  volatile.Register32 // 0x0
	P0_1  volatile.Register32 // 0x4
	P0_2  volatile.Register32 // 0x8
	P0_3  volatile.Register32 // 0xC
	P0_4  volatile.Register32 // 0x10
	P0_5  volatile.Register32 // 0x14
	P0_6  volatile.Register32 // 0x18
	P0_7  volatile.Register32 // 0x1C
	P0_8  volatile.Register32 // 0x20
	P0_9  volatile.Register32 // 0x24
	P0_10 volatile.Register32 // 0x28
	P0_11 volatile.Register32 // 0x2C
	P0_12 volatile.Register32 // 0x30
	P0_13 volatile.Register32 // 0x34
	P0_14 volatile.Register32 // 0x38
	P0_15 volatile.Register32 // 0x3C
	P0_16 volatile.Register32 // 0x40
	P0_17 volatile.Register32 // 0x44
	P0_18 volatile.Register32 // 0x48
	P0_19 volatile.Register32 // 0x4C
	P0_20 volatile.Register32 // 0x50
	P0_21 volatile.Register32 // 0x54
	P0_22 volatile.Register32 // 0x58
	P0_23 volatile.Register32 // 0x5C
	P0_24 volatile.Register32 // 0x60
	P0_25 volatile.Register32 // 0x64
	P0_26 volatile.Register32 // 0x68
	P0_27 volatile.Register32 // 0x6C
	P0_28 volatile.Register32 // 0x70
	P0_29 volatile.Register32 // 0x74
	P0_30 volatile.Register32 // 0x78
	P0_31 volatile.Register32 // 0x7C
	P1_0  volatile.Register32 // 0x80
	P1_1  volatile.Register32 // 0x84
	P1_2  volatile.Register32 // 0x88
	P1_3  volatile.Register32 // 0x8C
	P1_4  volatile.Register32 // 0x90
	P1_5  volatile.Register32 // 0x94
	P1_6  volatile.Register32 // 0x98
	P1_7  volatile.Register32 // 0x9C
	P1_8  volatile.Register32 // 0xA0
	P1_9  volatile.Register32 // 0xA4
	P1_10 volatile.Register32 // 0xA8
	P1_11 volatile.Register32 // 0xAC
	P1_12 volatile.Register32 // 0xB0
	P1_13 volatile.Register32 // 0xB4
	P1_14 volatile.Register32 // 0xB8
	P1_15 volatile.Register32 // 0xBC
	P1_16 volatile.Register32 // 0xC0
	P1_17 volatile.Register32 // 0xC4
	P1_18 volatile.Register32 // 0xC8
	P1_19 volatile.Register32 // 0xCC
	P1_20 volatile.Register32 // 0xD0
	P1_21 volatile.Register32 // 0xD4
	P1_22 volatile.Register32 // 0xD8
	P1_23 volatile.Register32 // 0xDC
	P1_24 volatile.Register32 // 0xE0
	P1_25 volatile.Register32 // 0xE4
	P1_26 volatile.Register32 // 0xE8
	P1_27 volatile.Register32 // 0xEC
	P1_28 volatile.Register32 // 0xF0
	P1_29 volatile.Register32 // 0xF4
	P1_30 volatile.Register32 // 0xF8
	P1_31 volatile.Register32 // 0xFC
	P2_0  volatile.Register32 // 0x100
	P2_1  volatile.Register32 // 0x104
	P2_2  volatile.Register32 // 0x108
	P2_3  volatile.Register32 // 0x10C
	P2_4  volatile.Register32 // 0x110
	P2_5  volatile.Register32 // 0x114
	P2_6  volatile.Register32 // 0x118
	P2_7  volatile.Register32 // 0x11C
	P2_8  volatile.Register32 // 0x120
	P2_9  volatile.Register32 // 0x124
	P2_10 volatile.Register32 // 0x128
	P2_11 volatile.Register32 // 0x12C
	P2_12 volatile.Register32 // 0x130
	P2_13 volatile.Register32 // 0x134
	P2_14 volatile.Register32 // 0x138
	P2_15 volatile.Register32 // 0x13C
	P2_16 volatile.Register32 // 0x140
	P2_17 volatile.Register32 // 0x144
	P2_18 volatile.Register32 // 0x148
	P2_19 volatile.Register32 // 0x14C
	P2_20 volatile.Register32 // 0x150
	P2_21 volatile.Register32 // 0x154
	P2_22 volatile.Register32 // 0x158
	P2_23 volatile.Register32 // 0x15C
	P2_24 volatile.Register32 // 0x160
	P2_25 volatile.Register32 // 0x164
	P2_26 volatile.Register32 // 0x168
	P2_27 volatile.Register32 // 0x16C
	P2_28 volatile.Register32 // 0x170
	P2_29 volatile.Register32 // 0x174
	P2_30 volatile.Register32 // 0x178
	P2_31 volatile.Register32 // 0x17C
	P3_0  volatile.Register32 // 0x180
	P3_1  volatile.Register32 // 0x184
	P3_2  volatile.Register32 // 0x188
	P3_3  volatile.Register32 // 0x18C
	P3_4  volatile.Register32 // 0x190
	P3_5  volatile.Register32 // 0x194
	P3_6  volatile.Register32 // 0x198
	P3_7  volatile.Register32 // 0x19C
	P3_8  volatile.Register32 // 0x1A0
	P3_9  volatile.Register32 // 0x1A4
	P3_10 volatile.Register32 // 0x1A8
	P3_11 volatile.Register32 // 0x1AC
	P3_12 volatile.Register32 // 0x1B0
	P3_13 volatile.Register32 // 0x1B4
	P3_14 volatile.Register32 // 0x1B8
	P3_15 volatile.Register32 // 0x1BC
	P3_16 volatile.Register32 // 0x1C0
	P3_17 volatile.Register32 // 0x1C4
	P3_18 volatile.Register32 // 0x1C8
	P3_19 volatile.Register32 // 0x1CC
	P3_20 volatile.Register32 // 0x1D0
	P3_21 volatile.Register32 // 0x1D4
	P3_22 volatile.Register32 // 0x1D8
	P3_23 volatile.Register32 // 0x1DC
	P3_24 volatile.Register32 // 0x1E0
	P3_25 volatile.Register32 // 0x1E4
	P3_26 volatile.Register32 // 0x1E8
	P3_27 volatile.Register32 // 0x1EC
	P3_28 volatile.Register32 // 0x1F0
	P3_29 volatile.Register32 // 0x1F4
	P3_30 volatile.Register32 // 0x1F8
	P3_31 volatile.Register32 // 0x1FC
	P4_0  volatile.Register32 // 0x200
	P4_1  volatile.Register32 // 0x204
	P4_2  volatile.Register32 // 0x208
	P4_3  volatile.Register32 // 0x20C
	P4_4  volatile.Register32 // 0x210
	P4_5  volatile.Register32 // 0x214
	P4_6  volatile.Register32 // 0x218
	P4_7  volatile.Register32 // 0x21C
	P4_8  volatile.Register32 // 0x220
	P4_9  volatile.Register32 // 0x224
	P4_10 volatile.Register32 // 0x228
	P4_11 volatile.Register32 // 0x22C
	P4_12 volatile.Register32 // 0x230
	P4_13 volatile.Register32 // 0x234
	P4_14 volatile.Register32 // 0x238
	P4_15 volatile.Register32 // 0x23C
	P4_16 volatile.Register32 // 0x240
	P4_17 volatile.Register32 // 0x244
	P4_18 volatile.Register32 // 0x248
	P4_19 volatile.Register32 // 0x24C
	P4_20 volatile.Register32 // 0x250
	P4_21 volatile.Register32 // 0x254
	P4_22 volatile.Register32 // 0x258
	P4_23 volatile.Register32 // 0x25C
	P4_24 volatile.Register32 // 0x260
	P4_25 volatile.Register32 // 0x264
	P4_26 volatile.Register32 // 0x268
	P4_27 volatile.Register32 // 0x26C
	P4_28 volatile.Register32 // 0x270
	P4_29 volatile.Register32 // 0x274
	P4_30 volatile.Register32 // 0x278
	P4_31 volatile.Register32 // 0x27C
	P5_0  volatile.Register32 // 0x280
	P5_1  volatile.Register32 // 0x284
	P5_2  volatile.Register32 // 0x288
	P5_3  volatile.Register32 // 0x28C
	P5_4  volatile.Register32 // 0x290
}

// IOCON.P0_0: I/O configuration register for pin P0[0]
func (o *IOCON_Type) SetP0_0_FUNC(value uint32) {
	volatile.StoreUint32(&o.P0_0.Reg, volatile.LoadUint32(&o.P0_0.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetP0_0_FUNC() uint32 {
	return volatile.LoadUint32(&o.P0_0.Reg) & 0x7
}
func (o *IOCON_Type) SetP0_0_MODE(value uint32) {
	volatile.StoreUint32(&o.P0_0.Reg, volatile.LoadUint32(&o.P0_0.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetP0_0_MODE() uint32 {
	return (volatile.LoadUint32(&o.P0_0.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetP0_0_HYS(value uint32) {
	volatile.StoreUint32(&o.P0_0.Reg, volatile.LoadUint32(&o.P0_0.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetP0_0_HYS() uint32 {
	return (volatile.LoadUint32(&o.P0_0.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetP0_0_INV(value uint32) {
	volatile.StoreUint32(&o.P0_0.Reg, volatile.LoadUint32(&o.P0_0.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetP0_0_INV() uint32 {
	return (volatile.LoadUint32(&o.P0_0.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetP0_0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.P0_0.Reg, volatile.LoadUint32(&o.P0_0.Reg)&^(0x180)|value<<7)
}
func (o *IOCON_Type) GetP0_0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.P0_0.Reg) & 0x180) >> 7
}
func (o *IOCON_Type) SetP0_0_SLEW(value uint32) {
	volatile.StoreUint32(&o.P0_0.Reg, volatile.LoadUint32(&o.P0_0.Reg)&^(0x200)|value<<9)
}
func (o *IOCON_Type) GetP0_0_SLEW() uint32 {
	return (volatile.LoadUint32(&o.P0_0.Reg) & 0x200) >> 9
}
func (o *IOCON_Type) SetP0_0_OD(value uint32) {
	volatile.StoreUint32(&o.P0_0.Reg, volatile.LoadUint32(&o.P0_0.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetP0_0_OD() uint32 {
	return (volatile.LoadUint32(&o.P0_0.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetP0_0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.P0_0.Reg, volatile.LoadUint32(&o.P0_0.Reg)&^(0xfffff800)|value<<11)
}
func (o *IOCON_Type) GetP0_0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.P0_0.Reg) & 0xfffff800) >> 11
}

// IOCON.P0_1: I/O configuration register for pin P0[1]
func (o *IOCON_Type) SetP0_1_FUNC(value uint32) {
	volatile.StoreUint32(&o.P0_1.Reg, volatile.LoadUint32(&o.P0_1.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetP0_1_FUNC() uint32 {
	return volatile.LoadUint32(&o.P0_1.Reg) & 0x7
}
func (o *IOCON_Type) SetP0_1_MODE(value uint32) {
	volatile.StoreUint32(&o.P0_1.Reg, volatile.LoadUint32(&o.P0_1.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetP0_1_MODE() uint32 {
	return (volatile.LoadUint32(&o.P0_1.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetP0_1_HYS(value uint32) {
	volatile.StoreUint32(&o.P0_1.Reg, volatile.LoadUint32(&o.P0_1.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetP0_1_HYS() uint32 {
	return (volatile.LoadUint32(&o.P0_1.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetP0_1_INV(value uint32) {
	volatile.StoreUint32(&o.P0_1.Reg, volatile.LoadUint32(&o.P0_1.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetP0_1_INV() uint32 {
	return (volatile.LoadUint32(&o.P0_1.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetP0_1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.P0_1.Reg, volatile.LoadUint32(&o.P0_1.Reg)&^(0x180)|value<<7)
}
func (o *IOCON_Type) GetP0_1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.P0_1.Reg) & 0x180) >> 7
}
func (o *IOCON_Type) SetP0_1_SLEW(value uint32) {
	volatile.StoreUint32(&o.P0_1.Reg, volatile.LoadUint32(&o.P0_1.Reg)&^(0x200)|value<<9)
}
func (o *IOCON_Type) GetP0_1_SLEW() uint32 {
	return (volatile.LoadUint32(&o.P0_1.Reg) & 0x200) >> 9
}
func (o *IOCON_Type) SetP0_1_OD(value uint32) {
	volatile.StoreUint32(&o.P0_1.Reg, volatile.LoadUint32(&o.P0_1.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetP0_1_OD() uint32 {
	return (volatile.LoadUint32(&o.P0_1.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetP0_1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.P0_1.Reg, volatile.LoadUint32(&o.P0_1.Reg)&^(0xfffff800)|value<<11)
}
func (o *IOCON_Type) GetP0_1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.P0_1.Reg) & 0xfffff800) >> 11
}

// IOCON.P0_2: I/O configuration register for pin P0[2]
func (o *IOCON_Type) SetP0_2_FUNC(value uint32) {
	volatile.StoreUint32(&o.P0_2.Reg, volatile.LoadUint32(&o.P0_2.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetP0_2_FUNC() uint32 {
	return volatile.LoadUint32(&o.P0_2.Reg) & 0x7
}
func (o *IOCON_Type) SetP0_2_MODE(value uint32) {
	volatile.StoreUint32(&o.P0_2.Reg, volatile.LoadUint32(&o.P0_2.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetP0_2_MODE() uint32 {
	return (volatile.LoadUint32(&o.P0_2.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetP0_2_HYS(value uint32) {
	volatile.StoreUint32(&o.P0_2.Reg, volatile.LoadUint32(&o.P0_2.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetP0_2_HYS() uint32 {
	return (volatile.LoadUint32(&o.P0_2.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetP0_2_INV(value uint32) {
	volatile.StoreUint32(&o.P0_2.Reg, volatile.LoadUint32(&o.P0_2.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetP0_2_INV() uint32 {
	return (volatile.LoadUint32(&o.P0_2.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetP0_2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.P0_2.Reg, volatile.LoadUint32(&o.P0_2.Reg)&^(0x180)|value<<7)
}
func (o *IOCON_Type) GetP0_2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.P0_2.Reg) & 0x180) >> 7
}
func (o *IOCON_Type) SetP0_2_SLEW(value uint32) {
	volatile.StoreUint32(&o.P0_2.Reg, volatile.LoadUint32(&o.P0_2.Reg)&^(0x200)|value<<9)
}
func (o *IOCON_Type) GetP0_2_SLEW() uint32 {
	return (volatile.LoadUint32(&o.P0_2.Reg) & 0x200) >> 9
}
func (o *IOCON_Type) SetP0_2_OD(value uint32) {
	volatile.StoreUint32(&o.P0_2.Reg, volatile.LoadUint32(&o.P0_2.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetP0_2_OD() uint32 {
	return (volatile.LoadUint32(&o.P0_2.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetP0_2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.P0_2.Reg, volatile.LoadUint32(&o.P0_2.Reg)&^(0xfffff800)|value<<11)
}
func (o *IOCON_Type) GetP0_2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.P0_2.Reg) & 0xfffff800) >> 11
}

// IOCON.P0_3: I/O configuration register for pin P0[3]
func (o *IOCON_Type) SetP0_3_FUNC(value uint32) {
	volatile.StoreUint32(&o.P0_3.Reg, volatile.LoadUint32(&o.P0_3.Reg)&^(0x7)|value)
}
func (o *IOCON_Type) GetP0_3_FUNC() uint32 {
	return volatile.LoadUint32(&o.P0_3.Reg) & 0x7
}
func (o *IOCON_Type) SetP0_3_MODE(value uint32) {
	volatile.StoreUint32(&o.P0_3.Reg, volatile.LoadUint32(&o.P0_3.Reg)&^(0x18)|value<<3)
}
func (o *IOCON_Type) GetP0_3_MODE() uint32 {
	return (volatile.LoadUint32(&o.P0_3.Reg) & 0x18) >> 3
}
func (o *IOCON_Type) SetP0_3_HYS(value uint32) {
	volatile.StoreUint32(&o.P0_3.Reg, volatile.LoadUint32(&o.P0_3.Reg)&^(0x20)|value<<5)
}
func (o *IOCON_Type) GetP0_3_HYS() uint32 {
	return (volatile.LoadUint32(&o.P0_3.Reg) & 0x20) >> 5
}
func (o *IOCON_Type) SetP0_3_INV(value uint32) {
	volatile.StoreUint32(&o.P0_3.Reg, volatile.LoadUint32(&o.P0_3.Reg)&^(0x40)|value<<6)
}
func (o *IOCON_Type) GetP0_3_INV() uint32 {
	return (volatile.LoadUint32(&o.P0_3.Reg) & 0x40) >> 6
}
func (o *IOCON_Type) SetP0_3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.P0_3.Reg, volatile.LoadUint32(&o.P0_3.Reg)&^(0x180)|value<<7)
}
func (o *IOCON_Type) GetP0_3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.P0_3.Reg) & 0x180) >> 7
}
func (o *IOCON_Type) SetP0_3_SLEW(value uint32) {
	volatile.StoreUint32(&o.P0_3.Reg, volatile.LoadUint32(&o.P0_3.Reg)&^(0x200)|value<<9)
}
func (o *IOCON_Type) GetP0_3_SLEW() uint32 {
	return (volatile.LoadUint32(&o.P0_3.Reg) & 0x200) >> 9
}
func (o *IOCON_Type) SetP0_3_OD(value uint32) {
	volatile.StoreUint32(&o.P0_3.Reg, volatile.LoadUint32(&o.P0_3.Reg)&^(0x400)|value<<10)
}
func (o *IOCON_Type) GetP0_3_OD() uint32 {
	return (volatile.LoadUint32(&o.P0_3.Reg) & 0x400) >> 10
}
func (o *IOCON_Type) SetP0_3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.P0_3.Reg, volatile.LoadUint32(&o.P0_3.Reg)&^(0xfffff800)|value<<11)
}
func (o *IOCON_Type) GetP0_3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.P0_3.Reg) & 0xfffff800) >> 11
}

// IOCON.P0_4: I/O configuration register for pin P0[4]
func (o *IOCON_Type) SetP0_4_FUNC(value uint32)