/*
 * Decompiled with CFR 0.152.
 */
package org.h2.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import org.h2.command.CommandInterface;
import org.h2.engine.SessionInterface;
import org.h2.expression.ParameterInterface;
import org.h2.jdbc.JdbcBatchUpdateException;
import org.h2.jdbc.JdbcConnection;
import org.h2.jdbc.JdbcParameterMetaData;
import org.h2.jdbc.JdbcPreparedStatementBackwardsCompat;
import org.h2.jdbc.JdbcResultSet;
import org.h2.jdbc.JdbcResultSetMetaData;
import org.h2.jdbc.JdbcStatement;
import org.h2.message.DbException;
import org.h2.result.MergedResult;
import org.h2.result.ResultInterface;
import org.h2.result.ResultWithGeneratedKeys;
import org.h2.util.IOUtils;
import org.h2.util.Utils;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueByte;
import org.h2.value.ValueBytes;
import org.h2.value.ValueDate;
import org.h2.value.ValueDecimal;
import org.h2.value.ValueDouble;
import org.h2.value.ValueFloat;
import org.h2.value.ValueInt;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueShort;
import org.h2.value.ValueString;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;

public class JdbcPreparedStatement
extends JdbcStatement
implements PreparedStatement,
JdbcPreparedStatementBackwardsCompat {
    protected CommandInterface command;
    private final String sqlStatement;
    private ArrayList<Value[]> batchParameters;
    private MergedResult batchIdentities;
    private HashMap<String, Integer> cachedColumnLabelMap;
    private final Object generatedKeysRequest;

    JdbcPreparedStatement(JdbcConnection jdbcConnection, String string, int n, int n2, int n3, boolean bl, Object object) {
        super(jdbcConnection, n, n2, n3, bl);
        this.generatedKeysRequest = jdbcConnection.scopeGeneratedKeys() ? Boolean.valueOf(false) : object;
        this.setTrace(this.session.getTrace(), 3, n);
        this.sqlStatement = string;
        this.command = jdbcConnection.prepareCommand(string, this.fetchSize);
    }

    void setCachedColumnLabelMap(HashMap<String, Integer> hashMap) {
        this.cachedColumnLabelMap = hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet executeQuery() throws SQLException {
        try {
            int n = JdbcPreparedStatement.getNextId(4);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("ResultSet", 4, n, "executeQuery()");
            }
            this.batchIdentities = null;
            SessionInterface sessionInterface = this.session;
            synchronized (sessionInterface) {
                ResultInterface resultInterface;
                this.checkClosed();
                this.closeOldResultSet();
                boolean bl = false;
                boolean bl2 = this.resultSetType != 1003;
                boolean bl3 = this.resultSetConcurrency == 1008;
                try {
                    this.setExecutingStatement(this.command);
                    resultInterface = this.command.executeQuery(this.maxRows, bl2);
                    bl = resultInterface.isLazy();
                }
                finally {
                    if (!bl) {
                        this.setExecutingStatement(null);
                    }
                }
                this.resultSet = new JdbcResultSet(this.conn, this, this.command, resultInterface, n, this.closedByResultSet, bl2, bl3, this.cachedColumnLabelMap);
            }
            return this.resultSet;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int executeUpdate() throws SQLException {
        try {
            this.debugCodeCall("executeUpdate");
            this.checkClosedForWrite();
            this.batchIdentities = null;
            return this.executeUpdateInternal();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        try {
            this.debugCodeCall("executeLargeUpdate");
            this.checkClosedForWrite();
            this.batchIdentities = null;
            return this.executeUpdateInternal();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeUpdateInternal() throws SQLException {
        this.closeOldResultSet();
        SessionInterface sessionInterface = this.session;
        synchronized (sessionInterface) {
            try {
                this.setExecutingStatement(this.command);
                ResultWithGeneratedKeys resultWithGeneratedKeys = this.command.executeUpdate(this.generatedKeysRequest);
                this.updateCount = resultWithGeneratedKeys.getUpdateCount();
                ResultInterface resultInterface = resultWithGeneratedKeys.getGeneratedKeys();
                if (resultInterface != null) {
                    int n = JdbcPreparedStatement.getNextId(4);
                    this.generatedKeys = new JdbcResultSet(this.conn, this, this.command, resultInterface, n, false, true, false);
                }
            }
            finally {
                this.setExecutingStatement(null);
            }
        }
        return this.updateCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() throws SQLException {
        try {
            boolean bl;
            int n = JdbcPreparedStatement.getNextId(4);
            if (this.isDebugEnabled()) {
                this.debugCodeCall("execute");
            }
            this.checkClosedForWrite();
            SessionInterface sessionInterface = this.conn.getSession();
            synchronized (sessionInterface) {
                this.closeOldResultSet();
                boolean bl2 = false;
                try {
                    this.setExecutingStatement(this.command);
                    if (this.command.isQuery()) {
                        bl = true;
                        boolean bl3 = this.resultSetType != 1003;
                        boolean bl4 = this.resultSetConcurrency == 1008;
                        ResultInterface resultInterface = this.command.executeQuery(this.maxRows, bl3);
                        bl2 = resultInterface.isLazy();
                        this.resultSet = new JdbcResultSet(this.conn, this, this.command, resultInterface, n, this.closedByResultSet, bl3, bl4, this.cachedColumnLabelMap);
                    } else {
                        bl = false;
                        ResultWithGeneratedKeys resultWithGeneratedKeys = this.command.executeUpdate(this.generatedKeysRequest);
                        this.updateCount = resultWithGeneratedKeys.getUpdateCount();
                        ResultInterface resultInterface = resultWithGeneratedKeys.getGeneratedKeys();
                        if (resultInterface != null) {
                            this.generatedKeys = new JdbcResultSet(this.conn, this, this.command, resultInterface, n, false, true, false);
                        }
                    }
                }
                finally {
                    if (!bl2) {
                        this.setExecutingStatement(null);
                    }
                }
            }
            return bl;
        }
        catch (Throwable throwable) {
            throw this.logAndConvert(throwable);
        }
    }

    @Override
    public void clearParameters() throws SQLException {
        try {
            this.debugCodeCall("clearParameters");
            this.checkClosed();
            ArrayList<? extends ParameterInterface> arrayList = this.command.getParameters();
            for (ParameterInterface parameterInterface : arrayList) {
                parameterInterface.setValue(null, this.batchParameters == null);
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        try {
            this.debugCodeCall("executeQuery", string);
            throw DbException.get(90130);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void addBatch(String string) throws SQLException {
        try {
            this.debugCodeCall("addBatch", string);
            throw DbException.get(90130);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int executeUpdate(String string) throws SQLException {
        try {
            this.debugCodeCall("executeUpdate", string);
            throw DbException.get(90130);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public long executeLargeUpdate(String string) throws SQLException {
        try {
            this.debugCodeCall("executeLargeUpdate", string);
            throw DbException.get(90130);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean execute(String string) throws SQLException {
        try {
            this.debugCodeCall("execute", string);
            throw DbException.get(90130);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setNull(int n, int n2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setNull(" + n + ", " + n2 + ");");
            }
            this.setParameter(n, ValueNull.INSTANCE);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setInt(int n, int n2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setInt(" + n + ", " + n2 + ");");
            }
            this.setParameter(n, ValueInt.get(n2));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setString(int n, String string) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setString(" + n + ", " + JdbcPreparedStatement.quote(string) + ");");
            }
            this.setParameter(n, string == null ? ValueNull.INSTANCE : ValueString.get(string));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setBigDecimal(" + n + ", " + JdbcPreparedStatement.quoteBigDecimal(bigDecimal) + ");");
            }
            this.setParameter(n, bigDecimal == null ? ValueNull.INSTANCE : ValueDecimal.get(bigDecimal));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setDate(int n, Date date) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setDate(" + n + ", " + JdbcPreparedStatement.quoteDate(date) + ");");
            }
            this.setParameter(n, date == null ? ValueNull.INSTANCE : ValueDate.get(null, date));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setTime(int n, Time time) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setTime(" + n + ", " + JdbcPreparedStatement.quoteTime(time) + ");");
            }
            this.setParameter(n, time == null ? ValueNull.INSTANCE : ValueTime.get(null, time));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setTimestamp(" + n + ", " + JdbcPreparedStatement.quoteTimestamp(timestamp) + ");");
            }
            this.setParameter(n, timestamp == null ? ValueNull.INSTANCE : ValueTimestamp.get(null, timestamp));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setObject(int n, Object object) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setObject(" + n + ", x);");
            }
            if (object == null) {
                this.setParameter(n, ValueNull.INSTANCE);
            } else {
                this.setParameter(n, DataType.convertToValue(this.session, object, -1));
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setObject(int n, Object object, int n2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setObject(" + n + ", x, " + n2 + ");");
            }
            int n3 = DataType.convertSQLTypeToValueType(n2);
            if (object == null) {
                this.setParameter(n, ValueNull.INSTANCE);
            } else {
                Value value = DataType.convertToValue(this.conn.getSession(), object, n3);
                this.setParameter(n, value.convertTo(n3, this.conn, false));
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setObject(" + n + ", x, " + n2 + ", " + n3 + ");");
            }
            this.setObject(n, object, n2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setBoolean(int n, boolean bl) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setBoolean(" + n + ", " + bl + ");");
            }
            this.setParameter(n, ValueBoolean.get(bl));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setByte(int n, byte by) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setByte(" + n + ", " + by + ");");
            }
            this.setParameter(n, ValueByte.get(by));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setShort(int n, short s2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setShort(" + n + ", (short) " + s2 + ");");
            }
            this.setParameter(n, ValueShort.get(s2));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setLong(int n, long l) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setLong(" + n + ", " + l + "L);");
            }
            this.setParameter(n, ValueLong.get(l));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setFloat(int n, float f) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setFloat(" + n + ", " + f + "f);");
            }
            this.setParameter(n, ValueFloat.get(f));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setDouble(int n, double d) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setDouble(" + n + ", " + d + "d);");
            }
            this.setParameter(n, ValueDouble.get(d));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setRef(int n, Ref ref) throws SQLException {
        throw this.unsupported("ref");
    }

    @Override
    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setDate(" + n + ", " + JdbcPreparedStatement.quoteDate(date) + ", calendar);");
            }
            if (date == null) {
                this.setParameter(n, ValueNull.INSTANCE);
            } else {
                this.setParameter(n, ValueDate.get(calendar != null ? calendar.getTimeZone() : null, date));
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setTime(" + n + ", " + JdbcPreparedStatement.quoteTime(time) + ", calendar);");
            }
            if (time == null) {
                this.setParameter(n, ValueNull.INSTANCE);
            } else {
                this.setParameter(n, ValueTime.get(calendar != null ? calendar.getTimeZone() : null, time));
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setTimestamp(" + n + ", " + JdbcPreparedStatement.quoteTimestamp(timestamp) + ", calendar);");
            }
            if (timestamp == null) {
                this.setParameter(n, ValueNull.INSTANCE);
            } else {
                this.setParameter(n, ValueTimestamp.get(calendar != null ? calendar.getTimeZone() : null, timestamp));
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int n, InputStream inputStream2, int n2) throws SQLException {
        throw this.unsupported("unicodeStream");
    }

    @Override
    public void setNull(int n, int n2, String string) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setNull(" + n + ", " + n2 + ", " + JdbcPreparedStatement.quote(string) + ");");
            }
            this.setNull(n, n2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setBlob(int n, Blob blob) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setBlob(" + n + ", x);");
            }
            this.checkClosedForWrite();
            Value value = blob == null ? ValueNull.INSTANCE : this.conn.createBlob(blob.getBinaryStream(), -1L);
            this.setParameter(n, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setBlob(int n, InputStream inputStream2) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setBlob(" + n + ", x);");
            }
            this.checkClosedForWrite();
            Value value = this.conn.createBlob(inputStream2, -1L);
            this.setParameter(n, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setClob(int n, Clob clob) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setClob(" + n + ", x);");
            }
            this.checkClosedForWrite();
            Value value = clob == null ? ValueNull.INSTANCE : this.conn.createClob(clob.getCharacterStream(), -1L);
            this.setParameter(n, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setClob(int n, Reader reader) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setClob(" + n + ", x);");
            }
            this.checkClosedForWrite();
            Value value = reader == null ? ValueNull.INSTANCE : this.conn.createClob(reader, -1L);
            this.setParameter(n, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setArray(int n, Array array) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setArray(" + n + ", x);");
            }
            this.checkClosed();
            Value value = array == null ? ValueNull.INSTANCE : DataType.convertToValue(this.session, array.getArray(), 17);
            this.setParameter(n, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setBytes(int n, byte[] byArray) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setBytes(" + n + ", " + JdbcPreparedStatement.quoteBytes(byArray) + ");");
            }
            this.setParameter(n, byArray == null ? ValueNull.INSTANCE : ValueBytes.get(byArray));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream2, long l) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setBinaryStream(" + n + ", x, " + l + "L);");
            }
            this.checkClosedForWrite();
            Value value = this.conn.createBlob(inputStream2, l);
            this.setParameter(n, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream2, int n2) throws SQLException {
        this.setBinaryStream(n, inputStream2, (long)n2);
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream2) throws SQLException {
        this.setBinaryStream(n, inputStream2, -1);
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream2, int n2) throws SQLException {
        this.setAsciiStream(n, inputStream2, (long)n2);
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream2, long l) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setAsciiStream(" + n + ", x, " + l + "L);");
            }
            this.checkClosedForWrite();
            Value value = this.conn.createClob(IOUtils.getAsciiReader(inputStream2), l);
            this.setParameter(n, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream2) throws SQLException {
        this.setAsciiStream(n, inputStream2, -1);
    }

    @Override
    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.setCharacterStream(n, reader, (long)n2);
    }

    @Override
    public void setCharacterStream(int n, Reader reader) throws SQLException {
        this.setCharacterStream(n, reader, -1);
    }

    @Override
    public void setCharacterStream(int n, Reader reader, long l) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setCharacterStream(" + n + ", x, " + l + "L);");
            }
            this.checkClosedForWrite();
            Value value = this.conn.createClob(reader, l);
            this.setParameter(n, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setURL(int n, URL uRL) throws SQLException {
        throw this.unsupported("url");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            this.debugCodeCall("getMetaData");
            this.checkClosed();
            ResultInterface resultInterface = this.command.getMetaData();
            if (resultInterface == null) {
                return null;
            }
            int n = JdbcPreparedStatement.getNextId(5);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("ResultSetMetaData", 5, n, "getMetaData()");
            }
            String string = this.conn.getCatalog();
            return new JdbcResultSetMetaData(null, this, resultInterface, string, this.session.getTrace(), n);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        try {
            this.debugCodeCall("clearBatch");
            this.checkClosed();
            this.batchParameters = null;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            super.close();
            this.batchParameters = null;
            this.batchIdentities = null;
            if (this.command != null) {
                this.command.close();
                this.command = null;
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        try {
            this.debugCodeCall("executeBatch");
            if (this.batchParameters == null) {
                this.batchParameters = Utils.newSmallArrayList();
            }
            this.batchIdentities = new MergedResult();
            int n = this.batchParameters.size();
            int[] nArray = new int[n];
            Object object = null;
            Object object2 = null;
            this.checkClosedForWrite();
            for (int i = 0; i < n; ++i) {
                Object object3;
                Value[] valueArray = this.batchParameters.get(i);
                ArrayList<? extends ParameterInterface> arrayList = this.command.getParameters();
                for (int j = 0; j < valueArray.length; ++j) {
                    object3 = valueArray[j];
                    ParameterInterface parameterInterface = arrayList.get(j);
                    parameterInterface.setValue((Value)object3, false);
                }
                try {
                    nArray[i] = this.executeUpdateInternal();
                    ResultSet resultSet = super.getGeneratedKeys();
                    this.batchIdentities.add(((JdbcResultSet)resultSet).result);
                    continue;
                }
                catch (Exception exception) {
                    object3 = this.logAndConvert(exception);
                    if (object2 == null) {
                        object = object2 = object3;
                    } else {
                        ((SQLException)object2).setNextException((SQLException)object3);
                    }
                    nArray[i] = -3;
                }
            }
            this.batchParameters = null;
            if (object != null) {
                throw new JdbcBatchUpdateException((SQLException)object, nArray);
            }
            return nArray;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        if (this.batchIdentities != null) {
            try {
                int n = JdbcPreparedStatement.getNextId(4);
                if (this.isDebugEnabled()) {
                    this.debugCodeAssign("ResultSet", 4, n, "getGeneratedKeys()");
                }
                this.checkClosed();
                this.generatedKeys = new JdbcResultSet(this.conn, this, null, this.batchIdentities.getResult(), n, false, true, false);
            }
            catch (Exception exception) {
                throw this.logAndConvert(exception);
            }
        }
        return super.getGeneratedKeys();
    }

    @Override
    public void addBatch() throws SQLException {
        try {
            this.debugCodeCall("addBatch");
            this.checkClosedForWrite();
            ArrayList<? extends ParameterInterface> arrayList = this.command.getParameters();
            int n = arrayList.size();
            Value[] valueArray = new Value[n];
            for (int i = 0; i < n; ++i) {
                Value value;
                ParameterInterface parameterInterface = arrayList.get(i);
                parameterInterface.checkSet();
                valueArray[i] = value = parameterInterface.getParamValue();
            }
            if (this.batchParameters == null) {
                this.batchParameters = Utils.newSmallArrayList();
            }
            this.batchParameters.add(valueArray);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int executeUpdate(String string, int n) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("executeUpdate(" + JdbcPreparedStatement.quote(string) + ", " + n + ");");
            }
            throw DbException.get(90130);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public long executeLargeUpdate(String string, int n) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("executeLargeUpdate(" + JdbcPreparedStatement.quote(string) + ", " + n + ");");
            }
            throw DbException.get(90130);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int executeUpdate(String string, int[] nArray) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("executeUpdate(" + JdbcPreparedStatement.quote(string) + ", " + JdbcPreparedStatement.quoteIntArray(nArray) + ");");
            }
            throw DbException.get(90130);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public long executeLargeUpdate(String string, int[] nArray) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("executeLargeUpdate(" + JdbcPreparedStatement.quote(string) + ", " + JdbcPreparedStatement.quoteIntArray(nArray) + ");");
            }
            throw DbException.get(90130);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("executeUpdate(" + JdbcPreparedStatement.quote(string) + ", " + JdbcPreparedStatement.quoteArray(stringArray) + ");");
            }
            throw DbException.get(90130);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public long executeLargeUpdate(String string, String[] stringArray) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("executeLargeUpdate(" + JdbcPreparedStatement.quote(string) + ", " + JdbcPreparedStatement.quoteArray(stringArray) + ");");
            }
            throw DbException.get(90130);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean execute(String string, int n) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("execute(" + JdbcPreparedStatement.quote(string) + ", " + n + ");");
            }
            throw DbException.get(90130);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean execute(String string, int[] nArray) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("execute(" + JdbcPreparedStatement.quote(string) + ", " + JdbcPreparedStatement.quoteIntArray(nArray) + ");");
            }
            throw DbException.get(90130);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean execute(String string, String[] stringArray) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("execute(" + JdbcPreparedStatement.quote(string) + ", " + JdbcPreparedStatement.quoteArray(stringArray) + ");");
            }
            throw DbException.get(90130);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        try {
            int n = JdbcPreparedStatement.getNextId(11);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("ParameterMetaData", 11, n, "getParameterMetaData()");
            }
            this.checkClosed();
            return new JdbcParameterMetaData(this.session.getTrace(), this, this.command, n);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    private void setParameter(int n, Value value) {
        this.checkClosed();
        ArrayList<? extends ParameterInterface> arrayList = this.command.getParameters();
        if (--n < 0 || n >= arrayList.size()) {
            throw DbException.getInvalidValueException("parameterIndex", n + 1);
        }
        ParameterInterface parameterInterface = arrayList.get(n);
        parameterInterface.setValue(value, this.batchParameters == null);
    }

    @Override
    public void setRowId(int n, RowId rowId) throws SQLException {
        throw this.unsupported("rowId");
    }

    @Override
    public void setNString(int n, String string) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setNString(" + n + ", " + JdbcPreparedStatement.quote(string) + ");");
            }
            this.setParameter(n, string == null ? ValueNull.INSTANCE : ValueString.get(string));
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setNCharacterStream(int n, Reader reader, long l) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setNCharacterStream(" + n + ", x, " + l + "L);");
            }
            this.checkClosedForWrite();
            Value value = this.conn.createClob(reader, l);
            this.setParameter(n, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setNCharacterStream(int n, Reader reader) throws SQLException {
        this.setNCharacterStream(n, reader, -1L);
    }

    @Override
    public void setNClob(int n, NClob nClob) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setNClob(" + n + ", x);");
            }
            this.checkClosedForWrite();
            Value value = nClob == null ? ValueNull.INSTANCE : this.conn.createClob(nClob.getCharacterStream(), -1L);
            this.setParameter(n, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setNClob(int n, Reader reader) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setNClob(" + n + ", x);");
            }
            this.checkClosedForWrite();
            Value value = this.conn.createClob(reader, -1L);
            this.setParameter(n, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setClob(int n, Reader reader, long l) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setClob(" + n + ", x, " + l + "L);");
            }
            this.checkClosedForWrite();
            Value value = this.conn.createClob(reader, l);
            this.setParameter(n, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setBlob(int n, InputStream inputStream2, long l) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setBlob(" + n + ", x, " + l + "L);");
            }
            this.checkClosedForWrite();
            Value value = this.conn.createBlob(inputStream2, l);
            this.setParameter(n, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setNClob(int n, Reader reader, long l) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setNClob(" + n + ", x, " + l + "L);");
            }
            this.checkClosedForWrite();
            Value value = this.conn.createClob(reader, l);
            this.setParameter(n, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setSQLXML(int n, SQLXML sQLXML) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setSQLXML(" + n + ", x);");
            }
            this.checkClosedForWrite();
            Value value = sQLXML == null ? ValueNull.INSTANCE : this.conn.createClob(sQLXML.getCharacterStream(), -1L);
            this.setParameter(n, value);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public String toString() {
        return this.getTraceObjectName() + ": " + this.command;
    }

    @Override
    protected boolean checkClosed(boolean bl) {
        if (super.checkClosed(bl)) {
            ArrayList<? extends ParameterInterface> arrayList = this.command.getParameters();
            this.command = this.conn.prepareCommand(this.sqlStatement, this.fetchSize);
            ArrayList<? extends ParameterInterface> arrayList2 = this.command.getParameters();
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                ParameterInterface parameterInterface = arrayList.get(i);
                Value value = parameterInterface.getParamValue();
                if (value == null) continue;
                ParameterInterface parameterInterface2 = arrayList2.get(i);
                parameterInterface2.setValue(value, false);
            }
            return true;
        }
        return false;
    }
}

