/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool.notification;

import javafx.application.Platform;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.notification.INotificationCenter;
import mediathek.tool.notification.thrift.NotificationMessage;
import org.controlsfx.control.Notifications;

public class GenericNotificationCenter
implements INotificationCenter {
    @Override
    public void displayNotification(NotificationMessage notificationMessage) {
        if (!ApplicationConfiguration.getConfiguration().getBoolean("application.notifications.show", true)) {
            return;
        }
        Platform.runLater(() -> {
            try {
                Notifications msg = Notifications.create();
                msg.text(notificationMessage.getMessage());
                msg.title(notificationMessage.getTitle());
                switch (notificationMessage.getType()) {
                    case INFO: {
                        msg.showInformation();
                        break;
                    }
                    case ERROR: {
                        msg.showError();
                    }
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        });
    }
}

